var babelHelpers = require('./babel-helpers.js');
/**
 * MUI React dropdowns module
 * @module react/dropdowns
 */
/* jshint quotmark:false */
// jscs:disable validateQuoteMarks

'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = babelHelpers.interopRequireDefault(_react);

var _button = require('./button');

var _button2 = babelHelpers.interopRequireDefault(_button);

var _caret = require('./caret');

var _caret2 = babelHelpers.interopRequireDefault(_caret);

var _jqLite = require('../js/lib/jqLite');

var jqLite = babelHelpers.interopRequireWildcard(_jqLite);

var _util = require('../js/lib/util');

var util = babelHelpers.interopRequireWildcard(_util);


var PropTypes = _react2.default.PropTypes,
    dropdownClass = 'mui-dropdown',
    menuClass = 'mui-dropdown__menu',
    openClass = 'mui--is-open',
    rightClass = 'mui-dropdown__menu--right';

/**
 * Dropdown constructor
 * @class
 */

var Dropdown = function (_React$Component) {
  babelHelpers.inherits(Dropdown, _React$Component);

  function Dropdown(props) {
    babelHelpers.classCallCheck(this, Dropdown);

    var _this = babelHelpers.possibleConstructorReturn(this, (Dropdown.__proto__ || Object.getPrototypeOf(Dropdown)).call(this, props));

    _this.state = {
      opened: false,
      menuTop: 0
    };

    var cb = util.callback;
    _this.selectCB = cb(_this, 'select');
    _this.onClickCB = cb(_this, 'onClick');
    _this.onOutsideClickCB = cb(_this, 'onOutsideClick');
    return _this;
  }

  babelHelpers.createClass(Dropdown, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      document.addEventListener('click', this.onOutsideClickCB);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      document.removeEventListener('click', this.onOutsideClickCB);
    }
  }, {
    key: 'onClick',
    value: function onClick(ev) {
      // only left clicks
      if (ev.button !== 0) return;

      // exit if toggle button is disabled
      if (this.props.disabled) return;

      if (!ev.defaultPrevented) {
        this.toggle();

        // execute <Dropdown> onClick method
        var onClickFn = this.props.onClick;
        onClickFn && onClickFn(ev);
      }
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      // exit if no menu element
      if (!this.props.children) {
        return util.raiseError('Dropdown menu element not found');
      }

      if (this.state.opened) this.close();else this.open();
    }
  }, {
    key: 'open',
    value: function open() {
      // position menu element below toggle button
      var wrapperRect = this.refs.wrapperEl.getBoundingClientRect(),
          toggleRect = void 0;

      toggleRect = this.refs.button.refs.buttonEl.getBoundingClientRect();

      this.setState({
        opened: true,
        menuTop: toggleRect.top - wrapperRect.top + toggleRect.height
      });
    }
  }, {
    key: 'close',
    value: function close() {
      this.setState({ opened: false });
    }
  }, {
    key: 'select',
    value: function select(ev) {
      // onSelect callback
      if (this.props.onSelect && ev.target.tagName === 'A') {
        this.props.onSelect(ev.target.getAttribute('data-mui-value'));
      }

      // close menu
      if (!ev.defaultPrevented) this.close();
    }
  }, {
    key: 'onOutsideClick',
    value: function onOutsideClick(ev) {
      var isClickInside = this.refs.wrapperEl.contains(ev.target);
      if (!isClickInside) this.close();
    }
  }, {
    key: 'render',
    value: function render() {
      var buttonEl = void 0,
          menuEl = void 0,
          labelEl = void 0;

      var _props = this.props;
      var children = _props.children;
      var className = _props.className;
      var color = _props.color;
      var variant = _props.variant;
      var size = _props.size;
      var label = _props.label;
      var alignMenu = _props.alignMenu;
      var onClick = _props.onClick;
      var onSelect = _props.onSelect;
      var disabled = _props.disabled;
      var reactProps = babelHelpers.objectWithoutProperties(_props, ['children', 'className', 'color', 'variant', 'size', 'label', 'alignMenu', 'onClick', 'onSelect', 'disabled']);

      // build label

      if (jqLite.type(label) === 'string') {
        labelEl = _react2.default.createElement(
          'span',
          null,
          label,
          ' ',
          _react2.default.createElement(_caret2.default, null)
        );
      } else {
        labelEl = label;
      }

      buttonEl = _react2.default.createElement(
        _button2.default,
        {
          ref: 'button',
          type: 'button',
          onClick: this.onClickCB,
          color: color,
          variant: variant,
          size: size,
          disabled: disabled
        },
        labelEl
      );

      if (this.state.opened) {
        var cs = {};

        cs[menuClass] = true;
        cs[openClass] = this.state.opened;
        cs[rightClass] = alignMenu === 'right';
        cs = util.classNames(cs);

        menuEl = _react2.default.createElement(
          'ul',
          {
            ref: 'menuEl',
            className: cs,
            style: { top: this.state.menuTop },
            onClick: this.selectCB
          },
          children
        );
      } else {
        menuEl = _react2.default.createElement('div', null);
      }

      return _react2.default.createElement(
        'div',
        babelHelpers.extends({}, reactProps, {
          ref: 'wrapperEl',
          className: dropdownClass + ' ' + className
        }),
        buttonEl,
        menuEl
      );
    }
  }]);
  return Dropdown;
}(_react2.default.Component);

/** Define module API */


Dropdown.propTypes = {
  color: PropTypes.oneOf(['default', 'primary', 'danger', 'dark', 'accent']),
  variant: PropTypes.oneOf(['default', 'flat', 'raised', 'fab']),
  size: PropTypes.oneOf(['default', 'small', 'large']),
  label: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  alignMenu: PropTypes.oneOf(['left', 'right']),
  onClick: PropTypes.func,
  onSelect: PropTypes.func,
  disabled: PropTypes.bool
};
Dropdown.defaultProps = {
  className: '',
  color: 'default',
  variant: 'default',
  size: 'default',
  label: '',
  alignMenu: 'left',
  onClick: null,
  onSelect: null,
  disabled: false
};
exports.default = Dropdown;
module.exports = exports['default'];