var babelHelpers = require('./babel-helpers.js');
/**
 * MUI React tabs module
 * @module react/tabs
 */
/* jshint quotmark:false */
// jscs:disable validateQuoteMarks

'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = babelHelpers.interopRequireDefault(_react);

var _tab = require('./tab');

var _tab2 = babelHelpers.interopRequireDefault(_tab);

var _util = require('../js/lib/util');

var util = babelHelpers.interopRequireWildcard(_util);


var PropTypes = _react2.default.PropTypes,
    tabsBarClass = 'mui-tabs__bar',
    tabsBarJustifiedClass = 'mui-tabs__bar--justified',
    tabsPaneClass = 'mui-tabs__pane',
    isActiveClass = 'mui--is-active';

/**
 * Tabs constructor
 * @class
 */

var Tabs = function (_React$Component) {
  babelHelpers.inherits(Tabs, _React$Component);

  function Tabs(props) {
    babelHelpers.classCallCheck(this, Tabs);

    var _this = babelHelpers.possibleConstructorReturn(this, (Tabs.__proto__ || Object.getPrototypeOf(Tabs)).call(this, props));

    _this.state = { currentSelectedIndex: props.initialSelectedIndex };
    return _this;
  }

  babelHelpers.createClass(Tabs, [{
    key: 'onClick',
    value: function onClick(i, tab, ev) {
      if (i !== this.state.currentSelectedIndex) {
        this.setState({ currentSelectedIndex: i });

        // onActive callback
        if (tab.props.onActive) tab.props.onActive(tab);

        // onChange callback
        if (this.props.onChange) {
          this.props.onChange(i, tab.props.value, tab, ev);
        }
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props;
      var children = _props.children;
      var initialSelectedIndex = _props.initialSelectedIndex;
      var justified = _props.justified;
      var reactProps = babelHelpers.objectWithoutProperties(_props, ['children', 'initialSelectedIndex', 'justified']);


      var tabEls = [],
          paneEls = [],
          m = children.length,
          selectedIndex = this.state.currentSelectedIndex % m,
          isActive = void 0,
          item = void 0,
          cls = void 0,
          i = void 0;

      for (i = 0; i < m; i++) {
        item = children[i];

        // only accept MUITab elements
        if (item.type !== _tab2.default) util.raiseError('Expecting MUITab React Element');

        isActive = i === selectedIndex ? true : false;

        // tab element
        tabEls.push(_react2.default.createElement(
          'li',
          { key: i, className: isActive ? isActiveClass : '' },
          _react2.default.createElement(
            'a',
            { onClick: this.onClick.bind(this, i, item) },
            item.props.label
          )
        ));

        // pane element
        cls = tabsPaneClass + ' ';
        if (isActive) cls += isActiveClass;

        paneEls.push(_react2.default.createElement(
          'div',
          { key: i, className: cls },
          item.props.children
        ));
      }

      cls = tabsBarClass;
      if (justified) cls += ' ' + tabsBarJustifiedClass;

      return _react2.default.createElement(
        'div',
        reactProps,
        _react2.default.createElement(
          'ul',
          { className: cls },
          tabEls
        ),
        paneEls
      );
    }
  }]);
  return Tabs;
}(_react2.default.Component);

/** Define module API */


Tabs.propTypes = {
  initialSelectedIndex: PropTypes.number,
  justified: PropTypes.bool,
  onChange: PropTypes.func
};
Tabs.defaultProps = {
  className: '',
  initialSelectedIndex: 0,
  justified: false,
  onChange: null
};
exports.default = Tabs;
module.exports = exports['default'];