/**
 * MUI React main module
 * @module react/main
 */

(function(win) {
  // return if library has been loaded already
  if (win._muiReactLoaded) return;
  else win._muiReactLoaded = true;
  
  var mui = win.mui = win.mui || [],
      react = mui.react = {},
      lib;

  react.Appbar = require('src/react/appbar');
  react.Button = require('src/react/button');
  react.Caret = require('src/react/caret');
  react.Checkbox = require('src/react/checkbox');
  react.Col = require('src/react/col');
  react.Container = require('src/react/container');
  react.Divider = require('src/react/divider');
  react.Dropdown = require('src/react/dropdown'),
  react.DropdownItem = require('src/react/dropdown-item'),
  react.Form = require('src/react/form');
  react.Input = require('src/react/input');
  react.Option = require('src/react/option');
  react.Panel = require('src/react/panel');
  react.Radio = require('src/react/radio');
  react.Row = require('src/react/row');
  react.Select = require('src/react/select');
  react.Tab = require('src/react/tab');
  react.Tabs = require('src/react/tabs');
  react.Textarea = require('src/react/textarea');
})(window);
