# v3.10.0


## Summary

The v3.10.0 release includes features and fixes from 66 pull requests since the v3.9.0 release. New features and improvements include:

* Full touch gesture support for the Microsoft Edge browser.
* Improved API docs - required constructor options are now marked as such.
* Text styles (vector labels) now work with defaults instead of failing when only a label text is set.
* Write support for GML3 features with multiple geometries

See the complete list below for details. And see the following notes to know how to upgrade from v3.9.0 to v3.10.0.


## Upgrade notes

#### `ol.layer.Layer` changes

The experimental `setHue`, `setContrast`, `setBrightness`, `setSaturation`, and the corresponding getter methods have been removed.  These properties only worked with the WebGL renderer.  If you are interested in applying color transforms, look for the `postcompose` event in the API docs.  In addition, the `ol.source.Raster` source provides a way to create new raster data based on arbitrary transforms run on any number of input sources.

#### Removal of legacy Internet Explorer support

If you are building an appliction that supports Internet Explorer 8 or older, you'll need to use ES5 shims to make OpenLayers work. As before, support for such old browsers is very basic, and we recommend to not support them.


## New features and fixes

 * [#4237](https://github.com/openlayers/openlayers/pull/4237) - #3328: GML3 - Writing features with multiple geometries ([@awaterme](https://github.com/awaterme))
 * [#4218](https://github.com/openlayers/openlayers/pull/4218) - Add 'getLayer()' method to 'ol.interaction.Select' ([@jonataswalker](https://github.com/jonataswalker))
 * [#4036](https://github.com/openlayers/openlayers/pull/4036) - Fix modify interaction event order ([@alvinlindstam](https://github.com/alvinlindstam))
 * [#4036](https://github.com/openlayers/openlayers/pull/4036) - Fix modify interaction event order ([@alvinlindstam](https://github.com/alvinlindstam))
 * [#4116](https://github.com/openlayers/openlayers/pull/4116) - Make ol.control.OverviewMap's view configurable ([@ahocevar](https://github.com/ahocevar))
 * [#4234](https://github.com/openlayers/openlayers/pull/4234) - Support OGC WKT proj4 def.units and def.to_meter ([@tbarsballe](https://github.com/tbarsballe))
 * [#4224](https://github.com/openlayers/openlayers/pull/4224) - Don't transform the angle into degrees to rotate the element ([@fredj](https://github.com/fredj))
 * [#4231](https://github.com/openlayers/openlayers/pull/4231) - Revert "Merge pull request #4217 from ThomasG77/clipboardjs-replacement" ([@ahocevar](https://github.com/ahocevar))
 * [#4217](https://github.com/openlayers/openlayers/pull/4217) - Replace ZeroClipboard with Clipboard.js to remove flash dependency ([@ThomasG77](https://github.com/ThomasG77))
 * [#4223](https://github.com/openlayers/openlayers/pull/4223) - Remove goog.fx.easing ([@fredj](https://github.com/fredj))
 * [#4222](https://github.com/openlayers/openlayers/pull/4222) - Remove unnecessary cast ([@fredj](https://github.com/fredj))
 * [#4209](https://github.com/openlayers/openlayers/pull/4209) - Remove goog.string.remove ([@gberaudo](https://github.com/gberaudo))
 * [#4207](https://github.com/openlayers/openlayers/pull/4207) - Remove goog.string.startsWith ([@gberaudo](https://github.com/gberaudo))
 * [#4208](https://github.com/openlayers/openlayers/pull/4208) - Remove goog.string.trim() ([@gberaudo](https://github.com/gberaudo))
 * [#4216](https://github.com/openlayers/openlayers/pull/4216) - Fix canvas replay which broke with 31a68e2 ([@ahocevar](https://github.com/ahocevar))
 * [#4202](https://github.com/openlayers/openlayers/pull/4202) - Remove use of goog.dom.appendChild ([@fredj](https://github.com/fredj))
 * [#4205](https://github.com/openlayers/openlayers/pull/4205) - Minor cleanup ([@fredj](https://github.com/fredj))
 * [#4203](https://github.com/openlayers/openlayers/pull/4203) - Cosmetic changes to example html / css ([@marcjansen](https://github.com/marcjansen))
 * [#4184](https://github.com/openlayers/openlayers/pull/4184) - Adjust iframe's position of GetFeatureInfo examples ([@jonataswalker](https://github.com/jonataswalker))
 * [#4192](https://github.com/openlayers/openlayers/pull/4192) - Remove use of goog.isNull in favor of simple truthy checks ([@marcjansen](https://github.com/marcjansen))
 * [#4187](https://github.com/openlayers/openlayers/pull/4187) - Fix {-y} template calculation for custom (TMS) tile grids ([@ahocevar](https://github.com/ahocevar))
 * [#4176](https://github.com/openlayers/openlayers/pull/4176) - Remove use of goog.isDefAndNotNull().
 ([@tschaub](https://github.com/tschaub))
 * [#4200](https://github.com/openlayers/openlayers/pull/4200) - Do not use goog.object.get ([@marcjansen](https://github.com/marcjansen))
 * [#4198](https://github.com/openlayers/openlayers/pull/4198) - Improve ol.control.Rotate.prototype.resetNorth_ performance ([@denilsonsa](https://github.com/denilsonsa))
 * [#4197](https://github.com/openlayers/openlayers/pull/4197) - Remove blur action on MOUSEOUT on Zoom Out button ([@denilsonsa](https://github.com/denilsonsa))
 * [#4195](https://github.com/openlayers/openlayers/pull/4195) - #4171: Prefer current layout as default on MultiLineString.setLineStrings() ([@awaterme](https://github.com/awaterme))
 * [#4172](https://github.com/openlayers/openlayers/pull/4172) - #4171: Prefer current layout as default on Multipolygon.setPolygons() ([@awaterme](https://github.com/awaterme))
 * [#4190](https://github.com/openlayers/openlayers/pull/4190) - Remove use of goog.functions.constant ([@marcjansen](https://github.com/marcjansen))
 * [#4188](https://github.com/openlayers/openlayers/pull/4188) - Remove use of goog.object.getKeys ([@fredj](https://github.com/fredj))
 * [#4189](https://github.com/openlayers/openlayers/pull/4189) - Replace goog.nullFunction with ol.nullFunction ([@marcjansen](https://github.com/marcjansen))
 * [#4165](https://github.com/openlayers/openlayers/pull/4165) - Use ECMAScript 5.1 Array functions instead of goog.array ([@fredj](https://github.com/fredj))
 * [#4181](https://github.com/openlayers/openlayers/pull/4181) - Remove use of goog.array.contains ([@fredj](https://github.com/fredj))
 * [#4162](https://github.com/openlayers/openlayers/pull/4162) - Remove ol.LEGACY_IE_SUPPORT ([@fredj](https://github.com/fredj))
 * [#4174](https://github.com/openlayers/openlayers/pull/4174) - Remove hue, saturation, contrast, and brightness as layer properties. ([@tschaub](https://github.com/tschaub))
 * [#4183](https://github.com/openlayers/openlayers/pull/4183) - Remove @api on getHitDetectionFramebuffer ([@elemoine](https://github.com/elemoine))
 * [#4179](https://github.com/openlayers/openlayers/pull/4179) - Use Date.now() instead of goog.now() ([@marcjansen](https://github.com/marcjansen))
 * [#4175](https://github.com/openlayers/openlayers/pull/4175) - Remove use of goog.math.clamp(). ([@tschaub](https://github.com/tschaub))
 * [#4173](https://github.com/openlayers/openlayers/pull/4173) - Only animate when resolution is about to be changed ([@ahocevar](https://github.com/ahocevar))
 * [#4129](https://github.com/openlayers/openlayers/pull/4129) - Remove use of goog.isDef. ([@openlayers](https://github.com/openlayers))
 * [#4168](https://github.com/openlayers/openlayers/pull/4168) - Tile preload example wording (fixes #4147) ([@wlerner](https://github.com/wlerner))
 * [#4167](https://github.com/openlayers/openlayers/pull/4167) - Remove externs in externs/closure-compiler.js ([@fredj](https://github.com/fredj))
 * [#4166](https://github.com/openlayers/openlayers/pull/4166) - Use version 20150920 of Closure Compiler ([@elemoine](https://github.com/elemoine))
 * [#4159](https://github.com/openlayers/openlayers/pull/4159) - Remove use of goog.object.containsKey ([@fredj](https://github.com/fredj))
 * [#4157](https://github.com/openlayers/openlayers/pull/4157) - Fix typo in doc ([@elemoine](https://github.com/elemoine))
 * [#4138](https://github.com/openlayers/openlayers/pull/4138) - Enhanced documentation for ol.style.Text ([@ekargee](https://github.com/ekargee))
 * [#4151](https://github.com/openlayers/openlayers/pull/4151) - Remove bogus assertion ([@elemoine](https://github.com/elemoine))
 * [#4110](https://github.com/openlayers/openlayers/pull/4110) - Minor cleanups ([@fredj](https://github.com/fredj))
 * [#4156](https://github.com/openlayers/openlayers/pull/4156) - Rename drag-features example to custom-interactions ([@elemoine](https://github.com/elemoine))
 * [#4150](https://github.com/openlayers/openlayers/pull/4150) - Remove use of goog.object.remove ([@fredj](https://github.com/fredj))
 * [#4145](https://github.com/openlayers/openlayers/pull/4145) - API method for simplifying geometries. ([@tschaub](https://github.com/tschaub))
 * [#4153](https://github.com/openlayers/openlayers/pull/4153) - Add a "features" option to ol.interaction.Select ([@elemoine](https://github.com/elemoine))
 * [#4144](https://github.com/openlayers/openlayers/pull/4144) - Set context.fillStyle to a string ([@elemoine](https://github.com/elemoine))
 * [#4149](https://github.com/openlayers/openlayers/pull/4149) - Remove use of goog.array.isEmpty ([@fredj](https://github.com/fredj))
 * [#4139](https://github.com/openlayers/openlayers/pull/4139) - Add turf.js and JSTS example ([@tsauerwein](https://github.com/tsauerwein))
 * [#4136](https://github.com/openlayers/openlayers/pull/4136) - Fix the 'click-to-fork' link in contributer notes ([@marcjansen](https://github.com/marcjansen))
 * [#4132](https://github.com/openlayers/openlayers/pull/4132) - Update quickstart tutorial ([@tsauerwein](https://github.com/tsauerwein))
 * [#4111](https://github.com/openlayers/openlayers/pull/4111) - Use a blackish default for filling texts ([@marcjansen](https://github.com/marcjansen))
 * [#4120](https://github.com/openlayers/openlayers/pull/4120) - Remove invalid link to featureOverlay in API doc ([@kalbermattenm](https://github.com/kalbermattenm))
 * [#4117](https://github.com/openlayers/openlayers/pull/4117) - forEachFeatureAtPixel shouldn't fail if layer has no source ([@pgiraud](https://github.com/pgiraud))
 * [#4106](https://github.com/openlayers/openlayers/pull/4106) - Focus to search field on page load ([@elemoine](https://github.com/elemoine))
 * [#4079](https://github.com/openlayers/openlayers/pull/4079) - Automatically mark required options in API-docs ([@marcjansen](https://github.com/marcjansen))
 * [#4108](https://github.com/openlayers/openlayers/pull/4108) - Add missing CSSProperties.prototype.touchAction extern ([@fredj](https://github.com/fredj))
 * [#4107](https://github.com/openlayers/openlayers/pull/4107) - Prevent page zoom on IE Edge ([@fredj](https://github.com/fredj))
 * [#3969](https://github.com/openlayers/openlayers/pull/3969) - Add an option to use the mouse's location as an anchor when zooming ([@samuellapointe](https://github.com/samuellapointe))
 * [#4101](https://github.com/openlayers/openlayers/pull/4101) - Release v3.9.0 ([@elemoine](https://github.com/elemoine))
