# v3.18.0

## Summary

The v3.18.0 release includes features and fixes from almost 120 pull requests since the v3.17.1 release. Most of the changes are bug fixes and continuing removal of the dependency on Closure Library. New features include:

 * Addition of `Intersects` and `Within` filters to `ol.format.ogc.filter` [#5668](https://github.com/openlayers/openlayers/pull/5668)
 * New `overlaps` option for `ol.source.Vector` and `ol.source.VectorTile` to improve rendering performance for polygon topologies [#5196](https://github.com/openlayers/openlayers/pull/5196)
 * New `rotateWithView` option for `ol.style.Text` to control appearance of text on rotated views [#5050](https://github.com/openlayers/openlayers/pull/5050)
 * Add a `#scale()` method to `ol.geom.Geometry` and subclasses [#5685](https://github.com/openlayers/openlayers/pull/5685)
 * Parse `id` of features in `ol.format.MVT` [#5613](https://github.com/openlayers/openlayers/pull/5613)

## Upgrade notes

#### Changes in the way assertions are handled

Previously, minified builds of the library did not have any assertions. This caused applications to fail silently or with cryptic stack traces. Starting with this release, developers get notified of many runtime errors through the new `ol.AssertionError`. This error has a `code` property. The meaning of the code can be found on https://openlayers.org/en/latest/doc/errors/. There are additional console assertion checks in debug mode when the `goog.DEBUG` compiler flag is `true`. As this is `true` by default, it is recommended that those creating custom builds set this to `false` so these assertions are stripped.'

#### Removal of `ol.ENABLE_NAMED_COLORS`

This option was previously needed to use named colors with the WebGL renderer but is no longer needed.

#### KML format now uses URL()

The URL constructor is supported by all modern browsers, but not by older ones, such as IE. To use the KML format in such older browsers, a URL polyfill will have to be loaded before use.

#### Changes only relevant to those who compile their applications together with the Closure Compiler

A number of internal types have been renamed.  This will not affect those who use the API provided by the library, but if you are compiling your application together with OpenLayers and using type names, you'll need to do the following:

 * rename `ol.CollectionEventType` to `ol.Collection.EventType`
 * rename `ol.CollectionEvent` to `ol.Collection.Event`
 * rename `ol.ViewHint` to `ol.View.Hint`
 * rename `ol.ViewProperty` to `ol.View.Property`
 * rename `ol.render.webgl.imagereplay.shader.Default.Locations` to `ol.render.webgl.imagereplay.defaultshader.Locations`
 * rename `ol.render.webgl.imagereplay.shader.DefaultFragment` to `ol.render.webgl.imagereplay.defaultshader.Fragment`
 * rename `ol.render.webgl.imagereplay.shader.DefaultVertex` to `ol.render.webgl.imagereplay.defaultshader.Vertex`
 * rename `ol.renderer.webgl.map.shader.Default.Locations` to `ol.renderer.webgl.defaultmapshader.Locations`
 * rename `ol.renderer.webgl.map.shader.Default.Locations` to `ol.renderer.webgl.defaultmapshader.Locations`
 * rename `ol.renderer.webgl.map.shader.DefaultFragment` to `ol.renderer.webgl.defaultmapshader.Fragment`
 * rename `ol.renderer.webgl.map.shader.DefaultVertex` to `ol.renderer.webgl.defaultmapshader.Vertex`
 * rename `ol.renderer.webgl.tilelayer.shader.Fragment` to `ol.renderer.webgl.tilelayershader.Fragment`
 * rename `ol.renderer.webgl.tilelayer.shader.Locations` to `ol.renderer.webgl.tilelayershader.Locations`
 * rename `ol.renderer.webgl.tilelayer.shader.Vertex` to `ol.renderer.webgl.tilelayershader.Vertex`
 * rename `ol.webgl.WebGLContextEventType` to `ol.webgl.ContextEventType`
 * rename `ol.webgl.shader.Fragment` to `ol.webgl.Fragment`
 * rename `ol.webgl.shader.Vertex` to `ol.webgl.Vertex`

## Full list of changes

 * [#5782](https://github.com/openlayers/openlayers/pull/5782) - Compare URLs in an IE compatible way ([@ahocevar](https://github.com/ahocevar))
 * [#5778](https://github.com/openlayers/openlayers/pull/5778) - Use Mapzen instead of openstreetmap.us tiles ([@ahocevar](https://github.com/ahocevar))
 * [#5774](https://github.com/openlayers/openlayers/pull/5774) - Update glob to version 7.0.6 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5708](https://github.com/openlayers/openlayers/pull/5708) - Remove unnecessary closePath() instructions ([@ahocevar](https://github.com/ahocevar))
 * [#5196](https://github.com/openlayers/openlayers/pull/5196) - Batch polygon and circle fills and strokes ([@ahocevar](https://github.com/ahocevar))
 * [#5768](https://github.com/openlayers/openlayers/pull/5768) - Enable extent clipping for vector layers ([@ahocevar](https://github.com/ahocevar))
 * [#4753](https://github.com/openlayers/openlayers/pull/4753) - Export ol.geom.Geometry#containsCoordinate function ([@fredj](https://github.com/fredj))
 * [#5050](https://github.com/openlayers/openlayers/pull/5050) - Add rotateWithView option to ol.style.Text ([@fredj](https://github.com/fredj))
 * [#5767](https://github.com/openlayers/openlayers/pull/5767) - Accept feature without geometry in ol.interaction.Modify ([@fredj](https://github.com/fredj))
 * [#5334](https://github.com/openlayers/openlayers/pull/5334) - Load the examples resources with HTTPS ([@fredj](https://github.com/fredj))
 * [#5766](https://github.com/openlayers/openlayers/pull/5766) - Use HTTPS to access tiles at tileserver.maptiler.com in examples ([@klokantech](https://github.com/klokantech))
 * [#5765](https://github.com/openlayers/openlayers/pull/5765) - Force a map render when the view is not updated ([@fredj](https://github.com/fredj))
 * [#5724](https://github.com/openlayers/openlayers/pull/5724) - Fix clipping of the tile layer extent on HiDPI devices ([@ahocevar](https://github.com/ahocevar))
 * [#5764](https://github.com/openlayers/openlayers/pull/5764) - Remove unnecessary map.render() calls ([@bartvde](https://github.com/bartvde))
 * [#5763](https://github.com/openlayers/openlayers/pull/5763) - Fix assert namespace ([@ahocevar](https://github.com/ahocevar))
 * [#5616](https://github.com/openlayers/openlayers/pull/5616) - Fix event type and documentation of ol.events.condition.mouseOnly ([@ahocevar](https://github.com/ahocevar))
 * [#5755](https://github.com/openlayers/openlayers/pull/5755) - Increase the size of the map in ol.layer.Tile rendering tests ([@fredj](https://github.com/fredj))
 * [#5757](https://github.com/openlayers/openlayers/pull/5757) - Add ol.source.Cluster#setDistance function ([@fredj](https://github.com/fredj))
 * [#5752](https://github.com/openlayers/openlayers/pull/5752) - Set proper replay canvas size and offset for rotated view ([@ahocevar](https://github.com/ahocevar))
 * [#5754](https://github.com/openlayers/openlayers/pull/5754) - Update istanbul to version 0.4.5 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5727](https://github.com/openlayers/openlayers/pull/5727) - Add missing goog require ([@fredj](https://github.com/fredj))
 * [#5273](https://github.com/openlayers/openlayers/pull/5273) - Take the pixelRatio into account when computing the gutter ([@fredj](https://github.com/fredj))
 * [#5753](https://github.com/openlayers/openlayers/pull/5753) - Update proj4 to version 2.3.15 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5741](https://github.com/openlayers/openlayers/pull/5741) - Point to the English workshop ([@bartvde](https://github.com/bartvde))
 * [#5721](https://github.com/openlayers/openlayers/pull/5721) - Update metalsmith to version 2.2.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5733](https://github.com/openlayers/openlayers/pull/5733) - Fix #5730 - Ignore null/undef. values in uri.appendParams ([@adube](https://github.com/adube))
 * [#5736](https://github.com/openlayers/openlayers/pull/5736) - Show `resultType` attribute in docs ([@tsauerwein](https://github.com/tsauerwein))
 * [#5735](https://github.com/openlayers/openlayers/pull/5735) - Update eslint to version 3.3.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5731](https://github.com/openlayers/openlayers/pull/5731) - Added a pixelRatio adjust to the canvasTileLayer 'forEachLayerAtPixel… ([@Benjaki2](https://github.com/Benjaki2))
 * [#5732](https://github.com/openlayers/openlayers/pull/5732) - Add missing curly braces in type annotations ([@fredj](https://github.com/fredj))
 * [#5728](https://github.com/openlayers/openlayers/pull/5728) - Update closure-util to version 1.15.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5717](https://github.com/openlayers/openlayers/pull/5717) - Update phantomjs-prebuilt to version 2.1.12 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5725](https://github.com/openlayers/openlayers/pull/5725) - Remove tilerange assert from tilegrid/wmts ([@probins](https://github.com/probins))
 * [#5723](https://github.com/openlayers/openlayers/pull/5723) - Update eslint to version 3.3.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5702](https://github.com/openlayers/openlayers/pull/5702) - Add rule to identify missing requires ([@tschaub](https://github.com/tschaub))
 * [#5670](https://github.com/openlayers/openlayers/pull/5670) - Added image data value to 'forEachLayerAtPixel' method callback ([@Benjaki2](https://github.com/Benjaki2))
 * [#5720](https://github.com/openlayers/openlayers/pull/5720) - Fix typo in tilegrid/wmts ([@probins](https://github.com/probins))
 * [#5715](https://github.com/openlayers/openlayers/pull/5715) - Create a check-example task for smarter example checking with PhantomJS ([@ahocevar](https://github.com/ahocevar))
 * [#5714](https://github.com/openlayers/openlayers/pull/5714) - Add FAQ entry about renderBuffer ([@tsauerwein](https://github.com/tsauerwein))
 * [#5713](https://github.com/openlayers/openlayers/pull/5713) - Check examples with http protocol instead of file ([@ahocevar](https://github.com/ahocevar))
 * [#5689](https://github.com/openlayers/openlayers/pull/5689) - Fix cursor change in translate interaction ([@pgiraud](https://github.com/pgiraud))
 * [#5165](https://github.com/openlayers/openlayers/pull/5165) - Remove goog.addSingletonGetter function ([@fredj](https://github.com/fredj))
 * [#5701](https://github.com/openlayers/openlayers/pull/5701) - Update phantomjs-prebuilt to version 2.1.11 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5698](https://github.com/openlayers/openlayers/pull/5698) - Custom rule to identify unused goog.require() calls ([@tschaub](https://github.com/tschaub))
 * [#5699](https://github.com/openlayers/openlayers/pull/5699) - Update mocha to version 3.0.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5697](https://github.com/openlayers/openlayers/pull/5697) - Re-enable ESLint config ([@tschaub](https://github.com/tschaub))
 * [#5693](https://github.com/openlayers/openlayers/pull/5693) - Reorganize files so they are named like their default export ([@tschaub](https://github.com/tschaub))
 * [#5694](https://github.com/openlayers/openlayers/pull/5694) - layer.Base in Map not required ([@probins](https://github.com/probins))
 * [#5695](https://github.com/openlayers/openlayers/pull/5695) - Remove unneeded requires in renderers ([@probins](https://github.com/probins))
 * [#5692](https://github.com/openlayers/openlayers/pull/5692) - Small text fix ([@bngsudheer](https://github.com/bngsudheer))
 * [#5682](https://github.com/openlayers/openlayers/pull/5682) - Update mocha to version 3.0.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5619](https://github.com/openlayers/openlayers/pull/5619) - Remove goog.asserts.* ([@ahocevar](https://github.com/ahocevar))
 * [#5685](https://github.com/openlayers/openlayers/pull/5685) - Add a method to scale geometries ([@tschaub](https://github.com/tschaub))
 * [#5674](https://github.com/openlayers/openlayers/pull/5674) - Support fractional zoom levels in ol.View#getZoom and #setZoom ([@ahocevar](https://github.com/ahocevar))
 * [#5681](https://github.com/openlayers/openlayers/pull/5681) - Remove extra goog.require ([@fredj](https://github.com/fredj))
 * [#5680](https://github.com/openlayers/openlayers/pull/5680) - Update phantomjs-prebuilt to version 2.1.10 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5668](https://github.com/openlayers/openlayers/pull/5668) - Added Intersects and Within filters into ol.format.wfs ([@cpsTinK](https://github.com/cpsTinK))
 * [#5675](https://github.com/openlayers/openlayers/pull/5675) - Remove unused goog.provide ([@fredj](https://github.com/fredj))
 * [#5673](https://github.com/openlayers/openlayers/pull/5673) - Add missing semicolon ([@ahocevar](https://github.com/ahocevar))
 * [#5587](https://github.com/openlayers/openlayers/pull/5587) - Lazily create KML style defaults ([@ahocevar](https://github.com/ahocevar))
 * [#5599](https://github.com/openlayers/openlayers/pull/5599) - Allow subpixel center on view ([@ahocevar](https://github.com/ahocevar))
 * [#5630](https://github.com/openlayers/openlayers/pull/5630) - chore(build): guard against unterminated scripts ([@tlvince](https://github.com/tlvince))
 * [#5669](https://github.com/openlayers/openlayers/pull/5669) - Fix Github links to specific lines on jsdoc pages ([@dtreiter](https://github.com/dtreiter))
 * [#5667](https://github.com/openlayers/openlayers/pull/5667) - Do not return undefined from ol.proj.get ([@ahocevar](https://github.com/ahocevar))
 * [#5665](https://github.com/openlayers/openlayers/pull/5665) - Update eslint to version 3.2.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5632](https://github.com/openlayers/openlayers/pull/5632) - Improve docs for the ol.LoadingStrategy type ([@ahocevar](https://github.com/ahocevar))
 * [#5641](https://github.com/openlayers/openlayers/pull/5641) - De-randomize the listener map property ([@ahocevar](https://github.com/ahocevar))
 * [#5664](https://github.com/openlayers/openlayers/pull/5664) - Update eslint to version 3.2.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5658](https://github.com/openlayers/openlayers/pull/5658) - Update marked to version 0.3.6 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5657](https://github.com/openlayers/openlayers/pull/5657) - Update phantomjs-prebuilt to version 2.1.9 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5652](https://github.com/openlayers/openlayers/pull/5652) - Make XHR work for file:// urls ([@ahocevar](https://github.com/ahocevar))
 * [#5653](https://github.com/openlayers/openlayers/pull/5653) - Fix namespace in filter docs ([@ahocevar](https://github.com/ahocevar))
 * [#5651](https://github.com/openlayers/openlayers/pull/5651) - Update coveralls to version 2.11.12 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5649](https://github.com/openlayers/openlayers/pull/5649) - Fix DateTime parsing with non-Zulu times ([@ahocevar](https://github.com/ahocevar))
 * [#5648](https://github.com/openlayers/openlayers/pull/5648) - Update sinon to version 1.17.5 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5646](https://github.com/openlayers/openlayers/pull/5646) - Update phantomjs-prebuilt to version 2.1.8 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5644](https://github.com/openlayers/openlayers/pull/5644) - Update browserify to version 13.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5640](https://github.com/openlayers/openlayers/pull/5640) - Add example for usage of HERE Map Tile API ([@chrismayer](https://github.com/chrismayer))
 * [#5579](https://github.com/openlayers/openlayers/pull/5579) - Update jquery to version 3.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5636](https://github.com/openlayers/openlayers/pull/5636) - Update clean-css to version 3.4.19 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5634](https://github.com/openlayers/openlayers/pull/5634) - Update async to version 2.0.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5622](https://github.com/openlayers/openlayers/pull/5622) - Update TileWMS.coordKeyPrefix_ on setUrls ([@rrutkows](https://github.com/rrutkows))
 * [#5611](https://github.com/openlayers/openlayers/pull/5611) - Fix broken link to Google JavaScript Style Guide ([@ischas](https://github.com/ischas))
 * [#5620](https://github.com/openlayers/openlayers/pull/5620) - Replace goog.getUid with ol.getUid ([@probins](https://github.com/probins))
 * [#5614](https://github.com/openlayers/openlayers/pull/5614) - Replace goog.abstractMethod ([@probins](https://github.com/probins))
 * [#5613](https://github.com/openlayers/openlayers/pull/5613) - Parse MVT id property ([@drnextgis](https://github.com/drnextgis))
 * [#5612](https://github.com/openlayers/openlayers/pull/5612) - Update vector-tile to version 1.3.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5609](https://github.com/openlayers/openlayers/pull/5609) - Update eslint to version 3.1.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5605](https://github.com/openlayers/openlayers/pull/5605) - Remove goog.isObject not in assertions ([@probins](https://github.com/probins))
 * [#5603](https://github.com/openlayers/openlayers/pull/5603) - Update eslint to version 3.1.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5597](https://github.com/openlayers/openlayers/pull/5597) - Avoid unnecessary getImageData calls in hit detection ([@schmidtk](https://github.com/schmidtk))
 * [#5429](https://github.com/openlayers/openlayers/pull/5429) - Remove enums from tests ([@probins](https://github.com/probins))
 * [#5516](https://github.com/openlayers/openlayers/pull/5516) - Remove goog.Uri from KML format ([@probins](https://github.com/probins))
 * [#5598](https://github.com/openlayers/openlayers/pull/5598) - Clarify that default source.Vector loader only handles features ([@probins](https://github.com/probins))
 * [#5595](https://github.com/openlayers/openlayers/pull/5595) - Use tile keys instead of coord keys ([@ahocevar](https://github.com/ahocevar))
 * [#5594](https://github.com/openlayers/openlayers/pull/5594) - Add renderBuffer option for ol.source.ImageVector ([@ahocevar](https://github.com/ahocevar))
 * [#5592](https://github.com/openlayers/openlayers/pull/5592) - Update coveralls to version 2.11.11 🚀 ([@openlayers](https://github.com/openlayers))
 * [#5593](https://github.com/openlayers/openlayers/pull/5593) - Update async to version 2.0.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4194](https://github.com/openlayers/openlayers/pull/4194) - Remove usage of goog.color and closure named colors ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#5583](https://github.com/openlayers/openlayers/pull/5583) - Fix dead link for change event in API docs ([@ahocevar](https://github.com/ahocevar))
 * [#5560](https://github.com/openlayers/openlayers/pull/5560) - Get rid of goog.isArrayLike ([@fredj](https://github.com/fredj))
 * [#5573](https://github.com/openlayers/openlayers/pull/5573) - Determine ol.global in a way that works in more environments ([@ahocevar](https://github.com/ahocevar))
 * [#5558](https://github.com/openlayers/openlayers/pull/5558) - Remove goog.Uri from tests ([@probins](https://github.com/probins))
 * [#5578](https://github.com/openlayers/openlayers/pull/5578) - Add polyfills to copy/paste code ([@ahocevar](https://github.com/ahocevar))
 * [#5577](https://github.com/openlayers/openlayers/pull/5577) - Fix olx.source.OSMOptions#url default value documentation ([@fredj](https://github.com/fredj))
 * [#5576](https://github.com/openlayers/openlayers/pull/5576) -  Use the word "documentation" ([@ahocevar](https://github.com/ahocevar))
 * [#5575](https://github.com/openlayers/openlayers/pull/5575) - Add a bit more info about the library to the README ([@ahocevar](https://github.com/ahocevar))
 * [#5574](https://github.com/openlayers/openlayers/pull/5574) - Add paragraph about supported browsers and polyfills ([@ahocevar](https://github.com/ahocevar))
 * [#5570](https://github.com/openlayers/openlayers/pull/5570) - Upgrade JSTS in example to 1.2.0 ([@bjornharrtell](https://github.com/bjornharrtell))
 * [#5566](https://github.com/openlayers/openlayers/pull/5566) - Fix ol.style.Image#getAnchor documentation ([@fredj](https://github.com/fredj))
 * [#5546](https://github.com/openlayers/openlayers/pull/5546) - Remove useless target argument from ol.Event and subclass constructors ([@ahocevar](https://github.com/ahocevar))
 * [#5565](https://github.com/openlayers/openlayers/pull/5565) - Reinsert goog.provide for enums in olx.js ([@probins](https://github.com/probins))
 * [#5561](https://github.com/openlayers/openlayers/pull/5561) - Add unit tests for ol.View.createCenterConstraint ([@fredj](https://github.com/fredj))
 * [#5563](https://github.com/openlayers/openlayers/pull/5563) - Return if a vertex was removed in ol.interaction.Modify#removeVertex_ ([@fredj](https://github.com/fredj))
 * [#5533](https://github.com/openlayers/openlayers/pull/5533) - Make sure reprojected tiles are recreated on updateParams ([@ahocevar](https://github.com/ahocevar))
 * [#5534](https://github.com/openlayers/openlayers/pull/5534) - Fix ScaleLine control documentation ([@ahocevar](https://github.com/ahocevar))
 * [#5541](https://github.com/openlayers/openlayers/pull/5541) - Replace goog.isNumber ([@probins](https://github.com/probins))
 * [#5552](https://github.com/openlayers/openlayers/pull/5552) - Replace goog.webgl. ([@probins](https://github.com/probins))
 * [#5550](https://github.com/openlayers/openlayers/pull/5550) - Remove use of ol.vec.Mat4 calls remaining after #5482 ([@ahocevar](https://github.com/ahocevar))
 * [#5507](https://github.com/openlayers/openlayers/pull/5507) - Remove use of goog.vec.* ([@ahocevar](https://github.com/ahocevar))
