# 4.5.0

### Summary

The 4.5 release includes enhancements and fixes from 50 or so pull requests.  Headlining this release, vector layers got a new `declutter` option that can be used to avoid overlapping labels.  See the [street labels example](http://openlayers.org/en/latest/examples/street-labels.html) for a demonstration of this feature.

Please note that if you are using `closure-util` to build your OpenLayers based application, it is time to migrate to using the [`ol` package](https://www.npmjs.com/package/ol) and a module bundler like webpack.  OpenLayers has not had a dependency on the Closure Library since the [3.19 release](https://github.com/openlayers/openlayers/releases/tag/v3.19.0); and with the 5.0 release we will be moving completely away from `goog.require` and `goog.provide`, dropping support for `closure-util`, and going with ES modules for our sources.

We will be adding details to the wiki about upcoming changes in 5.0 and tips on how to upgrade.  We'll likely have a few more 4.x releases before the 5.0 release.  But if you're interested in continuing to get feature enhancements in future releases, migrating to the `ol` package now will make the transition easier.

### Upgrade notes

#### Removed GeoJSON crs workaround for GeoServer

Previous version of GeoServer returned invalid crs in GeoJSON output.  The workaround in `ol.format.GeoJSON` used to read this crs code is now removed.

#### Deprecation of `ol.Attribution`

`ol.Attribution` is deprecated and will be removed in the next major version.  Instead, you can construct a source with a string attribution or an array of strings.  For dynamic attributions, you can provide a function that gets called with the current frame state.

Before:
```js
var source = new ol.source.XYZ({
  attributions: [
    new ol.Attribution({html: 'some attribution'})
  ]
});
```

After:
```js
var source = new ol.source.XYZ({
  attributions: 'some attribution'
});
```

In addition to passing a string or an array of strings for the `attributions` option, you can also pass a function that will get called with the current frame state.
```js
var source = new ol.source.XYZ({
  attributions: function(frameState) {
    // inspect the frame state and return attributions
    return 'some attribution'; // or ['multiple', 'attributions'] or null
  }
});
```

## Detailed changes

See below for the full list of changes.

 * [#7456](https://github.com/openlayers/openlayers/pull/7456) - Retry if sauce connect fails ([@tschaub](https://github.com/tschaub))
 * [#7440](https://github.com/openlayers/openlayers/pull/7440) - Attempt to make font loading tests more stable ([@ahocevar](https://github.com/ahocevar))
 * [#7444](https://github.com/openlayers/openlayers/pull/7444) - Simpler style management ([@ahocevar](https://github.com/ahocevar))
 * [#7438](https://github.com/openlayers/openlayers/pull/7438) - Call getProjection() only once ([@ahocevar](https://github.com/ahocevar))
 * [#7430](https://github.com/openlayers/openlayers/pull/7430) - Add support for hex colors with alpha ([@tschaub](https://github.com/tschaub))
 * [#7431](https://github.com/openlayers/openlayers/pull/7431) - Avoid returning undefined zoom ([@tschaub](https://github.com/tschaub))
 * [#7436](https://github.com/openlayers/openlayers/pull/7436) - Always use source projection loading image tiles ([@pjeweb](https://github.com/pjeweb))
 * [#7433](https://github.com/openlayers/openlayers/pull/7433) - Don't use getHints if it's not needed ([@fredj](https://github.com/fredj))
 * [#7362](https://github.com/openlayers/openlayers/pull/7362) - Added option to the ol.format.GeoJSON to allow the reading of the geometry_name from the geojson ([@Alexandre27](https://github.com/Alexandre27))
 * [#7426](https://github.com/openlayers/openlayers/pull/7426) - Update InteractionOptions.prototype.handleEvent docs ([@glen-nu](https://github.com/glen-nu))
 * [#7423](https://github.com/openlayers/openlayers/pull/7423) - Get rendered features by coordinate when wrapping ([@tschaub](https://github.com/tschaub))
 * [#7421](https://github.com/openlayers/openlayers/pull/7421) - Keep longitude between -180 and 180 ([@tschaub](https://github.com/tschaub))
 * [#7420](https://github.com/openlayers/openlayers/pull/7420) - Fix MapGuide example resolves #7325 ([@TDesjardins](https://github.com/TDesjardins))
 * [#7340](https://github.com/openlayers/openlayers/pull/7340) - Clear label cache when fonts become available ([@ahocevar](https://github.com/ahocevar))
 * [#7414](https://github.com/openlayers/openlayers/pull/7414) - Only split text at line angle changes ([@ahocevar](https://github.com/ahocevar))
 * [#7411](https://github.com/openlayers/openlayers/pull/7411) - Add getLayers and setLayers functions to ol.format.WMSGetFeatureInfo ([@fredj](https://github.com/fredj))
 * [#7328](https://github.com/openlayers/openlayers/pull/7328) - Declutter text and images ([@ahocevar](https://github.com/ahocevar))
 * [#7406](https://github.com/openlayers/openlayers/pull/7406) -  Add option to Zoomify source for setting custom extent ([@lasselaakkonen](https://github.com/lasselaakkonen))
 * [#7410](https://github.com/openlayers/openlayers/pull/7410) - Add getFeatureType and setFeatureType functions to ol.format.WFS ([@fredj](https://github.com/fredj))
 * [#7379](https://github.com/openlayers/openlayers/pull/7379) -  Add support for custom tile size to Zoomify source ([@lasselaakkonen](https://github.com/lasselaakkonen))
 * [#7376](https://github.com/openlayers/openlayers/pull/7376) - changed visibility of overlay properties to protected ([@virtualcitySYSTEMS](https://github.com/virtualcitySYSTEMS))
 * [#7377](https://github.com/openlayers/openlayers/pull/7377) - Add support to specify CSS class name when creating ol.Overlay ([@notnotse](https://github.com/notnotse))
 * [#7383](https://github.com/openlayers/openlayers/pull/7383) - Handle null tile coordinates correctly ([@ahocevar](https://github.com/ahocevar))
 * [#7375](https://github.com/openlayers/openlayers/pull/7375) - Read 'Abstract', 'AccessConstraints' and 'Fees' in ol.format.OWS ([@fredj](https://github.com/fredj))
 * [#7378](https://github.com/openlayers/openlayers/pull/7378) - Fix incorrect docs about ol.source.Raster ([@notnotse](https://github.com/notnotse))
 * [#7371](https://github.com/openlayers/openlayers/pull/7371) - Add @api annotation to ol.VectorTile.getExtent ([@notnotse](https://github.com/notnotse))
 * [#7369](https://github.com/openlayers/openlayers/pull/7369) - Always request the Bing API with the 'culture' value ([@fredj](https://github.com/fredj))
 * [#7364](https://github.com/openlayers/openlayers/pull/7364) - Remove GeoJSON workaround for GeoServer ([@fredj](https://github.com/fredj))
 * [#7355](https://github.com/openlayers/openlayers/pull/7355) - Pass pixel tolerance as a parameter to constructor of ol.interaction.Extent ([@marcosox](https://github.com/marcosox))
 * [#7356](https://github.com/openlayers/openlayers/pull/7356) - Fix documentation for target option in the controls ([@EduardoNogueira](https://github.com/EduardoNogueira))
 * [#7359](https://github.com/openlayers/openlayers/pull/7359) - Rename entry to input - regarding options to rollup lib - Issue #7358 ([@akkumar](https://github.com/akkumar))
 * [#7357](https://github.com/openlayers/openlayers/pull/7357) - Release v4.4.2 ([@tschaub](https://github.com/tschaub))
 * [#7350](https://github.com/openlayers/openlayers/pull/7350) - Calculate correct text box size ([@ahocevar](https://github.com/ahocevar))
 * [#7349](https://github.com/openlayers/openlayers/pull/7349) - Do not use tileUrlFunction for renderer tile coordinates ([@ahocevar](https://github.com/ahocevar))
 * [#7305](https://github.com/openlayers/openlayers/pull/7305) - Fix #7304: Re-calculate the resolution when the WMS source is reprojected ([@oterral](https://github.com/oterral))
 * [#7346](https://github.com/openlayers/openlayers/pull/7346) - Pre-render text images for configured scale ([@ahocevar](https://github.com/ahocevar))
 * [#7345](https://github.com/openlayers/openlayers/pull/7345) - Handle different lineWidth scaling in Safari ([@ahocevar](https://github.com/ahocevar))
 * [#7344](https://github.com/openlayers/openlayers/pull/7344) - Make text height detection independent of css settings ([@ahocevar](https://github.com/ahocevar))
 * [#7341](https://github.com/openlayers/openlayers/pull/7341) - Proper rendering of raster sources when there is a tile transition ([@tschaub](https://github.com/tschaub))
 * [#7339](https://github.com/openlayers/openlayers/pull/7339) - Use correct text stroke on HiDPI devices ([@ahocevar](https://github.com/ahocevar))
 * [#7327](https://github.com/openlayers/openlayers/pull/7327) - Prune the tile cache after updating a source's URL ([@tschaub](https://github.com/tschaub))
 * [#7333](https://github.com/openlayers/openlayers/pull/7333) - Pluggable Map/Layers - function calls to handles and create ([@waxenegger](https://github.com/waxenegger))
 * [#7329](https://github.com/openlayers/openlayers/pull/7329) - Reworked attribution handling ([@tschaub](https://github.com/tschaub))
 * [#7337](https://github.com/openlayers/openlayers/pull/7337) - Always create a new blank image to avoid CSP violations ([@ahocevar](https://github.com/ahocevar))
 * [#7330](https://github.com/openlayers/openlayers/pull/7330) - Add upgrade notes to 4.4.0 changelog ([@tschaub](https://github.com/tschaub))
 * [#7321](https://github.com/openlayers/openlayers/pull/7321) - Release v4.4.1 ([@tschaub](https://github.com/tschaub))
 * [#7323](https://github.com/openlayers/openlayers/pull/7323) - Only clear the canvas when needed ([@tschaub](https://github.com/tschaub))
 * [#7313](https://github.com/openlayers/openlayers/pull/7313) - Use lowercase module identifiers until ol@5 ([@tschaub](https://github.com/tschaub))
 * [#7316](https://github.com/openlayers/openlayers/pull/7316) - fix copy-paste error in 4.4.0 changelog ([@mprins](https://github.com/mprins))
 * [#7315](https://github.com/openlayers/openlayers/pull/7315) - Add new ol.format.filter.Contains spatial operator ([@fredj](https://github.com/fredj))
 * [#7311](https://github.com/openlayers/openlayers/pull/7311) - Release v4.4.0 ([@tschaub](https://github.com/tschaub))

Additionally a number of updates where made to our dependencies:
<details>
  <summary>Click to expand</summary>
  <ul>
    <li><a href="https://github.com/openlayers/openlayers/pull/7455">#7455</a> - Update eslint to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7447">#7447</a> - chore(package): update rollup-plugin-commonjs to version 8.2.6 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7448">#7448</a> - chore(package): update debounce to version 1.1.0 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7451">#7451</a> - chore(package): update karma to version 1.7.1 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7446">#7446</a> - fix(package): update rollup to version 0.51.3 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7428">#7428</a> - Update sinon to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7425">#7425</a> - Update async to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7418">#7418</a> - Update sinon to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7416">#7416</a> - Update sinon to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7417">#7417</a> - Update phantomjs-prebuilt to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7399">#7399</a> - Update eslint to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7395">#7395</a> - Update closure-util to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7392">#7392</a> - Update sinon to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7380">#7380</a> - Update rollup-plugin-cleanup to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7366">#7366</a> - Update handlebars to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7360">#7360</a> - Update eslint to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7354">#7354</a> - Update closure-util to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7319">#7319</a> - Update closure-util to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
    <li><a href="https://github.com/openlayers/openlayers/pull/7314">#7314</a> - Update mocha to the latest version 🚀 (<a href="https://github.com/openlayers">@openlayers</a>)</li>
  </ul>
</details>
