# v5.1.0

The 5.1 release adds a few new features a handful of fixes.  You should be able to upgrade without any additional work.  See the one note below regarding `null` geometry coordinates.

We're working toward type checking with TypeScript.  This will complete our move away from using the Closure Compiler for type checking and compilation.  We're excited about the improved experience for application developers and will highlight some of the benefit in upcoming releases.

### Upgrade Notes

#### Geometry constructor and `setCoordinates` no longer accept `null` coordinates

Geometries (`ol/geom/*`) now need to be constructed with valid coordinates (center for `ol/geom/Circle`) as first constructor argument. The same applies to the `setCoordinates()` (`setCenter() for `ol/geom/Circle`) method.

### New Features and Fixes

 * [#8409](https://github.com/openlayers/openlayers/pull/8409) - Add abstract translate to ol/geom/Geometry ([@pjeweb](https://github.com/pjeweb))
 * [#8405](https://github.com/openlayers/openlayers/pull/8405) - Minor type fixes ([@tschaub](https://github.com/tschaub))
 * [#8401](https://github.com/openlayers/openlayers/pull/8401) - Make webpack's css loader work ([@ahocevar](https://github.com/ahocevar))
 * [#8403](https://github.com/openlayers/openlayers/pull/8403) - Markdown links ([@tschaub](https://github.com/tschaub))
 * [#8402](https://github.com/openlayers/openlayers/pull/8402) - Type fixes from the typescript checks ([@fredj](https://github.com/fredj))
 * [#8400](https://github.com/openlayers/openlayers/pull/8400) - ESLint config update ([@tschaub](https://github.com/tschaub))
 * [#8399](https://github.com/openlayers/openlayers/pull/8399) - Copy ol.css to build dir when building package ([@ahocevar](https://github.com/ahocevar))
 * [#8397](https://github.com/openlayers/openlayers/pull/8397) - Update rollup ([@tschaub](https://github.com/tschaub))
 * [#8385](https://github.com/openlayers/openlayers/pull/8385) - Use class syntax ([@openlayers](https://github.com/openlayers))
 * [#8383](https://github.com/openlayers/openlayers/pull/8383) - style/Icon: Add `setAnchor()` method ([@Turbo87](https://github.com/Turbo87))
 * [#8368](https://github.com/openlayers/openlayers/pull/8368) - Make render listeners work with image render mode ([@ahocevar](https://github.com/ahocevar))
 * [#8376](https://github.com/openlayers/openlayers/pull/8376) - copy ZM values to polygon in makeRegular ([@virtualcitySYSTEMS](https://github.com/virtualcitySYSTEMS))
 * [#8372](https://github.com/openlayers/openlayers/pull/8372) - Release v5.0.3 ([@openlayers](https://github.com/openlayers))
 * [#8364](https://github.com/openlayers/openlayers/pull/8364) - Make examples work in IE11 ([@ahocevar](https://github.com/ahocevar))
 * [#8363](https://github.com/openlayers/openlayers/pull/8363) - Autogenerate src/ol/package.json ([@ahocevar](https://github.com/ahocevar))
 * [#8371](https://github.com/openlayers/openlayers/pull/8371) - Skip rendering when there is no replay group ([@ahocevar](https://github.com/ahocevar))
 * [#8362](https://github.com/openlayers/openlayers/pull/8362) - Smart flat coordinates ([@ahocevar](https://github.com/ahocevar))
 * [#8352](https://github.com/openlayers/openlayers/pull/8352) - Set `sideEffects` to `false` instead of `"false"` ([@tschaub](https://github.com/tschaub))
 * [#8351](https://github.com/openlayers/openlayers/pull/8351) - Fix typo in release notes ([@ahocevar](https://github.com/ahocevar))
 * [#8350](https://github.com/openlayers/openlayers/pull/8350) - Updates for v5.0.2 ([@ahocevar](https://github.com/ahocevar))
 * [#8349](https://github.com/openlayers/openlayers/pull/8349) - Release v5.0.1 ([@ahocevar](https://github.com/ahocevar))
 * [#8343](https://github.com/openlayers/openlayers/pull/8343) - Starter projects ([@tschaub](https://github.com/tschaub))
 * [#8347](https://github.com/openlayers/openlayers/pull/8347) - Fix typos in release notes ([@ahocevar](https://github.com/ahocevar))
 * [#8346](https://github.com/openlayers/openlayers/pull/8346) - Release v5.0.1 ([@openlayers](https://github.com/openlayers))
 * [#8342](https://github.com/openlayers/openlayers/pull/8342) - Fix links and description in quickstart tutorial ([@ahocevar](https://github.com/ahocevar))
 * [#8344](https://github.com/openlayers/openlayers/pull/8344) - Updated issue and pr templates ([@tschaub](https://github.com/tschaub))
 * [#8341](https://github.com/openlayers/openlayers/pull/8341) - Set sideEffects: false flag ([@ahocevar](https://github.com/ahocevar))
 * [#8333](https://github.com/openlayers/openlayers/pull/8333) - Fix wrong return type for readHref function ([@openlayers](https://github.com/openlayers))
 * [#8329](https://github.com/openlayers/openlayers/pull/8329) - Better jsdoc typing ([@fredj](https://github.com/fredj))
 * [#8319](https://github.com/openlayers/openlayers/pull/8319) - Remove reference to setProj4 function in documentation ([@fredj](https://github.com/fredj))


<details>
 <summary>Dependency Updates</summary>

 * [#8410](https://github.com/openlayers/openlayers/pull/8410) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8408](https://github.com/openlayers/openlayers/pull/8408) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8386](https://github.com/openlayers/openlayers/pull/8386) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8382](https://github.com/openlayers/openlayers/pull/8382) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8373](https://github.com/openlayers/openlayers/pull/8373) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8355](https://github.com/openlayers/openlayers/pull/8355) - Update recast to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8354](https://github.com/openlayers/openlayers/pull/8354) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8348](https://github.com/openlayers/openlayers/pull/8348) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8338](https://github.com/openlayers/openlayers/pull/8338) - Update recast to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8332](https://github.com/openlayers/openlayers/pull/8332) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8326](https://github.com/openlayers/openlayers/pull/8326) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8321](https://github.com/openlayers/openlayers/pull/8321) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8318](https://github.com/openlayers/openlayers/pull/8318) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))

</details>
