# v5.3.0

We're continuing to work toward more complete type checking with TypeScript – based on JSDoc annotations in the source.  The 5.3 release includes a number of bug fixes related to the type checking effort.  In addition the release comes with a handful of new features and improved API reference docs.

### Upgrade Notes

#### The `getUid` function returns string

The `getUid` function from the `ol/util` module now returns a string instead of a number.

#### Attributions are not collapsible for `ol/source/OSM`

When a map contains a layer from a `ol/source/OSM` source, the `ol/control/Attribution` control will be shown with the `collapsible: false` behavior.

To get the previous behavior, configure the `ol/control/Attribution` control with `collapsible: true`. 

### New Features and Fixes

 * [#8642](https://github.com/openlayers/openlayers/pull/8642) - Fixes for optional key passing, issue #8067 for tile sources ([@dimin](https://github.com/dimin))
 * [#8885](https://github.com/openlayers/openlayers/pull/8885) - Move GeolocationProperty into Geolocation ([@fredj](https://github.com/fredj))
 * [#8881](https://github.com/openlayers/openlayers/pull/8881) - Remove custom styles in drag-and-drop examples ([@fredj](https://github.com/fredj))
 * [#8877](https://github.com/openlayers/openlayers/pull/8877) - Create context in vector tile layer constructor ([@tschaub](https://github.com/tschaub))
 * [#8883](https://github.com/openlayers/openlayers/pull/8883) - New test runner ([@tschaub](https://github.com/tschaub))
 * [#8882](https://github.com/openlayers/openlayers/pull/8882) - Import simplification ([@fredj](https://github.com/fredj))
 * [#8858](https://github.com/openlayers/openlayers/pull/8858) - Add condition for viewParams and TypeScript related option ([@webgeodatavore](https://github.com/webgeodatavore))
 * [#8879](https://github.com/openlayers/openlayers/pull/8879) - Build with CircleCI ([@openlayers](https://github.com/openlayers))
 * [#8878](https://github.com/openlayers/openlayers/pull/8878) - Avoid logging 404 warnings ([@tschaub](https://github.com/tschaub))
 * [#8876](https://github.com/openlayers/openlayers/pull/8876) - Remove RenderType enum from vector tile layer ([@tschaub](https://github.com/tschaub))
 * [#8874](https://github.com/openlayers/openlayers/pull/8874) - Remove unnecessary type casts in canvas layer renderer ([@tschaub](https://github.com/tschaub))
 * [#8869](https://github.com/openlayers/openlayers/pull/8869) - Fix more types for TypeScript ([@ahocevar](https://github.com/ahocevar))
 * [#8868](https://github.com/openlayers/openlayers/pull/8868) - Throw when calling abstract methods; fix abstract return types ([@ahocevar](https://github.com/ahocevar))
 * [#8862](https://github.com/openlayers/openlayers/pull/8862) - Legacy build and apidoc improvements ([@ahocevar](https://github.com/ahocevar))
 * [#8867](https://github.com/openlayers/openlayers/pull/8867) - Fix example builder ([@ahocevar](https://github.com/ahocevar))
 * [#8852](https://github.com/openlayers/openlayers/pull/8852) - Improve link handling in API docs ([@ahocevar](https://github.com/ahocevar))
 * [#8853](https://github.com/openlayers/openlayers/pull/8853) - Make rendercomplete work with vector sources without loader ([@ahocevar](https://github.com/ahocevar))
 * [#8851](https://github.com/openlayers/openlayers/pull/8851) - Use typescript types for RBush ([@fredj](https://github.com/fredj))
 * [#8850](https://github.com/openlayers/openlayers/pull/8850) - Remove old TODO in ol/Graticule ([@fredj](https://github.com/fredj))
 * [#8847](https://github.com/openlayers/openlayers/pull/8847) - Fix API docs ([@ahocevar](https://github.com/ahocevar))
 * [#8845](https://github.com/openlayers/openlayers/pull/8845) - Remove RenderType enum from vector layer ([@tschaub](https://github.com/tschaub))
 * [#8843](https://github.com/openlayers/openlayers/pull/8843) - Fix ts typing for fullscreen button ([@tonio](https://github.com/tonio))
 * [#8841](https://github.com/openlayers/openlayers/pull/8841) - Use super.method instead of prototype.method.call ([@fredj](https://github.com/fredj))
 * [#8842](https://github.com/openlayers/openlayers/pull/8842) - Change target type from Element to HTMLElement ([@fredj](https://github.com/fredj))
 * [#8840](https://github.com/openlayers/openlayers/pull/8840) - Remove unneeded code in VectorTile renderer ([@elemoine](https://github.com/elemoine))
 * [#8844](https://github.com/openlayers/openlayers/pull/8844) - Set crossOrigin to anonymous in mapbox-streets-v6-style ([@elemoine](https://github.com/elemoine))
 * [#8776](https://github.com/openlayers/openlayers/pull/8776) - Use setTimeout without the window namespace ([@ahocevar](https://github.com/ahocevar))
 * [#8837](https://github.com/openlayers/openlayers/pull/8837) - Re-export MousePosition from ol/control ([@fredj](https://github.com/fredj))
 * [#8832](https://github.com/openlayers/openlayers/pull/8832) - Remove source foreachfeatureatcoordinate from ol/renderer/webgl/ImageLayer ([@fredj](https://github.com/fredj))
 * [#8833](https://github.com/openlayers/openlayers/pull/8833) - Fix wrong filename in type annotation ([@fredj](https://github.com/fredj))
 * [#8827](https://github.com/openlayers/openlayers/pull/8827) - Removed unused forEachFeatureAtCoordinate from ol/source/Source ([@schmidtk](https://github.com/schmidtk))
 * [#8830](https://github.com/openlayers/openlayers/pull/8830) - Type annotation fixes in ol/control/ ([@fredj](https://github.com/fredj))
 * [#8829](https://github.com/openlayers/openlayers/pull/8829) - Change getUid return type from number to string ([@fredj](https://github.com/fredj))
 * [#8825](https://github.com/openlayers/openlayers/pull/8825) - Fix TypeScript errors ([@schmidtk](https://github.com/schmidtk))
 * [#8828](https://github.com/openlayers/openlayers/pull/8828) - Re-export VectorTile from ol/source ([@elemoine](https://github.com/elemoine))
 * [#8806](https://github.com/openlayers/openlayers/pull/8806) - Preserve button class name list in full screen control on toggle ([@notnotse](https://github.com/notnotse))
 * [#8817](https://github.com/openlayers/openlayers/pull/8817) - Clarify format option for ol/source/WMTS ([@romanzoller](https://github.com/romanzoller))
 * [#8824](https://github.com/openlayers/openlayers/pull/8824) - Fix TypeScript errors in ol/format/GML ([@schmidtk](https://github.com/schmidtk))
 * [#8820](https://github.com/openlayers/openlayers/pull/8820) - Polygon intersectsExtent failure - Issue #8795 ([@hmdavidjunior](https://github.com/hmdavidjunior))
 * [#8519](https://github.com/openlayers/openlayers/pull/8519) - GML Format Improvements #8516 #8517 #8518 ([@NielsCharlier](https://github.com/NielsCharlier))
 * [#8711](https://github.com/openlayers/openlayers/pull/8711) - Fix TypeScript errors in ol/format/GML ([@schmidtk](https://github.com/schmidtk))
 * [#8818](https://github.com/openlayers/openlayers/pull/8818) - Fix the way zoom comes from ([@cs09g](https://github.com/cs09g))
 * [#8804](https://github.com/openlayers/openlayers/pull/8804) - Add possibility to disable collapsible attributions from Source ([@notnotse](https://github.com/notnotse))
 * [#8787](https://github.com/openlayers/openlayers/pull/8787) - Replace instanceof checks with other logic ([@ahocevar](https://github.com/ahocevar))
 * [#8808](https://github.com/openlayers/openlayers/pull/8808) - Fix format and version properties in ol/source/WMTS Options typedef ([@fredj](https://github.com/fredj))
 * [#8812](https://github.com/openlayers/openlayers/pull/8812) - Update snap.js ([@rosedo](https://github.com/rosedo))
 * [#8809](https://github.com/openlayers/openlayers/pull/8809) - Configurable interval options ([@notnotse](https://github.com/notnotse))
 * [#8798](https://github.com/openlayers/openlayers/pull/8798) - Use unpkg.com instead of rawgit.com ([@fredj](https://github.com/fredj))
 * [#8805](https://github.com/openlayers/openlayers/pull/8805) - Do not draw image with width or height < 0.5 ([@notnotse](https://github.com/notnotse))
 * [#8803](https://github.com/openlayers/openlayers/pull/8803) - Handle zoom slider position with floating point numbers ([@notnotse](https://github.com/notnotse))
 * [#8789](https://github.com/openlayers/openlayers/pull/8789) - Spelling and indentation fixes ([@fredj](https://github.com/fredj))
 * [#8782](https://github.com/openlayers/openlayers/pull/8782) - Fix getSimplifiedGeometry definition ([@wallw-bits](https://github.com/wallw-bits))
 * [#8783](https://github.com/openlayers/openlayers/pull/8783) - Fix missing method declaration ([@wallw-bits](https://github.com/wallw-bits))
 * [#8781](https://github.com/openlayers/openlayers/pull/8781) - Fix type check errors ([@schmidtk](https://github.com/schmidtk))
 * [#8779](https://github.com/openlayers/openlayers/pull/8779) - Fix additional type check errors ([@schmidtk](https://github.com/schmidtk))
 * [#8753](https://github.com/openlayers/openlayers/pull/8753) - Fix type check in ol/PluggableMap.js ([@wallw-bits](https://github.com/wallw-bits))
 * [#8762](https://github.com/openlayers/openlayers/pull/8762) - Fix type errors from interaction event handlers ([@schmidtk](https://github.com/schmidtk))
 * [#8763](https://github.com/openlayers/openlayers/pull/8763) - Fix type check for ol/events ([@wallw-bits](https://github.com/wallw-bits))
 * [#8774](https://github.com/openlayers/openlayers/pull/8774) - Fix type check errors in ol/renderer/webgl ([@schmidtk](https://github.com/schmidtk))
 * [#8768](https://github.com/openlayers/openlayers/pull/8768) - Fix type check errors in ol/interaction/Select ([@schmidtk](https://github.com/schmidtk))
 * [#8764](https://github.com/openlayers/openlayers/pull/8764) - Fix TypeScript errors in ol/interaction/Draw ([@schmidtk](https://github.com/schmidtk))
 * [#8767](https://github.com/openlayers/openlayers/pull/8767) - Fix type check errors in ol/interaction/Modify ([@schmidtk](https://github.com/schmidtk))
 * [#8773](https://github.com/openlayers/openlayers/pull/8773) - Fix type check errors in ol/renderer/canvas ([@schmidtk](https://github.com/schmidtk))
 * [#8769](https://github.com/openlayers/openlayers/pull/8769) - Fix type check errors in ol/render/canvas ([@schmidtk](https://github.com/schmidtk))
 * [#8770](https://github.com/openlayers/openlayers/pull/8770) - Fix type check errors in ol/render/webgl ([@schmidtk](https://github.com/schmidtk))
 * [#8765](https://github.com/openlayers/openlayers/pull/8765) - Simplify logic for fixed tile url functions ([@ahocevar](https://github.com/ahocevar))
 * [#8766](https://github.com/openlayers/openlayers/pull/8766) - Use FeatureLike typedef ([@fredj](https://github.com/fredj))
 * [#8739](https://github.com/openlayers/openlayers/pull/8739) - Fix TypeScript errors in ol/format/WMSGetFeatureInfo ([@schmidtk](https://github.com/schmidtk))
 * [#8666](https://github.com/openlayers/openlayers/pull/8666) - Fix condition TypeScript errors ([@schmidtk](https://github.com/schmidtk))
 * [#8757](https://github.com/openlayers/openlayers/pull/8757) - Use typeof to simplify JSDoc class types ([@schmidtk](https://github.com/schmidtk))
 * [#8759](https://github.com/openlayers/openlayers/pull/8759) - Use es6 class inheritance in examples ([@fredj](https://github.com/fredj))
 * [#8761](https://github.com/openlayers/openlayers/pull/8761) - Allow returning RenderFeature in ol/format/Feature ([@schmidtk](https://github.com/schmidtk))
 * [#8758](https://github.com/openlayers/openlayers/pull/8758) - Fix TS error and prevent extra string conversion ([@schmidtk](https://github.com/schmidtk))
 * [#8736](https://github.com/openlayers/openlayers/pull/8736) - Typescript misc fixes ([@fredj](https://github.com/fredj))
 * [#8741](https://github.com/openlayers/openlayers/pull/8741) - Fix TypeScript errors in ol/geom/* ([@schmidtk](https://github.com/schmidtk))
 * [#8707](https://github.com/openlayers/openlayers/pull/8707) - Fix TypeScript errors in ol/format/Feature ([@schmidtk](https://github.com/schmidtk))
 * [#8754](https://github.com/openlayers/openlayers/pull/8754) - Fix type check in ol/math ([@wallw-bits](https://github.com/wallw-bits))
 * [#8747](https://github.com/openlayers/openlayers/pull/8747) - Update doc/faq.md ([@fredj](https://github.com/fredj))
 * [#8744](https://github.com/openlayers/openlayers/pull/8744) - Fix type checks in VectorTileSource ([@wallw-bits](https://github.com/wallw-bits))
 * [#8740](https://github.com/openlayers/openlayers/pull/8740) - Increase linestring textalign test tolerance to be Firefox compliant. ([@benVigie](https://github.com/benVigie))
 * [#8738](https://github.com/openlayers/openlayers/pull/8738) - Cast to parent type to fix TS errors ([@schmidtk](https://github.com/schmidtk))
 * [#8737](https://github.com/openlayers/openlayers/pull/8737) - Flag optional param to fix TS error ([@schmidtk](https://github.com/schmidtk))
 * [#8742](https://github.com/openlayers/openlayers/pull/8742) - Fix type checks in Vector source ([@wallw-bits](https://github.com/wallw-bits))
 * [#8743](https://github.com/openlayers/openlayers/pull/8743) - Fix type check in Raster source ([@wallw-bits](https://github.com/wallw-bits))
 * [#8733](https://github.com/openlayers/openlayers/pull/8733) - Fix TypeScript errors in ol/format/WFS ([@schmidtk](https://github.com/schmidtk))
 * [#8735](https://github.com/openlayers/openlayers/pull/8735) - Fix TypeScript errors in ol/format/WKT ([@schmidtk](https://github.com/schmidtk))
 * [#8730](https://github.com/openlayers/openlayers/pull/8730) - Fix TypeScript errors in ol/format/KML ([@schmidtk](https://github.com/schmidtk))
 * [#8732](https://github.com/openlayers/openlayers/pull/8732) - Fix type check in ol/source/Tile ([@wallw-bits](https://github.com/wallw-bits))
 * [#8731](https://github.com/openlayers/openlayers/pull/8731) - Dispatch a GeolocationError in Geolocation ([@fredj](https://github.com/fredj))
 * [#8729](https://github.com/openlayers/openlayers/pull/8729) - Move functions out of the PointerEvent class ([@fredj](https://github.com/fredj))
 * [#8724](https://github.com/openlayers/openlayers/pull/8724) - Typescript misc fixes ([@fredj](https://github.com/fredj))
 * [#8717](https://github.com/openlayers/openlayers/pull/8717) - Fix type checks in TileArcGISRest ([@fredj](https://github.com/fredj))
 * [#8718](https://github.com/openlayers/openlayers/pull/8718) - Fix TypeScript errors in ol/format/GPX ([@schmidtk](https://github.com/schmidtk))
 * [#8706](https://github.com/openlayers/openlayers/pull/8706) - Use EsriJSON types from @types/arcgis-rest-api ([@schmidtk](https://github.com/schmidtk))
 * [#8709](https://github.com/openlayers/openlayers/pull/8709) - Fix TypeScript errors in ol/format/GeoJSON ([@schmidtk](https://github.com/schmidtk))
 * [#8708](https://github.com/openlayers/openlayers/pull/8708) - Fix type checks in ImageCanvas source ([@wallw-bits](https://github.com/wallw-bits))
 * [#8710](https://github.com/openlayers/openlayers/pull/8710) - Fix type checks in ImageArcGISRest ([@wallw-bits](https://github.com/wallw-bits))
 * [#8698](https://github.com/openlayers/openlayers/pull/8698) - Fix zoom slider events ([@intouch-smartwater](https://github.com/intouch-smartwater))
 * [#8697](https://github.com/openlayers/openlayers/pull/8697) - Remove unused properties from Cluster and Image options ([@fredj](https://github.com/fredj))
 * [#8688](https://github.com/openlayers/openlayers/pull/8688) - Fix PointerEventHandler event type ([@fredj](https://github.com/fredj))
 * [#8686](https://github.com/openlayers/openlayers/pull/8686) - Remove extra imports in jsdoc ([@fredj](https://github.com/fredj))
 * [#8681](https://github.com/openlayers/openlayers/pull/8681) - Check the type of the source before using it ([@wallw-bits](https://github.com/wallw-bits))
 * [#8691](https://github.com/openlayers/openlayers/pull/8691) - Fix assertion error documentation URL ([@romanzoller](https://github.com/romanzoller))
 * [#8692](https://github.com/openlayers/openlayers/pull/8692) - Type check fixes for Cluster source ([@wallw-bits](https://github.com/wallw-bits))
 * [#8677](https://github.com/openlayers/openlayers/pull/8677) - Type check fixes for VectorSource ([@wallw-bits](https://github.com/wallw-bits))
 * [#8684](https://github.com/openlayers/openlayers/pull/8684) - Define BingMapsImageryMetadataResponse type ([@wallw-bits](https://github.com/wallw-bits))
 * [#8690](https://github.com/openlayers/openlayers/pull/8690) - Fix type checks in CartoDB ([@wallw-bits](https://github.com/wallw-bits))
 * [#8693](https://github.com/openlayers/openlayers/pull/8693) - Fix type check errors for Image source ([@wallw-bits](https://github.com/wallw-bits))
 * [#8672](https://github.com/openlayers/openlayers/pull/8672) - Fix source type in Raster source ([@fredj](https://github.com/fredj))
 * [#8665](https://github.com/openlayers/openlayers/pull/8665) - Fix type check errors in RBush ([@wallw-bits](https://github.com/wallw-bits))
 * [#8680](https://github.com/openlayers/openlayers/pull/8680) - TypeScript fixes for ol/events ([@schmidtk](https://github.com/schmidtk))
 * [#8678](https://github.com/openlayers/openlayers/pull/8678) - Ensure image is Image or Video before settings src ([@wallw-bits](https://github.com/wallw-bits))
 * [#8676](https://github.com/openlayers/openlayers/pull/8676) - Cast tileGrid to WMTSTileGrid for type check ([@wallw-bits](https://github.com/wallw-bits))
 * [#8679](https://github.com/openlayers/openlayers/pull/8679) - Type check fixes in Triangulation ([@wallw-bits](https://github.com/wallw-bits))
 * [#8657](https://github.com/openlayers/openlayers/pull/8657) - Typescript fixes ([@fgravin](https://github.com/fgravin))
 * [#8671](https://github.com/openlayers/openlayers/pull/8671) - Fix typescript in FeatureLoader ([@fgravin](https://github.com/fgravin))
 * [#8675](https://github.com/openlayers/openlayers/pull/8675) - Get width as number from number|Size ([@wallw-bits](https://github.com/wallw-bits))
 * [#8654](https://github.com/openlayers/openlayers/pull/8654) - Remove extra imports in jsdoc ([@fredj](https://github.com/fredj))
 * [#8655](https://github.com/openlayers/openlayers/pull/8655) - Remove webkit specific properties from Touch ([@fredj](https://github.com/fredj))
 * [#8663](https://github.com/openlayers/openlayers/pull/8663) - Add vendor-specific TS declarations for the Fullscreen API. ([@schmidtk](https://github.com/schmidtk))
 * [#8658](https://github.com/openlayers/openlayers/pull/8658) - Don't define functions in the prototype ([@fredj](https://github.com/fredj))
 * [#8662](https://github.com/openlayers/openlayers/pull/8662) - Explicitly define type of 'this' ([@wallw-bits](https://github.com/wallw-bits))
 * [#8664](https://github.com/openlayers/openlayers/pull/8664) - Add native Event to ListenerFunction signature. ([@schmidtk](https://github.com/schmidtk))
 * [#8668](https://github.com/openlayers/openlayers/pull/8668) - Add missing 'module' annotation ([@fredj](https://github.com/fredj))
 * [#8643](https://github.com/openlayers/openlayers/pull/8643) - Fix style TypeScript errors ([@schmidtk](https://github.com/schmidtk))
 * [#8638](https://github.com/openlayers/openlayers/pull/8638) - Fix event type in hasListener check ([@ahocevar](https://github.com/ahocevar))
 * [#8618](https://github.com/openlayers/openlayers/pull/8618) - Use TopoJSON types from @types/topojson ([@fredj](https://github.com/fredj))
 * [#8619](https://github.com/openlayers/openlayers/pull/8619) - Remove wrong Geometry type in KML format ([@fredj](https://github.com/fredj))
 * [#8627](https://github.com/openlayers/openlayers/pull/8627) - Fix several type imports ([@ahocevar](https://github.com/ahocevar))
 * [#8629](https://github.com/openlayers/openlayers/pull/8629) - Enable circle primitive in draw-shapes example ([@megawac](https://github.com/megawac))
 * [#8626](https://github.com/openlayers/openlayers/pull/8626) - Better type annotations / type casts ([@marcjansen](https://github.com/marcjansen))
 * [#8622](https://github.com/openlayers/openlayers/pull/8622) - Remove unused method ([@tschaub](https://github.com/tschaub))
 * [#8615](https://github.com/openlayers/openlayers/pull/8615) - Use GeoJSON types from @types/geojson ([@tschaub](https://github.com/tschaub))
 * [#8609](https://github.com/openlayers/openlayers/pull/8609) - Remove extra imports in jsdoc ([@fredj](https://github.com/fredj))
 * [#8613](https://github.com/openlayers/openlayers/pull/8613) - Lazily detect tainted canvas ([@ahocevar](https://github.com/ahocevar))
 * [#8610](https://github.com/openlayers/openlayers/pull/8610) - Sensible touch behavior of the MousePosition control ([@ahocevar](https://github.com/ahocevar))
 * [#8602](https://github.com/openlayers/openlayers/pull/8602) - Add missing map property in ol/layer/Layer constructor options ([@fredj](https://github.com/fredj))
 * [#8607](https://github.com/openlayers/openlayers/pull/8607) - Listener return is boolean or void ([@tschaub](https://github.com/tschaub))
 * [#8595](https://github.com/openlayers/openlayers/pull/8595) - Optional arguments and typedef properties ([@tschaub](https://github.com/tschaub))
 * [#8594](https://github.com/openlayers/openlayers/pull/8594) - Remove extra imports in jsdoc ([@fredj](https://github.com/fredj))
 * [#8596](https://github.com/openlayers/openlayers/pull/8596) - Add types for the UTFGrid and TileJSON JSON responses ([@tschaub](https://github.com/tschaub))
 * [#8591](https://github.com/openlayers/openlayers/pull/8591) - Add missing properties in TextState typedef ([@fredj](https://github.com/fredj))
 * [#8590](https://github.com/openlayers/openlayers/pull/8590) - Don't import ourselves ([@fredj](https://github.com/fredj))
 * [#8586](https://github.com/openlayers/openlayers/pull/8586) - Cast 'originalEvent' in interactions ([@fredj](https://github.com/fredj))
 * [#8588](https://github.com/openlayers/openlayers/pull/8588) - Rework createXYZ ([@tschaub](https://github.com/tschaub))
 * [#8587](https://github.com/openlayers/openlayers/pull/8587) - Add a statement to trigger TypeScript checking ([@tschaub](https://github.com/tschaub))
 * [#8345](https://github.com/openlayers/openlayers/pull/8345) - TypeScript (1/n) ([@tschaub](https://github.com/tschaub))
 * [#8579](https://github.com/openlayers/openlayers/pull/8579) - Better type annotation ([@marcjansen](https://github.com/marcjansen))
 * [#8580](https://github.com/openlayers/openlayers/pull/8580) - Cast POINTER_ID before comparison ([@marcjansen](https://github.com/marcjansen))
 * [#8574](https://github.com/openlayers/openlayers/pull/8574) - Rename Extent to ExtentInteraction ([@fredj](https://github.com/fredj))
 * [#8577](https://github.com/openlayers/openlayers/pull/8577) - Remove geojson.js extern inclusion in tasks/generate-info ([@fredj](https://github.com/fredj))
 * [#8573](https://github.com/openlayers/openlayers/pull/8573) - Fix freehand polygon drawing ([@fredj](https://github.com/fredj))
 * [#8572](https://github.com/openlayers/openlayers/pull/8572) - typescript misc fixes ([@fredj](https://github.com/fredj))
 * [#8569](https://github.com/openlayers/openlayers/pull/8569) - Make proj~get simpler and faster ([@ahocevar](https://github.com/ahocevar))
 * [#8567](https://github.com/openlayers/openlayers/pull/8567) - Use 'Element' type instead of 'Node' ([@fredj](https://github.com/fredj))
 * [#8558](https://github.com/openlayers/openlayers/pull/8558) - Fix default zIndex value and documentation for layer options ([@fredj](https://github.com/fredj))
 * [#8555](https://github.com/openlayers/openlayers/pull/8555) - Do not minify examples that inject code into workers ([@ahocevar](https://github.com/ahocevar))
 * [#8557](https://github.com/openlayers/openlayers/pull/8557) - Fix typo in release notes ([@ahocevar](https://github.com/ahocevar))


<details>
  <summary>Dependency Updates</summary>

 * [#8884](https://github.com/openlayers/openlayers/pull/8884) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8880](https://github.com/openlayers/openlayers/pull/8880) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8872](https://github.com/openlayers/openlayers/pull/8872) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8860](https://github.com/openlayers/openlayers/pull/8860) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8855](https://github.com/openlayers/openlayers/pull/8855) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8838](https://github.com/openlayers/openlayers/pull/8838) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8834](https://github.com/openlayers/openlayers/pull/8834) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8799](https://github.com/openlayers/openlayers/pull/8799) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8796](https://github.com/openlayers/openlayers/pull/8796) - Update rollup-plugin-commonjs to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8793](https://github.com/openlayers/openlayers/pull/8793) - Update rollup-plugin-buble to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8794](https://github.com/openlayers/openlayers/pull/8794) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8788](https://github.com/openlayers/openlayers/pull/8788) - Update front-matter to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8785](https://github.com/openlayers/openlayers/pull/8785) - chore(package): update rollup to version 0.66.4 ([@openlayers](https://github.com/openlayers))
 * [#8719](https://github.com/openlayers/openlayers/pull/8719) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8714](https://github.com/openlayers/openlayers/pull/8714) - chore(package): update webpack to version 4.20.2 ([@openlayers](https://github.com/openlayers))
 * [#8703](https://github.com/openlayers/openlayers/pull/8703) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8646](https://github.com/openlayers/openlayers/pull/8646) - Update mustache to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8645](https://github.com/openlayers/openlayers/pull/8645) - Update rollup-plugin-uglify to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8685](https://github.com/openlayers/openlayers/pull/8685) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8683](https://github.com/openlayers/openlayers/pull/8683) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8656](https://github.com/openlayers/openlayers/pull/8656) - chore(package): update rollup-plugin-commonjs to version 9.1.8 ([@openlayers](https://github.com/openlayers))
 * [#8667](https://github.com/openlayers/openlayers/pull/8667) - chore(package): update uglifyjs-webpack-plugin to version 2.0.1 ([@openlayers](https://github.com/openlayers))
 * [#8661](https://github.com/openlayers/openlayers/pull/8661) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8644](https://github.com/openlayers/openlayers/pull/8644) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8631](https://github.com/openlayers/openlayers/pull/8631) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8630](https://github.com/openlayers/openlayers/pull/8630) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8617](https://github.com/openlayers/openlayers/pull/8617) - chore(package): update webpack to version 4.18.0 ([@openlayers](https://github.com/openlayers))
 * [#8589](https://github.com/openlayers/openlayers/pull/8589) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8581](https://github.com/openlayers/openlayers/pull/8581) - Update rollup-plugin-node-resolve to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8585](https://github.com/openlayers/openlayers/pull/8585) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8578](https://github.com/openlayers/openlayers/pull/8578) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8563](https://github.com/openlayers/openlayers/pull/8563) - Update rollup-plugin-uglify to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8561](https://github.com/openlayers/openlayers/pull/8561) - Update rollup-plugin-uglify to the latest version 🚀 ([@openlayers](https://github.com/openlayers))


</details>
