# Custom Charts

Other than the library of available charts, ngx-charts also exports all of the components and helpers used as building blocks for the charts. Things like legends, axes, dimension helpers, gradients, shapes, series of shapes, can all be directly imported into your application and used in your components. This allows you to combine them and build custom charts that implement use cases that the pre-made charts do not support.

You can find an example of how to use these components to build a custom chart here: https://github.com/swimlane/ngx-charts/tree/master/demo/combo-chart

The demo of the above combo-chart can be seen here: https://swimlane.github.io/ngx-charts/#/ngx-charts/combo-chart

The charts under the 'Demos' group in our demo page are not distributed with the library. However, their code is available and can be copied directly into your project. We encourage you to submit a pull request for your custom charts to be listed in our 'Demos' section, because they may help other people that have the same use case as you.

## Custom Chart Index
* [Bar/Line Combo Chart](https://github.com/swimlane/ngx-charts/tree/master/demo/combo-chart)
* [Sparkline](https://github.com/swimlane/ngx-charts/tree/master/demo/sparkline)
* [Timeline filter bar chart](https://github.com/swimlane/ngx-charts/tree/master/demo/timeline-filter-bar-chart)

*If you want to have your custom chart featured above, please submit a pull request to [this file](https://github.com/swimlane/ngx-charts/blob/master/docs/intro/custom-charts.md).*
