/*!
 * smartresize: debounced resize event for jQuery
 *
 * Copyright (c) 2009 Louis-Rémi Babé
 * Licensed under the GPL license.
 * http://docs.jquery.com/License
 *
 */
(function($) {

var event = $.event,
	resizeTimeout;
	
event.special[ "smartresize" ] = {
	setup: function() {
		$( this ).bind( "resize", event.special.smartresize.handler );
	},
	teardown: function() {
		$( this ).unbind( "resize", event.special.smartresize.handler );
	},
	handler: function( event, execAsap ) {
		// Save the context
		var context = this,
			args = arguments;
		
		// set correct event type
        event.type = "smartresize";
		
		if(resizeTimeout)
			clearTimeout(resizeTimeout);
		resizeTimeout = setTimeout(function() {
			jQuery.event.handle.apply( context, args );
		}, execAsap === "execAsap"? 0 : 100);
	}
}

$.fn.smartresize = function( fn ) {
	return fn ? this.bind( "smartresize", fn ) : this.trigger( "smartresize", ["execAsap"] );
};
	
})(jQuery);