define([
	"../common/validate/parameter-presence",
	"../common/validate/parameter-type/number",
	"./name-format"
], function( validateParameterPresence, validateParameterTypeNumber, currencyNameFormat ) {

return function( numberFormatter, pluralGenerator, properties ) {
	var fn;

	// Return formatter when style is "code" or "name".
	if ( pluralGenerator && properties ) {
		fn = function currencyFormatter( value ) {
			validateParameterPresence( value, "value" );
			validateParameterTypeNumber( value, "value" );
			return currencyNameFormat(
				numberFormatter( value ),
				pluralGenerator( value ),
				properties
			);
		};

	// Return formatter when style is "symbol" or "accounting".
	} else {
		fn = function currencyFormatter( value ) {
			return numberFormatter( value );
		};
	}

	return fn;
};

});
