/*! hyperform.js.org */
"use strict";function call_hook(e){var t,n=Array.prototype.slice.call(arguments,1);return e in registry&&(t=registry[e].reduce(function(t){return function(n,r){var a=r.apply({state:n,hook:e},t);return void 0!==a?a:n}}(n),t)),t}function do_filter(e,t){var n=t,r=Array.prototype.slice.call(arguments,1);return e in registry&&(n=registry[e].reduce(function(t,n){r[0]=t;var a=n.apply({state:t,hook:e},r);return void 0!==a?a:t},n)),n}function remove_hook(e,t){if(e in registry)for(var n=0;n<registry[e].length;n++)if(registry[e][n]===t){registry[e].splice(n,1);break}}function add_hook(e,t,n){e in registry||(registry[e]=[]),void 0===n&&(n=registry[e].length),registry[e].splice(n,0,t)}function return_hook_or(e,t){return function(){var n=call_hook(e,Array.prototype.slice.call(arguments));return void 0!==n?n:t.apply(this,arguments)}}function create_event(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.bubbles,r=void 0===n||n,a=t.cancelable,i=void 0!==a&&a,o=document.createEvent("Event");return o.initEvent(e,r,i),o}function trigger_event(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=n.bubbles,a=void 0===r||r,i=n.cancelable,o=void 0!==i&&i,s=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};t instanceof window.Event||(t=create_event(t,{bubbles:a,cancelable:o}));for(var l in s)s.hasOwnProperty(l)&&(t[l]=s[l]);return e.dispatchEvent(t),t}function matches(e,t){return native_matches.call(e,t)}function mark(e){return["object","function"].indexOf(typeof e)>-1&&(delete e.__hyperform,Object.defineProperty(e,"__hyperform",{configurable:!0,enumerable:!1,value:!0})),e}function generate_id(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"hf_";return e+uid++ +Math.random().toString(36).substr(2)}function reportValidity(e){if(e instanceof window.HTMLFormElement)return Array.prototype.map.call(e.elements,reportValidity).every(function(e){return e});var t,n=ValidityState(e).valid;if(n){var r=get_wrapper(e);r&&r.settings.validEvent&&(t=trigger_event(e,"valid",{cancelable:!0}))}else t=trigger_event(e,"invalid",{cancelable:!0});return t&&t.defaultPrevented||Renderer.showWarning(e),n}function submit_form_via(e){var t,n=create_event("submit",{cancelable:!0});n.preventDefault(),Object.defineProperty(n,"defaultPrevented",{value:!1,writable:!0}),Object.defineProperty(n,"preventDefault",{value:function(){return n.defaultPrevented=t=!0},writable:!0}),trigger_event(e.form,n,{},{submittedVia:e}),t||(add_submit_field(e),window.HTMLFormElement.prototype.submit.call(e.form),window.setTimeout(function(){return remove_submit_field(e)}))}function add_submit_field(e){if(["image","submit"].indexOf(e.type)>-1&&e.name){var t=get_wrapper(e.form)||{},n=t.submit_helper;n?n.parentNode&&n.parentNode.removeChild(n):(n=document.createElement("input"),n.type="hidden",t.submit_helper=n),n.name=e.name,n.value=e.value,e.form.appendChild(n)}}function remove_submit_field(e){if(["image","submit"].indexOf(e.type)>-1&&e.name){var t=get_wrapper(e.form)||{},n=t.submit_helper;n&&n.parentNode&&n.parentNode.removeChild(n)}}function check(e){var t=trigger_event(e.form,"validate",{cancelable:!0});if(!t.defaultPrevented){var n,r=!0;Array.prototype.map.call(e.form.elements,function(e){reportValidity(e)||(r=!1,!n&&"focus"in e&&(n=e))}),r?submit_form_via(e):n&&n.focus()}}function is_submit_button(e){return!("INPUT"!==e.nodeName&&"BUTTON"!==e.nodeName||"image"!==e.type&&"submit"!==e.type)}function is_submitting_click(e,t){return!e.defaultPrevented&&(!("button"in e)||e.button<2)&&is_submit_button(t)&&t.form&&!t.form.hasAttribute("novalidate")}function is_submitting_keypress(e){return!e.defaultPrevented&&(13===e.keyCode&&"INPUT"===e.target.nodeName&&text_types.indexOf(e.target.type)>-1||(13===e.keyCode||32===e.keyCode)&&is_submit_button(e.target))&&e.target.form&&!e.target.form.hasAttribute("novalidate")}function get_clicked_button(e){return is_submit_button(e)?e:matches(e,'button:not([type]) *, button[type="submit"] *')?get_clicked_button(e.parentNode):null}function get_click_handler(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return function(t){var n=get_clicked_button(t.target);n&&is_submitting_click(t,n)&&(t.preventDefault(),e||n.hasAttribute("formnovalidate")?submit_form_via(n):check(n))}}function get_keypress_handler(e){return function(t){if(is_submitting_keypress(t)){t.preventDefault();var n=get_wrapper(t.target.form)||{settings:{}};if(n.settings.preventImplicitSubmit)return;for(var r,a=t.target.form.elements.length,i=0;i<a;i++)if(["image","submit"].indexOf(t.target.form.elements[i].type)>-1){r=t.target.form.elements[i];break}r?r.click():e?submit_form_via(t.target):check(t.target)}}}function catch_submit(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];t?(e.addEventListener("click",ignored_click_handler),e.addEventListener("keypress",ignored_keypress_handler)):(e.addEventListener("click",click_handler),e.addEventListener("keypress",keypress_handler))}function uncatch_submit(e){e.removeEventListener("click",ignored_click_handler),e.removeEventListener("keypress",ignored_keypress_handler),e.removeEventListener("click",click_handler),e.removeEventListener("keypress",keypress_handler)}function uninstall_property(e,t){try{delete e[t]}catch(r){var n=get_wrapper(e);return n&&n.settings.debug&&console.log("[hyperform] cannot uninstall custom property "+t),!1}var r=Object.getOwnPropertyDescriptor(e,"_original_"+t);r&&Object.defineProperty(e,t,r)}function install_property(e,t,n){n.configurable=!0,n.enumerable=!0,"value"in n&&(n.writable=!0);var r=Object.getOwnPropertyDescriptor(e,t);if(r){if(r.configurable===!1){var a=get_wrapper(e);return a&&a.settings.debug&&console.log("[hyperform] cannot install custom property "+t),!1}if(r.get&&r.get.__hyperform||r.value&&r.value.__hyperform)return;Object.defineProperty(e,"_original_"+t,r)}return delete e[t],Object.defineProperty(e,t,n),!0}function is_field(e){return e instanceof window.HTMLButtonElement||e instanceof window.HTMLInputElement||e instanceof window.HTMLSelectElement||e instanceof window.HTMLTextAreaElement||e instanceof window.HTMLFieldSetElement||e===window.HTMLButtonElement.prototype||e===window.HTMLInputElement.prototype||e===window.HTMLSelectElement.prototype||e===window.HTMLTextAreaElement.prototype||e===window.HTMLFieldSetElement.prototype}function setCustomValidity(e,t){message_store.set(e,t,!0)}function sprintf(e){for(var t=arguments.length,n=Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];var a=n.length,i=0;return e.replace(/%([0-9]+\$)?([sl])/g,function(e,t,r){var o=i;t&&(o=Number(t.replace(/\$$/,""))-1),i+=1;var s="";return a>o&&(s=n[o]),(s instanceof Date||"number"==typeof s||s instanceof Number)&&(s="l"===r?(s.toLocaleString||s.toString).call(s):s.toString()),s})}function get_week_of_year(e){e=new Date(+e),e.setUTCHours(0,0,0),e.setUTCDate(e.getUTCDate()+4-(e.getUTCDay()||7));var t=new Date(e.getUTCFullYear(),0,1),n=Math.ceil(((e-t)/864e5+1)/7);return[e.getUTCFullYear(),n]}function pad(e){for(var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:2,n=e+"";n.length<t;)n="0"+n;return n}function date_to_string(e,t){if(!(e instanceof Date))return null;switch(t){case"datetime":return date_to_string(e,"date")+"T"+date_to_string(e,"time");case"datetime-local":return sprintf("%s-%s-%sT%s:%s:%s.%s",e.getFullYear(),pad(e.getMonth()+1),pad(e.getDate()),pad(e.getHours()),pad(e.getMinutes()),pad(e.getSeconds()),pad(e.getMilliseconds(),3)).replace(/(:00)?\.000$/,"");case"date":return sprintf("%s-%s-%s",e.getUTCFullYear(),pad(e.getUTCMonth()+1),pad(e.getUTCDate()));case"month":return sprintf("%s-%s",e.getUTCFullYear(),pad(e.getUTCMonth()+1));case"week":var n=get_week_of_year(e);return sprintf.call(null,"%s-W%s",n[0],pad(n[1]));case"time":return sprintf("%s:%s:%s.%s",pad(e.getUTCHours()),pad(e.getUTCMinutes()),pad(e.getUTCSeconds()),pad(e.getUTCMilliseconds(),3)).replace(/(:00)?\.000$/,"")}return null}function get_date_from_week(e,t){var n=new Date(Date.UTC(t,0,1+7*(e-1)));return n.getUTCDay()<=4?n.setUTCDate(n.getUTCDate()-n.getUTCDay()+1):n.setUTCDate(n.getUTCDate()+8-n.getUTCDay()),n}function string_to_date(e,t){var n,r=new Date(0);switch(t){case"datetime":if(!/^([0-9]{4,})-([0-9]{2})-([0-9]{2})T([01][0-9]|2[0-3]):([0-5][0-9])(?::([0-5][0-9])(?:\.([0-9]{1,3}))?)?$/.test(e))return null;for(n=RegExp.$7||"000";n.length<3;)n+="0";return r.setUTCFullYear(Number(RegExp.$1)),r.setUTCMonth(Number(RegExp.$2)-1,Number(RegExp.$3)),r.setUTCHours(Number(RegExp.$4),Number(RegExp.$5),Number(RegExp.$6||0),Number(n)),r;case"date":return/^([0-9]{4,})-([0-9]{2})-([0-9]{2})$/.test(e)?(r.setUTCFullYear(Number(RegExp.$1)),r.setUTCMonth(Number(RegExp.$2)-1,Number(RegExp.$3)),r):null;case"month":return/^([0-9]{4,})-([0-9]{2})$/.test(e)?(r.setUTCFullYear(Number(RegExp.$1)),r.setUTCMonth(Number(RegExp.$2)-1,1),r):null;case"week":return/^([0-9]{4,})-W(0[1-9]|[1234][0-9]|5[0-3])$/.test(e)?get_date_from_week(Number(RegExp.$2),Number(RegExp.$1)):null;case"time":if(!/^([01][0-9]|2[0-3]):([0-5][0-9])(?::([0-5][0-9])(?:\.([0-9]{1,3}))?)?$/.test(e))return null;for(n=RegExp.$4||"000";n.length<3;)n+="0";return r.setUTCHours(Number(RegExp.$1),Number(RegExp.$2),Number(RegExp.$3||0),Number(n)),r}return null}function string_to_number(e,t){var n=string_to_date(e,t);return null!==n?+n:Number(e)}function get_type(e){if(e instanceof window.HTMLTextAreaElement)return"textarea";if(e instanceof window.HTMLSelectElement)return e.hasAttribute("multiple")?"select-multiple":"select-one";if(e instanceof window.HTMLButtonElement)return(e.getAttribute("type")||"submit").toLowerCase();if(e instanceof window.HTMLInputElement){var t=(e.getAttribute("type")||"").toLowerCase();return t&&inputs.indexOf(t)>-1?t:e.type||"text"}return""}function set_language(e){language=e}function add_translation(e,t){e in catalog||(catalog[e]={});for(var n in t)t.hasOwnProperty(n)&&(catalog[e][n]=t[n])}function _(e){return language in catalog&&e in catalog[language]?catalog[language][e]:e in catalog.en?catalog.en[e]:e}function get_next_valid(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,n=get_type(e),r=e.getAttribute("min"),a=default_min[n]||NaN;if(r){var i=string_to_number(r,n);isNaN(i)||(a=i)}var o=e.getAttribute("max"),s=default_max[n]||NaN;if(o){var l=string_to_number(o,n);isNaN(l)||(s=l)}var u=e.getAttribute("step"),d=default_step[n]||1;if(u&&"any"===u.toLowerCase())return[_("any value"),_("any value")];if(u){var c=string_to_number(u,n);isNaN(c)||(d=c)}var m=string_to_number(e.getAttribute("value"),n),f=string_to_number(e.value||e.getAttribute("value"),n);if(isNaN(f))return[_("any valid value"),_("any valid value")];var p=isNaN(a)?isNaN(m)?default_step_base[n]||0:m:a,g=step_scale_factor[n]||1,v=p+Math.floor((f-p)/(d*g))*(d*g)*t,h=p+(Math.floor((f-p)/(d*g))+1)*(d*g)*t;return v<a?v=null:v>s&&(v=s),h>s?h=null:h<a&&(h=a),dates.indexOf(n)>-1&&(v=date_to_string(new Date(v),n),h=date_to_string(new Date(h),n)),[v,h]}function valueAsDate(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0,n=get_type(e);if(dates.indexOf(n)>-1){if(void 0!==t){if(null===t)e.value="";else{if(!(t instanceof Date))throw new window.DOMException("valueAsDate setter encountered invalid value","TypeError");isNaN(t.getTime())?e.value="":e.value=date_to_string(t,n)}return}var r=string_to_date(e.value,n);return r instanceof Date?r:null}if(void 0!==t)throw new window.DOMException("valueAsDate setter cannot set date on this element","InvalidStateError");return null}function valueAsNumber(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0,n=get_type(e);if(numbers.indexOf(n)>-1){if("range"===n&&e.hasAttribute("multiple"))return NaN;if(void 0!==t){if(isNaN(t))e.value="";else{if("number"!=typeof t||!window.isFinite(t))throw new window.DOMException("valueAsNumber setter encountered invalid value","TypeError");try{valueAsDate(e,new Date(t))}catch(n){if(!(n instanceof window.DOMException))throw n;e.value=t.toString()}}return}return string_to_number(e.value,n)}if(void 0!==t)throw new window.DOMException("valueAsNumber setter cannot set number on this element","InvalidStateError");return NaN}function stepDown(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;if(numbers.indexOf(get_type(e))===-1)throw new window.DOMException("stepDown encountered invalid type","InvalidStateError");if("any"===(e.getAttribute("step")||"").toLowerCase())throw new window.DOMException('stepDown encountered step "any"',"InvalidStateError");var n=get_next_valid(e,t)[0];null!==n&&valueAsNumber(e,n)}function stepUp(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;if(numbers.indexOf(get_type(e))===-1)throw new window.DOMException("stepUp encountered invalid type","InvalidStateError");if("any"===(e.getAttribute("step")||"").toLowerCase())throw new window.DOMException('stepUp encountered step "any"',"InvalidStateError");var n=get_next_valid(e,t)[1];null!==n&&valueAsNumber(e,n)}function validationMessage(e){var t=message_store.get(e);return t?t.toString():""}function willValidate(e){return is_validation_candidate(e)}function install_properties(e){for(var t=["accept","max","min","pattern","placeholder","step"],n=0;n<t.length;n++){var r=t[n];install_property(e,r,{get:gA(r),set:sA(r)})}for(var a=["multiple","required","readOnly"],i=0;i<a.length;i++){var o=a[i];install_property(e,o,{get:gAb(o.toLowerCase()),set:sAb(o.toLowerCase())})}for(var s=["minLength","maxLength"],l=0;l<s.length;l++){var u=s[l];install_property(e,u,{get:gAn(u.toLowerCase()),set:sAn(u.toLowerCase())})}}function uninstall_properties(e){for(var t=["accept","max","min","pattern","placeholder","step","multiple","required","readOnly","minLength","maxLength"],n=0;n<t.length;n++){var r=t[n];uninstall_property(e,r)}}function polyfill(e){if(is_field(e)){for(var t in polyfills)install_property(e,t,polyfills[t]);install_properties(e)}else(e instanceof window.HTMLFormElement||e===window.HTMLFormElement.prototype)&&(install_property(e,"checkValidity",polyfills.checkValidity),install_property(e,"reportValidity",polyfills.reportValidity))}function polyunfill(e){is_field(e)?(uninstall_property(e,"checkValidity"),uninstall_property(e,"reportValidity"),uninstall_property(e,"setCustomValidity"),uninstall_property(e,"stepDown"),uninstall_property(e,"stepUp"),uninstall_property(e,"validationMessage"),uninstall_property(e,"validity"),uninstall_property(e,"valueAsDate"),uninstall_property(e,"valueAsNumber"),uninstall_property(e,"willValidate"),uninstall_properties(e)):e instanceof window.HTMLFormElement&&(uninstall_property(e,"checkValidity"),uninstall_property(e,"reportValidity"))}function Wrapper(e,t){var n=instances.get(e);return n?(n.settings=t,n):(this.form=e,this.settings=t,this.revalidator=this.revalidate.bind(this),instances.set(e,this),catch_submit(e,"never"===t.revalidate),e===window||9===e.nodeType?(this.install([window.HTMLButtonElement.prototype,window.HTMLInputElement.prototype,window.HTMLSelectElement.prototype,window.HTMLTextAreaElement.prototype,window.HTMLFieldSetElement.prototype]),polyfill(window.HTMLFormElement)):(e instanceof window.HTMLFormElement||e instanceof window.HTMLFieldSetElement)&&(this.install(e.elements),e instanceof window.HTMLFormElement&&polyfill(e)),"oninput"!==t.revalidate&&"hybrid"!==t.revalidate||(e.addEventListener("keyup",this.revalidator),e.addEventListener("change",this.revalidator)),void("onblur"!==t.revalidate&&"hybrid"!==t.revalidate||e.addEventListener("blur",this.revalidator,!0)))}function get_wrapper(e){var t;for(e.form&&(t=instances.get(e.form));!t&&e;)t=instances.get(e),e=e.parentNode;return t||(t=instances.get(window)),t}function is_validation_candidate(e){var t=do_filter("is_validation_candidate",null,e);if(null!==t)return!!t;if(e instanceof window.HTMLSelectElement||e instanceof window.HTMLTextAreaElement||e instanceof window.HTMLButtonElement||e instanceof window.HTMLInputElement){var n=get_type(e);if((!n||non_inputs.indexOf(n)>-1||validation_candidates.indexOf(n)>-1)&&!e.hasAttribute("disabled")&&!e.hasAttribute("readonly")){var r=get_wrapper(e);if(r&&r.settings.novalidateOnElements||!e.hasAttribute("novalidate")||!e.noValidate){for(var a=e.parentNode;a&&1===a.nodeType;){if(a instanceof window.HTMLFieldSetElement&&a.hasAttribute("disabled"))return!1;if("DATALIST"===a.nodeName.toUpperCase())return!1;if(a===e.form)break;a=a.parentNode}return!0}}}return!1}function format_date(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;switch(t){case"date":return(e.toLocaleDateString||e.toDateString).call(e);case"time":return(e.toLocaleTimeString||e.toTimeString).call(e);case"month":return"toLocaleDateString"in e?e.toLocaleDateString(void 0,{year:"numeric",month:"2-digit"}):e.toDateString();default:return(e.toLocaleString||e.toString).call(e)}}function unicode_string_length(e){return e.match(/[\0-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/g).length}function test_bad_input(e){var t=get_type(e);if(!is_validation_candidate(e)||input_checked.indexOf(t)===-1)return!0;if(!e.value)return!("_original_validity"in e&&!e._original_validity.__hyperform)||!e._original_validity.badInput;var n=!0;switch(t){case"color":n=/^#[a-f0-9]{6}$/.test(e.value);break;case"number":case"range":n=!isNaN(Number(e.value));break;case"datetime":case"date":case"month":case"week":case"time":n=null!==string_to_date(e.value,t);break;case"datetime-local":n=/^([0-9]{4,})-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])T([01][0-9]|2[0-3]):([0-5][0-9])(?::([0-5][0-9])(?:\.([0-9]{1,3}))?)?$/.test(e.value);break;case"tel":break;case"email":}return n}function test_max(e){var t=get_type(e);if(!is_validation_candidate(e)||!e.value||!e.hasAttribute("max"))return!0;var n=void 0,r=void 0;return dates.indexOf(t)>-1?(n=1*string_to_date(e.value,t),r=1*(string_to_date(e.getAttribute("max"),t)||NaN)):(n=Number(e.value),r=Number(e.getAttribute("max"))),isNaN(r)||n<=r}function test_maxlength(e){if(!(is_validation_candidate(e)&&e.value&&text_types.indexOf(get_type(e))!==-1&&e.hasAttribute("maxlength")&&e.getAttribute("maxlength")))return!0;var t=parseInt(e.getAttribute("maxlength"),10);return!!(isNaN(t)||t<0)||unicode_string_length(e.value)<=t}function test_min(e){var t=get_type(e);if(!is_validation_candidate(e)||!e.value||!e.hasAttribute("min"))return!0;var n=void 0,r=void 0;return dates.indexOf(t)>-1?(n=1*string_to_date(e.value,t),r=1*(string_to_date(e.getAttribute("min"),t)||NaN)):(n=Number(e.value),r=Number(e.getAttribute("min"))),isNaN(r)||n>=r}function test_minlength(e){if(!(is_validation_candidate(e)&&e.value&&text_types.indexOf(get_type(e))!==-1&&e.hasAttribute("minlength")&&e.getAttribute("minlength")))return!0;var t=parseInt(e.getAttribute("minlength"),10);return!!(isNaN(t)||t<0)||unicode_string_length(e.value)>=t}function test_pattern(e){return!is_validation_candidate(e)||!e.value||!e.hasAttribute("pattern")||new RegExp("^(?:"+e.getAttribute("pattern")+")$").test(e.value)}function test_required(e){if(!is_validation_candidate(e)||!e.hasAttribute("required"))return!0;switch(e.type){case"checkbox":return e.checked;case"radio":return!!(e.checked||e.form&&Array.prototype.filter.call(document.getElementsByName(e.name),function(t){return t.name===e.name&&t.form===e.form&&t.checked}).length>0);default:return!!e.value}}function test_step(e){var t=get_type(e);if(!is_validation_candidate(e)||!e.value||numbers.indexOf(t)===-1||"any"===(e.getAttribute("step")||"").toLowerCase())return!0;var n=e.getAttribute("step");if(n=n?string_to_number(n,t):default_step[t]||1,n<=0||isNaN(n))return!0;var r=step_scale_factor[t]||1,a=string_to_number(e.value,t),i=string_to_number(e.getAttribute("min")||e.getAttribute("value")||"",t);isNaN(i)&&(i=default_step_base[t]||0),"month"===t&&(i=12*new Date(i).getUTCFullYear()+new Date(i).getUTCMonth(),a=12*new Date(a).getUTCFullYear()+new Date(a).getUTCMonth());var o=Math.abs(i-a)%(n*r);return o<1e-8||o>n*r-1e-8}function trim(e){return e.replace(ws_on_start_or_end,"")}function comma_split(e){return e.split(",").map(function(e){return trim(e)}).filter(function(e){return e})}function test_type(e){var t=get_type(e);if(!is_validation_candidate(e)||"file"!==t&&!e.value||"file"!==t&&type_checked.indexOf(t)===-1)return!0;var n=!0;switch(t){case"url":url_canary||(url_canary=document.createElement("a"));var r=trim(e.value);url_canary.href=r,n=url_canary.href===r||url_canary.href===r+"/";break;case"email":n=e.hasAttribute("multiple")?comma_split(e.value).every(function(e){return email_pattern.test(e)}):email_pattern.test(trim(e.value));break;case"file":if("files"in e&&e.files.length&&e.hasAttribute("accept")){var a=comma_split(e.getAttribute("accept")).map(function(e){return/^(audio|video|image)\/\*$/.test(e)&&(e=new RegExp("^"+RegExp.$1+"/.+$")),e});if(!a.length)break;e:for(var i=0;i<e.files.length;i++){var o=!1;t:for(var s=0;s<a.length;s++){var l=e.files[i],u=a[s],d=l.type;if("string"==typeof u&&"."===u.substr(0,1)){if(l.name.search(".")===-1)continue t;d=l.name.substr(l.name.lastIndexOf("."))}if(0===d.search(u)){o=!0;break t}}if(!o){n=!1;break e}}}}return n}function check$1(e,t){return function(n){var r=!e(n);return r&&t(n),r}}function set_msg(e,t,n){message_store.set(e,custom_messages.get(e,t,n))}function customError(e){var t=custom_validator_registry.get(e),n=t.length,r=!0;if(n)for(var a=0;a<n;a++){var i=t[a](e);if(void 0!==i&&!i){r=!1;break}}if(r){var o=message_store.get(e);r=!(o.toString()&&"is_custom"in o)}return!r}function w(e){var t='Please use camelCase method names! The name "%s" is deprecated and will be removed in the next non-patch release.';console.log(sprintf(t,e))}function hyperform(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.classes,r=t.debug,a=void 0!==r&&r,i=t.extend_fieldset,o=t.extendFieldset,s=t.novalidate_on_elements,l=t.novalidateOnElements,u=t.prevent_implicit_submit,d=t.preventImplicitSubmit,c=t.revalidate,m=t.strict,f=void 0!==m&&m,p=t.valid_event,g=t.validEvent;n||(n={}),void 0===o&&(void 0===i?o=!f:(w("extend_fieldset"),o=i)),void 0===l&&(void 0===s?l=!f:(w("novalidate_on_elements"),l=s)),void 0===d&&(void 0===u?d=!1:(w("prevent_implicit_submit"),d=u)),void 0===c&&(c=f?"onsubmit":"hybrid"),void 0===g&&(void 0===p?g=!f:(w("valid_event"),g=p));var _={debug:a,strict:f,preventImplicitSubmit:d,revalidate:c,validEvent:g,extendFieldset:o,classes:n};return e instanceof window.NodeList||e instanceof window.HTMLCollection||e instanceof Array?Array.prototype.map.call(e,function(e){return hyperform(e,_)}):new Wrapper(e,_)}var registry=Object.create(null),workingDefaultPrevented=function(){var e=document.createEvent("Event");return e.initEvent("foo",!0,!0),e.preventDefault(),e.defaultPrevented}();workingDefaultPrevented||!function(){var e=window.Event.prototype.preventDefault;window.Event.prototype.preventDefault=function(){this.cancelable&&(e.call(this),Object.defineProperty(this,"defaultPrevented",{get:function(){return!0},configurable:!0}))}}();var dates=["datetime","date","month","week","time"],plain_numbers=["number","range"],numbers=dates.concat(plain_numbers,"datetime-local"),type_checked=["email","url"],input_checked=["email","date","month","week","time","datetime","datetime-local","number","range","color"],text_types=["text","search","tel","password"].concat(type_checked),validation_candidates=["checkbox","color","file","image","radio","submit"].concat(numbers,text_types),inputs=["button","hidden","reset"].concat(validation_candidates),non_inputs=["select-one","select-multiple","textarea"],ep=window.Element.prototype,native_matches=ep.matches||ep.matchesSelector||ep.msMatchesSelector||ep.webkitMatchesSelector,store=new WeakMap,message_store={set:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if(e instanceof window.HTMLFieldSetElement){var r=get_wrapper(e);if(r&&!r.settings.extendFieldset)return message_store}return"string"==typeof t&&(t=new String(t)),n&&(t.is_custom=!0),mark(t),store.set(e,t),"_original_setCustomValidity"in e&&e._original_setCustomValidity(t.toString()),message_store},get:function(e){var t=store.get(e);return void 0===t&&"_original_validationMessage"in e&&(t=new String(e._original_validationMessage)),t?t:new String("")},delete:function(e){return"_original_setCustomValidity"in e&&e._original_setCustomValidity(""),store.delete(e)}},uid=0,warningsCache=new WeakMap,DefaultRenderer={attachWarning:function(e,t){t.parentNode.insertBefore(e,t.nextSibling)},detachWarning:function(e,t){e.parentNode.removeChild(e)},showWarning:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=message_store.get(e).toString(),r=warningsCache.get(e);if(n){if(!r){var a=get_wrapper(e);r=document.createElement("div"),r.className=a&&a.settings.classes.warning||"hf-warning",r.id=generate_id(),r.setAttribute("aria-live","polite"),warningsCache.set(e,r)}e.setAttribute("aria-errormessage",r.id),r.textContent=n,Renderer.attachWarning(r,e)}else r&&r.parentNode&&(e.removeAttribute("aria-errormessage"),Renderer.detachWarning(r,e));!t&&"radio"===e.type&&e.form&&Array.prototype.filter.call(document.getElementsByName(e.name),function(t){return t.name===e.name&&t.form===e.form}).map(function(e){return Renderer.showWarning(e,"sub_radio")})}},Renderer={attachWarning:DefaultRenderer.attachWarning,detachWarning:DefaultRenderer.detachWarning,showWarning:DefaultRenderer.showWarning,set:function(e,t){e.indexOf("_")>-1&&(console.log("Renderer.set: please use camelCase names. "+e+" will be removed in the next non-patch release."),e=e.replace(/_([a-z])/g,function(e){return e[1].toUpperCase()})),t||(t=DefaultRenderer[e]),Renderer[e]=t}},click_handler=get_click_handler(),ignored_click_handler=get_click_handler(!0),keypress_handler=get_keypress_handler(),ignored_keypress_handler=get_keypress_handler(!0),catalog={en:{TextTooLong:"Please shorten this text to %l characters or less (you are currently using %l characters).",ValueMissing:"Please fill out this field.",CheckboxMissing:"Please check this box if you want to proceed.",RadioMissing:"Please select one of these options.",FileMissing:"Please select a file.",SelectMissing:"Please select an item in the list.",InvalidEmail:"Please enter an email address.",InvalidURL:"Please enter a URL.",PatternMismatch:"Please match the requested format.",PatternMismatchWithTitle:"Please match the requested format: %l.",NumberRangeOverflow:"Please select a value that is no more than %l.",DateRangeOverflow:"Please select a value that is no later than %l.",TimeRangeOverflow:"Please select a value that is no later than %l.",NumberRangeUnderflow:"Please select a value that is no less than %l.",DateRangeUnderflow:"Please select a value that is no earlier than %l.",TimeRangeUnderflow:"Please select a value that is no earlier than %l.",StepMismatch:"Please select a valid value. The two nearest valid values are %l and %l.",StepMismatchOneValue:"Please select a valid value. The nearest valid value is %l.",BadInputNumber:"Please enter a number."}},language="en",default_step={"datetime-local":60,datetime:60,time:60},step_scale_factor={"datetime-local":1e3,datetime:1e3,date:864e5,week:6048e5,time:1e3},default_step_base={week:-2592e5},default_min={range:0},default_max={range:100},gA=function(e){return function(){return do_filter("attr_get_"+e,this.getAttribute(e),this)}},sA=function(e){return function(t){this.setAttribute(e,do_filter("attr_set_"+e,t,this))}},gAb=function(e){return function(){return do_filter("attr_get_"+e,this.hasAttribute(e),this)}},sAb=function(e){return function(t){do_filter("attr_set_"+e,t,this)?this.setAttribute(e,e):this.removeAttribute(e)}},gAn=function(e){return function(){return do_filter("attr_get_"+e,Math.max(0,Number(this.getAttribute(e))),this)}},sAn=function(e){return function(t){t=do_filter("attr_set_"+e,t,this),/^[0-9]+$/.test(t)&&this.setAttribute(e,t)}},polyfills={checkValidity:{value:mark(function(){return checkValidity(this)})},reportValidity:{value:mark(function(){return reportValidity(this)})},setCustomValidity:{value:mark(function(e){return setCustomValidity(this,e)})},stepDown:{value:mark(function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return stepDown(this,e)})},stepUp:{value:mark(function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return stepUp(this,e)})},validationMessage:{get:mark(function(){return validationMessage(this)})},validity:{get:mark(function(){return ValidityState(this)})},valueAsDate:{get:mark(function(){return valueAsDate(this)}),set:mark(function(e){valueAsDate(this,e)})},valueAsNumber:{get:mark(function(){return valueAsNumber(this)}),set:mark(function(e){valueAsNumber(this,e)})},willValidate:{get:mark(function(){return willValidate(this)})}},instances=new WeakMap;Wrapper.prototype={destroy:function(){uncatch_submit(this.form),instances.delete(this.form),this.form.removeEventListener("keyup",this.revalidator),this.form.removeEventListener("change",this.revalidator),this.form.removeEventListener("blur",this.revalidator,!0),this.form===window||9===this.form.nodeType?(this.uninstall([window.HTMLButtonElement.prototype,window.HTMLInputElement.prototype,window.HTMLSelectElement.prototype,window.HTMLTextAreaElement.prototype,window.HTMLFieldSetElement.prototype]),polyunfill(window.HTMLFormElement)):(this.form instanceof window.HTMLFormElement||this.form instanceof window.HTMLFieldSetElement)&&(this.uninstall(this.form.elements),this.form instanceof window.HTMLFormElement&&polyunfill(this.form))},revalidate:function(e){(e.target instanceof window.HTMLButtonElement||e.target instanceof window.HTMLTextAreaElement||e.target instanceof window.HTMLSelectElement||e.target instanceof window.HTMLInputElement)&&("hybrid"===this.settings.revalidate?"blur"===e.type&&e.target.value!==e.target.defaultValue||ValidityState(e.target).valid?reportValidity(e.target):"keyup"!==e.type&&"change"!==e.type||ValidityState(e.target).valid&&reportValidity(e.target):reportValidity(e.target))},install:function(e){e instanceof window.Element&&(e=[e]);for(var t=e.length,n=0;n<t;n++)polyfill(e[n])},uninstall:function(e){e instanceof window.Element&&(e=[e]);for(var t=e.length,n=0;n<t;n++)polyunfill(e[n])}};var store$1=new WeakMap,custom_messages={set:function(e,t,n){var r=store$1.get(e)||{};return r[t]=n,store$1.set(e,r),custom_messages},get:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:void 0,r=store$1.get(e);if(void 0===r||!(t in r)){var a="data-"+t.replace(/[A-Z]/g,"-$&").toLowerCase();return e.hasAttribute(a)?e.getAttribute(a):n}return r[t]},delete:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;if(!t)return store$1.delete(e);var n=store$1.get(e)||{};return t in n&&(delete n[t],store$1.set(e,n),!0)}},internal_registry=new WeakMap,custom_validator_registry={set:function(e,t){var n=internal_registry.get(e)||[];return n.push(t),internal_registry.set(e,n),custom_validator_registry},get:function(e){return internal_registry.get(e)||[]},delete:function(e){return internal_registry.delete(e)}},ws_on_start_or_end=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,url_canary,email_pattern=/^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/,badInput=check$1(test_bad_input,function(e){return set_msg(e,"badInput",_("Please match the requested type."))}),patternMismatch=check$1(test_pattern,function(e){set_msg(e,"patternMismatch",e.title?sprintf(_("PatternMismatchWithTitle"),e.title):_("PatternMismatch"))}),rangeOverflow=check$1(test_max,function(e){var t=get_type(e),n=get_wrapper(e),r=n&&n.settings.classes.outOfRange||"hf-out-of-range",a=n&&n.settings.classes.inRange||"hf-in-range",i=void 0;switch(t){case"date":case"datetime":case"datetime-local":i=sprintf(_("DateRangeOverflow"),format_date(string_to_date(e.getAttribute("max"),t),t));break;case"time":i=sprintf(_("TimeRangeOverflow"),format_date(string_to_date(e.getAttribute("max"),t),t));break;default:i=sprintf(_("NumberRangeOverflow"),string_to_number(e.getAttribute("max"),t));
}set_msg(e,"rangeOverflow",i),e.classList.add(r),e.classList.remove(a)}),rangeUnderflow=check$1(test_min,function(e){var t=get_type(e),n=get_wrapper(e),r=n&&n.settings.classes.outOfRange||"hf-out-of-range",a=n&&n.settings.classes.inRange||"hf-in-range",i=void 0;switch(t){case"date":case"datetime":case"datetime-local":i=sprintf(_("DateRangeUnderflow"),format_date(string_to_date(e.getAttribute("min"),t),t));break;case"time":i=sprintf(_("TimeRangeUnderflow"),format_date(string_to_date(e.getAttribute("min"),t),t));break;default:i=sprintf(_("NumberRangeUnderflow"),string_to_number(e.getAttribute("min"),t))}set_msg(e,"rangeUnderflow",i),e.classList.add(r),e.classList.remove(a)}),stepMismatch=check$1(test_step,function(e){var t=get_next_valid(e),n=t[0],r=t[1],a=!1,i=void 0;null===n?a=r:null===r&&(a=n),i=a!==!1?sprintf(_("StepMismatchOneValue"),a):sprintf(_("StepMismatch"),n,r),set_msg(e,"stepMismatch",i)}),tooLong=check$1(test_maxlength,function(e){set_msg(e,"tooLong",sprintf(_("TextTooLong"),e.getAttribute("maxlength"),unicode_string_length(e.value)))}),tooShort=check$1(test_minlength,function(e){set_msg(e,"tooShort",sprintf(_("Please lengthen this text to %l characters or more (you are currently using %l characters)."),e.getAttribute("maxlength"),unicode_string_length(e.value)))}),typeMismatch=check$1(test_type,function(e){var t=_("Please use the appropriate format."),n=get_type(e);"email"===n?t=_(e.hasAttribute("multiple")?"Please enter a comma separated list of email addresses.":"InvalidEmail"):"url"===n?t=_("InvalidURL"):"file"===n&&(t=_("Please select a file of the correct type.")),set_msg(e,"typeMismatch",t)}),valueMissing=check$1(test_required,function(e){var t=_("ValueMissing"),n=get_type(e);"checkbox"===n?t=_("CheckboxMissing"):"radio"===n?t=_("RadioMissing"):"file"===n?t=_(e.hasAttribute("multiple")?"Please select one or more files.":"FileMissing"):e instanceof window.HTMLSelectElement&&(t=_("SelectMissing")),set_msg(e,"valueMissing",t)}),validity_state_checkers={badInput:badInput,customError:customError,patternMismatch:patternMismatch,rangeOverflow:rangeOverflow,rangeUnderflow:rangeUnderflow,stepMismatch:stepMismatch,tooLong:tooLong,tooShort:tooShort,typeMismatch:typeMismatch,valueMissing:valueMissing},ValidityState=function e(t){if(!(t instanceof window.HTMLElement))throw new Error("cannot create a ValidityState for a non-element");var n=e.cache.get(t);return n?n:this instanceof e?(this.element=t,void e.cache.set(t,this)):new e(t)},ValidityStatePrototype={};ValidityState.prototype=ValidityStatePrototype,ValidityState.cache=new WeakMap;for(var prop in validity_state_checkers)Object.defineProperty(ValidityStatePrototype,prop,{configurable:!0,enumerable:!0,get:function(e){return function(){return e(this.element)}}(validity_state_checkers[prop]),set:void 0});Object.defineProperty(ValidityStatePrototype,"valid",{configurable:!0,enumerable:!0,get:function(){var e=get_wrapper(this.element),t=e&&e.settings.classes.valid||"hf-valid",n=e&&e.settings.classes.invalid||"hf-invalid",r=e&&e.settings.classes.userInvalid||"hf-user-invalid",a=e&&e.settings.classes.userValid||"hf-user-valid",i=e&&e.settings.classes.inRange||"hf-in-range",o=e&&e.settings.classes.outOfRange||"hf-out-of-range",s=e&&e.settings.classes.validated||"hf-validated";if(this.element.classList.add(s),is_validation_candidate(this.element))for(var l in validity_state_checkers)if(validity_state_checkers[l](this.element))return this.element.classList.add(n),this.element.classList.remove(t),this.element.classList.remove(a),this.element.value!==this.element.defaultValue?this.element.classList.add(r):this.element.classList.remove(r),this.element.setAttribute("aria-invalid","true"),!1;return message_store.delete(this.element),this.element.classList.remove(n,r,o),this.element.classList.add(t,i),this.element.value!==this.element.defaultValue?this.element.classList.add(a):this.element.classList.remove(a),this.element.setAttribute("aria-invalid","false"),!0},set:void 0}),mark(ValidityStatePrototype);var checkValidity=return_hook_or("checkValidity",function(e){if(e instanceof window.HTMLFormElement)return Array.prototype.map.call(e.elements,checkValidity).every(function(e){return e});var t=ValidityState(e).valid;if(t){var n=get_wrapper(e);n&&n.settings.validEvent&&trigger_event(e,"valid")}else trigger_event(e,"invalid",{cancelable:!0});return t}),version="0.9.1";hyperform.version=version,hyperform.checkValidity=checkValidity,hyperform.reportValidity=reportValidity,hyperform.setCustomValidity=setCustomValidity,hyperform.stepDown=stepDown,hyperform.stepUp=stepUp,hyperform.validationMessage=validationMessage,hyperform.ValidityState=ValidityState,hyperform.valueAsDate=valueAsDate,hyperform.valueAsNumber=valueAsNumber,hyperform.willValidate=willValidate,hyperform.setLanguage=function(e){return set_language(e),hyperform},hyperform.addTranslation=function(e,t){return add_translation(e,t),hyperform},hyperform.setRenderer=function(e,t){return Renderer.set(e,t),hyperform},hyperform.addValidator=function(e,t){return custom_validator_registry.set(e,t),hyperform},hyperform.setMessage=function(e,t,n){return custom_messages.set(e,t,n),hyperform},hyperform.addHook=function(e,t,n){return add_hook(e,t,n),hyperform},hyperform.removeHook=function(e,t){return remove_hook(e,t),hyperform},hyperform.set_language=function(e){return w("set_language"),set_language(e),hyperform},hyperform.add_translation=function(e,t){return w("add_translation"),add_translation(e,t),hyperform},hyperform.set_renderer=function(e,t){return w("set_renderer"),Renderer.set(e,t),hyperform},hyperform.add_validator=function(e,t){return w("add_validator"),custom_validator_registry.set(e,t),hyperform},hyperform.set_message=function(e,t,n){return w("set_message"),custom_messages.set(e,t,n),hyperform},hyperform.add_hook=function(e,t,n){return w("add_hook"),add_hook(e,t,n),hyperform},hyperform.remove_hook=function(e,t){return w("remove_hook"),remove_hook(e,t),hyperform},module.exports=hyperform;
