---
title: Foundation for Emails
description: Use Foundation for Emails to design responsive HTML emails that work in any email client.
---

## Getting Started

There are two ways to get started with Foundation for Emails: the CSS version and the Sass version.

The **CSS version** is a ZIP file download with all the HTML and CSS you need to get started writing an HTML email. You'll need to run your HTML through our web inliner before you can send them off.

<a href="css-guide.html" class="large button">Get Started with CSS Version</a>

The **Sass version** gives you more control over the visual styles of the framework, and a full build process, which includes a Sass compiler and image compression. It also includes Inky, our custom HTML language which makes writing code faster, a built-in inliner, and a live reloading server for testing. **The Sass version requires you to have Node.js installed.**

<a href="sass-guide.html" class="large button">Get Started with Sass Version</a>

---

## What's in the Box?

Get to know the pieces of Foundation.

### General

<div class="row up-1 medium-up-2 large-up-3 docs-big-index">
  <div class="column"><a href="sass.html">
    <strong>Using Sass</strong>
    <p>Loading and customizing the Foundation for Emails Sass.</p>
  </a></div>
  <div class="column"><a href="inky.html">
    <strong>Using Inky</strong>
    <p>Our custom HTML tags for writing email components.</p>
  </a></div>
  <div class="column"><a href="zurb-stack.html">
    <strong>ZURB Stack</strong>
    <p>An all-in-one solution for email development.</p>
  </a></div>
  <div class="column"><a href="compatibility.html">
    <strong>Compatibility</strong>
    <p>Foundation works with every key email client&mdash;even Outlook.</p>
  </a></div>
  <div class="column"><a href="migration.html">
    <strong>Migrate from Ink</strong>
    <p>Upgrade your Ink emails to Foundation for Emails 2.</p>
  </a></div>
</div>

### Components

<div class="row up-1 medium-up-2 large-up-3 docs-big-index">
  <div class="column"><a href="grid.html">
    <strong>The Grid</strong>
    <p>A fully responsive grid with support for small and large layouts.</p>
  </a></div>
  <div class="column"><a href="global.html">
    <strong>Global Styles</strong>
    <p>Core framework styles and Sass variables.</p>
  </a></div>
  <div class="column"><a href="alignment.html">
    <strong>Alignment Classes</strong>
    <p>Utility classes to align text and images.</p>
  </a></div>
  <div class="column"><a href="button.html">
    <strong>Buttons</strong>
    <p>Buttons with support for multiple sizes and colors.</p>
  </a></div>
  <div class="column"><a href="callout.html">
    <strong>Callout</strong>
    <p>Colored panels to use for sectioning or calls to action.</p>
  </a></div>
  <div class="column"><a href="menu.html">
    <strong>Menu</strong>
    <p>Horizontal or vertical list of links.</p>
  </a></div>
  <div class="column"><a href="spacer.html">
    <strong>Spacer</strong>
    <p>Create consistant vertical spacing between elements.</p>
  </a></div>
  <div class="column"><a href="wrapper.html">
    <strong>Wrapper</strong>
    <p>Helps create full with or fluid backgrounds.</p>
  </a></div>
  <div class="column"><a href="typography.html">
    <strong>Typography</strong>
    <p>Core styles for paragraphs, headings, and more.</p>
  </a></div>
  <div class="column"><a href="visibility.html">
    <strong>Visibility</strong>
    <p>Utility classes to control how content appears at different screen sizes.</p>
  </a></div>
</div>
