# Contributing to Jasmine-jQuery

Looking to contribute something to Jasmine-jQuery? **Here's how you can help.**

## Reporting issues

We only accept issues that are bug reports or feature requests. Bugs must be isolated and reproducible problems that we can fix within the Jasmine-jQuery. Please read the following guidelines before opening any issue.

1. **Search for existing issues.** Somemeone else may have reported the same issue. Moreover, the issue may have already been resolved with a fix available.
2. **Create an isolated and reproducible test case.** Be sure the problem exists in Jasmine-jQuery's code with a [reduced test case](http://css-tricks.com/reduced-test-cases/) that should be included in each bug report.
3. **Include a live example.** Make use of jsFiddle or jsBin to share your isolated test cases.
4. **Share as much information as possible.** Include operating system and version, browser and version, version of Jasmine-jQuery. Also include steps to reproduce the bug.

## Pull requests

- Try not to pollute your pull request with unintended changes--keep them simple and small
- Please squash your commits when appropriate. This simplifies future cherry picks, and also keeps the git log clean.
- Include tests that fail without your code, and pass with it.
- Update the documentation, examples elsewhere, and the guides: whatever is affected by your contribution.
- If you can, have another developer sanity check your change.

## Coding standards

- No semicolons
- Comma first
- 2 spaces (no tabs)
- strict mode
- "Attractive"
