/*! JointJS v0.9.5 - JavaScript diagramming library  2015-09-10 


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
(function(root, factory) {

    if (typeof define === 'function' && define.amd) {

        // AMD. Register as an anonymous module.
        define([], factory);

    } else if (typeof exports === 'object') {

        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like environments that support module.exports,
        // like Node.
        module.exports = factory();

    } else {

        // Browser globals.
        root.g = factory();
    }

}(this, function() {

var g=function(){function a(b,c){if(!(this instanceof a))return new a(b,c);var d;void 0===c&&Object(b)!==b?(d=b.split(-1===b.indexOf("@")?" ":"@"),this.x=parseInt(d[0],10),this.y=parseInt(d[1],10)):Object(b)===b?(this.x=b.x,this.y=b.y):(this.x=b,this.y=c)}function b(c,d){return this instanceof b?(this.start=a(c),void(this.end=a(d))):new b(c,d)}function c(a,b,d,e){return this instanceof c?(void 0===b&&(b=a.y,d=a.width,e=a.height,a=a.x),this.x=a,this.y=b,this.width=d,void(this.height=e)):new c(a,b,d,e)}function d(b,c,e){return this instanceof d?(b=a(b),this.x=b.x,this.y=b.y,this.a=c,void(this.b=e)):new d(b,c,e)}var e=Math,f=e.abs,h=e.cos,i=e.sin,j=e.sqrt,k=e.min,l=e.max,m=(e.atan,e.atan2),n=(e.acos,e.round),o=e.floor,p=e.PI,q=e.random,r=function(a){return 180*a/p%360},s=function(a,b){return b=b||!1,a=b?a:a%360,a*p/180},t=function(a,b){return b*Math.round(a/b)},u=function(a){return a%360+(0>a?360:0)};a.prototype={toString:function(){return this.x+"@"+this.y},adhereToRect:function(a){return a.containsPoint(this)?this:(this.x=k(l(this.x,a.x),a.x+a.width),this.y=k(l(this.y,a.y),a.y+a.height),this)},theta:function(b){b=a(b);var c=-(b.y-this.y),d=b.x-this.x,e=10,f=0==c.toFixed(e)&&0==d.toFixed(e)?0:m(c,d);return 0>f&&(f=2*p+f),180*f/p},distance:function(a){return b(this,a).length()},manhattanDistance:function(a){return f(a.x-this.x)+f(a.y-this.y)},offset:function(a,b){return this.x+=a||0,this.y+=b||0,this},magnitude:function(){return j(this.x*this.x+this.y*this.y)||.01},update:function(a,b){return this.x=a||0,this.y=b||0,this},round:function(a){return this.x=a?this.x.toFixed(a):n(this.x),this.y=a?this.y.toFixed(a):n(this.y),this},normalize:function(a){var b=(a||1)/this.magnitude();return this.x=b*this.x,this.y=b*this.y,this},difference:function(b){return a(this.x-b.x,this.y-b.y)},bearing:function(a){return b(this,a).bearing()},toPolar:function(b){b=b&&a(b)||a(0,0);var c=this.x,d=this.y;return this.x=j((c-b.x)*(c-b.x)+(d-b.y)*(d-b.y)),this.y=s(b.theta(a(c,d))),this},rotate:function(b,c){c=(c+360)%360,this.toPolar(b),this.y+=s(c);var d=a.fromPolar(this.x,this.y,b);return this.x=d.x,this.y=d.y,this},move:function(b,c){var d=s(a(b).theta(this));return this.offset(h(d)*c,-i(d)*c)},changeInAngle:function(b,c,d){return a(this).offset(-b,-c).theta(d)-this.theta(d)},equals:function(a){return this.x===a.x&&this.y===a.y},snapToGrid:function(a,b){return this.x=t(this.x,a),this.y=t(this.y,b||a),this},reflection:function(b){return a(b).move(this,this.distance(b))},clone:function(){return a(this)}},a.fromPolar=function(b,c,d){d=d&&a(d)||a(0,0);var e=f(b*h(c)),g=f(b*i(c)),j=u(r(c));return 90>j?g=-g:180>j?(e=-e,g=-g):270>j&&(e=-e),a(d.x+e,d.y+g)},a.random=function(b,c,d,e){return a(o(q()*(c-b+1)+b),o(q()*(e-d+1)+d))},b.prototype={toString:function(){return this.start.toString()+" "+this.end.toString()},length:function(){return j(this.squaredLength())},squaredLength:function(){var a=this.start.x,b=this.start.y,c=this.end.x,d=this.end.y;return(a-=c)*a+(b-=d)*b},midpoint:function(){return a((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},intersection:function(b){var c=a(this.end.x-this.start.x,this.end.y-this.start.y),d=a(b.end.x-b.start.x,b.end.y-b.start.y),e=c.x*d.y-c.y*d.x,f=a(b.start.x-this.start.x,b.start.y-this.start.y),g=f.x*d.y-f.y*d.x,h=f.x*c.y-f.y*c.x;if(0===e||0>g*e||0>h*e)return null;if(e>0){if(g>e||h>e)return null}else if(e>g||e>h)return null;return a(this.start.x+g*c.x/e,this.start.y+g*c.y/e)},bearing:function(){var a=s(this.start.y),b=s(this.end.y),c=this.start.x,d=this.end.x,e=s(d-c),f=i(e)*h(b),g=h(a)*i(b)-i(a)*h(b)*h(e),j=r(m(f,g)),k=["NE","E","SE","S","SW","W","NW","N"],l=j-22.5;return 0>l&&(l+=360),l=parseInt(l/45),k[l]},pointAt:function(b){var c=(1-b)*this.start.x+b*this.end.x,d=(1-b)*this.start.y+b*this.end.y;return a(c,d)},pointOffset:function(a){return((this.end.x-this.start.x)*(a.y-this.start.y)-(this.end.y-this.start.y)*(a.x-this.start.x))/2},clone:function(){return b(this)}},c.prototype={toString:function(){return this.origin().toString()+" "+this.corner().toString()},equals:function(a){var b=g.rect(this).normalize(),c=g.rect(a).normalize();return b.x===c.x&&b.y===c.y&&b.width===c.width&&b.height===c.height},origin:function(){return a(this.x,this.y)},corner:function(){return a(this.x+this.width,this.y+this.height)},topRight:function(){return a(this.x+this.width,this.y)},bottomLeft:function(){return a(this.x,this.y+this.height)},center:function(){return a(this.x+this.width/2,this.y+this.height/2)},intersect:function(a){var b=this.origin(),d=this.corner(),e=a.origin(),f=a.corner();if(f.x<=b.x||f.y<=b.y||e.x>=d.x||e.y>=d.y)return null;var g=Math.max(b.x,e.x),h=Math.max(b.y,e.y);return c(g,h,Math.min(d.x,f.x)-g,Math.min(d.y,f.y)-h)},sideNearestToPoint:function(b){b=a(b);var c=b.x-this.x,d=this.x+this.width-b.x,e=b.y-this.y,f=this.y+this.height-b.y,g=c,h="left";return g>d&&(g=d,h="right"),g>e&&(g=e,h="top"),g>f&&(g=f,h="bottom"),h},containsPoint:function(b){return b=a(b),b.x>=this.x&&b.x<=this.x+this.width&&b.y>=this.y&&b.y<=this.y+this.height?!0:!1},containsRect:function(a){var b=c(a).normalize(),d=b.width,e=b.height,f=b.x,g=b.y,h=this.width,i=this.height;if(0>(h|i|d|e))return!1;var j=this.x,k=this.y;if(j>f||k>g)return!1;if(h+=j,d+=f,f>=d){if(h>=j||d>h)return!1}else if(h>=j&&d>h)return!1;if(i+=k,e+=g,g>=e){if(i>=k||e>i)return!1}else if(i>=k&&e>i)return!1;return!0},pointNearestToPoint:function(b){if(b=a(b),this.containsPoint(b)){var c=this.sideNearestToPoint(b);switch(c){case"right":return a(this.x+this.width,b.y);case"left":return a(this.x,b.y);case"bottom":return a(b.x,this.y+this.height);case"top":return a(b.x,this.y)}}return b.adhereToRect(this)},intersectionWithLineFromCenterToPoint:function(c,d){c=a(c);var e,f=a(this.x+this.width/2,this.y+this.height/2);d&&c.rotate(f,d);for(var g=[b(this.origin(),this.topRight()),b(this.topRight(),this.corner()),b(this.corner(),this.bottomLeft()),b(this.bottomLeft(),this.origin())],h=b(f,c),i=g.length-1;i>=0;--i){var j=g[i].intersection(h);if(null!==j){e=j;break}}return e&&d&&e.rotate(f,-d),e},moveAndExpand:function(a){return this.x+=a.x||0,this.y+=a.y||0,this.width+=a.width||0,this.height+=a.height||0,this},round:function(a){return this.x=a?this.x.toFixed(a):n(this.x),this.y=a?this.y.toFixed(a):n(this.y),this.width=a?this.width.toFixed(a):n(this.width),this.height=a?this.height.toFixed(a):n(this.height),this},normalize:function(){var a=this.x,b=this.y,c=this.width,d=this.height;return this.width<0&&(a=this.x+this.width,c=-this.width),this.height<0&&(b=this.y+this.height,d=-this.height),this.x=a,this.y=b,this.width=c,this.height=d,this},bbox:function(a){var b=s(a||0),d=f(i(b)),e=f(h(b)),g=this.width*e+this.height*d,j=this.width*d+this.height*e;return c(this.x+(this.width-g)/2,this.y+(this.height-j)/2,g,j)},snapToGrid:function(a,b){var c=this.origin().snapToGrid(a,b),d=this.corner().snapToGrid(a,b);return this.x=c.x,this.y=c.y,this.width=d.x-c.x,this.height=d.y-c.y,this},clone:function(){return c(this)}},d.prototype={toString:function(){return a(this.x,this.y).toString()+" "+this.a+" "+this.b},bbox:function(){return c(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},intersectionWithLineFromCenterToPoint:function(b,c){b=a(b),c&&b.rotate(a(this.x,this.y),c);var d,e=b.x-this.x,f=b.y-this.y;if(0===e)return d=this.bbox().pointNearestToPoint(b),c?d.rotate(a(this.x,this.y),-c):d;var g=f/e,h=g*g,i=this.a*this.a,k=this.b*this.b,l=j(1/(1/i+h/k));l=0>e?-l:l;var m=g*l;return d=a(this.x+l,this.y+m),c?d.rotate(a(this.x,this.y),-c):d},clone:function(){return d(this)}};var v={curveThroughPoints:function(a){for(var b=this.getCurveControlPoints(a),c=["M",a[0].x,a[0].y],d=0;d<b[0].length;d++)c.push("C",b[0][d].x,b[0][d].y,b[1][d].x,b[1][d].y,a[d+1].x,a[d+1].y);return c},getCurveControlPoints:function(b){var c,d=[],e=[],f=b.length-1;if(1==f)return d[0]=a((2*b[0].x+b[1].x)/3,(2*b[0].y+b[1].y)/3),e[0]=a(2*d[0].x-b[0].x,2*d[0].y-b[0].y),[d,e];var g=[];for(c=1;f-1>c;c++)g[c]=4*b[c].x+2*b[c+1].x;g[0]=b[0].x+2*b[1].x,g[f-1]=(8*b[f-1].x+b[f].x)/2;var h=this.getFirstControlPoints(g);for(c=1;f-1>c;++c)g[c]=4*b[c].y+2*b[c+1].y;g[0]=b[0].y+2*b[1].y,g[f-1]=(8*b[f-1].y+b[f].y)/2;var i=this.getFirstControlPoints(g);for(c=0;f>c;c++)d.push(a(h[c],i[c])),f-1>c?e.push(a(2*b[c+1].x-h[c+1],2*b[c+1].y-i[c+1])):e.push(a((b[f].x+h[f-1])/2,(b[f].y+i[f-1])/2));return[d,e]},getFirstControlPoints:function(a){var b=a.length,c=[],d=[],e=2;c[0]=a[0]/e;for(var f=1;b>f;f++)d[f]=1/e,e=(b-1>f?4:3.5)-d[f],c[f]=(a[f]-c[f-1])/e;for(f=1;b>f;f++)c[b-f-1]-=d[b-f]*c[b-f];return c},getInversionSolver:function(a,b,c,d){function e(a,b){var c=f[a],d=f[b];return function(e){var f=(a%3?3:1)*(b%3?3:1),g=e.x*(c.y-d.y)+e.y*(d.x-c.x)+c.x*d.y-c.y*d.x;return f*g}}var f=arguments;return function(c){var d=3*e(2,3)(b),f=e(1,3)(a)/d,g=-e(2,3)(a)/d,h=f*e(3,1)(c)+g*(e(3,0)(c)+e(2,1)(c))+e(2,0)(c),i=f*e(3,0)(c)+g*e(2,0)(c)+e(1,0)(c);return i/(i-h)}},getCurveDivider:function(a,c,d,e){return function(f){var g=b(a,c).pointAt(f),h=b(c,d).pointAt(f),i=b(d,e).pointAt(f),j=b(g,h).pointAt(f),k=b(h,i).pointAt(f),l=b(j,k).pointAt(f);return[{p0:a,p1:g,p2:j,p3:l},{p0:l,p1:k,p2:i,p3:e}]}}},w={linear:function(a,b,c){var d=a[1]-a[0],e=b[1]-b[0];return(c-a[0])/d*e+b[0]||0}};return{toDeg:r,toRad:s,snapToGrid:t,normalizeAngle:u,point:a,line:b,rect:c,ellipse:d,bezier:v,scale:w}}();

    return g;

}));
