/*! JointJS v0.9.5 - JavaScript diagramming library  2015-09-10 


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
(function(root, factory) {

    if (typeof define === 'function' && define.amd) {

        // For AMD.

        define(['backbone', 'lodash', 'jquery'], function(Backbone, _, $) {

            Backbone.$ = $;

            return factory(root, Backbone, _, $);
        });

    } else if (typeof exports !== 'undefined') {

        // For Node.js or CommonJS.

        var Backbone = require('backbone');
        var _ = require('lodash');
        var $ = Backbone.$ = require('jquery');

        module.exports = factory(root, Backbone, _, $);

    } else {

        // As a browser global.

        var Backbone = root.Backbone;
        var _ = root._;
        var $ = Backbone.$ = root.jQuery || root.$;

        root.joint = factory(root, Backbone, _, $);
        root.g = root.joint.g;
        root.V = root.Vectorizer = root.joint.V;
    }

}(this, function(root, Backbone, _, $) {

var g=function(){function a(b,c){if(!(this instanceof a))return new a(b,c);var d;void 0===c&&Object(b)!==b?(d=b.split(-1===b.indexOf("@")?" ":"@"),this.x=parseInt(d[0],10),this.y=parseInt(d[1],10)):Object(b)===b?(this.x=b.x,this.y=b.y):(this.x=b,this.y=c)}function b(c,d){return this instanceof b?(this.start=a(c),void(this.end=a(d))):new b(c,d)}function c(a,b,d,e){return this instanceof c?(void 0===b&&(b=a.y,d=a.width,e=a.height,a=a.x),this.x=a,this.y=b,this.width=d,void(this.height=e)):new c(a,b,d,e)}function d(b,c,e){return this instanceof d?(b=a(b),this.x=b.x,this.y=b.y,this.a=c,void(this.b=e)):new d(b,c,e)}var e=Math,f=e.abs,h=e.cos,i=e.sin,j=e.sqrt,k=e.min,l=e.max,m=(e.atan,e.atan2),n=(e.acos,e.round),o=e.floor,p=e.PI,q=e.random,r=function(a){return 180*a/p%360},s=function(a,b){return b=b||!1,a=b?a:a%360,a*p/180},t=function(a,b){return b*Math.round(a/b)},u=function(a){return a%360+(0>a?360:0)};a.prototype={toString:function(){return this.x+"@"+this.y},adhereToRect:function(a){return a.containsPoint(this)?this:(this.x=k(l(this.x,a.x),a.x+a.width),this.y=k(l(this.y,a.y),a.y+a.height),this)},theta:function(b){b=a(b);var c=-(b.y-this.y),d=b.x-this.x,e=10,f=0==c.toFixed(e)&&0==d.toFixed(e)?0:m(c,d);return 0>f&&(f=2*p+f),180*f/p},distance:function(a){return b(this,a).length()},manhattanDistance:function(a){return f(a.x-this.x)+f(a.y-this.y)},offset:function(a,b){return this.x+=a||0,this.y+=b||0,this},magnitude:function(){return j(this.x*this.x+this.y*this.y)||.01},update:function(a,b){return this.x=a||0,this.y=b||0,this},round:function(a){return this.x=a?this.x.toFixed(a):n(this.x),this.y=a?this.y.toFixed(a):n(this.y),this},normalize:function(a){var b=(a||1)/this.magnitude();return this.x=b*this.x,this.y=b*this.y,this},difference:function(b){return a(this.x-b.x,this.y-b.y)},bearing:function(a){return b(this,a).bearing()},toPolar:function(b){b=b&&a(b)||a(0,0);var c=this.x,d=this.y;return this.x=j((c-b.x)*(c-b.x)+(d-b.y)*(d-b.y)),this.y=s(b.theta(a(c,d))),this},rotate:function(b,c){c=(c+360)%360,this.toPolar(b),this.y+=s(c);var d=a.fromPolar(this.x,this.y,b);return this.x=d.x,this.y=d.y,this},move:function(b,c){var d=s(a(b).theta(this));return this.offset(h(d)*c,-i(d)*c)},changeInAngle:function(b,c,d){return a(this).offset(-b,-c).theta(d)-this.theta(d)},equals:function(a){return this.x===a.x&&this.y===a.y},snapToGrid:function(a,b){return this.x=t(this.x,a),this.y=t(this.y,b||a),this},reflection:function(b){return a(b).move(this,this.distance(b))},clone:function(){return a(this)}},a.fromPolar=function(b,c,d){d=d&&a(d)||a(0,0);var e=f(b*h(c)),g=f(b*i(c)),j=u(r(c));return 90>j?g=-g:180>j?(e=-e,g=-g):270>j&&(e=-e),a(d.x+e,d.y+g)},a.random=function(b,c,d,e){return a(o(q()*(c-b+1)+b),o(q()*(e-d+1)+d))},b.prototype={toString:function(){return this.start.toString()+" "+this.end.toString()},length:function(){return j(this.squaredLength())},squaredLength:function(){var a=this.start.x,b=this.start.y,c=this.end.x,d=this.end.y;return(a-=c)*a+(b-=d)*b},midpoint:function(){return a((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},intersection:function(b){var c=a(this.end.x-this.start.x,this.end.y-this.start.y),d=a(b.end.x-b.start.x,b.end.y-b.start.y),e=c.x*d.y-c.y*d.x,f=a(b.start.x-this.start.x,b.start.y-this.start.y),g=f.x*d.y-f.y*d.x,h=f.x*c.y-f.y*c.x;if(0===e||0>g*e||0>h*e)return null;if(e>0){if(g>e||h>e)return null}else if(e>g||e>h)return null;return a(this.start.x+g*c.x/e,this.start.y+g*c.y/e)},bearing:function(){var a=s(this.start.y),b=s(this.end.y),c=this.start.x,d=this.end.x,e=s(d-c),f=i(e)*h(b),g=h(a)*i(b)-i(a)*h(b)*h(e),j=r(m(f,g)),k=["NE","E","SE","S","SW","W","NW","N"],l=j-22.5;return 0>l&&(l+=360),l=parseInt(l/45),k[l]},pointAt:function(b){var c=(1-b)*this.start.x+b*this.end.x,d=(1-b)*this.start.y+b*this.end.y;return a(c,d)},pointOffset:function(a){return((this.end.x-this.start.x)*(a.y-this.start.y)-(this.end.y-this.start.y)*(a.x-this.start.x))/2},clone:function(){return b(this)}},c.prototype={toString:function(){return this.origin().toString()+" "+this.corner().toString()},equals:function(a){var b=g.rect(this).normalize(),c=g.rect(a).normalize();return b.x===c.x&&b.y===c.y&&b.width===c.width&&b.height===c.height},origin:function(){return a(this.x,this.y)},corner:function(){return a(this.x+this.width,this.y+this.height)},topRight:function(){return a(this.x+this.width,this.y)},bottomLeft:function(){return a(this.x,this.y+this.height)},center:function(){return a(this.x+this.width/2,this.y+this.height/2)},intersect:function(a){var b=this.origin(),d=this.corner(),e=a.origin(),f=a.corner();if(f.x<=b.x||f.y<=b.y||e.x>=d.x||e.y>=d.y)return null;var g=Math.max(b.x,e.x),h=Math.max(b.y,e.y);return c(g,h,Math.min(d.x,f.x)-g,Math.min(d.y,f.y)-h)},sideNearestToPoint:function(b){b=a(b);var c=b.x-this.x,d=this.x+this.width-b.x,e=b.y-this.y,f=this.y+this.height-b.y,g=c,h="left";return g>d&&(g=d,h="right"),g>e&&(g=e,h="top"),g>f&&(g=f,h="bottom"),h},containsPoint:function(b){return b=a(b),b.x>=this.x&&b.x<=this.x+this.width&&b.y>=this.y&&b.y<=this.y+this.height?!0:!1},containsRect:function(a){var b=c(a).normalize(),d=b.width,e=b.height,f=b.x,g=b.y,h=this.width,i=this.height;if(0>(h|i|d|e))return!1;var j=this.x,k=this.y;if(j>f||k>g)return!1;if(h+=j,d+=f,f>=d){if(h>=j||d>h)return!1}else if(h>=j&&d>h)return!1;if(i+=k,e+=g,g>=e){if(i>=k||e>i)return!1}else if(i>=k&&e>i)return!1;return!0},pointNearestToPoint:function(b){if(b=a(b),this.containsPoint(b)){var c=this.sideNearestToPoint(b);switch(c){case"right":return a(this.x+this.width,b.y);case"left":return a(this.x,b.y);case"bottom":return a(b.x,this.y+this.height);case"top":return a(b.x,this.y)}}return b.adhereToRect(this)},intersectionWithLineFromCenterToPoint:function(c,d){c=a(c);var e,f=a(this.x+this.width/2,this.y+this.height/2);d&&c.rotate(f,d);for(var g=[b(this.origin(),this.topRight()),b(this.topRight(),this.corner()),b(this.corner(),this.bottomLeft()),b(this.bottomLeft(),this.origin())],h=b(f,c),i=g.length-1;i>=0;--i){var j=g[i].intersection(h);if(null!==j){e=j;break}}return e&&d&&e.rotate(f,-d),e},moveAndExpand:function(a){return this.x+=a.x||0,this.y+=a.y||0,this.width+=a.width||0,this.height+=a.height||0,this},round:function(a){return this.x=a?this.x.toFixed(a):n(this.x),this.y=a?this.y.toFixed(a):n(this.y),this.width=a?this.width.toFixed(a):n(this.width),this.height=a?this.height.toFixed(a):n(this.height),this},normalize:function(){var a=this.x,b=this.y,c=this.width,d=this.height;return this.width<0&&(a=this.x+this.width,c=-this.width),this.height<0&&(b=this.y+this.height,d=-this.height),this.x=a,this.y=b,this.width=c,this.height=d,this},bbox:function(a){var b=s(a||0),d=f(i(b)),e=f(h(b)),g=this.width*e+this.height*d,j=this.width*d+this.height*e;return c(this.x+(this.width-g)/2,this.y+(this.height-j)/2,g,j)},snapToGrid:function(a,b){var c=this.origin().snapToGrid(a,b),d=this.corner().snapToGrid(a,b);return this.x=c.x,this.y=c.y,this.width=d.x-c.x,this.height=d.y-c.y,this},clone:function(){return c(this)}},d.prototype={toString:function(){return a(this.x,this.y).toString()+" "+this.a+" "+this.b},bbox:function(){return c(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},intersectionWithLineFromCenterToPoint:function(b,c){b=a(b),c&&b.rotate(a(this.x,this.y),c);var d,e=b.x-this.x,f=b.y-this.y;if(0===e)return d=this.bbox().pointNearestToPoint(b),c?d.rotate(a(this.x,this.y),-c):d;var g=f/e,h=g*g,i=this.a*this.a,k=this.b*this.b,l=j(1/(1/i+h/k));l=0>e?-l:l;var m=g*l;return d=a(this.x+l,this.y+m),c?d.rotate(a(this.x,this.y),-c):d},clone:function(){return d(this)}};var v={curveThroughPoints:function(a){for(var b=this.getCurveControlPoints(a),c=["M",a[0].x,a[0].y],d=0;d<b[0].length;d++)c.push("C",b[0][d].x,b[0][d].y,b[1][d].x,b[1][d].y,a[d+1].x,a[d+1].y);return c},getCurveControlPoints:function(b){var c,d=[],e=[],f=b.length-1;if(1==f)return d[0]=a((2*b[0].x+b[1].x)/3,(2*b[0].y+b[1].y)/3),e[0]=a(2*d[0].x-b[0].x,2*d[0].y-b[0].y),[d,e];var g=[];for(c=1;f-1>c;c++)g[c]=4*b[c].x+2*b[c+1].x;g[0]=b[0].x+2*b[1].x,g[f-1]=(8*b[f-1].x+b[f].x)/2;var h=this.getFirstControlPoints(g);for(c=1;f-1>c;++c)g[c]=4*b[c].y+2*b[c+1].y;g[0]=b[0].y+2*b[1].y,g[f-1]=(8*b[f-1].y+b[f].y)/2;var i=this.getFirstControlPoints(g);for(c=0;f>c;c++)d.push(a(h[c],i[c])),f-1>c?e.push(a(2*b[c+1].x-h[c+1],2*b[c+1].y-i[c+1])):e.push(a((b[f].x+h[f-1])/2,(b[f].y+i[f-1])/2));return[d,e]},getFirstControlPoints:function(a){var b=a.length,c=[],d=[],e=2;c[0]=a[0]/e;for(var f=1;b>f;f++)d[f]=1/e,e=(b-1>f?4:3.5)-d[f],c[f]=(a[f]-c[f-1])/e;for(f=1;b>f;f++)c[b-f-1]-=d[b-f]*c[b-f];return c},getInversionSolver:function(a,b,c,d){function e(a,b){var c=f[a],d=f[b];return function(e){var f=(a%3?3:1)*(b%3?3:1),g=e.x*(c.y-d.y)+e.y*(d.x-c.x)+c.x*d.y-c.y*d.x;return f*g}}var f=arguments;return function(c){var d=3*e(2,3)(b),f=e(1,3)(a)/d,g=-e(2,3)(a)/d,h=f*e(3,1)(c)+g*(e(3,0)(c)+e(2,1)(c))+e(2,0)(c),i=f*e(3,0)(c)+g*e(2,0)(c)+e(1,0)(c);return i/(i-h)}},getCurveDivider:function(a,c,d,e){return function(f){var g=b(a,c).pointAt(f),h=b(c,d).pointAt(f),i=b(d,e).pointAt(f),j=b(g,h).pointAt(f),k=b(h,i).pointAt(f),l=b(j,k).pointAt(f);return[{p0:a,p1:g,p2:j,p3:l},{p0:l,p1:k,p2:i,p3:e}]}}},w={linear:function(a,b,c){var d=a[1]-a[0],e=b[1]-b[0];return(c-a[0])/d*e+b[0]||0}};return{toDeg:r,toRad:s,snapToGrid:t,normalizeAngle:u,point:a,line:b,rect:c,ellipse:d,bezier:v,scale:w}}();
var V,Vectorizer;V=Vectorizer=function(){function a(){var a=++x+"";return"v-"+a}function b(a){return(a||"").replace(/ /g," ")}function c(a){return a===Object(a)}function d(a){return"[object Array]"==Object.prototype.toString.call(a)}function e(a){var b='<svg xmlns="'+v.xmlns+'" xmlns:xlink="'+v.xlink+'" version="'+w+'">'+(a||"")+"</svg>",c=f(b,{async:!1});return c.documentElement}function f(a,b){b=b||{};var c;try{var d=new DOMParser;"undefined"!=typeof b.async&&(d.async=b.async),c=d.parseFromString(a,"text/xml")}catch(e){c=void 0}if(!c||c.getElementsByTagName("parsererror").length)throw new Error("Invalid XML: "+a);return c}function h(a,b,c){var d,f;if(!a)return void 0;if("object"==typeof a)return new m(a);if(b=b||{},"svg"===a.toLowerCase())return new m(e());if("<"===a[0]){var g=e(a);if(g.childNodes.length>1){var h=[];for(d=0,f=g.childNodes.length;f>d;d++){var j=g.childNodes[d];h.push(new m(document.importNode(j,!0)))}return h}return new m(document.importNode(g.firstChild,!0))}a=document.createElementNS(v.xmlns,a);for(var k in b)i(a,k,b[k]);for("[object Array]"!=Object.prototype.toString.call(c)&&(c=[c]),d=0,f=c[0]&&c.length||0;f>d;d++){var l=c[d];a.appendChild(l instanceof m?l.node:l)}return new m(a)}function i(a,b,c){if(b.indexOf(":")>-1){var d=b.split(":");a.setAttributeNS(v[d[0]],d[1],c)}else"id"===b?a.id=c:a.setAttribute(b,c)}function j(a){var b,c,d;if(a){var e=/[ ,]+/,f=a.match(/translate\((.*)\)/);f&&(b=f[1].split(e));var g=a.match(/rotate\((.*)\)/);g&&(c=g[1].split(e));var h=a.match(/scale\((.*)\)/);h&&(d=h[1].split(e))}var i=d&&d[0]?parseFloat(d[0]):1;return{translate:{tx:b&&b[0]?parseInt(b[0],10):0,ty:b&&b[1]?parseInt(b[1],10):0},rotate:{angle:c&&c[0]?parseInt(c[0],10):0,cx:c&&c[1]?parseInt(c[1],10):void 0,cy:c&&c[2]?parseInt(c[2],10):void 0},scale:{sx:i,sy:d&&d[1]?parseFloat(d[1]):i}}}function k(a,b){var c=b.x*a.a+b.y*a.c+0,d=b.x*a.b+b.y*a.d+0;return{x:c,y:d}}function l(a){var b=k(a,{x:0,y:1}),c=k(a,{x:1,y:0}),d=180/Math.PI*Math.atan2(b.y,b.x)-90,e=180/Math.PI*Math.atan2(c.y,c.x);return{translateX:a.e,translateY:a.f,scaleX:Math.sqrt(a.a*a.a+a.b*a.b),scaleY:Math.sqrt(a.c*a.c+a.d*a.d),skewX:d,skewY:e,rotation:d}}function m(b){b instanceof m&&(b=b.node),this.node=b,this.node.id||(this.node.id=a())}function n(a){a=h(a);var b=["M",a.attr("x1"),a.attr("y1"),"L",a.attr("x2"),a.attr("y2")].join(" ");return b}function o(a){a=h(a);for(var b,c=a.node.points,d=[],e=0;e<c.length;e++)b=c[e],d.push(0===e?"M":"L",b.x,b.y);return d.push("Z"),d.join(" ")}function p(a){a=h(a);for(var b,c=a.node.points,d=[],e=0;e<c.length;e++)b=c[e],d.push(0===e?"M":"L",b.x,b.y);return d.join(" ")}function q(a){a=h(a);var b=parseFloat(a.attr("cx"))||0,c=parseFloat(a.attr("cy"))||0,d=parseFloat(a.attr("r")),e=d*y,f=["M",b,c-d,"C",b+e,c-d,b+d,c-e,b+d,c,"C",b+d,c+e,b+e,c+d,b,c+d,"C",b-e,c+d,b-d,c+e,b-d,c,"C",b-d,c-e,b-e,c-d,b,c-d,"Z"].join(" ");return f}function r(a){a=h(a);var b=parseFloat(a.attr("cx"))||0,c=parseFloat(a.attr("cy"))||0,d=parseFloat(a.attr("rx")),e=parseFloat(a.attr("ry"))||d,f=d*y,g=e*y,i=["M",b,c-e,"C",b+f,c-e,b+d,c-g,b+d,c,"C",b+d,c+g,b+f,c+e,b,c+e,"C",b-f,c+e,b-d,c+g,b-d,c,"C",b-d,c-g,b-f,c-e,b,c-e,"Z"].join(" ");return i}function s(a){a=h(a);var b,c=parseFloat(a.attr("x"))||0,d=parseFloat(a.attr("y"))||0,e=parseFloat(a.attr("width"))||0,f=parseFloat(a.attr("height"))||0,i=parseFloat(a.attr("rx"))||0,j=parseFloat(a.attr("ry"))||0,k=g.rect(c,d,e,f);if(i||j){var l=c+e,m=d+f;b=["M",c+i,d,"L",l-i,d,"Q",l,d,l,d+j,"L",l,d+f-j,"Q",l,m,l-i,m,"L",c+i,m,"Q",c,m,c,m-i,"L",c,d+j,"Q",c,d,c+i,d,"Z"].join(" ")}else b=["M",k.origin().x,k.origin().y,"H",k.corner().x,"V",k.corner().y,"H",k.origin().x,"V",k.origin().y,"Z"].join(" ");return b}function t(a){var b=a.rx||a["top-rx"]||0,c=a.rx||a["bottom-rx"]||0,d=a.ry||a["top-ry"]||0,e=a.ry||a["bottom-ry"]||0;return["M",a.x,a.y+d,"v",a.height-d-e,"a",c,e,0,0,0,c,e,"h",a.width-2*c,"a",c,e,0,0,0,c,-e,"v",-(a.height-e-d),"a",b,d,0,0,0,-b,-d,"h",-(a.width-2*b),"a",b,d,0,0,0,-b,d].join(" ")}var u="object"==typeof window&&!(!window.SVGAngle&&!document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"));if(!u)return function(){};var v={xmlns:"http://www.w3.org/2000/svg",xlink:"http://www.w3.org/1999/xlink"},w="1.1",x=0;m.prototype={translate:function(a,b,c){c=c||{},b=b||0;var d=this.attr("transform")||"",e=j(d);if("undefined"==typeof a)return e.translate;d=d.replace(/translate\([^\)]*\)/g,"").trim();var f=c.absolute?a:e.translate.tx+a,g=c.absolute?b:e.translate.ty+b,h="translate("+f+","+g+")";return this.attr("transform",(h+" "+d).trim()),this},rotate:function(a,b,c,d){d=d||{};var e=this.attr("transform")||"",f=j(e);if("undefined"==typeof a)return f.rotate;e=e.replace(/rotate\([^\)]*\)/g,"").trim(),a%=360;var g=d.absolute?a:f.rotate.angle+a,h=void 0!==b&&void 0!==c?","+b+","+c:"",i="rotate("+g+h+")";return this.attr("transform",(e+" "+i).trim()),this},scale:function(a,b){b="undefined"==typeof b?a:b;var c=this.attr("transform")||"",d=j(c);if("undefined"==typeof a)return d.scale;c=c.replace(/scale\([^\)]*\)/g,"").trim();var e="scale("+a+","+b+")";return this.attr("transform",(c+" "+e).trim()),this},bbox:function(a,b){if(!this.node.ownerSVGElement)return{x:0,y:0,width:0,height:0};var c;try{c=this.node.getBBox(),c={x:c.x,y:c.y,width:c.width,height:c.height}}catch(d){c={x:this.node.clientLeft,y:this.node.clientTop,width:this.node.clientWidth,height:this.node.clientHeight}}if(a)return c;var e=this.node.getTransformToElement(b||this.node.ownerSVGElement);return z.transformRect(c,e)},text:function(a,e){a=b(a),e=e||{};var f,g=a.split("\n"),i=0,j=this.attr("y");j||this.attr("y","0.8em"),this.attr("display",a?null:"none"),this.node.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve"),this.node.textContent="";var k=this.node;if(e.textPath){var l=this.find("defs");0===l.length&&(l=h("defs"),this.append(l));var m=Object(e.textPath)===e.textPath?e.textPath.d:e.textPath;if(m){var n=h("path",{d:m});l.append(n)}var o=h("textPath");!e.textPath["xlink:href"]&&n&&o.attr("xlink:href","#"+n.node.id),Object(e.textPath)===e.textPath&&o.attr(e.textPath),this.append(o),k=o.node}for(var p=0,i=0;i<g.length;i++){var q=g[i],r=e.lineHeight||"1em";"auto"===e.lineHeight&&(r="1.5em");var s=z("tspan",{dy:0==i?"0em":r,x:this.attr("x")||0});if(s.addClass("v-line"),q)if(e.annotations){for(var t=0,u=z.annotateString(g[i],d(e.annotations)?e.annotations:[e.annotations],{offset:-p,includeAnnotationIndices:e.includeAnnotationIndices}),v=0;v<u.length;v++){var w=u[v];if(c(w)){var x=parseInt(w.attrs["font-size"],10);x&&x>t&&(t=x),f=z("tspan",w.attrs),e.includeAnnotationIndices&&f.attr("annotations",w.annotations),w.attrs["class"]&&f.addClass(w.attrs["class"]),f.node.textContent=w.t}else f=document.createTextNode(w||" ");s.append(f)}"auto"===e.lineHeight&&t&&0!==i&&s.attr("dy",1.2*t+"px")}else s.node.textContent=q;else s.addClass("v-empty-line"),s.node.style.opacity=0,s.node.textContent="-";z(k).append(s),p+=q.length+1}return this},attr:function(a,b){if("undefined"==typeof a){for(var c=this.node.attributes,d={},e=0;e<c.length;e++)d[c[e].nodeName]=c[e].nodeValue;return d}if("string"==typeof a&&"undefined"==typeof b)return this.node.getAttribute(a);if("object"==typeof a)for(var f in a)a.hasOwnProperty(f)&&i(this.node,f,a[f]);else i(this.node,a,b);return this},remove:function(){this.node.parentNode&&this.node.parentNode.removeChild(this.node)},append:function(a){var b=a;"[object Array]"!==Object.prototype.toString.call(a)&&(b=[a]);for(var c=0,d=b.length;d>c;c++)a=b[c],this.node.appendChild(a instanceof m?a.node:a);return this},prepend:function(a){this.node.insertBefore(a instanceof m?a.node:a,this.node.firstChild)},svg:function(){return this.node instanceof window.SVGSVGElement?this:z(this.node.ownerSVGElement)},defs:function(){var a=this.svg().node.getElementsByTagName("defs");return a&&a.length?z(a[0]):void 0},clone:function(){var b=z(this.node.cloneNode(!0));return b.node.id=a(),b},findOne:function(a){var b=this.node.querySelector(a);return b?z(b):void 0},find:function(a){var b=this.node.querySelectorAll(a);return Array.prototype.map.call(b,z)},index:function(){for(var a=0,b=this.node.previousSibling;b;)1===b.nodeType&&a++,b=b.previousSibling;return a},findParentByClass:function(a,b){b=b||this.node.ownerSVGElement;for(var c=this.node.parentNode;c&&c!==b;){if(z(c).hasClass(a))return z(c);c=c.parentNode}return null},toLocalPoint:function(a,b){var c=this.svg().node,d=c.createSVGPoint();d.x=a,d.y=b;try{var e=d.matrixTransform(c.getScreenCTM().inverse()),f=this.node.getTransformToElement(c).inverse()}catch(g){return d}return e.matrixTransform(f)},translateCenterToPoint:function(a){var b=this.bbox(),c=g.rect(b).center();this.translate(a.x-c.x,a.y-c.y)},translateAndAutoOrient:function(a,b,c){var d=this.scale();this.attr("transform",""),this.scale(d.sx,d.sy);var e=this.svg().node,f=this.bbox(!1,c),h=e.createSVGTransform();h.setTranslate(-f.x-f.width/2,-f.y-f.height/2);var i=e.createSVGTransform(),j=g.point(a).changeInAngle(a.x-b.x,a.y-b.y,b);i.setRotate(j,0,0);var k=e.createSVGTransform(),m=g.point(a).move(b,f.width/2);k.setTranslate(a.x+(a.x-m.x),a.y+(a.y-m.y));var n=this.node.getTransformToElement(c),o=e.createSVGTransform();o.setMatrix(k.matrix.multiply(i.matrix.multiply(h.matrix.multiply(n))));var p=l(o.matrix);return this.translate(p.translateX,p.translateY),this.rotate(p.rotation),this},animateAlongPath:function(a,b){var c=z("animateMotion",a),d=z("mpath",{"xlink:href":"#"+z(b).node.id});c.append(d),this.append(c);try{c.node.beginElement()}catch(e){if("fake"===document.documentElement.getAttribute("smiling")){var f=c.node;f.animators=[];var g=f.getAttribute("id");g&&(id2anim[g]=f);for(var h=getTargets(f),i=0,j=h.length;j>i;i++){var k=h[i],l=new Animator(f,k,i);animators.push(l),f.animators[i]=l,l.register()}}}},hasClass:function(a){return new RegExp("(\\s|^)"+a+"(\\s|$)").test(this.node.getAttribute("class"))},addClass:function(a){if(!this.hasClass(a)){var b=this.node.getAttribute("class")||"";this.node.setAttribute("class",(b+" "+a).trim())}return this},removeClass:function(a){if(this.hasClass(a)){var b=this.node.getAttribute("class").replace(new RegExp("(\\s|^)"+a+"(\\s|$)","g"),"$2");this.node.setAttribute("class",b)}return this},toggleClass:function(a,b){var c="undefined"==typeof b?this.hasClass(a):!b;return c?this.removeClass(a):this.addClass(a),this},sample:function(a){a=a||1;for(var b,c=this.node,d=c.getTotalLength(),e=[],f=0;d>f;)b=c.getPointAtLength(f),e.push({x:b.x,y:b.y,distance:f}),f+=a;return e},convertToPath:function(){var a=h("path");a.attr(this.attr());var b=this.convertToPathData();return b&&a.attr("d",b),a},convertToPathData:function(){var a=this.node.tagName.toUpperCase();switch(a){case"PATH":return this.attr("d");case"LINE":return n(this.node);case"POLYGON":return o(this.node);case"POLYLINE":return p(this.node);case"ELLIPSE":return r(this.node);case"CIRCLE":return q(this.node);case"RECT":return s(this.node)}throw new Error(a+" cannot be converted to PATH.")},findIntersection:function(a,b){var c=this.svg().node;b=b||c;var d=g.rect(this.bbox(!1,b)),e=d.center(),f=d.intersectionWithLineFromCenterToPoint(a);if(!f)return void 0;var h=this.node.localName.toUpperCase();if("RECT"===h){var i=g.rect(parseFloat(this.attr("x")||0),parseFloat(this.attr("y")||0),parseFloat(this.attr("width")),parseFloat(this.attr("height"))),j=this.node.getTransformToElement(b),k=z.decomposeMatrix(j),l=c.createSVGTransform();l.setRotate(-k.rotation,e.x,e.y);var m=z.transformRect(i,l.matrix.multiply(j));f=g.rect(m).intersectionWithLineFromCenterToPoint(a,k.rotation)}else if("PATH"===h||"POLYGON"===h||"POLYLINE"===h||"CIRCLE"===h||"ELLIPSE"===h){for(var n="PATH"===h?this:this.convertToPath(),o=n.sample(),p=1/0,q=[],r=0,s=o.length;s>r;r++){var t=o[r],u=z.createSVGPoint(t.x,t.y);u=u.matrixTransform(this.node.getTransformToElement(b)),t=g.point(u);var v=t.distance(e),w=1.1*t.distance(a),x=v+w;p>x?(p=x,q=[{sample:t,refDistance:w}]):p+1>x&&q.push({sample:t,refDistance:w})}q.sort(function(a,b){return a.refDistance-b.refDistance}),f=q[0].sample}return f}};var y=.5522847498307935,z=h;z.isVElement=function(a){return a instanceof m},z.decomposeMatrix=l,z.rectToPath=t;var A=z("svg").node;return z.createSVGMatrix=function(a){var b=A.createSVGMatrix();for(var c in a)b[c]=a[c];return b},z.createSVGTransform=function(){return A.createSVGTransform()},z.createSVGPoint=function(a,b){var c=A.createSVGPoint();return c.x=a,c.y=b,c},z.transformRect=function(a,b){var c=A.createSVGPoint();c.x=a.x,c.y=a.y;var d=c.matrixTransform(b);c.x=a.x+a.width,c.y=a.y;var e=c.matrixTransform(b);c.x=a.x+a.width,c.y=a.y+a.height;var f=c.matrixTransform(b);c.x=a.x,c.y=a.y+a.height;var g=c.matrixTransform(b),h=Math.min(d.x,e.x,f.x,g.x),i=Math.max(d.x,e.x,f.x,g.x),j=Math.min(d.y,e.y,f.y,g.y),k=Math.max(d.y,e.y,f.y,g.y);return{x:h,y:j,width:i-h,height:k-j}},z.styleToObject=function(a){for(var b={},c=a.split(";"),d=0;d<c.length;d++){var e=c[d],f=e.split("=");b[f[0].trim()]=f[1].trim()}return b},z.createSlicePathData=function(a,b,c,d){var e=2*Math.PI-1e-6,f=a,g=b,h=c,i=d,j=(h>i&&(j=h,h=i,i=j),i-h),k=j<Math.PI?"0":"1",l=Math.cos(h),m=Math.sin(h),n=Math.cos(i),o=Math.sin(i);return j>=e?f?"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"M0,"+f+"A"+f+","+f+" 0 1,0 0,"+-f+"A"+f+","+f+" 0 1,0 0,"+f+"Z":"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"Z":f?"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L"+f*n+","+f*o+"A"+f+","+f+" 0 "+k+",0 "+f*l+","+f*m+"Z":"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L0,0Z"},z.mergeAttrs=function(a,b){for(var d in b)"class"===d?a[d]=a[d]?a[d]+" "+b[d]:b[d]:"style"===d?c(a[d])&&c(b[d])?a[d]=z.mergeAttrs(a[d],b[d]):c(a[d])?a[d]=z.mergeAttrs(a[d],z.styleToObject(b[d])):c(b[d])?a[d]=z.mergeAttrs(z.styleToObject(a[d]),b[d]):a[d]=z.mergeAttrs(z.styleToObject(a[d]),z.styleToObject(b[d])):a[d]=b[d];return a},z.annotateString=function(a,b,d){b=b||[],d=d||{},offset=d.offset||0;for(var e,f,g,h=[],i=[],j=0;j<a.length;j++){f=i[j]=a[j];for(var k=0;k<b.length;k++){var l=b[k],m=l.start+offset,n=l.end+offset;j>=m&&n>j&&(c(f)?f.attrs=z.mergeAttrs(z.mergeAttrs({},f.attrs),l.attrs):f=i[j]={t:a[j],attrs:l.attrs},d.includeAnnotationIndices&&(f.annotations||(f.annotations=[])).push(k))}g=i[j-1],g?c(f)&&c(g)?JSON.stringify(f.attrs)===JSON.stringify(g.attrs)?e.t+=f.t:(h.push(e),e=f):c(f)?(h.push(e),e=f):c(g)?(h.push(e),e=f):e=(e||"")+f:e=f}return e&&h.push(e),h},z.findAnnotationsAtIndex=function(a,b){if(!a)return[];var c=[];return a.forEach(function(a){a.start<b&&b<=a.end&&c.push(a)}),c},z.findAnnotationsBetweenIndexes=function(a,b,c){if(!a)return[];var d=[];return a.forEach(function(a){(b>=a.start&&b<a.end||c>a.start&&c<=a.end||a.start>=b&&a.end<c)&&d.push(a)}),d},z.shiftAnnotations=function(a,b,c){return a?(a.forEach(function(a){a.start>=b&&(a.start+=c,a.end+=c)}),a):a},z.sanitizeText=b,z}();
var joint={version:"0.9.5",dia:{},ui:{},layout:{},shapes:{},format:{},connectors:{},routers:{},util:{hashCode:function(a){var b=0;if(0==a.length)return b;for(var c=0;c<a.length;c++){var d=a.charCodeAt(c);b=(b<<5)-b+d,b&=b}return b},getByPath:function(a,b,c){c=c||"/";for(var d,e=b.split(c);e.length;){if(d=e.shift(),!(Object(a)===a&&d in a))return void 0;a=a[d]}return a},setByPath:function(a,b,c,d){d=d||"/";var e=b.split(d),f=a,g=0;if(b.indexOf(d)>-1){for(var h=e.length;h-1>g;g++)f=f[e[g]]||(f[e[g]]={});f[e[h-1]]=c}else a[b]=c;return a},unsetByPath:function(a,b,c){c=c||"/";var d=b.lastIndexOf(c);if(d>-1){var e=joint.util.getByPath(a,b.substr(0,d),c);e&&delete e[b.slice(d+1)]}else delete a[b];return a},flattenObject:function(a,b,c){b=b||"/";var d={};for(var e in a)if(a.hasOwnProperty(e)){var f="object"==typeof a[e];if(f&&c&&c(a[e])&&(f=!1),f){var g=this.flattenObject(a[e],b,c);for(var h in g)g.hasOwnProperty(h)&&(d[e+b+h]=g[h])}else d[e]=a[e]}return d},uuid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(a){var b=16*Math.random()|0,c="x"==a?b:3&b|8;return c.toString(16)})},guid:function(a){return this.guid.id=this.guid.id||1,a.id=void 0===a.id?"j_"+this.guid.id++:a.id,a.id},mixin:function(){for(var a=arguments[0],b=1,c=arguments.length;c>b;b++){var d=arguments[b];(Object(d)===d||_.isFunction(d)||null!==d&&void 0!==d)&&_.each(d,function(b,c){return this.mixin.deep&&Object(b)===b?(a[c]||(a[c]=_.isArray(b)?[]:{}),void this.mixin(a[c],b)):void(a[c]!==b&&(this.mixin.supplement&&a.hasOwnProperty(c)||(a[c]=b)))},this)}return a},supplement:function(){this.mixin.supplement=!0;var a=this.mixin.apply(this,arguments);return this.mixin.supplement=!1,a},deepMixin:function(){this.mixin.deep=!0;var a=this.mixin.apply(this,arguments);return this.mixin.deep=!1,a},deepSupplement:function(){this.mixin.deep=this.mixin.supplement=!0;var a=this.mixin.apply(this,arguments);return this.mixin.deep=this.mixin.supplement=!1,a},normalizeEvent:function(a){var b=a.originalEvent&&a.originalEvent.changedTouches&&a.originalEvent.changedTouches[0];if(b){for(var c in a)void 0===b[c]&&(b[c]=a[c]);return b}return a},nextFrame:function(){var a;if("undefined"!=typeof window&&(a=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame),!a){var b=0;a=function(a){var c=(new Date).getTime(),d=Math.max(0,16-(c-b)),e=setTimeout(function(){a(c+d)},d);return b=c+d,e}}return function(b,c){return a(c?_.bind(b,c):b)}}(),cancelFrame:function(){var a,b="undefined"!=typeof window;return b&&(a=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.webkitCancelRequestAnimationFrame||window.msCancelAnimationFrame||window.msCancelRequestAnimationFrame||window.oCancelAnimationFrame||window.oCancelRequestAnimationFrame||window.mozCancelAnimationFrame||window.mozCancelRequestAnimationFrame),a=a||clearTimeout,b?_.bind(a,window):a}(),shapePerimeterConnectionPoint:function(a,b,c,d){var e,f;if(!c){var h=b.$(".scalable")[0],i=b.$(".rotatable")[0];h&&h.firstChild?c=h.firstChild:i&&i.firstChild&&(c=i.firstChild)}return c?(f=V(c).findIntersection(d,a.paper.viewport),f||(e=g.rect(V(c).bbox(!1,a.paper.viewport)))):(e=b.model.getBBox(),f=e.intersectionWithLineFromCenterToPoint(d)),f||e.center()},breakText:function(a,b,c,d){d=d||{};var e=b.width,f=b.height,g=d.svgDocument||V("svg").node,h=V("<text><tspan></tspan></text>").attr(c||{}).node,i=h.firstChild,j=document.createTextNode("");i.appendChild(j),g.appendChild(h),d.svgDocument||document.body.appendChild(g);for(var k,l=a.split(" "),m=[],n=[],o=0,p=0,q=l.length;q>o;o++){var r=l[o];if(j.data=n[p]?n[p]+" "+r:r,i.getComputedTextLength()<=e)n[p]=j.data,k&&(m[p++]=!0,k=0);else{if(!n[p]||k){var s=!!k;if(k=r.length-1,s||!k){if(!k){if(!n[p]){n=[];break}l.splice(o,2,r+l[o+1]),q--,m[p++]=!0,o--;continue}l[o]=r.substring(0,k),l[o+1]=r.substring(k)+l[o+1]}else l.splice(o,1,r.substring(0,k),r.substring(k)),q++,p&&!m[p-1]&&p--;o--;continue}p++,o--}if("undefined"!=typeof f){var t=t||1.25*h.getBBox().height;if(t*n.length>f){n.splice(Math.floor(f/t));break}}}return d.svgDocument?g.removeChild(h):document.body.removeChild(g),n.join("\n")},imageToDataUri:function(a,b){if(!a||"data:"===a.substr(0,"data:".length))return setTimeout(function(){b(null,a)},0);var c=document.createElement("canvas"),d=document.createElement("img");d.onload=function(){var e=c.getContext("2d");c.width=d.width,c.height=d.height,e.drawImage(d,0,0);try{var f=(a.split(".").pop()||"png","jpeg"),g=c.toDataURL(f)}catch(h){if(/\.svg$/.test(a)){var i=window.XMLHttpRequest?new XMLHttpRequest:new ActiveXObject("Microsoft.XMLHTTP");i.open("GET",a,!1),i.send(null);var j=i.responseText;return b(null,"data:image/svg+xml,"+encodeURIComponent(j))}console.error(d.src,"fails to convert",h)}b(null,g)},d.ononerror=function(){b(new Error("Failed to load image."))},d.src=a},getElementBBox:function(a){var b,c=$(a),d=c.offset();if(a.ownerSVGElement){b=V(a).bbox();var e=a.getBoundingClientRect(),f=(e.width-b.width)/2,g=(e.height-b.height)/2;b.x=d.left+f,b.y=d.top+g}else b={x:d.left,y:d.top,width:c.outerWidth(),height:c.outerHeight()};return b},sortElements:function(a,b){var c=$(a),d=c.map(function(){var a=this,b=a.parentNode,c=b.insertBefore(document.createTextNode(""),a.nextSibling);return function(){if(b===this)throw new Error("You can't sort elements if any one is a descendant of another.");b.insertBefore(this,c),b.removeChild(c)}});return Array.prototype.sort.call(c,b).each(function(a){d[a].call(this)})},setAttributesBySelector:function(a,b){var c=$(a);_.each(b,function(a,b){var d=c.find(b).addBack().filter(b);_.has(a,"class")&&(d.addClass(a["class"]),a=_.omit(a,"class")),d.attr(a)})},normalizeSides:function(a){return Object(a)!==a?(a=a||0,{top:a,bottom:a,left:a,right:a}):{top:a.top||0,bottom:a.bottom||0,left:a.left||0,right:a.right||0}},timing:{linear:function(a){return a},quad:function(a){return a*a},cubic:function(a){return a*a*a},inout:function(a){if(0>=a)return 0;if(a>=1)return 1;var b=a*a,c=b*a;return 4*(.5>a?c:3*(a-b)+c-.75)},exponential:function(a){return Math.pow(2,10*(a-1))},bounce:function(a){for(var b=0,c=1;1;b+=c,c/=2)if(a>=(7-4*b)/11){var d=(11-6*b-11*a)/4;return-d*d+c*c}},reverse:function(a){return function(b){return 1-a(1-b)}},reflect:function(a){return function(b){return.5*(.5>b?a(2*b):2-a(2-2*b))}},clamp:function(a,b,c){return b=b||0,c=c||1,function(d){var e=a(d);return b>e?b:e>c?c:e}},back:function(a){return a||(a=1.70158),function(b){return b*b*((a+1)*b-a)}},elastic:function(a){return a||(a=1.5),function(b){return Math.pow(2,10*(b-1))*Math.cos(20*Math.PI*a/3*b)}}},interpolate:{number:function(a,b){var c=b-a;return function(b){return a+c*b}},object:function(a,b){var c=_.keys(a);return function(d){var e,f,g={};for(e=c.length-1;-1!=e;e--)f=c[e],g[f]=a[f]+(b[f]-a[f])*d;return g}},hexColor:function(a,b){var c=parseInt(a.slice(1),16),d=parseInt(b.slice(1),16),e=255&c,f=(255&d)-e,g=65280&c,h=(65280&d)-g,i=16711680&c,j=(16711680&d)-i;return function(a){var b=e+f*a&255,c=g+h*a&65280,d=i+j*a&16711680;return"#"+(1<<24|b|c|d).toString(16).slice(1)}},unit:function(a,b){var c=/(-?[0-9]*.[0-9]*)(px|em|cm|mm|in|pt|pc|%)/,d=c.exec(a),e=c.exec(b),f=e[1].indexOf("."),g=f>0?e[1].length-f-1:0;a=+d[1];var h=+e[1]-a,i=d[2];return function(b){return(a+h*b).toFixed(g)+i}}},filter:{outline:function(a){var b='<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology in="SourceAlpha" result="morphedOuter" operator="dilate" radius="${outerRadius}" /><feMorphology in="SourceAlpha" result="morphedInner" operator="dilate" radius="${innerRadius}" /><feComposite result="morphedOuterColored" in="colored" in2="morphedOuter" operator="in"/><feComposite operator="xor" in="morphedOuterColored" in2="morphedInner" result="outline"/><feMerge><feMergeNode in="outline"/><feMergeNode in="SourceGraphic"/></feMerge></filter>',c=_.isFinite(a.margin)?a.margin:2,d=_.isFinite(a.width)?a.width:1;return _.template(b)({color:a.color||"blue",opacity:_.isFinite(a.opacity)?a.opacity:1,outerRadius:c+d,innerRadius:c})},highlight:function(a){var b='<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology result="morphed" in="SourceGraphic" operator="dilate" radius="${width}"/><feComposite result="composed" in="colored" in2="morphed" operator="in"/><feGaussianBlur result="blured" in="composed" stdDeviation="${blur}"/><feBlend in="SourceGraphic" in2="blured" mode="normal"/></filter>';return _.template(b)({color:a.color||"red",width:_.isFinite(a.width)?a.width:1,blur:_.isFinite(a.blur)?a.blur:0,opacity:_.isFinite(a.opacity)?a.opacity:1})},blur:function(a){var b=_.isFinite(a.x)?a.x:2;return _.template('<filter><feGaussianBlur stdDeviation="${stdDeviation}"/></filter>')({stdDeviation:_.isFinite(a.y)?[b,a.y]:b})},dropShadow:function(a){var b="SVGFEDropShadowElement"in window?'<filter><feDropShadow stdDeviation="${blur}" dx="${dx}" dy="${dy}" flood-color="${color}" flood-opacity="${opacity}"/></filter>':'<filter><feGaussianBlur in="SourceAlpha" stdDeviation="${blur}"/><feOffset dx="${dx}" dy="${dy}" result="offsetblur"/><feFlood flood-color="${color}"/><feComposite in2="offsetblur" operator="in"/><feComponentTransfer><feFuncA type="linear" slope="${opacity}"/></feComponentTransfer><feMerge><feMergeNode/><feMergeNode in="SourceGraphic"/></feMerge></filter>';return _.template(b)({dx:a.dx||0,dy:a.dy||0,opacity:_.isFinite(a.opacity)?a.opacity:1,color:a.color||"black",blur:_.isFinite(a.blur)?a.blur:4})},grayscale:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${b} ${h} 0 0 0 0 0 1 0"/></filter>')({a:.2126+.7874*(1-b),b:.7152-.7152*(1-b),c:.0722-.0722*(1-b),d:.2126-.2126*(1-b),e:.7152+.2848*(1-b),f:.0722-.0722*(1-b),g:.2126-.2126*(1-b),h:.0722+.9278*(1-b)})},sepia:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${h} ${i} 0 0 0 0 0 1 0"/></filter>')({a:.393+.607*(1-b),b:.769-.769*(1-b),c:.189-.189*(1-b),d:.349-.349*(1-b),e:.686+.314*(1-b),f:.168-.168*(1-b),g:.272-.272*(1-b),h:.534-.534*(1-b),i:.131+.869*(1-b)})},saturate:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feColorMatrix type="saturate" values="${amount}"/></filter>')({amount:1-b})},hueRotate:function(a){return _.template('<filter><feColorMatrix type="hueRotate" values="${angle}"/></filter>')({angle:a.angle||0})},invert:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feComponentTransfer><feFuncR type="table" tableValues="${amount} ${amount2}"/><feFuncG type="table" tableValues="${amount} ${amount2}"/><feFuncB type="table" tableValues="${amount} ${amount2}"/></feComponentTransfer></filter>')({amount:b,amount2:1-b})},brightness:function(a){return _.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}"/><feFuncG type="linear" slope="${amount}"/><feFuncB type="linear" slope="${amount}"/></feComponentTransfer></filter>')({amount:_.isFinite(a.amount)?a.amount:1})},contrast:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}" intercept="${amount2}"/><feFuncG type="linear" slope="${amount}" intercept="${amount2}"/><feFuncB type="linear" slope="${amount}" intercept="${amount2}"/></feComponentTransfer></filter>')({amount:b,amount2:.5-b/2})}},format:{number:function(a,b,c){function d(a){for(var b=a.length,d=[],e=0,f=c.grouping[0];b>0&&f>0;)d.push(a.substring(b-=f,b+f)),f=c.grouping[e=(e+1)%c.grouping.length];return d.reverse().join(c.thousands)}c=c||{currency:["$",""],decimal:".",thousands:",",grouping:[3]};var e=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,f=e.exec(a),g=f[1]||" ",h=f[2]||">",i=f[3]||"",j=f[4]||"",k=f[5],l=+f[6],m=f[7],n=f[8],o=f[9],p=1,q="",r="",s=!1;switch(n&&(n=+n.substring(1)),(k||"0"===g&&"="===h)&&(k=g="0",h="=",m&&(l-=Math.floor((l-1)/4))),o){case"n":m=!0,o="g";break;case"%":p=100,r="%",o="f";break;case"p":p=100,r="%",o="r";break;case"b":case"o":case"x":case"X":"#"===j&&(q="0"+o.toLowerCase());case"c":case"d":s=!0,n=0;break;case"s":p=-1,o="r"}"$"===j&&(q=c.currency[0],r=c.currency[1]),"r"!=o||n||(o="g"),null!=n&&("g"==o?n=Math.max(1,Math.min(21,n)):("e"==o||"f"==o)&&(n=Math.max(0,Math.min(20,n))));var t=k&&m;if(s&&b%1)return"";var u=0>b||0===b&&0>1/b?(b=-b,"-"):i,v=r;if(0>p){var w=this.prefix(b,n);b=w.scale(b),v=w.symbol+r}else b*=p;b=this.convert(o,b,n);var x=b.lastIndexOf("."),y=0>x?b:b.substring(0,x),z=0>x?"":c.decimal+b.substring(x+1);!k&&m&&c.grouping&&(y=d(y));var A=q.length+y.length+z.length+(t?0:u.length),B=l>A?new Array(A=l-A+1).join(g):"";return t&&(y=d(B+y)),u+=q,b=y+z,("<"===h?u+b+B:">"===h?B+u+b:"^"===h?B.substring(0,A>>=1)+u+b+B.substring(A):u+(t?b:B+b))+v},string:function(a,b){for(var c,d="{",e=!1,f=[];-1!==(c=a.indexOf(d));){var g,h,i;if(g=a.slice(0,c),e){h=g.split(":"),i=h.shift().split("."),g=b;for(var j=0;j<i.length;j++)g=g[i[j]];h.length&&(g=this.number(h,g))}f.push(g),a=a.slice(c+1),d=(e=!e)?"}":"{"}return f.push(a),f.join("")},convert:function(a,b,c){switch(a){case"b":return b.toString(2);case"c":return String.fromCharCode(b);case"o":return b.toString(8);case"x":return b.toString(16);case"X":return b.toString(16).toUpperCase();case"g":return b.toPrecision(c);case"e":return b.toExponential(c);case"f":return b.toFixed(c);case"r":return(b=this.round(b,this.precision(b,c))).toFixed(Math.max(0,Math.min(20,this.precision(b*(1+1e-15),c))));default:return b+""}},round:function(a,b){return b?Math.round(a*(b=Math.pow(10,b)))/b:Math.round(a)},precision:function(a,b){return b-(a?Math.ceil(Math.log(a)/Math.LN10):1)},prefix:function(a,b){var c=_.map(["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"],function(a,b){var c=Math.pow(10,3*Math.abs(8-b));return{scale:b>8?function(a){return a/c}:function(a){return a*c},symbol:a}}),d=0;return a&&(0>a&&(a*=-1),b&&(a=this.round(a,this.precision(a,b))),d=1+Math.floor(1e-12+Math.log(a)/Math.LN10),d=Math.max(-24,Math.min(24,3*Math.floor((0>=d?d+1:d-1)/3)))),c[8+d/3]}}}};joint.dia.GraphCells=Backbone.Collection.extend({cellNamespace:joint.shapes,initialize:function(a,b){this.on("change:z",this.sort,this),b.cellNamespace&&(this.cellNamespace=b.cellNamespace)},model:function(a,b){var c=b.collection.cellNamespace,d="link"===a.type?joint.dia.Link:joint.util.getByPath(c,a.type,".")||joint.dia.Element;return new d(a,b)},comparator:function(a){return a.get("z")||0},getConnectedLinks:function(a,b){b=b||{},_.isUndefined(b.inbound)&&_.isUndefined(b.outbound)&&(b.inbound=b.outbound=!0);var c=this.filter(function(c){if(!c.isLink())return!1;var d=c.get("source"),e=c.get("target");return d&&d.id===a.id&&b.outbound||e&&e.id===a.id&&b.inbound});if(b.deep){var d=a.getEmbeddedCells({deep:!0});_.each(this.difference(c,d),function(a){if(a.isLink()){if(b.outbound){var e=a.get("source");if(e&&e.id&&_.find(d,{id:e.id}))return void c.push(a)}if(b.inbound){var f=a.get("target");f&&f.id&&_.find(d,{id:f.id})&&c.push(a)}}})}return c},getNeighbors:function(a,b){b=b||{};var c=_.transform(this.getConnectedLinks(a,b),function(c,d){var e=d.get("source"),f=d.get("target"),g=d.hasLoop(b);if(b.inbound&&_.has(e,"id")&&!c[e.id]){var h=this.get(e.id);!g&&(h===a||b.deep&&h.isEmbeddedIn(a))||(c[e.id]=h)}if(b.outbound&&_.has(f,"id")&&!c[f.id]){var i=this.get(f.id);!g&&(i===a||b.deep&&i.isEmbeddedIn(a))||(c[f.id]=i)}},{},this);return _.values(c)},getCommonAncestor:function(){var a=_.map(arguments,function(a){for(var b=[a.id],c=a.get("parent");c;)b.push(c),c=this.get(c).get("parent");return b},this);a=_.sortBy(a,"length");var b=_.find(a.shift(),function(b){return _.every(a,function(a){return _.contains(a,b)})});return this.get(b)},getBBox:function(a){a=a||this.models;var b={x:1/0,y:1/0},c={x:-(1/0),y:-(1/0)};return _.each(a,function(a){if(!a.isLink()){var d=a.getBBox();b.x=Math.min(b.x,d.x),b.y=Math.min(b.y,d.y),c.x=Math.max(c.x,d.x+d.width),c.y=Math.max(c.y,d.y+d.height)}}),g.rect(b.x,b.y,c.x-b.x,c.y-b.y)}}),joint.dia.Graph=Backbone.Model.extend({initialize:function(a,b){b=b||{},Backbone.Model.prototype.set.call(this,"cells",new joint.dia.GraphCells([],{model:b.cellModel,cellNamespace:b.cellNamespace})),this.get("cells").on("all",this.trigger,this),this.get("cells").on("remove",this._removeCell,this)},toJSON:function(){var a=Backbone.Model.prototype.toJSON.apply(this,arguments);return a.cells=this.get("cells").toJSON(),a},fromJSON:function(a,b){if(!a.cells)throw new Error("Graph JSON must contain cells array.");return this.set(a,b)},set:function(a,b,c){var d;return"object"==typeof a?(d=a,c=b):(d={})[a]=b,d.hasOwnProperty("cells")&&(this.resetCells(d.cells,c),d=_.omit(d,"cells")),Backbone.Model.prototype.set.call(this,d,c)},clear:function(a){a=_.extend({},a,{clear:!0});var b=this.get("cells");if(0===b.length)return this;this.trigger("batch:start",{batchName:"clear"});var c=b.sortBy(function(a){return a.isLink()?1:2});do c.shift().remove(a);while(c.length>0);return this.trigger("batch:stop",{batchName:"clear"}),this},_prepareCell:function(a){var b=a instanceof Backbone.Model?a.attributes:a;if(_.isUndefined(b.z)&&(b.z=this.maxZIndex()+1),!_.isString(b.type))throw new TypeError("dia.Graph: cell type must be a string.");return a},maxZIndex:function(){var a=this.get("cells").last();return a?a.get("z")||0:0},addCell:function(a,b){return _.isArray(a)?this.addCells(a,b):(this.get("cells").add(this._prepareCell(a),b||{}),this)},addCells:function(a,b){return b=b||{},b.position=a.length,_.each(a,function(a){b.position--,this.addCell(a,b)},this),this},resetCells:function(a,b){return this.get("cells").reset(_.map(a,this._prepareCell,this),b),this},_removeCell:function(a,b,c){c=c||{},c.clear||(c.disconnectLinks?this.disconnectLinks(a,c):this.removeLinks(a,c)),this.get("cells").remove(a,{silent:!0})},getCell:function(a){return this.get("cells").get(a)},getCells:function(){return this.get("cells").toArray()},getElements:function(){return this.get("cells").filter(function(a){return a instanceof joint.dia.Element})},getLinks:function(){return this.get("cells").filter(function(a){return a instanceof joint.dia.Link})},getConnectedLinks:function(a,b){return this.get("cells").getConnectedLinks(a,b)},getNeighbors:function(a,b){return this.get("cells").getNeighbors(a,b)},disconnectLinks:function(a,b){_.each(this.getConnectedLinks(a),function(c){c.set(c.get("source").id===a.id?"source":"target",g.point(0,0),b)})},removeLinks:function(a,b){_.invoke(this.getConnectedLinks(a),"remove",b)},findModelsFromPoint:function(a){return _.filter(this.getElements(),function(b){return b.getBBox().containsPoint(a)})},findModelsInArea:function(a){return _.filter(this.getElements(),function(b){return b.getBBox().intersect(a)})},findModelsUnderElement:function(a,b){b=_.defaults(b||{},{searchBy:"bbox"});var c=a.getBBox(),d="bbox"==b.searchBy?this.findModelsInArea(c):this.findModelsFromPoint(c[b.searchBy]());return _.reject(d,function(b){return a.id==b.id||b.isEmbeddedIn(a)})},getBBox:function(){var a=this.get("cells");return a.getBBox.apply(a,arguments)},getCommonAncestor:function(){var a=this.get("cells");return a.getCommonAncestor.apply(a,arguments)}}),joint.dia.Cell=Backbone.Model.extend({constructor:function(a,b){var c,d=a||{};this.cid=_.uniqueId("c"),this.attributes={},b&&b.collection&&(this.collection=b.collection),b&&b.parse&&(d=this.parse(d,b)||{}),(c=_.result(this,"defaults"))&&(d=_.merge({},c,d)),this.set(d,b),this.changed={},this.initialize.apply(this,arguments)},toJSON:function(){var a=this.constructor.prototype.defaults.attrs||{},b=this.attributes.attrs,c={};_.each(b,function(b,d){var e=a[d];_.each(b,function(a,b){_.isObject(a)&&!_.isArray(a)?_.each(a,function(a,f){e&&e[b]&&_.isEqual(e[b][f],a)||(c[d]=c[d]||{},(c[d][b]||(c[d][b]={}))[f]=a)}):e&&_.isEqual(e[b],a)||(c[d]=c[d]||{},c[d][b]=a)})});var d=_.cloneDeep(_.omit(this.attributes,"attrs"));return d.attrs=c,d},initialize:function(a){a&&a.id||this.set("id",joint.util.uuid(),{silent:!0}),this._transitionIds={},this.processPorts(),this.on("change:attrs",this.processPorts,this)},processPorts:function(){var a=this.ports,b={};_.each(this.get("attrs"),function(a,c){a&&a.port&&(_.isUndefined(a.port.id)?b[a.port]={id:a.port}:b[a.port.id]=a.port)});var c={};if(_.each(a,function(a,d){b[d]||(c[d]=!0)}),this.collection&&!_.isEmpty(c)){var d=this.collection.getConnectedLinks(this,{inbound:!0});_.each(d,function(a){c[a.get("target").port]&&a.remove()});var e=this.collection.getConnectedLinks(this,{outbound:!0});_.each(e,function(a){c[a.get("source").port]&&a.remove()})}this.ports=b},remove:function(a){a=a||{};var b=this.collection;b&&b.trigger("batch:start",{batchName:"remove"});var c=this.get("parent");if(c){var d=this.collection&&this.collection.get(c);d.unembed(this)}return _.invoke(this.getEmbeddedCells(),"remove",a),this.trigger("remove",this,this.collection,a),b&&b.trigger("batch:stop",{batchName:"remove"}),this},toFront:function(a){if(this.collection){a=a||{};var b=(this.collection.last().get("z")||0)+1;if(this.trigger("batch:start",{batchName:"to-front"}).set("z",b,a),a.deep){var c=this.getEmbeddedCells({deep:!0,breadthFirst:!0});_.each(c,function(c){c.set("z",++b,a)})}this.trigger("batch:stop",{batchName:"to-front"})}return this},toBack:function(a){if(this.collection){a=a||{};var b=(this.collection.first().get("z")||0)-1;if(this.trigger("batch:start",{batchName:"to-back"}),a.deep){var c=this.getEmbeddedCells({deep:!0,breadthFirst:!0});_.eachRight(c,function(c){c.set("z",b--,a)})}this.set("z",b,a).trigger("batch:stop",{batchName:"to-back"})}return this},embed:function(a,b){if(this===a||this.isEmbeddedIn(a))throw new Error("Recursive embedding not allowed.");this.trigger("batch:start",{batchName:"embed"});var c=_.clone(this.get("embeds")||[]);return c[a.isLink()?"unshift":"push"](a.id),a.set("parent",this.id,b),this.set("embeds",_.uniq(c),b),this.trigger("batch:stop",{batchName:"embed"}),this},unembed:function(a,b){return this.trigger("batch:start",{batchName:"unembed"}),a.unset("parent",b),this.set("embeds",_.without(this.get("embeds"),a.id),b),this.trigger("batch:stop",{batchName:"unembed"}),this},getAncestors:function(){var a=[],b=this.get("parent");if(void 0===this.collection)return a;for(;void 0!==b;){var c=this.collection.get(b);if(void 0===c)break;a.push(c),b=c.get("parent")}return a},getEmbeddedCells:function(a){if(a=a||{},this.collection){var b;if(a.deep)if(a.breadthFirst){b=[];for(var c=this.getEmbeddedCells();c.length>0;){var d=c.shift();b.push(d),c.push.apply(c,d.getEmbeddedCells())}}else b=this.getEmbeddedCells(),_.each(b,function(c){b.push.apply(b,c.getEmbeddedCells(a))});else b=_.map(this.get("embeds"),this.collection.get,this.collection);return b}return[]},isEmbeddedIn:function(a,b){var c=_.isString(a)?a:a.id,d=this.get("parent");if(b=_.defaults({deep:!0},b),this.collection&&b.deep){for(;d;){if(d===c)return!0;d=this.collection.get(d).get("parent")}return!1}return d===c},clone:function(a){a=a||{};var b=Backbone.Model.prototype.clone.apply(this,arguments);if(b.set("id",joint.util.uuid(),{silent:!0}),b.set("embeds",""),!a.deep)return b;var c=_.sortBy(this.getEmbeddedCells(),function(a){return a instanceof joint.dia.Element}),d=[b],e={};return _.each(c,function(a){var c=a.clone({deep:!0});b.embed(c[0]),_.each(c,function(c){if(c instanceof joint.dia.Link)return c.get("source").id===this.id&&c.prop("source",{id:b.id}),c.get("target").id===this.id&&c.prop("target",{id:b.id}),void(e[a.id]=c);d.push(c);var f=this.collection.getConnectedLinks(a,{inbound:!0});_.each(f,function(a){var b=e[a.id]||a.clone();e[a.id]=b,b.prop("target",{id:c.id})});var g=this.collection.getConnectedLinks(a,{outbound:!0});_.each(g,function(a){var b=e[a.id]||a.clone();e[a.id]=b,b.prop("source",{id:c.id})})},this)},this),d=d.concat(_.values(e))},prop:function(a,b,c){var d="/";if(_.isString(a)){if(arguments.length>1){var e=a,f=e.split("/"),g=f[0];if(f.shift(),c=c||{},c.propertyPath=e,c.propertyValue=b,0===f.length)return this.set(g,b,c);var h={},i=h,j=g;_.each(f,function(a){i=i[j]=_.isFinite(Number(a))?[]:{},j=a}),h=joint.util.setByPath(h,e,b,"/");var k=_.merge({},this.attributes);c.rewrite&&joint.util.unsetByPath(k,e,"/");var l=_.merge(k,h);return this.set(g,l[g],c)}return joint.util.getByPath(this.attributes,a,d)}return this.set(_.merge({},this.attributes,a),b)},removeProp:function(a,b){b=b||{},b.dirty=!0;var c=a.split("/");if(1===c.length)return this.unset(a,b);var d=c[0],e=c.slice(1).join("/"),f=_.merge({},this.get(d));return joint.util.unsetByPath(f,e,"/"),this.set(d,f,b)},attr:function(a,b,c){var d=Array.prototype.slice.call(arguments);return _.isString(a)?d[0]="attrs/"+a:d[0]={attrs:a},this.prop.apply(this,d)},removeAttr:function(a,b){return _.isArray(a)?(_.each(a,function(a){this.removeAttr(a,b)},this),this):this.removeProp("attrs/"+a,b)},transition:function(a,b,c,d){d=d||"/";var e={duration:100,delay:10,timingFunction:joint.util.timing.linear,valueFunction:joint.util.interpolate.number};c=_.extend(e,c);var f,g=0,h=_.bind(function(b){var d,e,i;g=g||b,b-=g,e=b/c.duration,1>e?this._transitionIds[a]=d=joint.util.nextFrame(h):(e=1,delete this._transitionIds[a]),i=f(c.timingFunction(e)),c.transitionId=d,this.prop(a,i,c),d||this.trigger("transition:end",this,a)},this),i=_.bind(function(e){this.stopTransitions(a),f=c.valueFunction(joint.util.getByPath(this.attributes,a,d),b),this._transitionIds[a]=joint.util.nextFrame(e),this.trigger("transition:start",this,a)},this);return _.delay(i,c.delay,h)},getTransitions:function(){return _.keys(this._transitionIds)},stopTransitions:function(a,b){b=b||"/";var c=a&&a.split(b);return _(this._transitionIds).keys().filter(c&&function(a){return _.isEqual(c,a.split(b).slice(0,c.length))}).each(function(a){joint.util.cancelFrame(this._transitionIds[a]),delete this._transitionIds[a],this.trigger("transition:end",this,a)},this),this},addTo:function(a,b){return a.addCell(this,b),this},findView:function(a){return a.findViewByModel(this)},isLink:function(){return!1}}),joint.dia.CellView=Backbone.View.extend({tagName:"g",attributes:function(){return{"model-id":this.model.id}},constructor:function(a){this._configure(a),Backbone.View.apply(this,arguments)},_configure:function(a){this.options&&(a=_.extend({},_.result(this,"options"),a)),this.options=a,this.options.id=this.options.id||joint.util.guid(this)},initialize:function(){_.bindAll(this,"remove","update"),this.$el.data("view",this),this.listenTo(this.model,"change:attrs",this.onChangeAttrs)},onChangeAttrs:function(a,b,c){return c.dirty?this.render():this.update()},_ensureElement:function(){var a;if(this.el)a=_.result(this,"el");else{var b=_.extend({id:this.id},_.result(this,"attributes"));this.className&&(b["class"]=_.result(this,"className")),a=V(_.result(this,"tagName"),b).node}this.setElement(a,!1)},_setElement:function(a){this.$el=a instanceof Backbone.$?a:Backbone.$(a),this.el=this.$el[0],this.vel=V(this.el)},findBySelector:function(a){var b="."===a?this.$el:this.$el.find(a);return b},notify:function(a){if(this.paper){var b=Array.prototype.slice.call(arguments,1);this.trigger.apply(this,[a].concat(b)),this.paper.trigger.apply(this.paper,[a,this].concat(b))}},getStrokeBBox:function(a){var b=!!a;a=a||this.el;var c,d=V(a).bbox(!1,this.paper.viewport);return c=b?V(a).attr("stroke-width"):this.model.attr("rect/stroke-width")||this.model.attr("circle/stroke-width")||this.model.attr("ellipse/stroke-width")||this.model.attr("path/stroke-width"),c=parseFloat(c)||0,g.rect(d).moveAndExpand({x:-c/2,y:-c/2,width:c,height:c})},getBBox:function(){return g.rect(this.vel.bbox())},highlight:function(a,b){return a=a?this.$(a)[0]||this.el:this.el,b=b||{},b.partial=a!=this.el,this.notify("cell:highlight",a,b),this},unhighlight:function(a,b){return a=a?this.$(a)[0]||this.el:this.el,b=b||{},b.partial=a!=this.el,this.notify("cell:unhighlight",a,b),this},findMagnet:function(a){var b=this.$(a);if(0===b.length||b[0]===this.el){var c=this.model.get("attrs")||{};return c["."]&&c["."].magnet===!1?void 0:this.el}return b.attr("magnet")?b[0]:this.findMagnet(b.parent())},applyFilter:function(a,b){var c=_.isString(a)?this.findBySelector(a):$(a),d=b.name+this.paper.svg.id+joint.util.hashCode(JSON.stringify(b));if(!this.paper.svg.getElementById(d)){var e=joint.util.filter[b.name]&&joint.util.filter[b.name](b.args||{});if(!e)throw new Error("Non-existing filter "+b.name);var f=V(e);f.attr({filterUnits:"objectBoundingBox",x:-1,y:-1,width:3,height:3}),b.attrs&&f.attr(b.attrs),f.node.id=d,V(this.paper.svg).defs().append(f)}c.each(function(){V(this).attr("filter","url(#"+d+")")})},applyGradient:function(a,b,c){var d=_.isString(a)?this.findBySelector(a):$(a),e=c.type+this.paper.svg.id+joint.util.hashCode(JSON.stringify(c));if(!this.paper.svg.getElementById(e)){var f=["<"+c.type+">",_.map(c.stops,function(a){return'<stop offset="'+a.offset+'" stop-color="'+a.color+'" stop-opacity="'+(_.isFinite(a.opacity)?a.opacity:1)+'" />'}).join(""),"</"+c.type+">"].join(""),g=V(f);c.attrs&&g.attr(c.attrs),g.node.id=e,V(this.paper.svg).defs().append(g)}d.each(function(){V(this).attr(b,"url(#"+e+")")})},getSelector:function(a,b){if(a===this.el)return b;var c=V(a).index()+1,d=a.tagName+":nth-child("+c+")";return b&&(d+=" > "+b),this.getSelector(a.parentNode,d)},pointerdblclick:function(a,b,c){this.notify("cell:pointerdblclick",a,b,c)},pointerclick:function(a,b,c){this.notify("cell:pointerclick",a,b,c)},pointerdown:function(a,b,c){this.model.collection&&(this.model.trigger("batch:start",{batchName:"pointer"}),this._collection=this.model.collection),this.notify("cell:pointerdown",a,b,c)},pointermove:function(a,b,c){this.notify("cell:pointermove",a,b,c)},pointerup:function(a,b,c){this.notify("cell:pointerup",a,b,c),this._collection&&(this._collection.trigger("batch:stop",{batchName:"pointer"}),delete this._collection)},mouseover:function(a){this.notify("cell:mouseover",a)},mouseout:function(a){this.notify("cell:mouseout",a)},contextmenu:function(a,b,c){this.notify("cell:contextmenu",a,b,c)}}),joint.dia.Element=joint.dia.Cell.extend({defaults:{position:{x:0,y:0},size:{width:1,height:1},angle:0},position:function(a,b,c){var d=_.isNumber(b);if(c=(d?c:a)||{},c.parentRelative){if(!this.collection)throw new Error("Element must be part of a collection.");var e=this.collection.get(this.get("parent")),f=e&&!e.isLink()?e.get("position"):{x:0,y:0}}if(d)return c.parentRelative&&(a+=f.x,b+=f.y),this.set("position",{x:a,y:b},c);var h=g.point(this.get("position"));return c.parentRelative?h.difference(f):h},translate:function(a,b,c){if(a=a||0,b=b||0,0===a&&0===b)return this;c=c||{},c.translateBy=c.translateBy||this.id;var d=this.get("position")||{x:0,y:0};if(c.restrictedArea&&c.translateBy===this.id){var e=this.getBBox({deep:!0}),f=c.restrictedArea,g=d.x-e.x,h=d.y-e.y,i=Math.max(f.x+g,Math.min(f.x+f.width+g-e.width,d.x+a)),j=Math.max(f.y+h,Math.min(f.y+f.height+h-e.height,d.y+b));a=i-d.x,b=j-d.y}var k={x:d.x+a,y:d.y+b};return c.tx=a,c.ty=b,c.transition?(_.isObject(c.transition)||(c.transition={}),this.transition("position",k,_.extend({},c.transition,{valueFunction:joint.util.interpolate.object}))):(this.set("position",k,c),_.invoke(this.getEmbeddedCells(),"translate",a,b,c)),this},resize:function(a,b,c){return this.trigger("batch:start",{batchName:"resize"}),this.set("size",{width:a,height:b},c),this.trigger("batch:stop",{batchName:"resize"}),this},fitEmbeds:function(a){a=a||{};var b=this.collection;if(!b)throw new Error("Element must be part of a collection.");var c=this.getEmbeddedCells();if(c.length>0){this.trigger("batch:start",{batchName:"fit-embeds"}),a.deep&&_.invoke(c,"fitEmbeds",a);var d=b.getBBox(c),e=joint.util.normalizeSides(a.padding);d.moveAndExpand({x:-e.left,y:-e.top,width:e.right+e.left,height:e.bottom+e.top}),this.set({position:{x:d.x,y:d.y},size:{width:d.width,
height:d.height}},a),this.trigger("batch:stop",{batchName:"fit-embeds"})}return this},rotate:function(a,b,c){if(c){var d=this.getBBox().center(),e=this.get("size"),f=this.get("position");d.rotate(c,this.get("angle")-a);var g=d.x-e.width/2-f.x,h=d.y-e.height/2-f.y;this.trigger("batch:start",{batchName:"rotate"}),this.translate(g,h),this.rotate(a,b),this.trigger("batch:stop",{batchName:"rotate"})}else this.set("angle",b?a:(this.get("angle")+a)%360);return this},getBBox:function(a){if(a=a||{},a.deep&&this.collection){var b=this.getEmbeddedCells({deep:!0,breadthFirst:!0});return b.push(this),this.collection.getBBox(b)}var c=this.get("position"),d=this.get("size");return g.rect(c.x,c.y,d.width,d.height)}}),joint.dia.ElementView=joint.dia.CellView.extend({SPECIAL_ATTRIBUTES:["style","text","html","ref-x","ref-y","ref-dx","ref-dy","ref-width","ref-height","ref","x-alignment","y-alignment","port"],className:function(){return"element "+this.model.get("type").replace("."," ","g")},initialize:function(){_.bindAll(this,"translate","resize","rotate"),joint.dia.CellView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"change:position",this.translate),this.listenTo(this.model,"change:size",this.resize),this.listenTo(this.model,"change:angle",this.rotate)},update:function(a,b){var c=this.model.get("attrs"),d=this.rotatableNode;if(d){var e=d.attr("transform");d.attr("transform","")}var f=[],g={};_.each(b||c,function(a,b){var c=this.findBySelector(b);if(0!==c.length){g[b]=c;var d=this.SPECIAL_ATTRIBUTES.slice();_.isObject(a.filter)&&(d.push("filter"),this.applyFilter(c,a.filter)),_.isObject(a.fill)&&(d.push("fill"),this.applyGradient(c,"fill",a.fill)),_.isObject(a.stroke)&&(d.push("stroke"),this.applyGradient(c,"stroke",a.stroke)),_.isUndefined(a.text)||(c.each(function(){V(this).text(a.text+"",{lineHeight:a.lineHeight,textPath:a.textPath,annotations:a.annotations})}),d.push("lineHeight","textPath","annotations"));var e=_.omit(a,d);c.each(function(){V(this).attr(e)}),a.port&&c.attr("port",_.isUndefined(a.port.id)?a.port:a.port.id),a.style&&c.css(a.style),_.isUndefined(a.html)||c.each(function(){$(this).html(a.html+"")}),_.isUndefined(a["ref-x"])&&_.isUndefined(a["ref-y"])&&_.isUndefined(a["ref-dx"])&&_.isUndefined(a["ref-dy"])&&_.isUndefined(a["x-alignment"])&&_.isUndefined(a["y-alignment"])&&_.isUndefined(a["ref-width"])&&_.isUndefined(a["ref-height"])||_.each(c,function(a,b,c){var d=$(a);d.selector=c.selector,f.push(d)})}},this);var h=this.model.get("size"),i={x:0,y:0,width:h.width,height:h.height};b=b||{},_.each(f,function(a){var d=b[a.selector],e=d?_.merge({},c[a.selector],d):c[a.selector];this.positionRelative(V(a[0]),i,e,g)},this),d&&d.attr("transform",e||"")},positionRelative:function(a,b,c,d){var e=c.ref,f=parseFloat(c["ref-dx"]),g=parseFloat(c["ref-dy"]),h=c["y-alignment"],i=c["x-alignment"],j=c["ref-y"],k=_.isString(j)&&"%"===j.slice(-1);j=parseFloat(j),k&&(j/=100);var l=c["ref-x"],m=_.isString(l)&&"%"===l.slice(-1);l=parseFloat(l),m&&(l/=100);var n=c["ref-width"],o=_.isString(n)&&"%"===n.slice(-1);n=parseFloat(n),o&&(n/=100);var p=c["ref-height"],q=_.isString(p)&&"%"===p.slice(-1);p=parseFloat(p),q&&(p/=100);var r=a.findParentByClass("scalable",this.el);if(e){var s;if(s=d&&d[e]?V(d[e][0]):"."===e?this.vel:this.vel.findOne(e),!s)throw new Error("dia.ElementView: reference does not exists.");b=s.bbox(!1,this.el)}a.attr("transform")&&a.attr("transform",a.attr("transform").replace(/translate\([^)]*\)/g,"").trim()||""),isFinite(n)&&(o||n>=0&&1>=n?a.attr("width",n*b.width):a.attr("width",Math.max(n+b.width,0))),isFinite(p)&&(q||p>=0&&1>=p?a.attr("height",p*b.height):a.attr("height",Math.max(p+b.height,0)));var t,u=0,v=0;if(isFinite(f)&&(r?(t=t||r.scale(),u=b.x+b.width+f/t.sx):u=b.x+b.width+f),isFinite(g)&&(r?(t=t||r.scale(),v=b.y+b.height+g/t.sy):v=b.y+b.height+g),isFinite(l)&&(m||l>0&&1>l?u=b.x+b.width*l:r?(t=t||r.scale(),u=b.x+l/t.sx):u=b.x+l),isFinite(j)&&(m||j>0&&1>j?v=b.y+b.height*j:r?(t=t||r.scale(),v=b.y+j/t.sy):v=b.y+j),!_.isUndefined(h)||!_.isUndefined(i)){var w=a.bbox(!1,this.paper.viewport);"middle"===h?v-=w.height/2:isFinite(h)&&(v+=h>-1&&1>h?w.height*h:h),"middle"===i?u-=w.width/2:isFinite(i)&&(u+=i>-1&&1>i?w.width*i:i)}a.translate(u,v)},renderMarkup:function(){var a=this.model.get("markup")||this.model.markup;if(!a)throw new Error("properties.markup is missing while the default render() implementation is used.");var b=V(a);this.vel.append(b)},render:function(){return this.$el.empty(),this.renderMarkup(),this.rotatableNode=this.vel.findOne(".rotatable"),this.scalableNode=this.vel.findOne(".scalable"),this.update(),this.resize(),this.rotate(),this.translate(),this},scale:function(a,b){this.vel.scale(a,b)},resize:function(){var a=this.model.get("size")||{width:1,height:1},b=this.model.get("angle")||0,c=this.scalableNode;if(c){var d=c.bbox(!0);c.attr("transform","scale("+a.width/(d.width||1)+","+a.height/(d.height||1)+")");var e=this.rotatableNode,f=e&&e.attr("transform");if(f&&"null"!==f){e.attr("transform",f+" rotate("+-b+","+a.width/2+","+a.height/2+")");var g=c.bbox(!1,this.paper.viewport);this.model.set("position",{x:g.x,y:g.y}),this.rotate()}this.update()}},translate:function(a,b,c){var d=this.model.get("position")||{x:0,y:0};this.vel.attr("transform","translate("+d.x+","+d.y+")")},rotate:function(){var a=this.rotatableNode;if(a){var b=this.model.get("angle")||0,c=this.model.get("size")||{width:1,height:1},d=c.width/2,e=c.height/2;a.attr("transform","rotate("+b+","+d+","+e+")")}},getBBox:function(a){if(a&&a.useModelGeometry){var b=this.model.getBBox().bbox(this.model.get("angle")),c=this.paper.viewport.getCTM();return g.rect(V.transformRect(b,c))}return joint.dia.CellView.prototype.getBBox.apply(this,arguments)},prepareEmbedding:function(a){a=a||{};var b=a.model||this.model,c=a.paper||this.paper;b.toFront({deep:!0,ui:!0}),_.invoke(c.model.getConnectedLinks(b,{deep:!0}),"toFront",{ui:!0});var d=b.get("parent");d&&c.model.getCell(d).unembed(b,{ui:!0})},processEmbedding:function(a){a=a||{};var b=a.model||this.model,c=a.paper||this.paper,d=c.options,e=c.model.findModelsUnderElement(b,{searchBy:d.findParentBy});d.frontParentOnly&&(e=e.slice(-1));for(var f=null,g=this._candidateEmbedView,h=e.length-1;h>=0;h--){var i=e[h];if(g&&g.model.id==i.id){f=g;break}var j=i.findView(c);if(d.validateEmbedding.call(c,this,j)){f=j;break}}f&&f!=g&&(g&&g.unhighlight(null,{embedding:!0}),this._candidateEmbedView=f.highlight(null,{embedding:!0})),!f&&g&&(g.unhighlight(null,{embedding:!0}),delete this._candidateEmbedView)},finalizeEmbedding:function(a){a=a||{};var b=this._candidateEmbedView,c=a.model||this.model,d=a.paper||this.paper;b&&(b.model.embed(c,{ui:!0}),b.unhighlight(null,{embedding:!0}),delete this._candidateEmbedView),_.invoke(d.model.getConnectedLinks(c,{deep:!0}),"reparent",{ui:!0})},pointerdown:function(a,b,c){var d=this.paper;if(a.target.getAttribute("magnet")&&d.options.validateMagnet.call(d,this,a.target)){this.model.trigger("batch:start",{batchName:"add-link"});var e=d.getDefaultLink(this,a.target);e.set({source:{id:this.model.id,selector:this.getSelector(a.target),port:a.target.getAttribute("port")},target:{x:b,y:c}}),d.model.addCell(e),this._linkView=d.findViewByModel(e),this._linkView.pointerdown(a,b,c),this._linkView.startArrowheadMove("target")}else this._dx=b,this._dy=c,this.restrictedArea=d.getRestrictedArea(this),joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("element:pointerdown",a,b,c)},pointermove:function(a,b,c){if(this._linkView)this._linkView.pointermove(a,b,c);else{var d=this.paper.options.gridSize,e=_.isFunction(this.options.interactive)?this.options.interactive(this,"pointermove"):this.options.interactive;if(e!==!1){var f=this.model.get("position"),h=g.snapToGrid(f.x,d)-f.x+g.snapToGrid(b-this._dx,d),i=g.snapToGrid(f.y,d)-f.y+g.snapToGrid(c-this._dy,d);this.model.translate(h,i,{restrictedArea:this.restrictedArea,ui:!0}),this.paper.options.embeddingMode&&(this._inProcessOfEmbedding||(this.prepareEmbedding(),this._inProcessOfEmbedding=!0),this.processEmbedding())}this._dx=g.snapToGrid(b,d),this._dy=g.snapToGrid(c,d),joint.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("element:pointermove",a,b,c)}},pointerup:function(a,b,c){if(this._linkView){var d=this._linkView,e=d.model;d.pointerup(a,b,c),this.paper.options.linkPinning||_.has(e.get("target"),"id")||e.remove({ui:!0}),delete this._linkView,this.model.trigger("batch:stop",{batchName:"add-link"})}else this._inProcessOfEmbedding&&(this.finalizeEmbedding(),this._inProcessOfEmbedding=!1),this.notify("element:pointerup",a,b,c),joint.dia.CellView.prototype.pointerup.apply(this,arguments)}}),joint.dia.Link=joint.dia.Cell.extend({markup:['<path class="connection" stroke="black"/>','<path class="marker-source" fill="black" stroke="black" />','<path class="marker-target" fill="black" stroke="black" />','<path class="connection-wrap"/>','<g class="labels"/>','<g class="marker-vertices"/>','<g class="marker-arrowheads"/>','<g class="link-tools"/>'].join(""),labelMarkup:['<g class="label">',"<rect />","<text />","</g>"].join(""),toolMarkup:['<g class="link-tool">','<g class="tool-remove" event="remove">','<circle r="11" />','<path transform="scale(.8) translate(-16, -16)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z"/>',"<title>Remove link.</title>","</g>",'<g class="tool-options" event="link:options">','<circle r="11" transform="translate(25)"/>','<path fill="white" transform="scale(.55) translate(29, -16)" d="M31.229,17.736c0.064-0.571,0.104-1.148,0.104-1.736s-0.04-1.166-0.104-1.737l-4.377-1.557c-0.218-0.716-0.504-1.401-0.851-2.05l1.993-4.192c-0.725-0.91-1.549-1.734-2.458-2.459l-4.193,1.994c-0.647-0.347-1.334-0.632-2.049-0.849l-1.558-4.378C17.165,0.708,16.588,0.667,16,0.667s-1.166,0.041-1.737,0.105L12.707,5.15c-0.716,0.217-1.401,0.502-2.05,0.849L6.464,4.005C5.554,4.73,4.73,5.554,4.005,6.464l1.994,4.192c-0.347,0.648-0.632,1.334-0.849,2.05l-4.378,1.557C0.708,14.834,0.667,15.412,0.667,16s0.041,1.165,0.105,1.736l4.378,1.558c0.217,0.715,0.502,1.401,0.849,2.049l-1.994,4.193c0.725,0.909,1.549,1.733,2.459,2.458l4.192-1.993c0.648,0.347,1.334,0.633,2.05,0.851l1.557,4.377c0.571,0.064,1.148,0.104,1.737,0.104c0.588,0,1.165-0.04,1.736-0.104l1.558-4.377c0.715-0.218,1.399-0.504,2.049-0.851l4.193,1.993c0.909-0.725,1.733-1.549,2.458-2.458l-1.993-4.193c0.347-0.647,0.633-1.334,0.851-2.049L31.229,17.736zM16,20.871c-2.69,0-4.872-2.182-4.872-4.871c0-2.69,2.182-4.872,4.872-4.872c2.689,0,4.871,2.182,4.871,4.872C20.871,18.689,18.689,20.871,16,20.871z"/>',"<title>Link options.</title>","</g>","</g>"].join(""),vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>"].join(""),arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<path class="marker-arrowhead" end="<%= end %>" d="M 26 0 L 0 13 L 26 26 z" />',"</g>"].join(""),defaults:{type:"link",source:{},target:{}},disconnect:function(){return this.set({source:g.point(0,0),target:g.point(0,0)})},label:function(a,b){a=a||0;var c=this.get("labels")||[];if(0===arguments.length||1===arguments.length)return c[a];var d=_.merge({},c[a],b),e=c.slice();return e[a]=d,this.set({labels:e})},translate:function(a,b,c){var d={},e=this.get("source"),f=this.get("target"),g=this.get("vertices");return e.id||(d.source={x:e.x+a,y:e.y+b}),f.id||(d.target={x:f.x+a,y:f.y+b}),g&&g.length&&(d.vertices=_.map(g,function(c){return{x:c.x+a,y:c.y+b}})),this.set(d,c)},reparent:function(a){var b;if(this.collection){var c=this.collection.get(this.get("source").id),d=this.collection.get(this.get("target").id),e=this.collection.get(this.get("parent"));c&&d&&(b=this.collection.getCommonAncestor(c,d)),!e||b&&b.id==e.id||e.unembed(this,a),b&&b.embed(this,a)}return b},isLink:function(){return!0},hasLoop:function(a){a=a||{};var b=this.get("source").id,c=this.get("target").id,d=b&&c&&b===c;if(!d&&a.deep&&this.collection){var e=this.collection.get(b),f=this.collection.get(c);d=e.isEmbeddedIn(f)||f.isEmbeddedIn(e)}return d}}),joint.dia.LinkView=joint.dia.CellView.extend({className:function(){return _.unique(this.model.get("type").split(".").concat("link")).join(" ")},options:{shortLinkLength:100,doubleLinkTools:!1,longLinkLength:160,linkToolsOffset:40,doubleLinkToolsOffset:60,sampleInterval:50},initialize:function(a){joint.dia.CellView.prototype.initialize.apply(this,arguments),"function"!=typeof this.constructor.prototype.watchSource&&(this.constructor.prototype.watchSource=this.createWatcher("source"),this.constructor.prototype.watchTarget=this.createWatcher("target")),this._labelCache={},this._markerCache={},this.startListening()},startListening:function(){var a=this.model;this.listenTo(a,"change:markup",this.render),this.listenTo(a,"change:smooth change:manhattan change:router change:connector",this.update),this.listenTo(a,"change:toolMarkup",this.onToolsChange),this.listenTo(a,"change:labels change:labelMarkup",this.onLabelsChange),this.listenTo(a,"change:vertices change:vertexMarkup",this.onVerticesChange),this.listenTo(a,"change:source",this.onSourceChange),this.listenTo(a,"change:target",this.onTargetChange)},onSourceChange:function(a,b){this.watchSource(a,b).update()},onTargetChange:function(a,b){this.watchTarget(a,b).update()},onVerticesChange:function(a,b,c){this.renderVertexMarkers(),(!c.translateBy||c.translateBy===this.model.id||this.model.hasLoop())&&this.update()},onToolsChange:function(){this.renderTools().updateToolsPosition()},onLabelsChange:function(){this.renderLabels().updateLabelPositions()},render:function(){this.$el.empty();var a=V(this.model.get("markup")||this.model.markup);if(_.isArray(a)||(a=[a]),this._V={},_.each(a,function(a){var b=a.attr("class");b&&(this._V[$.camelCase(b)]=a)},this),!this._V.connection)throw new Error("link: no connection path in the markup");return this.renderTools(),this.renderVertexMarkers(),this.renderArrowheadMarkers(),this.vel.append(a),this.renderLabels(),this.watchSource(this.model,this.model.get("source")).watchTarget(this.model,this.model.get("target")).update(),this},renderLabels:function(){if(!this._V.labels)return this;this._labelCache={};var a=$(this._V.labels.node).empty(),b=this.model.get("labels")||[];if(!b.length)return this;var c=_.template(this.model.get("labelMarkup")||this.model.labelMarkup),d=V(c()),e=this.can("labelMove");return _.each(b,function(b,c){var f=d.clone().node;V(f).attr("label-idx",c),e&&V(f).attr("cursor","move"),this._labelCache[c]=V(f);var g=$(f).find("text"),h=$(f).find("rect"),i=_.extend({"text-anchor":"middle","font-size":14},joint.util.getByPath(b,"attrs/text","/"));g.attr(_.omit(i,"text")),_.isUndefined(i.text)||V(g[0]).text(i.text+""),a.append(f);var j=V(g[0]).bbox(!0,a[0]);V(g[0]).translate(0,-j.height/2);var k=_.extend({fill:"white",rx:3,ry:3},joint.util.getByPath(b,"attrs/rect","/"));h.attr(_.extend(k,{x:j.x,y:j.y-j.height/2,width:j.width,height:j.height}))},this),this},renderTools:function(){if(!this._V.linkTools)return this;var a=$(this._V.linkTools.node).empty(),b=_.template(this.model.get("toolMarkup")||this.model.toolMarkup),c=V(b());if(a.append(c.node),this._toolCache=c,this.options.doubleLinkTools){var d;this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup?(b=_.template(this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup),d=V(b())):d=c.clone(),a.append(d.node),this._tool2Cache=d}return this},renderVertexMarkers:function(){if(!this._V.markerVertices)return this;var a=$(this._V.markerVertices.node).empty(),b=_.template(this.model.get("vertexMarkup")||this.model.vertexMarkup);return _.each(this.model.get("vertices"),function(c,d){a.append(V(b(_.extend({idx:d},c))).node)}),this},renderArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;var a=$(this._V.markerArrowheads.node);a.empty();var b=_.template(this.model.get("arrowheadMarkup")||this.model.arrowheadMarkup);return this._V.sourceArrowhead=V(b({end:"source"})),this._V.targetArrowhead=V(b({end:"target"})),a.append(this._V.sourceArrowhead.node,this._V.targetArrowhead.node),this},update:function(){_.each(this.model.get("attrs"),function(a,b){var c=[];_.isObject(a.fill)&&(this.applyGradient(b,"fill",a.fill),c.push("fill")),_.isObject(a.stroke)&&(this.applyGradient(b,"stroke",a.stroke),c.push("stroke")),_.isObject(a.filter)&&(this.applyFilter(b,a.filter),c.push("filter")),c.length>0&&(c.unshift(a),a=_.omit.apply(_,c)),this.findBySelector(b).attr(a)},this);var a=this.route=this.findRoute(this.model.get("vertices")||[]);this._findConnectionPoints(a);var b=this.getPathData(a);return this._V.connection.attr("d",b),this._V.connectionWrap&&this._V.connectionWrap.attr("d",b),this._translateAndAutoOrientArrows(this._V.markerSource,this._V.markerTarget),this.updateLabelPositions(),this.updateToolsPosition(),this.updateArrowheadMarkers(),delete this.options.perpendicular,this.updatePostponed=!1,this},_findConnectionPoints:function(a){var b,c,d,e,f=_.first(a);b=this.getConnectionPoint("source",this.model.get("source"),f||this.model.get("target")).round();var h=_.last(a);c=this.getConnectionPoint("target",this.model.get("target"),h||b).round();var i=this._markerCache;this._V.markerSource&&(i.sourceBBox=i.sourceBBox||this._V.markerSource.bbox(!0),d=g.point(b).move(f||c,i.sourceBBox.width*this._V.markerSource.scale().sx*-1).round()),this._V.markerTarget&&(i.targetBBox=i.targetBBox||this._V.markerTarget.bbox(!0),e=g.point(c).move(h||b,i.targetBBox.width*this._V.markerTarget.scale().sx*-1).round()),i.sourcePoint=d||b,i.targetPoint=e||c,this.sourcePoint=b,this.targetPoint=c},updateLabelPositions:function(){if(!this._V.labels)return this;var a=this.model.get("labels")||[];if(!a.length)return this;var b=this._V.connection.node,c=b.getTotalLength();if(!_.isNaN(c)){var d;_.each(a,function(a,e){var f=a.position,h=_.isObject(f)?f.distance:f,i=_.isObject(f)?f.offset:{x:0,y:0};h=h>c?c:h,h=0>h?c+h:h,h=h>1?h:c*h;var j=b.getPointAtLength(h);if(_.isObject(i))j=g.point(j).offset(i.x,i.y);else if(_.isNumber(i)){d||(d=this._samples||this._V.connection.sample(this.options.sampleInterval));for(var k,l,m,n,o=1/0,p=0,q=d.length;q>p;p++)m=d[p],n=g.line(m,j).squaredLength(),o>n&&(o=n,k=m,l=p);var r=d[l-1],s=d[l+1],t=0;s?t=g.point(j).theta(s):r&&(t=g.point(r).theta(j)),j=g.point(j).offset(i).rotate(j,t-90)}this._labelCache[e].attr("transform","translate("+j.x+", "+j.y+")")},this)}return this},updateToolsPosition:function(){if(!this._V.linkTools)return this;var a="",b=this.options.linkToolsOffset,c=this.getConnectionLength();if(!_.isNaN(c)){c<this.options.shortLinkLength&&(a="scale(.5)",b/=2);var d=this.getPointAtLength(b);if(this._toolCache.attr("transform","translate("+d.x+", "+d.y+") "+a),this.options.doubleLinkTools&&c>=this.options.longLinkLength){var e=this.options.doubleLinkToolsOffset||b;d=this.getPointAtLength(c-e),this._tool2Cache.attr("transform","translate("+d.x+", "+d.y+") "+a),this._tool2Cache.attr("visibility","visible")}else this.options.doubleLinkTools&&this._tool2Cache.attr("visibility","hidden")}return this},updateArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;if("none"===$.css(this._V.markerArrowheads.node,"display"))return this;var a=this.getConnectionLength()<this.options.shortLinkLength?.5:1;return this._V.sourceArrowhead.scale(a),this._V.targetArrowhead.scale(a),this._translateAndAutoOrientArrows(this._V.sourceArrowhead,this._V.targetArrowhead),this},createWatcher:function(a){function b(b,d){d=d||{};var e=null,f=b.previous(a)||{};return f.id&&this.stopListening(this.paper.getModelById(f.id),"change",c),d.id&&(e=this.paper.getModelById(d.id),this.listenTo(e,"change",c)),c.call(this,e,{cacheOnly:!0}),this}var c=_.partial(this.onEndModelChange,a);return b},onEndModelChange:function(a,b,c){var d=!c.cacheOnly,e=this.model.get(a)||{};if(b){var f=this.constructor.makeSelector(e),h="source"==a?"target":"source",i=this.model.get(h)||{},j=i.id&&this.constructor.makeSelector(i);if(c.handleBy===this.cid&&f==j)this[a+"BBox"]=this[h+"BBox"],this[a+"View"]=this[h+"View"],this[a+"Magnet"]=this[h+"Magnet"];else if(c.translateBy){var k=this[a+"BBox"];k.x+=c.tx,k.y+=c.ty}else{var l=this.paper.findViewByModel(e.id),m=l.el.querySelector(f);this[a+"BBox"]=l.getStrokeBBox(m),this[a+"View"]=l,this[a+"Magnet"]=m}if(c.handleBy===this.cid&&c.translateBy&&this.model.isEmbeddedIn(b)&&!_.isEmpty(this.model.get("vertices"))&&(d=!1),!this.updatePostponed&&i.id){var n=this.paper.getModelById(i.id);e.id===i.id&&(c.handleBy=this.cid),(c.handleBy===this.cid||c.translateBy&&n.isEmbeddedIn(c.translateBy))&&(this.updatePostponed=!0,d=!1)}}else this[a+"BBox"]=g.rect(e.x||0,e.y||0,1,1),this[a+"View"]=this[a+"Magnet"]=null;this.lastEndChange=a,d&&this.update()},_translateAndAutoOrientArrows:function(a,b){a&&a.translateAndAutoOrient(this.sourcePoint,_.first(this.route)||this.targetPoint,this.paper.viewport),b&&b.translateAndAutoOrient(this.targetPoint,_.last(this.route)||this.sourcePoint,this.paper.viewport)},removeVertex:function(a){var b=_.clone(this.model.get("vertices"));return b&&b.length&&(b.splice(a,1),this.model.set("vertices",b,{ui:!0})),this},addVertex:function(a){for(var b,c=(this.model.get("vertices")||[]).slice(),d=c.slice(),e=this._V.connection.node.cloneNode(!1),f=e.getTotalLength(),g=20,h=c.length+1;h--&&(c.splice(h,0,a),V(e).attr("d",this.getPathData(this.findRoute(c))),b=e.getTotalLength(),b-f>g);)c=d.slice();return-1===h&&(h=0,c.splice(h,0,a)),this.model.set("vertices",c,{ui:!0}),h},sendToken:function(a,b,c){b=b||1e3,V(this.paper.viewport).append(a),V(a).animateAlongPath({dur:b+"ms",repeatCount:1},this._V.connection.node),_.delay(function(){V(a).remove(),c&&c()},b)},findRoute:function(a){var b=joint.routers,c=this.model.get("router"),d=this.paper.options.defaultRouter;if(!c)if(this.model.get("manhattan"))c={name:"orthogonal"};else{if(!d)return a;c=d}var e=c.args||{},f=_.isFunction(c)?c:b[c.name];if(!_.isFunction(f))throw"unknown router: "+c.name;var g=f.call(this,a||[],e,this);return g},getPathData:function(a){var b=joint.connectors,c=this.model.get("connector"),d=this.paper.options.defaultConnector;c||(c=this.model.get("smooth")?{name:"smooth"}:d||{name:"normal"});var e=_.isFunction(c)?c:b[c.name],f=c.args||{};if(!_.isFunction(e))throw"unknown connector: "+c.name;var g=e.call(this,this._markerCache.sourcePoint,this._markerCache.targetPoint,a||this.model.get("vertices")||{},f,this);return g},getConnectionPoint:function(a,b,c){var d;if(_.isEmpty(b)&&(b={x:0,y:0}),_.isEmpty(c)&&(c={x:0,y:0}),b.id){var e,f="source"===a?this.sourceBBox:this.targetBBox;if(c.id){var h="source"===a?this.targetBBox:this.sourceBBox;e=g.rect(h).intersectionWithLineFromCenterToPoint(g.rect(f).center()),e=e||g.rect(h).center()}else e=g.point(c);if(this.paper.options.perpendicularLinks||this.options.perpendicular){var i,j=g.rect(0,e.y,this.paper.options.width,1),k=g.rect(e.x,0,1,this.paper.options.height);if(j.intersect(g.rect(f)))switch(i=g.rect(f).sideNearestToPoint(e)){case"left":d=g.point(f.x,e.y);break;case"right":d=g.point(f.x+f.width,e.y);break;default:d=g.rect(f).center()}else if(k.intersect(g.rect(f)))switch(i=g.rect(f).sideNearestToPoint(e)){case"top":d=g.point(e.x,f.y);break;case"bottom":d=g.point(e.x,f.y+f.height);break;default:d=g.rect(f).center()}else d=g.rect(f).intersectionWithLineFromCenterToPoint(e),d=d||g.rect(f).center()}else if(this.paper.options.linkConnectionPoint){var l="target"===a?this.targetView:this.sourceView,m="target"===a?this.targetMagnet:this.sourceMagnet;d=this.paper.options.linkConnectionPoint(this,l,m,e)}else d=g.rect(f).intersectionWithLineFromCenterToPoint(e),d=d||g.rect(f).center()}else d=g.point(b);return d},getConnectionLength:function(){return this._V.connection.node.getTotalLength()},getPointAtLength:function(a){return this._V.connection.node.getPointAtLength(a)},_beforeArrowheadMove:function(){this._z=this.model.get("z"),this.model.toFront(),this.el.style.pointerEvents="none",this.paper.options.markAvailable&&this._markAvailableMagnets()},_afterArrowheadMove:function(){_.isUndefined(this._z)||(this.model.set("z",this._z,{ui:!0}),delete this._z),this.el.style.pointerEvents="visiblePainted",this.paper.options.markAvailable&&this._unmarkAvailableMagnets()},_createValidateConnectionArgs:function(a){function b(a,b){return c[f]=a,c[f+1]=a.el===b?void 0:b,c}var c=[];c[4]=a,c[5]=this;var d,e=0,f=0;"source"===a?(e=2,d="target"):(f=2,d="source");var g=this.model.get(d);return g.id&&(c[e]=this.paper.findViewByModel(g.id),c[e+1]=g.selector&&c[e].el.querySelector(g.selector)),b},_markAvailableMagnets:function(){var a=this.paper.model.getElements(),b=this.paper.options.validateConnection;_.chain(a).map(this.paper.findViewByModel,this.paper).each(function(a){var c="false"!==a.el.getAttribute("magnet")&&b.apply(this.paper,this._validateConnectionArgs(a,null)),d=_.filter(a.el.querySelectorAll("[magnet]"),function(c){return b.apply(this.paper,this._validateConnectionArgs(a,c))},this);c&&V(a.el).addClass("available-magnet"),_.each(d,function(a){V(a).addClass("available-magnet")}),(c||d.length)&&V(a.el).addClass("available-cell")},this).value()},_unmarkAvailableMagnets:function(){_.each(this.paper.el.querySelectorAll(".available-cell, .available-magnet"),function(a){V(a).removeClass("available-magnet").removeClass("available-cell")})},startArrowheadMove:function(a){this._action="arrowhead-move",this._arrowhead=a,this._initialEnd=_.clone(this.model.get(a))||{x:0,y:0},this._validateConnectionArgs=this._createValidateConnectionArgs(this._arrowhead),this._beforeArrowheadMove()},can:function(a){var b=_.isFunction(this.options.interactive)?this.options.interactive(this,"pointerdown"):this.options.interactive;return _.isObject(b)&&b[a]===!1?!1:!0},pointerdown:function(a,b,c){if(joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("link:pointerdown",a,b,c),this._dx=b,this._dy=c,null==a.target.getAttribute("magnet")){var d=_.isFunction(this.options.interactive)?this.options.interactive(this,"pointerdown"):this.options.interactive;if(d!==!1){var e,f=a.target.getAttribute("class"),g=a.target.parentNode.getAttribute("class");switch("label"===g?(f=g,e=a.target.parentNode):e=a.target,f){case"marker-vertex":this.can("vertexMove")&&(this._action="vertex-move",this._vertexIdx=a.target.getAttribute("idx"));break;case"marker-vertex-remove":case"marker-vertex-remove-area":this.can("vertexRemove")&&this.removeVertex(a.target.getAttribute("idx"));break;case"marker-arrowhead":this.can("arrowheadMove")&&this.startArrowheadMove(a.target.getAttribute("end"));break;case"label":this.can("labelMove")&&(this._action="label-move",this._labelIdx=parseInt(V(e).attr("label-idx"),10),this._samples=this._V.connection.sample(1),this._linkLength=this._V.connection.node.getTotalLength());break;default:var h=a.target.parentNode.getAttribute("event");h?"remove"===h?this.model.remove():this.paper.trigger(h,a,this,b,c):this.can("vertexAdd")&&(this._vertexIdx=this.addVertex({x:b,y:c}),this._action="vertex-move")}}}},pointermove:function(a,b,c){switch(this._action){case"vertex-move":var d=_.clone(this.model.get("vertices"));d[this._vertexIdx]={x:b,y:c},this.model.set("vertices",d,{ui:!0});break;case"label-move":for(var e,f,h,i,j={x:b,y:c},k=(this.model.get("labels")[this._labelIdx],this._samples),l=1/0,m=0,n=k.length;n>m;m++)h=k[m],i=g.line(h,j).squaredLength(),l>i&&(l=i,e=h,f=m);var o=k[f-1],p=k[f+1],q=(g.point(e).distance(j),0);o&&p?q=g.line(o,p).pointOffset(j):o?q=g.line(o,e).pointOffset(j):p&&(q=g.line(e,p).pointOffset(j)),this.model.label(this._labelIdx,{position:{distance:e.distance/this._linkLength,offset:q}});break;case"arrowhead-move":if(this.paper.options.snapLinks){var r=this.paper.options.snapLinks.radius||50,s=this.paper.findViewsInArea({x:b-r,y:c-r,width:2*r,height:2*r});this._closestView&&this._closestView.unhighlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),this._closestView=this._closestEnd=null;var t,u=Number.MAX_VALUE,v=g.point(b,c);_.each(s,function(a){"false"!==a.el.getAttribute("magnet")&&(t=a.model.getBBox().center().distance(v),r>t&&u>t&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,null))&&(u=t,this._closestView=a,this._closestEnd={id:a.model.id})),a.$("[magnet]").each(_.bind(function(b,c){var d=V(c).bbox(!1,this.paper.viewport);t=v.distance({x:d.x+d.width/2,y:d.y+d.height/2}),r>t&&u>t&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,c))&&(u=t,this._closestView=a,this._closestEnd={id:a.model.id,selector:a.getSelector(c),port:c.getAttribute("port")})},this))},this),this._closestView&&this._closestView.highlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),this.model.set(this._arrowhead,this._closestEnd||{x:b,y:c},{ui:!0})}else{var w="mousemove"===a.type?a.target:document.elementFromPoint(a.clientX,a.clientY);this._targetEvent!==w&&(this._magnetUnderPointer&&this._viewUnderPointer.unhighlight(this._magnetUnderPointer,{connecting:!0}),this._viewUnderPointer=this.paper.findView(w),this._viewUnderPointer?(this._magnetUnderPointer=this._viewUnderPointer.findMagnet(w),this._magnetUnderPointer&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(this._viewUnderPointer,this._magnetUnderPointer))?this._magnetUnderPointer&&this._viewUnderPointer.highlight(this._magnetUnderPointer,{connecting:!0}):this._magnetUnderPointer=null):this._magnetUnderPointer=null),this._targetEvent=w,this.model.set(this._arrowhead,{x:b,y:c},{ui:!0})}}this._dx=b,this._dy=c,joint.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("link:pointermove",a,b,c)},pointerup:function(a,b,c){if("label-move"===this._action)this._samples=null;else if("arrowhead-move"===this._action){var d=this.paper.options,e=this._arrowhead;if(d.snapLinks)this._closestView&&this._closestView.unhighlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),this._closestView=this._closestEnd=null;else{var f=this._viewUnderPointer,g=this._magnetUnderPointer;if(delete this._viewUnderPointer,delete this._magnetUnderPointer,g){f.unhighlight(g,{connecting:!0});var h=f.getSelector(g),i=g.getAttribute("port"),j={id:f.model.id};null!=h&&(j.port=i),null!=i&&(j.selector=h),this.model.set(e,j,{ui:!0})}}d.linkPinning||_.has(this.model.get(e),"id")||this.model.set(e,this._initialEnd,{ui:!0}),d.embeddingMode&&this.model.reparent()&&delete this._z,this._afterArrowheadMove()}delete this._action,this.notify("link:pointerup",a,b,c),joint.dia.CellView.prototype.pointerup.apply(this,arguments)}},{makeSelector:function(a){var b='[model-id="'+a.id+'"]';return a.port?b+=' [port="'+a.port+'"]':a.selector&&(b+=" "+a.selector),b}}),joint.dia.Paper=Backbone.View.extend({className:"paper",options:{width:800,height:600,origin:{x:0,y:0},gridSize:1,perpendicularLinks:!1,elementView:joint.dia.ElementView,linkView:joint.dia.LinkView,snapLinks:!1,restrictTranslate:!1,markAvailable:!1,defaultLink:new joint.dia.Link,defaultConnector:{name:"normal"},defaultRouter:null,validateMagnet:function(a,b){return"passive"!==b.getAttribute("magnet")},validateConnection:function(a,b,c,d,e,f){return("target"===e?c:a)instanceof joint.dia.ElementView},embeddingMode:!1,validateEmbedding:function(a,b){return!0},findParentBy:"bbox",frontParentOnly:!0,interactive:{
labelMove:!1},linkPinning:!0,clickThreshold:0,cellViewNamespace:joint.shapes},events:{mousedown:"pointerdown",dblclick:"mousedblclick",click:"mouseclick",touchstart:"pointerdown",mousemove:"pointermove",touchmove:"pointermove","mouseover .element":"cellMouseover","mouseover .link":"cellMouseover","mouseout .element":"cellMouseout","mouseout .link":"cellMouseout",contextmenu:"contextmenu"},constructor:function(a){this._configure(a),Backbone.View.apply(this,arguments)},_configure:function(a){this.options&&(a=_.merge({},_.result(this,"options"),a)),this.options=a},initialize:function(){_.bindAll(this,"pointerup"),this.svg=V("svg").node,this.viewport=V("g").addClass("viewport").node,this.defs=V("defs").node,V(this.svg).append([this.viewport,this.defs]),this.$el.append(this.svg),this.setOrigin(),this.setDimensions(),this.listenTo(this.model,"add",this.onCellAdded),this.listenTo(this.model,"remove",this.removeView),this.listenTo(this.model,"reset",this.resetViews),this.listenTo(this.model,"sort",this.sortViews),$(document).on("mouseup touchend",this.pointerup),this._mousemoved=0,this._views={},this.on({"cell:highlight":this.onCellHighlight,"cell:unhighlight":this.onCellUnhighlight})},remove:function(){this.removeViews(),$(document).off("mouseup touchend",this.pointerup),Backbone.View.prototype.remove.call(this)},setDimensions:function(a,b){a=this.options.width=a||this.options.width,b=this.options.height=b||this.options.height,V(this.svg).attr({width:a,height:b}),this.trigger("resize",a,b)},setOrigin:function(a,b){this.options.origin.x=a||0,this.options.origin.y=b||0,V(this.viewport).translate(a,b,{absolute:!0}),this.trigger("translate",a,b)},fitToContent:function(a,b,c,d){_.isObject(a)?(d=a,a=d.gridWidth||1,b=d.gridHeight||1,c=d.padding||0):(d=d||{},a=a||1,b=b||1,c=c||0),c=joint.util.normalizeSides(c);var e=V(this.viewport).bbox(!0,this.svg),f=V(this.viewport).scale();e.x*=f.sx,e.y*=f.sy,e.width*=f.sx,e.height*=f.sy;var g=Math.max(Math.ceil((e.width+e.x)/a),1)*a,h=Math.max(Math.ceil((e.height+e.y)/b),1)*b,i=0,j=0;("negative"==d.allowNewOrigin&&e.x<0||"positive"==d.allowNewOrigin&&e.x>=0||"any"==d.allowNewOrigin)&&(i=Math.ceil(-e.x/a)*a,i+=c.left,g+=i),("negative"==d.allowNewOrigin&&e.y<0||"positive"==d.allowNewOrigin&&e.y>=0||"any"==d.allowNewOrigin)&&(j=Math.ceil(-e.y/b)*b,j+=c.top,h+=j),g+=c.right,h+=c.bottom,g=Math.max(g,d.minWidth||0),h=Math.max(h,d.minHeight||0),g=Math.min(g,d.maxWidth||Number.MAX_VALUE),h=Math.min(h,d.maxHeight||Number.MAX_VALUE);var k=g!=this.options.width||h!=this.options.height,l=i!=this.options.origin.x||j!=this.options.origin.y;l&&this.setOrigin(i,j),k&&this.setDimensions(g,h)},scaleContentToFit:function(a){var b=this.getContentBBox();if(b.width&&b.height){a=a||{},_.defaults(a,{padding:0,preserveAspectRatio:!0,scaleGrid:null,minScale:0,maxScale:Number.MAX_VALUE});var c=a.padding,d=a.minScaleX||a.minScale,e=a.maxScaleX||a.maxScale,f=a.minScaleY||a.minScale,h=a.maxScaleY||a.maxScale,i=a.fittingBBox||{x:this.options.origin.x,y:this.options.origin.y,width:this.options.width,height:this.options.height};i=g.rect(i).moveAndExpand({x:c,y:c,width:-2*c,height:-2*c});var j=V(this.viewport).scale(),k=i.width/b.width*j.sx,l=i.height/b.height*j.sy;if(a.preserveAspectRatio&&(k=l=Math.min(k,l)),a.scaleGrid){var m=a.scaleGrid;k=m*Math.floor(k/m),l=m*Math.floor(l/m)}k=Math.min(e,Math.max(d,k)),l=Math.min(h,Math.max(f,l)),this.scale(k,l);var n=this.getContentBBox(),o=i.x-n.x,p=i.y-n.y;this.setOrigin(o,p)}},getContentBBox:function(){var a=this.viewport.getBoundingClientRect(),b=this.viewport.getScreenCTM(),c=this.viewport.getCTM(),d=g.rect({x:a.left-b.e+c.e,y:a.top-b.f+c.f,width:a.width,height:a.height});return d},getArea:function(){var a=this.viewport.getCTM().inverse(),b={x:0,y:0,width:this.options.width,height:this.options.height};return g.rect(V.transformRect(b,a))},getRestrictedArea:function(){var a;return a=_.isFunction(this.options.restrictTranslate)?this.options.restrictTranslate.aply(this,arguments):this.options.restrictTranslate===!0?this.getArea():this.options.restrictTranslate||null},createViewForModel:function(a){var b,c,d=this.options.cellViewNamespace,e=a.get("type")+"View",f=joint.util.getByPath(d,e,".");a.isLink()?(b=this.options.linkView,c=joint.dia.LinkView):(b=this.options.elementView,c=joint.dia.ElementView);var g=b.prototype instanceof Backbone.View?f||b:b.call(this,a)||f||c;return new g({model:a,interactive:this.options.interactive})},onCellAdded:function(a,b,c){if(this.options.async&&c.async!==!1&&_.isNumber(c.position)){if(this._asyncCells=this._asyncCells||[],this._asyncCells.push(a),0==c.position){if(this._frameId)throw new Error("another asynchronous rendering in progress");this.asyncRenderViews(this._asyncCells,c),delete this._asyncCells}}else this.renderView(a)},removeView:function(a){var b=this._views[a.id];return b&&(b.remove(),delete this._views[a.id]),b},renderView:function(a){var b=this._views[a.id]=this.createViewForModel(a);return V(this.viewport).append(b.el),b.paper=this,b.render(),$(b.el).find("image").on("dragstart",function(){return!1}),b},beforeRenderViews:function(a){return a.sort(function(a,b){return a instanceof joint.dia.Link?1:-1}),a},afterRenderViews:function(){this.sortViews()},resetViews:function(a,b){$(this.viewport).empty(),this.removeViews();var c=a.models.slice();c=this.beforeRenderViews(c,b)||c,this._frameId&&(joint.util.cancelFrame(this._frameId),delete this._frameId),this.options.async?this.asyncRenderViews(c,b):(_.each(c,this.renderView,this),this.sortViews())},removeViews:function(){_.invoke(this._views,"remove"),this._views={}},asyncBatchAdded:_.noop,asyncRenderViews:function(a,b){if(this._frameId){var c=this.options.async&&this.options.async.batchSize||50,d=a.splice(0,c),e=this.model.get("cells");_.each(d,function(a){a.collection===e&&this.renderView(a)},this),this.asyncBatchAdded()}a.length?this._frameId=joint.util.nextFrame(function(){this.asyncRenderViews(a,b)},this):(delete this._frameId,this.afterRenderViews(b),this.trigger("render:done",b))},sortViews:function(){var a=$(this.viewport).children("[model-id]"),b=this.model.get("cells");joint.util.sortElements(a,function(a,c){var d=b.get($(a).attr("model-id")),e=b.get($(c).attr("model-id"));return(d.get("z")||0)>(e.get("z")||0)?1:-1})},scale:function(a,b,c,d){b=b||a,_.isUndefined(c)&&(c=0,d=0),V(this.viewport).attr("transform","");var e=this.options.origin.x,f=this.options.origin.y;if(c||d||e||f){var g=e-c*(a-1),h=f-d*(b-1);this.setOrigin(g,h)}return V(this.viewport).scale(a,b),this.trigger("scale",a,b,c,d),this},rotate:function(a,b,c){if(_.isUndefined(b)){var d=this.viewport.getBBox();b=d.width/2,c=d.height/2}V(this.viewport).rotate(a,b,c)},findView:function(a){for(var b=_.isString(a)?this.viewport.querySelector(a):a instanceof $?a[0]:a;b&&b!==this.el&&b!==document;){var c=b.getAttribute("model-id");if(c)return this._views[c];b=b.parentNode}return void 0},findViewByModel:function(a){var b=_.isString(a)?a:a.id;return this._views[b]},findViewsFromPoint:function(a){a=g.point(a);var b=_.map(this.model.getElements(),this.findViewByModel,this);return _.filter(b,function(b){return b&&g.rect(b.vel.bbox(!1,this.viewport)).containsPoint(a)},this)},findViewsInArea:function(a){a=g.rect(a);var b=_.map(this.model.getElements(),this.findViewByModel,this);return _.filter(b,function(b){return b&&a.intersect(g.rect(b.vel.bbox(!1,this.viewport)))},this)},getModelById:function(a){return this.model.getCell(a)},snapToGrid:function(a){var b=V(this.viewport).toLocalPoint(a.x,a.y);return{x:g.snapToGrid(b.x,this.options.gridSize),y:g.snapToGrid(b.y,this.options.gridSize)}},clientToLocalPoint:function(a){var b=this.svg.createSVGPoint();b.x=a.x,b.y=a.y;var c=V("rect",{width:this.options.width,height:this.options.height,x:0,y:0,opacity:0});V(this.svg).prepend(c);var d=$(this.svg).offset();c.remove();var e=document.body.scrollTop||document.documentElement.scrollTop,f=document.body.scrollLeft||document.documentElement.scrollLeft;b.x+=f-d.left,b.y+=e-d.top;var g=b.matrixTransform(this.viewport.getCTM().inverse());return g},getDefaultLink:function(a,b){return _.isFunction(this.options.defaultLink)?this.options.defaultLink.call(this,a,b):this.options.defaultLink.clone()},onCellHighlight:function(a,b){V(b).addClass("highlighted")},onCellUnhighlight:function(a,b){V(b).removeClass("highlighted")},mousedblclick:function(a){a.preventDefault(),a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerdblclick(a,c.x,c.y):this.trigger("blank:pointerdblclick",a,c.x,c.y)}},mouseclick:function(a){if(this._mousemoved<=this.options.clickThreshold){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(this.guard(a,b))return;var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerclick(a,c.x,c.y):this.trigger("blank:pointerclick",a,c.x,c.y)}this._mousemoved=0},guard:function(a,b){return b&&b.model&&b.model instanceof joint.dia.Cell?!1:this.svg===a.target||this.el===a.target||$.contains(this.svg,a.target)?!1:!0},contextmenu:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.contextmenu(a,c.x,c.y):this.trigger("blank:contextmenu",a,c.x,c.y)}},pointerdown:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?(this.sourceView=b,b.pointerdown(a,c.x,c.y)):this.trigger("blank:pointerdown",a,c.x,c.y)}},pointermove:function(a){if(a.preventDefault(),a=joint.util.normalizeEvent(a),this.sourceView){this._mousemoved++;var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView.pointermove(a,b.x,b.y)}},pointerup:function(a){a=joint.util.normalizeEvent(a);var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView?(this.sourceView.pointerup(a,b.x,b.y),this.sourceView=null):this.trigger("blank:pointerup",a,b.x,b.y)},cellMouseover:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(b){if(this.guard(a,b))return;b.mouseover(a)}},cellMouseout:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(b){if(this.guard(a,b))return;b.mouseout(a)}}}),joint.shapes.basic={},joint.shapes.basic.Generic=joint.dia.Element.extend({defaults:joint.util.deepSupplement({type:"basic.Generic",attrs:{".":{fill:"#ffffff",stroke:"none"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.basic.Rect=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><rect/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Rect",attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:100,height:60},text:{fill:"#000000",text:"","font-size":14,"ref-x":.5,"ref-y":.5,"text-anchor":"middle","y-alignment":"middle","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.TextView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"change:attrs",this.resize)}}),joint.shapes.basic.Text=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><text/></g></g>',defaults:joint.util.deepSupplement({type:"basic.Text",attrs:{text:{"font-size":18,fill:"#000000"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Circle=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Circle",size:{width:60,height:60},attrs:{circle:{fill:"#ffffff",stroke:"#000000",r:30,cx:30,cy:30},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Ellipse=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><ellipse/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Ellipse",size:{width:60,height:40},attrs:{ellipse:{fill:"#ffffff",stroke:"#000000",rx:30,ry:20,cx:30,cy:20},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Polygon=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Polygon",size:{width:60,height:40},attrs:{polygon:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Polyline=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><polyline/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Polyline",size:{width:60,height:40},attrs:{polyline:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Image=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><image/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Image",attrs:{text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Path=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Path",size:{width:60,height:60},attrs:{path:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle",ref:"path","ref-x":.5,"ref-dy":10,fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Rhombus=joint.shapes.basic.Path.extend({defaults:joint.util.deepSupplement({type:"basic.Rhombus",attrs:{path:{d:"M 30 0 L 60 30 30 60 0 30 z"},text:{"ref-y":.5,"y-alignment":"middle"}}},joint.shapes.basic.Path.prototype.defaults)}),joint.shapes.basic.PortsModelInterface={initialize:function(){this.updatePortsAttrs(),this.on("change:inPorts change:outPorts",this.updatePortsAttrs,this),this.constructor.__super__.constructor.__super__.initialize.apply(this,arguments)},updatePortsAttrs:function(a){var b=this.get("attrs");_.each(this._portSelectors,function(a){b[a]&&delete b[a]}),this._portSelectors=[];var c={};_.each(this.get("inPorts"),function(a,b,d){var e=this.getPortAttrs(a,b,d.length,".inPorts","in");this._portSelectors=this._portSelectors.concat(_.keys(e)),_.extend(c,e)},this),_.each(this.get("outPorts"),function(a,b,d){var e=this.getPortAttrs(a,b,d.length,".outPorts","out");this._portSelectors=this._portSelectors.concat(_.keys(e)),_.extend(c,e)},this),this.attr(c,{silent:!0}),this.processPorts(),this.trigger("process:ports")},getPortSelector:function(a){var b=".inPorts",c=this.get("inPorts").indexOf(a);if(0>c&&(b=".outPorts",c=this.get("outPorts").indexOf(a),0>c))throw new Error("getPortSelector(): Port doesn't exist.");return b+">g:nth-child("+(c+1)+")>.port-body"}},joint.shapes.basic.PortsViewInterface={initialize:function(){this.listenTo(this.model,"process:ports",this.update),joint.dia.ElementView.prototype.initialize.apply(this,arguments)},update:function(){this.renderPorts(),joint.dia.ElementView.prototype.update.apply(this,arguments)},renderPorts:function(){var a=this.$(".inPorts").empty(),b=this.$(".outPorts").empty(),c=_.template(this.model.portMarkup);_.each(_.filter(this.model.ports,function(a){return"in"===a.type}),function(b,d){a.append(V(c({id:d,port:b})).node)}),_.each(_.filter(this.model.ports,function(a){return"out"===a.type}),function(a,d){b.append(V(c({id:d,port:a})).node)})}},joint.shapes.basic.TextBlock=joint.shapes.basic.Generic.extend({markup:['<g class="rotatable"><g class="scalable"><rect/></g><switch>','<foreignObject requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility" class="fobj">','<body xmlns="http://www.w3.org/1999/xhtml"><div/></body>',"</foreignObject>",'<text class="content"/>',"</switch></g>"].join(""),defaults:joint.util.deepSupplement({type:"basic.TextBlock",attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:80,height:100},text:{fill:"#000000","font-size":14,"font-family":"Arial, helvetica, sans-serif"},".content":{text:"",ref:"rect","ref-x":.5,"ref-y":.5,"y-alignment":"middle","x-alignment":"middle"}},content:""},joint.shapes.basic.Generic.prototype.defaults),initialize:function(){"undefined"!=typeof SVGForeignObjectElement&&(this.setForeignObjectSize(this,this.get("size")),this.setDivContent(this,this.get("content")),this.listenTo(this,"change:size",this.setForeignObjectSize),this.listenTo(this,"change:content",this.setDivContent)),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},setForeignObjectSize:function(a,b){a.attr({".fobj":_.clone(b),div:{style:_.clone(b)}})},setDivContent:function(a,b){a.attr({div:{html:b}})}}),joint.shapes.basic.TextBlockView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),"undefined"==typeof SVGForeignObjectElement&&(this.noSVGForeignObjectElement=!0,this.listenTo(this.model,"change:content",function(a){this.updateContent(a)}))},update:function(a,b){if(this.noSVGForeignObjectElement){var c=this.model,d=_.omit(b||c.get("attrs"),".content");joint.dia.ElementView.prototype.update.call(this,c,d),(!b||_.has(b,".content"))&&this.updateContent(c,b)}else joint.dia.ElementView.prototype.update.call(this,c,b)},updateContent:function(a,b){var c=_.merge({},(b||a.get("attrs"))[".content"]);delete c.text;var d=joint.util.breakText(a.get("content"),a.get("size"),c,{svgDocument:this.paper.svg}),e=joint.util.setByPath({},".content",c,"/");e[".content"].text=d,joint.dia.ElementView.prototype.update.call(this,a,e)}}),joint.routers.orthogonal=function(){function a(a,b){return a.x==b.x?a.y>b.y?"N":"S":a.y==b.y?a.x>b.x?"W":"E":null}function b(a,b){return a["W"==b||"E"==b?"width":"height"]}function c(a,b){return g.rect(a).moveAndExpand({x:-b,y:-b,width:2*b,height:2*b})}function d(a){return g.rect(a.x,a.y,0,0)}function e(a,b){var c=Math.min(a.x,b.x),d=Math.min(a.y,b.y),e=Math.max(a.x+a.width,b.x+b.width),f=Math.max(a.y+a.height,b.y+b.height);return g.rect(c,d,e-c,f-d)}function f(a,b,c){var d=g.point(a.x,b.y);return c.containsPoint(d)&&(d=g.point(b.x,a.y)),d}function h(b,c,d){var e=g.point(b.x,c.y),f=g.point(c.x,b.y),h=a(b,e),i=a(b,f),j=n[d],k=h==d||h!=j&&(i==j||i!=d)?e:f;return{points:[k],direction:a(k,c)}}function i(b,c,d){var e=f(b,c,d);return{points:[e],direction:a(e,c)}}function j(c,d,e,h){var i,j={},k=[g.point(c.x,d.y),g.point(d.x,c.y)],l=_.filter(k,function(a){return!e.containsPoint(a)}),m=_.filter(l,function(b){return a(b,c)!=h});if(m.length>0)i=_.filter(m,function(b){return a(c,b)==h}).pop(),i=i||m[0],j.points=[i],j.direction=a(i,d);else{i=_.difference(k,l)[0];var n=g.point(d).move(i,-b(e,h)/2),o=f(n,c,e);j.points=[o,n],j.direction=a(n,d)}return j}function k(c,d,e,f){var j=i(d,c,f),k=j.points[0];if(e.containsPoint(k)){j=i(c,d,e);var l=j.points[0];if(f.containsPoint(l)){var m=g.point(c).move(l,-b(e,a(c,l))/2),n=g.point(d).move(k,-b(f,a(d,k))/2),o=g.line(m,n).midpoint(),p=i(c,o,e),q=h(o,d,p.direction);j.points=[p.points[0],q.points[0]],j.direction=q.direction}}return j}function l(b,d,h,i,j){var k,l,m,n={},p=c(e(h,i),1),q=p.center().distance(d)>p.center().distance(b),r=q?d:b,s=q?b:d;return j?(k=g.point.fromPolar(p.width+p.height,o[j],r),k=p.pointNearestToPoint(k).move(k,-1)):k=p.pointNearestToPoint(r).move(r,1),l=f(k,s,p),k.round().equals(l.round())?(l=g.point.fromPolar(p.width+p.height,g.toRad(k.theta(r))+Math.PI/2,s),l=p.pointNearestToPoint(l).move(s,1).round(),m=f(k,l,p),n.points=q?[l,m,k]:[k,m,l]):n.points=q?[l,k]:[k,l],n.direction=q?a(k,d):a(l,d),n}function m(b,e,f){var m=e.elementPadding||20,n=[],o=c(f.sourceBBox,m),p=c(f.targetBBox,m);b=_.map(b,g.point),b.unshift(o.center()),b.push(p.center());for(var q,r=0,s=b.length-1;s>r;r++){var t=null,u=b[r],v=b[r+1],w=!!a(u,v);if(0==r)r+1==s?o.intersect(c(p,1))?t=l(u,v,o,p):w||(t=k(u,v,o,p)):o.containsPoint(v)?t=l(u,v,o,c(d(v),m)):w||(t=i(u,v,o));else if(r+1==s){var x=w&&a(v,u)==q;p.containsPoint(u)||x?t=l(u,v,c(d(u),m),p,q):w||(t=j(u,v,p,q))}else w||(t=h(u,v,q));t?(Array.prototype.push.apply(n,t.points),q=t.direction):q=a(u,v),s>r+1&&n.push(v)}return n}var n={N:"S",S:"N",E:"W",W:"E"},o={N:-Math.PI/2*3,S:-Math.PI/2,E:0,W:Math.PI};return m}(),joint.routers.manhattan=function(a,b){"use strict";function c(a){this.map={},this.options=a,this.mapGridSize=100}function d(){this.items=[],this.hash={},this.values={},this.OPEN=1,this.CLOSE=2}function e(a,b){for(var c,d=[],e={x:0,y:0},f=b;c=a[f];){var g=c.difference(f);g.equals(e)||(d.unshift(f),e=g),f=c}return d.unshift(f),d}function f(a,c,d){var e=d.step,f=a.center(),g=b.chain(d.directionMap).pick(c).map(function(b){var c=b.x*a.width/2,d=b.y*a.height/2,g=f.clone().offset(c,d);return a.containsPoint(g)&&g.offset(b.x*e,b.y*e),g.snapToGrid(e)}).value();return g}function g(b,c,d){var e=360/d;return Math.floor(a.normalizeAngle(b.theta(c)+e/2)/e)*e}function h(a,b){var c=Math.abs(a-b);return c>180?360-c:c}function i(a,b){for(var c=1/0,d=0,e=b.length;e>d;d++){var f=a.manhattanDistance(b[d]);c>f&&(c=f)}return c}function j(c,j,k,l){var m,n,o,p,q=l.step;if(c instanceof a.rect?(m=f(c,l.startDirections,l),o=c.center()):(o=c.clone().snapToGrid(q),m=[c]),j instanceof a.rect?(n=f(j,l.endDirections,l),p=j.center()):(p=j.clone().snapToGrid(q),n=[j]),m=b.filter(m,k.isPointAccessible,k),n=b.filter(n,k.isPointAccessible,k),m.length>0&&n.length>0){var r=new d,s={},t={};b.each(m,function(a){var b=a.toString();r.add(b,i(a,n)),t[b]=0});for(var u,v,w=l.directions,x=w.length,y=l.maximumLoops,z=b.invoke(n,"toString");!r.isEmpty()&&y>0;){var A=r.pop(),B=a.point(A),C=t[A],D=s[A]?g(s[A],B,x):null!=l.previousDirAngle?l.previousDirAngle:g(o,B,x);if(z.indexOf(A)>=0&&(v=h(D,g(B,p,x)),B.equals(p)||180>v))return l.previousDirAngle=D,e(s,B);for(var E=0;x>E;E++)if(u=w[E],v=h(D,u.angle),!(v>l.maxAllowedDirectionChange)){var F=B.clone().offset(u.offsetX,u.offsetY),G=F.toString();if(!r.isClose(G)&&k.isPointAccessible(F)){var H=C+u.cost+l.penalties[v];(!r.isOpen(G)||H<t[G])&&(s[G]=B,t[G]=H,r.add(G,H+i(F,n)))}}y--}}return l.fallbackRoute(o,p,l)}function k(c){c.directions=b.result(c,"directions"),c.penalties=b.result(c,"penalties"),c.paddingBox=b.result(c,"paddingBox"),b.each(c.directions,function(b){var c=new a.point(0,0),d=new a.point(b.offsetX,b.offsetY),e=a.normalizeAngle(c.theta(d));b.angle=e})}function l(d,e){k(e),this.options.perpendicular=!!e.perpendicular;for(var f=a.rect(this.sourceBBox).moveAndExpand(e.paddingBox),g=a.rect(this.targetBBox).moveAndExpand(e.paddingBox),h=new c(e).build(this.paper.model,this.model),i=b.map(d,a.point),l=[],m=f.center().snapToGrid(e.step),n=0,o=i.length;o>=n;n++){var p=null,q=r||f,r=i[n];if(!r){r=g;var s=!this.model.get("source").id||!this.model.get("target").id;if(s&&b.isFunction(e.draggingRoute)){var t=q instanceof a.rect?q.center():q;p=e.draggingRoute(t,r.origin(),e)}}p=p||j(q,r,h,e);var u=b.first(p);u&&u.equals(m)&&p.shift(),m=b.last(p)||m,Array.prototype.push.apply(l,p)}return l}var m={step:10,perpendicular:!0,excludeEnds:[],excludeTypes:["basic.Text"],maximumLoops:2e3,startDirections:["left","right","top","bottom"],endDirections:["left","right","top","bottom"],directionMap:{right:{x:1,y:0},bottom:{x:0,y:1},left:{x:-1,y:0},top:{x:0,y:-1}},maxAllowedDirectionChange:90,paddingBox:function(){var a=this.step;return{x:-a,y:-a,width:2*a,height:2*a}},directions:function(){var a=this.step;return[{offsetX:a,offsetY:0,cost:a},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:0,cost:a},{offsetX:0,offsetY:-a,cost:a}]},penalties:function(){return{0:0,45:this.step/2,90:this.step/2}},fallbackRoute:function(b,c,d){var e=(d.previousDirAngle||0)%180===0?a.point(b.x,c.y):a.point(c.x,b.y);return[e,c]},draggingRoute:null};return c.prototype.build=function(a,c){var d=this.options,e=b.chain(d.excludeEnds).map(c.get,c).pluck("id").map(a.getCell,a).value(),f=[],g=a.getCell(c.get("source").id);g&&(f=b.union(f,b.map(g.getAncestors(),"id")));var h=a.getCell(c.get("target").id);h&&(f=b.union(f,b.map(h.getAncestors(),"id")));var i=this.mapGridSize;return b.chain(a.getElements()).difference(e).reject(function(a){return b.contains(d.excludeTypes,a.get("type"))||b.contains(f,a.id)}).invoke("getBBox").invoke("moveAndExpand",d.paddingBox).foldl(function(a,b){for(var c=b.origin().snapToGrid(i),d=b.corner().snapToGrid(i),e=c.x;e<=d.x;e+=i)for(var f=c.y;f<=d.y;f+=i){var g=e+"@"+f;a[g]=a[g]||[],a[g].push(b)}return a},this.map).value(),this},c.prototype.isPointAccessible=function(a){var c=a.clone().snapToGrid(this.mapGridSize).toString();return b.every(this.map[c],function(b){return!b.containsPoint(a)})},d.prototype.add=function(a,c){this.hash[a]?this.items.splice(this.items.indexOf(a),1):this.hash[a]=this.OPEN,this.values[a]=c;var d=b.sortedIndex(this.items,a,function(a){return this.values[a]},this);this.items.splice(d,0,a)},d.prototype.remove=function(a){this.hash[a]=this.CLOSE},d.prototype.isOpen=function(a){return this.hash[a]===this.OPEN},d.prototype.isClose=function(a){return this.hash[a]===this.CLOSE},d.prototype.isEmpty=function(){return 0===this.items.length},d.prototype.pop=function(){var a=this.items.shift();return this.remove(a),a},function(a,c,d){return l.call(d,a,b.extend({},m,c))}}(g,_),joint.routers.metro=function(){if(!_.isFunction(joint.routers.manhattan))throw"Metro requires the manhattan router.";var a={diagonalCost:null,directions:function(){var a=this.step,b=this.diagonalCost||Math.ceil(Math.sqrt(a*a<<1));return[{offsetX:a,offsetY:0,cost:a},{offsetX:a,offsetY:a,cost:b},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:a,cost:b},{offsetX:-a,offsetY:0,cost:a},{offsetX:-a,offsetY:-a,cost:b},{offsetX:0,offsetY:-a,cost:a},{offsetX:a,offsetY:-a,cost:b}]},maxAllowedDirectionChange:45,fallbackRoute:function(a,b,c){var d=a.theta(b),e={x:b.x,y:a.y},f={x:a.x,y:b.y};if(d%180>90){var h=e;e=f,f=h}var i=45>d%90?e:f,j=g.line(a,i),k=90*Math.ceil(d/90),l=g.point.fromPolar(j.squaredLength(),g.toRad(k+135),i),m=g.line(b,l),n=j.intersection(m);return n?[n.round(),b]:[b]}};return function(b,c,d){return joint.routers.manhattan(b,_.extend({},a,c),d)}}(),joint.routers.oneSide=function(a,b,c){var d,e,f,g=b.side||"bottom",h=b.padding||40,i=c.sourceBBox,j=c.targetBBox,k=i.center(),l=j.center();switch(g){case"bottom":f=1,d="y",e="height";break;case"top":f=-1,d="y",e="height";break;case"left":f=-1,d="x",e="width";break;case"right":f=1,d="x",e="width";break;default:throw new Error("Router: invalid side")}return k[d]+=f*(i[e]/2+h),l[d]+=f*(j[e]/2+h),f*(k[d]-l[d])>0?l[d]=k[d]:k[d]=l[d],[k].concat(a,l)},joint.connectors.normal=function(a,b,c){var d=["M",a.x,a.y];return _.each(c,function(a){d.push(a.x,a.y)}),d.push(b.x,b.y),d.join(" ")},joint.connectors.rounded=function(a,b,c,d){var e,f,h,i,j,k,l=d.radius||10,m=["M",a.x,a.y];return _.each(c,function(d,n){j=c[n-1]||a,k=c[n+1]||b,h=i||g.point(d).distance(j)/2,i=g.point(d).distance(k)/2,e=g.point(d).move(j,-Math.min(l,h)).round(),f=g.point(d).move(k,-Math.min(l,i)).round(),m.push(e.x,e.y,"S",d.x,d.y,f.x,f.y,"L")}),m.push(b.x,b.y),m.join(" ")},joint.connectors.smooth=function(a,b,c){var d;if(c.length)d=g.bezier.curveThroughPoints([a].concat(c).concat([b]));else{var e=a.x<b.x?b.x-(b.x-a.x)/2:a.x-(a.x-b.x)/2;d=["M",a.x,a.y,"C",e,a.y,e,b.y,b.x,b.y]}return d.join(" ")},joint.connectors.jumpover=function(a,b){function c(a,c,d){var e=[].concat(a,d,c);return e.reduce(function(a,c,d){var f=e[d+1];return null!=f&&(a[d]=b.line(c,f)),a},[])}function d(a){var b=a.paper._jumpOverUpdateList;null==b&&(b=a.paper._jumpOverUpdateList=[],a.paper.on("cell:pointerup",e)),b.indexOf(a)<0&&(b.push(a),a.listenToOnce(a.model,"change:connector remove",function(){b.splice(b.indexOf(a),1)}))}function e(){for(var a=this._jumpOverUpdateList,b=0;b<a.length;b++)a[b].update()}function f(b,c){return a(c).map(function(a){return b.intersection(a)}).compact().value()}function g(a,c){return b.line(a,c).squaredLength()}function h(a,c,d){return c.reduce(function(e,f,g){if(f.skip===!0)return e;var h=e.pop()||a,i=b.point(f).move(h.start,-d),j=b.point(f).move(h.start,+d),k=c[g+1];if(null!=k){var m=j.distance(k);d>=m&&(j=k.move(h.start,m),k.skip=!0)}else{var n=i.distance(h.end);if(2*d+l>n)return e.push(h),e}if(e.length>0){var o=j.distance(e[0].start);if(2*d+l>o)return e.push(h),e}var p=b.line(i,j);return p.isJump=!0,e.push(b.line(h.start,i),p,b.line(j,h.end)),e},[])}function i(b,c,d){var e=["M",b[0].start.x,b[0].start.y],f=a(b).map(function(a){if(a.isJump){if("arc"===d){var b=a.start.difference(a.end),e=Number(b.x<0&&b.y<0);return["A",c,c,0,0,e,a.end.x,a.end.y]}if("gap"===d)return["M",a.end.x,a.end.y]}return["L",a.end.x,a.end.y]}).flatten().value();return[].concat(e,f).join(" ")}var j=5,k=["arc","gap"],l=1;return function(b,e,l,m){d(this);var n=m.size||j,o=m.jump&&(""+m.jump).toLowerCase();-1===k.indexOf(o)&&(o=k[0]);var p=this.paper,q=p.model,r=q.getLinks();if(1===r.length)return i(c(b,e,l),n,o);var s=this.model,t=r.indexOf(s),u=r.filter(function(a,b){if(b>t){var c=a.get("connector");return!(c&&"jumpover"===c.name)}return!0}),v=u.map(function(a){return p.findViewByModel(a)}),w=v.map(function(a){return null==a?[]:c(a.sourcePoint,a.targetPoint,a.route)}),x=w[t],y=x.reduce(function(b,c){var d=a(u).map(function(a,b){return a===s?null:f(c,w[b])}).flatten().compact().sortBy(a.partial(g,c.start)).value();return d.length>0?b.push.apply(b,h(c,d,n)):b.push(c),b},[]);return i(y,n,o)}}(_,g);
joint.shapes.erd={},joint.shapes.erd.Entity=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.Entity",size:{width:150,height:60},attrs:{".outer":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"100,0 100,60 0,60 0,0"},".inner":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"95,5 95,55 5,55 5,5",display:"none"},text:{text:"Entity","font-family":"Arial","font-size":14,ref:".outer","ref-x":.5,"ref-y":.5,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.WeakEntity=joint.shapes.erd.Entity.extend({defaults:joint.util.deepSupplement({type:"erd.WeakEntity",attrs:{".inner":{display:"auto"},text:{text:"Weak Entity"}}},joint.shapes.erd.Entity.prototype.defaults)}),joint.shapes.erd.Relationship=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.Relationship",size:{width:80,height:80},attrs:{".outer":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,0 80,40 40,80 0,40"},".inner":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,5 75,40 40,75 5,40",display:"none"},text:{text:"Relationship","font-family":"Arial","font-size":12,ref:".","ref-x":.5,"ref-y":.5,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.IdentifyingRelationship=joint.shapes.erd.Relationship.extend({defaults:joint.util.deepSupplement({type:"erd.IdentifyingRelationship",attrs:{".inner":{display:"auto"},text:{text:"Identifying"}}},joint.shapes.erd.Relationship.prototype.defaults)}),joint.shapes.erd.Attribute=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><ellipse class="outer"/><ellipse class="inner"/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.Attribute",size:{width:100,height:50},attrs:{ellipse:{transform:"translate(50, 25)"},".outer":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:50,ry:25,fill:"#E67E22"},".inner":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:45,ry:20,fill:"#E67E22",display:"none"},text:{"font-family":"Arial","font-size":14,ref:".","ref-x":.5,"ref-y":.5,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.Multivalued=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Multivalued",attrs:{".inner":{display:"block"},text:{text:"multivalued"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.Derived=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Derived",attrs:{".outer":{"stroke-dasharray":"3,5"},text:{text:"derived"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.Key=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Key",attrs:{ellipse:{"stroke-width":4},text:{text:"key","font-weight":"800","text-decoration":"underline"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.Normal=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Normal",attrs:{text:{text:"Normal"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.ISA=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.ISA",size:{width:100,height:50},attrs:{polygon:{points:"0,0 50,50 100,0",fill:"#F1C40F",stroke:"#F39C12","stroke-width":2},text:{text:"ISA","font-size":18,ref:"polygon","ref-x":.5,"ref-y":.3,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.Line=joint.dia.Link.extend({defaults:{type:"erd.Line"},cardinality:function(a){this.set("labels",[{position:-20,attrs:{text:{dy:-8,text:a}}}])}});
joint.shapes.fsa={},joint.shapes.fsa.State=joint.shapes.basic.Circle.extend({defaults:joint.util.deepSupplement({type:"fsa.State",attrs:{circle:{"stroke-width":3},text:{"font-weight":"800"}}},joint.shapes.basic.Circle.prototype.defaults)}),joint.shapes.fsa.StartState=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><circle/></g></g>',defaults:joint.util.deepSupplement({type:"fsa.StartState",size:{width:20,height:20},attrs:{circle:{transform:"translate(10, 10)",r:10,fill:"#000000"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.fsa.EndState=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>',defaults:joint.util.deepSupplement({type:"fsa.EndState",size:{width:20,height:20},attrs:{".outer":{transform:"translate(10, 10)",r:10,fill:"#ffffff",stroke:"#000000"},".inner":{transform:"translate(10, 10)",r:6,fill:"#000000"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.fsa.Arrow=joint.dia.Link.extend({defaults:joint.util.deepSupplement({type:"fsa.Arrow",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}},smooth:!0},joint.dia.Link.prototype.defaults)});
joint.shapes.org={},joint.shapes.org.Member=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="card"/><image/></g><text class="rank"/><text class="name"/></g>',defaults:joint.util.deepSupplement({type:"org.Member",size:{width:180,height:70},attrs:{rect:{width:170,height:60},".card":{fill:"#FFFFFF",stroke:"#000000","stroke-width":2,"pointer-events":"visiblePainted",rx:10,ry:10},image:{width:48,height:48,ref:".card","ref-x":10,"ref-y":5},".rank":{"text-decoration":"underline",ref:".card","ref-x":.9,"ref-y":.2,"font-family":"Courier New","font-size":14,"text-anchor":"end"},".name":{"font-weight":"800",ref:".card","ref-x":.9,"ref-y":.6,"font-family":"Courier New","font-size":14,"text-anchor":"end"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.org.Arrow=joint.dia.Link.extend({defaults:{type:"org.Arrow",source:{selector:".card"},target:{selector:".card"},attrs:{".connection":{stroke:"#585858","stroke-width":3}},z:-1}});
joint.shapes.chess={},joint.shapes.chess.KingWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;"><path      d="M 22.5,11.63 L 22.5,6"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 20,8 L 25,8"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"      style="fill:#ffffff; stroke:#000000; stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 11.5,30 C 17,27 27,27 32.5,30"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,37 C 17,34 27,34 32.5,37"      style="fill:none; stroke:#000000;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KingWhite",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.KingBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path       d="M 22.5,11.63 L 22.5,6"       style="fill:none; stroke:#000000; stroke-linejoin:miter;"       id="path6570" />    <path       d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"       style="fill:#000000;fill-opacity:1; stroke-linecap:butt; stroke-linejoin:miter;" />    <path       d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "       style="fill:#000000; stroke:#000000;" />    <path       d="M 20,8 L 25,8"       style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path       d="M 32,29.5 C 32,29.5 40.5,25.5 38.03,19.85 C 34.15,14 25,18 22.5,24.5 L 22.51,26.6 L 22.5,24.5 C 20,18 9.906,14 6.997,19.85 C 4.5,25.5 11.85,28.85 11.85,28.85"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,30 C 17,27 27,27 32.5,30 M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5 M 11.5,37 C 17,34 27,34 32.5,37"       style="fill:none; stroke:#ffffff;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KingBlack",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.QueenWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(-1,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(15.5,-5.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(32,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(7,-4.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(24,-4)" />    <path      d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38,14 L 31,25 L 31,11 L 25.5,24.5 L 22.5,9.5 L 19.5,24.5 L 14,10.5 L 14,25 L 7,14 L 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 11.5,30 C 15,29 30,29 33.5,30"      style="fill:none;" />    <path      d="M 12,33.5 C 18,32.5 27,32.5 33,33.5"      style="fill:none;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.QueenWhite",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.QueenBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:none;">      <circle cx="6"    cy="12" r="2.75" />      <circle cx="14"   cy="9"  r="2.75" />      <circle cx="22.5" cy="8"  r="2.75" />      <circle cx="31"   cy="9"  r="2.75" />      <circle cx="39"   cy="12" r="2.75" />    </g>    <path       d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38.5,13.5 L 31,25 L 30.7,10.9 L 25.5,24.5 L 22.5,10 L 19.5,24.5 L 14.3,10.9 L 14,25 L 6.5,13.5 L 9,26 z"       style="stroke-linecap:butt; stroke:#000000;" />    <path       d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z"       style="stroke-linecap:butt;" />    <path       d="M 11,38.5 A 35,35 1 0 0 34,38.5"       style="fill:none; stroke:#000000; stroke-linecap:butt;" />    <path       d="M 11,29 A 35,35 1 0 1 34,29"       style="fill:none; stroke:#ffffff;" />    <path       d="M 12.5,31.5 L 32.5,31.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,34.5 A 35,35 1 0 0 33.5,34.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 10.5,37.5 A 35,35 1 0 0 34.5,37.5"       style="fill:none; stroke:#ffffff;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.QueenBlack",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.RookWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14"      style="stroke-linecap:butt;" />    <path      d="M 34,14 L 31,17 L 14,17 L 11,14" />    <path      d="M 31,17 L 31,29.5 L 14,29.5 L 14,17"      style="stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 31,29.5 L 32.5,32 L 12.5,32 L 14,29.5" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.RookWhite",size:{width:32,height:34}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.RookBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12.5,32 L 14,29.5 L 31,29.5 L 32.5,32 L 12.5,32 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 14,29.5 L 14,16.5 L 31,16.5 L 31,29.5 L 14,29.5 z "      style="stroke-linecap:butt;stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 11,14 L 34,14 L 31,16.5 L 14,16.5 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14 L 11,14 z "      style="stroke-linecap:butt;" />    <path      d="M 12,35.5 L 33,35.5 L 33,35.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 13,31.5 L 32,31.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,29.5 L 31,29.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 31,16.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.RookBlack",size:{width:32,height:34}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.BishopWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#ffffff; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path      d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.BishopWhite",size:{width:38,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.BishopBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path       d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"       style="fill:none; stroke:#ffffff; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.BishopBlack",size:{width:38,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.KnightWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#000000; stroke:#000000;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#000000; stroke:#000000;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KnightWhite",size:{width:38,height:37}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.KnightBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#000000; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#000000; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 24.55,10.4 L 24.1,11.85 L 24.6,12 C 27.75,13 30.25,14.49 32.5,18.75 C 34.75,23.01 35.75,29.06 35.25,39 L 35.2,39.5 L 37.45,39.5 L 37.5,39 C 38,28.94 36.62,22.15 34.25,17.66 C 31.88,13.17 28.46,11.02 25.06,10.5 L 24.55,10.4 z "      style="fill:#ffffff; stroke:none;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KnightBlack",size:{width:38,height:37}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.PawnWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>',defaults:joint.util.deepSupplement({type:"chess.PawnWhite",size:{width:28,height:33}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.PawnBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>',defaults:joint.util.deepSupplement({type:"chess.PawnBlack",size:{width:28,height:33}},joint.shapes.basic.Generic.prototype.defaults)});
joint.shapes.pn={},joint.shapes.pn.Place=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="root"/><g class="tokens" /></g><text class="label"/></g>',defaults:joint.util.deepSupplement({type:"pn.Place",size:{width:50,height:50},attrs:{".root":{r:25,fill:"#ffffff",stroke:"#000000",transform:"translate(25, 25)"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:".root",fill:"#000000","font-size":12},".tokens > circle":{fill:"#000000",r:5},".tokens.one > circle":{transform:"translate(25, 25)"},".tokens.two > circle:nth-child(1)":{transform:"translate(19, 25)"},".tokens.two > circle:nth-child(2)":{transform:"translate(31, 25)"},".tokens.three > circle:nth-child(1)":{transform:"translate(18, 29)"},".tokens.three > circle:nth-child(2)":{transform:"translate(25, 19)"},".tokens.three > circle:nth-child(3)":{transform:"translate(32, 29)"},".tokens.alot > text":{transform:"translate(25, 18)","text-anchor":"middle",fill:"#000000"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.pn.PlaceView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.model.on("change:tokens",function(){this.renderTokens(),this.update()},this)},render:function(){joint.dia.ElementView.prototype.render.apply(this,arguments),this.renderTokens(),this.update()},renderTokens:function(){var a=this.$(".tokens").empty();a[0].className.baseVal="tokens";var b=this.model.get("tokens");if(b)switch(b){case 1:a[0].className.baseVal+=" one",a.append(V("<circle/>").node);break;case 2:a[0].className.baseVal+=" two",a.append(V("<circle/>").node,V("<circle/>").node);break;case 3:a[0].className.baseVal+=" three",a.append(V("<circle/>").node,V("<circle/>").node,V("<circle/>").node);break;default:a[0].className.baseVal+=" alot",a.append(V("<text/>").text(b+"").node)}}}),joint.shapes.pn.Transition=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="root"/></g></g><text class="label"/>',defaults:joint.util.deepSupplement({type:"pn.Transition",size:{width:12,height:50},attrs:{rect:{width:12,height:50,fill:"#000000",stroke:"#000000"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:"rect",fill:"#000000","font-size":12}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.pn.Link=joint.dia.Link.extend({defaults:joint.util.deepSupplement({type:"pn.Link",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}}},joint.dia.Link.prototype.defaults)});
joint.shapes.devs={},joint.shapes.devs.Model=joint.shapes.basic.Generic.extend(_.extend({},joint.shapes.basic.PortsModelInterface,{markup:'<g class="rotatable"><g class="scalable"><rect class="body"/></g><text class="label"/><g class="inPorts"/><g class="outPorts"/></g>',portMarkup:'<g class="port port<%= id %>"><circle class="port-body"/><text class="port-label"/></g>',defaults:joint.util.deepSupplement({type:"devs.Model",size:{width:1,height:1},inPorts:[],outPorts:[],attrs:{".":{magnet:!1},".body":{width:150,height:250,stroke:"#000000"},".port-body":{r:10,magnet:!0,stroke:"#000000"},text:{"pointer-events":"none"},".label":{text:"Model","ref-x":.5,"ref-y":10,ref:".body","text-anchor":"middle",fill:"#000000"},".inPorts .port-label":{x:-15,dy:4,"text-anchor":"end",fill:"#000000"},".outPorts .port-label":{x:15,dy:4,fill:"#000000"}}},joint.shapes.basic.Generic.prototype.defaults),getPortAttrs:function(a,b,c,d,e){var f={},g="port"+b,h=d+">."+g,i=h+">.port-label",j=h+">.port-body";return f[i]={text:a},f[j]={port:{id:a||_.uniqueId(e),type:e}},f[h]={ref:".body","ref-y":(b+.5)*(1/c)},".outPorts"===d&&(f[h]["ref-dx"]=0),f}})),joint.shapes.devs.Atomic=joint.shapes.devs.Model.extend({defaults:joint.util.deepSupplement({type:"devs.Atomic",size:{width:80,height:80},attrs:{".body":{fill:"salmon"},".label":{text:"Atomic"},".inPorts .port-body":{fill:"PaleGreen"},".outPorts .port-body":{fill:"Tomato"}}},joint.shapes.devs.Model.prototype.defaults)}),joint.shapes.devs.Coupled=joint.shapes.devs.Model.extend({defaults:joint.util.deepSupplement({type:"devs.Coupled",size:{width:200,height:300},attrs:{".body":{fill:"seaGreen"},".label":{text:"Coupled"},".inPorts .port-body":{fill:"PaleGreen"},".outPorts .port-body":{fill:"Tomato"}}},joint.shapes.devs.Model.prototype.defaults)}),joint.shapes.devs.Link=joint.dia.Link.extend({defaults:{type:"devs.Link",attrs:{".connection":{"stroke-width":2}}}}),joint.shapes.devs.ModelView=joint.dia.ElementView.extend(joint.shapes.basic.PortsViewInterface),joint.shapes.devs.AtomicView=joint.shapes.devs.ModelView,joint.shapes.devs.CoupledView=joint.shapes.devs.ModelView;
joint.shapes.uml={},joint.shapes.uml.Class=joint.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable">','<rect class="uml-class-name-rect"/><rect class="uml-class-attrs-rect"/><rect class="uml-class-methods-rect"/>',"</g>",'<text class="uml-class-name-text"/><text class="uml-class-attrs-text"/><text class="uml-class-methods-text"/>',"</g>"].join(""),defaults:joint.util.deepSupplement({type:"uml.Class",attrs:{rect:{width:200},".uml-class-name-rect":{stroke:"black","stroke-width":2,fill:"#3498db"},".uml-class-attrs-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-methods-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-name-text":{ref:".uml-class-name-rect","ref-y":.5,"ref-x":.5,"text-anchor":"middle","y-alignment":"middle","font-weight":"bold",fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-attrs-text":{ref:".uml-class-attrs-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-methods-text":{ref:".uml-class-methods-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"}},name:[],attributes:[],methods:[]},joint.shapes.basic.Generic.prototype.defaults),initialize:function(){this.on("change:name change:attributes change:methods",function(){this.updateRectangles(),this.trigger("uml-update")},this),this.updateRectangles(),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},getClassName:function(){return this.get("name")},updateRectangles:function(){var a=this.get("attrs"),b=[{type:"name",text:this.getClassName()},{type:"attrs",text:this.get("attributes")},{type:"methods",text:this.get("methods")}],c=0;_.each(b,function(b){var d=_.isArray(b.text)?b.text:[b.text],e=20*d.length+20;a[".uml-class-"+b.type+"-text"].text=d.join("\n"),a[".uml-class-"+b.type+"-rect"].height=e,a[".uml-class-"+b.type+"-rect"].transform="translate(0,"+c+")",c+=e})}}),joint.shapes.uml.ClassView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"uml-update",function(){this.update(),this.resize()})}}),joint.shapes.uml.Abstract=joint.shapes.uml.Class.extend({defaults:joint.util.deepSupplement({type:"uml.Abstract",attrs:{".uml-class-name-rect":{fill:"#e74c3c"},".uml-class-attrs-rect":{fill:"#c0392b"},".uml-class-methods-rect":{fill:"#c0392b"}}},joint.shapes.uml.Class.prototype.defaults),getClassName:function(){return["<<Abstract>>",this.get("name")]}}),joint.shapes.uml.AbstractView=joint.shapes.uml.ClassView,joint.shapes.uml.Interface=joint.shapes.uml.Class.extend({defaults:joint.util.deepSupplement({type:"uml.Interface",attrs:{".uml-class-name-rect":{fill:"#f1c40f"},".uml-class-attrs-rect":{fill:"#f39c12"},".uml-class-methods-rect":{fill:"#f39c12"}}},joint.shapes.uml.Class.prototype.defaults),getClassName:function(){return["<<Interface>>",this.get("name")]}}),joint.shapes.uml.InterfaceView=joint.shapes.uml.ClassView,joint.shapes.uml.Generalization=joint.dia.Link.extend({defaults:{type:"uml.Generalization",attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"}}}}),joint.shapes.uml.Implementation=joint.dia.Link.extend({defaults:{type:"uml.Implementation",attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"},".connection":{"stroke-dasharray":"3,3"}}}}),joint.shapes.uml.Aggregation=joint.dia.Link.extend({defaults:{type:"uml.Aggregation",attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"white"}}}}),joint.shapes.uml.Composition=joint.dia.Link.extend({defaults:{type:"uml.Composition",attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"black"}}}}),joint.shapes.uml.Association=joint.dia.Link.extend({defaults:{type:"uml.Association"}}),joint.shapes.uml.State=joint.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable">','<rect class="uml-state-body"/>',"</g>",'<path class="uml-state-separator"/>','<text class="uml-state-name"/>','<text class="uml-state-events"/>',"</g>"].join(""),defaults:joint.util.deepSupplement({type:"uml.State",attrs:{".uml-state-body":{width:200,height:200,rx:10,ry:10,fill:"#ecf0f1",stroke:"#bdc3c7","stroke-width":3},".uml-state-separator":{stroke:"#bdc3c7","stroke-width":2},".uml-state-name":{ref:".uml-state-body","ref-x":.5,"ref-y":5,"text-anchor":"middle",fill:"#000000","font-family":"Courier New","font-size":14},".uml-state-events":{ref:".uml-state-separator","ref-x":5,"ref-y":5,fill:"#000000","font-family":"Courier New","font-size":14}},name:"State",events:[]},joint.shapes.basic.Generic.prototype.defaults),initialize:function(){this.on({"change:name":this.updateName,"change:events":this.updateEvents,"change:size":this.updatePath},this),this.updateName(),this.updateEvents(),this.updatePath(),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},updateName:function(){this.attr(".uml-state-name/text",this.get("name"))},updateEvents:function(){this.attr(".uml-state-events/text",this.get("events").join("\n"))},updatePath:function(){var a="M 0 20 L "+this.get("size").width+" 20";this.attr(".uml-state-separator/d",a,{silent:!0})}}),joint.shapes.uml.StartState=joint.shapes.basic.Circle.extend({defaults:joint.util.deepSupplement({type:"uml.StartState",attrs:{circle:{fill:"#34495e",stroke:"#2c3e50","stroke-width":2,rx:1}}},joint.shapes.basic.Circle.prototype.defaults)}),joint.shapes.uml.EndState=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>',defaults:joint.util.deepSupplement({type:"uml.EndState",size:{width:20,height:20},attrs:{"circle.outer":{transform:"translate(10, 10)",r:10,fill:"#ffffff",stroke:"#2c3e50"},"circle.inner":{transform:"translate(10, 10)",r:6,fill:"#34495e"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.uml.Transition=joint.dia.Link.extend({defaults:{type:"uml.Transition",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z",fill:"#34495e",stroke:"#2c3e50"},".connection":{stroke:"#2c3e50"}}}});
joint.shapes.logic={},joint.shapes.logic.Gate=joint.shapes.basic.Generic.extend({defaults:joint.util.deepSupplement({type:"logic.Gate",size:{width:80,height:40},attrs:{".":{magnet:!1},".body":{width:100,height:50},circle:{r:7,stroke:"black",fill:"transparent","stroke-width":2}}},joint.shapes.basic.Generic.prototype.defaults),operation:function(){return!0}}),joint.shapes.logic.IO=joint.shapes.logic.Gate.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="body"/></g><path class="wire"/><circle/><text/></g>',defaults:joint.util.deepSupplement({type:"logic.IO",size:{width:60,height:30},attrs:{".body":{fill:"white",stroke:"black","stroke-width":2},".wire":{ref:".body","ref-y":.5,stroke:"black"},text:{fill:"black",ref:".body","ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle","font-weight":"bold","font-variant":"small-caps","text-transform":"capitalize","font-size":"14px"}}},joint.shapes.logic.Gate.prototype.defaults)}),joint.shapes.logic.Input=joint.shapes.logic.IO.extend({defaults:joint.util.deepSupplement({type:"logic.Input",attrs:{".wire":{"ref-dx":0,d:"M 0 0 L 23 0"},circle:{ref:".body","ref-dx":30,"ref-y":.5,magnet:!0,"class":"output",port:"out"},text:{text:"input"}}},joint.shapes.logic.IO.prototype.defaults)}),joint.shapes.logic.Output=joint.shapes.logic.IO.extend({defaults:joint.util.deepSupplement({type:"logic.Output",attrs:{".wire":{"ref-x":0,d:"M 0 0 L -23 0"},circle:{ref:".body","ref-x":-30,"ref-y":.5,magnet:"passive","class":"input",port:"in"},text:{text:"output"}}},joint.shapes.logic.IO.prototype.defaults)}),joint.shapes.logic.Gate11=joint.shapes.logic.Gate.extend({markup:'<g class="rotatable"><g class="scalable"><image class="body"/></g><circle class="input"/><circle class="output"/></g>',defaults:joint.util.deepSupplement({type:"logic.Gate11",attrs:{".input":{ref:".body","ref-x":-2,"ref-y":.5,magnet:"passive",port:"in"},".output":{ref:".body","ref-dx":2,"ref-y":.5,magnet:!0,port:"out"}}},joint.shapes.logic.Gate.prototype.defaults)}),joint.shapes.logic.Gate21=joint.shapes.logic.Gate.extend({markup:'<g class="rotatable"><g class="scalable"><image class="body"/></g><circle class="input input1"/><circle  class="input input2"/><circle class="output"/></g>',defaults:joint.util.deepSupplement({type:"logic.Gate21",attrs:{".input1":{ref:".body","ref-x":-2,"ref-y":.3,magnet:"passive",port:"in1"},".input2":{ref:".body","ref-x":-2,"ref-y":.7,magnet:"passive",port:"in2"},".output":{ref:".body","ref-dx":2,"ref-y":.5,magnet:!0,port:"out"}}},joint.shapes.logic.Gate.prototype.defaults)}),joint.shapes.logic.Repeater=joint.shapes.logic.Gate11.extend({defaults:joint.util.deepSupplement({type:"logic.Repeater",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},joint.shapes.logic.Gate11.prototype.defaults),operation:function(a){return a}}),joint.shapes.logic.Not=joint.shapes.logic.Gate11.extend({defaults:joint.util.deepSupplement({type:"logic.Not",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},joint.shapes.logic.Gate11.prototype.defaults),operation:function(a){return!a}}),joint.shapes.logic.Or=joint.shapes.logic.Gate21.extend({defaults:joint.util.deepSupplement({type:"logic.Or",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},joint.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return a||b}}),joint.shapes.logic.And=joint.shapes.logic.Gate21.extend({defaults:joint.util.deepSupplement({type:"logic.And",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},joint.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return a&&b}}),joint.shapes.logic.Nor=joint.shapes.logic.Gate21.extend({defaults:joint.util.deepSupplement({type:"logic.Nor",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"
}}},joint.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return!(a||b)}}),joint.shapes.logic.Nand=joint.shapes.logic.Gate21.extend({defaults:joint.util.deepSupplement({type:"logic.Nand",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},joint.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return!(a&&b)}}),joint.shapes.logic.Xor=joint.shapes.logic.Gate21.extend({defaults:joint.util.deepSupplement({type:"logic.Xor",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},joint.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return(!a||b)&&(a||!b)}}),joint.shapes.logic.Xnor=joint.shapes.logic.Gate21.extend({defaults:joint.util.deepSupplement({type:"logic.Xnor",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnCiAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIKICAgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIgogICB4bWxuczpzdmc9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiAgIHhtbG5zOnNvZGlwb2RpPSJodHRwOi8vc29kaXBvZGkuc291cmNlZm9yZ2UubmV0L0RURC9zb2RpcG9kaS0wLmR0ZCIKICAgeG1sbnM6aW5rc2NhcGU9Imh0dHA6Ly93d3cuaW5rc2NhcGUub3JnL25hbWVzcGFjZXMvaW5rc2NhcGUiCiAgIHdpZHRoPSIxMDAiCiAgIGhlaWdodD0iNTAiCiAgIGlkPSJzdmcyIgogICBzb2RpcG9kaTp2ZXJzaW9uPSIwLjMyIgogICBpbmtzY2FwZTp2ZXJzaW9uPSIwLjQ2IgogICB2ZXJzaW9uPSIxLjAiCiAgIHNvZGlwb2RpOmRvY25hbWU9IlhOT1IgQU5TSS5zdmciCiAgIGlua3NjYXBlOm91dHB1dF9leHRlbnNpb249Im9yZy5pbmtzY2FwZS5vdXRwdXQuc3ZnLmlua3NjYXBlIj4KICA8ZGVmcwogICAgIGlkPSJkZWZzNCI+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogMTUgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfej0iNTAgOiAxNSA6IDEiCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMjUgOiAxMCA6IDEiCiAgICAgICBpZD0icGVyc3BlY3RpdmUyNzE0IiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDAuNSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF96PSIxIDogMC41IDogMSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIwLjUgOiAwLjMzMzMzMzMzIDogMSIKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI4MDYiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI4MTkiCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMzcyLjA0NzI0IDogMzUwLjc4NzM5IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9Ijc0NC4wOTQ0OCA6IDUyNi4xODEwOSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogNTI2LjE4MTA5IDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI3NzciCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iNzUgOiA0MCA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSIxNTAgOiA2MCA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogNjAgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlMzI3NSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSI1MCA6IDMzLjMzMzMzMyA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSIxMDAgOiA1MCA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogNTAgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlNTUzMyIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIzMiA6IDIxLjMzMzMzMyA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSI2NCA6IDMyIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiAzMiA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmUyNTU3IgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjI1IDogMTYuNjY2NjY3IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjUwIDogMjUgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDI1IDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgPC9kZWZzPgogIDxzb2RpcG9kaTpuYW1lZHZpZXcKICAgICBpZD0iYmFzZSIKICAgICBwYWdlY29sb3I9IiNmZmZmZmYiCiAgICAgYm9yZGVyY29sb3I9IiM2NjY2NjYiCiAgICAgYm9yZGVyb3BhY2l0eT0iMS4wIgogICAgIGlua3NjYXBlOnBhZ2VvcGFjaXR5PSIwLjAiCiAgICAgaW5rc2NhcGU6cGFnZXNoYWRvdz0iMiIKICAgICBpbmtzY2FwZTp6b29tPSI0IgogICAgIGlua3NjYXBlOmN4PSI5NS43MjM2NiIKICAgICBpbmtzY2FwZTpjeT0iLTI2Ljc3NTAyMyIKICAgICBpbmtzY2FwZTpkb2N1bWVudC11bml0cz0icHgiCiAgICAgaW5rc2NhcGU6Y3VycmVudC1sYXllcj0ibGF5ZXIxIgogICAgIHNob3dncmlkPSJ0cnVlIgogICAgIGlua3NjYXBlOmdyaWQtYmJveD0idHJ1ZSIKICAgICBpbmtzY2FwZTpncmlkLXBvaW50cz0idHJ1ZSIKICAgICBncmlkdG9sZXJhbmNlPSIxMDAwMCIKICAgICBpbmtzY2FwZTp3aW5kb3ctd2lkdGg9IjEzOTkiCiAgICAgaW5rc2NhcGU6d2luZG93LWhlaWdodD0iODc0IgogICAgIGlua3NjYXBlOndpbmRvdy14PSIzMyIKICAgICBpbmtzY2FwZTp3aW5kb3cteT0iMCIKICAgICBpbmtzY2FwZTpzbmFwLWJib3g9InRydWUiPgogICAgPGlua3NjYXBlOmdyaWQKICAgICAgIGlkPSJHcmlkRnJvbVByZTA0NlNldHRpbmdzIgogICAgICAgdHlwZT0ieHlncmlkIgogICAgICAgb3JpZ2lueD0iMHB4IgogICAgICAgb3JpZ2lueT0iMHB4IgogICAgICAgc3BhY2luZ3g9IjFweCIKICAgICAgIHNwYWNpbmd5PSIxcHgiCiAgICAgICBjb2xvcj0iIzAwMDBmZiIKICAgICAgIGVtcGNvbG9yPSIjMDAwMGZmIgogICAgICAgb3BhY2l0eT0iMC4yIgogICAgICAgZW1wb3BhY2l0eT0iMC40IgogICAgICAgZW1wc3BhY2luZz0iNSIKICAgICAgIHZpc2libGU9InRydWUiCiAgICAgICBlbmFibGVkPSJ0cnVlIiAvPgogIDwvc29kaXBvZGk6bmFtZWR2aWV3PgogIDxtZXRhZGF0YQogICAgIGlkPSJtZXRhZGF0YTciPgogICAgPHJkZjpSREY+CiAgICAgIDxjYzpXb3JrCiAgICAgICAgIHJkZjphYm91dD0iIj4KICAgICAgICA8ZGM6Zm9ybWF0PmltYWdlL3N2Zyt4bWw8L2RjOmZvcm1hdD4KICAgICAgICA8ZGM6dHlwZQogICAgICAgICAgIHJkZjpyZXNvdXJjZT0iaHR0cDovL3B1cmwub3JnL2RjL2RjbWl0eXBlL1N0aWxsSW1hZ2UiIC8+CiAgICAgIDwvY2M6V29yaz4KICAgIDwvcmRmOlJERj4KICA8L21ldGFkYXRhPgogIDxnCiAgICAgaW5rc2NhcGU6bGFiZWw9IkxheWVyIDEiCiAgICAgaW5rc2NhcGU6Z3JvdXBtb2RlPSJsYXllciIKICAgICBpZD0ibGF5ZXIxIj4KICAgIDxwYXRoCiAgICAgICBzdHlsZT0iZmlsbDpub25lO3N0cm9rZTojMDAwMDAwO3N0cm9rZS13aWR0aDoyLjAwMDAwMDI0O3N0cm9rZS1saW5lY2FwOmJ1dHQ7c3Ryb2tlLWxpbmVqb2luOm1pdGVyO3N0cm9rZS1vcGFjaXR5OjEiCiAgICAgICBkPSJNIDc4LjMzMzMzMiwyNSBDIDkxLjY2NjY2NiwyNSA5NSwyNSA5NSwyNSIKICAgICAgIGlkPSJwYXRoMzA1OSIKICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2MiIC8+CiAgICA8cGF0aAogICAgICAgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6IzAwMDAwMDtzdHJva2Utd2lkdGg6MS45OTk5OTk4ODtzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgZD0iTSAzMC4zODU3MTcsMTUgTCA0Ljk5OTk5OTgsMTUiCiAgICAgICBpZD0icGF0aDMwNjEiIC8+CiAgICA8cGF0aAogICAgICAgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6IzAwMDAwMDtzdHJva2Utd2lkdGg6MS45OTk5OTk3NjtzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgZD0iTSAzMS4zNjIwOTEsMzUgTCA0Ljk5OTk5OTgsMzUiCiAgICAgICBpZD0icGF0aDM5NDQiIC8+CiAgICA8ZwogICAgICAgaWQ9ImcyNTYwIgogICAgICAgaW5rc2NhcGU6bGFiZWw9IkxheWVyIDEiCiAgICAgICB0cmFuc2Zvcm09InRyYW5zbGF0ZSgyNi41LC0zOS41KSI+CiAgICAgIDxwYXRoCiAgICAgICAgIGlkPSJwYXRoMzUxNiIKICAgICAgICAgc3R5bGU9ImZpbGw6IzAwMDAwMDtmaWxsLW9wYWNpdHk6MTtmaWxsLXJ1bGU6ZXZlbm9kZDtzdHJva2U6bm9uZTtzdHJva2Utd2lkdGg6MztzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgICBkPSJNIC0yLjI1LDgxLjUwMDAwNSBDIC0zLjg0NzM3NCw4NC4xNDQ0MDUgLTQuNSw4NC41MDAwMDUgLTQuNSw4NC41MDAwMDUgTCAtOC4xNTYyNSw4NC41MDAwMDUgTCAtNi4xNTYyNSw4Mi4wNjI1MDUgQyAtNi4xNTYyNSw4Mi4wNjI1MDUgLTAuNSw3NS4wNjI0NTEgLTAuNSw2NC41IEMgLTAuNSw1My45Mzc1NDkgLTYuMTU2MjUsNDYuOTM3NSAtNi4xNTYyNSw0Ni45Mzc1IEwgLTguMTU2MjUsNDQuNSBMIC00LjUsNDQuNSBDIC0zLjcxODc1LDQ1LjQzNzUgLTMuMDc4MTI1LDQ2LjE1NjI1IC0yLjI4MTI1LDQ3LjUgQyAtMC40MDg1MzEsNTAuNTk5ODE1IDIuNSw1Ni41MjY2NDYgMi41LDY0LjUgQyAyLjUsNzIuNDUwNjUgLTAuMzk2Njk3LDc4LjM3OTQyNSAtMi4yNSw4MS41MDAwMDUgeiIKICAgICAgICAgc29kaXBvZGk6bm9kZXR5cGVzPSJjY2Njc2NjY2NzYyIgLz4KICAgICAgPHBhdGgKICAgICAgICAgc3R5bGU9ImZpbGw6IzAwMDAwMDtmaWxsLW9wYWNpdHk6MTtmaWxsLXJ1bGU6ZXZlbm9kZDtzdHJva2U6bm9uZTtzdHJva2Utd2lkdGg6MztzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgICBkPSJNIC0yLjQwNjI1LDQ0LjUgTCAtMC40MDYyNSw0Ni45Mzc1IEMgLTAuNDA2MjUsNDYuOTM3NSA1LjI1LDUzLjkzNzU0OSA1LjI1LDY0LjUgQyA1LjI1LDc1LjA2MjQ1MSAtMC40MDYyNSw4Mi4wNjI1IC0wLjQwNjI1LDgyLjA2MjUgTCAtMi40MDYyNSw4NC41IEwgMC43NSw4NC41IEwgMTQuNzUsODQuNSBDIDE3LjE1ODA3Niw4NC41MDAwMDEgMjIuNDM5Njk5LDg0LjUyNDUxNCAyOC4zNzUsODIuMDkzNzUgQyAzNC4zMTAzMDEsNzkuNjYyOTg2IDQwLjkxMTUzNiw3NC43NTA0ODQgNDYuMDYyNSw2NS4yMTg3NSBMIDQ0Ljc1LDY0LjUgTCA0Ni4wNjI1LDYzLjc4MTI1IEMgMzUuNzU5Mzg3LDQ0LjcxNTU5IDE5LjUwNjU3NCw0NC41IDE0Ljc1LDQ0LjUgTCAwLjc1LDQ0LjUgTCAtMi40MDYyNSw0NC41IHogTSAzLjQ2ODc1LDQ3LjUgTCAxNC43NSw0Ny41IEMgMTkuNDM0MTczLDQ3LjUgMzMuMDM2ODUsNDcuMzY5NzkzIDQyLjcxODc1LDY0LjUgQyAzNy45NTE5NjQsNzIuOTI5MDc1IDMyLjE5NzQ2OSw3Ny4xODM5MSAyNyw3OS4zMTI1IEMgMjEuNjM5MzM5LDgxLjUwNzkyNCAxNy4xNTgwNzUsODEuNTAwMDAxIDE0Ljc1LDgxLjUgTCAzLjUsODEuNSBDIDUuMzczNTg4NCw3OC4zOTE1NjYgOC4yNSw3Mi40NTA2NSA4LjI1LDY0LjUgQyA4LjI1LDU2LjUyNjY0NiA1LjM0MTQ2ODYsNTAuNTk5ODE1IDMuNDY4NzUsNDcuNSB6IgogICAgICAgICBpZD0icGF0aDQ5NzMiCiAgICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2NzY2NjY3NjY2NjY2NjY2NzY2NzYyIgLz4KICAgIDwvZz4KICAgIDxwYXRoCiAgICAgICBzb2RpcG9kaTp0eXBlPSJhcmMiCiAgICAgICBzdHlsZT0iZmlsbDpub25lO2ZpbGwtb3BhY2l0eToxO3N0cm9rZTojMDAwMDAwO3N0cm9rZS13aWR0aDozO3N0cm9rZS1saW5lam9pbjptaXRlcjttYXJrZXI6bm9uZTtzdHJva2Utb3BhY2l0eToxO3Zpc2liaWxpdHk6dmlzaWJsZTtkaXNwbGF5OmlubGluZTtvdmVyZmxvdzp2aXNpYmxlO2VuYWJsZS1iYWNrZ3JvdW5kOmFjY3VtdWxhdGUiCiAgICAgICBpZD0icGF0aDM1NTEiCiAgICAgICBzb2RpcG9kaTpjeD0iNzUiCiAgICAgICBzb2RpcG9kaTpjeT0iMjUiCiAgICAgICBzb2RpcG9kaTpyeD0iNCIKICAgICAgIHNvZGlwb2RpOnJ5PSI0IgogICAgICAgZD0iTSA3OSwyNSBBIDQsNCAwIDEgMSA3MSwyNSBBIDQsNCAwIDEgMSA3OSwyNSB6IiAvPgogIDwvZz4KPC9zdmc+Cg=="}}},joint.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return(!a||!b)&&(a||b)}}),joint.shapes.logic.Wire=joint.dia.Link.extend({arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<circle class="marker-arrowhead" end="<%= end %>" r="7"/>',"</g>"].join(""),vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<g class="marker-vertex-remove-group">','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>","</g>"].join(""),defaults:joint.util.deepSupplement({type:"logic.Wire",attrs:{".connection":{"stroke-width":2},".marker-vertex":{r:7}},router:{name:"orthogonal"},connector:{name:"rounded",args:{radius:10}}},joint.dia.Link.prototype.defaults)});
if("object"==typeof exports)var graphlib=require("graphlib"),dagre=require("dagre");graphlib=graphlib||"undefined"!=typeof window&&window.graphlib,dagre=dagre||"undefined"!=typeof window&&window.dagre,joint.dia.Graph.prototype.toGraphLib=function(a){a=a||{};var b=_.pick(a,"directed","compound","multigraph"),c=new graphlib.Graph(b),d=a.setNodeLabel||_.noop,e=a.setEdgeLabel||_.noop,f=a.setEdgeName||_.noop;return this.get("cells").each(function(a){if(a.isLink()){var b=a.get("source"),g=a.get("target");if(!b.id||!g.id)return;c.setEdge(b.id,g.id,e(a),f(a))}else c.setNode(a.id,d(a)),c.isCompound()&&a.has("parent")&&c.setParent(a.id,a.get("parent"))}),c},joint.dia.Graph.prototype.fromGraphLib=function(a,b){b=b||{};var c=b.importNode||_.noop,d=b.importEdge||_.noop;a.nodes().forEach(function(d){c.call(this,d,a,this,b)},this),a.edges().forEach(function(c){d.call(this,c,a,this,b)},this)},joint.layout.DirectedGraph={layout:function(a,b){b=_.defaults(b||{},{resizeClusters:!0,clusterPadding:10});var c=a.toGraphLib({directed:!0,multigraph:!0,compound:!0,setNodeLabel:function(a){return{width:a.get("size").width,height:a.get("size").height,rank:a.get("rank")}},setEdgeLabel:function(a){return{minLen:a.get("minLen")||1}},setEdgeName:function(a){return a.id}}),d={};return b.rankDir&&(d.rankdir=b.rankDir),b.nodeSep&&(d.nodesep=b.nodeSep),b.edgeSep&&(d.edgesep=b.edgeSep),b.rankSep&&(d.ranksep=b.rankSep),b.marginX&&(d.marginx=b.marginX),b.marginY&&(d.marginy=b.marginY),c.setGraph(d),dagre.layout(c,{debugTiming:!!b.debugTiming}),a.fromGraphLib(c,{importNode:function(a,c){var d=this.getCell(a),e=c.node(a);b.setPosition?b.setPosition(d,e):d.set("position",{x:e.x-e.width/2,y:e.y-e.height/2})},importEdge:function(a,c){var d=this.getCell(a.name),e=c.edge(a);b.setLinkVertices&&(b.setVertices?b.setVertices(d,e.points):d.set("vertices",e.points))}}),b.resizeClusters&&_.chain(c.nodes()).filter(function(a){return c.children(a).length>0}).map(a.getCell,a).sortBy(function(a){return-a.getAncestors().length}).invoke("fitEmbeds",{padding:b.clusterPadding}).value(),c.graph()}};

	joint.g = g;
	joint.V = joint.Vectorizer = V;

	return joint;

}));
