/*! JointJS v1.0.1 (2016-09-20) - JavaScript diagramming library


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/
(function(root, factory) {

    if (typeof define === 'function' && define.amd) {

        // AMD. Register as an anonymous module.
        define([], factory);

    } else if (typeof exports === 'object') {

        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like environments that support module.exports,
        // like Node.
        module.exports = factory();

    } else {

        // Browser globals.
        root.g = factory();
    }

}(this, function() {

var g=function(){var a={},b=Math,c=b.abs,d=b.cos,e=b.sin,f=b.sqrt,g=b.min,h=b.max,i=b.atan2,j=b.round,k=b.floor,l=b.PI,m=b.random;a.bezier={curveThroughPoints:function(a){for(var b=this.getCurveControlPoints(a),c=["M",a[0].x,a[0].y],d=0;d<b[0].length;d++)c.push("C",b[0][d].x,b[0][d].y,b[1][d].x,b[1][d].y,a[d+1].x,a[d+1].y);return c},getCurveControlPoints:function(a){var b,c=[],d=[],e=a.length-1;if(1==e)return c[0]=p((2*a[0].x+a[1].x)/3,(2*a[0].y+a[1].y)/3),d[0]=p(2*c[0].x-a[0].x,2*c[0].y-a[0].y),[c,d];var f=[];for(b=1;b<e-1;b++)f[b]=4*a[b].x+2*a[b+1].x;f[0]=a[0].x+2*a[1].x,f[e-1]=(8*a[e-1].x+a[e].x)/2;var g=this.getFirstControlPoints(f);for(b=1;b<e-1;++b)f[b]=4*a[b].y+2*a[b+1].y;f[0]=a[0].y+2*a[1].y,f[e-1]=(8*a[e-1].y+a[e].y)/2;var h=this.getFirstControlPoints(f);for(b=0;b<e;b++)c.push(p(g[b],h[b])),b<e-1?d.push(p(2*a[b+1].x-g[b+1],2*a[b+1].y-h[b+1])):d.push(p((a[e].x+g[e-1])/2,(a[e].y+h[e-1])/2));return[c,d]},getCurveDivider:function(a,b,c,d){return function(e){var f=o(a,b).pointAt(e),g=o(b,c).pointAt(e),h=o(c,d).pointAt(e),i=o(f,g).pointAt(e),j=o(g,h).pointAt(e),k=o(i,j).pointAt(e);return[{p0:a,p1:f,p2:i,p3:k},{p0:k,p1:j,p2:h,p3:d}]}},getFirstControlPoints:function(a){var b=a.length,c=[],d=[],e=2;c[0]=a[0]/e;for(var f=1;f<b;f++)d[f]=1/e,e=(f<b-1?4:3.5)-d[f],c[f]=(a[f]-c[f-1])/e;for(f=1;f<b;f++)c[b-f-1]-=d[b-f]*c[b-f];return c},getInversionSolver:function(a,b,c,d){function e(a,b){var c=f[a],d=f[b];return function(e){var f=(a%3?3:1)*(b%3?3:1),g=e.x*(c.y-d.y)+e.y*(d.x-c.x)+c.x*d.y-c.y*d.x;return f*g}}var f=arguments;return function(c){var d=3*e(2,3)(b),f=e(1,3)(a)/d,g=-e(2,3)(a)/d,h=f*e(3,1)(c)+g*(e(3,0)(c)+e(2,1)(c))+e(2,0)(c),i=f*e(3,0)(c)+g*e(2,0)(c)+e(1,0)(c);return i/(i-h)}}};var n=a.Ellipse=function(a,b,c){return this instanceof n?a instanceof n?new n(p(a),a.a,a.b):(a=p(a),this.x=a.x,this.y=a.y,this.a=b,void(this.b=c)):new n(a,b,c)};a.Ellipse.fromRect=function(a){return a=q(a),n(a.center(),a.width/2,a.height/2)},a.Ellipse.prototype={bbox:function(){return q(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},clone:function(){return n(this)},normalizedDistance:function(a){var b=a.x,c=a.y,d=this.a,e=this.b,f=this.x,g=this.y;return(b-f)*(b-f)/(d*d)+(c-g)*(c-g)/(e*e)},containsPoint:function(a){return this.normalizedDistance(a)<=1},center:function(){return p(this.x,this.y)},tangentTheta:function(b){var c,d,e=30,f=b.x,g=b.y,h=this.a,i=this.b,j=this.bbox().center(),k=j.x,l=j.y,m=f>j.x+h/2,n=f<j.x-h/2;return m||n?(c=f>j.x?g-e:g+e,d=h*h/(f-k)-h*h*(g-l)*(c-l)/(i*i*(f-k))+k):(d=g>j.y?f+e:f-e,c=i*i/(g-l)-i*i*(f-k)*(d-k)/(h*h*(g-l))+l),a.point(d,c).theta(b)},equals:function(a){return a=n(a),a.x===this.x&&a.y===this.y&&a.a===this.a&&a.b===this.b},intersectionWithLineFromCenterToPoint:function(a,b){a=p(a),b&&a.rotate(p(this.x,this.y),b);var c,d=a.x-this.x,e=a.y-this.y;if(0===d)return c=this.bbox().pointNearestToPoint(a),b?c.rotate(p(this.x,this.y),-b):c;var g=e/d,h=g*g,i=this.a*this.a,j=this.b*this.b,k=f(1/(1/i+h/j));k=d<0?-k:k;var l=g*k;return c=p(this.x+k,this.y+l),b?c.rotate(p(this.x,this.y),-b):c},toString:function(){return p(this.x,this.y).toString()+" "+this.a+" "+this.b}};var o=a.Line=function(a,b){return this instanceof o?(this.start=p(a),void(this.end=p(b))):new o(a,b)};a.Line.prototype={bearing:function(){var a=u(this.start.y),b=u(this.end.y),c=this.start.x,f=this.end.x,g=u(f-c),h=e(g)*d(b),j=d(a)*e(b)-e(a)*d(b)*d(g),k=t(i(h,j)),l=["NE","E","SE","S","SW","W","NW","N"],m=k-22.5;return m<0&&(m+=360),m=parseInt(m/45),l[m]},clone:function(){return o(this)},intersection:function(a){var b=p(this.end.x-this.start.x,this.end.y-this.start.y),c=p(a.end.x-a.start.x,a.end.y-a.start.y),d=b.x*c.y-b.y*c.x,e=p(a.start.x-this.start.x,a.start.y-this.start.y),f=e.x*c.y-e.y*c.x,g=e.x*b.y-e.y*b.x;if(0===d||f*d<0||g*d<0)return null;if(d>0){if(f>d||g>d)return null}else if(f<d||g<d)return null;return p(this.start.x+f*b.x/d,this.start.y+f*b.y/d)},length:function(){return f(this.squaredLength())},midpoint:function(){return p((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},pointAt:function(a){var b=(1-a)*this.start.x+a*this.end.x,c=(1-a)*this.start.y+a*this.end.y;return p(b,c)},pointOffset:function(a){return((this.end.x-this.start.x)*(a.y-this.start.y)-(this.end.y-this.start.y)*(a.x-this.start.x))/2},squaredLength:function(){var a=this.start.x,b=this.start.y,c=this.end.x,d=this.end.y;return(a-=c)*a+(b-=d)*b},toString:function(){return this.start.toString()+" "+this.end.toString()}};var p=a.Point=function(a,b){if(!(this instanceof p))return new p(a,b);if("string"==typeof a){var c=a.split(a.indexOf("@")===-1?" ":"@");a=parseInt(c[0],10),b=parseInt(c[1],10)}else Object(a)===a&&(b=a.y,a=a.x);this.x=void 0===a?0:a,this.y=void 0===b?0:b};a.Point.fromPolar=function(a,b,f){f=f&&p(f)||p(0,0);var g=c(a*d(b)),h=c(a*e(b)),i=r(t(b));return i<90?h=-h:i<180?(g=-g,h=-h):i<270&&(g=-g),p(f.x+g,f.y+h)},a.Point.random=function(a,b,c,d){return p(k(m()*(b-a+1)+a),k(m()*(d-c+1)+c))},a.Point.prototype={adhereToRect:function(a){return a.containsPoint(this)?this:(this.x=g(h(this.x,a.x),a.x+a.width),this.y=g(h(this.y,a.y),a.y+a.height),this)},bearing:function(a){return o(this,a).bearing()},changeInAngle:function(a,b,c){return p(this).offset(-a,-b).theta(c)-this.theta(c)},clone:function(){return p(this)},difference:function(a){return p(this.x-a.x,this.y-a.y)},distance:function(a){return o(this,a).length()},equals:function(a){return this.x===a.x&&this.y===a.y},magnitude:function(){return f(this.x*this.x+this.y*this.y)||.01},manhattanDistance:function(a){return c(a.x-this.x)+c(a.y-this.y)},move:function(a,b){var c=u(p(a).theta(this));return this.offset(d(c)*b,-e(c)*b)},normalize:function(a){var b=(a||1)/this.magnitude();return this.scale(b,b)},offset:function(a,b){return this.x+=a||0,this.y+=b||0,this},reflection:function(a){return p(a).move(this,this.distance(a))},rotate:function(a,b){b=(b+360)%360,this.toPolar(a),this.y+=u(b);var c=p.fromPolar(this.x,this.y,a);return this.x=c.x,this.y=c.y,this},round:function(a){return this.x=a?this.x.toFixed(a):j(this.x),this.y=a?this.y.toFixed(a):j(this.y),this},scale:function(a,b,c){return c=c&&p(c)||p(0,0),this.x=c.x+a*(this.x-c.x),this.y=c.y+b*(this.y-c.y),this},snapToGrid:function(a,b){return this.x=s(this.x,a),this.y=s(this.y,b||a),this},theta:function(a){a=p(a);var b=-(a.y-this.y),c=a.x-this.x,d=10,e=0==b.toFixed(d)&&0==c.toFixed(d)?0:i(b,c);return e<0&&(e=2*l+e),180*e/l},toJSON:function(){return{x:this.x,y:this.y}},toPolar:function(a){a=a&&p(a)||p(0,0);var b=this.x,c=this.y;return this.x=f((b-a.x)*(b-a.x)+(c-a.y)*(c-a.y)),this.y=u(a.theta(p(b,c))),this},toString:function(){return this.x+"@"+this.y},update:function(a,b){return this.x=a||0,this.y=b||0,this}};var q=a.Rect=function(a,b,c,d){return this instanceof q?(Object(a)===a&&(b=a.y,c=a.width,d=a.height,a=a.x),this.x=void 0===a?0:a,this.y=void 0===b?0:b,this.width=void 0===c?0:c,void(this.height=void 0===d?0:d)):new q(a,b,c,d)};a.Rect.fromEllipse=function(a){return a=n(a),q(a.x-a.a,a.y-a.b,2*a.a,2*a.b)},a.Rect.prototype={bbox:function(a){var b=u(a||0),f=c(e(b)),g=c(d(b)),h=this.width*g+this.height*f,i=this.width*f+this.height*g;return q(this.x+(this.width-h)/2,this.y+(this.height-i)/2,h,i)},bottomLeft:function(){return p(this.x,this.y+this.height)},bottomMiddle:function(){return p(this.x+this.width/2,this.y+this.height)},center:function(){return p(this.x+this.width/2,this.y+this.height/2)},clone:function(){return q(this)},containsPoint:function(a){return a=p(a),a.x>=this.x&&a.x<=this.x+this.width&&a.y>=this.y&&a.y<=this.y+this.height},containsRect:function(a){var b=q(this).normalize(),c=q(a).normalize(),d=b.width,e=b.height,f=c.width,g=c.height;if(!(d&&e&&f&&g))return!1;var h=b.x,i=b.y,j=c.x,k=c.y;return f+=j,d+=h,g+=k,e+=i,h<=j&&f<=d&&i<=k&&g<=e},corner:function(){return p(this.x+this.width,this.y+this.height)},equals:function(a){var b=q(this).normalize(),c=q(a).normalize();return b.x===c.x&&b.y===c.y&&b.width===c.width&&b.height===c.height},intersect:function(a){var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner();if(e.x<=b.x||e.y<=b.y||d.x>=c.x||d.y>=c.y)return null;var f=Math.max(b.x,d.x),g=Math.max(b.y,d.y);return q(f,g,Math.min(c.x,e.x)-f,Math.min(c.y,e.y)-g)},intersectionWithLineFromCenterToPoint:function(a,b){a=p(a);var c,d=p(this.x+this.width/2,this.y+this.height/2);b&&a.rotate(d,b);for(var e=[o(this.origin(),this.topRight()),o(this.topRight(),this.corner()),o(this.corner(),this.bottomLeft()),o(this.bottomLeft(),this.origin())],f=o(d,a),g=e.length-1;g>=0;--g){var h=e[g].intersection(f);if(null!==h){c=h;break}}return c&&b&&c.rotate(d,-b),c},leftMiddle:function(){return p(this.x,this.y+this.height/2)},moveAndExpand:function(a){return this.x+=a.x||0,this.y+=a.y||0,this.width+=a.width||0,this.height+=a.height||0,this},normalize:function(){var a=this.x,b=this.y,c=this.width,d=this.height;return this.width<0&&(a=this.x+this.width,c=-this.width),this.height<0&&(b=this.y+this.height,d=-this.height),this.x=a,this.y=b,this.width=c,this.height=d,this},origin:function(){return p(this.x,this.y)},pointNearestToPoint:function(a){if(a=p(a),this.containsPoint(a)){var b=this.sideNearestToPoint(a);switch(b){case"right":return p(this.x+this.width,a.y);case"left":return p(this.x,a.y);case"bottom":return p(a.x,this.y+this.height);case"top":return p(a.x,this.y)}}return a.adhereToRect(this)},rightMiddle:function(){return p(this.x+this.width,this.y+this.height/2)},round:function(a){return this.x=a?this.x.toFixed(a):j(this.x),this.y=a?this.y.toFixed(a):j(this.y),this.width=a?this.width.toFixed(a):j(this.width),this.height=a?this.height.toFixed(a):j(this.height),this},scale:function(a,b,c){return c=this.origin().scale(a,b,c),this.x=c.x,this.y=c.y,this.width*=a,this.height*=b,this},sideNearestToPoint:function(a){a=p(a);var b=a.x-this.x,c=this.x+this.width-a.x,d=a.y-this.y,e=this.y+this.height-a.y,f=b,g="left";return c<f&&(f=c,g="right"),d<f&&(f=d,g="top"),e<f&&(f=e,g="bottom"),g},snapToGrid:function(a,b){var c=this.origin().snapToGrid(a,b),d=this.corner().snapToGrid(a,b);return this.x=c.x,this.y=c.y,this.width=d.x-c.x,this.height=d.y-c.y,this},topMiddle:function(){return p(this.x+this.width/2,this.y)},topRight:function(){return p(this.x+this.width,this.y)},toJSON:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},toString:function(){return this.origin().toString()+" "+this.corner().toString()},union:function(a){var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner(),f=Math.min(b.x,d.x),g=Math.min(b.y,d.y),h=Math.max(c.x,e.x),i=Math.max(c.y,e.y);return q(f,g,h-f,i-g)}};var r=a.normalizeAngle=function(a){return a%360+(a<0?360:0)};a.scale={linear:function(a,b,c){var d=a[1]-a[0],e=b[1]-b[0];return(c-a[0])/d*e+b[0]||0}};var s=a.snapToGrid=function(a,b){return b*Math.round(a/b)},t=a.toDeg=function(a){return 180*a/l%360},u=a.toRad=function(a,b){return b=b||!1,a=b?a:a%360,a*l/180};return a.ellipse=a.Ellipse,a.line=a.Line,a.point=a.Point,a.rect=a.Rect,a}();

    return g;

}));
