/*! JointJS v1.0.2 (2016-10-27) - JavaScript diagramming library


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/
(function(root, factory) {

    if (typeof define === 'function' && define.amd) {

        // For AMD.

        define(['backbone', 'lodash', 'jquery'], function(Backbone, _, $) {

            Backbone.$ = $;

            return factory(root, Backbone, _, $);
        });

    } else if (typeof exports !== 'undefined') {

        // For Node.js or CommonJS.

        var Backbone = require('backbone');
        var _ = require('lodash');
        var $ = Backbone.$ = require('jquery');

        module.exports = factory(root, Backbone, _, $);

    } else {

        // As a browser global.

        var Backbone = root.Backbone;
        var _ = root._;
        var $ = Backbone.$ = root.jQuery || root.$;

        root.joint = factory(root, Backbone, _, $);
        root.g = root.joint.g;
        root.V = root.Vectorizer = root.joint.V;
    }

}(this, function(root, Backbone, _, $) {

var g=function(){var a={},b=Math,c=b.abs,d=b.cos,e=b.sin,f=b.sqrt,g=b.min,h=b.max,i=b.atan2,j=b.round,k=b.floor,l=b.PI,m=b.random;a.bezier={curveThroughPoints:function(a){for(var b=this.getCurveControlPoints(a),c=["M",a[0].x,a[0].y],d=0;d<b[0].length;d++)c.push("C",b[0][d].x,b[0][d].y,b[1][d].x,b[1][d].y,a[d+1].x,a[d+1].y);return c},getCurveControlPoints:function(a){var b,c=[],d=[],e=a.length-1;if(1==e)return c[0]=p((2*a[0].x+a[1].x)/3,(2*a[0].y+a[1].y)/3),d[0]=p(2*c[0].x-a[0].x,2*c[0].y-a[0].y),[c,d];var f=[];for(b=1;b<e-1;b++)f[b]=4*a[b].x+2*a[b+1].x;f[0]=a[0].x+2*a[1].x,f[e-1]=(8*a[e-1].x+a[e].x)/2;var g=this.getFirstControlPoints(f);for(b=1;b<e-1;++b)f[b]=4*a[b].y+2*a[b+1].y;f[0]=a[0].y+2*a[1].y,f[e-1]=(8*a[e-1].y+a[e].y)/2;var h=this.getFirstControlPoints(f);for(b=0;b<e;b++)c.push(p(g[b],h[b])),b<e-1?d.push(p(2*a[b+1].x-g[b+1],2*a[b+1].y-h[b+1])):d.push(p((a[e].x+g[e-1])/2,(a[e].y+h[e-1])/2));return[c,d]},getCurveDivider:function(a,b,c,d){return function(e){var f=o(a,b).pointAt(e),g=o(b,c).pointAt(e),h=o(c,d).pointAt(e),i=o(f,g).pointAt(e),j=o(g,h).pointAt(e),k=o(i,j).pointAt(e);return[{p0:a,p1:f,p2:i,p3:k},{p0:k,p1:j,p2:h,p3:d}]}},getFirstControlPoints:function(a){var b=a.length,c=[],d=[],e=2;c[0]=a[0]/e;for(var f=1;f<b;f++)d[f]=1/e,e=(f<b-1?4:3.5)-d[f],c[f]=(a[f]-c[f-1])/e;for(f=1;f<b;f++)c[b-f-1]-=d[b-f]*c[b-f];return c},getInversionSolver:function(a,b,c,d){function e(a,b){var c=f[a],d=f[b];return function(e){var f=(a%3?3:1)*(b%3?3:1),g=e.x*(c.y-d.y)+e.y*(d.x-c.x)+c.x*d.y-c.y*d.x;return f*g}}var f=arguments;return function(c){var d=3*e(2,3)(b),f=e(1,3)(a)/d,g=-e(2,3)(a)/d,h=f*e(3,1)(c)+g*(e(3,0)(c)+e(2,1)(c))+e(2,0)(c),i=f*e(3,0)(c)+g*e(2,0)(c)+e(1,0)(c);return i/(i-h)}}};var n=a.Ellipse=function(a,b,c){return this instanceof n?a instanceof n?new n(p(a),a.a,a.b):(a=p(a),this.x=a.x,this.y=a.y,this.a=b,void(this.b=c)):new n(a,b,c)};a.Ellipse.fromRect=function(a){return a=q(a),n(a.center(),a.width/2,a.height/2)},a.Ellipse.prototype={bbox:function(){return q(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},clone:function(){return n(this)},normalizedDistance:function(a){var b=a.x,c=a.y,d=this.a,e=this.b,f=this.x,g=this.y;return(b-f)*(b-f)/(d*d)+(c-g)*(c-g)/(e*e)},containsPoint:function(a){return this.normalizedDistance(a)<=1},center:function(){return p(this.x,this.y)},tangentTheta:function(b){var c,d,e=30,f=b.x,g=b.y,h=this.a,i=this.b,j=this.bbox().center(),k=j.x,l=j.y,m=f>j.x+h/2,n=f<j.x-h/2;return m||n?(c=f>j.x?g-e:g+e,d=h*h/(f-k)-h*h*(g-l)*(c-l)/(i*i*(f-k))+k):(d=g>j.y?f+e:f-e,c=i*i/(g-l)-i*i*(f-k)*(d-k)/(h*h*(g-l))+l),a.point(d,c).theta(b)},equals:function(a){return a=n(a),a.x===this.x&&a.y===this.y&&a.a===this.a&&a.b===this.b},intersectionWithLineFromCenterToPoint:function(a,b){a=p(a),b&&a.rotate(p(this.x,this.y),b);var c,d=a.x-this.x,e=a.y-this.y;if(0===d)return c=this.bbox().pointNearestToPoint(a),b?c.rotate(p(this.x,this.y),-b):c;var g=e/d,h=g*g,i=this.a*this.a,j=this.b*this.b,k=f(1/(1/i+h/j));k=d<0?-k:k;var l=g*k;return c=p(this.x+k,this.y+l),b?c.rotate(p(this.x,this.y),-b):c},toString:function(){return p(this.x,this.y).toString()+" "+this.a+" "+this.b}};var o=a.Line=function(a,b){return this instanceof o?(this.start=p(a),void(this.end=p(b))):new o(a,b)};a.Line.prototype={bearing:function(){var a=u(this.start.y),b=u(this.end.y),c=this.start.x,f=this.end.x,g=u(f-c),h=e(g)*d(b),j=d(a)*e(b)-e(a)*d(b)*d(g),k=t(i(h,j)),l=["NE","E","SE","S","SW","W","NW","N"],m=k-22.5;return m<0&&(m+=360),m=parseInt(m/45),l[m]},clone:function(){return o(this)},intersection:function(a){var b=p(this.end.x-this.start.x,this.end.y-this.start.y),c=p(a.end.x-a.start.x,a.end.y-a.start.y),d=b.x*c.y-b.y*c.x,e=p(a.start.x-this.start.x,a.start.y-this.start.y),f=e.x*c.y-e.y*c.x,g=e.x*b.y-e.y*b.x;if(0===d||f*d<0||g*d<0)return null;if(d>0){if(f>d||g>d)return null}else if(f<d||g<d)return null;return p(this.start.x+f*b.x/d,this.start.y+f*b.y/d)},length:function(){return f(this.squaredLength())},midpoint:function(){return p((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},pointAt:function(a){var b=(1-a)*this.start.x+a*this.end.x,c=(1-a)*this.start.y+a*this.end.y;return p(b,c)},pointOffset:function(a){return((this.end.x-this.start.x)*(a.y-this.start.y)-(this.end.y-this.start.y)*(a.x-this.start.x))/2},squaredLength:function(){var a=this.start.x,b=this.start.y,c=this.end.x,d=this.end.y;return(a-=c)*a+(b-=d)*b},toString:function(){return this.start.toString()+" "+this.end.toString()}};var p=a.Point=function(a,b){if(!(this instanceof p))return new p(a,b);if("string"==typeof a){var c=a.split(a.indexOf("@")===-1?" ":"@");a=parseInt(c[0],10),b=parseInt(c[1],10)}else Object(a)===a&&(b=a.y,a=a.x);this.x=void 0===a?0:a,this.y=void 0===b?0:b};a.Point.fromPolar=function(a,b,f){f=f&&p(f)||p(0,0);var g=c(a*d(b)),h=c(a*e(b)),i=r(t(b));return i<90?h=-h:i<180?(g=-g,h=-h):i<270&&(g=-g),p(f.x+g,f.y+h)},a.Point.random=function(a,b,c,d){return p(k(m()*(b-a+1)+a),k(m()*(d-c+1)+c))},a.Point.prototype={adhereToRect:function(a){return a.containsPoint(this)?this:(this.x=g(h(this.x,a.x),a.x+a.width),this.y=g(h(this.y,a.y),a.y+a.height),this)},bearing:function(a){return o(this,a).bearing()},changeInAngle:function(a,b,c){return p(this).offset(-a,-b).theta(c)-this.theta(c)},clone:function(){return p(this)},difference:function(a){return p(this.x-a.x,this.y-a.y)},distance:function(a){return o(this,a).length()},equals:function(a){return this.x===a.x&&this.y===a.y},magnitude:function(){return f(this.x*this.x+this.y*this.y)||.01},manhattanDistance:function(a){return c(a.x-this.x)+c(a.y-this.y)},move:function(a,b){var c=u(p(a).theta(this));return this.offset(d(c)*b,-e(c)*b)},normalize:function(a){var b=(a||1)/this.magnitude();return this.scale(b,b)},offset:function(a,b){return this.x+=a||0,this.y+=b||0,this},reflection:function(a){return p(a).move(this,this.distance(a))},rotate:function(a,b){b=(b+360)%360,this.toPolar(a),this.y+=u(b);var c=p.fromPolar(this.x,this.y,a);return this.x=c.x,this.y=c.y,this},round:function(a){return this.x=a?this.x.toFixed(a):j(this.x),this.y=a?this.y.toFixed(a):j(this.y),this},scale:function(a,b,c){return c=c&&p(c)||p(0,0),this.x=c.x+a*(this.x-c.x),this.y=c.y+b*(this.y-c.y),this},snapToGrid:function(a,b){return this.x=s(this.x,a),this.y=s(this.y,b||a),this},theta:function(a){a=p(a);var b=-(a.y-this.y),c=a.x-this.x,d=10,e=0==b.toFixed(d)&&0==c.toFixed(d)?0:i(b,c);return e<0&&(e=2*l+e),180*e/l},toJSON:function(){return{x:this.x,y:this.y}},toPolar:function(a){a=a&&p(a)||p(0,0);var b=this.x,c=this.y;return this.x=f((b-a.x)*(b-a.x)+(c-a.y)*(c-a.y)),this.y=u(a.theta(p(b,c))),this},toString:function(){return this.x+"@"+this.y},update:function(a,b){return this.x=a||0,this.y=b||0,this}};var q=a.Rect=function(a,b,c,d){return this instanceof q?(Object(a)===a&&(b=a.y,c=a.width,d=a.height,a=a.x),this.x=void 0===a?0:a,this.y=void 0===b?0:b,this.width=void 0===c?0:c,void(this.height=void 0===d?0:d)):new q(a,b,c,d)};a.Rect.fromEllipse=function(a){return a=n(a),q(a.x-a.a,a.y-a.b,2*a.a,2*a.b)},a.Rect.prototype={bbox:function(a){var b=u(a||0),f=c(e(b)),g=c(d(b)),h=this.width*g+this.height*f,i=this.width*f+this.height*g;return q(this.x+(this.width-h)/2,this.y+(this.height-i)/2,h,i)},bottomLeft:function(){return p(this.x,this.y+this.height)},bottomMiddle:function(){return p(this.x+this.width/2,this.y+this.height)},center:function(){return p(this.x+this.width/2,this.y+this.height/2)},clone:function(){return q(this)},containsPoint:function(a){return a=p(a),a.x>=this.x&&a.x<=this.x+this.width&&a.y>=this.y&&a.y<=this.y+this.height},containsRect:function(a){var b=q(this).normalize(),c=q(a).normalize(),d=b.width,e=b.height,f=c.width,g=c.height;if(!(d&&e&&f&&g))return!1;var h=b.x,i=b.y,j=c.x,k=c.y;return f+=j,d+=h,g+=k,e+=i,h<=j&&f<=d&&i<=k&&g<=e},corner:function(){return p(this.x+this.width,this.y+this.height)},equals:function(a){var b=q(this).normalize(),c=q(a).normalize();return b.x===c.x&&b.y===c.y&&b.width===c.width&&b.height===c.height},intersect:function(a){var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner();if(e.x<=b.x||e.y<=b.y||d.x>=c.x||d.y>=c.y)return null;var f=Math.max(b.x,d.x),g=Math.max(b.y,d.y);return q(f,g,Math.min(c.x,e.x)-f,Math.min(c.y,e.y)-g)},intersectionWithLineFromCenterToPoint:function(a,b){a=p(a);var c,d=p(this.x+this.width/2,this.y+this.height/2);b&&a.rotate(d,b);for(var e=[o(this.origin(),this.topRight()),o(this.topRight(),this.corner()),o(this.corner(),this.bottomLeft()),o(this.bottomLeft(),this.origin())],f=o(d,a),g=e.length-1;g>=0;--g){var h=e[g].intersection(f);if(null!==h){c=h;break}}return c&&b&&c.rotate(d,-b),c},leftMiddle:function(){return p(this.x,this.y+this.height/2)},moveAndExpand:function(a){return this.x+=a.x||0,this.y+=a.y||0,this.width+=a.width||0,this.height+=a.height||0,this},normalize:function(){var a=this.x,b=this.y,c=this.width,d=this.height;return this.width<0&&(a=this.x+this.width,c=-this.width),this.height<0&&(b=this.y+this.height,d=-this.height),this.x=a,this.y=b,this.width=c,this.height=d,this},origin:function(){return p(this.x,this.y)},pointNearestToPoint:function(a){if(a=p(a),this.containsPoint(a)){var b=this.sideNearestToPoint(a);switch(b){case"right":return p(this.x+this.width,a.y);case"left":return p(this.x,a.y);case"bottom":return p(a.x,this.y+this.height);case"top":return p(a.x,this.y)}}return a.adhereToRect(this)},rightMiddle:function(){return p(this.x+this.width,this.y+this.height/2)},round:function(a){return this.x=a?this.x.toFixed(a):j(this.x),this.y=a?this.y.toFixed(a):j(this.y),this.width=a?this.width.toFixed(a):j(this.width),this.height=a?this.height.toFixed(a):j(this.height),this},scale:function(a,b,c){return c=this.origin().scale(a,b,c),this.x=c.x,this.y=c.y,this.width*=a,this.height*=b,this},sideNearestToPoint:function(a){a=p(a);var b=a.x-this.x,c=this.x+this.width-a.x,d=a.y-this.y,e=this.y+this.height-a.y,f=b,g="left";return c<f&&(f=c,g="right"),d<f&&(f=d,g="top"),e<f&&(f=e,g="bottom"),g},snapToGrid:function(a,b){var c=this.origin().snapToGrid(a,b),d=this.corner().snapToGrid(a,b);return this.x=c.x,this.y=c.y,this.width=d.x-c.x,this.height=d.y-c.y,this},topMiddle:function(){return p(this.x+this.width/2,this.y)},topRight:function(){return p(this.x+this.width,this.y)},toJSON:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},toString:function(){return this.origin().toString()+" "+this.corner().toString()},union:function(a){var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner(),f=Math.min(b.x,d.x),g=Math.min(b.y,d.y),h=Math.max(c.x,e.x),i=Math.max(c.y,e.y);return q(f,g,h-f,i-g)}};var r=a.normalizeAngle=function(a){return a%360+(a<0?360:0)};a.scale={linear:function(a,b,c){var d=a[1]-a[0],e=b[1]-b[0];return(c-a[0])/d*e+b[0]||0}};var s=a.snapToGrid=function(a,b){return b*Math.round(a/b)},t=a.toDeg=function(a){return 180*a/l%360},u=a.toRad=function(a,b){return b=b||!1,a=b?a:a%360,a*l/180};return a.ellipse=a.Ellipse,a.line=a.Line,a.point=a.Point,a.rect=a.Rect,a}();
var V,Vectorizer;V=Vectorizer=function(){"use strict";var a="object"==typeof window&&!(!window.SVGAngle&&!document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"));if(!a)return function(){throw new Error("SVG is required to use Vectorizer.")};var b={xmlns:"http://www.w3.org/2000/svg",xml:"http://www.w3.org/XML/1998/namespace",xlink:"http://www.w3.org/1999/xlink"},c="1.1",d=function(a,c,e){if(!(this instanceof d))return d.apply(Object.create(d.prototype),arguments);if(a){if(d.isV(a)&&(a=a.node),c=c||{},d.isString(a))if("svg"===a.toLowerCase())a=d.createSvgDocument();else if("<"===a[0]){var f=d.createSvgDocument(a);if(f.childNodes.length>1){var g,h,i=[];for(g=0,h=f.childNodes.length;g<h;g++){var j=f.childNodes[g];i.push(new d(document.importNode(j,!0)))}return i}a=document.importNode(f.firstChild,!0)}else a=document.createElementNS(b.xmlns,a);return this.node=a,this.node.id||(this.node.id=d.uniqueId()),this.setAttributes(c),e&&this.append(e),this}};d.prototype.getTransformToElement=function(a){return a.getScreenCTM().inverse().multiply(this.node.getScreenCTM())},d.prototype.transform=function(a,b){if(d.isUndefined(a))return this.node.parentNode?this.getTransformToElement(this.node.parentNode):this.node.getScreenCTM();var c=this.node.transform.baseVal;b&&b.absolute&&c.clear();var e=d.createSVGTransform(a);return c.appendItem(e),this},d.prototype.translate=function(a,b,c){c=c||{},b=b||0;var e=this.attr("transform")||"",f=d.parseTransformString(e);if(d.isUndefined(a))return f.translate;e=e.replace(/translate\([^\)]*\)/g,"").trim();var g=c.absolute?a:f.translate.tx+a,h=c.absolute?b:f.translate.ty+b,i="translate("+g+","+h+")";return this.attr("transform",(i+" "+e).trim()),this},d.prototype.rotate=function(a,b,c,e){e=e||{};var f=this.attr("transform")||"",g=d.parseTransformString(f);if(d.isUndefined(a))return g.rotate;f=f.replace(/rotate\([^\)]*\)/g,"").trim(),a%=360;var h=e.absolute?a:g.rotate.angle+a,i=void 0!==b&&void 0!==c?","+b+","+c:"",j="rotate("+h+i+")";return this.attr("transform",(f+" "+j).trim()),this},d.prototype.scale=function(a,b){b=d.isUndefined(b)?a:b;var c=this.attr("transform")||"",e=d.parseTransformString(c);if(d.isUndefined(a))return e.scale;c=c.replace(/scale\([^\)]*\)/g,"").trim();var f="scale("+a+","+b+")";return this.attr("transform",(c+" "+f).trim()),this},d.prototype.bbox=function(a,b){if(!this.node.ownerSVGElement)return{x:0,y:0,width:0,height:0};var c;try{c=this.node.getBBox(),c={x:c.x,y:c.y,width:c.width,height:c.height}}catch(a){c={x:this.node.clientLeft,y:this.node.clientTop,width:this.node.clientWidth,height:this.node.clientHeight}}if(a)return c;var e=this.getTransformToElement(b||this.node.ownerSVGElement);return d.transformRect(c,e)},d.prototype.text=function(a,b){a=d.sanitizeText(a),b=b||{};var c,e=a.split("\n"),f=this.attr("y");f||this.attr("y","0.8em"),this.attr("display",a?null:"none"),this.attr("xml:space","preserve"),this.node.textContent="";var g=this.node;if(b.textPath){var h=this.find("defs");0===h.length&&(h=d("defs"),this.append(h));var i=Object(b.textPath)===b.textPath?b.textPath.d:b.textPath;if(i){var j=d("path",{d:i});h.append(j)}var k=d("textPath");!b.textPath["xlink:href"]&&j&&k.attr("xlink:href","#"+j.node.id),Object(b.textPath)===b.textPath&&k.attr(b.textPath),this.append(k),g=k.node}for(var l=0,m=0;m<e.length;m++){var n=e[m],o=b.lineHeight||"1em";"auto"===b.lineHeight&&(o="1.5em");var p=d("tspan",{dy:0==m?"0em":o,x:this.attr("x")||0});if(p.addClass("v-line"),n)if(b.annotations){for(var q=0,r=d.annotateString(e[m],d.isArray(b.annotations)?b.annotations:[b.annotations],{offset:-l,includeAnnotationIndices:b.includeAnnotationIndices}),s=0;s<r.length;s++){var t=r[s];if(d.isObject(t)){var u=parseInt(t.attrs["font-size"],10);u&&u>q&&(q=u),c=d("tspan",t.attrs),b.includeAnnotationIndices&&c.attr("annotations",t.annotations),t.attrs.class&&c.addClass(t.attrs.class),c.node.textContent=t.t}else c=document.createTextNode(t||" ");p.append(c)}"auto"===b.lineHeight&&q&&0!==m&&p.attr("dy",1.2*q+"px")}else p.node.textContent=n;else p.addClass("v-empty-line"),p.node.style.fillOpacity=0,p.node.style.strokeOpacity=0,p.node.textContent="-";d(g).append(p),l+=n.length+1}return this},d.prototype.removeAttr=function(a){var b=d.qualifyAttr(a),c=this.node;return b.ns?c.hasAttributeNS(b.ns,b.local)&&c.removeAttributeNS(b.ns,b.local):c.hasAttribute(a)&&c.removeAttribute(a),this},d.prototype.attr=function(a,b){if(d.isUndefined(a)){for(var c=this.node.attributes,e={},f=0;f<c.length;f++)e[c[f].nodeName]=c[f].nodeValue;return e}if(d.isString(a)&&d.isUndefined(b))return this.node.getAttribute(a);if("object"==typeof a)for(var g in a)a.hasOwnProperty(g)&&this.setAttribute(g,a[g]);else this.setAttribute(a,b);return this},d.prototype.remove=function(){return this.node.parentNode&&this.node.parentNode.removeChild(this.node),this},d.prototype.empty=function(){for(;this.node.firstChild;)this.node.removeChild(this.node.firstChild);return this},d.prototype.setAttributes=function(a){for(var b in a)a.hasOwnProperty(b)&&this.setAttribute(b,a[b]);return this},d.prototype.append=function(a){d.isArray(a)||(a=[a]);for(var b=0,c=a.length;b<c;b++)this.node.appendChild(d.toNode(a[b]));return this},d.prototype.prepend=function(a){var b=this.node.firstChild;return b?d(b).before(a):this.append(a)},d.prototype.before=function(a){var b=this.node,c=b.parentNode;if(c){d.isArray(a)||(a=[a]);for(var e=0,f=a.length;e<f;e++)c.insertBefore(d.toNode(a[e]),b)}return this},d.prototype.svg=function(){return this.node instanceof window.SVGSVGElement?this:d(this.node.ownerSVGElement)},d.prototype.defs=function(){var a=this.svg().node.getElementsByTagName("defs");return a&&a.length?d(a[0]):void 0},d.prototype.clone=function(){var a=d(this.node.cloneNode(!0));return a.node.id=d.uniqueId(),a},d.prototype.findOne=function(a){var b=this.node.querySelector(a);return b?d(b):void 0},d.prototype.find=function(a){var b=[],c=this.node.querySelectorAll(a);if(c)for(var e=0;e<c.length;e++)b.push(d(c[e]));return b},d.prototype.index=function(){for(var a=0,b=this.node.previousSibling;b;)1===b.nodeType&&a++,b=b.previousSibling;return a},d.prototype.findParentByClass=function(a,b){for(var c=this.node.ownerSVGElement,e=this.node.parentNode;e&&e!==b&&e!==c;){var f=d(e);if(f.hasClass(a))return f;e=e.parentNode}return null},d.prototype.toLocalPoint=function(a,b){var c=this.svg().node,d=c.createSVGPoint();d.x=a,d.y=b;try{var e=d.matrixTransform(c.getScreenCTM().inverse()),f=this.getTransformToElement(c).inverse()}catch(a){return d}return e.matrixTransform(f)},d.prototype.translateCenterToPoint=function(a){var b=this.bbox(),c=g.rect(b).center();this.translate(a.x-c.x,a.y-c.y)},d.prototype.translateAndAutoOrient=function(a,b,c){var e=this.scale();this.attr("transform",""),this.scale(e.sx,e.sy);var f=this.svg().node,h=this.bbox(!1,c),i=f.createSVGTransform();i.setTranslate(-h.x-h.width/2,-h.y-h.height/2);var j=f.createSVGTransform(),k=g.point(a).changeInAngle(a.x-b.x,a.y-b.y,b);j.setRotate(k,0,0);var l=f.createSVGTransform(),m=g.point(a).move(b,h.width/2);l.setTranslate(a.x+(a.x-m.x),a.y+(a.y-m.y));var n=this.getTransformToElement(c),o=f.createSVGTransform();o.setMatrix(l.matrix.multiply(j.matrix.multiply(i.matrix.multiply(n))));var p=d.decomposeMatrix(o.matrix);return this.translate(p.translateX,p.translateY),this.rotate(p.rotation),this},d.prototype.animateAlongPath=function(a,b){var c=d("animateMotion",a),e=d("mpath",{"xlink:href":"#"+d(b).node.id});c.append(e),this.append(c);try{c.node.beginElement()}catch(a){if("fake"===document.documentElement.getAttribute("smiling")){var f=c.node;f.animators=[];var g=f.getAttribute("id");g&&(id2anim[g]=f);for(var h=getTargets(f),i=0,j=h.length;i<j;i++){var k=h[i],l=new Animator(f,k,i);animators.push(l),f.animators[i]=l,l.register()}}}},d.prototype.hasClass=function(a){return new RegExp("(\\s|^)"+a+"(\\s|$)").test(this.node.getAttribute("class"))},d.prototype.addClass=function(a){if(!this.hasClass(a)){var b=this.node.getAttribute("class")||"";this.node.setAttribute("class",(b+" "+a).trim())}return this},d.prototype.removeClass=function(a){if(this.hasClass(a)){var b=this.node.getAttribute("class").replace(new RegExp("(\\s|^)"+a+"(\\s|$)","g"),"$2");this.node.setAttribute("class",b)}return this},d.prototype.toggleClass=function(a,b){var c=d.isUndefined(b)?this.hasClass(a):!b;return c?this.removeClass(a):this.addClass(a),this},d.prototype.sample=function(a){a=a||1;for(var b,c=this.node,d=c.getTotalLength(),e=[],f=0;f<d;)b=c.getPointAtLength(f),e.push({x:b.x,y:b.y,distance:f}),f+=a;return e},d.prototype.convertToPath=function(){var a=d("path");a.attr(this.attr());var b=this.convertToPathData();return b&&a.attr("d",b),a},d.prototype.convertToPathData=function(){var a=this.node.tagName.toUpperCase();switch(a){case"PATH":return this.attr("d");case"LINE":return d.convertLineToPathData(this.node);case"POLYGON":return d.convertPolygonToPathData(this.node);case"POLYLINE":return d.convertPolylineToPathData(this.node);case"ELLIPSE":return d.convertEllipseToPathData(this.node);case"CIRCLE":return d.convertCircleToPathData(this.node);case"RECT":return d.convertRectToPathData(this.node)}throw new Error(a+" cannot be converted to PATH.")},d.prototype.findIntersection=function(a,b){var c=this.svg().node;b=b||c;var e=g.rect(this.bbox(!1,b)),f=e.center();if(e.intersectionWithLineFromCenterToPoint(a)){var h,i=this.node.localName.toUpperCase();if("RECT"===i){var j=g.rect(parseFloat(this.attr("x")||0),parseFloat(this.attr("y")||0),parseFloat(this.attr("width")),parseFloat(this.attr("height"))),k=this.getTransformToElement(b),l=d.decomposeMatrix(k),m=c.createSVGTransform();m.setRotate(-l.rotation,f.x,f.y);var n=d.transformRect(j,m.matrix.multiply(k));h=g.rect(n).intersectionWithLineFromCenterToPoint(a,l.rotation)}else if("PATH"===i||"POLYGON"===i||"POLYLINE"===i||"CIRCLE"===i||"ELLIPSE"===i){var o,p,q,r,s,t,u="PATH"===i?this:this.convertToPath(),v=u.sample(),w=1/0,x=[];for(o=0;o<v.length;o++)p=v[o],q=d.createSVGPoint(p.x,p.y),q=q.matrixTransform(this.getTransformToElement(b)),p=g.point(q),r=p.distance(f),s=1.1*p.distance(a),t=r+s,t<w?(w=t,x=[{sample:p,refDistance:s}]):t<w+1&&x.push({sample:p,refDistance:s});x.sort(function(a,b){return a.refDistance-b.refDistance}),x[0]&&(h=x[0].sample)}return h}},d.prototype.setAttribute=function(a,b){var c=this.node;if(null===b)return this.removeAttr(a),this;var e=d.qualifyAttr(a);return e.ns?c.setAttributeNS(e.ns,a,b):"id"===a?c.id=b:c.setAttribute(a,b),this},d.createSvgDocument=function(a){var e='<svg xmlns="'+b.xmlns+'" xmlns:xlink="'+b.xlink+'" version="'+c+'">'+(a||"")+"</svg>",f=d.parseXML(e,{async:!1});return f.documentElement},d.idCounter=0,d.uniqueId=function(){var a=++d.idCounter+"";return"v-"+a},d.sanitizeText=function(a){return(a||"").replace(/ /g,"\xa0")},d.isUndefined=function(a){return"undefined"==typeof a},d.isString=function(a){return"string"==typeof a},d.isObject=function(a){return a&&"object"==typeof a},d.isArray=Array.isArray,d.parseXML=function(a,b){b=b||{};var c;try{var e=new DOMParser;d.isUndefined(b.async)||(e.async=b.async),c=e.parseFromString(a,"text/xml")}catch(a){c=void 0}if(!c||c.getElementsByTagName("parsererror").length)throw new Error("Invalid XML: "+a);return c},d.qualifyAttr=function(a){if(a.indexOf(":")!==-1){var c=a.split(":");return{ns:b[c[0]],local:c[1]}}return{ns:null,local:a}},d.parseTransformString=function(a){var b,c,d;if(a){var e=/[ ,]+/,f=a.match(/translate\((.*)\)/);f&&(b=f[1].split(e));var g=a.match(/rotate\((.*)\)/);g&&(c=g[1].split(e));var h=a.match(/scale\((.*)\)/);h&&(d=h[1].split(e))}var i=d&&d[0]?parseFloat(d[0]):1;return{translate:{tx:b&&b[0]?parseInt(b[0],10):0,ty:b&&b[1]?parseInt(b[1],10):0},rotate:{angle:c&&c[0]?parseInt(c[0],10):0,cx:c&&c[1]?parseInt(c[1],10):void 0,cy:c&&c[2]?parseInt(c[2],10):void 0},scale:{sx:i,sy:d&&d[1]?parseFloat(d[1]):i}}},d.deltaTransformPoint=function(a,b){var c=b.x*a.a+b.y*a.c+0,d=b.x*a.b+b.y*a.d+0;return{x:c,y:d}},d.decomposeMatrix=function(a){var b=d.deltaTransformPoint(a,{x:0,y:1}),c=d.deltaTransformPoint(a,{x:1,y:0}),e=180/Math.PI*Math.atan2(b.y,b.x)-90,f=180/Math.PI*Math.atan2(c.y,c.x);return{translateX:a.e,translateY:a.f,scaleX:Math.sqrt(a.a*a.a+a.b*a.b),scaleY:Math.sqrt(a.c*a.c+a.d*a.d),skewX:e,skewY:f,rotation:e}},d.isV=function(a){return a instanceof d},d.isVElement=d.isV;var e=d("svg").node;return d.createSVGMatrix=function(a){var b=e.createSVGMatrix();for(var c in a)b[c]=a[c];return b},d.createSVGTransform=function(a){return d.isUndefined(a)?e.createSVGTransform():(a instanceof SVGMatrix||(a=d.createSVGMatrix(a)),e.createSVGTransformFromMatrix(a))},d.createSVGPoint=function(a,b){var c=e.createSVGPoint();return c.x=a,c.y=b,c},d.transformRect=function(a,b){var c=e.createSVGPoint();c.x=a.x,c.y=a.y;var d=c.matrixTransform(b);c.x=a.x+a.width,c.y=a.y;var f=c.matrixTransform(b);c.x=a.x+a.width,c.y=a.y+a.height;var g=c.matrixTransform(b);c.x=a.x,c.y=a.y+a.height;var h=c.matrixTransform(b),i=Math.min(d.x,f.x,g.x,h.x),j=Math.max(d.x,f.x,g.x,h.x),k=Math.min(d.y,f.y,g.y,h.y),l=Math.max(d.y,f.y,g.y,h.y);return{x:i,y:k,width:j-i,height:l-k}},d.transformPoint=function(a,b){return d.createSVGPoint(a.x,a.y).matrixTransform(b)},d.styleToObject=function(a){for(var b={},c=a.split(";"),d=0;d<c.length;d++){var e=c[d],f=e.split("=");b[f[0].trim()]=f[1].trim()}return b},d.createSlicePathData=function(a,b,c,d){var e=2*Math.PI-1e-6,f=a,g=b,h=c,i=d,j=(i<h&&(j=h,h=i,i=j),i-h),k=j<Math.PI?"0":"1",l=Math.cos(h),m=Math.sin(h),n=Math.cos(i),o=Math.sin(i);return j>=e?f?"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"M0,"+f+"A"+f+","+f+" 0 1,0 0,"+-f+"A"+f+","+f+" 0 1,0 0,"+f+"Z":"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"Z":f?"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L"+f*n+","+f*o+"A"+f+","+f+" 0 "+k+",0 "+f*l+","+f*m+"Z":"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L0,0Z"},d.mergeAttrs=function(a,b){for(var c in b)"class"===c?a[c]=a[c]?a[c]+" "+b[c]:b[c]:"style"===c?d.isObject(a[c])&&d.isObject(b[c])?a[c]=d.mergeAttrs(a[c],b[c]):d.isObject(a[c])?a[c]=d.mergeAttrs(a[c],d.styleToObject(b[c])):d.isObject(b[c])?a[c]=d.mergeAttrs(d.styleToObject(a[c]),b[c]):a[c]=d.mergeAttrs(d.styleToObject(a[c]),d.styleToObject(b[c])):a[c]=b[c];return a},d.annotateString=function(a,b,c){b=b||[],c=c||{};for(var e,f,g,h=c.offset||0,i=[],j=[],k=0;k<a.length;k++){f=j[k]=a[k];for(var l=0;l<b.length;l++){var m=b[l],n=m.start+h,o=m.end+h;k>=n&&k<o&&(d.isObject(f)?f.attrs=d.mergeAttrs(d.mergeAttrs({},f.attrs),m.attrs):f=j[k]={t:a[k],attrs:m.attrs},c.includeAnnotationIndices&&(f.annotations||(f.annotations=[])).push(l))}g=j[k-1],g?d.isObject(f)&&d.isObject(g)?JSON.stringify(f.attrs)===JSON.stringify(g.attrs)?e.t+=f.t:(i.push(e),e=f):d.isObject(f)?(i.push(e),e=f):d.isObject(g)?(i.push(e),e=f):e=(e||"")+f:e=f}return e&&i.push(e),i},d.findAnnotationsAtIndex=function(a,b){var c=[];return a&&a.forEach(function(a){a.start<b&&b<=a.end&&c.push(a)}),c},d.findAnnotationsBetweenIndexes=function(a,b,c){var d=[];return a&&a.forEach(function(a){(b>=a.start&&b<a.end||c>a.start&&c<=a.end||a.start>=b&&a.end<c)&&d.push(a)}),d},d.shiftAnnotations=function(a,b,c){return a&&a.forEach(function(a){a.start<b&&a.end>=b?a.end+=c:a.start>=b&&(a.start+=c,a.end+=c)}),a},d.convertLineToPathData=function(a){a=d(a);var b=["M",a.attr("x1"),a.attr("y1"),"L",a.attr("x2"),a.attr("y2")].join(" ");return b},d.convertPolygonToPathData=function(a){var b=d.getPointsFromSvgNode(d(a).node);return b.length>0?d.svgPointsToPath(b)+" Z":null},d.convertPolylineToPathData=function(a){var b=d.getPointsFromSvgNode(d(a).node);return b.length>0?d.svgPointsToPath(b):null},d.svgPointsToPath=function(a){var b;for(b=0;b<a.length;b++)a[b]=a[b].x+" "+a[b].y;return"M "+a.join(" L")},d.getPointsFromSvgNode=function(a){var b,c=[];for(b=0;b<a.points.numberOfItems;b++)c.push(a.points.getItem(b));return c},d.KAPPA=.5522847498307935,d.convertCircleToPathData=function(a){a=d(a);var b=parseFloat(a.attr("cx"))||0,c=parseFloat(a.attr("cy"))||0,e=parseFloat(a.attr("r")),f=e*d.KAPPA,g=["M",b,c-e,"C",b+f,c-e,b+e,c-f,b+e,c,"C",b+e,c+f,b+f,c+e,b,c+e,"C",b-f,c+e,b-e,c+f,b-e,c,"C",b-e,c-f,b-f,c-e,b,c-e,"Z"].join(" ");return g},d.convertEllipseToPathData=function(a){a=d(a);var b=parseFloat(a.attr("cx"))||0,c=parseFloat(a.attr("cy"))||0,e=parseFloat(a.attr("rx")),f=parseFloat(a.attr("ry"))||e,g=e*d.KAPPA,h=f*d.KAPPA,i=["M",b,c-f,"C",b+g,c-f,b+e,c-h,b+e,c,"C",b+e,c+h,b+g,c+f,b,c+f,"C",b-g,c+f,b-e,c+h,b-e,c,"C",b-e,c-h,b-g,c-f,b,c-f,"Z"].join(" ");return i},d.convertRectToPathData=function(a){a=d(a);var b,c=parseFloat(a.attr("x"))||0,e=parseFloat(a.attr("y"))||0,f=parseFloat(a.attr("width"))||0,h=parseFloat(a.attr("height"))||0,i=parseFloat(a.attr("rx"))||0,j=parseFloat(a.attr("ry"))||0,k=g.rect(c,e,f,h);if(i||j){var l=c+f,m=e+h;b=["M",c+i,e,"L",l-i,e,"Q",l,e,l,e+j,"L",l,e+h-j,"Q",l,m,l-i,m,"L",c+i,m,"Q",c,m,c,m-i,"L",c,e+j,"Q",c,e,c+i,e,"Z"].join(" ")}else b=["M",k.origin().x,k.origin().y,"H",k.corner().x,"V",k.corner().y,"H",k.origin().x,"V",k.origin().y,"Z"].join(" ");return b},d.rectToPath=function(a){var b=a.rx||a["top-rx"]||0,c=a.rx||a["bottom-rx"]||0,d=a.ry||a["top-ry"]||0,e=a.ry||a["bottom-ry"]||0;return["M",a.x,a.y+d,"v",a.height-d-e,"a",c,e,0,0,0,c,e,"h",a.width-2*c,"a",c,e,0,0,0,c,-e,"v",-(a.height-e-d),"a",b,d,0,0,0,-b,-d,"h",-(a.width-2*b),"a",b,d,0,0,0,-b,d].join(" ")},d.toNode=function(a){return d.isV(a)?a.node:a.nodeName&&a||a[0]},d}();
var joint={version:"1.0.2",config:{classNamePrefix:"joint-",defaultTheme:"default"},dia:{},ui:{},layout:{},shapes:{},format:{},connectors:{},highlighters:{},routers:{},mvc:{views:{}},setTheme:function(a,b){b=b||{},_.invoke(joint.mvc.views,"setTheme",a,b),joint.mvc.View.prototype.defaultTheme=a},env:{_results:{},_tests:{svgforeignobject:function(){return!!document.createElementNS&&/SVGForeignObject/.test({}.toString.call(document.createElementNS("http://www.w3.org/2000/svg","foreignObject")))}},addTest:function(a,b){return joint.env._tests[a]=b},test:function(a){var b=joint.env._tests[a];if(!b)throw new Error('Test not defined ("'+a+'"). Use `joint.env.addTest(name, fn) to add a new test.`');var c=joint.env._results[a];if("undefined"!=typeof c)return c;try{c=b()}catch(a){c=!1}return joint.env._results[a]=c,c}},util:{hashCode:function(a){var b=0;if(0==a.length)return b;for(var c=0;c<a.length;c++){var d=a.charCodeAt(c);b=(b<<5)-b+d,b&=b}return b},getByPath:function(a,b,c){c=c||"/";for(var d,e=b.split(c);e.length;){if(d=e.shift(),!(Object(a)===a&&d in a))return;a=a[d]}return a},setByPath:function(a,b,c,d){d=d||"/";var e=b.split(d),f=a,g=0;if(b.indexOf(d)>-1){for(var h=e.length;g<h-1;g++)f=f[e[g]]||(f[e[g]]={});f[e[h-1]]=c}else a[b]=c;return a},unsetByPath:function(a,b,c){c=c||"/";var d=b.lastIndexOf(c);if(d>-1){var e=joint.util.getByPath(a,b.substr(0,d),c);e&&delete e[b.slice(d+1)]}else delete a[b];return a},flattenObject:function(a,b,c){b=b||"/";var d={};for(var e in a)if(a.hasOwnProperty(e)){var f="object"==typeof a[e];if(f&&c&&c(a[e])&&(f=!1),f){var g=this.flattenObject(a[e],b,c);for(var h in g)g.hasOwnProperty(h)&&(d[e+b+h]=g[h])}else d[e]=a[e]}return d},uuid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(a){var b=16*Math.random()|0,c="x"==a?b:3&b|8;return c.toString(16)})},guid:function(a){return this.guid.id=this.guid.id||1,a.id=void 0===a.id?"j_"+this.guid.id++:a.id,a.id},mixin:_.assign,supplement:_.defaults,deepMixin:_.mixin,deepSupplement:_.defaultsDeep,normalizeEvent:function(a){var b=a.originalEvent&&a.originalEvent.changedTouches&&a.originalEvent.changedTouches[0];if(b){for(var c in a)void 0===b[c]&&(b[c]=a[c]);return b}return a},nextFrame:function(){var a;if("undefined"!=typeof window&&(a=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame),!a){var b=0;a=function(a){var c=(new Date).getTime(),d=Math.max(0,16-(c-b)),e=setTimeout(function(){a(c+d)},d);return b=c+d,e}}return function(b,c){return a(c?_.bind(b,c):b)}}(),cancelFrame:function(){var a,b="undefined"!=typeof window;return b&&(a=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.webkitCancelRequestAnimationFrame||window.msCancelAnimationFrame||window.msCancelRequestAnimationFrame||window.oCancelAnimationFrame||window.oCancelRequestAnimationFrame||window.mozCancelAnimationFrame||window.mozCancelRequestAnimationFrame),a=a||clearTimeout,b?_.bind(a,window):a}(),shapePerimeterConnectionPoint:function(a,b,c,d){var e,f;if(!c){var h=b.$(".scalable")[0],i=b.$(".rotatable")[0];h&&h.firstChild?c=h.firstChild:i&&i.firstChild&&(c=i.firstChild)}return c?(f=V(c).findIntersection(d,a.paper.viewport),f||(e=g.rect(V(c).bbox(!1,a.paper.viewport)))):(e=b.model.getBBox(),f=e.intersectionWithLineFromCenterToPoint(d)),f||e.center()},breakText:function(a,b,c,d){d=d||{};var e=b.width,f=b.height,g=d.svgDocument||V("svg").node,h=V("<text><tspan></tspan></text>").attr(c||{}).node,i=h.firstChild,j=document.createTextNode("");h.style.opacity=0,h.style.display="block",i.style.display="block",i.appendChild(j),g.appendChild(h),d.svgDocument||document.body.appendChild(g);for(var k,l=a.split(" "),m=[],n=[],o=0,p=0,q=l.length;o<q;o++){var r=l[o];if(j.data=n[p]?n[p]+" "+r:r,i.getComputedTextLength()<=e)n[p]=j.data,k&&(m[p++]=!0,k=0);else{if(!n[p]||k){var s=!!k;if(k=r.length-1,s||!k){if(!k){if(!n[p]){n=[];break}l.splice(o,2,r+l[o+1]),q--,m[p++]=!0,o--;continue}l[o]=r.substring(0,k),l[o+1]=r.substring(k)+l[o+1]}else l.splice(o,1,r.substring(0,k),r.substring(k)),q++,p&&!m[p-1]&&p--;o--;continue}p++,o--}if("undefined"!=typeof f){var t=t||1.25*h.getBBox().height;if(t*n.length>f){n.splice(Math.floor(f/t));break}}}return d.svgDocument?g.removeChild(h):document.body.removeChild(g),n.join("\n")},imageToDataUri:function(a,b){if(!a||"data:"===a.substr(0,"data:".length))return setTimeout(function(){b(null,a)},0);var c=function(b,c){if(200===b.status){var d=new FileReader;d.onload=function(a){var b=a.target.result;c(null,b)},d.onerror=function(){c(new Error("Failed to load image "+a))},d.readAsDataURL(b.response)}else c(new Error("Failed to load image "+a))},d=function(b,c){var d=function(a){for(var b=32768,c=[],d=0;d<a.length;d+=b)c.push(String.fromCharCode.apply(null,a.subarray(d,d+b)));return c.join("")};if(200===b.status){var e=new Uint8Array(b.response),f=a.split(".").pop()||"png",g={svg:"svg+xml"},h="data:image/"+(g[f]||f)+";base64,",i=h+btoa(d(e));c(null,i)}else c(new Error("Failed to load image "+a))},e=new XMLHttpRequest;e.open("GET",a,!0),e.addEventListener("error",function(){b(new Error("Failed to load image "+a))}),e.responseType=window.FileReader?"blob":"arraybuffer",e.addEventListener("load",function(){window.FileReader?c(e,b):d(e,b)}),e.send()},getElementBBox:function(a){var b,c=$(a),d=c.offset();if(a.ownerSVGElement){b=V(a).bbox();var e=a.getBoundingClientRect(),f=(e.width-b.width)/2,g=(e.height-b.height)/2;b.x=d.left+f,b.y=d.top+g}else b={x:d.left,y:d.top,width:c.outerWidth(),height:c.outerHeight()};return b},sortElements:function(a,b){var c=$(a),d=c.map(function(){var a=this,b=a.parentNode,c=b.insertBefore(document.createTextNode(""),a.nextSibling);return function(){if(b===this)throw new Error("You can't sort elements if any one is a descendant of another.");b.insertBefore(this,c),b.removeChild(c)}});return Array.prototype.sort.call(c,b).each(function(a){d[a].call(this)})},setAttributesBySelector:function(a,b){var c=$(a);_.each(b,function(a,b){var d=c.find(b).addBack().filter(b);_.has(a,"class")&&(d.addClass(a.class),a=_.omit(a,"class")),d.attr(a)})},normalizeSides:function(a){return Object(a)!==a?(a=a||0,{top:a,bottom:a,left:a,right:a}):{top:a.top||0,bottom:a.bottom||0,left:a.left||0,right:a.right||0}},timing:{linear:function(a){return a},quad:function(a){return a*a},cubic:function(a){return a*a*a},inout:function(a){if(a<=0)return 0;if(a>=1)return 1;var b=a*a,c=b*a;return 4*(a<.5?c:3*(a-b)+c-.75)},exponential:function(a){return Math.pow(2,10*(a-1))},bounce:function(a){for(var b=0,c=1;1;b+=c,c/=2)if(a>=(7-4*b)/11){var d=(11-6*b-11*a)/4;return-d*d+c*c}},reverse:function(a){return function(b){return 1-a(1-b)}},reflect:function(a){return function(b){return.5*(b<.5?a(2*b):2-a(2-2*b))}},clamp:function(a,b,c){return b=b||0,c=c||1,function(d){var e=a(d);return e<b?b:e>c?c:e}},back:function(a){return a||(a=1.70158),function(b){return b*b*((a+1)*b-a)}},elastic:function(a){return a||(a=1.5),function(b){return Math.pow(2,10*(b-1))*Math.cos(20*Math.PI*a/3*b)}}},interpolate:{number:function(a,b){var c=b-a;return function(b){return a+c*b}},object:function(a,b){var c=_.keys(a);return function(d){var e,f,g={};for(e=c.length-1;e!=-1;e--)f=c[e],g[f]=a[f]+(b[f]-a[f])*d;return g}},hexColor:function(a,b){var c=parseInt(a.slice(1),16),d=parseInt(b.slice(1),16),e=255&c,f=(255&d)-e,g=65280&c,h=(65280&d)-g,i=16711680&c,j=(16711680&d)-i;return function(a){var b=e+f*a&255,c=g+h*a&65280,d=i+j*a&16711680;return"#"+(1<<24|b|c|d).toString(16).slice(1)}},unit:function(a,b){var c=/(-?[0-9]*.[0-9]*)(px|em|cm|mm|in|pt|pc|%)/,d=c.exec(a),e=c.exec(b),f=e[1].indexOf("."),g=f>0?e[1].length-f-1:0;a=+d[1];var h=+e[1]-a,i=d[2];return function(b){return(a+h*b).toFixed(g)+i}}},filter:{outline:function(a){var b='<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology in="SourceAlpha" result="morphedOuter" operator="dilate" radius="${outerRadius}" /><feMorphology in="SourceAlpha" result="morphedInner" operator="dilate" radius="${innerRadius}" /><feComposite result="morphedOuterColored" in="colored" in2="morphedOuter" operator="in"/><feComposite operator="xor" in="morphedOuterColored" in2="morphedInner" result="outline"/><feMerge><feMergeNode in="outline"/><feMergeNode in="SourceGraphic"/></feMerge></filter>',c=_.isFinite(a.margin)?a.margin:2,d=_.isFinite(a.width)?a.width:1;return joint.util.template(b)({color:a.color||"blue",opacity:_.isFinite(a.opacity)?a.opacity:1,outerRadius:c+d,innerRadius:c})},highlight:function(a){var b='<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology result="morphed" in="SourceGraphic" operator="dilate" radius="${width}"/><feComposite result="composed" in="colored" in2="morphed" operator="in"/><feGaussianBlur result="blured" in="composed" stdDeviation="${blur}"/><feBlend in="SourceGraphic" in2="blured" mode="normal"/></filter>';return joint.util.template(b)({color:a.color||"red",width:_.isFinite(a.width)?a.width:1,blur:_.isFinite(a.blur)?a.blur:0,opacity:_.isFinite(a.opacity)?a.opacity:1})},blur:function(a){var b=_.isFinite(a.x)?a.x:2;return joint.util.template('<filter><feGaussianBlur stdDeviation="${stdDeviation}"/></filter>')({stdDeviation:_.isFinite(a.y)?[b,a.y]:b})},dropShadow:function(a){var b="SVGFEDropShadowElement"in window?'<filter><feDropShadow stdDeviation="${blur}" dx="${dx}" dy="${dy}" flood-color="${color}" flood-opacity="${opacity}"/></filter>':'<filter><feGaussianBlur in="SourceAlpha" stdDeviation="${blur}"/><feOffset dx="${dx}" dy="${dy}" result="offsetblur"/><feFlood flood-color="${color}"/><feComposite in2="offsetblur" operator="in"/><feComponentTransfer><feFuncA type="linear" slope="${opacity}"/></feComponentTransfer><feMerge><feMergeNode/><feMergeNode in="SourceGraphic"/></feMerge></filter>';return joint.util.template(b)({dx:a.dx||0,dy:a.dy||0,opacity:_.isFinite(a.opacity)?a.opacity:1,color:a.color||"black",blur:_.isFinite(a.blur)?a.blur:4})},grayscale:function(a){var b=_.isFinite(a.amount)?a.amount:1;return joint.util.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${b} ${h} 0 0 0 0 0 1 0"/></filter>')({a:.2126+.7874*(1-b),b:.7152-.7152*(1-b),c:.0722-.0722*(1-b),d:.2126-.2126*(1-b),e:.7152+.2848*(1-b),f:.0722-.0722*(1-b),g:.2126-.2126*(1-b),h:.0722+.9278*(1-b)})},sepia:function(a){var b=_.isFinite(a.amount)?a.amount:1;return joint.util.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${h} ${i} 0 0 0 0 0 1 0"/></filter>')({a:.393+.607*(1-b),b:.769-.769*(1-b),c:.189-.189*(1-b),d:.349-.349*(1-b),e:.686+.314*(1-b),f:.168-.168*(1-b),g:.272-.272*(1-b),h:.534-.534*(1-b),i:.131+.869*(1-b)})},saturate:function(a){var b=_.isFinite(a.amount)?a.amount:1;return joint.util.template('<filter><feColorMatrix type="saturate" values="${amount}"/></filter>')({amount:1-b})},hueRotate:function(a){return joint.util.template('<filter><feColorMatrix type="hueRotate" values="${angle}"/></filter>')({angle:a.angle||0})},invert:function(a){var b=_.isFinite(a.amount)?a.amount:1;return joint.util.template('<filter><feComponentTransfer><feFuncR type="table" tableValues="${amount} ${amount2}"/><feFuncG type="table" tableValues="${amount} ${amount2}"/><feFuncB type="table" tableValues="${amount} ${amount2}"/></feComponentTransfer></filter>')({amount:b,amount2:1-b})},brightness:function(a){return joint.util.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}"/><feFuncG type="linear" slope="${amount}"/><feFuncB type="linear" slope="${amount}"/></feComponentTransfer></filter>')({amount:_.isFinite(a.amount)?a.amount:1})},contrast:function(a){var b=_.isFinite(a.amount)?a.amount:1;return joint.util.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}" intercept="${amount2}"/><feFuncG type="linear" slope="${amount}" intercept="${amount2}"/><feFuncB type="linear" slope="${amount}" intercept="${amount2}"/></feComponentTransfer></filter>')({amount:b,amount2:.5-b/2})}},format:{number:function(a,b,c){function d(a){for(var b=a.length,d=[],e=0,f=c.grouping[0];b>0&&f>0;)d.push(a.substring(b-=f,b+f)),f=c.grouping[e=(e+1)%c.grouping.length];return d.reverse().join(c.thousands)}c=c||{currency:["$",""],decimal:".",thousands:",",grouping:[3]};var e=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,f=e.exec(a),g=f[1]||" ",h=f[2]||">",i=f[3]||"",j=f[4]||"",k=f[5],l=+f[6],m=f[7],n=f[8],o=f[9],p=1,q="",r="",s=!1;switch(n&&(n=+n.substring(1)),(k||"0"===g&&"="===h)&&(k=g="0",h="=",m&&(l-=Math.floor((l-1)/4))),o){case"n":m=!0,o="g";break;case"%":p=100,r="%",o="f";break;case"p":p=100,r="%",o="r";break;case"b":case"o":case"x":case"X":"#"===j&&(q="0"+o.toLowerCase());break;case"c":case"d":s=!0,n=0;break;case"s":p=-1,o="r"}"$"===j&&(q=c.currency[0],r=c.currency[1]),"r"!=o||n||(o="g"),null!=n&&("g"==o?n=Math.max(1,Math.min(21,n)):"e"!=o&&"f"!=o||(n=Math.max(0,Math.min(20,n))));var t=k&&m;if(s&&b%1)return"";var u=b<0||0===b&&1/b<0?(b=-b,"-"):i,v=r;if(p<0){var w=this.prefix(b,n);b=w.scale(b),v=w.symbol+r}else b*=p;b=this.convert(o,b,n);var x=b.lastIndexOf("."),y=x<0?b:b.substring(0,x),z=x<0?"":c.decimal+b.substring(x+1);!k&&m&&c.grouping&&(y=d(y));var A=q.length+y.length+z.length+(t?0:u.length),B=A<l?new Array(A=l-A+1).join(g):"";return t&&(y=d(B+y)),u+=q,b=y+z,("<"===h?u+b+B:">"===h?B+u+b:"^"===h?B.substring(0,A>>=1)+u+b+B.substring(A):u+(t?b:B+b))+v},string:function(a,b){for(var c,d="{",e=!1,f=[];(c=a.indexOf(d))!==-1;){var g,h,i;if(g=a.slice(0,c),e){h=g.split(":"),i=h.shift().split("."),g=b;for(var j=0;j<i.length;j++)g=g[i[j]];h.length&&(g=this.number(h,g))}f.push(g),a=a.slice(c+1),d=(e=!e)?"}":"{"}return f.push(a),f.join("")},convert:function(a,b,c){switch(a){case"b":return b.toString(2);case"c":return String.fromCharCode(b);case"o":return b.toString(8);case"x":return b.toString(16);case"X":return b.toString(16).toUpperCase();case"g":return b.toPrecision(c);case"e":return b.toExponential(c);case"f":return b.toFixed(c);case"r":return(b=this.round(b,this.precision(b,c))).toFixed(Math.max(0,Math.min(20,this.precision(b*(1+1e-15),c))));default:return b+""}},round:function(a,b){return b?Math.round(a*(b=Math.pow(10,b)))/b:Math.round(a)},precision:function(a,b){return b-(a?Math.ceil(Math.log(a)/Math.LN10):1)},prefix:function(a,b){var c=_.map(["y","z","a","f","p","n","\xb5","m","","k","M","G","T","P","E","Z","Y"],function(a,b){var c=Math.pow(10,3*Math.abs(8-b));return{scale:b>8?function(a){return a/c}:function(a){return a*c},symbol:a}}),d=0;return a&&(a<0&&(a*=-1),b&&(a=this.round(a,this.precision(a,b))),d=1+Math.floor(1e-12+Math.log(a)/Math.LN10),d=Math.max(-24,Math.min(24,3*Math.floor((d<=0?d+1:d-1)/3)))),c[8+d/3]}},template:function(a){var b=/<%= ([^ ]+) %>|\$\{ ?([^\{\} ]+) ?\}|\{\{([^\{\} ]+)\}\}/g;return function(c){return c=c||{},a.replace(b,function(a){for(var b=Array.prototype.slice.call(arguments),d=_.find(b.slice(1,4),function(a){return!!a}),e=d.split("."),f=c[e.shift()];!_.isUndefined(f)&&e.length;)f=f[e.shift()];return _.isUndefined(f)?"":f})}},toggleFullScreen:function(a){function b(a,b){for(var c=["webkit","moz","ms","o",""],d=0;d<c.length;d++){var e=c[d],f=e?e+b:b.substr(0,1).toLowerCase()+b.substr(1);if(!_.isUndefined(a[f]))return _.isFunction(a[f])?a[f]():a[f]}}a=a||document.body,b(document,"FullScreen")||b(document,"IsFullScreen")?b(document,"CancelFullScreen"):b(a,"RequestFullScreen")},addClassNamePrefix:function(a){return a?_.map(a.toString().split(" "),function(a){return a.substr(0,joint.config.classNamePrefix.length)!==joint.config.classNamePrefix&&(a=joint.config.classNamePrefix+a),a}).join(" "):a},removeClassNamePrefix:function(a){return a?_.map(a.toString().split(" "),function(a){return a.substr(0,joint.config.classNamePrefix.length)===joint.config.classNamePrefix&&(a=a.substr(joint.config.classNamePrefix.length)),a}).join(" "):a},wrapWith:function(a,b,c){if(_.isString(c)){if(!joint.util.wrappers[c])throw new Error('Unknown wrapper: "'+c+'"');c=joint.util.wrappers[c]}if(!_.isFunction(c))throw new Error("Wrapper must be a function.");_.each(b,function(b){a[b]=c(a[b])})},wrappers:{cells:function(a){return function(){var b=Array.prototype.slice.call(arguments),c=b.length>0&&_.first(b)||[],d=b.length>1&&_.last(b)||{};return _.isArray(c)||(d instanceof joint.dia.Cell?(c=b,d={}):c=_.initial(b)),a.call(this,c,d)}}}}};joint.mvc.View=Backbone.View.extend({options:{},theme:null,themeClassNamePrefix:joint.util.addClassNamePrefix("theme-"),requireSetThemeOverride:!1,defaultTheme:joint.config.defaultTheme,constructor:function(a){Backbone.View.call(this,a)},initialize:function(a){this.requireSetThemeOverride=a&&!!a.theme,this.options=_.extend({},this.options,a),_.bindAll(this,"setTheme","onSetTheme","remove","onRemove"),joint.mvc.views[this.cid]=this,this.setTheme(this.options.theme||this.defaultTheme),this._ensureElClassName(),this.init()},_ensureElClassName:function(){var a=_.result(this,"className"),b=joint.util.addClassNamePrefix(a);this.$el.removeClass(a),this.$el.addClass(b)},init:function(){},onRender:function(){},setTheme:function(a,b){if(b=b||{},!this.theme||!this.requireSetThemeOverride||b.override)return this.removeThemeClassName(),this.addThemeClassName(a),this.onSetTheme(this.theme,a),this.theme=a,this},addThemeClassName:function(a){a=a||this.theme;var b=this.themeClassNamePrefix+a;return this.$el.addClass(b),this},removeThemeClassName:function(a){a=a||this.theme;var b=this.themeClassNamePrefix+a;return this.$el.removeClass(b),this},onSetTheme:function(a,b){},remove:function(){return this.onRemove(),joint.mvc.views[this.cid]=null,Backbone.View.prototype.remove.apply(this,arguments),this},onRemove:function(){}}),function(){joint.mvc.View._extend=joint.mvc.View.extend,joint.mvc.View.extend=function(a,b){a=a||{};var c=a.render||this.prototype.render||null;return a.render=function(){return c&&c.apply(this,arguments),this.onRender(),this},joint.mvc.View._extend.call(this,a,b)}}(),joint.dia.GraphCells=Backbone.Collection.extend({cellNamespace:joint.shapes,initialize:function(a,b){b.cellNamespace&&(this.cellNamespace=b.cellNamespace),this.graph=b.graph},model:function(a,b){var c=b.collection,d=c.cellNamespace,e="link"===a.type?joint.dia.Link:joint.util.getByPath(d,a.type,".")||joint.dia.Element,f=new e(a,b);return f.graph=c.graph,f},comparator:function(a){return a.get("z")||0}}),joint.dia.Graph=Backbone.Model.extend({_batches:{},initialize:function(a,b){b=b||{};var c=new joint.dia.GraphCells([],{model:b.cellModel,cellNamespace:b.cellNamespace,graph:this});Backbone.Model.prototype.set.call(this,"cells",c),c.on("all",this.trigger,this),this.on("change:z",this._sortOnChangeZ,this),this.on("batch:stop",this._onBatchStop,this),this._out={},this._in={},this._nodes={},this._edges={},c.on("add",this._restructureOnAdd,this),c.on("remove",this._restructureOnRemove,this),c.on("reset",this._restructureOnReset,this),c.on("change:source",this._restructureOnChangeSource,this),c.on("change:target",this._restructureOnChangeTarget,this),c.on("remove",this._removeCell,this)},_sortOnChangeZ:function(){this.hasActiveBatch("to-front")||this.hasActiveBatch("to-back")||this.get("cells").sort()},_onBatchStop:function(a){var b=a&&a.batchName;"to-front"!==b&&"to-back"!==b||this.hasActiveBatch(b)||this.get("cells").sort()},_restructureOnAdd:function(a){if(a.isLink()){this._edges[a.id]=!0;var b=a.get("source"),c=a.get("target");b.id&&((this._out[b.id]||(this._out[b.id]={}))[a.id]=!0),c.id&&((this._in[c.id]||(this._in[c.id]={}))[a.id]=!0)}else this._nodes[a.id]=!0},_restructureOnRemove:function(a){if(a.isLink()){delete this._edges[a.id];var b=a.get("source"),c=a.get("target");b.id&&this._out[b.id]&&this._out[b.id][a.id]&&delete this._out[b.id][a.id],c.id&&this._in[c.id]&&this._in[c.id][a.id]&&delete this._in[c.id][a.id]}else delete this._nodes[a.id]},_restructureOnReset:function(a){a=a.models,this._out={},this._in={},this._nodes={},this._edges={},_.each(a,this._restructureOnAdd,this)},_restructureOnChangeSource:function(a){var b=a.previous("source");b.id&&this._out[b.id]&&delete this._out[b.id][a.id];var c=a.get("source");c.id&&((this._out[c.id]||(this._out[c.id]={}))[a.id]=!0)},_restructureOnChangeTarget:function(a){var b=a.previous("target");b.id&&this._in[b.id]&&delete this._in[b.id][a.id];var c=a.get("target");c.id&&((this._in[c.id]||(this._in[c.id]={}))[a.id]=!0)},getOutboundEdges:function(a){return this._out&&this._out[a]||{}},getInboundEdges:function(a){return this._in&&this._in[a]||{}},toJSON:function(){var a=Backbone.Model.prototype.toJSON.apply(this,arguments);return a.cells=this.get("cells").toJSON(),a},fromJSON:function(a,b){if(!a.cells)throw new Error("Graph JSON must contain cells array.");return this.set(a,b)},set:function(a,b,c){var d;return"object"==typeof a?(d=a,c=b):(d={})[a]=b,d.hasOwnProperty("cells")&&(this.resetCells(d.cells,c),d=_.omit(d,"cells")),Backbone.Model.prototype.set.call(this,d,c)},clear:function(a){a=_.extend({},a,{clear:!0});var b=this.get("cells");if(0===b.length)return this;this.startBatch("clear",a);var c=b.sortBy(function(a){return a.isLink()?1:2});do c.shift().remove(a);while(c.length>0);return this.stopBatch("clear"),this},_prepareCell:function(a){var b;if(a instanceof Backbone.Model?(b=a.attributes,a.graph=this):b=a,!_.isString(b.type))throw new TypeError("dia.Graph: cell type must be a string.");return a},maxZIndex:function(){var a=this.get("cells").last();return a?a.get("z")||0:0},addCell:function(a,b){return _.isArray(a)?this.addCells(a,b):(a instanceof Backbone.Model?a.has("z")||a.set("z",this.maxZIndex()+1):_.isUndefined(a.z)&&(a.z=this.maxZIndex()+1),this.get("cells").add(this._prepareCell(a),b||{}),this)},addCells:function(a,b){return a.length&&(a=_.flattenDeep(a),b.position=a.length,this.startBatch("add"),_.each(a,function(a){b.position--,this.addCell(a,b)},this),this.stopBatch("add")),this},resetCells:function(a,b){return this.get("cells").reset(_.map(a,this._prepareCell,this),b),this},removeCells:function(a,b){return a.length&&(this.startBatch("remove"),_.invoke(a,"remove",b),this.stopBatch("remove")),this},_removeCell:function(a,b,c){c=c||{},c.clear||(c.disconnectLinks?this.disconnectLinks(a,c):this.removeLinks(a,c)),this.get("cells").remove(a,{silent:!0}),delete a.graph},getCell:function(a){return this.get("cells").get(a)},getCells:function(){return this.get("cells").toArray()},getElements:function(){return _.map(this._nodes,function(a,b){return this.getCell(b)},this)},getLinks:function(){return _.map(this._edges,function(a,b){return this.getCell(b)},this)},getFirstCell:function(){return this.get("cells").first()},getLastCell:function(){return this.get("cells").last()},getConnectedLinks:function(a,b){b=b||{};var c=b.inbound,d=b.outbound;_.isUndefined(c)&&_.isUndefined(d)&&(c=d=!0);var e=[],f={};if(d&&_.each(this.getOutboundEdges(a.id),function(a,b){f[b]||(e.push(this.getCell(b)),f[b]=!0)},this),c&&_.each(this.getInboundEdges(a.id),function(a,b){f[b]||(e.push(this.getCell(b)),f[b]=!0)},this),b.deep){var g=a.getEmbeddedCells({deep:!0}),h={};_.each(g,function(a){a.isLink()&&(h[a.id]=!0)}),_.each(g,function(a){a.isLink()||(d&&_.each(this.getOutboundEdges(a.id),function(a,b){f[b]||h[b]||(e.push(this.getCell(b)),f[b]=!0)},this),c&&_.each(this.getInboundEdges(a.id),function(a,b){f[b]||h[b]||(e.push(this.getCell(b)),f[b]=!0)},this))},this)}return e},getNeighbors:function(a,b){b=b||{};var c=b.inbound,d=b.outbound;_.isUndefined(c)&&_.isUndefined(d)&&(c=d=!0);var e=_.transform(this.getConnectedLinks(a,b),function(e,f){var g=f.get("source"),h=f.get("target"),i=f.hasLoop(b);if(c&&_.has(g,"id")&&!e[g.id]){var j=this.getCell(g.id);!i&&(!j||j===a||b.deep&&j.isEmbeddedIn(a))||(e[g.id]=j)}if(d&&_.has(h,"id")&&!e[h.id]){var k=this.getCell(h.id);!i&&(!k||k===a||b.deep&&k.isEmbeddedIn(a))||(e[h.id]=k)}},{},this);return _.values(e)},getCommonAncestor:function(){var a=_.map(arguments,function(a){for(var b=[],c=a.get("parent");c;)b.push(c),c=this.getCell(c).get("parent");return b},this);a=_.sortBy(a,"length");var b=_.find(a.shift(),function(b){return _.every(a,function(a){return _.contains(a,b)})});return this.getCell(b)},getSuccessors:function(a,b){b=b||{};var c=[];return this.search(a,function(b){b!==a&&c.push(b)},_.extend({},b,{outbound:!0})),c},cloneCells:function(a){a=_.unique(a);var b=_.transform(a,function(a,b){a[b.id]=b.clone()},{});return _.each(a,function(a){var c=b[a.id];if(c.isLink()){var d=c.get("source"),e=c.get("target");d.id&&b[d.id]&&c.prop("source/id",b[d.id].id),e.id&&b[e.id]&&c.prop("target/id",b[e.id].id)}var f=a.get("parent");f&&b[f]&&c.set("parent",b[f].id);var g=_.reduce(a.get("embeds"),function(a,c){return b[c]&&a.push(b[c].id),a},[]);_.isEmpty(g)||c.set("embeds",g)}),b},cloneSubgraph:function(a,b){var c=this.getSubgraph(a,b);return this.cloneCells(c)},getSubgraph:function(a,b){b=b||{};var c=[],d={},e=[],f=[];return _.each(a,function(a){if(d[a.id]||(c.push(a),d[a.id]=a,a.isLink()?f.push(a):e.push(a)),b.deep){var g=a.getEmbeddedCells({deep:!0});_.each(g,function(a){d[a.id]||(c.push(a),d[a.id]=a,a.isLink()?f.push(a):e.push(a))})}}),_.each(f,function(a){var b=a.get("source"),f=a.get("target");if(b.id&&!d[b.id]){var g=this.getCell(b.id);c.push(g),d[g.id]=g,e.push(g)}if(f.id&&!d[f.id]){var h=this.getCell(f.id);c.push(this.getCell(f.id)),d[h.id]=h,e.push(h)}},this),_.each(e,function(a){var e=this.getConnectedLinks(a,b);_.each(e,function(a){var b=a.get("source"),e=a.get("target");!d[a.id]&&b.id&&d[b.id]&&e.id&&d[e.id]&&(c.push(a),d[a.id]=a)})},this),c},getPredecessors:function(a,b){b=b||{};var c=[];return this.search(a,function(b){b!==a&&c.push(b)},_.extend({},b,{inbound:!0})),c},search:function(a,b,c){c=c||{},c.breadthFirst?this.bfs(a,b,c):this.dfs(a,b,c)},bfs:function(a,b,c){c=c||{};var d={},e={},f=[];for(f.push(a),e[a.id]=0;f.length>0;){var g=f.shift();if(!d[g.id]){if(d[g.id]=!0,b(g,e[g.id])===!1)return;_.each(this.getNeighbors(g,c),function(a){e[a.id]=e[g.id]+1,f.push(a)})}}},dfs:function(a,b,c,d,e){c=c||{};var f=d||{},g=e||0;b(a,g)!==!1&&(f[a.id]=!0,_.each(this.getNeighbors(a,c),function(a){f[a.id]||this.dfs(a,b,c,f,g+1)},this))},getSources:function(){var a=[];return _.each(this._nodes,function(b,c){this._in[c]&&!_.isEmpty(this._in[c])||a.push(this.getCell(c))},this),a},getSinks:function(){var a=[];return _.each(this._nodes,function(b,c){this._out[c]&&!_.isEmpty(this._out[c])||a.push(this.getCell(c))},this),a},isSource:function(a){return!this._in[a.id]||_.isEmpty(this._in[a.id])},isSink:function(a){return!this._out[a.id]||_.isEmpty(this._out[a.id])},isSuccessor:function(a,b){var c=!1;return this.search(a,function(d){if(d===b&&d!==a)return c=!0,!1},{outbound:!0}),c},isPredecessor:function(a,b){var c=!1;return this.search(a,function(d){if(d===b&&d!==a)return c=!0,!1},{inbound:!0}),c},isNeighbor:function(a,b,c){c=c||{};var d=c.inbound,e=c.outbound;_.isUndefined(d)&&_.isUndefined(e)&&(d=e=!0);var f=!1;return _.each(this.getConnectedLinks(a,c),function(a){var c=a.get("source"),g=a.get("target");return d&&_.has(c,"id")&&c.id===b.id?(f=!0,!1):e&&_.has(g,"id")&&g.id===b.id?(f=!0,!1):void 0}),f},disconnectLinks:function(a,b){_.each(this.getConnectedLinks(a),function(c){c.set(c.get("source").id===a.id?"source":"target",g.point(0,0),b)})},removeLinks:function(a,b){_.invoke(this.getConnectedLinks(a),"remove",b)},findModelsFromPoint:function(a){return _.filter(this.getElements(),function(b){return b.getBBox().containsPoint(a)})},findModelsInArea:function(a,b){a=g.rect(a),b=_.defaults(b||{},{strict:!1});var c=b.strict?"containsRect":"intersect";return _.filter(this.getElements(),function(b){return a[c](b.getBBox())})},findModelsUnderElement:function(a,b){b=_.defaults(b||{},{searchBy:"bbox"});var c=a.getBBox(),d="bbox"==b.searchBy?this.findModelsInArea(c):this.findModelsFromPoint(c[b.searchBy]());return _.reject(d,function(b){return a.id==b.id||b.isEmbeddedIn(a)})},getBBox:function(a,b){return this.getCellsBBox(a||this.getElements(),b)},getCellsBBox:function(a,b){return _.reduce(a,function(a,c){return c.isLink()?a:a?a.union(c.getBBox(b)):c.getBBox(b)},null)},translate:function(a,b,c){var d=_.reject(this.getCells(),function(a){return a.isEmbedded()});_.invoke(d,"translate",a,b,c)},resize:function(a,b,c){return this.resizeCells(a,b,this.getCells(),c)},resizeCells:function(a,b,c,d){var e=this.getCellsBBox(c);if(e){var f=Math.max(a/e.width,0),g=Math.max(b/e.height,0);_.invoke(c,"scale",f,g,e.origin(),d)}return this},startBatch:function(a,b){return b=b||{},this._batches[a]=(this._batches[a]||0)+1,this.trigger("batch:start",_.extend({},b,{batchName:a}))},stopBatch:function(a,b){return b=b||{},this._batches[a]=(this._batches[a]||0)-1,this.trigger("batch:stop",_.extend({},b,{batchName:a}))},hasActiveBatch:function(a){return a?this._batches[a]:_.any(this._batches,function(a){return a>0})}}),joint.util.wrapWith(joint.dia.Graph.prototype,["resetCells","addCells","removeCells"],"cells"),joint.dia.Cell=Backbone.Model.extend({constructor:function(a,b){var c,d=a||{};this.cid=_.uniqueId("c"),this.attributes={},b&&b.collection&&(this.collection=b.collection),b&&b.parse&&(d=this.parse(d,b)||{}),(c=_.result(this,"defaults"))&&(d=_.merge({},c,d)),this.set(d,b),this.changed={},this.initialize.apply(this,arguments)},translate:function(a,b,c){throw new Error("Must define a translate() method.")},toJSON:function(){var a=this.constructor.prototype.defaults.attrs||{},b=this.attributes.attrs,c={};_.each(b,function(b,d){var e=a[d];_.each(b,function(a,b){_.isObject(a)&&!_.isArray(a)?_.each(a,function(a,f){e&&e[b]&&_.isEqual(e[b][f],a)||(c[d]=c[d]||{},(c[d][b]||(c[d][b]={}))[f]=a)}):e&&_.isEqual(e[b],a)||(c[d]=c[d]||{},c[d][b]=a)})});var d=_.cloneDeep(_.omit(this.attributes,"attrs"));return d.attrs=c,d},initialize:function(a){a&&a.id||this.set("id",joint.util.uuid(),{silent:!0}),this._transitionIds={},this.processPorts(),this.on("change:attrs",this.processPorts,this)},processPorts:function(){var a=this.ports,b={};_.each(this.get("attrs"),function(a,c){a&&a.port&&(_.isUndefined(a.port.id)?b[a.port]={id:a.port}:b[a.port.id]=a.port)});var c={};if(_.each(a,function(a,d){b[d]||(c[d]=!0)}),this.graph&&!_.isEmpty(c)){var d=this.graph.getConnectedLinks(this,{inbound:!0});_.each(d,function(a){c[a.get("target").port]&&a.remove()});var e=this.graph.getConnectedLinks(this,{outbound:!0});_.each(e,function(a){c[a.get("source").port]&&a.remove()})}this.ports=b},remove:function(a){a=a||{};var b=this.graph;b&&b.startBatch("remove");var c=this.get("parent");if(c){var d=b&&b.getCell(c);d.unembed(this)}return _.invoke(this.getEmbeddedCells(),"remove",a),this.trigger("remove",this,this.collection,a),b&&b.stopBatch("remove"),this},toFront:function(a){if(this.graph){a=a||{};var b=(this.graph.getLastCell().get("z")||0)+1;if(this.startBatch("to-front").set("z",b,a),a.deep){var c=this.getEmbeddedCells({deep:!0,breadthFirst:!0});_.each(c,function(c){c.set("z",++b,a)})}this.stopBatch("to-front")}return this},toBack:function(a){if(this.graph){a=a||{};var b=(this.graph.getFirstCell().get("z")||0)-1;if(this.startBatch("to-back"),a.deep){var c=this.getEmbeddedCells({deep:!0,breadthFirst:!0});_.eachRight(c,function(c){c.set("z",b--,a)})}this.set("z",b,a).stopBatch("to-back")}return this},embed:function(a,b){if(this===a||this.isEmbeddedIn(a))throw new Error("Recursive embedding not allowed.");this.startBatch("embed");var c=_.clone(this.get("embeds")||[]);return c[a.isLink()?"unshift":"push"](a.id),a.set("parent",this.id,b),this.set("embeds",_.uniq(c),b),this.stopBatch("embed"),this},unembed:function(a,b){return this.startBatch("unembed"),a.unset("parent",b),this.set("embeds",_.without(this.get("embeds"),a.id),b),this.stopBatch("unembed"),this},getAncestors:function(){var a=[],b=this.get("parent");if(!this.graph)return a;for(;void 0!==b;){var c=this.graph.getCell(b);if(void 0===c)break;a.push(c),b=c.get("parent")}return a},getEmbeddedCells:function(a){if(a=a||{},this.graph){var b;if(a.deep)if(a.breadthFirst){b=[];for(var c=this.getEmbeddedCells();c.length>0;){
var d=c.shift();b.push(d),c.push.apply(c,d.getEmbeddedCells())}}else b=this.getEmbeddedCells(),_.each(b,function(c){b.push.apply(b,c.getEmbeddedCells(a))});else b=_.map(this.get("embeds"),this.graph.getCell,this.graph);return b}return[]},isEmbeddedIn:function(a,b){var c=_.isString(a)?a:a.id,d=this.get("parent");if(b=_.defaults({deep:!0},b),this.graph&&b.deep){for(;d;){if(d===c)return!0;d=this.graph.getCell(d).get("parent")}return!1}return d===c},isEmbedded:function(){return!!this.get("parent")},clone:function(a){if(a=a||{},a.deep)return _.values(joint.dia.Graph.prototype.cloneCells.call(null,[this].concat(this.getEmbeddedCells({deep:!0}))));var b=Backbone.Model.prototype.clone.apply(this,arguments);return b.set("id",joint.util.uuid()),b.unset("embeds"),b.unset("parent"),b},prop:function(a,b,c){var d="/";if(_.isString(a)){if(arguments.length>1){var e=a,f=e.split("/"),g=f[0];if(f.shift(),c=c||{},c.propertyPath=e,c.propertyValue=b,0===f.length)return this.set(g,b,c);var h={},i=h,j=g;_.each(f,function(a){i=i[j]=_.isFinite(Number(a))?[]:{},j=a}),h=joint.util.setByPath(h,e,b,"/");var k=_.merge({},this.attributes);c.rewrite&&joint.util.unsetByPath(k,e,"/");var l=_.merge(k,h);return this.set(g,l[g],c)}return joint.util.getByPath(this.attributes,a,d)}return this.set(_.merge({},this.attributes,a),b)},removeProp:function(a,b){b=b||{},b.dirty=!0;var c=a.split("/");if(1===c.length)return this.unset(a,b);var d=c[0],e=c.slice(1).join("/"),f=_.merge({},this.get(d));return joint.util.unsetByPath(f,e,"/"),this.set(d,f,b)},attr:function(a,b,c){var d=Array.prototype.slice.call(arguments);return _.isString(a)?d[0]="attrs/"+a:d[0]={attrs:a},this.prop.apply(this,d)},removeAttr:function(a,b){return _.isArray(a)?(_.each(a,function(a){this.removeAttr(a,b)},this),this):this.removeProp("attrs/"+a,b)},transition:function(a,b,c,d){d=d||"/";var e={duration:100,delay:10,timingFunction:joint.util.timing.linear,valueFunction:joint.util.interpolate.number};c=_.extend(e,c);var f,g=0,h=_.bind(function(b){var d,e,i;g=g||b,b-=g,e=b/c.duration,e<1?this._transitionIds[a]=d=joint.util.nextFrame(h):(e=1,delete this._transitionIds[a]),i=f(c.timingFunction(e)),c.transitionId=d,this.prop(a,i,c),d||this.trigger("transition:end",this,a)},this),i=_.bind(function(e){this.stopTransitions(a),f=c.valueFunction(joint.util.getByPath(this.attributes,a,d),b),this._transitionIds[a]=joint.util.nextFrame(e),this.trigger("transition:start",this,a)},this);return _.delay(i,c.delay,h)},getTransitions:function(){return _.keys(this._transitionIds)},stopTransitions:function(a,b){b=b||"/";var c=a&&a.split(b);return _(this._transitionIds).keys().filter(c&&function(a){return _.isEqual(c,a.split(b).slice(0,c.length))}).each(function(a){joint.util.cancelFrame(this._transitionIds[a]),delete this._transitionIds[a],this.trigger("transition:end",this,a)},this),this},addTo:function(a,b){return a.addCell(this,b),this},findView:function(a){return a.findViewByModel(this)},isElement:function(){return!1},isLink:function(){return!1},startBatch:function(a,b){return this.graph&&this.graph.startBatch(a,_.extend({},b,{cell:this})),this},stopBatch:function(a,b){return this.graph&&this.graph.stopBatch(a,_.extend({},b,{cell:this})),this}}),joint.dia.CellView=joint.mvc.View.extend({tagName:"g",className:function(){var a=["cell"],b=this.model.get("type");return b&&_.each(b.toLowerCase().split("."),function(b,c,d){a.push("type-"+d.slice(0,c+1).join("-"))}),a.join(" ")},attributes:function(){return{"model-id":this.model.id}},constructor:function(a){a.id=a.id||joint.util.guid(this),joint.mvc.View.call(this,a)},init:function(){_.bindAll(this,"remove","update"),this.$el.data("view",this),this.$el.attr("data-type",this.model.get("type")),this.listenTo(this.model,"change:attrs",this.onChangeAttrs)},onChangeAttrs:function(a,b,c){return c.dirty?this.render():this.update(a,b,c)},can:function(a){var b=_.isFunction(this.options.interactive)?this.options.interactive(this):this.options.interactive;return _.isObject(b)&&b[a]!==!1||_.isBoolean(b)&&b!==!1},_ensureElement:function(){var a;if(this.el)a=_.result(this,"el");else{var b=_.extend({id:this.id},_.result(this,"attributes"));this.className&&(b.class=_.result(this,"className")),a=V(_.result(this,"tagName"),b).node}this.setElement(a,!1)},_setElement:function(a){this.$el=a instanceof Backbone.$?a:Backbone.$(a),this.el=this.$el[0],this.vel=V(this.el)},findBySelector:function(a){var b="."===a?this.$el:this.$el.find(a);return b},notify:function(a){if(this.paper){var b=Array.prototype.slice.call(arguments,1);this.trigger.apply(this,[a].concat(b)),this.paper.trigger.apply(this.paper,[a,this].concat(b))}},getStrokeBBox:function(a){var b=!!a;a=a||this.el;var c,d=V(a).bbox(!1,this.paper.viewport);return c=b?V(a).attr("stroke-width"):this.model.attr("rect/stroke-width")||this.model.attr("circle/stroke-width")||this.model.attr("ellipse/stroke-width")||this.model.attr("path/stroke-width"),c=parseFloat(c)||0,g.rect(d).moveAndExpand({x:-c/2,y:-c/2,width:c,height:c})},getBBox:function(){return g.rect(this.vel.bbox())},highlight:function(a,b){return a=a?this.$(a)[0]||this.el:this.el,b=b||{},b.partial=a!==this.el,this.notify("cell:highlight",a,b),this},unhighlight:function(a,b){return a=a?this.$(a)[0]||this.el:this.el,b=b||{},b.partial=a!=this.el,this.notify("cell:unhighlight",a,b),this},findMagnet:function(a){var b=this.$(a),c=this.$el;0===b.length&&(b=c);do{var d=b.attr("magnet");if((d||b.is(c))&&"false"!==d)return b[0];b=b.parent()}while(b.length>0)},applyFilter:function(a,b){var c=_.isString(a)?this.findBySelector(a):$(a),d=b.name+this.paper.svg.id+joint.util.hashCode(JSON.stringify(b));if(!this.paper.svg.getElementById(d)){var e=joint.util.filter[b.name]&&joint.util.filter[b.name](b.args||{});if(!e)throw new Error("Non-existing filter "+b.name);var f=V(e);f.attr({filterUnits:"objectBoundingBox",x:-1,y:-1,width:3,height:3}),b.attrs&&f.attr(b.attrs),f.node.id=d,V(this.paper.svg).defs().append(f)}c.each(function(){V(this).attr("filter","url(#"+d+")")})},applyGradient:function(a,b,c){var d=_.isString(a)?this.findBySelector(a):$(a),e=c.type+this.paper.svg.id+joint.util.hashCode(JSON.stringify(c));if(!this.paper.svg.getElementById(e)){var f=["<"+c.type+">",_.map(c.stops,function(a){return'<stop offset="'+a.offset+'" stop-color="'+a.color+'" stop-opacity="'+(_.isFinite(a.opacity)?a.opacity:1)+'" />'}).join(""),"</"+c.type+">"].join(""),g=V(f);c.attrs&&g.attr(c.attrs),g.node.id=e,V(this.paper.svg).defs().append(g)}d.each(function(){V(this).attr(b,"url(#"+e+")")})},getSelector:function(a,b){if(a===this.el)return b;var c;if(a){var d=V(a).index()+1;c=a.tagName+":nth-child("+d+")",b&&(c+=" > "+b),c=this.getSelector(a.parentNode,c)}return c},pointerdblclick:function(a,b,c){this.notify("cell:pointerdblclick",a,b,c)},pointerclick:function(a,b,c){this.notify("cell:pointerclick",a,b,c)},pointerdown:function(a,b,c){this.model.graph&&(this.model.startBatch("pointer"),this._graph=this.model.graph),this.notify("cell:pointerdown",a,b,c)},pointermove:function(a,b,c){this.notify("cell:pointermove",a,b,c)},pointerup:function(a,b,c){this.notify("cell:pointerup",a,b,c),this._graph&&(this._graph.stopBatch("pointer",{cell:this.model}),delete this._graph)},mouseover:function(a){this.notify("cell:mouseover",a)},mouseout:function(a){this.notify("cell:mouseout",a)},mousewheel:function(a,b,c,d){this.notify("cell:mousewheel",a,b,c,d)},contextmenu:function(a,b,c){this.notify("cell:contextmenu",a,b,c)},setInteractivity:function(a){this.options.interactive=a}}),joint.dia.Element=joint.dia.Cell.extend({defaults:{position:{x:0,y:0},size:{width:1,height:1},angle:0},initialize:function(){this._initializePorts(),joint.dia.Cell.prototype.initialize.apply(this,arguments)},_initializePorts:function(){},isElement:function(){return!0},position:function(a,b,c){var d=_.isNumber(b);if(c=(d?c:a)||{},c.parentRelative){if(!this.graph)throw new Error("Element must be part of a graph.");var e=this.graph.getCell(this.get("parent")),f=e&&!e.isLink()?e.get("position"):{x:0,y:0}}if(d)return c.parentRelative&&(a+=f.x,b+=f.y),this.set("position",{x:a,y:b},c);var h=g.point(this.get("position"));return c.parentRelative?h.difference(f):h},translate:function(a,b,c){if(a=a||0,b=b||0,0===a&&0===b)return this;c=c||{},c.translateBy=c.translateBy||this.id;var d=this.get("position")||{x:0,y:0};if(c.restrictedArea&&c.translateBy===this.id){var e=this.getBBox({deep:!0}),f=c.restrictedArea,g=d.x-e.x,h=d.y-e.y,i=Math.max(f.x+g,Math.min(f.x+f.width+g-e.width,d.x+a)),j=Math.max(f.y+h,Math.min(f.y+f.height+h-e.height,d.y+b));a=i-d.x,b=j-d.y}var k={x:d.x+a,y:d.y+b};return c.tx=a,c.ty=b,c.transition?(_.isObject(c.transition)||(c.transition={}),this.transition("position",k,_.extend({},c.transition,{valueFunction:joint.util.interpolate.object}))):this.set("position",k,c),_.invoke(this.getEmbeddedCells(),"translate",a,b,c),this},resize:function(a,b,c){if(c=c||{},this.startBatch("resize",c),c.direction){var d=this.get("size");switch(c.direction){case"left":case"right":b=d.height;break;case"top":case"bottom":a=d.width}var e=g.normalizeAngle(this.get("angle")||0),f={"top-right":0,right:0,"top-left":1,top:1,"bottom-left":2,left:2,"bottom-right":3,bottom:3}[c.direction];c.absolute&&(f+=Math.floor((e+45)/90),f%=4);var h=this.getBBox(),i=h[["bottomLeft","corner","topRight","origin"][f]](),j=g.point(i).rotate(h.center(),-e),k=Math.sqrt(a*a+b*b)/2,l=f*Math.PI/2;l+=Math.atan(f%2==0?b/a:a/b),l-=g.toRad(e);var m=g.point.fromPolar(k,l,j),n=g.point(m).offset(a/-2,b/-2);this.set("size",{width:a,height:b},c),this.position(n.x,n.y,c)}else this.set("size",{width:a,height:b},c);return this.stopBatch("resize",c),this},scale:function(a,b,c,d){var e=this.getBBox().scale(a,b,c);return this.startBatch("scale",d),this.position(e.x,e.y,d),this.resize(e.width,e.height,d),this.stopBatch("scale"),this},fitEmbeds:function(a){if(a=a||{},!this.graph)throw new Error("Element must be part of a graph.");var b=this.getEmbeddedCells();if(b.length>0){this.startBatch("fit-embeds",a),a.deep&&_.invoke(b,"fitEmbeds",a);var c=this.graph.getCellsBBox(b),d=joint.util.normalizeSides(a.padding);c.moveAndExpand({x:-d.left,y:-d.top,width:d.right+d.left,height:d.bottom+d.top}),this.set({position:{x:c.x,y:c.y},size:{width:c.width,height:c.height}},a),this.stopBatch("fit-embeds")}return this},rotate:function(a,b,c,d){if(c){var e=this.getBBox().center(),f=this.get("size"),g=this.get("position");e.rotate(c,this.get("angle")-a);var h=e.x-f.width/2-g.x,i=e.y-f.height/2-g.y;this.startBatch("rotate",{angle:a,absolute:b,origin:c}),this.translate(h,i,_.clone(d)),this.rotate(a,b,null,d),this.stopBatch("rotate")}else this.set("angle",b?a:(this.get("angle")+a)%360,d);return this},getBBox:function(a){if(a=a||{},a.deep&&this.graph){var b=this.getEmbeddedCells({deep:!0,breadthFirst:!0});return b.push(this),this.graph.getCellsBBox(b)}var c=this.get("position"),d=this.get("size");return g.rect(c.x,c.y,d.width,d.height)}}),joint.dia.ElementView=joint.dia.CellView.extend({SPECIAL_ATTRIBUTES:["style","text","html","ref-x","ref-y","ref-dx","ref-dy","ref-width","ref-height","ref","x-alignment","y-alignment","port"],_removePorts:function(){},_renderPorts:function(){},className:function(){var a=joint.dia.CellView.prototype.className.apply(this).split(" ");return a.push("element"),a.join(" ")},initialize:function(){joint.dia.CellView.prototype.initialize.apply(this,arguments);var a=this.model;this.listenTo(a,"change:position",this.translate),this.listenTo(a,"change:size",this.resize),this.listenTo(a,"change:angle",this.rotate),this.listenTo(a,"change:markup",this.render),this._initializePorts()},_initializePorts:function(){},updateAttr:function(a,b){var c=this.SPECIAL_ATTRIBUTES.slice();_.isObject(b.filter)&&(c.push("filter"),this.applyFilter(a,b.filter)),_.isObject(b.fill)&&(c.push("fill"),this.applyGradient(a,"fill",b.fill)),_.isObject(b.stroke)&&(c.push("stroke"),this.applyGradient(a,"stroke",b.stroke)),_.isUndefined(b.text)||(a.each(function(){_.isUndefined(b.x)||(V(this).attr("x",b.x),c.push("x")),_.isUndefined(b.y)||(V(this).attr("y",b.y),c.push("y")),V(this).text(b.text+"",{lineHeight:b.lineHeight,textPath:b.textPath,annotations:b.annotations})}),c.push("lineHeight","textPath","annotations"));var d=_.omit(b,c);a.each(function(){V(this).attr(d)}),b.port&&a.attr("port",_.isUndefined(b.port.id)?b.port:b.port.id),b.style&&a.css(b.style),_.isUndefined(b.html)||a.each(function(){$(this).html(b.html+"")})},update:function(a,b){this._removePorts();var c=this.model.get("attrs"),d=this.rotatableNode;if(d){var e=d.attr("transform");d.attr("transform","")}var f=[],g={};_.each(b||c,function(a,b){var c="."===b?this.$el:this.findBySelector(b);0!==c.length&&(g[b]=c,this.updateAttr(c,a),_.isUndefined(a["ref-x"])&&_.isUndefined(a["ref-y"])&&_.isUndefined(a["ref-dx"])&&_.isUndefined(a["ref-dy"])&&_.isUndefined(a["x-alignment"])&&_.isUndefined(a["y-alignment"])&&_.isUndefined(a["ref-width"])&&_.isUndefined(a["ref-height"])||_.each(c,function(a,b,c){var d=$(a);d.selector=c.selector,f.push(d)}))},this);var h=this.model.get("size"),i={x:0,y:0,width:h.width,height:h.height};b=b||{},_.each(f,function(a){var d=b[a.selector],e=d?_.merge({},c[a.selector],d):c[a.selector];this.positionRelative(V(a[0]),i,e,g)},this),d&&d.attr("transform",e||""),this._renderPorts()},positionRelative:function(a,b,c,d){var e=c.ref,f=parseFloat(c["ref-dx"]),g=parseFloat(c["ref-dy"]),h=c["y-alignment"],i=c["x-alignment"],j=c["ref-y"],k=_.isString(j)&&"%"===j.slice(-1);j=parseFloat(j),k&&(j/=100);var l=c["ref-x"],m=_.isString(l)&&"%"===l.slice(-1);l=parseFloat(l),m&&(l/=100);var n=c["ref-width"],o=_.isString(n)&&"%"===n.slice(-1);n=parseFloat(n),o&&(n/=100);var p=c["ref-height"],q=_.isString(p)&&"%"===p.slice(-1);p=parseFloat(p),q&&(p/=100);var r=a.findParentByClass("scalable",this.el);if(e){var s;if(s=d&&d[e]?V(d[e][0]):"."===e?this.vel:this.vel.findOne(e),!s)throw new Error("dia.ElementView: reference does not exists.");b=s.bbox(!1,this.el)}a.attr("transform")&&a.attr("transform",a.attr("transform").replace(/translate\([^)]*\)/g,"").trim()||""),isFinite(n)&&(o||n>=0&&n<=1?a.attr("width",n*b.width):a.attr("width",Math.max(n+b.width,0))),isFinite(p)&&(q||p>=0&&p<=1?a.attr("height",p*b.height):a.attr("height",Math.max(p+b.height,0)));var t,u=0,v=0;if(isFinite(f)&&(r?(t=t||r.scale(),u=b.x+b.width+f/t.sx):u=b.x+b.width+f),isFinite(g)&&(r?(t=t||r.scale(),v=b.y+b.height+g/t.sy):v=b.y+b.height+g),isFinite(l)&&(m||l>0&&l<1?u=b.x+b.width*l:r?(t=t||r.scale(),u=b.x+l/t.sx):u=b.x+l),isFinite(j)&&(k||j>0&&j<1?v=b.y+b.height*j:r?(t=t||r.scale(),v=b.y+j/t.sy):v=b.y+j),!_.isUndefined(h)||!_.isUndefined(i)){var w=a.node,x=a.bbox(!1,w.parentNode),y=w.nodeName.toUpperCase();"TEXT"!==y&&"TSPAN"!==y||(x.height+=x.y,x.width+=x.x),r&&(t=t||r.scale(),x.width*=t.sx,x.height*=t.sy),"middle"===h?v-=x.height/2:"bottom"===h?v-=x.height:isFinite(h)&&(v+=h>-1&&h<1?x.height*h:h),"middle"===i?u-=x.width/2:"right"===i?u-=x.width:isFinite(i)&&(u+=i>-1&&i<1?x.width*i:i)}a.translate(u,v)},renderMarkup:function(){var a=this.model.get("markup")||this.model.markup;if(!a)throw new Error("properties.markup is missing while the default render() implementation is used.");var b=joint.util.template(a)(),c=V(b);this.vel.append(c)},render:function(){return this.$el.empty(),this.renderMarkup(),this.rotatableNode=this.vel.findOne(".rotatable"),this.scalableNode=this.vel.findOne(".scalable"),this.update(),this.resize(),this.rotate(),this.translate(),this},scale:function(a,b){this.vel.scale(a,b)},resize:function(a,b,c){var d=this.model,e=d.get("size")||{width:1,height:1},f=d.get("angle")||0,g=this.scalableNode;if(!g)return 0!==f&&this.rotate(),void this.update();var h=g.bbox(!0);g.attr("transform","scale("+e.width/(h.width||1)+","+e.height/(h.height||1)+")");var i=this.rotatableNode,j=i&&i.attr("transform");if(j&&"null"!==j){i.attr("transform",j+" rotate("+-f+","+e.width/2+","+e.height/2+")");var k=g.bbox(!1,this.paper.viewport);d.set("position",{x:k.x,y:k.y},c),this.rotate()}this.update()},translate:function(a,b,c){var d=this.model.get("position")||{x:0,y:0};this.vel.attr("transform","translate("+d.x+","+d.y+")")},rotate:function(){var a=this.rotatableNode;if(a){var b=this.model.get("angle")||0,c=this.model.get("size")||{width:1,height:1},d=c.width/2,e=c.height/2;0!==b?a.attr("transform","rotate("+b+","+d+","+e+")"):a.removeAttr("transform")}},getBBox:function(a){if(a&&a.useModelGeometry){var b=this.model.getBBox().bbox(this.model.get("angle")),c=this.paper.viewport.getCTM();return g.rect(V.transformRect(b,c))}return joint.dia.CellView.prototype.getBBox.apply(this,arguments)},prepareEmbedding:function(a){a=a||{};var b=a.model||this.model,c=a.paper||this.paper,d=c.model;b.startBatch("to-front",a),b.toFront({deep:!0,ui:!0});var e=d.get("cells").max("z").get("z"),f=d.getConnectedLinks(b,{deep:!0});_.invoke(f,"set","z",e+1,{ui:!0}),b.stopBatch("to-front");var g=b.get("parent");g&&d.getCell(g).unembed(b,{ui:!0})},processEmbedding:function(a){a=a||{};var b=a.model||this.model,c=a.paper||this.paper,d=c.options,e=c.model.findModelsUnderElement(b,{searchBy:d.findParentBy});d.frontParentOnly&&(e=e.slice(-1));for(var f=null,g=this._candidateEmbedView,h=e.length-1;h>=0;h--){var i=e[h];if(g&&g.model.id==i.id){f=g;break}var j=i.findView(c);if(d.validateEmbedding.call(c,this,j)){f=j;break}}f&&f!=g&&(this.clearEmbedding(),this._candidateEmbedView=f.highlight(null,{embedding:!0})),!f&&g&&this.clearEmbedding()},clearEmbedding:function(){var a=this._candidateEmbedView;a&&(a.unhighlight(null,{embedding:!0}),this._candidateEmbedView=null)},finalizeEmbedding:function(a){a=a||{};var b=this._candidateEmbedView,c=a.model||this.model,d=a.paper||this.paper;b&&(b.model.embed(c,{ui:!0}),b.unhighlight(null,{embedding:!0}),delete this._candidateEmbedView),_.invoke(d.model.getConnectedLinks(c,{deep:!0}),"reparent",{ui:!0})},pointerdown:function(a,b,c){var d=this.paper;if(a.target.getAttribute("magnet")&&this.can("addLinkFromMagnet")&&d.options.validateMagnet.call(d,this,a.target)){this.model.startBatch("add-link");var e=d.getDefaultLink(this,a.target);e.set({source:{id:this.model.id,selector:this.getSelector(a.target),port:a.target.getAttribute("port")},target:{x:b,y:c}}),d.model.addCell(e);var f=this._linkView=d.findViewByModel(e);f.pointerdown(a,b,c),f.startArrowheadMove("target",{whenNotAllowed:"remove"})}else this._dx=b,this._dy=c,this.restrictedArea=d.getRestrictedArea(this),joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("element:pointerdown",a,b,c)},pointermove:function(a,b,c){if(this._linkView)this._linkView.pointermove(a,b,c);else{var d=this.paper.options.gridSize;if(this.can("elementMove")){var e=this.model.get("position"),f=g.snapToGrid(e.x,d)-e.x+g.snapToGrid(b-this._dx,d),h=g.snapToGrid(e.y,d)-e.y+g.snapToGrid(c-this._dy,d);this.model.translate(f,h,{restrictedArea:this.restrictedArea,ui:!0}),this.paper.options.embeddingMode&&(this._inProcessOfEmbedding||(this.prepareEmbedding(),this._inProcessOfEmbedding=!0),this.processEmbedding())}this._dx=g.snapToGrid(b,d),this._dy=g.snapToGrid(c,d),joint.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("element:pointermove",a,b,c)}},pointerup:function(a,b,c){this._linkView?(this._linkView.pointerup(a,b,c),this._linkView=null,this.model.stopBatch("add-link")):(this._inProcessOfEmbedding&&(this.finalizeEmbedding(),this._inProcessOfEmbedding=!1),this.notify("element:pointerup",a,b,c),joint.dia.CellView.prototype.pointerup.apply(this,arguments))}}),joint.dia.Link=joint.dia.Cell.extend({markup:['<path class="connection" stroke="black" d="M 0 0 0 0"/>','<path class="marker-source" fill="black" stroke="black" d="M 0 0 0 0"/>','<path class="marker-target" fill="black" stroke="black" d="M 0 0 0 0"/>','<path class="connection-wrap" d="M 0 0 0 0"/>','<g class="labels"/>','<g class="marker-vertices"/>','<g class="marker-arrowheads"/>','<g class="link-tools"/>'].join(""),labelMarkup:['<g class="label">',"<rect />","<text />","</g>"].join(""),toolMarkup:['<g class="link-tool">','<g class="tool-remove" event="remove">','<circle r="11" />','<path transform="scale(.8) translate(-16, -16)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z" />',"<title>Remove link.</title>","</g>",'<g class="tool-options" event="link:options">','<circle r="11" transform="translate(25)"/>','<path fill="white" transform="scale(.55) translate(29, -16)" d="M31.229,17.736c0.064-0.571,0.104-1.148,0.104-1.736s-0.04-1.166-0.104-1.737l-4.377-1.557c-0.218-0.716-0.504-1.401-0.851-2.05l1.993-4.192c-0.725-0.91-1.549-1.734-2.458-2.459l-4.193,1.994c-0.647-0.347-1.334-0.632-2.049-0.849l-1.558-4.378C17.165,0.708,16.588,0.667,16,0.667s-1.166,0.041-1.737,0.105L12.707,5.15c-0.716,0.217-1.401,0.502-2.05,0.849L6.464,4.005C5.554,4.73,4.73,5.554,4.005,6.464l1.994,4.192c-0.347,0.648-0.632,1.334-0.849,2.05l-4.378,1.557C0.708,14.834,0.667,15.412,0.667,16s0.041,1.165,0.105,1.736l4.378,1.558c0.217,0.715,0.502,1.401,0.849,2.049l-1.994,4.193c0.725,0.909,1.549,1.733,2.459,2.458l4.192-1.993c0.648,0.347,1.334,0.633,2.05,0.851l1.557,4.377c0.571,0.064,1.148,0.104,1.737,0.104c0.588,0,1.165-0.04,1.736-0.104l1.558-4.377c0.715-0.218,1.399-0.504,2.049-0.851l4.193,1.993c0.909-0.725,1.733-1.549,2.458-2.458l-1.993-4.193c0.347-0.647,0.633-1.334,0.851-2.049L31.229,17.736zM16,20.871c-2.69,0-4.872-2.182-4.872-4.871c0-2.69,2.182-4.872,4.872-4.872c2.689,0,4.871,2.182,4.871,4.872C20.871,18.689,18.689,20.871,16,20.871z"/>',"<title>Link options.</title>","</g>","</g>"].join(""),vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>"].join(""),arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<path class="marker-arrowhead" end="<%= end %>" d="M 26 0 L 0 13 L 26 26 z" />',"</g>"].join(""),defaults:{type:"link",source:{},target:{}},isLink:function(){return!0},disconnect:function(){return this.set({source:g.point(0,0),target:g.point(0,0)})},label:function(a,b){a=a||0;var c=this.get("labels")||[];if(0===arguments.length||1===arguments.length)return c[a];var d=_.merge({},c[a],b),e=c.slice();return e[a]=d,this.set({labels:e})},translate:function(a,b,c){return c=c||{},c.translateBy=c.translateBy||this.id,c.tx=a,c.ty=b,this.applyToPoints(function(c){return{x:(c.x||0)+a,y:(c.y||0)+b}},c)},scale:function(a,b,c,d){return this.applyToPoints(function(d){return g.point(d).scale(a,b,c).toJSON()},d)},applyToPoints:function(a,b){if(!_.isFunction(a))throw new TypeError("dia.Link: applyToPoints expects its first parameter to be a function.");var c={},d=this.get("source");d.id||(c.source=a(d));var e=this.get("target");e.id||(c.target=a(e));var f=this.get("vertices");return f&&f.length>0&&(c.vertices=_.map(f,a)),this.set(c,b)},reparent:function(a){var b;if(this.graph){var c=this.graph.getCell(this.get("source").id),d=this.graph.getCell(this.get("target").id),e=this.graph.getCell(this.get("parent"));c&&d&&(b=this.graph.getCommonAncestor(c,d)),!e||b&&b.id===e.id||e.unembed(this,a),b&&b.embed(this,a)}return b},hasLoop:function(a){a=a||{};var b=this.get("source").id,c=this.get("target").id;if(!b||!c)return!1;var d=b===c;if(!d&&a.deep&&this.graph){var e=this.graph.getCell(b),f=this.graph.getCell(c);d=e.isEmbeddedIn(f)||f.isEmbeddedIn(e)}return d},getSourceElement:function(){var a=this.get("source");return a&&a.id&&this.graph&&this.graph.getCell(a.id)||null},getTargetElement:function(){var a=this.get("target");return a&&a.id&&this.graph&&this.graph.getCell(a.id)||null},getRelationshipAncestor:function(){var a;if(this.graph){var b=_.compact([this,this.getSourceElement(),this.getTargetElement()]);a=this.graph.getCommonAncestor.apply(this.graph,b)}return a||null},isRelationshipEmbeddedIn:function(a){var b=_.isString(a)?a:a.id,c=this.getRelationshipAncestor();return!!c&&(c.id===b||c.isEmbeddedIn(b))}},{endsEqual:function(a,b){var c=a.port===b.port||!a.port&&!b.port;return a.id===b.id&&c}}),joint.dia.LinkView=joint.dia.CellView.extend({className:function(){var a=joint.dia.CellView.prototype.className.apply(this).split(" ");return a.push("link"),a.join(" ")},options:{shortLinkLength:100,doubleLinkTools:!1,longLinkLength:160,linkToolsOffset:40,doubleLinkToolsOffset:60,sampleInterval:50},_z:null,initialize:function(a){joint.dia.CellView.prototype.initialize.apply(this,arguments),"function"!=typeof this.constructor.prototype.watchSource&&(this.constructor.prototype.watchSource=this.createWatcher("source"),this.constructor.prototype.watchTarget=this.createWatcher("target")),this._labelCache={},this._markerCache={},this.startListening()},startListening:function(){var a=this.model;this.listenTo(a,"change:markup",this.render),this.listenTo(a,"change:smooth change:manhattan change:router change:connector",this.update),this.listenTo(a,"change:toolMarkup",this.onToolsChange),this.listenTo(a,"change:labels change:labelMarkup",this.onLabelsChange),this.listenTo(a,"change:vertices change:vertexMarkup",this.onVerticesChange),this.listenTo(a,"change:source",this.onSourceChange),this.listenTo(a,"change:target",this.onTargetChange)},onSourceChange:function(a,b,c){this.watchSource(a,b),c.translateBy&&this.model.get("target").id||(c.updateConnectionOnly=!0,this.update(this.model,null,c))},onTargetChange:function(a,b,c){this.watchTarget(a,b),c.translateBy||(c.updateConnectionOnly=!0,this.update(this.model,null,c))},onVerticesChange:function(a,b,c){this.renderVertexMarkers(),c.translateBy&&c.translateBy!==this.model.id||(c.updateConnectionOnly=!0,this.update(a,null,c))},onToolsChange:function(){this.renderTools().updateToolsPosition()},onLabelsChange:function(){this.renderLabels().updateLabelPositions()},render:function(){this.$el.empty();var a=this.model,b=a.get("markup")||a.markup,c=V(b);if(_.isArray(c)||(c=[c]),this._V={},_.each(c,function(a){var b=a.attr("class");b&&(b=joint.util.removeClassNamePrefix(b),this._V[$.camelCase(b)]=a)},this),!this._V.connection)throw new Error("link: no connection path in the markup");return this.renderTools(),this.renderVertexMarkers(),this.renderArrowheadMarkers(),this.vel.append(c),this.renderLabels(),this.watchSource(a,a.get("source")).watchTarget(a,a.get("target")).update(),this},renderLabels:function(){if(!this._V.labels)return this;this._labelCache={};var a=$(this._V.labels.node).empty(),b=this.model.get("labels")||[];if(!b.length)return this;var c=joint.util.template(this.model.get("labelMarkup")||this.model.labelMarkup),d=V(c()),e=this.can("labelMove");return _.each(b,function(b,c){var f=d.clone().node;V(f).attr("label-idx",c),e&&V(f).attr("cursor","move"),this._labelCache[c]=V(f);var g=$(f).find("text"),h=$(f).find("rect"),i=_.extend({"text-anchor":"middle","font-size":14},joint.util.getByPath(b,"attrs/text","/"));g.attr(_.omit(i,"text")),_.isUndefined(i.text)||V(g[0]).text(i.text+"",{annotations:i.annotations}),a.append(f);var j=V(g[0]).bbox(!0,a[0]);V(g[0]).translate(0,-j.height/2);var k=_.extend({fill:"white",rx:3,ry:3},joint.util.getByPath(b,"attrs/rect","/"));h.attr(_.extend(k,{x:j.x,y:j.y-j.height/2,width:j.width,height:j.height}))},this),this},renderTools:function(){if(!this._V.linkTools)return this;var a=$(this._V.linkTools.node).empty(),b=joint.util.template(this.model.get("toolMarkup")||this.model.toolMarkup),c=V(b());if(a.append(c.node),this._toolCache=c,this.options.doubleLinkTools){var d;this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup?(b=joint.util.template(this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup),d=V(b())):d=c.clone(),a.append(d.node),this._tool2Cache=d}return this},renderVertexMarkers:function(){if(!this._V.markerVertices)return this;var a=$(this._V.markerVertices.node).empty(),b=joint.util.template(this.model.get("vertexMarkup")||this.model.vertexMarkup);return _.each(this.model.get("vertices"),function(c,d){a.append(V(b(_.extend({idx:d},c))).node)}),this},renderArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;var a=$(this._V.markerArrowheads.node);a.empty();var b=joint.util.template(this.model.get("arrowheadMarkup")||this.model.arrowheadMarkup);return this._V.sourceArrowhead=V(b({end:"source"})),this._V.targetArrowhead=V(b({end:"target"})),a.append(this._V.sourceArrowhead.node,this._V.targetArrowhead.node),this},update:function(a,b,c){return c=c||{},c.updateConnectionOnly||this.updateAttributes(),this.updateConnection(c),this.updateLabelPositions(),this.updateToolsPosition(),this.updateArrowheadMarkers(),this.options.perpendicular=null,this.updatePostponed=!1,this},updateConnection:function(a){a=a||{};var b,c=this.model;if(a.translateBy&&c.isRelationshipEmbeddedIn(a.translateBy)){var d=a.tx||0,e=a.ty||0;b=this.route=_.map(this.route,function(a){return g.point(a).offset(d,e)}),this._translateConnectionPoints(d,e)}else b=this.route=this.findRoute(c.get("vertices")||[],a),this._findConnectionPoints(b);var f=this.getPathData(b);this._V.connection.attr("d",f),this._V.connectionWrap&&this._V.connectionWrap.attr("d",f),this._translateAndAutoOrientArrows(this._V.markerSource,this._V.markerTarget)},updateAttributes:function(){_.each(this.model.get("attrs"),function(a,b){var c=[];_.isObject(a.fill)&&(this.applyGradient(b,"fill",a.fill),c.push("fill")),_.isObject(a.stroke)&&(this.applyGradient(b,"stroke",a.stroke),c.push("stroke")),_.isObject(a.filter)&&(this.applyFilter(b,a.filter),c.push("filter")),c.length>0&&(c.unshift(a),a=_.omit.apply(_,c)),this.findBySelector(b).attr(a)},this)},_findConnectionPoints:function(a){var b,c,d,e,f=_.first(a);b=this.getConnectionPoint("source",this.model.get("source"),f||this.model.get("target")).round();var h=_.last(a);c=this.getConnectionPoint("target",this.model.get("target"),h||b).round();var i=this._markerCache;this._V.markerSource&&(i.sourceBBox=i.sourceBBox||this._V.markerSource.bbox(!0),d=g.point(b).move(f||c,i.sourceBBox.width*this._V.markerSource.scale().sx*-1).round()),this._V.markerTarget&&(i.targetBBox=i.targetBBox||this._V.markerTarget.bbox(!0),e=g.point(c).move(h||b,i.targetBBox.width*this._V.markerTarget.scale().sx*-1).round()),i.sourcePoint=d||b,i.targetPoint=e||c,this.sourcePoint=b,this.targetPoint=c},_translateConnectionPoints:function(a,b){var c=this._markerCache;c.sourcePoint.offset(a,b),c.targetPoint.offset(a,b),this.sourcePoint.offset(a,b),this.targetPoint.offset(a,b)},updateLabelPositions:function(){if(!this._V.labels)return this;var a=this.model.get("labels")||[];if(!a.length)return this;var b=this._V.connection.node,c=b.getTotalLength();if(!_.isNaN(c)){var d;_.each(a,function(a,e){var f=a.position,h=_.isObject(f)?f.distance:f,i=_.isObject(f)?f.offset:{x:0,y:0};_.isNaN(h)?h=c/2:(h=h>c?c:h,h=h<0?c+h:h,h=h>1?h:c*h);var j=b.getPointAtLength(h);if(_.isObject(i))j=g.point(j).offset(i.x,i.y);else if(_.isNumber(i)){d||(d=this._samples||this._V.connection.sample(this.options.sampleInterval));for(var k,l,m,n=1/0,o=0;o<d.length;o++)l=d[o],m=g.line(l,j).squaredLength(),m<n&&(n=m,k=o);var p=d[k-1],q=d[k+1],r=0;q?r=g.point(j).theta(q):p&&(r=g.point(p).theta(j)),j=g.point(j).offset(i).rotate(j,r-90)}this._labelCache[e].attr("transform","translate("+j.x+", "+j.y+")")},this)}return this},updateToolsPosition:function(){if(!this._V.linkTools)return this;var a="",b=this.options.linkToolsOffset,c=this.getConnectionLength();if(!_.isNaN(c)){c<this.options.shortLinkLength&&(a="scale(.5)",b/=2);var d=this.getPointAtLength(b);
if(this._toolCache.attr("transform","translate("+d.x+", "+d.y+") "+a),this.options.doubleLinkTools&&c>=this.options.longLinkLength){var e=this.options.doubleLinkToolsOffset||b;d=this.getPointAtLength(c-e),this._tool2Cache.attr("transform","translate("+d.x+", "+d.y+") "+a),this._tool2Cache.attr("visibility","visible")}else this.options.doubleLinkTools&&this._tool2Cache.attr("visibility","hidden")}return this},updateArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;if("none"===$.css(this._V.markerArrowheads.node,"display"))return this;var a=this.getConnectionLength()<this.options.shortLinkLength?.5:1;return this._V.sourceArrowhead.scale(a),this._V.targetArrowhead.scale(a),this._translateAndAutoOrientArrows(this._V.sourceArrowhead,this._V.targetArrowhead),this},createWatcher:function(a){function b(b,d){d=d||{};var e=null,f=b.previous(a)||{};return f.id&&this.stopListening(this.paper.getModelById(f.id),"change",c),d.id&&(e=this.paper.getModelById(d.id),this.listenTo(e,"change",c)),c.call(this,e,{cacheOnly:!0}),this}var c=_.partial(this.onEndModelChange,a);return b},onEndModelChange:function(a,b,c){var d=!c.cacheOnly,e=this.model,f=e.get(a)||{};if(b){var h=this.constructor.makeSelector(f),i="source"==a?"target":"source",j=e.get(i)||{},k=j.id&&this.constructor.makeSelector(j);if(c.handleBy===this.cid&&h==k)this[a+"BBox"]=this[i+"BBox"],this[a+"View"]=this[i+"View"],this[a+"Magnet"]=this[i+"Magnet"];else if(c.translateBy){var l=this[a+"BBox"];l.x+=c.tx,l.y+=c.ty}else{var m=this.paper.findViewByModel(f.id),n=m.el.querySelector(h);this[a+"BBox"]=m.getStrokeBBox(n),this[a+"View"]=m,this[a+"Magnet"]=n}if(c.handleBy===this.cid&&c.translateBy&&e.isEmbeddedIn(b)&&!_.isEmpty(e.get("vertices"))&&(d=!1),!this.updatePostponed&&j.id){var o=this.paper.getModelById(j.id);f.id===j.id&&(c.handleBy=this.cid),(c.handleBy===this.cid||c.translateBy&&o.isEmbeddedIn(c.translateBy))&&(this.updatePostponed=!0,d=!1)}}else this[a+"BBox"]=g.rect(f.x||0,f.y||0,1,1),this[a+"View"]=this[a+"Magnet"]=null;d&&(c.updateConnectionOnly=!0,this.update(e,null,c))},_translateAndAutoOrientArrows:function(a,b){a&&a.translateAndAutoOrient(this.sourcePoint,_.first(this.route)||this.targetPoint,this.paper.viewport),b&&b.translateAndAutoOrient(this.targetPoint,_.last(this.route)||this.sourcePoint,this.paper.viewport)},removeVertex:function(a){var b=_.clone(this.model.get("vertices"));return b&&b.length&&(b.splice(a,1),this.model.set("vertices",b,{ui:!0})),this},addVertex:function(a){for(var b,c=(this.model.get("vertices")||[]).slice(),d=c.slice(),e=this._V.connection.node.cloneNode(!1),f=e.getTotalLength(),g=20,h=c.length+1;h--&&(c.splice(h,0,a),V(e).attr("d",this.getPathData(this.findRoute(c))),b=e.getTotalLength(),b-f>g);)c=d.slice();return h===-1&&(h=0,c.splice(h,0,a)),this.model.set("vertices",c,{ui:!0}),h},sendToken:function(a,b,c){b=b||1e3,V(this.paper.viewport).append(a),V(a).animateAlongPath({dur:b+"ms",repeatCount:1},this._V.connection.node),_.delay(function(){V(a).remove(),c&&c()},b)},findRoute:function(a){var b=joint.routers,c=this.model.get("router"),d=this.paper.options.defaultRouter;if(!c)if(this.model.get("manhattan"))c={name:"orthogonal"};else{if(!d)return a;c=d}var e=c.args||{},f=_.isFunction(c)?c:b[c.name];if(!_.isFunction(f))throw new Error('unknown router: "'+c.name+'"');var g=f.call(this,a||[],e,this);return g},getPathData:function(a){var b=joint.connectors,c=this.model.get("connector"),d=this.paper.options.defaultConnector;c||(c=this.model.get("smooth")?{name:"smooth"}:d||{});var e=_.isFunction(c)?c:b[c.name],f=c.args||{};if(!_.isFunction(e))throw new Error('unknown connector: "'+c.name+'"');var g=e.call(this,this._markerCache.sourcePoint,this._markerCache.targetPoint,a||this.model.get("vertices")||{},f,this);return g},getConnectionPoint:function(a,b,c){var d;if(_.isEmpty(b)&&(b={x:0,y:0}),_.isEmpty(c)&&(c={x:0,y:0}),b.id){var e,f=g.Rect("source"===a?this.sourceBBox:this.targetBBox);if(c.id){var h=g.Rect("source"===a?this.targetBBox:this.sourceBBox);e=h.intersectionWithLineFromCenterToPoint(f.center()),e=e||h.center()}else e=g.Point(c);var i=this.paper.options;if(i.perpendicularLinks||this.options.perpendicular){var j,k=f.origin(),l=f.corner();if(k.y<=e.y&&e.y<=l.y)switch(j=f.sideNearestToPoint(e)){case"left":d=g.Point(k.x,e.y);break;case"right":d=g.Point(l.x,e.y);break;default:d=f.center()}else if(k.x<=e.x&&e.x<=l.x)switch(j=f.sideNearestToPoint(e)){case"top":d=g.Point(e.x,k.y);break;case"bottom":d=g.Point(e.x,l.y);break;default:d=f.center()}else d=f.intersectionWithLineFromCenterToPoint(e),d=d||f.center()}else if(i.linkConnectionPoint){var m="target"===a?this.targetView:this.sourceView,n="target"===a?this.targetMagnet:this.sourceMagnet;d=i.linkConnectionPoint(this,m,n,e)}else d=f.intersectionWithLineFromCenterToPoint(e),d=d||f.center()}else d=g.Point(b);return d},getConnectionLength:function(){return this._V.connection.node.getTotalLength()},getPointAtLength:function(a){return this._V.connection.node.getPointAtLength(a)},_beforeArrowheadMove:function(){this._z=this.model.get("z"),this.model.toFront(),this.el.style.pointerEvents="none",this.paper.options.markAvailable&&this._markAvailableMagnets()},_afterArrowheadMove:function(){_.isNull(this._z)||(this.model.set("z",this._z,{ui:!0}),this._z=null),this.el.style.pointerEvents="visiblePainted",this.paper.options.markAvailable&&this._unmarkAvailableMagnets()},_createValidateConnectionArgs:function(a){function b(a,b){return c[f]=a,c[f+1]=a.el===b?void 0:b,c}var c=[];c[4]=a,c[5]=this;var d,e=0,f=0;"source"===a?(e=2,d="target"):(f=2,d="source");var g=this.model.get(d);return g.id&&(c[e]=this.paper.findViewByModel(g.id),c[e+1]=g.selector&&c[e].el.querySelector(g.selector)),b},_markAvailableMagnets:function(){function a(a,b){var c=a.paper,d=c.options.validateConnection;return d.apply(c,this._validateConnectionArgs(a,b))}var b=this.paper,c=b.model.getElements();this._marked={},_.chain(c).map(b.findViewByModel,b).each(function(b){var c=Array.prototype.slice.call(b.el.querySelectorAll("[magnet]"));"false"!==b.el.getAttribute("magnet")&&c.push(b.el);var d=_.filter(c,_.partial(a,b),this);d.length>0&&(_.each(d,_.partial(b.highlight,_,{magnetAvailability:!0}),b),b.highlight(null,{elementAvailability:!0}),this._marked[b.model.id]=d)},this).value()},_unmarkAvailableMagnets:function(){_.each(this._marked,function(a,b){var c=this.paper.findViewByModel(b);c&&(_.each(a,_.partial(c.unhighlight,_,{magnetAvailability:!0}),c),c.unhighlight(null,{elementAvailability:!0}))},this),this._marked=null},startArrowheadMove:function(a,b){b=_.defaults(b||{},{whenNotAllowed:"revert"}),this._action="arrowhead-move",this._whenNotAllowed=b.whenNotAllowed,this._arrowhead=a,this._initialMagnet=this[a+"Magnet"]||(this[a+"View"]?this[a+"View"].el:null),this._initialEnd=_.clone(this.model.get(a))||{x:0,y:0},this._validateConnectionArgs=this._createValidateConnectionArgs(this._arrowhead),this._beforeArrowheadMove()},pointerdown:function(a,b,c){if(joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("link:pointerdown",a,b,c),this._dx=b,this._dy=c,null==a.target.getAttribute("magnet")){var d,e=joint.util.removeClassNamePrefix(a.target.getAttribute("class")),f=joint.util.removeClassNamePrefix(a.target.parentNode.getAttribute("class"));switch("label"===f?(e=f,d=a.target.parentNode):d=a.target,e){case"marker-vertex":this.can("vertexMove")&&(this._action="vertex-move",this._vertexIdx=a.target.getAttribute("idx"));break;case"marker-vertex-remove":case"marker-vertex-remove-area":this.can("vertexRemove")&&this.removeVertex(a.target.getAttribute("idx"));break;case"marker-arrowhead":this.can("arrowheadMove")&&this.startArrowheadMove(a.target.getAttribute("end"));break;case"label":this.can("labelMove")&&(this._action="label-move",this._labelIdx=parseInt(V(d).attr("label-idx"),10),this._samples=this._V.connection.sample(1),this._linkLength=this._V.connection.node.getTotalLength());break;default:var g=a.target.parentNode.getAttribute("event");g?this.can("useLinkTools")&&("remove"===g?this.model.remove():this.notify(g,a,b,c)):this.can("vertexAdd")&&(this._vertexIdx=this.addVertex({x:b,y:c}),this._action="vertex-move")}}},pointermove:function(a,b,c){switch(this._action){case"vertex-move":var d=_.clone(this.model.get("vertices"));d[this._vertexIdx]={x:b,y:c},this.model.set("vertices",d,{ui:!0});break;case"label-move":for(var e,f,h,i,j={x:b,y:c},k=this._samples,l=1/0,m=0,n=k.length;m<n;m++)h=k[m],i=g.line(h,j).squaredLength(),i<l&&(l=i,e=h,f=m);var o=k[f-1],p=k[f+1],q=0;o&&p?q=g.line(o,p).pointOffset(j):o?q=g.line(o,e).pointOffset(j):p&&(q=g.line(e,p).pointOffset(j)),this.model.label(this._labelIdx,{position:{distance:e.distance/this._linkLength,offset:q}});break;case"arrowhead-move":if(this.paper.options.snapLinks){var r=this.paper.options.snapLinks.radius||50,s=this.paper.findViewsInArea({x:b-r,y:c-r,width:2*r,height:2*r});this._closestView&&this._closestView.unhighlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),this._closestView=this._closestEnd=null;var t,u=Number.MAX_VALUE,v=g.point(b,c);_.each(s,function(a){"false"!==a.el.getAttribute("magnet")&&(t=a.model.getBBox().center().distance(v),t<r&&t<u&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,null))&&(u=t,this._closestView=a,this._closestEnd={id:a.model.id})),a.$("[magnet]").each(_.bind(function(b,c){var d=V(c).bbox(!1,this.paper.viewport);t=v.distance({x:d.x+d.width/2,y:d.y+d.height/2}),t<r&&t<u&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,c))&&(u=t,this._closestView=a,this._closestEnd={id:a.model.id,selector:a.getSelector(c),port:c.getAttribute("port")})},this))},this),this._closestView&&this._closestView.highlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),this.model.set(this._arrowhead,this._closestEnd||{x:b,y:c},{ui:!0})}else{var w="mousemove"===a.type?a.target:document.elementFromPoint(a.clientX,a.clientY);this._targetEvent!==w&&(this._magnetUnderPointer&&this._viewUnderPointer.unhighlight(this._magnetUnderPointer,{connecting:!0}),this._viewUnderPointer=this.paper.findView(w),this._viewUnderPointer?(this._magnetUnderPointer=this._viewUnderPointer.findMagnet(w),this._magnetUnderPointer&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(this._viewUnderPointer,this._magnetUnderPointer))?this._magnetUnderPointer&&this._viewUnderPointer.highlight(this._magnetUnderPointer,{connecting:!0}):this._magnetUnderPointer=null):this._magnetUnderPointer=null),this._targetEvent=w,this.model.set(this._arrowhead,{x:b,y:c},{ui:!0})}}this._dx=b,this._dy=c,joint.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("link:pointermove",a,b,c)},pointerup:function(a,b,c){if("label-move"===this._action)this._samples=null;else if("arrowhead-move"===this._action){var d,e=this.paper,f=e.options,g=this._arrowhead,h=this._initialEnd;if(f.snapLinks)this._closestView&&(this._closestView.unhighlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),d=this._closestView.findMagnet(this._closestEnd.selector)),this._closestView=this._closestEnd=null;else{var i=this._viewUnderPointer;if(d=this._magnetUnderPointer,this._viewUnderPointer=null,this._magnetUnderPointer=null,d){i.unhighlight(d,{connecting:!0});var j=i.getSelector(d),k=d.getAttribute("port"),l={id:i.model.id};null!=j&&(l.port=k),null!=k&&(l.selector=j),this.model.set(g,l,{ui:!0})}}if(!e.linkAllowed(this))switch(this._whenNotAllowed){case"remove":this.model.remove();break;case"revert":default:this.model.set(g,h,{ui:!0})}f.embeddingMode&&this.model.reparent()&&(this._z=null);var m=this.model.prop(g)||{},n=!joint.dia.Link.endsEqual(h,m);n&&(h.id&&this.notify("link:disconnect",a,e.findViewByModel(h.id),this._initialMagnet,g),m.id&&this.notify("link:connect",a,e.findViewByModel(m.id),d,g)),this._afterArrowheadMove()}this._action=null,this._whenNotAllowed=null,this._initialMagnet=null,this._initialEnd=null,this._validateConnectionArgs=null,this.notify("link:pointerup",a,b,c),joint.dia.CellView.prototype.pointerup.apply(this,arguments)}},{makeSelector:function(a){var b='[model-id="'+a.id+'"]';return a.port?b+=' [port="'+a.port+'"]':a.selector&&(b+=" "+a.selector),b}}),joint.dia.Paper=joint.mvc.View.extend({className:"paper",options:{width:800,height:600,origin:{x:0,y:0},gridSize:1,drawGrid:!1,perpendicularLinks:!1,elementView:joint.dia.ElementView,linkView:joint.dia.LinkView,snapLinks:!1,multiLinks:!0,guard:function(a,b){return!1},highlighting:{default:{name:"stroke",options:{padding:3}},magnetAvailability:{name:"addClass",options:{className:"available-magnet"}},elementAvailability:{name:"addClass",options:{className:"available-cell"}}},preventContextMenu:!0,restrictTranslate:!1,markAvailable:!1,defaultLink:new joint.dia.Link,defaultConnector:{name:"normal"},defaultRouter:{name:"normal"},validateMagnet:function(a,b){return"passive"!==b.getAttribute("magnet")},validateConnection:function(a,b,c,d,e,f){return("target"===e?c:a)instanceof joint.dia.ElementView},embeddingMode:!1,validateEmbedding:function(a,b){return!0},findParentBy:"bbox",frontParentOnly:!0,interactive:{labelMove:!1},linkPinning:!0,clickThreshold:0,cellViewNamespace:joint.shapes,highlighterNamespace:joint.highlighters},events:{mousedown:"pointerdown",dblclick:"mousedblclick",click:"mouseclick",touchstart:"pointerdown",touchend:"mouseclick",touchmove:"pointermove",mousemove:"pointermove","mouseover .joint-cell":"cellMouseover","mouseout .joint-cell":"cellMouseout",contextmenu:"contextmenu",mousewheel:"mousewheel",DOMMouseScroll:"mousewheel"},_highlights:[],init:function(){_.bindAll(this,"pointerup"),this.model=this.options.model||new joint.dia.Graph,this.options.origin=_.clone(this.options.origin),this.options.defaultConnector=_.clone(this.options.defaultConnector),_.defaults(this.options.highlighting,this.constructor.prototype.options.highlighting),this.options.highlighting=_.cloneDeep(this.options.highlighting),this.svg=V("svg").node,this.viewport=V("g").addClass(joint.util.addClassNamePrefix("viewport")).node,this.defs=V("defs").node,V(this.svg).append([this.viewport,this.defs]),this.$el.append(this.svg),this.listenTo(this.model,"add",this.onCellAdded),this.listenTo(this.model,"remove",this.removeView),this.listenTo(this.model,"reset",this.resetViews),this.listenTo(this.model,"sort",this._onSort),this.listenTo(this.model,"batch:stop",this._onBatchStop),this.setOrigin(),this.setDimensions(),$(document).on("mouseup touchend",this.pointerup),this._mousemoved=0,this._views={},this.on("cell:highlight",this.onCellHighlight,this),this.on("cell:unhighlight",this.onCellUnhighlight,this)},_onSort:function(){this.model.hasActiveBatch("add")||this.sortViews()},_onBatchStop:function(a){var b=a&&a.batchName;"add"!==b||this.model.hasActiveBatch("add")||this.sortViews()},onRemove:function(){this.removeViews(),$(document).off("mouseup touchend",this.pointerup)},setDimensions:function(a,b){a=this.options.width=a||this.options.width,b=this.options.height=b||this.options.height,V(this.svg).attr({width:a,height:b}),this.trigger("resize",a,b)},setOrigin:function(a,b){this.options.origin.x=a||0,this.options.origin.y=b||0,V(this.viewport).translate(a,b,{absolute:!0}),this.trigger("translate",a,b),this.options.drawGrid&&this.drawGrid()},fitToContent:function(a,b,c,d){_.isObject(a)?(d=a,a=d.gridWidth||1,b=d.gridHeight||1,c=d.padding||0):(d=d||{},a=a||1,b=b||1,c=c||0),c=joint.util.normalizeSides(c);var e=V(this.viewport).bbox(!0,this.svg),f=V(this.viewport).scale();e.x*=f.sx,e.y*=f.sy,e.width*=f.sx,e.height*=f.sy;var g=Math.max(Math.ceil((e.width+e.x)/a),1)*a,h=Math.max(Math.ceil((e.height+e.y)/b),1)*b,i=0,j=0;("negative"==d.allowNewOrigin&&e.x<0||"positive"==d.allowNewOrigin&&e.x>=0||"any"==d.allowNewOrigin)&&(i=Math.ceil(-e.x/a)*a,i+=c.left,g+=i),("negative"==d.allowNewOrigin&&e.y<0||"positive"==d.allowNewOrigin&&e.y>=0||"any"==d.allowNewOrigin)&&(j=Math.ceil(-e.y/b)*b,j+=c.top,h+=j),g+=c.right,h+=c.bottom,g=Math.max(g,d.minWidth||0),h=Math.max(h,d.minHeight||0),g=Math.min(g,d.maxWidth||Number.MAX_VALUE),h=Math.min(h,d.maxHeight||Number.MAX_VALUE);var k=g!=this.options.width||h!=this.options.height,l=i!=this.options.origin.x||j!=this.options.origin.y;l&&this.setOrigin(i,j),k&&this.setDimensions(g,h)},scaleContentToFit:function(a){var b=this.getContentBBox();if(b.width&&b.height){a=a||{},_.defaults(a,{padding:0,preserveAspectRatio:!0,scaleGrid:null,minScale:0,maxScale:Number.MAX_VALUE});var c=a.padding,d=a.minScaleX||a.minScale,e=a.maxScaleX||a.maxScale,f=a.minScaleY||a.minScale,h=a.maxScaleY||a.maxScale,i=a.fittingBBox||{x:this.options.origin.x,y:this.options.origin.y,width:this.options.width,height:this.options.height};i=g.rect(i).moveAndExpand({x:c,y:c,width:-2*c,height:-2*c});var j=V(this.viewport).scale(),k=i.width/b.width*j.sx,l=i.height/b.height*j.sy;if(a.preserveAspectRatio&&(k=l=Math.min(k,l)),a.scaleGrid){var m=a.scaleGrid;k=m*Math.floor(k/m),l=m*Math.floor(l/m)}k=Math.min(e,Math.max(d,k)),l=Math.min(h,Math.max(f,l)),this.scale(k,l);var n=this.getContentBBox(),o=i.x-n.x,p=i.y-n.y;this.setOrigin(o,p)}},getContentBBox:function(){var a=this.viewport.getBoundingClientRect(),b=this.viewport.getScreenCTM(),c=this.viewport.getCTM();return g.rect({x:a.left-b.e+c.e,y:a.top-b.f+c.f,width:a.width,height:a.height})},getArea:function(){var a=this.viewport.getCTM().inverse(),b={x:0,y:0,width:this.options.width,height:this.options.height};return g.rect(V.transformRect(b,a))},getRestrictedArea:function(){var a;return a=_.isFunction(this.options.restrictTranslate)?this.options.restrictTranslate.apply(this,arguments):this.options.restrictTranslate===!0?this.getArea():this.options.restrictTranslate||null},createViewForModel:function(a){var b,c,d=this.options.cellViewNamespace,e=a.get("type")+"View",f=joint.util.getByPath(d,e,".");a.isLink()?(b=this.options.linkView,c=joint.dia.LinkView):(b=this.options.elementView,c=joint.dia.ElementView);var g=b.prototype instanceof Backbone.View?f||b:b.call(this,a)||f||c;return new g({model:a,interactive:this.options.interactive})},onCellAdded:function(a,b,c){if(this.options.async&&c.async!==!1&&_.isNumber(c.position)){if(this._asyncCells=this._asyncCells||[],this._asyncCells.push(a),0==c.position){if(this._frameId)throw new Error("another asynchronous rendering in progress");this.asyncRenderViews(this._asyncCells,c),delete this._asyncCells}}else this.renderView(a)},removeView:function(a){var b=this._views[a.id];return b&&(b.remove(),delete this._views[a.id]),b},renderView:function(a){var b=this._views[a.id]=this.createViewForModel(a);return V(this.viewport).append(b.el),b.paper=this,b.render(),$(b.el).find("image").on("dragstart",function(){return!1}),b},beforeRenderViews:function(a){return a.sort(function(a){return a instanceof joint.dia.Link?1:-1}),a},afterRenderViews:function(){this.sortViews()},resetViews:function(a,b){this.removeViews();var c=a.models.slice();c=this.beforeRenderViews(c,b)||c,this._frameId&&(joint.util.cancelFrame(this._frameId),delete this._frameId),this.options.async?this.asyncRenderViews(c,b):(_.each(c,this.renderView,this),this.sortViews())},removeViews:function(){_.invoke(this._views,"remove"),this._views={}},asyncBatchAdded:_.noop,asyncRenderViews:function(a,b){if(this._frameId){var c=this.options.async&&this.options.async.batchSize||50,d=a.splice(0,c),e=this.model.get("cells");_.each(d,function(a){a.collection===e&&this.renderView(a)},this),this.asyncBatchAdded()}a.length?this._frameId=joint.util.nextFrame(function(){this.asyncRenderViews(a,b)},this):(delete this._frameId,this.afterRenderViews(b),this.trigger("render:done",b))},sortViews:function(){var a=$(this.viewport).children("[model-id]"),b=this.model.get("cells");joint.util.sortElements(a,function(a,c){var d=b.get($(a).attr("model-id")),e=b.get($(c).attr("model-id"));return(d.get("z")||0)>(e.get("z")||0)?1:-1})},scale:function(a,b,c,d){b=b||a,_.isUndefined(c)&&(c=0,d=0),V(this.viewport).attr("transform","");var e=this.options.origin.x,f=this.options.origin.y;if(c||d||e||f){var g=e-c*(a-1),h=f-d*(b-1);this.setOrigin(g,h)}return V(this.viewport).scale(a,b),this.trigger("scale",a,b,c,d),this.options.drawGrid&&this.drawGrid(),this},rotate:function(a,b,c){if(_.isUndefined(b)){var d=this.viewport.getBBox();b=d.width/2,c=d.height/2}V(this.viewport).rotate(a,b,c)},findView:function(a){for(var b=_.isString(a)?this.viewport.querySelector(a):a instanceof $?a[0]:a;b&&b!==this.el&&b!==document;){var c=b.getAttribute("model-id");if(c)return this._views[c];b=b.parentNode}},findViewByModel:function(a){var b=_.isString(a)?a:a.id;return this._views[b]},findViewsFromPoint:function(a){a=g.point(a);var b=_.map(this.model.getElements(),this.findViewByModel,this);return _.filter(b,function(b){return b&&g.rect(b.vel.bbox(!1,this.viewport)).containsPoint(a)},this)},findViewsInArea:function(a,b){b=_.defaults(b||{},{strict:!1}),a=g.rect(a);var c=_.map(this.model.getElements(),this.findViewByModel,this),d=b.strict?"containsRect":"intersect";return _.filter(c,function(b){return b&&a[d](g.rect(b.vel.bbox(!1,this.viewport)))},this)},getModelById:function(a){return this.model.getCell(a)},snapToGrid:function(a){var b=V(this.viewport).toLocalPoint(a.x,a.y);return{x:g.snapToGrid(b.x,this.options.gridSize),y:g.snapToGrid(b.y,this.options.gridSize)}},clientToLocalPoint:function(a){a=g.point(a);var b=V("rect",{width:this.options.width,height:this.options.height,x:0,y:0,opacity:0});V(this.svg).prepend(b);var c=$(this.svg).offset();b.remove();var d=document.body.scrollTop||document.documentElement.scrollTop,e=document.body.scrollLeft||document.documentElement.scrollLeft;return a.offset(e-c.left,d-c.top),V.transformPoint(a,this.viewport.getCTM().inverse())},linkAllowed:function(a){var b;if(a instanceof joint.dia.Link)b=a;else{if(!(a instanceof joint.dia.LinkView))throw new Error("Must provide link model or view.");b=a.model}if(!this.options.multiLinks){var c=b.get("source"),d=b.get("target");if(c.id&&d.id){var e=b.getSourceElement();if(e){var f=this.model.getConnectedLinks(e,{outbound:!0,inbound:!1}),g=_.filter(f,function(a){var b=a.get("source"),e=a.get("target");return b&&b.id===c.id&&(!b.port||b.port===c.port)&&e&&e.id===d.id&&(!e.port||e.port===d.port)}).length;if(g>1)return!1}}}return!!(this.options.linkPinning||_.has(b.get("source"),"id")&&_.has(b.get("target"),"id"))},getDefaultLink:function(a,b){return _.isFunction(this.options.defaultLink)?this.options.defaultLink.call(this,a,b):this.options.defaultLink.clone()},resolveHighlighter:function(a){a=a||{};var b=a.highlighter,c=this.options;if(_.isUndefined(b)){var d=_.chain(a).pick("embedding","connecting","magnetAvailability","elementAvailability").keys().first().value();b=d&&c.highlighting[d]||c.highlighting.default}if(!b)return!1;_.isString(b)&&(b={name:b});var e=b.name,f=c.highlighterNamespace[e];if(!f)throw new Error('Unknown highlighter ("'+e+'")');if("function"!=typeof f.highlight)throw new Error('Highlighter ("'+e+'") is missing required highlight() method');if("function"!=typeof f.unhighlight)throw new Error('Highlighter ("'+e+'") is missing required unhighlight() method');return{highlighter:f,options:b.options||{},name:e}},onCellHighlight:function(a,b,c){if(c=this.resolveHighlighter(c)){var d=c.name+b.id+JSON.stringify(c.options);if(!this._highlights[d]){var e=c.highlighter;e.highlight(a,b,_.clone(c.options)),this._highlights[d]={cellView:a,magnetEl:b,opt:c.options,highlighter:e}}}},onCellUnhighlight:function(a,b,c){if(c=this.resolveHighlighter(c)){var d=c.name+b.id+JSON.stringify(c.options),e=this._highlights[d];e&&(e.highlighter.unhighlight(e.cellView,e.magnetEl,e.opt),this._highlights[d]=null)}},mousedblclick:function(a){a.preventDefault(),a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerdblclick(a,c.x,c.y):this.trigger("blank:pointerdblclick",a,c.x,c.y)}},mouseclick:function(a){if(this._mousemoved<=this.options.clickThreshold){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(this.guard(a,b))return;var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerclick(a,c.x,c.y):this.trigger("blank:pointerclick",a,c.x,c.y)}},guard:function(a,b){return!(!this.options.guard||!this.options.guard(a,b))||(a.data&&!_.isUndefined(a.data.guarded)?a.data.guarded:!(b&&b.model&&b.model instanceof joint.dia.Cell)&&(this.svg!==a.target&&this.el!==a.target&&!$.contains(this.svg,a.target)))},contextmenu:function(a){a=joint.util.normalizeEvent(a),this.options.preventContextMenu&&a.preventDefault();var b=this.findView(a.target);if(!this.guard(a,b)){var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.contextmenu(a,c.x,c.y):this.trigger("blank:contextmenu",a,c.x,c.y)}},pointerdown:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){a.preventDefault(),this._mousemoved=0;var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?(this.sourceView=b,b.pointerdown(a,c.x,c.y)):this.trigger("blank:pointerdown",a,c.x,c.y)}},pointermove:function(a){if(this.sourceView){a.preventDefault(),a=joint.util.normalizeEvent(a),this._mousemoved++;var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView.pointermove(a,b.x,b.y)}},pointerup:function(a){a=joint.util.normalizeEvent(a);var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView?(this.sourceView.pointerup(a,b.x,b.y),this.sourceView=null):this.trigger("blank:pointerup",a,b.x,b.y)},mousewheel:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){var c=a.originalEvent,d=this.snapToGrid({x:c.clientX,y:c.clientY}),e=Math.max(-1,Math.min(1,c.wheelDelta||-c.detail));b?b.mousewheel(a,d.x,d.y,e):this.trigger("blank:mousewheel",a,d.x,d.y,e)}},cellMouseover:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(b){if(this.guard(a,b))return;b.mouseover(a)}},cellMouseout:function(a){a=joint.util.normalizeEvent(a);var b=this.findView(a.target);if(b){if(this.guard(a,b))return;b.mouseout(a)}},setGridSize:function(a){return this.options.gridSize=a,this.options.drawGrid&&this.drawGrid(),this},clearGrid:function(){return this.el.style.backgroundImage="none",this},drawGrid:function(a){a=_.defaults(a||{},this.options.drawGrid,{color:"#aaa",thickness:1});var b=this.options.gridSize;if(b<=1)return this.clearGrid();var c=V(this.viewport).scale(),d=c.sx,e=c.sy,f=this.options.origin.x,g=this.options.origin.y,h=b*d,i=b*e,j=document.createElement("canvas");j.width=h,j.height=i,h=f>=0?f%h:h+f%h,i=g>=0?g%i:i+g%i;var k=j.getContext("2d");k.beginPath(),k.rect(h,i,a.thickness*d,a.thickness*e),k.fillStyle=a.color,k.fill();var l=j.toDataURL("image/png");return this.el.style.backgroundImage='url("'+l+'")',this},setInteractivity:function(a){this.options.interactive=a,_.invoke(this._views,"setInteractivity",a)}}),function(a,b){var c=function(a){var c=b.cloneDeep(a);this.ports=[],this.groups=this._getNormalizedGroups(c),this._init(c)};c.prototype={getPorts:function(){return this.ports},getPort:function(a){return b.find(this.ports,function(b){return b.id===a})},getGroup:function(a){return this.groups[a]||this._createGroupNode()},addPort:function(a){a=this._evaluatePort(a),this.ports.push(a)},_init:function(a){a=a||{};var c=a.items||[];b.each(c,function(a){this.addPort(a)},this)},_evaluatePort:function(a){var c=b.clone(a),d=b.extend(this._createGroupNode(),a.group?this.groups[a.group]:null);return c.markup=c.markup||d.markup,c.attrs=b.merge({},d.attrs,c.attrs),c.position=b.merge(this._createPositionNode(),d.position,{args:c.args}),c.label=b.merge({},d.label,this._getLabel(c)),c.z=this._getZIndex(c.z,d.z),c},_getZIndex:function(a,c){return b.isNumber(a)?a:b.isNumber(c)||"auto"===c?c:"auto"},_createPositionNode:function(){return{name:"left",args:{}}},_createGroupNode:function(){return{position:{},label:{position:{name:"left",args:{}}}}},_getNormalizedGroups:function(a){return a=a||{},a.groups=a.groups||{},b.each(a.groups,function(a){a.position=this._getPosition(a.position,!0),a.label=this._getLabel(a,!0)},this),a.groups},_getPosition:function(a,c){var d,e={};b.isFunction(a)?(d="fn",e.fn=a):b.isString(a)?d=a:b.isUndefined(a)?d=c?"left":null:b.isArray(a)?(d="absolute",e.x=a[0],e.y=a[1]):b.isObject(a)&&(d=a.name,b.extend(e,a.args));var f={args:e};return d&&(f.name=d),f},_getLabel:function(a,b){var c=a.label||{},d=c;return d.position=this._getPosition(c.position,b),d}},b.extend(a.dia.Element.prototype,{_initializePorts:function(){this._createPortData(),this.on("change:ports",function(){this._processRemovedPort(),this._createPortData()},this)},_processRemovedPort:function(){var a=this.get("ports")||{},c={};b.each(a.items,function(a){c[a.id]=!0});var d=this.previous("ports")||{},e={};b.each(d.items,function(a){c[a.id]||(e[a.id]=!0)});var f=this.graph;if(f&&!b.isEmpty(e)){var g=f.getConnectedLinks(this,{inbound:!0});b.each(g,function(a){e[a.get("target").port]&&a.remove()});var h=f.getConnectedLinks(this,{outbound:!0});b.each(h,function(a){e[a.get("source").port]&&a.remove()})}},hasPorts:function(){return this.prop("ports/items").length>0},hasPort:function(a){return this.getPortIndex(a)!==-1},getPorts:function(){return b.cloneDeep(this.prop("ports/items"))||[]},getPort:function(a){return b.cloneDeep(b.find(this.prop("ports/items"),function(b){return b.id&&b.id===a}))},getPortIndex:function(a){var c=b.isObject(a)?a.id:a;return this._isValidPortId(c)?b.findIndex(this.prop("ports/items"),{id:c}):-1},addPort:function(a,c){if(!b.isObject(a)||b.isArray(a))throw new Error("Element: addPort requires an object.");var d=b.clone(this.prop("ports/items"))||[];return d.push(a),this.prop("ports/items",d,c),this},portProp:function(a,c,d,e){var f=this.getPortIndex(a);if(f===-1)throw new Error("Element: unable to find port with id "+a);var g;return b.isString(c)?(g=Array.prototype.slice.call(arguments,1),g[0]=["ports/items/",f,"/",c].join("")):g=["ports/items/"+f,c,d],this.prop.apply(this,g)},_validatePorts:function(){var c=this.get("ports")||{},d=[];c=c||{};var e=c.items||[];return b.each(e,function(b){this._isValidPortId(b.id)||(b.id=a.util.uuid())},this),b.uniq(e,"id").length!==e.length&&d.push("Element: found id duplicities in ports."),d},_isValidPortId:function(a){return!b.isNull(a)&&!b.isUndefined(a)&&!b.isObject(a)},addPorts:function(a,c){return a.length&&this.prop("ports/items",(b.clone(this.prop("ports/items"))||[]).concat(a),c),this},removePort:function(a,c){var d=c||{},e=b.clone(this.prop("ports/items")),f=this.getPortIndex(a);return f!==-1&&(e.splice(f,1),d.rewrite=!0,this.prop("ports/items",e,d)),this},_createPortData:function(){var a=this._validatePorts();if(a.length>0)throw this.set("ports",this.previous("ports")),new Error(a.join(" "));this.portData=new c(this.get("ports"))}}),b.extend(a.dia.ElementView.prototype,{portContainerMarkup:'<g class="joint-port"/>',portMarkup:'<circle class="joint-port-body" r="10" fill="#FFFFFF" stroke="#000000"/>',portLabelMarkup:'<text class="joint-port-label" fill="#000000"/>',_portElementsCache:null,_initializePorts:function(){this._portElementsCache={},this.listenTo(this.model,"change:ports",function(){this._refreshPorts()})},_refreshPorts:function(){this._removePorts(),this._portElementsCache={},this._renderPorts()},_renderPorts:function(){var a=[],c=this._getContainerElement();b.each(c.node.childNodes,function(b){a.push(b)});var d=b.groupBy(this.model.portData.getPorts(),"z"),e="auto";b.each(d[e],function(b){var d=this._getPortElement(b);c.append(d),a.push(d)},this),b.each(d,function(b,c){if(c!==e){var f=parseInt(c,10);this._appendPorts(d[c],f,a)}},this),this._updatePorts()},_getContainerElement:function(){return this.rotatableNode||this.vel},_appendPorts:function(a,c,d){var e=this._getContainerElement(),f=b.map(a,this._getPortElement,this);d[c]||c<0?V(d[Math.max(c,0)]).before(f):e.append(f)},_getPortElement:function(a){return this._portElementsCache[a.id]?this._portElementsCache[a.id].portElement:this._createPortElement(a)},_updatePorts:function(){var a=g.rect(this.model.get("size")),c=this.model.portData.getPorts();
b.each(b.groupBy(c,"group"),function(c,d){var e=this.model.portData.getGroup(d);b.each(c,this._updatePortAttrs,this),this._layoutPorts(c,e,a.clone())},this)},_removePorts:function(){b.invoke(this._portElementsCache,"portElement.remove")},_createPortElement:function(a){var b=V(this._getPortMarkup(a)),c=V(this._getPortLabelMarkup(a.label));if(b&&b.length>1)throw new Error("ElementView: Invalid port markup - multiple roots.");b.attr({port:a.id,"port-group":a.group});var d=V(this.portContainerMarkup).append(b).append(c);return this._portElementsCache[a.id]={portElement:d,portLabelElement:c},d},_updatePortAttrs:function(a){var b=a.attrs||{},c=this._portElementsCache[a.id];c&&this._updateAllAttrs(c.portElement.node,b)},_updateAllAttrs:function(a,c){b.each(c,function(b,c){var d="."===c?$(a):$(a).find(c);this.updateAttr(d,b)},this)},_layoutPorts:function(c,d,e){var f=d.position.name,h=a.layout.Port;h[f]||(f="left");var i=h[f](b.pluck(c,"position.args"),e,d.position.args||{});b.each(i,function(b,d){var f=this.model.portData.getPort(c[d].id),h=this._portElementsCache[f.id]||{};this.applyPortTransform(h.portElement,b);var i=a.layout.PortLabel,j=f.label.position.name;if(i[j]){var k=i[j](g.point(b),e,f.label.position.args);this.applyPortTransform(h.portLabelElement,k,-(b.angle||0))}},this)},applyPortTransform:function(a,b,c){var d=V.createSVGMatrix().rotate(c||0).translate(b.x||0,b.y||0).rotate(b.angle||0);a.transform(d,{absolute:!0}),this._updateAllAttrs(a.node,b.attrs||{})},_getPortMarkup:function(a){return a.markup||this.model.get("portMarkup")||this.model.portMarkup||this.portMarkup},_getPortLabelMarkup:function(a){return a.markup||this.model.get("portLabelMarkup")||this.model.portLabelMarkup||this.portLabelMarkup}})}(joint,_),joint.shapes.basic={},joint.shapes.basic.Generic=joint.dia.Element.extend({defaults:_.defaultsDeep({type:"basic.Generic",attrs:{".":{fill:"#ffffff",stroke:"none"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.basic.Rect=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><rect/></g><text/></g>',defaults:_.defaultsDeep({type:"basic.Rect",attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:100,height:60},text:{fill:"#000000",text:"","font-size":14,"ref-x":.5,"ref-y":.5,"text-anchor":"middle","y-alignment":"middle","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.TextView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"change:attrs",this.resize)}}),joint.shapes.basic.Text=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><text/></g></g>',defaults:_.defaultsDeep({type:"basic.Text",attrs:{text:{"font-size":18,fill:"#000000"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Circle=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle/></g><text/></g>',defaults:_.defaultsDeep({type:"basic.Circle",size:{width:60,height:60},attrs:{circle:{fill:"#ffffff",stroke:"#000000",r:30,cx:30,cy:30},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Ellipse=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><ellipse/></g><text/></g>',defaults:_.defaultsDeep({type:"basic.Ellipse",size:{width:60,height:40},attrs:{ellipse:{fill:"#ffffff",stroke:"#000000",rx:30,ry:20,cx:30,cy:20},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Polygon=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>',defaults:_.defaultsDeep({type:"basic.Polygon",size:{width:60,height:40},attrs:{polygon:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Polyline=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><polyline/></g><text/></g>',defaults:_.defaultsDeep({type:"basic.Polyline",size:{width:60,height:40},attrs:{polyline:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Image=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><image/></g><text/></g>',defaults:_.defaultsDeep({type:"basic.Image",attrs:{text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Path=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path/></g><text/></g>',defaults:_.defaultsDeep({type:"basic.Path",size:{width:60,height:60},attrs:{path:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle",ref:"path","ref-x":.5,"ref-dy":10,fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Rhombus=joint.shapes.basic.Path.extend({defaults:_.defaultsDeep({type:"basic.Rhombus",attrs:{path:{d:"M 30 0 L 60 30 30 60 0 30 z"},text:{"ref-y":.5,"y-alignment":"middle"}}},joint.shapes.basic.Path.prototype.defaults)}),joint.shapes.basic.PortsModelInterface={initialize:function(){this.updatePortsAttrs(),this.on("change:inPorts change:outPorts",this.updatePortsAttrs,this),this.constructor.__super__.constructor.__super__.initialize.apply(this,arguments)},updatePortsAttrs:function(a){if(this._portSelectors){var b=_.omit(this.get("attrs"),this._portSelectors);this.set("attrs",b,{silent:!0})}this._portSelectors=[];var c={};_.each(this.get("inPorts"),function(a,b,d){var e=this.getPortAttrs(a,b,d.length,".inPorts","in");this._portSelectors=this._portSelectors.concat(_.keys(e)),_.extend(c,e)},this),_.each(this.get("outPorts"),function(a,b,d){var e=this.getPortAttrs(a,b,d.length,".outPorts","out");this._portSelectors=this._portSelectors.concat(_.keys(e)),_.extend(c,e)},this),this.attr(c,{silent:!0}),this.processPorts(),this.trigger("process:ports")},getPortSelector:function(a){var b=".inPorts",c=this.get("inPorts").indexOf(a);if(c<0&&(b=".outPorts",c=this.get("outPorts").indexOf(a),c<0))throw new Error("getPortSelector(): Port doesn't exist.");return b+">g:nth-child("+(c+1)+")>.port-body"}},joint.shapes.basic.PortsViewInterface={initialize:function(){this.listenTo(this.model,"process:ports",this.update),joint.dia.ElementView.prototype.initialize.apply(this,arguments)},update:function(){this.renderPorts(),joint.dia.ElementView.prototype.update.apply(this,arguments)},renderPorts:function(){var a=this.$(".inPorts").empty(),b=this.$(".outPorts").empty(),c=joint.util.template(this.model.portMarkup);_.each(_.filter(this.model.ports,function(a){return"in"===a.type}),function(b,d){a.append(V(c({id:d,port:b})).node)}),_.each(_.filter(this.model.ports,function(a){return"out"===a.type}),function(a,d){b.append(V(c({id:d,port:a})).node)})}},joint.shapes.basic.TextBlock=joint.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable"><rect/></g>',joint.env.test("svgforeignobject")?'<foreignObject class="fobj"><body xmlns="http://www.w3.org/1999/xhtml"><div class="content"/></body></foreignObject>':'<text class="content"/>',"</g>"].join(""),defaults:_.defaultsDeep({type:"basic.TextBlock",attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:80,height:100},text:{fill:"#000000","font-size":14,"font-family":"Arial, helvetica, sans-serif"},".content":{text:"",ref:"rect","ref-x":.5,"ref-y":.5,"y-alignment":"middle","x-alignment":"middle"}},content:""},joint.shapes.basic.Generic.prototype.defaults),initialize:function(){this.listenTo(this,"change:size",this.updateSize),this.listenTo(this,"change:content",this.updateContent),this.updateSize(this,this.get("size")),this.updateContent(this,this.get("content")),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},updateSize:function(a,b){this.attr({".fobj":_.clone(b),div:{style:_.clone(b)}})},updateContent:function(a,b){joint.env.test("svgforeignobject")?this.attr({".content":{html:b}}):this.attr({".content":{text:b}})},setForeignObjectSize:function(){this.updateSize.apply(this,arguments)},setDivContent:function(){this.updateContent.apply(this,arguments)}}),joint.shapes.basic.TextBlockView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.noSVGForeignObjectElement=!joint.env.test("svgforeignobject"),joint.env.test("svgforeignobject")||this.listenTo(this.model,"change:content",function(a){this.updateContent(a)})},update:function(a,b){if(joint.env.test("svgforeignobject")){var c=this.model,d=_.omit(b||c.get("attrs"),".content");joint.dia.ElementView.prototype.update.call(this,c,d),b&&!_.has(b,".content")||this.updateContent(c,b)}else joint.dia.ElementView.prototype.update.call(this,c,b)},updateContent:function(a,b){var c=_.merge({},(b||a.get("attrs"))[".content"]);c=_.omit(c,"text");var d=joint.util.breakText(a.get("content"),a.get("size"),c,{svgDocument:this.paper.svg}),e=joint.util.setByPath({},".content",c,"/");e[".content"].text=d,joint.dia.ElementView.prototype.update.call(this,a,e)}}),joint.routers.manhattan=function(a,b,c){"use strict";function d(a){this.map={},this.options=a,this.mapGridSize=100}function e(){this.items=[],this.hash={},this.values={},this.OPEN=1,this.CLOSE=2}function f(b){return a.point(0===b.x?0:Math.abs(b.x)/b.x,0===b.y?0:Math.abs(b.y)/b.y)}function g(b,c,d,e){for(var g,h=[],i=f(e.difference(c)),j=c;g=b[j];){var k=f(j.difference(g));k.equals(i)||(h.unshift(j),i=k),j=g}var l=f(a.point(j).difference(d));return l.equals(i)||h.unshift(j),h}function h(a,c,d){var e=d.step,f=a.center(),g=b.chain(d.directionMap).pick(c).map(function(b){var c=b.x*a.width/2,d=b.y*a.height/2,g=f.clone().offset(c,d);return a.containsPoint(g)&&g.offset(b.x*e,b.y*e),g.snapToGrid(e)}).value();return g}function i(b,c,d){var e=360/d;return Math.floor(a.normalizeAngle(b.theta(c)+e/2)/e)*e}function j(a,b){var c=Math.abs(a-b);return c>180?360-c:c}function k(a,b){for(var c=1/0,d=0,e=b.length;d<e;d++){var f=a.manhattanDistance(b[d]);f<c&&(c=f)}return c}function l(c,d,f,l){var m,n,o,p,q=l.step;if(c instanceof a.rect?(m=h(c,l.startDirections,l),o=c.center().snapToGrid(q)):(o=c.clone().snapToGrid(q),m=[o]),d instanceof a.rect?(n=h(d,l.endDirections,l),p=d.center().snapToGrid(q)):(p=d.clone().snapToGrid(q),n=[p]),m=b.filter(m,f.isPointAccessible,f),n=b.filter(n,f.isPointAccessible,f),m.length>0&&n.length>0){var r=new e,s={},t={};b.each(m,function(a){var b=a.toString();r.add(b,k(a,n)),t[b]=0});for(var u,v,w=l.directions,x=w.length,y=l.maximumLoops,z=b.invoke(n,"toString");!r.isEmpty()&&y>0;){var A=r.pop(),B=a.point(A),C=t[A],D=E,E=s[A]?i(s[A],B,x):null!=l.previousDirAngle?l.previousDirAngle:i(o,B,x);if(z.indexOf(A)>=0&&(v=j(E,i(B,p,x)),B.equals(p)||v<180))return l.previousDirAngle=E,g(s,B,o,p);for(var F=0;F<x;F++)if(u=w[F],v=j(E,u.angle),!(D&&v>l.maxAllowedDirectionChange)){var G=B.clone().offset(u.offsetX,u.offsetY),H=G.toString();if(!r.isClose(H)&&f.isPointAccessible(G)){var I=C+u.cost+l.penalties[v];(!r.isOpen(H)||I<t[H])&&(s[H]=B,t[H]=I,r.add(H,I+k(G,n)))}}y--}}return l.fallbackRoute(o,p,l)}function m(c){c.directions=b.result(c,"directions"),c.penalties=b.result(c,"penalties"),c.paddingBox=b.result(c,"paddingBox"),b.each(c.directions,function(b){var c=a.point(0,0),d=a.point(b.offsetX,b.offsetY);b.angle=a.normalizeAngle(c.theta(d))})}function n(e,f){m(f),this.options.perpendicular=!!f.perpendicular;for(var g=a.rect(this.sourceBBox).moveAndExpand(f.paddingBox),h=a.rect(this.targetBBox).moveAndExpand(f.paddingBox),i=new d(f).build(this.paper.model,this.model),j=b.map(e,a.point),k=[],n=g.center().snapToGrid(f.step),o=0,p=j.length;o<=p;o++){var q=null,r=s||g,s=j[o];if(!s){s=h;var t=!this.model.get("source").id||!this.model.get("target").id;if(t&&b.isFunction(f.draggingRoute)){var u=r instanceof a.rect?r.center():r;q=f.draggingRoute(u,s.origin(),f)}}if(q=q||l(r,s,i,f),null===q){if(!b.isFunction(c.routers.orthogonal))throw new Error("Manhattan requires the orthogonal router.");return c.routers.orthogonal(e,f,this)}var v=b.first(q);v&&v.equals(n)&&q.shift(),n=b.last(q)||n,Array.prototype.push.apply(k,q)}return k}var o={step:10,perpendicular:!0,excludeEnds:[],excludeTypes:["basic.Text"],maximumLoops:2e3,startDirections:["left","right","top","bottom"],endDirections:["left","right","top","bottom"],directionMap:{right:{x:1,y:0},bottom:{x:0,y:1},left:{x:-1,y:0},top:{x:0,y:-1}},maxAllowedDirectionChange:90,paddingBox:function(){var a=this.step;return{x:-a,y:-a,width:2*a,height:2*a}},directions:function(){var a=this.step;return[{offsetX:a,offsetY:0,cost:a},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:0,cost:a},{offsetX:0,offsetY:-a,cost:a}]},penalties:function(){return{0:0,45:this.step/2,90:this.step/2}},fallbackRoute:b.constant(null),draggingRoute:null};return d.prototype.build=function(a,c){var d=this.options,e=b.chain(d.excludeEnds).map(c.get,c).pluck("id").map(a.getCell,a).value(),f=[],g=a.getCell(c.get("source").id);g&&(f=b.union(f,b.map(g.getAncestors(),"id")));var h=a.getCell(c.get("target").id);h&&(f=b.union(f,b.map(h.getAncestors(),"id")));var i=this.mapGridSize;return b.chain(a.getElements()).difference(e).reject(function(a){return b.contains(d.excludeTypes,a.get("type"))||b.contains(f,a.id)}).invoke("getBBox").invoke("moveAndExpand",d.paddingBox).foldl(function(a,b){for(var c=b.origin().snapToGrid(i),d=b.corner().snapToGrid(i),e=c.x;e<=d.x;e+=i)for(var f=c.y;f<=d.y;f+=i){var g=e+"@"+f;a[g]=a[g]||[],a[g].push(b)}return a},this.map).value(),this},d.prototype.isPointAccessible=function(a){var c=a.clone().snapToGrid(this.mapGridSize).toString();return b.every(this.map[c],function(b){return!b.containsPoint(a)})},e.prototype.add=function(a,c){this.hash[a]?this.items.splice(this.items.indexOf(a),1):this.hash[a]=this.OPEN,this.values[a]=c;var d=b.sortedIndex(this.items,a,function(a){return this.values[a]},this);this.items.splice(d,0,a)},e.prototype.remove=function(a){this.hash[a]=this.CLOSE},e.prototype.isOpen=function(a){return this.hash[a]===this.OPEN},e.prototype.isClose=function(a){return this.hash[a]===this.CLOSE},e.prototype.isEmpty=function(){return 0===this.items.length},e.prototype.pop=function(){var a=this.items.shift();return this.remove(a),a},function(a,c,d){return n.call(d,a,b.extend({},o,c))}}(g,_,joint),joint.routers.metro=function(){if(!_.isFunction(joint.routers.manhattan))throw new Error("Metro requires the manhattan router.");var a={diagonalCost:null,directions:function(){var a=this.step,b=this.diagonalCost||Math.ceil(Math.sqrt(a*a<<1));return[{offsetX:a,offsetY:0,cost:a},{offsetX:a,offsetY:a,cost:b},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:a,cost:b},{offsetX:-a,offsetY:0,cost:a},{offsetX:-a,offsetY:-a,cost:b},{offsetX:0,offsetY:-a,cost:a},{offsetX:a,offsetY:-a,cost:b}]},maxAllowedDirectionChange:45,fallbackRoute:function(a,b,c){var d=a.theta(b),e={x:b.x,y:a.y},f={x:a.x,y:b.y};if(d%180>90){var h=e;e=f,f=h}var i=d%90<45?e:f,j=g.line(a,i),k=90*Math.ceil(d/90),l=g.point.fromPolar(j.squaredLength(),g.toRad(k+135),i),m=g.line(b,l),n=j.intersection(m);return n?[n.round(),b]:[b]}};return function(b,c,d){return joint.routers.manhattan(b,_.extend({},a,c),d)}}(),joint.routers.normal=function(a,b,c){return a},joint.routers.oneSide=function(a,b,c){var d,e,f,g=b.side||"bottom",h=b.padding||40,i=c.sourceBBox,j=c.targetBBox,k=i.center(),l=j.center();switch(g){case"bottom":f=1,d="y",e="height";break;case"top":f=-1,d="y",e="height";break;case"left":f=-1,d="x",e="width";break;case"right":f=1,d="x",e="width";break;default:throw new Error("Router: invalid side")}return k[d]+=f*(i[e]/2+h),l[d]+=f*(j[e]/2+h),f*(k[d]-l[d])>0?l[d]=k[d]:k[d]=l[d],[k].concat(a,l)},joint.routers.orthogonal=function(){function a(a,b){return a.x==b.x?a.y>b.y?"N":"S":a.y==b.y?a.x>b.x?"W":"E":null}function b(a,b){return a["W"==b||"E"==b?"width":"height"]}function c(a,b){return g.rect(a).moveAndExpand({x:-b,y:-b,width:2*b,height:2*b})}function d(a){return g.rect(a.x,a.y,0,0)}function e(a,b){var c=Math.min(a.x,b.x),d=Math.min(a.y,b.y),e=Math.max(a.x+a.width,b.x+b.width),f=Math.max(a.y+a.height,b.y+b.height);return g.rect(c,d,e-c,f-d)}function f(a,b,c){var d=g.point(a.x,b.y);return c.containsPoint(d)&&(d=g.point(b.x,a.y)),d}function h(b,c,d){var e=g.point(b.x,c.y),f=g.point(c.x,b.y),h=a(b,e),i=a(b,f),j=n[d],k=h==d||h!=j&&(i==j||i!=d)?e:f;return{points:[k],direction:a(k,c)}}function i(b,c,d){var e=f(b,c,d);return{points:[e],direction:a(e,c)}}function j(c,d,e,h){var i,j={},k=[g.point(c.x,d.y),g.point(d.x,c.y)],l=_.filter(k,function(a){return!e.containsPoint(a)}),m=_.filter(l,function(b){return a(b,c)!=h});if(m.length>0)i=_.filter(m,function(b){return a(c,b)==h}).pop(),i=i||m[0],j.points=[i],j.direction=a(i,d);else{i=_.difference(k,l)[0];var n=g.point(d).move(i,-b(e,h)/2),o=f(n,c,e);j.points=[o,n],j.direction=a(n,d)}return j}function k(c,d,e,f){var j=i(d,c,f),k=j.points[0];if(e.containsPoint(k)){j=i(c,d,e);var l=j.points[0];if(f.containsPoint(l)){var m=g.point(c).move(l,-b(e,a(c,l))/2),n=g.point(d).move(k,-b(f,a(d,k))/2),o=g.line(m,n).midpoint(),p=i(c,o,e),q=h(o,d,p.direction);j.points=[p.points[0],q.points[0]],j.direction=q.direction}}return j}function l(b,d,h,i,j){var k,l,m,n={},p=c(e(h,i),1),q=p.center().distance(d)>p.center().distance(b),r=q?d:b,s=q?b:d;return j?(k=g.point.fromPolar(p.width+p.height,o[j],r),k=p.pointNearestToPoint(k).move(k,-1)):k=p.pointNearestToPoint(r).move(r,1),l=f(k,s,p),k.round().equals(l.round())?(l=g.point.fromPolar(p.width+p.height,g.toRad(k.theta(r))+Math.PI/2,s),l=p.pointNearestToPoint(l).move(s,1).round(),m=f(k,l,p),n.points=q?[l,m,k]:[k,m,l]):n.points=q?[l,k]:[k,l],n.direction=q?a(k,d):a(l,d),n}function m(b,e,f){var m=e.elementPadding||20,n=[],o=c(f.sourceBBox,m),p=c(f.targetBBox,m);b=_.map(b,g.point),b.unshift(o.center()),b.push(p.center());for(var q,r=0,s=b.length-1;r<s;r++){var t=null,u=b[r],v=b[r+1],w=!!a(u,v);if(0==r)r+1==s?o.intersect(c(p,1))?t=l(u,v,o,p):w||(t=k(u,v,o,p)):o.containsPoint(v)?t=l(u,v,o,c(d(v),m)):w||(t=i(u,v,o));else if(r+1==s){var x=w&&a(v,u)==q;p.containsPoint(u)||x?t=l(u,v,c(d(u),m),p,q):w||(t=j(u,v,p,q))}else w||(t=h(u,v,q));t?(Array.prototype.push.apply(n,t.points),q=t.direction):q=a(u,v),r+1<s&&n.push(v)}return n}var n={N:"S",S:"N",E:"W",W:"E"},o={N:-Math.PI/2*3,S:-Math.PI/2,E:0,W:Math.PI};return m}(),joint.connectors.normal=function(a,b,c){var d=["M",a.x,a.y];return _.each(c,function(a){d.push(a.x,a.y)}),d.push(b.x,b.y),d.join(" ")},joint.connectors.rounded=function(a,b,c,d){d=d||{};var e,f,h,i,j,k,l=d.radius||10,m=["M",a.x,a.y];return _.each(c,function(d,n){j=c[n-1]||a,k=c[n+1]||b,h=i||g.point(d).distance(j)/2,i=g.point(d).distance(k)/2,e=g.point(d).move(j,-Math.min(l,h)).round(),f=g.point(d).move(k,-Math.min(l,i)).round(),m.push(e.x,e.y,"S",d.x,d.y,f.x,f.y,"L")}),m.push(b.x,b.y),m.join(" ")},joint.connectors.smooth=function(a,b,c){var d;if(c.length)d=g.bezier.curveThroughPoints([a].concat(c).concat([b]));else{var e=(a.x+b.x)/2;d=["M",a.x,a.y,"C",e,a.y,e,b.y,b.x,b.y]}return d.join(" ")},joint.connectors.jumpover=function(a,b){function c(a,c,d){var e=[].concat(a,d,c);return e.reduce(function(a,c,d){var f=e[d+1];return null!=f&&(a[d]=b.line(c,f)),a},[])}function d(a){var b=a.paper._jumpOverUpdateList;null==b&&(b=a.paper._jumpOverUpdateList=[],a.paper.on("cell:pointerup",e),a.paper.model.on("reset",function(){b=[]})),b.indexOf(a)<0&&(b.push(a),a.listenToOnce(a.model,"change:connector remove",function(){b.splice(b.indexOf(a),1)}))}function e(){for(var a=this._jumpOverUpdateList,b=0;b<a.length;b++)a[b].update()}function f(b,c){return a(c).map(function(a){return b.intersection(a)}).compact().value()}function g(a,c){return b.line(a,c).squaredLength()}function h(a,c,d){return c.reduce(function(e,f,g){if(f.skip===!0)return e;var h=e.pop()||a,i=b.point(f).move(h.start,-d),j=b.point(f).move(h.start,+d),k=c[g+1];if(null!=k){var m=j.distance(k);m<=d&&(j=k.move(h.start,m),k.skip=!0)}else{var n=i.distance(h.end);if(n<2*d+l)return e.push(h),e}var o=j.distance(h.start);if(o<2*d+l)return e.push(h),e;var p=b.line(i,j);return p.isJump=!0,e.push(b.line(h.start,i),p,b.line(j,h.end)),e},[])}function i(c,d,e){var f=["M",c[0].start.x,c[0].start.y],g=a(c).map(function(a){if(a.isJump){var c;if("arc"===e){c=a.start.difference(a.end);var f=Number(c.x<0&&c.y<0);return["A",d,d,0,0,f,a.end.x,a.end.y]}if("gap"===e)return["M",a.end.x,a.end.y];if("cubic"===e){c=a.start.difference(a.end);var g=a.start.theta(a.end),h=.6*d,i=1.35*d;c.x<0&&c.y<0&&(i*=-1);var j=b.point(a.start.x+h,a.start.y+i).rotate(a.start,g),k=b.point(a.end.x-h,a.end.y+i).rotate(a.end,g);return["C",j.x,j.y,k.x,k.y,a.end.x,a.end.y]}}return["L",a.end.x,a.end.y]}).flatten().value();return[].concat(f,g).join(" ")}var j=5,k=["arc","gap","cubic"],l=1,m=["smooth"];return function(b,e,l,n){d(this);var o=n.size||j,p=n.jump&&(""+n.jump).toLowerCase(),q=n.ignoreConnectors||m;k.indexOf(p)===-1&&(p=k[0]);var r=this.paper,s=r.model,t=s.getLinks();if(1===t.length)return i(c(b,e,l),o,p);var u=this.model,v=t.indexOf(u),w=r.options.defaultConnector||{},x=t.filter(function(b,c){var d=b.get("connector")||w;return!a.contains(q,d.name)&&(!(c>v)||"jumpover"!==d.name)}),y=x.map(function(a){return r.findViewByModel(a)}),z=c(b,e,l),A=y.map(function(a){return null==a?[]:a===this?z:c(a.sourcePoint,a.targetPoint,a.route)},this),B=z.reduce(function(b,c){var d=a(x).map(function(a,b){return a===u?null:f(c,A[b])}).flatten().compact().sortBy(a.partial(g,c.start)).value();return d.length>0?b.push.apply(b,h(c,d,o)):b.push(c),b},[]);return i(B,o,p)}}(_,g),function(a,b,c){function d(b,c,d){var e=b.toJSON();return e.angle=c||0,a.defaults({},d,e)}function e(c,e,f){return a.map(c,function(a,b,c){var e=this.pointAt((b+.5)/c.length);return(a.dx||a.dy)&&e.offset(a.dx||0,a.dy||0),d(e.round(),0,a)},b.line(e,f))}function f(c,e,f,g){var h=e.center(),i=e.width/e.height,j=e.topMiddle(),k=b.Ellipse.fromRect(e);return a.map(c,function(a,b,c){var e=f+g(b,c.length),l=j.clone().rotate(h,-e).scale(i,1,h),m=a.compensateRotation?-k.tangentTheta(l):0;return(a.dx||a.dy)&&l.offset(a.dx||0,a.dy||0),a.dr&&l.move(h,a.dr),d(l.round(),m,a)})}function g(c,d){var e=d.x;a.isString(e)&&(e=parseFloat(e)/100*c.width);var f=d.y;return a.isString(f)&&(f=parseFloat(f)/100*c.height),b.point(e||0,f||0)}c.layout.Port={absolute:function(b,c,d){return a.map(b,a.partial(g,c))},fn:function(a,b,c){return c.fn(a,b,c)},line:function(a,b,c){var d=g(b,c.start||b.origin()),f=g(b,c.end||b.corner());return e(a,d,f)},left:function(a,b,c){return e(a,b.origin(),b.bottomLeft())},right:function(a,b,c){return e(a,b.topRight(),b.corner())},top:function(a,b,c){return e(a,b.origin(),b.topRight())},bottom:function(a,b,c){return e(a,b.bottomLeft(),b.corner())},ellipseSpread:function(a,b,c){var d=c.startAngle||0,e=c.step||360/a.length;return f(a,b,d,function(a){return a*e})},ellipse:function(a,b,c){var d=c.startAngle||0,e=c.step||20;return f(a,b,d,function(a,b){return(a+.5-b/2)*e})}}}(_,g,joint),function(a,b,c){function d(b,c){return a.defaultsDeep({},b,c,{x:0,y:0,angle:0,attrs:{".":{y:"0","text-anchor":"start"}}})}function e(b,c,e,g){g=a.defaults({},g,{offset:15});var h,i,j,k,l=c.center().theta(b),m=f(c),n=g.offset,o=0;l<m[1]||l>m[2]?(j=".3em",h=n,i=0,k="start"):l<m[0]?(j="0",h=0,i=-n,e?(o=-90,k="start"):k="middle"):l<m[3]?(j=".3em",h=-n,i=0,k="end"):(j=".6em",h=0,i=n,e?(o=90,k="start"):k="middle");var p=Math.round;return d({x:p(h),y:p(i),angle:o,attrs:{".":{y:j,"text-anchor":k}}})}function f(a){var b=a.center(),c=b.theta(a.origin()),d=b.theta(a.bottomLeft()),e=b.theta(a.corner()),f=b.theta(a.topRight());return[c,f,e,d]}function g(b,c,e,g){var h=c.center().theta(b);g=a.defaults({},g,{offset:15});var i,j,k,l,m=g.offset,n=0,o=f(c);h<o[1]||h>o[2]?(k=".3em",i=-m,j=0,l="end"):h<o[0]?(k=".6em",i=0,j=m,e?(n=90,l="start"):l="middle"):h<o[3]?(k=".3em",i=m,j=0,l="start"):(k="0em",i=0,j=-m,e?(n=-90,l="start"):l="middle");var p=Math.round;return d({x:p(i),y:p(j),angle:n,attrs:{".":{y:k,"text-anchor":l}}})}function h(c,e,f){f=a.defaults({},f,{offset:20});var g,h=b.point(0,0),i=-c.theta(h),j=i,k=c.clone().move(h,f.offset).difference(c).round(),l=".3em";(i+90)%180===0?(g=e?"end":"middle",e||i!==-270||(l="0em")):i>-270&&i<-90?(g="start",j=i-180):g="end";var m=Math.round;return d({x:m(k.x),y:m(k.y),angle:e?j:0,attrs:{".":{y:l,"text-anchor":g}}})}c.layout.PortLabel={manual:a.rearg(d,2),left:function(a,b,c){return d(c,{x:-15,attrs:{".":{y:".3em","text-anchor":"end"}}})},right:function(a,b,c){return d(c,{x:15,attrs:{".":{y:".3em","text-anchor":"start"}}})},top:function(a,b,c){return d(c,{y:-15,attrs:{".":{"text-anchor":"middle"}}})},bottom:function(a,b,c){return d(c,{y:15,attrs:{".":{y:".6em","text-anchor":"middle"}}})},outsideOriented:function(a,b,c){return e(a,b,!0,c)},outside:function(a,b,c){return e(a,b,!1,c)},insideOriented:function(a,b,c){return g(a,b,!0,c)},inside:function(a,b,c){return g(a,b,!1,c)},radial:function(a,b,c){return h(a.difference(b.center()),!1,c)},radialOriented:function(a,b,c){return h(a.difference(b.center()),!0,c)}}}(_,g,joint),joint.highlighters.addClass={className:joint.util.addClassNamePrefix("highlighted"),highlight:function(a,b,c){var d=c||{},e=d.className||this.className;V(b).addClass(e)},unhighlight:function(a,b,c){var d=c||{},e=d.className||this.className;V(b).removeClass(e)}},joint.highlighters.opacity={highlight:function(a,b){V(b).addClass(joint.util.addClassNamePrefix("highlight-opacity"))},unhighlight:function(a,b){V(b).removeClass(joint.util.addClassNamePrefix("highlight-opacity"))}},joint.highlighters.stroke={defaultOptions:{padding:3,rx:0,ry:0,attrs:{"stroke-width":3,stroke:"#FEB663"}},_views:{},highlight:function(a,b,c){if(!this._views[b.id]){var d=_.defaults(c||{},this.defaultOptions),e=V(b),f=e.bbox(!0);try{var g=e.convertToPathData()}catch(a){g=V.rectToPath(_.extend({},d,f))}var h=V("path").attr({d:g,"pointer-events":"none","vector-effect":"non-scaling-stroke",fill:"none"}).attr(d.attrs);h.transform(a.el.getCTM().inverse()),h.transform(b.getCTM());var i=d.padding;if(i){var j=f.x+f.width/2,k=f.y+f.height/2,l=(f.width+i)/f.width,m=(f.height+i)/f.height;h.transform({a:l,b:0,c:0,d:m,e:j-l*j,f:k-m*k})}var n=this._views[b.id]=new joint.mvc.View({className:"highlight-stroke",el:h.node,$el:h});n.listenTo(a.model,"remove",n.remove),a.vel.append(h)}},unhighlight:function(a,b,c){this._views[b.id]&&(this._views[b.id].remove(),this._views[b.id]=null)}};

    joint.g = g;
    joint.V = joint.Vectorizer = V;

    return joint;

}));
