/*! JointJS v2.0.1 (2017-11-15) - JavaScript diagramming library


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/
(function(root, factory) {

    if (typeof define === 'function' && define.amd) {

        // AMD. Register as an anonymous module.
        define([], factory);

    } else if (typeof exports === 'object') {

        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like environments that support module.exports,
        // like Node.
        module.exports = factory();

    } else {

        // Browser globals.
        root.g = factory();
    }

}(this, function() {

var g=function(){var a={},b=Math,c=b.abs,d=b.cos,e=b.sin,f=b.sqrt,g=b.min,h=b.max,i=b.atan2,j=b.round,k=b.floor,l=b.PI,m=b.random,n=b.pow;a.bezier={curveThroughPoints:function(a){for(var b=this.getCurveControlPoints(a),c=["M",a[0].x,a[0].y],d=0;d<b[0].length;d++)c.push("C",b[0][d].x,b[0][d].y,b[1][d].x,b[1][d].y,a[d+1].x,a[d+1].y);return c},getCurveControlPoints:function(a){var b,c=[],d=[],e=a.length-1;if(1==e)return c[0]=q((2*a[0].x+a[1].x)/3,(2*a[0].y+a[1].y)/3),d[0]=q(2*c[0].x-a[0].x,2*c[0].y-a[0].y),[c,d];var f=[];for(b=1;b<e-1;b++)f[b]=4*a[b].x+2*a[b+1].x;f[0]=a[0].x+2*a[1].x,f[e-1]=(8*a[e-1].x+a[e].x)/2;var g=this.getFirstControlPoints(f);for(b=1;b<e-1;++b)f[b]=4*a[b].y+2*a[b+1].y;f[0]=a[0].y+2*a[1].y,f[e-1]=(8*a[e-1].y+a[e].y)/2;var h=this.getFirstControlPoints(f);for(b=0;b<e;b++)c.push(q(g[b],h[b])),b<e-1?d.push(q(2*a[b+1].x-g[b+1],2*a[b+1].y-h[b+1])):d.push(q((a[e].x+g[e-1])/2,(a[e].y+h[e-1])/2));return[c,d]},getCurveDivider:function(a,b,c,d){return function(e){var f=p(a,b).pointAt(e),g=p(b,c).pointAt(e),h=p(c,d).pointAt(e),i=p(f,g).pointAt(e),j=p(g,h).pointAt(e),k=p(i,j).pointAt(e);return[{p0:a,p1:f,p2:i,p3:k},{p0:k,p1:j,p2:h,p3:d}]}},getFirstControlPoints:function(a){var b=a.length,c=[],d=[],e=2;c[0]=a[0]/e;for(var f=1;f<b;f++)d[f]=1/e,e=(f<b-1?4:3.5)-d[f],c[f]=(a[f]-c[f-1])/e;for(f=1;f<b;f++)c[b-f-1]-=d[b-f]*c[b-f];return c},getInversionSolver:function(a,b,c,d){function e(a,b){var c=f[a],d=f[b];return function(e){var f=(a%3?3:1)*(b%3?3:1),g=e.x*(c.y-d.y)+e.y*(d.x-c.x)+c.x*d.y-c.y*d.x;return f*g}}var f=arguments;return function(c){var d=3*e(2,3)(b),f=e(1,3)(a)/d,g=-e(2,3)(a)/d,h=f*e(3,1)(c)+g*(e(3,0)(c)+e(2,1)(c))+e(2,0)(c),i=f*e(3,0)(c)+g*e(2,0)(c)+e(1,0)(c);return i/(i-h)}}};var o=a.Ellipse=function(a,b,c){return this instanceof o?a instanceof o?new o(q(a),a.a,a.b):(a=q(a),this.x=a.x,this.y=a.y,this.a=b,void(this.b=c)):new o(a,b,c)};a.Ellipse.fromRect=function(a){return a=r(a),o(a.center(),a.width/2,a.height/2)},a.Ellipse.prototype={bbox:function(){return r(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},clone:function(){return o(this)},normalizedDistance:function(a){var b=a.x,c=a.y,d=this.a,e=this.b,f=this.x,g=this.y;return(b-f)*(b-f)/(d*d)+(c-g)*(c-g)/(e*e)},inflate:function(a,b){return void 0===a&&(a=0),void 0===b&&(b=a),this.a+=2*a,this.b+=2*b,this},containsPoint:function(a){return this.normalizedDistance(a)<=1},center:function(){return q(this.x,this.y)},tangentTheta:function(b){var c,d,e=30,f=b.x,g=b.y,h=this.a,i=this.b,j=this.bbox().center(),k=j.x,l=j.y,m=f>j.x+h/2,n=f<j.x-h/2;return m||n?(c=f>j.x?g-e:g+e,d=h*h/(f-k)-h*h*(g-l)*(c-l)/(i*i*(f-k))+k):(d=g>j.y?f+e:f-e,c=i*i/(g-l)-i*i*(f-k)*(d-k)/(h*h*(g-l))+l),a.point(d,c).theta(b)},equals:function(a){return!!a&&a.x===this.x&&a.y===this.y&&a.a===this.a&&a.b===this.b},intersectionWithLineFromCenterToPoint:function(a,b){a=q(a),b&&a.rotate(q(this.x,this.y),b);var c,d=a.x-this.x,e=a.y-this.y;if(0===d)return c=this.bbox().pointNearestToPoint(a),b?c.rotate(q(this.x,this.y),-b):c;var g=e/d,h=g*g,i=this.a*this.a,j=this.b*this.b,k=f(1/(1/i+h/j));k=d<0?-k:k;var l=g*k;return c=q(this.x+k,this.y+l),b?c.rotate(q(this.x,this.y),-b):c},toString:function(){return q(this.x,this.y).toString()+" "+this.a+" "+this.b}};var p=a.Line=function(a,b){return this instanceof p?a instanceof p?p(a.start,a.end):(this.start=q(a),void(this.end=q(b))):new p(a,b)};a.Line.prototype={bearing:function(){var a=w(this.start.y),b=w(this.end.y),c=this.start.x,f=this.end.x,g=w(f-c),h=e(g)*d(b),j=d(a)*e(b)-e(a)*d(b)*d(g),k=v(i(h,j)),l=["NE","E","SE","S","SW","W","NW","N"],m=k-22.5;return m<0&&(m+=360),m=parseInt(m/45),l[m]},clone:function(){return p(this.start,this.end)},equals:function(a){return!!a&&this.start.x===a.start.x&&this.start.y===a.start.y&&this.end.x===a.end.x&&this.end.y===a.end.y},intersect:function(a){if(a instanceof p){var b=q(this.end.x-this.start.x,this.end.y-this.start.y),c=q(a.end.x-a.start.x,a.end.y-a.start.y),d=b.x*c.y-b.y*c.x,e=q(a.start.x-this.start.x,a.start.y-this.start.y),f=e.x*c.y-e.y*c.x,g=e.x*b.y-e.y*b.x;if(0===d||f*d<0||g*d<0)return null;if(d>0){if(f>d||g>d)return null}else if(f<d||g<d)return null;return q(this.start.x+f*b.x/d,this.start.y+f*b.y/d)}if(a instanceof r){var h,i,j=a,k=[j.topLine(),j.rightLine(),j.bottomLine(),j.leftLine()],l=[],m=[];for(i=0;i<k.length;i++)h=this.intersect(k[i]),null!==h&&m.indexOf(h.toString())<0&&(l.push(h),m.push(h.toString()));return l.length>0?l:null}return null},length:function(){return f(this.squaredLength())},midpoint:function(){return q((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},pointAt:function(a){var b=(1-a)*this.start.x+a*this.end.x,c=(1-a)*this.start.y+a*this.end.y;return q(b,c)},pointOffset:function(a){return((this.end.x-this.start.x)*(a.y-this.start.y)-(this.end.y-this.start.y)*(a.x-this.start.x))/2},vector:function(){return q(this.end.x-this.start.x,this.end.y-this.start.y)},closestPoint:function(a){return this.pointAt(this.closestPointNormalizedLength(a))},closestPointNormalizedLength:function(a){var b=this.vector().dot(p(this.start,a).vector());return Math.min(1,Math.max(0,b/this.squaredLength()))},squaredLength:function(){var a=this.start.x,b=this.start.y,c=this.end.x,d=this.end.y;return(a-=c)*a+(b-=d)*b},toString:function(){return this.start.toString()+" "+this.end.toString()}},a.Line.prototype.intersection=a.Line.prototype.intersect;var q=a.Point=function(a,b){if(!(this instanceof q))return new q(a,b);if("string"==typeof a){var c=a.split(a.indexOf("@")===-1?" ":"@");a=parseInt(c[0],10),b=parseInt(c[1],10)}else Object(a)===a&&(b=a.y,a=a.x);this.x=void 0===a?0:a,this.y=void 0===b?0:b};a.Point.fromPolar=function(a,b,f){f=f&&q(f)||q(0,0);var g=c(a*d(b)),h=c(a*e(b)),i=t(v(b));return i<90?h=-h:i<180?(g=-g,h=-h):i<270&&(g=-g),q(f.x+g,f.y+h)},a.Point.random=function(a,b,c,d){return q(k(m()*(b-a+1)+a),k(m()*(d-c+1)+c))},a.Point.prototype={adhereToRect:function(a){return a.containsPoint(this)?this:(this.x=g(h(this.x,a.x),a.x+a.width),this.y=g(h(this.y,a.y),a.y+a.height),this)},bearing:function(a){return p(this,a).bearing()},changeInAngle:function(a,b,c){return q(this).offset(-a,-b).theta(c)-this.theta(c)},clone:function(){return q(this)},difference:function(a,b){return Object(a)===a&&(b=a.y,a=a.x),q(this.x-(a||0),this.y-(b||0))},distance:function(a){return p(this,a).length()},squaredDistance:function(a){return p(this,a).squaredLength()},equals:function(a){return!!a&&this.x===a.x&&this.y===a.y},magnitude:function(){return f(this.x*this.x+this.y*this.y)||.01},manhattanDistance:function(a){return c(a.x-this.x)+c(a.y-this.y)},move:function(a,b){var c=w(q(a).theta(this));return this.offset(d(c)*b,-e(c)*b)},normalize:function(a){var b=(a||1)/this.magnitude();return this.scale(b,b)},offset:function(a,b){return Object(a)===a&&(b=a.y,a=a.x),this.x+=a||0,this.y+=b||0,this},reflection:function(a){return q(a).move(this,this.distance(a))},rotate:function(a,b){b=(b+360)%360,this.toPolar(a),this.y+=w(b);var c=q.fromPolar(this.x,this.y,a);return this.x=c.x,this.y=c.y,this},round:function(a){var b=n(10,a||0);return this.x=j(this.x*b)/b,this.y=j(this.y*b)/b,this},scale:function(a,b,c){return c=c&&q(c)||q(0,0),this.x=c.x+a*(this.x-c.x),this.y=c.y+b*(this.y-c.y),this},snapToGrid:function(a,b){return this.x=u(this.x,a),this.y=u(this.y,b||a),this},theta:function(a){a=q(a);var b=-(a.y-this.y),c=a.x-this.x,d=i(b,c);return d<0&&(d=2*l+d),180*d/l},angleBetween:function(a,b){var c=this.equals(a)||this.equals(b)?NaN:this.theta(b)-this.theta(a);return c<0&&(c+=360),c},vectorAngle:function(a){var b=q(0,0);return b.angleBetween(this,a)},toJSON:function(){return{x:this.x,y:this.y}},toPolar:function(a){a=a&&q(a)||q(0,0);var b=this.x,c=this.y;return this.x=f((b-a.x)*(b-a.x)+(c-a.y)*(c-a.y)),this.y=w(a.theta(q(b,c))),this},toString:function(){return this.x+"@"+this.y},update:function(a,b){return this.x=a||0,this.y=b||0,this},dot:function(a){return a?this.x*a.x+this.y*a.y:NaN},cross:function(a,b){return a&&b?(b.x-this.x)*(a.y-this.y)-(b.y-this.y)*(a.x-this.x):NaN}};var r=a.Rect=function(a,b,c,d){return this instanceof r?(Object(a)===a&&(b=a.y,c=a.width,d=a.height,a=a.x),this.x=void 0===a?0:a,this.y=void 0===b?0:b,this.width=void 0===c?0:c,void(this.height=void 0===d?0:d)):new r(a,b,c,d)};a.Rect.fromEllipse=function(a){return a=o(a),r(a.x-a.a,a.y-a.b,2*a.a,2*a.b)},a.Rect.prototype={bbox:function(a){var b=w(a||0),f=c(e(b)),g=c(d(b)),h=this.width*g+this.height*f,i=this.width*f+this.height*g;return r(this.x+(this.width-h)/2,this.y+(this.height-i)/2,h,i)},bottomLeft:function(){return q(this.x,this.y+this.height)},bottomLine:function(){return p(this.bottomLeft(),this.corner())},bottomMiddle:function(){return q(this.x+this.width/2,this.y+this.height)},center:function(){return q(this.x+this.width/2,this.y+this.height/2)},clone:function(){return r(this)},containsPoint:function(a){return a=q(a),a.x>=this.x&&a.x<=this.x+this.width&&a.y>=this.y&&a.y<=this.y+this.height},containsRect:function(a){var b=r(this).normalize(),c=r(a).normalize(),d=b.width,e=b.height,f=c.width,g=c.height;if(!(d&&e&&f&&g))return!1;var h=b.x,i=b.y,j=c.x,k=c.y;return f+=j,d+=h,g+=k,e+=i,h<=j&&f<=d&&i<=k&&g<=e},corner:function(){return q(this.x+this.width,this.y+this.height)},equals:function(a){var b=r(this).normalize(),c=r(a).normalize();return b.x===c.x&&b.y===c.y&&b.width===c.width&&b.height===c.height},intersect:function(a){var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner();if(e.x<=b.x||e.y<=b.y||d.x>=c.x||d.y>=c.y)return null;var f=Math.max(b.x,d.x),g=Math.max(b.y,d.y);return r(f,g,Math.min(c.x,e.x)-f,Math.min(c.y,e.y)-g)},intersectionWithLineFromCenterToPoint:function(a,b){a=q(a);var c,d=q(this.x+this.width/2,this.y+this.height/2);b&&a.rotate(d,b);for(var e=[p(this.origin(),this.topRight()),p(this.topRight(),this.corner()),p(this.corner(),this.bottomLeft()),p(this.bottomLeft(),this.origin())],f=p(d,a),g=e.length-1;g>=0;--g){var h=e[g].intersection(f);if(null!==h){c=h;break}}return c&&b&&c.rotate(d,-b),c},leftLine:function(){return p(this.origin(),this.bottomLeft())},leftMiddle:function(){return q(this.x,this.y+this.height/2)},moveAndExpand:function(a){return this.x+=a.x||0,this.y+=a.y||0,this.width+=a.width||0,this.height+=a.height||0,this},offset:function(a,b){return q.prototype.offset.call(this,a,b)},inflate:function(a,b){return void 0===a&&(a=0),void 0===b&&(b=a),this.x-=a,this.y-=b,this.width+=2*a,this.height+=2*b,this},normalize:function(){var a=this.x,b=this.y,c=this.width,d=this.height;return this.width<0&&(a=this.x+this.width,c=-this.width),this.height<0&&(b=this.y+this.height,d=-this.height),this.x=a,this.y=b,this.width=c,this.height=d,this},origin:function(){return q(this.x,this.y)},pointNearestToPoint:function(a){if(a=q(a),this.containsPoint(a)){var b=this.sideNearestToPoint(a);switch(b){case"right":return q(this.x+this.width,a.y);case"left":return q(this.x,a.y);case"bottom":return q(a.x,this.y+this.height);case"top":return q(a.x,this.y)}}return a.adhereToRect(this)},rightLine:function(){return p(this.topRight(),this.corner())},rightMiddle:function(){return q(this.x+this.width,this.y+this.height/2)},round:function(a){var b=n(10,a||0);return this.x=j(this.x*b)/b,this.y=j(this.y*b)/b,this.width=j(this.width*b)/b,this.height=j(this.height*b)/b,this},scale:function(a,b,c){return c=this.origin().scale(a,b,c),this.x=c.x,this.y=c.y,this.width*=a,this.height*=b,this},maxRectScaleToFit:function(b,c){b=a.Rect(b),c||(c=b.center());var d,e,f,g,h,i,j,k,l=c.x,m=c.y;d=e=f=g=h=i=j=k=1/0;var n=b.origin();n.x<l&&(d=(this.x-l)/(n.x-l)),n.y<m&&(h=(this.y-m)/(n.y-m));var o=b.corner();o.x>l&&(e=(this.x+this.width-l)/(o.x-l)),o.y>m&&(i=(this.y+this.height-m)/(o.y-m));var p=b.topRight();p.x>l&&(f=(this.x+this.width-l)/(p.x-l)),p.y<m&&(j=(this.y-m)/(p.y-m));var q=b.bottomLeft();return q.x<l&&(g=(this.x-l)/(q.x-l)),q.y>m&&(k=(this.y+this.height-m)/(q.y-m)),{sx:Math.min(d,e,f,g),sy:Math.min(h,i,j,k)}},maxRectUniformScaleToFit:function(a,b){var c=this.maxRectScaleToFit(a,b);return Math.min(c.sx,c.sy)},sideNearestToPoint:function(a){a=q(a);var b=a.x-this.x,c=this.x+this.width-a.x,d=a.y-this.y,e=this.y+this.height-a.y,f=b,g="left";return c<f&&(f=c,g="right"),d<f&&(f=d,g="top"),e<f&&(f=e,g="bottom"),g},snapToGrid:function(a,b){var c=this.origin().snapToGrid(a,b),d=this.corner().snapToGrid(a,b);return this.x=c.x,this.y=c.y,this.width=d.x-c.x,this.height=d.y-c.y,this},topLine:function(){return p(this.origin(),this.topRight())},topMiddle:function(){return q(this.x+this.width/2,this.y)},topRight:function(){return q(this.x+this.width,this.y)},toJSON:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},toString:function(){return this.origin().toString()+" "+this.corner().toString()},union:function(a){a=r(a);var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner(),f=Math.min(b.x,d.x),g=Math.min(b.y,d.y),h=Math.max(c.x,e.x),i=Math.max(c.y,e.y);return r(f,g,h-f,i-g)}};var s=a.Polyline=function(a){return this instanceof s?void(this.points=Array.isArray(a)?a.map(q):[]):new s(a)};s.prototype={pointAtLength:function(a){for(var b=this.points,c=0,d=0,e=b.length-1;d<e;d++){var f=b[d],g=b[d+1],h=f.distance(g);if(c+=h,a<=c)return p(g,f).pointAt(h?(c-a)/h:0)}return null},length:function(){for(var a=this.points,b=0,c=0,d=a.length-1;c<d;c++)b+=a[c].distance(a[c+1]);return b},closestPoint:function(a){return this.pointAtLength(this.closestPointLength(a))},closestPointLength:function(a){for(var b,c=this.points,d=1/0,e=0,f=0,g=c.length-1;f<g;f++){var h=p(c[f],c[f+1]),i=h.length(),j=h.closestPointNormalizedLength(a),k=h.pointAt(j),l=k.squaredDistance(a);l<d&&(d=l,b=e+j*i),e+=i}return b},toString:function(){return this.points+""},convexHull:function(){var a,b,c,d=this.points;for(b=d.length,a=0;a<b;a++)void 0===c?c=d[a]:d[a].y<c.y?c=d[a]:d[a].y===c.y&&d[a].x>c.x&&(c=d[a]);var e=[];for(b=d.length,a=0;a<b;a++){var f=c.theta(d[a]);0===f&&(f=360);var g=[d[a],a,f];e.push(g)}if(e.sort(function(a,b){var c=a[2]-b[2];return 0===c&&(c=b[1]-a[1]),c}),e.length>2){var h=e[e.length-1];e.unshift(h)}for(var i,j,k,l,m,n,o={},p=[];0!==e.length;)if(i=e.pop(),j=i[0],!o.hasOwnProperty(i[0]+"@@"+i[1]))for(var q=!1;!q;)if(p.length<2)p.push(i),q=!0;else{k=p.pop(),l=k[0],m=p.pop(),n=m[0];var r=n.cross(l,j);if(r<0)p.push(m),p.push(k),p.push(i),q=!0;else if(0===r){var t=1e-10,u=l.angleBetween(n,j);Math.abs(u-180)<t?(o[k[0]+"@@"+k[1]]=l,p.push(m)):l.equals(j)||n.equals(l)?(o[k[0]+"@@"+k[1]]=l,p.push(m)):Math.abs((u+1)%360-1)<t&&(p.push(m),e.push(k))}else o[k[0]+"@@"+k[1]]=l,p.push(m)}p.length>2&&p.pop();var v,w=-1;for(b=p.length,a=0;a<b;a++){var x=p[a][1];(void 0===v||x<v)&&(v=x,w=a)}var y=[];if(w>0){var z=p.slice(w),A=p.slice(0,w);y=z.concat(A)}else y=p;var B=[];for(b=y.length,a=0;a<b;a++)B.push(y[a][0]);return s(B)}},a.scale={linear:function(a,b,c){var d=a[1]-a[0],e=b[1]-b[0];return(c-a[0])/d*e+b[0]||0}};var t=a.normalizeAngle=function(a){return a%360+(a<0?360:0)},u=a.snapToGrid=function(a,b){return b*Math.round(a/b)},v=a.toDeg=function(a){return 180*a/l%360},w=a.toRad=function(a,b){return b=b||!1,a=b?a:a%360,a*l/180};return a.ellipse=a.Ellipse,a.line=a.Line,a.point=a.Point,a.rect=a.Rect,a}();

    return g;

}));
