/*! JointJS v2.0.1 (2017-11-15) - JavaScript diagramming library


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/
(function(root, factory) {

    if (typeof define === 'function' && define.amd) {

        // AMD. Register as an anonymous module.
        define(['g'], function(g) {
            return factory(g);
        });

    } else if (typeof exports === 'object') {

        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like environments that support module.exports,
        // like Node.
        var g = require('./geometry');

        module.exports = factory(g);

    } else {

        // Browser globals.
        var g = root.g;

        root.Vectorizer = root.V = factory(g);
    }

}(this, function(g) {

var V,Vectorizer;V=Vectorizer=function(){"use strict";var a="object"==typeof window&&!(!window.SVGAngle&&!document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"));if(!a)return function(){throw new Error("SVG is required to use Vectorizer.")};var b={xmlns:"http://www.w3.org/2000/svg",xml:"http://www.w3.org/XML/1998/namespace",xlink:"http://www.w3.org/1999/xlink"},c="1.1",d=function(a,c,e){if(!(this instanceof d))return d.apply(Object.create(d.prototype),arguments);if(a){if(d.isV(a)&&(a=a.node),c=c||{},d.isString(a)){if("svg"===a.toLowerCase())a=d.createSvgDocument();else if("<"===a[0]){var f=d.createSvgDocument(a);if(f.childNodes.length>1){var g,h,i=[];for(g=0,h=f.childNodes.length;g<h;g++){var j=f.childNodes[g];i.push(new d(document.importNode(j,!0)))}return i}a=document.importNode(f.firstChild,!0)}else a=document.createElementNS(b.xmlns,a);d.ensureId(a)}return this.node=a,this.setAttributes(c),e&&this.append(e),this}};d.prototype.getTransformToElement=function(a){return a=d.toNode(a),a.getScreenCTM().inverse().multiply(this.node.getScreenCTM())},d.prototype.transform=function(a,b){var c=this.node;if(d.isUndefined(a))return d.transformStringToMatrix(this.attr("transform"));if(b&&b.absolute)return this.attr("transform",d.matrixToTransformString(a));var e=d.createSVGTransform(a);return c.transform.baseVal.appendItem(e),this},d.prototype.translate=function(a,b,c){c=c||{},b=b||0;var e=this.attr("transform")||"",f=d.parseTransformString(e);if(e=f.value,d.isUndefined(a))return f.translate;e=e.replace(/translate\([^\)]*\)/g,"").trim();var g=c.absolute?a:f.translate.tx+a,h=c.absolute?b:f.translate.ty+b,i="translate("+g+","+h+")";return this.attr("transform",(i+" "+e).trim()),this},d.prototype.rotate=function(a,b,c,e){e=e||{};var f=this.attr("transform")||"",g=d.parseTransformString(f);if(f=g.value,d.isUndefined(a))return g.rotate;f=f.replace(/rotate\([^\)]*\)/g,"").trim(),a%=360;var h=e.absolute?a:g.rotate.angle+a,i=void 0!==b&&void 0!==c?","+b+","+c:"",j="rotate("+h+i+")";return this.attr("transform",(f+" "+j).trim()),this},d.prototype.scale=function(a,b){b=d.isUndefined(b)?a:b;var c=this.attr("transform")||"",e=d.parseTransformString(c);if(c=e.value,d.isUndefined(a))return e.scale;c=c.replace(/scale\([^\)]*\)/g,"").trim();var f="scale("+a+","+b+")";return this.attr("transform",(c+" "+f).trim()),this},d.prototype.bbox=function(a,b){var c,e=this.node,f=e.ownerSVGElement;if(!f)return g.Rect(0,0,0,0);try{c=e.getBBox()}catch(a){c={x:e.clientLeft,y:e.clientTop,width:e.clientWidth,height:e.clientHeight}}if(a)return g.Rect(c);var h=this.getTransformToElement(b||f);return d.transformRect(c,h)},d.prototype.getBBox=function(a){var b,c={},e=this.node,f=e.ownerSVGElement;if(!f)return g.Rect(0,0,0,0);if(a&&(a.target&&(c.target=d.toNode(a.target)),a.recursive&&(c.recursive=a.recursive)),c.recursive){var h=this.children(),i=h.length;if(0===i)return this.getBBox({target:c.target,recursive:!1});c.target||(c.target=this);for(var j=0;j<i;j++){var k,l=h[j];k=0===l.children().length?l.getBBox({target:c.target,recursive:!1}):l.getBBox({target:c.target,recursive:!0}),b=b?b.union(k):k}return b}try{b=e.getBBox()}catch(a){b={x:e.clientLeft,y:e.clientTop,width:e.clientWidth,height:e.clientHeight}}if(c.target){var m=this.getTransformToElement(c.target);return d.transformRect(b,m)}return g.Rect(b)},d.prototype.text=function(a,b){a=d.sanitizeText(a),b=b||{};var c,e=b.eol,f=a.split("\n");a?this.removeAttr("display"):this.attr("display","none"),this.attr("xml:space","preserve"),this.node.textContent="";var g=this.node;if(b.textPath){var h=this.find("defs");0===h.length&&(h=d("defs"),this.append(h));var i=Object(b.textPath)===b.textPath?b.textPath.d:b.textPath;if(i){var j=d("path",{d:i});h.append(j)}var k=d("textPath");!b.textPath["xlink:href"]&&j&&k.attr("xlink:href","#"+j.node.id),Object(b.textPath)===b.textPath&&k.attr(b.textPath),this.append(k),g=k.node}var l=0,m=(void 0!==b.x?b.x:this.attr("x"))||0,n=b.lineHeight||"1em";"auto"===b.lineHeight&&(n="1.5em");for(var o=0,p=0;p<f.length;p++){var q={class:"v-line"};0===p?q.dy="0em":(q.dy=n,q.x=m);var r=d("tspan",q),s=f.length-1,t=f[p];if(t){var u=0;if(b.annotations){for(var v=d.annotateString(f[p],d.isArray(b.annotations)?b.annotations:[b.annotations],{offset:-l,includeAnnotationIndices:b.includeAnnotationIndices}),w=v.length-1,x=0;x<v.length;x++){var y=v[x];if(d.isObject(y)){var z=parseFloat(y.attrs["font-size"]);z&&z>u&&(u=z),c=d("tspan",y.attrs),b.includeAnnotationIndices&&c.attr("annotations",y.annotations),y.attrs.class&&c.addClass(y.attrs.class),e&&x===w&&p!==s&&(y.t+=e),c.node.textContent=y.t}else e&&x===w&&p!==s&&(y+=e),c=document.createTextNode(y||" ");r.append(c)}"auto"===b.lineHeight&&u&&0!==p&&r.attr("dy",1.2*u+"px")}else e&&p!==s&&(t+=e),r.node.textContent=t;0===p&&(o=u)}else r.addClass("v-empty-line"),r.node.style.fillOpacity=0,r.node.style.strokeOpacity=0,r.node.textContent="-";d(g).append(r),l+=t.length+1}var A=this.attr("y");return null===A&&this.attr("y",o||"0.8em"),this},d.prototype.removeAttr=function(a){var b=d.qualifyAttr(a),c=this.node;return b.ns?c.hasAttributeNS(b.ns,b.local)&&c.removeAttributeNS(b.ns,b.local):c.hasAttribute(a)&&c.removeAttribute(a),this},d.prototype.attr=function(a,b){if(d.isUndefined(a)){for(var c=this.node.attributes,e={},f=0;f<c.length;f++)e[c[f].name]=c[f].value;return e}if(d.isString(a)&&d.isUndefined(b))return this.node.getAttribute(a);if("object"==typeof a)for(var g in a)a.hasOwnProperty(g)&&this.setAttribute(g,a[g]);else this.setAttribute(a,b);return this},d.prototype.remove=function(){return this.node.parentNode&&this.node.parentNode.removeChild(this.node),this},d.prototype.empty=function(){for(;this.node.firstChild;)this.node.removeChild(this.node.firstChild);return this},d.prototype.setAttributes=function(a){for(var b in a)a.hasOwnProperty(b)&&this.setAttribute(b,a[b]);return this},d.prototype.append=function(a){d.isArray(a)||(a=[a]);for(var b=0,c=a.length;b<c;b++)this.node.appendChild(d.toNode(a[b]));return this},d.prototype.prepend=function(a){var b=this.node.firstChild;return b?d(b).before(a):this.append(a)},d.prototype.before=function(a){var b=this.node,c=b.parentNode;if(c){d.isArray(a)||(a=[a]);for(var e=0,f=a.length;e<f;e++)c.insertBefore(d.toNode(a[e]),b)}return this},d.prototype.appendTo=function(a){return d.toNode(a).appendChild(this.node),this},d.prototype.svg=function(){return this.node instanceof window.SVGSVGElement?this:d(this.node.ownerSVGElement)},d.prototype.defs=function(){var a=this.svg().node.getElementsByTagName("defs");return a&&a.length?d(a[0]):void 0},d.prototype.clone=function(){var a=d(this.node.cloneNode(!0));return a.node.id=d.uniqueId(),a},d.prototype.findOne=function(a){var b=this.node.querySelector(a);return b?d(b):void 0},d.prototype.find=function(a){var b=[],c=this.node.querySelectorAll(a);if(c)for(var e=0;e<c.length;e++)b.push(d(c[e]));return b},d.prototype.children=function(){for(var a=this.node.childNodes,b=[],c=0;c<a.length;c++){var e=a[c];1===e.nodeType&&b.push(d(a[c]))}return b},d.prototype.index=function(){for(var a=0,b=this.node.previousSibling;b;)1===b.nodeType&&a++,b=b.previousSibling;return a},d.prototype.findParentByClass=function(a,b){for(var c=this.node.ownerSVGElement,e=this.node.parentNode;e&&e!==b&&e!==c;){var f=d(e);if(f.hasClass(a))return f;e=e.parentNode}return null},d.prototype.contains=function(a){var b=this.node,c=d.toNode(a),e=c&&c.parentNode;return b===e||!!(e&&1===e.nodeType&&16&b.compareDocumentPosition(e))},d.prototype.toLocalPoint=function(a,b){var c=this.svg().node,d=c.createSVGPoint();d.x=a,d.y=b;try{var e=d.matrixTransform(c.getScreenCTM().inverse()),f=this.getTransformToElement(c).inverse()}catch(a){return d}return e.matrixTransform(f)},d.prototype.translateCenterToPoint=function(a){var b=this.getBBox({target:this.svg()}),c=b.center();return this.translate(a.x-c.x,a.y-c.y),this},d.prototype.translateAndAutoOrient=function(a,b,c){var e=this.scale();this.attr("transform",""),this.scale(e.sx,e.sy);var f=this.svg().node,h=this.getBBox({target:c||f}),i=f.createSVGTransform();i.setTranslate(-h.x-h.width/2,-h.y-h.height/2);var j=f.createSVGTransform(),k=g.point(a).changeInAngle(a.x-b.x,a.y-b.y,b);j.setRotate(k,0,0);var l=f.createSVGTransform(),m=g.point(a).move(b,h.width/2);l.setTranslate(a.x+(a.x-m.x),a.y+(a.y-m.y));var n=this.getTransformToElement(c||f),o=f.createSVGTransform();o.setMatrix(l.matrix.multiply(j.matrix.multiply(i.matrix.multiply(n))));var p=d.decomposeMatrix(o.matrix);return this.translate(p.translateX,p.translateY),this.rotate(p.rotation),this},d.prototype.animateAlongPath=function(a,b){b=d.toNode(b);var c=d.ensureId(b),e=d("animateMotion",a),f=d("mpath",{"xlink:href":"#"+c});e.append(f),this.append(e);try{e.node.beginElement()}catch(a){if("fake"===document.documentElement.getAttribute("smiling")){var g=e.node;g.animators=[];var h=g.getAttribute("id");h&&(id2anim[h]=g);for(var i=getTargets(g),j=0,k=i.length;j<k;j++){var l=i[j],m=new Animator(g,l,j);animators.push(m),g.animators[j]=m,m.register()}}}return this},d.prototype.hasClass=function(a){return new RegExp("(\\s|^)"+a+"(\\s|$)").test(this.node.getAttribute("class"))},d.prototype.addClass=function(a){if(!this.hasClass(a)){var b=this.node.getAttribute("class")||"";this.node.setAttribute("class",(b+" "+a).trim())}return this},d.prototype.removeClass=function(a){if(this.hasClass(a)){var b=this.node.getAttribute("class").replace(new RegExp("(\\s|^)"+a+"(\\s|$)","g"),"$2");this.node.setAttribute("class",b)}return this},d.prototype.toggleClass=function(a,b){var c=d.isUndefined(b)?this.hasClass(a):!b;return c?this.removeClass(a):this.addClass(a),this},d.prototype.sample=function(a){a=a||1;for(var b,c=this.node,d=c.getTotalLength(),e=[],f=0;f<d;)b=c.getPointAtLength(f),e.push({x:b.x,y:b.y,distance:f}),f+=a;return e},d.prototype.convertToPath=function(){var a=d("path");a.attr(this.attr());var b=this.convertToPathData();return b&&a.attr("d",b),a},d.prototype.convertToPathData=function(){var a=this.node.tagName.toUpperCase();switch(a){case"PATH":return this.attr("d");case"LINE":return d.convertLineToPathData(this.node);case"POLYGON":return d.convertPolygonToPathData(this.node);case"POLYLINE":return d.convertPolylineToPathData(this.node);case"ELLIPSE":return d.convertEllipseToPathData(this.node);case"CIRCLE":return d.convertCircleToPathData(this.node);case"RECT":return d.convertRectToPathData(this.node)}throw new Error(a+" cannot be converted to PATH.")},d.prototype.findIntersection=function(a,b){var c=this.svg().node;b=b||c;var e=this.getBBox({target:b}),f=e.center();if(e.intersectionWithLineFromCenterToPoint(a)){var h,i=this.node.localName.toUpperCase();if("RECT"===i){var j=g.rect(parseFloat(this.attr("x")||0),parseFloat(this.attr("y")||0),parseFloat(this.attr("width")),parseFloat(this.attr("height"))),k=this.getTransformToElement(b),l=d.decomposeMatrix(k),m=c.createSVGTransform();m.setRotate(-l.rotation,f.x,f.y);var n=d.transformRect(j,m.matrix.multiply(k));h=g.rect(n).intersectionWithLineFromCenterToPoint(a,l.rotation)}else if("PATH"===i||"POLYGON"===i||"POLYLINE"===i||"CIRCLE"===i||"ELLIPSE"===i){var o,p,q,r,s,t,u="PATH"===i?this:this.convertToPath(),v=u.sample(),w=1/0,x=[];for(o=0;o<v.length;o++)p=v[o],q=d.createSVGPoint(p.x,p.y),q=q.matrixTransform(this.getTransformToElement(b)),p=g.point(q),r=p.distance(f),s=1.1*p.distance(a),t=r+s,t<w?(w=t,x=[{sample:p,refDistance:s}]):t<w+1&&x.push({sample:p,refDistance:s});x.sort(function(a,b){return a.refDistance-b.refDistance}),x[0]&&(h=x[0].sample)}return h}},d.prototype.setAttribute=function(a,b){var c=this.node;if(null===b)return this.removeAttr(a),this;var e=d.qualifyAttr(a);return e.ns?c.setAttributeNS(e.ns,a,b):"id"===a?c.id=b:c.setAttribute(a,b),this},d.createSvgDocument=function(a){var e='<svg xmlns="'+b.xmlns+'" xmlns:xlink="'+b.xlink+'" version="'+c+'">'+(a||"")+"</svg>",f=d.parseXML(e,{async:!1});return f.documentElement},d.idCounter=0,d.uniqueId=function(){return"v-"+ ++d.idCounter},d.toNode=function(a){return d.isV(a)?a.node:a.nodeName&&a||a[0]},d.ensureId=function(a){return a=d.toNode(a),a.id||(a.id=d.uniqueId())},d.sanitizeText=function(a){return(a||"").replace(/ /g,"\xa0")},d.isUndefined=function(a){return"undefined"==typeof a},d.isString=function(a){return"string"==typeof a},d.isObject=function(a){return a&&"object"==typeof a},d.isArray=Array.isArray,d.parseXML=function(a,b){b=b||{};var c;try{var e=new DOMParser;d.isUndefined(b.async)||(e.async=b.async),c=e.parseFromString(a,"text/xml")}catch(a){c=void 0}if(!c||c.getElementsByTagName("parsererror").length)throw new Error("Invalid XML: "+a);return c},d.qualifyAttr=function(a){if(a.indexOf(":")!==-1){var c=a.split(":");return{ns:b[c[0]],local:c[1]}}return{ns:null,local:a}},d.transformRegex=/(\w+)\(([^,)]+),?([^)]+)?\)/gi,d.transformSeparatorRegex=/[ ,]+/,d.transformationListRegex=/^(\w+)\((.*)\)/,d.transformStringToMatrix=function(a){var b=d.createSVGMatrix(),c=a&&a.match(d.transformRegex);if(!c)return b;for(var e=0,f=c.length;e<f;e++){var g=c[e],h=g.match(d.transformationListRegex);if(h){var i,j,k,l,m,n=d.createSVGMatrix(),o=h[2].split(d.transformSeparatorRegex);switch(h[1].toLowerCase()){case"scale":i=parseFloat(o[0]),j=void 0===o[1]?i:parseFloat(o[1]),n=n.scaleNonUniform(i,j);break;case"translate":k=parseFloat(o[0]),l=parseFloat(o[1]),n=n.translate(k,l);break;case"rotate":m=parseFloat(o[0]),k=parseFloat(o[1])||0,l=parseFloat(o[2])||0,n=0!==k||0!==l?n.translate(k,l).rotate(m).translate(-k,-l):n.rotate(m);break;case"skewx":m=parseFloat(o[0]),n=n.skewX(m);break;case"skewy":m=parseFloat(o[0]),n=n.skewY(m);break;case"matrix":n.a=parseFloat(o[0]),n.b=parseFloat(o[1]),n.c=parseFloat(o[2]),n.d=parseFloat(o[3]),n.e=parseFloat(o[4]),n.f=parseFloat(o[5]);break;default:continue}b=b.multiply(n)}}return b},d.matrixToTransformString=function(a){return a||(a=!0),"matrix("+(void 0!==a.a?a.a:1)+","+(void 0!==a.b?a.b:0)+","+(void 0!==a.c?a.c:0)+","+(void 0!==a.d?a.d:1)+","+(void 0!==a.e?a.e:0)+","+(void 0!==a.f?a.f:0)+")"},d.parseTransformString=function(a){var b,c,e;if(a){var f=d.transformSeparatorRegex;if(a.trim().indexOf("matrix")>=0){var g=d.transformStringToMatrix(a),h=d.decomposeMatrix(g);b=[h.translateX,h.translateY],e=[h.scaleX,h.scaleY],c=[h.rotation];var i=[];0===b[0]&&0===b[0]||i.push("translate("+b+")"),1===e[0]&&1===e[1]||i.push("scale("+e+")"),0!==c[0]&&i.push("rotate("+c+")"),a=i.join(" ")}else{var j=a.match(/translate\((.*?)\)/);j&&(b=j[1].split(f));var k=a.match(/rotate\((.*?)\)/);k&&(c=k[1].split(f));var l=a.match(/scale\((.*?)\)/);l&&(e=l[1].split(f))}}var m=e&&e[0]?parseFloat(e[0]):1;return{value:a,translate:{tx:b&&b[0]?parseInt(b[0],10):0,ty:b&&b[1]?parseInt(b[1],10):0},rotate:{angle:c&&c[0]?parseInt(c[0],10):0,cx:c&&c[1]?parseInt(c[1],10):void 0,cy:c&&c[2]?parseInt(c[2],10):void 0},scale:{sx:m,sy:e&&e[1]?parseFloat(e[1]):m}}},d.deltaTransformPoint=function(a,b){var c=b.x*a.a+b.y*a.c+0,d=b.x*a.b+b.y*a.d+0;return{x:c,y:d}},d.decomposeMatrix=function(a){var b=d.deltaTransformPoint(a,{x:0,y:1}),c=d.deltaTransformPoint(a,{x:1,y:0}),e=180/Math.PI*Math.atan2(b.y,b.x)-90,f=180/Math.PI*Math.atan2(c.y,c.x);return{translateX:a.e,translateY:a.f,scaleX:Math.sqrt(a.a*a.a+a.b*a.b),scaleY:Math.sqrt(a.c*a.c+a.d*a.d),skewX:e,skewY:f,rotation:e}},d.matrixToScale=function(a){var b,c,e,f;return a?(b=d.isUndefined(a.a)?1:a.a,f=d.isUndefined(a.d)?1:a.d,c=a.b,e=a.c):b=f=1,{sx:c?Math.sqrt(b*b+c*c):b,sy:e?Math.sqrt(e*e+f*f):f}},d.matrixToRotate=function(a){var b={x:0,y:1};return a&&(b=d.deltaTransformPoint(a,b)),{angle:g.normalizeAngle(g.toDeg(Math.atan2(b.y,b.x))-90)}},d.matrixToTranslate=function(a){return{tx:a&&a.e||0,ty:a&&a.f||0}},d.isV=function(a){return a instanceof d},d.isVElement=d.isV;var e=d("svg").node;return d.createSVGMatrix=function(a){var b=e.createSVGMatrix();for(var c in a)b[c]=a[c];return b},d.createSVGTransform=function(a){return d.isUndefined(a)?e.createSVGTransform():(a instanceof SVGMatrix||(a=d.createSVGMatrix(a)),e.createSVGTransformFromMatrix(a))},d.createSVGPoint=function(a,b){var c=e.createSVGPoint();return c.x=a,c.y=b,c},d.transformRect=function(a,b){var c=e.createSVGPoint();c.x=a.x,c.y=a.y;var d=c.matrixTransform(b);c.x=a.x+a.width,c.y=a.y;var f=c.matrixTransform(b);c.x=a.x+a.width,c.y=a.y+a.height;var h=c.matrixTransform(b);c.x=a.x,c.y=a.y+a.height;var i=c.matrixTransform(b),j=Math.min(d.x,f.x,h.x,i.x),k=Math.max(d.x,f.x,h.x,i.x),l=Math.min(d.y,f.y,h.y,i.y),m=Math.max(d.y,f.y,h.y,i.y);return g.Rect(j,l,k-j,m-l)},d.transformPoint=function(a,b){return g.Point(d.createSVGPoint(a.x,a.y).matrixTransform(b))},d.styleToObject=function(a){for(var b={},c=a.split(";"),d=0;d<c.length;d++){var e=c[d],f=e.split("=");b[f[0].trim()]=f[1].trim()}return b},d.createSlicePathData=function(a,b,c,d){var e=2*Math.PI-1e-6,f=a,g=b,h=c,i=d,j=(i<h&&(j=h,h=i,i=j),i-h),k=j<Math.PI?"0":"1",l=Math.cos(h),m=Math.sin(h),n=Math.cos(i),o=Math.sin(i);return j>=e?f?"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"M0,"+f+"A"+f+","+f+" 0 1,0 0,"+-f+"A"+f+","+f+" 0 1,0 0,"+f+"Z":"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"Z":f?"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L"+f*n+","+f*o+"A"+f+","+f+" 0 "+k+",0 "+f*l+","+f*m+"Z":"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L0,0Z"},d.mergeAttrs=function(a,b){for(var c in b)"class"===c?a[c]=a[c]?a[c]+" "+b[c]:b[c]:"style"===c?d.isObject(a[c])&&d.isObject(b[c])?a[c]=d.mergeAttrs(a[c],b[c]):d.isObject(a[c])?a[c]=d.mergeAttrs(a[c],d.styleToObject(b[c])):d.isObject(b[c])?a[c]=d.mergeAttrs(d.styleToObject(a[c]),b[c]):a[c]=d.mergeAttrs(d.styleToObject(a[c]),d.styleToObject(b[c])):a[c]=b[c];return a},d.annotateString=function(a,b,c){b=b||[],c=c||{};for(var e,f,g,h=c.offset||0,i=[],j=[],k=0;k<a.length;k++){f=j[k]=a[k];for(var l=0;l<b.length;l++){var m=b[l],n=m.start+h,o=m.end+h;k>=n&&k<o&&(d.isObject(f)?f.attrs=d.mergeAttrs(d.mergeAttrs({},f.attrs),m.attrs):f=j[k]={t:a[k],attrs:m.attrs},c.includeAnnotationIndices&&(f.annotations||(f.annotations=[])).push(l))}g=j[k-1],g?d.isObject(f)&&d.isObject(g)?JSON.stringify(f.attrs)===JSON.stringify(g.attrs)?e.t+=f.t:(i.push(e),e=f):d.isObject(f)?(i.push(e),e=f):d.isObject(g)?(i.push(e),e=f):e=(e||"")+f:e=f}return e&&i.push(e),i},d.findAnnotationsAtIndex=function(a,b){var c=[];return a&&a.forEach(function(a){a.start<b&&b<=a.end&&c.push(a)}),c},d.findAnnotationsBetweenIndexes=function(a,b,c){var d=[];return a&&a.forEach(function(a){(b>=a.start&&b<a.end||c>a.start&&c<=a.end||a.start>=b&&a.end<c)&&d.push(a)}),d},d.shiftAnnotations=function(a,b,c){return a&&a.forEach(function(a){a.start<b&&a.end>=b?a.end+=c:a.start>=b&&(a.start+=c,a.end+=c)}),a},d.convertLineToPathData=function(a){a=d(a);var b=["M",a.attr("x1"),a.attr("y1"),"L",a.attr("x2"),a.attr("y2")].join(" ");return b},d.convertPolygonToPathData=function(a){var b=d.getPointsFromSvgNode(d(a).node);return b.length>0?d.svgPointsToPath(b)+" Z":null},d.convertPolylineToPathData=function(a){var b=d.getPointsFromSvgNode(d(a).node);return b.length>0?d.svgPointsToPath(b):null},d.svgPointsToPath=function(a){var b;for(b=0;b<a.length;b++)a[b]=a[b].x+" "+a[b].y;return"M "+a.join(" L")},d.getPointsFromSvgNode=function(a){a=d.toNode(a);var b=[],c=a.points;if(c)for(var e=0;e<c.numberOfItems;e++)b.push(c.getItem(e));return b},d.KAPPA=.5522847498307935,d.convertCircleToPathData=function(a){a=d(a);var b=parseFloat(a.attr("cx"))||0,c=parseFloat(a.attr("cy"))||0,e=parseFloat(a.attr("r")),f=e*d.KAPPA,g=["M",b,c-e,"C",b+f,c-e,b+e,c-f,b+e,c,"C",b+e,c+f,b+f,c+e,b,c+e,"C",b-f,c+e,b-e,c+f,b-e,c,"C",b-e,c-f,b-f,c-e,b,c-e,"Z"].join(" ");return g},d.convertEllipseToPathData=function(a){a=d(a);var b=parseFloat(a.attr("cx"))||0,c=parseFloat(a.attr("cy"))||0,e=parseFloat(a.attr("rx")),f=parseFloat(a.attr("ry"))||e,g=e*d.KAPPA,h=f*d.KAPPA,i=["M",b,c-f,"C",b+g,c-f,b+e,c-h,b+e,c,"C",b+e,c+h,b+g,c+f,b,c+f,"C",b-g,c+f,b-e,c+h,b-e,c,"C",b-e,c-h,b-g,c-f,b,c-f,"Z"].join(" ");return i},d.convertRectToPathData=function(a){return a=d(a),d.rectToPath({x:parseFloat(a.attr("x"))||0,y:parseFloat(a.attr("y"))||0,width:parseFloat(a.attr("width"))||0,height:parseFloat(a.attr("height"))||0,rx:parseFloat(a.attr("rx"))||0,ry:parseFloat(a.attr("ry"))||0})},d.rectToPath=function(a){var b,c=a.x,d=a.y,e=a.width,f=a.height,g=Math.min(a.rx||a["top-rx"]||0,e/2),h=Math.min(a.rx||a["bottom-rx"]||0,e/2),i=Math.min(a.ry||a["top-ry"]||0,f/2),j=Math.min(a.ry||a["bottom-ry"]||0,f/2);return b=g||h||i||j?["M",c,d+i,"v",f-i-j,"a",h,j,0,0,0,h,j,"h",e-2*h,"a",h,j,0,0,0,h,-j,"v",-(f-j-i),"a",g,i,0,0,0,-g,-i,"h",-(e-2*g),"a",g,i,0,0,0,-g,i,"Z"]:["M",c,d,"H",c+e,"V",d+f,"H",c,"V",d,"Z"],b.join(" ")},d.namespace=b,d}();

    return V;

}));
