/* 
 * joy.js v0.2.1 
 * http://joyjs.org
 * 
 * @copyright 2012-2013 Endel Dreyer 
 * @license MIT
 * @build 7/6/2013
 */
(function(t){var i=t.Joy||{Init:{},Render:{},Input:{},Context:{},debug:!1,deltaTime:1,ready:function(t){document.onload=t}};i.generateUniqueId=function(){return"joy"+(new Date).getTime()},t.Joy=i})(window),function(t){t.CompositeOperation={SOURCE_OVER:"source-over",SOURCE_IN:"source-in",SOURCE_OUT:"source-out",SOURCE_ATOP:"source-atop",LIGHTER:"lighter",XOR:"xor",DESTINATION_OVER:"destination-over",DESTINATION_IN:"destination-in",DESTINATION_OUT:"destination-out",DESTINATION_ATOP:"destination-atop",DESTINATION_COPY:"copy"}}(Joy),function(t){t.Events={INIT:"init",SCENE_ACTIVE:"sceneActive",ADDED:"added",REMOVED:"removed",UPDATE:"update",COLLISION:"collision",COLLISION_ENTER:"collisionEnter",COLLISION_EXIT:"collisionExit"}}(Joy),function(t){t.currentEngine=null;var i=function(i){if(t.currentEngine=this,this.paused=!1,"string"==typeof i.tagName&&"CANVAS"===i.tagName){i={canvas:i};var e=Joy.Markup.evaluateDataset(i.canvas);for(var n in e)i[n]=e[n]}if(i.canvas&&(this.context=new Joy.Context.Context2d({canvas:i.canvas})),!this.context){var o=i.context||Joy.Context.Context2d;this.context=new o({canvas:document.createElement("canvas")}),document.body.appendChild(this.context.canvas)}i.width&&(this.context.canvas.width=i.width),i.height&&(this.context.canvas.height=i.height),this.context.canvas.style.width=this.context.canvas.width/window.devicePixelRatio+"px",this.context.canvas.style.height=this.context.canvas.height/window.devicePixelRatio+"px",i.fullscreen&&(window.onresize=function(){}),t.Mouse!==void 0&&t.Mouse.enable(this),i.debug&&(Joy.debug=!0),this.scenes=[],Object.defineProperty(this,"width",{get:function(){return this.context.canvas.width},configurable:!0}),Object.defineProperty(this,"height",{get:function(){return this.context.canvas.height},configurable:!0}),Object.defineProperty(this,"currentScene",{get:function(){return this.scenes[this._currentSceneIndex]},set:function(i){null!==this._currentSceneIndex&&(this.scenes[this._currentSceneIndex].visible=!1,this.scenes[this._currentSceneIndex].viewport.reset()),this.sceneLoader&&i.loader.loading?(this._currentSceneIndex=this.scenes.indexOf(this.sceneLoader),this.sceneLoader.loader=i.loader,this.sceneLoader.visible=!0,i.visible=!1,i.loader.bind("loadComplete",function(){t.currentEngine.gotoScene(i)})):(this._currentSceneIndex=this.scenes.indexOf(i),i.visible=!0,i.broadcast(t.Events.SCENE_ACTIVE,[i]))}}),this._currentSceneIndex=null,this.sceneLoader=null,this.setSceneLoader(t.Engine.defaultSceneLoader),this.context.canvas.children.length>0&&(this.markup=new t.Markup(this).parse()),Joy.debug?(this._lastRenderTime=new Date,this._frameRateText=new Joy.Text({x:4,y:4,font:"12px Verdana",color:"red"}),this.onEnterFrameDebug()):this.onEnterFrame()};i.prototype.createScene=function(i){var e=new t.Scene({ctx:this.context.ctx});return"function"==typeof i&&i.apply(this,[e]),this.addScene(e),e},i.prototype.setSceneLoader=function(i){var e="object"==typeof i?i:new t.Scene({ctx:this.context.ctx,loader:null});return"function"==typeof i&&i.apply(this,[e]),-1===this.scenes.indexOf(e)&&this.scenes.push(e),this.sceneLoader=e,e},i.prototype.pause=function(){this._deltaTime=t.deltaTime,t.deltaTime=0,this.paused=!0},i.prototype.resume=function(){t.deltaTime=this._deltaTime,this.paused=!1},i.prototype.gotoNextScene=function(t,i){if(this.scenes[this._currentSceneIndex+1]===void 0)throw Error("There is no next scene.");return this.gotoScene(this.scenes[this._currentSceneIndex+1],t,i)},i.prototype.gotoScene=function(t,i,e){var n=this;return i||(i=1e3),e||(e="#000"),this.currentScene.fadeOut(i,e).bind("fadeOutComplete",function(){n.currentScene=t,n.currentScene.fadeIn(i,e)}),this},i.prototype.addScene=function(t){t.engine=this,t.setContext(this.context.ctx),Joy.debug&&t.viewport.addHud(this._frameRateText),this.scenes.push(t),null===this._currentSceneIndex&&(this.currentScene=t)},i.prototype.render=function(){this.context.render(this.scenes)},i.prototype.onEnterFrame=function(){t.currentEngine.paused||(t.TweenManager.update(),t.currentEngine.render()),window.onEnterFrame(t.currentEngine.onEnterFrame)},i.prototype.onEnterFrameDebug=function(){var i=new Date;t.currentEngine._frameRateText.text=""+(1e3/(i-t.currentEngine._lastRenderTime)).toFixed(1)+" FPS",t.currentEngine.paused||(t.TweenManager.update(),t.currentEngine.render()),t.currentEngine._lastRenderTime=i,window.onEnterFrame(t.currentEngine.onEnterFrameDebug)},t.Engine=i}(Joy),function(){var t=!1,i=/xyz/.test(function(){"xyz"})?/\b_super\b/:/.*/;this.Class=function(){},Class.extend=function(e){function n(){!t&&this.init&&this.init.apply(this,arguments)}var o=this.prototype;t=!0;var s=new this;t=!1;for(var r in e)s[r]="function"==typeof e[r]&&"function"==typeof o[r]&&i.test(e[r])?function(t,i){return function(){var e=this._super;this._super=o[t];var n=i.apply(this,arguments);return this._super=e,n}}(r,e[r]):e[r];return n.prototype=s,n.prototype.constructor=n,n.extend=arguments.callee,n},Joy.Object=Class}(Joy),function(t){function i(t){return""!==n&&(t=t.charAt(0).toUpperCase()+t.slice(1)),n+t}var e=navigator.userAgent,n=e.match(/opera/i)&&"o"||e.match(/webkit/i)&&"webkit"||e.match(/msie/i)&&"ms"||e.match(/mozilla/i)&&"moz"||"";"function"!=typeof window.addEventListener&&(HTMLElement.prototype.addEventListener=function(t,i){attachEvent("on"+t,i)}),t.Support={touch:"ontouchstart"in window,retina:window.devicePixelRatio>1||window.matchMedia("(min-resolution: 1.1dppx)").matches,imageSmoothingEnabled:i("imageSmoothingEnabled")},window.onEnterFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){window.setTimeout(t,1e3/60)}}()}(Joy),function(t){var i=t.Object.extend({init:function(t){this._handlers=t&&t._handlers||{},this._behaviours=t&&t._behaviours||[]},behave:function(i,e){var n;if("string"==typeof i){var o,s=i.split(",");for(n=0,l=s.length;l>n;n++)o=this.behave(t.Behaviour.get(s[n].replace(" ","")),e);return o}this._behaviours.push(i.id);var r=new i(e);for(n in r)"string"==typeof Joy.Events[n]?this.bind(Joy.Events[n],r[n]):"constructor"!==n&&(this[n]=r[n]);return this},hasBehaviour:function(t){return this._behaviours.indexOf(t)>=0},bind:function(t,e){var n=e;return void 0!==i._custom.bind[t]&&(n={target:this,handler:e},i._custom.bind[t].call(this,n)),void 0===this._handlers[t]&&(this._handlers[t]=[]),-1===this._handlers[t].indexOf(n)&&this._handlers[t].push(n),this},unbind:function(t){if(void 0!==i._custom.unbind[t])for(var e=0,n=this._handlers[t].length;n>e;++e)i._custom.unbind[t].call(this,this._handlers[t][e]);return this._handlers[t]=null,this},trigger:function(t,i,e){var n=this._handlers[t]||[];i=i||[],e=e||0;for(var o=0,s=n.length;s>o;++o)n[o].apply(this,i)},broadcast:function(t,i,e){this.trigger(t,i,e)}});i._custom={bind:{},unbind:{}},i.register=function(t,e,n){return i._custom.bind[t]=e,i._custom.unbind[t]=n,this},i.register(Joy.Events.INIT,function(t){t.handler.call(this)}),t.Triggerable=i}(Joy),function(){Math.clamp=function(t,i,e){return i>t?i:t>e?e:+t}}(Joy),function(t){var i=function(t,i,e,n,o,s){return null!==t&&(this.m11=t),this.m12=i||0,this.m21=e||0,null!==n&&(this.m22=n),this.dx=o||0,this.dy=s||0,this};i.prototype.appendTransform=function(t,e,n,o,s,r,a,h,c){var l,u,d;return s%360?(d=s*i.DEG_TO_RAD,l=Math.cos(d),u=Math.sin(d)):(l=1,u=0),r||a?(r*=i.DEG_TO_RAD,a*=i.DEG_TO_RAD,this.append(Math.cos(a),Math.sin(a),-Math.sin(r),Math.cos(r),t,e),this.append(l*n,u*n,-u*o,l*o,0,0)):this.append(l*n,u*n,-u*o,l*o,t,e),(h||c)&&(this.dx-=h*this.m11+c*this.m21,this.dy-=h*this.m12+c*this.m22),this},i.prototype.append=function(t,i,e,n,o,s){var r=this.m11,a=this.m12,h=this.m21,c=this.m22;return this.m11=t*r+i*h,this.m12=t*a+i*c,this.m21=e*r+n*h,this.m22=e*a+n*c,this.dx=o*r+s*h+this.dx,this.dy=o*a+s*c+this.dy,this},i.prototype.invert=function(){var t=this.m11,i=this.m12,e=this.m21,n=this.m22,o=this.dx,s=t*n-i*e;return this.m11=n/s,this.m12=-i/s,this.m21=-e/s,this.m22=t/s,this.dx=(e*this.dy-n*o)/s,this.dy=-(t*this.dy-i*o)/s,this},i.prototype.clone=function(){return new i(this.m11,this.m12,this.m21,this.m22,this.dx,this.dy)},i.prototype.identity=function(){return this.m11=this.m22=1,this.m12=this.m21=this.dx=this.dy=0,this},i.DEG_TO_RAD=Math.PI/180,i.identity=new i(1,0,0,1,0,0),t.Matrix2D=i}(Joy),function(t){var i=function(t,i){var e=t,n=i;"object"==typeof e&&(e=t.min||0,n=t.max||0),this.min=parseFloat(e||0,10),this.max=parseFloat(n||this.min||0,10)};i.prototype.random=function(){return i.random(this.min,this.max)},i.prototype.randomInt=function(){return i.randomInt(this.min,this.max)},i.parse=function(t){if("string"==typeof t){var e=t.split("..");return new i(e[0],e[1])}return new i(t)},i.random=function(t,i){return Math.random()*(i-t+1)+t},i.randomInt=function(t,i){return Math.floor(Math.random()*(i-t+1)+t)},t.Range=i}(Joy),function(t){var i=function(t,e){this.x=t||0,this.y=e||0,Object.defineProperty(this,"length",{get:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},configurable:!0}),Object.defineProperty(this,"normalized",{get:function(){var t=this.length;return new i(this.x/t,this.y/t)},configurable:!0})};i.prototype.set=function(t,i){return this.x=t,this.y=i,this},i.prototype.subtract=function(t){return this.x-=t.x,this.y-=t.y,this},i.prototype.sum=function(t){return this.x+=t.x,this.y+=t.y,this},i.prototype.scale=function(t,i){return this.x*=t,this.y*=i||t,this},i.prototype.clone=function(){return new i(this.x,this.y)},i.prototype.unit=function(){return new i(Math.cos(this.x),Math.sin(this.y))},i.prototype.normalize=function(){var t=this.normalized;return this.x=t.x,this.y=t.y,this},i.distance=function(t,i){var e=t.x-i.x,n=t.y-i.y;return Math.sqrt(e*e+n*n)},i.prototype.toString=function(){return"#<Vector2d @x="+this.x+", @y="+this.y+">"},i.LEFT=new i(-1,0),i.RIGHT=new i(1,0),i.TOP=new i(0,-1),i.BOTTOM=new i(0,1),t.Vector2d=i}(Joy),function(t){var i=function(t,i,e,n){this.red=t,this.green=i,this.blue=e,this.alpha=n};i.prototype.toString=function(){return this.green||this.blue?this.alpha?"rgba("+this.red+","+this.green+","+this.blue+","+this.alpha+")":"rgb("+this.red+","+this.green+","+this.blue+")":this.red},t.Color=i}(Joy),function(t){var i=t.Triggerable.extend({init:function(){this._super(),this.assets=[],this.loaded=0,Object.defineProperty(this,"percentage",{get:function(){return Math.round(100*(this.loaded/this.assets.length))},configurable:!0}),Object.defineProperty(this,"loading",{get:function(){return this.assets.length!==this.loaded},configurable:!0}),Object.defineProperty(this,"completed",{get:function(){return this.assets.length>0&&!this.loading},configurable:!0})},add:function(t){var i=this;this.assets.push(t),t.addEventListener("load",function(){i.loaded+=1,i.trigger("loadProgress"),i.loaded==i.assets.length&&i.trigger("loadComplete")})}});t.Loader=i}(Joy),function(t){var i=function(){};i.process=function(t,i){var e=t.getImageData(0,0,t.canvas.width,t.canvas.height);i.call(this,e),t.putImageData(e,0,0)};var e=[512,512,456,512,328,456,335,512,405,328,271,456,388,335,292,512,454,405,364,328,298,271,496,456,420,388,360,335,312,292,273,512,482,454,428,405,383,364,345,328,312,298,284,271,259,496,475,456,437,420,404,388,374,360,347,335,323,312,302,292,282,273,265,512,497,482,468,454,441,428,417,405,394,383,373,364,354,345,337,328,320,312,305,298,291,284,278,271,265,259,507,496,485,475,465,456,446,437,428,420,412,404,396,388,381,374,367,360,354,347,341,335,329,323,318,312,307,302,297,292,287,282,278,273,269,265,261,512,505,497,489,482,475,468,461,454,447,441,435,428,422,417,411,405,399,394,389,383,378,373,368,364,359,354,350,345,341,337,332,328,324,320,316,312,309,305,301,298,294,291,287,284,281,278,274,271,268,265,262,259,257,507,501,496,491,485,480,475,470,465,460,456,451,446,442,437,433,428,424,420,416,412,408,404,400,396,392,388,385,381,377,374,370,367,363,360,357,354,350,347,344,341,338,335,332,329,326,323,320,318,315,312,310,307,304,302,299,297,294,292,289,287,285,282,280,278,275,273,271,269,267,265,263,261,259],n=[9,11,12,13,13,14,14,15,15,15,15,16,16,16,16,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24];i.blur=function(t){var i,o,s,r,a,h,c,l,u,d,f,p,v,g,m,y,x,w,_,E,b,A=function(){this.r=0,this.g=0,this.b=0,this.a=0,this.next=null},T=t.data,O=5,S=t.width,C=t.height,I=O+O+1,P=S-1,M=C-1,D=O+1,N=D*(D+1)/2,L=new A,R=L;for(s=1;I>s;s++)R=R.next=new A,s==D&&(b=R);R.next=L;var k=null,J=null;c=h=0;var Y=e[O],U=n[O];for(o=0;C>o;o++){for(g=m=y=l=u=d=0,f=D*(x=T[h]),p=D*(w=T[h+1]),v=D*(_=T[h+2]),l+=N*x,u+=N*w,d+=N*_,R=L,s=0;D>s;s++)R.r=x,R.g=w,R.b=_,R=R.next;for(s=1;D>s;s++)r=h+((s>P?P:s)<<2),l+=(R.r=x=T[r])*(E=D-s),u+=(R.g=w=T[r+1])*E,d+=(R.b=_=T[r+2])*E,g+=x,m+=w,y+=_,R=R.next;for(k=L,J=b,i=0;S>i;i++)T[h]=l*Y>>U,T[h+1]=u*Y>>U,T[h+2]=d*Y>>U,l-=f,u-=p,d-=v,f-=k.r,p-=k.g,v-=k.b,r=c+(P>(r=i+O+1)?r:P)<<2,g+=k.r=T[r],m+=k.g=T[r+1],y+=k.b=T[r+2],l+=g,u+=m,d+=y,k=k.next,f+=x=J.r,p+=w=J.g,v+=_=J.b,g-=x,m-=w,y-=_,J=J.next,h+=4;c+=S}for(i=0;S>i;i++){for(m=y=g=u=d=l=0,h=i<<2,f=D*(x=T[h]),p=D*(w=T[h+1]),v=D*(_=T[h+2]),l+=N*x,u+=N*w,d+=N*_,R=L,s=0;D>s;s++)R.r=x,R.g=w,R.b=_,R=R.next;for(a=S,s=1;O>=s;s++)h=a+i<<2,l+=(R.r=x=T[h])*(E=D-s),u+=(R.g=w=T[h+1])*E,d+=(R.b=_=T[h+2])*E,g+=x,m+=w,y+=_,R=R.next,M>s&&(a+=S);for(h=i,k=L,J=b,o=0;C>o;o++)r=h<<2,T[r]=l*Y>>U,T[r+1]=u*Y>>U,T[r+2]=d*Y>>U,l-=f,u-=p,d-=v,f-=k.r,p-=k.g,v-=k.b,r=i+(M>(r=o+D)?r:M)*S<<2,l+=g+=k.r=T[r],u+=m+=k.g=T[r+1],d+=y+=k.b=T[r+2],k=k.next,f+=x=J.r,p+=w=J.g,v+=_=J.b,g-=x,m-=w,y-=_,J=J.next,h+=S}},i.noise=function(t){var i,e,n,o=0;for(i=0;t.width>i;++i)for(e=0;t.height>e;++e)n=.8*Math.random(),o=4*i+e*4*t.width,t.data[o]*=n,t.data[o+1]*=n,t.data[o+2]*=n},t.Shader=i}(Joy),function(t){t.Utils={applyFriction:function(i,e){return 0>i+e?i+e*t.deltaTime:i-e>0?i-e*t.deltaTime:0}}}(Joy),function(t){t.Engine.defaultSceneLoader=function(t){var i,e,n,o="data:image/png;base64,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",s={percentage:0},r=this;t.background("#000"),n=new Joy.Text({x:r.width/2,y:r.height/2,text:"0%",align:"center",font:"30pt Courier New, monospace",color:"#fff",alpha:0,baseline:Joy.Text.BASELINE.MIDDLE}).bind(Joy.Events.UPDATE,function(){var e=this;s.percentage!==t.loader.percentage&&(i&&i.stop(),s.percentage=t.loader.percentage,i=Joy.Tween({percentage:parseInt(e.text,10)},1e3).easing(Joy.TweenManager.Easing.Quadratic.Out).to({percentage:t.loader.percentage}).onUpdate(function(){e.text=parseInt(this.percentage,10)+"%"}).start())}),e=new Joy.Sprite(o).bind("load",function(){this.alpha=0,this.position.x=r.width/2,this.position.y=r.height/2,this.pivot.x+=this.width/2,this.pivot.y+=this.height/2,Joy.Tween(this.position).to({x:this.position.x-50}).easing(Joy.TweenManager.Easing.Quadratic.Out).start(),Joy.Tween(this,1e3).to({alpha:1}).easing(Joy.TweenManager.Easing.Quadratic.Out).start(),Joy.Tween(n,1e3).to({alpha:1}).easing(Joy.TweenManager.Easing.Quadratic.Out).start(),Joy.Tween(n.position,3e3).to({x:n.position.x+50}).easing(Joy.TweenManager.Easing.Quadratic.Out).start()}),t.addChild(e),t.addChild(n)}}(Joy),function(t){var i=t.Triggerable.extend({init:function(i){i||(i={}),this.id=i.id||Joy.generateUniqueId(),this.position=i.position||new t.Vector2d(i.x||0,i.y||0),Object.defineProperty(this,"collidePosition",{get:function(){var i=null!==this._parent?this._parent.collidePosition:new t.Vector2d;return i.sum(this.position).subtract(this.pivot)},configurable:!0}),this.pivot=i.pivot||new t.Vector2d(i.pivotX||0,i.pivotY||0),this.skew=i.skew||new t.Vector2d(i.skewX||0,i.skewY||0),this.scale=i.scale||new t.Vector2d(i.scaleX||1,i.scaleY||1),this.alpha=i.alpha===void 0?1:i.alpha,this.rotation=i.rotation||0,this.smooth=i.smooth===void 0?!0:i.smooth,this.destroyed=!1,this._width=i.width||0,this._height=i.height||0,Object.defineProperty(this,"collider",{get:function(){return this._collider},set:function(t){this._collider=t,this._collider.target=this},configurable:!0}),this._collider=i.collider||this,this.index=null,this.ctx=i.ctx||null,this._shadow=null,this._parent=null,this._visible=i.visible===void 0?!0:i.visible,this._matrix=t.Matrix2D.identity.clone(),this._collisionTargets=[],this._collisionActive={},this._hasContextOperations=!1,this._contextOperations={},Object.defineProperty(this,"parent",{get:function(){return this._parent},configurable:!0}),Object.defineProperty(this,"scene",{get:function(){for(var i=this._parent;!(i instanceof t.Scene)&&null!==i;)i=i&&i.parent||null;return i},configurable:!0}),Object.defineProperty(this,"visible",{get:function(){return this._visible&&this.alpha>0&&0!==this.scale.y&&0!==this.scale.y},set:function(t){this._visible=t},configurable:!0}),Object.defineProperty(this,"matrix",{get:function(){return this._matrix},configurable:!0}),Object.defineProperty(this,"width",{get:function(){return this._width*Math.abs(this.scale.x)},configurable:!0}),Object.defineProperty(this,"height",{get:function(){return this._height*Math.abs(this.scale.y)},configurable:!0}),Object.defineProperty(this,"right",{get:function(){return this.position.x+this.width},configurable:!0}),Object.defineProperty(this,"bottom",{get:function(){return this.position.y+this.height},configurable:!0}),this.flipX=i.flipX||!1,this.flipY=i.flipY||!1,this._super(i),this.collider&&this.bind(t.Events.UPDATE,this.checkCollisions)},setContext:function(t){this.ctx=t},destroy:function(){return this.destroyed=!0,this},setScale:function(t,i){this.scale.x=t,this.scale.y=i},allowCollisionFrom:function(i){i instanceof t.DisplayObject&&(i=[i]);for(var e=0,n=i.length;n>e;++e)this._collisionTargets.push(i[e]);return this},translate:function(t,i){return this._hasContextOperations=!0,this._contextOperations.translate=[t,i],this},rotate:function(t){this.rotation=t},transform:function(t,i,e,n,o,s){return this._contextOperations.transform=[t,i,e,n,o,s],this},composite:function(t){return this.compositeOperation=t,this},fillStyle:function(t){return this._hasContextOperations=!0,this._contextOperations.fillStyle=""+t,this},fillRect:function(t,i,e,n){return this._hasContextOperations=!0,this._contextOperations.fillRect=[t,i,e,n],this},shadow:function(t){return this._shadow=t?{color:t.color||"#000",offsetX:t.offsetX||0,offsetY:t.offsetY||0,blur:t.blur||1}:null,this},updateContext:function(){var i={};i[!1]=-1,i[!0]=1;var e=this._matrix.identity().appendTransform(this.position.x+this.width*(this.flipX+0),this.position.y+this.height*(this.flipY+0),this.scale.x*i[!this.flipX],this.scale.y*i[!this.flipY],this.rotation,this.skew.x,this.skew.y,this.pivot.x,this.pivot.y);this.ctx.transform(e.m11,e.m12,e.m21,e.m22,e.dx,e.dy),this.ctx.globalAlpha*=this.alpha,this.compositeOperation&&(this.ctx.globalCompositeOperation=this.compositeOperation),this.ctx[t.Support.imageSmoothingEnabled]=this.smooth,this._shadow&&(this.ctx.shadowColor=this._shadow.color,this.ctx.shadowOffsetX=this._shadow.offsetX,this.ctx.shadowOffsetY=this._shadow.offsetY,this.ctx.shadowBlur=this._shadow.blur)},collide:function(t){return!(this.collidePosition.x>=t.collidePosition.x+t.width||t.collidePosition.x>=this.collidePosition.x+this.width||this.collidePosition.y>=t.collidePosition.y+t.height||t.collidePosition.y>=this.collidePosition.y+this.height)},checkCollisions:function(){var i,e=this._collisionTargets.length;if(0!==e){void 0!==this.collider.updateColliderPosition&&this.collider.updateColliderPosition(this.position),t.debug&&this.collider.renderStroke(this.ctx);for(var n=0;e>n;++n)i=this._collisionTargets[n].collider,i.collide(this.collider)?(this._collisionActive[i.id]||(this.trigger(t.Events.COLLISION_ENTER,[this._collisionTargets[n]]),this._collisionActive[i.id]=!0),this.trigger(t.Events.COLLISION,[this._collisionTargets[n]])):this._collisionActive[i.id]&&(delete this._collisionActive[i.id],this.trigger(t.Events.COLLISION_EXIT,[this._collisionTargets[n]]))}},willCollideAt:function(i){var e=new t.RectCollider(this.collider.position.clone().sum(i),1,1),n=this._collisionTargets.length;if(0!==n){e.updateColliderPosition(this.position);for(var o=0;n>o;++o)if(this._collisionTargets[o].collider.collide(e))return this._collisionTargets[o];return null}},render:function(){if(this.destroyed&&this.parent)return this.parent.removeChild(this),void 0;if(this._hasContextOperations)for(var t in this._contextOperations)this._contextOperations[t]instanceof Array?this.ctx[t].apply(this.ctx,this._contextOperations[t]):this.ctx[t]=this._contextOperations[t]},renderStroke:function(t){t.strokeStyle="red",t.strokeRect(this.collidePosition.x,this.collidePosition.y,this.width,this.height)},getMatrix:function(){return this._matrix.clone()},getBounds:function(){return new t.Rect(this.position.x,this.position.y,this.width,this.height)}});t.DisplayObject=i}(Joy),function(t){var i=t.DisplayObject.extend({init:function(t){if(t||(t={}),this.children=[],Object.defineProperty(this,"numChildren",{get:function(){return this.children.length},configurable:!0}),Object.defineProperty(this,"width",{get:function(){for(var t=0,i=0,e=this.children.length;e>i;++i)this.children[i].width>t&&(t=this.children[i].width);return t},configurable:!0}),Object.defineProperty(this,"height",{get:function(){for(var t=0,i=0,e=this.children.length;e>i;++i)this.children[i].height>t&&(t=this.children[i].height);return t},configurable:!0}),this._super(t),t.children)for(var i=0,e=t.children.length;e>i;++i)this.addChild(t.children[i])},setContext:function(t){this.ctx=t;for(var i=0,e=this.children.length;e>i;++i)this.children[i].setContext(t)},render:function(){this.visible&&(this.ctx.save(),this.updateContext(),this._super(),this.renderChildren(),this.ctx.restore())},renderChildren:function(){for(var i=0,e=this.children.length;e>i;++i)this.children[i].visible&&(this.ctx.save(),this.children[i].updateContext(),this.children[i].render(),this.children[i].trigger("update"),this.ctx.restore(),t.debug&&this.children[i].collider.renderStroke(this.ctx))},broadcast:function(t,i){this.trigger(t,i);for(var e=0,n=this.children.length;n>e;++e)this.children[e].trigger(t,i)},swapChildren:function(t,i){if(t.parent!==i.parent)throw Error("DisplayObject must be at same level to swap.");var e=t.index;return this.children[e]=i,this.children[i.index]=t,t.index=i.index,i.index=e,this},addChild:function(i){return i.setContext(this.ctx),i.index=this.children.push(i)-1,i._parent=this,i.scene&&i.broadcast(t.Events.ADDED,[this]),this},getChildById:function(t){for(var i=0,e=this.children.length;e>i;++i)if(this.children[i].id==t)return this.children[i]},getChildAt:function(t){return this.children[t]},removeChild:function(t){var i=this.children.indexOf(t);return-1!==i&&this.removeChildAt(i),this},removeChildAt:function(i){var e=this.children.splice(i,1)[0];return e.trigger(t.Events.REMOVED,[this]),this}});t.DisplayObjectContainer=i}(Joy),function(t){t.Object.extend({init:function(){}})}(Joy),function(t){var i=t.DisplayObjectContainer.extend({init:function(i){this._super(i),this.viewport=i.viewport||null,this.distance=i.distance||1,this.velocity=i.velocity||1,this.bind(t.Events.ADDED,this._setup)},_setup:function(i){if(!(i instanceof t.Scene))throw Error("'Parallax' instance must be added into a 'Scene'.");this.viewport=i.viewport;var e=this;this.viewport.bind("setup",function(){var t,i,n,o;for(t=0,i=e.numChildren;i>t;++t)if(e.getChildAt(t).position){for(n=e.getChildAt(t);n.numChildren>0;)n.removeChildAt(0);for(var s=0,r=Math.ceil(n.width/this.width)-1;r>s;++s)o=n.clone(),o.children=[],o.position.x=n.width,n.addChild(o)}}),this.viewport.bind("translate",function(){for(var t=e.distance,i=0,n=e.numChildren;n>i;++i)t*=e.velocity*(i+1),e.getChildAt(i).position&&(e.getChildAt(i).position.x+=this.translation.x*t/this.width,e.getChildAt(i).position.y+=this.translation.y*t/(this.height/2))})}});t.Parallax=i}(Joy),function(t){var i=t.DisplayObject.extend({init:function(i){this._super(i),this.emit=i.emit===void 0?!0:i.emit,this.sources=i.source!==void 0?[i.source]:i.sources,this.emission=i.emission!==void 0?new t.Range(i.emission):new t.Range(1,5),this.ease=i.ease||t.TweenManager.Easing.Linear,this.start=i.start||{},this.end=i.end||{},this.particleLifetime=i.particleLifetime!==void 0?new t.Range(i.particleLifetime):new t.Range(1,2),Object.defineProperty(this,"lifetime",{get:function(){return this._lifetime},set:function(i){this._lifetime=(i!==void 0?new t.Range(i):new t.Range(-1)).random()},configurable:!0}),this.lifetime=i.lifetime||1/0,this._ttl=1/0,this.bind(t.Events.ADDED,function(){for(var i=0,e=this.sources.length;e>i;i++)this.sources[i].trigger(t.Events.ADDED)}),this.bind(t.Events.SCENE_ACTIVE,this._activate)},_activate:function(){this._ttl=Date.now()+1e3*this.lifetime},_emit:function(i){for(var e,n=0;i>n;n+=1)e=this.sources[t.Range.randomInt(0,this.sources.length-1)].clone(),e.behave("Particle",{emitter:this,ease:this.ease,start:this.start,end:this.end,ttl:this.particleLifetime.random()}),this.parent.addChild(e);return this},render:function(){this._super(),!this.emit||Date.now()>this._ttl||this._emit(1)}});t.ParticleEmitter=i}(Joy),function(t){var i=t.DisplayObjectContainer.extend({init:function(i){i||(i={}),i.visible===void 0&&(i.visible=!1),this._super(i),this.loader=i.loader===void 0?new t.Loader:i.loader,this.paused=!1,this.shaders=[],this.viewport=i.viewport||new t.Viewport({scene:this})},background:function(i){return this.fillStyle(""+i),this.fillRect(0,0,this.width||t.currentEngine.width,this.height||t.currentEngine.height),this},pause:function(i){return i=i||{},i.blur&&(this.render(),t.Shader.process(this.ctx,t.Shader.blur,i.blur)),this.paused=!0,this.trigger("pause"),this},updateContext:function(){this._super(),this.viewport.follow&&this.viewport.updateContext()},render:function(){if(!this.paused&&(this.updateContext(),this._super(),this.viewport.render(),this.shaders.length>0))for(var i=0,e=this.shaders.length;e>i;++i)t.Shader.process(this.ctx,this.shaders[i][0],this.shaders[i][1])},broadcast:function(t,i){this.viewport.broadcast(t,i),this._super(t,i)},fadeOut:function(i,e){var n=this,o=new t.Rect({width:this.viewport.width,height:this.viewport.height,color:e,alpha:0});n.trigger("fadeOutStart"),this.viewport.addHud(o);var s=setInterval(function(){o.alpha+=1e3/i/60*t.deltaTime,o.alpha>=1&&(clearInterval(s),n.viewport.hud.removeChild(o),n.trigger("fadeOutComplete"))},1);return this},fadeIn:function(i,e){var n=this,o=new t.Rect({width:this.viewport.width,height:this.viewport.height,color:e,alpha:1});n.trigger("fadeInStart"),this.viewport.addHud(o);var s=setInterval(function(){o.alpha-=1e3/i/60*t.deltaTime,0>=o.alpha&&(clearInterval(s),n.viewport.hud.removeChild(o),n.trigger("fadeInComplete"))},1e3/60);return this},addShader:function(t,i){return this.shaders.push([t,i]),this}});t.Scene=i}(Joy),function(t){var i=t.DisplayObjectContainer.extend({init:function(i){"string"==typeof i&&(i={src:i}),this.image=i.image||new Image,i.width=this.image.width||i.width,i.height=this.image.height||i.height,this._super(i),this.bind(t.Events.ADDED,function(){i.src&&this.load(i.src)
})},load:function(t){var i=this;this.scene&&this.scene.loader&&!this.scene.loader.completed&&this.scene.loader.add(this.image),this.image.addEventListener("load",function(){i.onLoad(),i.trigger("load")}),this.image.src=t},onLoad:function(){this._width||(this._width=this.image.width),this._height||(this._height=this.image.height)},render:function(){this.visible&&(this.ctx.drawImage(this.image,0,0,this._width,this._height),this.renderChildren())},clone:function(){var i=new t.Sprite(this);return this.position=this.position.clone(),this.scale=this.scale.clone(),this.pivot=this.pivot.clone(),this.skew=this.skew.clone(),i}});t.Sprite=i}(Joy),function(t){var i=function(t){this.parent=t.parent,this.name=t.name,this.framesPerSecond=t.framesPerSecond,this.frames=t.frames,this.firstFrame=this.frames[0],this.lastFrame=lastFrame=this.frames[1]||this.frames[0],this.currentFrame=0};i.prototype.start=function(){this.currentFrame=this.firstFrame;var t=this;this._interval=setInterval(function(){t.update()},1e3/this.framesPerSecond)},i.prototype.stop=function(){return this._interval&&clearInterval(this._interval),this},i.prototype.update=function(){this.currentFrame==this.lastFrame?(this.currentFrame=this.firstFrame,this.parent.trigger("animationStart")):(this.currentFrame=this.currentFrame+1,this.currentFrame==this.lastFrame&&this.parent.trigger("animationEnd"))},t.SpriteAnimation=i}(Joy),function(t){var i=t.Sprite.extend({init:function(t){if(this._super(t),this.animations={length:0},this._frequencyInterval=null,this.frames=1,this.framesPerSecond=t.framesPerSecond||t.fps||24,t.animations)for(var i in t.animations)this.addAnimation(i,t.animations[i]);this.currentAnimationName="all",Object.defineProperty(this,"fps",{get:function(){return this.framesPerSecond},configurable:!0}),Object.defineProperty(this,"currentAnimation",{get:function(){return this.animations[this.currentAnimationName]},configurable:!0})},addAnimation:function(i,e){return this.animations[i]=new t.SpriteAnimation({parent:this,name:i,frames:e instanceof Array?e:e.frames,framesPerSecond:e.framesPerSecond||this.framesPerSecond}),this.animations.length=(this.animations.length||0)+1,this},onLoad:function(){this._super();var t=1;this._width<this.image.width&&(t=this._columns=Math.ceil(this.image.width/this._width)),this._height<this.image.height&&(t*=this._rows=Math.ceil(this.image.height/this._height)),this.addAnimation("all",[0,t-1]),(0===this.animations.length||null===this.currentAnimation)&&this.play("all")},play:function(t){if(this.currentAnimationName!=t){if(this.currentAnimation&&this.currentAnimation.stop(),this.currentAnimationName=t,!this.animations[t])throw Error("Animation '"+t+"' not found on '"+this.id+"'");this.animations[t].start()}return this},stop:function(){this.currentAnimation.stop()},render:function(){this.visible&&this.ctx.drawImage(this.image,this._width*(this.currentAnimation.currentFrame%this._columns),this._height*(this.currentAnimation.currentFrame/this._columns>>0),this._width,this._height,0,0,this._width,this._height)}});t.SpriteSheet=i}(Joy),function(t){var i={TOP:"top",HANGING:"hanging",MIDDLE:"middle",ALPHABETIC:"alphabetic",IDEOGRAPHIC:"ideographic",BOTTOM:"bottom"},e="Normal 12px Verdana",n="#000000",o="left",s=i.TOP,r=t.DisplayObject.extend({init:function(t){t===void 0&&(t={}),this._super(t),this.text=t.text||"",this.font=t.font||e,this.align=t.align||o,this.baseline=t.baseline||s,this._color=t.color||n,Object.defineProperty(this,"color",{get:function(){return this._color},set:function(t){this._color=""+t},configurable:!0}),t.stroke?this.useStroke():this.useFill()},useStroke:function(){this.stroke=!0,this.fillMethod="strokeText",this.styleMethod="strokeStyle"},useFill:function(){this.stroke=!1,this.fillMethod="fillText",this.styleMethod="fillStyle"},updateContext:function(){this._super(),this.ctx.font=this.font,this.ctx.textAlign=this.align,this.ctx.textBaseline=this.baseline,this.ctx[this.styleMethod]=this.color,this.ctx[this.fillMethod](this.text,0,0)},getMeasure:function(){return this.ctx.measureText(this.text)}});r.BASELINE=i,t.Text=r}(Joy),function(t){var i=t.DisplayObjectContainer.extend({init:function(i){if(!(i.tileset instanceof t.Tileset))throw Error("'tileset' must be given on Tilemap constructor, as Sprite instance.");this._super(i),this.tileset=i.tileset,this.lines=i.lines||1,this.columns=i.columns||1,Object.defineProperty(this,"data",{get:function(){return this._data},set:function(i){this._data=i,(this.collider==this||this.collider instanceof t.TilemapCollider)&&(this.collider=new t.TilemapCollider(this))},configurable:!0}),this.data=i.data,Object.defineProperty(this,"height",{get:function(){return this.lines*this.tileset.tileHeight},configurable:!0}),Object.defineProperty(this,"width",{get:function(){return this.columns*this.tileset.tileWidth},configurable:!0}),this.bind(t.Events.ADDED,function(){this.tileset.trigger(t.Events.ADDED)})},renderChildren:function(){for(var t=0,i=this.data.length;i>t;++t)0!==this.data[t]&&this.ctx.drawImage(this.tileset.image,this.tileset.tileWidth*((this.data[t]-1)%this.tileset.columns),this.tileset.tileHeight*((this.data[t]-1)/this.tileset.columns>>0),this.tileset.tileWidth,this.tileset.tileHeight,this.tileset.tileWidth*(t%this.columns),this.tileset.tileHeight*(t/this.columns>>0),this.tileset.tileWidth,this.tileset.tileHeight)}});t.Tilemap=i}(Joy),function(t){var i=t.Sprite.extend({init:function(t){this.tileWidth=t.width,this.tileHeight=t.height,delete t.width,delete t.height,this._super(t)},onLoad:function(){this._super(),this.columns=this._width/this.tileWidth>>0,this.lines=this._height/this.tileHeight>>0}});t.Tileset=i}(Joy),function(t){var i=t.Triggerable.extend({init:function(i){this._super(i),this.id=i.id||Joy.generateUniqueId(),this.position=new t.Vector2d,this._lastPosition=new t.Vector2d,this.translation=new t.Vector2d,i.scene&&(this.scene=i.scene,this.ctx=this.scene.ctx),this.hud=new t.DisplayObjectContainer({id:this.id+"_HUD",ctx:this.ctx}),this.hud.position=this.position,this.active=!0,this._translationTotal=new t.Vector2d,this.setup(i)},addHud:function(t){return this.hud.addChild(t)},setup:function(i){this.width=i.width||this.scene.ctx.canvas.width,this.height=i.height||this.scene.ctx.canvas.height,i.follow&&(this.follow=i.follow),this.scale=new t.Vector2d(1,1),this.bind(t.Events.SCENE_ACTIVE,function(){this.width&&this.height&&this.setSize(this.width,this.height),this.trigger("setup")})},setSize:function(t,i){return this.reset(),this.width=t,this.height=i,this.ctx.scale(this.ctx.canvas.width/this.width*this.scale.x,this.ctx.canvas.height/this.height*this.scale.y),this.scale.x=this.width/this.ctx.canvas.width,this.scale.y=this.height/this.ctx.canvas.height,this},setDeadzone:function(i,e){return this.deadzone=new t.Vector2d(i,e),this},updateContext:function(){this.width/2,this.height/2,this.position.x=~~(this.follow.position.x+this.follow.width/2-this.width/2),this.position.y=~~(this.follow.position.y+this.follow.height/2-this.height/2),this.translation.x=-this.position.x+this._lastPosition.x,this.translation.y=-this.position.y+this._lastPosition.y,this._translationTotal.sum(this.translation),this.active&&(this.trigger("translate"),this.ctx.translate(this.translation.x,this.translation.y)),this._lastPosition.x=this.position.x,this._lastPosition.y=this.position.y},render:function(){this.hud.render()},reset:function(){return this.translation.x=-this._translationTotal.x,this.translation.y=-this._translationTotal.y,this.ctx.translate(this.translation.x,this.translation.y),this.trigger("translate"),this._translationTotal.set(0,0),this._lastPosition.set(0,0),this}});t.Viewport=i}(Joy),function(t){var i=t.DisplayObject.extend({init:function(t){this._super(t),this.radius=t.radius||1,this.color=t.color||"#000",Object.defineProperty(this,"width",{get:function(){return 2*this.radius*this.scale.x},configurable:!0}),Object.defineProperty(this,"height",{get:function(){return 2*this.radius*this.scale.y},configurable:!0})},render:function(){this.ctx.beginPath(),this.ctx.arc(this.radius,this.radius,this.radius,0,2*Math.PI),this.ctx.fillStyle=this.color,this.ctx.fill()}});t.Circle=i}(Joy),function(t){var i=t.DisplayObject.extend({init:function(t){this._super(t),t.color&&this.colorize(t.color)},colorize:function(t){return this.color=""+t,this},render:function(){this.color&&(this.ctx.fillStyle=this.color),this.ctx.fillRect(0,0,this._width,this._height)}});t.Rect=i}(Joy),/*!
 *  howler.js v1.0.1
 *  howlerjs.com
 *
 *  (c) 2013, James Simpson of GoldFire Studios
 *  goldfirestudios.com
 *
 *  MIT License
 */
function(){var t={},i=null,e=!0;if("undefined"!=typeof AudioContext?i=new AudioContext:"undefined"!=typeof webkitAudioContext?i=new webkitAudioContext:e=!1,e){var n=i.createGainNode();n.gain.value=1,n.connect(i.destination)}var o=function(){this._volume=1};o.prototype={volume:function(i){var o=this;if(i>=0&&1>=i){o._volume=i,e&&(n.gain.value=i);for(var s in t)if(t.hasOwnProperty(s)&&t[s]._webAudio===!1)for(var r=0;t[s]._audioNode.length>r;r++)t[s]._audioNode[r].volume=t[s]._volume*o._volume;return o}return e?n.gain.value:o._volume},mute:function(){e&&(n.gain.value=0);for(var i in t)if(t.hasOwnProperty(i)&&t[i]._webAudio===!1)for(var o=0;t[i]._audioNode.length>o;o++)t[i]._audioNode[o].volume=0;return self},unmute:function(){var i=this;e&&(n.gain.value=i._volume);for(var o in t)if(t.hasOwnProperty(o)&&t[o]._webAudio===!1)for(var s=0;t[o]._audioNode.length>s;s++)t[o]._audioNode[s].volume=t[o]._volume*i._volume;return i}},window.Howler=new o;var s=new Audio,r={mp3:!!s.canPlayType("audio/mpeg;").replace(/^no$/,""),ogg:!!s.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/,""),wav:!!s.canPlayType('audio/wav; codecs="1"').replace(/^no$/,""),m4a:!!(s.canPlayType("audio/x-m4a;")||s.canPlayType("audio/aac;")).replace(/^no$/,"")};s=null;var a=window.Howl=function(t){var o=this;o._autoplay=t.autoplay||!1,o._buffer=t.buffer||!1,o._duration=t.duration||0,o._loop=t.loop||!1,o._loaded=!1,o._sprite=t.sprite||{},o._src=t.src||"",o._pos=t.pos||0,o._volume=t.volume||1,o._urls=t.urls||[],o._onload=[t.onload||function(){}],o._onend=[t.onend||function(){}],o._onpause=[t.onpause||function(){}],o._onendTimer=[],o._webAudio=e&&!o._buffer,o._webAudio?(o._gainNode=i.createGainNode(),o._gainNode.gain.value=o._volume,o._gainNode.connect(n)):o._audioNode=[],o.load()};if(a.prototype={load:function(){for(var i=this,e=null,n=0;i._urls.length>n;n++){var o=i._urls[n].toLowerCase().match(/.+\.([^?]+)(\?|$)/)[1],s=!1;switch(o){case"mp3":s=r.mp3;break;case"ogg":s=r.ogg;break;case"wav":s=r.wav;break;case"m4a":s=r.m4a}if(s===!0){e=i._urls[n];break}}if(e){if(i._src=e,i._webAudio)h(i,e);else{var a=new Audio;i._audioNode.push(a),a.src=e,a.preload="auto",a.volume=i._volume;var c=function(){i._duration=a.duration,i._loaded=!0,i.on("load"),i._autoplay&&i.play(),t[e]=i,a.removeEventListener("canplaythrough",c,!1)};a.addEventListener("canplaythrough",c,!1),a.load()}return i}},urls:function(t){var i=this;return t?(i._urls=t,i.stop(),i.load(),i):i._urls},play:function(t){var e=this;if(!e._loaded)return e.on("load",function(){e.play(t)}),e;if(t&&!e._sprite[t])return e;var n=t?e._sprite[t][0]/1e3:e._pos,o=t?e._sprite[t][1]/1e3:e._duration-n,s=Date.now()+"";return function(){var i={id:s,sprite:t};e._onendTimer.push(setTimeout(function(){e._loop&&e.stop().play(t),e._webAudio||e.pause(i.id),e.on("end")},1e3*o))}(),e._webAudio?(l(e),e._playStart=i.currentTime,e.bufferSource.noteGrainOn(0,n,o)):e.inactiveNode(function(t){t.id=s,t.currentTime=n,t.play()}),e},pause:function(t){var e=this;if(!e._loaded)return e.on("load",function(){e.pause(t)}),e;if(e._onendTimer[0]&&(clearTimeout(e._onendTimer[0]),e._onendTimer.splice(0,1)),e._webAudio){if(!e.bufferSource)return e;e._pos+=i.currentTime-e._playStart,e.bufferSource.noteOff(0)}else{var n=t?e.nodeById(t):e.activeNode();n&&(e._pos=n.currentTime,n.pause())}return e.on("pause"),e},stop:function(){var t=this;if(t._pos=0,!t._loaded)return t.on("load",function(){t.stop()}),t;if(t._onendTimer[0]&&(clearTimeout(t._onendTimer[0]),t._onendTimer.splice(0,1)),t._webAudio){if(!t.bufferSource)return t;t.bufferSource.noteOff(0)}else{var i=t.activeNode();i&&(i.pause(),i.currentTime=0)}return t},mute:function(){var t=this;if(!t._loaded)return t.on("load",function(){t.mute()}),t;if(t._webAudio)t._gainNode.gain.value=0;else{var i=t.activeNode();i&&(i.volume=0)}return t},unmute:function(){var t=this;if(!t._loaded)return t.on("load",function(){t.unmute()}),t;if(t._webAudio)t._gainNode.gain.value=t._volume;else{var i=t.activeNode();i&&(i.volume=t._volume)}return t},volume:function(t){var i=this;if(!i._loaded)return i.on("load",function(){i.volume(t)}),i;if(t>=0&&1>=t){if(i._volume=t,i._webAudio)i._gainNode.gain.value=t;else{var e=i.activeNode();e&&(e.volume=t*a.volume())}return i}return i._volume},loop:function(t){var i=this;return"boolean"==typeof t?(i._loop=t,i):i._loop},sprite:function(t){var i=this;return"object"==typeof t?(i._sprite=t,i):i._sprite},pos:function(t){var e=this;if(!e._loaded)return e.on("load",function(){e.pos(t)}),e;if(e._webAudio)return t>=0?(e._pos=t,e.pause().play(),e):e._pos+(i.currentTime-e._playStart);var n=e.activeNode();return n?t>=0?(n.currentTime=t,e):n.currentTime:e},fadeIn:function(t,i,e){var n=this,o=t,s=o/.01,r=i/s;if(!n._loaded)return n.on("load",function(){n.fadeIn(t,i,e)}),n;n.volume(0).play();for(var a=1;s>=a;a++)(function(){var i=n._volume+.01*a,o=t;setTimeout(function(){n.volume(i),i===o&&e&&e()},r*a)})();return n},fadeOut:function(t,i,e){var n=this,o=n._volume-t,s=o/.01,r=i/s;if(!n._loaded)return n.on("load",function(){n.fadeOut(t,i,e)}),n;for(var a=1;s>=a;a++)(function(){var i=n._volume-.01*a,o=t;setTimeout(function(){n.volume(i),i===o&&(e&&e(),n.pause())},r*a)})();return n},nodeById:function(t){for(var i=this,e=null,n=0;i._audioNode.length>n;n++)if(i._audioNode[n].id===t){e=i._audioNode[n];break}return e},activeNode:function(){for(var t=this,i=null,e=0;t._audioNode.length>e;e++)if(!t._audioNode[e].paused){i=t._audioNode[e];break}return t.drainPool(),i},inactiveNode:function(t){for(var i=this,e=null,n=0;i._audioNode.length>n;n++)if(i._audioNode[n].paused){t(i._audioNode[n]),e=!0;break}if(i.drainPool(),!e){i.load();var o=i._audioNode[i._audioNode.length-1];o.addEventListener("loadedmetadata",function(){t(o)})}},drainPool:function(){var t,i=this,e=0;for(t=0;i._audioNode.length>t;t++)i._audioNode[t].paused&&e++;for(t=0;i._audioNode.length>t&&!(5>=e);t++)i._audioNode[t].paused&&(e--,i._audioNode.splice(t,1))},on:function(t,i){var e=this,n=e["_on"+t];if(i)n.push(i);else for(var o=0;n.length>o;o++)n[o].call()}},e)var h=function(e,n){if(n in t)c(e);else{var o=new XMLHttpRequest;o.open("GET",n,!0),o.responseType="arraybuffer",o.onload=function(){i.decodeAudioData(o.response,function(i){i&&(t[n]=i,c(e,i))})},o.send()}},c=function(t,i){t._duration=i?i.duration:t._duration,t._loaded=!0,t.on("load"),t._autoplay&&t.play()},l=function(e){e.bufferSource=i.createBufferSource(),e.bufferSource.buffer=t[e._src],e.bufferSource.connect(e._gainNode),e.bufferSource.loop=e._loop}}(),void 0===Date.now&&(Date.now=function(){return(new Date).valueOf()});var TWEEN=TWEEN||function(){var t=[];return{REVISION:"8",getAll:function(){return t},removeAll:function(){t=[]},add:function(i){t.push(i)},remove:function(i){var e=t.indexOf(i);-1!==e&&t.splice(e,1)},update:function(i){if(0===t.length)return!1;var e=0,n=t.length;for(i=void 0!==i?i:Date.now();n>e;)t[e].update(i)?e++:(t.splice(e,1),n--);return!0}}}();TWEEN.Tween=function(t){var i=t,e={},n={},o=1e3,s=0,r=null,a=TWEEN.Easing.Linear.None,h=TWEEN.Interpolation.Linear,c=[],l=null,u=!1,d=null,f=null;this.to=function(t,i){return void 0!==i&&(o=i),n=t,this},this.start=function(t){TWEEN.add(this),u=!1,r=void 0!==t?t:Date.now(),r+=s;for(var o in n)if(null!==i[o]&&o in i){if(n[o]instanceof Array){if(0===n[o].length)continue;n[o]=[i[o]].concat(n[o])}e[o]=i[o]}return this},this.stop=function(){return TWEEN.remove(this),this},this.delay=function(t){return s=t,this},this.easing=function(t){return a=t,this},this.interpolation=function(t){return h=t,this},this.chain=function(){return c=arguments,this},this.onStart=function(t){return l=t,this},this.onUpdate=function(t){return d=t,this},this.onComplete=function(t){return f=t,this},this.update=function(t){if(r>t)return!0;u===!1&&(null!==l&&l.call(i),u=!0);var s=(t-r)/o;s=s>1?1:s;var p=a(s);for(var v in e){var g=e[v],m=n[v];i[v]=m instanceof Array?h(m,p):g+(m-g)*p}if(null!==d&&d.call(i,p),1==s){null!==f&&f.call(i);for(var y=0,x=c.length;x>y;y++)c[y].start(t);return!1}return!0}},TWEEN.Easing={Linear:{None:function(t){return t}},Quadratic:{In:function(t){return t*t},Out:function(t){return t*(2-t)},InOut:function(t){return 1>(t*=2)?.5*t*t:-.5*(--t*(t-2)-1)}},Cubic:{In:function(t){return t*t*t},Out:function(t){return--t*t*t+1},InOut:function(t){return 1>(t*=2)?.5*t*t*t:.5*((t-=2)*t*t+2)}},Quartic:{In:function(t){return t*t*t*t},Out:function(t){return 1- --t*t*t*t},InOut:function(t){return 1>(t*=2)?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)}},Quintic:{In:function(t){return t*t*t*t*t},Out:function(t){return--t*t*t*t*t+1},InOut:function(t){return 1>(t*=2)?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)}},Sinusoidal:{In:function(t){return 1-Math.cos(t*Math.PI/2)},Out:function(t){return Math.sin(t*Math.PI/2)},InOut:function(t){return.5*(1-Math.cos(Math.PI*t))}},Exponential:{In:function(t){return 0===t?0:Math.pow(1024,t-1)},Out:function(t){return 1===t?1:1-Math.pow(2,-10*t)},InOut:function(t){return 0===t?0:1===t?1:1>(t*=2)?.5*Math.pow(1024,t-1):.5*(-Math.pow(2,-10*(t-1))+2)}},Circular:{In:function(t){return 1-Math.sqrt(1-t*t)},Out:function(t){return Math.sqrt(1- --t*t)},InOut:function(t){return 1>(t*=2)?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)}},Elastic:{In:function(t){var i,e=.1,n=.4;return 0===t?0:1===t?1:(!e||1>e?(e=1,i=n/4):i=n*Math.asin(1/e)/(2*Math.PI),-(e*Math.pow(2,10*(t-=1))*Math.sin((t-i)*2*Math.PI/n)))},Out:function(t){var i,e=.1,n=.4;return 0===t?0:1===t?1:(!e||1>e?(e=1,i=n/4):i=n*Math.asin(1/e)/(2*Math.PI),e*Math.pow(2,-10*t)*Math.sin((t-i)*2*Math.PI/n)+1)},InOut:function(t){var i,e=.1,n=.4;return 0===t?0:1===t?1:(!e||1>e?(e=1,i=n/4):i=n*Math.asin(1/e)/(2*Math.PI),1>(t*=2)?-.5*e*Math.pow(2,10*(t-=1))*Math.sin((t-i)*2*Math.PI/n):.5*e*Math.pow(2,-10*(t-=1))*Math.sin((t-i)*2*Math.PI/n)+1)}},Back:{In:function(t){var i=1.70158;return t*t*((i+1)*t-i)},Out:function(t){var i=1.70158;return--t*t*((i+1)*t+i)+1},InOut:function(t){var i=2.5949095;return 1>(t*=2)?.5*t*t*((i+1)*t-i):.5*((t-=2)*t*((i+1)*t+i)+2)}},Bounce:{In:function(t){return 1-TWEEN.Easing.Bounce.Out(1-t)},Out:function(t){return 1/2.75>t?7.5625*t*t:2/2.75>t?7.5625*(t-=1.5/2.75)*t+.75:2.5/2.75>t?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},InOut:function(t){return.5>t?.5*TWEEN.Easing.Bounce.In(2*t):.5*TWEEN.Easing.Bounce.Out(2*t-1)+.5}}},TWEEN.Interpolation={Linear:function(t,i){var e=t.length-1,n=e*i,o=Math.floor(n),s=TWEEN.Interpolation.Utils.Linear;return 0>i?s(t[0],t[1],n):i>1?s(t[e],t[e-1],e-n):s(t[o],t[o+1>e?e:o+1],n-o)},Bezier:function(t,i){var e,n=0,o=t.length-1,s=Math.pow,r=TWEEN.Interpolation.Utils.Bernstein;for(e=0;o>=e;e++)n+=s(1-i,o-e)*s(i,e)*t[e]*r(o,e);return n},CatmullRom:function(t,i){var e=t.length-1,n=e*i,o=Math.floor(n),s=TWEEN.Interpolation.Utils.CatmullRom;return t[0]===t[e]?(0>i&&(o=Math.floor(n=e*(1+i))),s(t[(o-1+e)%e],t[o],t[(o+1)%e],t[(o+2)%e],n-o)):0>i?t[0]-(s(t[0],t[0],t[1],t[1],-n)-t[0]):i>1?t[e]-(s(t[e],t[e],t[e-1],t[e-1],n-e)-t[e]):s(t[o?o-1:0],t[o],t[o+1>e?e:o+1],t[o+2>e?e:o+2],n-o)},Utils:{Linear:function(t,i,e){return(i-t)*e+t},Bernstein:function(t,i){var e=TWEEN.Interpolation.Utils.Factorial;return e(t)/e(i)/e(t-i)},Factorial:function(){var t=[1];return function(i){var e,n=1;if(t[i])return t[i];for(e=i;e>1;e--)n*=e;return t[i]=n}}(),CatmullRom:function(t,i,e,n,o){var s=.5*(e-t),r=.5*(n-i),a=o*o,h=o*a;return(2*i-2*e+s+r)*h+(-3*i+3*e-2*s-r)*a+s*o+i}}},function(t){t.Sound=Howl}(Joy),function(t){t.TweenManager=TWEEN,t.Tween=function(t,i){return new TWEEN.Tween(t,i)}}(Joy),function(t){var i=t.Object.extend({});i.behaviours={},i.define=function(t,e){return this.behaviours[t]=i.extend(e),this.behaviours[t].id=t,this.behaviours[name]},i.get=function(t){return this.behaviours[t]},Joy.Behaviour=i}(Joy),function(t){t.Behaviour.define("Button",{INIT:function(){this.isOver=!1},UPDATE:function(){var i=t.Mouse.isOver(this);i&&!this.isOver?this.trigger(t.Events.MOUSE_OVER):!i&&this.isOver&&this.trigger(t.Events.MOUSE_OUT),this.isOver=i}})}(Joy),function(t){t.Behaviour.Movimentation=t.Behaviour.define("Movimentation",{INIT:function(){this.velocity=new t.Vector2d,this.maxVelocity=new t.Vector2d(500,500),Object.defineProperty(this,"direction",{get:function(){return this.velocity.normalized},configurable:!0}),this.acceleration=new t.Vector2d,this.friction=new t.Vector2d},UPDATE:function(){this.friction.x&&(this.velocity.x=t.Utils.applyFriction(this.velocity.x,this.friction.x)),this.friction.y&&(this.velocity.y=t.Utils.applyFriction(this.velocity.y,this.friction.y)),this.velocity.x+=this.acceleration.x*t.deltaTime,this.velocity.y+=this.acceleration.y*t.deltaTime,0!==this.velocity.x&&(this.velocity.x=Math.clamp(this.velocity.x,-this.maxVelocity.x,this.maxVelocity.x)),0!==this.velocity.y&&(this.velocity.y=Math.clamp(this.velocity.y,-this.maxVelocity.y,this.maxVelocity.y)),this.position.x+=this.velocity.x,this.position.y+=this.velocity.y}})}(Joy),function(t){function i(i,e){var n={};return n.position=new t.Vector2d,n.position.x=i.position.x+t.Range.parse(e.position&&e.position.x||{}).randomInt(),n.position.y=i.position.y+t.Range.parse(e.position&&e.position.y||{}).randomInt(),n.scale=new t.Vector2d,n.scale.x=t.Range.parse(e.scale&&e.scale.x||i.scale.x).randomInt(),n.scale.y=t.Range.parse(e.scale&&e.scale.y||i.scale.y).randomInt(),n.alpha=t.Range.parse(e.alpha===void 0?i.alpha:e.alpha).randomInt(),n.rotation=t.Range.parse(e.rotation===void 0?i.rotation:e.rotation).randomInt(),n}t.Behaviour.define("Particle",{init:function(t){this.particleOptions=t},ADDED:function(){var e=i(this.particleOptions.emitter,this.particleOptions.start||{}),n=i(this.particleOptions.emitter,this.particleOptions.end||{});for(var o in e)this[o]=e[o],"object"==typeof n[o]&&(t.Tween(e[o],1e3*this.particleOptions.ttl).to(n[o]).start(),delete n[o]);t.Tween(this,1e3*this.particleOptions.ttl).to(n).onComplete(this.destroy).start()}})}(Joy),function(t){t.Behaviour.define("Physics",{INIT:function(){},UPDATE:function(){}})}(Joy),function(t){var i=function(i,e,n){this.id=t.generateUniqueId(),this.position=i,this.collidePosition=this.position.clone(),this.width=e,this.height=n};i.prototype.updateColliderPosition=function(t){this.collidePosition.x=t.x+this.position.x,this.collidePosition.y=t.y+this.position.y},i.prototype.renderStroke=function(t){t.strokeStyle="red",t.strokeRect(this.collidePosition.x,this.collidePosition.y,this.width,this.height)},i.prototype.collide=function(t){return!(this.collidePosition.x>=t.collidePosition.x+t.width||t.collidePosition.x>=this.collidePosition.x+this.width||this.collidePosition.y>=t.collidePosition.y+t.height||t.collidePosition.y>=this.collidePosition.y+this.height)},i.prototype.clone=function(){return new i(this.position.clone(),this.width,this.height)},t.RectCollider=i}(Joy),function(t){var i=function(i){this.blocks=[];for(var e=0,n=i.data.length;n>e;++e)0!==i.data[e]&&this.blocks.push(new Joy.RectCollider(new t.Vector2d(i.tileset.tileWidth*(e%i.columns),i.tileset.tileHeight*(e/i.columns>>0)),i.tileset.tileWidth,i.tileset.tileHeight));this.length=this.blocks.length};i.prototype.collide=function(t){for(var i=0;this.length>i;++i)if(!(this.blocks[i].collidePosition.x>=t.collidePosition.x+t.width||t.collidePosition.x>=this.blocks[i].collidePosition.x+this.blocks[i].width||this.blocks[i].collidePosition.y>=t.collidePosition.y+t.height||t.collidePosition.y>=this.blocks[i].collidePosition.y+this.blocks[i].height))return!0;return!1},i.prototype.renderStroke=function(t){for(var i=0;this.length>i;++i)t.strokeRect(this.blocks[i].position.x,this.blocks[i].position.y,this.blocks[i].width,this.blocks[i].height)},t.TilemapCollider=i}(Joy),function(t){var i=function(t){this.setCanvas(t.canvas)};i.prototype.setCanvas=function(t){return this.canvas=t,this.ctx=t.getContext("2d"),this},i.prototype.clear=function(){return this.ctx.clearRect(0,0,this.ctx.canvas.width,this.ctx.canvas.height),this},i.prototype.render=function(t){this.clear();for(var i=0,e=t.length;e>i;++i)t[i].visible&&t[i].render()},t.Context.Context2d=i}(Joy),function(J){var Markup=function(t){this.engine=t,this.canvas=t.context.canvas,this.parsers={IMG:function(t,i){return new J.Sprite(i)},LABEL:function(t,i){return i.text=t.innerHTML,new J.Text(i)},DIV:function(t,i){for(var e=new J.DisplayObjectContainer(i),n=t.querySelector("*"),o=0,s=n.length;s>o;o++)e.addChild(this.parsers[n[o].tagName].apply(this,[n[o],Markup.evaluateDataset(n[o])]));return e},AUDIO:function(){new J.Sound({})}}};Markup.prototype.parse=function(){var t=this.canvas.querySelectorAll("section");0===t.length&&(t=[this.canvas]);for(var i=0;t.length>i;i++)this.createScene(t[i])},Markup.prototype.createScene=function(t){var i,e,n=[],o=t.querySelectorAll("*");for(i=0,e=o.length;e>i;++i)if(this.parsers[o[i].tagName]){var s=this.parsers[o[i].tagName].apply(this,[o[i],Markup.evaluateDataset(o[i])]);n.push(s)}var r=Markup.evaluateDataset(t);this.engine.createScene(function(t){for(var o in r)console.log(o,r[o]),"function"==typeof t[o]?t[o](r[o]):t[o]=r[o];for(i=0,e=n.length;e>i;++i)t.addChild(n[i])})},Markup.evaluateDataset=function(el){var value,matches,attr,attributeName,attributes=el.attributes,obj={};for(var key in attributes)attr=attributes[key],"object"==typeof attr&&(value=""===attr.value?!0:attr.value,attributeName=attr.name,0===attributeName.indexOf("data-")&&(attributeName=attributeName.substr(5,attributeName.length)),matches=attr.value.match(/\{\{([^\}]*)\}\}/),matches&&(value=value.replace(value,eval(matches[1]))),obj[attributeName]=value);return obj},J.Markup=Markup}(Joy),function(t){var i=function(){};t.Package=i}(Joy),function(t){function i(t,i){var n,o,s=e.handlers[t];for(n=0,o=s.length;o>n;++n)s[n].handler.apply(s[n].target,[i])}var e={ENTER:13,SPACE:32,BACKSPACE:8,TAB:9,SHIFT:16,CTRL:17,ALT:18,PAUSE:19,CAPSLOCK:20,ESCAPE:27,PAGEUP:33,PAGEDOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,INSERT:45,DELETE:46,KEY_0:48,KEY_1:49,KEY_2:50,KEY_3:51,KEY_4:52,KEY_5:53,KEY_6:54,KEY_7:55,KEY_8:56,KEY_9:57,KEY_A:65,KEY_B:66,KEY_C:67,KEY_D:68,KEY_E:69,KEY_F:70,KEY_G:71,KEY_H:72,KEY_I:73,KEY_J:74,KEY_K:75,KEY_L:76,KEY_M:77,KEY_N:78,KEY_O:79,KEY_P:80,KEY_Q:81,KEY_R:82,KEY_S:83,KEY_T:84,KEY_U:85,KEY_V:86,KEY_W:87,KEY_X:88,KEY_Y:89,KEY_Z:90,SELECT:93,NUMPAD0:96,NUMPAD1:97,NUMPAD2:98,NUMPAD3:99,NUMPAD4:100,NUMPAD5:101,NUMPAD6:102,NUMPAD7:103,NUMPAD8:104,NUMPAD9:105,MULTIPLY:106,ADD:107,SUBTRACT:109,DECIMALPOINT:110,DIVIDE:111,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,NUMLOCK:144,SCROLLLOCK:145,SEMICOLON:186,EQUALSIGN:187,COMMA:188,DASH:189,PERIOD:190,FORWARDSLASH:191,GRAVEACCENT:192,OPENBRACKET:219,BACKSLASH:220,CLOSEBRAKET:221,SINGLEQUOTE:222};t.Events.KEY_DOWN="onkeydown",t.Events.KEY_UP="onkeyup",t.Events.KEY_PRESS="key",e.repeatRate=1,e.handlers={},e.timers={},[t.Events.KEY_DOWN,t.Events.KEY_UP,t.Events.KEY_PRESS].forEach(function(i){e.handlers[i]=[],t.Triggerable.register(i,function(t){-1===e.handlers[i].indexOf(t)&&e.handlers[i].push(t)},function(t){var n=e.handlers[i].indexOf(t);-1!==n&&e.handlers[i].splice(n,1)})}),document.onkeydown=function(n){var o=(n||window.event).keyCode;return e.timers[o]||(i(t.Events.KEY_DOWN,n),i(t.Events.KEY_PRESS,n),0!==e.repeatRate&&(e.timers[o]=setInterval(function(){i(t.Events.KEY_PRESS,n)},e.repeatRate))),!1},document.onkeyup=function(n){var o=(n||window.event).keyCode;o in e.timers&&(i(t.Events.KEY_UP,n),e.timers[o]&&clearInterval(e.timers[o]),delete e.timers[o])},Joy.Keyboard=e}(Joy),function(t){var i={collider:new t.RectCollider(new t.Vector2d,1,1),lastEvent:null,updateColliderPosition:function(e){i.collider.position.x=e.offsetX*t.currentEngine.currentScene.viewport.scale.x,i.collider.position.y=e.offsetY*t.currentEngine.currentScene.viewport.scale.y,i.collider.updateColliderPosition(t.currentEngine.currentScene.viewport.position)},isOver:function(t){return t.collider.collide(i.collider)},enable:function(e){var n=function(t){var e=i.handlers[t.type];this.lastEvent=t,i.updateColliderPosition(t);for(var n=0,o=e.length;o>n;++n)e[n].target.visible&&i.isOver(e[n].target)&&e[n].handler.apply(e[n].target,[t])};e.context.canvas["on"+t.Events.CLICK]=n,e.context.canvas["on"+t.Events.DOUBLE_CLICK]=n,e.context.canvas["on"+t.Events.MOUSE_MOVE]=n,e.context.canvas["on"+t.Events.MOUSE_DOWN]=n,e.context.canvas["on"+t.Events.MOUSE_UP]=n},handlers:{},timers:{}};t.Events.MOUSE_DOWN="mousedown",t.Events.MOUSE_UP="mouseup",t.Events.MOUSE_MOVE="mousemove",t.Events.CLICK="click",t.Events.DOUBLE_CLICK="dblclick",t.Events.MOUSE_OVER="mouseover",t.Events.MOUSE_OUT="mouseout",[t.Events.CLICK,t.Events.DOUBLE_CLICK,t.Events.DOUBLE_CLICK,t.Events.MOUSE_MOVE,t.Events.MOUSE_DOWN,t.Events.MOUSE_UP].forEach(function(e){i.handlers[e]=[],t.Triggerable.register(e,function(t){-1===i.handlers[e].indexOf(t)&&i.handlers[e].push(t)},function(t){var n=i.handlers[e].indexOf(t);-1!==n&&i.handlers[e].splice(n,1)})}),t.Mouse=i}(Joy),function(t){if(t.Support.touch){var i={};t.Events.TOUCH_START="touchstart",t.Events.TOUCH_MOVE="touchmove",t.Events.TOUCH_END="touchend",t.Touch=i}}(Joy);