###!
# @name jQuery Center plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-extends >= 1.0.0
###

((root, factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends'], ($) -> factory root, $
  else if typeof exports is 'object'
    # CommonJS
    factory root, require('jquery-extends')
  else
    # Browser globals
    factory root, jQuery
) (if window? then window else this), (window, $) ->
  'use strict'

  ###*
  # @param {boolean} [isFixed]
  # @param {string} [mode] h, v, horizental, or verital
  # @returns {$.fn}
  ###
  $.fn.center = (isFixed, mode) ->
    return @  unless @length > 0

    [mode, isFixed] = [isFixed, false]  unless typeof isFixed is 'boolean'

    isHorizental = mode not in ['v', 'vertical']
    isVertical = mode not in ['h', 'horizental']
    ww = $(window).width()
    wh = $(window).height()
    sx = if isFixed then 0 else $(document).scrollLeft()
    sy = if isFixed then 0 else $(document).scrollTop()
    position = if isFixed then 'fixed' else 'absolute'

    @filter(':visible').each ->
      $this = $(@)
      $this.appendTo(document.body)  if $this.parents().is(-> $(@).css('position') is 'fixed')
      $this.css(position: position, zIndex: $.maxZIndex() + 1)

      if isHorizental
        $w = $this.outerWidth()
        left = ww/2 - $w/2 + sx
        left = 0  if left < 0
        $this.css('left', left)

      if isVertical
        $h = $this.outerHeight()
        top = wh/2 - $h/2 + sy
        top = 0  if top < 0
        $this.css('top', top)

      return #nothing
    @
  #end of $.fn.center

  # Exports
  $.fn.center
