
/*!
 * @name jQuery Cookie Map plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 *   jquery-cookie >= 1.4.0
 */

(function() {
  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery', 'jquery-cookie'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery'), require('jquery-cookie'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';
    var CookieMap;
    CookieMap = (function() {
      function CookieMap(name, options) {
        this.name = name;
        if (typeof this.name !== 'string') {
          $.error("'name' must be string type");
        }
        if (!(this.name.length > 0)) {
          $.error("'name' must not be empty");
        }
        if (typeof options === 'boolean') {
          options = {
            autoSave: options
          };
        }
        this.options = $.extend({}, this.options, options);
        this.load();
      }

      CookieMap.prototype.options = {
        autoSave: true
      };

      CookieMap.prototype.load = function() {
        this.hash = (function() {
          try {
            return JSON.parse($.cookie(this.name));
          } catch (_error) {
            return {};
          }
        }).call(this);
        return this;
      };

      CookieMap.prototype.save = function() {
        var savedValue, value;
        value = JSON.stringify(this.hash);
        if (value === '{}') {
          if (!$.removeCookie(this.name)) {
            $.error("Clear cookie value failed : " + this.name);
          }
        } else {
          $.cookie(this.name, value, this.options);
          savedValue = $.cookie(this.name);
          if (savedValue !== value) {
            $.error("Set Cookie value failed : " + this.name);
          }
        }
        return this;
      };

      CookieMap.prototype.get = function(key) {
        var _ref;
        if (key != null) {
          return (_ref = this.hash) != null ? _ref[key] : void 0;
        } else {
          return this.hash;
        }
      };

      CookieMap.prototype.set = function(key, value) {
        if (!this.hash) {
          this.hash = {};
        }
        if ($.isPlainObject(key)) {
          this.hash = $.extend({}, key);
        } else {
          this.hash[key] = value;
        }
        if (this.options.autoSave) {
          this.save();
        }
        return this;
      };

      CookieMap.prototype.clear = function() {
        this.hash = {};
        if (this.options.autoSave) {
          this.save();
        }
        return this;
      };

      CookieMap.prototype.toString = function() {
        return this.name + " : " + JSON.stringify(this.hash);
      };

      return CookieMap;

    })();
    $.CookieMap = function(name, options) {
      return new CookieMap(name, options);
    };
    return CookieMap;
  });

}).call(this);

//# sourceMappingURL=jquery-cookiemap.js.map
