
/*!
 * @name jQuery Currency plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 *   jquery-extends >= 1.0.0
 */

(function() {
  var __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery-extends'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';
    var PROP_NAME, defaults, fractionFillZeros, isExponential, isNumeric, normalizeOptions;
    PROP_NAME = '$currency';
    defaults = {
      initial: true,
      maxIntegerDigits: 0,
      maxFractionDigits: 3,
      fractionRound: false,
      fractionFillZeros: true,
      groupDigits: true,
      symbol: '',
      decimalSymbol: '.',
      digitGroupSymbol: ','
    };
    normalizeOptions = function(options) {
      options = $.extend({}, defaults, (function() {
        switch (typeof options) {
          case 'boolean':
            return {
              initial: options
            };
          case 'string':
            return {
              digitGroupSymbol: options
            };
          case 'number':
            return {
              maxFractionDigits: options
            };
          default:
            if ($.isPlainObject(options)) {
              return options;
            } else {
              return {};
            }
        }
      })());
      if (options.decimalSymbol) {
        if (options.decimalSymbol.length > 1) {
          options.decimalSymbol = options.decimalSymbol.charAt(0);
        }
        if (/[0-9]/.test(options.decimalSymbol)) {
          $.error("Decimal symbol must not be digits");
        }
      }
      if (options.digitGroupSymbol) {
        if (options.digitGroupSymbol.length > 1) {
          options.digitGroupSymbol = options.digitGroupSymbol.charAt(0);
        }
        if (/[0-9]/.test(options.digitGroupSymbol)) {
          $.error("Digit group symbol must not be digits");
        }
      }
      if (options.decimalSymbol === options.digitGroupSymbol) {
        $.error("Decimal symbol must not be equal to digit group symbol");
      }
      if (options.symbol) {
        if (/[0-9]/.test(options.symbol)) {
          $.error("Symbol must not be contains digits");
        }
        if (options.decimalSymbol && options.symbol.contains(options.decimalSymbol)) {
          $.error("Symbol must not be contains : " + options.decimalSymbol);
        }
        if (options.digitGroupSymbol && options.symbol.contains(options.digitGroupSymbol)) {
          $.error("Symbol must not be contains : " + options.digitGroupSymbol);
        }
      }
      return options;
    };
    isNumeric = function(value) {
      return !isNaN(parseFloat(value)) && isFinite(value);
    };
    isExponential = function(value) {
      return /^\d(\.\d+)?e\+\d+$/i.test(value);
    };
    fractionFillZeros = function(value, options) {
      var fractionLength, period;
      if (value.length > 0 && options.fractionFillZeros && options.maxFractionDigits > 0) {
        if (value === '-') {
          value = '0';
        }
        period = value.indexOf(options.decimalSymbol);
        if (period === -1) {
          period = value.length;
          value += options.decimalSymbol;
        }
        fractionLength = value.length - period - 1;
        if (fractionLength < options.maxFractionDigits) {
          value += $.fill(options.maxFractionDigits - fractionLength, '0');
        }
      }
      return value;
    };
    $.fn.currency = function(options) {
      var targets;
      switch (options) {
        case 'hasCurrency':
          return !!this.data(PROP_NAME);
        case 'cleanValue':
          return ((function(_this) {
            return function(options) {
              var begin, isNegative, pattern, regex, value;
              value = $.trim(_this.val());
              if (options) {
                isNegative = false;
                begin = 0;
                if (value.charAt(begin) === '-') {
                  isNegative = true;
                  begin++;
                }
                if (value.charAt(begin) === options.symbol) {
                  begin++;
                }
                if (begin > 0) {
                  value = value.slice(begin);
                }
                if (options.groupDigits && options.digitGroupSymbol) {
                  pattern = options.digitGroupSymbol.replace(/([\^\.\?\*\(\)\[\]])/g, '\\$1');
                  regex = new RegExp('[' + pattern + ']', 'g');
                  value = value.replace(regex, '');
                }
                if (options.decimalSymbol !== '.') {
                  value = value.replace(options.decimalSymbol, '.');
                }
                if (isNegative) {
                  value = '-' + value;
                }
              }
              return value;
            };
          })(this))(this.data(PROP_NAME));
        case 'toNumber':
          return ((function(_this) {
            return function() {
              var value;
              value = _this.currency('cleanValue');
              if (value.contains('.')) {
                return parseFloat(value);
              } else {
                return parseInt(value) || 0;
              }
            };
          })(this))();
      }
      options = normalizeOptions(options);
      targets = this.filter('input');
      targets.removeData(PROP_NAME + '.previousValue');
      targets.data(PROP_NAME, options);
      targets.off('.' + PROP_NAME);
      targets.on('keypress.' + PROP_NAME, function(e) {
        var decimalSymbolCode, keyCode, minusCode, position;
        options = $.data(this, PROP_NAME);
        keyCode = e.keyCode || e.charCode;
        decimalSymbolCode = options.decimalSymbol.charCodeAt(0);
        minusCode = '-'.charCodeAt(0);
        position = 'selectionStart' in this ? this.selectionStart : -1;
        if (position > 0 && /^\s+$/g.test(this.value.slice(0, position))) {
          position = 0;
        }
        if (!((48 <= keyCode && keyCode <= 57) || (keyCode === decimalSymbolCode && !this.value.contains(options.decimalSymbol)) || (position <= 0 && keyCode === minusCode && !this.value.contains('-')))) {
          return e.preventDefault();
        }
      });
      targets.on('keyup.{0} blur.{0} change.{0}'.format(PROP_NAME), function(e) {
        var c, cleanValue, cleanedZeros, count, currencyValue, currencyValueUnits, currentPosition, endFractionPosition, fractionDigits, hasDot, i, integerDigits, isNegative, keyCode, period, selection, startFractionPosition, _i, _j, _ref, _ref1;
        if (e.type === 'change') {
          $.removeData(this, PROP_NAME + '.canceledChangeEvent');
        }
        if (e.type === 'blur' && $.data(this, PROP_NAME + '.canceledChangeEvent')) {
          $(this).change();
        }
        if (e.type === 'keyup') {
          if (!('selectionStart' in this)) {
            return;
          }
          keyCode = e.keyCode || e.charCode;
          if (keyCode === 20 || keyCode === 27 || __indexOf.call([16, 17, 18], keyCode) >= 0 || __indexOf.call([33, 34, 35, 36, 37, 38, 39, 40], keyCode) >= 0) {
            return;
          }
        }
        if (!this.value) {
          return;
        }
        if (this.value === $.data(this, PROP_NAME + '.previousValue')) {
          if (!e.type.startsWith('key')) {
            this.value = fractionFillZeros(this.value, $.data(this, PROP_NAME));
          }
          return;
        }
        if (isExponential($.trim(this.value))) {
          if (!e.type.startsWith('key')) {
            this.value = $.trim(this.value);
          }
          return;
        }
        options = $.data(this, PROP_NAME);
        selection = {
          direction: this.selectionDirection,
          start: this.selectionStart,
          end: this.selectionEnd,
          correction: 0
        };
        cleanValue = '';
        isNegative = false;
        hasDot = false;
        for (i = _i = 0, _ref = this.value.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
          c = this.value.charAt(i);
          if (c === options.digitGroupSymbol) {
            if (selection.start > i) {
              selection.correction++;
            }
            continue;
          }
          if (c === options.decimalSymbol) {
            if (hasDot) {
              if (selection.start > i) {
                selection.correction++;
              }
              continue;
            }
            if (cleanValue === '') {
              cleanValue += '0';
              if (selection.start > i) {
                selection.correction--;
              }
            }
            hasDot = true;
          } else if (!/[0-9]/.test(c)) {
            if (c === '-' && cleanValue.length === 0) {
              isNegative = true;
            }
            if (selection.start > i) {
              selection.correction++;
            }
            continue;
          }
          cleanValue += c;
        }
        period = cleanValue.indexOf(options.decimalSymbol);
        integerDigits = period > -1 ? cleanValue.slice(0, period) : cleanValue;
        fractionDigits = null;
        if (period > -1 && options.maxFractionDigits > 0) {
          startFractionPosition = period + 1;
          endFractionPosition = period + 1 + options.maxFractionDigits;
          fractionDigits = cleanValue.slice(startFractionPosition, endFractionPosition);
          if (options.fractionRound && cleanValue.slice(endFractionPosition, endFractionPosition + 1) >= 5) {
            fractionDigits = fractionDigits.slice(0, -1) + (parseInt(fractionDigits.slice(-1)) + 1);
          }
        }
        if (integerDigits.length > 0) {
          cleanedZeros = integerDigits.replace(/^0+(0|[^0].*)$/, '$1');
          if (cleanedZeros.length !== integerDigits.length) {
            selection.correction += integerDigits.length - cleanedZeros.length;
            integerDigits = cleanedZeros;
          }
          if (integerDigits.length > options.maxIntegerDigits && options.maxIntegerDigits) {
            currentPosition = selection[selection.direction === 'backward' ? 'start' : 'end'] - selection.correction;
            if (currentPosition > options.maxIntegerDigits && currentPosition <= integerDigits.length) {
              selection.correction += currentPosition - options.maxIntegerDigits;
            }
            integerDigits = integerDigits.slice(0, options.maxIntegerDigits);
          }
        }
        selection.start -= selection.correction;
        selection.end -= selection.correction;
        selection.correction = 0;
        currencyValue;
        if (options.groupDigits) {
          currencyValueUnits = [];
          count = 0;
          for (i = _j = _ref1 = integerDigits.length - 1; _ref1 <= 0 ? _j <= 0 : _j >= 0; i = _ref1 <= 0 ? ++_j : --_j) {
            if (count > 0 && !(count % 3)) {
              if (selection.start > i) {
                selection.correction--;
              }
              currencyValueUnits.unshift(options.digitGroupSymbol);
            }
            currencyValueUnits.unshift(integerDigits.charAt(i));
            count++;
          }
          currencyValue = currencyValueUnits.join('');
        } else {
          currencyValue = integerDigits;
        }
        if (fractionDigits !== null) {
          currencyValue += options.decimalSymbol + fractionDigits;
        }
        if (options.symbol && currencyValue.length > 0) {
          currencyValue = options.symbol + currencyValue;
          selection.correction -= options.symbol.length;
        }
        if (isNegative) {
          currencyValue = '-' + currencyValue;
          selection.correction--;
        }
        if (!e.type.startsWith('key')) {
          this.value = fractionFillZeros(currencyValue, options);
        } else if (this.value !== currencyValue) {
          this.value = currencyValue;
          this.selectionStart = selection.start - selection.correction;
          this.selectionEnd = selection.end - selection.correction;
          this.selectionDirection = selection.direction;
          $.data(this, PROP_NAME + '.canceledChangeEvent', true);
        }
        $.data(this, PROP_NAME + '.previousValue', this.value);
      });
      if (options.initial) {
        targets.change();
      }
      return this;
    };
    $.currency = function(input, options) {
      var cleanedZeros, count, currencyValue, currencyValueUnits, endFractionPosition, fractionDigits, i, integerDigits, isNegative, period, startFractionPosition, _i, _ref;
      if (!isNumeric(input)) {
        return input;
      }
      input = $.trim(input.toString());
      if (isExponential(input)) {
        return input;
      }
      options = normalizeOptions(options);
      isNegative = input.charAt(0) === '-' ? (input = input.slice(1), true) : false;
      period = input.indexOf(options.decimalSymbol);
      integerDigits = period > -1 ? input.slice(0, period) : input;
      fractionDigits = null;
      if (period > -1 && options.maxFractionDigits > 0) {
        startFractionPosition = period + 1;
        endFractionPosition = period + 1 + options.maxFractionDigits;
        fractionDigits = input.slice(startFractionPosition, endFractionPosition);
        if (options.fractionRound && input.slice(endFractionPosition, endFractionPosition + 1) >= 5) {
          fractionDigits = fractionDigits.slice(0, -1) + (parseInt(fractionDigits.slice(-1)) + 1);
        }
        if (parseInt(fractionDigits) === 0) {
          fractionDigits = null;
        }
      }
      if (integerDigits.length > 0) {
        cleanedZeros = integerDigits.replace(/^0+(0|[^0].*)$/, '$1');
        if (cleanedZeros.length !== integerDigits.length) {
          integerDigits = cleanedZeros;
        }
        if (integerDigits.length > options.maxIntegerDigits && options.maxIntegerDigits) {
          integerDigits = integerDigits.slice(0, options.maxIntegerDigits);
        }
      }
      currencyValue;
      if (options.groupDigits) {
        currencyValueUnits = [];
        count = 0;
        for (i = _i = _ref = integerDigits.length - 1; _ref <= 0 ? _i <= 0 : _i >= 0; i = _ref <= 0 ? ++_i : --_i) {
          if (!(count === 0 || count % 3)) {
            currencyValueUnits.unshift(options.digitGroupSymbol);
          }
          currencyValueUnits.unshift(integerDigits.charAt(i));
          count++;
        }
        currencyValue = currencyValueUnits.join('');
      } else {
        currencyValue = integerDigits;
      }
      if (fractionDigits !== null) {
        currencyValue += options.decimalSymbol + fractionDigits;
      }
      if (options.symbol && currencyValue.length > 0) {
        currencyValue = options.symbol + currencyValue;
      }
      if (isNegative) {
        currencyValue = '-' + currencyValue;
      }
      return fractionFillZeros(currencyValue, options);
    };
    Number.prototype.currency = function(options) {
      return $.currency(this, options);
    };
    String.prototype.currency = function(options) {
      return $.currency(this.toString(), options);
    };
    return $.currency;
  });

}).call(this);

//# sourceMappingURL=jquery-currency.js.map
