
/*!
 * @name jQuery Parameter Control plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 *   jquery-extends >= 1.0.0
 */

(function() {
  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery-extends'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';
    var defaultParams;
    defaultParams = {};

    /**
     * @param {boolean} [clear] clear previous default parameters.
     * @param {object|string} params the parameters or parameter name.
     * @param {object} [value] the parameter value.
     */
    $.param.setDefaultParams = function(clear, params, value) {
      var args;
      args = $.makeArray(arguments);
      clear = typeof args[0] === 'boolean' ? args.shift() : false;
      params = typeof args[0] === 'string' ? $.obj.make(args.shift(), args.shift()) : args.shift();
      if (clear) {
        defaultParams = {};
      }
      return $.extend(defaultParams, params);
    };

    /**
     * @param {object|string} [params] the parameters or parameter name.
     * @param {boolean} [ignoredEmpty] default is true.
     */
    $.param.queryData = function(params, ignoredEmpty) {
      var key, value;
      params = $.extend({}, defaultParams, params);
      for (key in params) {
        value = params[key];
        if ($.isFunction(value)) {
          params[key] = value();
        }
        if (!(ignoredEmpty === false || (value != null) && value !== '')) {
          delete params[key];
        }
      }
      return params;
    };

    /**
     * @param {object|string} [params] the parameters or parameter name.
     * @param {boolean} [traditional] the traditional flag.
     * @param {boolean} [ignoredEmpty] default is true.
     */
    $.param.queryString = function(params, traditional, ignoredEmpty) {
      return this(this.queryData(params, ignoredEmpty), traditional == null ? true : traditional);
    };

    /**
     * @param {string} [url] the url.
     * @param {object|string} [params] the parameters or parameter name.
     * @param {boolean} [traditional] the traditional flag.
     * @param {boolean} [ignoredEmpty] default is true.
     */
    $.param.makeUrl = function(url, params, traditional, ignoredEmpty) {
      var hash, hashPosition, queryString;
      if (url == null) {
        url = '';
      }
      if (typeof url !== 'string') {
        $.error("URL is not a string [" + url + "]");
      }
      hash = '';
      hashPosition = url.indexOf('#');
      if (hashPosition > -1) {
        hash = url.substring(hashPosition);
        url = url.substring(0, hashPosition);
      }
      queryString = this.queryString(params, traditional, ignoredEmpty);
      if (queryString) {
        url += (url.contains('?') ? '&' : '?') + queryString;
      }
      return url + hash;
    };

    /**
     * @param {string} [url] the url.
     * @param {object|string} [params] the parameters or parameter name.
     * @param {boolean} [ignoredEmpty] default is true.
     */
    $.param.postUrl = function(url, params, ignoredEmpty) {
      var form, hashPosition, i, querystring;
      if (url == null) {
        url = '';
      }
      if (typeof url !== 'string') {
        $.error("URL is not a string [" + url + "]");
      }
      hashPosition = url.indexOf('#');
      if (hashPosition > -1) {
        url = url.substring(0, hashPosition);
      }
      i = url.indexOf('?');
      if (i > -1) {
        querystring = url.substring(i + 1);
        if (querystring) {
          params = $.extend(true, {}, $.deserialize(querystring), params);
        }
        url = url.substring(0, i);
      }
      form = $('<form/>', {
        action: url,
        method: 'post'
      });
      form.appendField(this.queryData(params, ignoredEmpty));
      form.appendTo(document.body).hide();
      form.submit();
      form.remove();
    };
    String.prototype.makeUrl = function() {
      return $.param.makeUrl.apply($.param, $.merge([this.toString()], arguments));
    };
    String.prototype.postUrl = function() {
      return $.param.postUrl.apply($.param, $.merge([this.toString()], arguments));
    };
    return $.param;
  });

}).call(this);

//# sourceMappingURL=jquery-param.js.map
