
/*!
 * @name jQuery Toggle Image plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 */

(function() {
  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';

    /**
     * @param {boolean|string|object} [option] 옵션
     * @param {string} [image] 이미지
     * @returns {$.fn}
     */
    $.fn.toggleImage = function(option, image) {
      var DEFAULT_OPTION, PROP_NAME, key, _ref;
      PROP_NAME = '$toggleImage';
      DEFAULT_OPTION = '__default__';
      if (option == null) {
        option = DEFAULT_OPTION;
      }
      if (image) {
        _ref = [option, {}, image], key = _ref[0], option = _ref[1], option[key] = _ref[2];
      }
      this.filter('img').each(function() {
        var $this, attrOption, data, src;
        $this = $(this);
        data = $.data(this, PROP_NAME);
        if ($.isPlainObject(option)) {
          $.data(this, PROP_NAME, $.extend(data || {}, option));
          for (key in option) {
            (new Image()).src = option[key];
          }
        } else {
          src = $this.attr('src');
          if (!data) {
            data = $.data(this, PROP_NAME, {});
          }
          if (!(DEFAULT_OPTION in data)) {
            data[DEFAULT_OPTION] = src;
          }
          if (!(option in data)) {
            attrOption = $this.attr(option);
            if (attrOption) {
              data[option] = attrOption;
            }
          }
          if (option in data && data[option] !== src) {
            $this.attr('src', data[option]);
          }
        }
      });
      return this;
    };
    return $.fn.toggleImage;
  });

}).call(this);

//# sourceMappingURL=jquery-toggleimage.js.map
