((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery-extends')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  $.messages = $.extend $.messages or {},
    'am': 'AM'
    'pm': 'PM'
    'dayShortNames': ['SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT']
    'dayLongNames': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
    'monthShortNames': ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
    'monthLongNames': ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'Decomber']

  # Exports
  $.messages
