
/*!
 * @name jQuery ajax success plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 */

(function() {
  var __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';

    /**
     * @param {object} [options] Options
     * @param {function} [callback] Callback
     * @example
     *   <pre>
     *     $.ajax
     *       url: 'test.xml'
     *       dataType: 'xml'
     *       success: $.ajax.success
     *         statusCodeName: 'statusCode'
     *         xmlResponseSelector: ':first'
     *         xmlStatusCodeType: 'A' # A: attribute, E: element
     *       , (data, textStatus, jqXHR) ->
     *         # Success...
     *
     *       error: (jqXHR, textStatus, errorThrown) ->
     *         # Error...
     *
     *   </pre>
     */
    $.ajax.success = function(options, callback) {
      var _ref;
      if ($.isFunction(options)) {
        _ref = [options, null], callback = _ref[0], options = _ref[1];
      } else {
        if (options && !$.isPlainObject(options)) {
          $.error(options + " is not a plain object");
        }
        if (callback && !$.isFunction(callback)) {
          $.error(callback + " is not a function");
        }
      }
      options = $.extend({
        statusCodeName: 'statusCode',
        xmlResponseSelector: ':first',
        xmlStatusCodeType: 'A'
      }, options);
      return function(data, textStatus, xhr) {
        var dataTypes, globalEventContext, statusCode, xml, _ref1, _ref2, _ref3, _ref4;
        dataTypes = ((_ref1 = this.dataType) != null ? typeof _ref1.split === "function" ? _ref1.split(' ') : void 0 : void 0) || this.dataTypes || [];
        statusCode = (function() {
          switch (false) {
            case __indexOf.call(dataTypes, 'json') < 0:
              return parseInt(data[options.statusCodeName]) || 0;
            case __indexOf.call(dataTypes, 'xml') < 0:
              xml = $(data).find(options.xmlResponseSelector);
              switch (options.xmlStatusCodeType) {
                case 'A':
                  return parseInt(xml.attr(options.statusCodeName)) || 0;
                case 'E':
                  return parseInt(xml.children(options.statusCodeName).text()) || 0;
                default:
                  return 0;
              }
              break;
            default:
              return 0;
          }
        })();
        if (statusCode >= 400) {
          xhr.status = statusCode;
          if (this.global) {
            globalEventContext = ((_ref2 = this.context) != null ? _ref2.nodeType : void 0) || ((_ref3 = this.context) != null ? _ref3.jquery : void 0) ? $(this.context) : $.event;
            globalEventContext.trigger('ajaxError', [xhr, this, 'usererror']);
          }
          if ((_ref4 = this.error) != null) {
            if (typeof _ref4.call === "function") {
              _ref4.call(this, xhr, 'usererror', null);
            }
          }
        } else {
          if (callback != null) {
            if (typeof callback.apply === "function") {
              callback.apply(this, arguments);
            }
          }
        }
      };
    };
    return $.ajax.success;
  });

}).call(this);

//# sourceMappingURL=jquery-ajaxsuccess.js.map
