###!
# @name jQuery Cookie Map plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-cookie >= 1.4.0
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery', 'jquery-cookie'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery'), require('jquery-cookie')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  class CookieMap
    constructor: (@name, options) ->
      $.error "'name' must be string type"  unless typeof @name is 'string'
      $.error "'name' must not be empty"  unless @name.length > 0

      options = autoSave: options  if typeof options is 'boolean'
      @options = $.extend({}, @options, options)
      @load()

    options:
      autoSave: true

    load: ->
      @hash = try JSON.parse($.cookie(@name))
      catch
        {}
      @

    save: ->
      value = JSON.stringify(@hash)
      if value is '{}'
        $.error "Clear cookie value failed : " + @name  unless $.removeCookie(@name)
      else
        $.cookie(@name, value, @options)
        savedValue = $.cookie(@name)
        $.error "Set Cookie value failed : " + @name  unless savedValue is value
      @

    get: (key) -> if key? then @hash?[key] else @hash

    set: (key, value) ->
      @hash = {}  unless @hash

      if $.isPlainObject key
        @hash = $.extend({}, key)
      else
        @hash[key] = value

      @save()  if @options.autoSave
      @

    clear: ->
      @hash = {}
      @save()  if @options.autoSave
      @

    toString: -> @name + " : " + JSON.stringify(@hash)

  $.CookieMap = (name, options) -> new CookieMap(name, options)

  # Exports
  CookieMap