###!
# @name jQuery Limit Value plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-extends >= 1.0.0
#   jquery-browser >= 1.0.0
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends', 'jquery-browser'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery-extends'), require('jquery-browser')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  ###*
  # @param {boolean|number} [checkbyte] check byte length if true. (default is false)
  # @param {number} limitSize the limit size.
  # @param {selectors|element} [selectors] for display remaining count.
  # @returns {$.fn}
  ###
  $.fn.limitValue = (checkbyte, limitSize, selectors...) ->
    return @  unless arguments.length
    return @  unless @is 'input,textarea'

    PROP_NAME = '$limitValue'
    WARN_COLOR_ATTR_NAME = 'warnColor'
    DEFAULT_WARN_COLOR = '#f00'

    args = $.makeArray(arguments)
    isBoolean = (v) -> typeof v is 'boolean'
    isNumber = (v) -> typeof v is 'number'

    checkbyte = if isBoolean(args[0]) or isNumber(args[0]) and isNumber(args[1]) then args.shift() else false
    $.error args[0] + " is not a number"  unless isNumber(args[0])
    limitSize = args.shift()
    states = $([])
    states.push($(a).get()...)  for a in args

    self = @
    eventHandler = (e) ->
      $this = $(@)
      value = $this.val()

      length = $.getLength(checkbyte, value)
      state = states.eq(self.index(@))
      remainingCount = if limitSize > length then limitSize - length else 0

      if state.length > 0
        if remainingCount is 0
          state.data('__original_color', state[0].style.color)  unless state.data('__original_color')?
          state.css('color', state.attr(WARN_COLOR_ATTR_NAME) or state.data(WARN_COLOR_ATTR_NAME) or DEFAULT_WARN_COLOR)
        else
          originalColor = state.data('__original_color')
          state.css('color', originalColor)  if originalColor?
        state.text(remainingCount)

      if length > limitSize
        newValue = $.cutstring(checkbyte, value, limitSize)
        newValueLength = newValue.length
        selection =
          start: @selectionStart
          end: @selectionEnd
          direction: @selectionDirection

        if selection.start >= newValueLength or $.browser.msie
          $this.blur().val(newValue).focus()
        else
          $this.val(newValue)

        @selectionStart = if selection.start < newValueLength then selection.start else newValueLength
        @selectionEnd = if selection.end < newValueLength then selection.end else newValueLength
        @selectionDirection = selection.direction

      return #nothing
    #end of eventHandler = (e) ->

    @off('.' + PROP_NAME)
    @on('change.{0} keyup.{0} keydown.{0}'.format(PROP_NAME), eventHandler)
    @change()
    @
  #end of $.fn.limitValue

  # Exports
  $.fn.limitValue
