###!
# @name jQuery options
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-extends >= 1.0.0
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery-extends')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  class Options
    constructor: (defaults) ->
      @$defaults = defaults
      @$options = $.obj.extend(true, defaults)

    get: (key, defaultValue) -> if key then $.obj.get(@$options, key, defaultValue) else @$options
    set: (options) -> $.obj.extend(true, @$options, options); @
    reset: (keepOptions) -> @$options = $.obj.extend(true, (if keepOptions then @$options else {}), @$defaults); @

  $.Options = (options) -> new Options(options)

  # Exports
  Options