###!
# @name jQuery Toggle Image plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  ###*
  # @param {boolean|string|object} [option] 옵션
  # @param {string} [image] 이미지
  # @returns {$.fn}
  ###
  $.fn.toggleImage = (option, image) ->
    PROP_NAME = '$toggleImage'
    DEFAULT_OPTION = '__default__'

    option = DEFAULT_OPTION  unless option?
    [key, option, option[key]] = [option, {}, image]  if image

    @filter('img').each ->
      $this = $(@)
      data = $.data(@, PROP_NAME)
      if $.isPlainObject option
        $.data(@, PROP_NAME, $.extend(data or {}, option))
        #Preloading images
        (new Image()).src = option[key]  for key of option
      else
        src = $this.attr('src')
        data = $.data(@, PROP_NAME, {})  unless data
        data[DEFAULT_OPTION] = src  unless DEFAULT_OPTION of data
        unless option of data
          attrOption = $this.attr(option)
          data[option] = attrOption  if attrOption
        $this.attr('src', data[option])  if option of data and data[option] isnt src
      return #nothing
    @
  #end of $.fn.toggleImage = (option, image) ->

  # Exports
  $.fn.toggleImage
