###!
# @name jQuery Validate Extends
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-extends >= 1.0.0
#   jquery-validation >= 1.11.1
# @optionals:
#   euckr-codes >= 1.0.0
###

((root, factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends', 'jquery-validation'], ($) -> factory root, $
  else if typeof exports is 'object'
    # CommonJS
    factory root, require('jquery-extends'), require('jquery-validation')
  else
    # Browser globals
    factory root, jQuery
) (if window? then window else this), (window, $) ->
  'use strict'

  VALIDATOR_PROP_NAME = 'validator'

  _validate = $.fn.validate
  $.fn.validate = () ->
    unless validator = @data(VALIDATOR_PROP_NAME)
      if validator = _validate.apply(@, arguments)
        if validator.settings.extendedRules
          for name, rules of validator.settings.extendedRules
            element = validator.findByNameOrSelector(name)
            if element.length > 0
              element.extendedRules(rules)
            else
              console.log "Initialize validator extended rules : element %s was skipped because not found", name

        validator.settings.initialize?.call?(validator, validator.currentForm, validator.settings, validator)
    validator
  #end of $.fn.validate = () ->

  $.fn.isValidatedForm = -> @is('form') and @data(VALIDATOR_PROP_NAME) instanceof $.validator

  $.validator::stopRequest = (element, valid) ->
    @pendingRequest--
    # sometimes synchronization fails, make sure pendingRequest is never < 0
    @pendingRequest = 0  if @pendingRequest < 0

    delete @pending[element.name]
    if @formSubmitted
      @invalidRemote = true  unless valid

      if @pendingRequest is 0
        if @invalidRemote
          $(@currentForm).triggerHandler('invalid-form', [@])
        else if @form()
          $(@currentForm).submit()
        @formSubmitted = false
        @invalidRemote = false

    element.focus?()  unless valid or @lastActive
    return #nothing
  #end of $.validator::stopRequest = (element, valid) ->

  $.validator::getLength = (value, element) ->
    switch element.nodeName.toLowerCase()
      when 'select' then return $('option:selected', element).length
      when 'input' then return @findByName(element.name).filter(':checked').length  if @checkable element
      else return $.getLength(2, value)  if 'koreanChars' of $(element).rules()
    value.length

  _elementValue = $.validator::elementValue
  $.validator::elementValue = (element) ->
    value = _elementValue.call(@, element)
    return ''  if $(element).data('inputmask') and value is $(element).inputmask?('getemptymask')
    return $(element).currency('toNumber')  if value and $(element).currency?('hasCurrency')
    value

  $.validator::findByNameOrSelector = (name) ->
    trimmedName = $.trim(name)
    return $(@currentForm).find(trimmedName)  if trimmedName.charAt(0) in ['#', '.', ':']
    $(@currentForm).find('[name="' + trimmedName + '"]')

  $.validator.extendedMethods = {}
  $.validator.addExtendedMethod = (name, method) -> $.validator.extendedMethods[name] = method; return #nothing
  $.validator.addExtendedMethods = (methods) -> $.extend($.validator.extendedMethods, methods); return #nothing

  $.fn.extendedRules = (ruleName, options) ->
    PROP_NAME = 'validatorExtendedRules'

    return @data(PROP_NAME)  unless arguments.length > 0
    return @data(PROP_NAME)?[ruleName]  if arguments.length is 1 and typeof ruleName is 'string'

    if typeof ruleName is 'string'
      [rules, rules[ruleName]] = [{}, options]
    else if $.isPlainObject ruleName
      rules = ruleName
    else
      rules = {}

    @each ->
      unless validator = $(@form).data(VALIDATOR_PROP_NAME)
        console.error "Form validator is not initialized.", @
      else
        element = @
        for rule, options of rules
          if rule of $.validator.extendedMethods
            data = $.data(element, PROP_NAME) or $.data(element, PROP_NAME, {})
            previousRuleData = data[rule]
            ruleData =
              options: options
            namespace =
              ruleName: rule
              fullName: PROP_NAME + '-' + rule

            $.validator.extendedMethods[rule].call(validator, element, ruleData, namespace, previousRuleData)
            data[rule] = ruleData
          else
            console.error "Unsupported extended rule : " + rule
    @
  #end of $.fn.extendedRules = (ruleName, options) ->


  $.validator.addMethod 'remote', (value, element, param) ->
    return 'dependency-mismatch'  if @optional element

    previous = @previousValue(element)
    @settings.messages[element.name] = {}  unless @settings.messages[element.name]

    previous.originalMessage = @settings.messages[element.name].remote
    @settings.messages[element.name].remote = previous.message

    param = if typeof param is 'string' then url: param else param

    return 'pending'  if @pending[element.name]
    return previous.valid  if previous.old is value

    previous.old = value
    validator = @

    @startRequest(element)

    data = {}
    # Override
    data[param.name or element.name] = value

    $.ajax $.extend(true,
      url: param
      mode: 'abort'
      port: 'validate' + element.name
      dataType: 'json'
      data: data
      success: (response) ->
        response = @successInternal.apply(@, arguments)  if $.isFunction @successInternal

        validator.settings.messages[element.name].remote = previous.originalMessage
        valid = response is true or response is 'true'
        if valid
          submitted = validator.formSubmitted
          validator.prepareElement(element)
          validator.formSubmitted = submitted
          validator.successList.push(element)
          delete validator.invalid[element.name]
          validator.showErrors()
        else
          errors = {}
          message = response or validator.defaultMessage(element, 'remote')
          errors[element.name] = previous.message = message?(value) or message
          validator.invalid[element.name] = true
          validator.showErrors(errors)

        previous.valid = valid
        validator.stopRequest(element, valid)

      # Fix for request error
      error: ->
        previous.old = null
        validator.pendingRequest--
        # sometimes synchronization fails, make sure pendingRequest is never < 0
        validator.pendingRequest = 0  if validator.pendingRequest < 0
        delete validator.pending[element.name]

    , param)

    'pending'
  #end of $.validator.addMethod 'remote', (value, element, param) ->

  $.validator.addMethod 'exactlength', (value, element, param) ->
    @optional(element) or (=>
      length = if $.isArray(value) then value.length else @getLength($.trim(value), element)
      length is parseInt(param)
    )()
  , "정확히 {0}자로 입력하세요."

  $.validator.addMethod 'numeric', (value, element, param) ->
    @optional(element) or (=>
      patternInteger = '\\d{1,' + (param[0] or '') + '}'
      patternFraction = if param[1] > 0 then '(\\.\\d{0,' + param[1] + '})?' else ''
      regex = new RegExp('^-?' + patternInteger + patternFraction + '$')
      regex.test value.toString()
    )()
  , "numeric value out of bounds (<{0} digits>.<{1} digits> expected)"

  $.validator.addMethod 'equal', (value, element, param) ->
    @optional(element) or `value == param`
  , "{0}을 입력하세요."

  $.validator.addMethod 'phone', (value, element) ->
    @optional(element) or /^[\-\+\(\)0-9]\{1,\}$/i.test value
  , "전화번호 형식을 정확이 입력하세요."

  # Validator for password keyboard layout
  $.validator.addMethod 'keyLayout', (value, element, param) ->
    @optional(element) or value.length < param or (=>
      repeat = parseInt(param)
      return true  unless repeat > 0
      layout = '1234567890qwertyuiopasdfghjklzxcvbnm'
      for i in [0..value.length - repeat]
        return false  if layout.contains value.substr(i, i + repeat)
      true
    )()
  , "연속된 {0}자 이상의 문자는 입력할 수 없습니다."

  $.validator.addMethod 'keyRepeat', (value, element, param) ->
    @optional(element) or value.length < param or (=>
      repeat = parseInt(param)
      return true  unless repeat > 0
      regex = new RegExp("(.)(?:.*\\1){" + (repeat - 1) + "}")
      not regex.test(value)
    )()
  , "동일한 {0}자 이상의 문자는 입력할 수 없습니다."

  $.validator.addMethod 'words', (value, element) ->
    @optional(element) or /^[\w-]+$/.test value
  , "영문, 숫자 또는 (-,_) 형식으로 입력하세요."

  $.validator.addMethod 'ascii', (value, element) ->
    @optional(element) or /^[\u0000-\u007F]+$/.test value
  , "영문, 숫자 또는 일부 특수문자(!,@,#,$,%,^,&,*,(,),-,+,=,_,/,\\,<,>,[,],{,},...) 만 입력하세요."

  $.validator.addMethod 'alphaOrNumber', (value, element) ->
    @optional(element) or /^[a-zA-Z0-9]*$/.test value
  , "영문 또는 숫자로 입력하세요."

  $.validator.addMethod 'alphaAndNumber', (value, element) ->
    @optional(element) or (
      /^[a-zA-Z0-9]*$/.test(value) and
      /[a-zA-Z]{1,}/.test(value) and
      /[0-9]{1,}/.test(value)
    )
  , "영문과 숫자를 혼용하여 입력하세요."

  $.validator.addMethod 'startWithAlpha', (value, element) ->
    @optional(element) or /^[a-zA-Z]{1,}/.test value
  , "첫글자는 영문으로 입력하세요."

  $.validator.addMethod 'hangul', (value, element) ->
    @optional(element) or /^[가-힣]+$/.test value
  , "한글 형식으로 입력하세요."

  $.validator.addMethod 'containsNumber', (value, element) ->
    @optional(element) or /[0-9]{1,}/.test value
  , "숫자를 포함해야 합니다."

  $.validator.addMethod 'lt', (value, element, param) ->
    @optional(element) or value < param
  , "Please enter a value less than {0}."

  $.validator.addMethod 'gt', (value, element, param) ->
    @optional(element) or value > param
  , "Please enter a value greater than {0}."

  $.validator.addMethod 'brnKO', (value, element) ->
    @optional(element) or (=>
      brn = value.replace(/-/g, '')
      checkIDs = [1, 3, 7, 1, 3, 7, 1, 3, 5]
      checkSum = 0
      checkTemp = null

      checkSum += checkIDs[i] * brn.charAt(i) % 10  for i in [0...8]
      checkTemp = checkIDs[8] * brn.charAt(8) + '0'
      checkSum += parseFloat(checkTemp.charAt(0))
      checkSum += parseFloat(checkTemp.charAt(1))

      parseInt(brn.charAt(9)) is ((10 - (checkSum % 10)) % 10)
    )()
  , "형식에 맞지 않는 사업자 번호입니다."

  $.validator.addMethod('koreanChars', (value, element) ->
    return 'dependency-mismatch'  if @optional(element) or
                                     window.event?.type is 'keyup' and
                                     (window.event.keyCode or window.event.charCode) isnt 13

    previous = $.data(element, 'previousValue') or $.data(element, 'previousValue', old: null, valid: true)
    return previous.valid  if previous.old is value
    previous.old = value

    exceptChars = $.data(element, 'exceptChars', [])
    for i in [0...value.length]
      unless value.charCodeAt(i) of window.EUCKR_CODES
        c = value.charAt(i)
        exceptChars.push(c)  unless c in exceptChars

    valid = exceptChars.length is 0
    previous.valid = valid
    valid
  , (params, element) ->
    message = "허용되지 않는 문자가 입력되었습니다."
    exceptChars = $.data(element, 'exceptChars')
    message += "\n[#{exceptChars}]"  if exceptChars?.length > 0
    $.validator.format(message, params)
  )  if window.EUCKR_CODES?

  # Exports
  $.validator
