
/*!
 * @name jQuery Validate Extends
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 *   jquery-extends >= 1.0.0
 *   jquery-validation >= 1.11.1
 * @optionals:
 *   euckr-codes >= 1.0.0
 */

(function() {
  var __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  (function(root, factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends', 'jquery-validation'], function($) {
        return factory(root, $);
      });
    } else if (typeof exports === 'object') {
      return factory(root, require('jquery-extends'), require('jquery-validation'));
    } else {
      return factory(root, jQuery);
    }
  })((typeof window !== "undefined" && window !== null ? window : this), function(window, $) {
    'use strict';
    var VALIDATOR_PROP_NAME, _elementValue, _validate;
    VALIDATOR_PROP_NAME = 'validator';
    _validate = $.fn.validate;
    $.fn.validate = function() {
      var element, name, rules, validator, _ref, _ref1;
      if (!(validator = this.data(VALIDATOR_PROP_NAME))) {
        if (validator = _validate.apply(this, arguments)) {
          if (validator.settings.extendedRules) {
            _ref = validator.settings.extendedRules;
            for (name in _ref) {
              rules = _ref[name];
              element = validator.findByNameOrSelector(name);
              if (element.length > 0) {
                element.extendedRules(rules);
              } else {
                console.log("Initialize validator extended rules : element %s was skipped because not found", name);
              }
            }
          }
          if ((_ref1 = validator.settings.initialize) != null) {
            if (typeof _ref1.call === "function") {
              _ref1.call(validator, validator.currentForm, validator.settings, validator);
            }
          }
        }
      }
      return validator;
    };
    $.fn.isValidatedForm = function() {
      return this.is('form') && this.data(VALIDATOR_PROP_NAME) instanceof $.validator;
    };
    $.validator.prototype.stopRequest = function(element, valid) {
      this.pendingRequest--;
      if (this.pendingRequest < 0) {
        this.pendingRequest = 0;
      }
      delete this.pending[element.name];
      if (this.formSubmitted) {
        if (!valid) {
          this.invalidRemote = true;
        }
        if (this.pendingRequest === 0) {
          if (this.invalidRemote) {
            $(this.currentForm).triggerHandler('invalid-form', [this]);
          } else if (this.form()) {
            $(this.currentForm).submit();
          }
          this.formSubmitted = false;
          this.invalidRemote = false;
        }
      }
      if (!(valid || this.lastActive)) {
        if (typeof element.focus === "function") {
          element.focus();
        }
      }
    };
    $.validator.prototype.getLength = function(value, element) {
      switch (element.nodeName.toLowerCase()) {
        case 'select':
          return $('option:selected', element).length;
        case 'input':
          if (this.checkable(element)) {
            return this.findByName(element.name).filter(':checked').length;
          }
          break;
        default:
          if ('koreanChars' in $(element).rules()) {
            return $.getLength(2, value);
          }
      }
      return value.length;
    };
    _elementValue = $.validator.prototype.elementValue;
    $.validator.prototype.elementValue = function(element) {
      var value, _base, _base1;
      value = _elementValue.call(this, element);
      if ($(element).data('inputmask') && value === (typeof (_base = $(element)).inputmask === "function" ? _base.inputmask('getemptymask') : void 0)) {
        return '';
      }
      if (value && (typeof (_base1 = $(element)).currency === "function" ? _base1.currency('hasCurrency') : void 0)) {
        return $(element).currency('toNumber');
      }
      return value;
    };
    $.validator.prototype.findByNameOrSelector = function(name) {
      var trimmedName, _ref;
      trimmedName = $.trim(name);
      if ((_ref = trimmedName.charAt(0)) === '#' || _ref === '.' || _ref === ':') {
        return $(this.currentForm).find(trimmedName);
      }
      return $(this.currentForm).find('[name="' + trimmedName + '"]');
    };
    $.validator.extendedMethods = {};
    $.validator.addExtendedMethod = function(name, method) {
      $.validator.extendedMethods[name] = method;
    };
    $.validator.addExtendedMethods = function(methods) {
      $.extend($.validator.extendedMethods, methods);
    };
    $.fn.extendedRules = function(ruleName, options) {
      var PROP_NAME, rules, _ref, _ref1;
      PROP_NAME = 'validatorExtendedRules';
      if (!(arguments.length > 0)) {
        return this.data(PROP_NAME);
      }
      if (arguments.length === 1 && typeof ruleName === 'string') {
        return (_ref = this.data(PROP_NAME)) != null ? _ref[ruleName] : void 0;
      }
      if (typeof ruleName === 'string') {
        _ref1 = [{}, options], rules = _ref1[0], rules[ruleName] = _ref1[1];
      } else if ($.isPlainObject(ruleName)) {
        rules = ruleName;
      } else {
        rules = {};
      }
      this.each(function() {
        var data, element, namespace, previousRuleData, rule, ruleData, validator, _results;
        if (!(validator = $(this.form).data(VALIDATOR_PROP_NAME))) {
          return console.error("Form validator is not initialized.", this);
        } else {
          element = this;
          _results = [];
          for (rule in rules) {
            options = rules[rule];
            if (rule in $.validator.extendedMethods) {
              data = $.data(element, PROP_NAME) || $.data(element, PROP_NAME, {});
              previousRuleData = data[rule];
              ruleData = {
                options: options
              };
              namespace = {
                ruleName: rule,
                fullName: PROP_NAME + '-' + rule
              };
              $.validator.extendedMethods[rule].call(validator, element, ruleData, namespace, previousRuleData);
              _results.push(data[rule] = ruleData);
            } else {
              _results.push(console.error("Unsupported extended rule : " + rule));
            }
          }
          return _results;
        }
      });
      return this;
    };
    $.validator.addMethod('remote', function(value, element, param) {
      var data, previous, validator;
      if (this.optional(element)) {
        return 'dependency-mismatch';
      }
      previous = this.previousValue(element);
      if (!this.settings.messages[element.name]) {
        this.settings.messages[element.name] = {};
      }
      previous.originalMessage = this.settings.messages[element.name].remote;
      this.settings.messages[element.name].remote = previous.message;
      param = typeof param === 'string' ? {
        url: param
      } : param;
      if (this.pending[element.name]) {
        return 'pending';
      }
      if (previous.old === value) {
        return previous.valid;
      }
      previous.old = value;
      validator = this;
      this.startRequest(element);
      data = {};
      data[param.name || element.name] = value;
      $.ajax($.extend(true, {
        url: param,
        mode: 'abort',
        port: 'validate' + element.name,
        dataType: 'json',
        data: data,
        success: function(response) {
          var errors, message, submitted, valid;
          if ($.isFunction(this.successInternal)) {
            response = this.successInternal.apply(this, arguments);
          }
          validator.settings.messages[element.name].remote = previous.originalMessage;
          valid = response === true || response === 'true';
          if (valid) {
            submitted = validator.formSubmitted;
            validator.prepareElement(element);
            validator.formSubmitted = submitted;
            validator.successList.push(element);
            delete validator.invalid[element.name];
            validator.showErrors();
          } else {
            errors = {};
            message = response || validator.defaultMessage(element, 'remote');
            errors[element.name] = previous.message = (typeof message === "function" ? message(value) : void 0) || message;
            validator.invalid[element.name] = true;
            validator.showErrors(errors);
          }
          previous.valid = valid;
          return validator.stopRequest(element, valid);
        },
        error: function() {
          previous.old = null;
          validator.pendingRequest--;
          if (validator.pendingRequest < 0) {
            validator.pendingRequest = 0;
          }
          return delete validator.pending[element.name];
        }
      }, param));
      return 'pending';
    });
    $.validator.addMethod('exactlength', function(value, element, param) {
      return this.optional(element) || ((function(_this) {
        return function() {
          var length;
          length = $.isArray(value) ? value.length : _this.getLength($.trim(value), element);
          return length === parseInt(param);
        };
      })(this))();
    }, "정확히 {0}자로 입력하세요.");
    $.validator.addMethod('numeric', function(value, element, param) {
      return this.optional(element) || ((function(_this) {
        return function() {
          var patternFraction, patternInteger, regex;
          patternInteger = '\\d{1,' + (param[0] || '') + '}';
          patternFraction = param[1] > 0 ? '(\\.\\d{0,' + param[1] + '})?' : '';
          regex = new RegExp('^-?' + patternInteger + patternFraction + '$');
          return regex.test(value.toString());
        };
      })(this))();
    }, "numeric value out of bounds (<{0} digits>.<{1} digits> expected)");
    $.validator.addMethod('equal', function(value, element, param) {
      return this.optional(element) || value == param;
    }, "{0}을 입력하세요.");
    $.validator.addMethod('phone', function(value, element) {
      return this.optional(element) || /^[\-\+\(\)0-9]\{1,\}$/i.test(value);
    }, "전화번호 형식을 정확이 입력하세요.");
    $.validator.addMethod('keyLayout', function(value, element, param) {
      return this.optional(element) || value.length < param || ((function(_this) {
        return function() {
          var i, layout, repeat, _i, _ref;
          repeat = parseInt(param);
          if (!(repeat > 0)) {
            return true;
          }
          layout = '1234567890qwertyuiopasdfghjklzxcvbnm';
          for (i = _i = 0, _ref = value.length - repeat; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
            if (layout.contains(value.substr(i, i + repeat))) {
              return false;
            }
          }
          return true;
        };
      })(this))();
    }, "연속된 {0}자 이상의 문자는 입력할 수 없습니다.");
    $.validator.addMethod('keyRepeat', function(value, element, param) {
      return this.optional(element) || value.length < param || ((function(_this) {
        return function() {
          var regex, repeat;
          repeat = parseInt(param);
          if (!(repeat > 0)) {
            return true;
          }
          regex = new RegExp("(.)(?:.*\\1){" + (repeat - 1) + "}");
          return !regex.test(value);
        };
      })(this))();
    }, "동일한 {0}자 이상의 문자는 입력할 수 없습니다.");
    $.validator.addMethod('words', function(value, element) {
      return this.optional(element) || /^[\w-]+$/.test(value);
    }, "영문, 숫자 또는 (-,_) 형식으로 입력하세요.");
    $.validator.addMethod('ascii', function(value, element) {
      return this.optional(element) || /^[\u0000-\u007F]+$/.test(value);
    }, "영문, 숫자 또는 일부 특수문자(!,@,#,$,%,^,&,*,(,),-,+,=,_,/,\\,<,>,[,],{,},...) 만 입력하세요.");
    $.validator.addMethod('alphaOrNumber', function(value, element) {
      return this.optional(element) || /^[a-zA-Z0-9]*$/.test(value);
    }, "영문 또는 숫자로 입력하세요.");
    $.validator.addMethod('alphaAndNumber', function(value, element) {
      return this.optional(element) || (/^[a-zA-Z0-9]*$/.test(value) && /[a-zA-Z]{1,}/.test(value) && /[0-9]{1,}/.test(value));
    }, "영문과 숫자를 혼용하여 입력하세요.");
    $.validator.addMethod('startWithAlpha', function(value, element) {
      return this.optional(element) || /^[a-zA-Z]{1,}/.test(value);
    }, "첫글자는 영문으로 입력하세요.");
    $.validator.addMethod('hangul', function(value, element) {
      return this.optional(element) || /^[가-힣]+$/.test(value);
    }, "한글 형식으로 입력하세요.");
    $.validator.addMethod('containsNumber', function(value, element) {
      return this.optional(element) || /[0-9]{1,}/.test(value);
    }, "숫자를 포함해야 합니다.");
    $.validator.addMethod('lt', function(value, element, param) {
      return this.optional(element) || value < param;
    }, "Please enter a value less than {0}.");
    $.validator.addMethod('gt', function(value, element, param) {
      return this.optional(element) || value > param;
    }, "Please enter a value greater than {0}.");
    $.validator.addMethod('brnKO', function(value, element) {
      return this.optional(element) || ((function(_this) {
        return function() {
          var brn, checkIDs, checkSum, checkTemp, i, _i;
          brn = value.replace(/-/g, '');
          checkIDs = [1, 3, 7, 1, 3, 7, 1, 3, 5];
          checkSum = 0;
          checkTemp = null;
          for (i = _i = 0; _i < 8; i = ++_i) {
            checkSum += checkIDs[i] * brn.charAt(i) % 10;
          }
          checkTemp = checkIDs[8] * brn.charAt(8) + '0';
          checkSum += parseFloat(checkTemp.charAt(0));
          checkSum += parseFloat(checkTemp.charAt(1));
          return parseInt(brn.charAt(9)) === ((10 - (checkSum % 10)) % 10);
        };
      })(this))();
    }, "형식에 맞지 않는 사업자 번호입니다.");
    if (window.EUCKR_CODES != null) {
      $.validator.addMethod('koreanChars', function(value, element) {
        var c, exceptChars, i, previous, valid, _i, _ref, _ref1;
        if (this.optional(element) || ((_ref = window.event) != null ? _ref.type : void 0) === 'keyup' && (window.event.keyCode || window.event.charCode) !== 13) {
          return 'dependency-mismatch';
        }
        previous = $.data(element, 'previousValue') || $.data(element, 'previousValue', {
          old: null,
          valid: true
        });
        if (previous.old === value) {
          return previous.valid;
        }
        previous.old = value;
        exceptChars = $.data(element, 'exceptChars', []);
        for (i = _i = 0, _ref1 = value.length; 0 <= _ref1 ? _i < _ref1 : _i > _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
          if (!(value.charCodeAt(i) in window.EUCKR_CODES)) {
            c = value.charAt(i);
            if (__indexOf.call(exceptChars, c) < 0) {
              exceptChars.push(c);
            }
          }
        }
        valid = exceptChars.length === 0;
        previous.valid = valid;
        return valid;
      }, function(params, element) {
        var exceptChars, message;
        message = "허용되지 않는 문자가 입력되었습니다.";
        exceptChars = $.data(element, 'exceptChars');
        if ((exceptChars != null ? exceptChars.length : void 0) > 0) {
          message += "\n[" + exceptChars + "]";
        }
        return $.validator.format(message, params);
      });
    }
    return $.validator;
  });

}).call(this);

//# sourceMappingURL=jquery-validate-extends.js.map
