(function() {
  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery-extends'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';
    $.messages = $.extend($.messages || {}, {
      'am': '오전',
      'pm': '오후',
      'dayShortNames': ['일', '월', '화', '수', '목', '금', '토'],
      'dayLongNames': ['일요일', '월요일', '화요일', '수요일', '목요일', '금요일', '토요일'],
      'monthShortNames': ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월'],
      'monthLongNames': ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월']
    });
    return $.messages;
  });

}).call(this);

//# sourceMappingURL=jquery-extends-locale_ko-kr.js.map
