###!
# @name jQuery Currency plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-extends >= 1.0.0
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery-extends')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  PROP_NAME = '$currency'

  defaults =
    initial: true
    maxIntegerDigits: 0
    maxFractionDigits: 3
    fractionRound: false
    fractionFillZeros: true
    groupDigits: true
    symbol: ''
    decimalSymbol: '.'
    digitGroupSymbol: ','

  normalizeOptions = (options) ->
    options = $.extend {}, defaults, switch typeof options
      when 'boolean' then initial: options
      when 'string' then digitGroupSymbol: options
      when 'number' then maxFractionDigits: options
      else (if $.isPlainObject options then options else {})

    if options.decimalSymbol
      options.decimalSymbol = options.decimalSymbol.charAt(0)  if options.decimalSymbol.length > 1
      $.error "Decimal symbol must not be digits"  if /[0-9]/.test options.decimalSymbol

    if options.digitGroupSymbol
      options.digitGroupSymbol = options.digitGroupSymbol.charAt(0)  if options.digitGroupSymbol.length > 1
      $.error "Digit group symbol must not be digits"  if /[0-9]/.test options.digitGroupSymbol

    $.error "Decimal symbol must not be equal to digit group symbol"  if options.decimalSymbol is options.digitGroupSymbol

    if options.symbol
      $.error "Symbol must not be contains digits"  if /[0-9]/.test options.symbol
      $.error "Symbol must not be contains : " + options.decimalSymbol  if options.decimalSymbol and options.symbol.contains options.decimalSymbol
      $.error "Symbol must not be contains : " + options.digitGroupSymbol  if options.digitGroupSymbol and options.symbol.contains options.digitGroupSymbol

    options
  #end of normalizeOptions = (options) ->

  isNumeric = (value) -> not isNaN(parseFloat(value)) and isFinite(value)
  isExponential = (value) -> /^\d(\.\d+)?e\+\d+$/i.test(value)

  fractionFillZeros = (value, options) ->
    if value.length > 0 and options.fractionFillZeros and options.maxFractionDigits > 0
      value = '0'  if value is '-'

      period = value.indexOf(options.decimalSymbol)
      if period is -1
        period = value.length
        value += options.decimalSymbol

      fractionLength = value.length - period - 1
      value += $.fill(options.maxFractionDigits - fractionLength, '0')  if fractionLength < options.maxFractionDigits
    value
  #end of fractionFillZeros = (value, options) ->

  $.fn.currency = (options) ->
    switch options
      when 'hasCurrency' then return !!@data(PROP_NAME)
      when 'cleanValue' then return ((options) =>
        value = $.trim(@val())
        if options
          isNegative = false
          begin = 0

          if value.charAt(begin) is '-'
            isNegative = true
            begin++

          begin++  if value.charAt(begin) is options.symbol
          value = value[begin..]  if begin > 0

          if options.groupDigits and options.digitGroupSymbol
            pattern = options.digitGroupSymbol.replace(/([\^\.\?\*\(\)\[\]])/g, '\\$1')
            regex = new RegExp('[' + pattern + ']', 'g')
            value = value.replace(regex, '')

          value = value.replace(options.decimalSymbol, '.')  unless options.decimalSymbol is '.'
          value = '-' + value  if isNegative
        value
      )(@data PROP_NAME)
      when 'toNumber' then return (=>
        value = @currency('cleanValue')
        if value.contains '.'
          parseFloat(value)
        else
          parseInt(value) or 0
      )()

    options = normalizeOptions(options)
    targets = @filter('input')
    targets.removeData PROP_NAME + '.previousValue'
    targets.data PROP_NAME, options
    targets.off '.' + PROP_NAME
    targets.on 'keypress.' + PROP_NAME, (e) ->
      options = $.data(@, PROP_NAME)
      keyCode = e.keyCode or e.charCode
      decimalSymbolCode = options.decimalSymbol.charCodeAt(0)
      minusCode = '-'.charCodeAt(0)
      position = if 'selectionStart' of @ then @selectionStart else -1
      position = 0  if position > 0 and /^\s+$/g.test(@value[0...position])

      e.preventDefault()  unless 48 <= keyCode <= 57 or
                                (keyCode is decimalSymbolCode and not @value.contains options.decimalSymbol) or
                                (position <= 0 and keyCode is minusCode and not @value.contains '-')

    targets.on 'keyup.{0} blur.{0} change.{0}'.format(PROP_NAME), (e) ->
      $.removeData(@, PROP_NAME + '.canceledChangeEvent')  if e.type is 'change'

      $(@).change()  if e.type is 'blur' and $.data(@, PROP_NAME + '.canceledChangeEvent')

      if e.type is 'keyup'
        return  unless 'selectionStart' of @
        keyCode = e.keyCode or e.charCode
        return  if keyCode is 20 or       # CAPS LOCK
                   keyCode is 27 or       # ESC
                   keyCode in [16..18] or # SHIFT,CTRL,ALT
                   keyCode in [33..40]    # HOME,END,PGUP,UPDN,CURSOR(LEFT, RIGHT, UP, DOWN)

      return  unless @value

      if @value is $.data(@, PROP_NAME + '.previousValue')
        @value = fractionFillZeros(@value, $.data(@, PROP_NAME))  unless e.type.startsWith 'key'
        return #nothing

      # 지수형식은 그냥 보여준다.
      if isExponential $.trim(@value)
        @value = $.trim(@value)  unless e.type.startsWith 'key'
        return #nothing

      options = $.data(@, PROP_NAME)
      selection =
        direction: @selectionDirection
        start: @selectionStart
        end: @selectionEnd
        correction: 0
      cleanValue = ''
      isNegative = false
      hasDot = false

      for i in [0...@value.length]
        c = @value.charAt(i)
        if c is options.digitGroupSymbol
          selection.correction++  if selection.start > i
          continue

        if c is options.decimalSymbol
          if hasDot
            selection.correction++  if selection.start > i
            continue

          if cleanValue is ''
            cleanValue += '0'
            selection.correction--  if selection.start > i

          hasDot = true

        else unless /[0-9]/.test c
          isNegative = true  if c is '-' and cleanValue.length is 0
          selection.correction++  if selection.start > i
          continue

        cleanValue += c

      period = cleanValue.indexOf(options.decimalSymbol)
      integerDigits = if period > -1 then cleanValue[0...period] else cleanValue
      fractionDigits = null

      if period > -1 and options.maxFractionDigits > 0
        startFractionPosition = period + 1
        endFractionPosition = period + 1 + options.maxFractionDigits
        fractionDigits = cleanValue[startFractionPosition...endFractionPosition]
        if options.fractionRound and cleanValue[endFractionPosition...endFractionPosition+1] >= 5
          fractionDigits = fractionDigits[0...-1] + (parseInt(fractionDigits[-1..]) + 1)

      if integerDigits.length > 0
        cleanedZeros = integerDigits.replace(/^0+(0|[^0].*)$/, '$1')
        if cleanedZeros.length isnt integerDigits.length
          selection.correction += integerDigits.length - cleanedZeros.length
          integerDigits = cleanedZeros

        if integerDigits.length > options.maxIntegerDigits and options.maxIntegerDigits
          currentPosition = selection[if selection.direction is 'backward' then 'start' else 'end'] - selection.correction
          selection.correction += currentPosition - options.maxIntegerDigits  if currentPosition > options.maxIntegerDigits and currentPosition <= integerDigits.length
          integerDigits = integerDigits[0...options.maxIntegerDigits]

      selection.start -= selection.correction
      selection.end -= selection.correction
      selection.correction = 0

      currencyValue
      if options.groupDigits
        currencyValueUnits = []
        count = 0
        for i in [integerDigits.length-1..0]
          if count > 0 and not (count % 3)
            selection.correction--  if selection.start > i
            currencyValueUnits.unshift options.digitGroupSymbol
          currencyValueUnits.unshift integerDigits.charAt(i)
          count++
        currencyValue = currencyValueUnits.join('')
      else
        currencyValue = integerDigits
      currencyValue += options.decimalSymbol + fractionDigits  unless fractionDigits is null

      if options.symbol and currencyValue.length > 0
        currencyValue = options.symbol + currencyValue
        selection.correction -= options.symbol.length

      if isNegative
        currencyValue = '-' + currencyValue
        selection.correction--

      unless e.type.startsWith 'key'
        @value = fractionFillZeros(currencyValue, options)
      else if @value isnt currencyValue
        @value = currencyValue
        @selectionStart = selection.start - selection.correction
        @selectionEnd = selection.end - selection.correction
        @selectionDirection = selection.direction
        $.data(@, PROP_NAME + '.canceledChangeEvent', true)
      $.data(@, PROP_NAME + '.previousValue', @value)

      return #nothing
    #end of targets.on 'keypress.' + PROP_NAME, (e) ->

    targets.change()  if options.initial
    @
  #end of $.fn.currency = (options) ->

  $.currency = (input, options) ->
    return input  unless isNumeric input
    input = $.trim(input.toString())
    return input  if isExponential input

    options = normalizeOptions(options)

    isNegative = if input.charAt(0) is '-' then input = input[1..]; true else false

    period = input.indexOf(options.decimalSymbol)
    integerDigits = if period > -1 then input[0...period] else input
    fractionDigits = null

    if period > -1 and options.maxFractionDigits > 0
      startFractionPosition = period + 1
      endFractionPosition = period + 1 + options.maxFractionDigits
      fractionDigits = input[startFractionPosition...endFractionPosition]
      if options.fractionRound and input[endFractionPosition...endFractionPosition+1] >= 5
        fractionDigits = fractionDigits[0...-1] + (parseInt(fractionDigits[-1..]) + 1)
      fractionDigits = null  if parseInt(fractionDigits) is 0

    if integerDigits.length > 0
      cleanedZeros = integerDigits.replace(/^0+(0|[^0].*)$/, '$1')
      integerDigits = cleanedZeros  unless cleanedZeros.length is integerDigits.length
      integerDigits = integerDigits[0...options.maxIntegerDigits]  if integerDigits.length > options.maxIntegerDigits and options.maxIntegerDigits

    currencyValue
    if options.groupDigits
      currencyValueUnits = []
      count = 0
      for i in [integerDigits.length-1..0]
        currencyValueUnits.unshift options.digitGroupSymbol  unless count is 0 or count % 3
        currencyValueUnits.unshift integerDigits.charAt(i)
        count++
      currencyValue = currencyValueUnits.join('')
    else
      currencyValue = integerDigits
    currencyValue += options.decimalSymbol + fractionDigits  unless fractionDigits is null
    currencyValue = options.symbol + currencyValue  if options.symbol and currencyValue.length > 0
    currencyValue = '-' + currencyValue  if isNegative
    fractionFillZeros(currencyValue, options)
  #end of $.currency = (input, options) ->

  Number::currency = (options) -> $.currency(@, options)
  String::currency = (options) -> $.currency(@toString(), options)

  # Exports
  $.currency
