((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery-extends')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  $.messages = $.extend $.messages or {},
    'am': '오전'
    'pm': '오후'
    'dayShortNames': ['일', '월', '화', '수', '목', '금', '토']
    'dayLongNames': ['일요일', '월요일', '화요일', '수요일', '목요일', '금요일', '토요일']
    'monthShortNames': ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월']
    'monthLongNames': ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월']

  # Exports
  $.messages
