###!
# @name jQuery Apply Field plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-extends >= 1.0.0
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery-extends')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  ###*
  # @description Converter Store.
  ###
  converterStore =
    log: -> console.log @; return undefined
    array: -> @array = true; return undefined
    ignoreEmpty: -> @value? and @value isnt ''
    ignoreBlank: -> @value? and @value.trim() isnt ''

  ###*
  # @description Normalize Converters
  # @param {string|function|array} converters then converters.
  ###
  normalizeConverters = (converters) ->
    unless $.isArray converters
      converters = if typeof converters is 'string' then converters.split(/\s+/) else [converters]

    $.map converters, (converter) ->
      return converter  unless typeof converter is 'string'
      unless converter is ''
        $.error "Converter not found : " + converter  unless converter of converterStore
        converterStore[converter]

  ###*
  # @description
  #
  # Converter Provider.
  # Converter 우선순위: general &gt; regex &gt; defaults
  # ex1) { '*': 'ignoreEmpty array' }
  # ex2) { '*': ['ignoreEmpty', 'array', function(){}]
  #
  # @param {object} rawConverters 가공되지 않은 Converters
  ###
  class ConverterProvider
    constructor: (rawConverters) ->
      $.error "RawConverters must be plain object"  unless $.isPlainObject rawConverters

      @general = {}
      @regex = []
      @defaults = []

      for key, value of rawConverters
        converters = normalizeConverters(value)

        if /^\*+$/.test key
          $.merge(@defaults, converters)

        else if key.charAt(0) is '/' and key.charAt(1) isnt '/' and (lsp = key.lastIndexOf('/')) > 1
          pattern = key[1...lsp]
          flag = key[lsp+1..]

          @regex.push
            regex: new RegExp(pattern, flag)
            converters: converters

        else if key.contains '*'
          @regex.push
            regex: new RegExp('^' + key.replace(/\*+/g, '.*') + '$')
            converters: converters

        else
          @general[key] = converters

    ###*
    # @description
    # 파라미터이름으로 Converter를 찾는다.
    #
    # @param {string} param 파라미터 이름
    # @param {string} [root] 파라미터 루트
    # @returns {*}
    ###
    find: (param, root) ->
      $.error("Param must be string")  unless typeof param is 'string'

      if root
        $.error "Param must be starts with '#{root}'"  unless param.startsWith root
        param = param[root.length..]
        param = param[1..]  if param.charAt(0) is '.'

      converters = []
      $.merge(converters, @general[param])  if param of @general
      ($.merge(converters, r.converters)  if r.regex.test param)  for r in @regex
      $.merge(converters, @defaults)

  #end of class ConverterProvider

  ###*
  # @param {boolean} [isDefault] 기본값 사용 여부 (default is false)
  # @param {string} [root] 파라미터 루트 (default is "")
  # @param {object} data 데이타
  # @param {object|ConverterProvider} [converterProvider] Converters
  # @param {function} [callback] Callback (default is $.noop)
  # @param {boolean} [isDebug] 디버깅 메시지 출력 여부 (default is false)
  ###
  $.fn.applyField = (isDefault, root, data, converterProvider, callback, isDebug) ->
    return @  unless @length > 0

    PROP_NAME = '$applyField'

    args = $.makeArray(arguments)
    isDefault = if typeof args[0] is 'boolean' then args.shift() else false
    root = if typeof args[0] is 'string' then args.shift() else ''
    data = args.shift()
    converterProvider = if args[0] instanceof ConverterProvider
      args.shift()
    else
      new ConverterProvider(if $.isPlainObject args[0] then args.shift() else {})
    callback = if $.isFunction args[0] then args.shift() else $.noop
    isDebug = if typeof args[0] is 'boolean' then args.shift() else false

    @filter('form').each ->
      $this = $(@)

      if isDefault
        $this.data PROP_NAME, [root, data, converterProvider, callback]
        $this.off 'reset.' + PROP_NAME
        $this.on 'reset.' + PROP_NAME, ->
          $.nextTick ->
            data = $this.data(PROP_NAME)
            $this.applyField.apply($this, data)  if data
          return #nothing

      (applyField = (form, param) ->
        for converter in converterProvider.find(param.name, root)
          converter = converter.call(param, root, data, form)  if $.isFunction converter
          return  if converter is false
          continue  if converter is true
          param.value = converter  unless typeof converter is 'undefined'

        {name, value} = param

        if param.array
          value = [value]  unless $.isArray value
          for val, i in value
            if $.isPlainObject val
              for k, v of val
                $.nextTick -> applyField(form,
                  name: if name then "#{name}[#{i}].#{k}" else "#{k}[#{i}]"
                  value: v
                )
            else
              $.nextTick -> applyField(form,
                name: "#{name}[#{i}]"
                value: val
              )

        else if $.isPlainObject value
          for key, val of value
            $.nextTick -> applyField(form,
              name: (if name then name + '.' else '') + key
              value: val
            )

        else
          elements = $(form).findByName(name)
          multiples = elements.filter(':checkbox, :radio, select')
          textboxes = elements.not(multiples)

          multiples.val(if $.isArray value then value else [value])  if multiples.length > 0

          if textboxes.length is 1
            textboxes.val(value)  unless typeof value is 'undefined'
          else if textboxes.length > 1
            if $.isArray value
              for textbox, i in textboxes
                break  unless i < value.length
                $(textbox).val(value[i])  unless typeof value[i] is 'undefined'
            else unless typeof value is 'undefined'
              textboxes.first().val(value)

          callback.call(elements, elements, value)  if elements.length > 0

          console.log "%s: %o, %o", name, value, elements.get()  if isDebug
        return undefined
      )(@, name: root, value: data)
    #end of @filter('form').each ->
    @
  #end of $.fn.applyField

  # Exports
  $.applyField =
    converters: converterStore
    ConverterProvider: ConverterProvider
