###!
# @name jQuery Browser plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
###

((root, factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery'], ($) -> factory root, $
  else if typeof exports is 'object'
    # CommonJS
    factory root, require('jquery')
  else
    # Browser globals
    factory root, jQuery
) (if window? then window else this), (window, $) ->
  'use strict'

  $.uaMatch = (ua) ->
    ua = ua.toLowerCase()
    match = /(edge)\/([\w.]+)/.exec(ua) or
        /(opr)[\/]([\w.]+)/.exec(ua) or
        /(chrome)[ \/]([\w.]+)/.exec(ua) or
        /(version)(applewebkit)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(ua) or
        /(webkit)[ \/]([\w.]+).*(version)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(ua) or
        /(webkit)[ \/]([\w.]+)/.exec(ua) or
        /(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) or
        /(msie) ([\w.]+)/.exec(ua) or
        ua.indexOf('trident') >= 0 and /(rv)(?::| )([\w.]+)/.exec(ua) or
        ua.indexOf('compatible') < 0 and /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) or
        []
    platform_match = /(ipad)/.exec(ua) or
        /(ipod)/.exec(ua) or
        /(iphone)/.exec(ua) or
        /(kindle)/.exec(ua) or
        /(silk)/.exec(ua) or
        /(android)/.exec(ua) or
        /(windows phone)/.exec(ua) or
        /(win)/.exec(ua) or
        /(mac)/.exec(ua) or
        /(linux)/.exec(ua) or
        /(cros)/.exec(ua) or
        /(playbook)/.exec(ua) or
        /(bb)/.exec(ua) or
        /(blackberry)/.exec(ua) or
        []

    browser: match[5] or match[3] or match[1] or ''
    version: match[2] or match[4] or '0'
    versionNumber: match[4] or match[2] or '0'
    platform: platform_match[0] or ''

  matched = $.uaMatch(window.navigator.userAgent)
  browser = {}
  if matched.browser
    browser[matched.browser] = true
    browser.version = matched.version
    browser.versionNumber = parseInt(matched.versionNumber, 10)
  browser[matched.platform] = true  if matched.platform

  # These are all considered mobile platforms, meaning they run a mobile browser
  browser.mobile = true  if browser.android or browser.bb or browser.blackberry or browser.ipad or browser.iphone or browser.ipod or browser.kindle or browser.playbook or browser.silk or browser['windows phone']

  # These are all considered desktop platforms, meaning they run a desktop browser
  browser.desktop = true  if browser.cros or browser.mac or browser.linux or browser.win

  # Chrome, Opera 15+ and Safari are webkit based browsers
  browser.webkit = true  if browser.chrome or browser.opr or browser.safari

  # IE11 has a new token so we will assign it msie to avoid breaking changes
  # IE12 disguises itself as Chrome, but adds a new Edge token.
  if browser.rv or browser.edge
    matched.browser = 'msie'
    browser['msie'] = true

  # Blackberry browsers are marked as Safari on BlackBerry
  if browser.safari and browser.blackberry
    matched.browser = 'blackberry'
    browser['blackberry'] = true

  # Playbook browsers are marked as Safari on Playbook
  if browser.safari and browser.playbook
    matched.browser = 'playbook'
    browser['playbook'] = true

  # BB10 is a newer OS version of BlackBerry
  if browser.bb
    matched.browser = 'blackberry'
    browser['blackberry'] = true

  # Opera 15+ are identified as opr
  if browser.opr
    matched.browser = 'opera'
    browser['opera'] = true

  # Stock Android browsers are marked as Safari on Android.
  if browser.safari and browser.android
    matched.browser = 'android'
    browser['android'] = true

  # Kindle browsers are marked as Safari on Kindle
  if browser.safari and browser.kindle
    matched.browser = 'kindle'
    browser['kindle'] = true

  # Kindle Silk browsers are marked as Safari on Kindle
  if browser.safari and browser.silk
    matched.browser = 'silk'
    browser['silk'] = true

  # Assign the name and platform variable
  browser.name = matched.browser
  browser.platform = matched.platform
  $.browser = browser

  # Exports
  browser
