
/*!
 * @name jQuery Browser plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 */

(function() {
  (function(root, factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery'], function($) {
        return factory(root, $);
      });
    } else if (typeof exports === 'object') {
      return factory(root, require('jquery'));
    } else {
      return factory(root, jQuery);
    }
  })((typeof window !== "undefined" && window !== null ? window : this), function(window, $) {
    'use strict';
    var browser, matched;
    $.uaMatch = function(ua) {
      var match, platform_match;
      ua = ua.toLowerCase();
      match = /(edge)\/([\w.]+)/.exec(ua) || /(opr)[\/]([\w.]+)/.exec(ua) || /(chrome)[ \/]([\w.]+)/.exec(ua) || /(version)(applewebkit)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(ua) || /(webkit)[ \/]([\w.]+).*(version)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(ua) || /(webkit)[ \/]([\w.]+)/.exec(ua) || /(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) || /(msie) ([\w.]+)/.exec(ua) || ua.indexOf('trident') >= 0 && /(rv)(?::| )([\w.]+)/.exec(ua) || ua.indexOf('compatible') < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) || [];
      platform_match = /(ipad)/.exec(ua) || /(ipod)/.exec(ua) || /(iphone)/.exec(ua) || /(kindle)/.exec(ua) || /(silk)/.exec(ua) || /(android)/.exec(ua) || /(windows phone)/.exec(ua) || /(win)/.exec(ua) || /(mac)/.exec(ua) || /(linux)/.exec(ua) || /(cros)/.exec(ua) || /(playbook)/.exec(ua) || /(bb)/.exec(ua) || /(blackberry)/.exec(ua) || [];
      return {
        browser: match[5] || match[3] || match[1] || '',
        version: match[2] || match[4] || '0',
        versionNumber: match[4] || match[2] || '0',
        platform: platform_match[0] || ''
      };
    };
    matched = $.uaMatch(window.navigator.userAgent);
    browser = {};
    if (matched.browser) {
      browser[matched.browser] = true;
      browser.version = matched.version;
      browser.versionNumber = parseInt(matched.versionNumber, 10);
    }
    if (matched.platform) {
      browser[matched.platform] = true;
    }
    if (browser.android || browser.bb || browser.blackberry || browser.ipad || browser.iphone || browser.ipod || browser.kindle || browser.playbook || browser.silk || browser['windows phone']) {
      browser.mobile = true;
    }
    if (browser.cros || browser.mac || browser.linux || browser.win) {
      browser.desktop = true;
    }
    if (browser.chrome || browser.opr || browser.safari) {
      browser.webkit = true;
    }
    if (browser.rv || browser.edge) {
      matched.browser = 'msie';
      browser['msie'] = true;
    }
    if (browser.safari && browser.blackberry) {
      matched.browser = 'blackberry';
      browser['blackberry'] = true;
    }
    if (browser.safari && browser.playbook) {
      matched.browser = 'playbook';
      browser['playbook'] = true;
    }
    if (browser.bb) {
      matched.browser = 'blackberry';
      browser['blackberry'] = true;
    }
    if (browser.opr) {
      matched.browser = 'opera';
      browser['opera'] = true;
    }
    if (browser.safari && browser.android) {
      matched.browser = 'android';
      browser['android'] = true;
    }
    if (browser.safari && browser.kindle) {
      matched.browser = 'kindle';
      browser['kindle'] = true;
    }
    if (browser.safari && browser.silk) {
      matched.browser = 'silk';
      browser['silk'] = true;
    }
    browser.name = matched.browser;
    browser.platform = matched.platform;
    $.browser = browser;
    return browser;
  });

}).call(this);

//# sourceMappingURL=jquery-browser.js.map
