
/*!
 * @name jQuery Center plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 *   jquery-extends >= 1.0.0
 */

(function() {
  (function(root, factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends'], function($) {
        return factory(root, $);
      });
    } else if (typeof exports === 'object') {
      return factory(root, require('jquery-extends'));
    } else {
      return factory(root, jQuery);
    }
  })((typeof window !== "undefined" && window !== null ? window : this), function(window, $) {
    'use strict';

    /**
     * @param {boolean} [isFixed]
     * @param {string} [mode] h, v, horizental, or verital
     * @returns {$.fn}
     */
    $.fn.center = function(isFixed, mode) {
      var isHorizental, isVertical, position, sx, sy, wh, ww, _ref;
      if (!(this.length > 0)) {
        return this;
      }
      if (typeof isFixed !== 'boolean') {
        _ref = [isFixed, false], mode = _ref[0], isFixed = _ref[1];
      }
      isHorizental = mode !== 'v' && mode !== 'vertical';
      isVertical = mode !== 'h' && mode !== 'horizental';
      ww = $(window).width();
      wh = $(window).height();
      sx = isFixed ? 0 : $(document).scrollLeft();
      sy = isFixed ? 0 : $(document).scrollTop();
      position = isFixed ? 'fixed' : 'absolute';
      this.filter(':visible').each(function() {
        var $h, $this, $w, left, top;
        $this = $(this);
        if ($this.parents().is(function() {
          return $(this).css('position') === 'fixed';
        })) {
          $this.appendTo(document.body);
        }
        $this.css({
          position: position,
          zIndex: $.maxZIndex() + 1
        });
        if (isHorizental) {
          $w = $this.outerWidth();
          left = ww / 2 - $w / 2 + sx;
          if (left < 0) {
            left = 0;
          }
          $this.css('left', left);
        }
        if (isVertical) {
          $h = $this.outerHeight();
          top = wh / 2 - $h / 2 + sy;
          if (top < 0) {
            top = 0;
          }
          $this.css('top', top);
        }
        return void 0;
      });
      return this;
    };
    return $.fn.center;
  });

}).call(this);

//# sourceMappingURL=jquery-center.js.map
