###!
# @name jQuery extends
# @version 1.0.0
# @requires:
#   jquery >= 1.7
###

((root, factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery'], ($) -> factory root, $
  else if typeof exports is 'object'
    # CommonJS
    factory root, require('jquery')
  else
    # Browser globals
    factory root, jQuery
) (if window? then window else this), (window, $) ->
  'use strict'

  # Default messages
  $.messages = $.extend
    am: 'AM'
    pm: 'PM'
    dayShortNames: ['SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT']
    dayLongNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
    monthShortNames: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
    monthLongNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'Decomber']
  , $.messages

  $.extend

    nextTick: (callback) -> setTimeout(callback, 0)

    namespace: (name, props) ->
      return @  unless name
      obj = @
      for nameFragment in $.split(name, '.', '/')
        obj[nameFragment] = {}  unless obj[nameFragment]?
        obj = obj[nameFragment]
      $.extend obj, props

    ###*
    # @param {date|number|string} input
    ###
    parseDate: (input) ->
      if typeof input is 'string'
        switch input.length
          when 4 # maybe 'yyyy'
            return new Date(input, 0, 1)  if (/\d{4}/.test(input))
          when 6 # maybe 'yyyyMM'
            [year, month] = input.match(/(\d{4})(\d{2})/)?[1..2] or []
            return new Date(year, month - 1, 1)  if year? and month?
          when 7 # maybe 'yyyy-MM', 'yyyy.MM', 'yyyy/MM'
            [year, month] = input.match(/(\d{4})[\-\.\/](\d{2})/)?[1..2] or []
            return new Date(year, month - 1, 1)  if year? and month?
          when 8 # maybe 'yyyyMMdd'
            [year, month, day] = input.match(/(\d{4})(\d{2})(\d{2})/)?[1..3] or []
            return new Date(year, month - 1, day)  if year? and month? and day?
          when 10 # maybe 'yyyy-MM-dd', 'yyyy.MM.dd', 'yyyy/MM/dd'
            [year, month, day] = input.match(/(\d{4})[\-\.\/](\d{2})[-\.](\d{2})/)?[1..3] or []
            return new Date(year, month - 1, day)  if year? and month? and day?
      new Date(input)

    ###*
    # @param {array|object} items
    # @param {function} callback
    ###
    some: (items, callback) ->
      $.error callback + " is not a function"  unless $.isFunction callback
      if $.isArray items
        for item, i in items then return true  if callback.call(window, item, i)
      else if $.isPlainObject items
        for key, item of items then return true  if callback.call(window, item, key)
      else
        $.error items + " is not array or plain object"
      false

    ###*
    # @param {boolean|number} [checkbyte] check byte length if true. (default is false)
    # @param {string} string
    ###
    getLength: (checkbyte, string) ->
      args = $.makeArray(arguments)
      checkbyte = if typeof args[0] in ['boolean','number'] then args.shift() else false
      $.error args[0] + " is not a string"  unless typeof args[0] is 'string'
      string = args.shift()

      return string.length  if checkbyte is false

      length = 0
      for i in [0...string.length]
        c = string.charCodeAt(i)
        length += switch
          when c <= 0x00007F                                  then 1
          when typeof checkbyte is 'number' and checkbyte > 0 then checkbyte
          when c <= 0x0007FF                                  then 2
          when c <= 0x00FFFF                                  then 3
          else                                                     4
      length

    ###*
    # @param {boolean|number} [checkbyte] check byte length if true. (default is false)
    # @param {string} string
    # @param {number} maxLength the max length.
    # @param {string} [suffix] the suffix.
    ###
    cutstring: (checkbyte, string, maxLength, suffix) ->
      args = $.makeArray(arguments)
      checkbyte = if typeof args[0] in ['boolean','number'] then args.shift() else false
      $.error args[0] + " is not a string"  unless typeof args[0] is 'string'
      string = args.shift()
      $.error args[0] + " is not a number"  unless typeof args[0] is 'number'
      maxLength = args.shift()
      suffix = if typeof args[0] is 'string' then args.shift() else ''

      length = $.getLength(checkbyte, string)
      return string  unless length > maxLength

      suffixLength = $.getLength(checkbyte, suffix)
      $.error "Max length must be more than suffix length"  if suffixLength > maxLength

      newString = ''
      checkedLength = 0
      for i in [0...string.length]
        c = string.charAt(i)
        l = $.getLength(checkbyte, c)
        break  if checkedLength + l > maxLength - suffixLength
        checkedLength += l
        newString += c
      newString + suffix

    ###*
    # @param {number} size the size.
    # @param {string} [fillChar] the fill character.
    ###
    fill: (size, fillChar) ->
      $.error size + " is not a number"  unless typeof size is 'number'
      fillChar = " "  if typeof fillChar is 'undefined'
      $.error fillChar + " is not a string"  unless typeof fillChar is 'string'
      Array(1 + size).join(fillChar)

    ###*
    # @param {string} string the string.
    # @param {number} size the size.
    # @param {string} [fillChar] the fill character.
    ###
    leftPad: (string, size, fillChar) ->
      string = ''  if typeof string is 'undefined'
      string = string.toString()  unless typeof string is 'string'
      $.error size + " is not a number"  unless typeof size is 'number'
      fillChar = " "  if typeof fillChar is 'undefined'
      $.error fillChar + " is not a string"  unless typeof fillChar is 'string'
      if string.length >= size then string else $.fill(size - string.length, fillChar) + string

    ###*
    # @param {string} string the string.
    # @param {number} size the size.
    # @param {string} [fillChar] the fill character.
    ###
    rightPad: (string, size, fillChar) ->
      string = ''  if typeof string is 'undefined'
      string = string.toString()  unless typeof string is 'string'
      $.error size + " is not a number"  unless typeof size is 'number'
      fillChar = " "  if typeof fillChar is 'undefined'
      $.error fillChar + " is not a string"  unless typeof fillChar is 'string'
      if string.length >= size then string else string + $.fill(size - string.length, fillChar)

    ###*
    # Max zIndex from document body.
    ###
    maxZIndex: (excludes) -> $(document.body).maxZIndex excludes

    ###*
    # @param {object} [attrs] the attributes.
    # @param {object|array} values the values.
    # @returns {*|HTMLElement}
    ###
    makeInput: (attrs, values) ->
      args = $.makeArray(arguments)
      attrs = $.extend(type: 'hidden', if $.isPlainObject args[0] then args.shift() else {})
      values = if $.isArray args[0] then args.shift() else if args.length > 0 then args else ['']
      $(for value in values
        $input = $('<input/>', attrs)
        if $.isPlainObject value
          $input.attr('type', value.type)  if 'type' of value
          $input.attr('name', value.name)  if 'name' of value
          $input.val(value.value)  if 'value' of value
        else
          $input.val(value)
        $input.get(0)
      )

    xmlToString: (xmlNode) -> try
      # Gecko- and Webkit-based browsers (Firefox, Chrome), Opera, IE9.
      (new XMLSerializer()).serializeToString xmlNode
    catch
      # Other browsers without XML Serializer
      $.error "XMLSerializer not supported"  unless xmlNode.xml?
      # Internet Explorer IE.
      xmlNode.xml

    deserialize: (querystring, options) ->
      return {}  unless typeof querystring is 'string' and querystring isnt ''

      pairs = querystring.split(/&amp;|&/i)
      options = {}  unless $.isPlainObject options
      o = {}
      for pair in pairs
        [name, value] = pair.split('=')
        name = decodeURIComponent(name)
        value = decodeURIComponent(value)
        $.obj.set(true, o, name, value)  unless options.except? and name in options.except
      o

    split: (str, separator, escapeChar, limit) ->
      if typeof separator is 'number'
        [limit, separator, escapeChar] = [separator, null, null]
      else if typeof escapeChar is 'number'
        [limit, escapeChar] = [escapeChar, null]

      str = str.toString()
      limited = (i) -> 0 < limit <= i + 1
      parts = []
      i = 0
      s = 0
      while (p = str.indexOf(separator, s)) isnt -1 and not limited(i)
        part = str[s...p]
        escaped = false
        if escapeChar and part[-1..] is escapeChar
          part = part[0...-1]
          escaped = part[-1...] isnt escapeChar
          part += separator  if escaped
        parts[i] = (parts[i] or '') + part
        s = p + 1
        i++  unless escaped
      parts[i] = (parts[i] or '') + str[s..]  if s <= str.length
      parts

    supportsInputType: (type) ->
      input = document.createElement('input')
      input.setAttribute 'type', type
      input.type is type

    antStylePathToRegex: (path) ->
      $.error "Path must be string type : " + path  unless typeof path is 'string'
      $.error "Path must not be empty."  unless path.length > 0

      path = path.replace(/\/{2,}/g, '/')
      path = path.replace(/[-[\]{}()+.,\\^$|#\s]/g, '\\$&')
      pattern =  path.replace /((\/?\*\*)|(\/?\*)|(\?)|(\/))/g, ($0) ->
        switch $0
          when '/**'  then '(?:/{1,}.*)?'
          when '**'   then '.*'
          when '/*'   then '(?:/{1,}[^/]*)?'
          when '*'    then '[^/]*'
          when '?'    then '[^/]'
          when '/'    then '/{1,}'

      new RegExp('^(' + pattern + ')$')

    reindexParams: (prefix, params) ->
      regex = new RegExp('^(' + prefix.replace('.', '\\.') + ')\\[(\\d+)\\]')
      prevIndex = null
      index = -1
      for param in params
        results = regex.exec(param.name)
        if results
          currIndex = results[2]
          if prevIndex isnt currIndex
            prevIndex = currIndex
            index++
          param.name = param.name.replace(regex, '$1[' + index + ']')
      index

  # Shortcuts for left/right pad
  $.lpad = $.leftPad
  $.rpad = $.rightPad

  #end of $.extend

  $.fn.extend

    reverse: -> Array::reverse.call(@)

    findByName: (name) -> @find('[name="' + name + '"]')

    findByNames: () ->
      if arguments.length is 0 then $([])
      else @find ('[name="' + arg + '"]' for arg in arguments).join(',')

    maxZIndex: (excludes) ->
      zIndex = 0
      @find(':visible').andSelf().add(@parentsUntil('html')).not(excludes).each ->
        if @nodeName isnt '#document'
          $this = $(@)
          if $this.css('position') in ['absolute', 'relative', 'fixed']
            value = parseInt($this.css('zIndex'))
            zIndex = value  if not isNaN(value) and value > zIndex
      zIndex

    serializeObject: (options) ->
      result = {}
      options = options or {}
      $.each @serializeArray(), ->
        unless options.except? and @name in options.except
          if @name of result
            result[@name] = [result[@name]]  unless $.isArray result[@name]
            result[@name].push(@value)
          else
            result[@name] = @value
      result

    appendField: (name, value, callback) ->
      return @  unless @length > 0

      if typeof name is 'string'
        [values, values[name]] = [{}, value]
      else if $.isPlainObject name
        [values, callback] = [name, value]
      else
        return @

      values = for key, value of values
        name: name
        value: value

      @filter('form').each ->
        elements = $.makeInput(type: 'hidden', values).appendTo(@)
        callback?.call?(elements, elements)
        return #nothing
      @

    reclone: () ->
      @map ((args) -> ->
        oldEl = $(@)
        newEl = oldEl.clone.apply(oldEl, args)
        newEl.insertAfter(@)
        oldEl.remove()
        newEl[0]
      )(arguments)

    groupBy: (callback) ->
      $.error callback + " is not a function"  unless $.isFunction callback

      result = {}
      for elem, i in @
        key = callback.call(elem, elem, i, @)
        if key isnt undefined
          result[key] = $([])  unless key of result
          result[key].push @[i]
      result

  #end of $.fn.extend

  $.obj =

    get: (obj, key, defaultValue) ->
      return defaultValue  unless obj?
      return obj  unless key

      for keyFragment in $.split(key, '.', '/')
        return defaultValue  unless (obj = obj[keyFragment])?

      obj = $.makeArray(obj)  if $.isArray(defaultValue) and not $.isArray(obj)
      obj

    set: (appendArray, obj, fullkey, value) ->
      args = $.makeArray(arguments)
      appendArray = if typeof args[0] is 'boolean' then args.shift() else false
      obj = if typeof args[0] is 'object' or $.isFunction args[0] then args.shift() else {}
      $.error "Object key must be string type : " + args[0]  unless typeof args[0] is 'string'
      fullkey = args.shift()
      value = args.shift()

      keys = $.map $.split(fullkey, '.', '/'), (key) ->
        if /^([^\[]+)?\[([^\]]+)?\]/.test key
          inKeys = [key.match(/^([^\[]+)?/)[1]]
          inBracket = /\[([^\]]+)?\]/g
          inKeys.push nextMatches[1]  while nextMatches = inBracket.exec(key)
          inKeys
        else
          key

      isNull = (o, key) ->
        try
          not (key of o and o[key]?)
        catch
          false

      currObj = obj
      for key, i in keys
        if i is keys.length - 1
          if not appendArray or isNull(currObj, key)
            currObj[key] = value
          else if $.isArray currObj[key]
            currObj[key].push value
          else
            currObj[key] = [currObj[key], value]
        else if isNull(currObj, key)
          keys[i + 1] = '0'  unless keys[i + 1]
          currObj[key] = if /^\d+$/.test keys[i+1] then [] else {}
        else if typeof keys[i + 1] is 'undefined'
          keys[i + 1] = if $.isArray currObj[key] then currObj[key].length + '' else ''
        currObj = currObj[key]

      obj
    #end of set:

    generalize: (obj) ->
      return obj  unless $.isPlainObject obj
      newObj = {}
      for key, value of obj
        if key.contains('.') or /\[(\w+)?\]/.test(key)
          $.obj.set true, newObj, key, value
        else
          newObj[key] = value
      newObj

    extend: (deep, appendArray, target, extendIfUndefined) ->
      args = $.makeArray(arguments)
      deep = if typeof args[0] is 'boolean' then args.shift() else false
      appendArray = if typeof args[0] is 'boolean' then args.shift() else false
      extendIfUndefined = if typeof args.last() is 'boolean' then args.pop() else false
      target = if args.length is 1 then {} else args.shift() or {}
      target = {}  unless typeof target is 'object' or $.isFunction target

      for options in args
        if options?
          for name of options
            src = target[name]
            copy = options[name]

            continue  if target is copy

            copyIsArray = false
            if deep and copy and ($.isPlainObject(copy) or (copyIsArray = $.isArray(copy)))
              unless copyIsArray
                srcIsPlainObject = false
                if src is undefined or (srcIsPlainObject = $.isPlainObject(src)) or not extendIfUndefined
                  target[name] = $.obj.extend(deep, appendArray, (if srcIsPlainObject then src else {}), copy, extendIfUndefined)
              else if src is undefined or not extendIfUndefined
                target[name] = $.merge((if appendArray and $.isArray(src) then src else []), $.obj.extend(deep, [], copy))
            else if copy isnt undefined and (src is undefined or not extendIfUndefined)
              if copy instanceof Date
                target[name] = new Date(copy.getTime())
              else if copy instanceof RegExp
                flags = ''
                flags += 'g' if copy.global?
                flags += 'i' if copy.ignoreCase?
                flags += 'm' if copy.multiline?
                flags += 'y' if copy.sticky?
                target[name] = RegExp(copy.source, flags)
              else
                target[name] = copy
      target
    #end of extend: () ->

    make: () ->
      obj = {}
      for i in [0...arguments.length] by 2
        obj[arguments[i]] = arguments[i + 1]
      obj

    empty: (obj) ->
      if $.isPlainObject obj
        delete obj[key]  for key of obj
      obj

  # jQuery.obj expose to jQuery
  for key of $.obj
    shortKey = key + 'Object'
    $[shortKey] = $.obj[key]  unless shortKey of $

  #end of $.obj

  #start of String.prototype

  String::contains = (str) -> @indexOf(str) > -1
  String::startsWith = (str) -> @indexOf(str) is 0
  String::endsWith = (str) ->
    i = @lastIndexOf(str)
    i > -1 and i is @length - str.toString().length

  String::lpad = String::leftPad = (size, fillChar) -> $.leftPad(@toString(), size, fillChar)
  String::rpad = String::rightPad = (size, fillChar) -> $.rightPad(@toString(), size, fillChar)

  String::format = () ->
    @replace /(''|'\{|\}'|\{(\w+)\})/g, ((args) -> ($0, $1, $2) ->
      switch $1
        when "''" then "'"
        when "'{" then '{'
        when "}'" then '}'
        else (
          unless /^\d+$/g.test $2
            args[0] or {}
          else if $.isArray args[0]
            args[0]
          else
            args
        )[$2]
    )(arguments)

  String::formatVariables = ->
    regex = /(''|'\{|\}'|\{(\w+)\})/g
    variables = []
    while matches = regex.exec(@)
      variables.push(matches[2])  unless matches[0] in ["''", "'{", "}'"]
    variables

  String::parseDate = -> $.parseDate @toString()

  String::deserialize = -> $.deserialize @toString()

  String::xmlEscape = -> @replace /(<|>|"|'|&)/g, ($1) ->
    switch $1
      when '<' then '&lt;'
      when '>' then '&gt;'
      when '"' then '&#34;'
      when "'" then '&#39;'
      when '&' then '&amp;'
      else $1

  String::xmlUnescape = -> @replace /(&lt;|&gt;|&#34;|&#39;|&amp;)/g, ($1) ->
    switch $1
      when '&lt;'  then '<'
      when '&gt;'  then '>'
      when '&#34;' then '"'
      when '&#39;' then "'"
      when '&amp;' then '&'
      else $1

  String::nl2br = (xmlEscape) -> (if xmlEscape then @xmlEscape() else @).replace(/(\r\n|\n\r|\r|\n)/g, '<br/>')

  String::br2nl = (xmlUnescape) ->
    result = @replace(/(<br>|<br\/>)/g, '\n')
    if xmlUnescape then result.xmlUnescape() else result

  String::quote = (overlapable) ->
    overlapable = true  if arguments.length is 0
    if not overlapable and @length >= 2
      return @toString()  if @charAt(0) is '"' and @charAt(@length - 1) is '"'
      return @toString()  if @charAt(0) is "'" and @charAt(@length - 1) is "'"
    '"' + @ + '"'

  String::unquote = ->
    return @[1...-1]  if @length >= 2 and (
        (@charAt(0) is '"' and @charAt(@length - 1) is '"') or
        (@charAt(0) is "'" and @charAt(@length - 1) is "'") )
    @toString()

  String::compareTo = (str) -> switch
    when (not str?) then  1
    when (@ > str)  then  1
    when (@ < str)  then -1
    else                  0

  String::grouped = (size) -> @[i...i+size]  for i in [0...@length] by size
  String::groupedRight = (size) -> (@[Math.max(0, i-size)...i]  for i in [@length...0] by -size).reverse()

  String::a = String::antStylePathToRegex = -> $.antStylePathToRegex @toString()

  String::r = String::regex = (flags) -> new RegExp(@, flags)

  unless String::trim then String::trim = -> $.trim @.toString()

  #end of String.prototype

  Number::lpad = Number::leftPad = (size, fillChar) -> @toString().leftPad size, fillChar
  Number::rpad = Number::rightPad = (size, fillChar) -> @toString().rightPad size, fillChar

  Array.range = (from, to, step) ->
    range = []
    isNumber = typeof from is 'number' and typeof to is 'number'
    begin = if isNumber then from else from.toString().charCodeAt(0)
    end = if isNumber then to else to.toString().charCodeAt(0)
    for i in [begin..end] by step or 1
      range.push(if isNumber then i else String.fromCharCode(i))
    range

  #start of Array.prototype

  Array::first = -> @[0]
  Array::last = -> @[@length - 1]
  Array::contains = (a) -> a in @

  Array::include = (a) ->
    i = @indexOf(a)
    if i > -1
      @[i] = a
    else
      @push(a)
    @

  Array::remove = (a) ->
    for i in [@length-1..0]
      if @[i] is a
        @splice(i, 1)
        break
    @

  Array::trimAll = -> a?.toString?()?.trim?() or ''  for a in @

  Array::groupBy = (callback) ->
    $.error callback + " is not a function"  unless $.isFunction callback
    result = {}
    for a, i in @
      key = callback.call(window, a, i, @)
      if key isnt undefined
        result[key] = []  unless key of result
        result[key].push(a)
    result

  Array::grouped = (size) -> @[i...i+size]  for i in [0...@length] by size
  Array::groupedRight = (size) -> (@[Math.max(0, i-size)...i]  for i in [@length...0] by -size).reverse()

  Array::min = -> @reduce (a, b) -> if a < b then a else b
  Array::max = -> @reduce (a, b) -> if a > b then a else b

  Array::joinPaths = ->
    path = ''
    for a in @
      if a
        path += '/'  if path.length > 0 and path.charAt(path.length - 1) isnt '/'
        path += a.toString()
    path

  unless Array::some then Array::some = (callback) -> $.some(@, callback)

  unless Array::every then Array::every = (callback) ->
    for a in @
      return false  unless callback.call window, a
    true

  unless Array::indexOf then Array::indexOf = (o) ->
    for a, i in @
      return i  if a is o
    -1

  unless Array::reduce then Array::reduce = (callback) ->
    throw new TypeError "Reduce of empty array with no initial value"  unless @length > 0
    result = @[0]
    for i in [1...@.length]
      result = callback.call window, result, @[i], i, @
    result

  unless Array::filter then Array::filter = (callback) ->
    result = []
    for a, i in @
      result.push a  if callback.call window, a, i, @
    result

  #end of Array.prototype

  #start of Date.prototype

  Date.MILLISECONDS_IN_DAY = 86400000
  Date.MILLISECONDS_IN_HOUR = 3600000
  Date.MILLISECONDS_IN_MINUTE = 60000
  Date.MILLISECONDS_IN_SECOND = 1000

  Date.diff = (a, b) ->
    times = @diffTimes(a, b)
    days: parseInt(times / @MILLISECONDS_IN_DAY)
    hours: parseInt(times % @MILLISECONDS_IN_DAY / @MILLISECONDS_IN_HOUR)
    minutes: parseInt(times % @MILLISECONDS_IN_HOUR / @MILLISECONDS_IN_MINUTE)
    seconds: parseInt(times % @MILLISECONDS_IN_MINUTE / @MILLISECONDS_IN_SECOND)

  Date.diffTimes = (a, b) -> a.getTime() - b.getTime()
  Date.diffYears = (a, b) -> a.getFullYear() - b.getFullYear()
  Date.diffMonths = (a, b) -> @diffYears(a, b) * 12 + a.getMonth() - b.getMonth()
  Date.diffDays = (a, b) -> parseInt(@diffTimes(a, b) / @MILLISECONDS_IN_DAY)
  Date.diffHours = (a, b) -> parseInt(@diffTimes(a, b) / @MILLISECONDS_IN_HOUR)
  Date.diffMinutes = (a, b) -> parseInt(@diffTimes(a, b) / @MILLISECONDS_IN_MINUTE)
  Date.diffSeconds = (a, b) -> parseInt(@diffTimes(a, b) / @MILLISECONDS_IN_SECOND)

  Date::addTime = (a) -> @setTime(@getTime() + a); @
  Date::addYear = (a) -> @setFullYear(@getFullYear() + a); @
  Date::addMonth = (a) -> @setMonth(@getMonth() + a); @
  Date::addDate = (a) -> @setDate(@getDate() + a); @
  Date::addHours = (a) -> @setHours(@getHours() + a); @
  Date::addMinutes = (a) -> @setMinutes(@getMinutes() + a); @
  Date::addSeconds = (a) -> @setSeconds(@getSeconds() + a); @
  Date::addMilliseconds = (a) -> @setMilliseconds(@getMilliseconds() + a); @
  Date::addUTCYear = (a) -> @setUTCFullYear(@getUTCFullYear() + a); @
  Date::addUTCMonth = (a) -> @setUTCMonth(@getUTCMonth() + a); @
  Date::addUTCDate = (a) -> @setUTCDate(@getUTCDate() + a); @
  Date::addUTCHours = (a) -> @setUTCHours(@getUTCHours() + a); @
  Date::addUTCMinutes = (a) -> @setUTCMinutes(@getUTCMinutes() + a); @
  Date::addUTCSeconds = (a) -> @setUTCSeconds(@getUTCSeconds() + a); @
  Date::addUTCMilliseconds = (a) -> @setUTCMilliseconds(@getUTCMilliseconds() + a); @

  Date::diff = (a) -> Date.diff(@, a)
  Date::diffTimes = (a) -> Date.diffTimes(@, a)
  Date::diffYears = (a) -> Date.diffYears(@, a)
  Date::diffMonths = (a) -> Date.diffMonths(@, a)
  Date::diffDays = (a) -> Date.diffDays(@, a)
  Date::diffHours = (a) -> Date.diffHours(@, a)
  Date::diffMinutes = (a) -> Date.diffMinutes(@, a)
  Date::diffSeconds = (a) -> Date.diffSeconds(@, a)

  Date::truncateDate = -> new Date(@getFullYear(), @getMonth(), @getDate())

  Date::format = (format) ->
    return format  unless format
    return 'NaN'  if isNaN @getTime()

    date = new Date(@)
    format.replace /(''|'[^']+'|y+|m+|M+|d+|D+|h+|H+|s+|S+|E+|a+)/g, ($0) ->
      switch $0.charAt(0)
        when "'" then (if $0.charAt(1) is "'" then "'" else if $0.charAt($0.length-1) is "'" then $0[1...-1] else $0)
        when 'y' then (if $0.length < 4 then date.getFullYear().toString()[-2..] else date.getFullYear()).leftPad($0.length, '0')
        when 'M'
          if $0.length < 3
            (date.getMonth() + 1).leftPad($0.length, '0')
          else if $0.length is 3
            $.messages['monthShortNames'][date.getMonth()]
          else
            $.messages['monthLongNames'][date.getMonth()]
        when 'd' then date.getDate().leftPad($0.length, '0')
        when 'D' then parseInt((date.getTime() - new Date(date.getFullYear(),0,0).getTime()) / Date.MILLISECONDS_IN_DAY).leftPad($0.length, '0')
        when 'E' then (if ($0.length < 4) then $.messages['dayShortNames'][date.getDay()] else $.messages['dayLongNames'][date.getDay()])
        when 'a' then (if date.getHours() < 12 then $.messages['am'] else $.messages['pm'])
        when 'H' then date.getHours().leftPad($0.length, '0')
        when 'h' then ((date.getHours() % 12) or 12).leftPad($0.length, '0')
        when 'm' then date.getMinutes().leftPad($0.length, '0')
        when 's' then date.getSeconds().leftPad($0.length, '0')
        when 'S' then date.getMilliseconds().leftPad($0.length, '0')
        else $0

  #end of Date.prototype

  #start of RegExp.prototype

  RegExp.escape = (text) -> text.replace /[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&'

  #end of RegExp.prototype

  # Exports
  $
