
/*!
 * @name jQuery Limit Value plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 *   jquery-extends >= 1.0.0
 *   jquery-browser >= 1.0.0
 */

(function() {
  var __slice = [].slice;

  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends', 'jquery-browser'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery-extends'), require('jquery-browser'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';

    /**
     * @param {boolean|number} [checkbyte] check byte length if true. (default is false)
     * @param {number} limitSize the limit size.
     * @param {selectors|element} [selectors] for display remaining count.
     * @returns {$.fn}
     */
    $.fn.limitValue = function() {
      var DEFAULT_WARN_COLOR, PROP_NAME, WARN_COLOR_ATTR_NAME, a, args, checkbyte, eventHandler, isBoolean, isNumber, limitSize, selectors, self, states, _i, _len;
      checkbyte = arguments[0], limitSize = arguments[1], selectors = 3 <= arguments.length ? __slice.call(arguments, 2) : [];
      if (!arguments.length) {
        return this;
      }
      if (!this.is('input,textarea')) {
        return this;
      }
      PROP_NAME = '$limitValue';
      WARN_COLOR_ATTR_NAME = 'warnColor';
      DEFAULT_WARN_COLOR = '#f00';
      args = $.makeArray(arguments);
      isBoolean = function(v) {
        return typeof v === 'boolean';
      };
      isNumber = function(v) {
        return typeof v === 'number';
      };
      checkbyte = isBoolean(args[0]) || isNumber(args[0]) && isNumber(args[1]) ? args.shift() : false;
      if (!isNumber(args[0])) {
        $.error(args[0] + " is not a number");
      }
      limitSize = args.shift();
      states = $([]);
      for (_i = 0, _len = args.length; _i < _len; _i++) {
        a = args[_i];
        states.push.apply(states, $(a).get());
      }
      self = this;
      eventHandler = function(e) {
        var $this, length, newValue, newValueLength, originalColor, remainingCount, selection, state, value;
        $this = $(this);
        value = $this.val();
        length = $.getLength(checkbyte, value);
        state = states.eq(self.index(this));
        remainingCount = limitSize > length ? limitSize - length : 0;
        if (state.length > 0) {
          if (remainingCount === 0) {
            if (state.data('__original_color') == null) {
              state.data('__original_color', state[0].style.color);
            }
            state.css('color', state.attr(WARN_COLOR_ATTR_NAME) || state.data(WARN_COLOR_ATTR_NAME) || DEFAULT_WARN_COLOR);
          } else {
            originalColor = state.data('__original_color');
            if (originalColor != null) {
              state.css('color', originalColor);
            }
          }
          state.text(remainingCount);
        }
        if (length > limitSize) {
          newValue = $.cutstring(checkbyte, value, limitSize);
          newValueLength = newValue.length;
          selection = {
            start: this.selectionStart,
            end: this.selectionEnd,
            direction: this.selectionDirection
          };
          if (selection.start >= newValueLength || $.browser.msie) {
            $this.blur().val(newValue).focus();
          } else {
            $this.val(newValue);
          }
          this.selectionStart = selection.start < newValueLength ? selection.start : newValueLength;
          this.selectionEnd = selection.end < newValueLength ? selection.end : newValueLength;
          this.selectionDirection = selection.direction;
        }
        return void 0;
      };
      this.off('.' + PROP_NAME);
      this.on('change.{0} keyup.{0} keydown.{0}'.format(PROP_NAME), eventHandler);
      this.change();
      return this;
    };
    return $.fn.limitValue;
  });

}).call(this);

//# sourceMappingURL=jquery-limitvalue.js.map
