function fix_opts(defaults) {
	return function(opts) {
		defaults.forEach(function(d) {
			if(typeof opts[d[0]] === 'undefined') opts[d[0]] = d[1];
			if(d[2] === 'n') opts[d[0]] = Number(opts[d[0]]);
		});
	};
}

var fix_read_opts = fix_opts([
	['cellNF', false], /* emit cell number format string as .z */
	['cellHTML', true], /* emit html string as .h */
	['cellFormula', true], /* emit formulae as .f */

	['sheetStubs', false], /* emit empty cells */
	['sheetRows', 0, 'n'], /* read n rows (0 = read all rows) */

	['bookDeps', false], /* parse calculation chains */
	['bookSheets', false], /* only try to get sheet names (no Sheets) */
	['bookProps', false], /* only try to get properties (no Sheets) */
	['bookFiles', false], /* include raw file structure (keys, files) */
	['bookVBA', false], /* include vba raw data (vbaraw) */

	['WTF', false] /* WTF mode (throws errors) */
]);


var fix_write_opts = fix_opts([
	['bookSST', false], /* Generate Shared String Table */

	['bookType', 'xlsx'], /* Type of workbook (xlsx/m/b) */

	['WTF', false] /* WTF mode (throws errors) */
]);
