/* xlsx.js (C) 2013-2014 SheetJS -- http://sheetjs.com */
var JSZip=function(data,options){this.files={};this.root="";if(data){this.load(data,options)}};JSZip.signature={LOCAL_FILE_HEADER:"PK",CENTRAL_FILE_HEADER:"PK",CENTRAL_DIRECTORY_END:"PK",ZIP64_CENTRAL_DIRECTORY_LOCATOR:"PK",ZIP64_CENTRAL_DIRECTORY_END:"PK",DATA_DESCRIPTOR:"PK\b"};JSZip.defaults={base64:false,binary:false,dir:false,date:null,compression:null};JSZip.support={arraybuffer:function(){return typeof ArrayBuffer!=="undefined"&&typeof Uint8Array!=="undefined"}(),nodebuffer:function(){return typeof Buffer!=="undefined"}(),uint8array:function(){return typeof Uint8Array!=="undefined"}(),blob:function(){if(typeof ArrayBuffer==="undefined"){return false}var buffer=new ArrayBuffer(0);try{return new Blob([buffer],{type:"application/zip"}).size===0}catch(e){}try{var BlobBuilder=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder;var builder=new BlobBuilder;builder.append(buffer);return builder.getBlob("application/zip").size===0}catch(e){}return false}()};JSZip.prototype=function(){var textEncoder,textDecoder;if(JSZip.support.uint8array&&typeof TextEncoder==="function"&&typeof TextDecoder==="function"){textEncoder=new TextEncoder("utf-8");textDecoder=new TextDecoder("utf-8")}var getRawData=function(file){if(file._data instanceof JSZip.CompressedObject){file._data=file._data.getContent();file.options.binary=true;file.options.base64=false;if(JSZip.utils.getTypeOf(file._data)==="uint8array"){var copy=file._data;file._data=new Uint8Array(copy.length);if(copy.length!==0){file._data.set(copy,0)}}}return file._data};var getBinaryData=function(file){var result=getRawData(file),type=JSZip.utils.getTypeOf(result);if(type==="string"){if(!file.options.binary){if(textEncoder){return textEncoder.encode(result)}if(JSZip.support.nodebuffer){return new Buffer(result,"utf-8")}}return file.asBinary()}return result};var dataToString=function(asUTF8){var result=getRawData(this);if(result===null||typeof result==="undefined"){return""}if(this.options.base64){result=JSZip.base64.decode(result)}if(asUTF8&&this.options.binary){result=JSZip.prototype.utf8decode(result)}else{result=JSZip.utils.transformTo("string",result)}if(!asUTF8&&!this.options.binary){result=JSZip.prototype.utf8encode(result)}return result};var ZipObject=function(name,data,options){this.name=name;this._data=data;this.options=options};ZipObject.prototype={asText:function(){return dataToString.call(this,true)},asBinary:function(){return dataToString.call(this,false)},asNodeBuffer:function(){var result=getBinaryData(this);return JSZip.utils.transformTo("nodebuffer",result)},asUint8Array:function(){var result=getBinaryData(this);return JSZip.utils.transformTo("uint8array",result)},asArrayBuffer:function(){return this.asUint8Array().buffer}};var decToHex=function(dec,bytes){var hex="",i;for(i=0;i<bytes;i++){hex+=String.fromCharCode(dec&255);dec=dec>>>8}return hex};var extend=function(){var result={},i,attr;for(i=0;i<arguments.length;i++){for(attr in arguments[i]){if(arguments[i].hasOwnProperty(attr)&&typeof result[attr]==="undefined"){result[attr]=arguments[i][attr]}}}return result};var prepareFileAttrs=function(o){o=o||{};if(o.base64===true&&o.binary==null){o.binary=true}o=extend(o,JSZip.defaults);o.date=o.date||new Date;if(o.compression!==null)o.compression=o.compression.toUpperCase();return o};var fileAdd=function(name,data,o){var parent=parentFolder(name),dataType=JSZip.utils.getTypeOf(data);if(parent){folderAdd.call(this,parent)}o=prepareFileAttrs(o);if(o.dir||data===null||typeof data==="undefined"){o.base64=false;o.binary=false;data=null}else if(dataType==="string"){if(o.binary&&!o.base64){if(o.optimizedBinaryString!==true){data=JSZip.utils.string2binary(data)}}}else{o.base64=false;o.binary=true;if(!dataType&&!(data instanceof JSZip.CompressedObject)){throw new Error("The data of '"+name+"' is in an unsupported format !")}if(dataType==="arraybuffer"){data=JSZip.utils.transformTo("uint8array",data)}}var object=new ZipObject(name,data,o);this.files[name]=object;return object};var parentFolder=function(path){if(path.slice(-1)=="/"){path=path.substring(0,path.length-1)}var lastSlash=path.lastIndexOf("/");return lastSlash>0?path.substring(0,lastSlash):""};var folderAdd=function(name){if(name.slice(-1)!="/"){name+="/"}if(!this.files[name]){fileAdd.call(this,name,null,{dir:true})}return this.files[name]};var generateCompressedObjectFrom=function(file,compression){var result=new JSZip.CompressedObject,content;if(file._data instanceof JSZip.CompressedObject){result.uncompressedSize=file._data.uncompressedSize;result.crc32=file._data.crc32;if(result.uncompressedSize===0||file.options.dir){compression=JSZip.compressions["STORE"];result.compressedContent="";result.crc32=0}else if(file._data.compressionMethod===compression.magic){result.compressedContent=file._data.getCompressedContent()}else{content=file._data.getContent();result.compressedContent=compression.compress(JSZip.utils.transformTo(compression.compressInputType,content))}}else{content=getBinaryData(file);if(!content||content.length===0||file.options.dir){compression=JSZip.compressions["STORE"];content=""}result.uncompressedSize=content.length;result.crc32=this.crc32(content);result.compressedContent=compression.compress(JSZip.utils.transformTo(compression.compressInputType,content))}result.compressedSize=result.compressedContent.length;result.compressionMethod=compression.magic;return result};var generateZipParts=function(name,file,compressedObject,offset){var data=compressedObject.compressedContent,utfEncodedFileName=this.utf8encode(file.name),useUTF8=utfEncodedFileName!==file.name,o=file.options,dosTime,dosDate;dosTime=o.date.getHours();dosTime=dosTime<<6;dosTime=dosTime|o.date.getMinutes();dosTime=dosTime<<5;dosTime=dosTime|o.date.getSeconds()/2;dosDate=o.date.getFullYear()-1980;dosDate=dosDate<<4;dosDate=dosDate|o.date.getMonth()+1;dosDate=dosDate<<5;dosDate=dosDate|o.date.getDate();var header="";header+="\n\x00";header+=useUTF8?"\x00\b":"\x00\x00";header+=compressedObject.compressionMethod;header+=decToHex(dosTime,2);header+=decToHex(dosDate,2);header+=decToHex(compressedObject.crc32,4);header+=decToHex(compressedObject.compressedSize,4);header+=decToHex(compressedObject.uncompressedSize,4);header+=decToHex(utfEncodedFileName.length,2);header+="\x00\x00";var fileRecord=JSZip.signature.LOCAL_FILE_HEADER+header+utfEncodedFileName;var dirRecord=JSZip.signature.CENTRAL_FILE_HEADER+"\x00"+header+"\x00\x00"+"\x00\x00"+"\x00\x00"+(file.options.dir===true?"\x00\x00\x00":"\x00\x00\x00\x00")+decToHex(offset,4)+utfEncodedFileName;return{fileRecord:fileRecord,dirRecord:dirRecord,compressedObject:compressedObject}};var StringWriter=function(){this.data=[]};StringWriter.prototype={append:function(input){input=JSZip.utils.transformTo("string",input);this.data.push(input)},finalize:function(){return this.data.join("")}};var Uint8ArrayWriter=function(length){this.data=new Uint8Array(length);this.index=0};Uint8ArrayWriter.prototype={append:function(input){if(input.length!==0){input=JSZip.utils.transformTo("uint8array",input);this.data.set(input,this.index);this.index+=input.length}},finalize:function(){return this.data}};return{load:function(stream,options){throw new Error("Load method is not defined. Is the file jszip-load.js included ?")},filter:function(search){var result=[],filename,relativePath,file,fileClone;for(filename in this.files){if(!this.files.hasOwnProperty(filename)){continue}file=this.files[filename];fileClone=new ZipObject(file.name,file._data,extend(file.options));relativePath=filename.slice(this.root.length,filename.length);if(filename.slice(0,this.root.length)===this.root&&search(relativePath,fileClone)){result.push(fileClone)}}return result},file:function(name,data,o){if(arguments.length===1){if(JSZip.utils.isRegExp(name)){var regexp=name;return this.filter(function(relativePath,file){return!file.options.dir&&regexp.test(relativePath)})}else{return this.filter(function(relativePath,file){return!file.options.dir&&relativePath===name})[0]||null}}else{name=this.root+name;fileAdd.call(this,name,data,o)}return this},folder:function(arg){if(!arg){return this}if(JSZip.utils.isRegExp(arg)){return this.filter(function(relativePath,file){return file.options.dir&&arg.test(relativePath)})}var name=this.root+arg;var newFolder=folderAdd.call(this,name);var ret=this.clone();ret.root=newFolder.name;return ret},remove:function(name){name=this.root+name;var file=this.files[name];if(!file){if(name.slice(-1)!="/"){name+="/"}file=this.files[name]}if(file){if(!file.options.dir){delete this.files[name]}else{var kids=this.filter(function(relativePath,file){return file.name.slice(0,name.length)===name});for(var i=0;i<kids.length;i++){delete this.files[kids[i].name]}}}return this},generate:function(options){options=extend(options||{},{base64:true,compression:"STORE",type:"base64"});JSZip.utils.checkSupport(options.type);var zipData=[],localDirLength=0,centralDirLength=0,writer,i;for(var name in this.files){if(!this.files.hasOwnProperty(name)){continue}var file=this.files[name];var compressionName=file.options.compression||options.compression.toUpperCase();var compression=JSZip.compressions[compressionName];if(!compression){throw new Error(compressionName+" is not a valid compression method !")}var compressedObject=generateCompressedObjectFrom.call(this,file,compression);var zipPart=generateZipParts.call(this,name,file,compressedObject,localDirLength);localDirLength+=zipPart.fileRecord.length+compressedObject.compressedSize;centralDirLength+=zipPart.dirRecord.length;zipData.push(zipPart)}var dirEnd="";dirEnd=JSZip.signature.CENTRAL_DIRECTORY_END+"\x00\x00"+"\x00\x00"+decToHex(zipData.length,2)+decToHex(zipData.length,2)+decToHex(centralDirLength,4)+decToHex(localDirLength,4)+"\x00\x00";switch(options.type.toLowerCase()){case"uint8array":case"arraybuffer":case"blob":case"nodebuffer":writer=new Uint8ArrayWriter(localDirLength+centralDirLength+dirEnd.length);break;default:writer=new StringWriter(localDirLength+centralDirLength+dirEnd.length);break}for(i=0;i<zipData.length;i++){writer.append(zipData[i].fileRecord);writer.append(zipData[i].compressedObject.compressedContent)}for(i=0;i<zipData.length;i++){writer.append(zipData[i].dirRecord)}writer.append(dirEnd);var zip=writer.finalize();switch(options.type.toLowerCase()){case"uint8array":case"arraybuffer":case"nodebuffer":return JSZip.utils.transformTo(options.type.toLowerCase(),zip);case"blob":return JSZip.utils.arrayBuffer2Blob(JSZip.utils.transformTo("arraybuffer",zip));case"base64":return options.base64?JSZip.base64.encode(zip):zip;default:return zip}},crc32:function crc32(input,crc){if(typeof input==="undefined"||!input.length){return 0}var isArray=JSZip.utils.getTypeOf(input)!=="string";var table=[0,1996959894,3993919788,2567524794,124634137,1886057615,3915621685,2657392035,249268274,2044508324,3772115230,2547177864,162941995,2125561021,3887607047,2428444049,498536548,1789927666,4089016648,2227061214,450548861,1843258603,4107580753,2211677639,325883990,1684777152,4251122042,2321926636,335633487,1661365465,4195302755,2366115317,997073096,1281953886,3579855332,2724688242,1006888145,1258607687,3524101629,2768942443,901097722,1119000684,3686517206,2898065728,853044451,1172266101,3705015759,2882616665,651767980,1373503546,3369554304,3218104598,565507253,1454621731,3485111705,3099436303,671266974,1594198024,3322730930,2970347812,795835527,1483230225,3244367275,3060149565,1994146192,31158534,2563907772,4023717930,1907459465,112637215,2680153253,3904427059,2013776290,251722036,2517215374,3775830040,2137656763,141376813,2439277719,3865271297,1802195444,476864866,2238001368,4066508878,1812370925,453092731,2181625025,4111451223,1706088902,314042704,2344532202,4240017532,1658658271,366619977,2362670323,4224994405,1303535960,984961486,2747007092,3569037538,1256170817,1037604311,2765210733,3554079995,1131014506,879679996,2909243462,3663771856,1141124467,855842277,2852801631,3708648649,1342533948,654459306,3188396048,3373015174,1466479909,544179635,3110523913,3462522015,1591671054,702138776,2966460450,3352799412,1504918807,783551873,3082640443,3233442989,3988292384,2596254646,62317068,1957810842,3939845945,2647816111,81470997,1943803523,3814918930,2489596804,225274430,2053790376,3826175755,2466906013,167816743,2097651377,4027552580,2265490386,503444072,1762050814,4150417245,2154129355,426522225,1852507879,4275313526,2312317920,282753626,1742555852,4189708143,2394877945,397917763,1622183637,3604390888,2714866558,953729732,1340076626,3518719985,2797360999,1068828381,1219638859,3624741850,2936675148,906185462,1090812512,3747672003,2825379669,829329135,1181335161,3412177804,3160834842,628085408,1382605366,3423369109,3138078467,570562233,1426400815,3317316542,2998733608,733239954,1555261956,3268935591,3050360625,752459403,1541320221,2607071920,3965973030,1969922972,40735498,2617837225,3943577151,1913087877,83908371,2512341634,3803740692,2075208622,213261112,2463272603,3855990285,2094854071,198958881,2262029012,4057260610,1759359992,534414190,2176718541,4139329115,1873836001,414664567,2282248934,4279200368,1711684554,285281116,2405801727,4167216745,1634467795,376229701,2685067896,3608007406,1308918612,956543938,2808555105,3495958263,1231636301,1047427035,2932959818,3654703836,1088359270,936918e3,2847714899,3736837829,1202900863,817233897,3183342108,3401237130,1404277552,615818150,3134207493,3453421203,1423857449,601450431,3009837614,3294710456,1567103746,711928724,3020668471,3272380065,1510334235,755167117];if(typeof crc=="undefined"){crc=0}var x=0;var y=0;var byte=0;crc=crc^-1;for(var i=0,iTop=input.length;i<iTop;i++){byte=isArray?input[i]:input.charCodeAt(i);y=(crc^byte)&255;x=table[y];crc=crc>>>8^x}return crc^-1},clone:function(){var newObj=new JSZip;for(var i in this){if(typeof this[i]!=="function"){newObj[i]=this[i]}}return newObj},utf8encode:function(string){if(textEncoder){var u8=textEncoder.encode(string);return JSZip.utils.transformTo("string",u8)}if(JSZip.support.nodebuffer){return JSZip.utils.transformTo("string",new Buffer(string,"utf-8"))}var result=[],resIndex=0;for(var n=0;n<string.length;n++){var c=string.charCodeAt(n);if(c<128){result[resIndex++]=String.fromCharCode(c)}else if(c>127&&c<2048){result[resIndex++]=String.fromCharCode(c>>6|192);result[resIndex++]=String.fromCharCode(c&63|128)}else{result[resIndex++]=String.fromCharCode(c>>12|224);result[resIndex++]=String.fromCharCode(c>>6&63|128);result[resIndex++]=String.fromCharCode(c&63|128)}}return result.join("")},utf8decode:function(input){var result=[],resIndex=0;var type=JSZip.utils.getTypeOf(input);var isArray=type!=="string";var i=0;var c=0,c1=0,c2=0,c3=0;if(textDecoder){return textDecoder.decode(JSZip.utils.transformTo("uint8array",input))}if(JSZip.support.nodebuffer){return JSZip.utils.transformTo("nodebuffer",input).toString("utf-8")}while(i<input.length){c=isArray?input[i]:input.charCodeAt(i);if(c<128){result[resIndex++]=String.fromCharCode(c);i++}else if(c>191&&c<224){c2=isArray?input[i+1]:input.charCodeAt(i+1);result[resIndex++]=String.fromCharCode((c&31)<<6|c2&63);i+=2}else{c2=isArray?input[i+1]:input.charCodeAt(i+1);c3=isArray?input[i+2]:input.charCodeAt(i+2);result[resIndex++]=String.fromCharCode((c&15)<<12|(c2&63)<<6|c3&63);i+=3}}return result.join("")}}}();JSZip.compressions={STORE:{magic:"\x00\x00",compress:function(content){return content},uncompress:function(content){return content},compressInputType:null,uncompressInputType:null}};(function(){JSZip.utils={string2binary:function(str){var result="";for(var i=0;i<str.length;i++){result+=String.fromCharCode(str.charCodeAt(i)&255)}return result},string2Uint8Array:function(str){return JSZip.utils.transformTo("uint8array",str)},uint8Array2String:function(array){return JSZip.utils.transformTo("string",array)},arrayBuffer2Blob:function(buffer){JSZip.utils.checkSupport("blob");try{return new Blob([buffer],{type:"application/zip"})}catch(e){}try{var BlobBuilder=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder;var builder=new BlobBuilder;builder.append(buffer);return builder.getBlob("application/zip")}catch(e){}throw new Error("Bug : can't construct the Blob.")},string2Blob:function(str){var buffer=JSZip.utils.transformTo("arraybuffer",str);return JSZip.utils.arrayBuffer2Blob(buffer)}};function identity(input){return input}function stringToArrayLike(str,array){for(var i=0;i<str.length;++i){array[i]=str.charCodeAt(i)&255}return array}function arrayLikeToString(array){var chunk=65536;var result=[],len=array.length,type=JSZip.utils.getTypeOf(array),k=0;var canUseApply=true;try{switch(type){case"uint8array":String.fromCharCode.apply(null,new Uint8Array(0));break;case"nodebuffer":String.fromCharCode.apply(null,new Buffer(0));break}}catch(e){canUseApply=false}if(!canUseApply){var resultStr="";for(var i=0;i<array.length;i++){resultStr+=String.fromCharCode(array[i])}return resultStr}while(k<len&&chunk>1){try{if(type==="array"||type==="nodebuffer"){result.push(String.fromCharCode.apply(null,array.slice(k,Math.min(k+chunk,len))))}else{result.push(String.fromCharCode.apply(null,array.subarray(k,Math.min(k+chunk,len))))}k+=chunk}catch(e){chunk=Math.floor(chunk/2)}}return result.join("")}function arrayLikeToArrayLike(arrayFrom,arrayTo){for(var i=0;i<arrayFrom.length;i++){arrayTo[i]=arrayFrom[i]}return arrayTo}var transform={};transform["string"]={string:identity,array:function(input){return stringToArrayLike(input,new Array(input.length))},arraybuffer:function(input){return transform["string"]["uint8array"](input).buffer},uint8array:function(input){return stringToArrayLike(input,new Uint8Array(input.length))},nodebuffer:function(input){return stringToArrayLike(input,new Buffer(input.length))}};transform["array"]={string:arrayLikeToString,array:identity,arraybuffer:function(input){return new Uint8Array(input).buffer},uint8array:function(input){return new Uint8Array(input)},nodebuffer:function(input){return new Buffer(input)}};transform["arraybuffer"]={string:function(input){return arrayLikeToString(new Uint8Array(input))},array:function(input){return arrayLikeToArrayLike(new Uint8Array(input),new Array(input.byteLength))},arraybuffer:identity,uint8array:function(input){return new Uint8Array(input)},nodebuffer:function(input){return new Buffer(new Uint8Array(input))}};transform["uint8array"]={string:arrayLikeToString,array:function(input){return arrayLikeToArrayLike(input,new Array(input.length))},arraybuffer:function(input){return input.buffer},uint8array:identity,nodebuffer:function(input){return new Buffer(input)}};transform["nodebuffer"]={string:arrayLikeToString,array:function(input){return arrayLikeToArrayLike(input,new Array(input.length))},arraybuffer:function(input){return transform["nodebuffer"]["uint8array"](input).buffer},uint8array:function(input){return arrayLikeToArrayLike(input,new Uint8Array(input.length))},nodebuffer:identity};JSZip.utils.transformTo=function(outputType,input){if(!input){input=""}if(!outputType){return input}JSZip.utils.checkSupport(outputType);var inputType=JSZip.utils.getTypeOf(input);var result=transform[inputType][outputType](input);return result};JSZip.utils.getTypeOf=function(input){if(typeof input==="string"){return"string"}if(Object.prototype.toString.call(input)==="[object Array]"){return"array"}if(JSZip.support.nodebuffer&&Buffer.isBuffer(input)){return"nodebuffer"}if(JSZip.support.uint8array&&input instanceof Uint8Array){return"uint8array"}if(JSZip.support.arraybuffer&&input instanceof ArrayBuffer){return"arraybuffer"}};JSZip.utils.isRegExp=function(object){return Object.prototype.toString.call(object)==="[object RegExp]"};JSZip.utils.checkSupport=function(type){var supported=true;switch(type.toLowerCase()){case"uint8array":supported=JSZip.support.uint8array;break;case"arraybuffer":supported=JSZip.support.arraybuffer;break;case"nodebuffer":supported=JSZip.support.nodebuffer;break;case"blob":supported=JSZip.support.blob;break}if(!supported){throw new Error(type+" is not supported by this browser")}}})();(function(){JSZip.CompressedObject=function(){this.compressedSize=0;this.uncompressedSize=0;this.crc32=0;this.compressionMethod=null;this.compressedContent=null};JSZip.CompressedObject.prototype={getContent:function(){return null},getCompressedContent:function(){return null}}})();JSZip.base64=function(){var _keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";return{encode:function(input,utf8){var output="";var chr1,chr2,chr3,enc1,enc2,enc3,enc4;var i=0;while(i<input.length){chr1=input.charCodeAt(i++);chr2=input.charCodeAt(i++);chr3=input.charCodeAt(i++);enc1=chr1>>2;enc2=(chr1&3)<<4|chr2>>4;enc3=(chr2&15)<<2|chr3>>6;enc4=chr3&63;if(isNaN(chr2)){enc3=enc4=64}else if(isNaN(chr3)){enc4=64}output=output+_keyStr.charAt(enc1)+_keyStr.charAt(enc2)+_keyStr.charAt(enc3)+_keyStr.charAt(enc4)}return output},decode:function(input,utf8){var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");while(i<input.length){enc1=_keyStr.indexOf(input.charAt(i++));enc2=_keyStr.indexOf(input.charAt(i++));enc3=_keyStr.indexOf(input.charAt(i++));enc4=_keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!=64){output=output+String.fromCharCode(chr2)}if(enc4!=64){output=output+String.fromCharCode(chr3)}}return output}}}();(function(){"use strict";if(!JSZip){throw"JSZip not defined"}var context={};(function(){(function(){"use strict";var n=void 0,u=!0,aa=this;function ba(e,d){var c=e.split("."),f=aa;!(c[0]in f)&&f.execScript&&f.execScript("var "+c[0]);for(var a;c.length&&(a=c.shift());)!c.length&&d!==n?f[a]=d:f=f[a]?f[a]:f[a]={}}var C="undefined"!==typeof Uint8Array&&"undefined"!==typeof Uint16Array&&"undefined"!==typeof Uint32Array;function K(e,d){this.index="number"===typeof d?d:0;this.d=0;this.buffer=e instanceof(C?Uint8Array:Array)?e:new(C?Uint8Array:Array)(32768);if(2*this.buffer.length<=this.index)throw Error("invalid index");this.buffer.length<=this.index&&ca(this)}function ca(e){var d=e.buffer,c,f=d.length,a=new(C?Uint8Array:Array)(f<<1);if(C)a.set(d);else for(c=0;c<f;++c)a[c]=d[c];return e.buffer=a}K.prototype.a=function(e,d,c){var f=this.buffer,a=this.index,b=this.d,k=f[a],m;c&&1<d&&(e=8<d?(L[e&255]<<24|L[e>>>8&255]<<16|L[e>>>16&255]<<8|L[e>>>24&255])>>32-d:L[e]>>8-d);if(8>d+b)k=k<<d|e,b+=d;else for(m=0;m<d;++m)k=k<<1|e>>d-m-1&1,8===++b&&(b=0,f[a++]=L[k],k=0,a===f.length&&(f=ca(this)));f[a]=k;this.buffer=f;this.d=b;this.index=a};K.prototype.finish=function(){var e=this.buffer,d=this.index,c;0<this.d&&(e[d]<<=8-this.d,e[d]=L[e[d]],d++);C?c=e.subarray(0,d):(e.length=d,c=e);return c};var ga=new(C?Uint8Array:Array)(256),M;for(M=0;256>M;++M){for(var R=M,S=R,ha=7,R=R>>>1;R;R>>>=1)S<<=1,S|=R&1,--ha;ga[M]=(S<<ha&255)>>>0}var L=ga;function ja(e){this.buffer=new(C?Uint16Array:Array)(2*e);this.length=0}ja.prototype.getParent=function(e){return 2*((e-2)/4|0)};ja.prototype.push=function(e,d){var c,f,a=this.buffer,b;c=this.length;a[this.length++]=d;for(a[this.length++]=e;0<c;)if(f=this.getParent(c),a[c]>a[f])b=a[c],a[c]=a[f],a[f]=b,b=a[c+1],a[c+1]=a[f+1],a[f+1]=b,c=f;else break;return this.length};ja.prototype.pop=function(){var e,d,c=this.buffer,f,a,b;d=c[0];e=c[1];this.length-=2;c[0]=c[this.length];c[1]=c[this.length+1];for(b=0;;){a=2*b+2;if(a>=this.length)break;a+2<this.length&&c[a+2]>c[a]&&(a+=2);if(c[a]>c[b])f=c[b],c[b]=c[a],c[a]=f,f=c[b+1],c[b+1]=c[a+1],c[a+1]=f;else break;b=a}return{index:e,value:d,length:this.length}};function ka(e,d){this.e=ma;this.f=0;this.input=C&&e instanceof Array?new Uint8Array(e):e;this.c=0;d&&(d.lazy&&(this.f=d.lazy),"number"===typeof d.compressionType&&(this.e=d.compressionType),d.outputBuffer&&(this.b=C&&d.outputBuffer instanceof Array?new Uint8Array(d.outputBuffer):d.outputBuffer),"number"===typeof d.outputIndex&&(this.c=d.outputIndex));this.b||(this.b=new(C?Uint8Array:Array)(32768))}var ma=2,T=[],U;for(U=0;288>U;U++)switch(u){case 143>=U:T.push([U+48,8]);break;case 255>=U:T.push([U-144+400,9]);break;case 279>=U:T.push([U-256+0,7]);break;case 287>=U:T.push([U-280+192,8]);break;default:throw"invalid literal: "+U}ka.prototype.h=function(){var e,d,c,f,a=this.input;switch(this.e){case 0:c=0;for(f=a.length;c<f;){d=C?a.subarray(c,c+65535):a.slice(c,c+65535);c+=d.length;var b=d,k=c===f,m=n,g=n,p=n,v=n,x=n,l=this.b,h=this.c;if(C){for(l=new Uint8Array(this.b.buffer);l.length<=h+b.length+5;)l=new Uint8Array(l.length<<1);l.set(this.b)}m=k?1:0;l[h++]=m|0;g=b.length;p=~g+65536&65535;l[h++]=g&255;l[h++]=g>>>8&255;l[h++]=p&255;l[h++]=p>>>8&255;if(C)l.set(b,h),h+=b.length,l=l.subarray(0,h);else{v=0;for(x=b.length;v<x;++v)l[h++]=b[v];l.length=h}this.c=h;this.b=l}break;case 1:var q=new K(C?new Uint8Array(this.b.buffer):this.b,this.c);q.a(1,1,u);q.a(1,2,u);var t=na(this,a),w,da,z;w=0;for(da=t.length;w<da;w++)if(z=t[w],K.prototype.a.apply(q,T[z]),256<z)q.a(t[++w],t[++w],u),q.a(t[++w],5),q.a(t[++w],t[++w],u);else if(256===z)break;this.b=q.finish();this.c=this.b.length;break;case ma:var B=new K(C?new Uint8Array(this.b.buffer):this.b,this.c),ra,J,N,O,P,Ia=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],W,sa,X,ta,ea,ia=Array(19),ua,Q,fa,y,va;ra=ma;B.a(1,1,u);B.a(ra,2,u);J=na(this,a);W=oa(this.j,15);sa=pa(W);X=oa(this.i,7);ta=pa(X);for(N=286;257<N&&0===W[N-1];N--);for(O=30;1<O&&0===X[O-1];O--);var wa=N,xa=O,F=new(C?Uint32Array:Array)(wa+xa),r,G,s,Y,E=new(C?Uint32Array:Array)(316),D,A,H=new(C?Uint8Array:Array)(19);for(r=G=0;r<wa;r++)F[G++]=W[r];for(r=0;r<xa;r++)F[G++]=X[r];if(!C){r=0;for(Y=H.length;r<Y;++r)H[r]=0}r=D=0;for(Y=F.length;r<Y;r+=G){for(G=1;r+G<Y&&F[r+G]===F[r];++G);s=G;if(0===F[r])if(3>s)for(;0<s--;)E[D++]=0,H[0]++;else for(;0<s;)A=138>s?s:138,A>s-3&&A<s&&(A=s-3),10>=A?(E[D++]=17,E[D++]=A-3,H[17]++):(E[D++]=18,E[D++]=A-11,H[18]++),s-=A;else if(E[D++]=F[r],H[F[r]]++,s--,3>s)for(;0<s--;)E[D++]=F[r],H[F[r]]++;else for(;0<s;)A=6>s?s:6,A>s-3&&A<s&&(A=s-3),E[D++]=16,E[D++]=A-3,H[16]++,s-=A}e=C?E.subarray(0,D):E.slice(0,D);ea=oa(H,7);for(y=0;19>y;y++)ia[y]=ea[Ia[y]];for(P=19;4<P&&0===ia[P-1];P--);ua=pa(ea);B.a(N-257,5,u);B.a(O-1,5,u);B.a(P-4,4,u);for(y=0;y<P;y++)B.a(ia[y],3,u);y=0;for(va=e.length;y<va;y++)if(Q=e[y],B.a(ua[Q],ea[Q],u),16<=Q){y++;switch(Q){case 16:fa=2;break;case 17:fa=3;break;case 18:fa=7;break;default:throw"invalid code: "+Q}B.a(e[y],fa,u)}var ya=[sa,W],za=[ta,X],I,Aa,Z,la,Ba,Ca,Da,Ea;Ba=ya[0];Ca=ya[1];Da=za[0];Ea=za[1];I=0;for(Aa=J.length;I<Aa;++I)if(Z=J[I],B.a(Ba[Z],Ca[Z],u),256<Z)B.a(J[++I],J[++I],u),la=J[++I],B.a(Da[la],Ea[la],u),B.a(J[++I],J[++I],u);else if(256===Z)break;this.b=B.finish();this.c=this.b.length;break;default:throw"invalid compression type"}return this.b};function qa(e,d){this.length=e;this.g=d}var Fa=function(){function e(a){switch(u){case 3===a:return[257,a-3,0];case 4===a:return[258,a-4,0];case 5===a:return[259,a-5,0];case 6===a:return[260,a-6,0];case 7===a:return[261,a-7,0];case 8===a:return[262,a-8,0];case 9===a:return[263,a-9,0];case 10===a:return[264,a-10,0];case 12>=a:return[265,a-11,1];case 14>=a:return[266,a-13,1];case 16>=a:return[267,a-15,1];case 18>=a:return[268,a-17,1];case 22>=a:return[269,a-19,2];case 26>=a:return[270,a-23,2];case 30>=a:return[271,a-27,2];case 34>=a:return[272,a-31,2];case 42>=a:return[273,a-35,3];case 50>=a:return[274,a-43,3];case 58>=a:return[275,a-51,3];case 66>=a:return[276,a-59,3];case 82>=a:return[277,a-67,4];case 98>=a:return[278,a-83,4];case 114>=a:return[279,a-99,4];case 130>=a:return[280,a-115,4];case 162>=a:return[281,a-131,5];case 194>=a:return[282,a-163,5];case 226>=a:return[283,a-195,5];case 257>=a:return[284,a-227,5];case 258===a:return[285,a-258,0];default:throw"invalid length: "+a}}var d=[],c,f;for(c=3;258>=c;c++)f=e(c),d[c]=f[2]<<24|f[1]<<16|f[0];return d}(),Ga=C?new Uint32Array(Fa):Fa;function na(e,d){function c(a,c){var b=a.g,d=[],f=0,e;e=Ga[a.length];d[f++]=e&65535;d[f++]=e>>16&255;d[f++]=e>>24;var g;switch(u){case 1===b:g=[0,b-1,0];break;case 2===b:g=[1,b-2,0];break;case 3===b:g=[2,b-3,0];break;case 4===b:g=[3,b-4,0];break;case 6>=b:g=[4,b-5,1];break;case 8>=b:g=[5,b-7,1];break;case 12>=b:g=[6,b-9,2];break;case 16>=b:g=[7,b-13,2];break;case 24>=b:g=[8,b-17,3];break;case 32>=b:g=[9,b-25,3];break;case 48>=b:g=[10,b-33,4];break;case 64>=b:g=[11,b-49,4];break;case 96>=b:g=[12,b-65,5];break;case 128>=b:g=[13,b-97,5];break;case 192>=b:g=[14,b-129,6];break;case 256>=b:g=[15,b-193,6];break;case 384>=b:g=[16,b-257,7];break;case 512>=b:g=[17,b-385,7];break;case 768>=b:g=[18,b-513,8];break;case 1024>=b:g=[19,b-769,8];break;case 1536>=b:g=[20,b-1025,9];break;case 2048>=b:g=[21,b-1537,9];break;case 3072>=b:g=[22,b-2049,10];break;case 4096>=b:g=[23,b-3073,10];break;case 6144>=b:g=[24,b-4097,11];break;case 8192>=b:g=[25,b-6145,11];break;case 12288>=b:g=[26,b-8193,12];break;case 16384>=b:g=[27,b-12289,12];break;case 24576>=b:g=[28,b-16385,13];break;case 32768>=b:g=[29,b-24577,13];break;default:throw"invalid distance"}e=g;d[f++]=e[0];d[f++]=e[1];d[f++]=e[2];var k,m;k=0;for(m=d.length;k<m;++k)l[h++]=d[k];t[d[0]]++;w[d[3]]++;q=a.length+c-1;x=null}var f,a,b,k,m,g={},p,v,x,l=C?new Uint16Array(2*d.length):[],h=0,q=0,t=new(C?Uint32Array:Array)(286),w=new(C?Uint32Array:Array)(30),da=e.f,z;if(!C){for(b=0;285>=b;)t[b++]=0;for(b=0;29>=b;)w[b++]=0}t[256]=1;f=0;for(a=d.length;f<a;++f){b=m=0;for(k=3;b<k&&f+b!==a;++b)m=m<<8|d[f+b];g[m]===n&&(g[m]=[]);p=g[m];if(!(0<q--)){for(;0<p.length&&32768<f-p[0];)p.shift();if(f+3>=a){x&&c(x,-1);b=0;for(k=a-f;b<k;++b)z=d[f+b],l[h++]=z,++t[z];break}0<p.length?(v=Ha(d,f,p),x?x.length<v.length?(z=d[f-1],l[h++]=z,++t[z],c(v,0)):c(x,-1):v.length<da?x=v:c(v,0)):x?c(x,-1):(z=d[f],l[h++]=z,++t[z])}p.push(f)}l[h++]=256;t[256]++;e.j=t;e.i=w;return C?l.subarray(0,h):l}function Ha(e,d,c){var f,a,b=0,k,m,g,p,v=e.length;m=0;p=c.length;a:for(;m<p;m++){f=c[p-m-1];k=3;if(3<b){for(g=b;3<g;g--)if(e[f+g-1]!==e[d+g-1])continue a;k=b}for(;258>k&&d+k<v&&e[f+k]===e[d+k];)++k;k>b&&(a=f,b=k);if(258===k)break}return new qa(b,d-a)}function oa(e,d){var c=e.length,f=new ja(572),a=new(C?Uint8Array:Array)(c),b,k,m,g,p;if(!C)for(g=0;g<c;g++)a[g]=0;for(g=0;g<c;++g)0<e[g]&&f.push(g,e[g]);b=Array(f.length/2);k=new(C?Uint32Array:Array)(f.length/2);if(1===b.length)return a[f.pop().index]=1,a;g=0;for(p=f.length/2;g<p;++g)b[g]=f.pop(),k[g]=b[g].value;m=Ja(k,k.length,d);g=0;for(p=b.length;g<p;++g)a[b[g].index]=m[g];return a}function Ja(e,d,c){function f(a){var b=g[a][p[a]];b===d?(f(a+1),f(a+1)):--k[b];++p[a]}var a=new(C?Uint16Array:Array)(c),b=new(C?Uint8Array:Array)(c),k=new(C?Uint8Array:Array)(d),m=Array(c),g=Array(c),p=Array(c),v=(1<<c)-d,x=1<<c-1,l,h,q,t,w;a[c-1]=d;for(h=0;h<c;++h)v<x?b[h]=0:(b[h]=1,v-=x),v<<=1,a[c-2-h]=(a[c-1-h]/2|0)+d;a[0]=b[0];m[0]=Array(a[0]);g[0]=Array(a[0]);for(h=1;h<c;++h)a[h]>2*a[h-1]+b[h]&&(a[h]=2*a[h-1]+b[h]),m[h]=Array(a[h]),g[h]=Array(a[h]);for(l=0;l<d;++l)k[l]=c;for(q=0;q<a[c-1];++q)m[c-1][q]=e[q],g[c-1][q]=q;for(l=0;l<c;++l)p[l]=0;1===b[c-1]&&(--k[0],++p[c-1]);for(h=c-2;0<=h;--h){t=l=0;w=p[h+1];for(q=0;q<a[h];q++)t=m[h+1][w]+m[h+1][w+1],t>e[l]?(m[h][q]=t,g[h][q]=d,w+=2):(m[h][q]=e[l],g[h][q]=l,++l);p[h]=0;1===b[h]&&f(h)}return k}function pa(e){var d=new(C?Uint16Array:Array)(e.length),c=[],f=[],a=0,b,k,m,g;b=0;for(k=e.length;b<k;b++)c[e[b]]=(c[e[b]]|0)+1;b=1;for(k=16;b<=k;b++)f[b]=a,a+=c[b]|0,a<<=1;b=0;for(k=e.length;b<k;b++){a=f[e[b]];f[e[b]]+=1;m=d[b]=0;for(g=e[b];m<g;m++)d[b]=d[b]<<1|a&1,a>>>=1}return d}ba("Zlib.RawDeflate",ka);ba("Zlib.RawDeflate.prototype.compress",ka.prototype.h);var Ka={NONE:0,FIXED:1,DYNAMIC:ma},V,La,$,Ma;if(Object.keys)V=Object.keys(Ka);else for(La in V=[],$=0,Ka)V[$++]=La;$=0;for(Ma=V.length;$<Ma;++$)La=V[$],ba("Zlib.RawDeflate.CompressionType."+La,Ka[La])}).call(this)}).call(context);var compress=function(input){var deflate=new context.Zlib.RawDeflate(input);return deflate.compress()};var USE_TYPEDARRAY=typeof Uint8Array!=="undefined"&&typeof Uint16Array!=="undefined"&&typeof Uint32Array!=="undefined";if(!JSZip.compressions["DEFLATE"]){JSZip.compressions["DEFLATE"]={magic:"\b\x00",compress:compress,compressInputType:USE_TYPEDARRAY?"uint8array":"array"}
}else{JSZip.compressions["DEFLATE"].compress=compress;JSZip.compressions["DEFLATE"].compressInputType=USE_TYPEDARRAY?"uint8array":"array"}})();(function(){"use strict";if(!JSZip){throw"JSZip not defined"}var context={};(function(){(function(){"use strict";var l=void 0,p=this;function q(c,d){var a=c.split("."),b=p;!(a[0]in b)&&b.execScript&&b.execScript("var "+a[0]);for(var e;a.length&&(e=a.shift());)!a.length&&d!==l?b[e]=d:b=b[e]?b[e]:b[e]={}}var r="undefined"!==typeof Uint8Array&&"undefined"!==typeof Uint16Array&&"undefined"!==typeof Uint32Array;function u(c){var d=c.length,a=0,b=Number.POSITIVE_INFINITY,e,f,g,h,k,m,s,n,t;for(n=0;n<d;++n)c[n]>a&&(a=c[n]),c[n]<b&&(b=c[n]);e=1<<a;f=new(r?Uint32Array:Array)(e);g=1;h=0;for(k=2;g<=a;){for(n=0;n<d;++n)if(c[n]===g){m=0;s=h;for(t=0;t<g;++t)m=m<<1|s&1,s>>=1;for(t=m;t<e;t+=k)f[t]=g<<16|n;++h}++g;h<<=1;k<<=1}return[f,a,b]}function v(c,d){this.g=[];this.h=32768;this.c=this.f=this.d=this.k=0;this.input=r?new Uint8Array(c):c;this.l=!1;this.i=w;this.p=!1;if(d||!(d={}))d.index&&(this.d=d.index),d.bufferSize&&(this.h=d.bufferSize),d.bufferType&&(this.i=d.bufferType),d.resize&&(this.p=d.resize);switch(this.i){case x:this.a=32768;this.b=new(r?Uint8Array:Array)(32768+this.h+258);break;case w:this.a=0;this.b=new(r?Uint8Array:Array)(this.h);this.e=this.u;this.m=this.r;this.j=this.s;break;default:throw Error("invalid inflate mode")}}var x=0,w=1;v.prototype.t=function(){for(;!this.l;){var c=y(this,3);c&1&&(this.l=!0);c>>>=1;switch(c){case 0:var d=this.input,a=this.d,b=this.b,e=this.a,f=l,g=l,h=l,k=b.length,m=l;this.c=this.f=0;f=d[a++];if(f===l)throw Error("invalid uncompressed block header: LEN (first byte)");g=f;f=d[a++];if(f===l)throw Error("invalid uncompressed block header: LEN (second byte)");g|=f<<8;f=d[a++];if(f===l)throw Error("invalid uncompressed block header: NLEN (first byte)");h=f;f=d[a++];if(f===l)throw Error("invalid uncompressed block header: NLEN (second byte)");h|=f<<8;if(g===~h)throw Error("invalid uncompressed block header: length verify");if(a+g>d.length)throw Error("input buffer is broken");switch(this.i){case x:for(;e+g>b.length;){m=k-e;g-=m;if(r)b.set(d.subarray(a,a+m),e),e+=m,a+=m;else for(;m--;)b[e++]=d[a++];this.a=e;b=this.e();e=this.a}break;case w:for(;e+g>b.length;)b=this.e({o:2});break;default:throw Error("invalid inflate mode")}if(r)b.set(d.subarray(a,a+g),e),e+=g,a+=g;else for(;g--;)b[e++]=d[a++];this.d=a;this.a=e;this.b=b;break;case 1:this.j(z,A);break;case 2:B(this);break;default:throw Error("unknown BTYPE: "+c)}}return this.m()};var C=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],D=r?new Uint16Array(C):C,E=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,258,258],F=r?new Uint16Array(E):E,G=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0],H=r?new Uint8Array(G):G,I=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],J=r?new Uint16Array(I):I,K=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],L=r?new Uint8Array(K):K,M=new(r?Uint8Array:Array)(288),N,O;N=0;for(O=M.length;N<O;++N)M[N]=143>=N?8:255>=N?9:279>=N?7:8;var z=u(M),P=new(r?Uint8Array:Array)(30),Q,R;Q=0;for(R=P.length;Q<R;++Q)P[Q]=5;var A=u(P);function y(c,d){for(var a=c.f,b=c.c,e=c.input,f=c.d,g;b<d;){g=e[f++];if(g===l)throw Error("input buffer is broken");a|=g<<b;b+=8}g=a&(1<<d)-1;c.f=a>>>d;c.c=b-d;c.d=f;return g}function S(c,d){for(var a=c.f,b=c.c,e=c.input,f=c.d,g=d[0],h=d[1],k,m,s;b<h;){k=e[f++];if(k===l)break;a|=k<<b;b+=8}m=g[a&(1<<h)-1];s=m>>>16;c.f=a>>s;c.c=b-s;c.d=f;return m&65535}function B(c){function d(a,c,b){var d,f,e,g;for(g=0;g<a;)switch(d=S(this,c),d){case 16:for(e=3+y(this,2);e--;)b[g++]=f;break;case 17:for(e=3+y(this,3);e--;)b[g++]=0;f=0;break;case 18:for(e=11+y(this,7);e--;)b[g++]=0;f=0;break;default:f=b[g++]=d}return b}var a=y(c,5)+257,b=y(c,5)+1,e=y(c,4)+4,f=new(r?Uint8Array:Array)(D.length),g,h,k,m;for(m=0;m<e;++m)f[D[m]]=y(c,3);g=u(f);h=new(r?Uint8Array:Array)(a);k=new(r?Uint8Array:Array)(b);c.j(u(d.call(c,a,g,h)),u(d.call(c,b,g,k)))}v.prototype.j=function(c,d){var a=this.b,b=this.a;this.n=c;for(var e=a.length-258,f,g,h,k;256!==(f=S(this,c));)if(256>f)b>=e&&(this.a=b,a=this.e(),b=this.a),a[b++]=f;else{g=f-257;k=F[g];0<H[g]&&(k+=y(this,H[g]));f=S(this,d);h=J[f];0<L[f]&&(h+=y(this,L[f]));b>=e&&(this.a=b,a=this.e(),b=this.a);for(;k--;)a[b]=a[b++-h]}for(;8<=this.c;)this.c-=8,this.d--;this.a=b};v.prototype.s=function(c,d){var a=this.b,b=this.a;this.n=c;for(var e=a.length,f,g,h,k;256!==(f=S(this,c));)if(256>f)b>=e&&(a=this.e(),e=a.length),a[b++]=f;else{g=f-257;k=F[g];0<H[g]&&(k+=y(this,H[g]));f=S(this,d);h=J[f];0<L[f]&&(h+=y(this,L[f]));b+k>e&&(a=this.e(),e=a.length);for(;k--;)a[b]=a[b++-h]}for(;8<=this.c;)this.c-=8,this.d--;this.a=b};v.prototype.e=function(){var c=new(r?Uint8Array:Array)(this.a-32768),d=this.a-32768,a,b,e=this.b;if(r)c.set(e.subarray(32768,c.length));else{a=0;for(b=c.length;a<b;++a)c[a]=e[a+32768]}this.g.push(c);this.k+=c.length;if(r)e.set(e.subarray(d,d+32768));else for(a=0;32768>a;++a)e[a]=e[d+a];this.a=32768;return e};v.prototype.u=function(c){var d,a=this.input.length/this.d+1|0,b,e,f,g=this.input,h=this.b;c&&("number"===typeof c.o&&(a=c.o),"number"===typeof c.q&&(a+=c.q));2>a?(b=(g.length-this.d)/this.n[2],f=258*(b/2)|0,e=f<h.length?h.length+f:h.length<<1):e=h.length*a;r?(d=new Uint8Array(e),d.set(h)):d=h;return this.b=d};v.prototype.m=function(){var c=0,d=this.b,a=this.g,b,e=new(r?Uint8Array:Array)(this.k+(this.a-32768)),f,g,h,k;if(0===a.length)return r?this.b.subarray(32768,this.a):this.b.slice(32768,this.a);f=0;for(g=a.length;f<g;++f){b=a[f];h=0;for(k=b.length;h<k;++h)e[c++]=b[h]}f=32768;for(g=this.a;f<g;++f)e[c++]=d[f];this.g=[];return this.buffer=e};v.prototype.r=function(){var c,d=this.a;r?this.p?(c=new Uint8Array(d),c.set(this.b.subarray(0,d))):c=this.b.subarray(0,d):(this.b.length>d&&(this.b.length=d),c=this.b);return this.buffer=c};q("Zlib.RawInflate",v);q("Zlib.RawInflate.prototype.decompress",v.prototype.t);var T={ADAPTIVE:w,BLOCK:x},U,V,W,X;if(Object.keys)U=Object.keys(T);else for(V in U=[],W=0,T)U[W++]=V;W=0;for(X=U.length;W<X;++W)V=U[W],q("Zlib.RawInflate.BufferType."+V,T[V])}).call(this)}).call(context);var uncompress=function(input){var inflate=new context.Zlib.RawInflate(input);return inflate.decompress()};var USE_TYPEDARRAY=typeof Uint8Array!=="undefined"&&typeof Uint16Array!=="undefined"&&typeof Uint32Array!=="undefined";if(!JSZip.compressions["DEFLATE"]){JSZip.compressions["DEFLATE"]={magic:"\b\x00",uncompress:uncompress,uncompressInputType:USE_TYPEDARRAY?"uint8array":"array"}}else{JSZip.compressions["DEFLATE"].uncompress=uncompress;JSZip.compressions["DEFLATE"].uncompressInputType=USE_TYPEDARRAY?"uint8array":"array"}})();(function(root){"use strict";var MAX_VALUE_16BITS=65535;var MAX_VALUE_32BITS=-1;var pretty=function(str){var res="",code,i;for(i=0;i<(str||"").length;i++){code=str.charCodeAt(i);res+="\\x"+(code<16?"0":"")+code.toString(16).toUpperCase()}return res};var findCompression=function(compressionMethod){for(var method in JSZip.compressions){if(!JSZip.compressions.hasOwnProperty(method)){continue}if(JSZip.compressions[method].magic===compressionMethod){return JSZip.compressions[method]}}return null};function DataReader(data){this.data=null;this.length=0;this.index=0}DataReader.prototype={checkOffset:function(offset){this.checkIndex(this.index+offset)},checkIndex:function(newIndex){if(this.length<newIndex||newIndex<0){throw new Error("End of data reached (data length = "+this.length+", asked index = "+newIndex+"). Corrupted zip ?")}},setIndex:function(newIndex){this.checkIndex(newIndex);this.index=newIndex},skip:function(n){this.setIndex(this.index+n)},byteAt:function(i){},readInt:function(size){var result=0,i;this.checkOffset(size);for(i=this.index+size-1;i>=this.index;i--){result=(result<<8)+this.byteAt(i)}this.index+=size;return result},readString:function(size){return JSZip.utils.transformTo("string",this.readData(size))},readData:function(size){},lastIndexOfSignature:function(sig){},readDate:function(){var dostime=this.readInt(4);return new Date((dostime>>25&127)+1980,(dostime>>21&15)-1,dostime>>16&31,dostime>>11&31,dostime>>5&63,(dostime&31)<<1)}};function StringReader(data,optimizedBinaryString){this.data=data;if(!optimizedBinaryString){this.data=JSZip.utils.string2binary(this.data)}this.length=this.data.length;this.index=0}StringReader.prototype=new DataReader;StringReader.prototype.byteAt=function(i){return this.data.charCodeAt(i)};StringReader.prototype.lastIndexOfSignature=function(sig){return this.data.lastIndexOf(sig)};StringReader.prototype.readData=function(size){this.checkOffset(size);var result=this.data.slice(this.index,this.index+size);this.index+=size;return result};function Uint8ArrayReader(data){if(data){this.data=data;this.length=this.data.length;this.index=0}}Uint8ArrayReader.prototype=new DataReader;Uint8ArrayReader.prototype.byteAt=function(i){return this.data[i]};Uint8ArrayReader.prototype.lastIndexOfSignature=function(sig){var sig0=sig.charCodeAt(0),sig1=sig.charCodeAt(1),sig2=sig.charCodeAt(2),sig3=sig.charCodeAt(3);for(var i=this.length-4;i>=0;--i){if(this.data[i]===sig0&&this.data[i+1]===sig1&&this.data[i+2]===sig2&&this.data[i+3]===sig3){return i}}return-1};Uint8ArrayReader.prototype.readData=function(size){this.checkOffset(size);var result=this.data.subarray(this.index,this.index+size);this.index+=size;return result};function NodeBufferReader(data){this.data=data;this.length=this.data.length;this.index=0}NodeBufferReader.prototype=new Uint8ArrayReader;NodeBufferReader.prototype.readData=function(size){this.checkOffset(size);var result=this.data.slice(this.index,this.index+size);this.index+=size;return result};function ZipEntry(options,loadOptions){this.options=options;this.loadOptions=loadOptions}ZipEntry.prototype={isEncrypted:function(){return(this.bitFlag&1)===1},useUTF8:function(){return(this.bitFlag&2048)===2048},prepareCompressedContent:function(reader,from,length){return function(){var previousIndex=reader.index;reader.setIndex(from);var compressedFileData=reader.readData(length);reader.setIndex(previousIndex);return compressedFileData}},prepareContent:function(reader,from,length,compression,uncompressedSize){return function(){var compressedFileData=JSZip.utils.transformTo(compression.uncompressInputType,this.getCompressedContent());var uncompressedFileData=compression.uncompress(compressedFileData);if(uncompressedFileData.length!==uncompressedSize){throw new Error("Bug : uncompressed data size mismatch")}return uncompressedFileData}},readLocalPart:function(reader){var compression,localExtraFieldsLength;reader.skip(22);this.fileNameLength=reader.readInt(2);localExtraFieldsLength=reader.readInt(2);this.fileName=reader.readString(this.fileNameLength);reader.skip(localExtraFieldsLength);if(this.compressedSize==-1||this.uncompressedSize==-1){throw new Error("Bug or corrupted zip : didn't get enough informations from the central directory "+"(compressedSize == -1 || uncompressedSize == -1)")}compression=findCompression(this.compressionMethod);if(compression===null){throw new Error("Corrupted zip : compression "+pretty(this.compressionMethod)+" unknown (inner file : "+this.fileName+")")}this.decompressed=new JSZip.CompressedObject;this.decompressed.compressedSize=this.compressedSize;this.decompressed.uncompressedSize=this.uncompressedSize;this.decompressed.crc32=this.crc32;this.decompressed.compressionMethod=this.compressionMethod;this.decompressed.getCompressedContent=this.prepareCompressedContent(reader,reader.index,this.compressedSize,compression);this.decompressed.getContent=this.prepareContent(reader,reader.index,this.compressedSize,compression,this.uncompressedSize);if(this.loadOptions.checkCRC32){this.decompressed=JSZip.utils.transformTo("string",this.decompressed.getContent());if(JSZip.prototype.crc32(this.decompressed)!==this.crc32){throw new Error("Corrupted zip : CRC32 mismatch")}}},readCentralPart:function(reader){this.versionMadeBy=reader.readString(2);this.versionNeeded=reader.readInt(2);this.bitFlag=reader.readInt(2);this.compressionMethod=reader.readString(2);this.date=reader.readDate();this.crc32=reader.readInt(4);this.compressedSize=reader.readInt(4);this.uncompressedSize=reader.readInt(4);this.fileNameLength=reader.readInt(2);this.extraFieldsLength=reader.readInt(2);this.fileCommentLength=reader.readInt(2);this.diskNumberStart=reader.readInt(2);this.internalFileAttributes=reader.readInt(2);this.externalFileAttributes=reader.readInt(4);this.localHeaderOffset=reader.readInt(4);if(this.isEncrypted()){throw new Error("Encrypted zip are not supported")}this.fileName=reader.readString(this.fileNameLength);this.readExtraFields(reader);this.parseZIP64ExtraField(reader);this.fileComment=reader.readString(this.fileCommentLength);this.dir=this.externalFileAttributes&16?true:false},parseZIP64ExtraField:function(reader){if(!this.extraFields[1]){return}var extraReader=new StringReader(this.extraFields[1].value);if(this.uncompressedSize===MAX_VALUE_32BITS){this.uncompressedSize=extraReader.readInt(8)}if(this.compressedSize===MAX_VALUE_32BITS){this.compressedSize=extraReader.readInt(8)}if(this.localHeaderOffset===MAX_VALUE_32BITS){this.localHeaderOffset=extraReader.readInt(8)}if(this.diskNumberStart===MAX_VALUE_32BITS){this.diskNumberStart=extraReader.readInt(4)}},readExtraFields:function(reader){var start=reader.index,extraFieldId,extraFieldLength,extraFieldValue;this.extraFields=this.extraFields||{};while(reader.index<start+this.extraFieldsLength){extraFieldId=reader.readInt(2);extraFieldLength=reader.readInt(2);extraFieldValue=reader.readString(extraFieldLength);this.extraFields[extraFieldId]={id:extraFieldId,length:extraFieldLength,value:extraFieldValue}}},handleUTF8:function(){if(this.useUTF8()){this.fileName=JSZip.prototype.utf8decode(this.fileName);this.fileComment=JSZip.prototype.utf8decode(this.fileComment)}}};function ZipEntries(data,loadOptions){this.files=[];this.loadOptions=loadOptions;if(data){this.load(data)}}ZipEntries.prototype={checkSignature:function(expectedSignature){var signature=this.reader.readString(4);if(signature!==expectedSignature){throw new Error("Corrupted zip or bug : unexpected signature "+"("+pretty(signature)+", expected "+pretty(expectedSignature)+")")}},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2);this.diskWithCentralDirStart=this.reader.readInt(2);this.centralDirRecordsOnThisDisk=this.reader.readInt(2);this.centralDirRecords=this.reader.readInt(2);this.centralDirSize=this.reader.readInt(4);this.centralDirOffset=this.reader.readInt(4);this.zipCommentLength=this.reader.readInt(2);this.zipComment=this.reader.readString(this.zipCommentLength)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8);this.versionMadeBy=this.reader.readString(2);this.versionNeeded=this.reader.readInt(2);this.diskNumber=this.reader.readInt(4);this.diskWithCentralDirStart=this.reader.readInt(4);this.centralDirRecordsOnThisDisk=this.reader.readInt(8);this.centralDirRecords=this.reader.readInt(8);this.centralDirSize=this.reader.readInt(8);this.centralDirOffset=this.reader.readInt(8);this.zip64ExtensibleData={};var extraDataSize=this.zip64EndOfCentralSize-44,index=0,extraFieldId,extraFieldLength,extraFieldValue;while(index<extraDataSize){extraFieldId=this.reader.readInt(2);extraFieldLength=this.reader.readInt(4);extraFieldValue=this.reader.readString(extraFieldLength);this.zip64ExtensibleData[extraFieldId]={id:extraFieldId,length:extraFieldLength,value:extraFieldValue}}},readBlockZip64EndOfCentralLocator:function(){this.diskWithZip64CentralDirStart=this.reader.readInt(4);this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8);this.disksCount=this.reader.readInt(4);if(this.disksCount>1){throw new Error("Multi-volumes zip are not supported")}},readLocalFiles:function(){var i,file;for(i=0;i<this.files.length;i++){file=this.files[i];this.reader.setIndex(file.localHeaderOffset);this.checkSignature(JSZip.signature.LOCAL_FILE_HEADER);file.readLocalPart(this.reader);file.handleUTF8()}},readCentralDir:function(){var file;this.reader.setIndex(this.centralDirOffset);while(this.reader.readString(4)===JSZip.signature.CENTRAL_FILE_HEADER){file=new ZipEntry({zip64:this.zip64},this.loadOptions);file.readCentralPart(this.reader);this.files.push(file)}},readEndOfCentral:function(){var offset=this.reader.lastIndexOfSignature(JSZip.signature.CENTRAL_DIRECTORY_END);if(offset===-1){throw new Error("Corrupted zip : can't find end of central directory")}this.reader.setIndex(offset);this.checkSignature(JSZip.signature.CENTRAL_DIRECTORY_END);this.readBlockEndOfCentral();if(this.diskNumber===MAX_VALUE_16BITS||this.diskWithCentralDirStart===MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===MAX_VALUE_16BITS||this.centralDirRecords===MAX_VALUE_16BITS||this.centralDirSize===MAX_VALUE_32BITS||this.centralDirOffset===MAX_VALUE_32BITS){this.zip64=true;offset=this.reader.lastIndexOfSignature(JSZip.signature.ZIP64_CENTRAL_DIRECTORY_LOCATOR);if(offset===-1){throw new Error("Corrupted zip : can't find the ZIP64 end of central directory locator")}this.reader.setIndex(offset);this.checkSignature(JSZip.signature.ZIP64_CENTRAL_DIRECTORY_LOCATOR);this.readBlockZip64EndOfCentralLocator();this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);this.checkSignature(JSZip.signature.ZIP64_CENTRAL_DIRECTORY_END);this.readBlockZip64EndOfCentral()}},prepareReader:function(data){var type=JSZip.utils.getTypeOf(data);if(type==="string"&&!JSZip.support.uint8array){this.reader=new StringReader(data,this.loadOptions.optimizedBinaryString)}else if(type==="nodebuffer"){this.reader=new NodeBufferReader(data)}else{this.reader=new Uint8ArrayReader(JSZip.utils.transformTo("uint8array",data))}},load:function(data){this.prepareReader(data);this.readEndOfCentral();this.readCentralDir();this.readLocalFiles()}};JSZip.prototype.load=function(data,options){var files,zipEntries,i,input;options=options||{};if(options.base64){data=JSZip.base64.decode(data)}zipEntries=new ZipEntries(data,options);files=zipEntries.files;for(i=0;i<files.length;i++){input=files[i];this.file(input.fileName,input.decompressed,{binary:true,optimizedBinaryString:true,date:input.date,dir:input.dir})}return this}})(this);if(typeof exports!=="undefined")exports.JSZip=JSZip;var cptable={};cptable[874]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€����…�����������‘’“”•–—�������� กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[932]=function(){var d={},e={},D=[],j;D[0]="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~���������������������������������｡｢｣､･ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝﾞﾟ��������������������������������".split("");for(j=0;j!=D[0].length;++j)if(D[0][j].charCodeAt(0)!==65533){e[D[0][j]]=0*256+j;d[0*256+j]=D[0][j]}D[129]="����������������������������������������������������������������　、。，．・：；？！゛゜´｀¨＾￣＿ヽヾゝゞ〃仝々〆〇ー―‐／＼～∥｜…‥‘’“”（）〔〕［］｛｝〈〉《》「」『』【】＋－±×�÷＝≠＜＞≦≧∞∴♂♀°′″℃￥＄￠￡％＃＆＊＠§☆★○●◎◇◆□■△▲▽▼※〒→←↑↓〓�����������∈∋⊆⊇⊂⊃∪∩��������∧∨￢⇒⇔∀∃�����������∠⊥⌒∂∇≡≒≪≫√∽∝∵∫∬�������Å‰♯♭♪†‡¶����◯���".split("");for(j=0;j!=D[129].length;++j)if(D[129][j].charCodeAt(0)!==65533){e[D[129][j]]=129*256+j;d[129*256+j]=D[129][j]}D[130]="�������������������������������������������������������������������������������０１２３４５６７８９�������ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ�������ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ����ぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞただちぢっつづてでとどなにぬねのはばぱひびぴふぶぷへべぺほぼぽまみむめもゃやゅゆょよらりるれろゎわゐゑをん��������������".split("");for(j=0;j!=D[130].length;++j)if(D[130][j].charCodeAt(0)!==65533){e[D[130][j]]=130*256+j;d[130*256+j]=D[130][j]}D[131]="����������������������������������������������������������������ァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾタダチヂッツヅテデトドナニヌネノハバパヒビピフブプヘベペホボポマミ�ムメモャヤュユョヨラリルレロヮワヰヱヲンヴヵヶ��������ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩ��������αβγδεζηθικλμνξοπρστυφχψω�����������������������������������������".split("");for(j=0;j!=D[131].length;++j)if(D[131][j].charCodeAt(0)!==65533){e[D[131][j]]=131*256+j;d[131*256+j]=D[131][j]}D[132]="����������������������������������������������������������������АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ���������������абвгдеёжзийклмн�опрстуфхцчшщъыьэюя�������������─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂�����������������������������������������������������������������".split("");for(j=0;j!=D[132].length;++j)if(D[132][j].charCodeAt(0)!==65533){e[D[132][j]]=132*256+j;d[132*256+j]=D[132][j]}D[135]="����������������������������������������������������������������①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ�㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㎡��������㍻�〝〟№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼≒≡∫∮∑√⊥∠∟⊿∵∩∪���������������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[135].length;++j)if(D[135][j].charCodeAt(0)!==65533){e[D[135][j]]=135*256+j;d[135*256+j]=D[135][j]}D[136]="���������������������������������������������������������������������������������������������������������������������������������������������������������������亜唖娃阿哀愛挨姶逢葵茜穐悪握渥旭葦芦鯵梓圧斡扱宛姐虻飴絢綾鮎或粟袷安庵按暗案闇鞍杏以伊位依偉囲夷委威尉惟意慰易椅為畏異移維緯胃萎衣謂違遺医井亥域育郁磯一壱溢逸稲茨芋鰯允印咽員因姻引飲淫胤蔭���".split("");for(j=0;j!=D[136].length;++j)if(D[136][j].charCodeAt(0)!==65533){e[D[136][j]]=136*256+j;d[136*256+j]=D[136][j]}D[137]="����������������������������������������������������������������院陰隠韻吋右宇烏羽迂雨卯鵜窺丑碓臼渦嘘唄欝蔚鰻姥厩浦瓜閏噂云運雲荏餌叡営嬰影映曳栄永泳洩瑛盈穎頴英衛詠鋭液疫益駅悦謁越閲榎厭円�園堰奄宴延怨掩援沿演炎焔煙燕猿縁艶苑薗遠鉛鴛塩於汚甥凹央奥往応押旺横欧殴王翁襖鴬鴎黄岡沖荻億屋憶臆桶牡乙俺卸恩温穏音下化仮何伽価佳加可嘉夏嫁家寡科暇果架歌河火珂禍禾稼箇花苛茄荷華菓蝦課嘩貨迦過霞蚊俄峨我牙画臥芽蛾賀雅餓駕介会解回塊壊廻快怪悔恢懐戒拐改���".split("");for(j=0;j!=D[137].length;++j)if(D[137][j].charCodeAt(0)!==65533){e[D[137][j]]=137*256+j;d[137*256+j]=D[137][j]}D[138]="����������������������������������������������������������������魁晦械海灰界皆絵芥蟹開階貝凱劾外咳害崖慨概涯碍蓋街該鎧骸浬馨蛙垣柿蛎鈎劃嚇各廓拡撹格核殻獲確穫覚角赫較郭閣隔革学岳楽額顎掛笠樫�橿梶鰍潟割喝恰括活渇滑葛褐轄且鰹叶椛樺鞄株兜竃蒲釜鎌噛鴨栢茅萱粥刈苅瓦乾侃冠寒刊勘勧巻喚堪姦完官寛干幹患感慣憾換敢柑桓棺款歓汗漢澗潅環甘監看竿管簡緩缶翰肝艦莞観諌貫還鑑間閑関陥韓館舘丸含岸巌玩癌眼岩翫贋雁頑顔願企伎危喜器基奇嬉寄岐希幾忌揮机旗既期棋棄���".split("");for(j=0;j!=D[138].length;++j)if(D[138][j].charCodeAt(0)!==65533){e[D[138][j]]=138*256+j;d[138*256+j]=D[138][j]}D[139]="����������������������������������������������������������������機帰毅気汽畿祈季稀紀徽規記貴起軌輝飢騎鬼亀偽儀妓宜戯技擬欺犠疑祇義蟻誼議掬菊鞠吉吃喫桔橘詰砧杵黍却客脚虐逆丘久仇休及吸宮弓急救�朽求汲泣灸球究窮笈級糾給旧牛去居巨拒拠挙渠虚許距鋸漁禦魚亨享京供侠僑兇競共凶協匡卿叫喬境峡強彊怯恐恭挟教橋況狂狭矯胸脅興蕎郷鏡響饗驚仰凝尭暁業局曲極玉桐粁僅勤均巾錦斤欣欽琴禁禽筋緊芹菌衿襟謹近金吟銀九倶句区狗玖矩苦躯駆駈駒具愚虞喰空偶寓遇隅串櫛釧屑屈���".split("");for(j=0;j!=D[139].length;++j)if(D[139][j].charCodeAt(0)!==65533){e[D[139][j]]=139*256+j;d[139*256+j]=D[139][j]}D[140]="����������������������������������������������������������������掘窟沓靴轡窪熊隈粂栗繰桑鍬勲君薫訓群軍郡卦袈祁係傾刑兄啓圭珪型契形径恵慶慧憩掲携敬景桂渓畦稽系経継繋罫茎荊蛍計詣警軽頚鶏芸迎鯨�劇戟撃激隙桁傑欠決潔穴結血訣月件倹倦健兼券剣喧圏堅嫌建憲懸拳捲検権牽犬献研硯絹県肩見謙賢軒遣鍵険顕験鹸元原厳幻弦減源玄現絃舷言諺限乎個古呼固姑孤己庫弧戸故枯湖狐糊袴股胡菰虎誇跨鈷雇顧鼓五互伍午呉吾娯後御悟梧檎瑚碁語誤護醐乞鯉交佼侯候倖光公功効勾厚口向���".split("");for(j=0;j!=D[140].length;++j)if(D[140][j].charCodeAt(0)!==65533){e[D[140][j]]=140*256+j;d[140*256+j]=D[140][j]}D[141]="����������������������������������������������������������������后喉坑垢好孔孝宏工巧巷幸広庚康弘恒慌抗拘控攻昂晃更杭校梗構江洪浩港溝甲皇硬稿糠紅紘絞綱耕考肯肱腔膏航荒行衡講貢購郊酵鉱砿鋼閤降�項香高鴻剛劫号合壕拷濠豪轟麹克刻告国穀酷鵠黒獄漉腰甑忽惚骨狛込此頃今困坤墾婚恨懇昏昆根梱混痕紺艮魂些佐叉唆嵯左差査沙瑳砂詐鎖裟坐座挫債催再最哉塞妻宰彩才採栽歳済災采犀砕砦祭斎細菜裁載際剤在材罪財冴坂阪堺榊肴咲崎埼碕鷺作削咋搾昨朔柵窄策索錯桜鮭笹匙冊刷���".split("");for(j=0;j!=D[141].length;++j)if(D[141][j].charCodeAt(0)!==65533){e[D[141][j]]=141*256+j;d[141*256+j]=D[141][j]}D[142]="����������������������������������������������������������������察拶撮擦札殺薩雑皐鯖捌錆鮫皿晒三傘参山惨撒散桟燦珊産算纂蚕讃賛酸餐斬暫残仕仔伺使刺司史嗣四士始姉姿子屍市師志思指支孜斯施旨枝止�死氏獅祉私糸紙紫肢脂至視詞詩試誌諮資賜雌飼歯事似侍児字寺慈持時次滋治爾璽痔磁示而耳自蒔辞汐鹿式識鴫竺軸宍雫七叱執失嫉室悉湿漆疾質実蔀篠偲柴芝屡蕊縞舎写射捨赦斜煮社紗者謝車遮蛇邪借勺尺杓灼爵酌釈錫若寂弱惹主取守手朱殊狩珠種腫趣酒首儒受呪寿授樹綬需囚収周���".split("");for(j=0;j!=D[142].length;++j)if(D[142][j].charCodeAt(0)!==65533){e[D[142][j]]=142*256+j;d[142*256+j]=D[142][j]}D[143]="����������������������������������������������������������������宗就州修愁拾洲秀秋終繍習臭舟蒐衆襲讐蹴輯週酋酬集醜什住充十従戎柔汁渋獣縦重銃叔夙宿淑祝縮粛塾熟出術述俊峻春瞬竣舜駿准循旬楯殉淳�準潤盾純巡遵醇順処初所暑曙渚庶緒署書薯藷諸助叙女序徐恕鋤除傷償勝匠升召哨商唱嘗奨妾娼宵将小少尚庄床廠彰承抄招掌捷昇昌昭晶松梢樟樵沼消渉湘焼焦照症省硝礁祥称章笑粧紹肖菖蒋蕉衝裳訟証詔詳象賞醤鉦鍾鐘障鞘上丈丞乗冗剰城場壌嬢常情擾条杖浄状畳穣蒸譲醸錠嘱埴飾���".split("");for(j=0;j!=D[143].length;++j)if(D[143][j].charCodeAt(0)!==65533){e[D[143][j]]=143*256+j;d[143*256+j]=D[143][j]}D[144]="����������������������������������������������������������������拭植殖燭織職色触食蝕辱尻伸信侵唇娠寝審心慎振新晋森榛浸深申疹真神秦紳臣芯薪親診身辛進針震人仁刃塵壬尋甚尽腎訊迅陣靭笥諏須酢図厨�逗吹垂帥推水炊睡粋翠衰遂酔錐錘随瑞髄崇嵩数枢趨雛据杉椙菅頗雀裾澄摺寸世瀬畝是凄制勢姓征性成政整星晴棲栖正清牲生盛精聖声製西誠誓請逝醒青静斉税脆隻席惜戚斥昔析石積籍績脊責赤跡蹟碩切拙接摂折設窃節説雪絶舌蝉仙先千占宣専尖川戦扇撰栓栴泉浅洗染潜煎煽旋穿箭線���".split("");for(j=0;j!=D[144].length;++j)if(D[144][j].charCodeAt(0)!==65533){e[D[144][j]]=144*256+j;d[144*256+j]=D[144][j]}D[145]="����������������������������������������������������������������繊羨腺舛船薦詮賎践選遷銭銑閃鮮前善漸然全禅繕膳糎噌塑岨措曾曽楚狙疏疎礎祖租粗素組蘇訴阻遡鼠僧創双叢倉喪壮奏爽宋層匝惣想捜掃挿掻�操早曹巣槍槽漕燥争痩相窓糟総綜聡草荘葬蒼藻装走送遭鎗霜騒像増憎臓蔵贈造促側則即息捉束測足速俗属賊族続卒袖其揃存孫尊損村遜他多太汰詑唾堕妥惰打柁舵楕陀駄騨体堆対耐岱帯待怠態戴替泰滞胎腿苔袋貸退逮隊黛鯛代台大第醍題鷹滝瀧卓啄宅托択拓沢濯琢託鐸濁諾茸凧蛸只���".split("");for(j=0;j!=D[145].length;++j)if(D[145][j].charCodeAt(0)!==65533){e[D[145][j]]=145*256+j;d[145*256+j]=D[145][j]}D[146]="����������������������������������������������������������������叩但達辰奪脱巽竪辿棚谷狸鱈樽誰丹単嘆坦担探旦歎淡湛炭短端箪綻耽胆蛋誕鍛団壇弾断暖檀段男談値知地弛恥智池痴稚置致蜘遅馳築畜竹筑蓄�逐秩窒茶嫡着中仲宙忠抽昼柱注虫衷註酎鋳駐樗瀦猪苧著貯丁兆凋喋寵帖帳庁弔張彫徴懲挑暢朝潮牒町眺聴脹腸蝶調諜超跳銚長頂鳥勅捗直朕沈珍賃鎮陳津墜椎槌追鎚痛通塚栂掴槻佃漬柘辻蔦綴鍔椿潰坪壷嬬紬爪吊釣鶴亭低停偵剃貞呈堤定帝底庭廷弟悌抵挺提梯汀碇禎程締艇訂諦蹄逓���".split("");for(j=0;j!=D[146].length;++j)if(D[146][j].charCodeAt(0)!==65533){e[D[146][j]]=146*256+j;d[146*256+j]=D[146][j]}D[147]="����������������������������������������������������������������邸鄭釘鼎泥摘擢敵滴的笛適鏑溺哲徹撤轍迭鉄典填天展店添纏甜貼転顛点伝殿澱田電兎吐堵塗妬屠徒斗杜渡登菟賭途都鍍砥砺努度土奴怒倒党冬�凍刀唐塔塘套宕島嶋悼投搭東桃梼棟盗淘湯涛灯燈当痘祷等答筒糖統到董蕩藤討謄豆踏逃透鐙陶頭騰闘働動同堂導憧撞洞瞳童胴萄道銅峠鴇匿得徳涜特督禿篤毒独読栃橡凸突椴届鳶苫寅酉瀞噸屯惇敦沌豚遁頓呑曇鈍奈那内乍凪薙謎灘捺鍋楢馴縄畷南楠軟難汝二尼弐迩匂賑肉虹廿日乳入���".split("");for(j=0;j!=D[147].length;++j)if(D[147][j].charCodeAt(0)!==65533){e[D[147][j]]=147*256+j;d[147*256+j]=D[147][j]}D[148]="����������������������������������������������������������������如尿韮任妊忍認濡禰祢寧葱猫熱年念捻撚燃粘乃廼之埜嚢悩濃納能脳膿農覗蚤巴把播覇杷波派琶破婆罵芭馬俳廃拝排敗杯盃牌背肺輩配倍培媒梅�楳煤狽買売賠陪這蝿秤矧萩伯剥博拍柏泊白箔粕舶薄迫曝漠爆縛莫駁麦函箱硲箸肇筈櫨幡肌畑畠八鉢溌発醗髪伐罰抜筏閥鳩噺塙蛤隼伴判半反叛帆搬斑板氾汎版犯班畔繁般藩販範釆煩頒飯挽晩番盤磐蕃蛮匪卑否妃庇彼悲扉批披斐比泌疲皮碑秘緋罷肥被誹費避非飛樋簸備尾微枇毘琵眉美���".split("");for(j=0;j!=D[148].length;++j)if(D[148][j].charCodeAt(0)!==65533){e[D[148][j]]=148*256+j;d[148*256+j]=D[148][j]}D[149]="����������������������������������������������������������������鼻柊稗匹疋髭彦膝菱肘弼必畢筆逼桧姫媛紐百謬俵彪標氷漂瓢票表評豹廟描病秒苗錨鋲蒜蛭鰭品彬斌浜瀕貧賓頻敏瓶不付埠夫婦富冨布府怖扶敷�斧普浮父符腐膚芙譜負賦赴阜附侮撫武舞葡蕪部封楓風葺蕗伏副復幅服福腹複覆淵弗払沸仏物鮒分吻噴墳憤扮焚奮粉糞紛雰文聞丙併兵塀幣平弊柄並蔽閉陛米頁僻壁癖碧別瞥蔑箆偏変片篇編辺返遍便勉娩弁鞭保舗鋪圃捕歩甫補輔穂募墓慕戊暮母簿菩倣俸包呆報奉宝峰峯崩庖抱捧放方朋���".split("");for(j=0;j!=D[149].length;++j)if(D[149][j].charCodeAt(0)!==65533){e[D[149][j]]=149*256+j;d[149*256+j]=D[149][j]}D[150]="����������������������������������������������������������������法泡烹砲縫胞芳萌蓬蜂褒訪豊邦鋒飽鳳鵬乏亡傍剖坊妨帽忘忙房暴望某棒冒紡肪膨謀貌貿鉾防吠頬北僕卜墨撲朴牧睦穆釦勃没殆堀幌奔本翻凡盆�摩磨魔麻埋妹昧枚毎哩槙幕膜枕鮪柾鱒桝亦俣又抹末沫迄侭繭麿万慢満漫蔓味未魅巳箕岬密蜜湊蓑稔脈妙粍民眠務夢無牟矛霧鵡椋婿娘冥名命明盟迷銘鳴姪牝滅免棉綿緬面麺摸模茂妄孟毛猛盲網耗蒙儲木黙目杢勿餅尤戻籾貰問悶紋門匁也冶夜爺耶野弥矢厄役約薬訳躍靖柳薮鑓愉愈油癒���".split("");for(j=0;j!=D[150].length;++j)if(D[150][j].charCodeAt(0)!==65533){e[D[150][j]]=150*256+j;d[150*256+j]=D[150][j]}D[151]="����������������������������������������������������������������諭輸唯佑優勇友宥幽悠憂揖有柚湧涌猶猷由祐裕誘遊邑郵雄融夕予余与誉輿預傭幼妖容庸揚揺擁曜楊様洋溶熔用窯羊耀葉蓉要謡踊遥陽養慾抑欲�沃浴翌翼淀羅螺裸来莱頼雷洛絡落酪乱卵嵐欄濫藍蘭覧利吏履李梨理璃痢裏裡里離陸律率立葎掠略劉流溜琉留硫粒隆竜龍侶慮旅虜了亮僚両凌寮料梁涼猟療瞭稜糧良諒遼量陵領力緑倫厘林淋燐琳臨輪隣鱗麟瑠塁涙累類令伶例冷励嶺怜玲礼苓鈴隷零霊麗齢暦歴列劣烈裂廉恋憐漣煉簾練聯���".split("");for(j=0;j!=D[151].length;++j)if(D[151][j].charCodeAt(0)!==65533){e[D[151][j]]=151*256+j;d[151*256+j]=D[151][j]}D[152]="����������������������������������������������������������������蓮連錬呂魯櫓炉賂路露労婁廊弄朗楼榔浪漏牢狼篭老聾蝋郎六麓禄肋録論倭和話歪賄脇惑枠鷲亙亘鰐詫藁蕨椀湾碗腕��������������������������������������������弌丐丕个丱丶丼丿乂乖乘亂亅豫亊舒弍于亞亟亠亢亰亳亶从仍仄仆仂仗仞仭仟价伉佚估佛佝佗佇佶侈侏侘佻佩佰侑佯來侖儘俔俟俎俘俛俑俚俐俤俥倚倨倔倪倥倅伜俶倡倩倬俾俯們倆偃假會偕偐偈做偖偬偸傀傚傅傴傲���".split("");for(j=0;j!=D[152].length;++j)if(D[152][j].charCodeAt(0)!==65533){e[D[152][j]]=152*256+j;d[152*256+j]=D[152][j]}D[153]="����������������������������������������������������������������僉僊傳僂僖僞僥僭僣僮價僵儉儁儂儖儕儔儚儡儺儷儼儻儿兀兒兌兔兢竸兩兪兮冀冂囘册冉冏冑冓冕冖冤冦冢冩冪冫决冱冲冰况冽凅凉凛几處凩凭�凰凵凾刄刋刔刎刧刪刮刳刹剏剄剋剌剞剔剪剴剩剳剿剽劍劔劒剱劈劑辨辧劬劭劼劵勁勍勗勞勣勦飭勠勳勵勸勹匆匈甸匍匐匏匕匚匣匯匱匳匸區卆卅丗卉卍凖卞卩卮夘卻卷厂厖厠厦厥厮厰厶參簒雙叟曼燮叮叨叭叺吁吽呀听吭吼吮吶吩吝呎咏呵咎呟呱呷呰咒呻咀呶咄咐咆哇咢咸咥咬哄哈咨���".split("");for(j=0;j!=D[153].length;++j)if(D[153][j].charCodeAt(0)!==65533){e[D[153][j]]=153*256+j;d[153*256+j]=D[153][j]}D[154]="����������������������������������������������������������������咫哂咤咾咼哘哥哦唏唔哽哮哭哺哢唹啀啣啌售啜啅啖啗唸唳啝喙喀咯喊喟啻啾喘喞單啼喃喩喇喨嗚嗅嗟嗄嗜嗤嗔嘔嗷嘖嗾嗽嘛嗹噎噐營嘴嘶嘲嘸�噫噤嘯噬噪嚆嚀嚊嚠嚔嚏嚥嚮嚶嚴囂嚼囁囃囀囈囎囑囓囗囮囹圀囿圄圉圈國圍圓團圖嗇圜圦圷圸坎圻址坏坩埀垈坡坿垉垓垠垳垤垪垰埃埆埔埒埓堊埖埣堋堙堝塲堡塢塋塰毀塒堽塹墅墹墟墫墺壞墻墸墮壅壓壑壗壙壘壥壜壤壟壯壺壹壻壼壽夂夊夐夛梦夥夬夭夲夸夾竒奕奐奎奚奘奢奠奧奬奩���".split("");for(j=0;j!=D[154].length;++j)if(D[154][j].charCodeAt(0)!==65533){e[D[154][j]]=154*256+j;d[154*256+j]=D[154][j]}D[155]="����������������������������������������������������������������奸妁妝佞侫妣妲姆姨姜妍姙姚娥娟娑娜娉娚婀婬婉娵娶婢婪媚媼媾嫋嫂媽嫣嫗嫦嫩嫖嫺嫻嬌嬋嬖嬲嫐嬪嬶嬾孃孅孀孑孕孚孛孥孩孰孳孵學斈孺宀�它宦宸寃寇寉寔寐寤實寢寞寥寫寰寶寳尅將專對尓尠尢尨尸尹屁屆屎屓屐屏孱屬屮乢屶屹岌岑岔妛岫岻岶岼岷峅岾峇峙峩峽峺峭嶌峪崋崕崗嵜崟崛崑崔崢崚崙崘嵌嵒嵎嵋嵬嵳嵶嶇嶄嶂嶢嶝嶬嶮嶽嶐嶷嶼巉巍巓巒巖巛巫已巵帋帚帙帑帛帶帷幄幃幀幎幗幔幟幢幤幇幵并幺麼广庠廁廂廈廐廏���".split("");for(j=0;j!=D[155].length;++j)if(D[155][j].charCodeAt(0)!==65533){e[D[155][j]]=155*256+j;d[155*256+j]=D[155][j]}D[156]="����������������������������������������������������������������廖廣廝廚廛廢廡廨廩廬廱廳廰廴廸廾弃弉彝彜弋弑弖弩弭弸彁彈彌彎弯彑彖彗彙彡彭彳彷徃徂彿徊很徑徇從徙徘徠徨徭徼忖忻忤忸忱忝悳忿怡恠�怙怐怩怎怱怛怕怫怦怏怺恚恁恪恷恟恊恆恍恣恃恤恂恬恫恙悁悍惧悃悚悄悛悖悗悒悧悋惡悸惠惓悴忰悽惆悵惘慍愕愆惶惷愀惴惺愃愡惻惱愍愎慇愾愨愧慊愿愼愬愴愽慂慄慳慷慘慙慚慫慴慯慥慱慟慝慓慵憙憖憇憬憔憚憊憑憫憮懌懊應懷懈懃懆憺懋罹懍懦懣懶懺懴懿懽懼懾戀戈戉戍戌戔戛���".split("");for(j=0;j!=D[156].length;++j)if(D[156][j].charCodeAt(0)!==65533){e[D[156][j]]=156*256+j;d[156*256+j]=D[156][j]}D[157]="����������������������������������������������������������������戞戡截戮戰戲戳扁扎扞扣扛扠扨扼抂抉找抒抓抖拔抃抔拗拑抻拏拿拆擔拈拜拌拊拂拇抛拉挌拮拱挧挂挈拯拵捐挾捍搜捏掖掎掀掫捶掣掏掉掟掵捫�捩掾揩揀揆揣揉插揶揄搖搴搆搓搦搶攝搗搨搏摧摯摶摎攪撕撓撥撩撈撼據擒擅擇撻擘擂擱擧舉擠擡抬擣擯攬擶擴擲擺攀擽攘攜攅攤攣攫攴攵攷收攸畋效敖敕敍敘敞敝敲數斂斃變斛斟斫斷旃旆旁旄旌旒旛旙无旡旱杲昊昃旻杳昵昶昴昜晏晄晉晁晞晝晤晧晨晟晢晰暃暈暎暉暄暘暝曁暹曉暾暼���".split("");for(j=0;j!=D[157].length;++j)if(D[157][j].charCodeAt(0)!==65533){e[D[157][j]]=157*256+j;d[157*256+j]=D[157][j]}D[158]="����������������������������������������������������������������曄暸曖曚曠昿曦曩曰曵曷朏朖朞朦朧霸朮朿朶杁朸朷杆杞杠杙杣杤枉杰枩杼杪枌枋枦枡枅枷柯枴柬枳柩枸柤柞柝柢柮枹柎柆柧檜栞框栩桀桍栲桎�梳栫桙档桷桿梟梏梭梔條梛梃檮梹桴梵梠梺椏梍桾椁棊椈棘椢椦棡椌棍棔棧棕椶椒椄棗棣椥棹棠棯椨椪椚椣椡棆楹楷楜楸楫楔楾楮椹楴椽楙椰楡楞楝榁楪榲榮槐榿槁槓榾槎寨槊槝榻槃榧樮榑榠榜榕榴槞槨樂樛槿權槹槲槧樅榱樞槭樔槫樊樒櫁樣樓橄樌橲樶橸橇橢橙橦橈樸樢檐檍檠檄檢檣���".split("");for(j=0;j!=D[158].length;++j)if(D[158][j].charCodeAt(0)!==65533){e[D[158][j]]=158*256+j;d[158*256+j]=D[158][j]}D[159]="����������������������������������������������������������������檗蘗檻櫃櫂檸檳檬櫞櫑櫟檪櫚櫪櫻欅蘖櫺欒欖鬱欟欸欷盜欹飮歇歃歉歐歙歔歛歟歡歸歹歿殀殄殃殍殘殕殞殤殪殫殯殲殱殳殷殼毆毋毓毟毬毫毳毯�麾氈氓气氛氤氣汞汕汢汪沂沍沚沁沛汾汨汳沒沐泄泱泓沽泗泅泝沮沱沾沺泛泯泙泪洟衍洶洫洽洸洙洵洳洒洌浣涓浤浚浹浙涎涕濤涅淹渕渊涵淇淦涸淆淬淞淌淨淒淅淺淙淤淕淪淮渭湮渮渙湲湟渾渣湫渫湶湍渟湃渺湎渤滿渝游溂溪溘滉溷滓溽溯滄溲滔滕溏溥滂溟潁漑灌滬滸滾漿滲漱滯漲滌���".split("");for(j=0;j!=D[159].length;++j)if(D[159][j].charCodeAt(0)!==65533){e[D[159][j]]=159*256+j;d[159*256+j]=D[159][j]}D[224]="����������������������������������������������������������������漾漓滷澆潺潸澁澀潯潛濳潭澂潼潘澎澑濂潦澳澣澡澤澹濆澪濟濕濬濔濘濱濮濛瀉瀋濺瀑瀁瀏濾瀛瀚潴瀝瀘瀟瀰瀾瀲灑灣炙炒炯烱炬炸炳炮烟烋烝�烙焉烽焜焙煥煕熈煦煢煌煖煬熏燻熄熕熨熬燗熹熾燒燉燔燎燠燬燧燵燼燹燿爍爐爛爨爭爬爰爲爻爼爿牀牆牋牘牴牾犂犁犇犒犖犢犧犹犲狃狆狄狎狒狢狠狡狹狷倏猗猊猜猖猝猴猯猩猥猾獎獏默獗獪獨獰獸獵獻獺珈玳珎玻珀珥珮珞璢琅瑯琥珸琲琺瑕琿瑟瑙瑁瑜瑩瑰瑣瑪瑶瑾璋璞璧瓊瓏瓔珱���".split("");for(j=0;j!=D[224].length;++j)if(D[224][j].charCodeAt(0)!==65533){e[D[224][j]]=224*256+j;d[224*256+j]=D[224][j]}D[225]="����������������������������������������������������������������瓠瓣瓧瓩瓮瓲瓰瓱瓸瓷甄甃甅甌甎甍甕甓甞甦甬甼畄畍畊畉畛畆畚畩畤畧畫畭畸當疆疇畴疊疉疂疔疚疝疥疣痂疳痃疵疽疸疼疱痍痊痒痙痣痞痾痿�痼瘁痰痺痲痳瘋瘍瘉瘟瘧瘠瘡瘢瘤瘴瘰瘻癇癈癆癜癘癡癢癨癩癪癧癬癰癲癶癸發皀皃皈皋皎皖皓皙皚皰皴皸皹皺盂盍盖盒盞盡盥盧盪蘯盻眈眇眄眩眤眞眥眦眛眷眸睇睚睨睫睛睥睿睾睹瞎瞋瞑瞠瞞瞰瞶瞹瞿瞼瞽瞻矇矍矗矚矜矣矮矼砌砒礦砠礪硅碎硴碆硼碚碌碣碵碪碯磑磆磋磔碾碼磅磊磬���".split("");for(j=0;j!=D[225].length;++j)if(D[225][j].charCodeAt(0)!==65533){e[D[225][j]]=225*256+j;d[225*256+j]=D[225][j]}D[226]="����������������������������������������������������������������磧磚磽磴礇礒礑礙礬礫祀祠祗祟祚祕祓祺祿禊禝禧齋禪禮禳禹禺秉秕秧秬秡秣稈稍稘稙稠稟禀稱稻稾稷穃穗穉穡穢穩龝穰穹穽窈窗窕窘窖窩竈窰�窶竅竄窿邃竇竊竍竏竕竓站竚竝竡竢竦竭竰笂笏笊笆笳笘笙笞笵笨笶筐筺笄筍笋筌筅筵筥筴筧筰筱筬筮箝箘箟箍箜箚箋箒箏筝箙篋篁篌篏箴篆篝篩簑簔篦篥籠簀簇簓篳篷簗簍篶簣簧簪簟簷簫簽籌籃籔籏籀籐籘籟籤籖籥籬籵粃粐粤粭粢粫粡粨粳粲粱粮粹粽糀糅糂糘糒糜糢鬻糯糲糴糶糺紆���".split("");for(j=0;j!=D[226].length;++j)if(D[226][j].charCodeAt(0)!==65533){e[D[226][j]]=226*256+j;d[226*256+j]=D[226][j]}D[227]="����������������������������������������������������������������紂紜紕紊絅絋紮紲紿紵絆絳絖絎絲絨絮絏絣經綉絛綏絽綛綺綮綣綵緇綽綫總綢綯緜綸綟綰緘緝緤緞緻緲緡縅縊縣縡縒縱縟縉縋縢繆繦縻縵縹繃縷�縲縺繧繝繖繞繙繚繹繪繩繼繻纃緕繽辮繿纈纉續纒纐纓纔纖纎纛纜缸缺罅罌罍罎罐网罕罔罘罟罠罨罩罧罸羂羆羃羈羇羌羔羞羝羚羣羯羲羹羮羶羸譱翅翆翊翕翔翡翦翩翳翹飜耆耄耋耒耘耙耜耡耨耿耻聊聆聒聘聚聟聢聨聳聲聰聶聹聽聿肄肆肅肛肓肚肭冐肬胛胥胙胝胄胚胖脉胯胱脛脩脣脯腋���".split("");for(j=0;j!=D[227].length;++j)if(D[227][j].charCodeAt(0)!==65533){e[D[227][j]]=227*256+j;d[227*256+j]=D[227][j]}D[228]="����������������������������������������������������������������隋腆脾腓腑胼腱腮腥腦腴膃膈膊膀膂膠膕膤膣腟膓膩膰膵膾膸膽臀臂膺臉臍臑臙臘臈臚臟臠臧臺臻臾舁舂舅與舊舍舐舖舩舫舸舳艀艙艘艝艚艟艤�艢艨艪艫舮艱艷艸艾芍芒芫芟芻芬苡苣苟苒苴苳苺莓范苻苹苞茆苜茉苙茵茴茖茲茱荀茹荐荅茯茫茗茘莅莚莪莟莢莖茣莎莇莊荼莵荳荵莠莉莨菴萓菫菎菽萃菘萋菁菷萇菠菲萍萢萠莽萸蔆菻葭萪萼蕚蒄葷葫蒭葮蒂葩葆萬葯葹萵蓊葢蒹蒿蒟蓙蓍蒻蓚蓐蓁蓆蓖蒡蔡蓿蓴蔗蔘蔬蔟蔕蔔蓼蕀蕣蕘蕈���".split("");
for(j=0;j!=D[228].length;++j)if(D[228][j].charCodeAt(0)!==65533){e[D[228][j]]=228*256+j;d[228*256+j]=D[228][j]}D[229]="����������������������������������������������������������������蕁蘂蕋蕕薀薤薈薑薊薨蕭薔薛藪薇薜蕷蕾薐藉薺藏薹藐藕藝藥藜藹蘊蘓蘋藾藺蘆蘢蘚蘰蘿虍乕虔號虧虱蚓蚣蚩蚪蚋蚌蚶蚯蛄蛆蚰蛉蠣蚫蛔蛞蛩蛬�蛟蛛蛯蜒蜆蜈蜀蜃蛻蜑蜉蜍蛹蜊蜴蜿蜷蜻蜥蜩蜚蝠蝟蝸蝌蝎蝴蝗蝨蝮蝙蝓蝣蝪蠅螢螟螂螯蟋螽蟀蟐雖螫蟄螳蟇蟆螻蟯蟲蟠蠏蠍蟾蟶蟷蠎蟒蠑蠖蠕蠢蠡蠱蠶蠹蠧蠻衄衂衒衙衞衢衫袁衾袞衵衽袵衲袂袗袒袮袙袢袍袤袰袿袱裃裄裔裘裙裝裹褂裼裴裨裲褄褌褊褓襃褞褥褪褫襁襄褻褶褸襌褝襠襞���".split("");for(j=0;j!=D[229].length;++j)if(D[229][j].charCodeAt(0)!==65533){e[D[229][j]]=229*256+j;d[229*256+j]=D[229][j]}D[230]="����������������������������������������������������������������襦襤襭襪襯襴襷襾覃覈覊覓覘覡覩覦覬覯覲覺覽覿觀觚觜觝觧觴觸訃訖訐訌訛訝訥訶詁詛詒詆詈詼詭詬詢誅誂誄誨誡誑誥誦誚誣諄諍諂諚諫諳諧�諤諱謔諠諢諷諞諛謌謇謚諡謖謐謗謠謳鞫謦謫謾謨譁譌譏譎證譖譛譚譫譟譬譯譴譽讀讌讎讒讓讖讙讚谺豁谿豈豌豎豐豕豢豬豸豺貂貉貅貊貍貎貔豼貘戝貭貪貽貲貳貮貶賈賁賤賣賚賽賺賻贄贅贊贇贏贍贐齎贓賍贔贖赧赭赱赳趁趙跂趾趺跏跚跖跌跛跋跪跫跟跣跼踈踉跿踝踞踐踟蹂踵踰踴蹊���".split("");for(j=0;j!=D[230].length;++j)if(D[230][j].charCodeAt(0)!==65533){e[D[230][j]]=230*256+j;d[230*256+j]=D[230][j]}D[231]="����������������������������������������������������������������蹇蹉蹌蹐蹈蹙蹤蹠踪蹣蹕蹶蹲蹼躁躇躅躄躋躊躓躑躔躙躪躡躬躰軆躱躾軅軈軋軛軣軼軻軫軾輊輅輕輒輙輓輜輟輛輌輦輳輻輹轅轂輾轌轉轆轎轗轜�轢轣轤辜辟辣辭辯辷迚迥迢迪迯邇迴逅迹迺逑逕逡逍逞逖逋逧逶逵逹迸遏遐遑遒逎遉逾遖遘遞遨遯遶隨遲邂遽邁邀邊邉邏邨邯邱邵郢郤扈郛鄂鄒鄙鄲鄰酊酖酘酣酥酩酳酲醋醉醂醢醫醯醪醵醴醺釀釁釉釋釐釖釟釡釛釼釵釶鈞釿鈔鈬鈕鈑鉞鉗鉅鉉鉤鉈銕鈿鉋鉐銜銖銓銛鉚鋏銹銷鋩錏鋺鍄錮���".split("");for(j=0;j!=D[231].length;++j)if(D[231][j].charCodeAt(0)!==65533){e[D[231][j]]=231*256+j;d[231*256+j]=D[231][j]}D[232]="����������������������������������������������������������������錙錢錚錣錺錵錻鍜鍠鍼鍮鍖鎰鎬鎭鎔鎹鏖鏗鏨鏥鏘鏃鏝鏐鏈鏤鐚鐔鐓鐃鐇鐐鐶鐫鐵鐡鐺鑁鑒鑄鑛鑠鑢鑞鑪鈩鑰鑵鑷鑽鑚鑼鑾钁鑿閂閇閊閔閖閘閙�閠閨閧閭閼閻閹閾闊濶闃闍闌闕闔闖關闡闥闢阡阨阮阯陂陌陏陋陷陜陞陝陟陦陲陬隍隘隕隗險隧隱隲隰隴隶隸隹雎雋雉雍襍雜霍雕雹霄霆霈霓霎霑霏霖霙霤霪霰霹霽霾靄靆靈靂靉靜靠靤靦靨勒靫靱靹鞅靼鞁靺鞆鞋鞏鞐鞜鞨鞦鞣鞳鞴韃韆韈韋韜韭齏韲竟韶韵頏頌頸頤頡頷頽顆顏顋顫顯顰���".split("");for(j=0;j!=D[232].length;++j)if(D[232][j].charCodeAt(0)!==65533){e[D[232][j]]=232*256+j;d[232*256+j]=D[232][j]}D[233]="����������������������������������������������������������������顱顴顳颪颯颱颶飄飃飆飩飫餃餉餒餔餘餡餝餞餤餠餬餮餽餾饂饉饅饐饋饑饒饌饕馗馘馥馭馮馼駟駛駝駘駑駭駮駱駲駻駸騁騏騅駢騙騫騷驅驂驀驃�騾驕驍驛驗驟驢驥驤驩驫驪骭骰骼髀髏髑髓體髞髟髢髣髦髯髫髮髴髱髷髻鬆鬘鬚鬟鬢鬣鬥鬧鬨鬩鬪鬮鬯鬲魄魃魏魍魎魑魘魴鮓鮃鮑鮖鮗鮟鮠鮨鮴鯀鯊鮹鯆鯏鯑鯒鯣鯢鯤鯔鯡鰺鯲鯱鯰鰕鰔鰉鰓鰌鰆鰈鰒鰊鰄鰮鰛鰥鰤鰡鰰鱇鰲鱆鰾鱚鱠鱧鱶鱸鳧鳬鳰鴉鴈鳫鴃鴆鴪鴦鶯鴣鴟鵄鴕鴒鵁鴿鴾鵆鵈���".split("");for(j=0;j!=D[233].length;++j)if(D[233][j].charCodeAt(0)!==65533){e[D[233][j]]=233*256+j;d[233*256+j]=D[233][j]}D[234]="����������������������������������������������������������������鵝鵞鵤鵑鵐鵙鵲鶉鶇鶫鵯鵺鶚鶤鶩鶲鷄鷁鶻鶸鶺鷆鷏鷂鷙鷓鷸鷦鷭鷯鷽鸚鸛鸞鹵鹹鹽麁麈麋麌麒麕麑麝麥麩麸麪麭靡黌黎黏黐黔黜點黝黠黥黨黯�黴黶黷黹黻黼黽鼇鼈皷鼕鼡鼬鼾齊齒齔齣齟齠齡齦齧齬齪齷齲齶龕龜龠堯槇遙瑤凜熙�������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[234].length;++j)if(D[234][j].charCodeAt(0)!==65533){e[D[234][j]]=234*256+j;d[234*256+j]=D[234][j]}D[237]="����������������������������������������������������������������纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏�塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱���".split("");for(j=0;j!=D[237].length;++j)if(D[237][j].charCodeAt(0)!==65533){e[D[237][j]]=237*256+j;d[237*256+j]=D[237][j]}D[238]="����������������������������������������������������������������犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙�蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑��ⅰⅱⅲⅳⅴⅵⅶⅷⅸⅹ￢￤＇＂���".split("");for(j=0;j!=D[238].length;++j)if(D[238][j].charCodeAt(0)!==65533){e[D[238][j]]=238*256+j;d[238*256+j]=D[238][j]}D[250]="����������������������������������������������������������������ⅰⅱⅲⅳⅴⅵⅶⅷⅸⅹⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ￢￤＇＂㈱№℡∵纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊�兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯���".split("");for(j=0;j!=D[250].length;++j)if(D[250][j].charCodeAt(0)!==65533){e[D[250][j]]=250*256+j;d[250*256+j]=D[250][j]}D[251]="����������������������������������������������������������������涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神�祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙���".split("");for(j=0;j!=D[251].length;++j)if(D[251][j].charCodeAt(0)!==65533){e[D[251][j]]=251*256+j;d[251*256+j]=D[251][j]}D[252]="����������������������������������������������������������������髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑������������������������������������������������������������������������������������������������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[252].length;++j)if(D[252][j].charCodeAt(0)!==65533){e[D[252][j]]=252*256+j;d[252*256+j]=D[252][j]}return{enc:e,dec:d}}();cptable[936]=function(){var d={},e={},D=[],j;D[0]="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€�������������������������������������������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[0].length;++j)if(D[0][j].charCodeAt(0)!==65533){e[D[0][j]]=0*256+j;d[0*256+j]=D[0][j]}D[129]="����������������������������������������������������������������丂丄丅丆丏丒丗丟丠両丣並丩丮丯丱丳丵丷丼乀乁乂乄乆乊乑乕乗乚乛乢乣乤乥乧乨乪乫乬乭乮乯乲乴乵乶乷乸乹乺乻乼乽乿亀亁亂亃亄亅亇亊�亐亖亗亙亜亝亞亣亪亯亰亱亴亶亷亸亹亼亽亾仈仌仏仐仒仚仛仜仠仢仦仧仩仭仮仯仱仴仸仹仺仼仾伀伂伃伄伅伆伇伈伋伌伒伓伔伕伖伜伝伡伣伨伩伬伭伮伱伳伵伷伹伻伾伿佀佁佂佄佅佇佈佉佊佋佌佒佔佖佡佢佦佨佪佫佭佮佱佲併佷佸佹佺佽侀侁侂侅來侇侊侌侎侐侒侓侕侖侘侙侚侜侞侟価侢�".split("");for(j=0;j!=D[129].length;++j)if(D[129][j].charCodeAt(0)!==65533){e[D[129][j]]=129*256+j;d[129*256+j]=D[129][j]}D[130]="����������������������������������������������������������������侤侫侭侰侱侲侳侴侶侷侸侹侺侻侼侽侾俀俁係俆俇俈俉俋俌俍俒俓俔俕俖俙俛俠俢俤俥俧俫俬俰俲俴俵俶俷俹俻俼俽俿倀倁倂倃倄倅倆倇倈倉倊�個倎倐們倓倕倖倗倛倝倞倠倢倣値倧倫倯倰倱倲倳倴倵倶倷倸倹倻倽倿偀偁偂偄偅偆偉偊偋偍偐偑偒偓偔偖偗偘偙偛偝偞偟偠偡偢偣偤偦偧偨偩偪偫偭偮偯偰偱偲偳側偵偸偹偺偼偽傁傂傃傄傆傇傉傊傋傌傎傏傐傑傒傓傔傕傖傗傘備傚傛傜傝傞傟傠傡傢傤傦傪傫傭傮傯傰傱傳傴債傶傷傸傹傼�".split("");for(j=0;j!=D[130].length;++j)if(D[130][j].charCodeAt(0)!==65533){e[D[130][j]]=130*256+j;d[130*256+j]=D[130][j]}D[131]="����������������������������������������������������������������傽傾傿僀僁僂僃僄僅僆僇僈僉僊僋僌働僎僐僑僒僓僔僕僗僘僙僛僜僝僞僟僠僡僢僣僤僥僨僩僪僫僯僰僱僲僴僶僷僸價僺僼僽僾僿儀儁儂儃億儅儈�儉儊儌儍儎儏儐儑儓儔儕儖儗儘儙儚儛儜儝儞償儠儢儣儤儥儦儧儨儩優儫儬儭儮儯儰儱儲儳儴儵儶儷儸儹儺儻儼儽儾兂兇兊兌兎兏児兒兓兗兘兙兛兝兞兟兠兡兣兤兦內兩兪兯兲兺兾兿冃冄円冇冊冋冎冏冐冑冓冔冘冚冝冞冟冡冣冦冧冨冩冪冭冮冴冸冹冺冾冿凁凂凃凅凈凊凍凎凐凒凓凔凕凖凗�".split("");for(j=0;j!=D[131].length;++j)if(D[131][j].charCodeAt(0)!==65533){e[D[131][j]]=131*256+j;d[131*256+j]=D[131][j]}D[132]="����������������������������������������������������������������凘凙凚凜凞凟凢凣凥処凧凨凩凪凬凮凱凲凴凷凾刄刅刉刋刌刏刐刓刔刕刜刞刟刡刢刣別刦刧刪刬刯刱刲刴刵刼刾剄剅剆則剈剉剋剎剏剒剓剕剗剘�剙剚剛剝剟剠剢剣剤剦剨剫剬剭剮剰剱剳剴創剶剷剸剹剺剻剼剾劀劃劄劅劆劇劉劊劋劌劍劎劏劑劒劔劕劖劗劘劙劚劜劤劥劦劧劮劯劰労劵劶劷劸効劺劻劼劽勀勁勂勄勅勆勈勊勌勍勎勏勑勓勔動勗務勚勛勜勝勞勠勡勢勣勥勦勧勨勩勪勫勬勭勮勯勱勲勳勴勵勶勷勸勻勼勽匁匂匃匄匇匉匊匋匌匎�".split("");for(j=0;j!=D[132].length;++j)if(D[132][j].charCodeAt(0)!==65533){e[D[132][j]]=132*256+j;d[132*256+j]=D[132][j]}D[133]="����������������������������������������������������������������匑匒匓匔匘匛匜匞匟匢匤匥匧匨匩匫匬匭匯匰匱匲匳匴匵匶匷匸匼匽區卂卄卆卋卌卍卐協単卙卛卝卥卨卪卬卭卲卶卹卻卼卽卾厀厁厃厇厈厊厎厏�厐厑厒厓厔厖厗厙厛厜厞厠厡厤厧厪厫厬厭厯厰厱厲厳厴厵厷厸厹厺厼厽厾叀參叄叅叆叇収叏叐叒叓叕叚叜叝叞叡叢叧叴叺叾叿吀吂吅吇吋吔吘吙吚吜吢吤吥吪吰吳吶吷吺吽吿呁呂呄呅呇呉呌呍呎呏呑呚呝呞呟呠呡呣呥呧呩呪呫呬呭呮呯呰呴呹呺呾呿咁咃咅咇咈咉咊咍咑咓咗咘咜咞咟咠咡�".split("");for(j=0;j!=D[133].length;++j)if(D[133][j].charCodeAt(0)!==65533){e[D[133][j]]=133*256+j;d[133*256+j]=D[133][j]}D[134]="����������������������������������������������������������������咢咥咮咰咲咵咶咷咹咺咼咾哃哅哊哋哖哘哛哠員哢哣哤哫哬哯哰哱哴哵哶哷哸哹哻哾唀唂唃唄唅唈唊唋唌唍唎唒唓唕唖唗唘唙唚唜唝唞唟唡唥唦�唨唩唫唭唲唴唵唶唸唹唺唻唽啀啂啅啇啈啋啌啍啎問啑啒啓啔啗啘啙啚啛啝啞啟啠啢啣啨啩啫啯啰啱啲啳啴啹啺啽啿喅喆喌喍喎喐喒喓喕喖喗喚喛喞喠喡喢喣喤喥喦喨喩喪喫喬喭單喯喰喲喴営喸喺喼喿嗀嗁嗂嗃嗆嗇嗈嗊嗋嗎嗏嗐嗕嗗嗘嗙嗚嗛嗞嗠嗢嗧嗩嗭嗮嗰嗱嗴嗶嗸嗹嗺嗻嗼嗿嘂嘃嘄嘅�".split("");for(j=0;j!=D[134].length;++j)if(D[134][j].charCodeAt(0)!==65533){e[D[134][j]]=134*256+j;d[134*256+j]=D[134][j]}D[135]="����������������������������������������������������������������嘆嘇嘊嘋嘍嘐嘑嘒嘓嘔嘕嘖嘗嘙嘚嘜嘝嘠嘡嘢嘥嘦嘨嘩嘪嘫嘮嘯嘰嘳嘵嘷嘸嘺嘼嘽嘾噀噁噂噃噄噅噆噇噈噉噊噋噏噐噑噒噓噕噖噚噛噝噞噟噠噡�噣噥噦噧噭噮噯噰噲噳噴噵噷噸噹噺噽噾噿嚀嚁嚂嚃嚄嚇嚈嚉嚊嚋嚌嚍嚐嚑嚒嚔嚕嚖嚗嚘嚙嚚嚛嚜嚝嚞嚟嚠嚡嚢嚤嚥嚦嚧嚨嚩嚪嚫嚬嚭嚮嚰嚱嚲嚳嚴嚵嚶嚸嚹嚺嚻嚽嚾嚿囀囁囂囃囄囅囆囇囈囉囋囌囍囎囏囐囑囒囓囕囖囘囙囜団囥囦囧囨囩囪囬囮囯囲図囶囷囸囻囼圀圁圂圅圇國圌圍圎圏圐圑�".split("");for(j=0;j!=D[135].length;++j)if(D[135][j].charCodeAt(0)!==65533){e[D[135][j]]=135*256+j;d[135*256+j]=D[135][j]}D[136]="����������������������������������������������������������������園圓圔圕圖圗團圙圚圛圝圞圠圡圢圤圥圦圧圫圱圲圴圵圶圷圸圼圽圿坁坃坄坅坆坈坉坋坒坓坔坕坖坘坙坢坣坥坧坬坮坰坱坲坴坵坸坹坺坽坾坿垀�垁垇垈垉垊垍垎垏垐垑垔垕垖垗垘垙垚垜垝垞垟垥垨垪垬垯垰垱垳垵垶垷垹垺垻垼垽垾垿埀埁埄埅埆埇埈埉埊埌埍埐埑埓埖埗埛埜埞埡埢埣埥埦埧埨埩埪埫埬埮埰埱埲埳埵埶執埻埼埾埿堁堃堄堅堈堉堊堌堎堏堐堒堓堔堖堗堘堚堛堜堝堟堢堣堥堦堧堨堩堫堬堭堮堯報堲堳場堶堷堸堹堺堻堼堽�".split("");for(j=0;j!=D[136].length;++j)if(D[136][j].charCodeAt(0)!==65533){e[D[136][j]]=136*256+j;d[136*256+j]=D[136][j]}D[137]="����������������������������������������������������������������堾堿塀塁塂塃塅塆塇塈塉塊塋塎塏塐塒塓塕塖塗塙塚塛塜塝塟塠塡塢塣塤塦塧塨塩塪塭塮塯塰塱塲塳塴塵塶塷塸塹塺塻塼塽塿墂墄墆墇墈墊墋墌�墍墎墏墐墑墔墕墖増墘墛墜墝墠墡墢墣墤墥墦墧墪墫墬墭墮墯墰墱墲墳墴墵墶墷墸墹墺墻墽墾墿壀壂壃壄壆壇壈壉壊壋壌壍壎壏壐壒壓壔壖壗壘壙壚壛壜壝壞壟壠壡壢壣壥壦壧壨壩壪壭壯壱売壴壵壷壸壺壻壼壽壾壿夀夁夃夅夆夈変夊夋夌夎夐夑夒夓夗夘夛夝夞夠夡夢夣夦夨夬夰夲夳夵夶夻�".split("");for(j=0;j!=D[137].length;++j)if(D[137][j].charCodeAt(0)!==65533){e[D[137][j]]=137*256+j;d[137*256+j]=D[137][j]}D[138]="����������������������������������������������������������������夽夾夿奀奃奅奆奊奌奍奐奒奓奙奛奜奝奞奟奡奣奤奦奧奨奩奪奫奬奭奮奯奰奱奲奵奷奺奻奼奾奿妀妅妉妋妌妎妏妐妑妔妕妘妚妛妜妝妟妠妡妢妦�妧妬妭妰妱妳妴妵妶妷妸妺妼妽妿姀姁姂姃姄姅姇姈姉姌姍姎姏姕姖姙姛姞姟姠姡姢姤姦姧姩姪姫姭姮姯姰姱姲姳姴姵姶姷姸姺姼姽姾娀娂娊娋娍娎娏娐娒娔娕娖娗娙娚娛娝娞娡娢娤娦娧娨娪娫娬娭娮娯娰娳娵娷娸娹娺娻娽娾娿婁婂婃婄婅婇婈婋婌婍婎婏婐婑婒婓婔婖婗婘婙婛婜婝婞婟婠�".split("");for(j=0;j!=D[138].length;++j)if(D[138][j].charCodeAt(0)!==65533){e[D[138][j]]=138*256+j;d[138*256+j]=D[138][j]}D[139]="����������������������������������������������������������������婡婣婤婥婦婨婩婫婬婭婮婯婰婱婲婳婸婹婻婼婽婾媀媁媂媃媄媅媆媇媈媉媊媋媌媍媎媏媐媑媓媔媕媖媗媘媙媜媝媞媟媠媡媢媣媤媥媦媧媨媩媫媬�媭媮媯媰媱媴媶媷媹媺媻媼媽媿嫀嫃嫄嫅嫆嫇嫈嫊嫋嫍嫎嫏嫐嫑嫓嫕嫗嫙嫚嫛嫝嫞嫟嫢嫤嫥嫧嫨嫪嫬嫭嫮嫯嫰嫲嫳嫴嫵嫶嫷嫸嫹嫺嫻嫼嫽嫾嫿嬀嬁嬂嬃嬄嬅嬆嬇嬈嬊嬋嬌嬍嬎嬏嬐嬑嬒嬓嬔嬕嬘嬙嬚嬛嬜嬝嬞嬟嬠嬡嬢嬣嬤嬥嬦嬧嬨嬩嬪嬫嬬嬭嬮嬯嬰嬱嬳嬵嬶嬸嬹嬺嬻嬼嬽嬾嬿孁孂孃孄孅孆孇�".split("");for(j=0;j!=D[139].length;++j)if(D[139][j].charCodeAt(0)!==65533){e[D[139][j]]=139*256+j;d[139*256+j]=D[139][j]}D[140]="����������������������������������������������������������������孈孉孊孋孌孍孎孏孒孖孞孠孡孧孨孫孭孮孯孲孴孶孷學孹孻孼孾孿宂宆宊宍宎宐宑宒宔宖実宧宨宩宬宭宮宯宱宲宷宺宻宼寀寁寃寈寉寊寋寍寎寏�寑寔寕寖寗寘寙寚寛寜寠寢寣實寧審寪寫寬寭寯寱寲寳寴寵寶寷寽対尀専尃尅將專尋尌對導尐尒尓尗尙尛尞尟尠尡尣尦尨尩尪尫尭尮尯尰尲尳尵尶尷屃屄屆屇屌屍屒屓屔屖屗屘屚屛屜屝屟屢層屧屨屩屪屫屬屭屰屲屳屴屵屶屷屸屻屼屽屾岀岃岄岅岆岇岉岊岋岎岏岒岓岕岝岞岟岠岡岤岥岦岧岨�".split("");for(j=0;j!=D[140].length;++j)if(D[140][j].charCodeAt(0)!==65533){e[D[140][j]]=140*256+j;d[140*256+j]=D[140][j]}D[141]="����������������������������������������������������������������岪岮岯岰岲岴岶岹岺岻岼岾峀峂峃峅峆峇峈峉峊峌峍峎峏峐峑峓峔峕峖峗峘峚峛峜峝峞峟峠峢峣峧峩峫峬峮峯峱峲峳峴峵島峷峸峹峺峼峽峾峿崀�崁崄崅崈崉崊崋崌崍崏崐崑崒崓崕崗崘崙崚崜崝崟崠崡崢崣崥崨崪崫崬崯崰崱崲崳崵崶崷崸崹崺崻崼崿嵀嵁嵂嵃嵄嵅嵆嵈嵉嵍嵎嵏嵐嵑嵒嵓嵔嵕嵖嵗嵙嵚嵜嵞嵟嵠嵡嵢嵣嵤嵥嵦嵧嵨嵪嵭嵮嵰嵱嵲嵳嵵嵶嵷嵸嵹嵺嵻嵼嵽嵾嵿嶀嶁嶃嶄嶅嶆嶇嶈嶉嶊嶋嶌嶍嶎嶏嶐嶑嶒嶓嶔嶕嶖嶗嶘嶚嶛嶜嶞嶟嶠�".split("");for(j=0;j!=D[141].length;++j)if(D[141][j].charCodeAt(0)!==65533){e[D[141][j]]=141*256+j;d[141*256+j]=D[141][j]}D[142]="����������������������������������������������������������������嶡嶢嶣嶤嶥嶦嶧嶨嶩嶪嶫嶬嶭嶮嶯嶰嶱嶲嶳嶴嶵嶶嶸嶹嶺嶻嶼嶽嶾嶿巀巁巂巃巄巆巇巈巉巊巋巌巎巏巐巑巒巓巔巕巖巗巘巙巚巜巟巠巣巤巪巬巭�巰巵巶巸巹巺巻巼巿帀帄帇帉帊帋帍帎帒帓帗帞帟帠帡帢帣帤帥帨帩帪師帬帯帰帲帳帴帵帶帹帺帾帿幀幁幃幆幇幈幉幊幋幍幎幏幐幑幒幓幖幗幘幙幚幜幝幟幠幣幤幥幦幧幨幩幪幫幬幭幮幯幰幱幵幷幹幾庁庂広庅庈庉庌庍庎庒庘庛庝庡庢庣庤庨庩庪庫庬庮庯庰庱庲庴庺庻庼庽庿廀廁廂廃廄廅�".split("");for(j=0;j!=D[142].length;++j)if(D[142][j].charCodeAt(0)!==65533){e[D[142][j]]=142*256+j;d[142*256+j]=D[142][j]}D[143]="����������������������������������������������������������������廆廇廈廋廌廍廎廏廐廔廕廗廘廙廚廜廝廞廟廠廡廢廣廤廥廦廧廩廫廬廭廮廯廰廱廲廳廵廸廹廻廼廽弅弆弇弉弌弍弎弐弒弔弖弙弚弜弝弞弡弢弣弤�弨弫弬弮弰弲弳弴張弶強弸弻弽弾弿彁彂彃彄彅彆彇彈彉彊彋彌彍彎彏彑彔彙彚彛彜彞彟彠彣彥彧彨彫彮彯彲彴彵彶彸彺彽彾彿徃徆徍徎徏徑従徔徖徚徛徝從徟徠徢徣徤徥徦徧復徫徬徯徰徱徲徳徴徶徸徹徺徻徾徿忀忁忂忇忈忊忋忎忓忔忕忚忛応忞忟忢忣忥忦忨忩忬忯忰忲忳忴忶忷忹忺忼怇�".split("");for(j=0;j!=D[143].length;++j)if(D[143][j].charCodeAt(0)!==65533){e[D[143][j]]=143*256+j;d[143*256+j]=D[143][j]}D[144]="����������������������������������������������������������������怈怉怋怌怐怑怓怗怘怚怞怟怢怣怤怬怭怮怰怱怲怳怴怶怷怸怹怺怽怾恀恄恅恆恇恈恉恊恌恎恏恑恓恔恖恗恘恛恜恞恟恠恡恥恦恮恱恲恴恵恷恾悀�悁悂悅悆悇悈悊悋悎悏悐悑悓悕悗悘悙悜悞悡悢悤悥悧悩悪悮悰悳悵悶悷悹悺悽悾悿惀惁惂惃惄惇惈惉惌惍惎惏惐惒惓惔惖惗惙惛惞惡惢惣惤惥惪惱惲惵惷惸惻惼惽惾惿愂愃愄愅愇愊愋愌愐愑愒愓愔愖愗愘愙愛愜愝愞愡愢愥愨愩愪愬愭愮愯愰愱愲愳愴愵愶愷愸愹愺愻愼愽愾慀慁慂慃慄慅慆�".split("");for(j=0;j!=D[144].length;++j)if(D[144][j].charCodeAt(0)!==65533){e[D[144][j]]=144*256+j;d[144*256+j]=D[144][j]}D[145]="����������������������������������������������������������������慇慉態慍慏慐慒慓慔慖慗慘慙慚慛慜慞慟慠慡慣慤慥慦慩慪慫慬慭慮慯慱慲慳慴慶慸慹慺慻慼慽慾慿憀憁憂憃憄憅憆憇憈憉憊憌憍憏憐憑憒憓憕�憖憗憘憙憚憛憜憞憟憠憡憢憣憤憥憦憪憫憭憮憯憰憱憲憳憴憵憶憸憹憺憻憼憽憿懀懁懃懄懅懆懇應懌懍懎懏懐懓懕懖懗懘懙懚懛懜懝懞懟懠懡懢懣懤懥懧懨懩懪懫懬懭懮懯懰懱懲懳懴懶懷懸懹懺懻懼懽懾戀戁戂戃戄戅戇戉戓戔戙戜戝戞戠戣戦戧戨戩戫戭戯戰戱戲戵戶戸戹戺戻戼扂扄扅扆扊�".split("");for(j=0;j!=D[145].length;++j)if(D[145][j].charCodeAt(0)!==65533){e[D[145][j]]=145*256+j;d[145*256+j]=D[145][j]}D[146]="����������������������������������������������������������������扏扐払扖扗扙扚扜扝扞扟扠扡扢扤扥扨扱扲扴扵扷扸扺扻扽抁抂抃抅抆抇抈抋抌抍抎抏抐抔抙抜抝択抣抦抧抩抪抭抮抯抰抲抳抴抶抷抸抺抾拀拁�拃拋拏拑拕拝拞拠拡拤拪拫拰拲拵拸拹拺拻挀挃挄挅挆挊挋挌挍挏挐挒挓挔挕挗挘挙挜挦挧挩挬挭挮挰挱挳挴挵挶挷挸挻挼挾挿捀捁捄捇捈捊捑捒捓捔捖捗捘捙捚捛捜捝捠捤捥捦捨捪捫捬捯捰捲捳捴捵捸捹捼捽捾捿掁掃掄掅掆掋掍掑掓掔掕掗掙掚掛掜掝掞掟採掤掦掫掯掱掲掵掶掹掻掽掿揀�".split("");for(j=0;j!=D[146].length;++j)if(D[146][j].charCodeAt(0)!==65533){e[D[146][j]]=146*256+j;d[146*256+j]=D[146][j]}D[147]="����������������������������������������������������������������揁揂揃揅揇揈揊揋揌揑揓揔揕揗揘揙揚換揜揝揟揢揤揥揦揧揨揫揬揮揯揰揱揳揵揷揹揺揻揼揾搃搄搆搇搈搉搊損搎搑搒搕搖搗搘搙搚搝搟搢搣搤�搥搧搨搩搫搮搯搰搱搲搳搵搶搷搸搹搻搼搾摀摂摃摉摋摌摍摎摏摐摑摓摕摖摗摙摚摛摜摝摟摠摡摢摣摤摥摦摨摪摫摬摮摯摰摱摲摳摴摵摶摷摻摼摽摾摿撀撁撃撆撈撉撊撋撌撍撎撏撐撓撔撗撘撚撛撜撝撟撠撡撢撣撥撦撧撨撪撫撯撱撲撳撴撶撹撻撽撾撿擁擃擄擆擇擈擉擊擋擌擏擑擓擔擕擖擙據�".split("");for(j=0;j!=D[147].length;++j)if(D[147][j].charCodeAt(0)!==65533){e[D[147][j]]=147*256+j;d[147*256+j]=D[147][j]}D[148]="����������������������������������������������������������������擛擜擝擟擠擡擣擥擧擨擩擪擫擬擭擮擯擰擱擲擳擴擵擶擷擸擹擺擻擼擽擾擿攁攂攃攄攅攆攇攈攊攋攌攍攎攏攐攑攓攔攕攖攗攙攚攛攜攝攞攟攠攡�攢攣攤攦攧攨攩攪攬攭攰攱攲攳攷攺攼攽敀敁敂敃敄敆敇敊敋敍敎敐敒敓敔敗敘敚敜敟敠敡敤敥敧敨敩敪敭敮敯敱敳敵敶數敹敺敻敼敽敾敿斀斁斂斃斄斅斆斈斉斊斍斎斏斒斔斕斖斘斚斝斞斠斢斣斦斨斪斬斮斱斲斳斴斵斶斷斸斺斻斾斿旀旂旇旈旉旊旍旐旑旓旔旕旘旙旚旛旜旝旞旟旡旣旤旪旫�".split("");for(j=0;j!=D[148].length;++j)if(D[148][j].charCodeAt(0)!==65533){e[D[148][j]]=148*256+j;d[148*256+j]=D[148][j]}D[149]="����������������������������������������������������������������旲旳旴旵旸旹旻旼旽旾旿昁昄昅昇昈昉昋昍昐昑昒昖昗昘昚昛昜昞昡昢昣昤昦昩昪昫昬昮昰昲昳昷昸昹昺昻昽昿晀時晄晅晆晇晈晉晊晍晎晐晑晘�晙晛晜晝晞晠晢晣晥晧晩晪晫晬晭晱晲晳晵晸晹晻晼晽晿暀暁暃暅暆暈暉暊暋暍暎暏暐暒暓暔暕暘暙暚暛暜暞暟暠暡暢暣暤暥暦暩暪暫暬暭暯暰暱暲暳暵暶暷暸暺暻暼暽暿曀曁曂曃曄曅曆曇曈曉曊曋曌曍曎曏曐曑曒曓曔曕曖曗曘曚曞曟曠曡曢曣曤曥曧曨曪曫曬曭曮曯曱曵曶書曺曻曽朁朂會�".split("");for(j=0;j!=D[149].length;++j)if(D[149][j].charCodeAt(0)!==65533){e[D[149][j]]=149*256+j;d[149*256+j]=D[149][j]}D[150]="����������������������������������������������������������������朄朅朆朇朌朎朏朑朒朓朖朘朙朚朜朞朠朡朢朣朤朥朧朩朮朰朲朳朶朷朸朹朻朼朾朿杁杄杅杇杊杋杍杒杔杕杗杘杙杚杛杝杢杣杤杦杧杫杬杮東杴杶�杸杹杺杻杽枀枂枃枅枆枈枊枌枍枎枏枑枒枓枔枖枙枛枟枠枡枤枦枩枬枮枱枲枴枹枺枻枼枽枾枿柀柂柅柆柇柈柉柊柋柌柍柎柕柖柗柛柟柡柣柤柦柧柨柪柫柭柮柲柵柶柷柸柹柺査柼柾栁栂栃栄栆栍栐栒栔栕栘栙栚栛栜栞栟栠栢栣栤栥栦栧栨栫栬栭栮栯栰栱栴栵栶栺栻栿桇桋桍桏桒桖桗桘桙桚桛�".split("");for(j=0;j!=D[150].length;++j)if(D[150][j].charCodeAt(0)!==65533){e[D[150][j]]=150*256+j;d[150*256+j]=D[150][j]}D[151]="����������������������������������������������������������������桜桝桞桟桪桬桭桮桯桰桱桲桳桵桸桹桺桻桼桽桾桿梀梂梄梇梈梉梊梋梌梍梎梐梑梒梔梕梖梘梙梚梛梜條梞梟梠梡梣梤梥梩梪梫梬梮梱梲梴梶梷梸�梹梺梻梼梽梾梿棁棃棄棅棆棇棈棊棌棎棏棐棑棓棔棖棗棙棛棜棝棞棟棡棢棤棥棦棧棨棩棪棫棬棭棯棲棳棴棶棷棸棻棽棾棿椀椂椃椄椆椇椈椉椊椌椏椑椓椔椕椖椗椘椙椚椛検椝椞椡椢椣椥椦椧椨椩椪椫椬椮椯椱椲椳椵椶椷椸椺椻椼椾楀楁楃楄楅楆楇楈楉楊楋楌楍楎楏楐楑楒楓楕楖楘楙楛楜楟�".split("");for(j=0;j!=D[151].length;++j)if(D[151][j].charCodeAt(0)!==65533){e[D[151][j]]=151*256+j;d[151*256+j]=D[151][j]}D[152]="����������������������������������������������������������������楡楢楤楥楧楨楩楪楬業楯楰楲楳楴極楶楺楻楽楾楿榁榃榅榊榋榌榎榏榐榑榒榓榖榗榙榚榝榞榟榠榡榢榣榤榥榦榩榪榬榮榯榰榲榳榵榶榸榹榺榼榽�榾榿槀槂槃槄槅槆槇槈槉構槍槏槑槒槓槕槖槗様槙槚槜槝槞槡槢槣槤槥槦槧槨槩槪槫槬槮槯槰槱槳槴槵槶槷槸槹槺槻槼槾樀樁樂樃樄樅樆樇樈樉樋樌樍樎樏樐樑樒樓樔樕樖標樚樛樜樝樞樠樢樣樤樥樦樧権樫樬樭樮樰樲樳樴樶樷樸樹樺樻樼樿橀橁橂橃橅橆橈橉橊橋橌橍橎橏橑橒橓橔橕橖橗橚�".split("");for(j=0;j!=D[152].length;++j)if(D[152][j].charCodeAt(0)!==65533){e[D[152][j]]=152*256+j;d[152*256+j]=D[152][j]}D[153]="����������������������������������������������������������������橜橝橞機橠橢橣橤橦橧橨橩橪橫橬橭橮橯橰橲橳橴橵橶橷橸橺橻橽橾橿檁檂檃檅檆檇檈檉檊檋檌檍檏檒檓檔檕檖檘檙檚檛檜檝檞檟檡檢檣檤檥檦�檧檨檪檭檮檯檰檱檲檳檴檵檶檷檸檹檺檻檼檽檾檿櫀櫁櫂櫃櫄櫅櫆櫇櫈櫉櫊櫋櫌櫍櫎櫏櫐櫑櫒櫓櫔櫕櫖櫗櫘櫙櫚櫛櫜櫝櫞櫟櫠櫡櫢櫣櫤櫥櫦櫧櫨櫩櫪櫫櫬櫭櫮櫯櫰櫱櫲櫳櫴櫵櫶櫷櫸櫹櫺櫻櫼櫽櫾櫿欀欁欂欃欄欅欆欇欈欉權欋欌欍欎欏欐欑欒欓欔欕欖欗欘欙欚欛欜欝欞欟欥欦欨欩欪欫欬欭欮�".split("");for(j=0;j!=D[153].length;++j)if(D[153][j].charCodeAt(0)!==65533){e[D[153][j]]=153*256+j;d[153*256+j]=D[153][j]}D[154]="����������������������������������������������������������������欯欰欱欳欴欵欶欸欻欼欽欿歀歁歂歄歅歈歊歋歍歎歏歐歑歒歓歔歕歖歗歘歚歛歜歝歞歟歠歡歨歩歫歬歭歮歯歰歱歲歳歴歵歶歷歸歺歽歾歿殀殅殈�殌殎殏殐殑殔殕殗殘殙殜殝殞殟殠殢殣殤殥殦殧殨殩殫殬殭殮殯殰殱殲殶殸殹殺殻殼殽殾毀毃毄毆毇毈毉毊毌毎毐毑毘毚毜毝毞毟毠毢毣毤毥毦毧毨毩毬毭毮毰毱毲毴毶毷毸毺毻毼毾毿氀氁氂氃氄氈氉氊氋氌氎氒気氜氝氞氠氣氥氫氬氭氱氳氶氷氹氺氻氼氾氿汃汄汅汈汋汌汍汎汏汑汒汓汖汘�".split("");for(j=0;j!=D[154].length;++j)if(D[154][j].charCodeAt(0)!==65533){e[D[154][j]]=154*256+j;d[154*256+j]=D[154][j]}D[155]="����������������������������������������������������������������汙汚汢汣汥汦汧汫汬汭汮汯汱汳汵汷汸決汻汼汿沀沄沇沊沋沍沎沑沒沕沖沗沘沚沜沝沞沠沢沨沬沯沰沴沵沶沷沺泀況泂泃泆泇泈泋泍泎泏泑泒泘�泙泚泜泝泟泤泦泧泩泬泭泲泴泹泿洀洂洃洅洆洈洉洊洍洏洐洑洓洔洕洖洘洜洝洟洠洡洢洣洤洦洨洩洬洭洯洰洴洶洷洸洺洿浀浂浄浉浌浐浕浖浗浘浛浝浟浡浢浤浥浧浨浫浬浭浰浱浲浳浵浶浹浺浻浽浾浿涀涁涃涄涆涇涊涋涍涏涐涒涖涗涘涙涚涜涢涥涬涭涰涱涳涴涶涷涹涺涻涼涽涾淁淂淃淈淉淊�".split("");for(j=0;j!=D[155].length;++j)if(D[155][j].charCodeAt(0)!==65533){e[D[155][j]]=155*256+j;d[155*256+j]=D[155][j]}D[156]="����������������������������������������������������������������淍淎淏淐淒淓淔淕淗淚淛淜淟淢淣淥淧淨淩淪淭淯淰淲淴淵淶淸淺淽淾淿渀渁渂渃渄渆渇済渉渋渏渒渓渕渘渙減渜渞渟渢渦渧渨渪測渮渰渱渳渵�渶渷渹渻渼渽渾渿湀湁湂湅湆湇湈湉湊湋湌湏湐湑湒湕湗湙湚湜湝湞湠湡湢湣湤湥湦湧湨湩湪湬湭湯湰湱湲湳湴湵湶湷湸湹湺湻湼湽満溁溂溄溇溈溊溋溌溍溎溑溒溓溔溕準溗溙溚溛溝溞溠溡溣溤溦溨溩溫溬溭溮溰溳溵溸溹溼溾溿滀滃滄滅滆滈滉滊滌滍滎滐滒滖滘滙滛滜滝滣滧滪滫滬滭滮滯�".split("");for(j=0;j!=D[156].length;++j)if(D[156][j].charCodeAt(0)!==65533){e[D[156][j]]=156*256+j;d[156*256+j]=D[156][j]}D[157]="����������������������������������������������������������������滰滱滲滳滵滶滷滸滺滻滼滽滾滿漀漁漃漄漅漇漈漊漋漌漍漎漐漑漒漖漗漘漙漚漛漜漝漞漟漡漢漣漥漦漧漨漬漮漰漲漴漵漷漸漹漺漻漼漽漿潀潁潂�潃潄潅潈潉潊潌潎潏潐潑潒潓潔潕潖潗潙潚潛潝潟潠潡潣潤潥潧潨潩潪潫潬潯潰潱潳潵潶潷潹潻潽潾潿澀澁澂澃澅澆澇澊澋澏澐澑澒澓澔澕澖澗澘澙澚澛澝澞澟澠澢澣澤澥澦澨澩澪澫澬澭澮澯澰澱澲澴澵澷澸澺澻澼澽澾澿濁濃濄濅濆濇濈濊濋濌濍濎濏濐濓濔濕濖濗濘濙濚濛濜濝濟濢濣濤濥�".split("");for(j=0;j!=D[157].length;++j)if(D[157][j].charCodeAt(0)!==65533){e[D[157][j]]=157*256+j;d[157*256+j]=D[157][j]}D[158]="����������������������������������������������������������������濦濧濨濩濪濫濬濭濰濱濲濳濴濵濶濷濸濹濺濻濼濽濾濿瀀瀁瀂瀃瀄瀅瀆瀇瀈瀉瀊瀋瀌瀍瀎瀏瀐瀒瀓瀔瀕瀖瀗瀘瀙瀜瀝瀞瀟瀠瀡瀢瀤瀥瀦瀧瀨瀩瀪�瀫瀬瀭瀮瀯瀰瀱瀲瀳瀴瀶瀷瀸瀺瀻瀼瀽瀾瀿灀灁灂灃灄灅灆灇灈灉灊灋灍灎灐灑灒灓灔灕灖灗灘灙灚灛灜灝灟灠灡灢灣灤灥灦灧灨灩灪灮灱灲灳灴灷灹灺灻災炁炂炃炄炆炇炈炋炌炍炏炐炑炓炗炘炚炛炞炟炠炡炢炣炤炥炦炧炨炩炪炰炲炴炵炶為炾炿烄烅烆烇烉烋烌烍烎烏烐烑烒烓烔烕烖烗烚�".split("");for(j=0;j!=D[158].length;++j)if(D[158][j].charCodeAt(0)!==65533){e[D[158][j]]=158*256+j;d[158*256+j]=D[158][j]}D[159]="����������������������������������������������������������������烜烝烞烠烡烢烣烥烪烮烰烱烲烳烴烵烶烸烺烻烼烾烿焀焁焂焃焄焅焆焇焈焋焌焍焎焏焑焒焔焗焛焜焝焞焟焠無焢焣焤焥焧焨焩焪焫焬焭焮焲焳焴�焵焷焸焹焺焻焼焽焾焿煀煁煂煃煄煆煇煈煉煋煍煏煐煑煒煓煔煕煖煗煘煙煚煛煝煟煠煡煢煣煥煩煪煫煬煭煯煰煱煴煵煶煷煹煻煼煾煿熀熁熂熃熅熆熇熈熉熋熌熍熎熐熑熒熓熕熖熗熚熛熜熝熞熡熢熣熤熥熦熧熩熪熫熭熮熯熰熱熲熴熶熷熸熺熻熼熽熾熿燀燁燂燄燅燆燇燈燉燊燋燌燍燏燐燑燒燓�".split("");for(j=0;j!=D[159].length;++j)if(D[159][j].charCodeAt(0)!==65533){e[D[159][j]]=159*256+j;d[159*256+j]=D[159][j]}D[160]="����������������������������������������������������������������燖燗燘燙燚燛燜燝燞營燡燢燣燤燦燨燩燪燫燬燭燯燰燱燲燳燴燵燶燷燸燺燻燼燽燾燿爀爁爂爃爄爅爇爈爉爊爋爌爍爎爏爐爑爒爓爔爕爖爗爘爙爚�爛爜爞爟爠爡爢爣爤爥爦爧爩爫爭爮爯爲爳爴爺爼爾牀牁牂牃牄牅牆牉牊牋牎牏牐牑牓牔牕牗牘牚牜牞牠牣牤牥牨牪牫牬牭牰牱牳牴牶牷牸牻牼牽犂犃犅犆犇犈犉犌犎犐犑犓犔犕犖犗犘犙犚犛犜犝犞犠犡犢犣犤犥犦犧犨犩犪犫犮犱犲犳犵犺犻犼犽犾犿狀狅狆狇狉狊狋狌狏狑狓狔狕狖狘狚狛�".split("");for(j=0;j!=D[160].length;++j)if(D[160][j].charCodeAt(0)!==65533){e[D[160][j]]=160*256+j;d[160*256+j]=D[160][j]}D[161]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������　、。·ˉˇ¨〃々—～‖…‘’“”〔〕〈〉《》「」『』〖〗【】±×÷∶∧∨∑∏∪∩∈∷√⊥∥∠⌒⊙∫∮≡≌≈∽∝≠≮≯≤≥∞∵∴♂♀°′″℃＄¤￠￡‰§№☆★○●◎◇◆□■△▲※→←↑↓〓�".split("");for(j=0;j!=D[161].length;++j)if(D[161][j].charCodeAt(0)!==65533){e[D[161][j]]=161*256+j;d[161*256+j]=D[161][j]}D[162]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������ⅰⅱⅲⅳⅴⅵⅶⅷⅸⅹ������⒈⒉⒊⒋⒌⒍⒎⒏⒐⒑⒒⒓⒔⒕⒖⒗⒘⒙⒚⒛⑴⑵⑶⑷⑸⑹⑺⑻⑼⑽⑾⑿⒀⒁⒂⒃⒄⒅⒆⒇①②③④⑤⑥⑦⑧⑨⑩��㈠㈡㈢㈣㈤㈥㈦㈧㈨㈩��ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩⅪⅫ���".split("");for(j=0;j!=D[162].length;++j)if(D[162][j].charCodeAt(0)!==65533){e[D[162][j]]=162*256+j;d[162*256+j]=D[162][j]}D[163]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������！＂＃￥％＆＇（）＊＋，－．／０１２３４５６７８９：；＜＝＞？＠ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ［＼］＾＿｀ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ｛｜｝￣�".split("");for(j=0;j!=D[163].length;++j)if(D[163][j].charCodeAt(0)!==65533){e[D[163][j]]=163*256+j;d[163*256+j]=D[163][j]}D[164]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������ぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞただちぢっつづてでとどなにぬねのはばぱひびぴふぶぷへべぺほぼぽまみむめもゃやゅゆょよらりるれろゎわゐゑをん������������".split("");for(j=0;j!=D[164].length;++j)if(D[164][j].charCodeAt(0)!==65533){e[D[164][j]]=164*256+j;d[164*256+j]=D[164][j]}D[165]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������ァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾタダチヂッツヅテデトドナニヌネノハバパヒビピフブプヘベペホボポマミムメモャヤュユョヨラリルレロヮワヰヱヲンヴヵヶ���������".split("");for(j=0;j!=D[165].length;++j)if(D[165][j].charCodeAt(0)!==65533){e[D[165][j]]=165*256+j;d[165*256+j]=D[165][j]}D[166]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩ��������αβγδεζηθικλμνξοπρστυφχψω�������︵︶︹︺︿﹀︽︾﹁﹂﹃﹄��︻︼︷︸︱�︳︴����������".split("");for(j=0;j!=D[166].length;++j)if(D[166][j].charCodeAt(0)!==65533){e[D[166][j]]=166*256+j;d[166*256+j]=D[166][j]}D[167]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ���������������абвгдеёжзийклмнопрстуфхцчшщъыьэюя��������������".split("");for(j=0;j!=D[167].length;++j)if(D[167][j].charCodeAt(0)!==65533){e[D[167][j]]=167*256+j;d[167*256+j]=D[167][j]}D[168]="����������������������������������������������������������������ˊˋ˙–―‥‵℅℉↖↗↘↙∕∟∣≒≦≧⊿═║╒╓╔╕╖╗╘╙╚╛╜╝╞╟╠╡╢╣╤╥╦╧╨╩╪╫╬╭╮╯╰╱╲╳▁▂▃▄▅▆▇�█▉▊▋▌▍▎▏▓▔▕▼▽◢◣◤◥☉⊕〒〝〞�����������āáǎàēéěèīíǐìōóǒòūúǔùǖǘǚǜüêɑ�ńň�ɡ����ㄅㄆㄇㄈㄉㄊㄋㄌㄍㄎㄏㄐㄑㄒㄓㄔㄕㄖㄗㄘㄙㄚㄛㄜㄝㄞㄟㄠㄡㄢㄣㄤㄥㄦㄧㄨㄩ����������������������".split("");for(j=0;j!=D[168].length;++j)if(D[168][j].charCodeAt(0)!==65533){e[D[168][j]]=168*256+j;d[168*256+j]=D[168][j]}D[169]="����������������������������������������������������������������〡〢〣〤〥〦〧〨〩㊣㎎㎏㎜㎝㎞㎡㏄㏎㏑㏒㏕︰￢￤�℡㈱�‐���ー゛゜ヽヾ〆ゝゞ﹉﹊﹋﹌﹍﹎﹏﹐﹑﹒﹔﹕﹖﹗﹙﹚﹛﹜﹝﹞﹟﹠﹡�﹢﹣﹤﹥﹦﹨﹩﹪﹫�������������〇�������������─━│┃┄┅┆┇┈┉┊┋┌┍┎┏┐┑┒┓└┕┖┗┘┙┚┛├┝┞┟┠┡┢┣┤┥┦┧┨┩┪┫┬┭┮┯┰┱┲┳┴┵┶┷┸┹┺┻┼┽┾┿╀╁╂╃╄╅╆╇╈╉╊╋����������������".split("");for(j=0;j!=D[169].length;++j)if(D[169][j].charCodeAt(0)!==65533){e[D[169][j]]=169*256+j;d[169*256+j]=D[169][j]}D[170]="����������������������������������������������������������������狜狝狟狢狣狤狥狦狧狪狫狵狶狹狽狾狿猀猂猄猅猆猇猈猉猋猌猍猏猐猑猒猔猘猙猚猟猠猣猤猦猧猨猭猯猰猲猳猵猶猺猻猼猽獀獁獂獃獄獅獆獇獈�獉獊獋獌獎獏獑獓獔獕獖獘獙獚獛獜獝獞獟獡獢獣獤獥獦獧獨獩獪獫獮獰獱�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[170].length;++j)if(D[170][j].charCodeAt(0)!==65533){e[D[170][j]]=170*256+j;d[170*256+j]=D[170][j]}D[171]="����������������������������������������������������������������獲獳獴獵獶獷獸獹獺獻獼獽獿玀玁玂玃玅玆玈玊玌玍玏玐玒玓玔玕玗玘玙玚玜玝玞玠玡玣玤玥玦玧玨玪玬玭玱玴玵玶玸玹玼玽玾玿珁珃珄珅珆珇�珋珌珎珒珓珔珕珖珗珘珚珛珜珝珟珡珢珣珤珦珨珪珫珬珮珯珰珱珳珴珵珶珷�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[171].length;++j)if(D[171][j].charCodeAt(0)!==65533){e[D[171][j]]=171*256+j;d[171*256+j]=D[171][j]}D[172]="����������������������������������������������������������������珸珹珺珻珼珽現珿琀琁琂琄琇琈琋琌琍琎琑琒琓琔琕琖琗琘琙琜琝琞琟琠琡琣琤琧琩琫琭琯琱琲琷琸琹琺琻琽琾琿瑀瑂瑃瑄瑅瑆瑇瑈瑉瑊瑋瑌瑍�瑎瑏瑐瑑瑒瑓瑔瑖瑘瑝瑠瑡瑢瑣瑤瑥瑦瑧瑨瑩瑪瑫瑬瑮瑯瑱瑲瑳瑴瑵瑸瑹瑺�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[172].length;++j)if(D[172][j].charCodeAt(0)!==65533){e[D[172][j]]=172*256+j;d[172*256+j]=D[172][j]}D[173]="����������������������������������������������������������������瑻瑼瑽瑿璂璄璅璆璈璉璊璌璍璏璑璒璓璔璕璖璗璘璙璚璛璝璟璠璡璢璣璤璥璦璪璫璬璭璮璯環璱璲璳璴璵璶璷璸璹璻璼璽璾璿瓀瓁瓂瓃瓄瓅瓆瓇�瓈瓉瓊瓋瓌瓍瓎瓏瓐瓑瓓瓔瓕瓖瓗瓘瓙瓚瓛瓝瓟瓡瓥瓧瓨瓩瓪瓫瓬瓭瓰瓱瓲�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[173].length;++j)if(D[173][j].charCodeAt(0)!==65533){e[D[173][j]]=173*256+j;d[173*256+j]=D[173][j]}D[174]="����������������������������������������������������������������瓳瓵瓸瓹瓺瓻瓼瓽瓾甀甁甂甃甅甆甇甈甉甊甋甌甎甐甒甔甕甖甗甛甝甞甠甡產産甤甦甧甪甮甴甶甹甼甽甿畁畂畃畄畆畇畉畊畍畐畑畒畓畕畖畗畘�畝畞畟畠畡畢畣畤畧畨畩畫畬畭畮畯異畱畳畵當畷畺畻畼畽畾疀疁疂疄疅疇�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[174].length;++j)if(D[174][j].charCodeAt(0)!==65533){e[D[174][j]]=174*256+j;d[174*256+j]=D[174][j]}D[175]="����������������������������������������������������������������疈疉疊疌疍疎疐疓疕疘疛疜疞疢疦疧疨疩疪疭疶疷疺疻疿痀痁痆痋痌痎痏痐痑痓痗痙痚痜痝痟痠痡痥痩痬痭痮痯痲痳痵痶痷痸痺痻痽痾瘂瘄瘆瘇�瘈瘉瘋瘍瘎瘏瘑瘒瘓瘔瘖瘚瘜瘝瘞瘡瘣瘧瘨瘬瘮瘯瘱瘲瘶瘷瘹瘺瘻瘽癁療癄�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[175].length;++j)if(D[175][j].charCodeAt(0)!==65533){e[D[175][j]]=175*256+j;d[175*256+j]=D[175][j]}D[176]="����������������������������������������������������������������癅癆癇癈癉癊癋癎癏癐癑癒癓癕癗癘癙癚癛癝癟癠癡癢癤癥癦癧癨癩癪癬癭癮癰癱癲癳癴癵癶癷癹発發癿皀皁皃皅皉皊皌皍皏皐皒皔皕皗皘皚皛�皜皝皞皟皠皡皢皣皥皦皧皨皩皪皫皬皭皯皰皳皵皶皷皸皹皺皻皼皽皾盀盁盃啊阿埃挨哎唉哀皑癌蔼矮艾碍爱隘鞍氨安俺按暗岸胺案肮昂盎凹敖熬翱袄傲奥懊澳芭捌扒叭吧笆八疤巴拔跋靶把耙坝霸罢爸白柏百摆佰败拜稗斑班搬扳般颁板版扮拌伴瓣半办绊邦帮梆榜膀绑棒磅蚌镑傍谤苞胞包褒剥�".split("");for(j=0;j!=D[176].length;++j)if(D[176][j].charCodeAt(0)!==65533){e[D[176][j]]=176*256+j;d[176*256+j]=D[176][j]}D[177]="����������������������������������������������������������������盄盇盉盋盌盓盕盙盚盜盝盞盠盡盢監盤盦盧盨盩盪盫盬盭盰盳盵盶盷盺盻盽盿眀眂眃眅眆眊県眎眏眐眑眒眓眔眕眖眗眘眛眜眝眞眡眣眤眥眧眪眫�眬眮眰眱眲眳眴眹眻眽眾眿睂睄睅睆睈睉睊睋睌睍睎睏睒睓睔睕睖睗睘睙睜薄雹保堡饱宝抱报暴豹鲍爆杯碑悲卑北辈背贝钡倍狈备惫焙被奔苯本笨崩绷甭泵蹦迸逼鼻比鄙笔彼碧蓖蔽毕毙毖币庇痹闭敝弊必辟壁臂避陛鞭边编贬扁便变卞辨辩辫遍标彪膘表鳖憋别瘪彬斌濒滨宾摈兵冰柄丙秉饼炳�".split("");for(j=0;j!=D[177].length;++j)if(D[177][j].charCodeAt(0)!==65533){e[D[177][j]]=177*256+j;d[177*256+j]=D[177][j]}D[178]="����������������������������������������������������������������睝睞睟睠睤睧睩睪睭睮睯睰睱睲睳睴睵睶睷睸睺睻睼瞁瞂瞃瞆瞇瞈瞉瞊瞋瞏瞐瞓瞔瞕瞖瞗瞘瞙瞚瞛瞜瞝瞞瞡瞣瞤瞦瞨瞫瞭瞮瞯瞱瞲瞴瞶瞷瞸瞹瞺�瞼瞾矀矁矂矃矄矅矆矇矈矉矊矋矌矎矏矐矑矒矓矔矕矖矘矙矚矝矞矟矠矡矤病并玻菠播拨钵波博勃搏铂箔伯帛舶脖膊渤泊驳捕卜哺补埠不布步簿部怖擦猜裁材才财睬踩采彩菜蔡餐参蚕残惭惨灿苍舱仓沧藏操糙槽曹草厕策侧册测层蹭插叉茬茶查碴搽察岔差诧拆柴豺搀掺蝉馋谗缠铲产阐颤昌猖�".split("");for(j=0;j!=D[178].length;++j)if(D[178][j].charCodeAt(0)!==65533){e[D[178][j]]=178*256+j;d[178*256+j]=D[178][j]}D[179]="����������������������������������������������������������������矦矨矪矯矰矱矲矴矵矷矹矺矻矼砃砄砅砆砇砈砊砋砎砏砐砓砕砙砛砞砠砡砢砤砨砪砫砮砯砱砲砳砵砶砽砿硁硂硃硄硆硈硉硊硋硍硏硑硓硔硘硙硚�硛硜硞硟硠硡硢硣硤硥硦硧硨硩硯硰硱硲硳硴硵硶硸硹硺硻硽硾硿碀碁碂碃场尝常长偿肠厂敞畅唱倡超抄钞朝嘲潮巢吵炒车扯撤掣彻澈郴臣辰尘晨忱沉陈趁衬撑称城橙成呈乘程惩澄诚承逞骋秤吃痴持匙池迟弛驰耻齿侈尺赤翅斥炽充冲虫崇宠抽酬畴踌稠愁筹仇绸瞅丑臭初出橱厨躇锄雏滁除楚�".split("");for(j=0;j!=D[179].length;++j)if(D[179][j].charCodeAt(0)!==65533){e[D[179][j]]=179*256+j;d[179*256+j]=D[179][j]}D[180]="����������������������������������������������������������������碄碅碆碈碊碋碏碐碒碔碕碖碙碝碞碠碢碤碦碨碩碪碫碬碭碮碯碵碶碷碸確碻碼碽碿磀磂磃磄磆磇磈磌磍磎磏磑磒磓磖磗磘磚磛磜磝磞磟磠磡磢磣�磤磥磦磧磩磪磫磭磮磯磰磱磳磵磶磸磹磻磼磽磾磿礀礂礃礄礆礇礈礉礊礋礌础储矗搐触处揣川穿椽传船喘串疮窗幢床闯创吹炊捶锤垂春椿醇唇淳纯蠢戳绰疵茨磁雌辞慈瓷词此刺赐次聪葱囱匆从丛凑粗醋簇促蹿篡窜摧崔催脆瘁粹淬翠村存寸磋撮搓措挫错搭达答瘩打大呆歹傣戴带殆代贷袋待逮�".split("");for(j=0;j!=D[180].length;++j)if(D[180][j].charCodeAt(0)!==65533){e[D[180][j]]=180*256+j;d[180*256+j]=D[180][j]}D[181]="����������������������������������������������������������������礍礎礏礐礑礒礔礕礖礗礘礙礚礛礜礝礟礠礡礢礣礥礦礧礨礩礪礫礬礭礮礯礰礱礲礳礵礶礷礸礹礽礿祂祃祄祅祇祊祋祌祍祎祏祐祑祒祔祕祘祙祡祣�祤祦祩祪祫祬祮祰祱祲祳祴祵祶祹祻祼祽祾祿禂禃禆禇禈禉禋禌禍禎禐禑禒怠耽担丹单郸掸胆旦氮但惮淡诞弹蛋当挡党荡档刀捣蹈倒岛祷导到稻悼道盗德得的蹬灯登等瞪凳邓堤低滴迪敌笛狄涤翟嫡抵底地蒂第帝弟递缔颠掂滇碘点典靛垫电佃甸店惦奠淀殿碉叼雕凋刁掉吊钓调跌爹碟蝶迭谍叠�".split("");for(j=0;j!=D[181].length;++j)if(D[181][j].charCodeAt(0)!==65533){e[D[181][j]]=181*256+j;d[181*256+j]=D[181][j]}D[182]="����������������������������������������������������������������禓禔禕禖禗禘禙禛禜禝禞禟禠禡禢禣禤禥禦禨禩禪禫禬禭禮禯禰禱禲禴禵禶禷禸禼禿秂秄秅秇秈秊秌秎秏秐秓秔秖秗秙秚秛秜秝秞秠秡秢秥秨秪�秬秮秱秲秳秴秵秶秷秹秺秼秾秿稁稄稅稇稈稉稊稌稏稐稑稒稓稕稖稘稙稛稜丁盯叮钉顶鼎锭定订丢东冬董懂动栋侗恫冻洞兜抖斗陡豆逗痘都督毒犊独读堵睹赌杜镀肚度渡妒端短锻段断缎堆兑队对墩吨蹲敦顿囤钝盾遁掇哆多夺垛躲朵跺舵剁惰堕蛾峨鹅俄额讹娥恶厄扼遏鄂饿恩而儿耳尔饵洱二�".split("");for(j=0;j!=D[182].length;++j)if(D[182][j].charCodeAt(0)!==65533){e[D[182][j]]=182*256+j;d[182*256+j]=D[182][j]}D[183]="����������������������������������������������������������������稝稟稡稢稤稥稦稧稨稩稪稫稬稭種稯稰稱稲稴稵稶稸稺稾穀穁穂穃穄穅穇穈穉穊穋穌積穎穏穐穒穓穔穕穖穘穙穚穛穜穝穞穟穠穡穢穣穤穥穦穧穨�穩穪穫穬穭穮穯穱穲穳穵穻穼穽穾窂窅窇窉窊窋窌窎窏窐窓窔窙窚窛窞窡窢贰发罚筏伐乏阀法珐藩帆番翻樊矾钒繁凡烦反返范贩犯饭泛坊芳方肪房防妨仿访纺放菲非啡飞肥匪诽吠肺废沸费芬酚吩氛分纷坟焚汾粉奋份忿愤粪丰封枫蜂峰锋风疯烽逢冯缝讽奉凤佛否夫敷肤孵扶拂辐幅氟符伏俘服�".split("");for(j=0;j!=D[183].length;++j)if(D[183][j].charCodeAt(0)!==65533){e[D[183][j]]=183*256+j;d[183*256+j]=D[183][j]}D[184]="����������������������������������������������������������������窣窤窧窩窪窫窮窯窰窱窲窴窵窶窷窸窹窺窻窼窽窾竀竁竂竃竄竅竆竇竈竉竊竌竍竎竏竐竑竒竓竔竕竗竘竚竛竜竝竡竢竤竧竨竩竪竫竬竮竰竱竲竳�竴竵競竷竸竻竼竾笀笁笂笅笇笉笌笍笎笐笒笓笖笗笘笚笜笝笟笡笢笣笧笩笭浮涪福袱弗甫抚辅俯釜斧脯腑府腐赴副覆赋复傅付阜父腹负富讣附妇缚咐噶嘎该改概钙盖溉干甘杆柑竿肝赶感秆敢赣冈刚钢缸肛纲岗港杠篙皋高膏羔糕搞镐稿告哥歌搁戈鸽胳疙割革葛格蛤阁隔铬个各给根跟耕更庚羹�".split("");for(j=0;j!=D[184].length;++j)if(D[184][j].charCodeAt(0)!==65533){e[D[184][j]]=184*256+j;d[184*256+j]=D[184][j]}D[185]="����������������������������������������������������������������笯笰笲笴笵笶笷笹笻笽笿筀筁筂筃筄筆筈筊筍筎筓筕筗筙筜筞筟筡筣筤筥筦筧筨筩筪筫筬筭筯筰筳筴筶筸筺筼筽筿箁箂箃箄箆箇箈箉箊箋箌箎箏�箑箒箓箖箘箙箚箛箞箟箠箣箤箥箮箯箰箲箳箵箶箷箹箺箻箼箽箾箿節篂篃範埂耿梗工攻功恭龚供躬公宫弓巩汞拱贡共钩勾沟苟狗垢构购够辜菇咕箍估沽孤姑鼓古蛊骨谷股故顾固雇刮瓜剐寡挂褂乖拐怪棺关官冠观管馆罐惯灌贯光广逛瑰规圭硅归龟闺轨鬼诡癸桂柜跪贵刽辊滚棍锅郭国果裹过哈�".split("");for(j=0;j!=D[185].length;++j)if(D[185][j].charCodeAt(0)!==65533){e[D[185][j]]=185*256+j;d[185*256+j]=D[185][j]}D[186]="����������������������������������������������������������������篅篈築篊篋篍篎篏篐篒篔篕篖篗篘篛篜篞篟篠篢篣篤篧篨篩篫篬篭篯篰篲篳篴篵篶篸篹篺篻篽篿簀簁簂簃簄簅簆簈簉簊簍簎簐簑簒簓簔簕簗簘簙�簚簛簜簝簞簠簡簢簣簤簥簨簩簫簬簭簮簯簰簱簲簳簴簵簶簷簹簺簻簼簽簾籂骸孩海氦亥害骇酣憨邯韩含涵寒函喊罕翰撼捍旱憾悍焊汗汉夯杭航壕嚎豪毫郝好耗号浩呵喝荷菏核禾和何合盒貉阂河涸赫褐鹤贺嘿黑痕很狠恨哼亨横衡恒轰哄烘虹鸿洪宏弘红喉侯猴吼厚候后呼乎忽瑚壶葫胡蝴狐糊湖�".split("");for(j=0;j!=D[186].length;++j)if(D[186][j].charCodeAt(0)!==65533){e[D[186][j]]=186*256+j;d[186*256+j]=D[186][j]}D[187]="����������������������������������������������������������������籃籄籅籆籇籈籉籊籋籌籎籏籐籑籒籓籔籕籖籗籘籙籚籛籜籝籞籟籠籡籢籣籤籥籦籧籨籩籪籫籬籭籮籯籰籱籲籵籶籷籸籹籺籾籿粀粁粂粃粄粅粆粇�粈粊粋粌粍粎粏粐粓粔粖粙粚粛粠粡粣粦粧粨粩粫粬粭粯粰粴粵粶粷粸粺粻弧虎唬护互沪户花哗华猾滑画划化话槐徊怀淮坏欢环桓还缓换患唤痪豢焕涣宦幻荒慌黄磺蝗簧皇凰惶煌晃幌恍谎灰挥辉徽恢蛔回毁悔慧卉惠晦贿秽会烩汇讳诲绘荤昏婚魂浑混豁活伙火获或惑霍货祸击圾基机畸稽积箕�".split("");for(j=0;j!=D[187].length;++j)if(D[187][j].charCodeAt(0)!==65533){e[D[187][j]]=187*256+j;d[187*256+j]=D[187][j]}D[188]="����������������������������������������������������������������粿糀糂糃糄糆糉糋糎糏糐糑糒糓糔糘糚糛糝糞糡糢糣糤糥糦糧糩糪糫糬糭糮糰糱糲糳糴糵糶糷糹糺糼糽糾糿紀紁紂紃約紅紆紇紈紉紋紌納紎紏紐�紑紒紓純紕紖紗紘紙級紛紜紝紞紟紡紣紤紥紦紨紩紪紬紭紮細紱紲紳紴紵紶肌饥迹激讥鸡姬绩缉吉极棘辑籍集及急疾汲即嫉级挤几脊己蓟技冀季伎祭剂悸济寄寂计记既忌际妓继纪嘉枷夹佳家加荚颊贾甲钾假稼价架驾嫁歼监坚尖笺间煎兼肩艰奸缄茧检柬碱硷拣捡简俭剪减荐槛鉴践贱见键箭件�".split("");for(j=0;j!=D[188].length;++j)if(D[188][j].charCodeAt(0)!==65533){e[D[188][j]]=188*256+j;d[188*256+j]=D[188][j]}D[189]="����������������������������������������������������������������紷紸紹紺紻紼紽紾紿絀絁終絃組絅絆絇絈絉絊絋経絍絎絏結絑絒絓絔絕絖絗絘絙絚絛絜絝絞絟絠絡絢絣絤絥給絧絨絩絪絫絬絭絯絰統絲絳絴絵絶�絸絹絺絻絼絽絾絿綀綁綂綃綄綅綆綇綈綉綊綋綌綍綎綏綐綑綒經綔綕綖綗綘健舰剑饯渐溅涧建僵姜将浆江疆蒋桨奖讲匠酱降蕉椒礁焦胶交郊浇骄娇嚼搅铰矫侥脚狡角饺缴绞剿教酵轿较叫窖揭接皆秸街阶截劫节桔杰捷睫竭洁结解姐戒藉芥界借介疥诫届巾筋斤金今津襟紧锦仅谨进靳晋禁近烬浸�".split("");for(j=0;j!=D[189].length;++j)if(D[189][j].charCodeAt(0)!==65533){e[D[189][j]]=189*256+j;d[189*256+j]=D[189][j]}D[190]="����������������������������������������������������������������継続綛綜綝綞綟綠綡綢綣綤綥綧綨綩綪綫綬維綯綰綱網綳綴綵綶綷綸綹綺綻綼綽綾綿緀緁緂緃緄緅緆緇緈緉緊緋緌緍緎総緐緑緒緓緔緕緖緗緘緙�線緛緜緝緞緟締緡緢緣緤緥緦緧編緩緪緫緬緭緮緯緰緱緲緳練緵緶緷緸緹緺尽劲荆兢茎睛晶鲸京惊精粳经井警景颈静境敬镜径痉靖竟竞净炯窘揪究纠玖韭久灸九酒厩救旧臼舅咎就疚鞠拘狙疽居驹菊局咀矩举沮聚拒据巨具距踞锯俱句惧炬剧捐鹃娟倦眷卷绢撅攫抉掘倔爵觉决诀绝均菌钧军君峻�".split("");for(j=0;j!=D[190].length;++j)if(D[190][j].charCodeAt(0)!==65533){e[D[190][j]]=190*256+j;d[190*256+j]=D[190][j]}D[191]="����������������������������������������������������������������緻緼緽緾緿縀縁縂縃縄縅縆縇縈縉縊縋縌縍縎縏縐縑縒縓縔縕縖縗縘縙縚縛縜縝縞縟縠縡縢縣縤縥縦縧縨縩縪縫縬縭縮縯縰縱縲縳縴縵縶縷縸縹�縺縼總績縿繀繂繃繄繅繆繈繉繊繋繌繍繎繏繐繑繒繓織繕繖繗繘繙繚繛繜繝俊竣浚郡骏喀咖卡咯开揩楷凯慨刊堪勘坎砍看康慷糠扛抗亢炕考拷烤靠坷苛柯棵磕颗科壳咳可渴克刻客课肯啃垦恳坑吭空恐孔控抠口扣寇枯哭窟苦酷库裤夸垮挎跨胯块筷侩快宽款匡筐狂框矿眶旷况亏盔岿窥葵奎魁傀�".split("");for(j=0;j!=D[191].length;++j)if(D[191][j].charCodeAt(0)!==65533){e[D[191][j]]=191*256+j;d[191*256+j]=D[191][j]}D[192]="����������������������������������������������������������������繞繟繠繡繢繣繤繥繦繧繨繩繪繫繬繭繮繯繰繱繲繳繴繵繶繷繸繹繺繻繼繽繾繿纀纁纃纄纅纆纇纈纉纊纋續纍纎纏纐纑纒纓纔纕纖纗纘纙纚纜纝纞�纮纴纻纼绖绤绬绹缊缐缞缷缹缻缼缽缾缿罀罁罃罆罇罈罉罊罋罌罍罎罏罒罓馈愧溃坤昆捆困括扩廓阔垃拉喇蜡腊辣啦莱来赖蓝婪栏拦篮阑兰澜谰揽览懒缆烂滥琅榔狼廊郎朗浪捞劳牢老佬姥酪烙涝勒乐雷镭蕾磊累儡垒擂肋类泪棱楞冷厘梨犁黎篱狸离漓理李里鲤礼莉荔吏栗丽厉励砾历利傈例俐�".split("");for(j=0;j!=D[192].length;++j)if(D[192][j].charCodeAt(0)!==65533){e[D[192][j]]=192*256+j;d[192*256+j]=D[192][j]}D[193]="����������������������������������������������������������������罖罙罛罜罝罞罠罣罤罥罦罧罫罬罭罯罰罳罵罶罷罸罺罻罼罽罿羀羂羃羄羅羆羇羈羉羋羍羏羐羑羒羓羕羖羗羘羙羛羜羠羢羣羥羦羨義羪羫羬羭羮羱�羳羴羵羶羷羺羻羾翀翂翃翄翆翇翈翉翋翍翏翐翑習翓翖翗翙翚翛翜翝翞翢翣痢立粒沥隶力璃哩俩联莲连镰廉怜涟帘敛脸链恋炼练粮凉梁粱良两辆量晾亮谅撩聊僚疗燎寥辽潦了撂镣廖料列裂烈劣猎琳林磷霖临邻鳞淋凛赁吝拎玲菱零龄铃伶羚凌灵陵岭领另令溜琉榴硫馏留刘瘤流柳六龙聋咙笼窿�".split("");for(j=0;j!=D[193].length;++j)if(D[193][j].charCodeAt(0)!==65533){e[D[193][j]]=193*256+j;d[193*256+j]=D[193][j]}D[194]="����������������������������������������������������������������翤翧翨翪翫翬翭翯翲翴翵翶翷翸翹翺翽翾翿耂耇耈耉耊耎耏耑耓耚耛耝耞耟耡耣耤耫耬耭耮耯耰耲耴耹耺耼耾聀聁聄聅聇聈聉聎聏聐聑聓聕聖聗�聙聛聜聝聞聟聠聡聢聣聤聥聦聧聨聫聬聭聮聯聰聲聳聴聵聶職聸聹聺聻聼聽隆垄拢陇楼娄搂篓漏陋芦卢颅庐炉掳卤虏鲁麓碌露路赂鹿潞禄录陆戮驴吕铝侣旅履屡缕虑氯律率滤绿峦挛孪滦卵乱掠略抡轮伦仑沦纶论萝螺罗逻锣箩骡裸落洛骆络妈麻玛码蚂马骂嘛吗埋买麦卖迈脉瞒馒蛮满蔓曼慢漫�".split("");for(j=0;j!=D[194].length;++j)if(D[194][j].charCodeAt(0)!==65533){e[D[194][j]]=194*256+j;d[194*256+j]=D[194][j]}D[195]="����������������������������������������������������������������聾肁肂肅肈肊肍肎肏肐肑肒肔肕肗肙肞肣肦肧肨肬肰肳肵肶肸肹肻胅胇胈胉胊胋胏胐胑胒胓胔胕胘胟胠胢胣胦胮胵胷胹胻胾胿脀脁脃脄脅脇脈脋�脌脕脗脙脛脜脝脟脠脡脢脣脤脥脦脧脨脩脪脫脭脮脰脳脴脵脷脹脺脻脼脽脿谩芒茫盲氓忙莽猫茅锚毛矛铆卯茂冒帽貌贸么玫枚梅酶霉煤没眉媒镁每美昧寐妹媚门闷们萌蒙檬盟锰猛梦孟眯醚靡糜迷谜弥米秘觅泌蜜密幂棉眠绵冕免勉娩缅面苗描瞄藐秒渺庙妙蔑灭民抿皿敏悯闽明螟鸣铭名命谬摸�".split("");for(j=0;j!=D[195].length;++j)if(D[195][j].charCodeAt(0)!==65533){e[D[195][j]]=195*256+j;d[195*256+j]=D[195][j]}D[196]="����������������������������������������������������������������腀腁腂腃腄腅腇腉腍腎腏腒腖腗腘腛腜腝腞腟腡腢腣腤腦腨腪腫腬腯腲腳腵腶腷腸膁膃膄膅膆膇膉膋膌膍膎膐膒膓膔膕膖膗膙膚膞膟膠膡膢膤膥�膧膩膫膬膭膮膯膰膱膲膴膵膶膷膸膹膼膽膾膿臄臅臇臈臉臋臍臎臏臐臑臒臓摹蘑模膜磨摩魔抹末莫墨默沫漠寞陌谋牟某拇牡亩姆母墓暮幕募慕木目睦牧穆拿哪呐钠那娜纳氖乃奶耐奈南男难囊挠脑恼闹淖呢馁内嫩能妮霓倪泥尼拟你匿腻逆溺蔫拈年碾撵捻念娘酿鸟尿捏聂孽啮镊镍涅您柠狞凝宁�".split("");for(j=0;j!=D[196].length;++j)if(D[196][j].charCodeAt(0)!==65533){e[D[196][j]]=196*256+j;d[196*256+j]=D[196][j]}D[197]="����������������������������������������������������������������臔臕臖臗臘臙臚臛臜臝臞臟臠臡臢臤臥臦臨臩臫臮臯臰臱臲臵臶臷臸臹臺臽臿舃與興舉舊舋舎舏舑舓舕舖舗舘舙舚舝舠舤舥舦舧舩舮舲舺舼舽舿�艀艁艂艃艅艆艈艊艌艍艎艐艑艒艓艔艕艖艗艙艛艜艝艞艠艡艢艣艤艥艦艧艩拧泞牛扭钮纽脓浓农弄奴努怒女暖虐疟挪懦糯诺哦欧鸥殴藕呕偶沤啪趴爬帕怕琶拍排牌徘湃派攀潘盘磐盼畔判叛乓庞旁耪胖抛咆刨炮袍跑泡呸胚培裴赔陪配佩沛喷盆砰抨烹澎彭蓬棚硼篷膨朋鹏捧碰坯砒霹批披劈琵毗�".split("");for(j=0;j!=D[197].length;++j)if(D[197][j].charCodeAt(0)!==65533){e[D[197][j]]=197*256+j;d[197*256+j]=D[197][j]}D[198]="����������������������������������������������������������������艪艫艬艭艱艵艶艷艸艻艼芀芁芃芅芆芇芉芌芐芓芔芕芖芚芛芞芠芢芣芧芲芵芶芺芻芼芿苀苂苃苅苆苉苐苖苙苚苝苢苧苨苩苪苬苭苮苰苲苳苵苶苸�苺苼苽苾苿茀茊茋茍茐茒茓茖茘茙茝茞茟茠茡茢茣茤茥茦茩茪茮茰茲茷茻茽啤脾疲皮匹痞僻屁譬篇偏片骗飘漂瓢票撇瞥拼频贫品聘乒坪苹萍平凭瓶评屏坡泼颇婆破魄迫粕剖扑铺仆莆葡菩蒲埔朴圃普浦谱曝瀑期欺栖戚妻七凄漆柒沏其棋奇歧畦崎脐齐旗祈祁骑起岂乞企启契砌器气迄弃汽泣讫掐�".split("");for(j=0;j!=D[198].length;++j)if(D[198][j].charCodeAt(0)!==65533){e[D[198][j]]=198*256+j;d[198*256+j]=D[198][j]}D[199]="����������������������������������������������������������������茾茿荁荂荄荅荈荊荋荌荍荎荓荕荖荗荘荙荝荢荰荱荲荳荴荵荶荹荺荾荿莀莁莂莃莄莇莈莊莋莌莍莏莐莑莔莕莖莗莙莚莝莟莡莢莣莤莥莦莧莬莭莮�莯莵莻莾莿菂菃菄菆菈菉菋菍菎菐菑菒菓菕菗菙菚菛菞菢菣菤菦菧菨菫菬菭恰洽牵扦钎铅千迁签仟谦乾黔钱钳前潜遣浅谴堑嵌欠歉枪呛腔羌墙蔷强抢橇锹敲悄桥瞧乔侨巧鞘撬翘峭俏窍切茄且怯窃钦侵亲秦琴勤芹擒禽寝沁青轻氢倾卿清擎晴氰情顷请庆琼穷秋丘邱球求囚酋泅趋区蛆曲躯屈驱渠�".split("");
for(j=0;j!=D[199].length;++j)if(D[199][j].charCodeAt(0)!==65533){e[D[199][j]]=199*256+j;d[199*256+j]=D[199][j]}D[200]="����������������������������������������������������������������菮華菳菴菵菶菷菺菻菼菾菿萀萂萅萇萈萉萊萐萒萓萔萕萖萗萙萚萛萞萟萠萡萢萣萩萪萫萬萭萮萯萰萲萳萴萵萶萷萹萺萻萾萿葀葁葂葃葄葅葇葈葉�葊葋葌葍葎葏葐葒葓葔葕葖葘葝葞葟葠葢葤葥葦葧葨葪葮葯葰葲葴葷葹葻葼取娶龋趣去圈颧权醛泉全痊拳犬券劝缺炔瘸却鹊榷确雀裙群然燃冉染瓤壤攘嚷让饶扰绕惹热壬仁人忍韧任认刃妊纫扔仍日戎茸蓉荣融熔溶容绒冗揉柔肉茹蠕儒孺如辱乳汝入褥软阮蕊瑞锐闰润若弱撒洒萨腮鳃塞赛三叁�".split("");for(j=0;j!=D[200].length;++j)if(D[200][j].charCodeAt(0)!==65533){e[D[200][j]]=200*256+j;d[200*256+j]=D[200][j]}D[201]="����������������������������������������������������������������葽葾葿蒀蒁蒃蒄蒅蒆蒊蒍蒏蒐蒑蒒蒓蒔蒕蒖蒘蒚蒛蒝蒞蒟蒠蒢蒣蒤蒥蒦蒧蒨蒩蒪蒫蒬蒭蒮蒰蒱蒳蒵蒶蒷蒻蒼蒾蓀蓂蓃蓅蓆蓇蓈蓋蓌蓎蓏蓒蓔蓕蓗�蓘蓙蓚蓛蓜蓞蓡蓢蓤蓧蓨蓩蓪蓫蓭蓮蓯蓱蓲蓳蓴蓵蓶蓷蓸蓹蓺蓻蓽蓾蔀蔁蔂伞散桑嗓丧搔骚扫嫂瑟色涩森僧莎砂杀刹沙纱傻啥煞筛晒珊苫杉山删煽衫闪陕擅赡膳善汕扇缮墒伤商赏晌上尚裳梢捎稍烧芍勺韶少哨邵绍奢赊蛇舌舍赦摄射慑涉社设砷申呻伸身深娠绅神沈审婶甚肾慎渗声生甥牲升绳�".split("");for(j=0;j!=D[201].length;++j)if(D[201][j].charCodeAt(0)!==65533){e[D[201][j]]=201*256+j;d[201*256+j]=D[201][j]}D[202]="����������������������������������������������������������������蔃蔄蔅蔆蔇蔈蔉蔊蔋蔍蔎蔏蔐蔒蔔蔕蔖蔘蔙蔛蔜蔝蔞蔠蔢蔣蔤蔥蔦蔧蔨蔩蔪蔭蔮蔯蔰蔱蔲蔳蔴蔵蔶蔾蔿蕀蕁蕂蕄蕅蕆蕇蕋蕌蕍蕎蕏蕐蕑蕒蕓蕔蕕�蕗蕘蕚蕛蕜蕝蕟蕠蕡蕢蕣蕥蕦蕧蕩蕪蕫蕬蕭蕮蕯蕰蕱蕳蕵蕶蕷蕸蕼蕽蕿薀薁省盛剩胜圣师失狮施湿诗尸虱十石拾时什食蚀实识史矢使屎驶始式示士世柿事拭誓逝势是嗜噬适仕侍释饰氏市恃室视试收手首守寿授售受瘦兽蔬枢梳殊抒输叔舒淑疏书赎孰熟薯暑曙署蜀黍鼠属术述树束戍竖墅庶数漱�".split("");for(j=0;j!=D[202].length;++j)if(D[202][j].charCodeAt(0)!==65533){e[D[202][j]]=202*256+j;d[202*256+j]=D[202][j]}D[203]="����������������������������������������������������������������薂薃薆薈薉薊薋薌薍薎薐薑薒薓薔薕薖薗薘薙薚薝薞薟薠薡薢薣薥薦薧薩薫薬薭薱薲薳薴薵薶薸薺薻薼薽薾薿藀藂藃藄藅藆藇藈藊藋藌藍藎藑藒�藔藖藗藘藙藚藛藝藞藟藠藡藢藣藥藦藧藨藪藫藬藭藮藯藰藱藲藳藴藵藶藷藸恕刷耍摔衰甩帅栓拴霜双爽谁水睡税吮瞬顺舜说硕朔烁斯撕嘶思私司丝死肆寺嗣四伺似饲巳松耸怂颂送宋讼诵搜艘擞嗽苏酥俗素速粟僳塑溯宿诉肃酸蒜算虽隋随绥髓碎岁穗遂隧祟孙损笋蓑梭唆缩琐索锁所塌他它她塔�".split("");for(j=0;j!=D[203].length;++j)if(D[203][j].charCodeAt(0)!==65533){e[D[203][j]]=203*256+j;d[203*256+j]=D[203][j]}D[204]="����������������������������������������������������������������藹藺藼藽藾蘀蘁蘂蘃蘄蘆蘇蘈蘉蘊蘋蘌蘍蘎蘏蘐蘒蘓蘔蘕蘗蘘蘙蘚蘛蘜蘝蘞蘟蘠蘡蘢蘣蘤蘥蘦蘨蘪蘫蘬蘭蘮蘯蘰蘱蘲蘳蘴蘵蘶蘷蘹蘺蘻蘽蘾蘿虀�虁虂虃虄虅虆虇虈虉虊虋虌虒虓處虖虗虘虙虛虜虝號虠虡虣虤虥虦虧虨虩虪獭挞蹋踏胎苔抬台泰酞太态汰坍摊贪瘫滩坛檀痰潭谭谈坦毯袒碳探叹炭汤塘搪堂棠膛唐糖倘躺淌趟烫掏涛滔绦萄桃逃淘陶讨套特藤腾疼誊梯剔踢锑提题蹄啼体替嚏惕涕剃屉天添填田甜恬舔腆挑条迢眺跳贴铁帖厅听烃�".split("");for(j=0;j!=D[204].length;++j)if(D[204][j].charCodeAt(0)!==65533){e[D[204][j]]=204*256+j;d[204*256+j]=D[204][j]}D[205]="����������������������������������������������������������������虭虯虰虲虳虴虵虶虷虸蚃蚄蚅蚆蚇蚈蚉蚎蚏蚐蚑蚒蚔蚖蚗蚘蚙蚚蚛蚞蚟蚠蚡蚢蚥蚦蚫蚭蚮蚲蚳蚷蚸蚹蚻蚼蚽蚾蚿蛁蛂蛃蛅蛈蛌蛍蛒蛓蛕蛖蛗蛚蛜�蛝蛠蛡蛢蛣蛥蛦蛧蛨蛪蛫蛬蛯蛵蛶蛷蛺蛻蛼蛽蛿蜁蜄蜅蜆蜋蜌蜎蜏蜐蜑蜔蜖汀廷停亭庭挺艇通桐酮瞳同铜彤童桶捅筒统痛偷投头透凸秃突图徒途涂屠土吐兔湍团推颓腿蜕褪退吞屯臀拖托脱鸵陀驮驼椭妥拓唾挖哇蛙洼娃瓦袜歪外豌弯湾玩顽丸烷完碗挽晚皖惋宛婉万腕汪王亡枉网往旺望忘妄威�".split("");for(j=0;j!=D[205].length;++j)if(D[205][j].charCodeAt(0)!==65533){e[D[205][j]]=205*256+j;d[205*256+j]=D[205][j]}D[206]="����������������������������������������������������������������蜙蜛蜝蜟蜠蜤蜦蜧蜨蜪蜫蜬蜭蜯蜰蜲蜳蜵蜶蜸蜹蜺蜼蜽蝀蝁蝂蝃蝄蝅蝆蝊蝋蝍蝏蝐蝑蝒蝔蝕蝖蝘蝚蝛蝜蝝蝞蝟蝡蝢蝦蝧蝨蝩蝪蝫蝬蝭蝯蝱蝲蝳蝵�蝷蝸蝹蝺蝿螀螁螄螆螇螉螊螌螎螏螐螑螒螔螕螖螘螙螚螛螜螝螞螠螡螢螣螤巍微危韦违桅围唯惟为潍维苇萎委伟伪尾纬未蔚味畏胃喂魏位渭谓尉慰卫瘟温蚊文闻纹吻稳紊问嗡翁瓮挝蜗涡窝我斡卧握沃巫呜钨乌污诬屋无芜梧吾吴毋武五捂午舞伍侮坞戊雾晤物勿务悟误昔熙析西硒矽晰嘻吸锡牺�".split("");for(j=0;j!=D[206].length;++j)if(D[206][j].charCodeAt(0)!==65533){e[D[206][j]]=206*256+j;d[206*256+j]=D[206][j]}D[207]="����������������������������������������������������������������螥螦螧螩螪螮螰螱螲螴螶螷螸螹螻螼螾螿蟁蟂蟃蟄蟅蟇蟈蟉蟌蟍蟎蟏蟐蟔蟕蟖蟗蟘蟙蟚蟜蟝蟞蟟蟡蟢蟣蟤蟦蟧蟨蟩蟫蟬蟭蟯蟰蟱蟲蟳蟴蟵蟶蟷蟸�蟺蟻蟼蟽蟿蠀蠁蠂蠄蠅蠆蠇蠈蠉蠋蠌蠍蠎蠏蠐蠑蠒蠔蠗蠘蠙蠚蠜蠝蠞蠟蠠蠣稀息希悉膝夕惜熄烯溪汐犀檄袭席习媳喜铣洗系隙戏细瞎虾匣霞辖暇峡侠狭下厦夏吓掀锨先仙鲜纤咸贤衔舷闲涎弦嫌显险现献县腺馅羡宪陷限线相厢镶香箱襄湘乡翔祥详想响享项巷橡像向象萧硝霄削哮嚣销消宵淆晓�".split("");for(j=0;j!=D[207].length;++j)if(D[207][j].charCodeAt(0)!==65533){e[D[207][j]]=207*256+j;d[207*256+j]=D[207][j]}D[208]="����������������������������������������������������������������蠤蠥蠦蠧蠨蠩蠪蠫蠬蠭蠮蠯蠰蠱蠳蠴蠵蠶蠷蠸蠺蠻蠽蠾蠿衁衂衃衆衇衈衉衊衋衎衏衐衑衒術衕衖衘衚衛衜衝衞衟衠衦衧衪衭衯衱衳衴衵衶衸衹衺�衻衼袀袃袆袇袉袊袌袎袏袐袑袓袔袕袗袘袙袚袛袝袞袟袠袡袣袥袦袧袨袩袪小孝校肖啸笑效楔些歇蝎鞋协挟携邪斜胁谐写械卸蟹懈泄泻谢屑薪芯锌欣辛新忻心信衅星腥猩惺兴刑型形邢行醒幸杏性姓兄凶胸匈汹雄熊休修羞朽嗅锈秀袖绣墟戌需虚嘘须徐许蓄酗叙旭序畜恤絮婿绪续轩喧宣悬旋玄�".split("");for(j=0;j!=D[208].length;++j)if(D[208][j].charCodeAt(0)!==65533){e[D[208][j]]=208*256+j;d[208*256+j]=D[208][j]}D[209]="����������������������������������������������������������������袬袮袯袰袲袳袴袵袶袸袹袺袻袽袾袿裀裃裄裇裈裊裋裌裍裏裐裑裓裖裗裚裛補裝裞裠裡裦裧裩裪裫裬裭裮裯裲裵裶裷裺裻製裿褀褁褃褄褅褆複褈�褉褋褌褍褎褏褑褔褕褖褗褘褜褝褞褟褠褢褣褤褦褧褨褩褬褭褮褯褱褲褳褵褷选癣眩绚靴薛学穴雪血勋熏循旬询寻驯巡殉汛训讯逊迅压押鸦鸭呀丫芽牙蚜崖衙涯雅哑亚讶焉咽阉烟淹盐严研蜒岩延言颜阎炎沿奄掩眼衍演艳堰燕厌砚雁唁彦焰宴谚验殃央鸯秧杨扬佯疡羊洋阳氧仰痒养样漾邀腰妖瑶�".split("");for(j=0;j!=D[209].length;++j)if(D[209][j].charCodeAt(0)!==65533){e[D[209][j]]=209*256+j;d[209*256+j]=D[209][j]}D[210]="����������������������������������������������������������������褸褹褺褻褼褽褾褿襀襂襃襅襆襇襈襉襊襋襌襍襎襏襐襑襒襓襔襕襖襗襘襙襚襛襜襝襠襡襢襣襤襥襧襨襩襪襫襬襭襮襯襰襱襲襳襴襵襶襷襸襹襺襼�襽襾覀覂覄覅覇覈覉覊見覌覍覎規覐覑覒覓覔覕視覗覘覙覚覛覜覝覞覟覠覡摇尧遥窑谣姚咬舀药要耀椰噎耶爷野冶也页掖业叶曳腋夜液一壹医揖铱依伊衣颐夷遗移仪胰疑沂宜姨彝椅蚁倚已乙矣以艺抑易邑屹亿役臆逸肄疫亦裔意毅忆义益溢诣议谊译异翼翌绎茵荫因殷音阴姻吟银淫寅饮尹引隐�".split("");for(j=0;j!=D[210].length;++j)if(D[210][j].charCodeAt(0)!==65533){e[D[210][j]]=210*256+j;d[210*256+j]=D[210][j]}D[211]="����������������������������������������������������������������覢覣覤覥覦覧覨覩親覫覬覭覮覯覰覱覲観覴覵覶覷覸覹覺覻覼覽覾覿觀觃觍觓觔觕觗觘觙觛觝觟觠觡觢觤觧觨觩觪觬觭觮觰觱觲觴觵觶觷觸觹觺�觻觼觽觾觿訁訂訃訄訅訆計訉訊訋訌訍討訏訐訑訒訓訔訕訖託記訙訚訛訜訝印英樱婴鹰应缨莹萤营荧蝇迎赢盈影颖硬映哟拥佣臃痈庸雍踊蛹咏泳涌永恿勇用幽优悠忧尤由邮铀犹油游酉有友右佑釉诱又幼迂淤于盂榆虞愚舆余俞逾鱼愉渝渔隅予娱雨与屿禹宇语羽玉域芋郁吁遇喻峪御愈欲狱育誉�".split("");for(j=0;j!=D[211].length;++j)if(D[211][j].charCodeAt(0)!==65533){e[D[211][j]]=211*256+j;d[211*256+j]=D[211][j]}D[212]="����������������������������������������������������������������訞訟訠訡訢訣訤訥訦訧訨訩訪訫訬設訮訯訰許訲訳訴訵訶訷訸訹診註証訽訿詀詁詂詃詄詅詆詇詉詊詋詌詍詎詏詐詑詒詓詔評詖詗詘詙詚詛詜詝詞�詟詠詡詢詣詤詥試詧詨詩詪詫詬詭詮詯詰話該詳詴詵詶詷詸詺詻詼詽詾詿誀浴寓裕预豫驭鸳渊冤元垣袁原援辕园员圆猿源缘远苑愿怨院曰约越跃钥岳粤月悦阅耘云郧匀陨允运蕴酝晕韵孕匝砸杂栽哉灾宰载再在咱攒暂赞赃脏葬遭糟凿藻枣早澡蚤躁噪造皂灶燥责择则泽贼怎增憎曾赠扎喳渣札轧�".split("");for(j=0;j!=D[212].length;++j)if(D[212][j].charCodeAt(0)!==65533){e[D[212][j]]=212*256+j;d[212*256+j]=D[212][j]}D[213]="����������������������������������������������������������������誁誂誃誄誅誆誇誈誋誌認誎誏誐誑誒誔誕誖誗誘誙誚誛誜誝語誟誠誡誢誣誤誥誦誧誨誩說誫説読誮誯誰誱課誳誴誵誶誷誸誹誺誻誼誽誾調諀諁諂�諃諄諅諆談諈諉諊請諌諍諎諏諐諑諒諓諔諕論諗諘諙諚諛諜諝諞諟諠諡諢諣铡闸眨栅榨咋乍炸诈摘斋宅窄债寨瞻毡詹粘沾盏斩辗崭展蘸栈占战站湛绽樟章彰漳张掌涨杖丈帐账仗胀瘴障招昭找沼赵照罩兆肇召遮折哲蛰辙者锗蔗这浙珍斟真甄砧臻贞针侦枕疹诊震振镇阵蒸挣睁征狰争怔整拯正政�".split("");for(j=0;j!=D[213].length;++j)if(D[213][j].charCodeAt(0)!==65533){e[D[213][j]]=213*256+j;d[213*256+j]=D[213][j]}D[214]="����������������������������������������������������������������諤諥諦諧諨諩諪諫諬諭諮諯諰諱諲諳諴諵諶諷諸諹諺諻諼諽諾諿謀謁謂謃謄謅謆謈謉謊謋謌謍謎謏謐謑謒謓謔謕謖謗謘謙謚講謜謝謞謟謠謡謢謣�謤謥謧謨謩謪謫謬謭謮謯謰謱謲謳謴謵謶謷謸謹謺謻謼謽謾謿譀譁譂譃譄譅帧症郑证芝枝支吱蜘知肢脂汁之织职直植殖执值侄址指止趾只旨纸志挚掷至致置帜峙制智秩稚质炙痔滞治窒中盅忠钟衷终种肿重仲众舟周州洲诌粥轴肘帚咒皱宙昼骤珠株蛛朱猪诸诛逐竹烛煮拄瞩嘱主著柱助蛀贮铸筑�".split("");for(j=0;j!=D[214].length;++j)if(D[214][j].charCodeAt(0)!==65533){e[D[214][j]]=214*256+j;d[214*256+j]=D[214][j]}D[215]="����������������������������������������������������������������譆譇譈證譊譋譌譍譎譏譐譑譒譓譔譕譖譗識譙譚譛譜譝譞譟譠譡譢譣譤譥譧譨譩譪譫譭譮譯議譱譲譳譴譵譶護譸譹譺譻譼譽譾譿讀讁讂讃讄讅讆�讇讈讉變讋讌讍讎讏讐讑讒讓讔讕讖讗讘讙讚讛讜讝讞讟讬讱讻诇诐诪谉谞住注祝驻抓爪拽专砖转撰赚篆桩庄装妆撞壮状椎锥追赘坠缀谆准捉拙卓桌琢茁酌啄着灼浊兹咨资姿滋淄孜紫仔籽滓子自渍字鬃棕踪宗综总纵邹走奏揍租足卒族祖诅阻组钻纂嘴醉最罪尊遵昨左佐柞做作坐座������".split("");for(j=0;j!=D[215].length;++j)if(D[215][j].charCodeAt(0)!==65533){e[D[215][j]]=215*256+j;d[215*256+j]=D[215][j]}D[216]="����������������������������������������������������������������谸谹谺谻谼谽谾谿豀豂豃豄豅豈豊豋豍豎豏豐豑豒豓豔豖豗豘豙豛豜豝豞豟豠豣豤豥豦豧豨豩豬豭豮豯豰豱豲豴豵豶豷豻豼豽豾豿貀貁貃貄貆貇�貈貋貍貎貏貐貑貒貓貕貖貗貙貚貛貜貝貞貟負財貢貣貤貥貦貧貨販貪貫責貭亍丌兀丐廿卅丕亘丞鬲孬噩丨禺丿匕乇夭爻卮氐囟胤馗毓睾鼗丶亟鼐乜乩亓芈孛啬嘏仄厍厝厣厥厮靥赝匚叵匦匮匾赜卦卣刂刈刎刭刳刿剀剌剞剡剜蒯剽劂劁劐劓冂罔亻仃仉仂仨仡仫仞伛仳伢佤仵伥伧伉伫佞佧攸佚佝�".split("");for(j=0;j!=D[216].length;++j)if(D[216][j].charCodeAt(0)!==65533){e[D[216][j]]=216*256+j;d[216*256+j]=D[216][j]}D[217]="����������������������������������������������������������������貮貯貰貱貲貳貴貵貶買貸貹貺費貼貽貾貿賀賁賂賃賄賅賆資賈賉賊賋賌賍賎賏賐賑賒賓賔賕賖賗賘賙賚賛賜賝賞賟賠賡賢賣賤賥賦賧賨賩質賫賬�賭賮賯賰賱賲賳賴賵賶賷賸賹賺賻購賽賾賿贀贁贂贃贄贅贆贇贈贉贊贋贌贍佟佗伲伽佶佴侑侉侃侏佾佻侪佼侬侔俦俨俪俅俚俣俜俑俟俸倩偌俳倬倏倮倭俾倜倌倥倨偾偃偕偈偎偬偻傥傧傩傺僖儆僭僬僦僮儇儋仝氽佘佥俎龠汆籴兮巽黉馘冁夔勹匍訇匐凫夙兕亠兖亳衮袤亵脔裒禀嬴蠃羸冫冱冽冼�".split("");for(j=0;j!=D[217].length;++j)if(D[217][j].charCodeAt(0)!==65533){e[D[217][j]]=217*256+j;d[217*256+j]=D[217][j]}D[218]="����������������������������������������������������������������贎贏贐贑贒贓贔贕贖贗贘贙贚贛贜贠赑赒赗赟赥赨赩赪赬赮赯赱赲赸赹赺赻赼赽赾赿趀趂趃趆趇趈趉趌趍趎趏趐趒趓趕趖趗趘趙趚趛趜趝趞趠趡�趢趤趥趦趧趨趩趪趫趬趭趮趯趰趲趶趷趹趻趽跀跁跂跅跇跈跉跊跍跐跒跓跔凇冖冢冥讠讦讧讪讴讵讷诂诃诋诏诎诒诓诔诖诘诙诜诟诠诤诨诩诮诰诳诶诹诼诿谀谂谄谇谌谏谑谒谔谕谖谙谛谘谝谟谠谡谥谧谪谫谮谯谲谳谵谶卩卺阝阢阡阱阪阽阼陂陉陔陟陧陬陲陴隈隍隗隰邗邛邝邙邬邡邴邳邶邺�".split("");for(j=0;j!=D[218].length;++j)if(D[218][j].charCodeAt(0)!==65533){e[D[218][j]]=218*256+j;d[218*256+j]=D[218][j]}D[219]="����������������������������������������������������������������跕跘跙跜跠跡跢跥跦跧跩跭跮跰跱跲跴跶跼跾跿踀踁踂踃踄踆踇踈踋踍踎踐踑踒踓踕踖踗踘踙踚踛踜踠踡踤踥踦踧踨踫踭踰踲踳踴踶踷踸踻踼踾�踿蹃蹅蹆蹌蹍蹎蹏蹐蹓蹔蹕蹖蹗蹘蹚蹛蹜蹝蹞蹟蹠蹡蹢蹣蹤蹥蹧蹨蹪蹫蹮蹱邸邰郏郅邾郐郄郇郓郦郢郜郗郛郫郯郾鄄鄢鄞鄣鄱鄯鄹酃酆刍奂劢劬劭劾哿勐勖勰叟燮矍廴凵凼鬯厶弁畚巯坌垩垡塾墼壅壑圩圬圪圳圹圮圯坜圻坂坩垅坫垆坼坻坨坭坶坳垭垤垌垲埏垧垴垓垠埕埘埚埙埒垸埴埯埸埤埝�".split("");for(j=0;j!=D[219].length;++j)if(D[219][j].charCodeAt(0)!==65533){e[D[219][j]]=219*256+j;d[219*256+j]=D[219][j]}D[220]="����������������������������������������������������������������蹳蹵蹷蹸蹹蹺蹻蹽蹾躀躂躃躄躆躈躉躊躋躌躍躎躑躒躓躕躖躗躘躙躚躛躝躟躠躡躢躣躤躥躦躧躨躩躪躭躮躰躱躳躴躵躶躷躸躹躻躼躽躾躿軀軁軂�軃軄軅軆軇軈軉車軋軌軍軏軐軑軒軓軔軕軖軗軘軙軚軛軜軝軞軟軠軡転軣軤堋堍埽埭堀堞堙塄堠塥塬墁墉墚墀馨鼙懿艹艽艿芏芊芨芄芎芑芗芙芫芸芾芰苈苊苣芘芷芮苋苌苁芩芴芡芪芟苄苎芤苡茉苷苤茏茇苜苴苒苘茌苻苓茑茚茆茔茕苠苕茜荑荛荜茈莒茼茴茱莛荞茯荏荇荃荟荀茗荠茭茺茳荦荥�".split("");for(j=0;j!=D[220].length;++j)if(D[220][j].charCodeAt(0)!==65533){e[D[220][j]]=220*256+j;d[220*256+j]=D[220][j]}D[221]="����������������������������������������������������������������軥軦軧軨軩軪軫軬軭軮軯軰軱軲軳軴軵軶軷軸軹軺軻軼軽軾軿輀輁輂較輄輅輆輇輈載輊輋輌輍輎輏輐輑輒輓輔輕輖輗輘輙輚輛輜輝輞輟輠輡輢輣�輤輥輦輧輨輩輪輫輬輭輮輯輰輱輲輳輴輵輶輷輸輹輺輻輼輽輾輿轀轁轂轃轄荨茛荩荬荪荭荮莰荸莳莴莠莪莓莜莅荼莶莩荽莸荻莘莞莨莺莼菁萁菥菘堇萘萋菝菽菖萜萸萑萆菔菟萏萃菸菹菪菅菀萦菰菡葜葑葚葙葳蒇蒈葺蒉葸萼葆葩葶蒌蒎萱葭蓁蓍蓐蓦蒽蓓蓊蒿蒺蓠蒡蒹蒴蒗蓥蓣蔌甍蔸蓰蔹蔟蔺�".split("");for(j=0;j!=D[221].length;++j)if(D[221][j].charCodeAt(0)!==65533){e[D[221][j]]=221*256+j;d[221*256+j]=D[221][j]}D[222]="����������������������������������������������������������������轅轆轇轈轉轊轋轌轍轎轏轐轑轒轓轔轕轖轗轘轙轚轛轜轝轞轟轠轡轢轣轤轥轪辀辌辒辝辠辡辢辤辥辦辧辪辬辭辮辯農辳辴辵辷辸辺辻込辿迀迃迆�迉迊迋迌迍迏迒迖迗迚迠迡迣迧迬迯迱迲迴迵迶迺迻迼迾迿逇逈逌逎逓逕逘蕖蔻蓿蓼蕙蕈蕨蕤蕞蕺瞢蕃蕲蕻薤薨薇薏蕹薮薜薅薹薷薰藓藁藜藿蘧蘅蘩蘖蘼廾弈夼奁耷奕奚奘匏尢尥尬尴扌扪抟抻拊拚拗拮挢拶挹捋捃掭揶捱捺掎掴捭掬掊捩掮掼揲揸揠揿揄揞揎摒揆掾摅摁搋搛搠搌搦搡摞撄摭撖�".split("");for(j=0;j!=D[222].length;++j)if(D[222][j].charCodeAt(0)!==65533){e[D[222][j]]=222*256+j;d[222*256+j]=D[222][j]}D[223]="����������������������������������������������������������������這逜連逤逥逧逨逩逪逫逬逰週進逳逴逷逹逺逽逿遀遃遅遆遈遉遊運遌過達違遖遙遚遜遝遞遟遠遡遤遦遧適遪遫遬遯遰遱遲遳遶遷選遹遺遻遼遾邁�還邅邆邇邉邊邌邍邎邏邐邒邔邖邘邚邜邞邟邠邤邥邧邨邩邫邭邲邷邼邽邿郀摺撷撸撙撺擀擐擗擤擢攉攥攮弋忒甙弑卟叱叽叩叨叻吒吖吆呋呒呓呔呖呃吡呗呙吣吲咂咔呷呱呤咚咛咄呶呦咝哐咭哂咴哒咧咦哓哔呲咣哕咻咿哌哙哚哜咩咪咤哝哏哞唛哧唠哽唔哳唢唣唏唑唧唪啧喏喵啉啭啁啕唿啐唼�".split("");for(j=0;j!=D[223].length;++j)if(D[223][j].charCodeAt(0)!==65533){e[D[223][j]]=223*256+j;d[223*256+j]=D[223][j]}D[224]="����������������������������������������������������������������郂郃郆郈郉郋郌郍郒郔郕郖郘郙郚郞郟郠郣郤郥郩郪郬郮郰郱郲郳郵郶郷郹郺郻郼郿鄀鄁鄃鄅鄆鄇鄈鄉鄊鄋鄌鄍鄎鄏鄐鄑鄒鄓鄔鄕鄖鄗鄘鄚鄛鄜�鄝鄟鄠鄡鄤鄥鄦鄧鄨鄩鄪鄫鄬鄭鄮鄰鄲鄳鄴鄵鄶鄷鄸鄺鄻鄼鄽鄾鄿酀酁酂酄唷啖啵啶啷唳唰啜喋嗒喃喱喹喈喁喟啾嗖喑啻嗟喽喾喔喙嗪嗷嗉嘟嗑嗫嗬嗔嗦嗝嗄嗯嗥嗲嗳嗌嗍嗨嗵嗤辔嘞嘈嘌嘁嘤嘣嗾嘀嘧嘭噘嘹噗嘬噍噢噙噜噌噔嚆噤噱噫噻噼嚅嚓嚯囔囗囝囡囵囫囹囿圄圊圉圜帏帙帔帑帱帻帼�".split("");for(j=0;j!=D[224].length;++j)if(D[224][j].charCodeAt(0)!==65533){e[D[224][j]]=224*256+j;d[224*256+j]=D[224][j]}D[225]="����������������������������������������������������������������酅酇酈酑酓酔酕酖酘酙酛酜酟酠酦酧酨酫酭酳酺酻酼醀醁醂醃醄醆醈醊醎醏醓醔醕醖醗醘醙醜醝醞醟醠醡醤醥醦醧醨醩醫醬醰醱醲醳醶醷醸醹醻�醼醽醾醿釀釁釂釃釄釅釆釈釋釐釒釓釔釕釖釗釘釙釚釛針釞釟釠釡釢釣釤釥帷幄幔幛幞幡岌屺岍岐岖岈岘岙岑岚岜岵岢岽岬岫岱岣峁岷峄峒峤峋峥崂崃崧崦崮崤崞崆崛嵘崾崴崽嵬嵛嵯嵝嵫嵋嵊嵩嵴嶂嶙嶝豳嶷巅彳彷徂徇徉後徕徙徜徨徭徵徼衢彡犭犰犴犷犸狃狁狎狍狒狨狯狩狲狴狷猁狳猃狺�".split("");for(j=0;j!=D[225].length;++j)if(D[225][j].charCodeAt(0)!==65533){e[D[225][j]]=225*256+j;d[225*256+j]=D[225][j]}D[226]="����������������������������������������������������������������釦釧釨釩釪釫釬釭釮釯釰釱釲釳釴釵釶釷釸釹釺釻釼釽釾釿鈀鈁鈂鈃鈄鈅鈆鈇鈈鈉鈊鈋鈌鈍鈎鈏鈐鈑鈒鈓鈔鈕鈖鈗鈘鈙鈚鈛鈜鈝鈞鈟鈠鈡鈢鈣鈤�鈥鈦鈧鈨鈩鈪鈫鈬鈭鈮鈯鈰鈱鈲鈳鈴鈵鈶鈷鈸鈹鈺鈻鈼鈽鈾鈿鉀鉁鉂鉃鉄鉅狻猗猓猡猊猞猝猕猢猹猥猬猸猱獐獍獗獠獬獯獾舛夥飧夤夂饣饧饨饩饪饫饬饴饷饽馀馄馇馊馍馐馑馓馔馕庀庑庋庖庥庠庹庵庾庳赓廒廑廛廨廪膺忄忉忖忏怃忮怄忡忤忾怅怆忪忭忸怙怵怦怛怏怍怩怫怊怿怡恸恹恻恺恂�".split("");for(j=0;j!=D[226].length;++j)if(D[226][j].charCodeAt(0)!==65533){e[D[226][j]]=226*256+j;d[226*256+j]=D[226][j]}D[227]="����������������������������������������������������������������鉆鉇鉈鉉鉊鉋鉌鉍鉎鉏鉐鉑鉒鉓鉔鉕鉖鉗鉘鉙鉚鉛鉜鉝鉞鉟鉠鉡鉢鉣鉤鉥鉦鉧鉨鉩鉪鉫鉬鉭鉮鉯鉰鉱鉲鉳鉵鉶鉷鉸鉹鉺鉻鉼鉽鉾鉿銀銁銂銃銄銅�銆銇銈銉銊銋銌銍銏銐銑銒銓銔銕銖銗銘銙銚銛銜銝銞銟銠銡銢銣銤銥銦銧恪恽悖悚悭悝悃悒悌悛惬悻悱惝惘惆惚悴愠愦愕愣惴愀愎愫慊慵憬憔憧憷懔懵忝隳闩闫闱闳闵闶闼闾阃阄阆阈阊阋阌阍阏阒阕阖阗阙阚丬爿戕氵汔汜汊沣沅沐沔沌汨汩汴汶沆沩泐泔沭泷泸泱泗沲泠泖泺泫泮沱泓泯泾�".split("");for(j=0;j!=D[227].length;++j)if(D[227][j].charCodeAt(0)!==65533){e[D[227][j]]=227*256+j;d[227*256+j]=D[227][j]}D[228]="����������������������������������������������������������������銨銩銪銫銬銭銯銰銱銲銳銴銵銶銷銸銹銺銻銼銽銾銿鋀鋁鋂鋃鋄鋅鋆鋇鋉鋊鋋鋌鋍鋎鋏鋐鋑鋒鋓鋔鋕鋖鋗鋘鋙鋚鋛鋜鋝鋞鋟鋠鋡鋢鋣鋤鋥鋦鋧鋨�鋩鋪鋫鋬鋭鋮鋯鋰鋱鋲鋳鋴鋵鋶鋷鋸鋹鋺鋻鋼鋽鋾鋿錀錁錂錃錄錅錆錇錈錉洹洧洌浃浈洇洄洙洎洫浍洮洵洚浏浒浔洳涑浯涞涠浞涓涔浜浠浼浣渚淇淅淞渎涿淠渑淦淝淙渖涫渌涮渫湮湎湫溲湟溆湓湔渲渥湄滟溱溘滠漭滢溥溧溽溻溷滗溴滏溏滂溟潢潆潇漤漕滹漯漶潋潴漪漉漩澉澍澌潸潲潼潺濑�".split("");for(j=0;j!=D[228].length;++j)if(D[228][j].charCodeAt(0)!==65533){e[D[228][j]]=228*256+j;d[228*256+j]=D[228][j]}D[229]="����������������������������������������������������������������錊錋錌錍錎錏錐錑錒錓錔錕錖錗錘錙錚錛錜錝錞錟錠錡錢錣錤錥錦錧錨錩錪錫錬錭錮錯錰錱録錳錴錵錶錷錸錹錺錻錼錽錿鍀鍁鍂鍃鍄鍅鍆鍇鍈鍉�鍊鍋鍌鍍鍎鍏鍐鍑鍒鍓鍔鍕鍖鍗鍘鍙鍚鍛鍜鍝鍞鍟鍠鍡鍢鍣鍤鍥鍦鍧鍨鍩鍫濉澧澹澶濂濡濮濞濠濯瀚瀣瀛瀹瀵灏灞宀宄宕宓宥宸甯骞搴寤寮褰寰蹇謇辶迓迕迥迮迤迩迦迳迨逅逄逋逦逑逍逖逡逵逶逭逯遄遑遒遐遨遘遢遛暹遴遽邂邈邃邋彐彗彖彘尻咫屐屙孱屣屦羼弪弩弭艴弼鬻屮妁妃妍妩妪妣�".split("");for(j=0;j!=D[229].length;++j)if(D[229][j].charCodeAt(0)!==65533){e[D[229][j]]=229*256+j;d[229*256+j]=D[229][j]}D[230]="����������������������������������������������������������������鍬鍭鍮鍯鍰鍱鍲鍳鍴鍵鍶鍷鍸鍹鍺鍻鍼鍽鍾鍿鎀鎁鎂鎃鎄鎅鎆鎇鎈鎉鎊鎋鎌鎍鎎鎐鎑鎒鎓鎔鎕鎖鎗鎘鎙鎚鎛鎜鎝鎞鎟鎠鎡鎢鎣鎤鎥鎦鎧鎨鎩鎪鎫�鎬鎭鎮鎯鎰鎱鎲鎳鎴鎵鎶鎷鎸鎹鎺鎻鎼鎽鎾鎿鏀鏁鏂鏃鏄鏅鏆鏇鏈鏉鏋鏌鏍妗姊妫妞妤姒妲妯姗妾娅娆姝娈姣姘姹娌娉娲娴娑娣娓婀婧婊婕娼婢婵胬媪媛婷婺媾嫫媲嫒嫔媸嫠嫣嫱嫖嫦嫘嫜嬉嬗嬖嬲嬷孀尕尜孚孥孳孑孓孢驵驷驸驺驿驽骀骁骅骈骊骐骒骓骖骘骛骜骝骟骠骢骣骥骧纟纡纣纥纨纩�".split("");for(j=0;j!=D[230].length;++j)if(D[230][j].charCodeAt(0)!==65533){e[D[230][j]]=230*256+j;d[230*256+j]=D[230][j]}D[231]="����������������������������������������������������������������鏎鏏鏐鏑鏒鏓鏔鏕鏗鏘鏙鏚鏛鏜鏝鏞鏟鏠鏡鏢鏣鏤鏥鏦鏧鏨鏩鏪鏫鏬鏭鏮鏯鏰鏱鏲鏳鏴鏵鏶鏷鏸鏹鏺鏻鏼鏽鏾鏿鐀鐁鐂鐃鐄鐅鐆鐇鐈鐉鐊鐋鐌鐍�鐎鐏鐐鐑鐒鐓鐔鐕鐖鐗鐘鐙鐚鐛鐜鐝鐞鐟鐠鐡鐢鐣鐤鐥鐦鐧鐨鐩鐪鐫鐬鐭鐮纭纰纾绀绁绂绉绋绌绐绔绗绛绠绡绨绫绮绯绱绲缍绶绺绻绾缁缂缃缇缈缋缌缏缑缒缗缙缜缛缟缡缢缣缤缥缦缧缪缫缬缭缯缰缱缲缳缵幺畿巛甾邕玎玑玮玢玟珏珂珑玷玳珀珉珈珥珙顼琊珩珧珞玺珲琏琪瑛琦琥琨琰琮琬�".split("");for(j=0;j!=D[231].length;++j)if(D[231][j].charCodeAt(0)!==65533){e[D[231][j]]=231*256+j;d[231*256+j]=D[231][j]}D[232]="����������������������������������������������������������������鐯鐰鐱鐲鐳鐴鐵鐶鐷鐸鐹鐺鐻鐼鐽鐿鑀鑁鑂鑃鑄鑅鑆鑇鑈鑉鑊鑋鑌鑍鑎鑏鑐鑑鑒鑓鑔鑕鑖鑗鑘鑙鑚鑛鑜鑝鑞鑟鑠鑡鑢鑣鑤鑥鑦鑧鑨鑩鑪鑬鑭鑮鑯�鑰鑱鑲鑳鑴鑵鑶鑷鑸鑹鑺鑻鑼鑽鑾鑿钀钁钂钃钄钑钖钘铇铏铓铔铚铦铻锜锠琛琚瑁瑜瑗瑕瑙瑷瑭瑾璜璎璀璁璇璋璞璨璩璐璧瓒璺韪韫韬杌杓杞杈杩枥枇杪杳枘枧杵枨枞枭枋杷杼柰栉柘栊柩枰栌柙枵柚枳柝栀柃枸柢栎柁柽栲栳桠桡桎桢桄桤梃栝桕桦桁桧桀栾桊桉栩梵梏桴桷梓桫棂楮棼椟椠棹�".split("");for(j=0;j!=D[232].length;++j)if(D[232][j].charCodeAt(0)!==65533){e[D[232][j]]=232*256+j;d[232*256+j]=D[232][j]}D[233]="����������������������������������������������������������������锧锳锽镃镈镋镕镚镠镮镴镵長镸镹镺镻镼镽镾門閁閂閃閄閅閆閇閈閉閊開閌閍閎閏閐閑閒間閔閕閖閗閘閙閚閛閜閝閞閟閠閡関閣閤閥閦閧閨閩閪�閫閬閭閮閯閰閱閲閳閴閵閶閷閸閹閺閻閼閽閾閿闀闁闂闃闄闅闆闇闈闉闊闋椤棰椋椁楗棣椐楱椹楠楂楝榄楫榀榘楸椴槌榇榈槎榉楦楣楹榛榧榻榫榭槔榱槁槊槟榕槠榍槿樯槭樗樘橥槲橄樾檠橐橛樵檎橹樽樨橘橼檑檐檩檗檫猷獒殁殂殇殄殒殓殍殚殛殡殪轫轭轱轲轳轵轶轸轷轹轺轼轾辁辂辄辇辋�".split("");for(j=0;j!=D[233].length;++j)if(D[233][j].charCodeAt(0)!==65533){e[D[233][j]]=233*256+j;d[233*256+j]=D[233][j]}D[234]="����������������������������������������������������������������闌闍闎闏闐闑闒闓闔闕闖闗闘闙闚闛關闝闞闟闠闡闢闣闤闥闦闧闬闿阇阓阘阛阞阠阣阤阥阦阧阨阩阫阬阭阯阰阷阸阹阺阾陁陃陊陎陏陑陒陓陖陗�陘陙陚陜陝陞陠陣陥陦陫陭陮陯陰陱陳陸陹険陻陼陽陾陿隀隁隂隃隄隇隉隊辍辎辏辘辚軎戋戗戛戟戢戡戥戤戬臧瓯瓴瓿甏甑甓攴旮旯旰昊昙杲昃昕昀炅曷昝昴昱昶昵耆晟晔晁晏晖晡晗晷暄暌暧暝暾曛曜曦曩贲贳贶贻贽赀赅赆赈赉赇赍赕赙觇觊觋觌觎觏觐觑牮犟牝牦牯牾牿犄犋犍犏犒挈挲掰�".split("");for(j=0;j!=D[234].length;++j)if(D[234][j].charCodeAt(0)!==65533){e[D[234][j]]=234*256+j;d[234*256+j]=D[234][j]}D[235]="����������������������������������������������������������������隌階隑隒隓隕隖隚際隝隞隟隠隡隢隣隤隥隦隨隩險隫隬隭隮隯隱隲隴隵隷隸隺隻隿雂雃雈雊雋雐雑雓雔雖雗雘雙雚雛雜雝雞雟雡離難雤雥雦雧雫�雬雭雮雰雱雲雴雵雸雺電雼雽雿霂霃霅霊霋霌霐霑霒霔霕霗霘霙霚霛霝霟霠搿擘耄毪毳毽毵毹氅氇氆氍氕氘氙氚氡氩氤氪氲攵敕敫牍牒牖爰虢刖肟肜肓肼朊肽肱肫肭肴肷胧胨胩胪胛胂胄胙胍胗朐胝胫胱胴胭脍脎胲胼朕脒豚脶脞脬脘脲腈腌腓腴腙腚腱腠腩腼腽腭腧塍媵膈膂膑滕膣膪臌朦臊膻�".split("");for(j=0;j!=D[235].length;++j)if(D[235][j].charCodeAt(0)!==65533){e[D[235][j]]=235*256+j;d[235*256+j]=D[235][j]}D[236]="����������������������������������������������������������������霡霢霣霤霥霦霧霨霩霫霬霮霯霱霳霴霵霶霷霺霻霼霽霿靀靁靂靃靄靅靆靇靈靉靊靋靌靍靎靏靐靑靔靕靗靘靚靜靝靟靣靤靦靧靨靪靫靬靭靮靯靰靱�靲靵靷靸靹靺靻靽靾靿鞀鞁鞂鞃鞄鞆鞇鞈鞉鞊鞌鞎鞏鞐鞓鞕鞖鞗鞙鞚鞛鞜鞝臁膦欤欷欹歃歆歙飑飒飓飕飙飚殳彀毂觳斐齑斓於旆旄旃旌旎旒旖炀炜炖炝炻烀炷炫炱烨烊焐焓焖焯焱煳煜煨煅煲煊煸煺熘熳熵熨熠燠燔燧燹爝爨灬焘煦熹戾戽扃扈扉礻祀祆祉祛祜祓祚祢祗祠祯祧祺禅禊禚禧禳忑忐�".split("");for(j=0;j!=D[236].length;++j)if(D[236][j].charCodeAt(0)!==65533){e[D[236][j]]=236*256+j;d[236*256+j]=D[236][j]}D[237]="����������������������������������������������������������������鞞鞟鞡鞢鞤鞥鞦鞧鞨鞩鞪鞬鞮鞰鞱鞳鞵鞶鞷鞸鞹鞺鞻鞼鞽鞾鞿韀韁韂韃韄韅韆韇韈韉韊韋韌韍韎韏韐韑韒韓韔韕韖韗韘韙韚韛韜韝韞韟韠韡韢韣�韤韥韨韮韯韰韱韲韴韷韸韹韺韻韼韽韾響頀頁頂頃頄項順頇須頉頊頋頌頍頎怼恝恚恧恁恙恣悫愆愍慝憩憝懋懑戆肀聿沓泶淼矶矸砀砉砗砘砑斫砭砜砝砹砺砻砟砼砥砬砣砩硎硭硖硗砦硐硇硌硪碛碓碚碇碜碡碣碲碹碥磔磙磉磬磲礅磴礓礤礞礴龛黹黻黼盱眄眍盹眇眈眚眢眙眭眦眵眸睐睑睇睃睚睨�".split("");for(j=0;j!=D[237].length;++j)if(D[237][j].charCodeAt(0)!==65533){e[D[237][j]]=237*256+j;d[237*256+j]=D[237][j]}D[238]="����������������������������������������������������������������頏預頑頒頓頔頕頖頗領頙頚頛頜頝頞頟頠頡頢頣頤頥頦頧頨頩頪頫頬頭頮頯頰頱頲頳頴頵頶頷頸頹頺頻頼頽頾頿顀顁顂顃顄顅顆顇顈顉顊顋題額�顎顏顐顑顒顓顔顕顖顗願顙顚顛顜顝類顟顠顡顢顣顤顥顦顧顨顩顪顫顬顭顮睢睥睿瞍睽瞀瞌瞑瞟瞠瞰瞵瞽町畀畎畋畈畛畲畹疃罘罡罟詈罨罴罱罹羁罾盍盥蠲钅钆钇钋钊钌钍钏钐钔钗钕钚钛钜钣钤钫钪钭钬钯钰钲钴钶钷钸钹钺钼钽钿铄铈铉铊铋铌铍铎铐铑铒铕铖铗铙铘铛铞铟铠铢铤铥铧铨铪�".split("");for(j=0;j!=D[238].length;++j)if(D[238][j].charCodeAt(0)!==65533){e[D[238][j]]=238*256+j;d[238*256+j]=D[238][j]}D[239]="����������������������������������������������������������������顯顰顱顲顳顴颋颎颒颕颙颣風颩颪颫颬颭颮颯颰颱颲颳颴颵颶颷颸颹颺颻颼颽颾颿飀飁飂飃飄飅飆飇飈飉飊飋飌飍飏飐飔飖飗飛飜飝飠飡飢飣飤�飥飦飩飪飫飬飭飮飯飰飱飲飳飴飵飶飷飸飹飺飻飼飽飾飿餀餁餂餃餄餅餆餇铩铫铮铯铳铴铵铷铹铼铽铿锃锂锆锇锉锊锍锎锏锒锓锔锕锖锘锛锝锞锟锢锪锫锩锬锱锲锴锶锷锸锼锾锿镂锵镄镅镆镉镌镎镏镒镓镔镖镗镘镙镛镞镟镝镡镢镤镥镦镧镨镩镪镫镬镯镱镲镳锺矧矬雉秕秭秣秫稆嵇稃稂稞稔�".split("");for(j=0;j!=D[239].length;++j)if(D[239][j].charCodeAt(0)!==65533){e[D[239][j]]=239*256+j;d[239*256+j]=D[239][j]}D[240]="����������������������������������������������������������������餈餉養餋餌餎餏餑餒餓餔餕餖餗餘餙餚餛餜餝餞餟餠餡餢餣餤餥餦餧館餩餪餫餬餭餯餰餱餲餳餴餵餶餷餸餹餺餻餼餽餾餿饀饁饂饃饄饅饆饇饈饉�饊饋饌饍饎饏饐饑饒饓饖饗饘饙饚饛饜饝饞饟饠饡饢饤饦饳饸饹饻饾馂馃馉稹稷穑黏馥穰皈皎皓皙皤瓞瓠甬鸠鸢鸨鸩鸪鸫鸬鸲鸱鸶鸸鸷鸹鸺鸾鹁鹂鹄鹆鹇鹈鹉鹋鹌鹎鹑鹕鹗鹚鹛鹜鹞鹣鹦鹧鹨鹩鹪鹫鹬鹱鹭鹳疒疔疖疠疝疬疣疳疴疸痄疱疰痃痂痖痍痣痨痦痤痫痧瘃痱痼痿瘐瘀瘅瘌瘗瘊瘥瘘瘕瘙�".split("");for(j=0;j!=D[240].length;++j)if(D[240][j].charCodeAt(0)!==65533){e[D[240][j]]=240*256+j;d[240*256+j]=D[240][j]}D[241]="����������������������������������������������������������������馌馎馚馛馜馝馞馟馠馡馢馣馤馦馧馩馪馫馬馭馮馯馰馱馲馳馴馵馶馷馸馹馺馻馼馽馾馿駀駁駂駃駄駅駆駇駈駉駊駋駌駍駎駏駐駑駒駓駔駕駖駗駘�駙駚駛駜駝駞駟駠駡駢駣駤駥駦駧駨駩駪駫駬駭駮駯駰駱駲駳駴駵駶駷駸駹瘛瘼瘢瘠癀瘭瘰瘿瘵癃瘾瘳癍癞癔癜癖癫癯翊竦穸穹窀窆窈窕窦窠窬窨窭窳衤衩衲衽衿袂袢裆袷袼裉裢裎裣裥裱褚裼裨裾裰褡褙褓褛褊褴褫褶襁襦襻疋胥皲皴矜耒耔耖耜耠耢耥耦耧耩耨耱耋耵聃聆聍聒聩聱覃顸颀颃�".split("");for(j=0;j!=D[241].length;++j)if(D[241][j].charCodeAt(0)!==65533){e[D[241][j]]=241*256+j;d[241*256+j]=D[241][j]}D[242]="����������������������������������������������������������������駺駻駼駽駾駿騀騁騂騃騄騅騆騇騈騉騊騋騌騍騎騏騐騑騒験騔騕騖騗騘騙騚騛騜騝騞騟騠騡騢騣騤騥騦騧騨騩騪騫騬騭騮騯騰騱騲騳騴騵騶騷騸�騹騺騻騼騽騾騿驀驁驂驃驄驅驆驇驈驉驊驋驌驍驎驏驐驑驒驓驔驕驖驗驘驙颉颌颍颏颔颚颛颞颟颡颢颥颦虍虔虬虮虿虺虼虻蚨蚍蚋蚬蚝蚧蚣蚪蚓蚩蚶蛄蚵蛎蚰蚺蚱蚯蛉蛏蚴蛩蛱蛲蛭蛳蛐蜓蛞蛴蛟蛘蛑蜃蜇蛸蜈蜊蜍蜉蜣蜻蜞蜥蜮蜚蜾蝈蜴蜱蜩蜷蜿螂蜢蝽蝾蝻蝠蝰蝌蝮螋蝓蝣蝼蝤蝙蝥螓螯螨蟒�".split("");for(j=0;j!=D[242].length;++j)if(D[242][j].charCodeAt(0)!==65533){e[D[242][j]]=242*256+j;d[242*256+j]=D[242][j]}D[243]="����������������������������������������������������������������驚驛驜驝驞驟驠驡驢驣驤驥驦驧驨驩驪驫驲骃骉骍骎骔骕骙骦骩骪骫骬骭骮骯骲骳骴骵骹骻骽骾骿髃髄髆髇髈髉髊髍髎髏髐髒體髕髖髗髙髚髛髜�髝髞髠髢髣髤髥髧髨髩髪髬髮髰髱髲髳髴髵髶髷髸髺髼髽髾髿鬀鬁鬂鬄鬅鬆蟆螈螅螭螗螃螫蟥螬螵螳蟋蟓螽蟑蟀蟊蟛蟪蟠蟮蠖蠓蟾蠊蠛蠡蠹蠼缶罂罄罅舐竺竽笈笃笄笕笊笫笏筇笸笪笙笮笱笠笥笤笳笾笞筘筚筅筵筌筝筠筮筻筢筲筱箐箦箧箸箬箝箨箅箪箜箢箫箴篑篁篌篝篚篥篦篪簌篾篼簏簖簋�".split("");for(j=0;j!=D[243].length;++j)if(D[243][j].charCodeAt(0)!==65533){e[D[243][j]]=243*256+j;d[243*256+j]=D[243][j]}D[244]="����������������������������������������������������������������鬇鬉鬊鬋鬌鬍鬎鬐鬑鬒鬔鬕鬖鬗鬘鬙鬚鬛鬜鬝鬞鬠鬡鬢鬤鬥鬦鬧鬨鬩鬪鬫鬬鬭鬮鬰鬱鬳鬴鬵鬶鬷鬸鬹鬺鬽鬾鬿魀魆魊魋魌魎魐魒魓魕魖魗魘魙魚�魛魜魝魞魟魠魡魢魣魤魥魦魧魨魩魪魫魬魭魮魯魰魱魲魳魴魵魶魷魸魹魺魻簟簪簦簸籁籀臾舁舂舄臬衄舡舢舣舭舯舨舫舸舻舳舴舾艄艉艋艏艚艟艨衾袅袈裘裟襞羝羟羧羯羰羲籼敉粑粝粜粞粢粲粼粽糁糇糌糍糈糅糗糨艮暨羿翎翕翥翡翦翩翮翳糸絷綦綮繇纛麸麴赳趄趔趑趱赧赭豇豉酊酐酎酏酤�".split("");for(j=0;j!=D[244].length;++j)if(D[244][j].charCodeAt(0)!==65533){e[D[244][j]]=244*256+j;d[244*256+j]=D[244][j]}D[245]="����������������������������������������������������������������魼魽魾魿鮀鮁鮂鮃鮄鮅鮆鮇鮈鮉鮊鮋鮌鮍鮎鮏鮐鮑鮒鮓鮔鮕鮖鮗鮘鮙鮚鮛鮜鮝鮞鮟鮠鮡鮢鮣鮤鮥鮦鮧鮨鮩鮪鮫鮬鮭鮮鮯鮰鮱鮲鮳鮴鮵鮶鮷鮸鮹鮺�鮻鮼鮽鮾鮿鯀鯁鯂鯃鯄鯅鯆鯇鯈鯉鯊鯋鯌鯍鯎鯏鯐鯑鯒鯓鯔鯕鯖鯗鯘鯙鯚鯛酢酡酰酩酯酽酾酲酴酹醌醅醐醍醑醢醣醪醭醮醯醵醴醺豕鹾趸跫踅蹙蹩趵趿趼趺跄跖跗跚跞跎跏跛跆跬跷跸跣跹跻跤踉跽踔踝踟踬踮踣踯踺蹀踹踵踽踱蹉蹁蹂蹑蹒蹊蹰蹶蹼蹯蹴躅躏躔躐躜躞豸貂貊貅貘貔斛觖觞觚觜�".split("");for(j=0;j!=D[245].length;++j)if(D[245][j].charCodeAt(0)!==65533){e[D[245][j]]=245*256+j;d[245*256+j]=D[245][j]}D[246]="����������������������������������������������������������������鯜鯝鯞鯟鯠鯡鯢鯣鯤鯥鯦鯧鯨鯩鯪鯫鯬鯭鯮鯯鯰鯱鯲鯳鯴鯵鯶鯷鯸鯹鯺鯻鯼鯽鯾鯿鰀鰁鰂鰃鰄鰅鰆鰇鰈鰉鰊鰋鰌鰍鰎鰏鰐鰑鰒鰓鰔鰕鰖鰗鰘鰙鰚�鰛鰜鰝鰞鰟鰠鰡鰢鰣鰤鰥鰦鰧鰨鰩鰪鰫鰬鰭鰮鰯鰰鰱鰲鰳鰴鰵鰶鰷鰸鰹鰺鰻觥觫觯訾謦靓雩雳雯霆霁霈霏霎霪霭霰霾龀龃龅龆龇龈龉龊龌黾鼋鼍隹隼隽雎雒瞿雠銎銮鋈錾鍪鏊鎏鐾鑫鱿鲂鲅鲆鲇鲈稣鲋鲎鲐鲑鲒鲔鲕鲚鲛鲞鲟鲠鲡鲢鲣鲥鲦鲧鲨鲩鲫鲭鲮鲰鲱鲲鲳鲴鲵鲶鲷鲺鲻鲼鲽鳄鳅鳆鳇鳊鳋�".split("");for(j=0;j!=D[246].length;++j)if(D[246][j].charCodeAt(0)!==65533){e[D[246][j]]=246*256+j;d[246*256+j]=D[246][j]}D[247]="����������������������������������������������������������������鰼鰽鰾鰿鱀鱁鱂鱃鱄鱅鱆鱇鱈鱉鱊鱋鱌鱍鱎鱏鱐鱑鱒鱓鱔鱕鱖鱗鱘鱙鱚鱛鱜鱝鱞鱟鱠鱡鱢鱣鱤鱥鱦鱧鱨鱩鱪鱫鱬鱭鱮鱯鱰鱱鱲鱳鱴鱵鱶鱷鱸鱹鱺�鱻鱽鱾鲀鲃鲄鲉鲊鲌鲏鲓鲖鲗鲘鲙鲝鲪鲬鲯鲹鲾鲿鳀鳁鳂鳈鳉鳑鳒鳚鳛鳠鳡鳌鳍鳎鳏鳐鳓鳔鳕鳗鳘鳙鳜鳝鳟鳢靼鞅鞑鞒鞔鞯鞫鞣鞲鞴骱骰骷鹘骶骺骼髁髀髅髂髋髌髑魅魃魇魉魈魍魑飨餍餮饕饔髟髡髦髯髫髻髭髹鬈鬏鬓鬟鬣麽麾縻麂麇麈麋麒鏖麝麟黛黜黝黠黟黢黩黧黥黪黯鼢鼬鼯鼹鼷鼽鼾齄�".split("");for(j=0;j!=D[247].length;++j)if(D[247][j].charCodeAt(0)!==65533){e[D[247][j]]=247*256+j;d[247*256+j]=D[247][j]}D[248]="����������������������������������������������������������������鳣鳤鳥鳦鳧鳨鳩鳪鳫鳬鳭鳮鳯鳰鳱鳲鳳鳴鳵鳶鳷鳸鳹鳺鳻鳼鳽鳾鳿鴀鴁鴂鴃鴄鴅鴆鴇鴈鴉鴊鴋鴌鴍鴎鴏鴐鴑鴒鴓鴔鴕鴖鴗鴘鴙鴚鴛鴜鴝鴞鴟鴠鴡�鴢鴣鴤鴥鴦鴧鴨鴩鴪鴫鴬鴭鴮鴯鴰鴱鴲鴳鴴鴵鴶鴷鴸鴹鴺鴻鴼鴽鴾鴿鵀鵁鵂�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[248].length;++j)if(D[248][j].charCodeAt(0)!==65533){e[D[248][j]]=248*256+j;d[248*256+j]=D[248][j]}D[249]="����������������������������������������������������������������鵃鵄鵅鵆鵇鵈鵉鵊鵋鵌鵍鵎鵏鵐鵑鵒鵓鵔鵕鵖鵗鵘鵙鵚鵛鵜鵝鵞鵟鵠鵡鵢鵣鵤鵥鵦鵧鵨鵩鵪鵫鵬鵭鵮鵯鵰鵱鵲鵳鵴鵵鵶鵷鵸鵹鵺鵻鵼鵽鵾鵿鶀鶁�鶂鶃鶄鶅鶆鶇鶈鶉鶊鶋鶌鶍鶎鶏鶐鶑鶒鶓鶔鶕鶖鶗鶘鶙鶚鶛鶜鶝鶞鶟鶠鶡鶢�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[249].length;++j)if(D[249][j].charCodeAt(0)!==65533){e[D[249][j]]=249*256+j;d[249*256+j]=D[249][j]}D[250]="����������������������������������������������������������������鶣鶤鶥鶦鶧鶨鶩鶪鶫鶬鶭鶮鶯鶰鶱鶲鶳鶴鶵鶶鶷鶸鶹鶺鶻鶼鶽鶾鶿鷀鷁鷂鷃鷄鷅鷆鷇鷈鷉鷊鷋鷌鷍鷎鷏鷐鷑鷒鷓鷔鷕鷖鷗鷘鷙鷚鷛鷜鷝鷞鷟鷠鷡�鷢鷣鷤鷥鷦鷧鷨鷩鷪鷫鷬鷭鷮鷯鷰鷱鷲鷳鷴鷵鷶鷷鷸鷹鷺鷻鷼鷽鷾鷿鸀鸁鸂�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[250].length;++j)if(D[250][j].charCodeAt(0)!==65533){e[D[250][j]]=250*256+j;d[250*256+j]=D[250][j]}D[251]="����������������������������������������������������������������鸃鸄鸅鸆鸇鸈鸉鸊鸋鸌鸍鸎鸏鸐鸑鸒鸓鸔鸕鸖鸗鸘鸙鸚鸛鸜鸝鸞鸤鸧鸮鸰鸴鸻鸼鹀鹍鹐鹒鹓鹔鹖鹙鹝鹟鹠鹡鹢鹥鹮鹯鹲鹴鹵鹶鹷鹸鹹鹺鹻鹼鹽麀�麁麃麄麅麆麉麊麌麍麎麏麐麑麔麕麖麗麘麙麚麛麜麞麠麡麢麣麤麥麧麨麩麪�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[251].length;++j)if(D[251][j].charCodeAt(0)!==65533){e[D[251][j]]=251*256+j;d[251*256+j]=D[251][j]}D[252]="����������������������������������������������������������������麫麬麭麮麯麰麱麲麳麵麶麷麹麺麼麿黀黁黂黃黅黆黇黈黊黋黌黐黒黓黕黖黗黙黚點黡黣黤黦黨黫黬黭黮黰黱黲黳黴黵黶黷黸黺黽黿鼀鼁鼂鼃鼄鼅�鼆鼇鼈鼉鼊鼌鼏鼑鼒鼔鼕鼖鼘鼚鼛鼜鼝鼞鼟鼡鼣鼤鼥鼦鼧鼨鼩鼪鼫鼭鼮鼰鼱�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[252].length;++j)if(D[252][j].charCodeAt(0)!==65533){e[D[252][j]]=252*256+j;d[252*256+j]=D[252][j]}D[253]="����������������������������������������������������������������鼲鼳鼴鼵鼶鼸鼺鼼鼿齀齁齂齃齅齆齇齈齉齊齋齌齍齎齏齒齓齔齕齖齗齘齙齚齛齜齝齞齟齠齡齢齣齤齥齦齧齨齩齪齫齬齭齮齯齰齱齲齳齴齵齶齷齸�齹齺齻齼齽齾龁龂龍龎龏龐龑龒龓龔龕龖龗龘龜龝龞龡龢龣龤龥郎凉秊裏隣�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[253].length;++j)if(D[253][j].charCodeAt(0)!==65533){e[D[253][j]]=253*256+j;d[253*256+j]=D[253][j]}D[254]="����������������������������������������������������������������兀嗀﨎﨏﨑﨓﨔礼﨟蘒﨡﨣﨤﨧﨨﨩��������������������������������������������������������������������������������������������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[254].length;++j)if(D[254][j].charCodeAt(0)!==65533){e[D[254][j]]=254*256+j;d[254*256+j]=D[254][j]}return{enc:e,dec:d}}();cptable[949]=function(){var d={},e={},D=[],j;D[0]="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~��������������������������������������������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[0].length;++j)if(D[0][j].charCodeAt(0)!==65533){e[D[0][j]]=0*256+j;d[0*256+j]=D[0][j]}D[129]="�����������������������������������������������������������������갂갃갅갆갋갌갍갎갏갘갞갟갡갢갣갥갦갧갨갩갪갫갮갲갳갴������갵갶갷갺갻갽갾갿걁걂걃걄걅걆걇걈걉걊걌걎걏걐걑걒걓걕������걖걗걙걚걛걝걞걟걠걡걢걣걤걥걦걧걨걩걪걫걬걭걮걯걲걳걵걶걹걻걼걽걾걿겂겇겈겍겎겏겑겒겓겕겖겗겘겙겚겛겞겢겣겤겥겦겧겫겭겮겱겲겳겴겵겶겷겺겾겿곀곂곃곅곆곇곉곊곋곍곎곏곐곑곒곓곔곖곘곙곚곛곜곝곞곟곢곣곥곦곩곫곭곮곲곴곷곸곹곺곻곾곿괁괂괃괅괇괈괉괊괋괎괐괒괓�".split("");for(j=0;j!=D[129].length;++j)if(D[129][j].charCodeAt(0)!==65533){e[D[129][j]]=129*256+j;d[129*256+j]=D[129][j]}D[130]="�����������������������������������������������������������������괔괕괖괗괙괚괛괝괞괟괡괢괣괤괥괦괧괨괪괫괮괯괰괱괲괳������괶괷괹괺괻괽괾괿굀굁굂굃굆굈굊굋굌굍굎굏굑굒굓굕굖굗������굙굚굛굜굝굞굟굠굢굤굥굦굧굨굩굪굫굮굯굱굲굷굸굹굺굾궀궃궄궅궆궇궊궋궍궎궏궑궒궓궔궕궖궗궘궙궚궛궞궟궠궡궢궣궥궦궧궨궩궪궫궬궭궮궯궰궱궲궳궴궵궶궸궹궺궻궼궽궾궿귂귃귅귆귇귉귊귋귌귍귎귏귒귔귕귖귗귘귙귚귛귝귞귟귡귢귣귥귦귧귨귩귪귫귬귭귮귯귰귱귲귳귴귵귶귷�".split("");for(j=0;j!=D[130].length;++j)if(D[130][j].charCodeAt(0)!==65533){e[D[130][j]]=130*256+j;d[130*256+j]=D[130][j]}D[131]="�����������������������������������������������������������������귺귻귽귾긂긃긄긅긆긇긊긌긎긏긐긑긒긓긕긖긗긘긙긚긛긜������긝긞긟긠긡긢긣긤긥긦긧긨긩긪긫긬긭긮긯긲긳긵긶긹긻긼������긽긾긿깂깄깇깈깉깋깏깑깒깓깕깗깘깙깚깛깞깢깣깤깦깧깪깫깭깮깯깱깲깳깴깵깶깷깺깾깿꺀꺁꺂꺃꺆꺇꺈꺉꺊꺋꺍꺎꺏꺐꺑꺒꺓꺔꺕꺖꺗꺘꺙꺚꺛꺜꺝꺞꺟꺠꺡꺢꺣꺤꺥꺦꺧꺨꺩꺪꺫꺬꺭꺮꺯꺰꺱꺲꺳꺴꺵꺶꺷꺸꺹꺺꺻꺿껁껂껃껅껆껇껈껉껊껋껎껒껓껔껕껖껗껚껛껝껞껟껠껡껢껣껤껥�".split("");for(j=0;j!=D[131].length;++j)if(D[131][j].charCodeAt(0)!==65533){e[D[131][j]]=131*256+j;d[131*256+j]=D[131][j]}D[132]="�����������������������������������������������������������������껦껧껩껪껬껮껯껰껱껲껳껵껶껷껹껺껻껽껾껿꼀꼁꼂꼃꼄꼅������꼆꼉꼊꼋꼌꼎꼏꼑꼒꼓꼔꼕꼖꼗꼘꼙꼚꼛꼜꼝꼞꼟꼠꼡꼢꼣������꼤꼥꼦꼧꼨꼩꼪꼫꼮꼯꼱꼳꼵꼶꼷꼸꼹꼺꼻꼾꽀꽄꽅꽆꽇꽊꽋꽌꽍꽎꽏꽑꽒꽓꽔꽕꽖꽗꽘꽙꽚꽛꽞꽟꽠꽡꽢꽣꽦꽧꽨꽩꽪꽫꽬꽭꽮꽯꽰꽱꽲꽳꽴꽵꽶꽷꽸꽺꽻꽼꽽꽾꽿꾁꾂꾃꾅꾆꾇꾉꾊꾋꾌꾍꾎꾏꾒꾓꾔꾖꾗꾘꾙꾚꾛꾝꾞꾟꾠꾡꾢꾣꾤꾥꾦꾧꾨꾩꾪꾫꾬꾭꾮꾯꾰꾱꾲꾳꾴꾵꾶꾷꾺꾻꾽꾾�".split("");for(j=0;j!=D[132].length;++j)if(D[132][j].charCodeAt(0)!==65533){e[D[132][j]]=132*256+j;d[132*256+j]=D[132][j]}D[133]="�����������������������������������������������������������������꾿꿁꿂꿃꿄꿅꿆꿊꿌꿏꿐꿑꿒꿓꿕꿖꿗꿘꿙꿚꿛꿝꿞꿟꿠꿡������꿢꿣꿤꿥꿦꿧꿪꿫꿬꿭꿮꿯꿲꿳꿵꿶꿷꿹꿺꿻꿼꿽꿾꿿뀂뀃������뀅뀆뀇뀈뀉뀊뀋뀍뀎뀏뀑뀒뀓뀕뀖뀗뀘뀙뀚뀛뀞뀟뀠뀡뀢뀣뀤뀥뀦뀧뀩뀪뀫뀬뀭뀮뀯뀰뀱뀲뀳뀴뀵뀶뀷뀸뀹뀺뀻뀼뀽뀾뀿끀끁끂끃끆끇끉끋끍끏끐끑끒끖끘끚끛끜끞끟끠끡끢끣끤끥끦끧끨끩끪끫끬끭끮끯끰끱끲끳끴끵끶끷끸끹끺끻끾끿낁낂낃낅낆낇낈낉낊낋낎낐낒낓낔낕낖낗낛낝낞낣낤�".split("");for(j=0;j!=D[133].length;++j)if(D[133][j].charCodeAt(0)!==65533){e[D[133][j]]=133*256+j;d[133*256+j]=D[133][j]}D[134]="�����������������������������������������������������������������낥낦낧낪낰낲낶낷낹낺낻낽낾낿냀냁냂냃냆냊냋냌냍냎냏냒������냓냕냖냗냙냚냛냜냝냞냟냡냢냣냤냦냧냨냩냪냫냬냭냮냯냰������냱냲냳냴냵냶냷냸냹냺냻냼냽냾냿넀넁넂넃넄넅넆넇넊넍넎넏넑넔넕넖넗넚넞넟넠넡넢넦넧넩넪넫넭넮넯넰넱넲넳넶넺넻넼넽넾넿녂녃녅녆녇녉녊녋녌녍녎녏녒녓녖녗녙녚녛녝녞녟녡녢녣녤녥녦녧녨녩녪녫녬녭녮녯녰녱녲녳녴녵녶녷녺녻녽녾녿놁놃놄놅놆놇놊놌놎놏놐놑놕놖놗놙놚놛놝�".split("");for(j=0;j!=D[134].length;++j)if(D[134][j].charCodeAt(0)!==65533){e[D[134][j]]=134*256+j;d[134*256+j]=D[134][j]}D[135]="�����������������������������������������������������������������놞놟놠놡놢놣놤놥놦놧놩놪놫놬놭놮놯놰놱놲놳놴놵놶놷놸������놹놺놻놼놽놾놿뇀뇁뇂뇃뇄뇅뇆뇇뇈뇉뇊뇋뇍뇎뇏뇑뇒뇓뇕������뇖뇗뇘뇙뇚뇛뇞뇠뇡뇢뇣뇤뇥뇦뇧뇪뇫뇭뇮뇯뇱뇲뇳뇴뇵뇶뇷뇸뇺뇼뇾뇿눀눁눂눃눆눇눉눊눍눎눏눐눑눒눓눖눘눚눛눜눝눞눟눡눢눣눤눥눦눧눨눩눪눫눬눭눮눯눰눱눲눳눵눶눷눸눹눺눻눽눾눿뉀뉁뉂뉃뉄뉅뉆뉇뉈뉉뉊뉋뉌뉍뉎뉏뉐뉑뉒뉓뉔뉕뉖뉗뉙뉚뉛뉝뉞뉟뉡뉢뉣뉤뉥뉦뉧뉪뉫뉬뉭뉮�".split("");for(j=0;j!=D[135].length;++j)if(D[135][j].charCodeAt(0)!==65533){e[D[135][j]]=135*256+j;d[135*256+j]=D[135][j]}D[136]="�����������������������������������������������������������������뉯뉰뉱뉲뉳뉶뉷뉸뉹뉺뉻뉽뉾뉿늀늁늂늃늆늇늈늊늋늌늍늎������늏늒늓늕늖늗늛늜늝늞늟늢늤늧늨늩늫늭늮늯늱늲늳늵늶늷������늸늹늺늻늼늽늾늿닀닁닂닃닄닅닆닇닊닋닍닎닏닑닓닔닕닖닗닚닜닞닟닠닡닣닧닩닪닰닱닲닶닼닽닾댂댃댅댆댇댉댊댋댌댍댎댏댒댖댗댘댙댚댛댝댞댟댠댡댢댣댤댥댦댧댨댩댪댫댬댭댮댯댰댱댲댳댴댵댶댷댸댹댺댻댼댽댾댿덀덁덂덃덄덅덆덇덈덉덊덋덌덍덎덏덐덑덒덓덗덙덚덝덠덡덢덣�".split("");for(j=0;j!=D[136].length;++j)if(D[136][j].charCodeAt(0)!==65533){e[D[136][j]]=136*256+j;d[136*256+j]=D[136][j]}D[137]="�����������������������������������������������������������������덦덨덪덬덭덯덲덳덵덶덷덹덺덻덼덽덾덿뎂뎆뎇뎈뎉뎊뎋뎍������뎎뎏뎑뎒뎓뎕뎖뎗뎘뎙뎚뎛뎜뎝뎞뎟뎢뎣뎤뎥뎦뎧뎩뎪뎫뎭������뎮뎯뎰뎱뎲뎳뎴뎵뎶뎷뎸뎹뎺뎻뎼뎽뎾뎿돀돁돂돃돆돇돉돊돍돏돑돒돓돖돘돚돜돞돟돡돢돣돥돦돧돩돪돫돬돭돮돯돰돱돲돳돴돵돶돷돸돹돺돻돽돾돿됀됁됂됃됄됅됆됇됈됉됊됋됌됍됎됏됑됒됓됔됕됖됗됙됚됛됝됞됟됡됢됣됤됥됦됧됪됬됭됮됯됰됱됲됳됵됶됷됸됹됺됻됼됽됾됿둀둁둂둃둄�".split("");for(j=0;j!=D[137].length;++j)if(D[137][j].charCodeAt(0)!==65533){e[D[137][j]]=137*256+j;d[137*256+j]=D[137][j]}D[138]="�����������������������������������������������������������������둅둆둇둈둉둊둋둌둍둎둏둒둓둕둖둗둙둚둛둜둝둞둟둢둤둦������둧둨둩둪둫둭둮둯둰둱둲둳둴둵둶둷둸둹둺둻둼둽둾둿뒁뒂������뒃뒄뒅뒆뒇뒉뒊뒋뒌뒍뒎뒏뒐뒑뒒뒓뒔뒕뒖뒗뒘뒙뒚뒛뒜뒞뒟뒠뒡뒢뒣뒥뒦뒧뒩뒪뒫뒭뒮뒯뒰뒱뒲뒳뒴뒶뒸뒺뒻뒼뒽뒾뒿듁듂듃듅듆듇듉듊듋듌듍듎듏듑듒듓듔듖듗듘듙듚듛듞듟듡듢듥듧듨듩듪듫듮듰듲듳듴듵듶듷듹듺듻듼듽듾듿딀딁딂딃딄딅딆딇딈딉딊딋딌딍딎딏딐딑딒딓딖딗딙딚딝�".split("");for(j=0;j!=D[138].length;++j)if(D[138][j].charCodeAt(0)!==65533){e[D[138][j]]=138*256+j;d[138*256+j]=D[138][j]}D[139]="�����������������������������������������������������������������딞딟딠딡딢딣딦딫딬딭딮딯딲딳딵딶딷딹딺딻딼딽딾딿땂땆������땇땈땉땊땎땏땑땒땓땕땖땗땘땙땚땛땞땢땣땤땥땦땧땨땩땪������땫땬땭땮땯땰땱땲땳땴땵땶땷땸땹땺땻땼땽땾땿떀떁떂떃떄떅떆떇떈떉떊떋떌떍떎떏떐떑떒떓떔떕떖떗떘떙떚떛떜떝떞떟떢떣떥떦떧떩떬떭떮떯떲떶떷떸떹떺떾떿뗁뗂뗃뗅뗆뗇뗈뗉뗊뗋뗎뗒뗓뗔뗕뗖뗗뗙뗚뗛뗜뗝뗞뗟뗠뗡뗢뗣뗤뗥뗦뗧뗨뗩뗪뗫뗭뗮뗯뗰뗱뗲뗳뗴뗵뗶뗷뗸뗹뗺뗻뗼뗽뗾뗿�".split("");for(j=0;j!=D[139].length;++j)if(D[139][j].charCodeAt(0)!==65533){e[D[139][j]]=139*256+j;d[139*256+j]=D[139][j]}D[140]="�����������������������������������������������������������������똀똁똂똃똄똅똆똇똈똉똊똋똌똍똎똏똒똓똕똖똗똙똚똛똜똝������똞똟똠똡똢똣똤똦똧똨똩똪똫똭똮똯똰똱똲똳똵똶똷똸똹똺������똻똼똽똾똿뙀뙁뙂뙃뙄뙅뙆뙇뙉뙊뙋뙌뙍뙎뙏뙐뙑뙒뙓뙔뙕뙖뙗뙘뙙뙚뙛뙜뙝뙞뙟뙠뙡뙢뙣뙥뙦뙧뙩뙪뙫뙬뙭뙮뙯뙰뙱뙲뙳뙴뙵뙶뙷뙸뙹뙺뙻뙼뙽뙾뙿뚀뚁뚂뚃뚄뚅뚆뚇뚈뚉뚊뚋뚌뚍뚎뚏뚐뚑뚒뚓뚔뚕뚖뚗뚘뚙뚚뚛뚞뚟뚡뚢뚣뚥뚦뚧뚨뚩뚪뚭뚮뚯뚰뚲뚳뚴뚵뚶뚷뚸뚹뚺뚻뚼뚽뚾뚿뛀뛁뛂�".split("");for(j=0;j!=D[140].length;++j)if(D[140][j].charCodeAt(0)!==65533){e[D[140][j]]=140*256+j;d[140*256+j]=D[140][j]}D[141]="�����������������������������������������������������������������뛃뛄뛅뛆뛇뛈뛉뛊뛋뛌뛍뛎뛏뛐뛑뛒뛓뛕뛖뛗뛘뛙뛚뛛뛜뛝������뛞뛟뛠뛡뛢뛣뛤뛥뛦뛧뛨뛩뛪뛫뛬뛭뛮뛯뛱뛲뛳뛵뛶뛷뛹뛺������뛻뛼뛽뛾뛿뜂뜃뜄뜆뜇뜈뜉뜊뜋뜌뜍뜎뜏뜐뜑뜒뜓뜔뜕뜖뜗뜘뜙뜚뜛뜜뜝뜞뜟뜠뜡뜢뜣뜤뜥뜦뜧뜪뜫뜭뜮뜱뜲뜳뜴뜵뜶뜷뜺뜼뜽뜾뜿띀띁띂띃띅띆띇띉띊띋띍띎띏띐띑띒띓띖띗띘띙띚띛띜띝띞띟띡띢띣띥띦띧띩띪띫띬띭띮띯띲띴띶띷띸띹띺띻띾띿랁랂랃랅랆랇랈랉랊랋랎랓랔랕랚랛랝랞�".split("");for(j=0;j!=D[141].length;++j)if(D[141][j].charCodeAt(0)!==65533){e[D[141][j]]=141*256+j;d[141*256+j]=D[141][j]}D[142]="�����������������������������������������������������������������랟랡랢랣랤랥랦랧랪랮랯랰랱랲랳랶랷랹랺랻랼랽랾랿럀럁������럂럃럄럅럆럈럊럋럌럍럎럏럐럑럒럓럔럕럖럗럘럙럚럛럜럝������럞럟럠럡럢럣럤럥럦럧럨럩럪럫럮럯럱럲럳럵럶럷럸럹럺럻럾렂렃렄렅렆렊렋렍렎렏렑렒렓렔렕렖렗렚렜렞렟렠렡렢렣렦렧렩렪렫렭렮렯렰렱렲렳렶렺렻렼렽렾렿롁롂롃롅롆롇롈롉롊롋롌롍롎롏롐롒롔롕롖롗롘롙롚롛롞롟롡롢롣롥롦롧롨롩롪롫롮롰롲롳롴롵롶롷롹롺롻롽롾롿뢀뢁뢂뢃뢄�".split("");for(j=0;j!=D[142].length;++j)if(D[142][j].charCodeAt(0)!==65533){e[D[142][j]]=142*256+j;d[142*256+j]=D[142][j]}D[143]="�����������������������������������������������������������������뢅뢆뢇뢈뢉뢊뢋뢌뢎뢏뢐뢑뢒뢓뢔뢕뢖뢗뢘뢙뢚뢛뢜뢝뢞뢟������뢠뢡뢢뢣뢤뢥뢦뢧뢩뢪뢫뢬뢭뢮뢯뢱뢲뢳뢵뢶뢷뢹뢺뢻뢼뢽������뢾뢿룂룄룆룇룈룉룊룋룍룎룏룑룒룓룕룖룗룘룙룚룛룜룞룠룢룣룤룥룦룧룪룫룭룮룯룱룲룳룴룵룶룷룺룼룾룿뤀뤁뤂뤃뤅뤆뤇뤈뤉뤊뤋뤌뤍뤎뤏뤐뤑뤒뤓뤔뤕뤖뤗뤙뤚뤛뤜뤝뤞뤟뤡뤢뤣뤤뤥뤦뤧뤨뤩뤪뤫뤬뤭뤮뤯뤰뤱뤲뤳뤴뤵뤶뤷뤸뤹뤺뤻뤾뤿륁륂륃륅륆륇륈륉륊륋륍륎륐륒륓륔륕륖륗�".split("");for(j=0;j!=D[143].length;++j)if(D[143][j].charCodeAt(0)!==65533){e[D[143][j]]=143*256+j;d[143*256+j]=D[143][j]}D[144]="�����������������������������������������������������������������륚륛륝륞륟륡륢륣륤륥륦륧륪륬륮륯륰륱륲륳륶륷륹륺륻륽������륾륿릀릁릂릃릆릈릋릌릏릐릑릒릓릔릕릖릗릘릙릚릛릜릝릞������릟릠릡릢릣릤릥릦릧릨릩릪릫릮릯릱릲릳릵릶릷릸릹릺릻릾맀맂맃맄맅맆맇맊맋맍맓맔맕맖맗맚맜맟맠맢맦맧맩맪맫맭맮맯맰맱맲맳맶맻맼맽맾맿먂먃먄먅먆먇먉먊먋먌먍먎먏먐먑먒먓먔먖먗먘먙먚먛먜먝먞먟먠먡먢먣먤먥먦먧먨먩먪먫먬먭먮먯먰먱먲먳먴먵먶먷먺먻먽먾먿멁멃멄멅멆�".split("");for(j=0;j!=D[144].length;++j)if(D[144][j].charCodeAt(0)!==65533){e[D[144][j]]=144*256+j;d[144*256+j]=D[144][j]}D[145]="�����������������������������������������������������������������멇멊멌멏멐멑멒멖멗멙멚멛멝멞멟멠멡멢멣멦멪멫멬멭멮멯������멲멳멵멶멷멹멺멻멼멽멾멿몀몁몂몆몈몉몊몋몍몎몏몐몑몒������몓몔몕몖몗몘몙몚몛몜몝몞몟몠몡몢몣몤몥몦몧몪몭몮몯몱몳몴몵몶몷몺몼몾몿뫀뫁뫂뫃뫅뫆뫇뫉뫊뫋뫌뫍뫎뫏뫐뫑뫒뫓뫔뫕뫖뫗뫚뫛뫜뫝뫞뫟뫠뫡뫢뫣뫤뫥뫦뫧뫨뫩뫪뫫뫬뫭뫮뫯뫰뫱뫲뫳뫴뫵뫶뫷뫸뫹뫺뫻뫽뫾뫿묁묂묃묅묆묇묈묉묊묋묌묎묐묒묓묔묕묖묗묙묚묛묝묞묟묡묢묣묤묥묦묧�".split("");for(j=0;j!=D[145].length;++j)if(D[145][j].charCodeAt(0)!==65533){e[D[145][j]]=145*256+j;d[145*256+j]=D[145][j]}D[146]="�����������������������������������������������������������������묨묪묬묭묮묯묰묱묲묳묷묹묺묿뭀뭁뭂뭃뭆뭈뭊뭋뭌뭎뭑뭒������뭓뭕뭖뭗뭙뭚뭛뭜뭝뭞뭟뭠뭢뭤뭥뭦뭧뭨뭩뭪뭫뭭뭮뭯뭰뭱������뭲뭳뭴뭵뭶뭷뭸뭹뭺뭻뭼뭽뭾뭿뮀뮁뮂뮃뮄뮅뮆뮇뮉뮊뮋뮍뮎뮏뮑뮒뮓뮔뮕뮖뮗뮘뮙뮚뮛뮜뮝뮞뮟뮠뮡뮢뮣뮥뮦뮧뮩뮪뮫뮭뮮뮯뮰뮱뮲뮳뮵뮶뮸뮹뮺뮻뮼뮽뮾뮿믁믂믃믅믆믇믉믊믋믌믍믎믏믑믒믔믕믖믗믘믙믚믛믜믝믞믟믠믡믢믣믤믥믦믧믨믩믪믫믬믭믮믯믰믱믲믳믴믵믶믷믺믻믽믾밁�".split("");for(j=0;j!=D[146].length;++j)if(D[146][j].charCodeAt(0)!==65533){e[D[146][j]]=146*256+j;d[146*256+j]=D[146][j]}D[147]="�����������������������������������������������������������������밃밄밅밆밇밊밎밐밒밓밙밚밠밡밢밣밦밨밪밫밬밮밯밲밳밵������밶밷밹밺밻밼밽밾밿뱂뱆뱇뱈뱊뱋뱎뱏뱑뱒뱓뱔뱕뱖뱗뱘뱙������뱚뱛뱜뱞뱟뱠뱡뱢뱣뱤뱥뱦뱧뱨뱩뱪뱫뱬뱭뱮뱯뱰뱱뱲뱳뱴뱵뱶뱷뱸뱹뱺뱻뱼뱽뱾뱿벀벁벂벃벆벇벉벊벍벏벐벑벒벓벖벘벛벜벝벞벟벢벣벥벦벩벪벫벬벭벮벯벲벶벷벸벹벺벻벾벿볁볂볃볅볆볇볈볉볊볋볌볎볒볓볔볖볗볙볚볛볝볞볟볠볡볢볣볤볥볦볧볨볩볪볫볬볭볮볯볰볱볲볳볷볹볺볻볽�".split("");for(j=0;j!=D[147].length;++j)if(D[147][j].charCodeAt(0)!==65533){e[D[147][j]]=147*256+j;d[147*256+j]=D[147][j]}D[148]="�����������������������������������������������������������������볾볿봀봁봂봃봆봈봊봋봌봍봎봏봑봒봓봕봖봗봘봙봚봛봜봝������봞봟봠봡봢봣봥봦봧봨봩봪봫봭봮봯봰봱봲봳봴봵봶봷봸봹������봺봻봼봽봾봿뵁뵂뵃뵄뵅뵆뵇뵊뵋뵍뵎뵏뵑뵒뵓뵔뵕뵖뵗뵚뵛뵜뵝뵞뵟뵠뵡뵢뵣뵥뵦뵧뵩뵪뵫뵬뵭뵮뵯뵰뵱뵲뵳뵴뵵뵶뵷뵸뵹뵺뵻뵼뵽뵾뵿붂붃붅붆붋붌붍붎붏붒붔붖붗붘붛붝붞붟붠붡붢붣붥붦붧붨붩붪붫붬붭붮붯붱붲붳붴붵붶붷붹붺붻붼붽붾붿뷀뷁뷂뷃뷄뷅뷆뷇뷈뷉뷊뷋뷌뷍뷎뷏뷐뷑�".split("");for(j=0;j!=D[148].length;++j)if(D[148][j].charCodeAt(0)!==65533){e[D[148][j]]=148*256+j;d[148*256+j]=D[148][j]}D[149]="�����������������������������������������������������������������뷒뷓뷖뷗뷙뷚뷛뷝뷞뷟뷠뷡뷢뷣뷤뷥뷦뷧뷨뷪뷫뷬뷭뷮뷯뷱������뷲뷳뷵뷶뷷뷹뷺뷻뷼뷽뷾뷿븁븂븄븆븇븈븉븊븋븎븏븑븒븓������븕븖븗븘븙븚븛븞븠븡븢븣븤븥븦븧븨븩븪븫븬븭븮븯븰븱븲븳븴븵븶븷븸븹븺븻븼븽븾븿빀빁빂빃빆빇빉빊빋빍빏빐빑빒빓빖빘빜빝빞빟빢빣빥빦빧빩빫빬빭빮빯빲빶빷빸빹빺빾빿뺁뺂뺃뺅뺆뺇뺈뺉뺊뺋뺎뺒뺓뺔뺕뺖뺗뺚뺛뺜뺝뺞뺟뺠뺡뺢뺣뺤뺥뺦뺧뺩뺪뺫뺬뺭뺮뺯뺰뺱뺲뺳뺴뺵뺶뺷�".split("");for(j=0;j!=D[149].length;++j)if(D[149][j].charCodeAt(0)!==65533){e[D[149][j]]=149*256+j;d[149*256+j]=D[149][j]}D[150]="�����������������������������������������������������������������뺸뺹뺺뺻뺼뺽뺾뺿뻀뻁뻂뻃뻄뻅뻆뻇뻈뻉뻊뻋뻌뻍뻎뻏뻒뻓������뻕뻖뻙뻚뻛뻜뻝뻞뻟뻡뻢뻦뻧뻨뻩뻪뻫뻭뻮뻯뻰뻱뻲뻳뻴뻵������뻶뻷뻸뻹뻺뻻뻼뻽뻾뻿뼀뼂뼃뼄뼅뼆뼇뼊뼋뼌뼍뼎뼏뼐뼑뼒뼓뼔뼕뼖뼗뼚뼞뼟뼠뼡뼢뼣뼤뼥뼦뼧뼨뼩뼪뼫뼬뼭뼮뼯뼰뼱뼲뼳뼴뼵뼶뼷뼸뼹뼺뼻뼼뼽뼾뼿뽂뽃뽅뽆뽇뽉뽊뽋뽌뽍뽎뽏뽒뽓뽔뽖뽗뽘뽙뽚뽛뽜뽝뽞뽟뽠뽡뽢뽣뽤뽥뽦뽧뽨뽩뽪뽫뽬뽭뽮뽯뽰뽱뽲뽳뽴뽵뽶뽷뽸뽹뽺뽻뽼뽽뽾뽿뾀뾁뾂�".split("");for(j=0;j!=D[150].length;++j)if(D[150][j].charCodeAt(0)!==65533){e[D[150][j]]=150*256+j;d[150*256+j]=D[150][j]}D[151]="�����������������������������������������������������������������뾃뾄뾅뾆뾇뾈뾉뾊뾋뾌뾍뾎뾏뾐뾑뾒뾓뾕뾖뾗뾘뾙뾚뾛뾜뾝������뾞뾟뾠뾡뾢뾣뾤뾥뾦뾧뾨뾩뾪뾫뾬뾭뾮뾯뾱뾲뾳뾴뾵뾶뾷뾸������뾹뾺뾻뾼뾽뾾뾿뿀뿁뿂뿃뿄뿆뿇뿈뿉뿊뿋뿎뿏뿑뿒뿓뿕뿖뿗뿘뿙뿚뿛뿝뿞뿠뿢뿣뿤뿥뿦뿧뿨뿩뿪뿫뿬뿭뿮뿯뿰뿱뿲뿳뿴뿵뿶뿷뿸뿹뿺뿻뿼뿽뿾뿿쀀쀁쀂쀃쀄쀅쀆쀇쀈쀉쀊쀋쀌쀍쀎쀏쀐쀑쀒쀓쀔쀕쀖쀗쀘쀙쀚쀛쀜쀝쀞쀟쀠쀡쀢쀣쀤쀥쀦쀧쀨쀩쀪쀫쀬쀭쀮쀯쀰쀱쀲쀳쀴쀵쀶쀷쀸쀹쀺쀻쀽쀾쀿�".split("");for(j=0;j!=D[151].length;++j)if(D[151][j].charCodeAt(0)!==65533){e[D[151][j]]=151*256+j;d[151*256+j]=D[151][j]}D[152]="�����������������������������������������������������������������쁀쁁쁂쁃쁄쁅쁆쁇쁈쁉쁊쁋쁌쁍쁎쁏쁐쁒쁓쁔쁕쁖쁗쁙쁚쁛������쁝쁞쁟쁡쁢쁣쁤쁥쁦쁧쁪쁫쁬쁭쁮쁯쁰쁱쁲쁳쁴쁵쁶쁷쁸쁹������쁺쁻쁼쁽쁾쁿삀삁삂삃삄삅삆삇삈삉삊삋삌삍삎삏삒삓삕삖삗삙삚삛삜삝삞삟삢삤삦삧삨삩삪삫삮삱삲삷삸삹삺삻삾샂샃샄샆샇샊샋샍샎샏샑샒샓샔샕샖샗샚샞샟샠샡샢샣샦샧샩샪샫샭샮샯샰샱샲샳샶샸샺샻샼샽샾샿섁섂섃섅섆섇섉섊섋섌섍섎섏섑섒섓섔섖섗섘섙섚섛섡섢섥섨섩섪섫섮�".split("");for(j=0;j!=D[152].length;++j)if(D[152][j].charCodeAt(0)!==65533){e[D[152][j]]=152*256+j;d[152*256+j]=D[152][j]}D[153]="�����������������������������������������������������������������섲섳섴섵섷섺섻섽섾섿셁셂셃셄셅셆셇셊셎셏셐셑셒셓셖셗������셙셚셛셝셞셟셠셡셢셣셦셪셫셬셭셮셯셱셲셳셵셶셷셹셺셻������셼셽셾셿솀솁솂솃솄솆솇솈솉솊솋솏솑솒솓솕솗솘솙솚솛솞솠솢솣솤솦솧솪솫솭솮솯솱솲솳솴솵솶솷솸솹솺솻솼솾솿쇀쇁쇂쇃쇅쇆쇇쇉쇊쇋쇍쇎쇏쇐쇑쇒쇓쇕쇖쇙쇚쇛쇜쇝쇞쇟쇡쇢쇣쇥쇦쇧쇩쇪쇫쇬쇭쇮쇯쇲쇴쇵쇶쇷쇸쇹쇺쇻쇾쇿숁숂숃숅숆숇숈숉숊숋숎숐숒숓숔숕숖숗숚숛숝숞숡숢숣�".split("");for(j=0;j!=D[153].length;++j)if(D[153][j].charCodeAt(0)!==65533){e[D[153][j]]=153*256+j;d[153*256+j]=D[153][j]}D[154]="�����������������������������������������������������������������숤숥숦숧숪숬숮숰숳숵숶숷숸숹숺숻숼숽숾숿쉀쉁쉂쉃쉄쉅������쉆쉇쉉쉊쉋쉌쉍쉎쉏쉒쉓쉕쉖쉗쉙쉚쉛쉜쉝쉞쉟쉡쉢쉣쉤쉦������쉧쉨쉩쉪쉫쉮쉯쉱쉲쉳쉵쉶쉷쉸쉹쉺쉻쉾슀슂슃슄슅슆슇슊슋슌슍슎슏슑슒슓슔슕슖슗슙슚슜슞슟슠슡슢슣슦슧슩슪슫슮슯슰슱슲슳슶슸슺슻슼슽슾슿싀싁싂싃싄싅싆싇싈싉싊싋싌싍싎싏싐싑싒싓싔싕싖싗싘싙싚싛싞싟싡싢싥싦싧싨싩싪싮싰싲싳싴싵싷싺싽싾싿쌁쌂쌃쌄쌅쌆쌇쌊쌋쌎쌏�".split("");for(j=0;j!=D[154].length;++j)if(D[154][j].charCodeAt(0)!==65533){e[D[154][j]]=154*256+j;d[154*256+j]=D[154][j]}D[155]="�����������������������������������������������������������������쌐쌑쌒쌖쌗쌙쌚쌛쌝쌞쌟쌠쌡쌢쌣쌦쌧쌪쌫쌬쌭쌮쌯쌰쌱쌲������쌳쌴쌵쌶쌷쌸쌹쌺쌻쌼쌽쌾쌿썀썁썂썃썄썆썇썈썉썊썋썌썍������썎썏썐썑썒썓썔썕썖썗썘썙썚썛썜썝썞썟썠썡썢썣썤썥썦썧썪썫썭썮썯썱썳썴썵썶썷썺썻썾썿쎀쎁쎂쎃쎅쎆쎇쎉쎊쎋쎍쎎쎏쎐쎑쎒쎓쎔쎕쎖쎗쎘쎙쎚쎛쎜쎝쎞쎟쎠쎡쎢쎣쎤쎥쎦쎧쎨쎩쎪쎫쎬쎭쎮쎯쎰쎱쎲쎳쎴쎵쎶쎷쎸쎹쎺쎻쎼쎽쎾쎿쏁쏂쏃쏄쏅쏆쏇쏈쏉쏊쏋쏌쏍쏎쏏쏐쏑쏒쏓쏔쏕쏖쏗쏚�".split("");
for(j=0;j!=D[155].length;++j)if(D[155][j].charCodeAt(0)!==65533){e[D[155][j]]=155*256+j;d[155*256+j]=D[155][j]}D[156]="�����������������������������������������������������������������쏛쏝쏞쏡쏣쏤쏥쏦쏧쏪쏫쏬쏮쏯쏰쏱쏲쏳쏶쏷쏹쏺쏻쏼쏽쏾������쏿쐀쐁쐂쐃쐄쐅쐆쐇쐉쐊쐋쐌쐍쐎쐏쐑쐒쐓쐔쐕쐖쐗쐘쐙쐚������쐛쐜쐝쐞쐟쐠쐡쐢쐣쐥쐦쐧쐨쐩쐪쐫쐭쐮쐯쐱쐲쐳쐵쐶쐷쐸쐹쐺쐻쐾쐿쑀쑁쑂쑃쑄쑅쑆쑇쑉쑊쑋쑌쑍쑎쑏쑐쑑쑒쑓쑔쑕쑖쑗쑘쑙쑚쑛쑜쑝쑞쑟쑠쑡쑢쑣쑦쑧쑩쑪쑫쑭쑮쑯쑰쑱쑲쑳쑶쑷쑸쑺쑻쑼쑽쑾쑿쒁쒂쒃쒄쒅쒆쒇쒈쒉쒊쒋쒌쒍쒎쒏쒐쒑쒒쒓쒕쒖쒗쒘쒙쒚쒛쒝쒞쒟쒠쒡쒢쒣쒤쒥쒦쒧쒨쒩�".split("");for(j=0;j!=D[156].length;++j)if(D[156][j].charCodeAt(0)!==65533){e[D[156][j]]=156*256+j;d[156*256+j]=D[156][j]}D[157]="�����������������������������������������������������������������쒪쒫쒬쒭쒮쒯쒰쒱쒲쒳쒴쒵쒶쒷쒹쒺쒻쒽쒾쒿쓀쓁쓂쓃쓄쓅������쓆쓇쓈쓉쓊쓋쓌쓍쓎쓏쓐쓑쓒쓓쓔쓕쓖쓗쓘쓙쓚쓛쓜쓝쓞쓟������쓠쓡쓢쓣쓤쓥쓦쓧쓨쓪쓫쓬쓭쓮쓯쓲쓳쓵쓶쓷쓹쓻쓼쓽쓾씂씃씄씅씆씇씈씉씊씋씍씎씏씑씒씓씕씖씗씘씙씚씛씝씞씟씠씡씢씣씤씥씦씧씪씫씭씮씯씱씲씳씴씵씶씷씺씼씾씿앀앁앂앃앆앇앋앏앐앑앒앖앚앛앜앟앢앣앥앦앧앩앪앫앬앭앮앯앲앶앷앸앹앺앻앾앿얁얂얃얅얆얈얉얊얋얎얐얒얓얔�".split("");for(j=0;j!=D[157].length;++j)if(D[157][j].charCodeAt(0)!==65533){e[D[157][j]]=157*256+j;d[157*256+j]=D[157][j]}D[158]="�����������������������������������������������������������������얖얙얚얛얝얞얟얡얢얣얤얥얦얧얨얪얫얬얭얮얯얰얱얲얳얶������얷얺얿엀엁엂엃엋엍엏엒엓엕엖엗엙엚엛엜엝엞엟엢엤엦엧������엨엩엪엫엯엱엲엳엵엸엹엺엻옂옃옄옉옊옋옍옎옏옑옒옓옔옕옖옗옚옝옞옟옠옡옢옣옦옧옩옪옫옯옱옲옶옸옺옼옽옾옿왂왃왅왆왇왉왊왋왌왍왎왏왒왖왗왘왙왚왛왞왟왡왢왣왤왥왦왧왨왩왪왫왭왮왰왲왳왴왵왶왷왺왻왽왾왿욁욂욃욄욅욆욇욊욌욎욏욐욑욒욓욖욗욙욚욛욝욞욟욠욡욢욣욦�".split("");for(j=0;j!=D[158].length;++j)if(D[158][j].charCodeAt(0)!==65533){e[D[158][j]]=158*256+j;d[158*256+j]=D[158][j]}D[159]="�����������������������������������������������������������������욨욪욫욬욭욮욯욲욳욵욶욷욻욼욽욾욿웂웄웆웇웈웉웊웋웎������웏웑웒웓웕웖웗웘웙웚웛웞웟웢웣웤웥웦웧웪웫웭웮웯웱웲������웳웴웵웶웷웺웻웼웾웿윀윁윂윃윆윇윉윊윋윍윎윏윐윑윒윓윖윘윚윛윜윝윞윟윢윣윥윦윧윩윪윫윬윭윮윯윲윴윶윸윹윺윻윾윿읁읂읃읅읆읇읈읉읋읎읐읙읚읛읝읞읟읡읢읣읤읥읦읧읩읪읬읭읮읯읰읱읲읳읶읷읹읺읻읿잀잁잂잆잋잌잍잏잒잓잕잙잛잜잝잞잟잢잧잨잩잪잫잮잯잱잲잳잵잶잷�".split("");for(j=0;j!=D[159].length;++j)if(D[159][j].charCodeAt(0)!==65533){e[D[159][j]]=159*256+j;d[159*256+j]=D[159][j]}D[160]="�����������������������������������������������������������������잸잹잺잻잾쟂쟃쟄쟅쟆쟇쟊쟋쟍쟏쟑쟒쟓쟔쟕쟖쟗쟙쟚쟛쟜������쟞쟟쟠쟡쟢쟣쟥쟦쟧쟩쟪쟫쟭쟮쟯쟰쟱쟲쟳쟴쟵쟶쟷쟸쟹쟺������쟻쟼쟽쟾쟿젂젃젅젆젇젉젋젌젍젎젏젒젔젗젘젙젚젛젞젟젡젢젣젥젦젧젨젩젪젫젮젰젲젳젴젵젶젷젹젺젻젽젾젿졁졂졃졄졅졆졇졊졋졎졏졐졑졒졓졕졖졗졘졙졚졛졜졝졞졟졠졡졢졣졤졥졦졧졨졩졪졫졬졭졮졯졲졳졵졶졷졹졻졼졽졾졿좂좄좈좉좊좎좏좐좑좒좓좕좖좗좘좙좚좛좜좞좠좢좣좤�".split("");for(j=0;j!=D[160].length;++j)if(D[160][j].charCodeAt(0)!==65533){e[D[160][j]]=160*256+j;d[160*256+j]=D[160][j]}D[161]="�����������������������������������������������������������������좥좦좧좩좪좫좬좭좮좯좰좱좲좳좴좵좶좷좸좹좺좻좾좿죀죁������죂죃죅죆죇죉죊죋죍죎죏죐죑죒죓죖죘죚죛죜죝죞죟죢죣죥������죦죧죨죩죪죫죬죭죮죯죰죱죲죳죴죶죷죸죹죺죻죾죿줁줂줃줇줈줉줊줋줎　、。·‥…¨〃­―∥＼∼‘’“”〔〕〈〉《》「」『』【】±×÷≠≤≥∞∴°′″℃Å￠￡￥♂♀∠⊥⌒∂∇≡≒§※☆★○●◎◇◆□■△▲▽▼→←↑↓↔〓≪≫√∽∝∵∫∬∈∋⊆⊇⊂⊃∪∩∧∨￢�".split("");for(j=0;j!=D[161].length;++j)if(D[161][j].charCodeAt(0)!==65533){e[D[161][j]]=161*256+j;d[161*256+j]=D[161][j]}D[162]="�����������������������������������������������������������������줐줒줓줔줕줖줗줙줚줛줜줝줞줟줠줡줢줣줤줥줦줧줨줩줪줫������줭줮줯줰줱줲줳줵줶줷줸줹줺줻줼줽줾줿쥀쥁쥂쥃쥄쥅쥆쥇������쥈쥉쥊쥋쥌쥍쥎쥏쥒쥓쥕쥖쥗쥙쥚쥛쥜쥝쥞쥟쥢쥤쥥쥦쥧쥨쥩쥪쥫쥭쥮쥯⇒⇔∀∃´～ˇ˘˝˚˙¸˛¡¿ː∮∑∏¤℉‰◁◀▷▶♤♠♡♥♧♣⊙◈▣◐◑▒▤▥▨▧▦▩♨☏☎☜☞¶†‡↕↗↙↖↘♭♩♪♬㉿㈜№㏇™㏂㏘℡€®������������������������".split("");for(j=0;j!=D[162].length;++j)if(D[162][j].charCodeAt(0)!==65533){e[D[162][j]]=162*256+j;d[162*256+j]=D[162][j]}D[163]="�����������������������������������������������������������������쥱쥲쥳쥵쥶쥷쥸쥹쥺쥻쥽쥾쥿즀즁즂즃즄즅즆즇즊즋즍즎즏������즑즒즓즔즕즖즗즚즜즞즟즠즡즢즣즤즥즦즧즨즩즪즫즬즭즮������즯즰즱즲즳즴즵즶즷즸즹즺즻즼즽즾즿짂짃짅짆짉짋짌짍짎짏짒짔짗짘짛！＂＃＄％＆＇（）＊＋，－．／０１２３４５６７８９：；＜＝＞？＠ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ［￦］＾＿｀ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ｛｜｝￣�".split("");for(j=0;j!=D[163].length;++j)if(D[163][j].charCodeAt(0)!==65533){e[D[163][j]]=163*256+j;d[163*256+j]=D[163][j]}D[164]="�����������������������������������������������������������������짞짟짡짣짥짦짨짩짪짫짮짲짳짴짵짶짷짺짻짽짾짿쨁쨂쨃쨄������쨅쨆쨇쨊쨎쨏쨐쨑쨒쨓쨕쨖쨗쨙쨚쨛쨜쨝쨞쨟쨠쨡쨢쨣쨤쨥������쨦쨧쨨쨪쨫쨬쨭쨮쨯쨰쨱쨲쨳쨴쨵쨶쨷쨸쨹쨺쨻쨼쨽쨾쨿쩀쩁쩂쩃쩄쩅쩆ㄱㄲㄳㄴㄵㄶㄷㄸㄹㄺㄻㄼㄽㄾㄿㅀㅁㅂㅃㅄㅅㅆㅇㅈㅉㅊㅋㅌㅍㅎㅏㅐㅑㅒㅓㅔㅕㅖㅗㅘㅙㅚㅛㅜㅝㅞㅟㅠㅡㅢㅣㅤㅥㅦㅧㅨㅩㅪㅫㅬㅭㅮㅯㅰㅱㅲㅳㅴㅵㅶㅷㅸㅹㅺㅻㅼㅽㅾㅿㆀㆁㆂㆃㆄㆅㆆㆇㆈㆉㆊㆋㆌㆍㆎ�".split("");for(j=0;j!=D[164].length;++j)if(D[164][j].charCodeAt(0)!==65533){e[D[164][j]]=164*256+j;d[164*256+j]=D[164][j]}D[165]="�����������������������������������������������������������������쩇쩈쩉쩊쩋쩎쩏쩑쩒쩓쩕쩖쩗쩘쩙쩚쩛쩞쩢쩣쩤쩥쩦쩧쩩쩪������쩫쩬쩭쩮쩯쩰쩱쩲쩳쩴쩵쩶쩷쩸쩹쩺쩻쩼쩾쩿쪀쪁쪂쪃쪅쪆������쪇쪈쪉쪊쪋쪌쪍쪎쪏쪐쪑쪒쪓쪔쪕쪖쪗쪙쪚쪛쪜쪝쪞쪟쪠쪡쪢쪣쪤쪥쪦쪧ⅰⅱⅲⅳⅴⅵⅶⅷⅸⅹ�����ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ�������ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩ��������αβγδεζηθικλμνξοπρστυφχψω�������".split("");for(j=0;j!=D[165].length;++j)if(D[165][j].charCodeAt(0)!==65533){e[D[165][j]]=165*256+j;d[165*256+j]=D[165][j]}D[166]="�����������������������������������������������������������������쪨쪩쪪쪫쪬쪭쪮쪯쪰쪱쪲쪳쪴쪵쪶쪷쪸쪹쪺쪻쪾쪿쫁쫂쫃쫅������쫆쫇쫈쫉쫊쫋쫎쫐쫒쫔쫕쫖쫗쫚쫛쫜쫝쫞쫟쫡쫢쫣쫤쫥쫦쫧������쫨쫩쫪쫫쫭쫮쫯쫰쫱쫲쫳쫵쫶쫷쫸쫹쫺쫻쫼쫽쫾쫿쬀쬁쬂쬃쬄쬅쬆쬇쬉쬊─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂┒┑┚┙┖┕┎┍┞┟┡┢┦┧┩┪┭┮┱┲┵┶┹┺┽┾╀╁╃╄╅╆╇╈╉╊���������������������������".split("");for(j=0;j!=D[166].length;++j)if(D[166][j].charCodeAt(0)!==65533){e[D[166][j]]=166*256+j;d[166*256+j]=D[166][j]}D[167]="�����������������������������������������������������������������쬋쬌쬍쬎쬏쬑쬒쬓쬕쬖쬗쬙쬚쬛쬜쬝쬞쬟쬢쬣쬤쬥쬦쬧쬨쬩������쬪쬫쬬쬭쬮쬯쬰쬱쬲쬳쬴쬵쬶쬷쬸쬹쬺쬻쬼쬽쬾쬿쭀쭂쭃쭄������쭅쭆쭇쭊쭋쭍쭎쭏쭑쭒쭓쭔쭕쭖쭗쭚쭛쭜쭞쭟쭠쭡쭢쭣쭥쭦쭧쭨쭩쭪쭫쭬㎕㎖㎗ℓ㎘㏄㎣㎤㎥㎦㎙㎚㎛㎜㎝㎞㎟㎠㎡㎢㏊㎍㎎㎏㏏㎈㎉㏈㎧㎨㎰㎱㎲㎳㎴㎵㎶㎷㎸㎹㎀㎁㎂㎃㎄㎺㎻㎼㎽㎾㎿㎐㎑㎒㎓㎔Ω㏀㏁㎊㎋㎌㏖㏅㎭㎮㎯㏛㎩㎪㎫㎬㏝㏐㏓㏃㏉㏜㏆����������������".split("");for(j=0;j!=D[167].length;++j)if(D[167][j].charCodeAt(0)!==65533){e[D[167][j]]=167*256+j;d[167*256+j]=D[167][j]}D[168]="�����������������������������������������������������������������쭭쭮쭯쭰쭱쭲쭳쭴쭵쭶쭷쭺쭻쭼쭽쭾쭿쮀쮁쮂쮃쮄쮅쮆쮇쮈������쮉쮊쮋쮌쮍쮎쮏쮐쮑쮒쮓쮔쮕쮖쮗쮘쮙쮚쮛쮝쮞쮟쮠쮡쮢쮣������쮤쮥쮦쮧쮨쮩쮪쮫쮬쮭쮮쮯쮰쮱쮲쮳쮴쮵쮶쮷쮹쮺쮻쮼쮽쮾쮿쯀쯁쯂쯃쯄ÆÐªĦ�Ĳ�ĿŁØŒºÞŦŊ�㉠㉡㉢㉣㉤㉥㉦㉧㉨㉩㉪㉫㉬㉭㉮㉯㉰㉱㉲㉳㉴㉵㉶㉷㉸㉹㉺㉻ⓐⓑⓒⓓⓔⓕⓖⓗⓘⓙⓚⓛⓜⓝⓞⓟⓠⓡⓢⓣⓤⓥⓦⓧⓨⓩ①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮½⅓⅔¼¾⅛⅜⅝⅞�".split("");for(j=0;j!=D[168].length;++j)if(D[168][j].charCodeAt(0)!==65533){e[D[168][j]]=168*256+j;d[168*256+j]=D[168][j]}D[169]="�����������������������������������������������������������������쯅쯆쯇쯈쯉쯊쯋쯌쯍쯎쯏쯐쯑쯒쯓쯕쯖쯗쯘쯙쯚쯛쯜쯝쯞쯟������쯠쯡쯢쯣쯥쯦쯨쯪쯫쯬쯭쯮쯯쯰쯱쯲쯳쯴쯵쯶쯷쯸쯹쯺쯻쯼������쯽쯾쯿찀찁찂찃찄찅찆찇찈찉찊찋찎찏찑찒찓찕찖찗찘찙찚찛찞찟찠찣찤æđðħıĳĸŀłøœßþŧŋŉ㈀㈁㈂㈃㈄㈅㈆㈇㈈㈉㈊㈋㈌㈍㈎㈏㈐㈑㈒㈓㈔㈕㈖㈗㈘㈙㈚㈛⒜⒝⒞⒟⒠⒡⒢⒣⒤⒥⒦⒧⒨⒩⒪⒫⒬⒭⒮⒯⒰⒱⒲⒳⒴⒵⑴⑵⑶⑷⑸⑹⑺⑻⑼⑽⑾⑿⒀⒁⒂¹²³⁴ⁿ₁₂₃₄�".split("");for(j=0;j!=D[169].length;++j)if(D[169][j].charCodeAt(0)!==65533){e[D[169][j]]=169*256+j;d[169*256+j]=D[169][j]}D[170]="�����������������������������������������������������������������찥찦찪찫찭찯찱찲찳찴찵찶찷찺찿챀챁챂챃챆챇챉챊챋챍챎������챏챐챑챒챓챖챚챛챜챝챞챟챡챢챣챥챧챩챪챫챬챭챮챯챱챲������챳챴챶챷챸챹챺챻챼챽챾챿첀첁첂첃첄첅첆첇첈첉첊첋첌첍첎첏첐첑첒첓ぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞただちぢっつづてでとどなにぬねのはばぱひびぴふぶぷへべぺほぼぽまみむめもゃやゅゆょよらりるれろゎわゐゑをん������������".split("");for(j=0;j!=D[170].length;++j)if(D[170][j].charCodeAt(0)!==65533){e[D[170][j]]=170*256+j;d[170*256+j]=D[170][j]}D[171]="�����������������������������������������������������������������첔첕첖첗첚첛첝첞첟첡첢첣첤첥첦첧첪첮첯첰첱첲첳첶첷첹������첺첻첽첾첿쳀쳁쳂쳃쳆쳈쳊쳋쳌쳍쳎쳏쳑쳒쳓쳕쳖쳗쳘쳙쳚������쳛쳜쳝쳞쳟쳠쳡쳢쳣쳥쳦쳧쳨쳩쳪쳫쳭쳮쳯쳱쳲쳳쳴쳵쳶쳷쳸쳹쳺쳻쳼쳽ァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾタダチヂッツヅテデトドナニヌネノハバパヒビピフブプヘベペホボポマミムメモャヤュユョヨラリルレロヮワヰヱヲンヴヵヶ���������".split("");for(j=0;j!=D[171].length;++j)if(D[171][j].charCodeAt(0)!==65533){e[D[171][j]]=171*256+j;d[171*256+j]=D[171][j]}D[172]="�����������������������������������������������������������������쳾쳿촀촂촃촄촅촆촇촊촋촍촎촏촑촒촓촔촕촖촗촚촜촞촟촠������촡촢촣촥촦촧촩촪촫촭촮촯촰촱촲촳촴촵촶촷촸촺촻촼촽촾������촿쵀쵁쵂쵃쵄쵅쵆쵇쵈쵉쵊쵋쵌쵍쵎쵏쵐쵑쵒쵓쵔쵕쵖쵗쵘쵙쵚쵛쵝쵞쵟АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ���������������абвгдеёжзийклмнопрстуфхцчшщъыьэюя��������������".split("");for(j=0;j!=D[172].length;++j)if(D[172][j].charCodeAt(0)!==65533){e[D[172][j]]=172*256+j;d[172*256+j]=D[172][j]}D[173]="�����������������������������������������������������������������쵡쵢쵣쵥쵦쵧쵨쵩쵪쵫쵮쵰쵲쵳쵴쵵쵶쵷쵹쵺쵻쵼쵽쵾쵿춀������춁춂춃춄춅춆춇춉춊춋춌춍춎춏춐춑춒춓춖춗춙춚춛춝춞춟������춠춡춢춣춦춨춪춫춬춭춮춯춱춲춳춴춵춶춷춸춹춺춻춼춽춾춿췀췁췂췃췅�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[173].length;++j)if(D[173][j].charCodeAt(0)!==65533){e[D[173][j]]=173*256+j;d[173*256+j]=D[173][j]}D[174]="�����������������������������������������������������������������췆췇췈췉췊췋췍췎췏췑췒췓췔췕췖췗췘췙췚췛췜췝췞췟췠췡������췢췣췤췥췦췧췩췪췫췭췮췯췱췲췳췴췵췶췷췺췼췾췿츀츁츂������츃츅츆츇츉츊츋츍츎츏츐츑츒츓츕츖츗츘츚츛츜츝츞츟츢츣츥츦츧츩츪츫�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[174].length;++j)if(D[174][j].charCodeAt(0)!==65533){e[D[174][j]]=174*256+j;d[174*256+j]=D[174][j]}D[175]="�����������������������������������������������������������������츬츭츮츯츲츴츶츷츸츹츺츻츼츽츾츿칀칁칂칃칄칅칆칇칈칉������칊칋칌칍칎칏칐칑칒칓칔칕칖칗칚칛칝칞칢칣칤칥칦칧칪칬������칮칯칰칱칲칳칶칷칹칺칻칽칾칿캀캁캂캃캆캈캊캋캌캍캎캏캒캓캕캖캗캙�����������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[175].length;++j)if(D[175][j].charCodeAt(0)!==65533){e[D[175][j]]=175*256+j;d[175*256+j]=D[175][j]}D[176]="�����������������������������������������������������������������캚캛캜캝캞캟캢캦캧캨캩캪캫캮캯캰캱캲캳캴캵캶캷캸캹캺������캻캼캽캾캿컀컂컃컄컅컆컇컈컉컊컋컌컍컎컏컐컑컒컓컔컕������컖컗컘컙컚컛컜컝컞컟컠컡컢컣컦컧컩컪컭컮컯컰컱컲컳컶컺컻컼컽컾컿가각간갇갈갉갊감갑값갓갔강갖갗같갚갛개객갠갤갬갭갯갰갱갸갹갼걀걋걍걔걘걜거걱건걷걸걺검겁것겄겅겆겉겊겋게겐겔겜겝겟겠겡겨격겪견겯결겸겹겻겼경곁계곈곌곕곗고곡곤곧골곪곬곯곰곱곳공곶과곽관괄괆�".split("");for(j=0;j!=D[176].length;++j)if(D[176][j].charCodeAt(0)!==65533){e[D[176][j]]=176*256+j;d[176*256+j]=D[176][j]}D[177]="�����������������������������������������������������������������켂켃켅켆켇켉켊켋켌켍켎켏켒켔켖켗켘켙켚켛켝켞켟켡켢켣������켥켦켧켨켩켪켫켮켲켳켴켵켶켷켹켺켻켼켽켾켿콀콁콂콃콄������콅콆콇콈콉콊콋콌콍콎콏콐콑콒콓콖콗콙콚콛콝콞콟콠콡콢콣콦콨콪콫콬괌괍괏광괘괜괠괩괬괭괴괵괸괼굄굅굇굉교굔굘굡굣구국군굳굴굵굶굻굼굽굿궁궂궈궉권궐궜궝궤궷귀귁귄귈귐귑귓규균귤그극근귿글긁금급긋긍긔기긱긴긷길긺김깁깃깅깆깊까깍깎깐깔깖깜깝깟깠깡깥깨깩깬깰깸�".split("");for(j=0;j!=D[177].length;++j)if(D[177][j].charCodeAt(0)!==65533){e[D[177][j]]=177*256+j;d[177*256+j]=D[177][j]}D[178]="�����������������������������������������������������������������콭콮콯콲콳콵콶콷콹콺콻콼콽콾콿쾁쾂쾃쾄쾆쾇쾈쾉쾊쾋쾍������쾎쾏쾐쾑쾒쾓쾔쾕쾖쾗쾘쾙쾚쾛쾜쾝쾞쾟쾠쾢쾣쾤쾥쾦쾧쾩������쾪쾫쾬쾭쾮쾯쾱쾲쾳쾴쾵쾶쾷쾸쾹쾺쾻쾼쾽쾾쾿쿀쿁쿂쿃쿅쿆쿇쿈쿉쿊쿋깹깻깼깽꺄꺅꺌꺼꺽꺾껀껄껌껍껏껐껑께껙껜껨껫껭껴껸껼꼇꼈꼍꼐꼬꼭꼰꼲꼴꼼꼽꼿꽁꽂꽃꽈꽉꽐꽜꽝꽤꽥꽹꾀꾄꾈꾐꾑꾕꾜꾸꾹꾼꿀꿇꿈꿉꿋꿍꿎꿔꿜꿨꿩꿰꿱꿴꿸뀀뀁뀄뀌뀐뀔뀜뀝뀨끄끅끈끊끌끎끓끔끕끗끙�".split("");for(j=0;j!=D[178].length;++j)if(D[178][j].charCodeAt(0)!==65533){e[D[178][j]]=178*256+j;d[178*256+j]=D[178][j]}D[179]="�����������������������������������������������������������������쿌쿍쿎쿏쿐쿑쿒쿓쿔쿕쿖쿗쿘쿙쿚쿛쿜쿝쿞쿟쿢쿣쿥쿦쿧쿩������쿪쿫쿬쿭쿮쿯쿲쿴쿶쿷쿸쿹쿺쿻쿽쿾쿿퀁퀂퀃퀅퀆퀇퀈퀉퀊������퀋퀌퀍퀎퀏퀐퀒퀓퀔퀕퀖퀗퀙퀚퀛퀜퀝퀞퀟퀠퀡퀢퀣퀤퀥퀦퀧퀨퀩퀪퀫퀬끝끼끽낀낄낌낍낏낑나낙낚난낟날낡낢남납낫났낭낮낯낱낳내낵낸낼냄냅냇냈냉냐냑냔냘냠냥너넉넋넌널넒넓넘넙넛넜넝넣네넥넨넬넴넵넷넸넹녀녁년녈념녑녔녕녘녜녠노녹논놀놂놈놉놋농높놓놔놘놜놨뇌뇐뇔뇜뇝�".split("");for(j=0;j!=D[179].length;++j)if(D[179][j].charCodeAt(0)!==65533){e[D[179][j]]=179*256+j;d[179*256+j]=D[179][j]}D[180]="�����������������������������������������������������������������퀮퀯퀰퀱퀲퀳퀶퀷퀹퀺퀻퀽퀾퀿큀큁큂큃큆큈큊큋큌큍큎큏������큑큒큓큕큖큗큙큚큛큜큝큞큟큡큢큣큤큥큦큧큨큩큪큫큮큯������큱큲큳큵큶큷큸큹큺큻큾큿킀킂킃킄킅킆킇킈킉킊킋킌킍킎킏킐킑킒킓킔뇟뇨뇩뇬뇰뇹뇻뇽누눅눈눋눌눔눕눗눙눠눴눼뉘뉜뉠뉨뉩뉴뉵뉼늄늅늉느늑는늘늙늚늠늡늣능늦늪늬늰늴니닉닌닐닒님닙닛닝닢다닥닦단닫달닭닮닯닳담답닷닸당닺닻닿대댁댄댈댐댑댓댔댕댜더덕덖던덛덜덞덟덤덥�".split("");for(j=0;j!=D[180].length;++j)if(D[180][j].charCodeAt(0)!==65533){e[D[180][j]]=180*256+j;d[180*256+j]=D[180][j]}D[181]="�����������������������������������������������������������������킕킖킗킘킙킚킛킜킝킞킟킠킡킢킣킦킧킩킪킫킭킮킯킰킱킲������킳킶킸킺킻킼킽킾킿탂탃탅탆탇탊탋탌탍탎탏탒탖탗탘탙탚������탛탞탟탡탢탣탥탦탧탨탩탪탫탮탲탳탴탵탶탷탹탺탻탼탽탾탿턀턁턂턃턄덧덩덫덮데덱덴델뎀뎁뎃뎄뎅뎌뎐뎔뎠뎡뎨뎬도독돈돋돌돎돐돔돕돗동돛돝돠돤돨돼됐되된될됨됩됫됴두둑둔둘둠둡둣둥둬뒀뒈뒝뒤뒨뒬뒵뒷뒹듀듄듈듐듕드득든듣들듦듬듭듯등듸디딕딘딛딜딤딥딧딨딩딪따딱딴딸�".split("");for(j=0;j!=D[181].length;++j)if(D[181][j].charCodeAt(0)!==65533){e[D[181][j]]=181*256+j;d[181*256+j]=D[181][j]}D[182]="�����������������������������������������������������������������턅턆턇턈턉턊턋턌턎턏턐턑턒턓턔턕턖턗턘턙턚턛턜턝턞턟������턠턡턢턣턤턥턦턧턨턩턪턫턬턭턮턯턲턳턵턶턷턹턻턼턽턾������턿텂텆텇텈텉텊텋텎텏텑텒텓텕텖텗텘텙텚텛텞텠텢텣텤텥텦텧텩텪텫텭땀땁땃땄땅땋때땍땐땔땜땝땟땠땡떠떡떤떨떪떫떰떱떳떴떵떻떼떽뗀뗄뗌뗍뗏뗐뗑뗘뗬또똑똔똘똥똬똴뙈뙤뙨뚜뚝뚠뚤뚫뚬뚱뛔뛰뛴뛸뜀뜁뜅뜨뜩뜬뜯뜰뜸뜹뜻띄띈띌띔띕띠띤띨띰띱띳띵라락란랄람랍랏랐랑랒랖랗�".split("");for(j=0;j!=D[182].length;++j)if(D[182][j].charCodeAt(0)!==65533){e[D[182][j]]=182*256+j;d[182*256+j]=D[182][j]}D[183]="�����������������������������������������������������������������텮텯텰텱텲텳텴텵텶텷텸텹텺텻텽텾텿톀톁톂톃톅톆톇톉톊������톋톌톍톎톏톐톑톒톓톔톕톖톗톘톙톚톛톜톝톞톟톢톣톥톦톧������톩톪톫톬톭톮톯톲톴톶톷톸톹톻톽톾톿퇁퇂퇃퇄퇅퇆퇇퇈퇉퇊퇋퇌퇍퇎퇏래랙랜랠램랩랫랬랭랴략랸럇량러럭런럴럼럽럿렀렁렇레렉렌렐렘렙렛렝려력련렬렴렵렷렸령례롄롑롓로록론롤롬롭롯롱롸롼뢍뢨뢰뢴뢸룀룁룃룅료룐룔룝룟룡루룩룬룰룸룹룻룽뤄뤘뤠뤼뤽륀륄륌륏륑류륙륜률륨륩�".split("");for(j=0;j!=D[183].length;++j)if(D[183][j].charCodeAt(0)!==65533){e[D[183][j]]=183*256+j;d[183*256+j]=D[183][j]}D[184]="�����������������������������������������������������������������퇐퇑퇒퇓퇔퇕퇖퇗퇙퇚퇛퇜퇝퇞퇟퇠퇡퇢퇣퇤퇥퇦퇧퇨퇩퇪������퇫퇬퇭퇮퇯퇰퇱퇲퇳퇵퇶퇷퇹퇺퇻퇼퇽퇾퇿툀툁툂툃툄툅툆������툈툊툋툌툍툎툏툑툒툓툔툕툖툗툘툙툚툛툜툝툞툟툠툡툢툣툤툥툦툧툨툩륫륭르륵른를름릅릇릉릊릍릎리릭린릴림립릿링마막만많맏말맑맒맘맙맛망맞맡맣매맥맨맬맴맵맷맸맹맺먀먁먈먕머먹먼멀멂멈멉멋멍멎멓메멕멘멜멤멥멧멨멩며멱면멸몃몄명몇몌모목몫몬몰몲몸몹못몽뫄뫈뫘뫙뫼�".split("");for(j=0;j!=D[184].length;++j)if(D[184][j].charCodeAt(0)!==65533){e[D[184][j]]=184*256+j;d[184*256+j]=D[184][j]}D[185]="�����������������������������������������������������������������툪툫툮툯툱툲툳툵툶툷툸툹툺툻툾퉀퉂퉃퉄퉅퉆퉇퉉퉊퉋퉌������퉍퉎퉏퉐퉑퉒퉓퉔퉕퉖퉗퉘퉙퉚퉛퉝퉞퉟퉠퉡퉢퉣퉥퉦퉧퉨������퉩퉪퉫퉬퉭퉮퉯퉰퉱퉲퉳퉴퉵퉶퉷퉸퉹퉺퉻퉼퉽퉾퉿튂튃튅튆튇튉튊튋튌묀묄묍묏묑묘묜묠묩묫무묵묶문묻물묽묾뭄뭅뭇뭉뭍뭏뭐뭔뭘뭡뭣뭬뮈뮌뮐뮤뮨뮬뮴뮷므믄믈믐믓미믹민믿밀밂밈밉밋밌밍및밑바박밖밗반받발밝밞밟밤밥밧방밭배백밴밸뱀뱁뱃뱄뱅뱉뱌뱍뱐뱝버벅번벋벌벎범법벗�".split("");for(j=0;j!=D[185].length;++j)if(D[185][j].charCodeAt(0)!==65533){e[D[185][j]]=185*256+j;d[185*256+j]=D[185][j]}D[186]="�����������������������������������������������������������������튍튎튏튒튓튔튖튗튘튙튚튛튝튞튟튡튢튣튥튦튧튨튩튪튫튭������튮튯튰튲튳튴튵튶튷튺튻튽튾틁틃틄틅틆틇틊틌틍틎틏틐틑������틒틓틕틖틗틙틚틛틝틞틟틠틡틢틣틦틧틨틩틪틫틬틭틮틯틲틳틵틶틷틹틺벙벚베벡벤벧벨벰벱벳벴벵벼벽변별볍볏볐병볕볘볜보복볶본볼봄봅봇봉봐봔봤봬뵀뵈뵉뵌뵐뵘뵙뵤뵨부북분붇불붉붊붐붑붓붕붙붚붜붤붰붸뷔뷕뷘뷜뷩뷰뷴뷸븀븃븅브븍븐블븜븝븟비빅빈빌빎빔빕빗빙빚빛빠빡빤�".split("");for(j=0;j!=D[186].length;++j)if(D[186][j].charCodeAt(0)!==65533){e[D[186][j]]=186*256+j;d[186*256+j]=D[186][j]}D[187]="�����������������������������������������������������������������틻틼틽틾틿팂팄팆팇팈팉팊팋팏팑팒팓팕팗팘팙팚팛팞팢팣������팤팦팧팪팫팭팮팯팱팲팳팴팵팶팷팺팾팿퍀퍁퍂퍃퍆퍇퍈퍉������퍊퍋퍌퍍퍎퍏퍐퍑퍒퍓퍔퍕퍖퍗퍘퍙퍚퍛퍜퍝퍞퍟퍠퍡퍢퍣퍤퍥퍦퍧퍨퍩빨빪빰빱빳빴빵빻빼빽뺀뺄뺌뺍뺏뺐뺑뺘뺙뺨뻐뻑뻔뻗뻘뻠뻣뻤뻥뻬뼁뼈뼉뼘뼙뼛뼜뼝뽀뽁뽄뽈뽐뽑뽕뾔뾰뿅뿌뿍뿐뿔뿜뿟뿡쀼쁑쁘쁜쁠쁨쁩삐삑삔삘삠삡삣삥사삭삯산삳살삵삶삼삽삿샀상샅새색샌샐샘샙샛샜생샤�".split("");for(j=0;j!=D[187].length;++j)if(D[187][j].charCodeAt(0)!==65533){e[D[187][j]]=187*256+j;d[187*256+j]=D[187][j]}D[188]="�����������������������������������������������������������������퍪퍫퍬퍭퍮퍯퍰퍱퍲퍳퍴퍵퍶퍷퍸퍹퍺퍻퍾퍿펁펂펃펅펆펇������펈펉펊펋펎펒펓펔펕펖펗펚펛펝펞펟펡펢펣펤펥펦펧펪펬펮������펯펰펱펲펳펵펶펷펹펺펻펽펾펿폀폁폂폃폆폇폊폋폌폍폎폏폑폒폓폔폕폖샥샨샬샴샵샷샹섀섄섈섐섕서석섞섟선섣설섦섧섬섭섯섰성섶세섹센셀셈셉셋셌셍셔셕션셜셤셥셧셨셩셰셴셸솅소속솎손솔솖솜솝솟송솥솨솩솬솰솽쇄쇈쇌쇔쇗쇘쇠쇤쇨쇰쇱쇳쇼쇽숀숄숌숍숏숑수숙순숟술숨숩숫숭�".split("");for(j=0;j!=D[188].length;++j)if(D[188][j].charCodeAt(0)!==65533){e[D[188][j]]=188*256+j;d[188*256+j]=D[188][j]}D[189]="�����������������������������������������������������������������폗폙폚폛폜폝폞폟폠폢폤폥폦폧폨폩폪폫폮폯폱폲폳폵폶폷������폸폹폺폻폾퐀퐂퐃퐄퐅퐆퐇퐉퐊퐋퐌퐍퐎퐏퐐퐑퐒퐓퐔퐕퐖������퐗퐘퐙퐚퐛퐜퐞퐟퐠퐡퐢퐣퐤퐥퐦퐧퐨퐩퐪퐫퐬퐭퐮퐯퐰퐱퐲퐳퐴퐵퐶퐷숯숱숲숴쉈쉐쉑쉔쉘쉠쉥쉬쉭쉰쉴쉼쉽쉿슁슈슉슐슘슛슝스슥슨슬슭슴습슷승시식신싣실싫심십싯싱싶싸싹싻싼쌀쌈쌉쌌쌍쌓쌔쌕쌘쌜쌤쌥쌨쌩썅써썩썬썰썲썸썹썼썽쎄쎈쎌쏀쏘쏙쏜쏟쏠쏢쏨쏩쏭쏴쏵쏸쐈쐐쐤쐬쐰�".split("");for(j=0;j!=D[189].length;++j)if(D[189][j].charCodeAt(0)!==65533){e[D[189][j]]=189*256+j;d[189*256+j]=D[189][j]}D[190]="�����������������������������������������������������������������퐸퐹퐺퐻퐼퐽퐾퐿푁푂푃푅푆푇푈푉푊푋푌푍푎푏푐푑푒푓������푔푕푖푗푘푙푚푛푝푞푟푡푢푣푥푦푧푨푩푪푫푬푮푰푱푲������푳푴푵푶푷푺푻푽푾풁풃풄풅풆풇풊풌풎풏풐풑풒풓풕풖풗풘풙풚풛풜풝쐴쐼쐽쑈쑤쑥쑨쑬쑴쑵쑹쒀쒔쒜쒸쒼쓩쓰쓱쓴쓸쓺쓿씀씁씌씐씔씜씨씩씬씰씸씹씻씽아악안앉않알앍앎앓암압앗았앙앝앞애액앤앨앰앱앳앴앵야약얀얄얇얌얍얏양얕얗얘얜얠얩어억언얹얻얼얽얾엄업없엇었엉엊엌엎�".split("");for(j=0;j!=D[190].length;++j)if(D[190][j].charCodeAt(0)!==65533){e[D[190][j]]=190*256+j;d[190*256+j]=D[190][j]}D[191]="�����������������������������������������������������������������풞풟풠풡풢풣풤풥풦풧풨풪풫풬풭풮풯풰풱풲풳풴풵풶풷풸������풹풺풻풼풽풾풿퓀퓁퓂퓃퓄퓅퓆퓇퓈퓉퓊퓋퓍퓎퓏퓑퓒퓓퓕������퓖퓗퓘퓙퓚퓛퓝퓞퓠퓡퓢퓣퓤퓥퓦퓧퓩퓪퓫퓭퓮퓯퓱퓲퓳퓴퓵퓶퓷퓹퓺퓼에엑엔엘엠엡엣엥여역엮연열엶엷염엽엾엿였영옅옆옇예옌옐옘옙옛옜오옥온올옭옮옰옳옴옵옷옹옻와왁완왈왐왑왓왔왕왜왝왠왬왯왱외왹왼욀욈욉욋욍요욕욘욜욤욥욧용우욱운울욹욺움웁웃웅워웍원월웜웝웠웡웨�".split("");for(j=0;j!=D[191].length;++j)if(D[191][j].charCodeAt(0)!==65533){e[D[191][j]]=191*256+j;d[191*256+j]=D[191][j]}D[192]="�����������������������������������������������������������������퓾퓿픀픁픂픃픅픆픇픉픊픋픍픎픏픐픑픒픓픖픘픙픚픛픜픝������픞픟픠픡픢픣픤픥픦픧픨픩픪픫픬픭픮픯픰픱픲픳픴픵픶픷������픸픹픺픻픾픿핁핂핃핅핆핇핈핉핊핋핎핐핒핓핔핕핖핗핚핛핝핞핟핡핢핣웩웬웰웸웹웽위윅윈윌윔윕윗윙유육윤율윰윱윳융윷으윽은을읊음읍읏응읒읓읔읕읖읗의읜읠읨읫이익인일읽읾잃임입잇있잉잊잎자작잔잖잗잘잚잠잡잣잤장잦재잭잰잴잼잽잿쟀쟁쟈쟉쟌쟎쟐쟘쟝쟤쟨쟬저적전절젊�".split("");for(j=0;j!=D[192].length;++j)if(D[192][j].charCodeAt(0)!==65533){e[D[192][j]]=192*256+j;d[192*256+j]=D[192][j]}D[193]="�����������������������������������������������������������������핤핦핧핪핬핮핯핰핱핲핳핶핷핹핺핻핽핾핿햀햁햂햃햆햊햋������햌햍햎햏햑햒햓햔햕햖햗햘햙햚햛햜햝햞햟햠햡햢햣햤햦햧������햨햩햪햫햬햭햮햯햰햱햲햳햴햵햶햷햸햹햺햻햼햽햾햿헀헁헂헃헄헅헆헇점접젓정젖제젝젠젤젬젭젯젱져젼졀졈졉졌졍졔조족존졸졺좀좁좃종좆좇좋좌좍좔좝좟좡좨좼좽죄죈죌죔죕죗죙죠죡죤죵주죽준줄줅줆줌줍줏중줘줬줴쥐쥑쥔쥘쥠쥡쥣쥬쥰쥴쥼즈즉즌즐즘즙즛증지직진짇질짊짐집짓�".split("");for(j=0;j!=D[193].length;++j)if(D[193][j].charCodeAt(0)!==65533){e[D[193][j]]=193*256+j;d[193*256+j]=D[193][j]}D[194]="�����������������������������������������������������������������헊헋헍헎헏헑헓헔헕헖헗헚헜헞헟헠헡헢헣헦헧헩헪헫헭헮������헯헰헱헲헳헶헸헺헻헼헽헾헿혂혃혅혆혇혉혊혋혌혍혎혏혒������혖혗혘혙혚혛혝혞혟혡혢혣혥혦혧혨혩혪혫혬혮혯혰혱혲혳혴혵혶혷혺혻징짖짙짚짜짝짠짢짤짧짬짭짯짰짱째짹짼쨀쨈쨉쨋쨌쨍쨔쨘쨩쩌쩍쩐쩔쩜쩝쩟쩠쩡쩨쩽쪄쪘쪼쪽쫀쫄쫌쫍쫏쫑쫓쫘쫙쫠쫬쫴쬈쬐쬔쬘쬠쬡쭁쭈쭉쭌쭐쭘쭙쭝쭤쭸쭹쮜쮸쯔쯤쯧쯩찌찍찐찔찜찝찡찢찧차착찬찮찰참찹찻�".split("");for(j=0;j!=D[194].length;++j)if(D[194][j].charCodeAt(0)!==65533){e[D[194][j]]=194*256+j;d[194*256+j]=D[194][j]}D[195]="�����������������������������������������������������������������혽혾혿홁홂홃홄홆홇홊홌홎홏홐홒홓홖홗홙홚홛홝홞홟홠홡������홢홣홤홥홦홨홪홫홬홭홮홯홲홳홵홶홷홸홹홺홻홼홽홾홿횀������횁횂횄횆횇횈횉횊횋횎횏횑횒횓횕횖횗횘횙횚횛횜횞횠횢횣횤횥횦횧횩횪찼창찾채책챈챌챔챕챗챘챙챠챤챦챨챰챵처척천철첨첩첫첬청체첵첸첼쳄쳅쳇쳉쳐쳔쳤쳬쳰촁초촉촌촐촘촙촛총촤촨촬촹최쵠쵤쵬쵭쵯쵱쵸춈추축춘출춤춥춧충춰췄췌췐취췬췰췸췹췻췽츄츈츌츔츙츠측츤츨츰츱츳층�".split("");for(j=0;j!=D[195].length;++j)if(D[195][j].charCodeAt(0)!==65533){e[D[195][j]]=195*256+j;d[195*256+j]=D[195][j]}D[196]="�����������������������������������������������������������������횫횭횮횯횱횲횳횴횵횶횷횸횺횼횽횾횿훀훁훂훃훆훇훉훊훋������훍훎훏훐훒훓훕훖훘훚훛훜훝훞훟훡훢훣훥훦훧훩훪훫훬훭������훮훯훱훲훳훴훶훷훸훹훺훻훾훿휁휂휃휅휆휇휈휉휊휋휌휍휎휏휐휒휓휔치칙친칟칠칡침칩칫칭카칵칸칼캄캅캇캉캐캑캔캘캠캡캣캤캥캬캭컁커컥컨컫컬컴컵컷컸컹케켁켄켈켐켑켓켕켜켠켤켬켭켯켰켱켸코콕콘콜콤콥콧콩콰콱콴콸쾀쾅쾌쾡쾨쾰쿄쿠쿡쿤쿨쿰쿱쿳쿵쿼퀀퀄퀑퀘퀭퀴퀵퀸퀼�".split("");for(j=0;j!=D[196].length;++j)if(D[196][j].charCodeAt(0)!==65533){e[D[196][j]]=196*256+j;d[196*256+j]=D[196][j]}D[197]="�����������������������������������������������������������������휕휖휗휚휛휝휞휟휡휢휣휤휥휦휧휪휬휮휯휰휱휲휳휶휷휹������휺휻휽휾휿흀흁흂흃흅흆흈흊흋흌흍흎흏흒흓흕흚흛흜흝흞������흟흢흤흦흧흨흪흫흭흮흯흱흲흳흵흶흷흸흹흺흻흾흿힀힂힃힄힅힆힇힊힋큄큅큇큉큐큔큘큠크큭큰클큼큽킁키킥킨킬킴킵킷킹타탁탄탈탉탐탑탓탔탕태택탠탤탬탭탯탰탱탸턍터턱턴털턺텀텁텃텄텅테텍텐텔템텝텟텡텨텬텼톄톈토톡톤톨톰톱톳통톺톼퇀퇘퇴퇸툇툉툐투툭툰툴툼툽툿퉁퉈퉜�".split("");for(j=0;j!=D[197].length;++j)if(D[197][j].charCodeAt(0)!==65533){e[D[197][j]]=197*256+j;d[197*256+j]=D[197][j]}D[198]="�����������������������������������������������������������������힍힎힏힑힒힓힔힕힖힗힚힜힞힟힠힡힢힣������������������������������������������������������������������������������퉤튀튁튄튈튐튑튕튜튠튤튬튱트특튼튿틀틂틈틉틋틔틘틜틤틥티틱틴틸팀팁팃팅파팍팎판팔팖팜팝팟팠팡팥패팩팬팰팸팹팻팼팽퍄퍅퍼퍽펀펄펌펍펏펐펑페펙펜펠펨펩펫펭펴편펼폄폅폈평폐폘폡폣포폭폰폴폼폽폿퐁�".split("");for(j=0;j!=D[198].length;++j)if(D[198][j].charCodeAt(0)!==65533){e[D[198][j]]=198*256+j;d[198*256+j]=D[198][j]}D[199]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������퐈퐝푀푄표푠푤푭푯푸푹푼푿풀풂품풉풋풍풔풩퓌퓐퓔퓜퓟퓨퓬퓰퓸퓻퓽프픈플픔픕픗피픽핀필핌핍핏핑하학한할핥함합핫항해핵핸핼햄햅햇했행햐향허헉헌헐헒험헙헛헝헤헥헨헬헴헵헷헹혀혁현혈혐협혓혔형혜혠�".split("");for(j=0;j!=D[199].length;++j)if(D[199][j].charCodeAt(0)!==65533){e[D[199][j]]=199*256+j;d[199*256+j]=D[199][j]}D[200]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������혤혭호혹혼홀홅홈홉홋홍홑화확환활홧황홰홱홴횃횅회획횐횔횝횟횡효횬횰횹횻후훅훈훌훑훔훗훙훠훤훨훰훵훼훽휀휄휑휘휙휜휠휨휩휫휭휴휵휸휼흄흇흉흐흑흔흖흗흘흙흠흡흣흥흩희흰흴흼흽힁히힉힌힐힘힙힛힝�".split("");for(j=0;j!=D[200].length;++j)if(D[200][j].charCodeAt(0)!==65533){e[D[200][j]]=200*256+j;d[200*256+j]=D[200][j]}D[202]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������伽佳假價加可呵哥嘉嫁家暇架枷柯歌珂痂稼苛茄街袈訶賈跏軻迦駕刻却各恪慤殼珏脚覺角閣侃刊墾奸姦干幹懇揀杆柬桿澗癎看磵稈竿簡肝艮艱諫間乫喝曷渴碣竭葛褐蝎鞨勘坎堪嵌感憾戡敢柑橄減甘疳監瞰紺邯鑑鑒龕�".split("");for(j=0;j!=D[202].length;++j)if(D[202][j].charCodeAt(0)!==65533){e[D[202][j]]=202*256+j;d[202*256+j]=D[202][j]}D[203]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������匣岬甲胛鉀閘剛堈姜岡崗康强彊慷江畺疆糠絳綱羌腔舡薑襁講鋼降鱇介价個凱塏愷愾慨改槪漑疥皆盖箇芥蓋豈鎧開喀客坑更粳羹醵倨去居巨拒据據擧渠炬祛距踞車遽鉅鋸乾件健巾建愆楗腱虔蹇鍵騫乞傑杰桀儉劍劒檢�".split("");for(j=0;j!=D[203].length;++j)if(D[203][j].charCodeAt(0)!==65533){e[D[203][j]]=203*256+j;d[203*256+j]=D[203][j]}D[204]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������瞼鈐黔劫怯迲偈憩揭擊格檄激膈覡隔堅牽犬甄絹繭肩見譴遣鵑抉決潔結缺訣兼慊箝謙鉗鎌京俓倞傾儆勁勍卿坰境庚徑慶憬擎敬景暻更梗涇炅烱璟璥瓊痙硬磬竟競絅經耕耿脛莖警輕逕鏡頃頸驚鯨係啓堺契季屆悸戒桂械�".split("");for(j=0;j!=D[204].length;++j)if(D[204][j].charCodeAt(0)!==65533){e[D[204][j]]=204*256+j;d[204*256+j]=D[204][j]}D[205]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������棨溪界癸磎稽系繫繼計誡谿階鷄古叩告呱固姑孤尻庫拷攷故敲暠枯槁沽痼皐睾稿羔考股膏苦苽菰藁蠱袴誥賈辜錮雇顧高鼓哭斛曲梏穀谷鵠困坤崑昆梱棍滾琨袞鯤汨滑骨供公共功孔工恐恭拱控攻珙空蚣貢鞏串寡戈果瓜�".split("");for(j=0;j!=D[205].length;++j)if(D[205][j].charCodeAt(0)!==65533){e[D[205][j]]=205*256+j;d[205*256+j]=D[205][j]}D[206]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������科菓誇課跨過鍋顆廓槨藿郭串冠官寬慣棺款灌琯瓘管罐菅觀貫關館刮恝括适侊光匡壙廣曠洸炚狂珖筐胱鑛卦掛罫乖傀塊壞怪愧拐槐魁宏紘肱轟交僑咬喬嬌嶠巧攪敎校橋狡皎矯絞翹膠蕎蛟較轎郊餃驕鮫丘久九仇俱具勾�".split("");for(j=0;j!=D[206].length;++j)if(D[206][j].charCodeAt(0)!==65533){e[D[206][j]]=206*256+j;d[206*256+j]=D[206][j]}D[207]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������區口句咎嘔坵垢寇嶇廐懼拘救枸柩構歐毆毬求溝灸狗玖球瞿矩究絿耉臼舅舊苟衢謳購軀逑邱鉤銶駒驅鳩鷗龜國局菊鞠鞫麴君窘群裙軍郡堀屈掘窟宮弓穹窮芎躬倦券勸卷圈拳捲權淃眷厥獗蕨蹶闕机櫃潰詭軌饋句晷歸貴�".split("");for(j=0;j!=D[207].length;++j)if(D[207][j].charCodeAt(0)!==65533){e[D[207][j]]=207*256+j;d[207*256+j]=D[207][j]}D[208]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������鬼龜叫圭奎揆槻珪硅窺竅糾葵規赳逵閨勻均畇筠菌鈞龜橘克剋劇戟棘極隙僅劤勤懃斤根槿瑾筋芹菫覲謹近饉契今妗擒昑檎琴禁禽芩衾衿襟金錦伋及急扱汲級給亘兢矜肯企伎其冀嗜器圻基埼夔奇妓寄岐崎己幾忌技旗旣�".split("");for(j=0;j!=D[208].length;++j)if(D[208][j].charCodeAt(0)!==65533){e[D[208][j]]=208*256+j;d[208*256+j]=D[208][j]}D[209]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������朞期杞棋棄機欺氣汽沂淇玘琦琪璂璣畸畿碁磯祁祇祈祺箕紀綺羈耆耭肌記譏豈起錡錤飢饑騎騏驥麒緊佶吉拮桔金喫儺喇奈娜懦懶拏拿癩羅蘿螺裸邏那樂洛烙珞落諾酪駱亂卵暖欄煖爛蘭難鸞捏捺南嵐枏楠湳濫男藍襤拉�".split("");for(j=0;j!=D[209].length;++j)if(D[209][j].charCodeAt(0)!==65533){e[D[209][j]]=209*256+j;d[209*256+j]=D[209][j]}D[210]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������納臘蠟衲囊娘廊朗浪狼郎乃來內奈柰耐冷女年撚秊念恬拈捻寧寗努勞奴弩怒擄櫓爐瑙盧老蘆虜路露駑魯鷺碌祿綠菉錄鹿論壟弄濃籠聾膿農惱牢磊腦賂雷尿壘屢樓淚漏累縷陋嫩訥杻紐勒肋凜凌稜綾能菱陵尼泥匿溺多茶�".split("");for(j=0;j!=D[210].length;++j)if(D[210][j].charCodeAt(0)!==65533){e[D[210][j]]=210*256+j;d[210*256+j]=D[210][j]}D[211]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������丹亶但單團壇彖斷旦檀段湍短端簞緞蛋袒鄲鍛撻澾獺疸達啖坍憺擔曇淡湛潭澹痰聃膽蕁覃談譚錟沓畓答踏遝唐堂塘幢戇撞棠當糖螳黨代垈坮大對岱帶待戴擡玳臺袋貸隊黛宅德悳倒刀到圖堵塗導屠島嶋度徒悼挑掉搗桃�".split("");for(j=0;j!=D[211].length;++j)if(D[211][j].charCodeAt(0)!==65533){e[D[211][j]]=211*256+j;d[211*256+j]=D[211][j]}D[212]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������棹櫂淘渡滔濤燾盜睹禱稻萄覩賭跳蹈逃途道都鍍陶韜毒瀆牘犢獨督禿篤纛讀墩惇敦旽暾沌焞燉豚頓乭突仝冬凍動同憧東桐棟洞潼疼瞳童胴董銅兜斗杜枓痘竇荳讀豆逗頭屯臀芚遁遯鈍得嶝橙燈登等藤謄鄧騰喇懶拏癩羅�".split("");for(j=0;j!=D[212].length;++j)if(D[212][j].charCodeAt(0)!==65533){e[D[212][j]]=212*256+j;d[212*256+j]=D[212][j]}D[213]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������蘿螺裸邏樂洛烙珞絡落諾酪駱丹亂卵欄欒瀾爛蘭鸞剌辣嵐擥攬欖濫籃纜藍襤覽拉臘蠟廊朗浪狼琅瑯螂郞來崍徠萊冷掠略亮倆兩凉梁樑粮粱糧良諒輛量侶儷勵呂廬慮戾旅櫚濾礪藜蠣閭驢驪麗黎力曆歷瀝礫轢靂憐戀攣漣�".split("");for(j=0;j!=D[213].length;++j)if(D[213][j].charCodeAt(0)!==65533){e[D[213][j]]=213*256+j;d[213*256+j]=D[213][j]}D[214]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������煉璉練聯蓮輦連鍊冽列劣洌烈裂廉斂殮濂簾獵令伶囹寧岺嶺怜玲笭羚翎聆逞鈴零靈領齡例澧禮醴隷勞怒撈擄櫓潞瀘爐盧老蘆虜路輅露魯鷺鹵碌祿綠菉錄鹿麓論壟弄朧瀧瓏籠聾儡瀨牢磊賂賚賴雷了僚寮廖料燎療瞭聊蓼�".split("");for(j=0;j!=D[214].length;++j)if(D[214][j].charCodeAt(0)!==65533){e[D[214][j]]=214*256+j;d[214*256+j]=D[214][j]}D[215]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������遼鬧龍壘婁屢樓淚漏瘻累縷蔞褸鏤陋劉旒柳榴流溜瀏琉瑠留瘤硫謬類六戮陸侖倫崙淪綸輪律慄栗率隆勒肋凜凌楞稜綾菱陵俚利厘吏唎履悧李梨浬犁狸理璃異痢籬罹羸莉裏裡里釐離鯉吝潾燐璘藺躪隣鱗麟林淋琳臨霖砬�".split("");for(j=0;j!=D[215].length;++j)if(D[215][j].charCodeAt(0)!==65533){e[D[215][j]]=215*256+j;d[215*256+j]=D[215][j]}D[216]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������立笠粒摩瑪痲碼磨馬魔麻寞幕漠膜莫邈万卍娩巒彎慢挽晩曼滿漫灣瞞萬蔓蠻輓饅鰻唜抹末沫茉襪靺亡妄忘忙望網罔芒茫莽輞邙埋妹媒寐昧枚梅每煤罵買賣邁魅脈貊陌驀麥孟氓猛盲盟萌冪覓免冕勉棉沔眄眠綿緬面麵滅�".split("");for(j=0;j!=D[216].length;++j)if(D[216][j].charCodeAt(0)!==65533){e[D[216][j]]=216*256+j;d[216*256+j]=D[216][j]}D[217]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������蔑冥名命明暝椧溟皿瞑茗蓂螟酩銘鳴袂侮冒募姆帽慕摸摹暮某模母毛牟牡瑁眸矛耗芼茅謀謨貌木沐牧目睦穆鶩歿沒夢朦蒙卯墓妙廟描昴杳渺猫竗苗錨務巫憮懋戊拇撫无楙武毋無珷畝繆舞茂蕪誣貿霧鵡墨默們刎吻問文�".split("");for(j=0;j!=D[217].length;++j)if(D[217][j].charCodeAt(0)!==65533){e[D[217][j]]=217*256+j;d[217*256+j]=D[217][j]}D[218]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������汶紊紋聞蚊門雯勿沕物味媚尾嵋彌微未梶楣渼湄眉米美薇謎迷靡黴岷悶愍憫敏旻旼民泯玟珉緡閔密蜜謐剝博拍搏撲朴樸泊珀璞箔粕縛膊舶薄迫雹駁伴半反叛拌搬攀斑槃泮潘班畔瘢盤盼磐磻礬絆般蟠返頒飯勃拔撥渤潑�".split("");for(j=0;j!=D[218].length;++j)if(D[218][j].charCodeAt(0)!==65533){e[D[218][j]]=218*256+j;d[218*256+j]=D[218][j]}D[219]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������發跋醱鉢髮魃倣傍坊妨尨幇彷房放方旁昉枋榜滂磅紡肪膀舫芳蒡蚌訪謗邦防龐倍俳北培徘拜排杯湃焙盃背胚裴裵褙賠輩配陪伯佰帛柏栢白百魄幡樊煩燔番磻繁蕃藩飜伐筏罰閥凡帆梵氾汎泛犯範范法琺僻劈壁擘檗璧癖�".split("");for(j=0;j!=D[219].length;++j)if(D[219][j].charCodeAt(0)!==65533){e[D[219][j]]=219*256+j;d[219*256+j]=D[219][j]}D[220]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������碧蘗闢霹便卞弁變辨辯邊別瞥鱉鼈丙倂兵屛幷昞昺柄棅炳甁病秉竝輧餠騈保堡報寶普步洑湺潽珤甫菩補褓譜輔伏僕匐卜宓復服福腹茯蔔複覆輹輻馥鰒本乶俸奉封峯峰捧棒烽熢琫縫蓬蜂逢鋒鳳不付俯傅剖副否咐埠夫婦�".split("");for(j=0;j!=D[220].length;++j)if(D[220][j].charCodeAt(0)!==65533){e[D[220][j]]=220*256+j;d[220*256+j]=D[220][j]}D[221]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������孚孵富府復扶敷斧浮溥父符簿缶腐腑膚艀芙莩訃負賦賻赴趺部釜阜附駙鳧北分吩噴墳奔奮忿憤扮昐汾焚盆粉糞紛芬賁雰不佛弗彿拂崩朋棚硼繃鵬丕備匕匪卑妃婢庇悲憊扉批斐枇榧比毖毗毘沸泌琵痺砒碑秕秘粃緋翡肥�".split("");for(j=0;j!=D[221].length;++j)if(D[221][j].charCodeAt(0)!==65533){e[D[221][j]]=221*256+j;d[221*256+j]=D[221][j]}D[222]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������脾臂菲蜚裨誹譬費鄙非飛鼻嚬嬪彬斌檳殯浜濱瀕牝玭貧賓頻憑氷聘騁乍事些仕伺似使俟僿史司唆嗣四士奢娑寫寺射巳師徙思捨斜斯柶査梭死沙泗渣瀉獅砂社祀祠私篩紗絲肆舍莎蓑蛇裟詐詞謝賜赦辭邪飼駟麝削數朔索�".split("");for(j=0;j!=D[222].length;++j)if(D[222][j].charCodeAt(0)!==65533){e[D[222][j]]=222*256+j;d[222*256+j]=D[222][j]}D[223]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������傘刪山散汕珊産疝算蒜酸霰乷撒殺煞薩三參杉森渗芟蔘衫揷澁鈒颯上傷像償商喪嘗孀尙峠常床庠廂想桑橡湘爽牀狀相祥箱翔裳觴詳象賞霜塞璽賽嗇塞穡索色牲生甥省笙墅壻嶼序庶徐恕抒捿敍暑曙書栖棲犀瑞筮絮緖署�".split("");for(j=0;j!=D[223].length;++j)if(D[223][j].charCodeAt(0)!==65533){e[D[223][j]]=223*256+j;d[223*256+j]=D[223][j]}D[224]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������胥舒薯西誓逝鋤黍鼠夕奭席惜昔晳析汐淅潟石碩蓆釋錫仙僊先善嬋宣扇敾旋渲煽琁瑄璇璿癬禪線繕羨腺膳船蘚蟬詵跣選銑鐥饍鮮卨屑楔泄洩渫舌薛褻設說雪齧剡暹殲纖蟾贍閃陝攝涉燮葉城姓宬性惺成星晟猩珹盛省筬�".split("");for(j=0;j!=D[224].length;++j)if(D[224][j].charCodeAt(0)!==65533){e[D[224][j]]=224*256+j;d[224*256+j]=D[224][j]}D[225]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������聖聲腥誠醒世勢歲洗稅笹細說貰召嘯塑宵小少巢所掃搔昭梳沼消溯瀟炤燒甦疏疎瘙笑篠簫素紹蔬蕭蘇訴逍遡邵銷韶騷俗屬束涑粟續謖贖速孫巽損蓀遜飡率宋悚松淞訟誦送頌刷殺灑碎鎖衰釗修受嗽囚垂壽嫂守岫峀帥愁�".split("");for(j=0;j!=D[225].length;++j)if(D[225][j].charCodeAt(0)!==65533){e[D[225][j]]=225*256+j;d[225*256+j]=D[225][j]}D[226]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������戍手授搜收數樹殊水洙漱燧狩獸琇璲瘦睡秀穗竪粹綏綬繡羞脩茱蒐蓚藪袖誰讐輸遂邃酬銖銹隋隧隨雖需須首髓鬚叔塾夙孰宿淑潚熟琡璹肅菽巡徇循恂旬栒楯橓殉洵淳珣盾瞬筍純脣舜荀蓴蕣詢諄醇錞順馴戌術述鉥崇崧�".split("");for(j=0;j!=D[226].length;++j)if(D[226][j].charCodeAt(0)!==65533){e[D[226][j]]=226*256+j;d[226*256+j]=D[226][j]}D[227]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������嵩瑟膝蝨濕拾習褶襲丞乘僧勝升承昇繩蠅陞侍匙嘶始媤尸屎屍市弑恃施是時枾柴猜矢示翅蒔蓍視試詩諡豕豺埴寔式息拭植殖湜熄篒蝕識軾食飾伸侁信呻娠宸愼新晨燼申神紳腎臣莘薪藎蜃訊身辛辰迅失室實悉審尋心沁�".split("");for(j=0;j!=D[227].length;++j)if(D[227][j].charCodeAt(0)!==65533){e[D[227][j]]=227*256+j;d[227*256+j]=D[227][j]}D[228]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������沈深瀋甚芯諶什十拾雙氏亞俄兒啞娥峨我牙芽莪蛾衙訝阿雅餓鴉鵝堊岳嶽幄惡愕握樂渥鄂鍔顎鰐齷安岸按晏案眼雁鞍顔鮟斡謁軋閼唵岩巖庵暗癌菴闇壓押狎鴨仰央怏昻殃秧鴦厓哀埃崖愛曖涯碍艾隘靄厄扼掖液縊腋額�".split("");for(j=0;j!=D[228].length;++j)if(D[228][j].charCodeAt(0)!==65533){e[D[228][j]]=228*256+j;d[228*256+j]=D[228][j]}D[229]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������櫻罌鶯鸚也倻冶夜惹揶椰爺耶若野弱掠略約若葯蒻藥躍亮佯兩凉壤孃恙揚攘敭暘梁楊樣洋瀁煬痒瘍禳穰糧羊良襄諒讓釀陽量養圄御於漁瘀禦語馭魚齬億憶抑檍臆偃堰彦焉言諺孼蘖俺儼嚴奄掩淹嶪業円予余勵呂女如廬�".split("");for(j=0;j!=D[229].length;++j)if(D[229][j].charCodeAt(0)!==65533){e[D[229][j]]=229*256+j;d[229*256+j]=D[229][j]}D[230]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������旅歟汝濾璵礖礪與艅茹輿轝閭餘驪麗黎亦力域役易曆歷疫繹譯轢逆驛嚥堧姸娟宴年延憐戀捐挻撚椽沇沿涎涓淵演漣烟然煙煉燃燕璉硏硯秊筵緣練縯聯衍軟輦蓮連鉛鍊鳶列劣咽悅涅烈熱裂說閱厭廉念捻染殮炎焰琰艶苒�".split("");for(j=0;j!=D[230].length;++j)if(D[230][j].charCodeAt(0)!==65533){e[D[230][j]]=230*256+j;d[230*256+j]=D[230][j]}D[231]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������簾閻髥鹽曄獵燁葉令囹塋寧嶺嶸影怜映暎楹榮永泳渶潁濚瀛瀯煐營獰玲瑛瑩瓔盈穎纓羚聆英詠迎鈴鍈零霙靈領乂倪例刈叡曳汭濊猊睿穢芮藝蘂禮裔詣譽豫醴銳隸霓預五伍俉傲午吾吳嗚塢墺奧娛寤悟惡懊敖旿晤梧汚澳�".split("");for(j=0;j!=D[231].length;++j)if(D[231][j].charCodeAt(0)!==65533){e[D[231][j]]=231*256+j;d[231*256+j]=D[231][j]}D[232]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������烏熬獒筽蜈誤鰲鼇屋沃獄玉鈺溫瑥瘟穩縕蘊兀壅擁瓮甕癰翁邕雍饔渦瓦窩窪臥蛙蝸訛婉完宛梡椀浣玩琓琬碗緩翫脘腕莞豌阮頑曰往旺枉汪王倭娃歪矮外嵬巍猥畏了僚僥凹堯夭妖姚寥寮尿嶢拗搖撓擾料曜樂橈燎燿瑤療�".split("");for(j=0;j!=D[232].length;++j)if(D[232][j].charCodeAt(0)!==65533){e[D[232][j]]=232*256+j;d[232*256+j]=D[232][j]}D[233]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������窈窯繇繞耀腰蓼蟯要謠遙遼邀饒慾欲浴縟褥辱俑傭冗勇埇墉容庸慂榕涌湧溶熔瑢用甬聳茸蓉踊鎔鏞龍于佑偶優又友右宇寓尤愚憂旴牛玗瑀盂祐禑禹紆羽芋藕虞迂遇郵釪隅雨雩勖彧旭昱栯煜稶郁頊云暈橒殞澐熉耘芸蕓�".split("");for(j=0;j!=D[233].length;++j)if(D[233][j].charCodeAt(0)!==65533){e[D[233][j]]=233*256+j;d[233*256+j]=D[233][j]}D[234]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������運隕雲韻蔚鬱亐熊雄元原員圓園垣媛嫄寃怨愿援沅洹湲源爰猿瑗苑袁轅遠阮院願鴛月越鉞位偉僞危圍委威尉慰暐渭爲瑋緯胃萎葦蔿蝟衛褘謂違韋魏乳侑儒兪劉唯喩孺宥幼幽庾悠惟愈愉揄攸有杻柔柚柳楡楢油洧流游溜�".split("");for(j=0;j!=D[234].length;++j)if(D[234][j].charCodeAt(0)!==65533){e[D[234][j]]=234*256+j;d[234*256+j]=D[234][j]}D[235]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������濡猶猷琉瑜由留癒硫紐維臾萸裕誘諛諭踰蹂遊逾遺酉釉鍮類六堉戮毓肉育陸倫允奫尹崙淪潤玧胤贇輪鈗閏律慄栗率聿戎瀜絨融隆垠恩慇殷誾銀隱乙吟淫蔭陰音飮揖泣邑凝應膺鷹依倚儀宜意懿擬椅毅疑矣義艤薏蟻衣誼�".split("");for(j=0;j!=D[235].length;++j)if(D[235][j].charCodeAt(0)!==65533){e[D[235][j]]=235*256+j;d[235*256+j]=D[235][j]}D[236]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������議醫二以伊利吏夷姨履已弛彛怡易李梨泥爾珥理異痍痢移罹而耳肄苡荑裏裡貽貳邇里離飴餌匿溺瀷益翊翌翼謚人仁刃印吝咽因姻寅引忍湮燐璘絪茵藺蚓認隣靭靷鱗麟一佚佾壹日溢逸鎰馹任壬妊姙恁林淋稔臨荏賃入卄�".split("");for(j=0;j!=D[236].length;++j)if(D[236][j].charCodeAt(0)!==65533){e[D[236][j]]=236*256+j;d[236*256+j]=D[236][j]}D[237]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������立笠粒仍剩孕芿仔刺咨姉姿子字孜恣慈滋炙煮玆瓷疵磁紫者自茨蔗藉諮資雌作勺嚼斫昨灼炸爵綽芍酌雀鵲孱棧殘潺盞岑暫潛箴簪蠶雜丈仗匠場墻壯奬將帳庄張掌暲杖樟檣欌漿牆狀獐璋章粧腸臟臧莊葬蔣薔藏裝贓醬長�".split("");for(j=0;j!=D[237].length;++j)if(D[237][j].charCodeAt(0)!==65533){e[D[237][j]]=237*256+j;d[237*256+j]=D[237][j]}D[238]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������障再哉在宰才材栽梓渽滓災縡裁財載齋齎爭箏諍錚佇低儲咀姐底抵杵楮樗沮渚狙猪疽箸紵苧菹著藷詛貯躇這邸雎齟勣吊嫡寂摘敵滴狄炙的積笛籍績翟荻謫賊赤跡蹟迪迹適鏑佃佺傳全典前剪塡塼奠專展廛悛戰栓殿氈澱�".split("");for(j=0;j!=D[238].length;++j)if(D[238][j].charCodeAt(0)!==65533){e[D[238][j]]=238*256+j;d[238*256+j]=D[238][j]}D[239]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������煎琠田甸畑癲筌箋箭篆纏詮輾轉鈿銓錢鐫電顚顫餞切截折浙癤竊節絶占岾店漸点粘霑鮎點接摺蝶丁井亭停偵呈姃定幀庭廷征情挺政整旌晶晸柾楨檉正汀淀淨渟湞瀞炡玎珽町睛碇禎程穽精綎艇訂諪貞鄭酊釘鉦鋌錠霆靖�".split("");
for(j=0;j!=D[239].length;++j)if(D[239][j].charCodeAt(0)!==65533){e[D[239][j]]=239*256+j;d[239*256+j]=D[239][j]}D[240]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������靜頂鼎制劑啼堤帝弟悌提梯濟祭第臍薺製諸蹄醍除際霽題齊俎兆凋助嘲弔彫措操早晁曺曹朝條棗槽漕潮照燥爪璪眺祖祚租稠窕粗糟組繰肇藻蚤詔調趙躁造遭釣阻雕鳥族簇足鏃存尊卒拙猝倧宗從悰慫棕淙琮種終綜縱腫�".split("");for(j=0;j!=D[240].length;++j)if(D[240][j].charCodeAt(0)!==65533){e[D[240][j]]=240*256+j;d[240*256+j]=D[240][j]}D[241]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������踪踵鍾鐘佐坐左座挫罪主住侏做姝胄呪周嗾奏宙州廚晝朱柱株注洲湊澍炷珠疇籌紂紬綢舟蛛註誅走躊輳週酎酒鑄駐竹粥俊儁准埈寯峻晙樽浚準濬焌畯竣蠢逡遵雋駿茁中仲衆重卽櫛楫汁葺增憎曾拯烝甑症繒蒸證贈之只�".split("");for(j=0;j!=D[241].length;++j)if(D[241][j].charCodeAt(0)!==65533){e[D[241][j]]=241*256+j;d[241*256+j]=D[241][j]}D[242]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������咫地址志持指摯支旨智枝枳止池沚漬知砥祉祗紙肢脂至芝芷蜘誌識贄趾遲直稙稷織職唇嗔塵振搢晉晋桭榛殄津溱珍瑨璡畛疹盡眞瞋秦縉縝臻蔯袗診賑軫辰進鎭陣陳震侄叱姪嫉帙桎瓆疾秩窒膣蛭質跌迭斟朕什執潗緝輯�".split("");for(j=0;j!=D[242].length;++j)if(D[242][j].charCodeAt(0)!==65533){e[D[242][j]]=242*256+j;d[242*256+j]=D[242][j]}D[243]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������鏶集徵懲澄且侘借叉嗟嵯差次此磋箚茶蹉車遮捉搾着窄錯鑿齪撰澯燦璨瓚竄簒纂粲纘讚贊鑽餐饌刹察擦札紮僭參塹慘慙懺斬站讒讖倉倡創唱娼廠彰愴敞昌昶暢槍滄漲猖瘡窓脹艙菖蒼債埰寀寨彩採砦綵菜蔡采釵冊柵策�".split("");for(j=0;j!=D[243].length;++j)if(D[243][j].charCodeAt(0)!==65533){e[D[243][j]]=243*256+j;d[243*256+j]=D[243][j]}D[244]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������責凄妻悽處倜刺剔尺慽戚拓擲斥滌瘠脊蹠陟隻仟千喘天川擅泉淺玔穿舛薦賤踐遷釧闡阡韆凸哲喆徹撤澈綴輟轍鐵僉尖沾添甛瞻簽籤詹諂堞妾帖捷牒疊睫諜貼輒廳晴淸聽菁請靑鯖切剃替涕滯締諦逮遞體初剿哨憔抄招梢�".split("");for(j=0;j!=D[244].length;++j)if(D[244][j].charCodeAt(0)!==65533){e[D[244][j]]=244*256+j;d[244*256+j]=D[244][j]}D[245]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������椒楚樵炒焦硝礁礎秒稍肖艸苕草蕉貂超酢醋醮促囑燭矗蜀觸寸忖村邨叢塚寵悤憁摠總聰蔥銃撮催崔最墜抽推椎楸樞湫皺秋芻萩諏趨追鄒酋醜錐錘鎚雛騶鰍丑畜祝竺筑築縮蓄蹙蹴軸逐春椿瑃出朮黜充忠沖蟲衝衷悴膵萃�".split("");for(j=0;j!=D[245].length;++j)if(D[245][j].charCodeAt(0)!==65533){e[D[245][j]]=245*256+j;d[245*256+j]=D[245][j]}D[246]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������贅取吹嘴娶就炊翠聚脆臭趣醉驟鷲側仄厠惻測層侈値嗤峙幟恥梔治淄熾痔痴癡稚穉緇緻置致蚩輜雉馳齒則勅飭親七柒漆侵寢枕沈浸琛砧針鍼蟄秤稱快他咤唾墮妥惰打拖朶楕舵陀馱駝倬卓啄坼度托拓擢晫柝濁濯琢琸託�".split("");for(j=0;j!=D[246].length;++j)if(D[246][j].charCodeAt(0)!==65533){e[D[246][j]]=246*256+j;d[246*256+j]=D[246][j]}D[247]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������鐸呑嘆坦彈憚歎灘炭綻誕奪脫探眈耽貪塔搭榻宕帑湯糖蕩兌台太怠態殆汰泰笞胎苔跆邰颱宅擇澤撑攄兎吐土討慟桶洞痛筒統通堆槌腿褪退頹偸套妬投透鬪慝特闖坡婆巴把播擺杷波派爬琶破罷芭跛頗判坂板版瓣販辦鈑�".split("");for(j=0;j!=D[247].length;++j)if(D[247][j].charCodeAt(0)!==65533){e[D[247][j]]=247*256+j;d[247*256+j]=D[247][j]}D[248]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������阪八叭捌佩唄悖敗沛浿牌狽稗覇貝彭澎烹膨愎便偏扁片篇編翩遍鞭騙貶坪平枰萍評吠嬖幣廢弊斃肺蔽閉陛佈包匍匏咆哺圃布怖抛抱捕暴泡浦疱砲胞脯苞葡蒲袍褒逋鋪飽鮑幅暴曝瀑爆輻俵剽彪慓杓標漂瓢票表豹飇飄驃�".split("");for(j=0;j!=D[248].length;++j)if(D[248][j].charCodeAt(0)!==65533){e[D[248][j]]=248*256+j;d[248*256+j]=D[248][j]}D[249]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������品稟楓諷豊風馮彼披疲皮被避陂匹弼必泌珌畢疋筆苾馝乏逼下何厦夏廈昰河瑕荷蝦賀遐霞鰕壑學虐謔鶴寒恨悍旱汗漢澣瀚罕翰閑閒限韓割轄函含咸啣喊檻涵緘艦銜陷鹹合哈盒蛤閤闔陜亢伉姮嫦巷恒抗杭桁沆港缸肛航�".split("");for(j=0;j!=D[249].length;++j)if(D[249][j].charCodeAt(0)!==65533){e[D[249][j]]=249*256+j;d[249*256+j]=D[249][j]}D[250]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������行降項亥偕咳垓奚孩害懈楷海瀣蟹解該諧邂駭骸劾核倖幸杏荇行享向嚮珦鄕響餉饗香噓墟虛許憲櫶獻軒歇險驗奕爀赫革俔峴弦懸晛泫炫玄玹現眩睍絃絢縣舷衒見賢鉉顯孑穴血頁嫌俠協夾峽挾浹狹脅脇莢鋏頰亨兄刑型�".split("");for(j=0;j!=D[250].length;++j)if(D[250][j].charCodeAt(0)!==65533){e[D[250][j]]=250*256+j;d[250*256+j]=D[250][j]}D[251]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������形泂滎瀅灐炯熒珩瑩荊螢衡逈邢鎣馨兮彗惠慧暳蕙蹊醯鞋乎互呼壕壺好岵弧戶扈昊晧毫浩淏湖滸澔濠濩灝狐琥瑚瓠皓祜糊縞胡芦葫蒿虎號蝴護豪鎬頀顥惑或酷婚昏混渾琿魂忽惚笏哄弘汞泓洪烘紅虹訌鴻化和嬅樺火畵�".split("");for(j=0;j!=D[251].length;++j)if(D[251][j].charCodeAt(0)!==65533){e[D[251][j]]=251*256+j;d[251*256+j]=D[251][j]}D[252]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������禍禾花華話譁貨靴廓擴攫確碻穫丸喚奐宦幻患換歡晥桓渙煥環紈還驩鰥活滑猾豁闊凰幌徨恍惶愰慌晃晄榥況湟滉潢煌璜皇篁簧荒蝗遑隍黃匯回廻徊恢悔懷晦會檜淮澮灰獪繪膾茴蛔誨賄劃獲宖橫鐄哮嚆孝效斅曉梟涍淆�".split("");for(j=0;j!=D[252].length;++j)if(D[252][j].charCodeAt(0)!==65533){e[D[252][j]]=252*256+j;d[252*256+j]=D[252][j]}D[253]="�����������������������������������������������������������������������������������������������������������������������������������������������������������������爻肴酵驍侯候厚后吼喉嗅帿後朽煦珝逅勛勳塤壎焄熏燻薰訓暈薨喧暄煊萱卉喙毁彙徽揮暉煇諱輝麾休携烋畦虧恤譎鷸兇凶匈洶胸黑昕欣炘痕吃屹紇訖欠欽歆吸恰洽翕興僖凞喜噫囍姬嬉希憙憘戱晞曦熙熹熺犧禧稀羲詰�".split("");for(j=0;j!=D[253].length;++j)if(D[253][j].charCodeAt(0)!==65533){e[D[253][j]]=253*256+j;d[253*256+j]=D[253][j]}return{enc:e,dec:d}}();cptable[950]=function(){var d={},e={},D=[],j;D[0]="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~��������������������������������������������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[0].length;++j)if(D[0][j].charCodeAt(0)!==65533){e[D[0][j]]=0*256+j;d[0*256+j]=D[0][j]}D[161]="����������������������������������������������������������������　，、。．‧；：？！︰…‥﹐﹑﹒·﹔﹕﹖﹗｜–︱—︳╴︴﹏（）︵︶｛｝︷︸〔〕︹︺【】︻︼《》︽︾〈〉︿﹀「」﹁﹂『』﹃﹄﹙﹚����������������������������������﹛﹜﹝﹞‘’“”〝〞‵′＃＆＊※§〃○●△▲◎☆★◇◆□■▽▼㊣℅¯￣＿ˍ﹉﹊﹍﹎﹋﹌﹟﹠﹡＋－×÷±√＜＞＝≦≧≠∞≒≡﹢﹣﹤﹥﹦～∩∪⊥∠∟⊿㏒㏑∫∮∵∴♀♂⊕⊙↑↓←→↖↗↙↘∥∣／�".split("");for(j=0;j!=D[161].length;++j)if(D[161][j].charCodeAt(0)!==65533){e[D[161][j]]=161*256+j;d[161*256+j]=D[161][j]}D[162]="����������������������������������������������������������������＼∕﹨＄￥〒￠￡％＠℃℉﹩﹪﹫㏕㎜㎝㎞㏎㎡㎎㎏㏄°兙兛兞兝兡兣嗧瓩糎▁▂▃▄▅▆▇█▏▎▍▌▋▊▉┼┴┬┤├▔─│▕┌┐└┘╭����������������������������������╮╰╯═╞╪╡◢◣◥◤╱╲╳０１２３４５６７８９ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ〡〢〣〤〥〦〧〨〩十卄卅ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖ�".split("");for(j=0;j!=D[162].length;++j)if(D[162][j].charCodeAt(0)!==65533){e[D[162][j]]=162*256+j;d[162*256+j]=D[162][j]}D[163]="����������������������������������������������������������������ｗｘｙｚΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩαβγδεζηθικλμνξοπρστυφχψωㄅㄆㄇㄈㄉㄊㄋㄌㄍㄎㄏ����������������������������������ㄐㄑㄒㄓㄔㄕㄖㄗㄘㄙㄚㄛㄜㄝㄞㄟㄠㄡㄢㄣㄤㄥㄦㄧㄨㄩ˙ˉˊˇˋ���������������������������������€������������������������������".split("");for(j=0;j!=D[163].length;++j)if(D[163][j].charCodeAt(0)!==65533){e[D[163][j]]=163*256+j;d[163*256+j]=D[163][j]}D[164]="����������������������������������������������������������������一乙丁七乃九了二人儿入八几刀刁力匕十卜又三下丈上丫丸凡久么也乞于亡兀刃勺千叉口土士夕大女子孑孓寸小尢尸山川工己已巳巾干廾弋弓才����������������������������������丑丐不中丰丹之尹予云井互五亢仁什仃仆仇仍今介仄元允內六兮公冗凶分切刈勻勾勿化匹午升卅卞厄友及反壬天夫太夭孔少尤尺屯巴幻廿弔引心戈戶手扎支文斗斤方日曰月木欠止歹毋比毛氏水火爪父爻片牙牛犬王丙�".split("");for(j=0;j!=D[164].length;++j)if(D[164][j].charCodeAt(0)!==65533){e[D[164][j]]=164*256+j;d[164*256+j]=D[164][j]}D[165]="����������������������������������������������������������������世丕且丘主乍乏乎以付仔仕他仗代令仙仞充兄冉冊冬凹出凸刊加功包匆北匝仟半卉卡占卯卮去可古右召叮叩叨叼司叵叫另只史叱台句叭叻四囚外����������������������������������央失奴奶孕它尼巨巧左市布平幼弁弘弗必戊打扔扒扑斥旦朮本未末札正母民氐永汁汀氾犯玄玉瓜瓦甘生用甩田由甲申疋白皮皿目矛矢石示禾穴立丞丟乒乓乩亙交亦亥仿伉伙伊伕伍伐休伏仲件任仰仳份企伋光兇兆先全�".split("");for(j=0;j!=D[165].length;++j)if(D[165][j].charCodeAt(0)!==65533){e[D[165][j]]=165*256+j;d[165*256+j]=D[165][j]}D[166]="����������������������������������������������������������������共再冰列刑划刎刖劣匈匡匠印危吉吏同吊吐吁吋各向名合吃后吆吒因回囝圳地在圭圬圯圩夙多夷夸妄奸妃好她如妁字存宇守宅安寺尖屹州帆并年����������������������������������式弛忙忖戎戌戍成扣扛托收早旨旬旭曲曳有朽朴朱朵次此死氖汝汗汙江池汐汕污汛汍汎灰牟牝百竹米糸缶羊羽老考而耒耳聿肉肋肌臣自至臼舌舛舟艮色艾虫血行衣西阡串亨位住佇佗佞伴佛何估佐佑伽伺伸佃佔似但佣�".split("");for(j=0;j!=D[166].length;++j)if(D[166][j].charCodeAt(0)!==65533){e[D[166][j]]=166*256+j;d[166*256+j]=D[166][j]}D[167]="����������������������������������������������������������������作你伯低伶余佝佈佚兌克免兵冶冷別判利刪刨劫助努劬匣即卵吝吭吞吾否呎吧呆呃吳呈呂君吩告吹吻吸吮吵吶吠吼呀吱含吟听囪困囤囫坊坑址坍����������������������������������均坎圾坐坏圻壯夾妝妒妨妞妣妙妖妍妤妓妊妥孝孜孚孛完宋宏尬局屁尿尾岐岑岔岌巫希序庇床廷弄弟彤形彷役忘忌志忍忱快忸忪戒我抄抗抖技扶抉扭把扼找批扳抒扯折扮投抓抑抆改攻攸旱更束李杏材村杜杖杞杉杆杠�".split("");for(j=0;j!=D[167].length;++j)if(D[167][j].charCodeAt(0)!==65533){e[D[167][j]]=167*256+j;d[167*256+j]=D[167][j]}D[168]="����������������������������������������������������������������杓杗步每求汞沙沁沈沉沅沛汪決沐汰沌汨沖沒汽沃汲汾汴沆汶沍沔沘沂灶灼災灸牢牡牠狄狂玖甬甫男甸皂盯矣私秀禿究系罕肖肓肝肘肛肚育良芒����������������������������������芋芍見角言谷豆豕貝赤走足身車辛辰迂迆迅迄巡邑邢邪邦那酉釆里防阮阱阪阬並乖乳事些亞享京佯依侍佳使佬供例來侃佰併侈佩佻侖佾侏侑佺兔兒兕兩具其典冽函刻券刷刺到刮制剁劾劻卒協卓卑卦卷卸卹取叔受味呵�".split("");for(j=0;j!=D[168].length;++j)if(D[168][j].charCodeAt(0)!==65533){e[D[168][j]]=168*256+j;d[168*256+j]=D[168][j]}D[169]="����������������������������������������������������������������咖呸咕咀呻呷咄咒咆呼咐呱呶和咚呢周咋命咎固垃坷坪坩坡坦坤坼夜奉奇奈奄奔妾妻委妹妮姑姆姐姍始姓姊妯妳姒姅孟孤季宗定官宜宙宛尚屈居����������������������������������屆岷岡岸岩岫岱岳帘帚帖帕帛帑幸庚店府底庖延弦弧弩往征彿彼忝忠忽念忿怏怔怯怵怖怪怕怡性怩怫怛或戕房戾所承拉拌拄抿拂抹拒招披拓拔拋拈抨抽押拐拙拇拍抵拚抱拘拖拗拆抬拎放斧於旺昔易昌昆昂明昀昏昕昊�".split("");for(j=0;j!=D[169].length;++j)if(D[169][j].charCodeAt(0)!==65533){e[D[169][j]]=169*256+j;d[169*256+j]=D[169][j]}D[170]="����������������������������������������������������������������昇服朋杭枋枕東果杳杷枇枝林杯杰板枉松析杵枚枓杼杪杲欣武歧歿氓氛泣注泳沱泌泥河沽沾沼波沫法泓沸泄油況沮泗泅泱沿治泡泛泊沬泯泜泖泠����������������������������������炕炎炒炊炙爬爭爸版牧物狀狎狙狗狐玩玨玟玫玥甽疝疙疚的盂盲直知矽社祀祁秉秈空穹竺糾罔羌羋者肺肥肢肱股肫肩肴肪肯臥臾舍芳芝芙芭芽芟芹花芬芥芯芸芣芰芾芷虎虱初表軋迎返近邵邸邱邶采金長門阜陀阿阻附�".split("");for(j=0;j!=D[170].length;++j)if(D[170][j].charCodeAt(0)!==65533){e[D[170][j]]=170*256+j;d[170*256+j]=D[170][j]}D[171]="����������������������������������������������������������������陂隹雨青非亟亭亮信侵侯便俠俑俏保促侶俘俟俊俗侮俐俄係俚俎俞侷兗冒冑冠剎剃削前剌剋則勇勉勃勁匍南卻厚叛咬哀咨哎哉咸咦咳哇哂咽咪品����������������������������������哄哈咯咫咱咻咩咧咿囿垂型垠垣垢城垮垓奕契奏奎奐姜姘姿姣姨娃姥姪姚姦威姻孩宣宦室客宥封屎屏屍屋峙峒巷帝帥帟幽庠度建弈弭彥很待徊律徇後徉怒思怠急怎怨恍恰恨恢恆恃恬恫恪恤扁拜挖按拼拭持拮拽指拱拷�".split("");for(j=0;j!=D[171].length;++j)if(D[171][j].charCodeAt(0)!==65533){e[D[171][j]]=171*256+j;d[171*256+j]=D[171][j]}D[172]="����������������������������������������������������������������拯括拾拴挑挂政故斫施既春昭映昧是星昨昱昤曷柿染柱柔某柬架枯柵柩柯柄柑枴柚查枸柏柞柳枰柙柢柝柒歪殃殆段毒毗氟泉洋洲洪流津洌洱洞洗����������������������������������活洽派洶洛泵洹洧洸洩洮洵洎洫炫為炳炬炯炭炸炮炤爰牲牯牴狩狠狡玷珊玻玲珍珀玳甚甭畏界畎畋疫疤疥疢疣癸皆皇皈盈盆盃盅省盹相眉看盾盼眇矜砂研砌砍祆祉祈祇禹禺科秒秋穿突竿竽籽紂紅紀紉紇約紆缸美羿耄�".split("");for(j=0;j!=D[172].length;++j)if(D[172][j].charCodeAt(0)!==65533){e[D[172][j]]=172*256+j;d[172*256+j]=D[172][j]}D[173]="����������������������������������������������������������������耐耍耑耶胖胥胚胃胄背胡胛胎胞胤胝致舢苧范茅苣苛苦茄若茂茉苒苗英茁苜苔苑苞苓苟苯茆虐虹虻虺衍衫要觔計訂訃貞負赴赳趴軍軌述迦迢迪迥����������������������������������迭迫迤迨郊郎郁郃酋酊重閂限陋陌降面革韋韭音頁風飛食首香乘亳倌倍倣俯倦倥俸倩倖倆值借倚倒們俺倀倔倨俱倡個候倘俳修倭倪俾倫倉兼冤冥冢凍凌准凋剖剜剔剛剝匪卿原厝叟哨唐唁唷哼哥哲唆哺唔哩哭員唉哮哪�".split("");for(j=0;j!=D[173].length;++j)if(D[173][j].charCodeAt(0)!==65533){e[D[173][j]]=173*256+j;d[173*256+j]=D[173][j]}D[174]="����������������������������������������������������������������哦唧唇哽唏圃圄埂埔埋埃堉夏套奘奚娑娘娜娟娛娓姬娠娣娩娥娌娉孫屘宰害家宴宮宵容宸射屑展屐峭峽峻峪峨峰島崁峴差席師庫庭座弱徒徑徐恙����������������������������������恣恥恐恕恭恩息悄悟悚悍悔悌悅悖扇拳挈拿捎挾振捕捂捆捏捉挺捐挽挪挫挨捍捌效敉料旁旅時晉晏晃晒晌晅晁書朔朕朗校核案框桓根桂桔栩梳栗桌桑栽柴桐桀格桃株桅栓栘桁殊殉殷氣氧氨氦氤泰浪涕消涇浦浸海浙涓�".split("");for(j=0;j!=D[174].length;++j)if(D[174][j].charCodeAt(0)!==65533){e[D[174][j]]=174*256+j;d[174*256+j]=D[174][j]}D[175]="����������������������������������������������������������������浬涉浮浚浴浩涌涊浹涅浥涔烊烘烤烙烈烏爹特狼狹狽狸狷玆班琉珮珠珪珞畔畝畜畚留疾病症疲疳疽疼疹痂疸皋皰益盍盎眩真眠眨矩砰砧砸砝破砷����������������������������������砥砭砠砟砲祕祐祠祟祖神祝祗祚秤秣秧租秦秩秘窄窈站笆笑粉紡紗紋紊素索純紐紕級紜納紙紛缺罟羔翅翁耆耘耕耙耗耽耿胱脂胰脅胭胴脆胸胳脈能脊胼胯臭臬舀舐航舫舨般芻茫荒荔荊茸荐草茵茴荏茲茹茶茗荀茱茨荃�".split("");for(j=0;j!=D[175].length;++j)if(D[175][j].charCodeAt(0)!==65533){e[D[175][j]]=175*256+j;d[175*256+j]=D[175][j]}D[176]="����������������������������������������������������������������虔蚊蚪蚓蚤蚩蚌蚣蚜衰衷袁袂衽衹記訐討訌訕訊託訓訖訏訑豈豺豹財貢起躬軒軔軏辱送逆迷退迺迴逃追逅迸邕郡郝郢酒配酌釘針釗釜釙閃院陣陡����������������������������������陛陝除陘陞隻飢馬骨高鬥鬲鬼乾偺偽停假偃偌做偉健偶偎偕偵側偷偏倏偯偭兜冕凰剪副勒務勘動匐匏匙匿區匾參曼商啪啦啄啞啡啃啊唱啖問啕唯啤唸售啜唬啣唳啁啗圈國圉域堅堊堆埠埤基堂堵執培夠奢娶婁婉婦婪婀�".split("");for(j=0;j!=D[176].length;++j)if(D[176][j].charCodeAt(0)!==65533){e[D[176][j]]=176*256+j;d[176*256+j]=D[176][j]}D[177]="����������������������������������������������������������������娼婢婚婆婊孰寇寅寄寂宿密尉專將屠屜屝崇崆崎崛崖崢崑崩崔崙崤崧崗巢常帶帳帷康庸庶庵庾張強彗彬彩彫得徙從徘御徠徜恿患悉悠您惋悴惦悽����������������������������������情悻悵惜悼惘惕惆惟悸惚惇戚戛扈掠控捲掖探接捷捧掘措捱掩掉掃掛捫推掄授掙採掬排掏掀捻捩捨捺敝敖救教敗啟敏敘敕敔斜斛斬族旋旌旎晝晚晤晨晦晞曹勗望梁梯梢梓梵桿桶梱梧梗械梃棄梭梆梅梔條梨梟梡梂欲殺�".split("");for(j=0;j!=D[177].length;++j)if(D[177][j].charCodeAt(0)!==65533){e[D[177][j]]=177*256+j;d[177*256+j]=D[177][j]}D[178]="����������������������������������������������������������������毫毬氫涎涼淳淙液淡淌淤添淺清淇淋涯淑涮淞淹涸混淵淅淒渚涵淚淫淘淪深淮淨淆淄涪淬涿淦烹焉焊烽烯爽牽犁猜猛猖猓猙率琅琊球理現琍瓠瓶����������������������������������瓷甜產略畦畢異疏痔痕疵痊痍皎盔盒盛眷眾眼眶眸眺硫硃硎祥票祭移窒窕笠笨笛第符笙笞笮粒粗粕絆絃統紮紹紼絀細紳組累終紲紱缽羞羚翌翎習耜聊聆脯脖脣脫脩脰脤舂舵舷舶船莎莞莘荸莢莖莽莫莒莊莓莉莠荷荻荼�".split("");for(j=0;j!=D[178].length;++j)if(D[178][j].charCodeAt(0)!==65533){e[D[178][j]]=178*256+j;d[178*256+j]=D[178][j]}D[179]="����������������������������������������������������������������莆莧處彪蛇蛀蚶蛄蚵蛆蛋蚱蚯蛉術袞袈被袒袖袍袋覓規訪訝訣訥許設訟訛訢豉豚販責貫貨貪貧赧赦趾趺軛軟這逍通逗連速逝逐逕逞造透逢逖逛途����������������������������������部郭都酗野釵釦釣釧釭釩閉陪陵陳陸陰陴陶陷陬雀雪雩章竟頂頃魚鳥鹵鹿麥麻傢傍傅備傑傀傖傘傚最凱割剴創剩勞勝勛博厥啻喀喧啼喊喝喘喂喜喪喔喇喋喃喳單喟唾喲喚喻喬喱啾喉喫喙圍堯堪場堤堰報堡堝堠壹壺奠�".split("");for(j=0;j!=D[179].length;++j)if(D[179][j].charCodeAt(0)!==65533){e[D[179][j]]=179*256+j;d[179*256+j]=D[179][j]}D[180]="����������������������������������������������������������������婷媚婿媒媛媧孳孱寒富寓寐尊尋就嵌嵐崴嵇巽幅帽幀幃幾廊廁廂廄弼彭復循徨惑惡悲悶惠愜愣惺愕惰惻惴慨惱愎惶愉愀愒戟扉掣掌描揀揩揉揆揍����������������������������������插揣提握揖揭揮捶援揪換摒揚揹敞敦敢散斑斐斯普晰晴晶景暑智晾晷曾替期朝棺棕棠棘棗椅棟棵森棧棹棒棲棣棋棍植椒椎棉棚楮棻款欺欽殘殖殼毯氮氯氬港游湔渡渲湧湊渠渥渣減湛湘渤湖湮渭渦湯渴湍渺測湃渝渾滋�".split("");for(j=0;j!=D[180].length;++j)if(D[180][j].charCodeAt(0)!==65533){e[D[180][j]]=180*256+j;d[180*256+j]=D[180][j]}D[181]="����������������������������������������������������������������溉渙湎湣湄湲湩湟焙焚焦焰無然煮焜牌犄犀猶猥猴猩琺琪琳琢琥琵琶琴琯琛琦琨甥甦畫番痢痛痣痙痘痞痠登發皖皓皴盜睏短硝硬硯稍稈程稅稀窘����������������������������������窗窖童竣等策筆筐筒答筍筋筏筑粟粥絞結絨絕紫絮絲絡給絢絰絳善翔翕耋聒肅腕腔腋腑腎脹腆脾腌腓腴舒舜菩萃菸萍菠菅萋菁華菱菴著萊菰萌菌菽菲菊萸萎萄菜萇菔菟虛蛟蛙蛭蛔蛛蛤蛐蛞街裁裂袱覃視註詠評詞証詁�".split("");for(j=0;j!=D[181].length;++j)if(D[181][j].charCodeAt(0)!==65533){e[D[181][j]]=181*256+j;d[181*256+j]=D[181][j]}D[182]="����������������������������������������������������������������詔詛詐詆訴診訶詖象貂貯貼貳貽賁費賀貴買貶貿貸越超趁跎距跋跚跑跌跛跆軻軸軼辜逮逵週逸進逶鄂郵鄉郾酣酥量鈔鈕鈣鈉鈞鈍鈐鈇鈑閔閏開閑����������������������������������間閒閎隊階隋陽隅隆隍陲隄雁雅雄集雇雯雲韌項順須飧飪飯飩飲飭馮馭黃黍黑亂傭債傲傳僅傾催傷傻傯僇剿剷剽募勦勤勢勣匯嗟嗨嗓嗦嗎嗜嗇嗑嗣嗤嗯嗚嗡嗅嗆嗥嗉園圓塞塑塘塗塚塔填塌塭塊塢塒塋奧嫁嫉嫌媾媽媼�".split("");for(j=0;j!=D[182].length;++j)if(D[182][j].charCodeAt(0)!==65533){e[D[182][j]]=182*256+j;d[182*256+j]=D[182][j]}D[183]="����������������������������������������������������������������媳嫂媲嵩嵯幌幹廉廈弒彙徬微愚意慈感想愛惹愁愈慎慌慄慍愾愴愧愍愆愷戡戢搓搾搞搪搭搽搬搏搜搔損搶搖搗搆敬斟新暗暉暇暈暖暄暘暍會榔業����������������������������������楚楷楠楔極椰概楊楨楫楞楓楹榆楝楣楛歇歲毀殿毓毽溢溯滓溶滂源溝滇滅溥溘溼溺溫滑準溜滄滔溪溧溴煎煙煩煤煉照煜煬煦煌煥煞煆煨煖爺牒猷獅猿猾瑯瑚瑕瑟瑞瑁琿瑙瑛瑜當畸瘀痰瘁痲痱痺痿痴痳盞盟睛睫睦睞督�".split("");for(j=0;j!=D[183].length;++j)if(D[183][j].charCodeAt(0)!==65533){e[D[183][j]]=183*256+j;d[183*256+j]=D[183][j]}D[184]="����������������������������������������������������������������睹睪睬睜睥睨睢矮碎碰碗碘碌碉硼碑碓硿祺祿禁萬禽稜稚稠稔稟稞窟窠筷節筠筮筧粱粳粵經絹綑綁綏絛置罩罪署義羨群聖聘肆肄腱腰腸腥腮腳腫����������������������������������腹腺腦舅艇蒂葷落萱葵葦葫葉葬葛萼萵葡董葩葭葆虞虜號蛹蜓蜈蜇蜀蛾蛻蜂蜃蜆蜊衙裟裔裙補裘裝裡裊裕裒覜解詫該詳試詩詰誇詼詣誠話誅詭詢詮詬詹詻訾詨豢貊貉賊資賈賄貲賃賂賅跡跟跨路跳跺跪跤跦躲較載軾輊�".split("");for(j=0;j!=D[184].length;++j)if(D[184][j].charCodeAt(0)!==65533){e[D[184][j]]=184*256+j;d[184*256+j]=D[184][j]}D[185]="����������������������������������������������������������������辟農運遊道遂達逼違遐遇遏過遍遑逾遁鄒鄗酬酪酩釉鈷鉗鈸鈽鉀鈾鉛鉋鉤鉑鈴鉉鉍鉅鈹鈿鉚閘隘隔隕雍雋雉雊雷電雹零靖靴靶預頑頓頊頒頌飼飴����������������������������������飽飾馳馱馴髡鳩麂鼎鼓鼠僧僮僥僖僭僚僕像僑僱僎僩兢凳劃劂匱厭嗾嘀嘛嘗嗽嘔嘆嘉嘍嘎嗷嘖嘟嘈嘐嗶團圖塵塾境墓墊塹墅塽壽夥夢夤奪奩嫡嫦嫩嫗嫖嫘嫣孵寞寧寡寥實寨寢寤察對屢嶄嶇幛幣幕幗幔廓廖弊彆彰徹慇�".split("");for(j=0;j!=D[185].length;++j)if(D[185][j].charCodeAt(0)!==65533){e[D[185][j]]=185*256+j;d[185*256+j]=D[185][j]}D[186]="����������������������������������������������������������������愿態慷慢慣慟慚慘慵截撇摘摔撤摸摟摺摑摧搴摭摻敲斡旗旖暢暨暝榜榨榕槁榮槓構榛榷榻榫榴槐槍榭槌榦槃榣歉歌氳漳演滾漓滴漩漾漠漬漏漂漢����������������������������������滿滯漆漱漸漲漣漕漫漯澈漪滬漁滲滌滷熔熙煽熊熄熒爾犒犖獄獐瑤瑣瑪瑰瑭甄疑瘧瘍瘋瘉瘓盡監瞄睽睿睡磁碟碧碳碩碣禎福禍種稱窪窩竭端管箕箋筵算箝箔箏箸箇箄粹粽精綻綰綜綽綾綠緊綴網綱綺綢綿綵綸維緒緇綬�".split("");for(j=0;j!=D[186].length;++j)if(D[186][j].charCodeAt(0)!==65533){e[D[186][j]]=186*256+j;d[186*256+j]=D[186][j]}D[187]="����������������������������������������������������������������罰翠翡翟聞聚肇腐膀膏膈膊腿膂臧臺與舔舞艋蓉蒿蓆蓄蒙蒞蒲蒜蓋蒸蓀蓓蒐蒼蓑蓊蜿蜜蜻蜢蜥蜴蜘蝕蜷蜩裳褂裴裹裸製裨褚裯誦誌語誣認誡誓誤����������������������������������說誥誨誘誑誚誧豪貍貌賓賑賒赫趙趕跼輔輒輕輓辣遠遘遜遣遙遞遢遝遛鄙鄘鄞酵酸酷酴鉸銀銅銘銖鉻銓銜銨鉼銑閡閨閩閣閥閤隙障際雌雒需靼鞅韶頗領颯颱餃餅餌餉駁骯骰髦魁魂鳴鳶鳳麼鼻齊億儀僻僵價儂儈儉儅凜�".split("");for(j=0;j!=D[187].length;++j)if(D[187][j].charCodeAt(0)!==65533){e[D[187][j]]=187*256+j;d[187*256+j]=D[187][j]}D[188]="����������������������������������������������������������������劇劈劉劍劊勰厲嘮嘻嘹嘲嘿嘴嘩噓噎噗噴嘶嘯嘰墀墟增墳墜墮墩墦奭嬉嫻嬋嫵嬌嬈寮寬審寫層履嶝嶔幢幟幡廢廚廟廝廣廠彈影德徵慶慧慮慝慕憂����������������������������������慼慰慫慾憧憐憫憎憬憚憤憔憮戮摩摯摹撞撲撈撐撰撥撓撕撩撒撮播撫撚撬撙撢撳敵敷數暮暫暴暱樣樟槨樁樞標槽模樓樊槳樂樅槭樑歐歎殤毅毆漿潼澄潑潦潔澆潭潛潸潮澎潺潰潤澗潘滕潯潠潟熟熬熱熨牖犛獎獗瑩璋璃�".split("");for(j=0;j!=D[188].length;++j)if(D[188][j].charCodeAt(0)!==65533){e[D[188][j]]=188*256+j;d[188*256+j]=D[188][j]}D[189]="����������������������������������������������������������������瑾璀畿瘠瘩瘟瘤瘦瘡瘢皚皺盤瞎瞇瞌瞑瞋磋磅確磊碾磕碼磐稿稼穀稽稷稻窯窮箭箱範箴篆篇篁箠篌糊締練緯緻緘緬緝編緣線緞緩綞緙緲緹罵罷羯����������������������������������翩耦膛膜膝膠膚膘蔗蔽蔚蓮蔬蔭蔓蔑蔣蔡蔔蓬蔥蓿蔆螂蝴蝶蝠蝦蝸蝨蝙蝗蝌蝓衛衝褐複褒褓褕褊誼諒談諄誕請諸課諉諂調誰論諍誶誹諛豌豎豬賠賞賦賤賬賭賢賣賜質賡赭趟趣踫踐踝踢踏踩踟踡踞躺輝輛輟輩輦輪輜輞�".split("");for(j=0;j!=D[189].length;++j)if(D[189][j].charCodeAt(0)!==65533){e[D[189][j]]=189*256+j;d[189*256+j]=D[189][j]}D[190]="����������������������������������������������������������������輥適遮遨遭遷鄰鄭鄧鄱醇醉醋醃鋅銻銷鋪銬鋤鋁銳銼鋒鋇鋰銲閭閱霄霆震霉靠鞍鞋鞏頡頫頜颳養餓餒餘駝駐駟駛駑駕駒駙骷髮髯鬧魅魄魷魯鴆鴉����������������������������������鴃麩麾黎墨齒儒儘儔儐儕冀冪凝劑劓勳噙噫噹噩噤噸噪器噥噱噯噬噢噶壁墾壇壅奮嬝嬴學寰導彊憲憑憩憊懍憶憾懊懈戰擅擁擋撻撼據擄擇擂操撿擒擔撾整曆曉暹曄曇暸樽樸樺橙橫橘樹橄橢橡橋橇樵機橈歙歷氅濂澱澡�".split("");for(j=0;j!=D[190].length;++j)if(D[190][j].charCodeAt(0)!==65533){e[D[190][j]]=190*256+j;d[190*256+j]=D[190][j]}D[191]="����������������������������������������������������������������濃澤濁澧澳激澹澶澦澠澴熾燉燐燒燈燕熹燎燙燜燃燄獨璜璣璘璟璞瓢甌甍瘴瘸瘺盧盥瞠瞞瞟瞥磨磚磬磧禦積穎穆穌穋窺篙簑築篤篛篡篩篦糕糖縊����������������������������������縑縈縛縣縞縝縉縐罹羲翰翱翮耨膳膩膨臻興艘艙蕊蕙蕈蕨蕩蕃蕉蕭蕪蕞螃螟螞螢融衡褪褲褥褫褡親覦諦諺諫諱謀諜諧諮諾謁謂諷諭諳諶諼豫豭貓賴蹄踱踴蹂踹踵輻輯輸輳辨辦遵遴選遲遼遺鄴醒錠錶鋸錳錯錢鋼錫錄錚�".split("");for(j=0;j!=D[191].length;++j)if(D[191][j].charCodeAt(0)!==65533){e[D[191][j]]=191*256+j;d[191*256+j]=D[191][j]}D[192]="����������������������������������������������������������������錐錦錡錕錮錙閻隧隨險雕霎霑霖霍霓霏靛靜靦鞘頰頸頻頷頭頹頤餐館餞餛餡餚駭駢駱骸骼髻髭鬨鮑鴕鴣鴦鴨鴒鴛默黔龍龜優償儡儲勵嚎嚀嚐嚅嚇����������������������������������嚏壕壓壑壎嬰嬪嬤孺尷屨嶼嶺嶽嶸幫彌徽應懂懇懦懋戲戴擎擊擘擠擰擦擬擱擢擭斂斃曙曖檀檔檄檢檜櫛檣橾檗檐檠歜殮毚氈濘濱濟濠濛濤濫濯澀濬濡濩濕濮濰燧營燮燦燥燭燬燴燠爵牆獰獲璩環璦璨癆療癌盪瞳瞪瞰瞬�".split("");for(j=0;j!=D[192].length;++j)if(D[192][j].charCodeAt(0)!==65533){e[D[192][j]]=192*256+j;d[192*256+j]=D[192][j]}D[193]="����������������������������������������������������������������瞧瞭矯磷磺磴磯礁禧禪穗窿簇簍篾篷簌篠糠糜糞糢糟糙糝縮績繆縷縲繃縫總縱繅繁縴縹繈縵縿縯罄翳翼聱聲聰聯聳臆臃膺臂臀膿膽臉膾臨舉艱薪����������������������������������薄蕾薜薑薔薯薛薇薨薊虧蟀蟑螳蟒蟆螫螻螺蟈蟋褻褶襄褸褽覬謎謗謙講謊謠謝謄謐豁谿豳賺賽購賸賻趨蹉蹋蹈蹊轄輾轂轅輿避遽還邁邂邀鄹醣醞醜鍍鎂錨鍵鍊鍥鍋錘鍾鍬鍛鍰鍚鍔闊闋闌闈闆隱隸雖霜霞鞠韓顆颶餵騁�".split("");for(j=0;j!=D[193].length;++j)if(D[193][j].charCodeAt(0)!==65533){e[D[193][j]]=193*256+j;d[193*256+j]=D[193][j]}D[194]="����������������������������������������������������������������駿鮮鮫鮪鮭鴻鴿麋黏點黜黝黛鼾齋叢嚕嚮壙壘嬸彝懣戳擴擲擾攆擺擻擷斷曜朦檳檬櫃檻檸櫂檮檯歟歸殯瀉瀋濾瀆濺瀑瀏燻燼燾燸獷獵璧璿甕癖癘����������������������������������癒瞽瞿瞻瞼礎禮穡穢穠竄竅簫簧簪簞簣簡糧織繕繞繚繡繒繙罈翹翻職聶臍臏舊藏薩藍藐藉薰薺薹薦蟯蟬蟲蟠覆覲觴謨謹謬謫豐贅蹙蹣蹦蹤蹟蹕軀轉轍邇邃邈醫醬釐鎔鎊鎖鎢鎳鎮鎬鎰鎘鎚鎗闔闖闐闕離雜雙雛雞霤鞣鞦�".split("");for(j=0;j!=D[194].length;++j)if(D[194][j].charCodeAt(0)!==65533){e[D[194][j]]=194*256+j;d[194*256+j]=D[194][j]}D[195]="����������������������������������������������������������������鞭韹額顏題顎顓颺餾餿餽餮馥騎髁鬃鬆魏魎魍鯊鯉鯽鯈鯀鵑鵝鵠黠鼕鼬儳嚥壞壟壢寵龐廬懲懷懶懵攀攏曠曝櫥櫝櫚櫓瀛瀟瀨瀚瀝瀕瀘爆爍牘犢獸����������������������������������獺璽瓊瓣疇疆癟癡矇礙禱穫穩簾簿簸簽簷籀繫繭繹繩繪羅繳羶羹羸臘藩藝藪藕藤藥藷蟻蠅蠍蟹蟾襠襟襖襞譁譜識證譚譎譏譆譙贈贊蹼蹲躇蹶蹬蹺蹴轔轎辭邊邋醱醮鏡鏑鏟鏃鏈鏜鏝鏖鏢鏍鏘鏤鏗鏨關隴難霪霧靡韜韻類�".split("");for(j=0;j!=D[195].length;++j)if(D[195][j].charCodeAt(0)!==65533){e[D[195][j]]=195*256+j;d[195*256+j]=D[195][j]}D[196]="����������������������������������������������������������������願顛颼饅饉騖騙鬍鯨鯧鯖鯛鶉鵡鵲鵪鵬麒麗麓麴勸嚨嚷嚶嚴嚼壤孀孃孽寶巉懸懺攘攔攙曦朧櫬瀾瀰瀲爐獻瓏癢癥礦礪礬礫竇競籌籃籍糯糰辮繽繼����������������������������������纂罌耀臚艦藻藹蘑藺蘆蘋蘇蘊蠔蠕襤覺觸議譬警譯譟譫贏贍躉躁躅躂醴釋鐘鐃鏽闡霰飄饒饑馨騫騰騷騵鰓鰍鹹麵黨鼯齟齣齡儷儸囁囀囂夔屬巍懼懾攝攜斕曩櫻欄櫺殲灌爛犧瓖瓔癩矓籐纏續羼蘗蘭蘚蠣蠢蠡蠟襪襬覽譴�".split("");for(j=0;j!=D[196].length;++j)if(D[196][j].charCodeAt(0)!==65533){e[D[196][j]]=196*256+j;d[196*256+j]=D[196][j]}D[197]="����������������������������������������������������������������護譽贓躊躍躋轟辯醺鐮鐳鐵鐺鐸鐲鐫闢霸霹露響顧顥饗驅驃驀騾髏魔魑鰭鰥鶯鶴鷂鶸麝黯鼙齜齦齧儼儻囈囊囉孿巔巒彎懿攤權歡灑灘玀瓤疊癮癬����������������������������������禳籠籟聾聽臟襲襯觼讀贖贗躑躓轡酈鑄鑑鑒霽霾韃韁顫饕驕驍髒鬚鱉鰱鰾鰻鷓鷗鼴齬齪龔囌巖戀攣攫攪曬欐瓚竊籤籣籥纓纖纔臢蘸蘿蠱變邐邏鑣鑠鑤靨顯饜驚驛驗髓體髑鱔鱗鱖鷥麟黴囑壩攬灞癱癲矗罐羈蠶蠹衢讓讒�".split("");for(j=0;j!=D[197].length;++j)if(D[197][j].charCodeAt(0)!==65533){e[D[197][j]]=197*256+j;d[197*256+j]=D[197][j]}D[198]="����������������������������������������������������������������讖艷贛釀鑪靂靈靄韆顰驟鬢魘鱟鷹鷺鹼鹽鼇齷齲廳欖灣籬籮蠻觀躡釁鑲鑰顱饞髖鬣黌灤矚讚鑷韉驢驥纜讜躪釅鑽鑾鑼鱷鱸黷豔鑿鸚爨驪鬱鸛鸞籲���������������������������������������������������������������������������������������������������������������������������������".split("");for(j=0;j!=D[198].length;++j)if(D[198][j].charCodeAt(0)!==65533){e[D[198][j]]=198*256+j;d[198*256+j]=D[198][j]}D[201]="����������������������������������������������������������������乂乜凵匚厂万丌乇亍囗兀屮彳丏冇与丮亓仂仉仈冘勼卬厹圠夃夬尐巿旡殳毌气爿丱丼仨仜仩仡仝仚刌匜卌圢圣夗夯宁宄尒尻屴屳帄庀庂忉戉扐氕����������������������������������氶汃氿氻犮犰玊禸肊阞伎优伬仵伔仱伀价伈伝伂伅伢伓伄仴伒冱刓刉刐劦匢匟卍厊吇囡囟圮圪圴夼妀奼妅奻奾奷奿孖尕尥屼屺屻屾巟幵庄异弚彴忕忔忏扜扞扤扡扦扢扙扠扚扥旯旮朾朹朸朻机朿朼朳氘汆汒汜汏汊汔汋�".split("");for(j=0;j!=D[201].length;++j)if(D[201][j].charCodeAt(0)!==65533){e[D[201][j]]=201*256+j;d[201*256+j]=D[201][j]}D[202]="����������������������������������������������������������������汌灱牞犴犵玎甪癿穵网艸艼芀艽艿虍襾邙邗邘邛邔阢阤阠阣佖伻佢佉体佤伾佧佒佟佁佘伭伳伿佡冏冹刜刞刡劭劮匉卣卲厎厏吰吷吪呔呅吙吜吥吘����������������������������������吽呏呁吨吤呇囮囧囥坁坅坌坉坋坒夆奀妦妘妠妗妎妢妐妏妧妡宎宒尨尪岍岏岈岋岉岒岊岆岓岕巠帊帎庋庉庌庈庍弅弝彸彶忒忑忐忭忨忮忳忡忤忣忺忯忷忻怀忴戺抃抌抎抏抔抇扱扻扺扰抁抈扷扽扲扴攷旰旴旳旲旵杅杇�".split("");for(j=0;j!=D[202].length;++j)if(D[202][j].charCodeAt(0)!==65533){e[D[202][j]]=202*256+j;d[202*256+j]=D[202][j]}D[203]="����������������������������������������������������������������杙杕杌杈杝杍杚杋毐氙氚汸汧汫沄沋沏汱汯汩沚汭沇沕沜汦汳汥汻沎灴灺牣犿犽狃狆狁犺狅玕玗玓玔玒町甹疔疕皁礽耴肕肙肐肒肜芐芏芅芎芑芓����������������������������������芊芃芄豸迉辿邟邡邥邞邧邠阰阨阯阭丳侘佼侅佽侀侇佶佴侉侄佷佌侗佪侚佹侁佸侐侜侔侞侒侂侕佫佮冞冼冾刵刲刳剆刱劼匊匋匼厒厔咇呿咁咑咂咈呫呺呾呥呬呴呦咍呯呡呠咘呣呧呤囷囹坯坲坭坫坱坰坶垀坵坻坳坴坢�".split("");for(j=0;j!=D[203].length;++j)if(D[203][j].charCodeAt(0)!==65533){e[D[203][j]]=203*256+j;d[203*256+j]=D[203][j]}D[204]="����������������������������������������������������������������坨坽夌奅妵妺姏姎妲姌姁妶妼姃姖妱妽姀姈妴姇孢孥宓宕屄屇岮岤岠岵岯岨岬岟岣岭岢岪岧岝岥岶岰岦帗帔帙弨弢弣弤彔徂彾彽忞忥怭怦怙怲怋����������������������������������怴怊怗怳怚怞怬怢怍怐怮怓怑怌怉怜戔戽抭抴拑抾抪抶拊抮抳抯抻抩抰抸攽斨斻昉旼昄昒昈旻昃昋昍昅旽昑昐曶朊枅杬枎枒杶杻枘枆构杴枍枌杺枟枑枙枃杽极杸杹枔欥殀歾毞氝沓泬泫泮泙沶泔沭泧沷泐泂沺泃泆泭泲�".split("");for(j=0;j!=D[204].length;++j)if(D[204][j].charCodeAt(0)!==65533){e[D[204][j]]=204*256+j;d[204*256+j]=D[204][j]}D[205]="����������������������������������������������������������������泒泝沴沊沝沀泞泀洰泍泇沰泹泏泩泑炔炘炅炓炆炄炑炖炂炚炃牪狖狋狘狉狜狒狔狚狌狑玤玡玭玦玢玠玬玝瓝瓨甿畀甾疌疘皯盳盱盰盵矸矼矹矻矺����������������������������������矷祂礿秅穸穻竻籵糽耵肏肮肣肸肵肭舠芠苀芫芚芘芛芵芧芮芼芞芺芴芨芡芩苂芤苃芶芢虰虯虭虮豖迒迋迓迍迖迕迗邲邴邯邳邰阹阽阼阺陃俍俅俓侲俉俋俁俔俜俙侻侳俛俇俖侺俀侹俬剄剉勀勂匽卼厗厖厙厘咺咡咭咥哏�".split("");for(j=0;j!=D[205].length;++j)if(D[205][j].charCodeAt(0)!==65533){e[D[205][j]]=205*256+j;d[205*256+j]=D[205][j]}D[206]="����������������������������������������������������������������哃茍咷咮哖咶哅哆咠呰咼咢咾呲哞咰垵垞垟垤垌垗垝垛垔垘垏垙垥垚垕壴复奓姡姞姮娀姱姝姺姽姼姶姤姲姷姛姩姳姵姠姾姴姭宨屌峐峘峌峗峋峛����������������������������������峞峚峉峇峊峖峓峔峏峈峆峎峟峸巹帡帢帣帠帤庰庤庢庛庣庥弇弮彖徆怷怹恔恲恞恅恓恇恉恛恌恀恂恟怤恄恘恦恮扂扃拏挍挋拵挎挃拫拹挏挌拸拶挀挓挔拺挕拻拰敁敃斪斿昶昡昲昵昜昦昢昳昫昺昝昴昹昮朏朐柁柲柈枺�".split("");for(j=0;j!=D[206].length;++j)if(D[206][j].charCodeAt(0)!==65533){e[D[206][j]]=206*256+j;d[206*256+j]=D[206][j]}D[207]="����������������������������������������������������������������柜枻柸柘柀枷柅柫柤柟枵柍枳柷柶柮柣柂枹柎柧柰枲柼柆柭柌枮柦柛柺柉柊柃柪柋欨殂殄殶毖毘毠氠氡洨洴洭洟洼洿洒洊泚洳洄洙洺洚洑洀洝浂����������������������������������洁洘洷洃洏浀洇洠洬洈洢洉洐炷炟炾炱炰炡炴炵炩牁牉牊牬牰牳牮狊狤狨狫狟狪狦狣玅珌珂珈珅玹玶玵玴珫玿珇玾珃珆玸珋瓬瓮甮畇畈疧疪癹盄眈眃眄眅眊盷盻盺矧矨砆砑砒砅砐砏砎砉砃砓祊祌祋祅祄秕种秏秖秎窀�".split("");for(j=0;j!=D[207].length;++j)if(D[207][j].charCodeAt(0)!==65533){e[D[207][j]]=207*256+j;d[207*256+j]=D[207][j]}D[208]="����������������������������������������������������������������穾竑笀笁籺籸籹籿粀粁紃紈紁罘羑羍羾耇耎耏耔耷胘胇胠胑胈胂胐胅胣胙胜胊胕胉胏胗胦胍臿舡芔苙苾苹茇苨茀苕茺苫苖苴苬苡苲苵茌苻苶苰苪����������������������������������苤苠苺苳苭虷虴虼虳衁衎衧衪衩觓訄訇赲迣迡迮迠郱邽邿郕郅邾郇郋郈釔釓陔陏陑陓陊陎倞倅倇倓倢倰倛俵俴倳倷倬俶俷倗倜倠倧倵倯倱倎党冔冓凊凄凅凈凎剡剚剒剞剟剕剢勍匎厞唦哢唗唒哧哳哤唚哿唄唈哫唑唅哱�".split("");for(j=0;j!=D[208].length;++j)if(D[208][j].charCodeAt(0)!==65533){e[D[208][j]]=208*256+j;d[208*256+j]=D[208][j]}D[209]="����������������������������������������������������������������唊哻哷哸哠唎唃唋圁圂埌堲埕埒垺埆垽垼垸垶垿埇埐垹埁夎奊娙娖娭娮娕娏娗娊娞娳孬宧宭宬尃屖屔峬峿峮峱峷崀峹帩帨庨庮庪庬弳弰彧恝恚恧����������������������������������恁悢悈悀悒悁悝悃悕悛悗悇悜悎戙扆拲挐捖挬捄捅挶捃揤挹捋捊挼挩捁挴捘捔捙挭捇挳捚捑挸捗捀捈敊敆旆旃旄旂晊晟晇晑朒朓栟栚桉栲栳栻桋桏栖栱栜栵栫栭栯桎桄栴栝栒栔栦栨栮桍栺栥栠欬欯欭欱欴歭肂殈毦毤�".split("");for(j=0;j!=D[209].length;++j)if(D[209][j].charCodeAt(0)!==65533){e[D[209][j]]=209*256+j;d[209*256+j]=D[209][j]}D[210]="����������������������������������������������������������������毨毣毢毧氥浺浣浤浶洍浡涒浘浢浭浯涑涍淯浿涆浞浧浠涗浰浼浟涂涘洯浨涋浾涀涄洖涃浻浽浵涐烜烓烑烝烋缹烢烗烒烞烠烔烍烅烆烇烚烎烡牂牸����������������������������������牷牶猀狺狴狾狶狳狻猁珓珙珥珖玼珧珣珩珜珒珛珔珝珚珗珘珨瓞瓟瓴瓵甡畛畟疰痁疻痄痀疿疶疺皊盉眝眛眐眓眒眣眑眕眙眚眢眧砣砬砢砵砯砨砮砫砡砩砳砪砱祔祛祏祜祓祒祑秫秬秠秮秭秪秜秞秝窆窉窅窋窌窊窇竘笐�".split("");for(j=0;j!=D[210].length;++j)if(D[210][j].charCodeAt(0)!==65533){e[D[210][j]]=210*256+j;d[210*256+j]=D[210][j]}D[211]="����������������������������������������������������������������笄笓笅笏笈笊笎笉笒粄粑粊粌粈粍粅紞紝紑紎紘紖紓紟紒紏紌罜罡罞罠罝罛羖羒翃翂翀耖耾耹胺胲胹胵脁胻脀舁舯舥茳茭荄茙荑茥荖茿荁茦茜茢����������������������������������荂荎茛茪茈茼荍茖茤茠茷茯茩荇荅荌荓茞茬荋茧荈虓虒蚢蚨蚖蚍蚑蚞蚇蚗蚆蚋蚚蚅蚥蚙蚡蚧蚕蚘蚎蚝蚐蚔衃衄衭衵衶衲袀衱衿衯袃衾衴衼訒豇豗豻貤貣赶赸趵趷趶軑軓迾迵适迿迻逄迼迶郖郠郙郚郣郟郥郘郛郗郜郤酐�".split("");for(j=0;j!=D[211].length;++j)if(D[211][j].charCodeAt(0)!==65533){e[D[211][j]]=211*256+j;d[211*256+j]=D[211][j]}D[212]="����������������������������������������������������������������酎酏釕釢釚陜陟隼飣髟鬯乿偰偪偡偞偠偓偋偝偲偈偍偁偛偊偢倕偅偟偩偫偣偤偆偀偮偳偗偑凐剫剭剬剮勖勓匭厜啵啶唼啍啐唴唪啑啢唶唵唰啒啅����������������������������������唌唲啥啎唹啈唭唻啀啋圊圇埻堔埢埶埜埴堀埭埽堈埸堋埳埏堇埮埣埲埥埬埡堎埼堐埧堁堌埱埩埰堍堄奜婠婘婕婧婞娸娵婭婐婟婥婬婓婤婗婃婝婒婄婛婈媎娾婍娹婌婰婩婇婑婖婂婜孲孮寁寀屙崞崋崝崚崠崌崨崍崦崥崏�".split("");for(j=0;j!=D[212].length;++j)if(D[212][j].charCodeAt(0)!==65533){e[D[212][j]]=212*256+j;d[212*256+j]=D[212][j]}D[213]="����������������������������������������������������������������崰崒崣崟崮帾帴庱庴庹庲庳弶弸徛徖徟悊悐悆悾悰悺惓惔惏惤惙惝惈悱惛悷惊悿惃惍惀挲捥掊掂捽掽掞掭掝掗掫掎捯掇掐据掯捵掜捭掮捼掤挻掟����������������������������������捸掅掁掑掍捰敓旍晥晡晛晙晜晢朘桹梇梐梜桭桮梮梫楖桯梣梬梩桵桴梲梏桷梒桼桫桲梪梀桱桾梛梖梋梠梉梤桸桻梑梌梊桽欶欳欷欸殑殏殍殎殌氪淀涫涴涳湴涬淩淢涷淶淔渀淈淠淟淖涾淥淜淝淛淴淊涽淭淰涺淕淂淏淉�".split("");for(j=0;j!=D[213].length;++j)if(D[213][j].charCodeAt(0)!==65533){e[D[213][j]]=213*256+j;d[213*256+j]=D[213][j]}D[214]="����������������������������������������������������������������淐淲淓淽淗淍淣涻烺焍烷焗烴焌烰焄烳焐烼烿焆焓焀烸烶焋焂焎牾牻牼牿猝猗猇猑猘猊猈狿猏猞玈珶珸珵琄琁珽琇琀珺珼珿琌琋珴琈畤畣痎痒痏����������������������������������痋痌痑痐皏皉盓眹眯眭眱眲眴眳眽眥眻眵硈硒硉硍硊硌砦硅硐祤祧祩祪祣祫祡离秺秸秶秷窏窔窐笵筇笴笥笰笢笤笳笘笪笝笱笫笭笯笲笸笚笣粔粘粖粣紵紽紸紶紺絅紬紩絁絇紾紿絊紻紨罣羕羜羝羛翊翋翍翐翑翇翏翉耟�".split("");for(j=0;j!=D[214].length;++j)if(D[214][j].charCodeAt(0)!==65533){e[D[214][j]]=214*256+j;d[214*256+j]=D[214][j]}D[215]="����������������������������������������������������������������耞耛聇聃聈脘脥脙脛脭脟脬脞脡脕脧脝脢舑舸舳舺舴舲艴莐莣莨莍荺荳莤荴莏莁莕莙荵莔莩荽莃莌莝莛莪莋荾莥莯莈莗莰荿莦莇莮荶莚虙虖蚿蚷����������������������������������蛂蛁蛅蚺蚰蛈蚹蚳蚸蛌蚴蚻蚼蛃蚽蚾衒袉袕袨袢袪袚袑袡袟袘袧袙袛袗袤袬袌袓袎覂觖觙觕訰訧訬訞谹谻豜豝豽貥赽赻赹趼跂趹趿跁軘軞軝軜軗軠軡逤逋逑逜逌逡郯郪郰郴郲郳郔郫郬郩酖酘酚酓酕釬釴釱釳釸釤釹釪�".split("");for(j=0;j!=D[215].length;++j)if(D[215][j].charCodeAt(0)!==65533){e[D[215][j]]=215*256+j;d[215*256+j]=D[215][j]}D[216]="����������������������������������������������������������������釫釷釨釮镺閆閈陼陭陫陱陯隿靪頄飥馗傛傕傔傞傋傣傃傌傎傝偨傜傒傂傇兟凔匒匑厤厧喑喨喥喭啷噅喢喓喈喏喵喁喣喒喤啽喌喦啿喕喡喎圌堩堷����������������������������������堙堞堧堣堨埵塈堥堜堛堳堿堶堮堹堸堭堬堻奡媯媔媟婺媢媞婸媦婼媥媬媕媮娷媄媊媗媃媋媩婻婽媌媜媏媓媝寪寍寋寔寑寊寎尌尰崷嵃嵫嵁嵋崿崵嵑嵎嵕崳崺嵒崽崱嵙嵂崹嵉崸崼崲崶嵀嵅幄幁彘徦徥徫惉悹惌惢惎惄愔�".split("");for(j=0;j!=D[216].length;++j)if(D[216][j].charCodeAt(0)!==65533){e[D[216][j]]=216*256+j;d[216*256+j]=D[216][j]}D[217]="����������������������������������������������������������������惲愊愖愅惵愓惸惼惾惁愃愘愝愐惿愄愋扊掔掱掰揎揥揨揯揃撝揳揊揠揶揕揲揵摡揟掾揝揜揄揘揓揂揇揌揋揈揰揗揙攲敧敪敤敜敨敥斌斝斞斮旐旒����������������������������������晼晬晻暀晱晹晪晲朁椌棓椄棜椪棬棪棱椏棖棷棫棤棶椓椐棳棡椇棌椈楰梴椑棯棆椔棸棐棽棼棨椋椊椗棎棈棝棞棦棴棑椆棔棩椕椥棇欹欻欿欼殔殗殙殕殽毰毲毳氰淼湆湇渟湉溈渼渽湅湢渫渿湁湝湳渜渳湋湀湑渻渃渮湞�".split("");for(j=0;j!=D[217].length;++j)if(D[217][j].charCodeAt(0)!==65533){e[D[217][j]]=217*256+j;d[217*256+j]=D[217][j]}D[218]="����������������������������������������������������������������湨湜湡渱渨湠湱湫渹渢渰湓湥渧湸湤湷湕湹湒湦渵渶湚焠焞焯烻焮焱焣焥焢焲焟焨焺焛牋牚犈犉犆犅犋猒猋猰猢猱猳猧猲猭猦猣猵猌琮琬琰琫琖����������������������������������琚琡琭琱琤琣琝琩琠琲瓻甯畯畬痧痚痡痦痝痟痤痗皕皒盚睆睇睄睍睅睊睎睋睌矞矬硠硤硥硜硭硱硪确硰硩硨硞硢祴祳祲祰稂稊稃稌稄窙竦竤筊笻筄筈筌筎筀筘筅粢粞粨粡絘絯絣絓絖絧絪絏絭絜絫絒絔絩絑絟絎缾缿罥�".split("");for(j=0;j!=D[218].length;++j)if(D[218][j].charCodeAt(0)!==65533){e[D[218][j]]=218*256+j;d[218*256+j]=D[218][j]}D[219]="����������������������������������������������������������������罦羢羠羡翗聑聏聐胾胔腃腊腒腏腇脽腍脺臦臮臷臸臹舄舼舽舿艵茻菏菹萣菀菨萒菧菤菼菶萐菆菈菫菣莿萁菝菥菘菿菡菋菎菖菵菉萉萏菞萑萆菂菳����������������������������������菕菺菇菑菪萓菃菬菮菄菻菗菢萛菛菾蛘蛢蛦蛓蛣蛚蛪蛝蛫蛜蛬蛩蛗蛨蛑衈衖衕袺裗袹袸裀袾袶袼袷袽袲褁裉覕覘覗觝觚觛詎詍訹詙詀詗詘詄詅詒詈詑詊詌詏豟貁貀貺貾貰貹貵趄趀趉跘跓跍跇跖跜跏跕跙跈跗跅軯軷軺�".split("");for(j=0;j!=D[219].length;++j)if(D[219][j].charCodeAt(0)!==65533){e[D[219][j]]=219*256+j;d[219*256+j]=D[219][j]}D[220]="����������������������������������������������������������������軹軦軮軥軵軧軨軶軫軱軬軴軩逭逴逯鄆鄬鄄郿郼鄈郹郻鄁鄀鄇鄅鄃酡酤酟酢酠鈁鈊鈥鈃鈚鈦鈏鈌鈀鈒釿釽鈆鈄鈧鈂鈜鈤鈙鈗鈅鈖镻閍閌閐隇陾隈����������������������������������隉隃隀雂雈雃雱雰靬靰靮頇颩飫鳦黹亃亄亶傽傿僆傮僄僊傴僈僂傰僁傺傱僋僉傶傸凗剺剸剻剼嗃嗛嗌嗐嗋嗊嗝嗀嗔嗄嗩喿嗒喍嗏嗕嗢嗖嗈嗲嗍嗙嗂圔塓塨塤塏塍塉塯塕塎塝塙塥塛堽塣塱壼嫇嫄嫋媺媸媱媵媰媿嫈媻嫆�".split("");for(j=0;j!=D[220].length;++j)if(D[220][j].charCodeAt(0)!==65533){e[D[220][j]]=220*256+j;d[220*256+j]=D[220][j]}D[221]="����������������������������������������������������������������媷嫀嫊媴媶嫍媹媐寖寘寙尟尳嵱嵣嵊嵥嵲嵬嵞嵨嵧嵢巰幏幎幊幍幋廅廌廆廋廇彀徯徭惷慉慊愫慅愶愲愮慆愯慏愩慀戠酨戣戥戤揅揱揫搐搒搉搠搤����������������������������������搳摃搟搕搘搹搷搢搣搌搦搰搨摁搵搯搊搚摀搥搧搋揧搛搮搡搎敯斒旓暆暌暕暐暋暊暙暔晸朠楦楟椸楎楢楱椿楅楪椹楂楗楙楺楈楉椵楬椳椽楥棰楸椴楩楀楯楄楶楘楁楴楌椻楋椷楜楏楑椲楒椯楻椼歆歅歃歂歈歁殛嗀毻毼�".split("");for(j=0;j!=D[221].length;++j)if(D[221][j].charCodeAt(0)!==65533){e[D[221][j]]=221*256+j;d[221*256+j]=D[221][j]}D[222]="����������������������������������������������������������������毹毷毸溛滖滈溏滀溟溓溔溠溱溹滆滒溽滁溞滉溷溰滍溦滏溲溾滃滜滘溙溒溎溍溤溡溿溳滐滊溗溮溣煇煔煒煣煠煁煝煢煲煸煪煡煂煘煃煋煰煟煐煓����������������������������������煄煍煚牏犍犌犑犐犎猼獂猻猺獀獊獉瑄瑊瑋瑒瑑瑗瑀瑏瑐瑎瑂瑆瑍瑔瓡瓿瓾瓽甝畹畷榃痯瘏瘃痷痾痼痹痸瘐痻痶痭痵痽皙皵盝睕睟睠睒睖睚睩睧睔睙睭矠碇碚碔碏碄碕碅碆碡碃硹碙碀碖硻祼禂祽祹稑稘稙稒稗稕稢稓�".split("");for(j=0;j!=D[222].length;++j)if(D[222][j].charCodeAt(0)!==65533){e[D[222][j]]=222*256+j;d[222*256+j]=D[222][j]}D[223]="����������������������������������������������������������������稛稐窣窢窞竫筦筤筭筴筩筲筥筳筱筰筡筸筶筣粲粴粯綈綆綀綍絿綅絺綎絻綃絼綌綔綄絽綒罭罫罧罨罬羦羥羧翛翜耡腤腠腷腜腩腛腢腲朡腞腶腧腯����������������������������������腄腡舝艉艄艀艂艅蓱萿葖葶葹蒏蒍葥葑葀蒆葧萰葍葽葚葙葴葳葝蔇葞萷萺萴葺葃葸萲葅萩菙葋萯葂萭葟葰萹葎葌葒葯蓅蒎萻葇萶萳葨葾葄萫葠葔葮葐蜋蜄蛷蜌蛺蛖蛵蝍蛸蜎蜉蜁蛶蜍蜅裖裋裍裎裞裛裚裌裐覅覛觟觥觤�".split("");for(j=0;j!=D[223].length;++j)if(D[223][j].charCodeAt(0)!==65533){e[D[223][j]]=223*256+j;d[223*256+j]=D[223][j]}D[224]="����������������������������������������������������������������觡觠觢觜触詶誆詿詡訿詷誂誄詵誃誁詴詺谼豋豊豥豤豦貆貄貅賌赨赩趑趌趎趏趍趓趔趐趒跰跠跬跱跮跐跩跣跢跧跲跫跴輆軿輁輀輅輇輈輂輋遒逿����������������������������������遄遉逽鄐鄍鄏鄑鄖鄔鄋鄎酮酯鉈鉒鈰鈺鉦鈳鉥鉞銃鈮鉊鉆鉭鉬鉏鉠鉧鉯鈶鉡鉰鈱鉔鉣鉐鉲鉎鉓鉌鉖鈲閟閜閞閛隒隓隑隗雎雺雽雸雵靳靷靸靲頏頍頎颬飶飹馯馲馰馵骭骫魛鳪鳭鳧麀黽僦僔僗僨僳僛僪僝僤僓僬僰僯僣僠�".split("");for(j=0;j!=D[224].length;++j)if(D[224][j].charCodeAt(0)!==65533){e[D[224][j]]=224*256+j;d[224*256+j]=D[224][j]}D[225]="����������������������������������������������������������������凘劀劁勩勫匰厬嘧嘕嘌嘒嗼嘏嘜嘁嘓嘂嗺嘝嘄嗿嗹墉塼墐墘墆墁塿塴墋塺墇墑墎塶墂墈塻墔墏壾奫嫜嫮嫥嫕嫪嫚嫭嫫嫳嫢嫠嫛嫬嫞嫝嫙嫨嫟孷寠����������������������������������寣屣嶂嶀嵽嶆嵺嶁嵷嶊嶉嶈嵾嵼嶍嵹嵿幘幙幓廘廑廗廎廜廕廙廒廔彄彃彯徶愬愨慁慞慱慳慒慓慲慬憀慴慔慺慛慥愻慪慡慖戩戧戫搫摍摛摝摴摶摲摳摽摵摦撦摎撂摞摜摋摓摠摐摿搿摬摫摙摥摷敳斠暡暠暟朅朄朢榱榶槉�".split("");for(j=0;j!=D[225].length;++j)if(D[225][j].charCodeAt(0)!==65533){e[D[225][j]]=225*256+j;d[225*256+j]=D[225][j]}D[226]="����������������������������������������������������������������榠槎榖榰榬榼榑榙榎榧榍榩榾榯榿槄榽榤槔榹槊榚槏榳榓榪榡榞槙榗榐槂榵榥槆歊歍歋殞殟殠毃毄毾滎滵滱漃漥滸漷滻漮漉潎漙漚漧漘漻漒滭漊����������������������������������漶潳滹滮漭潀漰漼漵滫漇漎潃漅滽滶漹漜滼漺漟漍漞漈漡熇熐熉熀熅熂熏煻熆熁熗牄牓犗犕犓獃獍獑獌瑢瑳瑱瑵瑲瑧瑮甀甂甃畽疐瘖瘈瘌瘕瘑瘊瘔皸瞁睼瞅瞂睮瞀睯睾瞃碲碪碴碭碨硾碫碞碥碠碬碢碤禘禊禋禖禕禔禓�".split("");for(j=0;j!=D[226].length;++j)if(D[226][j].charCodeAt(0)!==65533){e[D[226][j]]=226*256+j;d[226*256+j]=D[226][j]}D[227]="����������������������������������������������������������������禗禈禒禐稫穊稰稯稨稦窨窫窬竮箈箜箊箑箐箖箍箌箛箎箅箘劄箙箤箂粻粿粼粺綧綷緂綣綪緁緀緅綝緎緄緆緋緌綯綹綖綼綟綦綮綩綡緉罳翢翣翥翞����������������������������������耤聝聜膉膆膃膇膍膌膋舕蒗蒤蒡蒟蒺蓎蓂蒬蒮蒫蒹蒴蓁蓍蒪蒚蒱蓐蒝蒧蒻蒢蒔蓇蓌蒛蒩蒯蒨蓖蒘蒶蓏蒠蓗蓔蓒蓛蒰蒑虡蜳蜣蜨蝫蝀蜮蜞蜡蜙蜛蝃蜬蝁蜾蝆蜠蜲蜪蜭蜼蜒蜺蜱蜵蝂蜦蜧蜸蜤蜚蜰蜑裷裧裱裲裺裾裮裼裶裻�".split("");for(j=0;j!=D[227].length;++j)if(D[227][j].charCodeAt(0)!==65533){e[D[227][j]]=227*256+j;d[227*256+j]=D[227][j]}D[228]="����������������������������������������������������������������裰裬裫覝覡覟覞觩觫觨誫誙誋誒誏誖谽豨豩賕賏賗趖踉踂跿踍跽踊踃踇踆踅跾踀踄輐輑輎輍鄣鄜鄠鄢鄟鄝鄚鄤鄡鄛酺酲酹酳銥銤鉶銛鉺銠銔銪銍����������������������������������銦銚銫鉹銗鉿銣鋮銎銂銕銢鉽銈銡銊銆銌銙銧鉾銇銩銝銋鈭隞隡雿靘靽靺靾鞃鞀鞂靻鞄鞁靿韎韍頖颭颮餂餀餇馝馜駃馹馻馺駂馽駇骱髣髧鬾鬿魠魡魟鳱鳲鳵麧僿儃儰僸儆儇僶僾儋儌僽儊劋劌勱勯噈噂噌嘵噁噊噉噆噘�".split("");for(j=0;j!=D[228].length;++j)if(D[228][j].charCodeAt(0)!==65533){e[D[228][j]]=228*256+j;d[228*256+j]=D[228][j]}D[229]="����������������������������������������������������������������噚噀嘳嘽嘬嘾嘸嘪嘺圚墫墝墱墠墣墯墬墥墡壿嫿嫴嫽嫷嫶嬃嫸嬂嫹嬁嬇嬅嬏屧嶙嶗嶟嶒嶢嶓嶕嶠嶜嶡嶚嶞幩幝幠幜緳廛廞廡彉徲憋憃慹憱憰憢憉����������������������������������憛憓憯憭憟憒憪憡憍慦憳戭摮摰撖撠撅撗撜撏撋撊撌撣撟摨撱撘敶敺敹敻斲斳暵暰暩暲暷暪暯樀樆樗槥槸樕槱槤樠槿槬槢樛樝槾樧槲槮樔槷槧橀樈槦槻樍槼槫樉樄樘樥樏槶樦樇槴樖歑殥殣殢殦氁氀毿氂潁漦潾澇濆澒�".split("");for(j=0;j!=D[229].length;++j)if(D[229][j].charCodeAt(0)!==65533){e[D[229][j]]=229*256+j;d[229*256+j]=D[229][j]}D[230]="����������������������������������������������������������������澍澉澌潢潏澅潚澖潶潬澂潕潲潒潐潗澔澓潝漀潡潫潽潧澐潓澋潩潿澕潣潷潪潻熲熯熛熰熠熚熩熵熝熥熞熤熡熪熜熧熳犘犚獘獒獞獟獠獝獛獡獚獙����������������������������������獢璇璉璊璆璁瑽璅璈瑼瑹甈甇畾瘥瘞瘙瘝瘜瘣瘚瘨瘛皜皝皞皛瞍瞏瞉瞈磍碻磏磌磑磎磔磈磃磄磉禚禡禠禜禢禛歶稹窲窴窳箷篋箾箬篎箯箹篊箵糅糈糌糋緷緛緪緧緗緡縃緺緦緶緱緰緮緟罶羬羰羭翭翫翪翬翦翨聤聧膣膟�".split("");
for(j=0;j!=D[230].length;++j)if(D[230][j].charCodeAt(0)!==65533){e[D[230][j]]=230*256+j;d[230*256+j]=D[230][j]}D[231]="����������������������������������������������������������������膞膕膢膙膗舖艏艓艒艐艎艑蔤蔻蔏蔀蔩蔎蔉蔍蔟蔊蔧蔜蓻蔫蓺蔈蔌蓴蔪蓲蔕蓷蓫蓳蓼蔒蓪蓩蔖蓾蔨蔝蔮蔂蓽蔞蓶蔱蔦蓧蓨蓰蓯蓹蔘蔠蔰蔋蔙蔯虢����������������������������������蝖蝣蝤蝷蟡蝳蝘蝔蝛蝒蝡蝚蝑蝞蝭蝪蝐蝎蝟蝝蝯蝬蝺蝮蝜蝥蝏蝻蝵蝢蝧蝩衚褅褌褔褋褗褘褙褆褖褑褎褉覢覤覣觭觰觬諏諆誸諓諑諔諕誻諗誾諀諅諘諃誺誽諙谾豍貏賥賟賙賨賚賝賧趠趜趡趛踠踣踥踤踮踕踛踖踑踙踦踧�".split("");for(j=0;j!=D[231].length;++j)if(D[231][j].charCodeAt(0)!==65533){e[D[231][j]]=231*256+j;d[231*256+j]=D[231][j]}D[232]="����������������������������������������������������������������踔踒踘踓踜踗踚輬輤輘輚輠輣輖輗遳遰遯遧遫鄯鄫鄩鄪鄲鄦鄮醅醆醊醁醂醄醀鋐鋃鋄鋀鋙銶鋏鋱鋟鋘鋩鋗鋝鋌鋯鋂鋨鋊鋈鋎鋦鋍鋕鋉鋠鋞鋧鋑鋓����������������������������������銵鋡鋆銴镼閬閫閮閰隤隢雓霅霈霂靚鞊鞎鞈韐韏頞頝頦頩頨頠頛頧颲餈飺餑餔餖餗餕駜駍駏駓駔駎駉駖駘駋駗駌骳髬髫髳髲髱魆魃魧魴魱魦魶魵魰魨魤魬鳼鳺鳽鳿鳷鴇鴀鳹鳻鴈鴅鴄麃黓鼏鼐儜儓儗儚儑凞匴叡噰噠噮�".split("");for(j=0;j!=D[232].length;++j)if(D[232][j].charCodeAt(0)!==65533){e[D[232][j]]=232*256+j;d[232*256+j]=D[232][j]}D[233]="����������������������������������������������������������������噳噦噣噭噲噞噷圜圛壈墽壉墿墺壂墼壆嬗嬙嬛嬡嬔嬓嬐嬖嬨嬚嬠嬞寯嶬嶱嶩嶧嶵嶰嶮嶪嶨嶲嶭嶯嶴幧幨幦幯廩廧廦廨廥彋徼憝憨憖懅憴懆懁懌憺����������������������������������憿憸憌擗擖擐擏擉撽撉擃擛擳擙攳敿敼斢曈暾曀曊曋曏暽暻暺曌朣樴橦橉橧樲橨樾橝橭橶橛橑樨橚樻樿橁橪橤橐橏橔橯橩橠樼橞橖橕橍橎橆歕歔歖殧殪殫毈毇氄氃氆澭濋澣濇澼濎濈潞濄澽澞濊澨瀄澥澮澺澬澪濏澿澸�".split("");for(j=0;j!=D[233].length;++j)if(D[233][j].charCodeAt(0)!==65533){e[D[233][j]]=233*256+j;d[233*256+j]=D[233][j]}D[234]="����������������������������������������������������������������澢濉澫濍澯澲澰燅燂熿熸燖燀燁燋燔燊燇燏熽燘熼燆燚燛犝犞獩獦獧獬獥獫獪瑿璚璠璔璒璕璡甋疀瘯瘭瘱瘽瘳瘼瘵瘲瘰皻盦瞚瞝瞡瞜瞛瞢瞣瞕瞙����������������������������������瞗磝磩磥磪磞磣磛磡磢磭磟磠禤穄穈穇窶窸窵窱窷篞篣篧篝篕篥篚篨篹篔篪篢篜篫篘篟糒糔糗糐糑縒縡縗縌縟縠縓縎縜縕縚縢縋縏縖縍縔縥縤罃罻罼罺羱翯耪耩聬膱膦膮膹膵膫膰膬膴膲膷膧臲艕艖艗蕖蕅蕫蕍蕓蕡蕘�".split("");for(j=0;j!=D[234].length;++j)if(D[234][j].charCodeAt(0)!==65533){e[D[234][j]]=234*256+j;d[234*256+j]=D[234][j]}D[235]="����������������������������������������������������������������蕀蕆蕤蕁蕢蕄蕑蕇蕣蔾蕛蕱蕎蕮蕵蕕蕧蕠薌蕦蕝蕔蕥蕬虣虥虤螛螏螗螓螒螈螁螖螘蝹螇螣螅螐螑螝螄螔螜螚螉褞褦褰褭褮褧褱褢褩褣褯褬褟觱諠����������������������������������諢諲諴諵諝謔諤諟諰諈諞諡諨諿諯諻貑貒貐賵賮賱賰賳赬赮趥趧踳踾踸蹀蹅踶踼踽蹁踰踿躽輶輮輵輲輹輷輴遶遹遻邆郺鄳鄵鄶醓醐醑醍醏錧錞錈錟錆錏鍺錸錼錛錣錒錁鍆錭錎錍鋋錝鋺錥錓鋹鋷錴錂錤鋿錩錹錵錪錔錌�".split("");for(j=0;j!=D[235].length;++j)if(D[235][j].charCodeAt(0)!==65533){e[D[235][j]]=235*256+j;d[235*256+j]=D[235][j]}D[236]="����������������������������������������������������������������錋鋾錉錀鋻錖閼闍閾閹閺閶閿閵閽隩雔霋霒霐鞙鞗鞔韰韸頵頯頲餤餟餧餩馞駮駬駥駤駰駣駪駩駧骹骿骴骻髶髺髹髷鬳鮀鮅鮇魼魾魻鮂鮓鮒鮐魺鮕����������������������������������魽鮈鴥鴗鴠鴞鴔鴩鴝鴘鴢鴐鴙鴟麈麆麇麮麭黕黖黺鼒鼽儦儥儢儤儠儩勴嚓嚌嚍嚆嚄嚃噾嚂噿嚁壖壔壏壒嬭嬥嬲嬣嬬嬧嬦嬯嬮孻寱寲嶷幬幪徾徻懃憵憼懧懠懥懤懨懞擯擩擣擫擤擨斁斀斶旚曒檍檖檁檥檉檟檛檡檞檇檓檎�".split("");for(j=0;j!=D[236].length;++j)if(D[236][j].charCodeAt(0)!==65533){e[D[236][j]]=236*256+j;d[236*256+j]=D[236][j]}D[237]="����������������������������������������������������������������檕檃檨檤檑橿檦檚檅檌檒歛殭氉濌澩濴濔濣濜濭濧濦濞濲濝濢濨燡燱燨燲燤燰燢獳獮獯璗璲璫璐璪璭璱璥璯甐甑甒甏疄癃癈癉癇皤盩瞵瞫瞲瞷瞶����������������������������������瞴瞱瞨矰磳磽礂磻磼磲礅磹磾礄禫禨穜穛穖穘穔穚窾竀竁簅簏篲簀篿篻簎篴簋篳簂簉簃簁篸篽簆篰篱簐簊糨縭縼繂縳顈縸縪繉繀繇縩繌縰縻縶繄縺罅罿罾罽翴翲耬膻臄臌臊臅臇膼臩艛艚艜薃薀薏薧薕薠薋薣蕻薤薚薞�".split("");for(j=0;j!=D[237].length;++j)if(D[237][j].charCodeAt(0)!==65533){e[D[237][j]]=237*256+j;d[237*256+j]=D[237][j]}D[238]="����������������������������������������������������������������蕷蕼薉薡蕺蕸蕗薎薖薆薍薙薝薁薢薂薈薅蕹蕶薘薐薟虨螾螪螭蟅螰螬螹螵螼螮蟉蟃蟂蟌螷螯蟄蟊螴螶螿螸螽蟞螲褵褳褼褾襁襒褷襂覭覯覮觲觳謞����������������������������������謘謖謑謅謋謢謏謒謕謇謍謈謆謜謓謚豏豰豲豱豯貕貔賹赯蹎蹍蹓蹐蹌蹇轃轀邅遾鄸醚醢醛醙醟醡醝醠鎡鎃鎯鍤鍖鍇鍼鍘鍜鍶鍉鍐鍑鍠鍭鎏鍌鍪鍹鍗鍕鍒鍏鍱鍷鍻鍡鍞鍣鍧鎀鍎鍙闇闀闉闃闅閷隮隰隬霠霟霘霝霙鞚鞡鞜�".split("");for(j=0;j!=D[238].length;++j)if(D[238][j].charCodeAt(0)!==65533){e[D[238][j]]=238*256+j;d[238*256+j]=D[238][j]}D[239]="����������������������������������������������������������������鞞鞝韕韔韱顁顄顊顉顅顃餥餫餬餪餳餲餯餭餱餰馘馣馡騂駺駴駷駹駸駶駻駽駾駼騃骾髾髽鬁髼魈鮚鮨鮞鮛鮦鮡鮥鮤鮆鮢鮠鮯鴳鵁鵧鴶鴮鴯鴱鴸鴰����������������������������������鵅鵂鵃鴾鴷鵀鴽翵鴭麊麉麍麰黈黚黻黿鼤鼣鼢齔龠儱儭儮嚘嚜嚗嚚嚝嚙奰嬼屩屪巀幭幮懘懟懭懮懱懪懰懫懖懩擿攄擽擸攁攃擼斔旛曚曛曘櫅檹檽櫡櫆檺檶檷櫇檴檭歞毉氋瀇瀌瀍瀁瀅瀔瀎濿瀀濻瀦濼濷瀊爁燿燹爃燽獶�".split("");for(j=0;j!=D[239].length;++j)if(D[239][j].charCodeAt(0)!==65533){e[D[239][j]]=239*256+j;d[239*256+j]=D[239][j]}D[240]="����������������������������������������������������������������璸瓀璵瓁璾璶璻瓂甔甓癜癤癙癐癓癗癚皦皽盬矂瞺磿礌礓礔礉礐礒礑禭禬穟簜簩簙簠簟簭簝簦簨簢簥簰繜繐繖繣繘繢繟繑繠繗繓羵羳翷翸聵臑臒����������������������������������臐艟艞薴藆藀藃藂薳薵薽藇藄薿藋藎藈藅薱薶藒蘤薸薷薾虩蟧蟦蟢蟛蟫蟪蟥蟟蟳蟤蟔蟜蟓蟭蟘蟣螤蟗蟙蠁蟴蟨蟝襓襋襏襌襆襐襑襉謪謧謣謳謰謵譇謯謼謾謱謥謷謦謶謮謤謻謽謺豂豵貙貘貗賾贄贂贀蹜蹢蹠蹗蹖蹞蹥蹧�".split("");for(j=0;j!=D[240].length;++j)if(D[240][j].charCodeAt(0)!==65533){e[D[240][j]]=240*256+j;d[240*256+j]=D[240][j]}D[241]="����������������������������������������������������������������蹛蹚蹡蹝蹩蹔轆轇轈轋鄨鄺鄻鄾醨醥醧醯醪鎵鎌鎒鎷鎛鎝鎉鎧鎎鎪鎞鎦鎕鎈鎙鎟鎍鎱鎑鎲鎤鎨鎴鎣鎥闒闓闑隳雗雚巂雟雘雝霣霢霥鞬鞮鞨鞫鞤鞪����������������������������������鞢鞥韗韙韖韘韺顐顑顒颸饁餼餺騏騋騉騍騄騑騊騅騇騆髀髜鬈鬄鬅鬩鬵魊魌魋鯇鯆鯃鮿鯁鮵鮸鯓鮶鯄鮹鮽鵜鵓鵏鵊鵛鵋鵙鵖鵌鵗鵒鵔鵟鵘鵚麎麌黟鼁鼀鼖鼥鼫鼪鼩鼨齌齕儴儵劖勷厴嚫嚭嚦嚧嚪嚬壚壝壛夒嬽嬾嬿巃幰�".split("");for(j=0;j!=D[241].length;++j)if(D[241][j].charCodeAt(0)!==65533){e[D[241][j]]=241*256+j;d[241*256+j]=D[241][j]}D[242]="����������������������������������������������������������������徿懻攇攐攍攉攌攎斄旞旝曞櫧櫠櫌櫑櫙櫋櫟櫜櫐櫫櫏櫍櫞歠殰氌瀙瀧瀠瀖瀫瀡瀢瀣瀩瀗瀤瀜瀪爌爊爇爂爅犥犦犤犣犡瓋瓅璷瓃甖癠矉矊矄矱礝礛����������������������������������礡礜礗礞禰穧穨簳簼簹簬簻糬糪繶繵繸繰繷繯繺繲繴繨罋罊羃羆羷翽翾聸臗臕艤艡艣藫藱藭藙藡藨藚藗藬藲藸藘藟藣藜藑藰藦藯藞藢蠀蟺蠃蟶蟷蠉蠌蠋蠆蟼蠈蟿蠊蠂襢襚襛襗襡襜襘襝襙覈覷覶觶譐譈譊譀譓譖譔譋譕�".split("");for(j=0;j!=D[242].length;++j)if(D[242][j].charCodeAt(0)!==65533){e[D[242][j]]=242*256+j;d[242*256+j]=D[242][j]}D[243]="����������������������������������������������������������������譑譂譒譗豃豷豶貚贆贇贉趬趪趭趫蹭蹸蹳蹪蹯蹻軂轒轑轏轐轓辴酀鄿醰醭鏞鏇鏏鏂鏚鏐鏹鏬鏌鏙鎩鏦鏊鏔鏮鏣鏕鏄鏎鏀鏒鏧镽闚闛雡霩霫霬霨霦����������������������������������鞳鞷鞶韝韞韟顜顙顝顗颿颽颻颾饈饇饃馦馧騚騕騥騝騤騛騢騠騧騣騞騜騔髂鬋鬊鬎鬌鬷鯪鯫鯠鯞鯤鯦鯢鯰鯔鯗鯬鯜鯙鯥鯕鯡鯚鵷鶁鶊鶄鶈鵱鶀鵸鶆鶋鶌鵽鵫鵴鵵鵰鵩鶅鵳鵻鶂鵯鵹鵿鶇鵨麔麑黀黼鼭齀齁齍齖齗齘匷嚲�".split("");for(j=0;j!=D[243].length;++j)if(D[243][j].charCodeAt(0)!==65533){e[D[243][j]]=243*256+j;d[243*256+j]=D[243][j]}D[244]="����������������������������������������������������������������嚵嚳壣孅巆巇廮廯忀忁懹攗攖攕攓旟曨曣曤櫳櫰櫪櫨櫹櫱櫮櫯瀼瀵瀯瀷瀴瀱灂瀸瀿瀺瀹灀瀻瀳灁爓爔犨獽獼璺皫皪皾盭矌矎矏矍矲礥礣礧礨礤礩����������������������������������禲穮穬穭竷籉籈籊籇籅糮繻繾纁纀羺翿聹臛臙舋艨艩蘢藿蘁藾蘛蘀藶蘄蘉蘅蘌藽蠙蠐蠑蠗蠓蠖襣襦覹觷譠譪譝譨譣譥譧譭趮躆躈躄轙轖轗轕轘轚邍酃酁醷醵醲醳鐋鐓鏻鐠鐏鐔鏾鐕鐐鐨鐙鐍鏵鐀鏷鐇鐎鐖鐒鏺鐉鏸鐊鏿�".split("");for(j=0;j!=D[244].length;++j)if(D[244][j].charCodeAt(0)!==65533){e[D[244][j]]=244*256+j;d[244*256+j]=D[244][j]}D[245]="����������������������������������������������������������������鏼鐌鏶鐑鐆闞闠闟霮霯鞹鞻韽韾顠顢顣顟飁飂饐饎饙饌饋饓騲騴騱騬騪騶騩騮騸騭髇髊髆鬐鬒鬑鰋鰈鯷鰅鰒鯸鱀鰇鰎鰆鰗鰔鰉鶟鶙鶤鶝鶒鶘鶐鶛����������������������������������鶠鶔鶜鶪鶗鶡鶚鶢鶨鶞鶣鶿鶩鶖鶦鶧麙麛麚黥黤黧黦鼰鼮齛齠齞齝齙龑儺儹劘劗囃嚽嚾孈孇巋巏廱懽攛欂櫼欃櫸欀灃灄灊灈灉灅灆爝爚爙獾甗癪矐礭礱礯籔籓糲纊纇纈纋纆纍罍羻耰臝蘘蘪蘦蘟蘣蘜蘙蘧蘮蘡蘠蘩蘞蘥�".split("");for(j=0;j!=D[245].length;++j)if(D[245][j].charCodeAt(0)!==65533){e[D[245][j]]=245*256+j;d[245*256+j]=D[245][j]}D[246]="����������������������������������������������������������������蠩蠝蠛蠠蠤蠜蠫衊襭襩襮襫觺譹譸譅譺譻贐贔趯躎躌轞轛轝酆酄酅醹鐿鐻鐶鐩鐽鐼鐰鐹鐪鐷鐬鑀鐱闥闤闣霵霺鞿韡顤飉飆飀饘饖騹騽驆驄驂驁騺����������������������������������騿髍鬕鬗鬘鬖鬺魒鰫鰝鰜鰬鰣鰨鰩鰤鰡鶷鶶鶼鷁鷇鷊鷏鶾鷅鷃鶻鶵鷎鶹鶺鶬鷈鶱鶭鷌鶳鷍鶲鹺麜黫黮黭鼛鼘鼚鼱齎齥齤龒亹囆囅囋奱孋孌巕巑廲攡攠攦攢欋欈欉氍灕灖灗灒爞爟犩獿瓘瓕瓙瓗癭皭礵禴穰穱籗籜籙籛籚�".split("");for(j=0;j!=D[246].length;++j)if(D[246][j].charCodeAt(0)!==65533){e[D[246][j]]=246*256+j;d[246*256+j]=D[246][j]}D[247]="����������������������������������������������������������������糴糱纑罏羇臞艫蘴蘵蘳蘬蘲蘶蠬蠨蠦蠪蠥襱覿覾觻譾讄讂讆讅譿贕躕躔躚躒躐躖躗轠轢酇鑌鑐鑊鑋鑏鑇鑅鑈鑉鑆霿韣顪顩飋饔饛驎驓驔驌驏驈驊����������������������������������驉驒驐髐鬙鬫鬻魖魕鱆鱈鰿鱄鰹鰳鱁鰼鰷鰴鰲鰽鰶鷛鷒鷞鷚鷋鷐鷜鷑鷟鷩鷙鷘鷖鷵鷕鷝麶黰鼵鼳鼲齂齫龕龢儽劙壨壧奲孍巘蠯彏戁戃戄攩攥斖曫欑欒欏毊灛灚爢玂玁玃癰矔籧籦纕艬蘺虀蘹蘼蘱蘻蘾蠰蠲蠮蠳襶襴襳觾�".split("");for(j=0;j!=D[247].length;++j)if(D[247][j].charCodeAt(0)!==65533){e[D[247][j]]=247*256+j;d[247*256+j]=D[247][j]}D[248]="����������������������������������������������������������������讌讎讋讈豅贙躘轤轣醼鑢鑕鑝鑗鑞韄韅頀驖驙鬞鬟鬠鱒鱘鱐鱊鱍鱋鱕鱙鱌鱎鷻鷷鷯鷣鷫鷸鷤鷶鷡鷮鷦鷲鷰鷢鷬鷴鷳鷨鷭黂黐黲黳鼆鼜鼸鼷鼶齃齏����������������������������������齱齰齮齯囓囍孎屭攭曭曮欓灟灡灝灠爣瓛瓥矕礸禷禶籪纗羉艭虃蠸蠷蠵衋讔讕躞躟躠躝醾醽釂鑫鑨鑩雥靆靃靇韇韥驞髕魙鱣鱧鱦鱢鱞鱠鸂鷾鸇鸃鸆鸅鸀鸁鸉鷿鷽鸄麠鼞齆齴齵齶囔攮斸欘欙欗欚灢爦犪矘矙礹籩籫糶纚�".split("");for(j=0;j!=D[248].length;++j)if(D[248][j].charCodeAt(0)!==65533){e[D[248][j]]=248*256+j;d[248*256+j]=D[248][j]}D[249]="����������������������������������������������������������������纘纛纙臠臡虆虇虈襹襺襼襻觿讘讙躥躤躣鑮鑭鑯鑱鑳靉顲饟鱨鱮鱭鸋鸍鸐鸏鸒鸑麡黵鼉齇齸齻齺齹圞灦籯蠼趲躦釃鑴鑸鑶鑵驠鱴鱳鱱鱵鸔鸓黶鼊����������������������������������龤灨灥糷虪蠾蠽蠿讞貜躩軉靋顳顴飌饡馫驤驦驧鬤鸕鸗齈戇欞爧虌躨钂钀钁驩驨鬮鸙爩虋讟钃鱹麷癵驫鱺鸝灩灪麤齾齉龘碁銹裏墻恒粧嫺╔╦╗╠╬╣╚╩╝╒╤╕╞╪╡╘╧╛╓╥╖╟╫╢╙╨╜║═╭╮╰╯▓�".split("");for(j=0;j!=D[249].length;++j)if(D[249][j].charCodeAt(0)!==65533){e[D[249][j]]=249*256+j;d[249*256+j]=D[249][j]}return{enc:e,dec:d}}();cptable[1250]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€�‚�„…†‡�‰Š‹ŚŤŽŹ�‘’“”•–—�™š›śťžź ˇ˘Ł¤Ą¦§¨©Ş«¬­®Ż°±˛ł´µ¶·¸ąş»Ľ˝ľżŔÁÂĂÄĹĆÇČÉĘËĚÍÎĎĐŃŇÓÔŐÖ×ŘŮÚŰÜÝŢßŕáâăäĺćçčéęëěíîďđńňóôőö÷řůúűüýţ˙".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[1251]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ЂЃ‚ѓ„…†‡€‰Љ‹ЊЌЋЏђ‘’“”•–—�™љ›њќћџ ЎўЈ¤Ґ¦§Ё©Є«¬­®Ї°±Ііґµ¶·ё№є»јЅѕїАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[1252]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€�‚ƒ„…†‡ˆ‰Š‹Œ�Ž��‘’“”•–—˜™š›œ�žŸ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[1253]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€�‚ƒ„…†‡�‰�‹�����‘’“”•–—�™�›���� ΅Ά£¤¥¦§¨©�«¬­®―°±²³΄µ¶·ΈΉΊ»Ό½ΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ�ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ�".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[1254]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€�‚ƒ„…†‡ˆ‰Š‹Œ����‘’“”•–—˜™š›œ��Ÿ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏĞÑÒÓÔÕÖ×ØÙÚÛÜİŞßàáâãäåæçèéêëìíîïğñòóôõö÷øùúûüışÿ".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[1255]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€�‚ƒ„…†‡ˆ‰�‹�����‘’“”•–—˜™�›���� ¡¢£₪¥¦§¨©×«¬­®¯°±²³´µ¶·¸¹÷»¼½¾¿ְֱֲֳִֵֶַָֹ�ֻּֽ־ֿ׀ׁׂ׃װױײ׳״�������אבגדהוזחטיךכלםמןנסעףפץצקרשת��‎‏�".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[1256]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~€پ‚ƒ„…†‡ˆ‰ٹ‹Œچژڈگ‘’“”•–—ک™ڑ›œ‌‍ں ،¢£¤¥¦§¨©ھ«¬­®¯°±²³´µ¶·¸¹؛»¼½¾؟ہءآأؤإئابةتثجحخدذرزسشصض×طظعغـفقكàلâمنهوçèéêëىيîïًٌٍَôُِ÷ّùْûü‎‏ے".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[1e4]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤‹›ﬁﬂ‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[10006]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~Ä¹²É³ÖÜ΅àâä΄¨çéèêë£™îï•½‰ôö¦­ùûü†ΓΔΘΛΞΠß®©ΣΪ§≠°·Α±≤≥¥ΒΕΖΗΙΚΜΦΫΨΩάΝ¬ΟΡ≈Τ«»… ΥΧΆΈœ–―“”‘’÷ΉΊΌΎέήίόΏύαβψδεφγηιξκλμνοπώρστθωςχυζϊϋΐΰ�".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[10007]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ†°¢£§•¶І®©™Ђђ≠Ѓѓ∞±≤≥іµ∂ЈЄєЇїЉљЊњјЅ¬√ƒ≈∆«»… ЋћЌќѕ–—“”‘’÷„ЎўЏџ№Ёёяабвгдежзийклмнопрстуфхцчшщъыьэю¤".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[10029]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ÄĀāÉĄÖÜáąČäčĆćéŹźĎíďĒēĖóėôöõúĚěü†°Ę£§•¶ß®©™ę¨≠ģĮįĪ≤≥īĶ∂∑łĻļĽľĹĺŅņŃ¬√ńŇ∆«»… ňŐÕőŌ–—“”‘’÷◊ōŔŕŘ‹›řŖŗŠ‚„šŚśÁŤťÍŽžŪÓÔūŮÚůŰűŲųÝýķŻŁżĢˇ".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[10079]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûüÝ°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤ÐðÞþý·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();cptable[10081]=function(){var d="\x00\b	\n\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸĞğİıŞş‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙ�ˆ˜¯˘˙˚¸˝˛ˇ".split(""),e={};for(var i=0;i!=d.length;++i)if(d[i].charCodeAt(0)!==65533)e[d[i]]=i;return{enc:e,dec:d}}();if(typeof module!=="undefined"&&module.exports)module.exports=cptable;(function(root,factory){"use strict";if(typeof cptable==="undefined"){if(typeof require!=="undefined"){var cpt=require("./cptable");if(typeof module!=="undefined"&&module.exports)module.exports=factory(cpt);else root.cptable=factory(cpt)}else throw new Error("cptable not found")}else cptable=factory(cptable)})(this,function(cpt){"use strict";var magic={1200:"utf16le",1201:"utf16be",12000:"utf32le",12001:"utf32be",16969:"utf64le",20127:"ascii",65000:"utf7",65001:"utf8"};var sbcs_cache=[874,1250,1251,1252,1253,1254,1255,1256,1e4];var dbcs_cache=[932,936,949,950];var magic_cache=[65001];var magic_decode={};var magic_encode={};var cpecache={};var cpdcache=[];if(typeof Buffer!=="undefined"){var sbcs_encode=function(cp){var E=cpt[cp].enc;var EE=new Buffer(256*256);for(var i=0;i!=256*256;++i)EE[i]=0;Object.keys(E).forEach(function(e){EE[e.charCodeAt(0)]=E[e]});return function(data,ofmt){if(data instanceof Buffer)data=data.toString("utf8");var out=new Buffer(data.length),i;if(typeof data==="string"){for(i=0;i!=data.length;++i)out[i]=EE[data.charCodeAt(i)]}else{for(i=0;i!=data.length;++i)out[i]=EE[data[i].charCodeAt(0)]}if(!ofmt)return out;if(ofmt==="buf")return out;var arr=[].slice.call(out);if(ofmt==="arr")return arr;return arr.map(function(x){return String.fromCharCode(x)}).join("")}};var sbcs_decode=function(cp){var D=cpt[cp].dec;var DD=new Buffer(2*256*256);Object.keys(D).forEach(function(d){var w=D[d].charCodeAt(0);DD[2*d]=w%256;DD[2*d+1]=w>>8});return function(data){var out=new Buffer(2*data.length),w,i,j;if(data instanceof Buffer){for(i=0;i<data.length;i++){j=2*data[i];out[2*i]=DD[j];out[2*i+1]=DD[j+1]}}else if(typeof data==="string"){for(i=0;i<data.length;i++){j=2*data.charCodeAt(i);out[2*i]=DD[j];out[2*i+1]=DD[j+1]}}else{for(i=0;i<data.length;i++){j=2*data[i];out[2*i]=DD[j];out[2*i+1]=DD[j+1]}}return out.toString("ucs2")}};var dbcs_encode=function(cp){var E=cpt[cp].enc;var EE=new Buffer(2*256*256);for(var i=0;i!=2*256*256;++i)EE[i]=0;Object.keys(E).forEach(function(e){EE[2*e.charCodeAt(0)]=E[e]&255;EE[2*e.charCodeAt(0)+1]=E[e]>>8});return function(data,ofmt){if(data instanceof Buffer)data=data.toString("utf8");var out=new Buffer(2*data.length),i,j,k;if(typeof data==="string"){for(i=k=0;i!=data.length;++i){j=data.charCodeAt(i)*2;out[k++]=EE[j+1]||EE[j];if(EE[j+1]>0)out[k++]=EE[j]}out.length=k}else{for(i=k=0;i!=data.length;i++){j=data[i].charCodeAt(0)*2;out[k++]=EE[j+1]||EE[j];if(EE[j+1]>0)out[k++]=EE[j]}}if(!ofmt)return out;if(ofmt==="buf")return out;var arr=[].slice.call(out);if(ofmt==="arr")return arr;return arr.map(function(x){return String.fromCharCode(x)}).join("")}};var dbcs_decode=function(cp){var D=cpt[cp].dec;var DD=new Buffer(2*256*256);for(var i=0;i!=256*256;++i){DD[2*i]=255;DD[2*i+1]=253}Object.keys(D).forEach(function(d){var w=D[d].charCodeAt(0);DD[2*d]=w%256;DD[2*d+1]=w>>8});return function(data){var out=new Buffer(2*data.length),w,i,j,k=0;if(data instanceof Buffer){for(i=0;i<data.length;i++){j=2*data[i];if(DD[j]===255&&DD[j+1]===253){j=2*(256*data[i]+data[i+1]);++i}out[k++]=DD[j];out[k++]=DD[j+1]}}else if(typeof data==="string"){for(i=0;i<data.length;i++){j=2*data.charCodeAt(i);if(DD[j]===255&&DD[j+1]===253){j=2*(256*data.charCodeAt(i)+data.charCodeAt(i+1));++i}out[k++]=DD[j];out[k++]=DD[j+1]}}else{for(i=0;i<data.length;i++){j=2*data[i];if(DD[j]===255&&DD[j+1]===253){j=2*(256*data[i]+data[i+1]);++i}out[k++]=DD[j];out[k++]=DD[j+1]}}out.length=k;return out.toString("ucs2")}};magic_decode[65001]=function(data){var out=new Buffer(2*data.length),w,i,j=1,k=0,ww;for(i=0;i<data.length;i+=j){j=1;if(data[i]<128)w=data[i];else if(data[i]<224){w=(data[i]&31)*64+(data[i+1]&63);j=2}else{w=(data[i]&15)*4096+(data[i+1]&63)*64+(data[i+2]&63);j=3}out[k++]=w%256;out[k++]=w>>8}out.length=k;return out.toString("ucs2")}}var encache=function(cp){if(typeof Buffer!=="undefined"){sbcs_cache.forEach(function(s){cpdcache[s]=sbcs_decode(s);cpecache[s]=sbcs_encode(s)});dbcs_cache.forEach(function(s){cpdcache[s]=dbcs_decode(s);cpecache[s]=dbcs_encode(s)});magic_cache.forEach(function(s){if(magic_decode[s])cpdcache[s]=magic_decode[s];if(magic_encode[s])cpecache[s]=magic_encode[s]})}};var cp_decache=function(cp){delete cpdcache[cp];delete cpecache[cp]};var decache=function(){if(typeof Buffer!=="undefined"){sbcs_cache.forEach(cp_decache);dbcs_cache.forEach(cp_decache);magic_cache.forEach(cp_decache)}};var cache={encache:encache,decache:decache,sbcs:sbcs_cache,dbcs:dbcs_cache};encache();var BM="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var SetD="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'(),-./:?";var encode=function(cp,data,ofmt){var F;if(F=cpecache[cp])return F(data,ofmt);if(typeof Buffer!=="undefined"&&data instanceof Buffer)data=data.toString("utf8");var out=typeof Buffer!=="undefined"?new Buffer(4*data.length):[],w,i,j=0,c,tt;var C=cpt[cp],E,M;if(C&&(E=C.enc))for(i=0;i!=data.length;++i,++j){w=E[data[i]];out[j]=w%256;if(w>255){out[j]=w/256|0;out[++j]=w%256}}else if(M=magic[cp])switch(M){case"utf8":if(typeof Buffer!=="undefined"&&typeof data==="string"){out=new Buffer(data,M);j=out.length;break}for(i=0;i!=data.length;++i,++j){w=data[i].charCodeAt(0);if(w<=127)out[j]=w;else if(w<=2047){out[j]=192+(w>>6);out[++j]=128+w%64}else{out[j]=224+(w>>12);out[++j]=128+(w>>6)%64;out[++j]=128+w%64}}break;case"ascii":if(typeof Buffer!=="undefined"&&typeof data==="string"){out=new Buffer(data,M);j=out.length;break}for(i=0;i!=data.length;++i,++j){w=data[i].charCodeAt(0);if(w<=127)out[j]=w;else throw new Error("bad ascii "+w)}break;case"utf16le":if(typeof Buffer!=="undefined"&&typeof data==="string"){out=new Buffer(data,M);j=out.length;break}for(i=0;i!=data.length;++i){w=data[i].charCodeAt(0);out[j++]=w%256;out[j++]=w>>8}break;case"utf16be":for(i=0;i!=data.length;++i){w=data[i].charCodeAt(0);out[j++]=w>>8;out[j++]=w%256}break;case"utf32le":for(i=0;i!=data.length;++i){w=data[i].charCodeAt(0);out[j++]=w%256;w>>=8;out[j++]=w%256;w>>=8;out[j++]=w%256;w>>=8;out[j++]=w%256}break;case"utf32be":for(i=0;i!=data.length;++i){w=data[i].charCodeAt(0);out[j+3]=w%256;w>>=8;out[j+2]=w%256;w>>=8;out[j+1]=w%256;w>>=8;out[j]=w%256;w>>=8;j+=4}break;case"utf7":for(i=0;i!=data.length;i++){c=data[i];if(c==="+"){out[j++]=43;out[j++]=45;continue}if(SetD.indexOf(c)>-1){out[j++]=c.charCodeAt(0);continue}tt=encode(1201,c);out[j++]=43;out[j++]=BM.charCodeAt(tt[0]>>2);out[j++]=BM.charCodeAt(((tt[0]&3)<<4)+((tt[1]||0)>>4));out[j++]=BM.charCodeAt(((tt[1]&15)<<2)+((tt[2]||0)>>6));out[j++]=45}break;default:throw new Error("Unsupported magic: "+cp+" "+magic[cp])}else throw new Error("Unrecognized CP: "+cp);out.length=j;if(typeof Buffer==="undefined")return ofmt=="str"?out.map(function(x){return String.fromCharCode(x)}).join(""):out;if(!ofmt)return out;if(ofmt==="buf")return out;var arr=[].slice.call(out);if(ofmt==="arr")return arr;return arr.map(function(x){return String.fromCharCode(x)}).join("")};var decode=function(cp,data){var F;if(F=cpdcache[cp])return F(data);var out=new Array(data.length),w,i,j=1,k=0;var C=cpt[cp],D,M;if(C&&(D=C.dec)){if(typeof data==="string")data=data.split("").map(function(x){return x.charCodeAt(0)});for(i=0;i<data.length;i+=j){j=2;w=D[data[i]*256+data[i+1]];if(!w){j=1;w=D[data[i]]}if(!w)throw new Error("Unrecognized code: "+data[i]+" "+data[i+j-1]+" "+i+" "+j+" "+D[data[i]]);out[k++]=w}}else if(M=magic[cp])switch(M){case"utf8":for(i=0;i<data.length;i+=j){j=1;if(data[i]<128)w=data[i];else if(data[i]<224){w=(data[i]&31)*64+(data[i+1]&63);j=2}else{w=(data[i]&15)*4096+(data[i+1]&63)*64+(data[i+2]&63);j=3}out[k++]=String.fromCharCode(w)}break;case"ascii":if(typeof Buffer!=="undefined"&&data instanceof Buffer)return data.toString(M);for(i=0;i<data.length;i++)out[i]=String.fromCharCode(data[i]);k=data.length;break;case"utf16le":if(typeof Buffer!=="undefined"&&data instanceof Buffer)return data.toString(M);j=2;for(i=0;i<data.length;i+=j){out[k++]=String.fromCharCode(256*data[i+1]+data[i])}break;case"utf16be":j=2;for(i=0;i<data.length;i+=j){out[k++]=String.fromCharCode(256*data[i]+data[i+1])}break;case"utf32le":j=4;for(i=0;i<data.length;i+=j){out[k++]=String.fromCharCode((data[i+3]<<24)+(data[i+2]<<16)+(data[i+1]<<8)+data[i])}break;case"utf32be":j=4;for(i=0;i<data.length;i+=j){out[k++]=String.fromCharCode((data[i]<<24)+(data[i+1]<<16)+(data[i+2]<<8)+data[i+3])}break;case"utf7":for(i=0;i<data.length;i+=j){if(data[i]!==43){j=1;out[k++]=String.fromCharCode(data[i]);continue}j=1;if(data[i+1]===45){j=2;out[k++]="+";continue}while(String.fromCharCode(data[i+j]).match(/[A-Za-z0-9+\/]/))j++;var dash=0;if(data[i+j]===45){++j;dash=1}var tt=[];var o64;var c1,c2,c3;var e1,e2,e3,e4;for(var l=1;l<j-dash;){e1=BM.indexOf(String.fromCharCode(data[i+l++]));e2=BM.indexOf(String.fromCharCode(data[i+l++]));c1=e1<<2|e2>>4;tt.push(c1);e3=BM.indexOf(String.fromCharCode(data[i+l++]));if(e3===-1)break;c2=(e2&15)<<4|e3>>2;tt.push(c2);e4=BM.indexOf(String.fromCharCode(data[i+l++]));if(e4===-1)break;c3=(e3&3)<<6|e4;if(e4!=64)tt.push(c3)}if(tt.length%2==1)tt.length--;o64=decode(1201,tt);for(l=0;l<o64.length;++l)out[k++]=o64[l]}break;default:throw new Error("Unsupported magic: "+cp+" "+magic[cp])}else throw new Error("Unrecognized CP: "+cp);out.length=k;return out.join("")};var hascp=function(cp){return cpt[cp]||magic[cp]};cpt.utils={decode:decode,encode:encode,hascp:hascp,magic:magic,cache:cache};return cpt});var XLSX={};(function(XLSX){XLSX.version="0.7.2";var current_codepage=1252,current_cptable;if(typeof module!=="undefined"&&typeof require!=="undefined"){if(typeof cptable==="undefined")cptable=require("codepage");current_cptable=cptable[current_codepage]}function reset_cp(){set_cp(1252)}function set_cp(cp){current_codepage=cp;if(typeof cptable!=="undefined")current_cptable=cptable[cp]}var _getchar=function(x){return String.fromCharCode(x)};if(typeof cptable!=="undefined")_getchar=function(x){if(current_codepage===1200)return String.fromCharCode(x);if(current_cptable)return current_cptable.dec[x];return cptable.utils.decode(current_codepage,[x%256,x>>8])[0]};function char_codes(data){return data.split("").map(function(x){return x.charCodeAt(0)})}function debom_xml(data){if(typeof cptable!=="undefined"){if(data.charCodeAt(0)===255&&data.charCodeAt(1)===254){return cptable.utils.decode(1200,char_codes(data.substr(2)))}}return data}var SSF={};var make_ssf=function(SSF){var _strrev=function(x){return String(x).split("").reverse().join("")};function fill(c,l){return new Array(l+1).join(c)}function pad(v,d,c){var t=String(v);return t.length>=d?t:fill(c||0,d-t.length)+t}function rpad(v,d,c){var t=String(v);return t.length>=d?t:t+fill(c||0,d-t.length)}SSF.version="0.7.0";var opts_fmt={date1904:0,output:"",WTF:false};function fixopts(o){for(var y in opts_fmt)if(o[y]===undefined)o[y]=opts_fmt[y]}SSF.opts=opts_fmt;var table_fmt={0:"General",1:"0",2:"0.00",3:"#,##0",4:"#,##0.00",9:"0%",10:"0.00%",11:"0.00E+00",12:"# ?/?",13:"# ??/??",14:"m/d/yy",15:"d-mmm-yy",16:"d-mmm",17:"mmm-yy",18:"h:mm AM/PM",19:"h:mm:ss AM/PM",20:"h:mm",21:"h:mm:ss",22:"m/d/yy h:mm",37:"#,##0 ;(#,##0)",38:"#,##0 ;[Red](#,##0)",39:"#,##0.00;(#,##0.00)",40:"#,##0.00;[Red](#,##0.00)",45:"mm:ss",46:"[h]:mm:ss",47:"mmss.0",48:"##0.0E+0",49:"@",56:'"上午/下午 "hh"時"mm"分"ss"秒 "',65535:"General"};var days=[["Sun","Sunday"],["Mon","Monday"],["Tue","Tuesday"],["Wed","Wednesday"],["Thu","Thursday"],["Fri","Friday"],["Sat","Saturday"]];var months=[["J","Jan","January"],["F","Feb","February"],["M","Mar","March"],["A","Apr","April"],["M","May","May"],["J","Jun","June"],["J","Jul","July"],["A","Aug","August"],["S","Sep","September"],["O","Oct","October"],["N","Nov","November"],["D","Dec","December"]];var frac=function frac(x,D,mixed){var sgn=x<0?-1:1;var B=x*sgn;var P_2=0,P_1=1,P=0;var Q_2=1,Q_1=0,Q=0;var A=Math.floor(B);while(Q_1<D){A=Math.floor(B);P=A*P_1+P_2;Q=A*Q_1+Q_2;if(B-A<5e-10)break;B=1/(B-A);P_2=P_1;P_1=P;Q_2=Q_1;Q_1=Q}if(Q>D){Q=Q_1;P=P_1}if(Q>D){Q=Q_2;P=P_2}if(!mixed)return[0,sgn*P,Q];if(Q===0)throw"Unexpected state: "+P+" "+P_1+" "+P_2+" "+Q+" "+Q_1+" "+Q_2;var q=Math.floor(sgn*P/Q);return[q,sgn*P-q*Q,Q]};var general_fmt=function(v,opts){if(typeof v==="boolean")return v?"TRUE":"FALSE";if(typeof v==="number"){var o,V=v<0?-v:v;if(V>=.1&&V<1)o=v.toPrecision(9);else if(V>=.01&&V<.1)o=v.toPrecision(8);else if(V>=.001&&V<.01)o=v.toPrecision(7);else if(V>=1e-4&&V<.001)o=v.toPrecision(6);else if(V>=Math.pow(10,10)&&V<Math.pow(10,11))o=v.toFixed(10).substr(0,12);else if(V>Math.pow(10,-9)&&V<Math.pow(10,11)){o=v.toFixed(12).replace(/(\.[0-9]*[1-9])0*$/,"$1").replace(/\.$/,"");if(o.length>(v<0?12:11))o=v.toPrecision(10);if(o.length>(v<0?12:11))o=v.toExponential(5)}else{o=v.toFixed(11).replace(/(\.[0-9]*[1-9])0*$/,"$1");if(o.length>(v<0?12:11))o=v.toPrecision(6)}o=o.replace(/(\.[0-9]*[1-9])0+e/,"$1e").replace(/\.0*e/,"e");return o.replace("e","E").replace(/\.0*$/,"").replace(/\.([0-9]*[^0])0*$/,".$1").replace(/(E[+-])([0-9])$/,"$1"+"0"+"$2")}if(typeof v==="string")return v;throw new Error("unsupported value in General format: "+v)};SSF._general=general_fmt;function fix_hijri(date,o){return 0}var parse_date_code=function parse_date_code(v,opts,b2){var date=Math.floor(v),time=Math.floor(86400*(v-date)+1e-6),dow=0;var dout=[];var out={D:date,T:time,u:86400*(v-date)-time,y:0,m:0,d:0,H:0,M:0,S:0,q:0};fixopts(opts=opts||{});if(opts.date1904)date+=1462;if(date>2958465)return null;if(out.u>.999){out.u=0;if(++time==86400){time=0;++date}}if(date===60){dout=b2?[1317,10,29]:[1900,2,29];dow=3}else if(date===0){dout=b2?[1317,8,29]:[1900,1,0];dow=6}else{if(date>60)--date;var d=new Date(1900,0,1);d.setDate(d.getDate()+date-1);dout=[d.getFullYear(),d.getMonth()+1,d.getDate()];dow=d.getDay();if(date<60)dow=(dow+6)%7;if(b2)dow=fix_hijri(d,dout)}out.y=dout[0];out.m=dout[1];out.d=dout[2];out.S=time%60;time=Math.floor(time/60);out.M=time%60;time=Math.floor(time/60);out.H=time;out.q=dow;return out};SSF.parse_date_code=parse_date_code;var write_date=function(type,fmt,val,ss0){var o,ss,tt,y=val.y,sss0;switch(type){case"b":y=val.y+543;case"y":switch(fmt.length){case 1:case 2:return pad(y%100,2);default:return pad(y%1e4,4)}case"m":switch(fmt){case"m":return val.m;case"mm":return pad(val.m,2);case"mmm":return months[val.m-1][1];case"mmmmm":return months[val.m-1][0];default:return months[val.m-1][2]}case"d":switch(fmt){case"d":return val.d;case"dd":return pad(val.d,2);case"ddd":return days[val.q][0];default:return days[val.q][1]}case"h":switch(fmt){case"h":return 1+(val.H+11)%12;case"hh":return pad(1+(val.H+11)%12,2);default:throw"bad hour format: "+fmt}case"H":switch(fmt){case"h":return val.H;case"hh":return pad(val.H,2);default:throw"bad hour format: "+fmt}case"M":switch(fmt){case"m":return val.M;case"mm":return pad(val.M,2);default:throw"bad minute format: "+fmt}case"s":switch(fmt){case"s":case"ss":case".0":case".00":case".000":sss0=ss0||0;tt=Math.pow(10,sss0);ss=Math.round(tt*(val.S+val.u));if(fmt==="s")return ss>=60*tt?0:ss/tt;else if(fmt==="ss"){if(ss>=60*tt)ss=0;return pad(ss,2+sss0).substr(0,2)}if(ss>=60*tt)ss=0;o=pad(ss,2+sss0);return"."+o.substr(2,fmt.length-1);default:throw"bad second format: "+fmt}case"Z":switch(fmt){case"[h]":case"[hh]":o=val.D*24+val.H;break;case"[m]":case"[mm]":o=(val.D*24+val.H)*60+val.M;break;case"[s]":case"[ss]":o=((val.D*24+val.H)*60+val.M)*60+Math.round(val.S+val.u);break;default:throw"bad abstime format: "+fmt}return fmt.length===3?o:pad(o,2);case"e":{return val.y}break}};var commaify=function(s){return _strrev(_strrev(s).replace(/.../g,"$&,")).replace(/^,/,"")};var write_num=function(type,fmt,val){if(type==="("&&!fmt.match(/\).*[0#]/)){var ffmt=fmt.replace(/\( */,"").replace(/ \)/,"").replace(/\)/,"");if(val>=0)return write_num("n",ffmt,val);return"("+write_num("n",ffmt,-val)+")"}var mul=0,o;fmt=fmt.replace(/%/g,function(){mul++;return""});if(mul!==0)return write_num(type,fmt,val*Math.pow(10,2*mul))+fill("%",mul);fmt=fmt.replace(/(\.0+)(,+)$/g,function($$,$1,$2){mul=$2.length;return $1});if(mul!==0)return write_num(type,fmt,val/Math.pow(10,3*mul));if(fmt.indexOf("E")>-1){var idx=fmt.indexOf("E")-fmt.indexOf(".")-1;if(fmt.match(/^#+0.0E\+0$/)){var period=fmt.indexOf(".");if(period===-1)period=fmt.indexOf("E");var ee=Number(val.toExponential(0).substr(2+(val<0?1:0)))%period;if(ee<0)ee+=period;o=(val/Math.pow(10,ee)).toPrecision(idx+1+(period+ee)%period);if(!o.match(/[Ee]/)){var fakee=Number(val.toExponential(0).substr(2+(val<0?1:0)));if(o.indexOf(".")===-1)o=o[0]+"."+o.substr(1)+"E+"+(fakee-o.length+ee);else o+="E+"+(fakee-ee);while(o.substr(0,2)==="0."){o=o[0]+o.substr(2,period)+"."+o.substr(2+period);o=o.replace(/^0+([1-9])/,"$1").replace(/^0+\./,"0.")}o=o.replace(/\+-/,"-")}o=o.replace(/^([+-]?)([0-9]*)\.([0-9]*)[Ee]/,function($$,$1,$2,$3){return $1+$2+$3.substr(0,(period+ee)%period)+"."+$3.substr(ee)+"E"})}else o=val.toExponential(idx);if(fmt.match(/E\+00$/)&&o.match(/e[+-][0-9]$/))o=o.substr(0,o.length-1)+"0"+o[o.length-1];if(fmt.match(/E\-/)&&o.match(/e\+/))o=o.replace(/e\+/,"e");return o.replace("e","E")}if(fmt[0]==="$")return"$"+write_num(type,fmt.substr(fmt[1]==" "?2:1),val);var r,rr,ff,aval=val<0?-val:val,sign=val<0?"-":"";if(r=fmt.match(/# (\?+)([ ]?)\/([ ]?)(\d+)/)){var den=Number(r[4]),rnd=Math.round(aval*den),base=Math.floor(rnd/den);var myn=rnd-base*den,myd=den;return sign+String(base||"")+" "+(myn===0?fill(" ",r[1].length+1+r[4].length):pad(myn,r[1].length," ")+r[2]+"/"+r[3]+pad(myd,r[4].length))}if(fmt.match(/^#+0+$/))fmt=fmt.replace(/#/g,"");if(fmt.match(/^00+$/))return(val<0?"-":"")+pad(Math.round(aval),fmt.length);if(fmt.match(/^[#?]+$/))return String(Math.round(val)).replace(/^0$/,"");if(r=fmt.match(/^#*0*\.(0+)/)){o=Math.round(val*Math.pow(10,r[1].length));rr=String(o/Math.pow(10,r[1].length)).replace(/^([^\.]+)$/,"$1."+r[1]).replace(/\.$/,"."+r[1]).replace(/\.([0-9]*)$/,function($$,$1){return"."+$1+fill("0",r[1].length-$1.length)});return fmt.match(/0\./)?rr:rr.replace(/^0\./,".")}fmt=fmt.replace(/^#+([0.])/,"$1");if(r=fmt.match(/^(0*)\.(#*)$/)){o=Math.round(aval*Math.pow(10,r[2].length));return sign+String(o/Math.pow(10,r[2].length)).replace(/\.(\d*[1-9])0*$/,".$1").replace(/^([-]?\d*)$/,"$1.").replace(/^0\./,r[1].length?"0.":".")}if(r=fmt.match(/^#,##0([.]?)$/))return sign+commaify(String(Math.round(aval)));if(r=fmt.match(/^#,##0\.([#0]*0)$/)){rr=Math.round((val-Math.floor(val))*Math.pow(10,r[1].length));return val<0?"-"+write_num(type,fmt,-val):commaify(String(Math.floor(val)))+"."+pad(rr,r[1].length,0)}if(r=fmt.match(/^#,#*,#0/))return write_num(type,fmt.replace(/^#,#*,/,""),val);if(r=fmt.match(/^([0#]+)(\\?-([0#]+))+$/)){ff=_strrev(write_num(type,fmt.replace(/[\\-]/g,""),val));rr=0;return _strrev(_strrev(fmt.replace(/\\/g,"")).replace(/[0#]/g,function(x){return rr<ff.length?ff[rr++]:x==="0"?"0":""}))}if(fmt.match(/\(###\) ###\\?-####/)){ff=write_num(type,"##########",val);return"("+ff.substr(0,3)+") "+ff.substr(3,3)+"-"+ff.substr(6)}if(r=fmt.match(/^([?]+)([ ]?)\/([ ]?)([?]+)/)){rr=Math.min(Math.max(r[1].length,r[4].length),7);ff=frac(aval,Math.pow(10,rr)-1,false);return sign+(ff[0]||(ff[1]?"":"0"))+(ff[1]?pad(ff[1],rr," ")+r[2]+"/"+r[3]+rpad(ff[2],rr," "):fill(" ",2*rr+1+r[2].length+r[3].length))}if(r=fmt.match(/^# ([?]+)([ ]?)\/([ ]?)([?]+)/)){rr=Math.min(Math.max(r[1].length,r[4].length),7);
ff=frac(aval,Math.pow(10,rr)-1,true);return sign+(ff[0]||(ff[1]?"":"0"))+" "+(ff[1]?pad(ff[1],rr," ")+r[2]+"/"+r[3]+rpad(ff[2],rr," "):fill(" ",2*rr+1+r[2].length+r[3].length))}if(r=fmt.match(/^[#0]+$/)){o=""+Math.round(val);if(fmt.length<=o.length)return o;return fmt.substr(0,fmt.length-o.length).replace(/#/g,"")+o}if(r=fmt.match(/^([#0]+)\.([#0]+)$/)){o=""+val.toFixed(Math.min(r[2].length,10)).replace(/([^0])0+$/,"$1");rr=o.indexOf(".");var lres=fmt.indexOf(".")-rr,rres=fmt.length-o.length-lres;return fmt.substr(0,lres).replace(/#/g,"")+o+fmt.substr(fmt.length-rres).replace(/#/g,"")}if(r=fmt.match(/^00,000\.([#0]*0)$/)){rr=val==Math.floor(val)?0:Math.round((val-Math.floor(val))*Math.pow(10,r[1].length));return val<0?"-"+write_num(type,fmt,-val):commaify(String(Math.floor(val))).replace(/^\d,\d{3}$/,"0$&").replace(/^\d*$/,function($$){return"00,"+($$.length<3?pad(0,3-$$.length):"")+$$})+"."+pad(rr,r[1].length,0)}switch(fmt){case"#,###":var x=commaify(String(Math.round(aval)));return x!=="0"?sign+x:"";default:}throw new Error("unsupported format |"+fmt+"|")};function split_fmt(fmt){var out=[];var in_str=-1;for(var i=0,j=0;i<fmt.length;++i){if(in_str!=-1){if(fmt[i]=='"')in_str=-1;continue}if(fmt[i]=="_"||fmt[i]=="*"||fmt[i]=="\\"){++i;continue}if(fmt[i]=='"'){in_str=i;continue}if(fmt[i]!=";")continue;out.push(fmt.slice(j,i));j=i+1}out.push(fmt.slice(j));if(in_str!=-1)throw new Error("Format |"+fmt+"| unterminated string at "+in_str);return out}SSF._split=split_fmt;function eval_fmt(fmt,v,opts,flen){var out=[],o="",i=0,c="",lst="t",q,dt,j;fixopts(opts=opts||{});var hr="H";while(i<fmt.length){switch(c=fmt[i]){case"G":if(fmt.substr(i,7).toLowerCase()!=="general")throw new Error("unrecognized character "+fmt[i]+" in "+fmt);out.push({t:"G",v:"General"});i+=7;break;case'"':for(o="";fmt[++i]!=='"'&&i<fmt.length;)o+=fmt[i];out.push({t:"t",v:o});++i;break;case"\\":var w=fmt[++i],t="()".indexOf(w)===-1?"t":w;out.push({t:t,v:w});++i;break;case"_":out.push({t:"t",v:" "});i+=2;break;case"@":out.push({t:"T",v:v});++i;break;case"B":case"b":if(fmt[i+1]==="1"||fmt[i+1]==="2"){if(!dt)dt=parse_date_code(v,opts,fmt[i+1]==="2");q={t:"X",v:fmt.substr(i,2)};out.push(q);lst=c;i+=2;break}case"M":case"D":case"Y":case"H":case"S":case"E":c=c.toLowerCase();case"m":case"d":case"y":case"h":case"s":case"e":case"g":if(v<0)return"";if(!dt)dt=parse_date_code(v,opts);if(!dt)return"";o=fmt[i];while((fmt[++i]||"").toLowerCase()===c)o+=c;if(c==="m"&&lst.toLowerCase()==="h")c="M";if(c==="h")c=hr;o=o.toLowerCase();q={t:c,v:o};out.push(q);lst=c;break;case"A":if(!dt)dt=parse_date_code(v,opts);if(!dt)return"";q={t:c,v:"A"};if(fmt.substr(i,3)==="A/P"){q.v=dt.H>=12?"P":"A";q.t="T";hr="h";i+=3}else if(fmt.substr(i,5)==="AM/PM"){q.v=dt.H>=12?"PM":"AM";q.t="T";i+=5;hr="h"}else{q.t="t";i++}out.push(q);lst=c;break;case"[":o=c;while(fmt[i++]!=="]"&&i<fmt.length)o+=fmt[i];if(o.substr(-1)!=="]")throw'unterminated "[" block: |'+o+"|";if(o.match(/\[[HhMmSs]*\]/)){if(!dt)dt=parse_date_code(v,opts);if(!dt)return"";out.push({t:"Z",v:o.toLowerCase()})}else{o=""}break;case".":if(dt){o=c;while((c=fmt[++i])==="0")o+=c;out.push({t:"s",v:o});break}case"0":case"#":o=c;while("0#?.,E+-%".indexOf(c=fmt[++i])>-1||c=="\\"&&fmt[i+1]=="-"&&"0#".indexOf(fmt[i+2])>-1)o+=c;out.push({t:"n",v:o});break;case"?":o=fmt[i];while(fmt[++i]===c)o+=c;q={t:c,v:o};out.push(q);lst=c;break;case"*":++i;if(fmt[i]==" "||fmt[i]=="*")++i;break;case"(":case")":out.push({t:flen===1?"t":c,v:c});++i;break;case"1":case"2":case"3":case"4":case"5":case"6":case"7":case"8":case"9":o=fmt[i];while("0123456789".indexOf(fmt[++i])>-1)o+=fmt[i];out.push({t:"D",v:o});break;case" ":out.push({t:c,v:c});++i;break;default:if(",$-+/():!^&'~{}<>=€acfijklopqrtuvwxz".indexOf(c)===-1)throw"unrecognized character "+fmt[i]+" in "+fmt;out.push({t:"t",v:c});++i;break}}var bt=0,ss0=0,ssm;for(i=out.length-1,lst="t";i>=0;--i){switch(out[i].t){case"h":case"H":out[i].t=hr;lst="h";if(bt<1)bt=1;break;case"s":if(ssm=out[i].v.match(/\.0+$/))ss0=Math.max(ss0,ssm[0].length-1);if(bt<3)bt=3;case"d":case"y":case"M":case"e":lst=out[i].t;break;case"m":if(lst==="s"){out[i].t="M";if(bt<2)bt=2}break;case"X":if(out[i].v==="B2");break;case"Z":if(bt<1&&out[i].v.match(/[Hh]/))bt=1;if(bt<2&&out[i].v.match(/[Mm]/))bt=2;if(bt<3&&out[i].v.match(/[Ss]/))bt=3}}switch(bt){case 0:break;case 1:if(dt.u>=.5){dt.u=0;++dt.S}if(dt.S>=60){dt.S=0;++dt.M}if(dt.M>=60){dt.M=0;++dt.H}break;case 2:if(dt.u>=.5){dt.u=0;++dt.S}if(dt.S>=60){dt.S=0;++dt.M}break}var nstr="",jj;for(i=0;i<out.length;++i){switch(out[i].t){case"t":case"T":case" ":case"D":break;case"X":delete out[i];break;case"d":case"m":case"y":case"h":case"H":case"M":case"s":case"e":case"b":case"Z":out[i].v=write_date(out[i].t,out[i].v,dt,ss0);out[i].t="t";break;case"n":case"(":case"?":jj=i+1;while(out[jj]&&("?D".indexOf(out[jj].t)>-1||" t".indexOf(out[jj].t)>-1&&"?t".indexOf((out[jj+1]||{}).t)>-1&&(out[jj+1].t=="?"||out[jj+1].v=="/")||out[i].t=="("&&")n ".indexOf(out[jj].t)>-1||out[jj].t=="t"&&(out[jj].v=="/"||"$€".indexOf(out[jj].v)>-1||out[jj].v==" "&&(out[jj+1]||{}).t=="?"))){out[i].v+=out[jj].v;delete out[jj];++jj}nstr+=out[i].v;i=jj-1;break;case"G":out[i].t="t";out[i].v=general_fmt(v,opts);break}}if(nstr){var ostr=write_num(nstr[0]=="("?"(":"n",nstr,v<0&&nstr[0]=="-"?-v:v);jj=ostr.length-1;var decpt=out.length;for(i=0;i<out.length;++i)if(out[i]&&out[i].v.indexOf(".")>-1){decpt=i;break}var lasti=out.length,vv;if(decpt===out.length&&!ostr.match(/E/)){for(i=out.length-1;i>=0;--i){if(!out[i]||"n?(".indexOf(out[i].t)===-1)continue;vv=out[i].v.split("");for(j=vv.length-1;j>=0;--j){if(jj>=0)vv[j]=ostr[jj--];else vv[j]=""}out[i].v=vv.join("");out[i].t="t";lasti=i}if(jj>=0&&lasti<out.length)out[lasti].v=ostr.substr(0,jj+1)+out[lasti].v}else if(decpt!==out.length&&!ostr.match(/E/)){jj=ostr.indexOf(".")-1;for(i=decpt;i>=0;--i){if(!out[i]||"n?(".indexOf(out[i].t)===-1)continue;vv=out[i].v.split("");for(j=out[i].v.indexOf(".")>-1&&i==decpt?out[i].v.indexOf(".")-1:vv.length-1;j>=0;--j){if(jj>=0&&"0#".indexOf(vv[j])>-1)vv[j]=ostr[jj--];else vv[j]=""}out[i].v=vv.join("");out[i].t="t";lasti=i}if(jj>=0&&lasti<out.length)out[lasti].v=ostr.substr(0,jj+1)+out[lasti].v;jj=ostr.indexOf(".")+1;for(i=decpt;i<out.length;++i){if(!out[i]||"n?(".indexOf(out[i].t)===-1&&i!=decpt)continue;vv=out[i].v.split("");for(j=out[i].v.indexOf(".")>-1&&i==decpt?out[i].v.indexOf(".")+1:0;j<vv.length;++j){if(jj<ostr.length)vv[j]=ostr[jj++];else vv[j]=""}out[i].v=vv.join("");out[i].t="t";lasti=i}}}for(i=0;i<out.length;++i)if(out[i]&&"n(?".indexOf(out[i].t)>-1){out[i].v=write_num(out[i].t,out[i].v,flen>1&&v<0&&i>0&&out[i-1].v=="-"?-v:v);out[i].t="t"}return out.map(function(x){return x.v}).join("")}SSF._eval=eval_fmt;function choose_fmt(fmt,v,o){if(typeof fmt==="number")fmt=(o&&o.table?o.table:table_fmt)[fmt];if(typeof fmt==="string")fmt=split_fmt(fmt);var l=fmt.length;if(l<4&&fmt[l-1].indexOf("@")>-1)--l;switch(fmt.length){case 1:fmt=fmt[0].indexOf("@")>-1?["General","General","General",fmt[0]]:[fmt[0],fmt[0],fmt[0],"@"];break;case 2:fmt=fmt[1].indexOf("@")>-1?[fmt[0],fmt[0],fmt[0],fmt[1]]:[fmt[0],fmt[1],fmt[0],"@"];break;case 3:fmt=fmt[2].indexOf("@")>-1?[fmt[0],fmt[1],fmt[0],fmt[2]]:[fmt[0],fmt[1],fmt[2],"@"];break;case 4:break;default:throw"cannot find right format for |"+fmt+"|"}if(typeof v!=="number")return[fmt.length,fmt[3]];var ff=v>0?fmt[0]:v<0?fmt[1]:fmt[2];if(fmt[0].match(/\[[=<>]/)||fmt[1].match(/\[[=<>]/)){var chk=function(v,rr,out){if(!rr)return null;var found=false;var thresh=Number(rr[2]);switch(rr[1]){case"=":if(v==thresh)found=true;break;case">":if(v>thresh)found=true;break;case"<":if(v<thresh)found=true;break;case"<>":if(v!=thresh)found=true;break;case">=":if(v>=thresh)found=true;break;case"<=":if(v<=thresh)found=true;break}return found?out:null};var m1=fmt[0].match(/\[([=<>]*)([-]?\d+)\]/);var m2=fmt[1].match(/\[([=<>]*)([-]?\d+)\]/);return chk(v,m1,[l,fmt[0]])||chk(v,m2,[l,fmt[1]])||[l,fmt[m1&&m2?2:1]]}return[l,ff]}var format=function format(fmt,v,o){fixopts(o=o||{});if(typeof fmt==="string"&&fmt.toLowerCase()==="general")return general_fmt(v,o);if(typeof fmt==="number")fmt=(o.table||table_fmt)[fmt];var f=choose_fmt(fmt,v,o);if(f[1].toLowerCase()==="general")return general_fmt(v,o);if(v===true)v="TRUE";if(v===false)v="FALSE";if(v===""||typeof v==="undefined")return"";return eval_fmt(f[1],v,o,f[0])};SSF._choose=choose_fmt;SSF._table=table_fmt;SSF.load=function(fmt,idx){table_fmt[idx]=fmt};SSF.format=format;SSF.get_table=function(){return table_fmt};SSF.load_table=function(tbl){for(var i=0;i!=392;++i)if(tbl[i])SSF.load(tbl[i],i)}};make_ssf(SSF);function isval(x){return typeof x!=="undefined"&&x!==null}function keys(o){return Object.keys(o).filter(function(x){return o.hasOwnProperty(x)})}function evert(obj,arr){var o={};keys(obj).forEach(function(k){if(!obj.hasOwnProperty(k))return;if(!arr)o[obj[k]]=k;else(o[obj[k]]=o[obj[k]]||[]).push(k)});return o}function datenum(v,date1904){if(date1904)v+=1462;var epoch=Date.parse(v);return(epoch-new Date(Date.UTC(1899,11,30)))/(24*60*60*1e3)}function getdata(data){if(!data)return null;if(data.data)return data.name.substr(-4)!==".bin"?debom_xml(data.data):data.data.split("").map(function(x){return x.charCodeAt(0)});if(data.asNodeBuffer&&typeof Buffer!=="undefined"&&data.name.substr(-4)===".bin")return data.asNodeBuffer();if(data.asBinary&&data.name.substr(-4)!==".bin")return debom_xml(data.asBinary());if(data._data&&data._data.getContent){if(data.name.substr(-4)===".bin")return Array.prototype.slice.call(data._data.getContent());return Array.prototype.slice.call(data._data.getContent(),0).map(function(x){return String.fromCharCode(x)}).join("")}return null}function getzipfile(zip,file){var f=file;if(zip.files[f])return zip.files[f];f=file.toLowerCase();if(zip.files[f])return zip.files[f];f=f.replace(/\//g,"\\");if(zip.files[f])return zip.files[f];throw new Error("Cannot find file "+file+" in zip")}function getzipdata(zip,file,safe){if(!safe)return getdata(getzipfile(zip,file));if(!file)return null;try{return getzipdata(zip,file)}catch(e){return null}}var _fs,jszip;if(typeof JSZip!=="undefined")jszip=JSZip;if(typeof exports!=="undefined"){if(typeof module!=="undefined"&&module.exports){if(typeof Buffer!=="undefined"&&typeof jszip==="undefined")jszip=require("jszip");if(typeof jszip==="undefined")jszip=require("./jszip").JSZip;_fs=require("fs")}}var _chr=function(c){return String.fromCharCode(c)};var _ord=function(c){return c.charCodeAt(0)};var attregexg=/([\w:]+)=((?:")([^"]*)(?:")|(?:')([^']*)(?:'))/g;var attregex=/([\w:]+)=((?:")(?:[^"]*)(?:")|(?:')(?:[^']*)(?:'))/;function parsexmltag(tag){var words=tag.split(/\s+/);var z={0:words[0]};if(words.length===1)return z;(tag.match(attregexg)||[]).map(function(x){var y=x.match(attregex);y[1]=y[1].replace(/xmlns:/,"xmlns");z[y[1].replace(/^[a-zA-Z]*:/,"")]=y[2].substr(1,y[2].length-2)});return z}var encodings={"&quot;":'"',"&apos;":"'","&gt;":">","&lt;":"<","&amp;":"&"};var rencoding=evert(encodings);var rencstr="&<>'\"".split("");function unescapexml(text){var s=text+"";for(var y in encodings)s=s.replace(new RegExp(y,"g"),encodings[y]);return s.replace(/_x([0-9a-fA-F]*)_/g,function(m,c){return _chr(parseInt(c,16))})}function escapexml(text){var s=text+"";rencstr.forEach(function(y){s=s.replace(new RegExp(y,"g"),rencoding[y])});s=s.replace(/[\u0000-\u0007]/g,function(s){return"_x"+("0000"+_ord(s).toString(16)).substr(-4)+"_"});return s}function parsexmlbool(value,tag){switch(value){case"0":case 0:case"false":case"FALSE":return false;case"1":case 1:case"true":case"TRUE":return true;default:throw"bad boolean value "+value+" in "+(tag||"?")}}var utf8read=function(orig){var out=[],i=0,c=0,c1=0,c2=0,c3=0;while(i<orig.length){c=orig.charCodeAt(i++);if(c<128)out.push(_chr(c));else{c2=orig.charCodeAt(i++);if(c>191&&c<224)out.push(_chr((c&31)<<6|c2&63));else{c3=orig.charCodeAt(i++);out.push(_chr((c&15)<<12|(c2&63)<<6|c3&63))}}}return out.join("")};function matchtag(f,g){return new RegExp("<(?:\\w+:)?"+f+'(?: xml:space="preserve")?(?:[^>]*)>([^☃]*)</(?:\\w+:)?'+f+">",(g||"")+"m")}function parseVector(data){var h=parsexmltag(data);var matches=data.match(new RegExp("<vt:"+h.baseType+">(.*?)</vt:"+h.baseType+">","g"))||[];if(matches.length!=h.size)throw"unexpected vector length "+matches.length+" != "+h.size;var res=[];matches.forEach(function(x){var v=x.replace(/<[/]?vt:variant>/g,"").match(/<vt:([^>]*)>(.*)</);res.push({v:v[2],t:v[1]})});return res}function writetag(f,g){return"<"+f+(g.match(/(^\s|\s$|\n)/)?' xml:space="preserve"':"")+">"+g+"</"+f+">"}function writextag(f,g,h){return"<"+f+(h!=null?keys(h).map(function(k){return" "+k+'="'+h[k]+'"'}).join(""):"")+(g==null?"/":(g.match(/(^\s|\s$|\n)/)?' xml:space="preserve"':"")+">"+g+"</"+f)+">"}function write_w3cdtf(d,t){try{return d.toISOString().replace(/\.\d*/,"")}catch(e){if(t)throw e}}function write_vt(s){if(typeof s=="string")return writextag("vt:lpwstr",s);if(typeof s=="number")return writextag((s|0)==s?"vt:i4":"vt:r8",String(s));if(typeof s=="boolean")return writextag("vt:bool",s?"true":"false");if(s instanceof Date)return writextag("vt:filetime",write_w3cdtf(s));throw new Error("Unable to serialize "+s)}var XML_HEADER='<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\r\n';var XMLNS={dc:"http://purl.org/dc/elements/1.1/",dcterms:"http://purl.org/dc/terms/",dcmitype:"http://purl.org/dc/dcmitype/",mx:"http://schemas.microsoft.com/office/mac/excel/2008/main",r:"http://schemas.openxmlformats.org/officeDocument/2006/relationships",sjs:"http://schemas.openxmlformats.org/package/2006/sheetjs/core-properties",vt:"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",xsd:"http://www.w3.org/2001/XMLSchema"};XMLNS.main=["http://schemas.openxmlformats.org/spreadsheetml/2006/main","http://purl.oclc.org/ooxml/spreadsheetml/main","http://schemas.microsoft.com/office/excel/2006/main","http://schemas.microsoft.com/office/excel/2006/2"];function readIEEE754(buf,idx,isLE,nl,ml){if(isLE===undefined)isLE=true;if(!nl)nl=8;if(!ml&&nl===8)ml=52;var e,m,el=nl*8-ml-1,eMax=(1<<el)-1,eBias=eMax>>1;var bits=-7,d=isLE?-1:1,i=isLE?nl-1:0,s=buf[idx+i];i+=d;e=s&(1<<-bits)-1;s>>>=-bits;bits+=el;for(;bits>0;e=e*256+buf[idx+i],i+=d,bits-=8);m=e&(1<<-bits)-1;e>>>=-bits;bits+=ml;for(;bits>0;m=m*256+buf[idx+i],i+=d,bits-=8);if(e===eMax)return m?NaN:(s?-1:1)*Infinity;else if(e===0)e=1-eBias;else{m=m+Math.pow(2,ml);e=e-eBias}return(s?-1:1)*m*Math.pow(2,e-ml)}var __toBuffer;if(typeof Buffer!=="undefined"){Buffer.prototype.hexlify=function(){return this.toString("hex")};__toBuffer=function(bufs){return Buffer.concat(bufs[0])}}else{__toBuffer=function(bufs){var x=[];for(var i=0;i!=bufs[0].length;++i){x=x.concat(bufs[0][i])}return x}}var __readUInt8=function(b,idx){return b.readUInt8?b.readUInt8(idx):b[idx]};var __readUInt16LE=function(b,idx){return b.readUInt16LE?b.readUInt16LE(idx):b[idx+1]*(1<<8)+b[idx]};var __readInt16LE=function(b,idx){var u=__readUInt16LE(b,idx);if(!(u&32768))return u;return(65535-u+1)*-1};var __readUInt32LE=function(b,idx){return b.readUInt32LE?b.readUInt32LE(idx):b[idx+3]*(1<<24)+b[idx+2]*(1<<16)+b[idx+1]*(1<<8)+b[idx]};var __readInt32LE=function(b,idx){if(b.readInt32LE)return b.readInt32LE(idx);var u=__readUInt32LE(b,idx);if(!(u&2147483648))return u;return(4294967295-u+1)*-1};var __readDoubleLE=function(b,idx){return b.readDoubleLE?b.readDoubleLE(idx):readIEEE754(b,idx||0)};function ReadShift(size,t){var o="",oo=[],w,vv,i,loc;t=t||"u";if(size==="ieee754"){size=8;t="f"}switch(size){case 1:o=__readUInt8(this,this.l);break;case 2:o=(t==="u"?__readUInt16LE:__readInt16LE)(this,this.l);break;case 4:o=__readUInt32LE(this,this.l);break;case 8:if(t==="f"){o=__readDoubleLE(this,this.l);break}case 16:o=this.toString("hex",this.l,this.l+size);break;case"dbcs":size=2*t;loc=this.l;for(i=0;i!=t;++i){oo.push(_getchar(__readUInt16LE(this,loc)));loc+=2}o=oo.join("");break;case"sbcs":size=t;o="";loc=this.l;for(i=0;i!=t;++i){o+=_getchar(__readUInt8(this,loc));loc+=1}break}this.l+=size;return o}function prep_blob(blob,pos){blob.read_shift=ReadShift.bind(blob);blob.l=pos||0;var read=ReadShift.bind(blob);return[read]}function parsenoop(blob,length){blob.l+=length}var recordhopper=function(data,cb,opts){var tmpbyte,cntbyte,length;prep_blob(data,data.l||0);while(data.l<data.length){var RT=data.read_shift(1);if(RT&128)RT=(RT&127)+((data.read_shift(1)&127)<<7);var R=RecordEnum[RT]||RecordEnum[65535];tmpbyte=data.read_shift(1);length=tmpbyte&127;for(cntbyte=1;cntbyte<4&&tmpbyte&128;++cntbyte)length+=((tmpbyte=data.read_shift(1))&127)<<7*cntbyte;var d=R.f(data,length,opts);if(cb(d,R,RT))return}};var blobhopper=function(){var bufs=[]};var parse_StrRun=function(data,length){return{ich:data.read_shift(2),ifnt:data.read_shift(2)}};var parse_RichStr=function(data,length){var start=data.l;var flags=data.read_shift(1);var fRichStr=flags&1,fExtStr=flags&2;var str=parse_XLWideString(data);var rgsStrRun=[];var z={t:str,r:"<t>"+escapexml(str)+"</t>",h:str};if(fRichStr){var dwSizeStrRun=data.read_shift(4);for(var i=0;i!=dwSizeStrRun;++i)rgsStrRun.push(parse_StrRun(data));z.r=JSON.stringify(rgsStrRun)}if(fExtStr){}data.l=start+length;return z};function parse_Cell(data){var col=data.read_shift(4);var iStyleRef=data.read_shift(2);iStyleRef+=data.read_shift(1)<<16;var fPhShow=data.read_shift(1);return{c:col,iStyleRef:iStyleRef}}var parse_CodeName=function(data,length){return parse_XLWideString(data,length)};var parse_RelID=function(data,length){return parse_XLNullableWideString(data,length)};function parse_RkNumber(data){var b=data.slice(data.l,data.l+4);var fX100=b[0]&1,fInt=b[0]&2;data.l+=4;b[0]&=~3;var RK=fInt===0?__readDoubleLE([0,0,0,0,b[0],b[1],b[2],b[3]],0):__readInt32LE(b,0)>>2;return fX100?RK/100:RK}var parse_UncheckedRfX=function(data){var cell={s:{},e:{}};cell.s.r=data.read_shift(4);cell.e.r=data.read_shift(4);cell.s.c=data.read_shift(4);cell.e.c=data.read_shift(4);return cell};var parse_XLNullableWideString=function(data){var cchCharacters=data.read_shift(4);return cchCharacters===0||cchCharacters===4294967295?"":data.read_shift("dbcs",cchCharacters)};var parse_XLWideString=function(data){var cchCharacters=data.read_shift(4);return cchCharacters===0?"":data.read_shift("dbcs",cchCharacters)};function parse_Xnum(data,length){return data.read_shift("ieee754")}var BErr={0:"#NULL!",7:"#DIV/0!",15:"#VALUE!",23:"#REF!",29:"#NAME?",36:"#NUM!",42:"#N/A",43:"#GETTING_DATA",255:"#WTF?"};var RBErr=evert(BErr);function parse_BrtColor(data,length){var read=data.read_shift.bind(data);var out={};var d=read(1);out.fValidRGB=d&1;out.xColorType=d>>>1;out.index=read(1);out.nTintAndShade=read(2,"i");out.bRed=read(1);out.bGreen=read(1);out.bBlue=read(1);out.bAlpha=read(1)}function parse_FontFlags(data,length){var d=data.read_shift(1);data.l++;var out={fItalic:d&2,fStrikeout:d&8,fOutline:d&16,fShadow:d&32,fCondense:d&64,fExtend:d&128};return out}var ct2type={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml":"workbooks","application/vnd.ms-excel.binIndexWs":"TODO","application/vnd.ms-excel.chartsheet":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml":"TODO","application/vnd.ms-excel.dialogsheet":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml":"TODO","application/vnd.ms-excel.macrosheet":"TODO","application/vnd.ms-excel.macrosheet+xml":"TODO","application/vnd.ms-excel.intlmacrosheet":"TODO","application/vnd.ms-excel.binIndexMs":"TODO","application/vnd.openxmlformats-package.core-properties+xml":"coreprops","application/vnd.openxmlformats-officedocument.custom-properties+xml":"custprops","application/vnd.openxmlformats-officedocument.extended-properties+xml":"extprops","application/vnd.openxmlformats-officedocument.customXmlProperties+xml":"TODO","application/vnd.ms-excel.comments":"comments","application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml":"comments","application/vnd.ms-excel.pivotTable":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml":"TODO","application/vnd.ms-excel.calcChain":"calcchains","application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml":"calcchains","application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings":"TODO","application/vnd.ms-office.activeX":"TODO","application/vnd.ms-office.activeX+xml":"TODO","application/vnd.ms-excel.attachedToolbars":"TODO","application/vnd.ms-excel.connections":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml":"TODO","application/vnd.ms-excel.externalLink":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml":"TODO","application/vnd.ms-excel.sheetMetadata":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml":"TODO","application/vnd.ms-excel.pivotCacheDefinition":"TODO","application/vnd.ms-excel.pivotCacheRecords":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml":"TODO","application/vnd.ms-excel.queryTable":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml":"TODO","application/vnd.ms-excel.userNames":"TODO","application/vnd.ms-excel.revisionHeaders":"TODO","application/vnd.ms-excel.revisionLog":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml":"TODO","application/vnd.ms-excel.tableSingleCells":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml":"TODO","application/vnd.ms-excel.slicer":"TODO","application/vnd.ms-excel.slicerCache":"TODO","application/vnd.ms-excel.slicer+xml":"TODO","application/vnd.ms-excel.slicerCache+xml":"TODO","application/vnd.ms-excel.wsSortMap":"TODO","application/vnd.ms-excel.table":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml":"TODO","application/vnd.openxmlformats-officedocument.theme+xml":"themes","application/vnd.ms-excel.Timeline+xml":"TODO","application/vnd.ms-excel.TimelineCache+xml":"TODO","application/vnd.ms-office.vbaProject":"vba","application/vnd.ms-office.vbaProjectSignature":"vba","application/vnd.ms-office.volatileDependencies":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml":"TODO","application/vnd.ms-excel.controlproperties+xml":"TODO","application/vnd.openxmlformats-officedocument.model+data":"TODO","application/vnd.ms-excel.Survey+xml":"TODO","application/vnd.openxmlformats-officedocument.drawing+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.chart+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml":"TODO","application/vnd.openxmlformats-officedocument.vmlDrawing":"TODO","application/vnd.openxmlformats-package.relationships+xml":"rels","application/vnd.openxmlformats-officedocument.oleObject":"TODO",sheet:"js"};var CT_LIST=function(){var o={workbooks:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml",xlsm:"application/vnd.ms-excel.sheet.macroEnabled.main+xml",xlsb:"application/vnd.ms-excel.sheet.binary.macroEnabled.main",xltx:"application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml"},strs:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml",xlsb:"application/vnd.ms-excel.sharedStrings"},sheets:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml",xlsb:"application/vnd.ms-excel.worksheet"},styles:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml",xlsb:"application/vnd.ms-excel.styles"}};keys(o).forEach(function(k){if(!o[k].xlsm)o[k].xlsm=o[k].xlsx});keys(o).forEach(function(k){keys(o[k]).forEach(function(v){ct2type[o[k][v]]=k})});return o}();var type2ct=evert(ct2type,true);XMLNS.CT="http://schemas.openxmlformats.org/package/2006/content-types";function parse_ct(data,opts){var ctext={};if(!data||!data.match)return data;var ct={workbooks:[],sheets:[],calcchains:[],themes:[],styles:[],coreprops:[],extprops:[],custprops:[],strs:[],comments:[],vba:[],TODO:[],rels:[],xmlns:""};(data.match(/<[^>]*>/g)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0].replace(/<\w*:/,"<")){case"<?xml":break;case"<Types":ct.xmlns=y["xmlns"+(y[0].match(/<(\w+):/)||["",""])[1]];break;case"<Default":ctext[y.Extension]=y.ContentType;break;case"<Override":if(y.ContentType in ct2type)ct[ct2type[y.ContentType]].push(y.PartName);else if(opts.WTF)console.error(y);break}});if(ct.xmlns!==XMLNS.CT)throw new Error("Unknown Namespace: "+ct.xmlns);ct.calcchain=ct.calcchains.length>0?ct.calcchains[0]:"";ct.sst=ct.strs.length>0?ct.strs[0]:"";ct.style=ct.styles.length>0?ct.styles[0]:"";ct.defaults=ctext;delete ct.calcchains;return ct}var CTYPE_XML_ROOT=writextag("Types",null,{xmlns:XMLNS.CT,"xmlns:xsd":XMLNS.xsd,"xmlns:xsi":XMLNS.xsi});var CTYPE_DEFAULTS=[["xml","application/xml"],["rels",type2ct.rels[0]]].map(function(x){return writextag("Default",null,{Extension:x[0],ContentType:x[1]})});function write_ct(ct,opts){var o=[],v;o.push(XML_HEADER);o.push(CTYPE_XML_ROOT);o=o.concat(CTYPE_DEFAULTS);var f1=function(w){if(ct[w]&&ct[w].length>0){v=ct[w][0];o.push(writextag("Override",null,{PartName:(v[0]=="/"?"":"/")+v,ContentType:CT_LIST[w][opts.bookType||"xlsx"]}))}};var f2=function(w){ct[w].forEach(function(v){o.push(writextag("Override",null,{PartName:(v[0]=="/"?"":"/")+v,ContentType:CT_LIST[w][opts.bookType||"xlsx"]}))})};var f3=function(t){(ct[t]||[]).forEach(function(v){o.push(writextag("Override",null,{PartName:(v[0]=="/"?"":"/")+v,ContentType:type2ct[t][0]}))})};f1("workbooks");f2("sheets");f3("themes");["strs","styles"].forEach(f1);["coreprops","extprops","custprops"].forEach(f3);if(o.length>2){o.push("</Types>");o[1]=o[1].replace("/>",">")}return o.join("")}var RELS={WB:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument",SHEET:"http://sheetjs.openxmlformats.org/officeDocument/2006/relationships/officeDocument"};function parse_rels(data,currentFilePath){if(!data)return data;if(currentFilePath.charAt(0)!=="/"){currentFilePath="/"+currentFilePath}var rels={};var hash={};var resolveRelativePathIntoAbsolute=function(to){var toksFrom=currentFilePath.split("/");toksFrom.pop();var toksTo=to.split("/");var reversed=[];while(toksTo.length!==0){var tokTo=toksTo.shift();if(tokTo===".."){toksFrom.pop()}else if(tokTo!=="."){toksFrom.push(tokTo)}}return toksFrom.join("/")};data.match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);if(y[0]==="<Relationship"){var rel={};rel.Type=y.Type;rel.Target=y.Target;rel.Id=y.Id;rel.TargetMode=y.TargetMode;var canonictarget=y.TargetMode==="External"?y.Target:resolveRelativePathIntoAbsolute(y.Target);rels[canonictarget]=rel;hash[y.Id]=rel}});rels["!id"]=hash;return rels}XMLNS.RELS="http://schemas.openxmlformats.org/package/2006/relationships";var RELS_ROOT=writextag("Relationships",null,{xmlns:XMLNS.RELS});function write_rels(rels){var o=[];o.push(XML_HEADER);o.push(RELS_ROOT);keys(rels["!id"]).forEach(function(rid){var rel=rels["!id"][rid];o.push(writextag("Relationship",null,rel))});if(o.length>2){o.push("</Relationships>");o[1]=o[1].replace("/>",">")}return o.join("")}var CORE_PROPS=[["cp:category","Category"],["cp:contentStatus","ContentStatus"],["cp:keywords","Keywords"],["cp:lastModifiedBy","LastAuthor"],["cp:lastPrinted","LastPrinted"],["cp:revision","RevNumber"],["cp:version","Version"],["dc:creator","Author"],["dc:description","Comments"],["dc:identifier","Identifier"],["dc:language","Language"],["dc:subject","Subject"],["dc:title","Title"],["dcterms:created","CreatedDate","date"],["dcterms:modified","ModifiedDate","date"]];XMLNS.CORE_PROPS="http://schemas.openxmlformats.org/package/2006/metadata/core-properties";RELS.CORE_PROPS="http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties";function parse_core_props(data){var p={};CORE_PROPS.forEach(function(f){var g="(?:"+f[0].substr(0,f[0].indexOf(":"))+":)"+f[0].substr(f[0].indexOf(":")+1);var cur=data.match(new RegExp("<"+g+"[^>]*>(.*)</"+g+">"));if(cur&&cur.length>0)p[f[1]]=cur[1];if(f[2]==="date"&&p[f[1]])p[f[1]]=new Date(p[f[1]])});return p}var CORE_PROPS_XML_ROOT=writextag("cp:coreProperties",null,{"xmlns:cp":XMLNS.CORE_PROPS,"xmlns:dc":XMLNS.dc,"xmlns:dcterms":XMLNS.dcterms,"xmlns:dcmitype":XMLNS.dcmitype,"xmlns:xsi":XMLNS.xsi});function write_core_props(cp,opts){var o=[],p={};o.push(XML_HEADER);o.push(CORE_PROPS_XML_ROOT);if(!cp)return o.join("");var doit=function(f,g,h){if(p[f]||typeof g==="undefined"||g==="")return;if(typeof g!=="string")g=String(g);p[f]=g;o.push(h?writextag(f,g,h):writetag(f,g))};if(typeof cp.CreatedDate!=="undefined")doit("dcterms:created",typeof cp.CreatedDate==="string"?cp.CreatedDate:write_w3cdtf(cp.CreatedDate,opts.WTF),{"xsi:type":"dcterms:W3CDTF"});if(typeof cp.ModifiedDate!=="undefined")doit("dcterms:modified",typeof cp.ModifiedDate==="string"?cp.ModifiedDate:write_w3cdtf(cp.ModifiedDate,opts.WTF),{"xsi:type":"dcterms:W3CDTF"});CORE_PROPS.forEach(function(f){doit(f[0],cp[f[1]])});if(o.length>2){o.push("</cp:coreProperties>");o[1]=o[1].replace("/>",">")}return o.join("")}var EXT_PROPS=[["Application","Application","string"],["AppVersion","AppVersion","string"],["Company","Company","string"],["DocSecurity","DocSecurity","string"],["Manager","Manager","string"],["HyperlinksChanged","HyperlinksChanged","bool"],["SharedDoc","SharedDoc","bool"],["LinksUpToDate","LinksUpToDate","bool"],["ScaleCrop","ScaleCrop","bool"],["HeadingPairs","HeadingPairs","raw"],["TitlesOfParts","TitlesOfParts","raw"]];XMLNS.EXT_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/extended-properties";RELS.EXT_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties";function parse_ext_props(data,p){var q={};if(!p)p={};EXT_PROPS.forEach(function(f){switch(f[2]){case"string":p[f[1]]=(data.match(matchtag(f[0]))||[])[1];break;case"bool":p[f[1]]=(data.match(matchtag(f[0]))||[])[1]==="true";break;case"raw":var cur=data.match(new RegExp("<"+f[0]+"[^>]*>(.*)</"+f[0]+">"));if(cur&&cur.length>0)q[f[1]]=cur[1];break}});if(q.HeadingPairs&&q.TitlesOfParts){var v=parseVector(q.HeadingPairs);var j=0,widx=0;for(var i=0;i!==v.length;++i){switch(v[i].v){case"Worksheets":widx=j;p.Worksheets=+v[++i].v;break;case"Named Ranges":++i;break}}var parts=parseVector(q.TitlesOfParts).map(function(x){return utf8read(x.v)});p.SheetNames=parts.slice(widx,widx+p.Worksheets)}return p}var EXT_PROPS_XML_ROOT=writextag("Properties",null,{xmlns:XMLNS.EXT_PROPS,"xmlns:vt":XMLNS.vt});function write_ext_props(cp,opts){var o=[],p={},W=writextag;if(!cp)cp={};cp.Application="SheetJS";o.push(XML_HEADER);o.push(EXT_PROPS_XML_ROOT);EXT_PROPS.forEach(function(f){if(typeof cp[f[1]]==="undefined")return;var v;switch(f[2]){case"string":v=cp[f[1]];break;case"bool":v=cp[f[1]]?"true":"false";break}if(typeof v!=="undefined")o.push(W(f[0],v))});o.push(W("HeadingPairs",W("vt:vector",W("vt:variant","<vt:lpstr>Worksheets</vt:lpstr>")+W("vt:variant",W("vt:i4",String(cp.Worksheets))),{size:2,baseType:"variant"})));o.push(W("TitlesOfParts",W("vt:vector",cp.SheetNames.map(function(s){return"<vt:lpstr>"+s+"</vt:lpstr>"}).join(""),{size:cp.Worksheets,baseType:"lpstr"})));if(o.length>2){o.push("</Properties>");o[1]=o[1].replace("/>",">")}return o.join("")}XMLNS.CUST_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/custom-properties";
RELS.CUST_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties";function parse_cust_props(data,opts){var p={},name;data.match(/<[^>]+>([^<]*)/g).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<?xml":break;case"<Properties":if(y.xmlns!==XMLNS.CUST_PROPS)throw"unrecognized xmlns "+y.xmlns;if(y.xmlnsvt&&y.xmlnsvt!==XMLNS.vt)throw"unrecognized vt "+y.xmlnsvt;break;case"<property":name=y.name;break;case"</property>":name=null;break;default:if(x.indexOf("<vt:")===0){var toks=x.split(">");var type=toks[0].substring(4),text=toks[1];switch(type){case"lpstr":case"lpwstr":case"bstr":case"lpwstr":p[name]=unescapexml(text);break;case"bool":p[name]=parsexmlbool(text,"<vt:bool>");break;case"i1":case"i2":case"i4":case"i8":case"int":case"uint":p[name]=parseInt(text,10);break;case"r4":case"r8":case"decimal":p[name]=parseFloat(text);break;case"filetime":case"date":p[name]=new Date(text);break;case"cy":case"error":p[name]=unescapexml(text);break;default:console.warn("Unexpected",x,type,toks)}}else if(x.substr(0,2)==="</"){}else if(opts.WTF)throw new Error(x)}});return p}var CUST_PROPS_XML_ROOT=writextag("Properties",null,{xmlns:XMLNS.CUST_PROPS,"xmlns:vt":XMLNS.vt});function write_cust_props(cp,opts){var o=[],p={};o.push(XML_HEADER);o.push(CUST_PROPS_XML_ROOT);if(!cp)return o.join("");var pid=1;keys(cp).forEach(function(k){++pid;o.push(writextag("property",write_vt(cp[k]),{fmtid:"{D5CDD505-2E9C-101B-9397-08002B2CF9AE}",pid:pid,name:k}))});if(o.length>2){o.push("</Properties>");o[1]=o[1].replace("/>",">")}return o.join("")}var CS2CP={0:1252,1:65001,2:65001,77:1e4,128:932,129:949,130:1361,134:936,136:950,161:1253,162:1254,163:1258,177:1255,178:1256,186:1257,204:1251,222:874,238:1250,255:1252,69:6969};var parse_rs=function(){var tregex=matchtag("t"),rpregex=matchtag("rPr");var parse_rpr=function(rpr,intro,outro){var font={},cp=65001;(rpr.match(/<[^>]*>/g)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<condense":break;case"<extend":break;case"<shadow":case"<shadow/>":break;case"<charset":if(y.val=="1")break;cp=CS2CP[parseInt(y.val,10)];break;case"<outline":case"<outline/>":break;case"<rFont":font.name=y.val;break;case"<sz":font.sz=y.val;break;case"<strike":if(!y.val)break;case"<strike/>":font.strike=1;break;case"</strike>":break;case"<u":if(!y.val)break;case"<u/>":font.u=1;break;case"</u>":break;case"<b":if(!y.val)break;case"<b/>":font.b=1;break;case"</b>":break;case"<i":if(!y.val)break;case"<i/>":font.i=1;break;case"</i>":break;case"<color":if(y.rgb)font.color=y.rgb.substr(2,6);break;case"<family":font.family=y.val;break;case"<vertAlign":break;case"<scheme":break;default:if(y[0][2]!=="/")throw"Unrecognized rich format "+y[0]}});var style=[];if(font.b)style.push("font-weight: bold;");if(font.i)style.push("font-style: italic;");intro.push('<span style="'+style.join("")+'">');outro.push("</span>");return cp};function parse_r(r){var terms=[[],"",[]];var t=r.match(tregex),cp=65001;if(!isval(t))return"";terms[1]=t[1];var rpr=r.match(rpregex);if(isval(rpr))cp=parse_rpr(rpr[1],terms[0],terms[2]);return terms[0].join("")+terms[1].replace(/\r\n/g,"<br/>")+terms[2].join("")}return function(rs){return rs.replace(/<r>/g,"").split(/<\/r>/).map(parse_r).join("")}}();var parse_si=function(x,opts){var html=opts?opts.cellHTML:true;var z={};if(!x)return null;var y;if(x[1]==="t"){z.t=utf8read(unescapexml(x.substr(x.indexOf(">")+1).split(/<\/t>/)[0]));z.r=x;if(html)z.h=z.t}else if(y=x.match(/<r>/)){z.r=x;z.t=utf8read(unescapexml(x.replace(/<[^>]*>/gm,"")));if(html)z.h=parse_rs(x)}return z};var parse_sst_xml=function(data,opts){var s=[];var sst=data.match(new RegExp("<sst([^>]*)>([\\s\\S]*)</sst>","m"));if(isval(sst)){s=sst[2].replace(/<(?:si|sstItem)>/g,"").split(/<\/(?:si|sstItem)>/).map(function(x){return parse_si(x,opts)}).filter(function(x){return x});sst=parsexmltag(sst[1]);s.Count=sst.count;s.Unique=sst.uniqueCount}return s};RELS.SST="http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings";var write_sst_xml=function(sst,opts){if(!opts.bookSST)return"";var o=[];o.push(XML_HEADER);o.push(writextag("sst",null,{xmlns:XMLNS.main[0],count:sst.Count,uniqueCount:sst.Unique}));sst.forEach(function(s){var sitag="<si>";if(s.r)sitag+=s.r;else{sitag+="<t";if(s.t.match(/^\s|\s$|[\t\n\r]/))sitag+=' xml:space="preserve"';sitag+=">";sitag+=escapexml(s.t);sitag+="</t>"}sitag+="</si>";o.push(sitag)});if(o.length>2){o.push("</sst>");o[1]=o[1].replace("/>",">")}return o.join("")};var parse_BrtBeginSst=function(data,length){return[data.read_shift(4),data.read_shift(4)]};var parse_sst_bin=function(data,opts){var s=[];var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtBeginSst":s.Count=val[0];s.Unique=val[1];break;case"BrtSSTItem":s.push(val);break;case"BrtEndSst":return true;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return s};var write_sst_bin=function(sst,opts){};var styles={};function parse_numFmts(t,opts){styles.NumberFmt=[];for(var y in SSF._table)styles.NumberFmt[y]=SSF._table[y];t[0].match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<numFmts":case"</numFmts>":case"<numFmts/>":case"<numFmts>":break;case"<numFmt":{var f=unescapexml(y.formatCode),i=parseInt(y.numFmtId,10);styles.NumberFmt[i]=f;if(i>0)SSF.load(f,i)}break;default:if(opts.WTF)throw"unrecognized "+y[0]+" in numFmts"}})}function write_numFmts(NF,opts){var o=[];o.push("<numFmts>");[[5,8],[23,26],[41,44],[63,66],[164,392]].forEach(function(r){for(var i=r[0];i<=r[1];++i)if(NF[i])o.push(writextag("numFmt",null,{numFmtId:i,formatCode:escapexml(NF[i])}))});o.push("</numFmts>");if(o.length===2)return"";o[0]=writextag("numFmts",null,{count:o.length-2}).replace("/>",">");return o.join("")}function parse_cellXfs(t,opts){styles.CellXf=[];t[0].match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<cellXfs":case"<cellXfs>":case"<cellXfs/>":case"</cellXfs>":break;case"<xf":delete y[0];if(y.numFmtId)y.numFmtId=parseInt(y.numFmtId,10);styles.CellXf.push(y);break;case"</xf>":break;case"<alignment":case"<alignment/>":break;case"<protection":case"</protection>":case"<protection/>":break;case"<extLst":case"</extLst>":break;case"<ext":break;default:if(opts.WTF)throw"unrecognized "+y[0]+" in cellXfs"}})}function write_cellXfs(cellXfs){var o=[];o.push(writextag("cellXfs",null));cellXfs.forEach(function(c){o.push(writextag("xf",null,c))});o.push("</cellXfs>");if(o.length===2)return"";o[0]=writextag("cellXfs",null,{count:o.length-2}).replace("/>",">");return o.join("")}function parse_sty_xml(data,opts){var t;if(t=data.match(/<numFmts([^>]*)>.*<\/numFmts>/))parse_numFmts(t,opts);if(t=data.match(/<cellXfs([^>]*)>.*<\/cellXfs>/))parse_cellXfs(t,opts);return styles}var STYLES_XML_ROOT=writextag("styleSheet",null,{xmlns:XMLNS.main[0],"xmlns:vt":XMLNS.vt});RELS.STY="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles";function write_sty_xml(wb,opts){var o=[],p={},W=writextag,w;o.push(XML_HEADER);o.push(STYLES_XML_ROOT);if(w=write_numFmts(wb.SSF))o.push(w);o.push('<fonts count="1"><font><sz val="12"/><color theme="1"/><name val="Calibri"/><family val="2"/><scheme val="minor"/></font></fonts>');o.push('<fills count="2"><fill><patternFill patternType="none"/></fill><fill><patternFill patternType="gray125"/></fill></fills>');o.push('<borders count="1"><border><left/><right/><top/><bottom/><diagonal/></border></borders>');o.push('<cellStyleXfs count="1"><xf numFmtId="0" fontId="0" fillId="0" borderId="0"/></cellStyleXfs>');if(w=write_cellXfs(opts.cellXfs))o.push(w);o.push('<cellStyles count="1"><cellStyle name="Normal" xfId="0" builtinId="0"/></cellStyles>');o.push('<dxfs count="0"/>');o.push('<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4"/>');if(o.length>2){o.push("</styleSheet>");o[1]=o[1].replace("/>",">")}return o.join("")}function parse_BrtFmt(data,length){var ifmt=data.read_shift(2);var stFmtCode=parse_XLWideString(data,length-2);return[ifmt,stFmtCode]}function parse_BrtFont(data,length){var read=data.read_shift.bind(data);var out={flags:{}};out.dyHeight=read(2);out.grbit=parse_FontFlags(data,2);out.bls=read(2);out.sss=read(2);out.uls=read(1);out.bFamily=read(1);out.bCharSet=read(1);data.l++;out.brtColor=parse_BrtColor(data,8);out.bFontScheme=read(1);out.name=parse_XLWideString(data,length-21);out.flags.Bold=out.bls===700;out.flags.Italic=out.grbit.fItalic;out.flags.Strikeout=out.grbit.fStrikeout;out.flags.Outline=out.grbit.fOutline;out.flags.Shadow=out.grbit.fShadow;out.flags.Condense=out.grbit.fCondense;out.flags.Extend=out.grbit.fExtend;out.flags.Sub=out.sss&2;out.flags.Sup=out.sss&1;return out}function parse_BrtXF(data,length){var ixfeParent=data.read_shift(2);var ifmt=data.read_shift(2);parsenoop(data,length-4);return{ixfe:ixfeParent,ifmt:ifmt}}function parse_sty_bin(data,opts){styles.NumberFmt=[];for(var y in SSF._table)styles.NumberFmt[y]=SSF._table[y];styles.CellXf=[];var state="";var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtFmt":styles.NumberFmt[val[0]]=val[1];SSF.load(val[1],val[0]);break;case"BrtFont":break;case"BrtKnownFonts":break;case"BrtFill":break;case"BrtBorder":break;case"BrtXF":if(state==="CELLXFS"){styles.CellXf.push(val)}break;case"BrtStyle":break;case"BrtRowHdr":break;case"BrtCellMeta":break;case"BrtDXF":break;case"BrtMRUColor":break;case"BrtIndexedColor":break;case"BrtBeginStyleSheet":break;case"BrtEndStyleSheet":break;case"BrtBeginTableStyle":break;case"BrtTableStyleElement":break;case"BrtEndTableStyle":break;case"BrtBeginFmts":state="FMTS";break;case"BrtEndFmts":state="";break;case"BrtBeginFonts":state="FONTS";break;case"BrtEndFonts":state="";break;case"BrtACBegin":state="ACFONTS";break;case"BrtACEnd":state="";break;case"BrtBeginFills":state="FILLS";break;case"BrtEndFills":state="";break;case"BrtBeginBorders":state="BORDERS";break;case"BrtEndBorders":state="";break;case"BrtBeginCellStyleXFs":state="CELLSTYLEXFS";break;case"BrtEndCellStyleXFs":state="";break;case"BrtBeginCellXFs":state="CELLXFS";break;case"BrtEndCellXFs":state="";break;case"BrtBeginStyles":state="STYLES";break;case"BrtEndStyles":state="";break;case"BrtBeginDXFs":state="DXFS";break;case"BrtEndDXFs":state="";break;case"BrtBeginTableStyles":state="TABLESTYLES";break;case"BrtEndTableStyles":state="";break;case"BrtBeginColorPalette":state="COLORPALETTE";break;case"BrtEndColorPalette":state="";break;case"BrtBeginIndexedColors":state="INDEXEDCOLORS";break;case"BrtEndIndexedColors":state="";break;case"BrtBeginMRUColors":state="MRUCOLORS";break;case"BrtEndMRUColors":state="";break;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;case"BrtBeginStyleSheetExt14":break;case"BrtBeginSlicerStyles":break;case"BrtEndSlicerStyles":break;case"BrtBeginTimelineStylesheetExt15":break;case"BrtEndTimelineStylesheetExt15":break;case"BrtBeginTimelineStyles":break;case"BrtEndTimelineStyles":break;case"BrtEndStyleSheetExt14":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return styles}RELS.THEME="http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme";function write_theme(){return'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\n<a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Office Theme"><a:themeElements><a:clrScheme name="Office"><a:dk1><a:sysClr val="windowText" lastClr="000000"/></a:dk1><a:lt1><a:sysClr val="window" lastClr="FFFFFF"/></a:lt1><a:dk2><a:srgbClr val="1F497D"/></a:dk2><a:lt2><a:srgbClr val="EEECE1"/></a:lt2><a:accent1><a:srgbClr val="4F81BD"/></a:accent1><a:accent2><a:srgbClr val="C0504D"/></a:accent2><a:accent3><a:srgbClr val="9BBB59"/></a:accent3><a:accent4><a:srgbClr val="8064A2"/></a:accent4><a:accent5><a:srgbClr val="4BACC6"/></a:accent5><a:accent6><a:srgbClr val="F79646"/></a:accent6><a:hlink><a:srgbClr val="0000FF"/></a:hlink><a:folHlink><a:srgbClr val="800080"/></a:folHlink></a:clrScheme><a:fontScheme name="Office"><a:majorFont><a:latin typeface="Cambria"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="宋体"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Times New Roman"/><a:font script="Hebr" typeface="Times New Roman"/><a:font script="Thai" typeface="Tahoma"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="MoolBoran"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Times New Roman"/><a:font script="Uigh" typeface="Microsoft Uighur"/><a:font script="Geor" typeface="Sylfaen"/></a:majorFont><a:minorFont><a:latin typeface="Calibri"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="宋体"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Arial"/><a:font script="Hebr" typeface="Arial"/><a:font script="Thai" typeface="Tahoma"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="DaunPenh"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Arial"/><a:font script="Uigh" typeface="Microsoft Uighur"/><a:font script="Geor" typeface="Sylfaen"/></a:minorFont></a:fontScheme><a:fmtScheme name="Office"><a:fillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="50000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="35000"><a:schemeClr val="phClr"><a:tint val="37000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:tint val="15000"/><a:satMod val="350000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="16200000" scaled="1"/></a:gradFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="100000"/><a:shade val="100000"/><a:satMod val="130000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:tint val="50000"/><a:shade val="100000"/><a:satMod val="350000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="16200000" scaled="0"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w="9525" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"><a:shade val="95000"/><a:satMod val="105000"/></a:schemeClr></a:solidFill><a:prstDash val="solid"/></a:ln><a:ln w="25400" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln><a:ln w="38100" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="20000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="38000"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw></a:effectLst><a:scene3d><a:camera prst="orthographicFront"><a:rot lat="0" lon="0" rev="0"/></a:camera><a:lightRig rig="threePt" dir="t"><a:rot lat="0" lon="0" rev="1200000"/></a:lightRig></a:scene3d><a:sp3d><a:bevelT w="63500" h="25400"/></a:sp3d></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="40000"/><a:satMod val="350000"/></a:schemeClr></a:gs><a:gs pos="40000"><a:schemeClr val="phClr"><a:tint val="45000"/><a:shade val="99000"/><a:satMod val="350000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="20000"/><a:satMod val="255000"/></a:schemeClr></a:gs></a:gsLst><a:path path="circle"><a:fillToRect l="50000" t="-80000" r="50000" b="180000"/></a:path></a:gradFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="80000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="30000"/><a:satMod val="200000"/></a:schemeClr></a:gs></a:gsLst><a:path path="circle"><a:fillToRect l="50000" t="50000" r="50000" b="50000"/></a:path></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults><a:spDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx="1"><a:schemeClr val="accent1"/></a:lnRef><a:fillRef idx="3"><a:schemeClr val="accent1"/></a:fillRef><a:effectRef idx="2"><a:schemeClr val="accent1"/></a:effectRef><a:fontRef idx="minor"><a:schemeClr val="lt1"/></a:fontRef></a:style></a:spDef><a:lnDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx="2"><a:schemeClr val="accent1"/></a:lnRef><a:fillRef idx="0"><a:schemeClr val="accent1"/></a:fillRef><a:effectRef idx="1"><a:schemeClr val="accent1"/></a:effectRef><a:fontRef idx="minor"><a:schemeClr val="tx1"/></a:fontRef></a:style></a:lnDef></a:objectDefaults><a:extraClrSchemeLst/></a:theme>'}function parse_cc_xml(data,opts){var d=[];var l=0,i=1;(data.match(/<[^>]*>/g)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<?xml":break;case"<calcChain":case"<calcChain>":case"</calcChain>":break;case"<c":delete y[0];if(y.i)i=y.i;else y.i=i;d.push(y);break}});return d}var parse_BrtCalcChainItem$=function(data,length){var out={};out.i=data.read_shift(4);var cell={};cell.r=data.read_shift(4);cell.c=data.read_shift(4);out.r=encode_cell(cell);var flags=data.read_shift(1);if(flags&2)out.l="1";if(flags&8)out.a="1";return out};function parse_cc_bin(data,opts){var out=[];var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtCalcChainItem$":out.push(val);break;case"BrtBeginCalcChain$":break;case"BrtEndCalcChain$":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return out}function parse_comments_xml(data,opts){if(data.match(/<(?:\w+:)?comments *\/>/))return[];var authors=[];var commentList=[];data.match(/<(?:\w+:)?authors>([^\u2603]*)<\/(?:\w+:)?authors>/m)[1].split(/<\/(?:\w+:)?author>/).forEach(function(x){if(x===""||x.trim()==="")return;authors.push(x.match(/<(?:\w+:)?author[^>]*>(.*)/)[1])});(data.match(/<(?:\w+:)?commentList>([^\u2603]*)<\/(?:\w+:)?commentList>/m)||["",""])[1].split(/<\/(?:\w+:)?comment>/).forEach(function(x,index){if(x===""||x.trim()==="")return;var y=parsexmltag(x.match(/<(?:\w+:)?comment[^>]*>/)[0]);var comment={author:y.authorId&&authors[y.authorId]?authors[y.authorId]:undefined,ref:y.ref,guid:y.guid};var cell=decode_cell(y.ref);if(opts.sheetRows&&opts.sheetRows<=cell.r)return;var textMatch=x.match(/<text>([^\u2603]*)<\/text>/m);if(!textMatch||!textMatch[1])return;var rt=parse_si(textMatch[1]);comment.r=rt.r;comment.t=rt.t;if(opts.cellHTML)comment.h=rt.h;commentList.push(comment)});return commentList}var parse_BrtBeginComment=function(data,length){var out={};out.iauthor=data.read_shift(4);var rfx=parse_UncheckedRfX(data,16);out.rfx=rfx.s;out.ref=encode_cell(rfx.s);data.l+=16;return out};var parse_BrtCommentAuthor=parse_XLWideString;var parse_BrtCommentText=parse_RichStr;function parse_comments_bin(data,opts){var out=[];var authors=[];var c={};var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtCommentAuthor":authors.push(val);break;case"BrtBeginComment":c=val;break;case"BrtCommentText":c.t=val.t;c.h=val.h;c.r=val.r;break;case"BrtEndComment":c.author=authors[c.iauthor];delete c.iauthor;if(opts.sheetRows&&opts.sheetRows<=c.rfx.r)break;delete c.rfx;out.push(c);break;case"BrtBeginComments":break;case"BrtEndComments":break;case"BrtBeginCommentAuthors":break;case"BrtEndCommentAuthors":break;case"BrtBeginCommentList":break;case"BrtEndCommentList":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return out}function parse_comments(zip,dirComments,sheets,sheetRels,opts){for(var i=0;i!=dirComments.length;++i){var canonicalpath=dirComments[i];var comments=parse_cmnt(getzipdata(zip,canonicalpath.replace(/^\//,""),true),canonicalpath,opts);if(!comments||!comments.length)continue;var sheetNames=keys(sheets);for(var j=0;j!=sheetNames.length;++j){var sheetName=sheetNames[j];var rels=sheetRels[sheetName];if(rels){var rel=rels[canonicalpath];if(rel)insertCommentsIntoSheet(sheetName,sheets[sheetName],comments)}}}}function insertCommentsIntoSheet(sheetName,sheet,comments){comments.forEach(function(comment){var cell=sheet[comment.ref];if(!cell){cell={};sheet[comment.ref]=cell;var range=decode_range(sheet["!ref"]||"BDWGO1000001:A1");var thisCell=decode_cell(comment.ref);if(range.s.r>thisCell.r)range.s.r=thisCell.r;if(range.e.r<thisCell.r)range.e.r=thisCell.r;if(range.s.c>thisCell.c)range.s.c=thisCell.c;if(range.e.c<thisCell.c)range.e.c=thisCell.c;var encoded=encode_range(range);if(encoded!==sheet["!ref"])sheet["!ref"]=encoded}if(!cell.c)cell.c=[];var o={a:comment.author,t:comment.t,r:comment.r};if(comment.h)o.h=comment.h;cell.c.push(o)})}var parse_CellParsedFormula=function(data,length){var cce=data.read_shift(4);return parsenoop(data,length-4)};var strs={};var _ssfopts={};RELS.WS="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet";function get_sst_id(sst,str){for(var i=0;i!=sst.length;++i)if(sst[i].t===str){sst.Count++;return i}sst[sst.length]={t:str};sst.Count++;sst.Unique++;return sst.length-1}function get_cell_style(styles,cell,opts){var z=opts.revssf[cell.z||"General"];for(var i=0;i!=styles.length;++i)if(styles[i].numFmtId===z)return i;styles[styles.length]={numFmtId:z,fontId:0,fillId:0,borderId:0,xfId:0,applyNumberFormat:1};return styles.length-1}function parse_ws_xml(data,opts,rels){if(!data)return data;var s={},mtch;var ref=data.match(/<dimension ref="([^"]*)"\s*\/>/);if(ref&&ref.length==2&&ref[1].indexOf(":")!==-1)s["!ref"]=ref[1];var mergecells=[];if(data.match(/<\/mergeCells>/)){var merges=data.match(/<mergeCell ref="([A-Z0-9:]+)"\s*\/>/g);mergecells=merges.map(function(range){return decode_range(/<mergeCell ref="([A-Z0-9:]+)"\s*\/>/.exec(range)[1])})}var refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};var q=["v","f"];var sidx=0;if(mtch=data.match(/<(?:\w+:)?sheetData>([^\u2603]*)<\/(?:\w+:)?sheetData>/m))mtch[1].split(/<\/(?:\w+:)?row>/).forEach(function(x){if(x===""||x.trim()==="")return;var row=parsexmltag(x.match(/<(?:\w+:)?row[^>]*>/)[0]);if(opts.sheetRows&&opts.sheetRows<+row.r)return;if(refguess.s.r>row.r-1)refguess.s.r=row.r-1;if(refguess.e.r<row.r-1)refguess.e.r=row.r-1;var cells=x.substr(x.indexOf(">")+1).split(/<(?:\w+:)?c /);cells.forEach(function(c,idx){if(c===""||c.trim()==="")return;var cref=c.match(/r=["']([^"']*)["']/);c="<c "+c;if(cref&&cref.length==2)idx=decode_cell(cref[1]).c;var cell=parsexmltag((c.match(/<c[^>]*>/)||[c])[0]);delete cell[0];var d=c.substr(c.indexOf(">")+1);var p={};q.forEach(function(f){var x=d.match(matchtag(f));if(x)p[f]=unescapexml(x[1])});if(cell.t===undefined&&p.v===undefined){if(!opts.sheetStubs)return;p.t="str";p.v=undefined}else p.t=cell.t?cell.t:"n";if(refguess.s.c>idx)refguess.s.c=idx;if(refguess.e.c<idx)refguess.e.c=idx;switch(p.t){case"n":p.v=parseFloat(p.v);break;case"s":{sidx=parseInt(p.v,10);p.v=strs[sidx].t;p.r=strs[sidx].r;if(opts.cellHTML)p.h=strs[sidx].h}break;case"str":if(p.v)p.v=utf8read(p.v);break;case"inlineStr":var is=d.match(/<is>(.*)<\/is>/);is=is?parse_si(is[1]):{t:"",r:""};p.t="str";p.v=is.t;break;case"b":if(typeof p.v!=="boolean")p.v=parsexmlbool(p.v);break;case"d":p.v=datenum(p.v);p.t="n";break;case"e":p.raw=RBErr[p.v];break}var fmtid=0;if(cell.s&&styles.CellXf){var cf=styles.CellXf[cell.s];if(cf&&cf.numFmtId)fmtid=cf.numFmtId}try{p.w=SSF.format(fmtid,p.v,_ssfopts);if(opts.cellNF)p.z=SSF._table[fmtid]}catch(e){if(opts.WTF)throw e}s[cell.r]=p})});if(data.match(/<\/hyperlinks>/))data.match(/<hyperlink[^>]*\/>/g).forEach(function(h){var val=parsexmltag(h);delete val[0];if(!val.ref)return;var rel=rels["!id"][val.id];if(rel){val.Target=rel.Target;if(val.location)val.Target+="#"+val.location;val.Rel=rel}var rng=decode_range(val.ref);for(var R=rng.s.r;R<=rng.e.r;++R)for(var C=rng.s.c;C<=rng.e.c;++C){var addr=encode_cell({c:C,r:R});if(!s[addr])s[addr]={t:"str",v:undefined};s[addr].l=val}});if(!s["!ref"]&&refguess.e.c>=refguess.s.c&&refguess.e.r>=refguess.s.r)s["!ref"]=encode_range(refguess);if(opts.sheetRows&&s["!ref"]){var tmpref=decode_range(s["!ref"]);if(opts.sheetRows<+tmpref.e.r){tmpref.e.r=opts.sheetRows-1;if(tmpref.e.r>refguess.e.r)tmpref.e.r=refguess.e.r;if(tmpref.e.r<tmpref.s.r)tmpref.s.r=tmpref.e.r;if(tmpref.e.c>refguess.e.c)tmpref.e.c=refguess.e.c;if(tmpref.e.c<tmpref.s.c)tmpref.s.c=tmpref.e.c;s["!fullref"]=s["!ref"];s["!ref"]=encode_range(tmpref)}}if(mergecells.length>0)s["!merges"]=mergecells;return s}var WS_XML_ROOT=writextag("worksheet",null,{xmlns:XMLNS.main[0],"xmlns:r":XMLNS.r});var write_ws_xml_cell=function(cell,ref,ws,opts,idx,wb){var vv=cell.v;if(cell.t=="b")vv=cell.v?"1":"0";var v=writextag("v",escapexml(String(vv))),o={r:ref};o.s=get_cell_style(opts.cellXfs,cell,opts);if(o.s===0||o.s==="0")delete o.s;if(typeof cell.v==="undefined")return"";switch(cell.t){case"s":case"str":{if(opts.bookSST){v=writextag("v",String(get_sst_id(opts.Strings,cell.v)));o.t="s";return writextag("c",v,o)}else{o.t="str";return writextag("c",v,o)}}break;case"n":delete o.t;return writextag("c",v,o);case"b":o.t="b";return writextag("c",v,o);case"e":o.t="e";return writextag("c",v,o)}};var write_ws_xml_data=function(ws,opts,idx,wb){var o=[],r=[],range=utils.decode_range(ws["!ref"]),cell,ref;for(var R=range.s.r;R<=range.e.r;++R){r=[];for(var C=range.s.c;C<=range.e.c;++C){ref=utils.encode_cell({c:C,r:R});if(!ws[ref])continue;if(cell=write_ws_xml_cell(ws[ref],ref,ws,opts,idx,wb))r.push(cell)}if(r.length)o.push(writextag("row",r.join(""),{r:encode_row(R)}))}return o.join("")};var write_ws_xml=function(idx,opts,wb){var o=[],s=wb.SheetNames[idx],ws=wb.Sheets[s]||{},sidx=0,rdata="";o.push(XML_HEADER);o.push(WS_XML_ROOT);o.push(writextag("dimension",null,{ref:ws["!ref"]||"A1"}));sidx=o.length;o.push(writextag("sheetData",null));if(ws["!ref"])rdata=write_ws_xml_data(ws,opts,idx,wb);if(rdata.length)o.push(rdata);if(o.length>sidx+1){o.push("</sheetData>");o[sidx]=o[sidx].replace("/>",">")}if(o.length>2){o.push("</worksheet>");o[1]=o[1].replace("/>",">")}return o.join("")};var parse_BrtRowHdr=function(data,length){var z={};z.r=data.read_shift(4);data.l+=length-4;return z};var parse_BrtWsDim=parse_UncheckedRfX;var parse_BrtWsProp=function(data,length){var z={};data.l+=19;z.name=parse_CodeName(data,length-19);return z};var parse_BrtCellBlank=function(data,length){var cell=parse_Cell(data);return[cell]};var parse_BrtCellBool=function(data,length){var cell=parse_Cell(data);var fBool=data.read_shift(1);return[cell,fBool,"b"]};var parse_BrtCellError=function(data,length){var cell=parse_Cell(data);var fBool=data.read_shift(1);return[cell,fBool,"e"]};var parse_BrtCellIsst=function(data,length){var cell=parse_Cell(data);var isst=data.read_shift(4);return[cell,isst,"s"]};var parse_BrtCellReal=function(data,length){var cell=parse_Cell(data);var value=parse_Xnum(data);return[cell,value,"n"]};var parse_BrtCellRk=function(data,length){var cell=parse_Cell(data);var value=parse_RkNumber(data);return[cell,value,"n"]};var parse_BrtCellSt=function(data,length){var cell=parse_Cell(data);var value=parse_XLWideString(data);return[cell,value,"str"]};var parse_BrtFmlaBool=function(data,length,opts){var cell=parse_Cell(data);var value=data.read_shift(1);var o=[cell,value,"b"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,length-9);o[3]=""}else data.l+=length-9;return o};var parse_BrtFmlaError=function(data,length,opts){var cell=parse_Cell(data);var value=data.read_shift(1);var o=[cell,value,"e"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,length-9);o[3]=""}else data.l+=length-9;return o};var parse_BrtFmlaNum=function(data,length,opts){var cell=parse_Cell(data);var value=parse_Xnum(data);var o=[cell,value,"n"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,length-16);o[3]=""}else data.l+=length-16;return o};var parse_BrtFmlaString=function(data,length,opts){var start=data.l;var cell=parse_Cell(data);var value=parse_XLWideString(data);var o=[cell,value,"str"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,start+length-data.l);o[3]=""}else data.l=start+length;return o};var parse_BrtMergeCell=parse_UncheckedRfX;var parse_BrtHLink=function(data,length,opts){var end=data.l+length;var rfx=parse_UncheckedRfX(data,16);var relId=parse_XLNullableWideString(data);var loc=parse_XLWideString(data);var tooltip=parse_XLWideString(data);var display=parse_XLWideString(data);data.l=end;return{rfx:rfx,relId:relId,loc:loc,tooltip:tooltip,display:display}};var parse_ws_bin=function(data,opts,rels){if(!data)return data;if(!rels)rels={"!id":{}};var s={};var ref;var refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};var pass=false,end=false;var row,p,cf,R,C,addr;var mergecells=[];recordhopper(data,function(val,R){if(end)return;switch(R.n){case"BrtWsDim":ref=val;break;case"BrtRowHdr":row=val;if(opts.sheetRows&&opts.sheetRows<=row.r)end=true;break;case"BrtFmlaBool":case"BrtFmlaError":case"BrtFmlaNum":case"BrtFmlaString":case"BrtCellBool":case"BrtCellError":case"BrtCellIsst":case"BrtCellReal":case"BrtCellRk":case"BrtCellSt":p={t:val[2]};switch(val[2]){case"n":p.v=val[1];break;case"s":p.v=strs[val[1]].t;p.r=strs[val[1]].r;break;case"b":p.v=val[1]?true:false;break;case"e":p.raw=val[1];p.v=BErr[p.raw];break;case"str":p.v=utf8read(val[1]);break}if(opts.cellFormula&&val.length>3)p.f=val[3];if(cf=styles.CellXf[val[0].iStyleRef])try{p.w=SSF.format(cf.ifmt,p.v,_ssfopts);if(opts.cellNF)p.z=SSF._table[cf.ifmt]}catch(e){if(opts.WTF)throw e}s[encode_cell({c:val[0].c,r:row.r})]=p;if(refguess.s.r>row.r)refguess.s.r=row.r;if(refguess.s.c>val[0].c)refguess.s.c=val[0].c;if(refguess.e.r<row.r)refguess.e.r=row.r;if(refguess.e.c<val[0].c)refguess.e.c=val[0].c;break;case"BrtCellBlank":if(!opts.sheetStubs)break;p={t:"str",v:undefined};s[encode_cell({c:val[0].c,r:row.r})]=p;if(refguess.s.r>row.r)refguess.s.r=row.r;if(refguess.s.c>val[0].c)refguess.s.c=val[0].c;if(refguess.e.r<row.r)refguess.e.r=row.r;if(refguess.e.c<val[0].c)refguess.e.c=val[0].c;
break;case"BrtBeginMergeCells":break;case"BrtEndMergeCells":break;case"BrtMergeCell":mergecells.push(val);break;case"BrtHLink":var rel=rels["!id"][val.relId];if(rel){val.Target=rel.Target;if(val.loc)val.Target+="#"+val.loc;val.Rel=rel}for(R=val.rfx.s.r;R<=val.rfx.e.r;++R)for(C=val.rfx.s.c;C<=val.rfx.e.c;++C){addr=encode_cell({c:C,r:R});if(!s[addr])s[addr]={t:"str",v:undefined};s[addr].l=val}break;case"BrtArrFmla":break;case"BrtShrFmla":break;case"BrtBeginSheet":break;case"BrtWsProp":break;case"BrtSheetCalcProp":break;case"BrtBeginWsViews":break;case"BrtBeginWsView":break;case"BrtPane":break;case"BrtSel":break;case"BrtEndWsView":break;case"BrtEndWsViews":break;case"BrtACBegin":break;case"BrtRwDescent":break;case"BrtACEnd":break;case"BrtWsFmtInfoEx14":break;case"BrtWsFmtInfo":break;case"BrtBeginColInfos":break;case"BrtColInfo":break;case"BrtEndColInfos":break;case"BrtBeginSheetData":break;case"BrtEndSheetData":break;case"BrtSheetProtection":break;case"BrtPrintOptions":break;case"BrtMargins":break;case"BrtPageSetup":break;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;case"BrtEndSheet":break;case"BrtDrawing":break;case"BrtLegacyDrawing":break;case"BrtLegacyDrawingHF":break;case"BrtPhoneticInfo":break;case"BrtBeginHeaderFooter":break;case"BrtEndHeaderFooter":break;case"BrtBrk":break;case"BrtBeginRwBrk":break;case"BrtEndRwBrk":break;case"BrtBeginColBrk":break;case"BrtEndColBrk":break;case"BrtBeginUserShViews":break;case"BrtBeginUserShView":break;case"BrtEndUserShView":break;case"BrtEndUserShViews":break;case"BrtBkHim":break;case"BrtBeginOleObjects":break;case"BrtOleObject":break;case"BrtEndOleObjects":break;case"BrtBeginListParts":break;case"BrtListPart":break;case"BrtEndListParts":break;case"BrtBeginSortState":break;case"BrtBeginSortCond":break;case"BrtEndSortCond":break;case"BrtEndSortState":break;case"BrtBeginConditionalFormatting":break;case"BrtEndConditionalFormatting":break;case"BrtBeginCFRule":break;case"BrtEndCFRule":break;case"BrtBeginDVals":break;case"BrtDVal":break;case"BrtEndDVals":break;case"BrtRangeProtection":break;case"BrtBeginDCon":break;case"BrtEndDCon":break;case"BrtBeginDRefs":break;case"BrtDRef":break;case"BrtEndDRefs":break;case"BrtBeginActiveXControls":break;case"BrtActiveX":break;case"BrtEndActiveXControls":break;case"BrtBeginAFilter":break;case"BrtEndAFilter":break;case"BrtBeginFilterColumn":break;case"BrtBeginFilters":break;case"BrtFilter":break;case"BrtEndFilters":break;case"BrtEndFilterColumn":break;case"BrtDynamicFilter":break;case"BrtTop10Filter":break;case"BrtBeginCustomFilters":break;case"BrtCustomFilter":break;case"BrtEndCustomFilters":break;case"BrtBeginCellWatches":break;case"BrtCellWatch":break;case"BrtEndCellWatches":break;case"BrtTable":break;case"BrtBeginCellIgnoreECs":break;case"BrtCellIgnoreEC":break;case"BrtEndCellIgnoreECs":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+R.n)}},opts);if(!s["!ref"]&&(refguess.s.r<1e6||ref.e.r>0||ref.e.c>0||ref.s.r>0||ref.s.c>0))s["!ref"]=encode_range(ref);if(opts.sheetRows&&s["!ref"]){var tmpref=decode_range(s["!ref"]);if(opts.sheetRows<+tmpref.e.r){tmpref.e.r=opts.sheetRows-1;if(tmpref.e.r>refguess.e.r)tmpref.e.r=refguess.e.r;if(tmpref.e.r<tmpref.s.r)tmpref.s.r=tmpref.e.r;if(tmpref.e.c>refguess.e.c)tmpref.e.c=refguess.e.c;if(tmpref.e.c<tmpref.s.c)tmpref.s.c=tmpref.e.c;s["!fullref"]=s["!ref"];s["!ref"]=encode_range(tmpref)}}if(mergecells.length>0)s["!merges"]=mergecells;return s};var write_ws_bin=function(wb,opts,rels){};var WBPropsDef={allowRefreshQuery:"0",autoCompressPictures:"1",backupFile:"0",checkCompatibility:"0",codeName:"",date1904:"0",dateCompatibility:"1",filterPrivacy:"0",hidePivotFieldList:"0",promptedSolutions:"0",publishItems:"0",refreshAllConnections:false,saveExternalLinkValues:"1",showBorderUnselectedTables:"1",showInkAnnotation:"1",showObjects:"all",showPivotChartFilter:"0"};var WBViewDef={activeTab:"0",autoFilterDateGrouping:"1",firstSheet:"0",minimized:"0",showHorizontalScroll:"1",showSheetTabs:"1",showVerticalScroll:"1",tabRatio:"600",visibility:"visible"};var SheetDef={state:"visible"};var CalcPrDef={calcCompleted:"true",calcMode:"auto",calcOnSave:"true",concurrentCalc:"true",fullCalcOnLoad:"false",fullPrecision:"true",iterate:"false",iterateCount:"100",iterateDelta:"0.001",refMode:"A1"};var CustomWBViewDef={autoUpdate:"false",changesSavedWin:"false",includeHiddenRowCol:"true",includePrintSettings:"true",maximized:"false",minimized:"false",onlySync:"false",personalView:"false",showComments:"commIndicator",showFormulaBar:"true",showHorizontalScroll:"true",showObjects:"all",showSheetTabs:"true",showStatusbar:"true",showVerticalScroll:"true",tabRatio:"600",xWindow:"0",yWindow:"0"};function parse_wb_xml(data){var wb={AppVersion:{},WBProps:{},WBView:[],Sheets:[],CalcPr:{},xmlns:""};var pass=false,xmlns="xmlns";data.match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);switch(y[0].replace(/<\w+:/,"<")){case"<?xml":break;case"<workbook":if(x.match(/<\w+:workbook/))xmlns="xmlns"+x.match(/<(\w+):/)[1];wb.xmlns=y[xmlns];break;case"</workbook>":break;case"<fileVersion":delete y[0];wb.AppVersion=y;break;case"<fileVersion/>":break;case"<fileSharing":case"<fileSharing/>":break;case"<workbookPr":delete y[0];wb.WBProps=y;break;case"<workbookPr/>":delete y[0];wb.WBProps=y;break;case"<workbookProtection/>":break;case"<bookViews>":case"</bookViews>":break;case"<workbookView":delete y[0];wb.WBView.push(y);break;case"<sheets>":case"</sheets>":break;case"<sheet":delete y[0];y.name=utf8read(y.name);wb.Sheets.push(y);break;case"<functionGroups":case"<functionGroups/>":break;case"<functionGroup":break;case"<externalReferences":case"</externalReferences>":break;case"<externalReference":break;case"<definedNames/>":break;case"<definedNames>":pass=true;break;case"</definedNames>":pass=false;break;case"<definedName":case"<definedName/>":case"</definedName>":break;case"<calcPr":delete y[0];wb.CalcPr=y;break;case"<calcPr/>":delete y[0];wb.CalcPr=y;break;case"<oleSize":break;case"<customWorkbookViews>":case"</customWorkbookViews>":case"<customWorkbookViews":break;case"<customWorkbookView":case"</customWorkbookView>":break;case"<pivotCaches>":case"</pivotCaches>":case"<pivotCaches":break;case"<pivotCache":break;case"<smartTagPr":case"<smartTagPr/>":break;case"<smartTagTypes":case"<smartTagTypes>":case"</smartTagTypes>":break;case"<smartTagType":break;case"<webPublishing":case"<webPublishing/>":break;case"<fileRecoveryPr":case"<fileRecoveryPr/>":break;case"<webPublishObjects>":case"<webPublishObjects":case"</webPublishObjects>":break;case"<webPublishObject":break;case"<extLst>":case"</extLst>":case"<extLst/>":break;case"<ext":pass=true;break;case"</ext>":pass=false;break;case"<mx:ArchID":break;case"<mc:AlternateContent":pass=true;break;case"</mc:AlternateContent>":pass=false;break}});if(XMLNS.main.indexOf(wb.xmlns)===-1)throw new Error("Unknown Namespace: "+wb.xmlns);var z;for(z in WBPropsDef)if(typeof wb.WBProps[z]==="undefined")wb.WBProps[z]=WBPropsDef[z];for(z in CalcPrDef)if(typeof wb.CalcPr[z]==="undefined")wb.CalcPr[z]=CalcPrDef[z];wb.WBView.forEach(function(w){for(var z in WBViewDef)if(typeof w[z]==="undefined")w[z]=WBViewDef[z]});wb.Sheets.forEach(function(w){for(var z in SheetDef)if(typeof w[z]==="undefined")w[z]=SheetDef[z]});_ssfopts.date1904=parsexmlbool(wb.WBProps.date1904,"date1904");return wb}var WB_XML_ROOT=writextag("workbook",null,{xmlns:XMLNS.main[0],"xmlns:r":XMLNS.r});var write_wb_xml=function(wb,opts){var o=[];o.push(XML_HEADER);o.push(WB_XML_ROOT);var date1904="false";try{date1904=parsexmlbool(wb.Workbook.WBProps.date1904)?"true":"false"}catch(e){date1904="false"}o.push(writextag("workbookPr",null,{date1904:date1904}));o.push("<sheets>");var i=1;wb.SheetNames.forEach(function(s){o.push(writextag("sheet",null,{name:s,sheetId:String(i),"r:id":"rId"+i}));++i});o.push("</sheets>");if(o.length>2){o.push("</workbook>");o[1]=o[1].replace("/>",">")}return o.join("")};var parse_BrtBundleSh=function(data,length){var z={};z.hsState=data.read_shift(4);z.iTabID=data.read_shift(4);z.strRelID=parse_RelID(data,length-8);z.name=parse_XLWideString(data);return z};var parse_wb_bin=function(data,opts){var wb={AppVersion:{},WBProps:{},WBView:[],Sheets:[],CalcPr:{},xmlns:""};var pass=false,z;recordhopper(data,function(val,R){switch(R.n){case"BrtBundleSh":wb.Sheets.push(val);break;case"BrtBeginBook":break;case"BrtFileVersion":break;case"BrtWbProp":break;case"BrtACBegin":break;case"BrtAbsPath15":break;case"BrtACEnd":break;case"BrtBookProtection":break;case"BrtBeginBookViews":break;case"BrtBookView":break;case"BrtEndBookViews":break;case"BrtBeginBundleShs":break;case"BrtEndBundleShs":break;case"BrtBeginFnGroup":break;case"BrtEndFnGroup":break;case"BrtBeginExternals":break;case"BrtSupSelf":break;case"BrtSupBookSrc":break;case"BrtExternSheet":break;case"BrtEndExternals":break;case"BrtName":break;case"BrtCalcProp":break;case"BrtUserBookView":break;case"BrtBeginPivotCacheIDs":break;case"BrtBeginPivotCacheID":break;case"BrtEndPivotCacheID":break;case"BrtEndPivotCacheIDs":break;case"BrtWebOpt":break;case"BrtFileRecover":break;case"BrtFileSharing":break;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;case"BrtEndBook":break;default:if(!pass)throw new Error("Unexpected record "+R.n)}});for(z in WBPropsDef)if(typeof wb.WBProps[z]==="undefined")wb.WBProps[z]=WBPropsDef[z];for(z in CalcPrDef)if(typeof wb.CalcPr[z]==="undefined")wb.CalcPr[z]=CalcPrDef[z];wb.WBView.forEach(function(w){for(var z in WBViewDef)if(typeof w[z]==="undefined")w[z]=WBViewDef[z]});wb.Sheets.forEach(function(w){for(var z in SheetDef)if(typeof w[z]==="undefined")w[z]=SheetDef[z]});_ssfopts.date1904=parsexmlbool(wb.WBProps.date1904,"date1904");return wb};var write_wb_bin=function(wb,opts){};function parse_wb(data,name,opts){return(name.substr(-4)===".bin"?parse_wb_bin:parse_wb_xml)(data,opts)}function parse_ws(data,name,opts,rels){return(name.substr(-4)===".bin"?parse_ws_bin:parse_ws_xml)(data,opts,rels)}function parse_sty(data,name,opts){return(name.substr(-4)===".bin"?parse_sty_bin:parse_sty_xml)(data,opts)}function parse_sst(data,name,opts){return(name.substr(-4)===".bin"?parse_sst_bin:parse_sst_xml)(data,opts)}function parse_cmnt(data,name,opts){return(name.substr(-4)===".bin"?parse_comments_bin:parse_comments_xml)(data,opts)}function parse_cc(data,name,opts){return(name.substr(-4)===".bin"?parse_cc_bin:parse_cc_xml)(data,opts)}function write_wb(wb,name,opts){return(name.substr(-4)===".bin"?write_wb_bin:write_wb_xml)(wb,opts)}function write_ws(data,name,opts,wb){return(name.substr(-4)===".bin"?write_ws_bin:write_ws_xml)(data,opts,wb)}function write_sty(data,name,opts){return(name.substr(-4)===".bin"?write_sty_bin:write_sty_xml)(data,opts)}function write_sst(data,name,opts){return(name.substr(-4)===".bin"?write_sst_bin:write_sst_xml)(data,opts)}var RecordEnum={0:{n:"BrtRowHdr",f:parse_BrtRowHdr},1:{n:"BrtCellBlank",f:parse_BrtCellBlank},2:{n:"BrtCellRk",f:parse_BrtCellRk},3:{n:"BrtCellError",f:parse_BrtCellError},4:{n:"BrtCellBool",f:parse_BrtCellBool},5:{n:"BrtCellReal",f:parse_BrtCellReal},6:{n:"BrtCellSt",f:parse_BrtCellSt},7:{n:"BrtCellIsst",f:parse_BrtCellIsst},8:{n:"BrtFmlaString",f:parse_BrtFmlaString},9:{n:"BrtFmlaNum",f:parse_BrtFmlaNum},10:{n:"BrtFmlaBool",f:parse_BrtFmlaBool},11:{n:"BrtFmlaError",f:parse_BrtFmlaError},19:{n:"BrtSSTItem",f:parse_RichStr},20:{n:"BrtPCDIMissing",f:parsenoop},21:{n:"BrtPCDINumber",f:parsenoop},22:{n:"BrtPCDIBoolean",f:parsenoop},23:{n:"BrtPCDIError",f:parsenoop},24:{n:"BrtPCDIString",f:parsenoop},25:{n:"BrtPCDIDatetime",f:parsenoop},26:{n:"BrtPCDIIndex",f:parsenoop},27:{n:"BrtPCDIAMissing",f:parsenoop},28:{n:"BrtPCDIANumber",f:parsenoop},29:{n:"BrtPCDIABoolean",f:parsenoop},30:{n:"BrtPCDIAError",f:parsenoop},31:{n:"BrtPCDIAString",f:parsenoop},32:{n:"BrtPCDIADatetime",f:parsenoop},33:{n:"BrtPCRRecord",f:parsenoop},34:{n:"BrtPCRRecordDt",f:parsenoop},35:{n:"BrtFRTBegin",f:parsenoop},36:{n:"BrtFRTEnd",f:parsenoop},37:{n:"BrtACBegin",f:parsenoop},38:{n:"BrtACEnd",f:parsenoop},39:{n:"BrtName",f:parsenoop},40:{n:"BrtIndexRowBlock",f:parsenoop},42:{n:"BrtIndexBlock",f:parsenoop},43:{n:"BrtFont",f:parse_BrtFont},44:{n:"BrtFmt",f:parse_BrtFmt},45:{n:"BrtFill",f:parsenoop},46:{n:"BrtBorder",f:parsenoop},47:{n:"BrtXF",f:parse_BrtXF},48:{n:"BrtStyle",f:parsenoop},49:{n:"BrtCellMeta",f:parsenoop},50:{n:"BrtValueMeta",f:parsenoop},51:{n:"BrtMdb",f:parsenoop},52:{n:"BrtBeginFmd",f:parsenoop},53:{n:"BrtEndFmd",f:parsenoop},54:{n:"BrtBeginMdx",f:parsenoop},55:{n:"BrtEndMdx",f:parsenoop},56:{n:"BrtBeginMdxTuple",f:parsenoop},57:{n:"BrtEndMdxTuple",f:parsenoop},58:{n:"BrtMdxMbrIstr",f:parsenoop},59:{n:"BrtStr",f:parsenoop},60:{n:"BrtColInfo",f:parsenoop},62:{n:"BrtCellRString",f:parsenoop},63:{n:"BrtCalcChainItem$",f:parse_BrtCalcChainItem$},64:{n:"BrtDVal",f:parsenoop},65:{n:"BrtSxvcellNum",f:parsenoop},66:{n:"BrtSxvcellStr",f:parsenoop},67:{n:"BrtSxvcellBool",f:parsenoop},68:{n:"BrtSxvcellErr",f:parsenoop},69:{n:"BrtSxvcellDate",f:parsenoop},70:{n:"BrtSxvcellNil",f:parsenoop},128:{n:"BrtFileVersion",f:parsenoop},129:{n:"BrtBeginSheet",f:parsenoop},130:{n:"BrtEndSheet",f:parsenoop},131:{n:"BrtBeginBook",f:parsenoop},132:{n:"BrtEndBook",f:parsenoop},133:{n:"BrtBeginWsViews",f:parsenoop},134:{n:"BrtEndWsViews",f:parsenoop},135:{n:"BrtBeginBookViews",f:parsenoop},136:{n:"BrtEndBookViews",f:parsenoop},137:{n:"BrtBeginWsView",f:parsenoop},138:{n:"BrtEndWsView",f:parsenoop},139:{n:"BrtBeginCsViews",f:parsenoop},140:{n:"BrtEndCsViews",f:parsenoop},141:{n:"BrtBeginCsView",f:parsenoop},142:{n:"BrtEndCsView",f:parsenoop},143:{n:"BrtBeginBundleShs",f:parsenoop},144:{n:"BrtEndBundleShs",f:parsenoop},145:{n:"BrtBeginSheetData",f:parsenoop},146:{n:"BrtEndSheetData",f:parsenoop},147:{n:"BrtWsProp",f:parse_BrtWsProp},148:{n:"BrtWsDim",f:parse_BrtWsDim},151:{n:"BrtPane",f:parsenoop},152:{n:"BrtSel",f:parsenoop},153:{n:"BrtWbProp",f:parsenoop},154:{n:"BrtWbFactoid",f:parsenoop},155:{n:"BrtFileRecover",f:parsenoop},156:{n:"BrtBundleSh",f:parse_BrtBundleSh},157:{n:"BrtCalcProp",f:parsenoop},158:{n:"BrtBookView",f:parsenoop},159:{n:"BrtBeginSst",f:parse_BrtBeginSst},160:{n:"BrtEndSst",f:parsenoop},161:{n:"BrtBeginAFilter",f:parsenoop},162:{n:"BrtEndAFilter",f:parsenoop},163:{n:"BrtBeginFilterColumn",f:parsenoop},164:{n:"BrtEndFilterColumn",f:parsenoop},165:{n:"BrtBeginFilters",f:parsenoop},166:{n:"BrtEndFilters",f:parsenoop},167:{n:"BrtFilter",f:parsenoop},168:{n:"BrtColorFilter",f:parsenoop},169:{n:"BrtIconFilter",f:parsenoop},170:{n:"BrtTop10Filter",f:parsenoop},171:{n:"BrtDynamicFilter",f:parsenoop},172:{n:"BrtBeginCustomFilters",f:parsenoop},173:{n:"BrtEndCustomFilters",f:parsenoop},174:{n:"BrtCustomFilter",f:parsenoop},175:{n:"BrtAFilterDateGroupItem",f:parsenoop},176:{n:"BrtMergeCell",f:parse_BrtMergeCell},177:{n:"BrtBeginMergeCells",f:parsenoop},178:{n:"BrtEndMergeCells",f:parsenoop},179:{n:"BrtBeginPivotCacheDef",f:parsenoop},180:{n:"BrtEndPivotCacheDef",f:parsenoop},181:{n:"BrtBeginPCDFields",f:parsenoop},182:{n:"BrtEndPCDFields",f:parsenoop},183:{n:"BrtBeginPCDField",f:parsenoop},184:{n:"BrtEndPCDField",f:parsenoop},185:{n:"BrtBeginPCDSource",f:parsenoop},186:{n:"BrtEndPCDSource",f:parsenoop},187:{n:"BrtBeginPCDSRange",f:parsenoop},188:{n:"BrtEndPCDSRange",f:parsenoop},189:{n:"BrtBeginPCDFAtbl",f:parsenoop},190:{n:"BrtEndPCDFAtbl",f:parsenoop},191:{n:"BrtBeginPCDIRun",f:parsenoop},192:{n:"BrtEndPCDIRun",f:parsenoop},193:{n:"BrtBeginPivotCacheRecords",f:parsenoop},194:{n:"BrtEndPivotCacheRecords",f:parsenoop},195:{n:"BrtBeginPCDHierarchies",f:parsenoop},196:{n:"BrtEndPCDHierarchies",f:parsenoop},197:{n:"BrtBeginPCDHierarchy",f:parsenoop},198:{n:"BrtEndPCDHierarchy",f:parsenoop},199:{n:"BrtBeginPCDHFieldsUsage",f:parsenoop},200:{n:"BrtEndPCDHFieldsUsage",f:parsenoop},201:{n:"BrtBeginExtConnection",f:parsenoop},202:{n:"BrtEndExtConnection",f:parsenoop},203:{n:"BrtBeginECDbProps",f:parsenoop},204:{n:"BrtEndECDbProps",f:parsenoop},205:{n:"BrtBeginECOlapProps",f:parsenoop},206:{n:"BrtEndECOlapProps",f:parsenoop},207:{n:"BrtBeginPCDSConsol",f:parsenoop},208:{n:"BrtEndPCDSConsol",f:parsenoop},209:{n:"BrtBeginPCDSCPages",f:parsenoop},210:{n:"BrtEndPCDSCPages",f:parsenoop},211:{n:"BrtBeginPCDSCPage",f:parsenoop},212:{n:"BrtEndPCDSCPage",f:parsenoop},213:{n:"BrtBeginPCDSCPItem",f:parsenoop},214:{n:"BrtEndPCDSCPItem",f:parsenoop},215:{n:"BrtBeginPCDSCSets",f:parsenoop},216:{n:"BrtEndPCDSCSets",f:parsenoop},217:{n:"BrtBeginPCDSCSet",f:parsenoop},218:{n:"BrtEndPCDSCSet",f:parsenoop},219:{n:"BrtBeginPCDFGroup",f:parsenoop},220:{n:"BrtEndPCDFGroup",f:parsenoop},221:{n:"BrtBeginPCDFGItems",f:parsenoop},222:{n:"BrtEndPCDFGItems",f:parsenoop},223:{n:"BrtBeginPCDFGRange",f:parsenoop},224:{n:"BrtEndPCDFGRange",f:parsenoop},225:{n:"BrtBeginPCDFGDiscrete",f:parsenoop},226:{n:"BrtEndPCDFGDiscrete",f:parsenoop},227:{n:"BrtBeginPCDSDTupleCache",f:parsenoop},228:{n:"BrtEndPCDSDTupleCache",f:parsenoop},229:{n:"BrtBeginPCDSDTCEntries",f:parsenoop},230:{n:"BrtEndPCDSDTCEntries",f:parsenoop},231:{n:"BrtBeginPCDSDTCEMembers",f:parsenoop},232:{n:"BrtEndPCDSDTCEMembers",f:parsenoop},233:{n:"BrtBeginPCDSDTCEMember",f:parsenoop},234:{n:"BrtEndPCDSDTCEMember",f:parsenoop},235:{n:"BrtBeginPCDSDTCQueries",f:parsenoop},236:{n:"BrtEndPCDSDTCQueries",f:parsenoop},237:{n:"BrtBeginPCDSDTCQuery",f:parsenoop},238:{n:"BrtEndPCDSDTCQuery",f:parsenoop},239:{n:"BrtBeginPCDSDTCSets",f:parsenoop},240:{n:"BrtEndPCDSDTCSets",f:parsenoop},241:{n:"BrtBeginPCDSDTCSet",f:parsenoop},242:{n:"BrtEndPCDSDTCSet",f:parsenoop},243:{n:"BrtBeginPCDCalcItems",f:parsenoop},244:{n:"BrtEndPCDCalcItems",f:parsenoop},245:{n:"BrtBeginPCDCalcItem",f:parsenoop},246:{n:"BrtEndPCDCalcItem",f:parsenoop},247:{n:"BrtBeginPRule",f:parsenoop},248:{n:"BrtEndPRule",f:parsenoop},249:{n:"BrtBeginPRFilters",f:parsenoop},250:{n:"BrtEndPRFilters",f:parsenoop},251:{n:"BrtBeginPRFilter",f:parsenoop},252:{n:"BrtEndPRFilter",f:parsenoop},253:{n:"BrtBeginPNames",f:parsenoop},254:{n:"BrtEndPNames",f:parsenoop},255:{n:"BrtBeginPName",f:parsenoop},256:{n:"BrtEndPName",f:parsenoop},257:{n:"BrtBeginPNPairs",f:parsenoop},258:{n:"BrtEndPNPairs",f:parsenoop},259:{n:"BrtBeginPNPair",f:parsenoop},260:{n:"BrtEndPNPair",f:parsenoop},261:{n:"BrtBeginECWebProps",f:parsenoop},262:{n:"BrtEndECWebProps",f:parsenoop},263:{n:"BrtBeginEcWpTables",f:parsenoop},264:{n:"BrtEndECWPTables",f:parsenoop},265:{n:"BrtBeginECParams",f:parsenoop},266:{n:"BrtEndECParams",f:parsenoop},267:{n:"BrtBeginECParam",f:parsenoop},268:{n:"BrtEndECParam",f:parsenoop},269:{n:"BrtBeginPCDKPIs",f:parsenoop},270:{n:"BrtEndPCDKPIs",f:parsenoop},271:{n:"BrtBeginPCDKPI",f:parsenoop},272:{n:"BrtEndPCDKPI",f:parsenoop},273:{n:"BrtBeginDims",f:parsenoop},274:{n:"BrtEndDims",f:parsenoop},275:{n:"BrtBeginDim",f:parsenoop},276:{n:"BrtEndDim",f:parsenoop},277:{n:"BrtIndexPartEnd",f:parsenoop},278:{n:"BrtBeginStyleSheet",f:parsenoop},279:{n:"BrtEndStyleSheet",f:parsenoop},280:{n:"BrtBeginSXView",f:parsenoop},281:{n:"BrtEndSXVI",f:parsenoop},282:{n:"BrtBeginSXVI",f:parsenoop},283:{n:"BrtBeginSXVIs",f:parsenoop},284:{n:"BrtEndSXVIs",f:parsenoop},285:{n:"BrtBeginSXVD",f:parsenoop},286:{n:"BrtEndSXVD",f:parsenoop},287:{n:"BrtBeginSXVDs",f:parsenoop},288:{n:"BrtEndSXVDs",f:parsenoop},289:{n:"BrtBeginSXPI",f:parsenoop},290:{n:"BrtEndSXPI",f:parsenoop},291:{n:"BrtBeginSXPIs",f:parsenoop},292:{n:"BrtEndSXPIs",f:parsenoop},293:{n:"BrtBeginSXDI",f:parsenoop},294:{n:"BrtEndSXDI",f:parsenoop},295:{n:"BrtBeginSXDIs",f:parsenoop},296:{n:"BrtEndSXDIs",f:parsenoop},297:{n:"BrtBeginSXLI",f:parsenoop},298:{n:"BrtEndSXLI",f:parsenoop},299:{n:"BrtBeginSXLIRws",f:parsenoop},300:{n:"BrtEndSXLIRws",f:parsenoop},301:{n:"BrtBeginSXLICols",f:parsenoop},302:{n:"BrtEndSXLICols",f:parsenoop},303:{n:"BrtBeginSXFormat",f:parsenoop},304:{n:"BrtEndSXFormat",f:parsenoop},305:{n:"BrtBeginSXFormats",f:parsenoop},306:{n:"BrtEndSxFormats",f:parsenoop},307:{n:"BrtBeginSxSelect",f:parsenoop},308:{n:"BrtEndSxSelect",f:parsenoop},309:{n:"BrtBeginISXVDRws",f:parsenoop},310:{n:"BrtEndISXVDRws",f:parsenoop},311:{n:"BrtBeginISXVDCols",f:parsenoop},312:{n:"BrtEndISXVDCols",f:parsenoop},313:{n:"BrtEndSXLocation",f:parsenoop},314:{n:"BrtBeginSXLocation",f:parsenoop},315:{n:"BrtEndSXView",f:parsenoop},316:{n:"BrtBeginSXTHs",f:parsenoop},317:{n:"BrtEndSXTHs",f:parsenoop},318:{n:"BrtBeginSXTH",f:parsenoop},319:{n:"BrtEndSXTH",f:parsenoop},320:{n:"BrtBeginISXTHRws",f:parsenoop},321:{n:"BrtEndISXTHRws",f:parsenoop},322:{n:"BrtBeginISXTHCols",f:parsenoop},323:{n:"BrtEndISXTHCols",f:parsenoop},324:{n:"BrtBeginSXTDMPS",f:parsenoop},325:{n:"BrtEndSXTDMPs",f:parsenoop},326:{n:"BrtBeginSXTDMP",f:parsenoop},327:{n:"BrtEndSXTDMP",f:parsenoop},328:{n:"BrtBeginSXTHItems",f:parsenoop},329:{n:"BrtEndSXTHItems",f:parsenoop},330:{n:"BrtBeginSXTHItem",f:parsenoop},331:{n:"BrtEndSXTHItem",f:parsenoop},332:{n:"BrtBeginMetadata",f:parsenoop},333:{n:"BrtEndMetadata",f:parsenoop},334:{n:"BrtBeginEsmdtinfo",f:parsenoop},335:{n:"BrtMdtinfo",f:parsenoop},336:{n:"BrtEndEsmdtinfo",f:parsenoop},337:{n:"BrtBeginEsmdb",f:parsenoop},338:{n:"BrtEndEsmdb",f:parsenoop},339:{n:"BrtBeginEsfmd",f:parsenoop},340:{n:"BrtEndEsfmd",f:parsenoop},341:{n:"BrtBeginSingleCells",f:parsenoop},342:{n:"BrtEndSingleCells",f:parsenoop},343:{n:"BrtBeginList",f:parsenoop},344:{n:"BrtEndList",f:parsenoop},345:{n:"BrtBeginListCols",f:parsenoop},346:{n:"BrtEndListCols",f:parsenoop},347:{n:"BrtBeginListCol",f:parsenoop},348:{n:"BrtEndListCol",f:parsenoop},349:{n:"BrtBeginListXmlCPr",f:parsenoop},350:{n:"BrtEndListXmlCPr",f:parsenoop},351:{n:"BrtListCCFmla",f:parsenoop},352:{n:"BrtListTrFmla",f:parsenoop},353:{n:"BrtBeginExternals",f:parsenoop},354:{n:"BrtEndExternals",f:parsenoop},355:{n:"BrtSupBookSrc",f:parsenoop},357:{n:"BrtSupSelf",f:parsenoop},358:{n:"BrtSupSame",f:parsenoop},359:{n:"BrtSupTabs",f:parsenoop},360:{n:"BrtBeginSupBook",f:parsenoop},361:{n:"BrtPlaceholderName",f:parsenoop},362:{n:"BrtExternSheet",f:parsenoop},363:{n:"BrtExternTableStart",f:parsenoop},364:{n:"BrtExternTableEnd",f:parsenoop},366:{n:"BrtExternRowHdr",f:parsenoop},367:{n:"BrtExternCellBlank",f:parsenoop},368:{n:"BrtExternCellReal",f:parsenoop},369:{n:"BrtExternCellBool",f:parsenoop},370:{n:"BrtExternCellError",f:parsenoop},371:{n:"BrtExternCellString",f:parsenoop},372:{n:"BrtBeginEsmdx",f:parsenoop},373:{n:"BrtEndEsmdx",f:parsenoop},374:{n:"BrtBeginMdxSet",f:parsenoop},375:{n:"BrtEndMdxSet",f:parsenoop},376:{n:"BrtBeginMdxMbrProp",f:parsenoop},377:{n:"BrtEndMdxMbrProp",f:parsenoop},378:{n:"BrtBeginMdxKPI",f:parsenoop},379:{n:"BrtEndMdxKPI",f:parsenoop},380:{n:"BrtBeginEsstr",f:parsenoop},381:{n:"BrtEndEsstr",f:parsenoop},382:{n:"BrtBeginPRFItem",f:parsenoop},383:{n:"BrtEndPRFItem",f:parsenoop},384:{n:"BrtBeginPivotCacheIDs",f:parsenoop},385:{n:"BrtEndPivotCacheIDs",f:parsenoop},386:{n:"BrtBeginPivotCacheID",f:parsenoop},387:{n:"BrtEndPivotCacheID",f:parsenoop},388:{n:"BrtBeginISXVIs",f:parsenoop},389:{n:"BrtEndISXVIs",f:parsenoop},390:{n:"BrtBeginColInfos",f:parsenoop},391:{n:"BrtEndColInfos",f:parsenoop},392:{n:"BrtBeginRwBrk",f:parsenoop},393:{n:"BrtEndRwBrk",f:parsenoop},394:{n:"BrtBeginColBrk",f:parsenoop},395:{n:"BrtEndColBrk",f:parsenoop},396:{n:"BrtBrk",f:parsenoop},397:{n:"BrtUserBookView",f:parsenoop},398:{n:"BrtInfo",f:parsenoop},399:{n:"BrtCUsr",f:parsenoop},400:{n:"BrtUsr",f:parsenoop},401:{n:"BrtBeginUsers",f:parsenoop},403:{n:"BrtEOF",f:parsenoop},404:{n:"BrtUCR",f:parsenoop},405:{n:"BrtRRInsDel",f:parsenoop},406:{n:"BrtRREndInsDel",f:parsenoop},407:{n:"BrtRRMove",f:parsenoop},408:{n:"BrtRREndMove",f:parsenoop},409:{n:"BrtRRChgCell",f:parsenoop},410:{n:"BrtRREndChgCell",f:parsenoop},411:{n:"BrtRRHeader",f:parsenoop},412:{n:"BrtRRUserView",f:parsenoop},413:{n:"BrtRRRenSheet",f:parsenoop},414:{n:"BrtRRInsertSh",f:parsenoop},415:{n:"BrtRRDefName",f:parsenoop},416:{n:"BrtRRNote",f:parsenoop},417:{n:"BrtRRConflict",f:parsenoop},418:{n:"BrtRRTQSIF",f:parsenoop},419:{n:"BrtRRFormat",f:parsenoop},420:{n:"BrtRREndFormat",f:parsenoop},421:{n:"BrtRRAutoFmt",f:parsenoop},422:{n:"BrtBeginUserShViews",f:parsenoop},423:{n:"BrtBeginUserShView",f:parsenoop},424:{n:"BrtEndUserShView",f:parsenoop},425:{n:"BrtEndUserShViews",f:parsenoop},426:{n:"BrtArrFmla",f:parsenoop},427:{n:"BrtShrFmla",f:parsenoop},428:{n:"BrtTable",f:parsenoop},429:{n:"BrtBeginExtConnections",f:parsenoop},430:{n:"BrtEndExtConnections",f:parsenoop},431:{n:"BrtBeginPCDCalcMems",f:parsenoop},432:{n:"BrtEndPCDCalcMems",f:parsenoop},433:{n:"BrtBeginPCDCalcMem",f:parsenoop},434:{n:"BrtEndPCDCalcMem",f:parsenoop},435:{n:"BrtBeginPCDHGLevels",f:parsenoop},436:{n:"BrtEndPCDHGLevels",f:parsenoop},437:{n:"BrtBeginPCDHGLevel",f:parsenoop},438:{n:"BrtEndPCDHGLevel",f:parsenoop},439:{n:"BrtBeginPCDHGLGroups",f:parsenoop},440:{n:"BrtEndPCDHGLGroups",f:parsenoop},441:{n:"BrtBeginPCDHGLGroup",f:parsenoop},442:{n:"BrtEndPCDHGLGroup",f:parsenoop},443:{n:"BrtBeginPCDHGLGMembers",f:parsenoop},444:{n:"BrtEndPCDHGLGMembers",f:parsenoop},445:{n:"BrtBeginPCDHGLGMember",f:parsenoop},446:{n:"BrtEndPCDHGLGMember",f:parsenoop},447:{n:"BrtBeginQSI",f:parsenoop},448:{n:"BrtEndQSI",f:parsenoop},449:{n:"BrtBeginQSIR",f:parsenoop},450:{n:"BrtEndQSIR",f:parsenoop},451:{n:"BrtBeginDeletedNames",f:parsenoop},452:{n:"BrtEndDeletedNames",f:parsenoop},453:{n:"BrtBeginDeletedName",f:parsenoop},454:{n:"BrtEndDeletedName",f:parsenoop},455:{n:"BrtBeginQSIFs",f:parsenoop},456:{n:"BrtEndQSIFs",f:parsenoop},457:{n:"BrtBeginQSIF",f:parsenoop},458:{n:"BrtEndQSIF",f:parsenoop},459:{n:"BrtBeginAutoSortScope",f:parsenoop},460:{n:"BrtEndAutoSortScope",f:parsenoop},461:{n:"BrtBeginConditionalFormatting",f:parsenoop},462:{n:"BrtEndConditionalFormatting",f:parsenoop},463:{n:"BrtBeginCFRule",f:parsenoop},464:{n:"BrtEndCFRule",f:parsenoop},465:{n:"BrtBeginIconSet",f:parsenoop},466:{n:"BrtEndIconSet",f:parsenoop},467:{n:"BrtBeginDatabar",f:parsenoop},468:{n:"BrtEndDatabar",f:parsenoop},469:{n:"BrtBeginColorScale",f:parsenoop},470:{n:"BrtEndColorScale",f:parsenoop},471:{n:"BrtCFVO",f:parsenoop},472:{n:"BrtExternValueMeta",f:parsenoop},473:{n:"BrtBeginColorPalette",f:parsenoop},474:{n:"BrtEndColorPalette",f:parsenoop},475:{n:"BrtIndexedColor",f:parsenoop},476:{n:"BrtMargins",f:parsenoop},477:{n:"BrtPrintOptions",f:parsenoop},478:{n:"BrtPageSetup",f:parsenoop},479:{n:"BrtBeginHeaderFooter",f:parsenoop},480:{n:"BrtEndHeaderFooter",f:parsenoop},481:{n:"BrtBeginSXCrtFormat",f:parsenoop},482:{n:"BrtEndSXCrtFormat",f:parsenoop},483:{n:"BrtBeginSXCrtFormats",f:parsenoop},484:{n:"BrtEndSXCrtFormats",f:parsenoop},485:{n:"BrtWsFmtInfo",f:parsenoop},486:{n:"BrtBeginMgs",f:parsenoop},487:{n:"BrtEndMGs",f:parsenoop},488:{n:"BrtBeginMGMaps",f:parsenoop},489:{n:"BrtEndMGMaps",f:parsenoop},490:{n:"BrtBeginMG",f:parsenoop},491:{n:"BrtEndMG",f:parsenoop},492:{n:"BrtBeginMap",f:parsenoop},493:{n:"BrtEndMap",f:parsenoop},494:{n:"BrtHLink",f:parse_BrtHLink},495:{n:"BrtBeginDCon",f:parsenoop},496:{n:"BrtEndDCon",f:parsenoop},497:{n:"BrtBeginDRefs",f:parsenoop},498:{n:"BrtEndDRefs",f:parsenoop},499:{n:"BrtDRef",f:parsenoop},500:{n:"BrtBeginScenMan",f:parsenoop},501:{n:"BrtEndScenMan",f:parsenoop},502:{n:"BrtBeginSct",f:parsenoop},503:{n:"BrtEndSct",f:parsenoop},504:{n:"BrtSlc",f:parsenoop},505:{n:"BrtBeginDXFs",f:parsenoop},506:{n:"BrtEndDXFs",f:parsenoop},507:{n:"BrtDXF",f:parsenoop},508:{n:"BrtBeginTableStyles",f:parsenoop},509:{n:"BrtEndTableStyles",f:parsenoop},510:{n:"BrtBeginTableStyle",f:parsenoop},511:{n:"BrtEndTableStyle",f:parsenoop},512:{n:"BrtTableStyleElement",f:parsenoop},513:{n:"BrtTableStyleClient",f:parsenoop},514:{n:"BrtBeginVolDeps",f:parsenoop},515:{n:"BrtEndVolDeps",f:parsenoop},516:{n:"BrtBeginVolType",f:parsenoop},517:{n:"BrtEndVolType",f:parsenoop},518:{n:"BrtBeginVolMain",f:parsenoop},519:{n:"BrtEndVolMain",f:parsenoop},520:{n:"BrtBeginVolTopic",f:parsenoop},521:{n:"BrtEndVolTopic",f:parsenoop},522:{n:"BrtVolSubtopic",f:parsenoop},523:{n:"BrtVolRef",f:parsenoop},524:{n:"BrtVolNum",f:parsenoop},525:{n:"BrtVolErr",f:parsenoop},526:{n:"BrtVolStr",f:parsenoop},527:{n:"BrtVolBool",f:parsenoop},528:{n:"BrtBeginCalcChain$",f:parsenoop},529:{n:"BrtEndCalcChain$",f:parsenoop},530:{n:"BrtBeginSortState",f:parsenoop},531:{n:"BrtEndSortState",f:parsenoop},532:{n:"BrtBeginSortCond",f:parsenoop},533:{n:"BrtEndSortCond",f:parsenoop},534:{n:"BrtBookProtection",f:parsenoop},535:{n:"BrtSheetProtection",f:parsenoop},536:{n:"BrtRangeProtection",f:parsenoop},537:{n:"BrtPhoneticInfo",f:parsenoop},538:{n:"BrtBeginECTxtWiz",f:parsenoop},539:{n:"BrtEndECTxtWiz",f:parsenoop},540:{n:"BrtBeginECTWFldInfoLst",f:parsenoop},541:{n:"BrtEndECTWFldInfoLst",f:parsenoop},542:{n:"BrtBeginECTwFldInfo",f:parsenoop},548:{n:"BrtFileSharing",f:parsenoop},549:{n:"BrtOleSize",f:parsenoop},550:{n:"BrtDrawing",f:parsenoop},551:{n:"BrtLegacyDrawing",f:parsenoop},552:{n:"BrtLegacyDrawingHF",f:parsenoop},553:{n:"BrtWebOpt",f:parsenoop},554:{n:"BrtBeginWebPubItems",f:parsenoop},555:{n:"BrtEndWebPubItems",f:parsenoop},556:{n:"BrtBeginWebPubItem",f:parsenoop},557:{n:"BrtEndWebPubItem",f:parsenoop},558:{n:"BrtBeginSXCondFmt",f:parsenoop},559:{n:"BrtEndSXCondFmt",f:parsenoop},560:{n:"BrtBeginSXCondFmts",f:parsenoop},561:{n:"BrtEndSXCondFmts",f:parsenoop},562:{n:"BrtBkHim",f:parsenoop},564:{n:"BrtColor",f:parsenoop},565:{n:"BrtBeginIndexedColors",f:parsenoop},566:{n:"BrtEndIndexedColors",f:parsenoop},569:{n:"BrtBeginMRUColors",f:parsenoop},570:{n:"BrtEndMRUColors",f:parsenoop},572:{n:"BrtMRUColor",f:parsenoop},573:{n:"BrtBeginDVals",f:parsenoop},574:{n:"BrtEndDVals",f:parsenoop},577:{n:"BrtSupNameStart",f:parsenoop},578:{n:"BrtSupNameValueStart",f:parsenoop},579:{n:"BrtSupNameValueEnd",f:parsenoop},580:{n:"BrtSupNameNum",f:parsenoop},581:{n:"BrtSupNameErr",f:parsenoop},582:{n:"BrtSupNameSt",f:parsenoop},583:{n:"BrtSupNameNil",f:parsenoop},584:{n:"BrtSupNameBool",f:parsenoop},585:{n:"BrtSupNameFmla",f:parsenoop},586:{n:"BrtSupNameBits",f:parsenoop},587:{n:"BrtSupNameEnd",f:parsenoop},588:{n:"BrtEndSupBook",f:parsenoop},589:{n:"BrtCellSmartTagProperty",f:parsenoop},590:{n:"BrtBeginCellSmartTag",f:parsenoop},591:{n:"BrtEndCellSmartTag",f:parsenoop},592:{n:"BrtBeginCellSmartTags",f:parsenoop},593:{n:"BrtEndCellSmartTags",f:parsenoop},594:{n:"BrtBeginSmartTags",f:parsenoop},595:{n:"BrtEndSmartTags",f:parsenoop},596:{n:"BrtSmartTagType",f:parsenoop},597:{n:"BrtBeginSmartTagTypes",f:parsenoop},598:{n:"BrtEndSmartTagTypes",f:parsenoop},599:{n:"BrtBeginSXFilters",f:parsenoop},600:{n:"BrtEndSXFilters",f:parsenoop},601:{n:"BrtBeginSXFILTER",f:parsenoop},602:{n:"BrtEndSXFilter",f:parsenoop},603:{n:"BrtBeginFills",f:parsenoop},604:{n:"BrtEndFills",f:parsenoop},605:{n:"BrtBeginCellWatches",f:parsenoop},606:{n:"BrtEndCellWatches",f:parsenoop},607:{n:"BrtCellWatch",f:parsenoop},608:{n:"BrtBeginCRErrs",f:parsenoop},609:{n:"BrtEndCRErrs",f:parsenoop},610:{n:"BrtCrashRecErr",f:parsenoop},611:{n:"BrtBeginFonts",f:parsenoop},612:{n:"BrtEndFonts",f:parsenoop},613:{n:"BrtBeginBorders",f:parsenoop},614:{n:"BrtEndBorders",f:parsenoop},615:{n:"BrtBeginFmts",f:parsenoop},616:{n:"BrtEndFmts",f:parsenoop},617:{n:"BrtBeginCellXFs",f:parsenoop},618:{n:"BrtEndCellXFs",f:parsenoop},619:{n:"BrtBeginStyles",f:parsenoop},620:{n:"BrtEndStyles",f:parsenoop},625:{n:"BrtBigName",f:parsenoop},626:{n:"BrtBeginCellStyleXFs",f:parsenoop},627:{n:"BrtEndCellStyleXFs",f:parsenoop},628:{n:"BrtBeginComments",f:parsenoop},629:{n:"BrtEndComments",f:parsenoop},630:{n:"BrtBeginCommentAuthors",f:parsenoop},631:{n:"BrtEndCommentAuthors",f:parsenoop},632:{n:"BrtCommentAuthor",f:parse_BrtCommentAuthor},633:{n:"BrtBeginCommentList",f:parsenoop},634:{n:"BrtEndCommentList",f:parsenoop},635:{n:"BrtBeginComment",f:parse_BrtBeginComment},636:{n:"BrtEndComment",f:parsenoop},637:{n:"BrtCommentText",f:parse_BrtCommentText},638:{n:"BrtBeginOleObjects",f:parsenoop},639:{n:"BrtOleObject",f:parsenoop},640:{n:"BrtEndOleObjects",f:parsenoop},641:{n:"BrtBeginSxrules",f:parsenoop},642:{n:"BrtEndSxRules",f:parsenoop},643:{n:"BrtBeginActiveXControls",f:parsenoop},644:{n:"BrtActiveX",f:parsenoop},645:{n:"BrtEndActiveXControls",f:parsenoop},646:{n:"BrtBeginPCDSDTCEMembersSortBy",f:parsenoop},648:{n:"BrtBeginCellIgnoreECs",f:parsenoop},649:{n:"BrtCellIgnoreEC",f:parsenoop},650:{n:"BrtEndCellIgnoreECs",f:parsenoop},651:{n:"BrtCsProp",f:parsenoop},652:{n:"BrtCsPageSetup",f:parsenoop},653:{n:"BrtBeginUserCsViews",f:parsenoop},654:{n:"BrtEndUserCsViews",f:parsenoop},655:{n:"BrtBeginUserCsView",f:parsenoop},656:{n:"BrtEndUserCsView",f:parsenoop},657:{n:"BrtBeginPcdSFCIEntries",f:parsenoop},658:{n:"BrtEndPCDSFCIEntries",f:parsenoop},659:{n:"BrtPCDSFCIEntry",f:parsenoop},660:{n:"BrtBeginListParts",f:parsenoop},661:{n:"BrtListPart",f:parsenoop},662:{n:"BrtEndListParts",f:parsenoop},663:{n:"BrtSheetCalcProp",f:parsenoop},664:{n:"BrtBeginFnGroup",f:parsenoop},665:{n:"BrtFnGroup",f:parsenoop},666:{n:"BrtEndFnGroup",f:parsenoop},667:{n:"BrtSupAddin",f:parsenoop},668:{n:"BrtSXTDMPOrder",f:parsenoop},669:{n:"BrtCsProtection",f:parsenoop},671:{n:"BrtBeginWsSortMap",f:parsenoop},672:{n:"BrtEndWsSortMap",f:parsenoop},673:{n:"BrtBeginRRSort",f:parsenoop},674:{n:"BrtEndRRSort",f:parsenoop},675:{n:"BrtRRSortItem",f:parsenoop},676:{n:"BrtFileSharingIso",f:parsenoop},677:{n:"BrtBookProtectionIso",f:parsenoop},678:{n:"BrtSheetProtectionIso",f:parsenoop},679:{n:"BrtCsProtectionIso",f:parsenoop},680:{n:"BrtRangeProtectionIso",f:parsenoop},1024:{n:"BrtRwDescent",f:parsenoop},1025:{n:"BrtKnownFonts",f:parsenoop},1026:{n:"BrtBeginSXTupleSet",f:parsenoop},1027:{n:"BrtEndSXTupleSet",f:parsenoop},1028:{n:"BrtBeginSXTupleSetHeader",f:parsenoop},1029:{n:"BrtEndSXTupleSetHeader",f:parsenoop},1030:{n:"BrtSXTupleSetHeaderItem",f:parsenoop},1031:{n:"BrtBeginSXTupleSetData",f:parsenoop},1032:{n:"BrtEndSXTupleSetData",f:parsenoop},1033:{n:"BrtBeginSXTupleSetRow",f:parsenoop},1034:{n:"BrtEndSXTupleSetRow",f:parsenoop},1035:{n:"BrtSXTupleSetRowItem",f:parsenoop},1036:{n:"BrtNameExt",f:parsenoop},1037:{n:"BrtPCDH14",f:parsenoop},1038:{n:"BrtBeginPCDCalcMem14",f:parsenoop},1039:{n:"BrtEndPCDCalcMem14",f:parsenoop},1040:{n:"BrtSXTH14",f:parsenoop},1041:{n:"BrtBeginSparklineGroup",f:parsenoop},1042:{n:"BrtEndSparklineGroup",f:parsenoop},1043:{n:"BrtSparkline",f:parsenoop},1044:{n:"BrtSXDI14",f:parsenoop},1045:{n:"BrtWsFmtInfoEx14",f:parsenoop},1046:{n:"BrtBeginConditionalFormatting14",f:parsenoop},1047:{n:"BrtEndConditionalFormatting14",f:parsenoop},1048:{n:"BrtBeginCFRule14",f:parsenoop},1049:{n:"BrtEndCFRule14",f:parsenoop},1050:{n:"BrtCFVO14",f:parsenoop},1051:{n:"BrtBeginDatabar14",f:parsenoop},1052:{n:"BrtBeginIconSet14",f:parsenoop},1053:{n:"BrtDVal14",f:parsenoop},1054:{n:"BrtBeginDVals14",f:parsenoop},1055:{n:"BrtColor14",f:parsenoop},1056:{n:"BrtBeginSparklines",f:parsenoop},1057:{n:"BrtEndSparklines",f:parsenoop},1058:{n:"BrtBeginSparklineGroups",f:parsenoop},1059:{n:"BrtEndSparklineGroups",f:parsenoop},1061:{n:"BrtSXVD14",f:parsenoop},1062:{n:"BrtBeginSxview14",f:parsenoop},1063:{n:"BrtEndSxview14",f:parsenoop},1066:{n:"BrtBeginPCD14",f:parsenoop},1067:{n:"BrtEndPCD14",f:parsenoop},1068:{n:"BrtBeginExtConn14",f:parsenoop},1069:{n:"BrtEndExtConn14",f:parsenoop},1070:{n:"BrtBeginSlicerCacheIDs",f:parsenoop},1071:{n:"BrtEndSlicerCacheIDs",f:parsenoop},1072:{n:"BrtBeginSlicerCacheID",f:parsenoop},1073:{n:"BrtEndSlicerCacheID",f:parsenoop},1075:{n:"BrtBeginSlicerCache",f:parsenoop},1076:{n:"BrtEndSlicerCache",f:parsenoop},1077:{n:"BrtBeginSlicerCacheDef",f:parsenoop},1078:{n:"BrtEndSlicerCacheDef",f:parsenoop},1079:{n:"BrtBeginSlicersEx",f:parsenoop},1080:{n:"BrtEndSlicersEx",f:parsenoop},1081:{n:"BrtBeginSlicerEx",f:parsenoop},1082:{n:"BrtEndSlicerEx",f:parsenoop},1083:{n:"BrtBeginSlicer",f:parsenoop},1084:{n:"BrtEndSlicer",f:parsenoop},1085:{n:"BrtSlicerCachePivotTables",f:parsenoop},1086:{n:"BrtBeginSlicerCacheOlapImpl",f:parsenoop},1087:{n:"BrtEndSlicerCacheOlapImpl",f:parsenoop},1088:{n:"BrtBeginSlicerCacheLevelsData",f:parsenoop},1089:{n:"BrtEndSlicerCacheLevelsData",f:parsenoop},1090:{n:"BrtBeginSlicerCacheLevelData",f:parsenoop},1091:{n:"BrtEndSlicerCacheLevelData",f:parsenoop},1092:{n:"BrtBeginSlicerCacheSiRanges",f:parsenoop},1093:{n:"BrtEndSlicerCacheSiRanges",f:parsenoop},1094:{n:"BrtBeginSlicerCacheSiRange",f:parsenoop},1095:{n:"BrtEndSlicerCacheSiRange",f:parsenoop},1096:{n:"BrtSlicerCacheOlapItem",f:parsenoop},1097:{n:"BrtBeginSlicerCacheSelections",f:parsenoop},1098:{n:"BrtSlicerCacheSelection",f:parsenoop},1099:{n:"BrtEndSlicerCacheSelections",f:parsenoop},1100:{n:"BrtBeginSlicerCacheNative",f:parsenoop},1101:{n:"BrtEndSlicerCacheNative",f:parsenoop},1102:{n:"BrtSlicerCacheNativeItem",f:parsenoop},1103:{n:"BrtRangeProtection14",f:parsenoop},1104:{n:"BrtRangeProtectionIso14",f:parsenoop},1105:{n:"BrtCellIgnoreEC14",f:parsenoop},1111:{n:"BrtList14",f:parsenoop},1112:{n:"BrtCFIcon",f:parsenoop},1113:{n:"BrtBeginSlicerCachesPivotCacheIDs",f:parsenoop},1114:{n:"BrtEndSlicerCachesPivotCacheIDs",f:parsenoop},1115:{n:"BrtBeginSlicers",f:parsenoop},1116:{n:"BrtEndSlicers",f:parsenoop},1117:{n:"BrtWbProp14",f:parsenoop},1118:{n:"BrtBeginSXEdit",f:parsenoop},1119:{n:"BrtEndSXEdit",f:parsenoop},1120:{n:"BrtBeginSXEdits",f:parsenoop},1121:{n:"BrtEndSXEdits",f:parsenoop},1122:{n:"BrtBeginSXChange",f:parsenoop},1123:{n:"BrtEndSXChange",f:parsenoop},1124:{n:"BrtBeginSXChanges",f:parsenoop},1125:{n:"BrtEndSXChanges",f:parsenoop},1126:{n:"BrtSXTupleItems",f:parsenoop},1128:{n:"BrtBeginSlicerStyle",f:parsenoop},1129:{n:"BrtEndSlicerStyle",f:parsenoop},1130:{n:"BrtSlicerStyleElement",f:parsenoop},1131:{n:"BrtBeginStyleSheetExt14",f:parsenoop},1132:{n:"BrtEndStyleSheetExt14",f:parsenoop},1133:{n:"BrtBeginSlicerCachesPivotCacheID",f:parsenoop},1134:{n:"BrtEndSlicerCachesPivotCacheID",f:parsenoop},1135:{n:"BrtBeginConditionalFormattings",f:parsenoop},1136:{n:"BrtEndConditionalFormattings",f:parsenoop},1137:{n:"BrtBeginPCDCalcMemExt",f:parsenoop},1138:{n:"BrtEndPCDCalcMemExt",f:parsenoop},1139:{n:"BrtBeginPCDCalcMemsExt",f:parsenoop},1140:{n:"BrtEndPCDCalcMemsExt",f:parsenoop},1141:{n:"BrtPCDField14",f:parsenoop},1142:{n:"BrtBeginSlicerStyles",f:parsenoop},1143:{n:"BrtEndSlicerStyles",f:parsenoop},1144:{n:"BrtBeginSlicerStyleElements",f:parsenoop},1145:{n:"BrtEndSlicerStyleElements",f:parsenoop},1146:{n:"BrtCFRuleExt",f:parsenoop},1147:{n:"BrtBeginSXCondFmt14",f:parsenoop},1148:{n:"BrtEndSXCondFmt14",f:parsenoop},1149:{n:"BrtBeginSXCondFmts14",f:parsenoop},1150:{n:"BrtEndSXCondFmts14",f:parsenoop},1152:{n:"BrtBeginSortCond14",f:parsenoop},1153:{n:"BrtEndSortCond14",f:parsenoop},1154:{n:"BrtEndDVals14",f:parsenoop},1155:{n:"BrtEndIconSet14",f:parsenoop},1156:{n:"BrtEndDatabar14",f:parsenoop},1157:{n:"BrtBeginColorScale14",f:parsenoop},1158:{n:"BrtEndColorScale14",f:parsenoop},1159:{n:"BrtBeginSxrules14",f:parsenoop},1160:{n:"BrtEndSxrules14",f:parsenoop},1161:{n:"BrtBeginPRule14",f:parsenoop},1162:{n:"BrtEndPRule14",f:parsenoop},1163:{n:"BrtBeginPRFilters14",f:parsenoop},1164:{n:"BrtEndPRFilters14",f:parsenoop},1165:{n:"BrtBeginPRFilter14",f:parsenoop},1166:{n:"BrtEndPRFilter14",f:parsenoop},1167:{n:"BrtBeginPRFItem14",f:parsenoop},1168:{n:"BrtEndPRFItem14",f:parsenoop},1169:{n:"BrtBeginCellIgnoreECs14",f:parsenoop},1170:{n:"BrtEndCellIgnoreECs14",f:parsenoop},1171:{n:"BrtDxf14",f:parsenoop},1172:{n:"BrtBeginDxF14s",f:parsenoop},1173:{n:"BrtEndDxf14s",f:parsenoop},1177:{n:"BrtFilter14",f:parsenoop},1178:{n:"BrtBeginCustomFilters14",f:parsenoop},1180:{n:"BrtCustomFilter14",f:parsenoop},1181:{n:"BrtIconFilter14",f:parsenoop},1182:{n:"BrtPivotCacheConnectionName",f:parsenoop},2048:{n:"BrtBeginDecoupledPivotCacheIDs",f:parsenoop},2049:{n:"BrtEndDecoupledPivotCacheIDs",f:parsenoop},2050:{n:"BrtDecoupledPivotCacheID",f:parsenoop},2051:{n:"BrtBeginPivotTableRefs",f:parsenoop},2052:{n:"BrtEndPivotTableRefs",f:parsenoop},2053:{n:"BrtPivotTableRef",f:parsenoop},2054:{n:"BrtSlicerCacheBookPivotTables",f:parsenoop},2055:{n:"BrtBeginSxvcells",f:parsenoop},2056:{n:"BrtEndSxvcells",f:parsenoop},2057:{n:"BrtBeginSxRow",f:parsenoop},2058:{n:"BrtEndSxRow",f:parsenoop},2060:{n:"BrtPcdCalcMem15",f:parsenoop},2067:{n:"BrtQsi15",f:parsenoop},2068:{n:"BrtBeginWebExtensions",f:parsenoop},2069:{n:"BrtEndWebExtensions",f:parsenoop},2070:{n:"BrtWebExtension",f:parsenoop},2071:{n:"BrtAbsPath15",f:parsenoop},2072:{n:"BrtBeginPivotTableUISettings",f:parsenoop},2073:{n:"BrtEndPivotTableUISettings",f:parsenoop},2075:{n:"BrtTableSlicerCacheIDs",f:parsenoop},2076:{n:"BrtTableSlicerCacheID",f:parsenoop},2077:{n:"BrtBeginTableSlicerCache",f:parsenoop},2078:{n:"BrtEndTableSlicerCache",f:parsenoop},2079:{n:"BrtSxFilter15",f:parsenoop},2080:{n:"BrtBeginTimelineCachePivotCacheIDs",f:parsenoop},2081:{n:"BrtEndTimelineCachePivotCacheIDs",f:parsenoop},2082:{n:"BrtTimelineCachePivotCacheID",f:parsenoop},2083:{n:"BrtBeginTimelineCacheIDs",f:parsenoop},2084:{n:"BrtEndTimelineCacheIDs",f:parsenoop},2085:{n:"BrtBeginTimelineCacheID",f:parsenoop},2086:{n:"BrtEndTimelineCacheID",f:parsenoop},2087:{n:"BrtBeginTimelinesEx",f:parsenoop},2088:{n:"BrtEndTimelinesEx",f:parsenoop},2089:{n:"BrtBeginTimelineEx",f:parsenoop},2090:{n:"BrtEndTimelineEx",f:parsenoop},2091:{n:"BrtWorkBookPr15",f:parsenoop},2092:{n:"BrtPCDH15",f:parsenoop},2093:{n:"BrtBeginTimelineStyle",f:parsenoop},2094:{n:"BrtEndTimelineStyle",f:parsenoop},2095:{n:"BrtTimelineStyleElement",f:parsenoop},2096:{n:"BrtBeginTimelineStylesheetExt15",f:parsenoop},2097:{n:"BrtEndTimelineStylesheetExt15",f:parsenoop},2098:{n:"BrtBeginTimelineStyles",f:parsenoop},2099:{n:"BrtEndTimelineStyles",f:parsenoop},2100:{n:"BrtBeginTimelineStyleElements",f:parsenoop},2101:{n:"BrtEndTimelineStyleElements",f:parsenoop},2102:{n:"BrtDxf15",f:parsenoop},2103:{n:"BrtBeginDxfs15",f:parsenoop},2104:{n:"brtEndDxfs15",f:parsenoop},2105:{n:"BrtSlicerCacheHideItemsWithNoData",f:parsenoop},2106:{n:"BrtBeginItemUniqueNames",f:parsenoop},2107:{n:"BrtEndItemUniqueNames",f:parsenoop},2108:{n:"BrtItemUniqueName",f:parsenoop},2109:{n:"BrtBeginExtConn15",f:parsenoop},2110:{n:"BrtEndExtConn15",f:parsenoop},2111:{n:"BrtBeginOledbPr15",f:parsenoop},2112:{n:"BrtEndOledbPr15",f:parsenoop},2113:{n:"BrtBeginDataFeedPr15",f:parsenoop},2114:{n:"BrtEndDataFeedPr15",f:parsenoop},2115:{n:"BrtTextPr15",f:parsenoop},2116:{n:"BrtRangePr15",f:parsenoop},2117:{n:"BrtDbCommand15",f:parsenoop},2118:{n:"BrtBeginDbTables15",f:parsenoop},2119:{n:"BrtEndDbTables15",f:parsenoop},2120:{n:"BrtDbTable15",f:parsenoop},2121:{n:"BrtBeginDataModel",f:parsenoop},2122:{n:"BrtEndDataModel",f:parsenoop},2123:{n:"BrtBeginModelTables",f:parsenoop},2124:{n:"BrtEndModelTables",f:parsenoop},2125:{n:"BrtModelTable",f:parsenoop},2126:{n:"BrtBeginModelRelationships",f:parsenoop},2127:{n:"BrtEndModelRelationships",f:parsenoop},2128:{n:"BrtModelRelationship",f:parsenoop},2129:{n:"BrtBeginECTxtWiz15",f:parsenoop},2130:{n:"BrtEndECTxtWiz15",f:parsenoop},2131:{n:"BrtBeginECTWFldInfoLst15",f:parsenoop},2132:{n:"BrtEndECTWFldInfoLst15",f:parsenoop},2133:{n:"BrtBeginECTWFldInfo15",f:parsenoop},2134:{n:"BrtFieldListActiveItem",f:parsenoop},2135:{n:"BrtPivotCacheIdVersion",f:parsenoop},2136:{n:"BrtSXDI15",f:parsenoop},65535:{n:"",f:parsenoop}};
function fix_opts(defaults){return function(opts){defaults.forEach(function(d){if(typeof opts[d[0]]==="undefined")opts[d[0]]=d[1];if(d[2]==="n")opts[d[0]]=Number(opts[d[0]])})}}var fix_read_opts=fix_opts([["cellNF",false],["cellHTML",true],["cellFormula",true],["sheetStubs",false],["sheetRows",0,"n"],["bookDeps",false],["bookSheets",false],["bookProps",false],["bookFiles",false],["bookVBA",false],["WTF",false]]);var fix_write_opts=fix_opts([["bookSST",false],["bookType","xlsx"],["WTF",false]]);function parse_zip(zip,opts){make_ssf(SSF);opts=opts||{};fix_read_opts(opts);reset_cp();var entries=keys(zip.files).filter(function(x){return x.substr(-1)!="/"}).sort();var dir=parse_ct(getzipdata(zip,"[Content_Types].xml"),opts);var xlsb=false;var sheets,binname;if(dir.workbooks.length===0){binname="xl/workbook.xml";if(getzipdata(zip,binname,true))dir.workbooks.push(binname)}if(dir.workbooks.length===0){binname="xl/workbook.bin";if(!getzipfile(zip,binname,true))throw new Error("Could not find workbook");dir.workbooks.push(binname);xlsb=true}if(xlsb)set_cp(1200);if(!opts.bookSheets&&!opts.bookProps){strs=[];if(dir.sst)strs=parse_sst(getzipdata(zip,dir.sst.replace(/^\//,"")),dir.sst,opts);styles={};if(dir.style)styles=parse_sty(getzipdata(zip,dir.style.replace(/^\//,"")),dir.style,opts)}var wb=parse_wb(getzipdata(zip,dir.workbooks[0].replace(/^\//,"")),dir.workbooks[0],opts);var props={},propdata="";if(dir.coreprops.length!==0){propdata=getzipdata(zip,dir.coreprops[0].replace(/^\//,""),true);if(propdata)props=parse_core_props(propdata);if(dir.extprops.length!==0){propdata=getzipdata(zip,dir.extprops[0].replace(/^\//,""),true);if(propdata)parse_ext_props(propdata,props)}}var custprops={};if(!opts.bookSheets||opts.bookProps){if(dir.custprops.length!==0){propdata=getzipdata(zip,dir.custprops[0].replace(/^\//,""),true);if(propdata)custprops=parse_cust_props(propdata,opts)}}var out={};if(opts.bookSheets||opts.bookProps){if(props.Worksheets&&props.SheetNames.length>0)sheets=props.SheetNames;else if(wb.Sheets)sheets=wb.Sheets.map(function(x){return x.name});if(opts.bookProps){out.Props=props;out.Custprops=custprops}if(typeof sheets!=="undefined")out.SheetNames=sheets;if(opts.bookSheets?out.SheetNames:opts.bookProps)return out}sheets={};var deps={};if(opts.bookDeps&&dir.calcchain)deps=parse_cc(getzipdata(zip,dir.calcchain.replace(/^\//,"")),dir.calcchain,opts);var i=0;var sheetRels={};var path,relsPath;if(!props.Worksheets){var wbsheets=wb.Sheets;props.Worksheets=wbsheets.length;props.SheetNames=[];for(var j=0;j!=wbsheets.length;++j){props.SheetNames[j]=wbsheets[j].name}}var wbrelsfile="xl/_rels/workbook.xml.rels";var wbrels=parse_rels(getzipdata(zip,wbrelsfile,true),wbrelsfile);if(wbrels)try{wbrels=wb.Sheets.map(function(w){return[w.name,wbrels["!id"][w.id].Target]})}catch(e){wbrels=null}var nmode=getzipdata(zip,"xl/worksheets/sheet.xml",true)?1:0;for(i=0;i!=props.Worksheets;++i){try{if(wbrels)path="xl/"+wbrels[i][1].replace(/[\/]?xl\//,"");else{path="xl/worksheets/sheet"+(i+1-nmode)+(xlsb?".bin":".xml");path=path.replace(/sheet0\./,"sheet.")}relsPath=path.replace(/^(.*)(\/)([^\/]*)$/,"$1/_rels/$3.rels");sheetRels[props.SheetNames[i]]=parse_rels(getzipdata(zip,relsPath,true),path);sheets[props.SheetNames[i]]=parse_ws(getzipdata(zip,path),path,opts,sheetRels[props.SheetNames[i]])}catch(e){if(opts.WTF)throw e}}if(dir.comments)parse_comments(zip,dir.comments,sheets,sheetRels,opts);out={Directory:dir,Workbook:wb,Props:props,Custprops:custprops,Deps:deps,Sheets:sheets,SheetNames:props.SheetNames,Strings:strs,Styles:styles,SSF:SSF.get_table()};if(opts.bookFiles){out.keys=entries;out.files=zip.files}if(opts.bookVBA){if(dir.vba.length>0)out.vbaraw=getzipdata(zip,dir.vba[0],true);else if(dir.defaults.bin==="application/vnd.ms-office.vbaProject")out.vbaraw=getzipdata(zip,"xl/vbaProject.bin",true)}return out}function add_rels(rels,rId,f,type,relobj){if(!relobj)relobj={};if(!rels["!id"])rels["!id"]={};relobj.Id="rId"+rId;relobj.Type=type;relobj.Target=f;if(rels["!id"][relobj.Id])throw new Error("Cannot rewrite rId "+rId);rels["!id"][relobj.Id]=relobj;rels[("/"+relobj.Target).replace("//","/")]=relobj}function write_zip(wb,opts){if(wb&&!wb.SSF){wb.SSF=SSF.get_table()}if(wb&&wb.SSF){make_ssf(SSF);SSF.load_table(wb.SSF);opts.revssf=evert(wb.SSF);opts.revssf[wb.SSF[65535]]=0}opts.rels={};opts.wbrels={};opts.Strings=[];opts.Strings.Count=0;opts.Strings.Unique=0;var wbext=opts.bookType=="xlsb"?"bin":"xml";var ct={workbooks:[],sheets:[],calcchains:[],themes:[],styles:[],coreprops:[],extprops:[],custprops:[],strs:[],comments:[],vba:[],TODO:[],rels:[],xmlns:""};fix_write_opts(opts=opts||{});var zip=new jszip;var f="",rId=0;opts.cellXfs=[];get_cell_style(opts.cellXfs,{},{revssf:{General:0}});f="docProps/core.xml";zip.file(f,write_core_props(wb.Props,opts));ct.coreprops.push(f);add_rels(opts.rels,2,f,RELS.CORE_PROPS);f="docProps/app.xml";if(!wb.Props)wb.Props={};wb.Props.SheetNames=wb.SheetNames;wb.Props.Worksheets=wb.SheetNames.length;zip.file(f,write_ext_props(wb.Props,opts));ct.extprops.push(f);add_rels(opts.rels,3,f,RELS.EXT_PROPS);if(wb.Custprops!==wb.Props){f="docProps/custom.xml";zip.file(f,write_cust_props(wb.Custprops,opts));ct.custprops.push(f);add_rels(opts.rels,4,f,RELS.CUST_PROPS)}f="xl/workbook."+wbext;zip.file(f,write_wb(wb,f,opts));ct.workbooks.push(f);add_rels(opts.rels,1,f,RELS.WB);wb.SheetNames.forEach(function(s,i){rId=i+1;f="xl/worksheets/sheet"+rId+"."+wbext;zip.file(f,write_ws(i,f,opts,wb));ct.sheets.push(f);add_rels(opts.wbrels,rId,"worksheets/sheet"+rId+"."+wbext,RELS.WS)});if((opts.Strings||[]).length>0){f="xl/sharedStrings."+wbext;zip.file(f,write_sst(opts.Strings,f,opts));ct.strs.push(f);add_rels(opts.wbrels,++rId,"sharedStrings."+wbext,RELS.SST)}f="xl/theme/theme1.xml";zip.file(f,write_theme());ct.themes.push(f);add_rels(opts.wbrels,++rId,"theme/theme1.xml",RELS.THEME);f="xl/styles.xml";zip.file(f,write_sty(wb,f,opts));ct.styles.push(f);add_rels(opts.wbrels,++rId,"styles."+wbext,RELS.STY);zip.file("[Content_Types].xml",write_ct(ct,opts));zip.file("_rels/.rels",write_rels(opts.rels));zip.file("xl/_rels/workbook.xml.rels",write_rels(opts.wbrels));return zip}function readSync(data,opts){var zip,d=data;var o=opts||{};if(!o.type)o.type=typeof Buffer!=="undefined"&&data instanceof Buffer?"buffer":"base64";switch(o.type){case"base64":zip=new jszip(d,{base64:true});break;case"binary":zip=new jszip(d,{base64:false});break;case"buffer":zip=new jszip(d);break;case"file":zip=new jszip(d=_fs.readFileSync(data));break;default:throw new Error("Unrecognized type "+o.type)}return parse_zip(zip,o)}function readFileSync(data,opts){var o=opts||{};o.type="file";return readSync(data,o)}function writeSync(wb,opts){var o=opts||{};var z=write_zip(wb,o);switch(o.type){case"base64":return z.generate({type:"base64"});case"binary":return z.generate({type:"string"});case"buffer":return z.generate({type:"nodebuffer"});case"file":return _fs.writeFileSync(o.file,z.generate({type:"nodebuffer"}));default:throw new Error("Unrecognized type "+o.type)}}function writeFileSync(wb,filename,opts){var o=opts||{};o.type="file";o.file=filename;switch(o.file.substr(-5).toLowerCase()){case".xlsm":o.bookType="xlsm";break;case".xlsb":o.bookType="xlsb";break}return writeSync(wb,o)}function decode_row(rowstr){return Number(unfix_row(rowstr))-1}function encode_row(row){return""+(row+1)}function fix_row(cstr){return cstr.replace(/([A-Z]|^)([0-9]+)$/,"$1$$$2")}function unfix_row(cstr){return cstr.replace(/\$([0-9]+)$/,"$1")}function decode_col(colstr){var c=unfix_col(colstr),d=0,i=0;for(;i!==c.length;++i)d=26*d+c.charCodeAt(i)-64;return d-1}function encode_col(col){var s="";for(++col;col;col=Math.floor((col-1)/26))s=_chr((col-1)%26+65)+s;return s}function fix_col(cstr){return cstr.replace(/^([A-Z])/,"$$$1")}function unfix_col(cstr){return cstr.replace(/^\$([A-Z])/,"$1")}function split_cell(cstr){return cstr.replace(/(\$?[A-Z]*)(\$?[0-9]*)/,"$1,$2").split(",")}function decode_cell(cstr){var splt=split_cell(cstr);return{c:decode_col(splt[0]),r:decode_row(splt[1])}}function encode_cell(cell){return encode_col(cell.c)+encode_row(cell.r)}function fix_cell(cstr){return fix_col(fix_row(cstr))}function unfix_cell(cstr){return unfix_col(unfix_row(cstr))}function decode_range(range){var x=range.split(":").map(decode_cell);return{s:x[0],e:x[x.length-1]}}function encode_range(cs,ce){if(typeof ce==="undefined"||typeof ce==="number")return encode_range(cs.s,cs.e);if(typeof cs!=="string")cs=encode_cell(cs);if(typeof ce!=="string")ce=encode_cell(ce);return cs==ce?cs:cs+":"+ce}function format_cell(cell,v){if(!cell||!cell.t)return"";if(typeof cell.w!=="undefined")return cell.w;if(typeof v==="undefined")v=cell.v;if(typeof cell.z!=="undefined")try{return cell.w=SSF.format(cell.z,v)}catch(e){}if(!cell.XF)return v;try{return cell.w=SSF.format(cell.XF.ifmt||0,v)}catch(e){return v}}function sheet_to_row_object_array(sheet,opts){var val,row,r,hdr={},isempty,R,C,v;var out=[];opts=opts||{};if(!sheet||!sheet["!ref"])return out;r=decode_range(sheet["!ref"]);for(R=r.s.r,C=r.s.c;C<=r.e.c;++C){val=sheet[encode_cell({c:C,r:R})];if(!val)continue;hdr[C]=format_cell(val)}for(R=r.s.r+1;R<=r.e.r;++R){isempty=true;row=Object.create({__rowNum__:R});for(C=r.s.c;C<=r.e.c;++C){val=sheet[encode_cell({c:C,r:R})];if(!val||!val.t)continue;v=(val||{}).v;switch(val.t){case"e":continue;case"s":case"str":break;case"b":case"n":break;default:throw"unrecognized type "+val.t}if(typeof v!=="undefined"){row[hdr[C]]=opts.raw?v||val.v:format_cell(val,v);isempty=false}}if(!isempty)out.push(row)}return out}function sheet_to_csv(sheet,opts){var out=[],txt="";opts=opts||{};if(!sheet||!sheet["!ref"])return"";var r=decode_range(sheet["!ref"]);var fs=opts.FS||",",rs=opts.RS||"\n";for(var R=r.s.r;R<=r.e.r;++R){var row=[];for(var C=r.s.c;C<=r.e.c;++C){var val=sheet[encode_cell({c:C,r:R})];if(!val){row.push("");continue}txt=String(format_cell(val));if(txt.indexOf(fs)!==-1||txt.indexOf(rs)!==-1||txt.indexOf('"')!==-1)txt='"'+txt.replace(/"/g,'""')+'"';row.push(txt)}out.push(row.join(fs))}return out.join(rs)+(out.length?rs:"")}var make_csv=sheet_to_csv;function get_formulae(ws){var cmds=[];for(var y in ws)if(y[0]!=="!"&&ws.hasOwnProperty(y)){var x=ws[y];var val="";if(x.f)val=x.f;else if(typeof x.w!=="undefined")val="'"+x.w;else if(typeof x.v==="undefined")continue;else val=x.v;cmds.push(y+"="+val)}return cmds}var utils={encode_col:encode_col,encode_row:encode_row,encode_cell:encode_cell,encode_range:encode_range,decode_col:decode_col,decode_row:decode_row,split_cell:split_cell,decode_cell:decode_cell,decode_range:decode_range,sheet_to_csv:sheet_to_csv,make_csv:sheet_to_csv,make_json:sheet_to_row_object_array,get_formulae:get_formulae,format_cell:format_cell,sheet_to_row_object_array:sheet_to_row_object_array};XLSX.parseZip=parse_zip;XLSX.read=readSync;XLSX.readFile=readFileSync;XLSX.write=writeSync;XLSX.writeFile=writeFileSync;XLSX.utils=utils;XLSX.SSF=SSF})(typeof exports!=="undefined"?exports:XLSX);
//# sourceMappingURL=dist/xlsx.full.min.map