/* xlsx.js (C) 2013-2014 SheetJS -- http://sheetjs.com */
var XLSX={};(function(XLSX){XLSX.version="0.7.2";var current_codepage=1252,current_cptable;if(typeof module!=="undefined"&&typeof require!=="undefined"){if(typeof cptable==="undefined")cptable=require("codepage");current_cptable=cptable[current_codepage]}function reset_cp(){set_cp(1252)}function set_cp(cp){current_codepage=cp;if(typeof cptable!=="undefined")current_cptable=cptable[cp]}var _getchar=function(x){return String.fromCharCode(x)};if(typeof cptable!=="undefined")_getchar=function(x){if(current_codepage===1200)return String.fromCharCode(x);if(current_cptable)return current_cptable.dec[x];return cptable.utils.decode(current_codepage,[x%256,x>>8])[0]};function char_codes(data){return data.split("").map(function(x){return x.charCodeAt(0)})}function debom_xml(data){if(typeof cptable!=="undefined"){if(data.charCodeAt(0)===255&&data.charCodeAt(1)===254){return cptable.utils.decode(1200,char_codes(data.substr(2)))}}return data}var SSF={};var make_ssf=function(SSF){var _strrev=function(x){return String(x).split("").reverse().join("")};function fill(c,l){return new Array(l+1).join(c)}function pad(v,d,c){var t=String(v);return t.length>=d?t:fill(c||0,d-t.length)+t}function rpad(v,d,c){var t=String(v);return t.length>=d?t:t+fill(c||0,d-t.length)}SSF.version="0.7.0";var opts_fmt={date1904:0,output:"",WTF:false};function fixopts(o){for(var y in opts_fmt)if(o[y]===undefined)o[y]=opts_fmt[y]}SSF.opts=opts_fmt;var table_fmt={0:"General",1:"0",2:"0.00",3:"#,##0",4:"#,##0.00",9:"0%",10:"0.00%",11:"0.00E+00",12:"# ?/?",13:"# ??/??",14:"m/d/yy",15:"d-mmm-yy",16:"d-mmm",17:"mmm-yy",18:"h:mm AM/PM",19:"h:mm:ss AM/PM",20:"h:mm",21:"h:mm:ss",22:"m/d/yy h:mm",37:"#,##0 ;(#,##0)",38:"#,##0 ;[Red](#,##0)",39:"#,##0.00;(#,##0.00)",40:"#,##0.00;[Red](#,##0.00)",45:"mm:ss",46:"[h]:mm:ss",47:"mmss.0",48:"##0.0E+0",49:"@",56:'"上午/下午 "hh"時"mm"分"ss"秒 "',65535:"General"};var days=[["Sun","Sunday"],["Mon","Monday"],["Tue","Tuesday"],["Wed","Wednesday"],["Thu","Thursday"],["Fri","Friday"],["Sat","Saturday"]];var months=[["J","Jan","January"],["F","Feb","February"],["M","Mar","March"],["A","Apr","April"],["M","May","May"],["J","Jun","June"],["J","Jul","July"],["A","Aug","August"],["S","Sep","September"],["O","Oct","October"],["N","Nov","November"],["D","Dec","December"]];var frac=function frac(x,D,mixed){var sgn=x<0?-1:1;var B=x*sgn;var P_2=0,P_1=1,P=0;var Q_2=1,Q_1=0,Q=0;var A=Math.floor(B);while(Q_1<D){A=Math.floor(B);P=A*P_1+P_2;Q=A*Q_1+Q_2;if(B-A<5e-10)break;B=1/(B-A);P_2=P_1;P_1=P;Q_2=Q_1;Q_1=Q}if(Q>D){Q=Q_1;P=P_1}if(Q>D){Q=Q_2;P=P_2}if(!mixed)return[0,sgn*P,Q];if(Q===0)throw"Unexpected state: "+P+" "+P_1+" "+P_2+" "+Q+" "+Q_1+" "+Q_2;var q=Math.floor(sgn*P/Q);return[q,sgn*P-q*Q,Q]};var general_fmt=function(v,opts){if(typeof v==="boolean")return v?"TRUE":"FALSE";if(typeof v==="number"){var o,V=v<0?-v:v;if(V>=.1&&V<1)o=v.toPrecision(9);else if(V>=.01&&V<.1)o=v.toPrecision(8);else if(V>=.001&&V<.01)o=v.toPrecision(7);else if(V>=1e-4&&V<.001)o=v.toPrecision(6);else if(V>=Math.pow(10,10)&&V<Math.pow(10,11))o=v.toFixed(10).substr(0,12);else if(V>Math.pow(10,-9)&&V<Math.pow(10,11)){o=v.toFixed(12).replace(/(\.[0-9]*[1-9])0*$/,"$1").replace(/\.$/,"");if(o.length>(v<0?12:11))o=v.toPrecision(10);if(o.length>(v<0?12:11))o=v.toExponential(5)}else{o=v.toFixed(11).replace(/(\.[0-9]*[1-9])0*$/,"$1");if(o.length>(v<0?12:11))o=v.toPrecision(6)}o=o.replace(/(\.[0-9]*[1-9])0+e/,"$1e").replace(/\.0*e/,"e");return o.replace("e","E").replace(/\.0*$/,"").replace(/\.([0-9]*[^0])0*$/,".$1").replace(/(E[+-])([0-9])$/,"$1"+"0"+"$2")}if(typeof v==="string")return v;throw new Error("unsupported value in General format: "+v)};SSF._general=general_fmt;function fix_hijri(date,o){return 0}var parse_date_code=function parse_date_code(v,opts,b2){var date=Math.floor(v),time=Math.floor(86400*(v-date)+1e-6),dow=0;var dout=[];var out={D:date,T:time,u:86400*(v-date)-time,y:0,m:0,d:0,H:0,M:0,S:0,q:0};fixopts(opts=opts||{});if(opts.date1904)date+=1462;if(date>2958465)return null;if(out.u>.999){out.u=0;if(++time==86400){time=0;++date}}if(date===60){dout=b2?[1317,10,29]:[1900,2,29];dow=3}else if(date===0){dout=b2?[1317,8,29]:[1900,1,0];dow=6}else{if(date>60)--date;var d=new Date(1900,0,1);d.setDate(d.getDate()+date-1);dout=[d.getFullYear(),d.getMonth()+1,d.getDate()];dow=d.getDay();if(date<60)dow=(dow+6)%7;if(b2)dow=fix_hijri(d,dout)}out.y=dout[0];out.m=dout[1];out.d=dout[2];out.S=time%60;time=Math.floor(time/60);out.M=time%60;time=Math.floor(time/60);out.H=time;out.q=dow;return out};SSF.parse_date_code=parse_date_code;var write_date=function(type,fmt,val,ss0){var o,ss,tt,y=val.y,sss0;switch(type){case"b":y=val.y+543;case"y":switch(fmt.length){case 1:case 2:return pad(y%100,2);default:return pad(y%1e4,4)}case"m":switch(fmt){case"m":return val.m;case"mm":return pad(val.m,2);case"mmm":return months[val.m-1][1];case"mmmmm":return months[val.m-1][0];default:return months[val.m-1][2]}case"d":switch(fmt){case"d":return val.d;case"dd":return pad(val.d,2);case"ddd":return days[val.q][0];default:return days[val.q][1]}case"h":switch(fmt){case"h":return 1+(val.H+11)%12;case"hh":return pad(1+(val.H+11)%12,2);default:throw"bad hour format: "+fmt}case"H":switch(fmt){case"h":return val.H;case"hh":return pad(val.H,2);default:throw"bad hour format: "+fmt}case"M":switch(fmt){case"m":return val.M;case"mm":return pad(val.M,2);default:throw"bad minute format: "+fmt}case"s":switch(fmt){case"s":case"ss":case".0":case".00":case".000":sss0=ss0||0;tt=Math.pow(10,sss0);ss=Math.round(tt*(val.S+val.u));if(fmt==="s")return ss>=60*tt?0:ss/tt;else if(fmt==="ss"){if(ss>=60*tt)ss=0;return pad(ss,2+sss0).substr(0,2)}if(ss>=60*tt)ss=0;o=pad(ss,2+sss0);return"."+o.substr(2,fmt.length-1);default:throw"bad second format: "+fmt}case"Z":switch(fmt){case"[h]":case"[hh]":o=val.D*24+val.H;break;case"[m]":case"[mm]":o=(val.D*24+val.H)*60+val.M;break;case"[s]":case"[ss]":o=((val.D*24+val.H)*60+val.M)*60+Math.round(val.S+val.u);break;default:throw"bad abstime format: "+fmt}return fmt.length===3?o:pad(o,2);case"e":{return val.y}break}};var commaify=function(s){return _strrev(_strrev(s).replace(/.../g,"$&,")).replace(/^,/,"")};var write_num=function(type,fmt,val){if(type==="("&&!fmt.match(/\).*[0#]/)){var ffmt=fmt.replace(/\( */,"").replace(/ \)/,"").replace(/\)/,"");if(val>=0)return write_num("n",ffmt,val);return"("+write_num("n",ffmt,-val)+")"}var mul=0,o;fmt=fmt.replace(/%/g,function(){mul++;return""});if(mul!==0)return write_num(type,fmt,val*Math.pow(10,2*mul))+fill("%",mul);fmt=fmt.replace(/(\.0+)(,+)$/g,function($$,$1,$2){mul=$2.length;return $1});if(mul!==0)return write_num(type,fmt,val/Math.pow(10,3*mul));if(fmt.indexOf("E")>-1){var idx=fmt.indexOf("E")-fmt.indexOf(".")-1;if(fmt.match(/^#+0.0E\+0$/)){var period=fmt.indexOf(".");if(period===-1)period=fmt.indexOf("E");var ee=Number(val.toExponential(0).substr(2+(val<0?1:0)))%period;if(ee<0)ee+=period;o=(val/Math.pow(10,ee)).toPrecision(idx+1+(period+ee)%period);if(!o.match(/[Ee]/)){var fakee=Number(val.toExponential(0).substr(2+(val<0?1:0)));if(o.indexOf(".")===-1)o=o[0]+"."+o.substr(1)+"E+"+(fakee-o.length+ee);else o+="E+"+(fakee-ee);while(o.substr(0,2)==="0."){o=o[0]+o.substr(2,period)+"."+o.substr(2+period);o=o.replace(/^0+([1-9])/,"$1").replace(/^0+\./,"0.")}o=o.replace(/\+-/,"-")}o=o.replace(/^([+-]?)([0-9]*)\.([0-9]*)[Ee]/,function($$,$1,$2,$3){return $1+$2+$3.substr(0,(period+ee)%period)+"."+$3.substr(ee)+"E"})}else o=val.toExponential(idx);if(fmt.match(/E\+00$/)&&o.match(/e[+-][0-9]$/))o=o.substr(0,o.length-1)+"0"+o[o.length-1];if(fmt.match(/E\-/)&&o.match(/e\+/))o=o.replace(/e\+/,"e");return o.replace("e","E")}if(fmt[0]==="$")return"$"+write_num(type,fmt.substr(fmt[1]==" "?2:1),val);var r,rr,ff,aval=val<0?-val:val,sign=val<0?"-":"";if(r=fmt.match(/# (\?+)([ ]?)\/([ ]?)(\d+)/)){var den=Number(r[4]),rnd=Math.round(aval*den),base=Math.floor(rnd/den);var myn=rnd-base*den,myd=den;return sign+String(base||"")+" "+(myn===0?fill(" ",r[1].length+1+r[4].length):pad(myn,r[1].length," ")+r[2]+"/"+r[3]+pad(myd,r[4].length))}if(fmt.match(/^#+0+$/))fmt=fmt.replace(/#/g,"");if(fmt.match(/^00+$/))return(val<0?"-":"")+pad(Math.round(aval),fmt.length);if(fmt.match(/^[#?]+$/))return String(Math.round(val)).replace(/^0$/,"");if(r=fmt.match(/^#*0*\.(0+)/)){o=Math.round(val*Math.pow(10,r[1].length));rr=String(o/Math.pow(10,r[1].length)).replace(/^([^\.]+)$/,"$1."+r[1]).replace(/\.$/,"."+r[1]).replace(/\.([0-9]*)$/,function($$,$1){return"."+$1+fill("0",r[1].length-$1.length)});return fmt.match(/0\./)?rr:rr.replace(/^0\./,".")}fmt=fmt.replace(/^#+([0.])/,"$1");if(r=fmt.match(/^(0*)\.(#*)$/)){o=Math.round(aval*Math.pow(10,r[2].length));return sign+String(o/Math.pow(10,r[2].length)).replace(/\.(\d*[1-9])0*$/,".$1").replace(/^([-]?\d*)$/,"$1.").replace(/^0\./,r[1].length?"0.":".")}if(r=fmt.match(/^#,##0([.]?)$/))return sign+commaify(String(Math.round(aval)));if(r=fmt.match(/^#,##0\.([#0]*0)$/)){rr=Math.round((val-Math.floor(val))*Math.pow(10,r[1].length));return val<0?"-"+write_num(type,fmt,-val):commaify(String(Math.floor(val)))+"."+pad(rr,r[1].length,0)}if(r=fmt.match(/^#,#*,#0/))return write_num(type,fmt.replace(/^#,#*,/,""),val);if(r=fmt.match(/^([0#]+)(\\?-([0#]+))+$/)){ff=_strrev(write_num(type,fmt.replace(/[\\-]/g,""),val));rr=0;return _strrev(_strrev(fmt.replace(/\\/g,"")).replace(/[0#]/g,function(x){return rr<ff.length?ff[rr++]:x==="0"?"0":""}))}if(fmt.match(/\(###\) ###\\?-####/)){ff=write_num(type,"##########",val);return"("+ff.substr(0,3)+") "+ff.substr(3,3)+"-"+ff.substr(6)}if(r=fmt.match(/^([?]+)([ ]?)\/([ ]?)([?]+)/)){rr=Math.min(Math.max(r[1].length,r[4].length),7);ff=frac(aval,Math.pow(10,rr)-1,false);return sign+(ff[0]||(ff[1]?"":"0"))+(ff[1]?pad(ff[1],rr," ")+r[2]+"/"+r[3]+rpad(ff[2],rr," "):fill(" ",2*rr+1+r[2].length+r[3].length))}if(r=fmt.match(/^# ([?]+)([ ]?)\/([ ]?)([?]+)/)){rr=Math.min(Math.max(r[1].length,r[4].length),7);ff=frac(aval,Math.pow(10,rr)-1,true);return sign+(ff[0]||(ff[1]?"":"0"))+" "+(ff[1]?pad(ff[1],rr," ")+r[2]+"/"+r[3]+rpad(ff[2],rr," "):fill(" ",2*rr+1+r[2].length+r[3].length))}if(r=fmt.match(/^[#0]+$/)){o=""+Math.round(val);if(fmt.length<=o.length)return o;return fmt.substr(0,fmt.length-o.length).replace(/#/g,"")+o}if(r=fmt.match(/^([#0]+)\.([#0]+)$/)){o=""+val.toFixed(Math.min(r[2].length,10)).replace(/([^0])0+$/,"$1");rr=o.indexOf(".");var lres=fmt.indexOf(".")-rr,rres=fmt.length-o.length-lres;return fmt.substr(0,lres).replace(/#/g,"")+o+fmt.substr(fmt.length-rres).replace(/#/g,"")}if(r=fmt.match(/^00,000\.([#0]*0)$/)){rr=val==Math.floor(val)?0:Math.round((val-Math.floor(val))*Math.pow(10,r[1].length));return val<0?"-"+write_num(type,fmt,-val):commaify(String(Math.floor(val))).replace(/^\d,\d{3}$/,"0$&").replace(/^\d*$/,function($$){return"00,"+($$.length<3?pad(0,3-$$.length):"")+$$})+"."+pad(rr,r[1].length,0)}switch(fmt){case"#,###":var x=commaify(String(Math.round(aval)));return x!=="0"?sign+x:"";default:}throw new Error("unsupported format |"+fmt+"|")};function split_fmt(fmt){var out=[];var in_str=-1;for(var i=0,j=0;i<fmt.length;++i){if(in_str!=-1){if(fmt[i]=='"')in_str=-1;continue}if(fmt[i]=="_"||fmt[i]=="*"||fmt[i]=="\\"){++i;continue}if(fmt[i]=='"'){in_str=i;continue}if(fmt[i]!=";")continue;out.push(fmt.slice(j,i));j=i+1}out.push(fmt.slice(j));if(in_str!=-1)throw new Error("Format |"+fmt+"| unterminated string at "+in_str);return out}SSF._split=split_fmt;function eval_fmt(fmt,v,opts,flen){var out=[],o="",i=0,c="",lst="t",q,dt,j;fixopts(opts=opts||{});var hr="H";while(i<fmt.length){switch(c=fmt[i]){case"G":if(fmt.substr(i,7).toLowerCase()!=="general")throw new Error("unrecognized character "+fmt[i]+" in "+fmt);out.push({t:"G",v:"General"});i+=7;break;case'"':for(o="";fmt[++i]!=='"'&&i<fmt.length;)o+=fmt[i];out.push({t:"t",v:o});++i;break;case"\\":var w=fmt[++i],t="()".indexOf(w)===-1?"t":w;out.push({t:t,v:w});++i;break;case"_":out.push({t:"t",v:" "});i+=2;break;case"@":out.push({t:"T",v:v});++i;break;case"B":case"b":if(fmt[i+1]==="1"||fmt[i+1]==="2"){if(!dt)dt=parse_date_code(v,opts,fmt[i+1]==="2");q={t:"X",v:fmt.substr(i,2)};out.push(q);lst=c;i+=2;break}case"M":case"D":case"Y":case"H":case"S":case"E":c=c.toLowerCase();case"m":case"d":case"y":case"h":case"s":case"e":case"g":if(v<0)return"";if(!dt)dt=parse_date_code(v,opts);if(!dt)return"";o=fmt[i];while((fmt[++i]||"").toLowerCase()===c)o+=c;if(c==="m"&&lst.toLowerCase()==="h")c="M";if(c==="h")c=hr;o=o.toLowerCase();q={t:c,v:o};out.push(q);lst=c;break;case"A":if(!dt)dt=parse_date_code(v,opts);if(!dt)return"";q={t:c,v:"A"};if(fmt.substr(i,3)==="A/P"){q.v=dt.H>=12?"P":"A";q.t="T";hr="h";i+=3}else if(fmt.substr(i,5)==="AM/PM"){q.v=dt.H>=12?"PM":"AM";q.t="T";i+=5;hr="h"}else{q.t="t";i++}out.push(q);lst=c;break;case"[":o=c;while(fmt[i++]!=="]"&&i<fmt.length)o+=fmt[i];if(o.substr(-1)!=="]")throw'unterminated "[" block: |'+o+"|";if(o.match(/\[[HhMmSs]*\]/)){if(!dt)dt=parse_date_code(v,opts);if(!dt)return"";out.push({t:"Z",v:o.toLowerCase()})}else{o=""}break;case".":if(dt){o=c;while((c=fmt[++i])==="0")o+=c;out.push({t:"s",v:o});break}case"0":case"#":o=c;while("0#?.,E+-%".indexOf(c=fmt[++i])>-1||c=="\\"&&fmt[i+1]=="-"&&"0#".indexOf(fmt[i+2])>-1)o+=c;out.push({t:"n",v:o});break;case"?":o=fmt[i];while(fmt[++i]===c)o+=c;q={t:c,v:o};out.push(q);lst=c;break;case"*":++i;if(fmt[i]==" "||fmt[i]=="*")++i;break;case"(":case")":out.push({t:flen===1?"t":c,v:c});++i;break;case"1":case"2":case"3":case"4":case"5":case"6":case"7":case"8":case"9":o=fmt[i];while("0123456789".indexOf(fmt[++i])>-1)o+=fmt[i];out.push({t:"D",v:o});break;case" ":out.push({t:c,v:c});++i;break;default:if(",$-+/():!^&'~{}<>=€acfijklopqrtuvwxz".indexOf(c)===-1)throw"unrecognized character "+fmt[i]+" in "+fmt;out.push({t:"t",v:c});++i;break}}var bt=0,ss0=0,ssm;for(i=out.length-1,lst="t";i>=0;--i){switch(out[i].t){case"h":case"H":out[i].t=hr;lst="h";if(bt<1)bt=1;break;case"s":if(ssm=out[i].v.match(/\.0+$/))ss0=Math.max(ss0,ssm[0].length-1);if(bt<3)bt=3;case"d":case"y":case"M":case"e":lst=out[i].t;break;case"m":if(lst==="s"){out[i].t="M";if(bt<2)bt=2}break;case"X":if(out[i].v==="B2");break;case"Z":if(bt<1&&out[i].v.match(/[Hh]/))bt=1;if(bt<2&&out[i].v.match(/[Mm]/))bt=2;if(bt<3&&out[i].v.match(/[Ss]/))bt=3}}switch(bt){case 0:break;case 1:if(dt.u>=.5){dt.u=0;++dt.S}if(dt.S>=60){dt.S=0;++dt.M}if(dt.M>=60){dt.M=0;++dt.H}break;case 2:if(dt.u>=.5){dt.u=0;++dt.S}if(dt.S>=60){dt.S=0;++dt.M}break}var nstr="",jj;for(i=0;i<out.length;++i){switch(out[i].t){case"t":case"T":case" ":case"D":break;case"X":delete out[i];break;case"d":case"m":case"y":case"h":case"H":case"M":case"s":case"e":case"b":case"Z":out[i].v=write_date(out[i].t,out[i].v,dt,ss0);out[i].t="t";break;case"n":case"(":case"?":jj=i+1;while(out[jj]&&("?D".indexOf(out[jj].t)>-1||" t".indexOf(out[jj].t)>-1&&"?t".indexOf((out[jj+1]||{}).t)>-1&&(out[jj+1].t=="?"||out[jj+1].v=="/")||out[i].t=="("&&")n ".indexOf(out[jj].t)>-1||out[jj].t=="t"&&(out[jj].v=="/"||"$€".indexOf(out[jj].v)>-1||out[jj].v==" "&&(out[jj+1]||{}).t=="?"))){out[i].v+=out[jj].v;delete out[jj];++jj}nstr+=out[i].v;i=jj-1;break;case"G":out[i].t="t";out[i].v=general_fmt(v,opts);break}}if(nstr){var ostr=write_num(nstr[0]=="("?"(":"n",nstr,v<0&&nstr[0]=="-"?-v:v);jj=ostr.length-1;var decpt=out.length;for(i=0;i<out.length;++i)if(out[i]&&out[i].v.indexOf(".")>-1){decpt=i;break}var lasti=out.length,vv;if(decpt===out.length&&!ostr.match(/E/)){for(i=out.length-1;i>=0;--i){if(!out[i]||"n?(".indexOf(out[i].t)===-1)continue;vv=out[i].v.split("");for(j=vv.length-1;j>=0;--j){if(jj>=0)vv[j]=ostr[jj--];else vv[j]=""}out[i].v=vv.join("");out[i].t="t";lasti=i}if(jj>=0&&lasti<out.length)out[lasti].v=ostr.substr(0,jj+1)+out[lasti].v}else if(decpt!==out.length&&!ostr.match(/E/)){jj=ostr.indexOf(".")-1;for(i=decpt;i>=0;--i){if(!out[i]||"n?(".indexOf(out[i].t)===-1)continue;vv=out[i].v.split("");for(j=out[i].v.indexOf(".")>-1&&i==decpt?out[i].v.indexOf(".")-1:vv.length-1;j>=0;--j){if(jj>=0&&"0#".indexOf(vv[j])>-1)vv[j]=ostr[jj--];else vv[j]=""}out[i].v=vv.join("");out[i].t="t";lasti=i}if(jj>=0&&lasti<out.length)out[lasti].v=ostr.substr(0,jj+1)+out[lasti].v;jj=ostr.indexOf(".")+1;for(i=decpt;i<out.length;++i){if(!out[i]||"n?(".indexOf(out[i].t)===-1&&i!=decpt)continue;vv=out[i].v.split("");for(j=out[i].v.indexOf(".")>-1&&i==decpt?out[i].v.indexOf(".")+1:0;j<vv.length;++j){if(jj<ostr.length)vv[j]=ostr[jj++];else vv[j]=""}out[i].v=vv.join("");out[i].t="t";lasti=i}}}for(i=0;i<out.length;++i)if(out[i]&&"n(?".indexOf(out[i].t)>-1){out[i].v=write_num(out[i].t,out[i].v,flen>1&&v<0&&i>0&&out[i-1].v=="-"?-v:v);out[i].t="t"}return out.map(function(x){return x.v}).join("")}SSF._eval=eval_fmt;function choose_fmt(fmt,v,o){if(typeof fmt==="number")fmt=(o&&o.table?o.table:table_fmt)[fmt];if(typeof fmt==="string")fmt=split_fmt(fmt);var l=fmt.length;if(l<4&&fmt[l-1].indexOf("@")>-1)--l;switch(fmt.length){case 1:fmt=fmt[0].indexOf("@")>-1?["General","General","General",fmt[0]]:[fmt[0],fmt[0],fmt[0],"@"];break;case 2:fmt=fmt[1].indexOf("@")>-1?[fmt[0],fmt[0],fmt[0],fmt[1]]:[fmt[0],fmt[1],fmt[0],"@"];break;case 3:fmt=fmt[2].indexOf("@")>-1?[fmt[0],fmt[1],fmt[0],fmt[2]]:[fmt[0],fmt[1],fmt[2],"@"];break;case 4:break;default:throw"cannot find right format for |"+fmt+"|"}if(typeof v!=="number")return[fmt.length,fmt[3]];var ff=v>0?fmt[0]:v<0?fmt[1]:fmt[2];if(fmt[0].match(/\[[=<>]/)||fmt[1].match(/\[[=<>]/)){var chk=function(v,rr,out){if(!rr)return null;var found=false;var thresh=Number(rr[2]);switch(rr[1]){case"=":if(v==thresh)found=true;break;case">":if(v>thresh)found=true;break;case"<":if(v<thresh)found=true;break;case"<>":if(v!=thresh)found=true;break;case">=":if(v>=thresh)found=true;break;case"<=":if(v<=thresh)found=true;break}return found?out:null};var m1=fmt[0].match(/\[([=<>]*)([-]?\d+)\]/);var m2=fmt[1].match(/\[([=<>]*)([-]?\d+)\]/);return chk(v,m1,[l,fmt[0]])||chk(v,m2,[l,fmt[1]])||[l,fmt[m1&&m2?2:1]]}return[l,ff]}var format=function format(fmt,v,o){fixopts(o=o||{});if(typeof fmt==="string"&&fmt.toLowerCase()==="general")return general_fmt(v,o);if(typeof fmt==="number")fmt=(o.table||table_fmt)[fmt];var f=choose_fmt(fmt,v,o);if(f[1].toLowerCase()==="general")return general_fmt(v,o);if(v===true)v="TRUE";if(v===false)v="FALSE";if(v===""||typeof v==="undefined")return"";return eval_fmt(f[1],v,o,f[0])};SSF._choose=choose_fmt;SSF._table=table_fmt;SSF.load=function(fmt,idx){table_fmt[idx]=fmt};SSF.format=format;SSF.get_table=function(){return table_fmt};SSF.load_table=function(tbl){for(var i=0;i!=392;++i)if(tbl[i])SSF.load(tbl[i],i)}};make_ssf(SSF);function isval(x){return typeof x!=="undefined"&&x!==null}function keys(o){return Object.keys(o).filter(function(x){return o.hasOwnProperty(x)})}function evert(obj,arr){var o={};keys(obj).forEach(function(k){if(!obj.hasOwnProperty(k))return;if(!arr)o[obj[k]]=k;else(o[obj[k]]=o[obj[k]]||[]).push(k)});return o}function datenum(v,date1904){if(date1904)v+=1462;var epoch=Date.parse(v);return(epoch-new Date(Date.UTC(1899,11,30)))/(24*60*60*1e3)}function getdata(data){if(!data)return null;if(data.data)return data.name.substr(-4)!==".bin"?debom_xml(data.data):data.data.split("").map(function(x){return x.charCodeAt(0)});if(data.asNodeBuffer&&typeof Buffer!=="undefined"&&data.name.substr(-4)===".bin")return data.asNodeBuffer();if(data.asBinary&&data.name.substr(-4)!==".bin")return debom_xml(data.asBinary());if(data._data&&data._data.getContent){if(data.name.substr(-4)===".bin")return Array.prototype.slice.call(data._data.getContent());return Array.prototype.slice.call(data._data.getContent(),0).map(function(x){return String.fromCharCode(x)}).join("")}return null}function getzipfile(zip,file){var f=file;if(zip.files[f])return zip.files[f];f=file.toLowerCase();if(zip.files[f])return zip.files[f];f=f.replace(/\//g,"\\");if(zip.files[f])return zip.files[f];throw new Error("Cannot find file "+file+" in zip")}function getzipdata(zip,file,safe){if(!safe)return getdata(getzipfile(zip,file));if(!file)return null;try{return getzipdata(zip,file)}catch(e){return null}}var _fs,jszip;if(typeof JSZip!=="undefined")jszip=JSZip;if(typeof exports!=="undefined"){if(typeof module!=="undefined"&&module.exports){if(typeof Buffer!=="undefined"&&typeof jszip==="undefined")jszip=require("jszip");if(typeof jszip==="undefined")jszip=require("./jszip").JSZip;_fs=require("fs")}}var _chr=function(c){return String.fromCharCode(c)};var _ord=function(c){return c.charCodeAt(0)};var attregexg=/([\w:]+)=((?:")([^"]*)(?:")|(?:')([^']*)(?:'))/g;var attregex=/([\w:]+)=((?:")(?:[^"]*)(?:")|(?:')(?:[^']*)(?:'))/;function parsexmltag(tag){var words=tag.split(/\s+/);var z={0:words[0]};if(words.length===1)return z;(tag.match(attregexg)||[]).map(function(x){var y=x.match(attregex);y[1]=y[1].replace(/xmlns:/,"xmlns");z[y[1].replace(/^[a-zA-Z]*:/,"")]=y[2].substr(1,y[2].length-2)});return z}var encodings={"&quot;":'"',"&apos;":"'","&gt;":">","&lt;":"<","&amp;":"&"};var rencoding=evert(encodings);var rencstr="&<>'\"".split("");function unescapexml(text){var s=text+"";for(var y in encodings)s=s.replace(new RegExp(y,"g"),encodings[y]);return s.replace(/_x([0-9a-fA-F]*)_/g,function(m,c){return _chr(parseInt(c,16))})}function escapexml(text){var s=text+"";rencstr.forEach(function(y){s=s.replace(new RegExp(y,"g"),rencoding[y])});s=s.replace(/[\u0000-\u0007]/g,function(s){return"_x"+("0000"+_ord(s).toString(16)).substr(-4)+"_"});return s}function parsexmlbool(value,tag){switch(value){case"0":case 0:case"false":case"FALSE":return false;case"1":case 1:case"true":case"TRUE":return true;default:throw"bad boolean value "+value+" in "+(tag||"?")}}var utf8read=function(orig){var out=[],i=0,c=0,c1=0,c2=0,c3=0;while(i<orig.length){c=orig.charCodeAt(i++);if(c<128)out.push(_chr(c));else{c2=orig.charCodeAt(i++);if(c>191&&c<224)out.push(_chr((c&31)<<6|c2&63));else{c3=orig.charCodeAt(i++);out.push(_chr((c&15)<<12|(c2&63)<<6|c3&63))}}}return out.join("")};function matchtag(f,g){return new RegExp("<(?:\\w+:)?"+f+'(?: xml:space="preserve")?(?:[^>]*)>([^☃]*)</(?:\\w+:)?'+f+">",(g||"")+"m")}function parseVector(data){var h=parsexmltag(data);var matches=data.match(new RegExp("<vt:"+h.baseType+">(.*?)</vt:"+h.baseType+">","g"))||[];if(matches.length!=h.size)throw"unexpected vector length "+matches.length+" != "+h.size;var res=[];matches.forEach(function(x){var v=x.replace(/<[/]?vt:variant>/g,"").match(/<vt:([^>]*)>(.*)</);res.push({v:v[2],t:v[1]})});return res}function writetag(f,g){return"<"+f+(g.match(/(^\s|\s$|\n)/)?' xml:space="preserve"':"")+">"+g+"</"+f+">"}function writextag(f,g,h){return"<"+f+(h!=null?keys(h).map(function(k){return" "+k+'="'+h[k]+'"'}).join(""):"")+(g==null?"/":(g.match(/(^\s|\s$|\n)/)?' xml:space="preserve"':"")+">"+g+"</"+f)+">"}function write_w3cdtf(d,t){try{return d.toISOString().replace(/\.\d*/,"")}catch(e){if(t)throw e}}function write_vt(s){if(typeof s=="string")return writextag("vt:lpwstr",s);if(typeof s=="number")return writextag((s|0)==s?"vt:i4":"vt:r8",String(s));if(typeof s=="boolean")return writextag("vt:bool",s?"true":"false");if(s instanceof Date)return writextag("vt:filetime",write_w3cdtf(s));throw new Error("Unable to serialize "+s)}var XML_HEADER='<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\r\n';var XMLNS={dc:"http://purl.org/dc/elements/1.1/",dcterms:"http://purl.org/dc/terms/",dcmitype:"http://purl.org/dc/dcmitype/",mx:"http://schemas.microsoft.com/office/mac/excel/2008/main",r:"http://schemas.openxmlformats.org/officeDocument/2006/relationships",sjs:"http://schemas.openxmlformats.org/package/2006/sheetjs/core-properties",vt:"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",xsd:"http://www.w3.org/2001/XMLSchema"};XMLNS.main=["http://schemas.openxmlformats.org/spreadsheetml/2006/main","http://purl.oclc.org/ooxml/spreadsheetml/main","http://schemas.microsoft.com/office/excel/2006/main","http://schemas.microsoft.com/office/excel/2006/2"];function readIEEE754(buf,idx,isLE,nl,ml){if(isLE===undefined)isLE=true;if(!nl)nl=8;if(!ml&&nl===8)ml=52;var e,m,el=nl*8-ml-1,eMax=(1<<el)-1,eBias=eMax>>1;var bits=-7,d=isLE?-1:1,i=isLE?nl-1:0,s=buf[idx+i];i+=d;e=s&(1<<-bits)-1;s>>>=-bits;bits+=el;for(;bits>0;e=e*256+buf[idx+i],i+=d,bits-=8);m=e&(1<<-bits)-1;e>>>=-bits;bits+=ml;for(;bits>0;m=m*256+buf[idx+i],i+=d,bits-=8);if(e===eMax)return m?NaN:(s?-1:1)*Infinity;else if(e===0)e=1-eBias;else{m=m+Math.pow(2,ml);e=e-eBias}return(s?-1:1)*m*Math.pow(2,e-ml)}var __toBuffer;if(typeof Buffer!=="undefined"){Buffer.prototype.hexlify=function(){return this.toString("hex")};__toBuffer=function(bufs){return Buffer.concat(bufs[0])}}else{__toBuffer=function(bufs){var x=[];for(var i=0;i!=bufs[0].length;++i){x=x.concat(bufs[0][i])}return x}}var __readUInt8=function(b,idx){return b.readUInt8?b.readUInt8(idx):b[idx]};var __readUInt16LE=function(b,idx){return b.readUInt16LE?b.readUInt16LE(idx):b[idx+1]*(1<<8)+b[idx]};var __readInt16LE=function(b,idx){var u=__readUInt16LE(b,idx);if(!(u&32768))return u;return(65535-u+1)*-1};var __readUInt32LE=function(b,idx){return b.readUInt32LE?b.readUInt32LE(idx):b[idx+3]*(1<<24)+b[idx+2]*(1<<16)+b[idx+1]*(1<<8)+b[idx]};var __readInt32LE=function(b,idx){if(b.readInt32LE)return b.readInt32LE(idx);var u=__readUInt32LE(b,idx);if(!(u&2147483648))return u;return(4294967295-u+1)*-1};var __readDoubleLE=function(b,idx){return b.readDoubleLE?b.readDoubleLE(idx):readIEEE754(b,idx||0)};function ReadShift(size,t){var o="",oo=[],w,vv,i,loc;t=t||"u";if(size==="ieee754"){size=8;t="f"}switch(size){case 1:o=__readUInt8(this,this.l);break;case 2:o=(t==="u"?__readUInt16LE:__readInt16LE)(this,this.l);break;case 4:o=__readUInt32LE(this,this.l);break;case 8:if(t==="f"){o=__readDoubleLE(this,this.l);break}case 16:o=this.toString("hex",this.l,this.l+size);break;case"dbcs":size=2*t;loc=this.l;for(i=0;i!=t;++i){oo.push(_getchar(__readUInt16LE(this,loc)));loc+=2}o=oo.join("");break;case"sbcs":size=t;o="";loc=this.l;for(i=0;i!=t;++i){o+=_getchar(__readUInt8(this,loc));loc+=1}break}this.l+=size;return o}function prep_blob(blob,pos){blob.read_shift=ReadShift.bind(blob);blob.l=pos||0;var read=ReadShift.bind(blob);return[read]}function parsenoop(blob,length){blob.l+=length}var recordhopper=function(data,cb,opts){var tmpbyte,cntbyte,length;prep_blob(data,data.l||0);while(data.l<data.length){var RT=data.read_shift(1);if(RT&128)RT=(RT&127)+((data.read_shift(1)&127)<<7);var R=RecordEnum[RT]||RecordEnum[65535];tmpbyte=data.read_shift(1);length=tmpbyte&127;for(cntbyte=1;cntbyte<4&&tmpbyte&128;++cntbyte)length+=((tmpbyte=data.read_shift(1))&127)<<7*cntbyte;var d=R.f(data,length,opts);if(cb(d,R,RT))return}};var blobhopper=function(){var bufs=[]};var parse_StrRun=function(data,length){return{ich:data.read_shift(2),ifnt:data.read_shift(2)}};var parse_RichStr=function(data,length){var start=data.l;var flags=data.read_shift(1);var fRichStr=flags&1,fExtStr=flags&2;var str=parse_XLWideString(data);var rgsStrRun=[];var z={t:str,r:"<t>"+escapexml(str)+"</t>",h:str};if(fRichStr){var dwSizeStrRun=data.read_shift(4);for(var i=0;i!=dwSizeStrRun;++i)rgsStrRun.push(parse_StrRun(data));z.r=JSON.stringify(rgsStrRun)}if(fExtStr){}data.l=start+length;return z};function parse_Cell(data){var col=data.read_shift(4);var iStyleRef=data.read_shift(2);iStyleRef+=data.read_shift(1)<<16;var fPhShow=data.read_shift(1);return{c:col,iStyleRef:iStyleRef}}var parse_CodeName=function(data,length){return parse_XLWideString(data,length)};var parse_RelID=function(data,length){return parse_XLNullableWideString(data,length)};function parse_RkNumber(data){var b=data.slice(data.l,data.l+4);var fX100=b[0]&1,fInt=b[0]&2;data.l+=4;b[0]&=~3;var RK=fInt===0?__readDoubleLE([0,0,0,0,b[0],b[1],b[2],b[3]],0):__readInt32LE(b,0)>>2;return fX100?RK/100:RK}var parse_UncheckedRfX=function(data){var cell={s:{},e:{}};cell.s.r=data.read_shift(4);cell.e.r=data.read_shift(4);cell.s.c=data.read_shift(4);cell.e.c=data.read_shift(4);return cell};var parse_XLNullableWideString=function(data){var cchCharacters=data.read_shift(4);return cchCharacters===0||cchCharacters===4294967295?"":data.read_shift("dbcs",cchCharacters)};var parse_XLWideString=function(data){var cchCharacters=data.read_shift(4);return cchCharacters===0?"":data.read_shift("dbcs",cchCharacters)};function parse_Xnum(data,length){return data.read_shift("ieee754")}var BErr={0:"#NULL!",7:"#DIV/0!",15:"#VALUE!",23:"#REF!",29:"#NAME?",36:"#NUM!",42:"#N/A",43:"#GETTING_DATA",255:"#WTF?"};var RBErr=evert(BErr);function parse_BrtColor(data,length){var read=data.read_shift.bind(data);var out={};var d=read(1);out.fValidRGB=d&1;out.xColorType=d>>>1;out.index=read(1);out.nTintAndShade=read(2,"i");out.bRed=read(1);out.bGreen=read(1);out.bBlue=read(1);out.bAlpha=read(1)}function parse_FontFlags(data,length){var d=data.read_shift(1);data.l++;var out={fItalic:d&2,fStrikeout:d&8,fOutline:d&16,fShadow:d&32,fCondense:d&64,fExtend:d&128};return out}var ct2type={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml":"workbooks","application/vnd.ms-excel.binIndexWs":"TODO","application/vnd.ms-excel.chartsheet":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml":"TODO","application/vnd.ms-excel.dialogsheet":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml":"TODO","application/vnd.ms-excel.macrosheet":"TODO","application/vnd.ms-excel.macrosheet+xml":"TODO","application/vnd.ms-excel.intlmacrosheet":"TODO","application/vnd.ms-excel.binIndexMs":"TODO","application/vnd.openxmlformats-package.core-properties+xml":"coreprops","application/vnd.openxmlformats-officedocument.custom-properties+xml":"custprops","application/vnd.openxmlformats-officedocument.extended-properties+xml":"extprops","application/vnd.openxmlformats-officedocument.customXmlProperties+xml":"TODO","application/vnd.ms-excel.comments":"comments","application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml":"comments","application/vnd.ms-excel.pivotTable":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml":"TODO","application/vnd.ms-excel.calcChain":"calcchains","application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml":"calcchains","application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings":"TODO","application/vnd.ms-office.activeX":"TODO","application/vnd.ms-office.activeX+xml":"TODO","application/vnd.ms-excel.attachedToolbars":"TODO","application/vnd.ms-excel.connections":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml":"TODO","application/vnd.ms-excel.externalLink":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml":"TODO","application/vnd.ms-excel.sheetMetadata":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml":"TODO","application/vnd.ms-excel.pivotCacheDefinition":"TODO","application/vnd.ms-excel.pivotCacheRecords":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml":"TODO","application/vnd.ms-excel.queryTable":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml":"TODO","application/vnd.ms-excel.userNames":"TODO","application/vnd.ms-excel.revisionHeaders":"TODO","application/vnd.ms-excel.revisionLog":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml":"TODO","application/vnd.ms-excel.tableSingleCells":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml":"TODO","application/vnd.ms-excel.slicer":"TODO","application/vnd.ms-excel.slicerCache":"TODO","application/vnd.ms-excel.slicer+xml":"TODO","application/vnd.ms-excel.slicerCache+xml":"TODO","application/vnd.ms-excel.wsSortMap":"TODO","application/vnd.ms-excel.table":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml":"TODO","application/vnd.openxmlformats-officedocument.theme+xml":"themes","application/vnd.ms-excel.Timeline+xml":"TODO","application/vnd.ms-excel.TimelineCache+xml":"TODO","application/vnd.ms-office.vbaProject":"vba","application/vnd.ms-office.vbaProjectSignature":"vba","application/vnd.ms-office.volatileDependencies":"TODO","application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml":"TODO","application/vnd.ms-excel.controlproperties+xml":"TODO","application/vnd.openxmlformats-officedocument.model+data":"TODO","application/vnd.ms-excel.Survey+xml":"TODO","application/vnd.openxmlformats-officedocument.drawing+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.chart+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml":"TODO","application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml":"TODO","application/vnd.openxmlformats-officedocument.vmlDrawing":"TODO","application/vnd.openxmlformats-package.relationships+xml":"rels","application/vnd.openxmlformats-officedocument.oleObject":"TODO",sheet:"js"};
var CT_LIST=function(){var o={workbooks:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml",xlsm:"application/vnd.ms-excel.sheet.macroEnabled.main+xml",xlsb:"application/vnd.ms-excel.sheet.binary.macroEnabled.main",xltx:"application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml"},strs:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml",xlsb:"application/vnd.ms-excel.sharedStrings"},sheets:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml",xlsb:"application/vnd.ms-excel.worksheet"},styles:{xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml",xlsb:"application/vnd.ms-excel.styles"}};keys(o).forEach(function(k){if(!o[k].xlsm)o[k].xlsm=o[k].xlsx});keys(o).forEach(function(k){keys(o[k]).forEach(function(v){ct2type[o[k][v]]=k})});return o}();var type2ct=evert(ct2type,true);XMLNS.CT="http://schemas.openxmlformats.org/package/2006/content-types";function parse_ct(data,opts){var ctext={};if(!data||!data.match)return data;var ct={workbooks:[],sheets:[],calcchains:[],themes:[],styles:[],coreprops:[],extprops:[],custprops:[],strs:[],comments:[],vba:[],TODO:[],rels:[],xmlns:""};(data.match(/<[^>]*>/g)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0].replace(/<\w*:/,"<")){case"<?xml":break;case"<Types":ct.xmlns=y["xmlns"+(y[0].match(/<(\w+):/)||["",""])[1]];break;case"<Default":ctext[y.Extension]=y.ContentType;break;case"<Override":if(y.ContentType in ct2type)ct[ct2type[y.ContentType]].push(y.PartName);else if(opts.WTF)console.error(y);break}});if(ct.xmlns!==XMLNS.CT)throw new Error("Unknown Namespace: "+ct.xmlns);ct.calcchain=ct.calcchains.length>0?ct.calcchains[0]:"";ct.sst=ct.strs.length>0?ct.strs[0]:"";ct.style=ct.styles.length>0?ct.styles[0]:"";ct.defaults=ctext;delete ct.calcchains;return ct}var CTYPE_XML_ROOT=writextag("Types",null,{xmlns:XMLNS.CT,"xmlns:xsd":XMLNS.xsd,"xmlns:xsi":XMLNS.xsi});var CTYPE_DEFAULTS=[["xml","application/xml"],["rels",type2ct.rels[0]]].map(function(x){return writextag("Default",null,{Extension:x[0],ContentType:x[1]})});function write_ct(ct,opts){var o=[],v;o.push(XML_HEADER);o.push(CTYPE_XML_ROOT);o=o.concat(CTYPE_DEFAULTS);var f1=function(w){if(ct[w]&&ct[w].length>0){v=ct[w][0];o.push(writextag("Override",null,{PartName:(v[0]=="/"?"":"/")+v,ContentType:CT_LIST[w][opts.bookType||"xlsx"]}))}};var f2=function(w){ct[w].forEach(function(v){o.push(writextag("Override",null,{PartName:(v[0]=="/"?"":"/")+v,ContentType:CT_LIST[w][opts.bookType||"xlsx"]}))})};var f3=function(t){(ct[t]||[]).forEach(function(v){o.push(writextag("Override",null,{PartName:(v[0]=="/"?"":"/")+v,ContentType:type2ct[t][0]}))})};f1("workbooks");f2("sheets");f3("themes");["strs","styles"].forEach(f1);["coreprops","extprops","custprops"].forEach(f3);if(o.length>2){o.push("</Types>");o[1]=o[1].replace("/>",">")}return o.join("")}var RELS={WB:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument",SHEET:"http://sheetjs.openxmlformats.org/officeDocument/2006/relationships/officeDocument"};function parse_rels(data,currentFilePath){if(!data)return data;if(currentFilePath.charAt(0)!=="/"){currentFilePath="/"+currentFilePath}var rels={};var hash={};var resolveRelativePathIntoAbsolute=function(to){var toksFrom=currentFilePath.split("/");toksFrom.pop();var toksTo=to.split("/");var reversed=[];while(toksTo.length!==0){var tokTo=toksTo.shift();if(tokTo===".."){toksFrom.pop()}else if(tokTo!=="."){toksFrom.push(tokTo)}}return toksFrom.join("/")};data.match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);if(y[0]==="<Relationship"){var rel={};rel.Type=y.Type;rel.Target=y.Target;rel.Id=y.Id;rel.TargetMode=y.TargetMode;var canonictarget=y.TargetMode==="External"?y.Target:resolveRelativePathIntoAbsolute(y.Target);rels[canonictarget]=rel;hash[y.Id]=rel}});rels["!id"]=hash;return rels}XMLNS.RELS="http://schemas.openxmlformats.org/package/2006/relationships";var RELS_ROOT=writextag("Relationships",null,{xmlns:XMLNS.RELS});function write_rels(rels){var o=[];o.push(XML_HEADER);o.push(RELS_ROOT);keys(rels["!id"]).forEach(function(rid){var rel=rels["!id"][rid];o.push(writextag("Relationship",null,rel))});if(o.length>2){o.push("</Relationships>");o[1]=o[1].replace("/>",">")}return o.join("")}var CORE_PROPS=[["cp:category","Category"],["cp:contentStatus","ContentStatus"],["cp:keywords","Keywords"],["cp:lastModifiedBy","LastAuthor"],["cp:lastPrinted","LastPrinted"],["cp:revision","RevNumber"],["cp:version","Version"],["dc:creator","Author"],["dc:description","Comments"],["dc:identifier","Identifier"],["dc:language","Language"],["dc:subject","Subject"],["dc:title","Title"],["dcterms:created","CreatedDate","date"],["dcterms:modified","ModifiedDate","date"]];XMLNS.CORE_PROPS="http://schemas.openxmlformats.org/package/2006/metadata/core-properties";RELS.CORE_PROPS="http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties";function parse_core_props(data){var p={};CORE_PROPS.forEach(function(f){var g="(?:"+f[0].substr(0,f[0].indexOf(":"))+":)"+f[0].substr(f[0].indexOf(":")+1);var cur=data.match(new RegExp("<"+g+"[^>]*>(.*)</"+g+">"));if(cur&&cur.length>0)p[f[1]]=cur[1];if(f[2]==="date"&&p[f[1]])p[f[1]]=new Date(p[f[1]])});return p}var CORE_PROPS_XML_ROOT=writextag("cp:coreProperties",null,{"xmlns:cp":XMLNS.CORE_PROPS,"xmlns:dc":XMLNS.dc,"xmlns:dcterms":XMLNS.dcterms,"xmlns:dcmitype":XMLNS.dcmitype,"xmlns:xsi":XMLNS.xsi});function write_core_props(cp,opts){var o=[],p={};o.push(XML_HEADER);o.push(CORE_PROPS_XML_ROOT);if(!cp)return o.join("");var doit=function(f,g,h){if(p[f]||typeof g==="undefined"||g==="")return;if(typeof g!=="string")g=String(g);p[f]=g;o.push(h?writextag(f,g,h):writetag(f,g))};if(typeof cp.CreatedDate!=="undefined")doit("dcterms:created",typeof cp.CreatedDate==="string"?cp.CreatedDate:write_w3cdtf(cp.CreatedDate,opts.WTF),{"xsi:type":"dcterms:W3CDTF"});if(typeof cp.ModifiedDate!=="undefined")doit("dcterms:modified",typeof cp.ModifiedDate==="string"?cp.ModifiedDate:write_w3cdtf(cp.ModifiedDate,opts.WTF),{"xsi:type":"dcterms:W3CDTF"});CORE_PROPS.forEach(function(f){doit(f[0],cp[f[1]])});if(o.length>2){o.push("</cp:coreProperties>");o[1]=o[1].replace("/>",">")}return o.join("")}var EXT_PROPS=[["Application","Application","string"],["AppVersion","AppVersion","string"],["Company","Company","string"],["DocSecurity","DocSecurity","string"],["Manager","Manager","string"],["HyperlinksChanged","HyperlinksChanged","bool"],["SharedDoc","SharedDoc","bool"],["LinksUpToDate","LinksUpToDate","bool"],["ScaleCrop","ScaleCrop","bool"],["HeadingPairs","HeadingPairs","raw"],["TitlesOfParts","TitlesOfParts","raw"]];XMLNS.EXT_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/extended-properties";RELS.EXT_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties";function parse_ext_props(data,p){var q={};if(!p)p={};EXT_PROPS.forEach(function(f){switch(f[2]){case"string":p[f[1]]=(data.match(matchtag(f[0]))||[])[1];break;case"bool":p[f[1]]=(data.match(matchtag(f[0]))||[])[1]==="true";break;case"raw":var cur=data.match(new RegExp("<"+f[0]+"[^>]*>(.*)</"+f[0]+">"));if(cur&&cur.length>0)q[f[1]]=cur[1];break}});if(q.HeadingPairs&&q.TitlesOfParts){var v=parseVector(q.HeadingPairs);var j=0,widx=0;for(var i=0;i!==v.length;++i){switch(v[i].v){case"Worksheets":widx=j;p.Worksheets=+v[++i].v;break;case"Named Ranges":++i;break}}var parts=parseVector(q.TitlesOfParts).map(function(x){return utf8read(x.v)});p.SheetNames=parts.slice(widx,widx+p.Worksheets)}return p}var EXT_PROPS_XML_ROOT=writextag("Properties",null,{xmlns:XMLNS.EXT_PROPS,"xmlns:vt":XMLNS.vt});function write_ext_props(cp,opts){var o=[],p={},W=writextag;if(!cp)cp={};cp.Application="SheetJS";o.push(XML_HEADER);o.push(EXT_PROPS_XML_ROOT);EXT_PROPS.forEach(function(f){if(typeof cp[f[1]]==="undefined")return;var v;switch(f[2]){case"string":v=cp[f[1]];break;case"bool":v=cp[f[1]]?"true":"false";break}if(typeof v!=="undefined")o.push(W(f[0],v))});o.push(W("HeadingPairs",W("vt:vector",W("vt:variant","<vt:lpstr>Worksheets</vt:lpstr>")+W("vt:variant",W("vt:i4",String(cp.Worksheets))),{size:2,baseType:"variant"})));o.push(W("TitlesOfParts",W("vt:vector",cp.SheetNames.map(function(s){return"<vt:lpstr>"+s+"</vt:lpstr>"}).join(""),{size:cp.Worksheets,baseType:"lpstr"})));if(o.length>2){o.push("</Properties>");o[1]=o[1].replace("/>",">")}return o.join("")}XMLNS.CUST_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/custom-properties";RELS.CUST_PROPS="http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties";function parse_cust_props(data,opts){var p={},name;data.match(/<[^>]+>([^<]*)/g).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<?xml":break;case"<Properties":if(y.xmlns!==XMLNS.CUST_PROPS)throw"unrecognized xmlns "+y.xmlns;if(y.xmlnsvt&&y.xmlnsvt!==XMLNS.vt)throw"unrecognized vt "+y.xmlnsvt;break;case"<property":name=y.name;break;case"</property>":name=null;break;default:if(x.indexOf("<vt:")===0){var toks=x.split(">");var type=toks[0].substring(4),text=toks[1];switch(type){case"lpstr":case"lpwstr":case"bstr":case"lpwstr":p[name]=unescapexml(text);break;case"bool":p[name]=parsexmlbool(text,"<vt:bool>");break;case"i1":case"i2":case"i4":case"i8":case"int":case"uint":p[name]=parseInt(text,10);break;case"r4":case"r8":case"decimal":p[name]=parseFloat(text);break;case"filetime":case"date":p[name]=new Date(text);break;case"cy":case"error":p[name]=unescapexml(text);break;default:console.warn("Unexpected",x,type,toks)}}else if(x.substr(0,2)==="</"){}else if(opts.WTF)throw new Error(x)}});return p}var CUST_PROPS_XML_ROOT=writextag("Properties",null,{xmlns:XMLNS.CUST_PROPS,"xmlns:vt":XMLNS.vt});function write_cust_props(cp,opts){var o=[],p={};o.push(XML_HEADER);o.push(CUST_PROPS_XML_ROOT);if(!cp)return o.join("");var pid=1;keys(cp).forEach(function(k){++pid;o.push(writextag("property",write_vt(cp[k]),{fmtid:"{D5CDD505-2E9C-101B-9397-08002B2CF9AE}",pid:pid,name:k}))});if(o.length>2){o.push("</Properties>");o[1]=o[1].replace("/>",">")}return o.join("")}var CS2CP={0:1252,1:65001,2:65001,77:1e4,128:932,129:949,130:1361,134:936,136:950,161:1253,162:1254,163:1258,177:1255,178:1256,186:1257,204:1251,222:874,238:1250,255:1252,69:6969};var parse_rs=function(){var tregex=matchtag("t"),rpregex=matchtag("rPr");var parse_rpr=function(rpr,intro,outro){var font={},cp=65001;(rpr.match(/<[^>]*>/g)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<condense":break;case"<extend":break;case"<shadow":case"<shadow/>":break;case"<charset":if(y.val=="1")break;cp=CS2CP[parseInt(y.val,10)];break;case"<outline":case"<outline/>":break;case"<rFont":font.name=y.val;break;case"<sz":font.sz=y.val;break;case"<strike":if(!y.val)break;case"<strike/>":font.strike=1;break;case"</strike>":break;case"<u":if(!y.val)break;case"<u/>":font.u=1;break;case"</u>":break;case"<b":if(!y.val)break;case"<b/>":font.b=1;break;case"</b>":break;case"<i":if(!y.val)break;case"<i/>":font.i=1;break;case"</i>":break;case"<color":if(y.rgb)font.color=y.rgb.substr(2,6);break;case"<family":font.family=y.val;break;case"<vertAlign":break;case"<scheme":break;default:if(y[0][2]!=="/")throw"Unrecognized rich format "+y[0]}});var style=[];if(font.b)style.push("font-weight: bold;");if(font.i)style.push("font-style: italic;");intro.push('<span style="'+style.join("")+'">');outro.push("</span>");return cp};function parse_r(r){var terms=[[],"",[]];var t=r.match(tregex),cp=65001;if(!isval(t))return"";terms[1]=t[1];var rpr=r.match(rpregex);if(isval(rpr))cp=parse_rpr(rpr[1],terms[0],terms[2]);return terms[0].join("")+terms[1].replace(/\r\n/g,"<br/>")+terms[2].join("")}return function(rs){return rs.replace(/<r>/g,"").split(/<\/r>/).map(parse_r).join("")}}();var parse_si=function(x,opts){var html=opts?opts.cellHTML:true;var z={};if(!x)return null;var y;if(x[1]==="t"){z.t=utf8read(unescapexml(x.substr(x.indexOf(">")+1).split(/<\/t>/)[0]));z.r=x;if(html)z.h=z.t}else if(y=x.match(/<r>/)){z.r=x;z.t=utf8read(unescapexml(x.replace(/<[^>]*>/gm,"")));if(html)z.h=parse_rs(x)}return z};var parse_sst_xml=function(data,opts){var s=[];var sst=data.match(new RegExp("<sst([^>]*)>([\\s\\S]*)</sst>","m"));if(isval(sst)){s=sst[2].replace(/<(?:si|sstItem)>/g,"").split(/<\/(?:si|sstItem)>/).map(function(x){return parse_si(x,opts)}).filter(function(x){return x});sst=parsexmltag(sst[1]);s.Count=sst.count;s.Unique=sst.uniqueCount}return s};RELS.SST="http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings";var write_sst_xml=function(sst,opts){if(!opts.bookSST)return"";var o=[];o.push(XML_HEADER);o.push(writextag("sst",null,{xmlns:XMLNS.main[0],count:sst.Count,uniqueCount:sst.Unique}));sst.forEach(function(s){var sitag="<si>";if(s.r)sitag+=s.r;else{sitag+="<t";if(s.t.match(/^\s|\s$|[\t\n\r]/))sitag+=' xml:space="preserve"';sitag+=">";sitag+=escapexml(s.t);sitag+="</t>"}sitag+="</si>";o.push(sitag)});if(o.length>2){o.push("</sst>");o[1]=o[1].replace("/>",">")}return o.join("")};var parse_BrtBeginSst=function(data,length){return[data.read_shift(4),data.read_shift(4)]};var parse_sst_bin=function(data,opts){var s=[];var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtBeginSst":s.Count=val[0];s.Unique=val[1];break;case"BrtSSTItem":s.push(val);break;case"BrtEndSst":return true;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return s};var write_sst_bin=function(sst,opts){};var styles={};function parse_numFmts(t,opts){styles.NumberFmt=[];for(var y in SSF._table)styles.NumberFmt[y]=SSF._table[y];t[0].match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<numFmts":case"</numFmts>":case"<numFmts/>":case"<numFmts>":break;case"<numFmt":{var f=unescapexml(y.formatCode),i=parseInt(y.numFmtId,10);styles.NumberFmt[i]=f;if(i>0)SSF.load(f,i)}break;default:if(opts.WTF)throw"unrecognized "+y[0]+" in numFmts"}})}function write_numFmts(NF,opts){var o=[];o.push("<numFmts>");[[5,8],[23,26],[41,44],[63,66],[164,392]].forEach(function(r){for(var i=r[0];i<=r[1];++i)if(NF[i])o.push(writextag("numFmt",null,{numFmtId:i,formatCode:escapexml(NF[i])}))});o.push("</numFmts>");if(o.length===2)return"";o[0]=writextag("numFmts",null,{count:o.length-2}).replace("/>",">");return o.join("")}function parse_cellXfs(t,opts){styles.CellXf=[];t[0].match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<cellXfs":case"<cellXfs>":case"<cellXfs/>":case"</cellXfs>":break;case"<xf":delete y[0];if(y.numFmtId)y.numFmtId=parseInt(y.numFmtId,10);styles.CellXf.push(y);break;case"</xf>":break;case"<alignment":case"<alignment/>":break;case"<protection":case"</protection>":case"<protection/>":break;case"<extLst":case"</extLst>":break;case"<ext":break;default:if(opts.WTF)throw"unrecognized "+y[0]+" in cellXfs"}})}function write_cellXfs(cellXfs){var o=[];o.push(writextag("cellXfs",null));cellXfs.forEach(function(c){o.push(writextag("xf",null,c))});o.push("</cellXfs>");if(o.length===2)return"";o[0]=writextag("cellXfs",null,{count:o.length-2}).replace("/>",">");return o.join("")}function parse_sty_xml(data,opts){var t;if(t=data.match(/<numFmts([^>]*)>.*<\/numFmts>/))parse_numFmts(t,opts);if(t=data.match(/<cellXfs([^>]*)>.*<\/cellXfs>/))parse_cellXfs(t,opts);return styles}var STYLES_XML_ROOT=writextag("styleSheet",null,{xmlns:XMLNS.main[0],"xmlns:vt":XMLNS.vt});RELS.STY="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles";function write_sty_xml(wb,opts){var o=[],p={},W=writextag,w;o.push(XML_HEADER);o.push(STYLES_XML_ROOT);if(w=write_numFmts(wb.SSF))o.push(w);o.push('<fonts count="1"><font><sz val="12"/><color theme="1"/><name val="Calibri"/><family val="2"/><scheme val="minor"/></font></fonts>');o.push('<fills count="2"><fill><patternFill patternType="none"/></fill><fill><patternFill patternType="gray125"/></fill></fills>');o.push('<borders count="1"><border><left/><right/><top/><bottom/><diagonal/></border></borders>');o.push('<cellStyleXfs count="1"><xf numFmtId="0" fontId="0" fillId="0" borderId="0"/></cellStyleXfs>');if(w=write_cellXfs(opts.cellXfs))o.push(w);o.push('<cellStyles count="1"><cellStyle name="Normal" xfId="0" builtinId="0"/></cellStyles>');o.push('<dxfs count="0"/>');o.push('<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4"/>');if(o.length>2){o.push("</styleSheet>");o[1]=o[1].replace("/>",">")}return o.join("")}function parse_BrtFmt(data,length){var ifmt=data.read_shift(2);var stFmtCode=parse_XLWideString(data,length-2);return[ifmt,stFmtCode]}function parse_BrtFont(data,length){var read=data.read_shift.bind(data);var out={flags:{}};out.dyHeight=read(2);out.grbit=parse_FontFlags(data,2);out.bls=read(2);out.sss=read(2);out.uls=read(1);out.bFamily=read(1);out.bCharSet=read(1);data.l++;out.brtColor=parse_BrtColor(data,8);out.bFontScheme=read(1);out.name=parse_XLWideString(data,length-21);out.flags.Bold=out.bls===700;out.flags.Italic=out.grbit.fItalic;out.flags.Strikeout=out.grbit.fStrikeout;out.flags.Outline=out.grbit.fOutline;out.flags.Shadow=out.grbit.fShadow;out.flags.Condense=out.grbit.fCondense;out.flags.Extend=out.grbit.fExtend;out.flags.Sub=out.sss&2;out.flags.Sup=out.sss&1;return out}function parse_BrtXF(data,length){var ixfeParent=data.read_shift(2);var ifmt=data.read_shift(2);parsenoop(data,length-4);return{ixfe:ixfeParent,ifmt:ifmt}}function parse_sty_bin(data,opts){styles.NumberFmt=[];for(var y in SSF._table)styles.NumberFmt[y]=SSF._table[y];styles.CellXf=[];var state="";var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtFmt":styles.NumberFmt[val[0]]=val[1];SSF.load(val[1],val[0]);break;case"BrtFont":break;case"BrtKnownFonts":break;case"BrtFill":break;case"BrtBorder":break;case"BrtXF":if(state==="CELLXFS"){styles.CellXf.push(val)}break;case"BrtStyle":break;case"BrtRowHdr":break;case"BrtCellMeta":break;case"BrtDXF":break;case"BrtMRUColor":break;case"BrtIndexedColor":break;case"BrtBeginStyleSheet":break;case"BrtEndStyleSheet":break;case"BrtBeginTableStyle":break;case"BrtTableStyleElement":break;case"BrtEndTableStyle":break;case"BrtBeginFmts":state="FMTS";break;case"BrtEndFmts":state="";break;case"BrtBeginFonts":state="FONTS";break;case"BrtEndFonts":state="";break;case"BrtACBegin":state="ACFONTS";break;case"BrtACEnd":state="";break;case"BrtBeginFills":state="FILLS";break;case"BrtEndFills":state="";break;case"BrtBeginBorders":state="BORDERS";break;case"BrtEndBorders":state="";break;case"BrtBeginCellStyleXFs":state="CELLSTYLEXFS";break;case"BrtEndCellStyleXFs":state="";break;case"BrtBeginCellXFs":state="CELLXFS";break;case"BrtEndCellXFs":state="";break;case"BrtBeginStyles":state="STYLES";break;case"BrtEndStyles":state="";break;case"BrtBeginDXFs":state="DXFS";break;case"BrtEndDXFs":state="";break;case"BrtBeginTableStyles":state="TABLESTYLES";break;case"BrtEndTableStyles":state="";break;case"BrtBeginColorPalette":state="COLORPALETTE";break;case"BrtEndColorPalette":state="";break;case"BrtBeginIndexedColors":state="INDEXEDCOLORS";break;case"BrtEndIndexedColors":state="";break;case"BrtBeginMRUColors":state="MRUCOLORS";break;case"BrtEndMRUColors":state="";break;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;case"BrtBeginStyleSheetExt14":break;case"BrtBeginSlicerStyles":break;case"BrtEndSlicerStyles":break;case"BrtBeginTimelineStylesheetExt15":break;case"BrtEndTimelineStylesheetExt15":break;case"BrtBeginTimelineStyles":break;case"BrtEndTimelineStyles":break;case"BrtEndStyleSheetExt14":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return styles}RELS.THEME="http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme";function write_theme(){return'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\n<a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Office Theme"><a:themeElements><a:clrScheme name="Office"><a:dk1><a:sysClr val="windowText" lastClr="000000"/></a:dk1><a:lt1><a:sysClr val="window" lastClr="FFFFFF"/></a:lt1><a:dk2><a:srgbClr val="1F497D"/></a:dk2><a:lt2><a:srgbClr val="EEECE1"/></a:lt2><a:accent1><a:srgbClr val="4F81BD"/></a:accent1><a:accent2><a:srgbClr val="C0504D"/></a:accent2><a:accent3><a:srgbClr val="9BBB59"/></a:accent3><a:accent4><a:srgbClr val="8064A2"/></a:accent4><a:accent5><a:srgbClr val="4BACC6"/></a:accent5><a:accent6><a:srgbClr val="F79646"/></a:accent6><a:hlink><a:srgbClr val="0000FF"/></a:hlink><a:folHlink><a:srgbClr val="800080"/></a:folHlink></a:clrScheme><a:fontScheme name="Office"><a:majorFont><a:latin typeface="Cambria"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="宋体"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Times New Roman"/><a:font script="Hebr" typeface="Times New Roman"/><a:font script="Thai" typeface="Tahoma"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="MoolBoran"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Times New Roman"/><a:font script="Uigh" typeface="Microsoft Uighur"/><a:font script="Geor" typeface="Sylfaen"/></a:majorFont><a:minorFont><a:latin typeface="Calibri"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="宋体"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Arial"/><a:font script="Hebr" typeface="Arial"/><a:font script="Thai" typeface="Tahoma"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="DaunPenh"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Arial"/><a:font script="Uigh" typeface="Microsoft Uighur"/><a:font script="Geor" typeface="Sylfaen"/></a:minorFont></a:fontScheme><a:fmtScheme name="Office"><a:fillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="50000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="35000"><a:schemeClr val="phClr"><a:tint val="37000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:tint val="15000"/><a:satMod val="350000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="16200000" scaled="1"/></a:gradFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="100000"/><a:shade val="100000"/><a:satMod val="130000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:tint val="50000"/><a:shade val="100000"/><a:satMod val="350000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="16200000" scaled="0"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w="9525" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"><a:shade val="95000"/><a:satMod val="105000"/></a:schemeClr></a:solidFill><a:prstDash val="solid"/></a:ln><a:ln w="25400" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln><a:ln w="38100" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="20000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="38000"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw></a:effectLst><a:scene3d><a:camera prst="orthographicFront"><a:rot lat="0" lon="0" rev="0"/></a:camera><a:lightRig rig="threePt" dir="t"><a:rot lat="0" lon="0" rev="1200000"/></a:lightRig></a:scene3d><a:sp3d><a:bevelT w="63500" h="25400"/></a:sp3d></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="40000"/><a:satMod val="350000"/></a:schemeClr></a:gs><a:gs pos="40000"><a:schemeClr val="phClr"><a:tint val="45000"/><a:shade val="99000"/><a:satMod val="350000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="20000"/><a:satMod val="255000"/></a:schemeClr></a:gs></a:gsLst><a:path path="circle"><a:fillToRect l="50000" t="-80000" r="50000" b="180000"/></a:path></a:gradFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="80000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="30000"/><a:satMod val="200000"/></a:schemeClr></a:gs></a:gsLst><a:path path="circle"><a:fillToRect l="50000" t="50000" r="50000" b="50000"/></a:path></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults><a:spDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx="1"><a:schemeClr val="accent1"/></a:lnRef><a:fillRef idx="3"><a:schemeClr val="accent1"/></a:fillRef><a:effectRef idx="2"><a:schemeClr val="accent1"/></a:effectRef><a:fontRef idx="minor"><a:schemeClr val="lt1"/></a:fontRef></a:style></a:spDef><a:lnDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx="2"><a:schemeClr val="accent1"/></a:lnRef><a:fillRef idx="0"><a:schemeClr val="accent1"/></a:fillRef><a:effectRef idx="1"><a:schemeClr val="accent1"/></a:effectRef><a:fontRef idx="minor"><a:schemeClr val="tx1"/></a:fontRef></a:style></a:lnDef></a:objectDefaults><a:extraClrSchemeLst/></a:theme>'}function parse_cc_xml(data,opts){var d=[];var l=0,i=1;(data.match(/<[^>]*>/g)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case"<?xml":break;case"<calcChain":case"<calcChain>":case"</calcChain>":break;case"<c":delete y[0];if(y.i)i=y.i;else y.i=i;d.push(y);break}});return d}var parse_BrtCalcChainItem$=function(data,length){var out={};out.i=data.read_shift(4);var cell={};cell.r=data.read_shift(4);cell.c=data.read_shift(4);out.r=encode_cell(cell);var flags=data.read_shift(1);if(flags&2)out.l="1";if(flags&8)out.a="1";return out};function parse_cc_bin(data,opts){var out=[];var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtCalcChainItem$":out.push(val);break;case"BrtBeginCalcChain$":break;case"BrtEndCalcChain$":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return out}function parse_comments_xml(data,opts){if(data.match(/<(?:\w+:)?comments *\/>/))return[];var authors=[];var commentList=[];data.match(/<(?:\w+:)?authors>([^\u2603]*)<\/(?:\w+:)?authors>/m)[1].split(/<\/(?:\w+:)?author>/).forEach(function(x){if(x===""||x.trim()==="")return;authors.push(x.match(/<(?:\w+:)?author[^>]*>(.*)/)[1])});(data.match(/<(?:\w+:)?commentList>([^\u2603]*)<\/(?:\w+:)?commentList>/m)||["",""])[1].split(/<\/(?:\w+:)?comment>/).forEach(function(x,index){if(x===""||x.trim()==="")return;var y=parsexmltag(x.match(/<(?:\w+:)?comment[^>]*>/)[0]);var comment={author:y.authorId&&authors[y.authorId]?authors[y.authorId]:undefined,ref:y.ref,guid:y.guid};var cell=decode_cell(y.ref);if(opts.sheetRows&&opts.sheetRows<=cell.r)return;var textMatch=x.match(/<text>([^\u2603]*)<\/text>/m);if(!textMatch||!textMatch[1])return;var rt=parse_si(textMatch[1]);comment.r=rt.r;comment.t=rt.t;if(opts.cellHTML)comment.h=rt.h;commentList.push(comment)});return commentList}var parse_BrtBeginComment=function(data,length){var out={};out.iauthor=data.read_shift(4);var rfx=parse_UncheckedRfX(data,16);out.rfx=rfx.s;out.ref=encode_cell(rfx.s);data.l+=16;return out};var parse_BrtCommentAuthor=parse_XLWideString;var parse_BrtCommentText=parse_RichStr;function parse_comments_bin(data,opts){var out=[];var authors=[];var c={};var pass=false;recordhopper(data,function(val,R,RT){switch(R.n){case"BrtCommentAuthor":authors.push(val);break;case"BrtBeginComment":c=val;break;case"BrtCommentText":c.t=val.t;c.h=val.h;c.r=val.r;break;case"BrtEndComment":c.author=authors[c.iauthor];delete c.iauthor;if(opts.sheetRows&&opts.sheetRows<=c.rfx.r)break;delete c.rfx;out.push(c);break;case"BrtBeginComments":break;case"BrtEndComments":break;case"BrtBeginCommentAuthors":break;case"BrtEndCommentAuthors":break;case"BrtBeginCommentList":break;case"BrtEndCommentList":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+RT+" "+R.n)}});return out}function parse_comments(zip,dirComments,sheets,sheetRels,opts){for(var i=0;i!=dirComments.length;++i){var canonicalpath=dirComments[i];var comments=parse_cmnt(getzipdata(zip,canonicalpath.replace(/^\//,""),true),canonicalpath,opts);if(!comments||!comments.length)continue;var sheetNames=keys(sheets);for(var j=0;j!=sheetNames.length;++j){var sheetName=sheetNames[j];var rels=sheetRels[sheetName];if(rels){var rel=rels[canonicalpath];if(rel)insertCommentsIntoSheet(sheetName,sheets[sheetName],comments)}}}}function insertCommentsIntoSheet(sheetName,sheet,comments){comments.forEach(function(comment){var cell=sheet[comment.ref];if(!cell){cell={};sheet[comment.ref]=cell;var range=decode_range(sheet["!ref"]||"BDWGO1000001:A1");var thisCell=decode_cell(comment.ref);if(range.s.r>thisCell.r)range.s.r=thisCell.r;if(range.e.r<thisCell.r)range.e.r=thisCell.r;if(range.s.c>thisCell.c)range.s.c=thisCell.c;if(range.e.c<thisCell.c)range.e.c=thisCell.c;var encoded=encode_range(range);if(encoded!==sheet["!ref"])sheet["!ref"]=encoded}if(!cell.c)cell.c=[];var o={a:comment.author,t:comment.t,r:comment.r};if(comment.h)o.h=comment.h;cell.c.push(o)})}var parse_CellParsedFormula=function(data,length){var cce=data.read_shift(4);return parsenoop(data,length-4)};var strs={};var _ssfopts={};RELS.WS="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet";function get_sst_id(sst,str){for(var i=0;i!=sst.length;++i)if(sst[i].t===str){sst.Count++;return i}sst[sst.length]={t:str};sst.Count++;sst.Unique++;return sst.length-1}function get_cell_style(styles,cell,opts){var z=opts.revssf[cell.z||"General"];for(var i=0;i!=styles.length;++i)if(styles[i].numFmtId===z)return i;styles[styles.length]={numFmtId:z,fontId:0,fillId:0,borderId:0,xfId:0,applyNumberFormat:1};return styles.length-1}function parse_ws_xml(data,opts,rels){if(!data)return data;
var s={},mtch;var ref=data.match(/<dimension ref="([^"]*)"\s*\/>/);if(ref&&ref.length==2&&ref[1].indexOf(":")!==-1)s["!ref"]=ref[1];var mergecells=[];if(data.match(/<\/mergeCells>/)){var merges=data.match(/<mergeCell ref="([A-Z0-9:]+)"\s*\/>/g);mergecells=merges.map(function(range){return decode_range(/<mergeCell ref="([A-Z0-9:]+)"\s*\/>/.exec(range)[1])})}var refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};var q=["v","f"];var sidx=0;if(mtch=data.match(/<(?:\w+:)?sheetData>([^\u2603]*)<\/(?:\w+:)?sheetData>/m))mtch[1].split(/<\/(?:\w+:)?row>/).forEach(function(x){if(x===""||x.trim()==="")return;var row=parsexmltag(x.match(/<(?:\w+:)?row[^>]*>/)[0]);if(opts.sheetRows&&opts.sheetRows<+row.r)return;if(refguess.s.r>row.r-1)refguess.s.r=row.r-1;if(refguess.e.r<row.r-1)refguess.e.r=row.r-1;var cells=x.substr(x.indexOf(">")+1).split(/<(?:\w+:)?c /);cells.forEach(function(c,idx){if(c===""||c.trim()==="")return;var cref=c.match(/r=["']([^"']*)["']/);c="<c "+c;if(cref&&cref.length==2)idx=decode_cell(cref[1]).c;var cell=parsexmltag((c.match(/<c[^>]*>/)||[c])[0]);delete cell[0];var d=c.substr(c.indexOf(">")+1);var p={};q.forEach(function(f){var x=d.match(matchtag(f));if(x)p[f]=unescapexml(x[1])});if(cell.t===undefined&&p.v===undefined){if(!opts.sheetStubs)return;p.t="str";p.v=undefined}else p.t=cell.t?cell.t:"n";if(refguess.s.c>idx)refguess.s.c=idx;if(refguess.e.c<idx)refguess.e.c=idx;switch(p.t){case"n":p.v=parseFloat(p.v);break;case"s":{sidx=parseInt(p.v,10);p.v=strs[sidx].t;p.r=strs[sidx].r;if(opts.cellHTML)p.h=strs[sidx].h}break;case"str":if(p.v)p.v=utf8read(p.v);break;case"inlineStr":var is=d.match(/<is>(.*)<\/is>/);is=is?parse_si(is[1]):{t:"",r:""};p.t="str";p.v=is.t;break;case"b":if(typeof p.v!=="boolean")p.v=parsexmlbool(p.v);break;case"d":p.v=datenum(p.v);p.t="n";break;case"e":p.raw=RBErr[p.v];break}var fmtid=0;if(cell.s&&styles.CellXf){var cf=styles.CellXf[cell.s];if(cf&&cf.numFmtId)fmtid=cf.numFmtId}try{p.w=SSF.format(fmtid,p.v,_ssfopts);if(opts.cellNF)p.z=SSF._table[fmtid]}catch(e){if(opts.WTF)throw e}s[cell.r]=p})});if(data.match(/<\/hyperlinks>/))data.match(/<hyperlink[^>]*\/>/g).forEach(function(h){var val=parsexmltag(h);delete val[0];if(!val.ref)return;var rel=rels["!id"][val.id];if(rel){val.Target=rel.Target;if(val.location)val.Target+="#"+val.location;val.Rel=rel}var rng=decode_range(val.ref);for(var R=rng.s.r;R<=rng.e.r;++R)for(var C=rng.s.c;C<=rng.e.c;++C){var addr=encode_cell({c:C,r:R});if(!s[addr])s[addr]={t:"str",v:undefined};s[addr].l=val}});if(!s["!ref"]&&refguess.e.c>=refguess.s.c&&refguess.e.r>=refguess.s.r)s["!ref"]=encode_range(refguess);if(opts.sheetRows&&s["!ref"]){var tmpref=decode_range(s["!ref"]);if(opts.sheetRows<+tmpref.e.r){tmpref.e.r=opts.sheetRows-1;if(tmpref.e.r>refguess.e.r)tmpref.e.r=refguess.e.r;if(tmpref.e.r<tmpref.s.r)tmpref.s.r=tmpref.e.r;if(tmpref.e.c>refguess.e.c)tmpref.e.c=refguess.e.c;if(tmpref.e.c<tmpref.s.c)tmpref.s.c=tmpref.e.c;s["!fullref"]=s["!ref"];s["!ref"]=encode_range(tmpref)}}if(mergecells.length>0)s["!merges"]=mergecells;return s}var WS_XML_ROOT=writextag("worksheet",null,{xmlns:XMLNS.main[0],"xmlns:r":XMLNS.r});var write_ws_xml_cell=function(cell,ref,ws,opts,idx,wb){var vv=cell.v;if(cell.t=="b")vv=cell.v?"1":"0";var v=writextag("v",escapexml(String(vv))),o={r:ref};o.s=get_cell_style(opts.cellXfs,cell,opts);if(o.s===0||o.s==="0")delete o.s;if(typeof cell.v==="undefined")return"";switch(cell.t){case"s":case"str":{if(opts.bookSST){v=writextag("v",String(get_sst_id(opts.Strings,cell.v)));o.t="s";return writextag("c",v,o)}else{o.t="str";return writextag("c",v,o)}}break;case"n":delete o.t;return writextag("c",v,o);case"b":o.t="b";return writextag("c",v,o);case"e":o.t="e";return writextag("c",v,o)}};var write_ws_xml_data=function(ws,opts,idx,wb){var o=[],r=[],range=utils.decode_range(ws["!ref"]),cell,ref;for(var R=range.s.r;R<=range.e.r;++R){r=[];for(var C=range.s.c;C<=range.e.c;++C){ref=utils.encode_cell({c:C,r:R});if(!ws[ref])continue;if(cell=write_ws_xml_cell(ws[ref],ref,ws,opts,idx,wb))r.push(cell)}if(r.length)o.push(writextag("row",r.join(""),{r:encode_row(R)}))}return o.join("")};var write_ws_xml=function(idx,opts,wb){var o=[],s=wb.SheetNames[idx],ws=wb.Sheets[s]||{},sidx=0,rdata="";o.push(XML_HEADER);o.push(WS_XML_ROOT);o.push(writextag("dimension",null,{ref:ws["!ref"]||"A1"}));sidx=o.length;o.push(writextag("sheetData",null));if(ws["!ref"])rdata=write_ws_xml_data(ws,opts,idx,wb);if(rdata.length)o.push(rdata);if(o.length>sidx+1){o.push("</sheetData>");o[sidx]=o[sidx].replace("/>",">")}if(o.length>2){o.push("</worksheet>");o[1]=o[1].replace("/>",">")}return o.join("")};var parse_BrtRowHdr=function(data,length){var z={};z.r=data.read_shift(4);data.l+=length-4;return z};var parse_BrtWsDim=parse_UncheckedRfX;var parse_BrtWsProp=function(data,length){var z={};data.l+=19;z.name=parse_CodeName(data,length-19);return z};var parse_BrtCellBlank=function(data,length){var cell=parse_Cell(data);return[cell]};var parse_BrtCellBool=function(data,length){var cell=parse_Cell(data);var fBool=data.read_shift(1);return[cell,fBool,"b"]};var parse_BrtCellError=function(data,length){var cell=parse_Cell(data);var fBool=data.read_shift(1);return[cell,fBool,"e"]};var parse_BrtCellIsst=function(data,length){var cell=parse_Cell(data);var isst=data.read_shift(4);return[cell,isst,"s"]};var parse_BrtCellReal=function(data,length){var cell=parse_Cell(data);var value=parse_Xnum(data);return[cell,value,"n"]};var parse_BrtCellRk=function(data,length){var cell=parse_Cell(data);var value=parse_RkNumber(data);return[cell,value,"n"]};var parse_BrtCellSt=function(data,length){var cell=parse_Cell(data);var value=parse_XLWideString(data);return[cell,value,"str"]};var parse_BrtFmlaBool=function(data,length,opts){var cell=parse_Cell(data);var value=data.read_shift(1);var o=[cell,value,"b"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,length-9);o[3]=""}else data.l+=length-9;return o};var parse_BrtFmlaError=function(data,length,opts){var cell=parse_Cell(data);var value=data.read_shift(1);var o=[cell,value,"e"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,length-9);o[3]=""}else data.l+=length-9;return o};var parse_BrtFmlaNum=function(data,length,opts){var cell=parse_Cell(data);var value=parse_Xnum(data);var o=[cell,value,"n"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,length-16);o[3]=""}else data.l+=length-16;return o};var parse_BrtFmlaString=function(data,length,opts){var start=data.l;var cell=parse_Cell(data);var value=parse_XLWideString(data);var o=[cell,value,"str"];if(opts.cellFormula){var formula=parse_CellParsedFormula(data,start+length-data.l);o[3]=""}else data.l=start+length;return o};var parse_BrtMergeCell=parse_UncheckedRfX;var parse_BrtHLink=function(data,length,opts){var end=data.l+length;var rfx=parse_UncheckedRfX(data,16);var relId=parse_XLNullableWideString(data);var loc=parse_XLWideString(data);var tooltip=parse_XLWideString(data);var display=parse_XLWideString(data);data.l=end;return{rfx:rfx,relId:relId,loc:loc,tooltip:tooltip,display:display}};var parse_ws_bin=function(data,opts,rels){if(!data)return data;if(!rels)rels={"!id":{}};var s={};var ref;var refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};var pass=false,end=false;var row,p,cf,R,C,addr;var mergecells=[];recordhopper(data,function(val,R){if(end)return;switch(R.n){case"BrtWsDim":ref=val;break;case"BrtRowHdr":row=val;if(opts.sheetRows&&opts.sheetRows<=row.r)end=true;break;case"BrtFmlaBool":case"BrtFmlaError":case"BrtFmlaNum":case"BrtFmlaString":case"BrtCellBool":case"BrtCellError":case"BrtCellIsst":case"BrtCellReal":case"BrtCellRk":case"BrtCellSt":p={t:val[2]};switch(val[2]){case"n":p.v=val[1];break;case"s":p.v=strs[val[1]].t;p.r=strs[val[1]].r;break;case"b":p.v=val[1]?true:false;break;case"e":p.raw=val[1];p.v=BErr[p.raw];break;case"str":p.v=utf8read(val[1]);break}if(opts.cellFormula&&val.length>3)p.f=val[3];if(cf=styles.CellXf[val[0].iStyleRef])try{p.w=SSF.format(cf.ifmt,p.v,_ssfopts);if(opts.cellNF)p.z=SSF._table[cf.ifmt]}catch(e){if(opts.WTF)throw e}s[encode_cell({c:val[0].c,r:row.r})]=p;if(refguess.s.r>row.r)refguess.s.r=row.r;if(refguess.s.c>val[0].c)refguess.s.c=val[0].c;if(refguess.e.r<row.r)refguess.e.r=row.r;if(refguess.e.c<val[0].c)refguess.e.c=val[0].c;break;case"BrtCellBlank":if(!opts.sheetStubs)break;p={t:"str",v:undefined};s[encode_cell({c:val[0].c,r:row.r})]=p;if(refguess.s.r>row.r)refguess.s.r=row.r;if(refguess.s.c>val[0].c)refguess.s.c=val[0].c;if(refguess.e.r<row.r)refguess.e.r=row.r;if(refguess.e.c<val[0].c)refguess.e.c=val[0].c;break;case"BrtBeginMergeCells":break;case"BrtEndMergeCells":break;case"BrtMergeCell":mergecells.push(val);break;case"BrtHLink":var rel=rels["!id"][val.relId];if(rel){val.Target=rel.Target;if(val.loc)val.Target+="#"+val.loc;val.Rel=rel}for(R=val.rfx.s.r;R<=val.rfx.e.r;++R)for(C=val.rfx.s.c;C<=val.rfx.e.c;++C){addr=encode_cell({c:C,r:R});if(!s[addr])s[addr]={t:"str",v:undefined};s[addr].l=val}break;case"BrtArrFmla":break;case"BrtShrFmla":break;case"BrtBeginSheet":break;case"BrtWsProp":break;case"BrtSheetCalcProp":break;case"BrtBeginWsViews":break;case"BrtBeginWsView":break;case"BrtPane":break;case"BrtSel":break;case"BrtEndWsView":break;case"BrtEndWsViews":break;case"BrtACBegin":break;case"BrtRwDescent":break;case"BrtACEnd":break;case"BrtWsFmtInfoEx14":break;case"BrtWsFmtInfo":break;case"BrtBeginColInfos":break;case"BrtColInfo":break;case"BrtEndColInfos":break;case"BrtBeginSheetData":break;case"BrtEndSheetData":break;case"BrtSheetProtection":break;case"BrtPrintOptions":break;case"BrtMargins":break;case"BrtPageSetup":break;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;case"BrtEndSheet":break;case"BrtDrawing":break;case"BrtLegacyDrawing":break;case"BrtLegacyDrawingHF":break;case"BrtPhoneticInfo":break;case"BrtBeginHeaderFooter":break;case"BrtEndHeaderFooter":break;case"BrtBrk":break;case"BrtBeginRwBrk":break;case"BrtEndRwBrk":break;case"BrtBeginColBrk":break;case"BrtEndColBrk":break;case"BrtBeginUserShViews":break;case"BrtBeginUserShView":break;case"BrtEndUserShView":break;case"BrtEndUserShViews":break;case"BrtBkHim":break;case"BrtBeginOleObjects":break;case"BrtOleObject":break;case"BrtEndOleObjects":break;case"BrtBeginListParts":break;case"BrtListPart":break;case"BrtEndListParts":break;case"BrtBeginSortState":break;case"BrtBeginSortCond":break;case"BrtEndSortCond":break;case"BrtEndSortState":break;case"BrtBeginConditionalFormatting":break;case"BrtEndConditionalFormatting":break;case"BrtBeginCFRule":break;case"BrtEndCFRule":break;case"BrtBeginDVals":break;case"BrtDVal":break;case"BrtEndDVals":break;case"BrtRangeProtection":break;case"BrtBeginDCon":break;case"BrtEndDCon":break;case"BrtBeginDRefs":break;case"BrtDRef":break;case"BrtEndDRefs":break;case"BrtBeginActiveXControls":break;case"BrtActiveX":break;case"BrtEndActiveXControls":break;case"BrtBeginAFilter":break;case"BrtEndAFilter":break;case"BrtBeginFilterColumn":break;case"BrtBeginFilters":break;case"BrtFilter":break;case"BrtEndFilters":break;case"BrtEndFilterColumn":break;case"BrtDynamicFilter":break;case"BrtTop10Filter":break;case"BrtBeginCustomFilters":break;case"BrtCustomFilter":break;case"BrtEndCustomFilters":break;case"BrtBeginCellWatches":break;case"BrtCellWatch":break;case"BrtEndCellWatches":break;case"BrtTable":break;case"BrtBeginCellIgnoreECs":break;case"BrtCellIgnoreEC":break;case"BrtEndCellIgnoreECs":break;default:if(!pass||opts.WTF)throw new Error("Unexpected record "+R.n)}},opts);if(!s["!ref"]&&(refguess.s.r<1e6||ref.e.r>0||ref.e.c>0||ref.s.r>0||ref.s.c>0))s["!ref"]=encode_range(ref);if(opts.sheetRows&&s["!ref"]){var tmpref=decode_range(s["!ref"]);if(opts.sheetRows<+tmpref.e.r){tmpref.e.r=opts.sheetRows-1;if(tmpref.e.r>refguess.e.r)tmpref.e.r=refguess.e.r;if(tmpref.e.r<tmpref.s.r)tmpref.s.r=tmpref.e.r;if(tmpref.e.c>refguess.e.c)tmpref.e.c=refguess.e.c;if(tmpref.e.c<tmpref.s.c)tmpref.s.c=tmpref.e.c;s["!fullref"]=s["!ref"];s["!ref"]=encode_range(tmpref)}}if(mergecells.length>0)s["!merges"]=mergecells;return s};var write_ws_bin=function(wb,opts,rels){};var WBPropsDef={allowRefreshQuery:"0",autoCompressPictures:"1",backupFile:"0",checkCompatibility:"0",codeName:"",date1904:"0",dateCompatibility:"1",filterPrivacy:"0",hidePivotFieldList:"0",promptedSolutions:"0",publishItems:"0",refreshAllConnections:false,saveExternalLinkValues:"1",showBorderUnselectedTables:"1",showInkAnnotation:"1",showObjects:"all",showPivotChartFilter:"0"};var WBViewDef={activeTab:"0",autoFilterDateGrouping:"1",firstSheet:"0",minimized:"0",showHorizontalScroll:"1",showSheetTabs:"1",showVerticalScroll:"1",tabRatio:"600",visibility:"visible"};var SheetDef={state:"visible"};var CalcPrDef={calcCompleted:"true",calcMode:"auto",calcOnSave:"true",concurrentCalc:"true",fullCalcOnLoad:"false",fullPrecision:"true",iterate:"false",iterateCount:"100",iterateDelta:"0.001",refMode:"A1"};var CustomWBViewDef={autoUpdate:"false",changesSavedWin:"false",includeHiddenRowCol:"true",includePrintSettings:"true",maximized:"false",minimized:"false",onlySync:"false",personalView:"false",showComments:"commIndicator",showFormulaBar:"true",showHorizontalScroll:"true",showObjects:"all",showSheetTabs:"true",showStatusbar:"true",showVerticalScroll:"true",tabRatio:"600",xWindow:"0",yWindow:"0"};function parse_wb_xml(data){var wb={AppVersion:{},WBProps:{},WBView:[],Sheets:[],CalcPr:{},xmlns:""};var pass=false,xmlns="xmlns";data.match(/<[^>]*>/g).forEach(function(x){var y=parsexmltag(x);switch(y[0].replace(/<\w+:/,"<")){case"<?xml":break;case"<workbook":if(x.match(/<\w+:workbook/))xmlns="xmlns"+x.match(/<(\w+):/)[1];wb.xmlns=y[xmlns];break;case"</workbook>":break;case"<fileVersion":delete y[0];wb.AppVersion=y;break;case"<fileVersion/>":break;case"<fileSharing":case"<fileSharing/>":break;case"<workbookPr":delete y[0];wb.WBProps=y;break;case"<workbookPr/>":delete y[0];wb.WBProps=y;break;case"<workbookProtection/>":break;case"<bookViews>":case"</bookViews>":break;case"<workbookView":delete y[0];wb.WBView.push(y);break;case"<sheets>":case"</sheets>":break;case"<sheet":delete y[0];y.name=utf8read(y.name);wb.Sheets.push(y);break;case"<functionGroups":case"<functionGroups/>":break;case"<functionGroup":break;case"<externalReferences":case"</externalReferences>":break;case"<externalReference":break;case"<definedNames/>":break;case"<definedNames>":pass=true;break;case"</definedNames>":pass=false;break;case"<definedName":case"<definedName/>":case"</definedName>":break;case"<calcPr":delete y[0];wb.CalcPr=y;break;case"<calcPr/>":delete y[0];wb.CalcPr=y;break;case"<oleSize":break;case"<customWorkbookViews>":case"</customWorkbookViews>":case"<customWorkbookViews":break;case"<customWorkbookView":case"</customWorkbookView>":break;case"<pivotCaches>":case"</pivotCaches>":case"<pivotCaches":break;case"<pivotCache":break;case"<smartTagPr":case"<smartTagPr/>":break;case"<smartTagTypes":case"<smartTagTypes>":case"</smartTagTypes>":break;case"<smartTagType":break;case"<webPublishing":case"<webPublishing/>":break;case"<fileRecoveryPr":case"<fileRecoveryPr/>":break;case"<webPublishObjects>":case"<webPublishObjects":case"</webPublishObjects>":break;case"<webPublishObject":break;case"<extLst>":case"</extLst>":case"<extLst/>":break;case"<ext":pass=true;break;case"</ext>":pass=false;break;case"<mx:ArchID":break;case"<mc:AlternateContent":pass=true;break;case"</mc:AlternateContent>":pass=false;break}});if(XMLNS.main.indexOf(wb.xmlns)===-1)throw new Error("Unknown Namespace: "+wb.xmlns);var z;for(z in WBPropsDef)if(typeof wb.WBProps[z]==="undefined")wb.WBProps[z]=WBPropsDef[z];for(z in CalcPrDef)if(typeof wb.CalcPr[z]==="undefined")wb.CalcPr[z]=CalcPrDef[z];wb.WBView.forEach(function(w){for(var z in WBViewDef)if(typeof w[z]==="undefined")w[z]=WBViewDef[z]});wb.Sheets.forEach(function(w){for(var z in SheetDef)if(typeof w[z]==="undefined")w[z]=SheetDef[z]});_ssfopts.date1904=parsexmlbool(wb.WBProps.date1904,"date1904");return wb}var WB_XML_ROOT=writextag("workbook",null,{xmlns:XMLNS.main[0],"xmlns:r":XMLNS.r});var write_wb_xml=function(wb,opts){var o=[];o.push(XML_HEADER);o.push(WB_XML_ROOT);var date1904="false";try{date1904=parsexmlbool(wb.Workbook.WBProps.date1904)?"true":"false"}catch(e){date1904="false"}o.push(writextag("workbookPr",null,{date1904:date1904}));o.push("<sheets>");var i=1;wb.SheetNames.forEach(function(s){o.push(writextag("sheet",null,{name:s,sheetId:String(i),"r:id":"rId"+i}));++i});o.push("</sheets>");if(o.length>2){o.push("</workbook>");o[1]=o[1].replace("/>",">")}return o.join("")};var parse_BrtBundleSh=function(data,length){var z={};z.hsState=data.read_shift(4);z.iTabID=data.read_shift(4);z.strRelID=parse_RelID(data,length-8);z.name=parse_XLWideString(data);return z};var parse_wb_bin=function(data,opts){var wb={AppVersion:{},WBProps:{},WBView:[],Sheets:[],CalcPr:{},xmlns:""};var pass=false,z;recordhopper(data,function(val,R){switch(R.n){case"BrtBundleSh":wb.Sheets.push(val);break;case"BrtBeginBook":break;case"BrtFileVersion":break;case"BrtWbProp":break;case"BrtACBegin":break;case"BrtAbsPath15":break;case"BrtACEnd":break;case"BrtBookProtection":break;case"BrtBeginBookViews":break;case"BrtBookView":break;case"BrtEndBookViews":break;case"BrtBeginBundleShs":break;case"BrtEndBundleShs":break;case"BrtBeginFnGroup":break;case"BrtEndFnGroup":break;case"BrtBeginExternals":break;case"BrtSupSelf":break;case"BrtSupBookSrc":break;case"BrtExternSheet":break;case"BrtEndExternals":break;case"BrtName":break;case"BrtCalcProp":break;case"BrtUserBookView":break;case"BrtBeginPivotCacheIDs":break;case"BrtBeginPivotCacheID":break;case"BrtEndPivotCacheID":break;case"BrtEndPivotCacheIDs":break;case"BrtWebOpt":break;case"BrtFileRecover":break;case"BrtFileSharing":break;case"BrtFRTBegin":pass=true;break;case"BrtFRTEnd":pass=false;break;case"BrtEndBook":break;default:if(!pass)throw new Error("Unexpected record "+R.n)}});for(z in WBPropsDef)if(typeof wb.WBProps[z]==="undefined")wb.WBProps[z]=WBPropsDef[z];for(z in CalcPrDef)if(typeof wb.CalcPr[z]==="undefined")wb.CalcPr[z]=CalcPrDef[z];wb.WBView.forEach(function(w){for(var z in WBViewDef)if(typeof w[z]==="undefined")w[z]=WBViewDef[z]});wb.Sheets.forEach(function(w){for(var z in SheetDef)if(typeof w[z]==="undefined")w[z]=SheetDef[z]});_ssfopts.date1904=parsexmlbool(wb.WBProps.date1904,"date1904");return wb};var write_wb_bin=function(wb,opts){};function parse_wb(data,name,opts){return(name.substr(-4)===".bin"?parse_wb_bin:parse_wb_xml)(data,opts)}function parse_ws(data,name,opts,rels){return(name.substr(-4)===".bin"?parse_ws_bin:parse_ws_xml)(data,opts,rels)}function parse_sty(data,name,opts){return(name.substr(-4)===".bin"?parse_sty_bin:parse_sty_xml)(data,opts)}function parse_sst(data,name,opts){return(name.substr(-4)===".bin"?parse_sst_bin:parse_sst_xml)(data,opts)}function parse_cmnt(data,name,opts){return(name.substr(-4)===".bin"?parse_comments_bin:parse_comments_xml)(data,opts)}function parse_cc(data,name,opts){return(name.substr(-4)===".bin"?parse_cc_bin:parse_cc_xml)(data,opts)}function write_wb(wb,name,opts){return(name.substr(-4)===".bin"?write_wb_bin:write_wb_xml)(wb,opts)}function write_ws(data,name,opts,wb){return(name.substr(-4)===".bin"?write_ws_bin:write_ws_xml)(data,opts,wb)}function write_sty(data,name,opts){return(name.substr(-4)===".bin"?write_sty_bin:write_sty_xml)(data,opts)}function write_sst(data,name,opts){return(name.substr(-4)===".bin"?write_sst_bin:write_sst_xml)(data,opts)}var RecordEnum={0:{n:"BrtRowHdr",f:parse_BrtRowHdr},1:{n:"BrtCellBlank",f:parse_BrtCellBlank},2:{n:"BrtCellRk",f:parse_BrtCellRk},3:{n:"BrtCellError",f:parse_BrtCellError},4:{n:"BrtCellBool",f:parse_BrtCellBool},5:{n:"BrtCellReal",f:parse_BrtCellReal},6:{n:"BrtCellSt",f:parse_BrtCellSt},7:{n:"BrtCellIsst",f:parse_BrtCellIsst},8:{n:"BrtFmlaString",f:parse_BrtFmlaString},9:{n:"BrtFmlaNum",f:parse_BrtFmlaNum},10:{n:"BrtFmlaBool",f:parse_BrtFmlaBool},11:{n:"BrtFmlaError",f:parse_BrtFmlaError},19:{n:"BrtSSTItem",f:parse_RichStr},20:{n:"BrtPCDIMissing",f:parsenoop},21:{n:"BrtPCDINumber",f:parsenoop},22:{n:"BrtPCDIBoolean",f:parsenoop},23:{n:"BrtPCDIError",f:parsenoop},24:{n:"BrtPCDIString",f:parsenoop},25:{n:"BrtPCDIDatetime",f:parsenoop},26:{n:"BrtPCDIIndex",f:parsenoop},27:{n:"BrtPCDIAMissing",f:parsenoop},28:{n:"BrtPCDIANumber",f:parsenoop},29:{n:"BrtPCDIABoolean",f:parsenoop},30:{n:"BrtPCDIAError",f:parsenoop},31:{n:"BrtPCDIAString",f:parsenoop},32:{n:"BrtPCDIADatetime",f:parsenoop},33:{n:"BrtPCRRecord",f:parsenoop},34:{n:"BrtPCRRecordDt",f:parsenoop},35:{n:"BrtFRTBegin",f:parsenoop},36:{n:"BrtFRTEnd",f:parsenoop},37:{n:"BrtACBegin",f:parsenoop},38:{n:"BrtACEnd",f:parsenoop},39:{n:"BrtName",f:parsenoop},40:{n:"BrtIndexRowBlock",f:parsenoop},42:{n:"BrtIndexBlock",f:parsenoop},43:{n:"BrtFont",f:parse_BrtFont},44:{n:"BrtFmt",f:parse_BrtFmt},45:{n:"BrtFill",f:parsenoop},46:{n:"BrtBorder",f:parsenoop},47:{n:"BrtXF",f:parse_BrtXF},48:{n:"BrtStyle",f:parsenoop},49:{n:"BrtCellMeta",f:parsenoop},50:{n:"BrtValueMeta",f:parsenoop},51:{n:"BrtMdb",f:parsenoop},52:{n:"BrtBeginFmd",f:parsenoop},53:{n:"BrtEndFmd",f:parsenoop},54:{n:"BrtBeginMdx",f:parsenoop},55:{n:"BrtEndMdx",f:parsenoop},56:{n:"BrtBeginMdxTuple",f:parsenoop},57:{n:"BrtEndMdxTuple",f:parsenoop},58:{n:"BrtMdxMbrIstr",f:parsenoop},59:{n:"BrtStr",f:parsenoop},60:{n:"BrtColInfo",f:parsenoop},62:{n:"BrtCellRString",f:parsenoop},63:{n:"BrtCalcChainItem$",f:parse_BrtCalcChainItem$},64:{n:"BrtDVal",f:parsenoop},65:{n:"BrtSxvcellNum",f:parsenoop},66:{n:"BrtSxvcellStr",f:parsenoop},67:{n:"BrtSxvcellBool",f:parsenoop},68:{n:"BrtSxvcellErr",f:parsenoop},69:{n:"BrtSxvcellDate",f:parsenoop},70:{n:"BrtSxvcellNil",f:parsenoop},128:{n:"BrtFileVersion",f:parsenoop},129:{n:"BrtBeginSheet",f:parsenoop},130:{n:"BrtEndSheet",f:parsenoop},131:{n:"BrtBeginBook",f:parsenoop},132:{n:"BrtEndBook",f:parsenoop},133:{n:"BrtBeginWsViews",f:parsenoop},134:{n:"BrtEndWsViews",f:parsenoop},135:{n:"BrtBeginBookViews",f:parsenoop},136:{n:"BrtEndBookViews",f:parsenoop},137:{n:"BrtBeginWsView",f:parsenoop},138:{n:"BrtEndWsView",f:parsenoop},139:{n:"BrtBeginCsViews",f:parsenoop},140:{n:"BrtEndCsViews",f:parsenoop},141:{n:"BrtBeginCsView",f:parsenoop},142:{n:"BrtEndCsView",f:parsenoop},143:{n:"BrtBeginBundleShs",f:parsenoop},144:{n:"BrtEndBundleShs",f:parsenoop},145:{n:"BrtBeginSheetData",f:parsenoop},146:{n:"BrtEndSheetData",f:parsenoop},147:{n:"BrtWsProp",f:parse_BrtWsProp},148:{n:"BrtWsDim",f:parse_BrtWsDim},151:{n:"BrtPane",f:parsenoop},152:{n:"BrtSel",f:parsenoop},153:{n:"BrtWbProp",f:parsenoop},154:{n:"BrtWbFactoid",f:parsenoop},155:{n:"BrtFileRecover",f:parsenoop},156:{n:"BrtBundleSh",f:parse_BrtBundleSh},157:{n:"BrtCalcProp",f:parsenoop},158:{n:"BrtBookView",f:parsenoop},159:{n:"BrtBeginSst",f:parse_BrtBeginSst},160:{n:"BrtEndSst",f:parsenoop},161:{n:"BrtBeginAFilter",f:parsenoop},162:{n:"BrtEndAFilter",f:parsenoop},163:{n:"BrtBeginFilterColumn",f:parsenoop},164:{n:"BrtEndFilterColumn",f:parsenoop},165:{n:"BrtBeginFilters",f:parsenoop},166:{n:"BrtEndFilters",f:parsenoop},167:{n:"BrtFilter",f:parsenoop},168:{n:"BrtColorFilter",f:parsenoop},169:{n:"BrtIconFilter",f:parsenoop},170:{n:"BrtTop10Filter",f:parsenoop},171:{n:"BrtDynamicFilter",f:parsenoop},172:{n:"BrtBeginCustomFilters",f:parsenoop},173:{n:"BrtEndCustomFilters",f:parsenoop},174:{n:"BrtCustomFilter",f:parsenoop},175:{n:"BrtAFilterDateGroupItem",f:parsenoop},176:{n:"BrtMergeCell",f:parse_BrtMergeCell},177:{n:"BrtBeginMergeCells",f:parsenoop},178:{n:"BrtEndMergeCells",f:parsenoop},179:{n:"BrtBeginPivotCacheDef",f:parsenoop},180:{n:"BrtEndPivotCacheDef",f:parsenoop},181:{n:"BrtBeginPCDFields",f:parsenoop},182:{n:"BrtEndPCDFields",f:parsenoop},183:{n:"BrtBeginPCDField",f:parsenoop},184:{n:"BrtEndPCDField",f:parsenoop},185:{n:"BrtBeginPCDSource",f:parsenoop},186:{n:"BrtEndPCDSource",f:parsenoop},187:{n:"BrtBeginPCDSRange",f:parsenoop},188:{n:"BrtEndPCDSRange",f:parsenoop},189:{n:"BrtBeginPCDFAtbl",f:parsenoop},190:{n:"BrtEndPCDFAtbl",f:parsenoop},191:{n:"BrtBeginPCDIRun",f:parsenoop},192:{n:"BrtEndPCDIRun",f:parsenoop},193:{n:"BrtBeginPivotCacheRecords",f:parsenoop},194:{n:"BrtEndPivotCacheRecords",f:parsenoop},195:{n:"BrtBeginPCDHierarchies",f:parsenoop},196:{n:"BrtEndPCDHierarchies",f:parsenoop},197:{n:"BrtBeginPCDHierarchy",f:parsenoop},198:{n:"BrtEndPCDHierarchy",f:parsenoop},199:{n:"BrtBeginPCDHFieldsUsage",f:parsenoop},200:{n:"BrtEndPCDHFieldsUsage",f:parsenoop},201:{n:"BrtBeginExtConnection",f:parsenoop},202:{n:"BrtEndExtConnection",f:parsenoop},203:{n:"BrtBeginECDbProps",f:parsenoop},204:{n:"BrtEndECDbProps",f:parsenoop},205:{n:"BrtBeginECOlapProps",f:parsenoop},206:{n:"BrtEndECOlapProps",f:parsenoop},207:{n:"BrtBeginPCDSConsol",f:parsenoop},208:{n:"BrtEndPCDSConsol",f:parsenoop},209:{n:"BrtBeginPCDSCPages",f:parsenoop},210:{n:"BrtEndPCDSCPages",f:parsenoop},211:{n:"BrtBeginPCDSCPage",f:parsenoop},212:{n:"BrtEndPCDSCPage",f:parsenoop},213:{n:"BrtBeginPCDSCPItem",f:parsenoop},214:{n:"BrtEndPCDSCPItem",f:parsenoop},215:{n:"BrtBeginPCDSCSets",f:parsenoop},216:{n:"BrtEndPCDSCSets",f:parsenoop},217:{n:"BrtBeginPCDSCSet",f:parsenoop},218:{n:"BrtEndPCDSCSet",f:parsenoop},219:{n:"BrtBeginPCDFGroup",f:parsenoop},220:{n:"BrtEndPCDFGroup",f:parsenoop},221:{n:"BrtBeginPCDFGItems",f:parsenoop},222:{n:"BrtEndPCDFGItems",f:parsenoop},223:{n:"BrtBeginPCDFGRange",f:parsenoop},224:{n:"BrtEndPCDFGRange",f:parsenoop},225:{n:"BrtBeginPCDFGDiscrete",f:parsenoop},226:{n:"BrtEndPCDFGDiscrete",f:parsenoop},227:{n:"BrtBeginPCDSDTupleCache",f:parsenoop},228:{n:"BrtEndPCDSDTupleCache",f:parsenoop},229:{n:"BrtBeginPCDSDTCEntries",f:parsenoop},230:{n:"BrtEndPCDSDTCEntries",f:parsenoop},231:{n:"BrtBeginPCDSDTCEMembers",f:parsenoop},232:{n:"BrtEndPCDSDTCEMembers",f:parsenoop},233:{n:"BrtBeginPCDSDTCEMember",f:parsenoop},234:{n:"BrtEndPCDSDTCEMember",f:parsenoop},235:{n:"BrtBeginPCDSDTCQueries",f:parsenoop},236:{n:"BrtEndPCDSDTCQueries",f:parsenoop},237:{n:"BrtBeginPCDSDTCQuery",f:parsenoop},238:{n:"BrtEndPCDSDTCQuery",f:parsenoop},239:{n:"BrtBeginPCDSDTCSets",f:parsenoop},240:{n:"BrtEndPCDSDTCSets",f:parsenoop},241:{n:"BrtBeginPCDSDTCSet",f:parsenoop},242:{n:"BrtEndPCDSDTCSet",f:parsenoop},243:{n:"BrtBeginPCDCalcItems",f:parsenoop},244:{n:"BrtEndPCDCalcItems",f:parsenoop},245:{n:"BrtBeginPCDCalcItem",f:parsenoop},246:{n:"BrtEndPCDCalcItem",f:parsenoop},247:{n:"BrtBeginPRule",f:parsenoop},248:{n:"BrtEndPRule",f:parsenoop},249:{n:"BrtBeginPRFilters",f:parsenoop},250:{n:"BrtEndPRFilters",f:parsenoop},251:{n:"BrtBeginPRFilter",f:parsenoop},252:{n:"BrtEndPRFilter",f:parsenoop},253:{n:"BrtBeginPNames",f:parsenoop},254:{n:"BrtEndPNames",f:parsenoop},255:{n:"BrtBeginPName",f:parsenoop},256:{n:"BrtEndPName",f:parsenoop},257:{n:"BrtBeginPNPairs",f:parsenoop},258:{n:"BrtEndPNPairs",f:parsenoop},259:{n:"BrtBeginPNPair",f:parsenoop},260:{n:"BrtEndPNPair",f:parsenoop},261:{n:"BrtBeginECWebProps",f:parsenoop},262:{n:"BrtEndECWebProps",f:parsenoop},263:{n:"BrtBeginEcWpTables",f:parsenoop},264:{n:"BrtEndECWPTables",f:parsenoop},265:{n:"BrtBeginECParams",f:parsenoop},266:{n:"BrtEndECParams",f:parsenoop},267:{n:"BrtBeginECParam",f:parsenoop},268:{n:"BrtEndECParam",f:parsenoop},269:{n:"BrtBeginPCDKPIs",f:parsenoop},270:{n:"BrtEndPCDKPIs",f:parsenoop},271:{n:"BrtBeginPCDKPI",f:parsenoop},272:{n:"BrtEndPCDKPI",f:parsenoop},273:{n:"BrtBeginDims",f:parsenoop},274:{n:"BrtEndDims",f:parsenoop},275:{n:"BrtBeginDim",f:parsenoop},276:{n:"BrtEndDim",f:parsenoop},277:{n:"BrtIndexPartEnd",f:parsenoop},278:{n:"BrtBeginStyleSheet",f:parsenoop},279:{n:"BrtEndStyleSheet",f:parsenoop},280:{n:"BrtBeginSXView",f:parsenoop},281:{n:"BrtEndSXVI",f:parsenoop},282:{n:"BrtBeginSXVI",f:parsenoop},283:{n:"BrtBeginSXVIs",f:parsenoop},284:{n:"BrtEndSXVIs",f:parsenoop},285:{n:"BrtBeginSXVD",f:parsenoop},286:{n:"BrtEndSXVD",f:parsenoop},287:{n:"BrtBeginSXVDs",f:parsenoop},288:{n:"BrtEndSXVDs",f:parsenoop},289:{n:"BrtBeginSXPI",f:parsenoop},290:{n:"BrtEndSXPI",f:parsenoop},291:{n:"BrtBeginSXPIs",f:parsenoop},292:{n:"BrtEndSXPIs",f:parsenoop},293:{n:"BrtBeginSXDI",f:parsenoop},294:{n:"BrtEndSXDI",f:parsenoop},295:{n:"BrtBeginSXDIs",f:parsenoop},296:{n:"BrtEndSXDIs",f:parsenoop},297:{n:"BrtBeginSXLI",f:parsenoop},298:{n:"BrtEndSXLI",f:parsenoop},299:{n:"BrtBeginSXLIRws",f:parsenoop},300:{n:"BrtEndSXLIRws",f:parsenoop},301:{n:"BrtBeginSXLICols",f:parsenoop},302:{n:"BrtEndSXLICols",f:parsenoop},303:{n:"BrtBeginSXFormat",f:parsenoop},304:{n:"BrtEndSXFormat",f:parsenoop},305:{n:"BrtBeginSXFormats",f:parsenoop},306:{n:"BrtEndSxFormats",f:parsenoop},307:{n:"BrtBeginSxSelect",f:parsenoop},308:{n:"BrtEndSxSelect",f:parsenoop},309:{n:"BrtBeginISXVDRws",f:parsenoop},310:{n:"BrtEndISXVDRws",f:parsenoop},311:{n:"BrtBeginISXVDCols",f:parsenoop},312:{n:"BrtEndISXVDCols",f:parsenoop},313:{n:"BrtEndSXLocation",f:parsenoop},314:{n:"BrtBeginSXLocation",f:parsenoop},315:{n:"BrtEndSXView",f:parsenoop},316:{n:"BrtBeginSXTHs",f:parsenoop},317:{n:"BrtEndSXTHs",f:parsenoop},318:{n:"BrtBeginSXTH",f:parsenoop},319:{n:"BrtEndSXTH",f:parsenoop},320:{n:"BrtBeginISXTHRws",f:parsenoop},321:{n:"BrtEndISXTHRws",f:parsenoop},322:{n:"BrtBeginISXTHCols",f:parsenoop},323:{n:"BrtEndISXTHCols",f:parsenoop},324:{n:"BrtBeginSXTDMPS",f:parsenoop},325:{n:"BrtEndSXTDMPs",f:parsenoop},326:{n:"BrtBeginSXTDMP",f:parsenoop},327:{n:"BrtEndSXTDMP",f:parsenoop},328:{n:"BrtBeginSXTHItems",f:parsenoop},329:{n:"BrtEndSXTHItems",f:parsenoop},330:{n:"BrtBeginSXTHItem",f:parsenoop},331:{n:"BrtEndSXTHItem",f:parsenoop},332:{n:"BrtBeginMetadata",f:parsenoop},333:{n:"BrtEndMetadata",f:parsenoop},334:{n:"BrtBeginEsmdtinfo",f:parsenoop},335:{n:"BrtMdtinfo",f:parsenoop},336:{n:"BrtEndEsmdtinfo",f:parsenoop},337:{n:"BrtBeginEsmdb",f:parsenoop},338:{n:"BrtEndEsmdb",f:parsenoop},339:{n:"BrtBeginEsfmd",f:parsenoop},340:{n:"BrtEndEsfmd",f:parsenoop},341:{n:"BrtBeginSingleCells",f:parsenoop},342:{n:"BrtEndSingleCells",f:parsenoop},343:{n:"BrtBeginList",f:parsenoop},344:{n:"BrtEndList",f:parsenoop},345:{n:"BrtBeginListCols",f:parsenoop},346:{n:"BrtEndListCols",f:parsenoop},347:{n:"BrtBeginListCol",f:parsenoop},348:{n:"BrtEndListCol",f:parsenoop},349:{n:"BrtBeginListXmlCPr",f:parsenoop},350:{n:"BrtEndListXmlCPr",f:parsenoop},351:{n:"BrtListCCFmla",f:parsenoop},352:{n:"BrtListTrFmla",f:parsenoop},353:{n:"BrtBeginExternals",f:parsenoop},354:{n:"BrtEndExternals",f:parsenoop},355:{n:"BrtSupBookSrc",f:parsenoop},357:{n:"BrtSupSelf",f:parsenoop},358:{n:"BrtSupSame",f:parsenoop},359:{n:"BrtSupTabs",f:parsenoop},360:{n:"BrtBeginSupBook",f:parsenoop},361:{n:"BrtPlaceholderName",f:parsenoop},362:{n:"BrtExternSheet",f:parsenoop},363:{n:"BrtExternTableStart",f:parsenoop},364:{n:"BrtExternTableEnd",f:parsenoop},366:{n:"BrtExternRowHdr",f:parsenoop},367:{n:"BrtExternCellBlank",f:parsenoop},368:{n:"BrtExternCellReal",f:parsenoop},369:{n:"BrtExternCellBool",f:parsenoop},370:{n:"BrtExternCellError",f:parsenoop},371:{n:"BrtExternCellString",f:parsenoop},372:{n:"BrtBeginEsmdx",f:parsenoop},373:{n:"BrtEndEsmdx",f:parsenoop},374:{n:"BrtBeginMdxSet",f:parsenoop},375:{n:"BrtEndMdxSet",f:parsenoop},376:{n:"BrtBeginMdxMbrProp",f:parsenoop},377:{n:"BrtEndMdxMbrProp",f:parsenoop},378:{n:"BrtBeginMdxKPI",f:parsenoop},379:{n:"BrtEndMdxKPI",f:parsenoop},380:{n:"BrtBeginEsstr",f:parsenoop},381:{n:"BrtEndEsstr",f:parsenoop},382:{n:"BrtBeginPRFItem",f:parsenoop},383:{n:"BrtEndPRFItem",f:parsenoop},384:{n:"BrtBeginPivotCacheIDs",f:parsenoop},385:{n:"BrtEndPivotCacheIDs",f:parsenoop},386:{n:"BrtBeginPivotCacheID",f:parsenoop},387:{n:"BrtEndPivotCacheID",f:parsenoop},388:{n:"BrtBeginISXVIs",f:parsenoop},389:{n:"BrtEndISXVIs",f:parsenoop},390:{n:"BrtBeginColInfos",f:parsenoop},391:{n:"BrtEndColInfos",f:parsenoop},392:{n:"BrtBeginRwBrk",f:parsenoop},393:{n:"BrtEndRwBrk",f:parsenoop},394:{n:"BrtBeginColBrk",f:parsenoop},395:{n:"BrtEndColBrk",f:parsenoop},396:{n:"BrtBrk",f:parsenoop},397:{n:"BrtUserBookView",f:parsenoop},398:{n:"BrtInfo",f:parsenoop},399:{n:"BrtCUsr",f:parsenoop},400:{n:"BrtUsr",f:parsenoop},401:{n:"BrtBeginUsers",f:parsenoop},403:{n:"BrtEOF",f:parsenoop},404:{n:"BrtUCR",f:parsenoop},405:{n:"BrtRRInsDel",f:parsenoop},406:{n:"BrtRREndInsDel",f:parsenoop},407:{n:"BrtRRMove",f:parsenoop},408:{n:"BrtRREndMove",f:parsenoop},409:{n:"BrtRRChgCell",f:parsenoop},410:{n:"BrtRREndChgCell",f:parsenoop},411:{n:"BrtRRHeader",f:parsenoop},412:{n:"BrtRRUserView",f:parsenoop},413:{n:"BrtRRRenSheet",f:parsenoop},414:{n:"BrtRRInsertSh",f:parsenoop},415:{n:"BrtRRDefName",f:parsenoop},416:{n:"BrtRRNote",f:parsenoop},417:{n:"BrtRRConflict",f:parsenoop},418:{n:"BrtRRTQSIF",f:parsenoop},419:{n:"BrtRRFormat",f:parsenoop},420:{n:"BrtRREndFormat",f:parsenoop},421:{n:"BrtRRAutoFmt",f:parsenoop},422:{n:"BrtBeginUserShViews",f:parsenoop},423:{n:"BrtBeginUserShView",f:parsenoop},424:{n:"BrtEndUserShView",f:parsenoop},425:{n:"BrtEndUserShViews",f:parsenoop},426:{n:"BrtArrFmla",f:parsenoop},427:{n:"BrtShrFmla",f:parsenoop},428:{n:"BrtTable",f:parsenoop},429:{n:"BrtBeginExtConnections",f:parsenoop},430:{n:"BrtEndExtConnections",f:parsenoop},431:{n:"BrtBeginPCDCalcMems",f:parsenoop},432:{n:"BrtEndPCDCalcMems",f:parsenoop},433:{n:"BrtBeginPCDCalcMem",f:parsenoop},434:{n:"BrtEndPCDCalcMem",f:parsenoop},435:{n:"BrtBeginPCDHGLevels",f:parsenoop},436:{n:"BrtEndPCDHGLevels",f:parsenoop},437:{n:"BrtBeginPCDHGLevel",f:parsenoop},438:{n:"BrtEndPCDHGLevel",f:parsenoop},439:{n:"BrtBeginPCDHGLGroups",f:parsenoop},440:{n:"BrtEndPCDHGLGroups",f:parsenoop},441:{n:"BrtBeginPCDHGLGroup",f:parsenoop},442:{n:"BrtEndPCDHGLGroup",f:parsenoop},443:{n:"BrtBeginPCDHGLGMembers",f:parsenoop},444:{n:"BrtEndPCDHGLGMembers",f:parsenoop},445:{n:"BrtBeginPCDHGLGMember",f:parsenoop},446:{n:"BrtEndPCDHGLGMember",f:parsenoop},447:{n:"BrtBeginQSI",f:parsenoop},448:{n:"BrtEndQSI",f:parsenoop},449:{n:"BrtBeginQSIR",f:parsenoop},450:{n:"BrtEndQSIR",f:parsenoop},451:{n:"BrtBeginDeletedNames",f:parsenoop},452:{n:"BrtEndDeletedNames",f:parsenoop},453:{n:"BrtBeginDeletedName",f:parsenoop},454:{n:"BrtEndDeletedName",f:parsenoop},455:{n:"BrtBeginQSIFs",f:parsenoop},456:{n:"BrtEndQSIFs",f:parsenoop},457:{n:"BrtBeginQSIF",f:parsenoop},458:{n:"BrtEndQSIF",f:parsenoop},459:{n:"BrtBeginAutoSortScope",f:parsenoop},460:{n:"BrtEndAutoSortScope",f:parsenoop},461:{n:"BrtBeginConditionalFormatting",f:parsenoop},462:{n:"BrtEndConditionalFormatting",f:parsenoop},463:{n:"BrtBeginCFRule",f:parsenoop},464:{n:"BrtEndCFRule",f:parsenoop},465:{n:"BrtBeginIconSet",f:parsenoop},466:{n:"BrtEndIconSet",f:parsenoop},467:{n:"BrtBeginDatabar",f:parsenoop},468:{n:"BrtEndDatabar",f:parsenoop},469:{n:"BrtBeginColorScale",f:parsenoop},470:{n:"BrtEndColorScale",f:parsenoop},471:{n:"BrtCFVO",f:parsenoop},472:{n:"BrtExternValueMeta",f:parsenoop},473:{n:"BrtBeginColorPalette",f:parsenoop},474:{n:"BrtEndColorPalette",f:parsenoop},475:{n:"BrtIndexedColor",f:parsenoop},476:{n:"BrtMargins",f:parsenoop},477:{n:"BrtPrintOptions",f:parsenoop},478:{n:"BrtPageSetup",f:parsenoop},479:{n:"BrtBeginHeaderFooter",f:parsenoop},480:{n:"BrtEndHeaderFooter",f:parsenoop},481:{n:"BrtBeginSXCrtFormat",f:parsenoop},482:{n:"BrtEndSXCrtFormat",f:parsenoop},483:{n:"BrtBeginSXCrtFormats",f:parsenoop},484:{n:"BrtEndSXCrtFormats",f:parsenoop},485:{n:"BrtWsFmtInfo",f:parsenoop},486:{n:"BrtBeginMgs",f:parsenoop},487:{n:"BrtEndMGs",f:parsenoop},488:{n:"BrtBeginMGMaps",f:parsenoop},489:{n:"BrtEndMGMaps",f:parsenoop},490:{n:"BrtBeginMG",f:parsenoop},491:{n:"BrtEndMG",f:parsenoop},492:{n:"BrtBeginMap",f:parsenoop},493:{n:"BrtEndMap",f:parsenoop},494:{n:"BrtHLink",f:parse_BrtHLink},495:{n:"BrtBeginDCon",f:parsenoop},496:{n:"BrtEndDCon",f:parsenoop},497:{n:"BrtBeginDRefs",f:parsenoop},498:{n:"BrtEndDRefs",f:parsenoop},499:{n:"BrtDRef",f:parsenoop},500:{n:"BrtBeginScenMan",f:parsenoop},501:{n:"BrtEndScenMan",f:parsenoop},502:{n:"BrtBeginSct",f:parsenoop},503:{n:"BrtEndSct",f:parsenoop},504:{n:"BrtSlc",f:parsenoop},505:{n:"BrtBeginDXFs",f:parsenoop},506:{n:"BrtEndDXFs",f:parsenoop},507:{n:"BrtDXF",f:parsenoop},508:{n:"BrtBeginTableStyles",f:parsenoop},509:{n:"BrtEndTableStyles",f:parsenoop},510:{n:"BrtBeginTableStyle",f:parsenoop},511:{n:"BrtEndTableStyle",f:parsenoop},512:{n:"BrtTableStyleElement",f:parsenoop},513:{n:"BrtTableStyleClient",f:parsenoop},514:{n:"BrtBeginVolDeps",f:parsenoop},515:{n:"BrtEndVolDeps",f:parsenoop},516:{n:"BrtBeginVolType",f:parsenoop},517:{n:"BrtEndVolType",f:parsenoop},518:{n:"BrtBeginVolMain",f:parsenoop},519:{n:"BrtEndVolMain",f:parsenoop},520:{n:"BrtBeginVolTopic",f:parsenoop},521:{n:"BrtEndVolTopic",f:parsenoop},522:{n:"BrtVolSubtopic",f:parsenoop},523:{n:"BrtVolRef",f:parsenoop},524:{n:"BrtVolNum",f:parsenoop},525:{n:"BrtVolErr",f:parsenoop},526:{n:"BrtVolStr",f:parsenoop},527:{n:"BrtVolBool",f:parsenoop},528:{n:"BrtBeginCalcChain$",f:parsenoop},529:{n:"BrtEndCalcChain$",f:parsenoop},530:{n:"BrtBeginSortState",f:parsenoop},531:{n:"BrtEndSortState",f:parsenoop},532:{n:"BrtBeginSortCond",f:parsenoop},533:{n:"BrtEndSortCond",f:parsenoop},534:{n:"BrtBookProtection",f:parsenoop},535:{n:"BrtSheetProtection",f:parsenoop},536:{n:"BrtRangeProtection",f:parsenoop},537:{n:"BrtPhoneticInfo",f:parsenoop},538:{n:"BrtBeginECTxtWiz",f:parsenoop},539:{n:"BrtEndECTxtWiz",f:parsenoop},540:{n:"BrtBeginECTWFldInfoLst",f:parsenoop},541:{n:"BrtEndECTWFldInfoLst",f:parsenoop},542:{n:"BrtBeginECTwFldInfo",f:parsenoop},548:{n:"BrtFileSharing",f:parsenoop},549:{n:"BrtOleSize",f:parsenoop},550:{n:"BrtDrawing",f:parsenoop},551:{n:"BrtLegacyDrawing",f:parsenoop},552:{n:"BrtLegacyDrawingHF",f:parsenoop},553:{n:"BrtWebOpt",f:parsenoop},554:{n:"BrtBeginWebPubItems",f:parsenoop},555:{n:"BrtEndWebPubItems",f:parsenoop},556:{n:"BrtBeginWebPubItem",f:parsenoop},557:{n:"BrtEndWebPubItem",f:parsenoop},558:{n:"BrtBeginSXCondFmt",f:parsenoop},559:{n:"BrtEndSXCondFmt",f:parsenoop},560:{n:"BrtBeginSXCondFmts",f:parsenoop},561:{n:"BrtEndSXCondFmts",f:parsenoop},562:{n:"BrtBkHim",f:parsenoop},564:{n:"BrtColor",f:parsenoop},565:{n:"BrtBeginIndexedColors",f:parsenoop},566:{n:"BrtEndIndexedColors",f:parsenoop},569:{n:"BrtBeginMRUColors",f:parsenoop},570:{n:"BrtEndMRUColors",f:parsenoop},572:{n:"BrtMRUColor",f:parsenoop},573:{n:"BrtBeginDVals",f:parsenoop},574:{n:"BrtEndDVals",f:parsenoop},577:{n:"BrtSupNameStart",f:parsenoop},578:{n:"BrtSupNameValueStart",f:parsenoop},579:{n:"BrtSupNameValueEnd",f:parsenoop},580:{n:"BrtSupNameNum",f:parsenoop},581:{n:"BrtSupNameErr",f:parsenoop},582:{n:"BrtSupNameSt",f:parsenoop},583:{n:"BrtSupNameNil",f:parsenoop},584:{n:"BrtSupNameBool",f:parsenoop},585:{n:"BrtSupNameFmla",f:parsenoop},586:{n:"BrtSupNameBits",f:parsenoop},587:{n:"BrtSupNameEnd",f:parsenoop},588:{n:"BrtEndSupBook",f:parsenoop},589:{n:"BrtCellSmartTagProperty",f:parsenoop},590:{n:"BrtBeginCellSmartTag",f:parsenoop},591:{n:"BrtEndCellSmartTag",f:parsenoop},592:{n:"BrtBeginCellSmartTags",f:parsenoop},593:{n:"BrtEndCellSmartTags",f:parsenoop},594:{n:"BrtBeginSmartTags",f:parsenoop},595:{n:"BrtEndSmartTags",f:parsenoop},596:{n:"BrtSmartTagType",f:parsenoop},597:{n:"BrtBeginSmartTagTypes",f:parsenoop},598:{n:"BrtEndSmartTagTypes",f:parsenoop},599:{n:"BrtBeginSXFilters",f:parsenoop},600:{n:"BrtEndSXFilters",f:parsenoop},601:{n:"BrtBeginSXFILTER",f:parsenoop},602:{n:"BrtEndSXFilter",f:parsenoop},603:{n:"BrtBeginFills",f:parsenoop},604:{n:"BrtEndFills",f:parsenoop},605:{n:"BrtBeginCellWatches",f:parsenoop},606:{n:"BrtEndCellWatches",f:parsenoop},607:{n:"BrtCellWatch",f:parsenoop},608:{n:"BrtBeginCRErrs",f:parsenoop},609:{n:"BrtEndCRErrs",f:parsenoop},610:{n:"BrtCrashRecErr",f:parsenoop},611:{n:"BrtBeginFonts",f:parsenoop},612:{n:"BrtEndFonts",f:parsenoop},613:{n:"BrtBeginBorders",f:parsenoop},614:{n:"BrtEndBorders",f:parsenoop},615:{n:"BrtBeginFmts",f:parsenoop},616:{n:"BrtEndFmts",f:parsenoop},617:{n:"BrtBeginCellXFs",f:parsenoop},618:{n:"BrtEndCellXFs",f:parsenoop},619:{n:"BrtBeginStyles",f:parsenoop},620:{n:"BrtEndStyles",f:parsenoop},625:{n:"BrtBigName",f:parsenoop},626:{n:"BrtBeginCellStyleXFs",f:parsenoop},627:{n:"BrtEndCellStyleXFs",f:parsenoop},628:{n:"BrtBeginComments",f:parsenoop},629:{n:"BrtEndComments",f:parsenoop},630:{n:"BrtBeginCommentAuthors",f:parsenoop},631:{n:"BrtEndCommentAuthors",f:parsenoop},632:{n:"BrtCommentAuthor",f:parse_BrtCommentAuthor},633:{n:"BrtBeginCommentList",f:parsenoop},634:{n:"BrtEndCommentList",f:parsenoop},635:{n:"BrtBeginComment",f:parse_BrtBeginComment},636:{n:"BrtEndComment",f:parsenoop},637:{n:"BrtCommentText",f:parse_BrtCommentText},638:{n:"BrtBeginOleObjects",f:parsenoop},639:{n:"BrtOleObject",f:parsenoop},640:{n:"BrtEndOleObjects",f:parsenoop},641:{n:"BrtBeginSxrules",f:parsenoop},642:{n:"BrtEndSxRules",f:parsenoop},643:{n:"BrtBeginActiveXControls",f:parsenoop},644:{n:"BrtActiveX",f:parsenoop},645:{n:"BrtEndActiveXControls",f:parsenoop},646:{n:"BrtBeginPCDSDTCEMembersSortBy",f:parsenoop},648:{n:"BrtBeginCellIgnoreECs",f:parsenoop},649:{n:"BrtCellIgnoreEC",f:parsenoop},650:{n:"BrtEndCellIgnoreECs",f:parsenoop},651:{n:"BrtCsProp",f:parsenoop},652:{n:"BrtCsPageSetup",f:parsenoop},653:{n:"BrtBeginUserCsViews",f:parsenoop},654:{n:"BrtEndUserCsViews",f:parsenoop},655:{n:"BrtBeginUserCsView",f:parsenoop},656:{n:"BrtEndUserCsView",f:parsenoop},657:{n:"BrtBeginPcdSFCIEntries",f:parsenoop},658:{n:"BrtEndPCDSFCIEntries",f:parsenoop},659:{n:"BrtPCDSFCIEntry",f:parsenoop},660:{n:"BrtBeginListParts",f:parsenoop},661:{n:"BrtListPart",f:parsenoop},662:{n:"BrtEndListParts",f:parsenoop},663:{n:"BrtSheetCalcProp",f:parsenoop},664:{n:"BrtBeginFnGroup",f:parsenoop},665:{n:"BrtFnGroup",f:parsenoop},666:{n:"BrtEndFnGroup",f:parsenoop},667:{n:"BrtSupAddin",f:parsenoop},668:{n:"BrtSXTDMPOrder",f:parsenoop},669:{n:"BrtCsProtection",f:parsenoop},671:{n:"BrtBeginWsSortMap",f:parsenoop},672:{n:"BrtEndWsSortMap",f:parsenoop},673:{n:"BrtBeginRRSort",f:parsenoop},674:{n:"BrtEndRRSort",f:parsenoop},675:{n:"BrtRRSortItem",f:parsenoop},676:{n:"BrtFileSharingIso",f:parsenoop},677:{n:"BrtBookProtectionIso",f:parsenoop},678:{n:"BrtSheetProtectionIso",f:parsenoop},679:{n:"BrtCsProtectionIso",f:parsenoop},680:{n:"BrtRangeProtectionIso",f:parsenoop},1024:{n:"BrtRwDescent",f:parsenoop},1025:{n:"BrtKnownFonts",f:parsenoop},1026:{n:"BrtBeginSXTupleSet",f:parsenoop},1027:{n:"BrtEndSXTupleSet",f:parsenoop},1028:{n:"BrtBeginSXTupleSetHeader",f:parsenoop},1029:{n:"BrtEndSXTupleSetHeader",f:parsenoop},1030:{n:"BrtSXTupleSetHeaderItem",f:parsenoop},1031:{n:"BrtBeginSXTupleSetData",f:parsenoop},1032:{n:"BrtEndSXTupleSetData",f:parsenoop},1033:{n:"BrtBeginSXTupleSetRow",f:parsenoop},1034:{n:"BrtEndSXTupleSetRow",f:parsenoop},1035:{n:"BrtSXTupleSetRowItem",f:parsenoop},1036:{n:"BrtNameExt",f:parsenoop},1037:{n:"BrtPCDH14",f:parsenoop},1038:{n:"BrtBeginPCDCalcMem14",f:parsenoop},1039:{n:"BrtEndPCDCalcMem14",f:parsenoop},1040:{n:"BrtSXTH14",f:parsenoop},1041:{n:"BrtBeginSparklineGroup",f:parsenoop},1042:{n:"BrtEndSparklineGroup",f:parsenoop},1043:{n:"BrtSparkline",f:parsenoop},1044:{n:"BrtSXDI14",f:parsenoop},1045:{n:"BrtWsFmtInfoEx14",f:parsenoop},1046:{n:"BrtBeginConditionalFormatting14",f:parsenoop},1047:{n:"BrtEndConditionalFormatting14",f:parsenoop},1048:{n:"BrtBeginCFRule14",f:parsenoop},1049:{n:"BrtEndCFRule14",f:parsenoop},1050:{n:"BrtCFVO14",f:parsenoop},1051:{n:"BrtBeginDatabar14",f:parsenoop},1052:{n:"BrtBeginIconSet14",f:parsenoop},1053:{n:"BrtDVal14",f:parsenoop},1054:{n:"BrtBeginDVals14",f:parsenoop},1055:{n:"BrtColor14",f:parsenoop},1056:{n:"BrtBeginSparklines",f:parsenoop},1057:{n:"BrtEndSparklines",f:parsenoop},1058:{n:"BrtBeginSparklineGroups",f:parsenoop},1059:{n:"BrtEndSparklineGroups",f:parsenoop},1061:{n:"BrtSXVD14",f:parsenoop},1062:{n:"BrtBeginSxview14",f:parsenoop},1063:{n:"BrtEndSxview14",f:parsenoop},1066:{n:"BrtBeginPCD14",f:parsenoop},1067:{n:"BrtEndPCD14",f:parsenoop},1068:{n:"BrtBeginExtConn14",f:parsenoop},1069:{n:"BrtEndExtConn14",f:parsenoop},1070:{n:"BrtBeginSlicerCacheIDs",f:parsenoop},1071:{n:"BrtEndSlicerCacheIDs",f:parsenoop},1072:{n:"BrtBeginSlicerCacheID",f:parsenoop},1073:{n:"BrtEndSlicerCacheID",f:parsenoop},1075:{n:"BrtBeginSlicerCache",f:parsenoop},1076:{n:"BrtEndSlicerCache",f:parsenoop},1077:{n:"BrtBeginSlicerCacheDef",f:parsenoop},1078:{n:"BrtEndSlicerCacheDef",f:parsenoop},1079:{n:"BrtBeginSlicersEx",f:parsenoop},1080:{n:"BrtEndSlicersEx",f:parsenoop},1081:{n:"BrtBeginSlicerEx",f:parsenoop},1082:{n:"BrtEndSlicerEx",f:parsenoop},1083:{n:"BrtBeginSlicer",f:parsenoop},1084:{n:"BrtEndSlicer",f:parsenoop},1085:{n:"BrtSlicerCachePivotTables",f:parsenoop},1086:{n:"BrtBeginSlicerCacheOlapImpl",f:parsenoop},1087:{n:"BrtEndSlicerCacheOlapImpl",f:parsenoop},1088:{n:"BrtBeginSlicerCacheLevelsData",f:parsenoop},1089:{n:"BrtEndSlicerCacheLevelsData",f:parsenoop},1090:{n:"BrtBeginSlicerCacheLevelData",f:parsenoop},1091:{n:"BrtEndSlicerCacheLevelData",f:parsenoop},1092:{n:"BrtBeginSlicerCacheSiRanges",f:parsenoop},1093:{n:"BrtEndSlicerCacheSiRanges",f:parsenoop},1094:{n:"BrtBeginSlicerCacheSiRange",f:parsenoop},1095:{n:"BrtEndSlicerCacheSiRange",f:parsenoop},1096:{n:"BrtSlicerCacheOlapItem",f:parsenoop},1097:{n:"BrtBeginSlicerCacheSelections",f:parsenoop},1098:{n:"BrtSlicerCacheSelection",f:parsenoop},1099:{n:"BrtEndSlicerCacheSelections",f:parsenoop},1100:{n:"BrtBeginSlicerCacheNative",f:parsenoop},1101:{n:"BrtEndSlicerCacheNative",f:parsenoop},1102:{n:"BrtSlicerCacheNativeItem",f:parsenoop},1103:{n:"BrtRangeProtection14",f:parsenoop},1104:{n:"BrtRangeProtectionIso14",f:parsenoop},1105:{n:"BrtCellIgnoreEC14",f:parsenoop},1111:{n:"BrtList14",f:parsenoop},1112:{n:"BrtCFIcon",f:parsenoop},1113:{n:"BrtBeginSlicerCachesPivotCacheIDs",f:parsenoop},1114:{n:"BrtEndSlicerCachesPivotCacheIDs",f:parsenoop},1115:{n:"BrtBeginSlicers",f:parsenoop},1116:{n:"BrtEndSlicers",f:parsenoop},1117:{n:"BrtWbProp14",f:parsenoop},1118:{n:"BrtBeginSXEdit",f:parsenoop},1119:{n:"BrtEndSXEdit",f:parsenoop},1120:{n:"BrtBeginSXEdits",f:parsenoop},1121:{n:"BrtEndSXEdits",f:parsenoop},1122:{n:"BrtBeginSXChange",f:parsenoop},1123:{n:"BrtEndSXChange",f:parsenoop},1124:{n:"BrtBeginSXChanges",f:parsenoop},1125:{n:"BrtEndSXChanges",f:parsenoop},1126:{n:"BrtSXTupleItems",f:parsenoop},1128:{n:"BrtBeginSlicerStyle",f:parsenoop},1129:{n:"BrtEndSlicerStyle",f:parsenoop},1130:{n:"BrtSlicerStyleElement",f:parsenoop},1131:{n:"BrtBeginStyleSheetExt14",f:parsenoop},1132:{n:"BrtEndStyleSheetExt14",f:parsenoop},1133:{n:"BrtBeginSlicerCachesPivotCacheID",f:parsenoop},1134:{n:"BrtEndSlicerCachesPivotCacheID",f:parsenoop},1135:{n:"BrtBeginConditionalFormattings",f:parsenoop},1136:{n:"BrtEndConditionalFormattings",f:parsenoop},1137:{n:"BrtBeginPCDCalcMemExt",f:parsenoop},1138:{n:"BrtEndPCDCalcMemExt",f:parsenoop},1139:{n:"BrtBeginPCDCalcMemsExt",f:parsenoop},1140:{n:"BrtEndPCDCalcMemsExt",f:parsenoop},1141:{n:"BrtPCDField14",f:parsenoop},1142:{n:"BrtBeginSlicerStyles",f:parsenoop},1143:{n:"BrtEndSlicerStyles",f:parsenoop},1144:{n:"BrtBeginSlicerStyleElements",f:parsenoop},1145:{n:"BrtEndSlicerStyleElements",f:parsenoop},1146:{n:"BrtCFRuleExt",f:parsenoop},1147:{n:"BrtBeginSXCondFmt14",f:parsenoop},1148:{n:"BrtEndSXCondFmt14",f:parsenoop},1149:{n:"BrtBeginSXCondFmts14",f:parsenoop},1150:{n:"BrtEndSXCondFmts14",f:parsenoop},1152:{n:"BrtBeginSortCond14",f:parsenoop},1153:{n:"BrtEndSortCond14",f:parsenoop},1154:{n:"BrtEndDVals14",f:parsenoop},1155:{n:"BrtEndIconSet14",f:parsenoop},1156:{n:"BrtEndDatabar14",f:parsenoop},1157:{n:"BrtBeginColorScale14",f:parsenoop},1158:{n:"BrtEndColorScale14",f:parsenoop},1159:{n:"BrtBeginSxrules14",f:parsenoop},1160:{n:"BrtEndSxrules14",f:parsenoop},1161:{n:"BrtBeginPRule14",f:parsenoop},1162:{n:"BrtEndPRule14",f:parsenoop},1163:{n:"BrtBeginPRFilters14",f:parsenoop},1164:{n:"BrtEndPRFilters14",f:parsenoop},1165:{n:"BrtBeginPRFilter14",f:parsenoop},1166:{n:"BrtEndPRFilter14",f:parsenoop},1167:{n:"BrtBeginPRFItem14",f:parsenoop},1168:{n:"BrtEndPRFItem14",f:parsenoop},1169:{n:"BrtBeginCellIgnoreECs14",f:parsenoop},1170:{n:"BrtEndCellIgnoreECs14",f:parsenoop},1171:{n:"BrtDxf14",f:parsenoop},1172:{n:"BrtBeginDxF14s",f:parsenoop},1173:{n:"BrtEndDxf14s",f:parsenoop},1177:{n:"BrtFilter14",f:parsenoop},1178:{n:"BrtBeginCustomFilters14",f:parsenoop},1180:{n:"BrtCustomFilter14",f:parsenoop},1181:{n:"BrtIconFilter14",f:parsenoop},1182:{n:"BrtPivotCacheConnectionName",f:parsenoop},2048:{n:"BrtBeginDecoupledPivotCacheIDs",f:parsenoop},2049:{n:"BrtEndDecoupledPivotCacheIDs",f:parsenoop},2050:{n:"BrtDecoupledPivotCacheID",f:parsenoop},2051:{n:"BrtBeginPivotTableRefs",f:parsenoop},2052:{n:"BrtEndPivotTableRefs",f:parsenoop},2053:{n:"BrtPivotTableRef",f:parsenoop},2054:{n:"BrtSlicerCacheBookPivotTables",f:parsenoop},2055:{n:"BrtBeginSxvcells",f:parsenoop},2056:{n:"BrtEndSxvcells",f:parsenoop},2057:{n:"BrtBeginSxRow",f:parsenoop},2058:{n:"BrtEndSxRow",f:parsenoop},2060:{n:"BrtPcdCalcMem15",f:parsenoop},2067:{n:"BrtQsi15",f:parsenoop},2068:{n:"BrtBeginWebExtensions",f:parsenoop},2069:{n:"BrtEndWebExtensions",f:parsenoop},2070:{n:"BrtWebExtension",f:parsenoop},2071:{n:"BrtAbsPath15",f:parsenoop},2072:{n:"BrtBeginPivotTableUISettings",f:parsenoop},2073:{n:"BrtEndPivotTableUISettings",f:parsenoop},2075:{n:"BrtTableSlicerCacheIDs",f:parsenoop},2076:{n:"BrtTableSlicerCacheID",f:parsenoop},2077:{n:"BrtBeginTableSlicerCache",f:parsenoop},2078:{n:"BrtEndTableSlicerCache",f:parsenoop},2079:{n:"BrtSxFilter15",f:parsenoop},2080:{n:"BrtBeginTimelineCachePivotCacheIDs",f:parsenoop},2081:{n:"BrtEndTimelineCachePivotCacheIDs",f:parsenoop},2082:{n:"BrtTimelineCachePivotCacheID",f:parsenoop},2083:{n:"BrtBeginTimelineCacheIDs",f:parsenoop},2084:{n:"BrtEndTimelineCacheIDs",f:parsenoop},2085:{n:"BrtBeginTimelineCacheID",f:parsenoop},2086:{n:"BrtEndTimelineCacheID",f:parsenoop},2087:{n:"BrtBeginTimelinesEx",f:parsenoop},2088:{n:"BrtEndTimelinesEx",f:parsenoop},2089:{n:"BrtBeginTimelineEx",f:parsenoop},2090:{n:"BrtEndTimelineEx",f:parsenoop},2091:{n:"BrtWorkBookPr15",f:parsenoop},2092:{n:"BrtPCDH15",f:parsenoop},2093:{n:"BrtBeginTimelineStyle",f:parsenoop},2094:{n:"BrtEndTimelineStyle",f:parsenoop},2095:{n:"BrtTimelineStyleElement",f:parsenoop},2096:{n:"BrtBeginTimelineStylesheetExt15",f:parsenoop},2097:{n:"BrtEndTimelineStylesheetExt15",f:parsenoop},2098:{n:"BrtBeginTimelineStyles",f:parsenoop},2099:{n:"BrtEndTimelineStyles",f:parsenoop},2100:{n:"BrtBeginTimelineStyleElements",f:parsenoop},2101:{n:"BrtEndTimelineStyleElements",f:parsenoop},2102:{n:"BrtDxf15",f:parsenoop},2103:{n:"BrtBeginDxfs15",f:parsenoop},2104:{n:"brtEndDxfs15",f:parsenoop},2105:{n:"BrtSlicerCacheHideItemsWithNoData",f:parsenoop},2106:{n:"BrtBeginItemUniqueNames",f:parsenoop},2107:{n:"BrtEndItemUniqueNames",f:parsenoop},2108:{n:"BrtItemUniqueName",f:parsenoop},2109:{n:"BrtBeginExtConn15",f:parsenoop},2110:{n:"BrtEndExtConn15",f:parsenoop},2111:{n:"BrtBeginOledbPr15",f:parsenoop},2112:{n:"BrtEndOledbPr15",f:parsenoop},2113:{n:"BrtBeginDataFeedPr15",f:parsenoop},2114:{n:"BrtEndDataFeedPr15",f:parsenoop},2115:{n:"BrtTextPr15",f:parsenoop},2116:{n:"BrtRangePr15",f:parsenoop},2117:{n:"BrtDbCommand15",f:parsenoop},2118:{n:"BrtBeginDbTables15",f:parsenoop},2119:{n:"BrtEndDbTables15",f:parsenoop},2120:{n:"BrtDbTable15",f:parsenoop},2121:{n:"BrtBeginDataModel",f:parsenoop},2122:{n:"BrtEndDataModel",f:parsenoop},2123:{n:"BrtBeginModelTables",f:parsenoop},2124:{n:"BrtEndModelTables",f:parsenoop},2125:{n:"BrtModelTable",f:parsenoop},2126:{n:"BrtBeginModelRelationships",f:parsenoop},2127:{n:"BrtEndModelRelationships",f:parsenoop},2128:{n:"BrtModelRelationship",f:parsenoop},2129:{n:"BrtBeginECTxtWiz15",f:parsenoop},2130:{n:"BrtEndECTxtWiz15",f:parsenoop},2131:{n:"BrtBeginECTWFldInfoLst15",f:parsenoop},2132:{n:"BrtEndECTWFldInfoLst15",f:parsenoop},2133:{n:"BrtBeginECTWFldInfo15",f:parsenoop},2134:{n:"BrtFieldListActiveItem",f:parsenoop},2135:{n:"BrtPivotCacheIdVersion",f:parsenoop},2136:{n:"BrtSXDI15",f:parsenoop},65535:{n:"",f:parsenoop}};
function fix_opts(defaults){return function(opts){defaults.forEach(function(d){if(typeof opts[d[0]]==="undefined")opts[d[0]]=d[1];if(d[2]==="n")opts[d[0]]=Number(opts[d[0]])})}}var fix_read_opts=fix_opts([["cellNF",false],["cellHTML",true],["cellFormula",true],["sheetStubs",false],["sheetRows",0,"n"],["bookDeps",false],["bookSheets",false],["bookProps",false],["bookFiles",false],["bookVBA",false],["WTF",false]]);var fix_write_opts=fix_opts([["bookSST",false],["bookType","xlsx"],["WTF",false]]);function parse_zip(zip,opts){make_ssf(SSF);opts=opts||{};fix_read_opts(opts);reset_cp();var entries=keys(zip.files).filter(function(x){return x.substr(-1)!="/"}).sort();var dir=parse_ct(getzipdata(zip,"[Content_Types].xml"),opts);var xlsb=false;var sheets,binname;if(dir.workbooks.length===0){binname="xl/workbook.xml";if(getzipdata(zip,binname,true))dir.workbooks.push(binname)}if(dir.workbooks.length===0){binname="xl/workbook.bin";if(!getzipfile(zip,binname,true))throw new Error("Could not find workbook");dir.workbooks.push(binname);xlsb=true}if(xlsb)set_cp(1200);if(!opts.bookSheets&&!opts.bookProps){strs=[];if(dir.sst)strs=parse_sst(getzipdata(zip,dir.sst.replace(/^\//,"")),dir.sst,opts);styles={};if(dir.style)styles=parse_sty(getzipdata(zip,dir.style.replace(/^\//,"")),dir.style,opts)}var wb=parse_wb(getzipdata(zip,dir.workbooks[0].replace(/^\//,"")),dir.workbooks[0],opts);var props={},propdata="";if(dir.coreprops.length!==0){propdata=getzipdata(zip,dir.coreprops[0].replace(/^\//,""),true);if(propdata)props=parse_core_props(propdata);if(dir.extprops.length!==0){propdata=getzipdata(zip,dir.extprops[0].replace(/^\//,""),true);if(propdata)parse_ext_props(propdata,props)}}var custprops={};if(!opts.bookSheets||opts.bookProps){if(dir.custprops.length!==0){propdata=getzipdata(zip,dir.custprops[0].replace(/^\//,""),true);if(propdata)custprops=parse_cust_props(propdata,opts)}}var out={};if(opts.bookSheets||opts.bookProps){if(props.Worksheets&&props.SheetNames.length>0)sheets=props.SheetNames;else if(wb.Sheets)sheets=wb.Sheets.map(function(x){return x.name});if(opts.bookProps){out.Props=props;out.Custprops=custprops}if(typeof sheets!=="undefined")out.SheetNames=sheets;if(opts.bookSheets?out.SheetNames:opts.bookProps)return out}sheets={};var deps={};if(opts.bookDeps&&dir.calcchain)deps=parse_cc(getzipdata(zip,dir.calcchain.replace(/^\//,"")),dir.calcchain,opts);var i=0;var sheetRels={};var path,relsPath;if(!props.Worksheets){var wbsheets=wb.Sheets;props.Worksheets=wbsheets.length;props.SheetNames=[];for(var j=0;j!=wbsheets.length;++j){props.SheetNames[j]=wbsheets[j].name}}var wbrelsfile="xl/_rels/workbook.xml.rels";var wbrels=parse_rels(getzipdata(zip,wbrelsfile,true),wbrelsfile);if(wbrels)try{wbrels=wb.Sheets.map(function(w){return[w.name,wbrels["!id"][w.id].Target]})}catch(e){wbrels=null}var nmode=getzipdata(zip,"xl/worksheets/sheet.xml",true)?1:0;for(i=0;i!=props.Worksheets;++i){try{if(wbrels)path="xl/"+wbrels[i][1].replace(/[\/]?xl\//,"");else{path="xl/worksheets/sheet"+(i+1-nmode)+(xlsb?".bin":".xml");path=path.replace(/sheet0\./,"sheet.")}relsPath=path.replace(/^(.*)(\/)([^\/]*)$/,"$1/_rels/$3.rels");sheetRels[props.SheetNames[i]]=parse_rels(getzipdata(zip,relsPath,true),path);sheets[props.SheetNames[i]]=parse_ws(getzipdata(zip,path),path,opts,sheetRels[props.SheetNames[i]])}catch(e){if(opts.WTF)throw e}}if(dir.comments)parse_comments(zip,dir.comments,sheets,sheetRels,opts);out={Directory:dir,Workbook:wb,Props:props,Custprops:custprops,Deps:deps,Sheets:sheets,SheetNames:props.SheetNames,Strings:strs,Styles:styles,SSF:SSF.get_table()};if(opts.bookFiles){out.keys=entries;out.files=zip.files}if(opts.bookVBA){if(dir.vba.length>0)out.vbaraw=getzipdata(zip,dir.vba[0],true);else if(dir.defaults.bin==="application/vnd.ms-office.vbaProject")out.vbaraw=getzipdata(zip,"xl/vbaProject.bin",true)}return out}function add_rels(rels,rId,f,type,relobj){if(!relobj)relobj={};if(!rels["!id"])rels["!id"]={};relobj.Id="rId"+rId;relobj.Type=type;relobj.Target=f;if(rels["!id"][relobj.Id])throw new Error("Cannot rewrite rId "+rId);rels["!id"][relobj.Id]=relobj;rels[("/"+relobj.Target).replace("//","/")]=relobj}function write_zip(wb,opts){if(wb&&!wb.SSF){wb.SSF=SSF.get_table()}if(wb&&wb.SSF){make_ssf(SSF);SSF.load_table(wb.SSF);opts.revssf=evert(wb.SSF);opts.revssf[wb.SSF[65535]]=0}opts.rels={};opts.wbrels={};opts.Strings=[];opts.Strings.Count=0;opts.Strings.Unique=0;var wbext=opts.bookType=="xlsb"?"bin":"xml";var ct={workbooks:[],sheets:[],calcchains:[],themes:[],styles:[],coreprops:[],extprops:[],custprops:[],strs:[],comments:[],vba:[],TODO:[],rels:[],xmlns:""};fix_write_opts(opts=opts||{});var zip=new jszip;var f="",rId=0;opts.cellXfs=[];get_cell_style(opts.cellXfs,{},{revssf:{General:0}});f="docProps/core.xml";zip.file(f,write_core_props(wb.Props,opts));ct.coreprops.push(f);add_rels(opts.rels,2,f,RELS.CORE_PROPS);f="docProps/app.xml";if(!wb.Props)wb.Props={};wb.Props.SheetNames=wb.SheetNames;wb.Props.Worksheets=wb.SheetNames.length;zip.file(f,write_ext_props(wb.Props,opts));ct.extprops.push(f);add_rels(opts.rels,3,f,RELS.EXT_PROPS);if(wb.Custprops!==wb.Props){f="docProps/custom.xml";zip.file(f,write_cust_props(wb.Custprops,opts));ct.custprops.push(f);add_rels(opts.rels,4,f,RELS.CUST_PROPS)}f="xl/workbook."+wbext;zip.file(f,write_wb(wb,f,opts));ct.workbooks.push(f);add_rels(opts.rels,1,f,RELS.WB);wb.SheetNames.forEach(function(s,i){rId=i+1;f="xl/worksheets/sheet"+rId+"."+wbext;zip.file(f,write_ws(i,f,opts,wb));ct.sheets.push(f);add_rels(opts.wbrels,rId,"worksheets/sheet"+rId+"."+wbext,RELS.WS)});if((opts.Strings||[]).length>0){f="xl/sharedStrings."+wbext;zip.file(f,write_sst(opts.Strings,f,opts));ct.strs.push(f);add_rels(opts.wbrels,++rId,"sharedStrings."+wbext,RELS.SST)}f="xl/theme/theme1.xml";zip.file(f,write_theme());ct.themes.push(f);add_rels(opts.wbrels,++rId,"theme/theme1.xml",RELS.THEME);f="xl/styles.xml";zip.file(f,write_sty(wb,f,opts));ct.styles.push(f);add_rels(opts.wbrels,++rId,"styles."+wbext,RELS.STY);zip.file("[Content_Types].xml",write_ct(ct,opts));zip.file("_rels/.rels",write_rels(opts.rels));zip.file("xl/_rels/workbook.xml.rels",write_rels(opts.wbrels));return zip}function readSync(data,opts){var zip,d=data;var o=opts||{};if(!o.type)o.type=typeof Buffer!=="undefined"&&data instanceof Buffer?"buffer":"base64";switch(o.type){case"base64":zip=new jszip(d,{base64:true});break;case"binary":zip=new jszip(d,{base64:false});break;case"buffer":zip=new jszip(d);break;case"file":zip=new jszip(d=_fs.readFileSync(data));break;default:throw new Error("Unrecognized type "+o.type)}return parse_zip(zip,o)}function readFileSync(data,opts){var o=opts||{};o.type="file";return readSync(data,o)}function writeSync(wb,opts){var o=opts||{};var z=write_zip(wb,o);switch(o.type){case"base64":return z.generate({type:"base64"});case"binary":return z.generate({type:"string"});case"buffer":return z.generate({type:"nodebuffer"});case"file":return _fs.writeFileSync(o.file,z.generate({type:"nodebuffer"}));default:throw new Error("Unrecognized type "+o.type)}}function writeFileSync(wb,filename,opts){var o=opts||{};o.type="file";o.file=filename;switch(o.file.substr(-5).toLowerCase()){case".xlsm":o.bookType="xlsm";break;case".xlsb":o.bookType="xlsb";break}return writeSync(wb,o)}function decode_row(rowstr){return Number(unfix_row(rowstr))-1}function encode_row(row){return""+(row+1)}function fix_row(cstr){return cstr.replace(/([A-Z]|^)([0-9]+)$/,"$1$$$2")}function unfix_row(cstr){return cstr.replace(/\$([0-9]+)$/,"$1")}function decode_col(colstr){var c=unfix_col(colstr),d=0,i=0;for(;i!==c.length;++i)d=26*d+c.charCodeAt(i)-64;return d-1}function encode_col(col){var s="";for(++col;col;col=Math.floor((col-1)/26))s=_chr((col-1)%26+65)+s;return s}function fix_col(cstr){return cstr.replace(/^([A-Z])/,"$$$1")}function unfix_col(cstr){return cstr.replace(/^\$([A-Z])/,"$1")}function split_cell(cstr){return cstr.replace(/(\$?[A-Z]*)(\$?[0-9]*)/,"$1,$2").split(",")}function decode_cell(cstr){var splt=split_cell(cstr);return{c:decode_col(splt[0]),r:decode_row(splt[1])}}function encode_cell(cell){return encode_col(cell.c)+encode_row(cell.r)}function fix_cell(cstr){return fix_col(fix_row(cstr))}function unfix_cell(cstr){return unfix_col(unfix_row(cstr))}function decode_range(range){var x=range.split(":").map(decode_cell);return{s:x[0],e:x[x.length-1]}}function encode_range(cs,ce){if(typeof ce==="undefined"||typeof ce==="number")return encode_range(cs.s,cs.e);if(typeof cs!=="string")cs=encode_cell(cs);if(typeof ce!=="string")ce=encode_cell(ce);return cs==ce?cs:cs+":"+ce}function format_cell(cell,v){if(!cell||!cell.t)return"";if(typeof cell.w!=="undefined")return cell.w;if(typeof v==="undefined")v=cell.v;if(typeof cell.z!=="undefined")try{return cell.w=SSF.format(cell.z,v)}catch(e){}if(!cell.XF)return v;try{return cell.w=SSF.format(cell.XF.ifmt||0,v)}catch(e){return v}}function sheet_to_row_object_array(sheet,opts){var val,row,r,hdr={},isempty,R,C,v;var out=[];opts=opts||{};if(!sheet||!sheet["!ref"])return out;r=decode_range(sheet["!ref"]);for(R=r.s.r,C=r.s.c;C<=r.e.c;++C){val=sheet[encode_cell({c:C,r:R})];if(!val)continue;hdr[C]=format_cell(val)}for(R=r.s.r+1;R<=r.e.r;++R){isempty=true;row=Object.create({__rowNum__:R});for(C=r.s.c;C<=r.e.c;++C){val=sheet[encode_cell({c:C,r:R})];if(!val||!val.t)continue;v=(val||{}).v;switch(val.t){case"e":continue;case"s":case"str":break;case"b":case"n":break;default:throw"unrecognized type "+val.t}if(typeof v!=="undefined"){row[hdr[C]]=opts.raw?v||val.v:format_cell(val,v);isempty=false}}if(!isempty)out.push(row)}return out}function sheet_to_csv(sheet,opts){var out=[],txt="";opts=opts||{};if(!sheet||!sheet["!ref"])return"";var r=decode_range(sheet["!ref"]);var fs=opts.FS||",",rs=opts.RS||"\n";for(var R=r.s.r;R<=r.e.r;++R){var row=[];for(var C=r.s.c;C<=r.e.c;++C){var val=sheet[encode_cell({c:C,r:R})];if(!val){row.push("");continue}txt=String(format_cell(val));if(txt.indexOf(fs)!==-1||txt.indexOf(rs)!==-1||txt.indexOf('"')!==-1)txt='"'+txt.replace(/"/g,'""')+'"';row.push(txt)}out.push(row.join(fs))}return out.join(rs)+(out.length?rs:"")}var make_csv=sheet_to_csv;function get_formulae(ws){var cmds=[];for(var y in ws)if(y[0]!=="!"&&ws.hasOwnProperty(y)){var x=ws[y];var val="";if(x.f)val=x.f;else if(typeof x.w!=="undefined")val="'"+x.w;else if(typeof x.v==="undefined")continue;else val=x.v;cmds.push(y+"="+val)}return cmds}var utils={encode_col:encode_col,encode_row:encode_row,encode_cell:encode_cell,encode_range:encode_range,decode_col:decode_col,decode_row:decode_row,split_cell:split_cell,decode_cell:decode_cell,decode_range:decode_range,sheet_to_csv:sheet_to_csv,make_csv:sheet_to_csv,make_json:sheet_to_row_object_array,get_formulae:get_formulae,format_cell:format_cell,sheet_to_row_object_array:sheet_to_row_object_array};XLSX.parseZip=parse_zip;XLSX.read=readSync;XLSX.readFile=readFileSync;XLSX.write=writeSync;XLSX.writeFile=writeFileSync;XLSX.utils=utils;XLSX.SSF=SSF})(typeof exports!=="undefined"?exports:XLSX);
//# sourceMappingURL=dist/xlsx.min.map