/*
 A JavaScript implementation of the SHA family of hashes, as
 defined in FIPS PUB 180-2 as well as the corresponding HMAC implementation
 as defined in FIPS PUB 198a

 Copyright Brian Turek 2008-2015
 Distributed under the BSD License
 See http://caligatio.github.com/jsSHA/ for more information

 Several functions taken from Paul Johnston
*/
'use strict';(function(E){function n(c,b,f){var a=0,d=[0],e="",g=null,e=f||"UTF8";if("UTF8"!==e&&"UTF16BE"!==e&&"UTF16LE"!==e)throw"encoding must be UTF8, UTF16BE, or UTF16LE";if("HEX"===b){if(0!==c.length%2)throw"srcString of HEX type must be in byte increments";g=w(c);a=g.binLen;d=g.value}else if("TEXT"===b||"ASCII"===b)g=x(c,e),a=g.binLen,d=g.value;else if("B64"===b)g=y(c),a=g.binLen,d=g.value;else if("BYTES"===b)g=z(c),a=g.binLen,d=g.value;else throw"inputFormat must be HEX, TEXT, ASCII, B64, or BYTES";
this.getHash=function(c,b,e,f){var g=null,h=d.slice(),m=a,p;3===arguments.length?"number"!==typeof e&&(f=e,e=1):2===arguments.length&&(e=1);if(e!==parseInt(e,10)||1>e)throw"numRounds must a integer >= 1";switch(b){case "HEX":g=A;break;case "B64":g=B;break;case "BYTES":g=C;break;default:throw"format must be HEX, B64, or BYTES";}if("SHA-1"===c)for(p=0;p<e;p+=1)h=u(h,m),m=160;else throw"Chosen SHA variant is not supported";return g(h,D(f))};this.getHMAC=function(c,b,f,g,r){var h,m,p,t,n=[],v=[];h=null;
switch(g){case "HEX":g=A;break;case "B64":g=B;break;case "BYTES":g=C;break;default:throw"outputFormat must be HEX, B64, or BYTES";}if("SHA-1"===f)m=64,t=160;else throw"Chosen SHA variant is not supported";if("HEX"===b)h=w(c),p=h.binLen,h=h.value;else if("TEXT"===b||"ASCII"===b)h=x(c,e),p=h.binLen,h=h.value;else if("B64"===b)h=y(c),p=h.binLen,h=h.value;else if("BYTES"===b)h=z(c),p=h.binLen,h=h.value;else throw"inputFormat must be HEX, TEXT, ASCII, B64, or BYTES";c=8*m;b=m/4-1;if(m<p/8){if("SHA-1"===
f)h=u(h,p);else throw"Unexpected error in HMAC implementation";for(;h.length<=b;)h.push(0);h[b]&=4294967040}else if(m>p/8){for(;h.length<=b;)h.push(0);h[b]&=4294967040}for(m=0;m<=b;m+=1)n[m]=h[m]^909522486,v[m]=h[m]^1549556828;if("SHA-1"===f)f=u(v.concat(u(n.concat(d),c+a)),c+t);else throw"Unexpected error in HMAC implementation";return g(f,D(r))}}function x(c,b){var f=[],a,d=[],e=0,g,k,q;if("UTF8"===b)for(g=0;g<c.length;g+=1)for(a=c.charCodeAt(g),d=[],128>a?d.push(a):2048>a?(d.push(192|a>>>6),d.push(128|
a&63)):55296>a||57344<=a?d.push(224|a>>>12,128|a>>>6&63,128|a&63):(g+=1,a=65536+((a&1023)<<10|c.charCodeAt(g)&1023),d.push(240|a>>>18,128|a>>>12&63,128|a>>>6&63,128|a&63)),k=0;k<d.length;k+=1){for(q=e>>>2;f.length<=q;)f.push(0);f[q]|=d[k]<<24-e%4*8;e+=1}else if("UTF16BE"===b||"UTF16LE"===b)for(g=0;g<c.length;g+=1){a=c.charCodeAt(g);"UTF16LE"===b&&(k=a&255,a=k<<8|a>>8);for(q=e>>>2;f.length<=q;)f.push(0);f[q]|=a<<16-e%4*8;e+=2}return{value:f,binLen:8*e}}function w(c){var b=[],f=c.length,a,d,e;if(0!==
f%2)throw"String of HEX type must be in byte increments";for(a=0;a<f;a+=2){d=parseInt(c.substr(a,2),16);if(isNaN(d))throw"String of HEX type contains invalid characters";for(e=a>>>3;b.length<=e;)b.push(0);b[a>>>3]|=d<<24-a%8*4}return{value:b,binLen:4*f}}function z(c){var b=[],f,a,d;for(a=0;a<c.length;a+=1)f=c.charCodeAt(a),d=a>>>2,b.length<=d&&b.push(0),b[d]|=f<<24-a%4*8;return{value:b,binLen:8*c.length}}function y(c){var b=[],f=0,a,d,e,g,k;if(-1===c.search(/^[a-zA-Z0-9=+\/]+$/))throw"Invalid character in base-64 string";
d=c.indexOf("=");c=c.replace(/\=/g,"");if(-1!==d&&d<c.length)throw"Invalid '=' found in base-64 string";for(d=0;d<c.length;d+=4){k=c.substr(d,4);for(e=g=0;e<k.length;e+=1)a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(k[e]),g|=a<<18-6*e;for(e=0;e<k.length-1;e+=1){for(a=f>>>2;b.length<=a;)b.push(0);b[a]|=(g>>>16-8*e&255)<<24-f%4*8;f+=1}}return{value:b,binLen:8*f}}function A(c,b){var f="",a=4*c.length,d,e;for(d=0;d<a;d+=1)e=c[d>>>2]>>>8*(3-d%4),f+="0123456789abcdef".charAt(e>>>
4&15)+"0123456789abcdef".charAt(e&15);return b.outputUpper?f.toUpperCase():f}function B(c,b){var f="",a=4*c.length,d,e,g;for(d=0;d<a;d+=3)for(g=d+1>>>2,e=c.length<=g?0:c[g],g=d+2>>>2,g=c.length<=g?0:c[g],g=(c[d>>>2]>>>8*(3-d%4)&255)<<16|(e>>>8*(3-(d+1)%4)&255)<<8|g>>>8*(3-(d+2)%4)&255,e=0;4>e;e+=1)8*d+6*e<=32*c.length?f+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(g>>>6*(3-e)&63):f+=b.b64Pad;return f}function C(c){var b="",f=4*c.length,a,d;for(a=0;a<f;a+=1)d=c[a>>>2]>>>
8*(3-a%4)&255,b+=String.fromCharCode(d);return b}function D(c){var b={outputUpper:!1,b64Pad:"="};try{c.hasOwnProperty("outputUpper")&&(b.outputUpper=c.outputUpper),c.hasOwnProperty("b64Pad")&&(b.b64Pad=c.b64Pad)}catch(f){}if("boolean"!==typeof b.outputUpper)throw"Invalid outputUpper formatting option";if("string"!==typeof b.b64Pad)throw"Invalid b64Pad formatting option";return b}function r(c,b){return c<<b|c>>>32-b}function t(c,b){var f=(c&65535)+(b&65535);return((c>>>16)+(b>>>16)+(f>>>16)&65535)<<
16|f&65535}function v(c,b,f,a,d){var e=(c&65535)+(b&65535)+(f&65535)+(a&65535)+(d&65535);return((c>>>16)+(b>>>16)+(f>>>16)+(a>>>16)+(d>>>16)+(e>>>16)&65535)<<16|e&65535}function u(c,b){var f=[],a,d,e,g,k,q,n,l,u,h=[1732584193,4023233417,2562383102,271733878,3285377520];for(a=(b+65>>>9<<4)+15;c.length<=a;)c.push(0);c[b>>>5]|=128<<24-b%32;c[a]=b;u=c.length;for(n=0;n<u;n+=16){a=h[0];d=h[1];e=h[2];g=h[3];k=h[4];for(l=0;80>l;l+=1)f[l]=16>l?c[l+n]:r(f[l-3]^f[l-8]^f[l-14]^f[l-16],1),q=20>l?v(r(a,5),d&e^
~d&g,k,1518500249,f[l]):40>l?v(r(a,5),d^e^g,k,1859775393,f[l]):60>l?v(r(a,5),d&e^d&g^e&g,k,2400959708,f[l]):v(r(a,5),d^e^g,k,3395469782,f[l]),k=g,g=e,e=r(d,30),d=a,a=q;h[0]=t(a,h[0]);h[1]=t(d,h[1]);h[2]=t(e,h[2]);h[3]=t(g,h[3]);h[4]=t(k,h[4])}return h}"function"===typeof define&&define.amd?define(function(){return n}):"undefined"!==typeof exports?"undefined"!==typeof module&&module.exports?module.exports=exports=n:exports=n:E.jsSHA=n})(this);
