/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, and format JSON.
 * It shows data a clear, editable treeview.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2015 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 4.1.3
 * @date    2015-03-17
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(this,function(){return function(e){function t(n){if(i[n])return i[n].exports;var o=i[n]={exports:{},id:n,loaded:!1};return e[n].call(o.exports,o,o.exports,t),o.loaded=!0,o.exports}var i={};return t.m=e,t.c=i,t.p="",t(0)}([function(e,t,i){function n(e,t,i){if(!(this instanceof n))throw new Error('JSONEditor constructor called without "new".');var o=s.getInternetExplorerVersion();if(-1!=o&&9>o)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");arguments.length&&this._create(e,t,i)}var o=i(1),r=i(2),s=i(3);n.modes={},n.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||"tree";this.setMode(n)},n.prototype._delete=function(){},n.prototype.set=function(e){this.json=e},n.prototype.get=function(){return this.json},n.prototype.setText=function(e){this.json=s.parse(e)},n.prototype.getText=function(){return JSON.stringify(this.json)},n.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},n.prototype.getName=function(){return this.options&&this.options.name},n.prototype.setMode=function(e){var t,i,o=this.container,r=s.extend({},this.options);r.mode=e;var a=n.modes[e];if(!a)throw new Error('Unknown mode "'+r.mode+'"');try{var l="text"==a.data;if(i=this.getName(),t=this[l?"getText":"get"](),this._delete(),s.clear(this),s.extend(this,a.mixin),this.create(o,r),this.setName(i),this[l?"setText":"set"](t),"function"==typeof a.load)try{a.load.call(this)}catch(c){}}catch(c){this._onError(c)}},n.prototype._onError=function(e){if("function"==typeof this.onError&&(s.log("WARNING: JSONEditor.onError is deprecated. Use options.error instead."),this.onError(e)),!this.options||"function"!=typeof this.options.error)throw e;this.options.error(e)},n.registerMode=function(e){var t,i;if(s.isArray(e))for(t=0;t<e.length;t++)n.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var o=e.mode;if(o in n.modes)throw new Error('Mode "'+o+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var r=["setMode","registerMode","modes"];for(t=0;t<r.length;t++)if(i=r[t],i in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');n.modes[o]=e}},n.registerMode(o),n.registerMode(r),e.exports=n},function(e,t,i){var n=i(4),o=i(5),r=i(6),s=i(7),a=i(8),l=i(3),c={};c.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new n,this.selection=void 0,this._setOptions(t),this.options.history&&"view"!==this.options.mode&&(this.history=new o(this)),this._createFrame(),this._createTable()},c._delete=function(){this.frame&&this.container&&this.frame.parentNode==this.container&&this.container.removeChild(this.frame)},c._setOptions=function(e){if(this.options={search:!0,history:!0,mode:"tree",name:void 0},e)for(var t in e)e.hasOwnProperty(t)&&(this.options[t]=e[t])};var h=void 0,u=null;c.set=function(e,t){if(t&&(l.log('Warning: second parameter "name" is deprecated. Use setName(name) instead.'),this.options.name=t),e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var i={field:this.options.name,value:e},n=new s(this,i);this._setRoot(n);var o=!1;this.node.expand(o),this.content.appendChild(this.table)}this.history&&this.history.clear()},c.get=function(){return h&&h.blur(),this.node?this.node.getValue():void 0},c.getText=function(){return JSON.stringify(this.get())},c.setText=function(e){this.set(l.parse(e))},c.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},c.getName=function(){return this.options.name},c.focus=function(){var e=this.content.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"),e&&e.focus())},c.clear=function(){this.node&&(this.node.collapse(),this.tbody.removeChild(this.node.getDom()),delete this.node)},c._setRoot=function(e){this.clear(),this.node=e,this.tbody.appendChild(e.getDom())},c.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},c.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},c.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},c._onAction=function(e,t){if(this.history&&this.history.add(e,t),this.options.change)try{this.options.change()}catch(i){l.log("Error in change callback: ",i)}},c.startAutoScroll=function(e){var t=this,i=this.content,n=l.getAbsoluteTop(i),o=i.clientHeight,r=n+o,s=24,a=50;this.autoScrollStep=n+s>e&&i.scrollTop>0?(n+s-e)/3:e>r-s&&o+i.scrollTop<i.scrollHeight?(r-s-e)/3:void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},a)):this.stopAutoScroll()},c.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},c.setSelection=function(e){e&&("scrollTop"in e&&this.content&&(this.content.scrollTop=e.scrollTop),e.range&&l.setSelectionOffset(e.range),e.dom&&e.dom.focus())},c.getSelection=function(){return{dom:u,scrollTop:this.content?this.content.scrollTop:0,range:l.getSelectionOffset()}},c.scrollTo=function(e,t){var i=this.content;if(i){var n=this;n.animateTimeout&&(clearTimeout(n.animateTimeout),delete n.animateTimeout),n.animateCallback&&(n.animateCallback(!1),delete n.animateCallback);var o=i.clientHeight,r=i.scrollHeight-o,s=Math.min(Math.max(e-o/4,0),r),a=function(){var e=i.scrollTop,o=s-e;Math.abs(o)>3?(i.scrollTop+=o/3,n.animateCallback=t,n.animateTimeout=setTimeout(a,50)):(t&&t(!0),i.scrollTop=s,delete n.animateTimeout,delete n.animateCallback)};a()}else t&&t(!1)},c._createFrame=function(){function e(e){t._onEvent(e)}this.frame=document.createElement("div"),this.frame.className="jsoneditor",this.container.appendChild(this.frame);var t=this;this.frame.onclick=function(t){var i=t.target;e(t),"BUTTON"==i.nodeName&&t.preventDefault()},this.frame.oninput=e,this.frame.onchange=e,this.frame.onkeydown=e,this.frame.onkeyup=e,this.frame.oncut=e,this.frame.onpaste=e,this.frame.onmousedown=e,this.frame.onmouseup=e,this.frame.onmouseover=e,this.frame.onmouseout=e,l.addEventListener(this.frame,"focus",e,!0),l.addEventListener(this.frame,"blur",e,!0),this.frame.onfocusin=e,this.frame.onfocusout=e,this.menu=document.createElement("div"),this.menu.className="menu",this.frame.appendChild(this.menu);var i=document.createElement("button");i.className="expand-all",i.title="Expand all fields",i.onclick=function(){t.expandAll()},this.menu.appendChild(i);var n=document.createElement("button");if(n.title="Collapse all fields",n.className="collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n),this.history){var o=document.createElement("button");o.className="undo separator",o.title="Undo last action (Ctrl+Z)",o.onclick=function(){t._onUndo()},this.menu.appendChild(o),this.dom.undo=o;var s=document.createElement("button");s.className="redo",s.title="Redo (Ctrl+Shift+Z)",s.onclick=function(){t._onRedo()},this.menu.appendChild(s),this.dom.redo=s,this.history.onChange=function(){o.disabled=!t.history.canUndo(),s.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var c=a.create(this,this.options.modes,this.options.mode);this.menu.appendChild(c),this.dom.modeBox=c}this.options.search&&(this.searchBox=new r(this,this.menu))},c._onUndo=function(){this.history&&(this.history.undo(),this.options.change&&this.options.change())},c._onRedo=function(){this.history&&(this.history.redo(),this.options.change&&this.options.change())},c._onEvent=function(e){var t=e.target;"keydown"==e.type&&this._onKeyDown(e),"focus"==e.type&&(u=t);var i=s.getNodeFromTarget(t);i&&i.onEvent(e)},c._onKeyDown=function(e){var t=e.which||e.keyCode,i=e.ctrlKey,n=e.shiftKey,o=!1;if(9==t&&setTimeout(function(){l.selectContentEditable(u)},0),this.searchBox)if(i&&70==t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),o=!0;else if(114==t||i&&71==t){var r=!0;n?this.searchBox.previous(r):this.searchBox.next(r),o=!0}this.history&&(i&&!n&&90==t?(this._onUndo(),o=!0):i&&n&&90==t&&(this._onRedo(),o=!0)),o&&(e.preventDefault(),e.stopPropagation())},c._createTable=function(){var e=document.createElement("div");e.className="outer",this.contentOuter=e,this.content=document.createElement("div"),this.content.className="tree",e.appendChild(this.content),this.table=document.createElement("table"),this.table.className="tree",this.content.appendChild(this.table);var t;this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&(t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t)),t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t),t=document.createElement("col"),this.colgroupContent.appendChild(t),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(e)},e.exports=[{mode:"tree",mixin:c,data:"json"},{mode:"view",mixin:c,data:"json"},{mode:"form",mixin:c,data:"json"}]},function(e,t,i){var n;try{n=i(9)}catch(o){}var r=i(8),s=i(3),a={};a.create=function(e,t){t=t||{},this.options=t,this.indentation=t.indentation?Number(t.indentation):2,this.mode="code"==t.mode?"code":"text","code"==this.mode&&"undefined"==typeof n&&(this.mode="text",s.log("WARNING: Cannot load code editor, Ace library not loaded. Falling back to plain text editor"));var i=this;this.container=e,this.dom={},this.editor=void 0,this.textarea=void 0,this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor",this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){i._onKeyDown(e)},this.menu=document.createElement("div"),this.menu.className="menu",this.frame.appendChild(this.menu);var o=document.createElement("button");o.className="format",o.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(o),o.onclick=function(){try{i.format()}catch(e){i._onError(e)}};var a=document.createElement("button");if(a.className="compact",a.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(a),a.onclick=function(){try{i.compact()}catch(e){i._onError(e)}},this.options&&this.options.modes&&this.options.modes.length){var l=r.create(this,this.options.modes,this.options.mode);this.menu.appendChild(l),this.dom.modeBox=l}if(this.content=document.createElement("div"),this.content.className="outer",this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"==this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var c=n.edit(this.editorDom);c.setTheme("ace/theme/jsoneditor"),c.setShowPrintMargin(!1),c.setFontSize(13),c.getSession().setMode("ace/mode/json"),c.getSession().setTabSize(this.indentation),c.getSession().setUseSoftTabs(!0),c.getSession().setUseWrapMode(!0),this.editor=c;var h=document.createElement("a");h.appendChild(document.createTextNode("powered by ace")),h.href="http://ace.ajax.org",h.target="_blank",h.className="poweredBy",h.onclick=function(){window.open(h.href,h.target)},this.menu.appendChild(h),t.change&&c.on("change",function(){t.change()})}else{var u=document.createElement("textarea");u.className="text",u.spellcheck=!1,this.content.appendChild(u),this.textarea=u,t.change&&(null===this.textarea.oninput?this.textarea.oninput=function(){t.change()}:this.textarea.onchange=function(){t.change()})}},a._onKeyDown=function(e){var t=e.which||e.keyCode,i=!1;220==t&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),i=!0),i&&(e.preventDefault(),e.stopPropagation())},a._delete=function(){this.frame&&this.container&&this.frame.parentNode==this.container&&this.container.removeChild(this.frame)},a._onError=function(e){if("function"==typeof this.onError&&(s.log("WARNING: JSONEditor.onError is deprecated. Use options.error instead."),this.onError(e)),!this.options||"function"!=typeof this.options.error)throw e;this.options.error(e)},a.compact=function(){var e=this.get(),t=JSON.stringify(e);this.setText(t)},a.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this.setText(t)},a.focus=function(){this.textarea&&this.textarea.focus(),this.editor&&this.editor.focus()},a.resize=function(){if(this.editor){var e=!1;this.editor.resize(e)}},a.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},a.get=function(){var e,t=this.getText();try{e=s.parse(t)}catch(i){t=s.sanitize(t),this.setText(t),e=s.parse(t)}return e},a.getText=function(){return this.textarea?this.textarea.value:this.editor?this.editor.getValue():""},a.setText=function(e){this.textarea&&(this.textarea.value=e),this.editor&&this.editor.setValue(e,-1)},e.exports=[{mode:"text",mixin:a,data:"text",load:a.format},{mode:"code",mixin:a,data:"text",load:a.format}]},function(e,t,i){var n=i(12);t.parse=function(e){try{return JSON.parse(e)}catch(i){throw t.validate(e),i}},t.sanitize=function(e){function t(){return e.charAt(c)}function i(){return e.charAt(c+1)}function n(){return e.charAt(c-1)}function o(){for(var t=c-1;t>=0;){var i=e.charAt(t);if("{"===i)return!0;if(" "!==i&&"\n"!==i&&"\r"!==i)return!1;t--}return!1}function r(){for(c+=2;c<e.length&&("*"!==t()||"/"!==i());)c++;c+=2}function s(i){l.push('"'),c++;for(var o=t();c<e.length&&o!==i;)'"'===o&&"\\"!==n()&&l.push("\\"),"\\"===o&&(c++,o=t(),"'"!==o&&l.push("\\")),l.push(o),c++,o=t();o===i&&(l.push('"'),c++)}function a(){for(var e=["null","true","false"],i="",n=t(),o=/[a-zA-Z_$\d]/;o.test(n);)i+=n,c++,n=t();l.push(-1===e.indexOf(i)?'"'+i+'"':i)}var l=[],c=0,h=e.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);for(h&&(e=h[3]);c<e.length;){var u=t();"/"===u&&"*"===i()?r():"'"===u||'"'===u?s(u):/[a-zA-Z_$]/.test(u)&&o()?a():(l.push(u),c++)}return l.join("")},t.validate=function(e){"undefined"!=typeof n?n.parse(e):JSON.parse(e)},t.extend=function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},t.clear=function(e){for(var t in e)e.hasOwnProperty(t)&&delete e[t];return e},t.log=function(){"undefined"!=typeof console&&"function"==typeof console.log&&console.log.apply(console,arguments)},t.type=function(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp||"regexp"==typeof e?"regexp":t.isArray(e)?"array":"object"};var o=/^https?:\/\/\S+$/;t.isUrl=function(e){return("string"==typeof e||e instanceof String)&&o.test(e)},t.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)},t.getAbsoluteLeft=function(e){var t=e.getBoundingClientRect();return t.left+window.pageXOffset||document.scrollLeft||0},t.getAbsoluteTop=function(e){var t=e.getBoundingClientRect();return t.top+window.pageYOffset||document.scrollTop||0},t.addClassName=function(e,t){var i=e.className.split(" ");-1==i.indexOf(t)&&(i.push(t),e.className=i.join(" "))},t.removeClassName=function(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!=n&&(i.splice(n,1),e.className=i.join(" "))},t.stripFormatting=function(e){for(var i=e.childNodes,n=0,o=i.length;o>n;n++){var r=i[n];r.style&&r.removeAttribute("style");var s=r.attributes;if(s)for(var a=s.length-1;a>=0;a--){var l=s[a];l.specified===!0&&r.removeAttribute(l.name)}t.stripFormatting(r)}},t.setEndOfContentEditable=function(e){var t,i;document.createRange&&(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),i=window.getSelection(),i.removeAllRanges(),i.addRange(t))},t.selectContentEditable=function(e){if(e&&"DIV"==e.nodeName){var t,i;window.getSelection&&document.createRange&&(i=document.createRange(),i.selectNodeContents(e),t=window.getSelection(),t.removeAllRanges(),t.addRange(i))}},t.getSelection=function(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null},t.setSelection=function(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}},t.getSelectionOffset=function(){var e=t.getSelection();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer==e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null},t.setSelectionOffset=function(e){if(document.createRange&&window.getSelection){var i=window.getSelection();if(i){var n=document.createRange();n.setStart(e.container.firstChild,e.startOffset),n.setEnd(e.container.firstChild,e.endOffset),t.setSelection(n)}}},t.getInnerText=function(e,i){var n=void 0==i;if(n&&(i={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return i.flush()+e.nodeValue;if(e.hasChildNodes()){for(var o=e.childNodes,r="",s=0,a=o.length;a>s;s++){var l=o[s];if("DIV"==l.nodeName||"P"==l.nodeName){var c=o[s-1],h=c?c.nodeName:void 0;h&&"DIV"!=h&&"P"!=h&&"BR"!=h&&(r+="\n",i.flush()),r+=t.getInnerText(l,i),i.set("\n")}else"BR"==l.nodeName?(r+=i.flush(),i.set("\n")):r+=t.getInnerText(l,i)}return r}return"P"==e.nodeName&&-1!=t.getInternetExplorerVersion()?i.flush():""},t.getInternetExplorerVersion=function(){if(-1==r){var e=-1;if("Microsoft Internet Explorer"==navigator.appName){var t=navigator.userAgent,i=new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})");null!=i.exec(t)&&(e=parseFloat(RegExp.$1))}r=e}return r},t.isFirefox=function(){return-1!=navigator.userAgent.indexOf("Firefox")};var r=-1;t.addEventListener=function(e,i,n,o){if(e.addEventListener)return void 0===o&&(o=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.addEventListener(i,n,o),n;if(e.attachEvent){var r=function(){return n.call(e,window.event)};return e.attachEvent("on"+i,r),r}},t.removeEventListener=function(e,i,n,o){e.removeEventListener?(void 0===o&&(o=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.removeEventListener(i,n,o)):e.detachEvent&&e.detachEvent("on"+i,n)}},function(e){function t(){this.locked=!1}t.prototype.highlight=function(e){this.locked||(this.node!=e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())},t.prototype.unhighlight=function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},t.prototype._cancelUnhighlight=function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)},t.prototype.lock=function(){this.locked=!0},t.prototype.unlock=function(){this.locked=!1},e.exports=t},function(e,t,i){function n(e){this.editor=e,this.clear(),this.actions={editField:{undo:function(e){e.node.updateField(e.oldValue)},redo:function(e){e.node.updateField(e.newValue)}},editValue:{undo:function(e){e.node.updateValue(e.oldValue)},redo:function(e){e.node.updateValue(e.newValue)}},appendNode:{undo:function(e){e.parent.removeChild(e.node)},redo:function(e){e.parent.appendChild(e.node)}},insertBeforeNode:{undo:function(e){e.parent.removeChild(e.node)},redo:function(e){e.parent.insertBefore(e.node,e.beforeNode)}},insertAfterNode:{undo:function(e){e.parent.removeChild(e.node)},redo:function(e){e.parent.insertAfter(e.node,e.afterNode)}},removeNode:{undo:function(e){var t=e.parent,i=t.childs[e.index]||t.append;t.insertBefore(e.node,i)},redo:function(e){e.parent.removeChild(e.node)}},duplicateNode:{undo:function(e){e.parent.removeChild(e.clone)},redo:function(e){e.parent.insertAfter(e.clone,e.node)}},changeType:{undo:function(e){e.node.changeType(e.oldType)},redo:function(e){e.node.changeType(e.newType)}},moveNode:{undo:function(e){e.startParent.moveTo(e.node,e.startIndex)},redo:function(e){e.endParent.moveTo(e.node,e.endIndex)}},sort:{undo:function(e){var t=e.node;t.hideChilds(),t.sort=e.oldSort,t.childs=e.oldChilds,t.showChilds()},redo:function(e){var t=e.node;t.hideChilds(),t.sort=e.newSort,t.childs=e.newChilds,t.showChilds()}}}}var o=i(3);n.prototype.onChange=function(){},n.prototype.add=function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()},n.prototype.clear=function(){this.history=[],this.index=-1,this.onChange()},n.prototype.canUndo=function(){return this.index>=0},n.prototype.canRedo=function(){return this.index<this.history.length-1},n.prototype.undo=function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.undo?(t.undo(e.params),e.params.oldSelection&&this.editor.setSelection(e.params.oldSelection)):o.log('Error: unknown action "'+e.action+'"')}this.index--,this.onChange()}},n.prototype.redo=function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.redo?(t.redo(e.params),e.params.newSelection&&this.editor.setSelection(e.params.newSelection)):o.log('Error: unknown action "'+e.action+'"')}this.onChange()}},e.exports=n},function(e){function t(e,t){var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.dom={},this.dom.container=t;var n=document.createElement("table");this.dom.table=n,n.className="search",t.appendChild(n);var o=document.createElement("tbody");this.dom.tbody=o,n.appendChild(o);var r=document.createElement("tr");o.appendChild(r);var s=document.createElement("td");r.appendChild(s);var a=document.createElement("div");this.dom.results=a,a.className="results",s.appendChild(a),s=document.createElement("td"),r.appendChild(s);var l=document.createElement("div");this.dom.input=l,l.className="frame",l.title="Search fields and values",s.appendChild(l);var c=document.createElement("table");l.appendChild(c);var h=document.createElement("tbody");c.appendChild(h),r=document.createElement("tr"),h.appendChild(r);var u=document.createElement("button");u.className="refresh",s=document.createElement("td"),s.appendChild(u),r.appendChild(s);var d=document.createElement("input");this.dom.search=d,d.oninput=function(e){i._onDelayedSearch(e)},d.onchange=function(e){i._onSearch(e)},d.onkeydown=function(e){i._onKeyDown(e)},d.onkeyup=function(e){i._onKeyUp(e)},u.onclick=function(){d.select()},s=document.createElement("td"),s.appendChild(d),r.appendChild(s);var g=document.createElement("button");g.title="Next result (Enter)",g.className="next",g.onclick=function(){i.next()},s=document.createElement("td"),s.appendChild(g),r.appendChild(s);var f=document.createElement("button");f.title="Previous result (Shift+Enter)",f.className="previous",f.onclick=function(){i.previous()},s=document.createElement("td"),s.appendChild(f),r.appendChild(s)}t.prototype.next=function(e){if(void 0!=this.results){var t=void 0!=this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}},t.prototype.previous=function(e){if(void 0!=this.results){var t=this.results.length-1,i=void 0!=this.resultIndex?this.resultIndex-1:t;0>i&&(i=t),this._setActiveResult(i,e)}},t.prototype._setActiveResult=function(e,t){if(this.activeResult){var i=this.activeResult.node,n=this.activeResult.elem;"field"==n?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var o=this.results[this.resultIndex].node,r=this.results[this.resultIndex].elem;"field"==r?o.searchFieldActive=!0:o.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],o.updateDom(),o.scrollTo(function(){t&&o.focus(r)})},t.prototype._clearDelay=function(){void 0!=this.timeout&&(clearTimeout(this.timeout),delete this.timeout)},t.prototype._onDelayedSearch=function(){this._clearDelay();var e=this;this.timeout=setTimeout(function(t){e._onSearch(t)},this.delay)},t.prototype._onSearch=function(e,t){this._clearDelay();var i=this.dom.search.value,n=i.length>0?i:void 0;if(n!=this.lastText||t)if(this.lastText=n,this.results=this.editor.search(n),this._setActiveResult(void 0),void 0!=n){var o=this.results.length;switch(o){case 0:this.dom.results.innerHTML="no&nbsp;results";break;case 1:this.dom.results.innerHTML="1&nbsp;result";break;default:this.dom.results.innerHTML=o+"&nbsp;results"}}else this.dom.results.innerHTML=""},t.prototype._onKeyDown=function(e){var t=e.which;27==t?(this.dom.search.value="",this._onSearch(e),e.preventDefault(),e.stopPropagation()):13==t&&(e.ctrlKey?this._onSearch(e,!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())},t.prototype._onKeyUp=function(e){var t=e.keyCode;27!=t&&13!=t&&this._onDelayedSearch(e)},e.exports=t},function(e,t,i){function n(e,t){this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),this.setValue(t.value,t.type)):(this.setField(""),this.setValue(null))}var o=i(10),r=i(11),s=i(3);n.prototype._updateEditability=function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,"tree"===this.editor.options.mode&&"function"==typeof this.editor.options.editable)){var e=this.editor.options.editable({field:this.field,value:this.value,path:this.path()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}},n.prototype.path=function(){for(var e=this,t=[];e;){var i=void 0!=e.field?e.field:e.index;void 0!==i&&t.unshift(i),e=e.parent}return t},n.prototype.setParent=function(e){this.parent=e},n.prototype.setField=function(e,t){this.field=e,this.fieldEditable=t===!0},n.prototype.getField=function(){return void 0===this.field&&this._getDomField(),this.field},n.prototype.setValue=function(e,t){var i,o,r=this.childs;if(r)for(;r.length;)this.removeChild(r[0]);if(this.type=this._getType(e),t&&t!=this.type){if("string"!=t||"auto"!=this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"==this.type){this.childs=[];for(var s=0,a=e.length;a>s;s++)i=e[s],void 0===i||i instanceof Function||(o=new n(this.editor,{value:i}),this.appendChild(o));this.value=""}else if("object"==this.type){this.childs=[];for(var l in e)e.hasOwnProperty(l)&&(i=e[l],void 0===i||i instanceof Function||(o=new n(this.editor,{field:l,value:i}),this.appendChild(o)));this.value=""}else this.childs=void 0,this.value=e},n.prototype.getValue=function(){if("array"==this.type){var e=[];return this.childs.forEach(function(t){e.push(t.getValue())}),e}if("object"==this.type){var t={};return this.childs.forEach(function(e){t[e.getField()]=e.getValue()}),t}return void 0===this.value&&this._getDomValue(),this.value},n.prototype.getLevel=function(){return this.parent?this.parent.getLevel()+1:0},n.prototype.clone=function(){var e=new n(this.editor);if(e.type=this.type,e.field=this.field,e.fieldInnerText=this.fieldInnerText,e.fieldEditable=this.fieldEditable,e.value=this.value,e.valueInnerText=this.valueInnerText,e.expanded=this.expanded,this.childs){var t=[];this.childs.forEach(function(i){var n=i.clone();n.setParent(e),t.push(n)}),e.childs=t}else e.childs=void 0;return e},n.prototype.expand=function(e){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="expanded"),this.showChilds(),e!==!1&&this.childs.forEach(function(t){t.expand(e)}))},n.prototype.collapse=function(e){this.childs&&(this.hideChilds(),e!==!1&&this.childs.forEach(function(t){t.collapse(e)}),this.dom.expand&&(this.dom.expand.className="collapsed"),this.expanded=!1)},n.prototype.showChilds=function(){var e=this.childs;if(e&&this.expanded){var t=this.dom.tr,i=t?t.parentNode:void 0;if(i){var n=this.getAppend(),o=t.nextSibling;o?i.insertBefore(n,o):i.appendChild(n),this.childs.forEach(function(e){i.insertBefore(e.getDom(),n),e.showChilds()})}}},n.prototype.hide=function(){var e=this.dom.tr,t=e?e.parentNode:void 0;t&&t.removeChild(e),this.hideChilds()},n.prototype.hideChilds=function(){var e=this.childs;if(e&&this.expanded){var t=this.getAppend();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()})}},n.prototype.appendChild=function(e){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"==this.type,"array"==this.type&&(e.index=this.childs.length),this.childs.push(e),this.expanded){var t=e.getDom(),i=this.getAppend(),n=i?i.parentNode:void 0;i&&n&&n.insertBefore(t,i),e.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},n.prototype.moveBefore=function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}e.parent&&e.parent.removeChild(e),t instanceof a?this.appendChild(e):this.insertBefore(e,t),i&&i.removeChild(n)}},n.prototype.moveTo=function(e,t){if(e.parent==this){var i=this.childs.indexOf(e);t>i&&t++}var n=this.childs[t]||this.append;this.moveBefore(e,n)},n.prototype.insertBefore=function(e,t){if(this._hasChilds()){if(t==this.append)e.setParent(this),e.fieldEditable="object"==this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1==i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"==this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),o=t.getDom(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},n.prototype.insertAfter=function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}},n.prototype.search=function(e){var t,i=[],n=e?e.toLowerCase():void 0;if(delete this.searchField,delete this.searchValue,void 0!=this.field){var o=String(this.field).toLowerCase();t=o.indexOf(n),-1!=t&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField()}if(this._hasChilds()){if(this.childs){var r=[];this.childs.forEach(function(t){r=r.concat(t.search(e))}),i=i.concat(r)}if(void 0!=n){var s=!1;0==r.length?this.collapse(s):this.expand(s)}}else{if(void 0!=this.value){var a=String(this.value).toLowerCase();t=a.indexOf(n),-1!=t&&(this.searchValue=!0,i.push({node:this,elem:"value"}))}this._updateDomValue()}return i},n.prototype.scrollTo=function(e){if(!this.dom.tr||!this.dom.tr.parentNode)for(var t=this.parent,i=!1;t;)t.expand(i),t=t.parent;this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)},n.focusElement=void 0,n.prototype.focus=function(e){if(n.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),s.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),s.selectContentEditable(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),s.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),
s.selectContentEditable(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.value&&!this._hasChilds()?(t.value.focus(),s.selectContentEditable(t.value)):t.field&&this.fieldEditable?(t.field.focus(),s.selectContentEditable(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}},n.select=function(e){setTimeout(function(){s.selectContentEditable(e)},0)},n.prototype.blur=function(){this._getDomValue(!1),this._getDomField(!1)},n.prototype._duplicate=function(e){var t=e.clone();return this.insertAfter(t,e),t},n.prototype.containsNode=function(e){if(this==e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;n>i;i++)if(t[i].containsNode(e))return!0;return!1},n.prototype._move=function(e,t){if(e!=t){if(e.containsNode(this))throw new Error("Cannot move a field into a child of itself");e.parent&&e.parent.removeChild(e);var i=e.clone();e.clearDom(),t?this.insertBefore(i,t):this.appendChild(i)}},n.prototype.removeChild=function(e){if(this.childs){var t=this.childs.indexOf(e);if(-1!=t){e.hide(),delete e.searchField,delete e.searchValue;var i=this.childs.splice(t,1)[0];return this.updateDom({updateIndexes:!0}),i}}return void 0},n.prototype._remove=function(e){this.removeChild(e)},n.prototype.changeType=function(e){var t=this.type;if(t!=e){if("string"!=e&&"auto"!=e||"string"!=t&&"auto"!=t){var i,n=this.dom.tr?this.dom.tr.parentNode:void 0;i=this.expanded?this.getAppend():this.getDom();var o=i&&i.parentNode?i.nextSibling:void 0;this.hide(),this.clearDom(),this.type=e,"object"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0==e.field&&(e.field="")}),("string"==t||"auto"==t)&&(this.expanded=!0)):"array"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),("string"==t||"auto"==t)&&(this.expanded=!0)):this.expanded=!1,n&&(o?n.insertBefore(this.getDom(),o):n.appendChild(this.getDom())),this.showChilds()}else this.type=e;("auto"==e||"string"==e)&&(this.value="string"==e?String(this.value):this._stringCast(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}},n.prototype._getDomValue=function(e){if(this.dom.value&&"array"!=this.type&&"object"!=this.type&&(this.valueInnerText=s.getInnerText(this.dom.value)),void 0!=this.valueInnerText)try{var t;if("string"==this.type)t=this._unescapeHTML(this.valueInnerText);else{var i=this._unescapeHTML(this.valueInnerText);t=this._stringCast(i)}if(t!==this.value){var n=this.value;this.value=t,this.editor._onAction("editValue",{node:this,oldValue:n,newValue:t,oldSelection:this.editor.selection,newSelection:this.editor.getSelection()})}}catch(o){if(this.value=void 0,e!==!0)throw o}},n.prototype._updateDomValue=function(){var e=this.dom.value;if(e){var t=this.value,i="auto"==this.type?s.type(t):this.type,n="string"==i&&s.isUrl(t),o="";o=n&&!this.editable.value?"":"string"==i?"green":"number"==i?"red":"boolean"==i?"darkorange":this._hasChilds()?"":null===t?"#004ED0":"black",e.style.color=o;var r=""==String(this.value)&&"array"!=this.type&&"object"!=this.type;if(r?s.addClassName(e,"empty"):s.removeClassName(e,"empty"),n?s.addClassName(e,"url"):s.removeClassName(e,"url"),"array"==i||"object"==i){var a=this.childs?this.childs.length:0;e.title=this.type+" containing "+a+" items"}else"string"==i&&s.isUrl(t)?this.editable.value&&(e.title="Ctrl+Click or Ctrl+Enter to open url in new window"):e.title="";this.searchValueActive?s.addClassName(e,"highlight-active"):s.removeClassName(e,"highlight-active"),this.searchValue?s.addClassName(e,"highlight"):s.removeClassName(e,"highlight"),s.stripFormatting(e)}},n.prototype._updateDomField=function(){var e=this.dom.field;if(e){var t=""==String(this.field)&&"array"!=this.parent.type;t?s.addClassName(e,"empty"):s.removeClassName(e,"empty"),this.searchFieldActive?s.addClassName(e,"highlight-active"):s.removeClassName(e,"highlight-active"),this.searchField?s.addClassName(e,"highlight"):s.removeClassName(e,"highlight"),s.stripFormatting(e)}},n.prototype._getDomField=function(e){if(this.dom.field&&this.fieldEditable&&(this.fieldInnerText=s.getInnerText(this.dom.field)),void 0!=this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText);if(t!==this.field){var i=this.field;this.field=t,this.editor._onAction("editField",{node:this,oldValue:i,newValue:t,oldSelection:this.editor.selection,newSelection:this.editor.getSelection()})}}catch(n){if(this.field=void 0,e!==!0)throw n}},n.prototype.clearDom=function(){this.dom={}},n.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),e.tr.node=this,"tree"===this.editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");e.drag=i,i.className="dragarea",i.title="Drag to move this field (Alt+Shift+Arrows)",t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),o=document.createElement("button");e.menu=o,o.className="contextmenu",o.title="Click to open the actions menu (Ctrl+M)",n.appendChild(e.menu),e.tr.appendChild(n)}var r=document.createElement("td");return e.tr.appendChild(r),e.tree=this._createDomTree(),r.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr},n.prototype._onDragStart=function(e){var t=this;this.mousemove||(this.mousemove=s.addEventListener(document,"mousemove",function(e){t._onDrag(e)})),this.mouseup||(this.mouseup=s.addEventListener(document,"mouseup",function(e){t._onDragEnd(e)})),this.editor.highlighter.lock(),this.drag={oldCursor:document.body.style.cursor,startParent:this.parent,startIndex:this.parent.childs.indexOf(this),mouseX:e.pageX,level:this.getLevel()},document.body.style.cursor="move",e.preventDefault()},n.prototype._onDrag=function(e){var t,i,o,r,l,c,h,u,d,g,f,p,m,v,A=e.pageY,w=e.pageX,C=!1;if(t=this.dom.tr,d=s.getAbsoluteTop(t),p=t.offsetHeight,d>A){i=t;do i=i.previousSibling,h=n.getNodeFromTarget(i),g=i?s.getAbsoluteTop(i):0;while(i&&g>A);h&&!h.parent&&(h=void 0),h||(c=t.parentNode.firstChild,i=c?c.nextSibling:void 0,h=n.getNodeFromTarget(i),h==this&&(h=void 0)),h&&(i=h.dom.tr,g=i?s.getAbsoluteTop(i):0,A>g+p&&(h=void 0)),h&&(h.parent.moveBefore(this,h),C=!0)}else if(l=this.expanded&&this.append?this.append.getDom():this.dom.tr,r=l?l.nextSibling:void 0){f=s.getAbsoluteTop(r),o=r;do u=n.getNodeFromTarget(o),o&&(m=o.nextSibling?s.getAbsoluteTop(o.nextSibling):0,v=o?m-f:0,1==u.parent.childs.length&&u.parent.childs[0]==this&&(d+=23)),o=o.nextSibling;while(o&&A>d+v);if(u&&u.parent){var E=w-this.drag.mouseX,F=Math.round(E/24/2),y=this.drag.level+F,b=u.getLevel();for(i=u.dom.tr.previousSibling;y>b&&i;){if(h=n.getNodeFromTarget(i),h==this||h._isChildOf(this));else{if(!(h instanceof a))break;var x=h.parent.childs;if(!(x.length>1||1==x.length&&x[0]!=this))break;u=n.getNodeFromTarget(i),b=u.getLevel()}i=i.previousSibling}l.nextSibling!=u.dom.tr&&(u.parent.moveBefore(this,u),C=!0)}}C&&(this.drag.mouseX=w,this.drag.level=this.getLevel()),this.editor.startAutoScroll(A),e.preventDefault()},n.prototype._onDragEnd=function(e){var t={node:this,startParent:this.drag.startParent,startIndex:this.drag.startIndex,endParent:this.parent,endIndex:this.parent.childs.indexOf(this)};(t.startParent!=t.endParent||t.startIndex!=t.endIndex)&&this.editor._onAction("moveNode",t),document.body.style.cursor=this.drag.oldCursor,this.editor.highlighter.unlock(),delete this.drag,this.mousemove&&(s.removeEventListener(document,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(s.removeEventListener(document,"mouseup",this.mouseup),delete this.mouseup),this.editor.stopAutoScroll(),e.preventDefault()},n.prototype._isChildOf=function(e){for(var t=this.parent;t;){if(t==e)return!0;t=t.parent}return!1},n.prototype._createDomField=function(){return document.createElement("div")},n.prototype.setHighlight=function(e){this.dom.tr&&(this.dom.tr.className=e?"highlight":"",this.append&&this.append.setHighlight(e),this.childs&&this.childs.forEach(function(t){t.setHighlight(e)}))},n.prototype.updateValue=function(e){this.value=e,this.updateDom()},n.prototype.updateField=function(e){this.field=e,this.updateDom()},n.prototype.updateDom=function(e){var t=this.dom.tree;t&&(t.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="field"):i.className="readonly";var n;n=void 0!=this.index?this.index:void 0!=this.field?this.field:this._hasChilds()?this.type:"",i.innerHTML=this._escapeHTML(n)}var o=this.dom.value;if(o){var r=this.childs?this.childs.length:0;o.innerHTML="array"==this.type?"["+r+"]":"object"==this.type?"{"+r+"}":this._escapeHTML(this.value)}this._updateDomField(),this._updateDomValue(),e&&e.updateIndexes===!0&&this._updateDomIndexes(),e&&e.recurse===!0&&this.childs&&this.childs.forEach(function(t){t.updateDom(e)}),this.append&&this.append.updateDom()},n.prototype._updateDomIndexes=function(){var e=this.dom.value,t=this.childs;e&&t&&("array"==this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"==this.type&&t.forEach(function(e){void 0!=e.index&&(delete e.index,void 0==e.field&&(e.field=""))}))},n.prototype._createDomValue=function(){var e;return"array"==this.type?(e=document.createElement("div"),e.className="readonly",e.innerHTML="[...]"):"object"==this.type?(e=document.createElement("div"),e.className="readonly",e.innerHTML="{...}"):!this.editable.value&&s.isUrl(this.value)?(e=document.createElement("a"),e.className="value",e.href=this.value,e.target="_blank",e.innerHTML=this._escapeHTML(this.value)):(e=document.createElement("div"),e.contentEditable=this.editable.value,e.spellcheck=!1,e.className="value",e.innerHTML=this._escapeHTML(this.value)),e},n.prototype._createDomExpandButton=function(){var e=document.createElement("button");return this._hasChilds()?(e.className=this.expanded?"expanded":"collapsed",e.title="Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs."):(e.className="invisible",e.title=""),e},n.prototype._createDomTree=function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var o=document.createElement("td");o.className="tree",n.appendChild(o),e.expand=this._createDomExpandButton(),o.appendChild(e.expand),e.tdExpand=o;var r=document.createElement("td");r.className="tree",n.appendChild(r),e.field=this._createDomField(),r.appendChild(e.field),e.tdField=r;var s=document.createElement("td");s.className="tree",n.appendChild(s),"object"!=this.type&&"array"!=this.type&&(s.appendChild(document.createTextNode(":")),s.className="separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t},n.prototype.onEvent=function(e){var t,i=e.type,n=e.target||e.srcElement,o=this.dom,r=this,a=this._hasChilds();if((n==o.drag||n==o.menu)&&("mouseover"==i?this.editor.highlighter.highlight(this):"mouseout"==i&&this.editor.highlighter.unhighlight()),"mousedown"==i&&n==o.drag&&this._onDragStart(e),"click"==i&&n==o.menu){var l=r.editor.highlighter;l.highlight(r),l.lock(),s.addClassName(o.menu,"selected"),this.showContextMenu(o.menu,function(){s.removeClassName(o.menu,"selected"),l.unlock(),l.unhighlight()})}if("click"==i&&n==o.expand&&a){var c=e.ctrlKey;this._onExpand(c)}var h=o.value;if(n==h)switch(i){case"focus":t=this;break;case"blur":case"change":this._getDomValue(!0),this._updateDomValue(),this.value&&(h.innerHTML=this._escapeHTML(this.value));break;case"input":this._getDomValue(!0),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getSelection();break;case"click":(e.ctrlKey||!this.editable.value)&&s.isUrl(this.value)&&window.open(this.value,"_blank");break;case"keyup":this._getDomValue(!0),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){r._getDomValue(!0),r._updateDomValue()},1)}var u=o.field;if(n==u)switch(i){case"focus":t=this;break;case"blur":case"change":this._getDomField(!0),this._updateDomField(),this.field&&(u.innerHTML=this._escapeHTML(this.field));break;case"input":this._getDomField(!0),this._updateDomField();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getSelection();break;case"keyup":this._getDomField(!0),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){r._getDomField(!0),r._updateDomField()},1)}var d=o.tree;if(n==d.parentNode)switch(i){case"click":var g=void 0!=e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<s.getAbsoluteLeft(o.tdSeparator);g||a?u&&(s.setEndOfContentEditable(u),u.focus()):h&&(s.setEndOfContentEditable(h),h.focus())}if(n==o.tdExpand&&!a||n==o.tdField||n==o.tdSeparator)switch(i){case"click":u&&(s.setEndOfContentEditable(u),u.focus())}"keydown"==i&&this.onKeyDown(e)},n.prototype.onKeyDown=function(e){var t,i,o,r,l=e.which||e.keyCode,c=e.target||e.srcElement,h=e.ctrlKey,u=e.shiftKey,d=e.altKey,g=!1,f="tree"===this.editor.options.mode;if(13==l){if(c==this.dom.value)(!this.editable.value||e.ctrlKey)&&s.isUrl(this.value)&&(window.open(this.value,"_blank"),g=!0);else if(c==this.dom.expand){var p=this._hasChilds();if(p){var m=e.ctrlKey;this._onExpand(m),c.focus(),g=!0}}}else if(68==l)h&&f&&(this._onDuplicate(),g=!0);else if(69==l)h&&(this._onExpand(u),c.focus(),g=!0);else if(77==l&&f)h&&(this.showContextMenu(c),g=!0);else if(46==l&&f)h&&(this._onRemove(),g=!0);else if(45==l&&f)h&&!u?(this._onInsertBefore(),g=!0):h&&u&&(this._onInsertAfter(),g=!0);else if(35==l){if(d){var v=this._lastNode();v&&v.focus(n.focusElement||this._getElementName(c)),g=!0}}else if(36==l){if(d){var A=this._firstNode();A&&A.focus(n.focusElement||this._getElementName(c)),g=!0}}else if(37==l){if(d&&!u){var w=this._previousElement(c);w&&this.focus(this._getElementName(w)),g=!0}else if(d&&u&&f){if(this.expanded){var C=this.getAppend();o=C?C.nextSibling:void 0}else{var E=this.getDom();o=E.nextSibling}o&&(i=n.getNodeFromTarget(o),r=o.nextSibling,b=n.getNodeFromTarget(r),i&&i instanceof a&&1!=this.parent.childs.length&&b&&b.parent&&(b.parent.moveBefore(this,b),this.focus(n.focusElement||this._getElementName(c))))}}else if(38==l)d&&!u?(t=this._previousNode(),t&&t.focus(n.focusElement||this._getElementName(c)),g=!0):d&&u&&(t=this._previousNode(),t&&t.parent&&(t.parent.moveBefore(this,t),this.focus(n.focusElement||this._getElementName(c))),g=!0);else if(39==l){if(d&&!u){var F=this._nextElement(c);F&&this.focus(this._getElementName(F)),g=!0}else if(d&&u){E=this.getDom();var y=E.previousSibling;y&&(t=n.getNodeFromTarget(y),t&&t.parent&&t instanceof a&&!t.isVisible()&&(t.parent.moveBefore(this,t),this.focus(n.focusElement||this._getElementName(c))))}}else if(40==l)if(d&&!u)i=this._nextNode(),i&&i.focus(n.focusElement||this._getElementName(c)),g=!0;else if(d&&u&&f){i=this.expanded?this.append?this.append._nextNode():void 0:this._nextNode(),o=i?i.getDom():void 0,r=1==this.parent.childs.length?o:o?o.nextSibling:void 0;var b=n.getNodeFromTarget(r);b&&b.parent&&(b.parent.moveBefore(this,b),this.focus(n.focusElement||this._getElementName(c))),g=!0}g&&(e.preventDefault(),e.stopPropagation())},n.prototype._onExpand=function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)},n.prototype._onRemove=function(){this.editor.highlighter.unhighlight();var e=this.parent.childs,t=e.indexOf(this),i=this.editor.getSelection();e[t+1]?e[t+1].focus():e[t-1]?e[t-1].focus():this.parent.focus();var n=this.editor.getSelection();this.parent._remove(this),this.editor._onAction("removeNode",{node:this,parent:this.parent,index:t,oldSelection:i,newSelection:n})},n.prototype._onDuplicate=function(){var e=this.editor.getSelection(),t=this.parent._duplicate(this);t.focus();var i=this.editor.getSelection();this.editor._onAction("duplicateNode",{node:this,clone:t,parent:this.parent,oldSelection:e,newSelection:i})},n.prototype._onInsertBefore=function(e,t,i){var o=this.editor.getSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.insertBefore(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getSelection();this.editor._onAction("insertBeforeNode",{node:r,beforeNode:this,parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onInsertAfter=function(e,t,i){var o=this.editor.getSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.insertAfter(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getSelection();this.editor._onAction("insertAfterNode",{node:r,afterNode:this,parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onAppend=function(e,t,i){var o=this.editor.getSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.appendChild(r),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getSelection();this.editor._onAction("appendNode",{node:r,parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onChangeType=function(e){var t=this.type;if(e!=t){var i=this.editor.getSelection();this.changeType(e);var n=this.editor.getSelection();this.editor._onAction("changeType",{node:this,oldType:t,newType:e,oldSelection:i,newSelection:n})}},n.prototype._onSort=function(e){if(this._hasChilds()){var t="desc"==e?-1:1,i="array"==this.type?"value":"field";this.hideChilds();var n=this.childs,o=this.sort;this.childs=this.childs.concat(),this.childs.sort(function(e,n){return e[i]>n[i]?t:e[i]<n[i]?-t:0}),this.sort=1==t?"asc":"desc",this.editor._onAction("sort",{node:this,oldChilds:n,oldSort:o,newChilds:this.childs,newSort:this.sort}),this.showChilds()}},n.prototype.getAppend=function(){return this.append||(this.append=new a(this.editor),this.append.setParent(this)),this.append.getDom()},n.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}return void 0},n.prototype._previousNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do i=i.previousSibling,e=n.getNodeFromTarget(i);while(i&&e instanceof a&&!e.isVisible())}return e},n.prototype._nextNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do i=i.nextSibling,e=n.getNodeFromTarget(i);while(i&&e instanceof a&&!e.isVisible())}return e},n.prototype._firstNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=n.getNodeFromTarget(i)}return e},n.prototype._lastNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=n.getNodeFromTarget(i);i&&e instanceof a&&!e.isVisible();)i=i.previousSibling,e=n.getNodeFromTarget(i)}return e},n.prototype._previousElement=function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}},n.prototype._nextElement=function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}},n.prototype._getElementName=function(e){var t=this.dom;for(var i in t)if(t.hasOwnProperty(i)&&t[i]==e)return i;return null},n.prototype._hasChilds=function(){return"array"==this.type||"object"==this.type},n.TYPE_TITLES={auto:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',object:'Field type "object". An object contains an unordered set of key/value pairs.',array:'Field type "array". An array contains an ordered collection of values.',string:'Field type "string". Field type is not determined from the value, but always returned as string.'},n.prototype.showContextMenu=function(e,t){var i=this,r=n.TYPE_TITLES,s=[];if(this.editable.value&&s.push({text:"Type",title:"Change the type of this field",className:"type-"+this.type,submenu:[{text:"Auto",className:"type-auto"+("auto"==this.type?" selected":""),title:r.auto,click:function(){i._onChangeType("auto")}},{text:"Array",className:"type-array"+("array"==this.type?" selected":""),title:r.array,click:function(){i._onChangeType("array")}},{text:"Object",className:"type-object"+("object"==this.type?" selected":""),title:r.object,click:function(){i._onChangeType("object")}},{text:"String",className:"type-string"+("string"==this.type?" selected":""),title:r.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()){var a="asc"==this.sort?"desc":"asc";s.push({text:"Sort",title:"Sort the childs of this "+this.type,className:"sort-"+a,click:function(){i._onSort(a)},submenu:[{text:"Ascending",className:"sort-asc",title:"Sort the childs of this "+this.type+" in ascending order",click:function(){i._onSort("asc")}},{text:"Descending",className:"sort-desc",title:"Sort the childs of this "+this.type+" in descending order",click:function(){i._onSort("desc")}}]})}if(this.parent&&this.parent._hasChilds()){s.length&&s.push({type:"separator"});var l=i.parent.childs;i==l[l.length-1]&&s.push({text:"Append",title:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",submenuTitle:"Select the type of the field to be appended",className:"append",click:function(){i._onAppend("","","auto")},submenu:[{text:"Auto",className:"type-auto",title:r.auto,click:function(){i._onAppend("","","auto")}},{text:"Array",className:"type-array",title:r.array,click:function(){i._onAppend("",[])}},{text:"Object",className:"type-object",title:r.object,click:function(){i._onAppend("",{})}},{text:"String",className:"type-string",title:r.string,click:function(){i._onAppend("","","string")}}]}),s.push({text:"Insert",title:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",submenuTitle:"Select the type of the field to be inserted",className:"insert",click:function(){i._onInsertBefore("","","auto")},submenu:[{text:"Auto",className:"type-auto",title:r.auto,click:function(){i._onInsertBefore("","","auto")}},{text:"Array",className:"type-array",title:r.array,click:function(){i._onInsertBefore("",[])}},{text:"Object",className:"type-object",title:r.object,click:function(){i._onInsertBefore("",{})}},{text:"String",className:"type-string",title:r.string,click:function(){i._onInsertBefore("","","string")}}]}),this.editable.field&&(s.push({text:"Duplicate",title:"Duplicate this field (Ctrl+D)",className:"duplicate",click:function(){i._onDuplicate()}}),s.push({text:"Remove",title:"Remove this field (Ctrl+Del)",className:"remove",click:function(){i._onRemove()}}))}var c=new o(s,{close:t});c.show(e)},n.prototype._getType=function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof this._stringCast(e)?"string":"auto"},n.prototype._stringCast=function(e){var t=e.toLowerCase(),i=Number(e),n=parseFloat(e);return""==e?"":"null"==t?null:"true"==t?!0:"false"==t?!1:isNaN(i)||isNaN(n)?e:i},n.prototype._escapeHTML=function(e){var t=String(e).replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/  /g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t);return i.substring(1,i.length-1)},n.prototype._unescapeHTML=function(e){var t='"'+this._escapeJSON(e)+'"',i=s.parse(t);return i.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ")},n.prototype._escapeJSON=function(e){for(var t="",i=0,n=e.length;n>i;){var o=e.charAt(i);"\n"==o?t+="\\n":"\\"==o?(t+=o,i++,o=e.charAt(i),-1=='"\\/bfnrtu'.indexOf(o)&&(t+="\\"),t+=o):t+='"'==o?'\\"':o,i++}return t};var a=r(n);e.exports=n},function(e,t,i){function n(e,t,i){function n(t){e.setMode(t);var i=e.dom&&e.dom.modeBox;i&&i.focus()}for(var r={code:{text:"Code",title:"Switch to code highlighter",click:function(){n("code")}},form:{text:"Form",title:"Switch to form editor",click:function(){n("form")}},text:{text:"Text",title:"Switch to plain text editor",click:function(){n("text")}},tree:{text:"Tree",title:"Switch to tree editor",click:function(){n("tree")}},view:{text:"View",title:"Switch to tree view",click:function(){n("view")}}},s=[],a=0;a<t.length;a++){var l=t[a],c=r[l];if(!c)throw new Error('Unknown mode "'+l+'"');c.className="type-modes"+(i==l?" selected":""),s.push(c)}var h=r[i];if(!h)throw new Error('Unknown mode "'+i+'"');var u=h.text,d=document.createElement("button");return d.className="modes separator",d.innerHTML=u+" &#x25BE;",d.title="Switch editor mode",d.onclick=function(){var e=new o(s);e.show(d)},d}var o=i(10);t.create=n},function(e,t,i){var n=i(14);i(15),i(16),i(13),e.exports=n},function(e,t,i){function n(e,t){function i(e,t,o){o.forEach(function(o){if("separator"==o.type){var r=document.createElement("div");r.className="separator",a=document.createElement("li"),a.appendChild(r),e.appendChild(a)}else{var s={},a=document.createElement("li");e.appendChild(a);var l=document.createElement("button");if(l.className=o.className,s.button=l,o.title&&(l.title=o.title),o.click&&(l.onclick=function(){n.hide(),o.click()}),a.appendChild(l),o.submenu){var c=document.createElement("div");c.className="icon",l.appendChild(c),l.appendChild(document.createTextNode(o.text));var h;if(o.click){l.className+=" default";var u=document.createElement("button");s.buttonExpand=u,u.className="expand",u.innerHTML='<div class="expand"></div>',a.appendChild(u),o.submenuTitle&&(u.title=o.submenuTitle),h=u}else{var d=document.createElement("div");d.className="expand",l.appendChild(d),h=l}h.onclick=function(){n._onExpandItem(s),h.focus()};var g=[];s.subItems=g;var f=document.createElement("ul");s.ul=f,f.className="menu",f.style.height="0",a.appendChild(f),i(f,g,o.submenu)}else l.innerHTML='<div class="icon"></div>'+o.text;t.push(s)}})}this.dom={};var n=this,o=this.dom;this.anchor=void 0,this.items=e,this.eventListeners={},this.selection=void 0,this.visibleSubmenu=void 0,this.onClose=t?t.close:void 0;var r=document.createElement("div");r.className="jsoneditor-contextmenu",o.menu=r;var s=document.createElement("ul");s.className="menu",r.appendChild(s),o.list=s,o.items=[];var a=document.createElement("button");o.focusButton=a;var l=document.createElement("li");l.style.overflow="hidden",l.style.height="0",l.appendChild(a),s.appendChild(l),i(s,this.dom.items,e),this.maxHeight=0,e.forEach(function(t){var i=24*(e.length+(t.submenu?t.submenu.length:0));n.maxHeight=Math.max(n.maxHeight,i)})}var o=i(3);n.prototype._getVisibleButtons=function(){var e=[],t=this;return this.dom.items.forEach(function(i){e.push(i.button),i.buttonExpand&&e.push(i.buttonExpand),i.subItems&&i==t.expandedItem&&i.subItems.forEach(function(t){e.push(t.button),t.buttonExpand&&e.push(t.buttonExpand)})}),e},n.visibleMenu=void 0,n.prototype.show=function(e){this.hide();var t=window.innerHeight,i=window.pageYOffset||document.scrollTop||0,r=t+i,s=e.offsetHeight,a=this.maxHeight,l=o.getAbsoluteLeft(e),c=o.getAbsoluteTop(e);r>c+s+a?(this.dom.menu.style.left=l+"px",this.dom.menu.style.top=c+s+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left=l+"px",this.dom.menu.style.top="",this.dom.menu.style.bottom=t-c+"px"),document.body.appendChild(this.dom.menu);var h=this,u=this.dom.list;this.eventListeners.mousedown=o.addEventListener(document,"mousedown",function(e){var t=e.target;t==u||h._isChildOf(t,u)||(h.hide(),e.stopPropagation(),e.preventDefault())}),this.eventListeners.mousewheel=o.addEventListener(document,"mousewheel",function(e){e.stopPropagation(),e.preventDefault()}),this.eventListeners.keydown=o.addEventListener(document,"keydown",function(e){h._onKeyDown(e)}),this.selection=o.getSelection(),this.anchor=e,setTimeout(function(){h.dom.focusButton.focus()},0),n.visibleMenu&&n.visibleMenu.hide(),n.visibleMenu=this},n.prototype.hide=function(){this.dom.menu.parentNode&&(this.dom.menu.parentNode.removeChild(this.dom.menu),this.onClose&&this.onClose());for(var e in this.eventListeners)if(this.eventListeners.hasOwnProperty(e)){var t=this.eventListeners[e];t&&o.removeEventListener(document,e,t),delete this.eventListeners[e]}n.visibleMenu==this&&(n.visibleMenu=void 0)},n.prototype._onExpandItem=function(e){var t=this,i=e==this.expandedItem,n=this.expandedItem;if(n&&(n.ul.style.height="0",n.ul.style.padding="",setTimeout(function(){t.expandedItem!=n&&(n.ul.style.display="",o.removeClassName(n.ul.parentNode,"selected"))},300),this.expandedItem=void 0),!i){var r=e.ul;r.style.display="block";{r.clientHeight}setTimeout(function(){t.expandedItem==e&&(r.style.height=24*r.childNodes.length+"px",r.style.padding="5px 10px")},0),o.addClassName(r.parentNode,"selected"),this.expandedItem=e}},n.prototype._onKeyDown=function(e){var t,i,n,r,s=e.target,a=e.which,l=!1;27==a?(this.selection&&o.setSelection(this.selection),this.anchor&&this.anchor.focus(),this.hide(),l=!0):9==a?e.shiftKey?(t=this._getVisibleButtons(),i=t.indexOf(s),0==i&&(t[t.length-1].focus(),l=!0)):(t=this._getVisibleButtons(),i=t.indexOf(s),i==t.length-1&&(t[0].focus(),l=!0)):37==a?("expand"==s.className&&(t=this._getVisibleButtons(),i=t.indexOf(s),n=t[i-1],n&&n.focus()),l=!0):38==a?(t=this._getVisibleButtons(),i=t.indexOf(s),n=t[i-1],n&&"expand"==n.className&&(n=t[i-2]),n||(n=t[t.length-1]),n&&n.focus(),l=!0):39==a?(t=this._getVisibleButtons(),i=t.indexOf(s),r=t[i+1],r&&"expand"==r.className&&r.focus(),l=!0):40==a&&(t=this._getVisibleButtons(),i=t.indexOf(s),r=t[i+1],r&&"expand"==r.className&&(r=t[i+2]),r||(r=t[0]),r&&(r.focus(),l=!0),l=!0),l&&(e.stopPropagation(),e.preventDefault())},n.prototype._isChildOf=function(e,t){for(var i=e.parentNode;i;){if(i==t)return!0;i=i.parentNode}return!1},e.exports=n},function(e,t,i){function n(e){function t(e){this.editor=e,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.node=this,e.tr=t,this.editable.field){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.className="contextmenu",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var o=document.createElement("td"),r=document.createElement("div");return r.innerHTML="(empty)",r.className="readonly",o.appendChild(r),e.td=o,e.text=r,this.updateDom(),t},t.prototype.updateDom=function(){var e=this.dom,t=e.td;t&&(t.style.paddingLeft=24*this.getLevel()+26+"px");var i=e.text;i&&(i.innerHTML="(empty "+this.parent.type+")");var n=e.tr;this.isVisible()?e.tr.firstChild||(e.tdDrag&&n.appendChild(e.tdDrag),e.tdMenu&&n.appendChild(e.tdMenu),n.appendChild(t)):e.tr.firstChild&&(e.tdDrag&&n.removeChild(e.tdDrag),e.tdMenu&&n.removeChild(e.tdMenu),n.removeChild(t))},t.prototype.isVisible=function(){return 0==this.parent.childs.length},t.prototype.showContextMenu=function(t,i){var n=this,o=e.TYPE_TITLES,s=[{text:"Append",title:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",submenuTitle:"Select the type of the field to be appended",className:"insert",click:function(){n._onAppend("","","auto")},submenu:[{text:"Auto",className:"type-auto",title:o.auto,click:function(){n._onAppend("","","auto")}},{text:"Array",className:"type-array",title:o.array,click:function(){n._onAppend("",[])}},{text:"Object",className:"type-object",title:o.object,click:function(){n._onAppend("",{})}},{text:"String",className:"type-string",title:o.string,click:function(){n._onAppend("","","string")}}]}],a=new r(s,{close:i});a.show(t)},t.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,r=n.menu;if(i==r&&("mouseover"==t?this.editor.highlighter.highlight(this.parent):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var s=this.editor.highlighter;
s.highlight(this.parent),s.lock(),o.addClassName(n.menu,"selected"),this.showContextMenu(n.menu,function(){o.removeClassName(n.menu,"selected"),s.unlock(),s.unhighlight()})}"keydown"==t&&this.onKeyDown(e)},t}var o=i(3),r=i(10);e.exports=n},function(e,t){var i=function(){var e={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,o,r){var s=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"	").replace(/\\v/g,"").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[s-1];case 13:this.$={};break;case 14:this.$=r[s-1];break;case 15:this.$=[r[s-2],r[s]];break;case 16:this.$={},this.$[r[s][0]]=r[s][1];break;case 17:this.$=r[s-2],r[s-2][r[s][0]]=r[s][1];break;case 18:this.$=[];break;case 19:this.$=r[s-1];break;case 20:this.$=[r[s]];break;case 21:this.$=r[s-2],r[s-2].push(r[s])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e){throw new Error(e)},parse:function(e){function t(e){o.length=o.length-2*e,r.length=r.length-e,s.length=s.length-e}function i(){var e;return e=n.lexer.lex()||1,"number"!=typeof e&&(e=n.symbols_[e]||e),e}var n=this,o=[0],r=[null],s=[],a=this.table,l="",c=0,h=0,u=0,d=2,g=1;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,"undefined"==typeof this.lexer.yylloc&&(this.lexer.yylloc={});var f=this.lexer.yylloc;s.push(f),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var p,m,v,A,w,C,E,F,y,b={};;){if(v=o[o.length-1],this.defaultActions[v]?A=this.defaultActions[v]:(null==p&&(p=i()),A=a[v]&&a[v][p]),"undefined"==typeof A||!A.length||!A[0]){if(!u){y=[];for(C in a[v])this.terminals_[C]&&C>2&&y.push("'"+this.terminals_[C]+"'");var x="";x=this.lexer.showPosition?"Parse error on line "+(c+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+y.join(", ")+", got '"+this.terminals_[p]+"'":"Parse error on line "+(c+1)+": Unexpected "+(1==p?"end of input":"'"+(this.terminals_[p]||p)+"'"),this.parseError(x,{text:this.lexer.match,token:this.terminals_[p]||p,line:this.lexer.yylineno,loc:f,expected:y})}if(3==u){if(p==g)throw new Error(x||"Parsing halted.");h=this.lexer.yyleng,l=this.lexer.yytext,c=this.lexer.yylineno,f=this.lexer.yylloc,p=i()}for(;;){if(d.toString()in a[v])break;if(0==v)throw new Error(x||"Parsing halted.");t(1),v=o[o.length-1]}m=p,p=d,v=o[o.length-1],A=a[v]&&a[v][d],u=3}if(A[0]instanceof Array&&A.length>1)throw new Error("Parse Error: multiple actions possible at state: "+v+", token: "+p);switch(A[0]){case 1:o.push(p),r.push(this.lexer.yytext),s.push(this.lexer.yylloc),o.push(A[1]),p=null,m?(p=m,m=null):(h=this.lexer.yyleng,l=this.lexer.yytext,c=this.lexer.yylineno,f=this.lexer.yylloc,u>0&&u--);break;case 2:if(E=this.productions_[A[1]][1],b.$=r[r.length-E],b._$={first_line:s[s.length-(E||1)].first_line,last_line:s[s.length-1].last_line,first_column:s[s.length-(E||1)].first_column,last_column:s[s.length-1].last_column},w=this.performAction.call(b,l,h,c,this.yy,A[1],r,s),"undefined"!=typeof w)return w;E&&(o=o.slice(0,-1*E*2),r=r.slice(0,-1*E),s=s.slice(0,-1*E)),o.push(this.productions_[A[1]][0]),r.push(b.$),s.push(b._$),F=a[o[o.length-2]][o[o.length-1]],o.push(F);break;case 3:return!0}}return!0}},t=function(){var e={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e;var t=e.match(/\n/);return t&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(e.length>20?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(e.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0);var e,t,i,n,o;this._more||(this.yytext="",this.match="");for(var r=this._currentRules(),s=0;s<r.length&&(i=this._input.match(this.rules[r[s]]),!i||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?(o=t[0].match(/\n.*/g),o&&(this.yylineno+=o.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:o?o[o.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,r[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e?e:void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return"undefined"!=typeof e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)}};return e.options={},e.performAction=function(e,t,i,n){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},e.rules=[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],e.conditions={INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}},e}();return e.lexer=t,e}();t.parser=i,t.parse=i.parse},function(){ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {	background: #ebebeb;	color: #333	}		.ace-jsoneditor.ace_editor {	font-family: droid sans mono, monospace, courier new, courier, sans-serif;	line-height: 1.3;	}	.ace-jsoneditor .ace_print-margin {	width: 1px;	background: #e8e8e8	}	.ace-jsoneditor .ace_scroller {	background-color: #FFFFFF	}	.ace-jsoneditor .ace_text-layer {	color: gray	}	.ace-jsoneditor .ace_variable {	color: #1a1a1a	}	.ace-jsoneditor .ace_cursor {	border-left: 2px solid #000000	}	.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {	border-left: 0px;	border-bottom: 1px solid #000000	}	.ace-jsoneditor .ace_marker-layer .ace_selection {	background: #D5DDF6	}	.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {	box-shadow: 0 0 3px 0px #FFFFFF;	border-radius: 2px	}	.ace-jsoneditor .ace_marker-layer .ace_step {	background: rgb(255, 255, 0)	}	.ace-jsoneditor .ace_marker-layer .ace_bracket {	margin: -1px 0 0 -1px;	border: 1px solid #BFBFBF	}	.ace-jsoneditor .ace_marker-layer .ace_active-line {	background: #FFFBD1	}	.ace-jsoneditor .ace_gutter-active-line {	background-color : #dcdcdc	}	.ace-jsoneditor .ace_marker-layer .ace_selected-word {	border: 1px solid #D5DDF6	}	.ace-jsoneditor .ace_invisible {	color: #BFBFBF	}	.ace-jsoneditor .ace_keyword,	.ace-jsoneditor .ace_meta,	.ace-jsoneditor .ace_support.ace_constant.ace_property-value {	color: #AF956F	}	.ace-jsoneditor .ace_keyword.ace_operator {	color: #484848	}	.ace-jsoneditor .ace_keyword.ace_other.ace_unit {	color: #96DC5F	}	.ace-jsoneditor .ace_constant.ace_language {	color: darkorange	}	.ace-jsoneditor .ace_constant.ace_numeric {	color: red	}	.ace-jsoneditor .ace_constant.ace_character.ace_entity {	color: #BF78CC	}	.ace-jsoneditor .ace_invalid {	color: #FFFFFF;	background-color: #FF002A;	}	.ace-jsoneditor .ace_fold {	background-color: #AF956F;	border-color: #000000	}	.ace-jsoneditor .ace_storage,	.ace-jsoneditor .ace_support.ace_class,	.ace-jsoneditor .ace_support.ace_function,	.ace-jsoneditor .ace_support.ace_other,	.ace-jsoneditor .ace_support.ace_type {	color: #C52727	}	.ace-jsoneditor .ace_string {	color: green	}	.ace-jsoneditor .ace_comment {	color: #BCC8BA	}	.ace-jsoneditor .ace_entity.ace_name.ace_tag,	.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {	color: #606060	}	.ace-jsoneditor .ace_markup.ace_underline {	text-decoration: underline	}	.ace-jsoneditor .ace_indent-guide {	background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y	}';var i=e("../lib/dom");i.importCssString(t.cssText,t.cssClass)})},function(e,t,i){!function(){function e(e){var t=function(e,t){return o("",e,t)},r=i;e&&(i[e]||(i[e]={}),r=i[e]),r.define&&r.define.packaged||(n.original=r.define,r.define=n,r.define.packaged=!0),r.acequire&&r.acequire.packaged||(o.original=r.acequire,r.acequire=t,r.acequire.packaged=!0)}var t="ace",i=function(){return this}();if(t||"undefined"==typeof acequirejs){var n=function(e,t,i){return"string"!=typeof e?void(n.original?n.original.apply(window,arguments):(console.error("dropping module because define wasn't a string."),console.trace())):(2==arguments.length&&(i=t),n.modules||(n.modules={},n.payloads={}),n.payloads[e]=i,void(n.modules[e]=null))},o=function(e,t,i){if("[object Array]"===Object.prototype.toString.call(t)){for(var n=[],r=0,a=t.length;a>r;++r){var l=s(e,t[r]);if(!l&&o.original)return o.original.apply(window,arguments);n.push(l)}i&&i.apply(null,n)}else{if("string"==typeof t){var c=s(e,t);return!c&&o.original?o.original.apply(window,arguments):(i&&i(),c)}if(o.original)return o.original.apply(window,arguments)}},r=function(e,t){if(-1!==t.indexOf("!")){var i=t.split("!");return r(e,i[0])+"!"+r(e,i[1])}if("."==t.charAt(0)){var n=e.split("/").slice(0,-1).join("/");for(t=n+"/"+t;-1!==t.indexOf(".")&&o!=t;){var o=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}}return t},s=function(e,t){t=r(e,t);var i=n.modules[t];if(!i){if(i=n.payloads[t],"function"==typeof i){var s={},a={id:t,uri:"",exports:s,packaged:!0},l=function(e,i){return o(t,e,i)},c=i(l,s,a);s=c||a.exports,n.modules[t]=s,delete n.payloads[t]}i=n.modules[t]=s||i}return i};e(t)}}(),ace.define("ace/lib/regexp",["require","exports","module"],function(){"use strict";function e(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.extended?"x":"")+(e.sticky?"y":"")}function t(e,t,i){if(Array.prototype.indexOf)return e.indexOf(t,i);for(var n=i||0;n<e.length;n++)if(e[n]===t)return n;return-1}var i={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},n=void 0===i.exec.call(/()??/,"")[1],o=function(){var e=/^/g;return i.test.call(e,""),!e.lastIndex}();o&&n||(RegExp.prototype.exec=function(r){var s,a,l=i.exec.apply(this,arguments);if("string"==typeof r&&l){if(!n&&l.length>1&&t(l,"")>-1&&(a=RegExp(this.source,i.replace.call(e(this),"g","")),i.replace.call(r.slice(l.index),a,function(){for(var e=1;e<arguments.length-2;e++)void 0===arguments[e]&&(l[e]=void 0)})),this._xregexp&&this._xregexp.captureNames)for(var c=1;c<l.length;c++)s=this._xregexp.captureNames[c-1],s&&(l[s]=l[c]);!o&&this.global&&!l[0].length&&this.lastIndex>l.index&&this.lastIndex--}return l},o||(RegExp.prototype.test=function(e){var t=i.exec.call(this,e);return t&&this.global&&!t[0].length&&this.lastIndex>t.index&&this.lastIndex--,!!t}))}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function e(){}function t(e){try{return Object.defineProperty(e,"sentinel",{}),"sentinel"in e}catch(t){}}function i(e){return e=+e,e!==e?e=0:0!==e&&e!==1/0&&e!==-(1/0)&&(e=(e>0||-1)*Math.floor(Math.abs(e))),e}Function.prototype.bind||(Function.prototype.bind=function(t){var i=this;if("function"!=typeof i)throw new TypeError("Function.prototype.bind called on incompatible "+i);var n=u.call(arguments,1),o=function(){if(this instanceof o){var e=i.apply(this,n.concat(u.call(arguments)));return Object(e)===e?e:this}return i.apply(t,n.concat(u.call(arguments)))};return i.prototype&&(e.prototype=i.prototype,o.prototype=new e,e.prototype=null),o});var n,o,r,s,a,l=Function.prototype.call,c=Array.prototype,h=Object.prototype,u=c.slice,d=l.bind(h.toString),g=l.bind(h.hasOwnProperty);if((a=g(h,"__defineGetter__"))&&(n=l.bind(h.__defineGetter__),o=l.bind(h.__defineSetter__),r=l.bind(h.__lookupGetter__),s=l.bind(h.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function e(e){var t=new Array(e+2);return t[0]=t[1]=0,t}var t,i=[];return i.splice.apply(i,e(20)),i.splice.apply(i,e(26)),t=i.length,i.splice(5,0,"XXX"),t+1==i.length,t+1==i.length?!0:void 0}()){var f=Array.prototype.splice;Array.prototype.splice=function(e,t){return arguments.length?f.apply(this,[void 0===e?0:e,void 0===t?this.length-e:t].concat(u.call(arguments,2))):[]}}else Array.prototype.splice=function(e,t){var i=this.length;e>0?e>i&&(e=i):void 0==e?e=0:0>e&&(e=Math.max(i+e,0)),i>e+t||(t=i-e);var n=this.slice(e,e+t),o=u.call(arguments,2),r=o.length;if(e===i)r&&this.push.apply(this,o);else{var s=Math.min(t,i-e),a=e+s,l=a+r-s,c=i-a,h=i-s;if(a>l)for(var d=0;c>d;++d)this[l+d]=this[a+d];else if(l>a)for(d=c;d--;)this[l+d]=this[a+d];if(r&&e===h)this.length=h,this.push.apply(this,o);else for(this.length=h+r,d=0;r>d;++d)this[e+d]=o[d]}return n};Array.isArray||(Array.isArray=function(e){return"[object Array]"==d(e)});var p=Object("a"),m="a"!=p[0]||!(0 in p);if(Array.prototype.forEach||(Array.prototype.forEach=function(e){var t=R(this),i=m&&"[object String]"==d(this)?this.split(""):t,n=arguments[1],o=-1,r=i.length>>>0;if("[object Function]"!=d(e))throw new TypeError;for(;++o<r;)o in i&&e.call(n,i[o],o,t)}),Array.prototype.map||(Array.prototype.map=function(e){var t=R(this),i=m&&"[object String]"==d(this)?this.split(""):t,n=i.length>>>0,o=Array(n),r=arguments[1];if("[object Function]"!=d(e))throw new TypeError(e+" is not a function");for(var s=0;n>s;s++)s in i&&(o[s]=e.call(r,i[s],s,t));return o}),Array.prototype.filter||(Array.prototype.filter=function(e){var t,i=R(this),n=m&&"[object String]"==d(this)?this.split(""):i,o=n.length>>>0,r=[],s=arguments[1];if("[object Function]"!=d(e))throw new TypeError(e+" is not a function");for(var a=0;o>a;a++)a in n&&(t=n[a],e.call(s,t,a,i)&&r.push(t));return r}),Array.prototype.every||(Array.prototype.every=function(e){var t=R(this),i=m&&"[object String]"==d(this)?this.split(""):t,n=i.length>>>0,o=arguments[1];if("[object Function]"!=d(e))throw new TypeError(e+" is not a function");for(var r=0;n>r;r++)if(r in i&&!e.call(o,i[r],r,t))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(e){var t=R(this),i=m&&"[object String]"==d(this)?this.split(""):t,n=i.length>>>0,o=arguments[1];if("[object Function]"!=d(e))throw new TypeError(e+" is not a function");for(var r=0;n>r;r++)if(r in i&&e.call(o,i[r],r,t))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(e){var t=R(this),i=m&&"[object String]"==d(this)?this.split(""):t,n=i.length>>>0;if("[object Function]"!=d(e))throw new TypeError(e+" is not a function");if(!n&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var o,r=0;if(arguments.length>=2)o=arguments[1];else for(;;){if(r in i){o=i[r++];break}if(++r>=n)throw new TypeError("reduce of empty array with no initial value")}for(;n>r;r++)r in i&&(o=e.call(void 0,o,i[r],r,t));return o}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(e){var t=R(this),i=m&&"[object String]"==d(this)?this.split(""):t,n=i.length>>>0;if("[object Function]"!=d(e))throw new TypeError(e+" is not a function");if(!n&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var o,r=n-1;if(arguments.length>=2)o=arguments[1];else for(;;){if(r in i){o=i[r--];break}if(--r<0)throw new TypeError("reduceRight of empty array with no initial value")}do r in this&&(o=e.call(void 0,o,i[r],r,t));while(r--);return o}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(e){var t=m&&"[object String]"==d(this)?this.split(""):R(this),n=t.length>>>0;if(!n)return-1;var o=0;for(arguments.length>1&&(o=i(arguments[1])),o=o>=0?o:Math.max(0,n+o);n>o;o++)if(o in t&&t[o]===e)return o;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(e){var t=m&&"[object String]"==d(this)?this.split(""):R(this),n=t.length>>>0;if(!n)return-1;var o=n-1;for(arguments.length>1&&(o=Math.min(o,i(arguments[1]))),o=o>=0?o:n-Math.abs(o);o>=0;o--)if(o in t&&e===t[o])return o;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(e){return e.__proto__||(e.constructor?e.constructor.prototype:h)}),!Object.getOwnPropertyDescriptor){var v="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(e,t){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError(v+e);if(g(e,t)){var i,n,o;if(i={enumerable:!0,configurable:!0},a){var l=e.__proto__;e.__proto__=h;var n=r(e,t),o=s(e,t);if(e.__proto__=l,n||o)return n&&(i.get=n),o&&(i.set=o),i}return i.value=e[t],i}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(e){return Object.keys(e)}),!Object.create){var A;A=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var e={};for(var t in e)e[t]=null;return e.constructor=e.hasOwnProperty=e.propertyIsEnumerable=e.isPrototypeOf=e.toLocaleString=e.toString=e.valueOf=e.__proto__=null,e},Object.create=function(e,t){var i;if(null===e)i=A();else{if("object"!=typeof e)throw new TypeError("typeof prototype["+typeof e+"] != 'object'");var n=function(){};n.prototype=e,i=new n,i.__proto__=e}return void 0!==t&&Object.defineProperties(i,t),i}}if(Object.defineProperty){var w=t({}),C="undefined"==typeof document||t(document.createElement("div"));if(!w||!C)var E=Object.defineProperty}if(!Object.defineProperty||E){var F="Property description must be an object: ",y="Object.defineProperty called on non-object: ",b="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(e,t,i){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError(y+e);if("object"!=typeof i&&"function"!=typeof i||null===i)throw new TypeError(F+i);if(E)try{return E.call(Object,e,t,i)}catch(l){}if(g(i,"value"))if(a&&(r(e,t)||s(e,t))){var c=e.__proto__;e.__proto__=h,delete e[t],e[t]=i.value,e.__proto__=c}else e[t]=i.value;else{if(!a)throw new TypeError(b);g(i,"get")&&n(e,t,i.get),g(i,"set")&&o(e,t,i.set)}return e}}Object.defineProperties||(Object.defineProperties=function(e,t){for(var i in t)g(t,i)&&Object.defineProperty(e,i,t[i]);return e}),Object.seal||(Object.seal=function(e){return e}),Object.freeze||(Object.freeze=function(e){return e});try{Object.freeze(function(){})}catch(x){Object.freeze=function(e){return function(t){return"function"==typeof t?t:e(t)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(e){return e}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(e){if(Object(e)===e)throw new TypeError;for(var t="";g(e,t);)t+="?";e[t]=!0;var i=g(e,t);return delete e[t],i}),!Object.keys){var S=!0,$=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],B=$.length;for(var D in{toString:null})S=!1;Object.keys=function T(e){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.keys called on a non-object");var T=[];for(var t in e)g(e,t)&&T.push(t);if(S)for(var i=0,n=B;n>i;i++){var o=$[i];g(e,o)&&T.push(o)}return T}}Date.now||(Date.now=function(){return(new Date).getTime()});var k="	\n\f\r   ᠎             　\u2028\u2029\ufeff";if(!String.prototype.trim||k.trim()){k="["+k+"]";var L=new RegExp("^"+k+k+"*"),_=new RegExp(k+k+"*$");String.prototype.trim=function(){return String(this).replace(L,"").replace(_,"")}}var R=function(e){if(null==e)throw new TypeError("can't convert "+e+" to object");return Object(e)}}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/regexp","ace/lib/es5-shim"],function(e){"use strict";e("./regexp"),e("./es5-shim")}),ace.define("ace/lib/dom",["require","exports","module"],function(e,t){"use strict";if("undefined"!=typeof document){var i="http://www.w3.org/1999/xhtml";t.getDocumentHead=function(e){return e||(e=document),e.head||e.getElementsByTagName("head")[0]||e.documentElement},t.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||i,e):document.createElement(e)},t.hasCssClass=function(e,t){var i=(e.className||"").split(/\s+/g);return-1!==i.indexOf(t)},t.addCssClass=function(e,i){t.hasCssClass(e,i)||(e.className+=" "+i)},t.removeCssClass=function(e,t){for(var i=e.className.split(/\s+/g);;){var n=i.indexOf(t);if(-1==n)break;i.splice(n,1)}e.className=i.join(" ")},t.toggleCssClass=function(e,t){for(var i=e.className.split(/\s+/g),n=!0;;){var o=i.indexOf(t);if(-1==o)break;n=!1,i.splice(o,1)}return n&&i.push(t),e.className=i.join(" "),n},t.setCssClass=function(e,i,n){n?t.addCssClass(e,i):t.removeCssClass(e,i)},t.hasCssString=function(e,t){var i,n=0;if(t=t||document,t.createStyleSheet&&(i=t.styleSheets)){for(;n<i.length;)if(i[n++].owningElement.id===e)return!0}else if(i=t.getElementsByTagName("style"))for(;n<i.length;)if(i[n++].id===e)return!0;return!1},t.importCssString=function(e,n,o){if(o=o||document,n&&t.hasCssString(n,o))return null;var r;o.createStyleSheet?(r=o.createStyleSheet(),r.cssText=e,n&&(r.owningElement.id=n)):(r=o.createElementNS?o.createElementNS(i,"style"):o.createElement("style"),r.appendChild(o.createTextNode(e)),n&&(r.id=n),t.getDocumentHead(o).appendChild(r))},t.importCssStylsheet=function(e,i){if(i.createStyleSheet)i.createStyleSheet(e);else{var n=t.createElement("link");n.rel="stylesheet",n.href=e,t.getDocumentHead(i).appendChild(n)}},t.getInnerWidth=function(e){return parseInt(t.computedStyle(e,"paddingLeft"),10)+parseInt(t.computedStyle(e,"paddingRight"),10)+e.clientWidth},t.getInnerHeight=function(e){return parseInt(t.computedStyle(e,"paddingTop"),10)+parseInt(t.computedStyle(e,"paddingBottom"),10)+e.clientHeight},void 0!==window.pageYOffset?(t.getPageScrollTop=function(){return window.pageYOffset},t.getPageScrollLeft=function(){return window.pageXOffset}):(t.getPageScrollTop=function(){return document.body.scrollTop},t.getPageScrollLeft=function(){return document.body.scrollLeft}),t.computedStyle=window.getComputedStyle?function(e,t){return t?(window.getComputedStyle(e,"")||{})[t]||"":window.getComputedStyle(e,"")||{}}:function(e,t){return t?e.currentStyle[t]:e.currentStyle},t.scrollbarWidth=function(e){var i=t.createElement("ace_inner");i.style.width="100%",i.style.minWidth="0px",i.style.height="200px",i.style.display="block";var n=t.createElement("ace_outer"),o=n.style;o.position="absolute",o.left="-10000px",o.overflow="hidden",o.width="200px",o.minWidth="0px",o.height="150px",o.display="block",n.appendChild(i);var r=e.documentElement;r.appendChild(n);var s=i.offsetWidth;o.overflow="scroll";var a=i.offsetWidth;return s==a&&(a=n.clientWidth),r.removeChild(n),s-a},t.setInnerHtml=function(e,t){var i=e.cloneNode(!1);return i.innerHTML=t,e.parentNode.replaceChild(i,e),i},"textContent"in document.documentElement?(t.setInnerText=function(e,t){e.textContent=t},t.getInnerText=function(e){return e.textContent}):(t.setInnerText=function(e,t){e.innerText=t},t.getInnerText=function(e){return e.innerText}),t.getParentWindow=function(e){return e.defaultView||e.parentWindow}}}),ace.define("ace/lib/oop",["require","exports","module"],function(e,t){"use strict";t.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},t.mixin=function(e,t){for(var i in t)e[i]=t[i];return e},t.implement=function(e,i){t.mixin(e,i)}}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop"],function(e,t){"use strict";e("./fixoldbrowsers");var i=e("./oop"),n=function(){var e,t,n={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,"super":8,meta:8,command:8,cmd:8},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'"}};for(t in n.FUNCTION_KEYS)e=n.FUNCTION_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);for(t in n.PRINTABLE_KEYS)e=n.PRINTABLE_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);return i.mixin(n,n.MODIFIER_KEYS),i.mixin(n,n.PRINTABLE_KEYS),i.mixin(n,n.FUNCTION_KEYS),n.enter=n["return"],n.escape=n.esc,n.del=n["delete"],n[173]="-",function(){for(var e=["cmd","ctrl","alt","shift"],t=Math.pow(2,e.length);t--;)n.KEY_MODS[t]=e.filter(function(e){return t&n.KEY_MODS[e]}).join("-")+"-"}(),n.KEY_MODS[0]="",n.KEY_MODS[-1]="input",n}();i.mixin(t,n),t.keyCodeToString=function(e){var t=n[e];return"string"!=typeof t&&(t=String.fromCharCode(e)),t.toLowerCase()}}),ace.define("ace/lib/useragent",["require","exports","module"],function(e,t){"use strict";if(t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS},"object"==typeof navigator){var i=(navigator.platform.match(/mac|win|linux/i)||["other"])[0].toLowerCase(),n=navigator.userAgent;t.isWin="win"==i,t.isMac="mac"==i,t.isLinux="linux"==i,t.isIE=parseFloat("Microsoft Internet Explorer"==navigator.appName||navigator.appName.indexOf("MSAppHost")>=0?(n.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]:(n.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=(window.Controllers||window.controllers)&&"Gecko"===window.navigator.product,t.isOldGecko=t.isGecko&&parseInt((n.match(/rv\:(\d+)/)||[])[1],10)<4,t.isOpera=window.opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(n.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(n.split(" Chrome/")[1])||void 0,t.isAIR=n.indexOf("AdobeAIR")>=0,t.isIPad=n.indexOf("iPad")>=0,t.isTouchPad=n.indexOf("TouchPad")>=0,t.isChromeOS=n.indexOf(" CrOS ")>=0}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t){"use strict";function i(e,t,i){var l=r(t);if(!o.isMac&&s){if((s[91]||s[92])&&(l|=8),s.altGr){if(3==(3&l))return;s.altGr=0}if(18===i||17===i){var c="location"in t?t.location:t.keyLocation;if(17===i&&1===c)a=t.timeStamp;else if(18===i&&3===l&&2===c){var h=-a;a=t.timeStamp,h+=a,3>h&&(s.altGr=!0)}}}if(i in n.MODIFIER_KEYS){switch(n.MODIFIER_KEYS[i]){case"Alt":l=2;break;case"Shift":l=4;break;case"Ctrl":l=1;break;default:l=8}i=-1}if(8&l&&(91===i||93===i)&&(i=-1),!l&&13===i){var c="location"in t?t.location:t.keyLocation;if(3===c&&(e(t,l,-i),t.defaultPrevented))return}if(o.isChromeOS&&8&l){if(e(t,l,i),t.defaultPrevented)return;l&=-9}return l||i in n.FUNCTION_KEYS||i in n.PRINTABLE_KEYS?e(t,l,i):!1}var n=e("./keys"),o=e("./useragent");t.addListener=function(e,t,i){if(e.addEventListener)return e.addEventListener(t,i,!1);if(e.attachEvent){var n=function(){i.call(e,window.event)};i._wrapper=n,e.attachEvent("on"+t,n)}},t.removeListener=function(e,t,i){return e.removeEventListener?e.removeEventListener(t,i,!1):void(e.detachEvent&&e.detachEvent("on"+t,i._wrapper||i))},t.stopEvent=function(e){return t.stopPropagation(e),t.preventDefault(e),!1},t.stopPropagation=function(e){e.stopPropagation?e.stopPropagation():e.cancelBubble=!0},t.preventDefault=function(e){e.preventDefault?e.preventDefault():e.returnValue=!1},t.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||o.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.preventDefault?e.button:{1:0,2:2,4:1}[e.button]},t.capture=function(e,i,n){function o(e){i&&i(e),n&&n(e),t.removeListener(document,"mousemove",i,!0),t.removeListener(document,"mouseup",o,!0),t.removeListener(document,"dragstart",o,!0)}return t.addListener(document,"mousemove",i,!0),t.addListener(document,"mouseup",o,!0),t.addListener(document,"dragstart",o,!0),o},t.addMouseWheelListener=function(e,i){"onmousewheel"in e?t.addListener(e,"mousewheel",function(e){var t=8;void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/t,e.wheelY=-e.wheelDeltaY/t):(e.wheelX=0,e.wheelY=-e.wheelDelta/t),i(e)}):"onwheel"in e?t.addListener(e,"wheel",function(e){var t=.35;switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=e.deltaX*t||0,e.wheelY=e.deltaY*t||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0);

}i(e)}):t.addListener(e,"DOMMouseScroll",function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),i(e)})},t.addMultiMouseDownListener=function(e,i,n,r){var s,a,l,c=0,h={2:"dblclick",3:"tripleclick",4:"quadclick"};t.addListener(e,"mousedown",function(e){if(0!==t.getButton(e)?c=0:e.detail>1?(c++,c>4&&(c=1)):c=1,o.isIE){var u=Math.abs(e.clientX-s)>5||Math.abs(e.clientY-a)>5;(!l||u)&&(c=1),l&&clearTimeout(l),l=setTimeout(function(){l=null},i[c-1]||600),1==c&&(s=e.clientX,a=e.clientY)}if(e._clicks=c,n[r]("mousedown",e),c>4)c=0;else if(c>1)return n[r](h[c],e)}),o.isOldIE&&t.addListener(e,"dblclick",function(e){c=2,l&&clearTimeout(l),l=setTimeout(function(){l=null},i[c-1]||600),n[r]("mousedown",e),n[r](h[c],e)})};var r=!o.isMac||!o.isOpera||"KeyboardEvent"in window?function(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)}:function(e){return 0|(e.metaKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.ctrlKey?8:0)};t.getModifierString=function(e){return n.KEY_MODS[r(e)]};var s=null,a=0;if(t.addCommandKeyListener=function(e,n){var r=t.addListener;if(o.isOldGecko||o.isOpera&&!("KeyboardEvent"in window)){var a=null;r(e,"keydown",function(e){a=e.keyCode}),r(e,"keypress",function(e){return i(n,e,a)})}else{var l=null;r(e,"keydown",function(e){s[e.keyCode]=!0;var t=i(n,e,e.keyCode);return l=e.defaultPrevented,t}),r(e,"keypress",function(e){l&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(t.stopEvent(e),l=null)}),r(e,"keyup",function(e){s[e.keyCode]=null}),s||(s=Object.create(null),r(window,"focus",function(){s=Object.create(null)}))}},window.postMessage&&!o.isOldIE){var l=1;t.nextTick=function(e,i){i=i||window;var n="zero-timeout-message-"+l;t.addListener(i,"message",function o(r){r.data==n&&(t.stopPropagation(r),t.removeListener(i,"message",o),e())}),i.postMessage(n,"*")}}t.nextFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame,t.nextFrame=t.nextFrame?t.nextFrame.bind(window):function(e){setTimeout(e,17)}}),ace.define("ace/lib/lang",["require","exports","module"],function(e,t){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var i="";t>0;)1&t&&(i+=e),(t>>=1)&&(e+=e);return i};var i=/^\s\s*/,n=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(i,"")},t.stringTrimRight=function(e){return e.replace(n,"")},t.copyObject=function(e){var t={};for(var i in e)t[i]=e[i];return t},t.copyArray=function(e){for(var t=[],i=0,n=e.length;n>i;i++)t[i]=e[i]&&"object"==typeof e[i]?this.copyObject(e[i]):e[i];return t},t.deepCopy=function(e){if("object"!=typeof e||!e)return e;var i=e.constructor;if(i===RegExp)return e;var n=i();for(var o in e)n[o]="object"==typeof e[o]?t.deepCopy(e[o]):e[o];return n},t.arrayToMap=function(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=1;return t},t.createMap=function(e){var t=Object.create(null);for(var i in e)t[i]=e[i];return t},t.arrayRemove=function(e,t){for(var i=0;i<=e.length;i++)t===e[i]&&e.splice(i,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return e.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var i=[];return e.replace(t,function(e){i.push({offset:arguments[arguments.length-2],length:e.length})}),i},t.deferredCall=function(e){var t=null,i=function(){t=null,e()},n=function(e){return n.cancel(),t=setTimeout(i,e||0),n};return n.schedule=n,n.call=function(){return this.cancel(),e(),n},n.cancel=function(){return clearTimeout(t),t=null,n},n.isPending=function(){return t},n},t.delayedCall=function(e,t){var i=null,n=function(){i=null,e()},o=function(e){null==i&&(i=setTimeout(n,e||t))};return o.delay=function(e){i&&clearTimeout(i),i=setTimeout(n,e||t)},o.schedule=o,o.call=function(){this.cancel(),e()},o.cancel=function(){i&&clearTimeout(i),i=null},o.isPending=function(){return i},o}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang"],function(e,t){"use strict";var i=e("../lib/event"),n=e("../lib/useragent"),o=e("../lib/dom"),r=e("../lib/lang"),s=n.isChrome<18,a=n.isIE,l=function(e,t){function l(e){if(!p){if(B)t=0,i=e?0:u.value.length-1;else var t=e?2:1,i=2;try{u.setSelectionRange(t,i)}catch(n){}}}function c(){p||(u.value=d,n.isWebKit&&E.schedule())}function h(){clearTimeout(j),j=setTimeout(function(){m&&(u.style.cssText=m,m=""),null==t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=!0,t.renderer.$moveTextAreaToCursor())},n.isOldIE?200:0)}var u=o.createElement("textarea");u.className="ace_text-input",n.isTouchPad&&u.setAttribute("x-palm-disable-auto-cap",!0),u.wrap="off",u.autocorrect="off",u.autocapitalize="off",u.spellcheck=!1,u.style.opacity="0",n.isOldIE&&(u.style.top="-100px"),e.insertBefore(u,e.firstChild);var d="",g=!1,f=!1,p=!1,m="",v=!0;try{var A=document.activeElement===u}catch(w){}i.addListener(u,"blur",function(e){t.onBlur(e),A=!1}),i.addListener(u,"focus",function(e){A=!0,t.onFocus(e),l()}),this.focus=function(){u.focus()},this.blur=function(){u.blur()},this.isFocused=function(){return A};var C=r.delayedCall(function(){A&&l(v)}),E=r.delayedCall(function(){p||(u.value=d,A&&l())});n.isWebKit||t.addEventListener("changeSelection",function(){t.selection.isEmpty()!=v&&(v=!v,C.schedule())}),c(),A&&t.onFocus();var F=function(e){return 0===e.selectionStart&&e.selectionEnd===e.value.length};if(!u.setSelectionRange&&u.createTextRange&&(u.setSelectionRange=function(e,t){var i=this.createTextRange();i.collapse(!0),i.moveStart("character",e),i.moveEnd("character",t),i.select()},F=function(e){try{var t=e.ownerDocument.selection.createRange()}catch(i){}return t&&t.parentElement()==e?t.text==e.value:!1}),n.isOldIE){var y=!1,b=function(e){if(!y){var t=u.value;if(!p&&t&&t!=d){if(e&&t==d[0])return x.schedule();k(t),y=!0,c(),y=!1}}},x=r.delayedCall(b);i.addListener(u,"propertychange",b);var S={13:1,27:1};i.addListener(u,"keyup",function(e){return!p||u.value&&!S[e.keyCode]||setTimeout(P,0),(u.value.charCodeAt(0)||0)<129?x.call():void(p?I():N())}),i.addListener(u,"keydown",function(){x.schedule(50)})}var $=function(){g?g=!1:F(u)?(t.selectAll(),l()):B&&l(t.selection.isEmpty())},B=null;this.setInputHandler=function(e){B=e},this.getInputHandler=function(){return B};var D=!1,k=function(e){B&&(e=B(e),B=null),f?(l(),e&&t.onPaste(e),f=!1):e==d.charAt(0)?D?t.execCommand("del",{source:"ace"}):t.execCommand("backspace",{source:"ace"}):(e.substring(0,2)==d?e=e.substr(2):e.charAt(0)==d.charAt(0)?e=e.substr(1):e.charAt(e.length-1)==d.charAt(0)&&(e=e.slice(0,-1)),e.charAt(e.length-1)==d.charAt(0)&&(e=e.slice(0,-1)),e&&t.onTextInput(e)),D&&(D=!1)},L=function(){if(!p){var e=u.value;k(e),c()}},_=function(e,t){var i=e.clipboardData||window.clipboardData;if(i&&!s){var n=a?"Text":"text/plain";return t?i.setData(n,t)!==!1:i.getData(n)}},R=function(e,n){var o=t.getCopyText();return o?void(_(e,o)?(n?t.onCut():t.onCopy(),i.preventDefault(e)):(g=!0,u.value=o,u.select(),setTimeout(function(){g=!1,c(),l(),n?t.onCut():t.onCopy()}))):i.preventDefault(e)},T=function(e){R(e,!0)},M=function(e){R(e,!1)},O=function(e){var o=_(e);"string"==typeof o?(o&&t.onPaste(o),n.isIE&&setTimeout(l),i.preventDefault(e)):(u.value="",f=!0)};i.addCommandKeyListener(u,t.onCommandKey.bind(t)),i.addListener(u,"select",$),i.addListener(u,"input",L),i.addListener(u,"cut",T),i.addListener(u,"copy",M),i.addListener(u,"paste",O),"oncut"in u&&"oncopy"in u&&"onpaste"in u||i.addListener(e,"keydown",function(e){if((!n.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:M(e);break;case 86:O(e);break;case 88:T(e)}});var N=function(){p||!t.onCompositionStart||t.$readOnly||(p={},t.onCompositionStart(),setTimeout(I,0),t.on("mousedown",P),t.selection.isEmpty()||(t.insert(""),t.session.markUndoGroup(),t.selection.clearSelection()),t.session.markUndoGroup())},I=function(){if(p&&t.onCompositionUpdate&&!t.$readOnly){var e=u.value.replace(/\x01/g,"");if(p.lastValue!==e&&(t.onCompositionUpdate(e),p.lastValue&&t.undo(),p.lastValue=e,p.lastValue)){var i=t.selection.getRange();t.insert(p.lastValue),t.session.markUndoGroup(),p.range=t.selection.getRange(),t.selection.setRange(i),t.selection.clearSelection()}}},P=function(e){if(t.onCompositionEnd&&!t.$readOnly){var i=p;p=!1;var n=setTimeout(function(){n=null;var e=u.value.replace(/\x01/g,"");p||(e==i.lastValue?c():!i.lastValue&&e&&(c(),k(e)))});B=function(e){return n&&clearTimeout(n),e=e.replace(/\x01/g,""),e==i.lastValue?"":(i.lastValue&&n&&t.undo(),e)},t.onCompositionEnd(),t.removeListener("mousedown",P),"compositionend"==e.type&&i.range&&t.selection.setRange(i.range)}},W=r.delayedCall(I,50);i.addListener(u,"compositionstart",N),n.isGecko?i.addListener(u,"text",function(){W.schedule()}):(i.addListener(u,"keyup",function(){W.schedule()}),i.addListener(u,"keydown",function(){W.schedule()})),i.addListener(u,"compositionend",P),this.getElement=function(){return u},this.setReadOnly=function(e){u.readOnly=e},this.onContextMenu=function(e){D=!0,l(t.selection.isEmpty()),t._emit("nativecontextmenu",{target:t,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,r){if(r||!n.isOldIE){m||(m=u.style.cssText),u.style.cssText=(r?"z-index:100000;":"")+"height:"+u.style.height+";"+(n.isIE?"opacity:0.1;":"");var s=t.container.getBoundingClientRect(),a=o.computedStyle(t.container),l=s.top+(parseInt(a.borderTopWidth)||0),c=s.left+(parseInt(s.borderLeftWidth)||0),d=s.bottom-l-u.clientHeight-2,g=function(e){u.style.left=e.clientX-c-2+"px",u.style.top=Math.min(e.clientY-l-2,d)+"px"};g(e),"mousedown"==e.type&&(t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=null),n.isWin&&!n.isOldIE&&i.capture(t.container,g,h))}},this.onContextMenuClose=h;var j,H=function(e){t.textInput.onContextMenu(e),h()};i.addListener(t.renderer.scroller,"contextmenu",H),i.addListener(u,"contextmenu",H)};t.TextInput=l}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t){"use strict";function i(e){e.$clickSelection=null;var t=e.editor;t.setDefaultHandler("mousedown",this.onMouseDown.bind(e)),t.setDefaultHandler("dblclick",this.onDoubleClick.bind(e)),t.setDefaultHandler("tripleclick",this.onTripleClick.bind(e)),t.setDefaultHandler("quadclick",this.onQuadClick.bind(e)),t.setDefaultHandler("mousewheel",this.onMouseWheel.bind(e));var i=["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"];i.forEach(function(t){e[t]=this[t]},this),e.selectByLines=this.extendSelectionBy.bind(e,"getLineRange"),e.selectByWords=this.extendSelectionBy.bind(e,"getWordRange")}function n(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}function o(e,t){if(e.start.row==e.end.row)var i=2*t.column-e.start.column-e.end.column;else if(e.start.row!=e.end.row-1||e.start.column||e.end.column)var i=2*t.row-e.start.row-e.end.row;else var i=t.column-4;return 0>i?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}var r=(e("../lib/dom"),e("../lib/event"),e("../lib/useragent"),0);(function(){this.onMouseDown=function(e){var t=e.inSelection(),i=e.getDocumentPosition();this.mousedownEvent=e;var n=this.editor,o=e.getButton();if(0!==o){var r=n.getSelectionRange(),s=r.isEmpty();return s&&n.selection.moveToPosition(i),void n.textInput.onContextMenu(e.domEvent)}return this.mousedownEvent.time=Date.now(),!t||n.isFocused()||(n.focus(),!this.$focusTimout||this.$clickSelection||n.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(i,e.domEvent._clicks>1),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var i=this.editor;this.mousedownEvent.getShiftKey()?i.selection.selectToPosition(e):t||i.selection.moveToPosition(e),t||this.select(),i.renderer.scroller.setCapture&&i.renderer.scroller.setCapture(),i.setStyle("ace_selecting"),this.setState("select")},this.select=function(){var e,t=this.editor,i=t.renderer.screenToTextCoordinates(this.x,this.y);if(this.$clickSelection){var n=this.$clickSelection.comparePoint(i);if(-1==n)e=this.$clickSelection.end;else if(1==n)e=this.$clickSelection.start;else{var r=o(this.$clickSelection,i);i=r.cursor,e=r.anchor}t.selection.setSelectionAnchor(e.row,e.column)}t.selection.selectToPosition(i),t.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,i=this.editor,n=i.renderer.screenToTextCoordinates(this.x,this.y),r=i.selection[e](n.row,n.column);if(this.$clickSelection){var s=this.$clickSelection.comparePoint(r.start),a=this.$clickSelection.comparePoint(r.end);if(-1==s&&0>=a)t=this.$clickSelection.end,(r.end.row!=n.row||r.end.column!=n.column)&&(n=r.start);else if(1==a&&s>=0)t=this.$clickSelection.start,(r.start.row!=n.row||r.start.column!=n.column)&&(n=r.end);else if(-1==s&&1==a)n=r.end,t=r.start;else{var l=o(this.$clickSelection,n);n=l.cursor,t=l.anchor}i.selection.setSelectionAnchor(t.row,t.column)}i.selection.selectToPosition(n),i.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){var e=n(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y),t=Date.now();(e>r||t-this.mousedownEvent.time>this.$focusTimout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var t=e.getDocumentPosition(),i=this.editor,n=i.session,o=n.getBracketRange(t);o?(o.isEmpty()&&(o.start.column--,o.end.column++),this.setState("select")):(o=i.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=o,this.select()},this.onTripleClick=function(e){var t=e.getDocumentPosition(),i=this.editor;this.setState("selectByLines");var n=i.getSelectionRange();n.isMultiLine()&&n.contains(t.row,t.column)?(this.$clickSelection=i.selection.getLineRange(n.start.row),this.$clickSelection.end=i.selection.getLineRange(n.end.row).end):this.$clickSelection=i.selection.getLineRange(t.row),this.select()},this.onQuadClick=function(){var e=this.editor;e.selectAll(),this.$clickSelection=e.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){if(!e.getAccelKey()){e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0);var t=e.domEvent.timeStamp,i=t-(this.$lastScrollTime||0),n=this.editor,o=n.renderer.isScrollableBy(e.wheelX*e.speed,e.wheelY*e.speed);return o||200>i?(this.$lastScrollTime=t,n.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}}}).call(i.prototype),t.DefaultHandlers=i}),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(e,t){"use strict";function i(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}var n=(e("./lib/oop"),e("./lib/dom"));(function(){this.$init=function(){return this.$element=n.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){n.setInnerText(this.getElement(),e)},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){n.addCssClass(this.getElement(),e)},this.show=function(e,t,i){null!=e&&this.setText(e),null!=t&&null!=i&&this.setPosition(t,i),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth}}).call(i.prototype),t.Tooltip=i}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],function(e,t){"use strict";function i(e){function t(){var t=u.getDocumentPosition().row,n=l.$annotations[t];if(!n)return i();var o=a.session.getLength();if(t==o){var s=a.renderer.pixelToScreenCoordinates(0,u.y).row,h=u.$pos;if(s>a.session.documentToScreenRow(h.row,h.column))return i()}if(d!=n)if(d=n.text.join("<br/>"),c.setHtml(d),c.show(),a.on("mousewheel",i),e.$tooltipFollowsMouse)r(u);else{var g=l.$cells[a.session.documentToScreenRow(t,0)].element,f=g.getBoundingClientRect(),p=c.getElement().style;p.left=f.right+"px",p.top=f.bottom+"px"}}function i(){h&&(h=clearTimeout(h)),d&&(c.hide(),d=null,a.removeEventListener("mousewheel",i))}function r(e){c.setPosition(e.x,e.y)}var a=e.editor,l=a.renderer.$gutterLayer,c=new n(a.container);e.editor.setDefaultHandler("guttermousedown",function(t){if(a.isFocused()&&0==t.getButton()){var i=l.getRegion(t);if("foldWidgets"!=i){var n=t.getDocumentPosition().row,o=a.session.selection;if(t.getShiftKey())o.selectTo(n,0);else{if(2==t.domEvent.detail)return a.selectAll(),t.preventDefault();e.$clickSelection=a.selection.getLineRange(n)}return e.setState("selectByLines"),e.captureMouse(t),t.preventDefault()}}});var h,u,d;e.editor.setDefaultHandler("guttermousemove",function(n){var s=n.domEvent.target||n.domEvent.srcElement;return o.hasCssClass(s,"ace_fold-widget")?i():(d&&e.$tooltipFollowsMouse&&r(n),u=n,void(h||(h=setTimeout(function(){h=null,u&&!e.isMousePressed?t():i()},50))))}),s.addListener(a.renderer.$gutter,"mouseout",function(){u=null,d&&!h&&(h=setTimeout(function(){h=null,i()},50))}),a.on("changeSession",i)}function n(e){a.call(this,e)}var o=e("../lib/dom"),r=e("../lib/oop"),s=e("../lib/event"),a=e("../tooltip").Tooltip;r.inherits(n,a),function(){this.setPosition=function(e,t){var i=window.innerWidth||document.documentElement.clientWidth,n=window.innerHeight||document.documentElement.clientHeight,o=this.getWidth(),r=this.getHeight();e+=15,t+=15,e+o>i&&(e-=e+o-i),t+r>n&&(t-=20+r),a.prototype.setPosition.call(this,e,t)}}.call(n.prototype),t.GutterHandler=i}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t){"use strict";var i=e("../lib/event"),n=e("../lib/useragent"),o=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){i.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){i.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos?this.$pos:(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY),this.$pos)},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e=this.editor,t=e.getSelectionRange();if(t.isEmpty())this.$inSelection=!1;else{var i=this.getDocumentPosition();this.$inSelection=t.contains(i.row,i.column)}return this.$inSelection},this.getButton=function(){return i.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=n.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(o.prototype)}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t){"use strict";function i(e){function t(e,t){var i=Date.now(),o=!t||e.row!=t.row,r=!t||e.column!=t.column;if(!B||o||r)m.$blockScrolling+=1,m.moveCursorToPosition(e),m.$blockScrolling-=1,B=i,D={x:C,y:E};else{var s=n(D.x,D.y,C,E);s>c?B=null:i-B>=l&&(m.renderer.scrollCursorIntoView(),B=null)}}function i(e,t){var i=Date.now(),n=m.renderer.layerConfig.lineHeight,o=m.renderer.layerConfig.characterWidth,r=m.renderer.scroller.getBoundingClientRect(),s={x:{left:C-r.left,right:r.right-C},y:{top:E-r.top,bottom:r.bottom-E}},l=Math.min(s.x.left,s.x.right),c=Math.min(s.y.top,s.y.bottom),h={row:e.row,column:e.column};2>=l/o&&(h.column+=s.x.left<s.x.right?-3:2),1>=c/n&&(h.row+=s.y.top<s.y.bottom?-1:1);var u=e.row!=h.row,d=e.column!=h.column,g=!t||e.row!=t.row;u||d&&!g?$?i-$>=a&&m.renderer.scrollCursorIntoView(h):$=i:$=null}function h(){var e=b;b=m.renderer.screenToTextCoordinates(C,E),t(b,e),i(b,e)}function u(){y=m.selection.toOrientedRange(),w=m.session.addMarker(y,"ace_selection",m.getSelectionStyle()),m.clearSelection(),m.isFocused()&&m.renderer.$cursorLayer.setBlinking(!1),clearInterval(F),h(),F=setInterval(h,20),L=0,r.addListener(document,"mousemove",g)}function d(){clearInterval(F),m.session.removeMarker(w),w=null,m.$blockScrolling+=1,m.selection.fromOrientedRange(y),m.$blockScrolling-=1,m.isFocused()&&!S&&m.renderer.$cursorLayer.setBlinking(!m.getReadOnly()),y=null,b=null,L=0,$=null,B=null,r.removeListener(document,"mousemove",g)}function g(){null==_&&(_=setTimeout(function(){null!=_&&w&&d()},20))}function f(e){var t=e.types;return!t||Array.prototype.some.call(t,function(e){return"text/plain"==e||"Text"==e})}function p(e){var t=["copy","copymove","all","uninitialized"],i=["move","copymove","linkmove","all","uninitialized"],n=s.isMac?e.altKey:e.ctrlKey,o="uninitialized";try{o=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var r="none";return n&&t.indexOf(o)>=0?r="copy":i.indexOf(o)>=0?r="move":t.indexOf(o)>=0&&(r="copy"),r}var m=e.editor,v=o.createElement("img");v.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",s.isOpera&&(v.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;");var A=["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"];A.forEach(function(t){e[t]=this[t]},this),m.addEventListener("mousedown",this.onMouseDown.bind(e));var w,C,E,F,y,b,x,S,$,B,D,k=m.container,L=0;this.onDragStart=function(e){if(this.cancelDrag||!k.draggable){var t=this;return setTimeout(function(){t.startSelect(),t.captureMouse(e)},0),e.preventDefault()}y=m.getSelectionRange();var i=e.dataTransfer;i.effectAllowed=m.getReadOnly()?"copy":"copyMove",s.isOpera&&(m.container.appendChild(v),v.scrollTop=0),i.setDragImage&&i.setDragImage(v,0,0),s.isOpera&&m.container.removeChild(v),i.clearData(),i.setData("Text",m.session.getTextRange()),S=!0,this.setState("drag")},this.onDragEnd=function(e){if(k.draggable=!1,S=!1,this.setState(null),!m.getReadOnly()){var t=e.dataTransfer.dropEffect;x||"move"!=t||m.session.remove(m.getSelectionRange()),m.renderer.$cursorLayer.setBlinking(!0)}this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){return!m.getReadOnly()&&f(e.dataTransfer)?(C=e.clientX,E=e.clientY,w||u(),L++,e.dataTransfer.dropEffect=x=p(e),r.preventDefault(e)):void 0},this.onDragOver=function(e){return!m.getReadOnly()&&f(e.dataTransfer)?(C=e.clientX,E=e.clientY,w||(u(),L++),null!==_&&(_=null),e.dataTransfer.dropEffect=x=p(e),r.preventDefault(e)):void 0},this.onDragLeave=function(e){return L--,0>=L&&w?(d(),x=null,r.preventDefault(e)):void 0},this.onDrop=function(e){if(b){var t=e.dataTransfer;if(S)switch(x){case"move":y=y.contains(b.row,b.column)?{start:b,end:b}:m.moveText(y,b);break;case"copy":y=m.moveText(y,b,!0)}else{var i=t.getData("Text");y={start:b,end:m.session.insert(b,i)},m.focus(),x=null}return d(),r.preventDefault(e)}},r.addListener(k,"dragstart",this.onDragStart.bind(e)),r.addListener(k,"dragend",this.onDragEnd.bind(e)),r.addListener(k,"dragenter",this.onDragEnter.bind(e)),r.addListener(k,"dragover",this.onDragOver.bind(e)),r.addListener(k,"dragleave",this.onDragLeave.bind(e)),r.addListener(k,"drop",this.onDrop.bind(e));var _=null}function n(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}var o=e("../lib/dom"),r=e("../lib/event"),s=e("../lib/useragent"),a=200,l=200,c=5;(function(){this.dragWait=function(){var e=Date.now()-this.mousedownEvent.time;e>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){var e=this.editor.container;e.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(){this.editor.renderer.$cursorLayer.setBlinking(!this.editor.getReadOnly()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor,t=e.container;t.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging");var i=s.isWin?"default":"move";e.renderer.setCursorStyle(i),this.setState("dragReady")},this.onMouseDrag=function(){var e=this.editor.container;if(s.isIE&&"dragReady"==this.state){var t=n(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y);t>3&&e.dragDrop()}if("dragWait"===this.state){var t=n(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y);t>0&&(e.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))}},this.onMouseDown=function(e){if(this.$dragEnabled){this.mousedownEvent=e;var t=this.editor,i=e.inSelection(),n=e.getButton(),o=e.domEvent.detail||1;if(1===o&&0===n&&i){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var r=e.domEvent.target||e.domEvent.srcElement;if("unselectable"in r&&(r.unselectable="on"),t.getDragDelay()){if(s.isWebKit){this.cancelDrag=!0;var a=t.container;a.draggable=!0}this.setState("dragWait")}else this.startDrag();this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0}}}}).call(i.prototype),t.DragdropHandler=i}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(e,t){"use strict";var i=e("./dom");t.get=function(e,t){var i=new XMLHttpRequest;i.open("GET",e,!0),i.onreadystatechange=function(){4===i.readyState&&t(i.responseText)},i.send(null)},t.loadScript=function(e,t){var n=i.getDocumentHead(),o=document.createElement("script");o.src=e,n.appendChild(o),o.onload=o.onreadystatechange=function(e,i){(i||!o.readyState||"loaded"==o.readyState||"complete"==o.readyState)&&(o=o.onload=o.onreadystatechange=null,i||t())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(e,t){"use strict";var i={},n=function(){this.propagationStopped=!0},o=function(){this.defaultPrevented=!0};i._emit=i._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var i=this._eventRegistry[e]||[],r=this._defaultHandlers[e];if(i.length||r){"object"==typeof t&&t||(t={}),t.type||(t.type=e),t.stopPropagation||(t.stopPropagation=n),t.preventDefault||(t.preventDefault=o),i=i.slice();for(var s=0;s<i.length&&(i[s](t,this),!t.propagationStopped);s++);return r&&!t.defaultPrevented?r(t,this):void 0}},i._signal=function(e,t){var i=(this._eventRegistry||{})[e];if(i){i=i.slice();for(var n=0;n<i.length;n++)i[n](t,this)}},i.once=function(e,t){var i=this;t&&this.addEventListener(e,function n(){i.removeEventListener(e,n),t.apply(null,arguments)})},i.setDefaultHandler=function(e,t){var i=this._defaultHandlers;if(i||(i=this._defaultHandlers={_disabled_:{}}),i[e]){var n=i[e],o=i._disabled_[e];o||(i._disabled_[e]=o=[]),o.push(n);var r=o.indexOf(t);-1!=r&&o.splice(r,1)}i[e]=t},i.removeDefaultHandler=function(e,t){var i=this._defaultHandlers;if(i){var n=i._disabled_[e];if(i[e]==t){{i[e]}n&&this.setDefaultHandler(e,n.pop())}else if(n){var o=n.indexOf(t);-1!=o&&n.splice(o,1)}}},i.on=i.addEventListener=function(e,t,i){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];return n||(n=this._eventRegistry[e]=[]),-1==n.indexOf(t)&&n[i?"unshift":"push"](t),t},i.off=i.removeListener=i.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};var i=this._eventRegistry[e];if(i){var n=i.indexOf(t);-1!==n&&i.splice(n,1)}},i.removeAllListeners=function(e){this._eventRegistry&&(this._eventRegistry[e]=[])},t.EventEmitter=i}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/event_emitter"],function(e,t,n){"no use strict";function o(o){if(u.packaged=o||e.packaged||n.packaged||h.define&&i(18).packaged,!h.document)return"";for(var s={},a="",l=document.currentScript||document._currentScript,c=l&&l.ownerDocument||document,d=c.getElementsByTagName("script"),g=0;g<d.length;g++){var f=d[g],p=f.src||f.getAttribute("src");if(p){for(var m=f.attributes,v=0,A=m.length;A>v;v++){var w=m[v];0===w.name.indexOf("data-ace-")&&(s[r(w.name.replace(/^data-ace-/,""))]=w.value)}var C=p.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);C&&(a=C[1])}}a&&(s.base=s.base||a,s.packaged=!0),s.basePath=s.base,s.workerPath=s.workerPath||s.base,s.modePath=s.modePath||s.base,s.themePath=s.themePath||s.base,delete s.base;for(var E in s)"undefined"!=typeof s[E]&&t.set(E,s[E])}function r(e){return e.replace(/-(.)/g,function(e,t){return t.toUpperCase()})}var s=e("./lib/lang"),a=e("./lib/oop"),l=e("./lib/net"),c=e("./lib/event_emitter").EventEmitter,h=function(){return this}(),u={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{}};t.get=function(e){if(!u.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return u[e]},t.set=function(e,t){if(!u.hasOwnProperty(e))throw new Error("Unknown config key: "+e);u[e]=t},t.all=function(){return s.copyObject(u)},a.implement(t,c),t.moduleUrl=function(e,t){if(u.$moduleUrls[e])return u.$moduleUrls[e];var i=e.split("/");t=t||i[i.length-2]||"";var n="snippets"==t?"/":"-",o=i[i.length-1];if("worker"==t&&"-"==n){var r=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g");o=o.replace(r,"")}(!o||o==t)&&i.length>1&&(o=i[i.length-2]);var s=u[t+"Path"];return null==s?s=u.basePath:"/"==n&&(t=n=""),s&&"/"!=s.slice(-1)&&(s+="/"),s+t+n+o+this.get("suffix")},t.setModuleUrl=function(e,t){return u.$moduleUrls[e]=t},t.$loading={},t.loadModule=function(i,n){var o,r;Array.isArray(i)&&(r=i[0],i=i[1]);try{o=e(i)}catch(s){}if(o&&!t.$loading[i])return n&&n(o);if(t.$loading[i]||(t.$loading[i]=[]),t.$loading[i].push(n),!(t.$loading[i].length>1)){var a=function(){e([i],function(e){t._emit("load.module",{name:i,module:e});var n=t.$loading[i];t.$loading[i]=null,n.forEach(function(t){t&&t(e)})})};return t.get("packaged")?void l.loadScript(t.moduleUrl(i,r),a):a()}},o(!0),t.init=o;var d={setOptions:function(e){Object.keys(e).forEach(function(t){this.setOption(t,e[t])},this)},getOptions:function(e){var t={};return e?Array.isArray(e)||(t=e,e=Object.keys(t)):e=Object.keys(this.$options),e.forEach(function(e){t[e]=this.getOption(e)},this),t},setOption:function(e,t){if(this["$"+e]!==t){var i=this.$options[e];if(!i)return void("undefined"!=typeof console&&console.warn&&console.warn('misspelled option "'+e+'"'));if(i.forwardTo)return this[i.forwardTo]&&this[i.forwardTo].setOption(e,t);i.handlesSet||(this["$"+e]=t),i&&i.set&&i.set.call(this,t)}},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:void("undefined"!=typeof console&&console.warn&&console.warn('misspelled option "'+e+'"'))}},g={};t.defineOptions=function(e,t,i){return e.$options||(g[t]=e.$options={}),Object.keys(i).forEach(function(t){var n=i[t];"string"==typeof n&&(n={forwardTo:n}),n.name||(n.name=t),e.$options[n.name]=n,"initialValue"in n&&(e["$"+n.name]=n.initialValue)}),a.implement(e,d),this},t.resetOptions=function(e){Object.keys(e.$options).forEach(function(t){var i=e.$options[t];"value"in i&&e.setOption(t,i.value)})},t.setDefaultValue=function(e,i,n){var o=g[e]||(g[e]={});o[i]&&(o.forwardTo?t.setDefaultValue(o.forwardTo,i,n):o[i].value=n)},t.setDefaultValues=function(e,i){
Object.keys(i).forEach(function(n){t.setDefaultValue(e,n,i[n])})}}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/config"],function(e,t){"use strict";var i=e("../lib/event"),n=e("../lib/useragent"),o=e("./default_handlers").DefaultHandlers,r=e("./default_gutter_handler").GutterHandler,s=e("./mouse_event").MouseEvent,a=e("./dragdrop_handler").DragdropHandler,l=e("../config"),c=function(e){var t=this;this.editor=e,new o(this),new r(this),new a(this);var s=function(t){!e.isFocused()&&e.textInput&&e.textInput.moveToMouse(t),e.focus()},l=e.renderer.getMouseEventTarget();i.addListener(l,"click",this.onMouseEvent.bind(this,"click")),i.addListener(l,"mousemove",this.onMouseMove.bind(this,"mousemove")),i.addMultiMouseDownListener(l,[400,300,250],this,"onMouseEvent"),e.renderer.scrollBarV&&(i.addMultiMouseDownListener(e.renderer.scrollBarV.inner,[400,300,250],this,"onMouseEvent"),i.addMultiMouseDownListener(e.renderer.scrollBarH.inner,[400,300,250],this,"onMouseEvent"),n.isIE&&(i.addListener(e.renderer.scrollBarV.element,"mousedown",s),i.addListener(e.renderer.scrollBarH.element,"mousemove",s))),i.addMouseWheelListener(e.container,this.onMouseWheel.bind(this,"mousewheel"));var c=e.renderer.$gutter;i.addListener(c,"mousedown",this.onMouseEvent.bind(this,"guttermousedown")),i.addListener(c,"click",this.onMouseEvent.bind(this,"gutterclick")),i.addListener(c,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick")),i.addListener(c,"mousemove",this.onMouseEvent.bind(this,"guttermousemove")),i.addListener(l,"mousedown",s),i.addListener(c,"mousedown",function(t){return e.focus(),i.preventDefault(t)}),e.on("mousemove",function(i){if(!t.state&&!t.$dragDelay&&t.$dragEnabled){var n=e.renderer.screenToTextCoordinates(i.x,i.y),o=e.session.selection.getRange(),r=e.renderer;r.setCursorStyle(!o.isEmpty()&&o.insideStart(n.row,n.column)?"default":"")}})};(function(){this.onMouseEvent=function(e,t){this.editor._emit(e,new s(t,this.editor))},this.onMouseMove=function(e,t){var i=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;i&&i.length&&this.editor._emit(e,new s(t,this.editor))},this.onMouseWheel=function(e,t){var i=new s(t,this.editor);i.speed=2*this.$scrollSpeed,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;var o=this.editor.renderer;o.$keepTextAreaAtCursor&&(o.$keepTextAreaAtCursor=null);var r=this,a=function(e){if(e){if(n.isWebKit&&!e.which&&r.releaseMouse)return r.releaseMouse();r.x=e.clientX,r.y=e.clientY,t&&t(e),r.mouseEvent=new s(e,r.editor),r.$mouseMoved=!0}},l=function(e){clearInterval(h),c(),r[r.state+"End"]&&r[r.state+"End"](e),r.state="",null==o.$keepTextAreaAtCursor&&(o.$keepTextAreaAtCursor=!0,o.$moveTextAreaToCursor()),r.isMousePressed=!1,r.$onCaptureMouseMove=r.releaseMouse=null,e&&r.onMouseEvent("mouseup",e)},c=function(){r[r.state]&&r[r.state](),r.$mouseMoved=!1};if(n.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout(function(){l(e)});r.$onCaptureMouseMove=a,r.releaseMouse=i.capture(this.editor.container,a,l);var h=setInterval(c,20)},this.releaseMouse=null,this.cancelContextMenu=function(){var e=function(t){t&&t.domEvent&&"contextmenu"!=t.domEvent.type||(this.editor.off("nativecontextmenu",e),t&&t.domEvent&&i.stopEvent(t.domEvent))}.bind(this);setTimeout(e,10),this.editor.on("nativecontextmenu",e)}}).call(c.prototype),l.defineOptions(c.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:n.isMac?150:0},dragEnabled:{initialValue:!0},focusTimout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=c}),ace.define("ace/mouse/fold_handler",["require","exports","module"],function(e,t){"use strict";function i(e){e.on("click",function(t){var i=t.getDocumentPosition(),n=e.session,o=n.getFoldAt(i.row,i.column,1);o&&(t.getAccelKey()?n.removeFold(o):n.expandFold(o),t.stop())}),e.on("gutterclick",function(t){var i=e.renderer.$gutterLayer.getRegion(t);if("foldWidgets"==i){var n=t.getDocumentPosition().row,o=e.session;o.foldWidgets&&o.foldWidgets[n]&&e.session.onFoldWidgetClick(n,t),e.isFocused()||e.focus(),t.stop()}}),e.on("gutterdblclick",function(t){var i=e.renderer.$gutterLayer.getRegion(t);if("foldWidgets"==i){var n=t.getDocumentPosition().row,o=e.session,r=o.getParentFoldRangeData(n,!0),s=r.range||r.firstRange;if(s){n=s.start.row;var a=o.getFoldAt(n,o.getLine(n).length,1);a?o.removeFold(a):(o.addFold("...",s),e.renderer.scrollCursorIntoView({row:s.start.row,column:0}))}t.stop()}})}t.FoldHandler=i}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(e,t){"use strict";var i=e("../lib/keys"),n=e("../lib/event"),o=function(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)};(function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){if(e){"function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e);var i=this.$handlers.indexOf(e);-1!=i&&this.$handlers.splice(i,1),void 0==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==i&&e.attach&&e.attach(this.$editor)}},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1==t?!1:(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var e=this.$data,t=e.editor;return this.$handlers.map(function(i){return i.getStatusText&&i.getStatusText(t,e)||""}).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,i,o){for(var r,s=!1,a=this.$editor.commands,l=this.$handlers.length;l--&&(r=this.$handlers[l].handleKeyboard(this.$data,e,t,i,o),!(r&&r.command&&(s="null"==r.command?!0:a.exec(r.command,this.$editor,r.args,o),s&&o&&-1!=e&&1!=r.passEvent&&1!=r.command.passEvent&&n.stopEvent(o),s))););return s},this.onCommandKey=function(e,t,n){var o=i.keyCodeToString(n);this.$callKeyboardHandlers(t,o,n,e)},this.onTextInput=function(e){var t=this.$callKeyboardHandlers(-1,e);t||this.$editor.commands.exec("insertstring",this.$editor,e)}}).call(o.prototype),t.KeyBinding=o}),ace.define("ace/range",["require","exports","module"],function(e,t){"use strict";var i=function(e,t){return e.row-t.row||e.column-t.column},n=function(e,t,i,n){this.start={row:e,column:t},this.end={row:i,column:n}};(function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t,i=e.end,n=e.start;return t=this.compare(i.row,i.column),1==t?(t=this.compare(n.row,n.column),1==t?2:0==t?1:0):-1==t?-2:(t=this.compare(n.row,n.column),-1==t?-1:1==t?42:0)},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){var t=this.compareRange(e);return-1==t||0==t||1==t},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)?this.isEnd(e,t)||this.isStart(e,t)?!1:!0:!1},this.insideStart=function(e,t){return 0==this.compare(e,t)?this.isEnd(e,t)?!1:!0:!1},this.insideEnd=function(e,t){return 0==this.compare(e,t)?this.isStart(e,t)?!1:!0:!1},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row===e?t<=this.end.column?0:1:0:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){if(this.end.row>t)var i={row:t+1,column:0};else if(this.end.row<e)var i={row:e,column:0};if(this.start.row>t)var o={row:t+1,column:0};else if(this.start.row<e)var o={row:e,column:0};return n.fromPoints(o||this.start,i||this.end)},this.extend=function(e,t){var i=this.compare(e,t);if(0==i)return this;if(-1==i)var o={row:e,column:t};else var r={row:e,column:t};return n.fromPoints(o||this.start,r||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return n.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new n(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new n(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),i=e.documentToScreenPosition(this.end);return new n(t.row,t.column,i.row,i.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}).call(n.prototype),n.fromPoints=function(e,t){return new n(e.row,e.column,t.row,t.column)},n.comparePoints=i,n.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=n}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(e,t){"use strict";var i=e("./lib/oop"),n=e("./lib/lang"),o=e("./lib/event_emitter").EventEmitter,r=e("./range").Range,s=function(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.lead=this.selectionLead=this.doc.createAnchor(0,0),this.anchor=this.selectionAnchor=this.doc.createAnchor(0,0);var t=this;this.lead.on("change",function(e){t._emit("changeCursor"),t.$isEmpty||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.selectionAnchor.on("change",function(){t.$isEmpty||t._emit("changeSelection")})};(function(){i.implement(this,o),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return this.isEmpty()?!1:this.getRange().isMultiLine()},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.anchor.setPosition(e,t),this.$isEmpty&&(this.$isEmpty=!1,this._emit("changeSelection"))},this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.shiftSelection=function(e){if(this.$isEmpty)return void this.moveCursorTo(this.lead.row,this.lead.column+e);var t=this.getSelectionAnchor(),i=this.getSelectionLead(),n=this.isBackwards();n&&0===t.column||this.setSelectionAnchor(t.row,t.column+e),(n||0!==i.column)&&this.$moveSelection(function(){this.moveCursorTo(i.row,i.column+e)})},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.isEmpty()?r.fromPoints(t,t):this.isBackwards()?r.fromPoints(t,e):r.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){var e=this.doc.getLength()-1;this.setSelectionAnchor(0,0),this.moveCursorTo(e,this.doc.getLine(e).length)},this.setRange=this.setSelectionRange=function(e,t){t?(this.setSelectionAnchor(e.end.row,e.end.column),this.selectTo(e.start.row,e.start.column)):(this.setSelectionAnchor(e.start.row,e.start.column),this.selectTo(e.end.row,e.end.column)),this.getRange().isEmpty()&&(this.$isEmpty=!0),this.$desiredColumn=null},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection(function(){this.moveCursorTo(e,t)})},this.selectToPosition=function(e){this.$moveSelection(function(){this.moveCursorToPosition(e)})},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){if("undefined"==typeof t){var i=e||this.lead;e=i.row,t=i.column}return this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),t=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(t)},this.getLineRange=function(e,t){var i,n="number"==typeof e?e:this.lead.row,o=this.session.getFoldLine(n);return o?(n=o.start.row,i=o.end.row):i=n,t===!0?new r(n,0,i,this.session.getLine(i).length):new r(n,0,i+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.moveCursorLeft=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,-1))this.moveCursorTo(e.start.row,e.start.column);else if(0===t.column)t.row>0&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length);else{var i=this.session.getTabSize();this.session.isTabStop(t)&&this.doc.getLine(t.row).slice(t.column-i,t.column).split(" ").length-1==i?this.moveCursorBy(0,-i):this.moveCursorBy(0,-1)}},this.moveCursorRight=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,1))this.moveCursorTo(e.end.row,e.end.column);else if(this.lead.column==this.doc.getLine(this.lead.row).length)this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0);else{var i=this.session.getTabSize(),t=this.lead;this.session.isTabStop(t)&&this.doc.getLine(t.row).slice(t.column,t.column+i).split(" ").length-1==i?this.moveCursorBy(0,i):this.moveCursorBy(0,1)}},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,i=this.session.documentToScreenRow(e,t),n=this.session.screenToDocumentPosition(i,0),o=this.session.getDisplayLine(e,null,n.row,n.column),r=o.match(/^\s*/);r[0].length==t||this.session.$useEmacsStyleLineStart||(n.column+=r[0].length),this.moveCursorToPosition(n)},this.moveCursorLineEnd=function(){var e=this.lead,t=this.session.getDocumentLastRowColumnPosition(e.row,e.column);if(this.lead.column==t.column){var i=this.session.getLine(t.row);if(t.column==i.length){var n=i.search(/\s+$/);n>0&&(t.column=n)}}this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e,t=this.lead.row,i=this.lead.column,n=this.doc.getLine(t),o=n.substring(i);this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0;var r=this.session.getFoldAt(t,i,1);return r?void this.moveCursorTo(r.end.row,r.end.column):((e=this.session.nonTokenRe.exec(o))&&(i+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,o=n.substring(i)),i>=n.length?(this.moveCursorTo(t,n.length),this.moveCursorRight(),void(t<this.doc.getLength()-1&&this.moveCursorWordRight())):((e=this.session.tokenRe.exec(o))&&(i+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),void this.moveCursorTo(t,i)))},this.moveCursorLongWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))return void this.moveCursorTo(e.start.row,e.start.column);var o=this.session.getFoldStringAt(t,i,-1);null==o&&(o=this.doc.getLine(t).substring(0,i));var r,s=n.stringReverse(o);return this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,(r=this.session.nonTokenRe.exec(s))&&(i-=this.session.nonTokenRe.lastIndex,s=s.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),0>=i?(this.moveCursorTo(t,0),this.moveCursorLeft(),void(t>0&&this.moveCursorWordLeft())):((r=this.session.tokenRe.exec(s))&&(i-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),void this.moveCursorTo(t,i))},this.$shortWordEndIndex=function(e){var t,i,n=0,o=/\s/,r=this.session.tokenRe;if(r.lastIndex=0,t=this.session.tokenRe.exec(e))n=this.session.tokenRe.lastIndex;else{for(;(i=e[n])&&o.test(i);)n++;if(1>n)for(r.lastIndex=0;(i=e[n])&&!r.test(i);)if(r.lastIndex=0,n++,o.test(i)){if(n>2){n--;break}for(;(i=e[n])&&o.test(i);)n++;if(n>2)break}}return r.lastIndex=0,n},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t),o=this.session.getFoldAt(e,t,1);if(o)return this.moveCursorTo(o.end.row,o.end.column);if(t==i.length){var r=this.doc.getLength();do e++,n=this.doc.getLine(e);while(r>e&&/^\s*$/.test(n));/^\s+/.test(n)||(n=""),t=0}var s=this.$shortWordEndIndex(n);this.moveCursorTo(e,t+s)},this.moveCursorShortWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))return this.moveCursorTo(e.start.row,e.start.column);var o=this.session.getLine(t).substring(0,i);if(0===i){do t--,o=this.doc.getLine(t);while(t>0&&/^\s*$/.test(o));i=o.length,/\s+$/.test(o)||(o="")}var r=n.stringReverse(o),s=this.$shortWordEndIndex(r);return this.moveCursorTo(t,i-s)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var i=this.session.documentToScreenPosition(this.lead.row,this.lead.column);0===t&&(this.$desiredColumn?i.column=this.$desiredColumn:this.$desiredColumn=i.column);var n=this.session.screenToDocumentPosition(i.row+e,i.column);0!==e&&0===t&&n.row===this.lead.row&&n.column===this.lead.column&&this.session.lineWidgets&&this.session.lineWidgets[n.row]&&n.row++,this.moveCursorTo(n.row,n.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,i){var n=this.session.getFoldAt(e,t,1);n&&(e=n.start.row,t=n.start.column),this.$keepDesiredColumnOnChange=!0,this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,i||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,i){var n=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(n.row,n.column,i)},this.detach=function(){this.lead.detach(),this.anchor.detach(),this.session=this.doc=null},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e.call(null,this);var i=this.getCursor();return r.fromPoints(t,i)}catch(n){return r.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){if(this.rangeCount)var e=this.ranges.map(function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t});else{var e=this.getRange();e.isBackwards=this.isBackwards()}return e},this.fromJSON=function(e){if(void 0==e.start){if(this.rangeList){this.toSingleRange(e[0]);for(var t=e.length;t--;){var i=r.fromPoints(e[t].start,e[t].end);e.isBackwards&&(i.cursor=i.start),this.addRange(i,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}).call(s.prototype),t.Selection=s}),ace.define("ace/tokenizer",["require","exports","module"],function(e,t){"use strict";var i=2e3,n=function(e){this.states=e,this.regExps={},this.matchMappings={};for(var t in this.states){for(var i=this.states[t],n=[],o=0,r=this.matchMappings[t]={defaultToken:"text"},s="g",a=[],l=0;l<i.length;l++){var c=i[l];if(c.defaultToken&&(r.defaultToken=c.defaultToken),c.caseInsensitive&&(s="gi"),null!=c.regex){c.regex instanceof RegExp&&(c.regex=c.regex.toString().slice(1,-1));var h=c.regex,u=new RegExp("(?:("+h+")|(.))").exec("a").length-2;Array.isArray(c.token)?1==c.token.length||1==u?c.token=c.token[0]:u-1!=c.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:c,groupCount:u-1}),c.token=c.token[0]):(c.tokenArray=c.token,c.token=null,c.onMatch=this.$arrayTokens):"function"!=typeof c.token||c.onMatch||(c.onMatch=u>1?this.$applyToken:c.token),u>1&&(/\\\d/.test(c.regex)?h=c.regex.replace(/\\([0-9]+)/g,function(e,t){return"\\"+(parseInt(t,10)+o+1)}):(u=1,h=this.removeCapturingGroups(c.regex)),c.splitRegex||"string"==typeof c.token||a.push(c)),r[o]=l,o+=u,n.push(h),c.onMatch||(c.onMatch=null)}}n.length||(r[0]=0,n.push("$")),a.forEach(function(e){e.splitRegex=this.createSplitterRegexp(e.regex,s)},this),this.regExps[t]=new RegExp("("+n.join(")|(")+")|($)",s)}};(function(){this.$setMaxTokenCount=function(e){i=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),i=this.token.apply(this,t);if("string"==typeof i)return[{type:i,value:e}];for(var n=[],o=0,r=i.length;r>o;o++)t[o]&&(n[n.length]={type:i[o],value:t[o]});return n},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var i=[],n=this.tokenArray,o=0,r=n.length;r>o;o++)t[o+1]&&(i[i.length]={type:n[o],value:t[o+1]});return i},this.removeCapturingGroups=function(e){var t=e.replace(/\[(?:\\.|[^\]])*?\]|\\.|\(\?[:=!]|(\()/g,function(e,t){return t?"(?:":e});return t},this.createSplitterRegexp=function(e,t){if(-1!=e.indexOf("(?=")){var i=0,n=!1,o={};e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(e,t,r,s,a,l){return n?n="]"!=a:a?n=!0:s?(i==o.stack&&(o.end=l+1,o.stack=-1),i--):r&&(i++,1!=r.length&&(o.stack=i,o.start=l)),e}),null!=o.end&&/^\)*$/.test(e.substr(o.end))&&(e=e.substring(0,o.start)+e.substr(o.end))}return new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){if(t&&"string"!=typeof t){var n=t.slice(0);t=n[0],"#tmp"===t&&(n.shift(),t=n.shift())}else var n=[];var o=t||"start",r=this.states[o];r||(o="start",r=this.states[o]);var s=this.matchMappings[o],a=this.regExps[o];a.lastIndex=0;for(var l,c=[],h=0,u=0,d={type:null,value:""};l=a.exec(e);){var g=s.defaultToken,f=null,p=l[0],m=a.lastIndex;if(m-p.length>h){var v=e.substring(h,m-p.length);d.type==g?d.value+=v:(d.type&&c.push(d),d={type:g,value:v})}for(var A=0;A<l.length-2;A++)if(void 0!==l[A+1]){f=r[s[A]],g=f.onMatch?f.onMatch(p,o,n):f.token,f.next&&(o="string"==typeof f.next?f.next:f.next(o,n),r=this.states[o],r||(this.reportError("state doesn't exist",o),o="start",r=this.states[o]),s=this.matchMappings[o],h=m,a=this.regExps[o],a.lastIndex=m);break}if(p)if("string"==typeof g)f&&f.merge===!1||d.type!==g?(d.type&&c.push(d),d={type:g,value:p}):d.value+=p;else if(g){d.type&&c.push(d),d={type:null,value:""};for(var A=0;A<g.length;A++)c.push(g[A])}if(h==e.length)break;if(h=m,u++>i){for(u>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});h<e.length;)d.type&&c.push(d),d={value:e.substring(h,h+=2e3),type:"overflow"};o="start",n=[];break}}return d.type&&c.push(d),n.length>1&&n[0]!==o&&n.unshift("#tmp",o),{tokens:c,state:n.length?n:o}},this.reportError=function(e,t){var i=new Error(e);i.data=t,"object"==typeof console&&console.error&&console.error(i),setTimeout(function(){throw i})}}).call(n.prototype),t.Tokenizer=n}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(e,t){"use strict";var i=e("../lib/lang"),n=function(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}};(function(){this.addRules=function(e,t){if(t)for(var i in e){for(var n=e[i],o=0;o<n.length;o++){var r=n[o];(r.next||r.onMatch)&&("string"!=typeof r.next?r.nextState&&0!==r.nextState.indexOf(t)&&(r.nextState=t+r.nextState):0!==r.next.indexOf(t)&&(r.next=t+r.next))}this.$rules[t+i]=n}else for(var i in e)this.$rules[i]=e[i]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,n,o,r){var s="function"==typeof e?(new e).getRules():e;if(o)for(var a=0;a<o.length;a++)o[a]=t+o[a];else{o=[];for(var l in s)o.push(t+l)}if(this.addRules(s,t),n)for(var c=Array.prototype[r?"push":"unshift"],a=0;a<o.length;a++)c.apply(this.$rules[o[a]],i.deepCopy(n));this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};var e=function(e,t){return("start"!=e||t.length)&&t.unshift(this.nextState,e),this.nextState},t=function(e,t){return t.shift(),t.shift()||"start"};this.normalizeRules=function(){function i(r){var s=o[r];s.processed=!0;for(var a=0;a<s.length;a++){var l=s[a];!l.regex&&l.start&&(l.regex=l.start,l.next||(l.next=[]),l.next.push({defaultToken:l.token},{token:l.token+".end",regex:l.end||l.start,next:"pop"}),l.token=l.token+".start",l.push=!0);var c=l.next||l.push;if(c&&Array.isArray(c)){var h=l.stateName;h||(h=l.token,"string"!=typeof h&&(h=h[0]||""),o[h]&&(h+=n++)),o[h]=c,l.next=h,i(h)}else"pop"==c&&(l.next=t);if(l.push&&(l.nextState=l.next||l.push,l.next=e,delete l.push),l.rules)for(var u in l.rules)o[u]?o[u].push&&o[u].push.apply(o[u],l.rules[u]):o[u]=l.rules[u];if(l.include||"string"==typeof l)var d=l.include||l,g=o[d];else Array.isArray(l)&&(g=l);if(g){var f=[a,1].concat(g);l.noEscape&&(f=f.filter(function(e){return!e.next})),s.splice.apply(s,f),a--,g=null}l.keywordMap&&(l.token=this.createKeywordMapper(l.keywordMap,l.defaultToken||"text",l.caseInsensitive),delete l.defaultToken)}}var n=0,o=this.$rules;Object.keys(o).forEach(i,this)},this.createKeywordMapper=function(e,t,i,n){var o=Object.create(null);return Object.keys(e).forEach(function(t){var r=e[t];i&&(r=r.toLowerCase());for(var s=r.split(n||"|"),a=s.length;a--;)o[s[a]]=t}),Object.getPrototypeOf(o)&&(o.__proto__=null),this.$keywordList=Object.keys(o),e=null,i?function(e){return o[e.toLowerCase()]||t}:function(e){return o[e]||t}},this.getKeywords=function(){return this.$keywords}}).call(n.prototype),t.TextHighlightRules=n}),ace.define("ace/mode/behaviour",["require","exports","module"],function(e,t){"use strict";var i=function(){this.$behaviours={}};(function(){this.add=function(e,t,i){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=i},this.addBehaviours=function(e){for(var t in e)for(var i in e[t])this.add(t,i,e[t][i])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){if("function"==typeof e)var i=(new e).getBehaviours(t);else var i=e.getBehaviours(t);this.addBehaviours(i)},this.getBehaviours=function(e){if(e){for(var t={},i=0;i<e.length;i++)this.$behaviours[e[i]]&&(t[e[i]]=this.$behaviours[e[i]]);return t}return this.$behaviours}}).call(i.prototype),t.Behaviour=i}),ace.define("ace/unicode",["require","exports","module"],function(e,t){"use strict";function i(e){var i=/\w{4}/g;for(var n in e)t.packages[n]=e[n].replace(i,"\\u$&")}t.packages={},i({L:"0041-005A0061-007A00AA00B500BA00C0-00D600D8-00F600F8-02C102C6-02D102E0-02E402EC02EE0370-037403760377037A-037D03860388-038A038C038E-03A103A3-03F503F7-0481048A-05250531-055605590561-058705D0-05EA05F0-05F20621-064A066E066F0671-06D306D506E506E606EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA07F407F507FA0800-0815081A082408280904-0939093D09500958-0961097109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E460E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EC60EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10A0-10C510D0-10FA10FC1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317D717DC1820-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541AA71B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C7D1CE9-1CEC1CEE-1CF11D00-1DBF1E00-1F151F18-1F1D1F20-1F451F48-1F4D1F50-1F571F591F5B1F5D1F5F-1F7D1F80-1FB41FB6-1FBC1FBE1FC2-1FC41FC6-1FCC1FD0-1FD31FD6-1FDB1FE0-1FEC1FF2-1FF41FF6-1FFC2071207F2090-209421022107210A-211321152119-211D212421262128212A-212D212F-2139213C-213F2145-2149214E218321842C00-2C2E2C30-2C5E2C60-2CE42CEB-2CEE2D00-2D252D30-2D652D6F2D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE2E2F300530063031-3035303B303C3041-3096309D-309F30A1-30FA30FC-30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A48CA4D0-A4FDA500-A60CA610-A61FA62AA62BA640-A65FA662-A66EA67F-A697A6A0-A6E5A717-A71FA722-A788A78BA78CA7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2A9CFAA00-AA28AA40-AA42AA44-AA4BAA60-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADB-AADDABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB00-FB06FB13-FB17FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF21-FF3AFF41-FF5AFF66-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",Ll:"0061-007A00AA00B500BA00DF-00F600F8-00FF01010103010501070109010B010D010F01110113011501170119011B011D011F01210123012501270129012B012D012F01310133013501370138013A013C013E014001420144014601480149014B014D014F01510153015501570159015B015D015F01610163016501670169016B016D016F0171017301750177017A017C017E-0180018301850188018C018D019201950199-019B019E01A101A301A501A801AA01AB01AD01B001B401B601B901BA01BD-01BF01C601C901CC01CE01D001D201D401D601D801DA01DC01DD01DF01E101E301E501E701E901EB01ED01EF01F001F301F501F901FB01FD01FF02010203020502070209020B020D020F02110213021502170219021B021D021F02210223022502270229022B022D022F02310233-0239023C023F0240024202470249024B024D024F-02930295-02AF037103730377037B-037D039003AC-03CE03D003D103D5-03D703D903DB03DD03DF03E103E303E503E703E903EB03ED03EF-03F303F503F803FB03FC0430-045F04610463046504670469046B046D046F04710473047504770479047B047D047F0481048B048D048F04910493049504970499049B049D049F04A104A304A504A704A904AB04AD04AF04B104B304B504B704B904BB04BD04BF04C204C404C604C804CA04CC04CE04CF04D104D304D504D704D904DB04DD04DF04E104E304E504E704E904EB04ED04EF04F104F304F504F704F904FB04FD04FF05010503050505070509050B050D050F05110513051505170519051B051D051F0521052305250561-05871D00-1D2B1D62-1D771D79-1D9A1E011E031E051E071E091E0B1E0D1E0F1E111E131E151E171E191E1B1E1D1E1F1E211E231E251E271E291E2B1E2D1E2F1E311E331E351E371E391E3B1E3D1E3F1E411E431E451E471E491E4B1E4D1E4F1E511E531E551E571E591E5B1E5D1E5F1E611E631E651E671E691E6B1E6D1E6F1E711E731E751E771E791E7B1E7D1E7F1E811E831E851E871E891E8B1E8D1E8F1E911E931E95-1E9D1E9F1EA11EA31EA51EA71EA91EAB1EAD1EAF1EB11EB31EB51EB71EB91EBB1EBD1EBF1EC11EC31EC51EC71EC91ECB1ECD1ECF1ED11ED31ED51ED71ED91EDB1EDD1EDF1EE11EE31EE51EE71EE91EEB1EED1EEF1EF11EF31EF51EF71EF91EFB1EFD1EFF-1F071F10-1F151F20-1F271F30-1F371F40-1F451F50-1F571F60-1F671F70-1F7D1F80-1F871F90-1F971FA0-1FA71FB0-1FB41FB61FB71FBE1FC2-1FC41FC61FC71FD0-1FD31FD61FD71FE0-1FE71FF2-1FF41FF61FF7210A210E210F2113212F21342139213C213D2146-2149214E21842C30-2C5E2C612C652C662C682C6A2C6C2C712C732C742C76-2C7C2C812C832C852C872C892C8B2C8D2C8F2C912C932C952C972C992C9B2C9D2C9F2CA12CA32CA52CA72CA92CAB2CAD2CAF2CB12CB32CB52CB72CB92CBB2CBD2CBF2CC12CC32CC52CC72CC92CCB2CCD2CCF2CD12CD32CD52CD72CD92CDB2CDD2CDF2CE12CE32CE42CEC2CEE2D00-2D25A641A643A645A647A649A64BA64DA64FA651A653A655A657A659A65BA65DA65FA663A665A667A669A66BA66DA681A683A685A687A689A68BA68DA68FA691A693A695A697A723A725A727A729A72BA72DA72F-A731A733A735A737A739A73BA73DA73FA741A743A745A747A749A74BA74DA74FA751A753A755A757A759A75BA75DA75FA761A763A765A767A769A76BA76DA76FA771-A778A77AA77CA77FA781A783A785A787A78CFB00-FB06FB13-FB17FF41-FF5A",
Lu:"0041-005A00C0-00D600D8-00DE01000102010401060108010A010C010E01100112011401160118011A011C011E01200122012401260128012A012C012E01300132013401360139013B013D013F0141014301450147014A014C014E01500152015401560158015A015C015E01600162016401660168016A016C016E017001720174017601780179017B017D018101820184018601870189-018B018E-0191019301940196-0198019C019D019F01A001A201A401A601A701A901AC01AE01AF01B1-01B301B501B701B801BC01C401C701CA01CD01CF01D101D301D501D701D901DB01DE01E001E201E401E601E801EA01EC01EE01F101F401F6-01F801FA01FC01FE02000202020402060208020A020C020E02100212021402160218021A021C021E02200222022402260228022A022C022E02300232023A023B023D023E02410243-02460248024A024C024E03700372037603860388-038A038C038E038F0391-03A103A3-03AB03CF03D2-03D403D803DA03DC03DE03E003E203E403E603E803EA03EC03EE03F403F703F903FA03FD-042F04600462046404660468046A046C046E04700472047404760478047A047C047E0480048A048C048E04900492049404960498049A049C049E04A004A204A404A604A804AA04AC04AE04B004B204B404B604B804BA04BC04BE04C004C104C304C504C704C904CB04CD04D004D204D404D604D804DA04DC04DE04E004E204E404E604E804EA04EC04EE04F004F204F404F604F804FA04FC04FE05000502050405060508050A050C050E05100512051405160518051A051C051E0520052205240531-055610A0-10C51E001E021E041E061E081E0A1E0C1E0E1E101E121E141E161E181E1A1E1C1E1E1E201E221E241E261E281E2A1E2C1E2E1E301E321E341E361E381E3A1E3C1E3E1E401E421E441E461E481E4A1E4C1E4E1E501E521E541E561E581E5A1E5C1E5E1E601E621E641E661E681E6A1E6C1E6E1E701E721E741E761E781E7A1E7C1E7E1E801E821E841E861E881E8A1E8C1E8E1E901E921E941E9E1EA01EA21EA41EA61EA81EAA1EAC1EAE1EB01EB21EB41EB61EB81EBA1EBC1EBE1EC01EC21EC41EC61EC81ECA1ECC1ECE1ED01ED21ED41ED61ED81EDA1EDC1EDE1EE01EE21EE41EE61EE81EEA1EEC1EEE1EF01EF21EF41EF61EF81EFA1EFC1EFE1F08-1F0F1F18-1F1D1F28-1F2F1F38-1F3F1F48-1F4D1F591F5B1F5D1F5F1F68-1F6F1FB8-1FBB1FC8-1FCB1FD8-1FDB1FE8-1FEC1FF8-1FFB21022107210B-210D2110-211221152119-211D212421262128212A-212D2130-2133213E213F214521832C00-2C2E2C602C62-2C642C672C692C6B2C6D-2C702C722C752C7E-2C802C822C842C862C882C8A2C8C2C8E2C902C922C942C962C982C9A2C9C2C9E2CA02CA22CA42CA62CA82CAA2CAC2CAE2CB02CB22CB42CB62CB82CBA2CBC2CBE2CC02CC22CC42CC62CC82CCA2CCC2CCE2CD02CD22CD42CD62CD82CDA2CDC2CDE2CE02CE22CEB2CEDA640A642A644A646A648A64AA64CA64EA650A652A654A656A658A65AA65CA65EA662A664A666A668A66AA66CA680A682A684A686A688A68AA68CA68EA690A692A694A696A722A724A726A728A72AA72CA72EA732A734A736A738A73AA73CA73EA740A742A744A746A748A74AA74CA74EA750A752A754A756A758A75AA75CA75EA760A762A764A766A768A76AA76CA76EA779A77BA77DA77EA780A782A784A786A78BFF21-FF3A",Lt:"01C501C801CB01F21F88-1F8F1F98-1F9F1FA8-1FAF1FBC1FCC1FFC",Lm:"02B0-02C102C6-02D102E0-02E402EC02EE0374037A0559064006E506E607F407F507FA081A0824082809710E460EC610FC17D718431AA71C78-1C7D1D2C-1D611D781D9B-1DBF2071207F2090-20942C7D2D6F2E2F30053031-3035303B309D309E30FC-30FEA015A4F8-A4FDA60CA67FA717-A71FA770A788A9CFAA70AADDFF70FF9EFF9F",Lo:"01BB01C0-01C3029405D0-05EA05F0-05F20621-063F0641-064A066E066F0671-06D306D506EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA0800-08150904-0939093D09500958-096109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E450E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10D0-10FA1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317DC1820-18421844-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C771CE9-1CEC1CEE-1CF12135-21382D30-2D652D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE3006303C3041-3096309F30A1-30FA30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A014A016-A48CA4D0-A4F7A500-A60BA610-A61FA62AA62BA66EA6A0-A6E5A7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2AA00-AA28AA40-AA42AA44-AA4BAA60-AA6FAA71-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADBAADCABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF66-FF6FFF71-FF9DFFA0-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",M:"0300-036F0483-04890591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DE-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0903093C093E-094E0951-0955096209630981-098309BC09BE-09C409C709C809CB-09CD09D709E209E30A01-0A030A3C0A3E-0A420A470A480A4B-0A4D0A510A700A710A750A81-0A830ABC0ABE-0AC50AC7-0AC90ACB-0ACD0AE20AE30B01-0B030B3C0B3E-0B440B470B480B4B-0B4D0B560B570B620B630B820BBE-0BC20BC6-0BC80BCA-0BCD0BD70C01-0C030C3E-0C440C46-0C480C4A-0C4D0C550C560C620C630C820C830CBC0CBE-0CC40CC6-0CC80CCA-0CCD0CD50CD60CE20CE30D020D030D3E-0D440D46-0D480D4A-0D4D0D570D620D630D820D830DCA0DCF-0DD40DD60DD8-0DDF0DF20DF30E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F3E0F3F0F71-0F840F860F870F90-0F970F99-0FBC0FC6102B-103E1056-1059105E-10601062-10641067-106D1071-10741082-108D108F109A-109D135F1712-17141732-1734175217531772177317B6-17D317DD180B-180D18A91920-192B1930-193B19B0-19C019C819C91A17-1A1B1A55-1A5E1A60-1A7C1A7F1B00-1B041B34-1B441B6B-1B731B80-1B821BA1-1BAA1C24-1C371CD0-1CD21CD4-1CE81CED1CF21DC0-1DE61DFD-1DFF20D0-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66F-A672A67CA67DA6F0A6F1A802A806A80BA823-A827A880A881A8B4-A8C4A8E0-A8F1A926-A92DA947-A953A980-A983A9B3-A9C0AA29-AA36AA43AA4CAA4DAA7BAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE3-ABEAABECABEDFB1EFE00-FE0FFE20-FE26",Mn:"0300-036F0483-04870591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DF-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0902093C0941-0948094D0951-095509620963098109BC09C1-09C409CD09E209E30A010A020A3C0A410A420A470A480A4B-0A4D0A510A700A710A750A810A820ABC0AC1-0AC50AC70AC80ACD0AE20AE30B010B3C0B3F0B41-0B440B4D0B560B620B630B820BC00BCD0C3E-0C400C46-0C480C4A-0C4D0C550C560C620C630CBC0CBF0CC60CCC0CCD0CE20CE30D41-0D440D4D0D620D630DCA0DD2-0DD40DD60E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F71-0F7E0F80-0F840F860F870F90-0F970F99-0FBC0FC6102D-10301032-10371039103A103D103E10581059105E-10601071-1074108210851086108D109D135F1712-17141732-1734175217531772177317B7-17BD17C617C9-17D317DD180B-180D18A91920-19221927192819321939-193B1A171A181A561A58-1A5E1A601A621A65-1A6C1A73-1A7C1A7F1B00-1B031B341B36-1B3A1B3C1B421B6B-1B731B801B811BA2-1BA51BA81BA91C2C-1C331C361C371CD0-1CD21CD4-1CE01CE2-1CE81CED1DC0-1DE61DFD-1DFF20D0-20DC20E120E5-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66FA67CA67DA6F0A6F1A802A806A80BA825A826A8C4A8E0-A8F1A926-A92DA947-A951A980-A982A9B3A9B6-A9B9A9BCAA29-AA2EAA31AA32AA35AA36AA43AA4CAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE5ABE8ABEDFB1EFE00-FE0FFE20-FE26",Mc:"0903093E-09400949-094C094E0982098309BE-09C009C709C809CB09CC09D70A030A3E-0A400A830ABE-0AC00AC90ACB0ACC0B020B030B3E0B400B470B480B4B0B4C0B570BBE0BBF0BC10BC20BC6-0BC80BCA-0BCC0BD70C01-0C030C41-0C440C820C830CBE0CC0-0CC40CC70CC80CCA0CCB0CD50CD60D020D030D3E-0D400D46-0D480D4A-0D4C0D570D820D830DCF-0DD10DD8-0DDF0DF20DF30F3E0F3F0F7F102B102C10311038103B103C105610571062-10641067-106D108310841087-108C108F109A-109C17B617BE-17C517C717C81923-19261929-192B193019311933-193819B0-19C019C819C91A19-1A1B1A551A571A611A631A641A6D-1A721B041B351B3B1B3D-1B411B431B441B821BA11BA61BA71BAA1C24-1C2B1C341C351CE11CF2A823A824A827A880A881A8B4-A8C3A952A953A983A9B4A9B5A9BAA9BBA9BD-A9C0AA2FAA30AA33AA34AA4DAA7BABE3ABE4ABE6ABE7ABE9ABEAABEC",Me:"0488048906DE20DD-20E020E2-20E4A670-A672",N:"0030-003900B200B300B900BC-00BE0660-066906F0-06F907C0-07C90966-096F09E6-09EF09F4-09F90A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BF20C66-0C6F0C78-0C7E0CE6-0CEF0D66-0D750E50-0E590ED0-0ED90F20-0F331040-10491090-10991369-137C16EE-16F017E0-17E917F0-17F91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C5920702074-20792080-20892150-21822185-21892460-249B24EA-24FF2776-27932CFD30073021-30293038-303A3192-31953220-32293251-325F3280-328932B1-32BFA620-A629A6E6-A6EFA830-A835A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nd:"0030-00390660-066906F0-06F907C0-07C90966-096F09E6-09EF0A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BEF0C66-0C6F0CE6-0CEF0D66-0D6F0E50-0E590ED0-0ED90F20-0F291040-10491090-109917E0-17E91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C59A620-A629A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nl:"16EE-16F02160-21822185-218830073021-30293038-303AA6E6-A6EF",No:"00B200B300B900BC-00BE09F4-09F90BF0-0BF20C78-0C7E0D70-0D750F2A-0F331369-137C17F0-17F920702074-20792080-20892150-215F21892460-249B24EA-24FF2776-27932CFD3192-31953220-32293251-325F3280-328932B1-32BFA830-A835",P:"0021-00230025-002A002C-002F003A003B003F0040005B-005D005F007B007D00A100AB00B700BB00BF037E0387055A-055F0589058A05BE05C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F3A-0F3D0F850FD0-0FD4104A-104F10FB1361-13681400166D166E169B169C16EB-16ED1735173617D4-17D617D8-17DA1800-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD32010-20272030-20432045-20512053-205E207D207E208D208E2329232A2768-277527C527C627E6-27EF2983-299829D8-29DB29FC29FD2CF9-2CFC2CFE2CFF2E00-2E2E2E302E313001-30033008-30113014-301F3030303D30A030FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFD3EFD3FFE10-FE19FE30-FE52FE54-FE61FE63FE68FE6AFE6BFF01-FF03FF05-FF0AFF0C-FF0FFF1AFF1BFF1FFF20FF3B-FF3DFF3FFF5BFF5DFF5F-FF65",Pd:"002D058A05BE140018062010-20152E172E1A301C303030A0FE31FE32FE58FE63FF0D",Ps:"0028005B007B0F3A0F3C169B201A201E2045207D208D23292768276A276C276E27702772277427C527E627E827EA27EC27EE2983298529872989298B298D298F299129932995299729D829DA29FC2E222E242E262E283008300A300C300E3010301430163018301A301DFD3EFE17FE35FE37FE39FE3BFE3DFE3FFE41FE43FE47FE59FE5BFE5DFF08FF3BFF5BFF5FFF62",Pe:"0029005D007D0F3B0F3D169C2046207E208E232A2769276B276D276F27712773277527C627E727E927EB27ED27EF298429862988298A298C298E2990299229942996299829D929DB29FD2E232E252E272E293009300B300D300F3011301530173019301B301E301FFD3FFE18FE36FE38FE3AFE3CFE3EFE40FE42FE44FE48FE5AFE5CFE5EFF09FF3DFF5DFF60FF63",Pi:"00AB2018201B201C201F20392E022E042E092E0C2E1C2E20",Pf:"00BB2019201D203A2E032E052E0A2E0D2E1D2E21",Pc:"005F203F20402054FE33FE34FE4D-FE4FFF3F",Po:"0021-00230025-0027002A002C002E002F003A003B003F0040005C00A100B700BF037E0387055A-055F058905C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F850FD0-0FD4104A-104F10FB1361-1368166D166E16EB-16ED1735173617D4-17D617D8-17DA1800-18051807-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD3201620172020-20272030-2038203B-203E2041-20432047-205120532055-205E2CF9-2CFC2CFE2CFF2E002E012E06-2E082E0B2E0E-2E162E182E192E1B2E1E2E1F2E2A-2E2E2E302E313001-3003303D30FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFE10-FE16FE19FE30FE45FE46FE49-FE4CFE50-FE52FE54-FE57FE5F-FE61FE68FE6AFE6BFF01-FF03FF05-FF07FF0AFF0CFF0EFF0FFF1AFF1BFF1FFF20FF3CFF61FF64FF65",S:"0024002B003C-003E005E0060007C007E00A2-00A900AC00AE-00B100B400B600B800D700F702C2-02C502D2-02DF02E5-02EB02ED02EF-02FF03750384038503F604820606-0608060B060E060F06E906FD06FE07F609F209F309FA09FB0AF10B700BF3-0BFA0C7F0CF10CF20D790E3F0F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-139917DB194019E0-19FF1B61-1B6A1B74-1B7C1FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE20442052207A-207C208A-208C20A0-20B8210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B2140-2144214A-214D214F2190-2328232B-23E82400-24262440-244A249C-24E92500-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE27C0-27C427C7-27CA27CC27D0-27E527F0-29822999-29D729DC-29FB29FE-2B4C2B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F309B309C319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A700-A716A720A721A789A78AA828-A82BA836-A839AA77-AA79FB29FDFCFDFDFE62FE64-FE66FE69FF04FF0BFF1C-FF1EFF3EFF40FF5CFF5EFFE0-FFE6FFE8-FFEEFFFCFFFD",Sm:"002B003C-003E007C007E00AC00B100D700F703F60606-060820442052207A-207C208A-208C2140-2144214B2190-2194219A219B21A021A321A621AE21CE21CF21D221D421F4-22FF2308-230B23202321237C239B-23B323DC-23E125B725C125F8-25FF266F27C0-27C427C7-27CA27CC27D0-27E527F0-27FF2900-29822999-29D729DC-29FB29FE-2AFF2B30-2B442B47-2B4CFB29FE62FE64-FE66FF0BFF1C-FF1EFF5CFF5EFFE2FFE9-FFEC",Sc:"002400A2-00A5060B09F209F309FB0AF10BF90E3F17DB20A0-20B8A838FDFCFE69FF04FFE0FFE1FFE5FFE6",Sk:"005E006000A800AF00B400B802C2-02C502D2-02DF02E5-02EB02ED02EF-02FF0375038403851FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE309B309CA700-A716A720A721A789A78AFF3EFF40FFE3",So:"00A600A700A900AE00B000B60482060E060F06E906FD06FE07F609FA0B700BF3-0BF80BFA0C7F0CF10CF20D790F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-1399194019E0-19FF1B61-1B6A1B74-1B7C210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B214A214C214D214F2195-2199219C-219F21A121A221A421A521A7-21AD21AF-21CD21D021D121D321D5-21F32300-2307230C-231F2322-2328232B-237B237D-239A23B4-23DB23E2-23E82400-24262440-244A249C-24E92500-25B625B8-25C025C2-25F72600-266E2670-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE2800-28FF2B00-2B2F2B452B462B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A828-A82BA836A837A839AA77-AA79FDFDFFE4FFE8FFEDFFEEFFFCFFFD",Z:"002000A01680180E2000-200A20282029202F205F3000",Zs:"002000A01680180E2000-200A202F205F3000",Zl:"2028",Zp:"2029",C:"0000-001F007F-009F00AD03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-0605061C061D0620065F06DD070E070F074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17B417B517DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF200B-200F202A-202E2060-206F20722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-F8FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFD-FF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFFBFFFEFFFF",Cc:"0000-001F007F-009F",Cf:"00AD0600-060306DD070F17B417B5200B-200F202A-202E2060-2064206A-206FFEFFFFF9-FFFB",Co:"E000-F8FF",Cs:"D800-DFFF",Cn:"03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-05FF06040605061C061D0620065F070E074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF2065-206920722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-D7FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFDFEFEFF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFF8FFFEFFFF"})}),ace.define("ace/token_iterator",["require","exports","module"],function(e,t){"use strict";var i=function(e,t,i){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);var n=e.getTokenAt(t,i);this.$tokenIndex=n?n.index:-1};(function(){this.stepBackward=function(){for(this.$tokenIndex-=1;this.$tokenIndex<0;){if(this.$row-=1,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){this.$tokenIndex+=1;for(var e;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e||(e=this.$session.getLength()),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,i=e[t].start;if(void 0!==i)return i;for(i=0;t>0;)t-=1,i+=e[t].value.length;return i}}).call(i.prototype),t.TokenIterator=i}),ace.define("ace/mode/text",["require","exports","module","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(e,t){"use strict";var i=e("../tokenizer").Tokenizer,n=e("./text_highlight_rules").TextHighlightRules,o=e("./behaviour").Behaviour,r=e("../unicode"),s=e("../lib/lang"),a=e("../token_iterator").TokenIterator,l=e("../range").Range,c=function(){this.HighlightRules=n,this.$behaviour=new o};(function(){this.tokenRe=new RegExp("^["+r.packages.L+r.packages.Mn+r.packages.Mc+r.packages.Nd+r.packages.Pc+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+r.packages.L+r.packages.Mn+r.packages.Mc+r.packages.Nd+r.packages.Pc+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules,this.$tokenizer=new i(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,t,i,n){function o(e){for(var t=i;n>=t;t++)e(r.getLine(t),t)}var r=t.doc,a=!0,l=!0,c=1/0,h=t.getTabSize(),u=!1;if(this.lineCommentStart){if(Array.isArray(this.lineCommentStart))var d=this.lineCommentStart.map(s.escapeRegExp).join("|"),g=this.lineCommentStart[0];else var d=s.escapeRegExp(this.lineCommentStart),g=this.lineCommentStart;d=new RegExp("^(\\s*)(?:"+d+") ?"),u=t.getUseSoftTabs();var f=function(e,t){var i=e.match(d);if(i){var n=i[1].length,o=i[0].length;A(e,n,o)||" "!=i[0][o-1]||o--,r.removeInLine(t,n,o)}},p=g+" ",m=function(e,t){(!a||/\S/.test(e))&&(A(e,c,c)?r.insertInLine({row:t,column:c},p):r.insertInLine({row:t,column:c},g))},v=function(e){return d.test(e)},A=function(e,t,i){for(var n=0;t--&&" "==e.charAt(t);)n++;if(n%h!=0)return!1;for(var n=0;" "==e.charAt(i++);)n++;return h>2?n%h!=h-1:n%h==0}}else{if(!this.blockComment)return!1;var g=this.blockComment.start,w=this.blockComment.end,d=new RegExp("^(\\s*)(?:"+s.escapeRegExp(g)+")"),C=new RegExp("(?:"+s.escapeRegExp(w)+")\\s*$"),m=function(e,t){v(e,t)||(!a||/\S/.test(e))&&(r.insertInLine({row:t,column:e.length},w),r.insertInLine({row:t,column:c},g))},f=function(e,t){var i;(i=e.match(C))&&r.removeInLine(t,e.length-i[0].length,e.length),(i=e.match(d))&&r.removeInLine(t,i[1].length,i[0].length)},v=function(e,i){if(d.test(e))return!0;for(var n=t.getTokens(i),o=0;o<n.length;o++)if("comment"===n[o].type)return!0}}var E=1/0;o(function(e,t){var i=e.search(/\S/);-1!==i?(c>i&&(c=i),l&&!v(e,t)&&(l=!1)):E>e.length&&(E=e.length)}),c==1/0&&(c=E,a=!1,l=!1),u&&c%h!=0&&(c=Math.floor(c/h)*h),o(l?f:m)},this.toggleBlockComment=function(e,t,i,n){var o=this.blockComment;if(o){!o.start&&o[0]&&(o=o[0]);var r,s,c=new a(t,n.row,n.column),h=c.getCurrentToken(),u=(t.selection,t.selection.toOrientedRange());if(h&&/comment/.test(h.type)){for(var d,g;h&&/comment/.test(h.type);){var f=h.value.indexOf(o.start);if(-1!=f){var p=c.getCurrentTokenRow(),m=c.getCurrentTokenColumn()+f;d=new l(p,m,p,m+o.start.length);break}h=c.stepBackward()}for(var c=new a(t,n.row,n.column),h=c.getCurrentToken();h&&/comment/.test(h.type);){var f=h.value.indexOf(o.end);if(-1!=f){var p=c.getCurrentTokenRow(),m=c.getCurrentTokenColumn()+f;g=new l(p,m,p,m+o.end.length);break}h=c.stepForward()}g&&t.remove(g),d&&(t.remove(d),r=d.start.row,s=-o.start.length)}else s=o.start.length,r=i.start.row,t.insert(i.end,o.end),t.insert(i.start,o.start);u.start.row==r&&(u.start.column+=s),u.end.row==r&&(u.end.column+=s),t.selection.fromOrientedRange(u)}},this.getNextLineIndent=function(e,t){return this.$getIndent(t)},this.checkOutdent=function(){return!1},this.autoOutdent=function(){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(){return null},this.createModeDelegates=function(e){this.$embeds=[],this.$modes={};for(var t in e)e[t]&&(this.$embeds.push(t),this.$modes[t]=new e[t]);for(var i=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],t=0;t<i.length;t++)!function(e){var n=i[t],o=e[n];e[i[t]]=function(){return this.$delegator(n,arguments,o)}}(this)},this.$delegator=function(e,t,i){var n=t[0];"string"!=typeof n&&(n=n[0]);for(var o=0;o<this.$embeds.length;o++)if(this.$modes[this.$embeds[o]]){var r=n.split(this.$embeds[o]);if(!r[0]&&r[1]){t[0]=r[1];var s=this.$modes[this.$embeds[o]];return s[e].apply(s,t)}}var a=i.apply(this,t);return i?a:void 0},this.transformAction=function(e,t){if(this.$behaviour){var i=this.$behaviour.getBehaviours();for(var n in i)if(i[n][t]){var o=i[n][t].apply(this,arguments);if(o)return o}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,i=[];for(var n in t)for(var o=t[n],r=0,s=o.length;s>r;r++)if("string"==typeof o[r].token)/keyword|support|storage/.test(o[r].token)&&i.push(o[r].regex);else if("object"==typeof o[r].token)for(var a=0,l=o[r].token.length;l>a;a++)if(/keyword|support|storage/.test(o[r].token[a])){var n=o[r].regex.match(/\(.+?\)/g)[a];i.push(n.substr(1,n.length-2))}this.completionKeywords=i}return e?i.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(){var e=this.$keywordList||this.$createKeywordList();return e.map(function(e){return{name:e,value:e,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(c.prototype),t.Mode=c}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t){"use strict";var i=e("./lib/oop"),n=e("./lib/event_emitter").EventEmitter,o=t.Anchor=function(e,t,i){this.$onChange=this.onChange.bind(this),this.attach(e),"undefined"==typeof i?this.setPosition(t.row,t.column):this.setPosition(t,i)};(function(){i.implement(this,n),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(e){var t=e.data,i=t.range;if((i.start.row!=i.end.row||i.start.row==this.row)&&!(i.start.row>this.row||i.start.row==this.row&&i.start.column>this.column)){var n=this.row,o=this.column,r=i.start,s=i.end;"insertText"===t.action?r.row===n&&r.column<=o?r.column===o&&this.$insertRight||(r.row===s.row?o+=s.column-r.column:(o-=r.column,n+=s.row-r.row)):r.row!==s.row&&r.row<n&&(n+=s.row-r.row):"insertLines"===t.action?r.row===n&&0===o&&this.$insertRight||r.row<=n&&(n+=s.row-r.row):"removeText"===t.action?r.row===n&&r.column<o?o=s.column>=o?r.column:Math.max(0,o-(s.column-r.column)):r.row!==s.row&&r.row<n?(s.row===n&&(o=Math.max(0,o-s.column)+r.column),n-=s.row-r.row):s.row===n&&(n-=s.row-r.row,o=Math.max(0,o-s.column)+r.column):"removeLines"==t.action&&r.row<=n&&(s.row<=n?n-=s.row-r.row:(n=r.row,o=0)),this.setPosition(n,o,!0)}},this.setPosition=function(e,t,i){var n;if(n=i?{row:e,column:t}:this.$clipPositionToDocument(e,t),this.row!=n.row||this.column!=n.column){var o={row:this.row,column:this.column};this.row=n.row,this.column=n.column,this._signal("change",{old:o,value:n})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var i={};return e>=this.document.getLength()?(i.row=Math.max(0,this.document.getLength()-1),i.column=this.document.getLine(i.row).length):0>e?(i.row=0,i.column=0):(i.row=e,i.column=Math.min(this.document.getLine(i.row).length,Math.max(0,t))),0>t&&(i.column=0),i}}).call(o.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/lib/event_emitter","ace/range","ace/anchor"],function(e,t){"use strict";var i=e("./lib/oop"),n=e("./lib/event_emitter").EventEmitter,o=e("./range").Range,r=e("./anchor").Anchor,s=function(e){this.$lines=[],0===e.length?this.$lines=[""]:Array.isArray(e)?this._insertLines(0,e):this.insert({row:0,column:0},e)};(function(){i.implement(this,n),this.setValue=function(e){var t=this.getLength();this.remove(new o(0,0,t,this.getLine(t-1).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new r(this,e,t)},this.$split=0==="aaa".split(/a/).length?function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=t?t[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){if(e.start.row==e.end.row)return this.getLine(e.start.row).substring(e.start.column,e.end.column);var t=this.getLines(e.start.row,e.end.row);t[0]=(t[0]||"").substring(e.start.column);var i=t.length-1;return e.end.row-e.start.row==i&&(t[i]=t[i].substring(0,e.end.column)),t.join(this.getNewLineCharacter())},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):e.row<0&&(e.row=0),e},this.insert=function(e,t){if(!t||0===t.length)return e;e=this.$clipPosition(e),this.getLength()<=1&&this.$detectNewLine(t);var i=this.$split(t),n=i.splice(0,1)[0],o=0==i.length?null:i.splice(i.length-1,1)[0];return e=this.insertInLine(e,n),null!==o&&(e=this.insertNewLine(e),e=this._insertLines(e.row,i),e=this.insertInLine(e,o||"")),e},this.insertLines=function(e,t){return e>=this.getLength()?this.insert({row:e,column:0},"\n"+t.join("\n")):this._insertLines(Math.max(e,0),t)},this._insertLines=function(e,t){if(0==t.length)return{row:e,column:0};for(;t.length>61440;){var i=this._insertLines(e,t.slice(0,61440));t=t.slice(61440),e=i.row}var n=[e,0];n.push.apply(n,t),this.$lines.splice.apply(this.$lines,n);var r=new o(e,0,e+t.length,0),s={action:"insertLines",range:r,lines:t};return this._signal("change",{data:s}),r.end},this.insertNewLine=function(e){e=this.$clipPosition(e);var t=this.$lines[e.row]||"";this.$lines[e.row]=t.substring(0,e.column),this.$lines.splice(e.row+1,0,t.substring(e.column,t.length));var i={row:e.row+1,column:0},n={action:"insertText",
range:o.fromPoints(e,i),text:this.getNewLineCharacter()};return this._signal("change",{data:n}),i},this.insertInLine=function(e,t){if(0==t.length)return e;var i=this.$lines[e.row]||"";this.$lines[e.row]=i.substring(0,e.column)+t+i.substring(e.column);var n={row:e.row,column:e.column+t.length},r={action:"insertText",range:o.fromPoints(e,n),text:t};return this._signal("change",{data:r}),n},this.remove=function(e){if(e instanceof o||(e=o.fromPoints(e.start,e.end)),e.start=this.$clipPosition(e.start),e.end=this.$clipPosition(e.end),e.isEmpty())return e.start;var t=e.start.row,i=e.end.row;if(e.isMultiLine()){var n=0==e.start.column?t:t+1,r=i-1;e.end.column>0&&this.removeInLine(i,0,e.end.column),r>=n&&this._removeLines(n,r),n!=t&&(this.removeInLine(t,e.start.column,this.getLine(t).length),this.removeNewLine(e.start.row))}else this.removeInLine(t,e.start.column,e.end.column);return e.start},this.removeInLine=function(e,t,i){if(t!=i){var n=new o(e,t,e,i),r=this.getLine(e),s=r.substring(t,i),a=r.substring(0,t)+r.substring(i,r.length);this.$lines.splice(e,1,a);var l={action:"removeText",range:n,text:s};return this._signal("change",{data:l}),n.start}},this.removeLines=function(e,t){return 0>e||t>=this.getLength()?this.remove(new o(e,0,t+1,0)):this._removeLines(e,t)},this._removeLines=function(e,t){var i=new o(e,0,t+1,0),n=this.$lines.splice(e,t-e+1),r={action:"removeLines",range:i,nl:this.getNewLineCharacter(),lines:n};return this._signal("change",{data:r}),n},this.removeNewLine=function(e){var t=this.getLine(e),i=this.getLine(e+1),n=new o(e,t.length,e+1,0),r=t+i;this.$lines.splice(e,2,r);var s={action:"removeText",range:n,text:this.getNewLineCharacter()};this._signal("change",{data:s})},this.replace=function(e,t){if(e instanceof o||(e=o.fromPoints(e.start,e.end)),0==t.length&&e.isEmpty())return e.start;if(t==this.getTextRange(e))return e.end;if(this.remove(e),t)var i=this.insert(e.start,t);else i=e.start;return i},this.applyDeltas=function(e){for(var t=0;t<e.length;t++){var i=e[t],n=o.fromPoints(i.range.start,i.range.end);"insertLines"==i.action?this.insertLines(n.start.row,i.lines):"insertText"==i.action?this.insert(n.start,i.text):"removeLines"==i.action?this._removeLines(n.start.row,n.end.row-1):"removeText"==i.action&&this.remove(n)}},this.revertDeltas=function(e){for(var t=e.length-1;t>=0;t--){var i=e[t],n=o.fromPoints(i.range.start,i.range.end);"insertLines"==i.action?this._removeLines(n.start.row,n.end.row-1):"insertText"==i.action?this.remove(n):"removeLines"==i.action?this._insertLines(n.start.row,i.lines):"removeText"==i.action&&this.insert(n.start,i.text)}},this.indexToPosition=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,o=t||0,r=i.length;r>o;o++)if(e-=i[o].length+n,0>e)return{row:o,column:e+i[o].length+n};return{row:r-1,column:i[r-1].length}},this.positionToIndex=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,o=0,r=Math.min(e.row,i.length),s=t||0;r>s;++s)o+=i[s].length+n;return o+e.column}}).call(s.prototype),t.Document=s}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t){"use strict";var i=e("./lib/oop"),n=e("./lib/event_emitter").EventEmitter,o=function(e){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var t=this;this.$worker=function(){if(t.running){for(var e=new Date,i=t.currentLine,n=-1,o=t.doc;t.lines[i];)i++;var r=i,s=o.getLength(),a=0;for(t.running=!1;s>i;){t.$tokenizeRow(i),n=i;do i++;while(t.lines[i]);if(a++,a%5===0&&new Date-e>20){t.running=setTimeout(t.$worker,20);break}}t.currentLine=i,n>=r&&t.fireUpdateEvent(r,n)}}};(function(){i.implement(this,n),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){var i={first:e,last:t};this._signal("update",{data:i})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t=e.range,i=t.start.row,n=t.end.row-i;if(0===n)this.lines[i]=null;else if("removeText"==e.action||"removeLines"==e.action)this.lines.splice(i,n+1,null),this.states.splice(i,n+1,null);else{var o=Array(n+1);o.unshift(i,1),this.lines.splice.apply(this.lines,o),this.states.splice.apply(this.states,o)}this.currentLine=Math.min(i,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),i=this.states[e-1],n=this.tokenizer.getLineTokens(t,i,e);return this.states[e]+""!=n.state+""?(this.states[e]=n.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=n.tokens}}).call(o.prototype),t.BackgroundTokenizer=o}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t){"use strict";var i=e("./lib/lang"),n=(e("./lib/oop"),e("./range").Range),o=function(e,t,i){this.setRegexp(e),this.clazz=t,this.type=i||"text"};(function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,o,r){if(this.regExp)for(var s=r.firstRow,a=r.lastRow,l=s;a>=l;l++){var c=this.cache[l];null==c&&(c=i.getMatchOffsets(o.getLine(l),this.regExp),c.length>this.MAX_RANGES&&(c=c.slice(0,this.MAX_RANGES)),c=c.map(function(e){return new n(l,e.offset,l,e.offset+e.length)}),this.cache[l]=c.length?c:"");for(var h=c.length;h--;)t.drawSingleLineMarker(e,c[h].toScreenRange(o),this.clazz,r)}}}).call(o.prototype),t.SearchHighlight=o}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(e,t){"use strict";function i(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];var i=t[t.length-1];this.range=new n(t[0].start.row,t[0].start.column,i.end.row,i.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(e){e.setFoldLine(this)},this)}var n=e("../range").Range;(function(){this.shiftRow=function(e){this.start.row+=e,this.end.row+=e,this.folds.forEach(function(t){t.start.row+=e,t.end.row+=e})},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort(function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)}),this.range.compareEnd(e.start.row,e.start.column)>0?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,i){var n,o,r,s=0,a=this.folds,l=!0;null==t&&(t=this.end.row,i=this.end.column);for(var c=0;c<a.length;c++){if(n=a[c],o=n.range.compareStart(t,i),-1==o)return void e(null,t,i,s,l);if(r=e(null,n.start.row,n.start.column,s,l),r=!r&&e(n.placeholder,n.start.row,n.start.column,s),r||0===o)return;l=!n.sameRow,s=n.end.column}e(null,t,i,s,l)},this.getNextFoldTo=function(e,t){for(var i,n,o=0;o<this.folds.length;o++){if(i=this.folds[o],n=i.range.compareEnd(e,t),-1==n)return{fold:i,kind:"after"};if(0===n)return{fold:i,kind:"inside"}}return null},this.addRemoveChars=function(e,t,i){var n,o,r=this.getNextFoldTo(e,t);if(r)if(n=r.fold,"inside"==r.kind&&n.start.column!=t&&n.start.row!=e)window.console&&window.console.log(e,t,n);else if(n.start.row==e){o=this.folds;var s=o.indexOf(n);for(0===s&&(this.start.column+=i),s;s<o.length;s++){if(n=o[s],n.start.column+=i,!n.sameRow)return;n.end.column+=i}this.end.column+=i}},this.split=function(e,t){var n=this.getNextFoldTo(e,t);if(!n||"inside"==n.kind)return null;var o=n.fold,r=this.folds,s=this.foldData,a=r.indexOf(o),l=r[a-1];this.end.row=l.end.row,this.end.column=l.end.column,r=r.splice(a,r.length-a);var c=new i(s,r);return s.splice(s.indexOf(this)+1,0,c),c},this.merge=function(e){for(var t=e.folds,i=0;i<t.length;i++)this.addFold(t[i]);var n=this.foldData;n.splice(n.indexOf(e),1)},this.toString=function(){var e=[this.range.toString()+": ["];return this.folds.forEach(function(t){e.push("  "+t.toString())}),e.push("]"),e.join("\n")},this.idxToPosition=function(e){for(var t=0,i=0;i<this.folds.length;i++){var n=this.folds[i];if(e-=n.start.column-t,0>e)return{row:n.start.row,column:n.start.column+e};if(e-=n.placeholder.length,0>e)return n.start;t=n.end.column}return{row:this.end.row,column:this.end.column+e}}}).call(i.prototype),t.FoldLine=i}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(e,t){"use strict";var i=e("./range").Range,n=i.comparePoints,o=function(){this.ranges=[]};(function(){this.comparePoints=n,this.pointIndex=function(e,t,i){for(var o=this.ranges,r=i||0;r<o.length;r++){var s=o[r],a=n(e,s.end);if(!(a>0)){var l=n(e,s.start);return 0===a?t&&0!==l?-r-2:r:l>0||0===l&&!t?r:-r-1}}return-r-1},this.add=function(e){var t=!e.isEmpty(),i=this.pointIndex(e.start,t);0>i&&(i=-i-1);var n=this.pointIndex(e.end,t,i);return 0>n?n=-n-1:n++,this.ranges.splice(i,n-i,e)},this.addList=function(e){for(var t=[],i=e.length;i--;)t.push.call(t,this.add(e[i]));return t},this.substractPoint=function(e){var t=this.pointIndex(e);return t>=0?this.ranges.splice(t,1):void 0},this.merge=function(){var e=[],t=this.ranges;t=t.sort(function(e,t){return n(e.start,t.start)});for(var i,o=t[0],r=1;r<t.length;r++){i=o,o=t[r];var s=n(i.end,o.start);0>s||(0!=s||i.isEmpty()||o.isEmpty())&&(n(i.end,o.end)<0&&(i.end.row=o.end.row,i.end.column=o.end.column),t.splice(r,1),e.push(o),o=i,r--)}return this.ranges=t,e},this.contains=function(e,t){return this.pointIndex({row:e,column:t})>=0},this.containsPoint=function(e){return this.pointIndex(e)>=0},this.rangeAtPoint=function(e){var t=this.pointIndex(e);return t>=0?this.ranges[t]:void 0},this.clipRows=function(e,t){var i=this.ranges;if(i[0].start.row>t||i[i.length-1].start.row<e)return[];var n=this.pointIndex({row:e,column:0});0>n&&(n=-n-1);var o=this.pointIndex({row:t,column:0},n);0>o&&(o=-o-1);for(var r=[],s=n;o>s;s++)r.push(i[s]);return r},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(e){var t=e.data.range;if("i"==e.data.action[0])var i=t.start,n=t.end;else var n=t.start,i=t.end;for(var o=i.row,r=n.row,s=r-o,a=-i.column+n.column,l=this.ranges,c=0,h=l.length;h>c;c++){var u=l[c];if(!(u.end.row<o)){if(u.start.row>o)break;if(u.start.row==o&&u.start.column>=i.column&&(u.start.column==i.column&&this.$insertRight||(u.start.column+=a,u.start.row+=s)),u.end.row==o&&u.end.column>=i.column){if(u.end.column==i.column&&this.$insertRight)continue;u.end.column==i.column&&a>0&&h-1>c&&u.end.column>u.start.column&&u.end.column==l[c+1].start.column&&(u.end.column-=a),u.end.column+=a,u.end.row+=s}}}if(0!=s&&h>c)for(;h>c;c++){var u=l[c];u.start.row+=s,u.end.row+=s}}}).call(o.prototype),t.RangeList=o}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range","ace/range_list","ace/lib/oop"],function(e,t){"use strict";function i(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function n(e,t){i(e.start,t),i(e.end,t)}function o(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}function r(e,t){o(e.start,t),o(e.end,t)}var s=(e("../range").Range,e("../range_list").RangeList),a=e("../lib/oop"),l=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};a.inherits(l,s),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(e){this.foldLine=e,this.subFolds.forEach(function(t){t.setFoldLine(e)})},this.clone=function(){var e=this.range.clone(),t=new l(e,this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){if(!this.range.containsRange(e))throw new Error("A fold can't intersect already existing fold"+e.range+this.range);n(e,this.start);for(var t=e.start.row,i=e.start.column,o=0,r=-1;o<this.subFolds.length&&(r=this.subFolds[o].range.compare(t,i),1==r);o++);var s=this.subFolds[o];if(0==r)return s.addSubFold(e);for(var t=e.range.end.row,i=e.range.end.column,a=o,r=-1;a<this.subFolds.length&&(r=this.subFolds[a].range.compare(t,i),1==r);a++);{this.subFolds[a]}if(0==r)throw new Error("A fold can't intersect already existing fold"+e.range+this.range);{this.subFolds.splice(o,a-o,e)}return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return r(e,this.start)}}.call(l.prototype)}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],function(e,t){"use strict";function i(){this.getFoldAt=function(e,t,i){var n=this.getFoldLine(e);if(!n)return null;for(var o=n.folds,r=0;r<o.length;r++){var s=o[r];if(s.range.contains(e,t)){if(1==i&&s.range.isEnd(e,t))continue;if(-1==i&&s.range.isStart(e,t))continue;return s}}},this.getFoldsInRange=function(e){var t=e.start,i=e.end,n=this.$foldData,o=[];t.column+=1,i.column-=1;for(var r=0;r<n.length;r++){var s=n[r].range.compareRange(e);if(2!=s){if(-2==s)break;for(var a=n[r].folds,l=0;l<a.length;l++){var c=a[l];if(s=c.range.compareRange(e),-2==s)break;if(2!=s){if(42==s)break;o.push(c)}}}}return t.column-=1,i.column+=1,o},this.getFoldsInRangeList=function(e){if(Array.isArray(e)){var t=[];e.forEach(function(e){t=t.concat(this.getFoldsInRange(e))},this)}else var t=this.getFoldsInRange(e);return t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,i=0;i<t.length;i++)for(var n=0;n<t[i].folds.length;n++)e.push(t[i].folds[n]);return e},this.getFoldStringAt=function(e,t,i,n){if(n=n||this.getFoldLine(e),!n)return null;for(var o,r,s={end:{column:0}},a=0;a<n.folds.length;a++){r=n.folds[a];var l=r.range.compareEnd(e,t);if(-1==l){o=this.getLine(r.start.row).substring(s.end.column,r.start.column);break}if(0===l)return null;s=r}return o||(o=this.getLine(r.start.row).substring(s.end.column)),-1==i?o.substring(0,t-s.end.column):1==i?o.substring(t-s.end.column):o},this.getFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0),n;n<i.length;n++){var o=i[n];if(o.start.row<=e&&o.end.row>=e)return o;if(o.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0),n;n<i.length;n++){var o=i[n];if(o.end.row>=e)return o}return null},this.getFoldedRowCount=function(e,t){for(var i=this.$foldData,n=t-e+1,o=0;o<i.length;o++){var r=i[o],s=r.end.row,a=r.start.row;if(s>=t){t>a&&(a>=e?n-=t-a:n=0);break}s>=e&&(n-=a>=e?s-a:s-e+1)}return n},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort(function(e,t){return e.start.row-t.start.row}),e},this.addFold=function(e,t){var i,n=this.$foldData,s=!1;e instanceof r?i=e:(i=new r(t,e),i.collapseChildren=t.collapseChildren),this.$clipRangeToDocument(i.range);var a=i.start.row,l=i.start.column,c=i.end.row,h=i.end.column;if(!(c>a||a==c&&h-2>=l))throw new Error("The range has to be at least 2 characters width");var u=this.getFoldAt(a,l,1),d=this.getFoldAt(c,h,-1);if(u&&d==u)return u.addSubFold(i);u&&!u.range.isStart(a,l)&&this.removeFold(u),d&&!d.range.isEnd(c,h)&&this.removeFold(d);var g=this.getFoldsInRange(i.range);g.length>0&&(this.removeFolds(g),g.forEach(function(e){i.addSubFold(e)}));for(var f=0;f<n.length;f++){var p=n[f];if(c==p.start.row){p.addFold(i),s=!0;break}if(a==p.end.row){if(p.addFold(i),s=!0,!i.sameRow){var m=n[f+1];if(m&&m.start.row==c){p.merge(m);break}}break}if(c<=p.start.row)break}return s||(p=this.$addFoldLine(new o(this.$foldData,i))),this.$useWrapMode?this.$updateWrapData(p.start.row,p.start.row):this.$updateRowLengthCache(p.start.row,p.start.row),this.$modified=!0,this._emit("changeFold",{data:i,action:"add"}),i},this.addFolds=function(e){e.forEach(function(e){this.addFold(e)},this)},this.removeFold=function(e){var t=e.foldLine,i=t.start.row,n=t.end.row,o=this.$foldData,r=t.folds;if(1==r.length)o.splice(o.indexOf(t),1);else if(t.range.isEnd(e.end.row,e.end.column))r.pop(),t.end.row=r[r.length-1].end.row,t.end.column=r[r.length-1].end.column;else if(t.range.isStart(e.start.row,e.start.column))r.shift(),t.start.row=r[0].start.row,t.start.column=r[0].start.column;else if(e.sameRow)r.splice(r.indexOf(e),1);else{var s=t.split(e.start.row,e.start.column);r=s.folds,r.shift(),s.start.row=r[0].start.row,s.start.column=r[0].start.column}this.$updating||(this.$useWrapMode?this.$updateWrapData(i,n):this.$updateRowLengthCache(i,n)),this.$modified=!0,this._emit("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],i=0;i<e.length;i++)t.push(e[i]);t.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(e){this.removeFold(e),e.subFolds.forEach(function(t){e.restoreRange(t),this.addFold(t)},this),e.collapseChildren>0&&this.foldAll(e.start.row+1,e.end.row,e.collapseChildren-1),e.subFolds=[]},this.expandFolds=function(e){e.forEach(function(e){this.expandFold(e)},this)},this.unfold=function(e,t){var i,o;if(null==e?(i=new n(0,0,this.getLength(),0),t=!0):i="number"==typeof e?new n(e,0,e,this.getLine(e).length):"row"in e?n.fromPoints(e,e):e,o=this.getFoldsInRangeList(i),t)this.removeFolds(o);else for(var r=o;r.length;)this.expandFolds(r),r=this.getFoldsInRangeList(i);return o.length?o:void 0},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){var i=this.getFoldLine(e,t);return i?i.end.row:e},this.getRowFoldStart=function(e,t){var i=this.getFoldLine(e,t);return i?i.start.row:e},this.getFoldDisplayLine=function(e,t,i,n,o){null==n&&(n=e.start.row),null==o&&(o=0),null==t&&(t=e.end.row),null==i&&(i=this.getLine(t).length);var r=this.doc,s="";return e.walk(function(e,t,i,a){if(!(n>t)){if(t==n){if(o>i)return;a=Math.max(o,a)}s+=null!=e?e:r.getLine(t).substring(a,i)}},t,i),s},this.getDisplayLine=function(e,t,i,n){var o=this.getFoldLine(e);if(o)return this.getFoldDisplayLine(o,e,t,i,n);var r;return r=this.doc.getLine(e),r.substring(n||0,t||r.length)},this.$cloneFoldData=function(){var e=[];return e=this.$foldData.map(function(t){var i=t.folds.map(function(e){return e.clone()});return new o(e,i)})},this.toggleFold=function(e){var t,i,n=this.selection,o=n.getRange();if(o.isEmpty()){var r=o.start;if(t=this.getFoldAt(r.row,r.column))return void this.expandFold(t);(i=this.findMatchingBracket(r))?1==o.comparePoint(i)?o.end=i:(o.start=i,o.start.column++,o.end.column--):(i=this.findMatchingBracket({row:r.row,column:r.column+1}))?(1==o.comparePoint(i)?o.end=i:o.start=i,o.start.column++):o=this.getCommentFoldRange(r.row,r.column)||o}else{var s=this.getFoldsInRange(o);if(e&&s.length)return void this.expandFolds(s);1==s.length&&(t=s[0])}if(t||(t=this.getFoldAt(o.start.row,o.start.column)),t&&t.range.toString()==o.toString())return void this.expandFold(t);var a="...";if(!o.isMultiLine()){if(a=this.getTextRange(o),a.length<4)return;a=a.trim().substring(0,2)+".."}this.addFold(a,o)},this.getCommentFoldRange=function(e,t,i){var o=new s(this,e,t),r=o.getCurrentToken();if(r&&/^comment|string/.test(r.type)){var a=new n,l=new RegExp(r.type.replace(/\..*/,"\\."));if(1!=i){do r=o.stepBackward();while(r&&l.test(r.type));o.stepForward()}if(a.start.row=o.getCurrentTokenRow(),a.start.column=o.getCurrentTokenColumn()+2,o=new s(this,e,t),-1!=i){do r=o.stepForward();while(r&&l.test(r.type));r=o.stepBackward()}else r=o.getCurrentToken();return a.end.row=o.getCurrentTokenRow(),a.end.column=o.getCurrentTokenColumn()+r.value.length-2,a}},this.foldAll=function(e,t,i){void 0==i&&(i=1e5);var n=this.foldWidgets;if(n){t=t||this.getLength(),e=e||0;for(var o=e;t>o;o++)if(null==n[o]&&(n[o]=this.getFoldWidget(o)),"start"==n[o]){var r=this.getFoldWidgetRange(o);if(r&&r.isMultiLine()&&r.end.row<=t&&r.start.row>=e){o=r.end.row;try{var s=this.addFold("...",r);s&&(s.collapseChildren=i)}catch(a){}}}}},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");if(this.$foldStyle!=e){this.$foldStyle=e,"manual"==e&&this.unfold();var t=this.$foldMode;this.$setFolding(null),this.$setFolding(t)}},this.$setFolding=function(e){if(this.$foldMode!=e){if(this.$foldMode=e,this.removeListener("change",this.$updateFoldWidgets),this._emit("changeAnnotation"),!e||"manual"==this.$foldStyle)return void(this.foldWidgets=null);this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets)}},this.getParentFoldRangeData=function(e,t){var i=this.foldWidgets;if(!i||t&&i[e])return{};for(var n,o=e-1;o>=0;){var r=i[o];if(null==r&&(r=i[o]=this.getFoldWidget(o)),"start"==r){var s=this.getFoldWidgetRange(o);if(n||(n=s),s&&s.end.row>=e)break}o--}return{range:-1!==o&&s,firstRange:n}},this.onFoldWidgetClick=function(e,t){t=t.domEvent;var i={children:t.shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey},n=this.$toggleFoldWidget(e,i);if(!n){var o=t.target||t.srcElement;o&&/ace_fold-widget/.test(o.className)&&(o.className+=" ace_invalid")}},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var i=this.getFoldWidget(e),n=this.getLine(e),o="end"===i?-1:1,r=this.getFoldAt(e,-1===o?0:n.length,o);if(r)return void(t.children||t.all?this.removeFold(r):this.expandFold(r));var s=this.getFoldWidgetRange(e,!0);if(s&&!s.isMultiLine()&&(r=this.getFoldAt(s.start.row,s.start.column,1),r&&s.isEqual(r.range)))return void this.removeFold(r);if(t.siblings){var a=this.getParentFoldRangeData(e);if(a.range)var l=a.range.start.row+1,c=a.range.end.row;this.foldAll(l,c,t.all?1e4:0)}else t.children?(c=s?s.end.row:this.getLength(),this.foldAll(e+1,s.end.row,t.all?1e4:0)):s&&(t.all&&(s.collapseChildren=1e4),this.addFold("...",s));return s}},this.toggleFoldWidget=function(){var e=this.selection.getCursor().row;e=this.getRowFoldStart(e);var t=this.$toggleFoldWidget(e,{});if(!t){var i=this.getParentFoldRangeData(e,!0);if(t=i.range||i.firstRange){e=t.start.row;var n=this.getFoldAt(e,this.getLine(e).length,1);n?this.removeFold(n):this.addFold("...",t)}}},this.updateFoldWidgets=function(e){var t=e.data,i=t.range,n=i.start.row,o=i.end.row-n;if(0===o)this.foldWidgets[n]=null;else if("removeText"==t.action||"removeLines"==t.action)this.foldWidgets.splice(n,o+1,null);else{var r=Array(o+1);r.unshift(n,1),this.foldWidgets.splice.apply(this.foldWidgets,r)}}}var n=e("../range").Range,o=e("./fold_line").FoldLine,r=e("./fold").Fold,s=e("../token_iterator").TokenIterator;t.Folding=i}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(e,t){"use strict";function i(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;var i=t||this.getLine(e.row).charAt(e.column-1);if(""==i)return null;var n=i.match(/([\(\[\{])|([\)\]\}])/);return n?n[1]?this.$findClosingBracket(n[1],e):this.$findOpeningBracket(n[2],e):null},this.getBracketRange=function(e){var t,i=this.getLine(e.row),n=!0,r=i.charAt(e.column-1),s=r&&r.match(/([\(\[\{])|([\)\]\}])/);if(s||(r=i.charAt(e.column),e={row:e.row,column:e.column+1},s=r&&r.match(/([\(\[\{])|([\)\]\}])/),n=!1),!s)return null;if(s[1]){var a=this.$findClosingBracket(s[1],e);if(!a)return null;t=o.fromPoints(e,a),n||(t.end.column++,t.start.column--),t.cursor=t.end}else{var a=this.$findOpeningBracket(s[2],e);if(!a)return null;t=o.fromPoints(a,e),n||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{"},this.$findOpeningBracket=function(e,t,i){var o=this.$brackets[e],r=1,s=new n(this,t.row,t.column),a=s.getCurrentToken();if(a||(a=s.stepForward()),a){i||(i=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end|start|begin)\b/,"")+")+"));for(var l=t.column-s.getCurrentTokenColumn()-2,c=a.value;;){for(;l>=0;){var h=c.charAt(l);if(h==o){if(r-=1,0==r)return{row:s.getCurrentTokenRow(),column:l+s.getCurrentTokenColumn()}}else h==e&&(r+=1);l-=1}do a=s.stepBackward();while(a&&!i.test(a.type));if(null==a)break;c=a.value,l=c.length-1}return null}},this.$findClosingBracket=function(e,t,i){var o=this.$brackets[e],r=1,s=new n(this,t.row,t.column),a=s.getCurrentToken();if(a||(a=s.stepForward()),a){i||(i=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:end|start|begin)\b/,"")+")+"));for(var l=t.column-s.getCurrentTokenColumn();;){for(var c=a.value,h=c.length;h>l;){var u=c.charAt(l);if(u==o){if(r-=1,0==r)return{row:s.getCurrentTokenRow(),column:l+s.getCurrentTokenColumn()}}else u==e&&(r+=1);l+=1}do a=s.stepForward();while(a&&!i.test(a.type));if(null==a)break;l=0}return null}}}var n=e("../token_iterator").TokenIterator,o=e("../range").Range;t.BracketMatch=i}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(e,t){"use strict";var i=e("./lib/oop"),n=e("./lib/lang"),o=e("./config"),r=e("./lib/event_emitter").EventEmitter,s=e("./selection").Selection,a=e("./mode/text").Mode,l=e("./range").Range,c=e("./document").Document,h=e("./background_tokenizer").BackgroundTokenizer,u=e("./search_highlight").SearchHighlight,d=function(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new c(e)),this.setDocument(e),this.selection=new s(this),o.resetOptions(this),this.setMode(t),o._signal("session",this)};(function(){function e(e){return 4352>e?!1:e>=4352&&4447>=e||e>=4515&&4519>=e||e>=4602&&4607>=e||e>=9001&&9002>=e||e>=11904&&11929>=e||e>=11931&&12019>=e||e>=12032&&12245>=e||e>=12272&&12283>=e||e>=12288&&12350>=e||e>=12353&&12438>=e||e>=12441&&12543>=e||e>=12549&&12589>=e||e>=12593&&12686>=e||e>=12688&&12730>=e||e>=12736&&12771>=e||e>=12784&&12830>=e||e>=12832&&12871>=e||e>=12880&&13054>=e||e>=13056&&19903>=e||e>=19968&&42124>=e||e>=42128&&42182>=e||e>=43360&&43388>=e||e>=44032&&55203>=e||e>=55216&&55238>=e||e>=55243&&55291>=e||e>=63744&&64255>=e||e>=65040&&65049>=e||e>=65072&&65106>=e||e>=65108&&65126>=e||e>=65128&&65131>=e||e>=65281&&65376>=e||e>=65504&&65510>=e}i.implement(this,r),this.setDocument=function(e){this.doc&&this.doc.removeListener("change",this.$onChange),this.doc=e,e.on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,i=this.$getRowCacheIndex(this.$docRowCache,e)+1;t>i&&(this.$docRowCache.splice(i,t),this.$screenRowCache.splice(i,t))},this.$getRowCacheIndex=function(e,t){for(var i=0,n=e.length-1;n>=i;){var o=i+n>>1,r=e[o];if(t>r)i=o+1;else{if(!(r>t))return o;n=o-1}}return i-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){var t=e.data;this.$resetRowCache(t.start.row)},this.onChange=function(e){var t=e.data;this.$modified=!0,this.$resetRowCache(t.range.start.row);var i=this.$updateInternalDataOnChange(e);this.$fromUndo||!this.$undoManager||t.ignore||(this.$deltasDoc.push(t),i&&0!=i.length&&this.$deltasFold.push({action:"removeFolds",folds:i}),this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(t),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var i,n=this.bgTokenizer.getTokens(e),o=0;if(null==t)r=n.length-1,o=this.getLine(e).length;else for(var r=0;r<n.length&&(o+=n[r].value.length,!(o>=t));r++);return(i=n[r])?(i.index=r,i.start=o-i.value.length,i):null},this.setUndoManager=function(e){if(this.$undoManager=e,this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.$informUndoManager&&this.$informUndoManager.cancel(),e){var t=this;this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.$deltasFold.length&&(t.$deltas.push({group:"fold",deltas:t.$deltasFold}),t.$deltasFold=[]),t.$deltasDoc.length&&(t.$deltas.push({group:"doc",deltas:t.$deltasDoc}),t.$deltasDoc=[]),t.$deltas.length>0&&e.execute({action:"aceupdate",args:[t.$deltas,t],merge:t.mergeUndoDeltas}),t.mergeUndoDeltas=!1,t.$deltas=[]},this.$informUndoManager=n.delayedCall(this.$syncInformUndoManager)}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},reset:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?n.stringRepeat(" ",this.getTabSize()):"	"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize===0},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";

this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){void 0===t&&(t="ace_breakpoint"),t?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,i,n){var o=this.$markerId++,r={range:e,type:i||"line",renderer:"function"==typeof i?i:null,clazz:t,inFront:!!n,id:o};return n?(this.$frontMarkers[o]=r,this._signal("changeFrontMarker")):(this.$backMarkers[o]=r,this._signal("changeBackMarker")),o},this.addDynamicMarker=function(e,t){if(e.update){var i=this.$markerId++;return e.id=i,e.inFront=!!t,t?(this.$frontMarkers[i]=e,this._signal("changeFrontMarker")):(this.$backMarkers[i]=e,this._signal("changeBackMarker")),e}},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];if(t){var i=t.inFront?this.$frontMarkers:this.$backMarkers;t&&(delete i[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))}},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){if(!this.$searchHighlight){var t=new u(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(t)}this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,i,n){"number"!=typeof t&&(i=t,t=e),i||(i="ace_step");var o=new l(e,0,t,1/0);return o.id=this.addMarker(o,i,"fullLine",n),o},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=t?t[1]:"\n"},this.getWordRange=function(e,t){var i=this.getLine(e),n=!1;if(t>0&&(n=!!i.charAt(t-1).match(this.tokenRe)),n||(n=!!i.charAt(t).match(this.tokenRe)),n)var o=this.tokenRe;else if(/^\s+$/.test(i.slice(t-1,t+1)))var o=/\s/;else var o=this.nonTokenRe;var r=t;if(r>0){do r--;while(r>=0&&i.charAt(r).match(o));r++}for(var s=t;s<i.length&&i.charAt(s).match(o);)s++;return new l(e,r,e,s)},this.getAWordRange=function(e,t){for(var i=this.getWordRange(e,t),n=this.getLine(i.end.row);n.charAt(i.end.column).match(/[ \t]/);)i.end.column+=1;return i},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes={},this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var i=e,n=i.path}else n=e||"ace/mode/text";return this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new a),this.$modes[n]&&!i?(this.$onChangeMode(this.$modes[n]),void(t&&t())):(this.$modeId=n,o.loadModule(["mode",n],function(e){return this.$modeId!==n?t&&t():this.$modes[n]&&!i?this.$onChangeMode(this.$modes[n]):void(e&&e.Mode&&(e=new e.Mode(i),i||(this.$modes[n]=e,e.$id=n),this.$onChangeMode(e),t&&t()))}.bind(this)),void(this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)))},this.$onChangeMode=function(e,t){if(t||(this.$modeId=e.$id),this.$mode!==e){this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker();var i=e.getTokenizer();if(void 0!==i.addEventListener){var n=this.onReloadTokenizer.bind(this);i.addEventListener("update",n)}if(this.bgTokenizer)this.bgTokenizer.setTokenizer(i);else{this.bgTokenizer=new h(i);var o=this;this.bgTokenizer.addEventListener("update",function(e){o._signal("tokenizerUpdate",e)})}this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode"))}},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){"object"==typeof console&&(console.log("Could not load worker"),console.log(e)),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var e=0;return this.lineWidgets.forEach(function(t){t&&t.screenWidth>e&&(e=t.screenWidth)}),this.lineWidgetWidth=e},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),i=this.$rowLengthCache,n=0,o=0,r=this.$foldData[o],s=r?r.start.row:1/0,a=t.length,l=0;a>l;l++){if(l>s){if(l=r.end.row+1,l>=a)break;r=this.$foldData[o++],s=r?r.start.row:1/0}null==i[l]&&(i[l]=this.$getStringScreenWidth(t[l])[0]),i[l]>n&&(n=i[l])}this.screenWidth=n}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=null,n=e.length-1;-1!=n;n--){var o=e[n];"doc"==o.group?(this.doc.revertDeltas(o.deltas),i=this.$getUndoSelection(o.deltas,!0,i)):o.deltas.forEach(function(e){this.addFolds(e.folds)},this)}return this.$fromUndo=!1,i&&this.$undoSelect&&!t&&this.selection.setSelectionRange(i),i}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=null,n=0;n<e.length;n++){var o=e[n];"doc"==o.group&&(this.doc.applyDeltas(o.deltas),i=this.$getUndoSelection(o.deltas,!1,i))}return this.$fromUndo=!1,i&&this.$undoSelect&&!t&&this.selection.setSelectionRange(i),i}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t,i){function n(e){var i="insertText"===e.action||"insertLines"===e.action;return t?!i:i}var o,r,s=e[0],a=!1;n(s)?(o=l.fromPoints(s.range.start,s.range.end),a=!0):(o=l.fromPoints(s.range.start,s.range.start),a=!1);for(var c=1;c<e.length;c++)s=e[c],n(s)?(r=s.range.start,-1==o.compare(r.row,r.column)&&o.setStart(s.range.start),r=s.range.end,1==o.compare(r.row,r.column)&&o.setEnd(s.range.end),a=!0):(r=s.range.start,-1==o.compare(r.row,r.column)&&(o=l.fromPoints(s.range.start,s.range.start)),a=!1);if(null!=i){0===l.comparePoints(i.start,o.start)&&(i.start.column+=o.end.column-o.start.column,i.end.column+=o.end.column-o.start.column);var h=i.compareRange(o);1==h?o.setStart(i.start):-1==h&&o.setEnd(i.end)}return o},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,i){var n=this.getTextRange(e),o=this.getFoldsInRange(e),r=l.fromPoints(t,t);if(!i){this.remove(e);var s=e.start.row-e.end.row,a=s?-e.end.column:e.start.column-e.end.column;a&&(r.start.row==e.end.row&&r.start.column>e.end.column&&(r.start.column+=a),r.end.row==e.end.row&&r.end.column>e.end.column&&(r.end.column+=a)),s&&r.start.row>=e.end.row&&(r.start.row+=s,r.end.row+=s)}if(r.end=this.insert(r.start,n),o.length){var c=e.start,h=r.start,s=h.row-c.row,a=h.column-c.column;this.addFolds(o.map(function(e){return e=e.clone(),e.start.row==c.row&&(e.start.column+=a),e.end.row==c.row&&(e.end.column+=a),e.start.row+=s,e.end.row+=s,e}))}return r},this.indentRows=function(e,t,i){i=i.replace(/\t/g,this.getTabString());for(var n=e;t>=n;n++)this.insert({row:n,column:0},i)},this.outdentRows=function(e){for(var t=e.collapseRows(),i=new l(0,0,0,0),n=this.getTabSize(),o=t.start.row;o<=t.end.row;++o){var r=this.getLine(o);i.start.row=o,i.end.row=o;for(var s=0;n>s&&" "==r.charAt(s);++s);n>s&&"	"==r.charAt(s)?(i.start.column=s,i.end.column=s+1):(i.start.column=0,i.end.column=s),this.remove(i)}},this.$moveLines=function(e,t,i){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),0>i){var n=this.getRowFoldStart(e+i);if(0>n)return 0;var o=n-e}else if(i>0){var n=this.getRowFoldEnd(t+i);if(n>this.doc.getLength()-1)return 0;var o=n-t}else{e=this.$clipRowToDocument(e),t=this.$clipRowToDocument(t);var o=t-e+1}var r=new l(e,0,t,Number.MAX_VALUE),s=this.getFoldsInRange(r).map(function(e){return e=e.clone(),e.start.row+=o,e.end.row+=o,e}),a=0==i?this.doc.getLines(e,t):this.doc.removeLines(e,t);return this.doc.insertLines(e+o,a),s.length&&this.addFolds(s),o},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return 0>t?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){if(t=Math.max(0,t),0>e)e=0,t=0;else{var i=this.doc.getLength();e>=i?(e=i-1,t=this.doc.getLine(i-1).length):t=Math.min(this.doc.getLine(e).length,t)}return{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){if(e!=this.$useWrapMode){if(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e){var t=this.getLength();this.$wrapData=Array(t),this.$updateWrapData(0,t-1)}this._signal("changeWrapMode")}},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){(this.$wrapLimitRange.min!==e||this.$wrapLimitRange.max!==t)&&(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var i=this.$wrapLimitRange;i.max<0&&(i={min:t,max:t});var n=this.$constrainWrapLimit(e,i.min,i.max);return n!=this.$wrapLimit&&n>1?(this.$wrapLimit=n,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0):!1},this.$constrainWrapLimit=function(e,t,i){return t&&(e=Math.max(t,e)),i&&(e=Math.min(i,e)),e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var t,i=this.$useWrapMode,n=e.data.action,o=e.data.range.start.row,r=e.data.range.end.row,s=e.data.range.start,a=e.data.range.end,l=null;if(-1!=n.indexOf("Lines")?(r="insertLines"==n?o+e.data.lines.length:o,t=e.data.lines?e.data.lines.length:r-o):t=r-o,this.$updating=!0,0!=t)if(-1!=n.indexOf("remove")){this[i?"$wrapData":"$rowLengthCache"].splice(o,t);var c=this.$foldData;l=this.getFoldsInRange(e.data.range),this.removeFolds(l);var h=this.getFoldLine(a.row),u=0;if(h){h.addRemoveChars(a.row,a.column,s.column-a.column),h.shiftRow(-t);var d=this.getFoldLine(o);d&&d!==h&&(d.merge(h),h=d),u=c.indexOf(h)+1}for(u;u<c.length;u++){var h=c[u];h.start.row>=a.row&&h.shiftRow(-t)}r=o}else{var g=Array(t);g.unshift(o,0);var f=i?this.$wrapData:this.$rowLengthCache;f.splice.apply(f,g);var c=this.$foldData,h=this.getFoldLine(o),u=0;if(h){var p=h.range.compareInside(s.row,s.column);0==p?(h=h.split(s.row,s.column),h&&(h.shiftRow(t),h.addRemoveChars(r,0,a.column-s.column))):-1==p&&(h.addRemoveChars(o,0,a.column-s.column),h.shiftRow(t)),u=c.indexOf(h)+1}for(u;u<c.length;u++){var h=c[u];h.start.row>=o&&h.shiftRow(t)}}else{t=Math.abs(e.data.range.start.column-e.data.range.end.column),-1!=n.indexOf("remove")&&(l=this.getFoldsInRange(e.data.range),this.removeFolds(l),t=-t);var h=this.getFoldLine(o);h&&h.addRemoveChars(o,s.column,t)}return i&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,i?this.$updateWrapData(o,r):this.$updateRowLengthCache(o,r),l},this.$updateRowLengthCache=function(e,t){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(e,t){var i,n,o=this.doc.getAllLines(),r=this.getTabSize(),s=this.$wrapData,a=this.$wrapLimit,l=e;for(t=Math.min(t,o.length-1);t>=l;)n=this.getFoldLine(l,n),n?(i=[],n.walk(function(e,t,n,r){var s;if(null!=e){s=this.$getDisplayTokens(e,i.length),s[0]=c;for(var a=1;a<s.length;a++)s[a]=d}else s=this.$getDisplayTokens(o[t].substring(r,n),i.length);i=i.concat(s)}.bind(this),n.end.row,o[n.end.row].length+1),s[n.start.row]=this.$computeWrapSplits(i,a,r),l=n.end.row+1):(i=this.$getDisplayTokens(o[l]),s[l]=this.$computeWrapSplits(i,a,r),l++)};var t=1,s=2,c=3,d=4,g=9,f=10,p=11,m=12;this.$computeWrapSplits=function(e,t){function i(t){var i=e.slice(r,t),o=i.length;i.join("").replace(/12/g,function(){o-=1}).replace(/2/g,function(){o-=1}),a+=o,n.push(a),r=t}if(0==e.length)return[];for(var n=[],o=e.length,r=0,a=0,l=this.$wrapAsCode;o-r>t;){var h=r+t;if(e[h-1]>=f&&e[h]>=f)i(h);else if(e[h]!=c&&e[h]!=d){for(var u=Math.max(h-(l?10:t-(t>>2)),r-1);h>u&&e[h]<c;)h--;if(l){for(;h>u&&e[h]<c;)h--;for(;h>u&&e[h]==g;)h--}else for(;h>u&&e[h]<f;)h--;h>u?i(++h):(h=r+t,e[h]==s&&h--,i(h))}else{for(h;h!=r-1&&e[h]!=c;h--);if(h>r){i(h);continue}for(h=r+t;h<e.length&&e[h]==d;h++);if(h==e.length)break;i(h)}}return n},this.$getDisplayTokens=function(i,n){var o,r=[];n=n||0;for(var a=0;a<i.length;a++){var l=i.charCodeAt(a);if(9==l){o=this.getScreenTabSize(r.length+n),r.push(p);for(var c=1;o>c;c++)r.push(m)}else 32==l?r.push(f):l>39&&48>l||l>57&&64>l?r.push(g):l>=4352&&e(l)?r.push(t,s):r.push(t)}return r},this.$getStringScreenWidth=function(t,i,n){if(0==i)return[0,0];null==i&&(i=1/0),n=n||0;var o,r;for(r=0;r<t.length&&(o=t.charCodeAt(r),n+=9==o?this.getScreenTabSize(n):o>=4352&&e(o)?2:1,!(n>i));r++);return[n,r]},this.lineWidgets=null,this.getRowLength=function(e){if(this.lineWidgets)var t=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;else t=0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getScreenLastRowColumn=function(e){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(t.row,t.column)},this.getDocumentLastRowColumn=function(e,t){var i=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(i)},this.getDocumentLastRowColumnPosition=function(e,t){var i=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(i,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){return this.$useWrapMode?this.$wrapData[e]:void 0},this.getScreenTabSize=function(e){return this.$tabSize-e%this.$tabSize},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,t){if(0>e)return{row:0,column:0};var i,n,o=0,r=0,s=0,a=0,l=this.$screenRowCache,c=this.$getRowCacheIndex(l,e),h=l.length;if(h&&c>=0)var s=l[c],o=this.$docRowCache[c],u=e>l[h-1];else var u=!h;for(var d=this.getLength()-1,g=this.getNextFoldLine(o),f=g?g.start.row:1/0;e>=s&&(a=this.getRowLength(o),!(s+a>e||o>=d));)s+=a,o++,o>f&&(o=g.end.row+1,g=this.getNextFoldLine(o,g),f=g?g.start.row:1/0),u&&(this.$docRowCache.push(o),this.$screenRowCache.push(s));if(g&&g.start.row<=o)i=this.getFoldDisplayLine(g),o=g.start.row;else{if(e>=s+a||o>d)return{row:d,column:this.getLine(d).length};i=this.getLine(o),g=null}if(this.$useWrapMode){var p=this.$wrapData[o];if(p){var m=Math.floor(e-s);n=p[m],m>0&&p.length&&(r=p[m-1]||p[p.length-1],i=i.substring(r))}}return r+=this.$getStringScreenWidth(i,t)[1],this.$useWrapMode&&r>=n&&(r=n-1),g?g.idxToPosition(r):{row:o,column:r}},this.documentToScreenPosition=function(e,t){if("undefined"==typeof t)var i=this.$clipPositionToDocument(e.row,e.column);else i=this.$clipPositionToDocument(e,t);e=i.row,t=i.column;var n=0,o=null,r=null;r=this.getFoldAt(e,t,1),r&&(e=r.start.row,t=r.start.column);var s,a=0,l=this.$docRowCache,c=this.$getRowCacheIndex(l,e),h=l.length;if(h&&c>=0)var a=l[c],n=this.$screenRowCache[c],u=e>l[h-1];else var u=!h;for(var d=this.getNextFoldLine(a),g=d?d.start.row:1/0;e>a;){if(a>=g){if(s=d.end.row+1,s>e)break;d=this.getNextFoldLine(s,d),g=d?d.start.row:1/0}else s=a+1;n+=this.getRowLength(a),a=s,u&&(this.$docRowCache.push(a),this.$screenRowCache.push(n))}var f="";if(d&&a>=g?(f=this.getFoldDisplayLine(d,e,t),o=d.start.row):(f=this.getLine(e).substring(0,t),o=e),this.$useWrapMode){var p=this.$wrapData[o];if(p){for(var m=0;f.length>=p[m];)n++,m++;f=f.substring(p[m-1]||0,f.length)}}return{row:n,column:this.$getStringScreenWidth(f)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var i=this.$wrapData.length,n=0,o=0,t=this.$foldData[o++],r=t?t.start.row:1/0;i>n;){var s=this.$wrapData[n];e+=s?s.length+1:1,n++,n>r&&(n=t.end.row+1,t=this.$foldData[o++],r=t?t.start.row:1/0)}else{e=this.getLength();for(var a=this.$foldData,o=0;o<a.length;o++)t=a[o],e-=t.end.row-t.start.row}return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(){},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker()}}).call(d.prototype),e("./edit_session/folding").Folding.call(d.prototype),e("./edit_session/bracket_match").BracketMatch.call(d.prototype),o.defineOptions(d.prototype,"session",{wrap:{set:function(e){if(e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e){if(e){var t="number"==typeof e?e:null;this.setWrapLimitRange(t,t),this.setUseWrapMode(!0)}else this.setUseWrapMode(!1);this.$wrap=e}},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){e="auto"==e?"text"!=this.$mode.type:"text"!=e,e!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$modified=!0,this.$resetRowCache(0),this.$updateWrapData(0,this.getLength()-1)))},initialValue:"auto"},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){isNaN(e)||this.$tabSize===e||(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},overwrite:{set:function(){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId}}}),t.EditSession=d}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t){"use strict";var i=e("./lib/lang"),n=e("./lib/oop"),o=e("./range").Range,r=function(){this.$options={}};(function(){this.set=function(e){return n.mixin(this.$options,e),this},this.getOptions=function(){return i.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var t=this.$matchIterator(e,this.$options);if(!t)return!1;var i=null;return t.forEach(function(e,t,n){if(e.start)i=e;else{var r=e.offset+(n||0);i=new o(t,r,t,r+e.length)}return!0}),i},this.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var n=t.range,r=n?e.getLines(n.start.row,n.end.row):e.doc.getAllLines(),s=[],a=t.re;if(t.$isMultiLine){var l,c=a.length,h=r.length-c;e:for(var u=a.offset||0;h>=u;u++){for(var d=0;c>d;d++)if(-1==r[u+d].search(a[d]))continue e;var g=r[u],f=r[u+c-1],p=g.length-g.match(a[0])[0].length,m=f.match(a[c-1])[0].length;l&&l.end.row===u&&l.end.column>p||(s.push(l=new o(u,p,u+c-1,m)),c>2&&(u=u+c-2))}}else for(var v=0;v<r.length;v++)for(var A=i.getMatchOffsets(r[v],a),d=0;d<A.length;d++){var w=A[d];s.push(new o(v,w.offset,v,w.offset+w.length))}if(n){for(var C=n.start.column,E=n.start.column,v=0,d=s.length-1;d>v&&s[v].start.column<C&&s[v].start.row==n.start.row;)v++;for(;d>v&&s[d].end.column>E&&s[d].end.row==n.end.row;)d--;for(s=s.slice(v,d+1),v=0,d=s.length;d>v;v++)s[v].start.row+=n.start.row,s[v].end.row+=n.start.row}return s},this.replace=function(e,t){var i=this.$options,n=this.$assembleRegExp(i);if(i.$isMultiLine)return t;if(n){var o=n.exec(e);if(!o||o[0].length!=e.length)return null;if(t=e.replace(n,t),i.preserveCase){t=t.split("");for(var r=Math.min(e.length,e.length);r--;){var s=e[r];t[r]=s&&s.toLowerCase()!=s?t[r].toUpperCase():t[r].toLowerCase()}t=t.join("")}return t}},this.$matchIterator=function(e,t){var n=this.$assembleRegExp(t);if(!n)return!1;var r,s=this,a=t.backwards;if(t.$isMultiLine)var l=n.length,c=function(t,i,s){var a=t.search(n[0]);if(-1!=a){for(var c=1;l>c;c++)if(t=e.getLine(i+c),-1==t.search(n[c]))return;var h=t.match(n[l-1])[0].length,u=new o(i,a,i+l-1,h);return 1==n.offset?(u.start.row--,u.start.column=Number.MAX_VALUE):s&&(u.start.column+=s),r(u)?!0:void 0}};else if(a)var c=function(e,t,o){for(var s=i.getMatchOffsets(e,n),a=s.length-1;a>=0;a--)if(r(s[a],t,o))return!0};else var c=function(e,t,o){for(var s=i.getMatchOffsets(e,n),a=0;a<s.length;a++)if(r(s[a],t,o))return!0};return{forEach:function(i){r=i,s.$lineIterator(e,t).forEach(c)}}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var n=e.needle;if(!e.needle)return e.re=!1;e.regExp||(n=i.escapeRegExp(n)),e.wholeWord&&(n="\\b"+n+"\\b");var o=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(n),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(n,o);try{var r=new RegExp(n,o)}catch(s){r=!1}return e.re=r},this.$assembleMultilineRegExp=function(e,t){for(var i=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),n=[],o=0;o<i.length;o++)try{n.push(new RegExp(i[o],t))}catch(r){return!1}return""==i[0]?(n.shift(),n.offset=1):n.offset=0,n},this.$lineIterator=function(e,t){var i=1==t.backwards,n=0!=t.skipCurrent,o=t.range,r=t.start;r||(r=o?o[i?"end":"start"]:e.selection.getRange()),r.start&&(r=r[n!=i?"end":"start"]);var s=o?o.start.row:0,a=o?o.end.row:e.getLength()-1,l=i?function(i){var n=r.row,o=e.getLine(n).substring(0,r.column);if(!i(o,n)){for(n--;n>=s;n--)if(i(e.getLine(n),n))return;if(0!=t.wrap)for(n=a,s=r.row;n>=s;n--)if(i(e.getLine(n),n))return}}:function(i){var n=r.row,o=e.getLine(n).substr(r.column);if(!i(o,n,r.column)){for(n+=1;a>=n;n++)if(i(e.getLine(n),n))return;if(0!=t.wrap)for(n=s,a=r.row;a>=n;n++)if(i(e.getLine(n),n))return}};return{forEach:l}}}).call(r.prototype),t.Search=r}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t){"use strict";function i(e,t){this.platform=t||(r.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function n(e,t){i.call(this,e,t),this.$singleCommand=!1}var o=e("../lib/keys"),r=e("../lib/useragent"),s=o.KEY_MODS;n.prototype=i.prototype,function(){this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),this.commands[e.name]=e,e.bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var i=e&&("string"==typeof e?e:e.name);e=this.commands[i],t||delete this.commands[i];var n=this.commandKeyBinding;for(var o in n){var r=n[o];if(r==e)delete n[o];else if(Array.isArray(r)){var s=r.indexOf(e);-1!=s&&(r.splice(s,1),1==r.length&&(n[o]=r[0]))}}},this.bindKey=function(e,t,i){return"object"==typeof e&&(e=e[this.platform]),e?"function"==typeof t?this.addCommand({exec:t,bindKey:e,name:t.name||e}):void e.split("|").forEach(function(e){var n="";if(-1!=e.indexOf(" ")){var o=e.split(/\s+/);e=o.pop(),o.forEach(function(e){var t=this.parseKeys(e),i=s[t.hashId]+t.key;n+=(n?" ":"")+i,this._addCommandToBinding(n,"chainKeys")},this),n+=" "}var r=this.parseKeys(e),a=s[r.hashId]+r.key;this._addCommandToBinding(n+a,t,i)},this):void 0},this._addCommandToBinding=function(e,t,i){var n,o=this.commandKeyBinding;t?!o[e]||this.$singleCommand?o[e]=t:(Array.isArray(o[e])?-1!=(n=o[e].indexOf(t))&&o[e].splice(n,1):o[e]=[o[e]],i||t.isDefault?o[e].unshift(t):o[e].push(t)):delete o[e]},this.addCommands=function(e){e&&Object.keys(e).forEach(function(t){var i=e[t];if(i){if("string"==typeof i)return this.bindKey(i,t);"function"==typeof i&&(i={exec:i}),"object"==typeof i&&(i.name||(i.name=t),this.addCommand(i))}},this)},this.removeCommands=function(e){Object.keys(e).forEach(function(t){this.removeCommand(e[t])},this)},this.bindKeys=function(e){Object.keys(e).forEach(function(t){this.bindKey(t,e[t])},this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(e){return e}),i=t.pop(),n=o[i];if(o.FUNCTION_KEYS[n])i=o.FUNCTION_KEYS[n].toLowerCase();else{if(!t.length)return{key:i,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:i.toUpperCase(),hashId:-1}}for(var r=0,s=t.length;s--;){var a=o.KEY_MODS[t[s]];if(null==a)return"undefined"!=typeof console&&console.error("invalid modifier "+t[s]+" in "+e),!1;r|=a}return{key:i,hashId:r}},this.findKeyCommand=function(e,t){var i=s[e]+t;return this.commandKeyBinding[i]},this.handleKeyboard=function(e,t,i,n){var o=s[t]+i,r=this.commandKeyBinding[o];return e.$keyChain&&(e.$keyChain+=" "+o,r=this.commandKeyBinding[e.$keyChain]||r),!r||"chainKeys"!=r&&"chainKeys"!=r[r.length-1]?(e.$keyChain&&n>0&&(e.$keyChain=""),{command:r}):(e.$keyChain=e.$keyChain||o,{command:"null"})}}.call(i.prototype),t.HashHandler=i,t.MultiHashHandler=n}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(e,t){"use strict";var i=e("../lib/oop"),n=e("../keyboard/hash_handler").MultiHashHandler,o=e("../lib/event_emitter").EventEmitter,r=function(e,t){n.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",function(e){return e.command.exec(e.editor,e.args||{})})};i.inherits(r,n),function(){i.implement(this,o),this.exec=function(e,t,i){if(Array.isArray(e)){for(var n=e.length;n--;)if(this.exec(e[n],t,i))return!0;return!1}if("string"==typeof e&&(e=this.commands[e]),!e)return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;var o={editor:t,command:e,args:i};return o.returnValue=this._emit("exec",o),this._signal("afterExec",o),o.returnValue===!1?!1:!0},this.toggleRecording=function(e){return this.$inReplay?void 0:(e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.removeEventListener("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0))},this.replay=function(e){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(e);try{this.$inReplay=!0,this.macro.forEach(function(t){"string"==typeof t?this.exec(t,e):this.exec(t[0],e,t[1])},this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map(function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e[1]||(e=e[0]),e})}}.call(r.prototype),t.CommandManager=r}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(e,t){"use strict";function i(e,t){return{win:e,mac:t}}var n=e("../lib/lang"),o=e("../config"),r=e("../range").Range;t.commands=[{name:"showSettingsMenu",bindKey:i("Ctrl-,","Command-,"),exec:function(e){o.loadModule("ace/ext/settings_menu",function(t){t.init(e),e.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",bindKey:i("Alt-E","Ctrl-E"),exec:function(e){o.loadModule("ace/ext/error_marker",function(t){t.showErrorMarker(e,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:i("Alt-Shift-E","Ctrl-Shift-E"),exec:function(e){o.loadModule("ace/ext/error_marker",function(t){t.showErrorMarker(e,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",bindKey:i("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",bindKey:i(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",bindKey:i("Ctrl-L","Command-L"),exec:function(e){var t=parseInt(prompt("Enter line number:"),10);isNaN(t)||e.gotoLine(t)},readOnly:!0},{name:"fold",bindKey:i("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:i("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:i("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:i("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},scrollIntoView:"center",readOnly:!0},{name:"foldall",bindKey:i("Ctrl-Alt-0","Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",bindKey:i("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",bindKey:i("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",bindKey:i("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",bindKey:i("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",bindKey:i("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",bindKey:i("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",bindKey:i("Ctrl-F","Command-F"),exec:function(e){o.loadModule("ace/ext/searchbox",function(t){t.Search(e)})},readOnly:!0},{name:"overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",bindKey:i("Ctrl-Shift-Home","Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",bindKey:i("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",bindKey:i("Shift-Up","Shift-Up"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",readOnly:!0},{name:"golineup",bindKey:i("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",
readOnly:!0},{name:"selecttoend",bindKey:i("Ctrl-Shift-End","Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",bindKey:i("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",bindKey:i("Shift-Down","Shift-Down"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",bindKey:i("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",bindKey:i("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",bindKey:i("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",bindKey:i("Alt-Shift-Left","Command-Shift-Left"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",bindKey:i("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",bindKey:i("Shift-Left","Shift-Left"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",bindKey:i("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",bindKey:i("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",bindKey:i("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",bindKey:i("Alt-Shift-Right","Command-Shift-Right"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",bindKey:i("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",bindKey:i("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",bindKey:i("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",bindKey:i(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",bindKey:i("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",bindKey:i(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",bindKey:i("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",bindKey:i("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",bindKey:i("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",bindKey:i("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",bindKey:i("Ctrl-P","Ctrl-P"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",readOnly:!0},{name:"selecttomatching",bindKey:i("Ctrl-Shift-P","Ctrl-Shift-P"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",readOnly:!0},{name:"passKeysToBrowser",bindKey:i("null","null"),exec:function(){},passEvent:!0,readOnly:!0},{name:"cut",exec:function(e){var t=e.getSelectionRange();e._emit("cut",t),e.selection.isEmpty()||(e.session.remove(t),e.clearSelection())},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"removeline",bindKey:i("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",bindKey:i("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",bindKey:i("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",bindKey:i("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",bindKey:i("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",bindKey:i("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},multiSelectAction:"forEach"},{name:"modifyNumberDown",bindKey:i("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},multiSelectAction:"forEach"},{name:"replace",bindKey:i("Ctrl-H","Command-Option-F"),exec:function(e){o.loadModule("ace/ext/searchbox",function(t){t.Search(e,!0)})}},{name:"undo",bindKey:i("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",bindKey:i("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",bindKey:i("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",bindKey:i("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",bindKey:i("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",bindKey:i("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",bindKey:i("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",bindKey:i("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",bindKey:i("Shift-Delete",null),exec:function(e){return e.selection.isEmpty()?void e.remove("left"):!1},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",bindKey:i("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",bindKey:i("Alt-Delete","Ctrl-K"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",bindKey:i("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",bindKey:i("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",bindKey:i("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",bindKey:i("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",bindKey:i("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",bindKey:i("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",exec:function(e,t){e.insert(n.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",bindKey:i(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",bindKey:i("Ctrl-T","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",bindKey:i("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",bindKey:i("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"expandtoline",bindKey:i("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",bindKey:i(null,null),exec:function(e){for(var t=e.selection.isBackwards(),i=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),o=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),s=e.session.doc.getLine(i.row).length,a=e.session.doc.getTextRange(e.selection.getRange()),l=a.replace(/\n\s*/," ").length,c=e.session.doc.getLine(i.row),h=i.row+1;h<=o.row+1;h++){var u=n.stringTrimLeft(n.stringTrimRight(e.session.doc.getLine(h)));0!==u.length&&(u=" "+u),c+=u}o.row+1<e.session.doc.getLength()-1&&(c+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new r(i.row,0,o.row+2,0),c),l>0?(e.selection.moveCursorTo(i.row,i.column),e.selection.selectTo(i.row,i.column+l)):(s=e.session.doc.getLine(i.row).length>s?s+1:s,e.selection.moveCursorTo(i.row,s))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",bindKey:i(null,null),exec:function(e){var t=e.session.doc.getLength()-1,i=e.session.doc.getLine(t).length,n=e.selection.rangeList.ranges,o=[];n.length<1&&(n=[e.selection.getRange()]);for(var s=0;s<n.length;s++)s==n.length-1&&(n[s].end.row!==t||n[s].end.column!==i)&&o.push(new r(n[s].end.row,n[s].end.column,t,i)),0===s?(0!==n[s].start.row||0!==n[s].start.column)&&o.push(new r(0,0,n[s].start.row,n[s].start.column)):o.push(new r(n[s-1].end.row,n[s-1].end.column,n[s].start.row,n[s].start.column));e.exitMultiSelectMode(),e.clearSelection();for(var s=0;s<o.length;s++)e.selection.addRange(o[s],!1)},readOnly:!0,scrollIntoView:"none"}]}),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator"],function(e,t){"use strict";e("./lib/fixoldbrowsers");var i=e("./lib/oop"),n=e("./lib/dom"),o=e("./lib/lang"),r=e("./lib/useragent"),s=e("./keyboard/textinput").TextInput,a=e("./mouse/mouse_handler").MouseHandler,l=e("./mouse/fold_handler").FoldHandler,c=e("./keyboard/keybinding").KeyBinding,h=e("./edit_session").EditSession,u=e("./search").Search,d=e("./range").Range,g=e("./lib/event_emitter").EventEmitter,f=e("./commands/command_manager").CommandManager,p=e("./commands/default_commands").commands,m=e("./config"),v=e("./token_iterator").TokenIterator,A=function(e,t){var i=e.getContainerElement();this.container=i,this.renderer=e,this.commands=new f(r.isMac?"mac":"win",p),this.textInput=new s(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.keyBinding=new c(this),this.$mouseHandler=new a(this),new l(this),this.$blockScrolling=0,this.$search=(new u).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=o.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(e,t){t._$emitInputEvent.schedule(31)}),this.setSession(t||new h("")),m.resetOptions(this),m._signal("editor",this)};(function(){i.implement(this,g),this.$initOperationListeners=function(){this.selections=[],this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=o.delayedCall(this.endOperation.bind(this)),this.on("change",function(){this.curOp||this.startOperation(),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||this.startOperation(),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop}},this.endOperation=function(e){if(this.curOp){if(e&&e.returnValue===!1)return this.curOp=null;var t=this.curOp.command;if(t&&t.scrollIntoView){switch(t.scrollIntoView){case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var i=this.selection.getRange(),n=this.renderer.layerConfig;(i.start.row>=n.lastRow||i.end.row<=n.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==t.scrollIntoView&&this.renderer.animateScrolling(this.curOp.scrollTop)}this.prevOp=this.curOp,this.curOp=null}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){if(this.$mergeUndoDeltas){var t=this.prevOp,i=this.$mergeableCommands,n=t.command&&e.command.name==t.command.name;if("insertstring"==e.command.name){var o=e.args;void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),n=n&&this.mergeNextCommand&&(!/\s/.test(o)||/\s/.test(t.args)),this.mergeNextCommand=!0}else n=n&&-1!==i.indexOf(e.command.name);"always"!=this.$mergeUndoDeltas&&Date.now()-this.sequenceStartTime>2e3&&(n=!1),n?this.session.mergeUndoDeltas=!0:-1!==i.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now())}},this.setKeyboardHandler=function(e,t){if(e&&"string"==typeof e){this.$keybindingId=e;var i=this;m.loadModule(["keybinding",e],function(n){i.$keybindingId==e&&i.keyBinding.setKeyboardHandler(n&&n.handler),t&&t()})}else this.$keybindingId=null,this.keyBinding.setKeyboardHandler(e),t&&t()},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){if(this.session!=e){var t=this.session;if(t){this.session.removeEventListener("change",this.$onDocumentChange),this.session.removeEventListener("changeMode",this.$onChangeMode),this.session.removeEventListener("tokenizerUpdate",this.$onTokenizerUpdate),this.session.removeEventListener("changeTabSize",this.$onChangeTabSize),this.session.removeEventListener("changeWrapLimit",this.$onChangeWrapLimit),this.session.removeEventListener("changeWrapMode",this.$onChangeWrapMode),this.session.removeEventListener("onChangeFold",this.$onChangeFold),this.session.removeEventListener("changeFrontMarker",this.$onChangeFrontMarker),this.session.removeEventListener("changeBackMarker",this.$onChangeBackMarker),this.session.removeEventListener("changeBreakpoint",this.$onChangeBreakpoint),this.session.removeEventListener("changeAnnotation",this.$onChangeAnnotation),this.session.removeEventListener("changeOverwrite",this.$onCursorChange),this.session.removeEventListener("changeScrollTop",this.$onScrollTopChange),this.session.removeEventListener("changeScrollLeft",this.$onScrollLeftChange);var i=this.session.getSelection();i.removeEventListener("changeCursor",this.$onCursorChange),i.removeEventListener("changeSelection",this.$onSelectionChange)}this.session=e,e?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.addEventListener("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.addEventListener("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.addEventListener("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.addEventListener("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.addEventListener("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.addEventListener("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.addEventListener("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.addEventListener("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.addEventListener("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.addEventListener("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.addEventListener("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.addEventListener("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.addEventListener("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.addEventListener("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.addEventListener("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.addEventListener("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.$blockScrolling+=1,this.onCursorChange(),this.$blockScrolling-=1,this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this})}},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||n.computedStyle(this.container,"fontSize")},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){if(this.session.$bracketHighlight&&(this.session.removeMarker(this.session.$bracketHighlight),this.session.$bracketHighlight=null),!this.$highlightPending){var e=this;this.$highlightPending=!0,setTimeout(function(){e.$highlightPending=!1;var t=e.session;if(t&&t.bgTokenizer){var i=t.findMatchingBracket(e.getCursorPosition());if(i)var n=new d(i.row,i.column,i.row,i.column+1);else if(t.$mode.getMatching)var n=t.$mode.getMatching(e.session);n&&(t.$bracketHighlight=t.addMarker(n,"ace_bracket","text"))}},50)}},this.$highlightTags=function(){if(!this.$highlightTagPending){var e=this;this.$highlightTagPending=!0,setTimeout(function(){e.$highlightTagPending=!1;var t=e.session;if(t&&t.bgTokenizer){var i=e.getCursorPosition(),n=new v(e.session,i.row,i.column),o=n.getCurrentToken();if(!o||-1===o.type.indexOf("tag-name"))return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);var r=o.value,s=0,a=n.stepBackward();if("<"==a.value){do a=o,o=n.stepForward(),o&&o.value===r&&-1!==o.type.indexOf("tag-name")&&("<"===a.value?s++:"</"===a.value&&s--);while(o&&s>=0)}else{do o=a,a=n.stepBackward(),o&&o.value===r&&-1!==o.type.indexOf("tag-name")&&("<"===a.value?s++:"</"===a.value&&s--);while(a&&0>=s);n.stepForward()}if(!o)return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);var l=n.getCurrentTokenRow(),c=n.getCurrentTokenColumn(),h=new d(l,c,l,c+o.value.length);t.$tagHighlight&&0!==h.compareRange(t.$backMarkers[t.$tagHighlight].range)&&(t.removeMarker(t.$tagHighlight),t.$tagHighlight=null),h&&!t.$tagHighlight&&(t.$tagHighlight=t.addMarker(h,"ace_bracket","text"))}},50)}},this.focus=function(){var e=this;setTimeout(function(){e.textInput.focus()}),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor()},this.onDocumentChange=function(e){var t,i=e.data,n=i.range;t=n.start.row==n.end.row&&"insertLines"!=i.action&&"removeLines"!=i.action?n.end.row:1/0,this.renderer.updateLines(n.start.row,t,this.session.$useWrapMode),this._signal("change",e),this.$cursorChange(),this.$updateHighlightActiveLine()},this.onTokenizerUpdate=function(e){var t=e.data;this.renderer.updateLines(t.first,t.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this.$blockScrolling||this.renderer.scrollCursorIntoView(),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t=this.getSession();if(this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),!this.renderer.$maxLines||1!==this.session.getLength()||this.renderer.$minLines>1||(e=!1)),t.$highlightLineMarker&&!e)t.removeMarker(t.$highlightLineMarker.id),t.$highlightLineMarker=null;else if(!t.$highlightLineMarker&&e){var i=new d(e.row,e.column,e.row,1/0);i.id=t.addMarker(i,"ace_active-line","screenLine"),t.$highlightLineMarker=i}else e&&(t.$highlightLineMarker.start.row=e.row,t.$highlightLineMarker.end.row=e.row,t.$highlightLineMarker.start.column=e.column,t._signal("changeBackMarker"))},this.onSelectionChange=function(){var e=this.session;if(e.$selectionMarker&&e.removeMarker(e.$selectionMarker),e.$selectionMarker=null,this.selection.isEmpty())this.$updateHighlightActiveLine();else{var t=this.selection.getRange(),i=this.getSelectionStyle();e.$selectionMarker=e.addMarker(t,"ace_selection",i)}var n=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(n),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var i=t.start.column-1,n=t.end.column+1,o=e.getLine(t.start.row),r=o.length,s=o.substring(Math.max(i,0),Math.min(n,r));if(!(i>=0&&/^[\w\d]/.test(s)||r>=n&&/[\w\d]$/.test(s))&&(s=o.substring(t.start.column,t.end.column),/^[\w\d]+$/.test(s))){var a=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:s});return a}}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText();return this._signal("copy",e),e},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e){if(!this.$readOnly){var t={text:e};this._signal("paste",t),this.insert(t.text,!0)}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var i=this.session,n=i.getMode(),o=this.getCursorPosition();if(this.getBehavioursEnabled()&&!t){var r=n.transformAction(i.getState(o.row),"insertion",this,i,e);r&&(e!==r.text&&(this.session.mergeUndoDeltas=!1,this.$mergeNextCommand=!1),e=r.text)}if("	"==e&&(e=this.session.getTabString()),this.selection.isEmpty()){if(this.session.getOverwrite()){var s=new d.fromPoints(o,o);s.end.column+=e.length,this.session.remove(s)}}else{var s=this.getSelectionRange();o=this.session.remove(s),this.clearSelection()}if("\n"==e||"\r\n"==e){var a=i.getLine(o.row);if(o.column>a.search(/\S|$/)){var l=a.substr(o.column).search(/\S|$/);i.doc.removeInLine(o.row,o.column,o.column+l)}}this.clearSelection();{var c=o.column,h=i.getState(o.row),a=i.getLine(o.row),u=n.checkOutdent(h,a,e);i.insert(o,e)}if(r&&r.selection&&this.selection.setSelectionRange(2==r.selection.length?new d(o.row,c+r.selection[0],o.row,c+r.selection[1]):new d(o.row+r.selection[0],r.selection[1],o.row+r.selection[2],r.selection[3])),i.getDocument().isNewLine(e)){var g=n.getNextLineIndent(h,a.slice(0,o.column),i.getTabString());i.insert({row:o.row+1,column:0},g)}u&&n.autoOutdent(h,i,o.row)},this.onTextInput=function(e){this.keyBinding.onTextInput(e)},this.onCommandKey=function(e,t,i){this.keyBinding.onCommandKey(e,t,i)},this.setOverwrite=function(e){this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t=this.getSelectionRange();if(this.getBehavioursEnabled()){var i=this.session,n=i.getState(t.start.row),o=i.getMode().transformAction(n,"deletion",this,i,t);if(0===t.end.column){var r=i.getTextRange(t);if("\n"==r[r.length-1]){var s=i.getLine(t.end.row);/^\s+$/.test(s)&&(t.end.column=s.length)}}o&&(t=o)}this.session.remove(t),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){if(this.selection.isEmpty()){var e=this.getCursorPosition(),t=e.column;if(0!==t){var i,n,o=this.session.getLine(e.row);t<o.length?(i=o.charAt(t)+o.charAt(t-1),n=new d(e.row,t-1,e.row,t+1)):(i=o.charAt(t-1)+o.charAt(t-2),n=new d(e.row,t-2,e.row,t)),this.session.replace(n,i)}}},this.toLowerCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(t.start.row<t.end.row){var i=this.$getSelectedRows();return void e.indentRows(i.first,i.last,"	")}if(t.start.column<t.end.column){var n=e.getTextRange(t);if(!/^\s+$/.test(n)){var i=this.$getSelectedRows();return void e.indentRows(i.first,i.last,"	")}}var r=e.getLine(t.start.row),s=t.start,a=e.getTabSize(),l=e.documentToScreenColumn(s.row,s.column);if(this.session.getUseSoftTabs())var c=a-l%a,h=o.stringRepeat(" ",c);
else{for(var c=l%a;" "==r[t.start.column]&&c;)t.start.column--,c--;this.selection.setSelectionRange(t),h="	"}return this.insert(h)},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"	")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){var e=this.$getSelectedRows(),t=this.session,i=[];for(o=e.first;o<=e.last;o++)i.push(t.getLine(o));i.sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0});for(var n=new d(0,0,0,0),o=e.first;o<=e.last;o++){var r=t.getLine(o);n.start.row=o,n.end.row=o,n.end.column=r.length,t.replace(n,i[o-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),i=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,i,e)},this.getNumberAt=function(e,t){var i=/[\-]?[0-9]+(?:\.[0-9]+)?/g;i.lastIndex=0;for(var n=this.session.getLine(e);i.lastIndex<t;){var o=i.exec(n);if(o.index<=t&&o.index+o[0].length>=t){var r={value:o[0],start:o.index,end:o.index+o[0].length};return r}}return null},this.modifyNumber=function(e){var t=this.selection.getCursor().row,i=this.selection.getCursor().column,n=new d(t,i-1,t,i),o=this.session.getTextRange(n);if(!isNaN(parseFloat(o))&&isFinite(o)){var r=this.getNumberAt(t,i);if(r){var s=r.value.indexOf(".")>=0?r.start+r.value.indexOf(".")+1:r.end,a=r.start+r.value.length-s,l=parseFloat(r.value);l*=Math.pow(10,a),e*=s!==r.end&&s>i?Math.pow(10,r.end-i-1):Math.pow(10,r.end-i),l+=e,l/=Math.pow(10,a);var c=l.toFixed(a),h=new d(t,r.start,t,r.end);this.session.replace(h,c),this.moveCursorTo(t,Math.max(r.start+1,i+c.length-r.value.length))}}},this.removeLines=function(){var e,t=this.$getSelectedRows();e=0===t.first||t.last+1<this.session.getLength()?new d(t.first,0,t.last+1,0):new d(t.first-1,this.session.getLine(t.first-1).length,t.last,this.session.getLine(t.last).length),this.session.remove(e),this.clearSelection()},this.duplicateSelection=function(){var e=this.selection,t=this.session,i=e.getRange(),n=e.isBackwards();if(i.isEmpty()){var o=i.start.row;t.duplicateLines(o,o)}else{var r=n?i.start:i.end,s=t.insert(r,t.getTextRange(i),!1);i.start=r,i.end=s,e.setSelectionRange(i,n)}},this.moveLinesDown=function(){this.$moveLines(function(e,t){return this.session.moveLinesDown(e,t)})},this.moveLinesUp=function(){this.$moveLines(function(e,t){return this.session.moveLinesUp(e,t)})},this.moveText=function(e,t,i){return this.session.moveText(e,t,i)},this.copyLinesUp=function(){this.$moveLines(function(e,t){return this.session.duplicateLines(e,t),0})},this.copyLinesDown=function(){this.$moveLines(function(e,t){return this.session.duplicateLines(e,t)})},this.$moveLines=function(e){var t=this.selection;if(!t.inMultiSelectMode||this.inVirtualSelectionMode){var i=t.toOrientedRange(),n=this.$getSelectedRows(i),o=e.call(this,n.first,n.last);i.moveBy(o,0),t.fromOrientedRange(i)}else{var r=t.rangeList.ranges;t.rangeList.detach(this.session);for(var s=r.length;s--;){for(var a=s,n=r[s].collapseRows(),l=n.end.row,c=n.start.row;s--&&(n=r[s].collapseRows(),c-n.end.row<=1);)c=n.end.row;s++;for(var o=e.call(this,c,l);a>=s;)r[a].moveBy(o,0),a--}t.fromOrientedRange(t.ranges[0]),t.rangeList.attach(this.session)}},this.$getSelectedRows=function(){var e=this.getSelectionRange().collapseRows();return{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(){this.renderer.showComposition(this.getCursorPosition())},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var i=this.renderer,n=this.renderer.layerConfig,o=e*Math.floor(n.height/n.lineHeight);this.$blockScrolling++,t===!0?this.selection.$moveSelection(function(){this.moveCursorBy(o,0)}):t===!1&&(this.selection.moveCursorBy(o,0),this.selection.clearSelection()),this.$blockScrolling--;var r=i.scrollTop;i.scrollBy(0,o*n.lineHeight),null!=t&&i.scrollCursorIntoView(null,.5),i.animateScrolling(r)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,i,n){this.renderer.scrollToLine(e,t,i,n)},this.centerSelection=function(){var e=this.getSelectionRange(),t={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(t,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.$blockScrolling+=1,this.selection.selectAll(),this.$blockScrolling-=1},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(e,t){var i=this.getCursorPosition(),n=new v(this.session,i.row,i.column),o=n.getCurrentToken(),r=o||n.stepForward();if(r){var s,a,l=!1,c={},h=i.column-r.start,u={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(r.value.match(/[{}()\[\]]/g)){for(;h<r.value.length&&!l;h++)if(u[r.value[h]])switch(a=u[r.value[h]]+"."+r.type.replace("rparen","lparen"),isNaN(c[a])&&(c[a]=0),r.value[h]){case"(":case"[":case"{":c[a]++;break;case")":case"]":case"}":c[a]--,-1===c[a]&&(s="bracket",l=!0)}}else r&&-1!==r.type.indexOf("tag-name")&&(isNaN(c[r.value])&&(c[r.value]=0),"<"===o.value?c[r.value]++:"</"===o.value&&c[r.value]--,-1===c[r.value]&&(s="tag",l=!0));l||(o=r,r=n.stepForward(),h=0)}while(r&&!l);if(s){var g,f;if("bracket"===s)g=this.session.getBracketRange(i),g||(g=new d(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1,n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1),f=g.start,(t||f.row===i.row&&Math.abs(f.column-i.column)<2)&&(g=this.session.getBracketRange(f)));else if("tag"===s){if(!r||-1===r.type.indexOf("tag-name"))return;var p=r.value;if(g=new d(n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2,n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2),0===g.compare(i.row,i.column)){l=!1;do r=o,o=n.stepBackward(),o&&(-1!==o.type.indexOf("tag-close")&&g.setEnd(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+1),r.value===p&&-1!==r.type.indexOf("tag-name")&&("<"===o.value?c[p]++:"</"===o.value&&c[p]--,0===c[p]&&(l=!0)));while(o&&!l)}r&&r.type.indexOf("tag-name")&&(f=g.start,f.row==i.row&&Math.abs(f.column-i.column)<2&&(f=g.end))}f=g&&g.cursor||f,f&&(e?g&&t?this.selection.setRange(g):g&&g.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(f.row,f.column):this.selection.moveTo(f.row,f.column))}}},this.gotoLine=function(e,t,i){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.$blockScrolling+=1,this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.$blockScrolling-=1,this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,i)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var i=this.$search.find(this.session),n=0;return i?(this.$tryReplace(i,e)&&(n=1),null!==i&&(this.selection.setSelectionRange(i),this.renderer.scrollSelectionIntoView(i.start,i.end)),n):n},this.replaceAll=function(e,t){t&&this.$search.set(t);var i=this.$search.findAll(this.session),n=0;if(!i.length)return n;this.$blockScrolling+=1;var o=this.getSelectionRange();this.selection.moveTo(0,0);for(var r=i.length-1;r>=0;--r)this.$tryReplace(i[r],e)&&n++;return this.selection.setSelectionRange(o),this.$blockScrolling-=1,n},this.$tryReplace=function(e,t){var i=this.session.getTextRange(e);return t=this.$search.replace(i,t),null!==t?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,n){t||(t={}),"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&i.mixin(t,e);var o=this.selection.getRange();null==t.needle&&(e=this.session.getTextRange(o)||this.$search.$options.needle,e||(o=this.session.getWordRange(o.start.row,o.start.column),e=this.session.getTextRange(o)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:o});var r=this.$search.find(this.session);return t.preventScroll?r:r?(this.revealRange(r,n),r):(t.backwards?o.start=o.end:o.end=o.start,void this.selection.setRange(o))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.$blockScrolling+=1,this.session.unfold(e),this.selection.setSelectionRange(e),this.$blockScrolling-=1;var i=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),t!==!1&&this.renderer.animateScrolling(i)},this.undo=function(){this.$blockScrolling++,this.session.getUndoManager().undo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.$blockScrolling++,this.session.getUndoManager().redo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy()},this.setAutoScrollEditorIntoView=function(e){if(e){var t,i=this,n=!1;this.$scrollAnchor||(this.$scrollAnchor=document.createElement("div"));var o=this.$scrollAnchor;o.style.cssText="position:absolute",this.container.insertBefore(o,this.container.firstChild);var r=this.on("changeSelection",function(){n=!0}),s=this.renderer.on("beforeRender",function(){n&&(t=i.renderer.container.getBoundingClientRect())}),a=this.renderer.on("afterRender",function(){if(n&&t&&(i.isFocused()||i.searchBox&&i.searchBox.isFocused())){var e=i.renderer,r=e.$cursorLayer.$pixelPos,s=e.layerConfig,a=r.top-s.offset;n=r.top>=0&&a+t.top<0?!0:r.top<s.height&&r.top+t.top+s.lineHeight>window.innerHeight?!1:null,null!=n&&(o.style.top=a+"px",o.style.left=r.left+"px",o.style.height=s.lineHeight+"px",o.scrollIntoView(n)),n=t=null}});this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.removeEventListener("changeSelection",r),this.renderer.removeEventListener("afterRender",a),this.renderer.removeEventListener("beforeRender",s))}}},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,n.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))}}).call(A.prototype),m.defineOptions(A.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(){this.$resetCursorStyle()},initialValue:!1},cursorStyle:{set:function(){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",showLineNumbers:"renderer",showGutter:"renderer",displayIndentGuides:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",tabSize:"session",wrap:"session",foldStyle:"session",mode:"session"}),t.Editor=A}),ace.define("ace/undomanager",["require","exports","module"],function(e,t){"use strict";var i=function(){this.reset()};(function(){this.execute=function(e){var t=e.args[0];this.$doc=e.args[1],e.merge&&this.hasUndo()&&(this.dirtyCounter--,t=this.$undoStack.pop().concat(t)),this.$undoStack.push(t),this.$redoStack=[],this.dirtyCounter<0&&(this.dirtyCounter=0/0),this.dirtyCounter++},this.undo=function(e){var t=this.$undoStack.pop(),i=null;return t&&(i=this.$doc.undoChanges(t,e),this.$redoStack.push(t),this.dirtyCounter--),i},this.redo=function(e){var t=this.$redoStack.pop(),i=null;return t&&(i=this.$doc.redoChanges(t,e),this.$undoStack.push(t),this.dirtyCounter++),i},this.reset=function(){this.$undoStack=[],this.$redoStack=[],this.dirtyCounter=0},this.hasUndo=function(){return this.$undoStack.length>0},this.hasRedo=function(){return this.$redoStack.length>0},this.markClean=function(){this.dirtyCounter=0},this.isClean=function(){return 0===this.dirtyCounter}}).call(i.prototype),t.UndoManager=i}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter"],function(e,t){"use strict";var i=e("../lib/dom"),n=e("../lib/oop"),o=e("../lib/lang"),r=e("../lib/event_emitter").EventEmitter,s=function(e){this.element=i.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$cells=[]};(function(){n.implement(this,r),this.setSession=function(e){this.session&&this.session.removeEventListener("change",this.$updateAnnotations),this.session=e,e&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var i=e[t],n=i.row,r=this.$annotations[n];r||(r=this.$annotations[n]={text:[]});var s=i.text;s=s?o.escapeHTML(s):i.html||"",-1===r.text.indexOf(s)&&r.text.push(s);var a=i.type;"error"==a?r.className=" ace_error":"warning"==a&&" ace_error"!=r.className?r.className=" ace_warning":"info"!=a||r.className||(r.className=" ace_info")}},this.$updateAnnotations=function(e){if(this.$annotations.length){var t=e.data,i=t.range,n=i.start.row,o=i.end.row-n;if(0===o);else if("removeText"==t.action||"removeLines"==t.action)this.$annotations.splice(n,o+1,null);else{var r=new Array(o+1);r.unshift(n,1),this.$annotations.splice.apply(this.$annotations,r)}}},this.update=function(e){for(var t=this.session,n=e.firstRow,o=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1),r=t.getNextFoldLine(n),s=r?r.start.row:1/0,a=this.$showFoldWidgets&&t.foldWidgets,l=t.$breakpoints,c=t.$decorations,h=t.$firstLineNumber,u=0,d=t.gutterRenderer||this.$renderer,g=null,f=-1,p=n;;){if(p>s&&(p=r.end.row+1,r=t.getNextFoldLine(p,r),s=r?r.start.row:1/0),p>o){for(;this.$cells.length>f+1;)g=this.$cells.pop(),this.element.removeChild(g.element);break}g=this.$cells[++f],g||(g={element:null,textNode:null,foldWidget:null},g.element=i.createElement("div"),g.textNode=document.createTextNode(""),g.element.appendChild(g.textNode),this.element.appendChild(g.element),this.$cells[f]=g);var m="ace_gutter-cell ";l[p]&&(m+=l[p]),c[p]&&(m+=c[p]),this.$annotations[p]&&(m+=this.$annotations[p].className),g.element.className!=m&&(g.element.className=m);var v=t.getRowLength(p)*e.lineHeight+"px";if(v!=g.element.style.height&&(g.element.style.height=v),a){var A=a[p];null==A&&(A=a[p]=t.getFoldWidget(p))}if(A){g.foldWidget||(g.foldWidget=i.createElement("span"),g.element.appendChild(g.foldWidget));var m="ace_fold-widget ace_"+A;m+="start"==A&&p==s&&p<r.end.row?" ace_closed":" ace_open",g.foldWidget.className!=m&&(g.foldWidget.className=m);var v=e.lineHeight+"px";g.foldWidget.style.height!=v&&(g.foldWidget.style.height=v)}else g.foldWidget&&(g.element.removeChild(g.foldWidget),g.foldWidget=null);var w=u=d?d.getText(t,p):p+h;w!=g.textNode.data&&(g.textNode.data=w),p++}this.element.style.height=e.minHeight+"px",(this.$fixedWidth||t.$useWrapMode)&&(u=t.getLength()+h);var C=d?d.getWidth(t,u,e):u.toString().length*e.characterWidth,E=this.$padding||this.$computePadding();C+=E.left+E.right,C===this.gutterWidth||isNaN(C)||(this.gutterWidth=C,this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._emit("changeGutterWidth",C))},this.$fixedWidth=!1,this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return""},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?i.addCssClass(this.element,"ace_folding-enabled"):i.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=i.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=parseInt(e.paddingLeft)+1||0,this.$padding.right=parseInt(e.paddingRight)||0,this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),i=this.element.getBoundingClientRect();return e.x<t.left+i.left?"markers":this.$showFoldWidgets&&e.x>i.right-t.right?"foldWidgets":void 0}}).call(s.prototype),t.Gutter=s}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(e,t){"use strict";var i=e("../range").Range,n=e("../lib/dom"),o=function(e){this.element=n.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)};(function(){this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.update=function(e){var e=e||this.config;if(e){this.config=e;var t=[];for(var i in this.markers){var n=this.markers[i];if(n.range){var o=n.range.clipRows(e.firstRow,e.lastRow);if(!o.isEmpty())if(o=o.toScreenRange(this.session),n.renderer){var r=this.$getTop(o.start.row,e),s=this.$padding+o.start.column*e.characterWidth;n.renderer(t,o,s,r,e)}else"fullLine"==n.type?this.drawFullLineMarker(t,o,n.clazz,e):"screenLine"==n.type?this.drawScreenLineMarker(t,o,n.clazz,e):o.isMultiLine()?"text"==n.type?this.drawTextMarker(t,o,n.clazz,e):this.drawMultiLineMarker(t,o,n.clazz,e):this.drawSingleLineMarker(t,o,n.clazz+" ace_start",e)}else n.update(t,this,this.session,e)}this.element.innerHTML=t.join("")}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(e,t,n,o,r){var s=t.start.row,a=new i(s,t.start.column,s,this.session.getScreenLastRowColumn(s));for(this.drawSingleLineMarker(e,a,n+" ace_start",o,1,r),s=t.end.row,a=new i(s,0,s,t.end.column),this.drawSingleLineMarker(e,a,n,o,0,r),s=t.start.row+1;s<t.end.row;s++)a.start.row=s,a.end.row=s,a.end.column=this.session.getScreenLastRowColumn(s),this.drawSingleLineMarker(e,a,n,o,1,r)},this.drawMultiLineMarker=function(e,t,i,n,o){var r=this.$padding,s=n.lineHeight,a=this.$getTop(t.start.row,n),l=r+t.start.column*n.characterWidth;o=o||"",e.push("<div class='",i," ace_start' style='","height:",s,"px;","right:0;","top:",a,"px;","left:",l,"px;",o,"'></div>"),a=this.$getTop(t.end.row,n);var c=t.end.column*n.characterWidth;e.push("<div class='",i,"' style='","height:",s,"px;","width:",c,"px;","top:",a,"px;","left:",r,"px;",o,"'></div>"),s=(t.end.row-t.start.row-1)*n.lineHeight,0>s||(a=this.$getTop(t.start.row+1,n),e.push("<div class='",i,"' style='","height:",s,"px;","right:0;","top:",a,"px;","left:",r,"px;",o,"'></div>"))},this.drawSingleLineMarker=function(e,t,i,n,o,r){var s=n.lineHeight,a=(t.end.column+(o||0)-t.start.column)*n.characterWidth,l=this.$getTop(t.start.row,n),c=this.$padding+t.start.column*n.characterWidth;e.push("<div class='",i,"' style='","height:",s,"px;","width:",a,"px;","top:",l,"px;","left:",c,"px;",r||"","'></div>")},this.drawFullLineMarker=function(e,t,i,n,o){var r=this.$getTop(t.start.row,n),s=n.lineHeight;t.start.row!=t.end.row&&(s+=this.$getTop(t.end.row,n)-r),e.push("<div class='",i,"' style='","height:",s,"px;","top:",r,"px;","left:0;right:0;",o||"","'></div>")},this.drawScreenLineMarker=function(e,t,i,n,o){var r=this.$getTop(t.start.row,n),s=n.lineHeight;e.push("<div class='",i,"' style='","height:",s,"px;","top:",r,"px;","left:0;right:0;",o||"","'></div>")}}).call(o.prototype),t.Marker=o}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],function(e,t){"use strict";var i=e("../lib/oop"),n=e("../lib/dom"),o=e("../lib/lang"),r=(e("../lib/useragent"),e("../lib/event_emitter").EventEmitter),s=function(e){this.element=n.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this)};(function(){i.implement(this,r),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="→",this.SPACE_CHAR="·",this.$padding=0,this.$updateEolChar=function(){var e="\n"==this.session.doc.getNewLineCharacter()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;return this.EOL_CHAR!=e?(this.EOL_CHAR=e,!0):void 0},this.setPadding=function(e){this.$padding=e,this.element.style.padding="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){this.session=e,e&&this.$computeTabString()},this.showInvisibles=!1,this.setShowInvisibles=function(e){return this.showInvisibles==e?!1:(this.showInvisibles=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides==e?!1:(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){var e=this.session.getTabSize();this.tabSize=e;for(var t=this.$tabStrings=[0],i=1;e+1>i;i++)t.push(this.showInvisibles?"<span class='ace_invisible ace_invisible_tab'>"+this.TAB_CHAR+o.stringRepeat(" ",i-1)+"</span>":o.stringRepeat(" ",i));if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;var n="ace_indent-guide",r="",s="";if(this.showInvisibles){n+=" ace_invisible",r=" ace_invisible_space",s=" ace_invisible_tab";var a=o.stringRepeat(this.SPACE_CHAR,this.tabSize),l=this.TAB_CHAR+o.stringRepeat(" ",this.tabSize-1)}else var a=o.stringRepeat(" ",this.tabSize),l=a;this.$tabStrings[" "]="<span class='"+n+r+"'>"+a+"</span>",this.$tabStrings["	"]="<span class='"+n+s+"'>"+l+"</span>"}},this.updateLines=function(e,t,i){(this.config.lastRow!=e.lastRow||this.config.firstRow!=e.firstRow)&&this.scrollLines(e),this.config=e;for(var n=Math.max(t,e.firstRow),o=Math.min(i,e.lastRow),r=this.element.childNodes,s=0,a=e.firstRow;n>a;a++){var l=this.session.getFoldLine(a);if(l){if(l.containsRow(n)){n=l.start.row;break}a=l.end.row}s++}for(var a=n,l=this.session.getNextFoldLine(a),c=l?l.start.row:1/0;;){if(a>c&&(a=l.end.row+1,l=this.session.getNextFoldLine(a,l),c=l?l.start.row:1/0),a>o)break;var h=r[s++];if(h){var u=[];this.$renderLine(u,a,!this.$useLineGroups(),a==c?l:!1),h.style.height=e.lineHeight*this.session.getRowLength(a)+"px",h.innerHTML=u.join("")}a++}},this.scrollLines=function(e){var t=this.config;if(this.config=e,!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);var i=this.element;if(t.firstRow<e.firstRow)for(var n=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);n>0;n--)i.removeChild(i.firstChild);if(t.lastRow>e.lastRow)for(var n=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);n>0;n--)i.removeChild(i.lastChild);if(e.firstRow<t.firstRow){var o=this.$renderLinesFragment(e,e.firstRow,t.firstRow-1);i.firstChild?i.insertBefore(o,i.firstChild):i.appendChild(o)}if(e.lastRow>t.lastRow){var o=this.$renderLinesFragment(e,t.lastRow+1,e.lastRow);i.appendChild(o)}},this.$renderLinesFragment=function(e,t,i){for(var o=this.element.ownerDocument.createDocumentFragment(),r=t,s=this.session.getNextFoldLine(r),a=s?s.start.row:1/0;;){if(r>a&&(r=s.end.row+1,s=this.session.getNextFoldLine(r,s),a=s?s.start.row:1/0),r>i)break;var l=n.createElement("div"),c=[];if(this.$renderLine(c,r,!1,r==a?s:!1),l.innerHTML=c.join(""),this.$useLineGroups())l.className="ace_line_group",o.appendChild(l),l.style.height=e.lineHeight*this.session.getRowLength(r)+"px";else for(;l.firstChild;)o.appendChild(l.firstChild);r++}return o},this.update=function(e){this.config=e;for(var t=[],i=e.firstRow,n=e.lastRow,o=i,r=this.session.getNextFoldLine(o),s=r?r.start.row:1/0;;){if(o>s&&(o=r.end.row+1,r=this.session.getNextFoldLine(o,r),s=r?r.start.row:1/0),o>n)break;this.$useLineGroups()&&t.push("<div class='ace_line_group' style='height:",e.lineHeight*this.session.getRowLength(o),"px'>"),this.$renderLine(t,o,!1,o==s?r:!1),this.$useLineGroups()&&t.push("</div>"),o++}this.element.innerHTML=t.join("")},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(e,t,i,n){var r=this,s=/\t|&|<|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\u3000\uFEFF])|[\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3000-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]/g,a=function(e,i,n,s){if(i)return r.showInvisibles?"<span class='ace_invisible ace_invisible_space'>"+o.stringRepeat(r.SPACE_CHAR,e.length)+"</span>":o.stringRepeat(" ",e.length);if("&"==e)return"&#38;";if("<"==e)return"&#60;";if("	"==e){var a=r.session.getScreenTabSize(t+s);return t+=a-1,r.$tabStrings[a]}if("　"==e){var l=r.showInvisibles?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",c=r.showInvisibles?r.SPACE_CHAR:"";return t+=1,"<span class='"+l+"' style='width:"+2*r.config.characterWidth+"px'>"+c+"</span>"}return n?"<span class='ace_invisible ace_invisible_space ace_invalid'>"+r.SPACE_CHAR+"</span>":(t+=1,"<span class='ace_cjk' style='width:"+2*r.config.characterWidth+"px'>"+e+"</span>")},l=n.replace(s,a);if(this.$textToken[i.type])e.push(l);else{var c="ace_"+i.type.replace(/\./g," ace_"),h="";"fold"==i.type&&(h=" style='width:"+i.value.length*this.config.characterWidth+"px;' "),e.push("<span class='",c,"'",h,">",l,"</span>")}return t+n.length},this.renderIndentGuide=function(e,t,i){var n=t.search(this.$indentGuideRe);return 0>=n||n>=i?t:" "==t[0]?(n-=n%this.tabSize,e.push(o.stringRepeat(this.$tabStrings[" "],n/this.tabSize)),t.substr(n)):"	"==t[0]?(e.push(o.stringRepeat(this.$tabStrings["	"],n)),t.substr(n)):t},this.$renderWrappedLine=function(e,t,i,n){for(var o=0,r=0,s=i[0],a=0,l=0;l<t.length;l++){var c=t[l],h=c.value;if(0==l&&this.displayIndentGuides){if(o=h.length,h=this.renderIndentGuide(e,h,s),!h)continue;o-=h.length}if(o+h.length<s)a=this.$renderToken(e,a,c,h),o+=h.length;else{for(;o+h.length>=s;)a=this.$renderToken(e,a,c,h.substring(0,s-o)),h=h.substring(s-o),o=s,n||e.push("</div>","<div class='ace_line' style='height:",this.config.lineHeight,"px'>"),r++,a=0,s=i[r]||Number.MAX_VALUE;0!=h.length&&(o+=h.length,a=this.$renderToken(e,a,c,h))}}},this.$renderSimpleLine=function(e,t){var i=0,n=t[0],o=n.value;this.displayIndentGuides&&(o=this.renderIndentGuide(e,o)),o&&(i=this.$renderToken(e,i,n,o));for(var r=1;r<t.length;r++)n=t[r],o=n.value,i=this.$renderToken(e,i,n,o)},this.$renderLine=function(e,t,i,n){if(n||0==n||(n=this.session.getFoldLine(t)),n)var o=this.$getFoldLineTokens(t,n);else var o=this.session.getTokens(t);if(i||e.push("<div class='ace_line' style='height:",this.config.lineHeight*(this.$useLineGroups()?1:this.session.getRowLength(t)),"px'>"),o.length){var r=this.session.getRowSplitData(t);r&&r.length?this.$renderWrappedLine(e,o,r,i):this.$renderSimpleLine(e,o)}this.showInvisibles&&(n&&(t=n.end.row),e.push("<span class='ace_invisible ace_invisible_eol'>",t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,"</span>")),i||e.push("</div>")},this.$getFoldLineTokens=function(e,t){function i(e,t,i){for(var n=0,r=0;r+e[n].value.length<t;)if(r+=e[n].value.length,n++,n==e.length)return;if(r!=t){var s=e[n].value.substring(t-r);s.length>i-t&&(s=s.substring(0,i-t)),o.push({type:e[n].type,value:s}),r=t+s.length,n+=1}for(;i>r&&n<e.length;){var s=e[n].value;

o.push(s.length+r>i?{type:e[n].type,value:s.substring(0,i-r)}:e[n]),r+=s.length,n+=1}}var n=this.session,o=[],r=n.getTokens(e);return t.walk(function(e,t,s,a,l){null!=e?o.push({type:"fold",value:e}):(l&&(r=n.getTokens(t)),r.length&&i(r,a,s))},t.end.row,this.session.getLine(t.end.row).length),o},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$measureNode&&this.$measureNode.parentNode.removeChild(this.$measureNode),delete this.$measureNode}}).call(s.prototype),t.Text=s}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(e,t){"use strict";var i,n=e("../lib/dom"),o=function(e){this.element=n.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),void 0===i&&(i="opacity"in this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),n.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateVisibility.bind(this)};(function(){this.$updateVisibility=function(e){for(var t=this.cursors,i=t.length;i--;)t[i].style.visibility=e?"":"hidden"},this.$updateOpacity=function(e){for(var t=this.cursors,i=t.length;i--;)t[i].style.opacity=e?"":"0"},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e==this.smoothBlinking||i||(this.smoothBlinking=e,n.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.$updateCursors=(e?this.$updateOpacity:this.$updateVisibility).bind(this),this.restartTimer())},this.addCursor=function(){var e=n.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){if(this.cursors.length>1){var e=this.cursors.pop();return e.parentNode.removeChild(e),e}},this.hideCursor=function(){this.isVisible=!1,n.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,n.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e=this.$updateCursors;if(clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.smoothBlinking&&n.removeCssClass(this.element,"ace_smooth-blinking"),e(!0),this.isBlinking&&this.blinkInterval&&this.isVisible){this.smoothBlinking&&setTimeout(function(){n.addCssClass(this.element,"ace_smooth-blinking")}.bind(this));var t=function(){this.timeoutId=setTimeout(function(){e(!1)},.6*this.blinkInterval)}.bind(this);this.intervalId=setInterval(function(){e(!0),t()},this.blinkInterval),t()}},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e||(e=this.session.selection.getCursor());var i=this.session.documentToScreenPosition(e),n=this.$padding+i.column*this.config.characterWidth,o=(i.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight;return{left:n,top:o}},this.update=function(e){this.config=e;var t=this.session.$selectionMarkers,i=0,n=0;(void 0===t||0===t.length)&&(t=[{cursor:null}]);for(var i=0,o=t.length;o>i;i++){var r=this.getPixelPosition(t[i].cursor,!0);if(!((r.top>e.height+e.offset||r.top<0)&&i>1)){var s=(this.cursors[n++]||this.addCursor()).style;s.left=r.left+"px",s.top=r.top+"px",s.width=e.characterWidth+"px",s.height=e.lineHeight+"px"}}for(;this.cursors.length>n;)this.removeCursor();var a=this.session.getOverwrite();this.$setOverwrite(a),this.$pixelPos=r,this.restartTimer()},this.$setOverwrite=function(e){e!=this.overwrite&&(this.overwrite=e,e?n.addCssClass(this.element,"ace_overwrite-cursors"):n.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(o.prototype),t.Cursor=o}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t){"use strict";var i=e("./lib/oop"),n=e("./lib/dom"),o=e("./lib/event"),r=e("./lib/event_emitter").EventEmitter,s=function(e){this.element=n.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=n.createElement("div"),this.inner.className="ace_scrollbar-inner",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,o.addListener(this.element,"scroll",this.onScroll.bind(this)),o.addListener(this.element,"mousedown",o.preventDefault)};(function(){i.implement(this,r),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e}}).call(s.prototype);var a=function(e,t){s.call(this,e),this.scrollTop=0,t.$scrollbarWidth=this.width=n.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px"};i.inherits(a,s),function(){this.classSuffix="-v",this.onScroll=function(){this.skipEvent||(this.scrollTop=this.element.scrollTop,this._emit("scroll",{data:this.scrollTop})),this.skipEvent=!1},this.getWidth=function(){return this.isVisible?this.width:0},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=function(e){this.inner.style.height=e+"px"},this.setScrollHeight=function(e){this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=this.element.scrollTop=e)}}.call(a.prototype);var l=function(e,t){s.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"};i.inherits(l,s),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(l.prototype),t.ScrollBar=a,t.ScrollBarV=a,t.ScrollBarH=l,t.VScrollBar=a,t.HScrollBar=l}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(e,t){"use strict";var i=e("./lib/event"),n=function(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.window=t||window};(function(){this.schedule=function(e){if(this.changes=this.changes|e,!this.pending&&this.changes){this.pending=!0;var t=this;i.nextFrame(function(){t.pending=!1;for(var e;e=t.changes;)t.changes=0,t.onRender(e)},this.window)}}}).call(n.prototype),t.RenderLoop=n}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],function(e,t){var i=e("../lib/oop"),n=e("../lib/dom"),o=e("../lib/lang"),r=e("../lib/useragent"),s=e("../lib/event_emitter").EventEmitter,a=0,l=t.FontMetrics=function(e){this.el=n.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=n.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=n.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),a||this.$testFractionalRect(),this.$measureNode.innerHTML=o.stringRepeat("X",a),this.$characterSize={width:0,height:0},this.checkForSizeChanges()};(function(){i.implement(this,s),this.$characterSize={width:0,height:0},this.$testFractionalRect=function(){var e=n.createElement("div");this.$setMeasureNodeStyles(e.style),e.style.width="0.2px",document.documentElement.appendChild(e);var t=e.getBoundingClientRect().width;a=t>0&&1>t?50:100,e.parentNode.removeChild(e)},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="-100px",e.visibility="hidden",e.position="fixed",e.whiteSpace="pre",r.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(){var e=this.$measureSizes();if(e&&(this.$characterSize.width!==e.width||this.$characterSize.height!==e.height)){this.$measureNode.style.fontWeight="bold";var t=this.$measureSizes();this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e})}},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer)return this.$pollSizeChangesTimer;var e=this;return this.$pollSizeChangesTimer=setInterval(function(){e.checkForSizeChanges()},500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&this.$pollSizeChangesTimer},this.$measureSizes=function(){if(50===a){var e=null;try{e=this.$measureNode.getBoundingClientRect()}catch(t){e={width:0,height:0}}var i={height:e.height,width:e.width/a}}else var i={height:this.$measureNode.clientHeight,width:this.$measureNode.clientWidth/a};return 0===i.width||0===i.height?null:i},this.$measureCharWidth=function(e){this.$main.innerHTML=o.stringRepeat(e,a);var t=this.$main.getBoundingClientRect();return t.width/a},this.getCharacterWidth=function(e){var t=this.charSizes[e];return void 0===t&&(this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width),t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)}}).call(l.prototype)}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/lib/useragent","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter"],function(e,t){"use strict";var i=e("./lib/oop"),n=e("./lib/dom"),o=e("./config"),r=e("./lib/useragent"),s=e("./layer/gutter").Gutter,a=e("./layer/marker").Marker,l=e("./layer/text").Text,c=e("./layer/cursor").Cursor,h=e("./scrollbar").HScrollBar,u=e("./scrollbar").VScrollBar,d=e("./renderloop").RenderLoop,g=e("./layer/font_metrics").FontMetrics,f=e("./lib/event_emitter").EventEmitter,p='.ace_editor {	position: relative;	overflow: hidden;	font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;	direction: ltr;	}	.ace_scroller {	position: absolute;	overflow: hidden;	top: 0;	bottom: 0;	background-color: inherit;	-ms-user-select: none;	-moz-user-select: none;	-webkit-user-select: none;	user-select: none;	cursor: text;	}	.ace_content {	position: absolute;	-moz-box-sizing: border-box;	-webkit-box-sizing: border-box;	box-sizing: border-box;	min-width: 100%;	}	.ace_dragging .ace_scroller:before{	position: absolute;	top: 0;	left: 0;	right: 0;	bottom: 0;	content: \'\';	background: rgba(250, 250, 250, 0.01);	z-index: 1000;	}	.ace_dragging.ace_dark .ace_scroller:before{	background: rgba(0, 0, 0, 0.01);	}	.ace_selecting, .ace_selecting * {	cursor: text !important;	}	.ace_gutter {	position: absolute;	overflow : hidden;	width: auto;	top: 0;	bottom: 0;	left: 0;	cursor: default;	z-index: 4;	-ms-user-select: none;	-moz-user-select: none;	-webkit-user-select: none;	user-select: none;	}	.ace_gutter-active-line {	position: absolute;	left: 0;	right: 0;	}	.ace_scroller.ace_scroll-left {	box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;	}	.ace_gutter-cell {	padding-left: 19px;	padding-right: 6px;	background-repeat: no-repeat;	}	.ace_gutter-cell.ace_error {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");	background-repeat: no-repeat;	background-position: 2px center;	}	.ace_gutter-cell.ace_warning {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");	background-position: 2px center;	}	.ace_gutter-cell.ace_info {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");	background-position: 2px center;	}	.ace_dark .ace_gutter-cell.ace_info {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");	}	.ace_scrollbar {	position: absolute;	right: 0;	bottom: 0;	z-index: 6;	}	.ace_scrollbar-inner {	position: absolute;	cursor: text;	left: 0;	top: 0;	}	.ace_scrollbar-v{	overflow-x: hidden;	overflow-y: scroll;	top: 0;	}	.ace_scrollbar-h {	overflow-x: scroll;	overflow-y: hidden;	left: 0;	}	.ace_print-margin {	position: absolute;	height: 100%;	}	.ace_text-input {	position: absolute;	z-index: 0;	width: 0.5em;	height: 1em;	opacity: 0;	background: transparent;	-moz-appearance: none;	appearance: none;	border: none;	resize: none;	outline: none;	overflow: hidden;	font: inherit;	padding: 0 1px;	margin: 0 -1px;	text-indent: -1em;	-ms-user-select: text;	-moz-user-select: text;	-webkit-user-select: text;	user-select: text;	}	.ace_text-input.ace_composition {	background: inherit;	color: inherit;	z-index: 1000;	opacity: 1;	text-indent: 0;	}	.ace_layer {	z-index: 1;	position: absolute;	overflow: hidden;	white-space: pre;	height: 100%;	width: 100%;	-moz-box-sizing: border-box;	-webkit-box-sizing: border-box;	box-sizing: border-box;	pointer-events: none;	}	.ace_gutter-layer {	position: relative;	width: auto;	text-align: right;	pointer-events: auto;	}	.ace_text-layer {	font: inherit !important;	}	.ace_cjk {	display: inline-block;	text-align: center;	}	.ace_cursor-layer {	z-index: 4;	}	.ace_cursor {	z-index: 4;	position: absolute;	-moz-box-sizing: border-box;	-webkit-box-sizing: border-box;	box-sizing: border-box;	border-left: 2px solid	}	.ace_slim-cursors .ace_cursor {	border-left-width: 1px;	}	.ace_overwrite-cursors .ace_cursor {	border-left-width: 0;	border-bottom: 1px solid;	}	.ace_hidden-cursors .ace_cursor {	opacity: 0.2;	}	.ace_smooth-blinking .ace_cursor {	-webkit-transition: opacity 0.18s;	transition: opacity 0.18s;	}	.ace_editor.ace_multiselect .ace_cursor {	border-left-width: 1px;	}	.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {	position: absolute;	z-index: 3;	}	.ace_marker-layer .ace_selection {	position: absolute;	z-index: 5;	}	.ace_marker-layer .ace_bracket {	position: absolute;	z-index: 6;	}	.ace_marker-layer .ace_active-line {	position: absolute;	z-index: 2;	}	.ace_marker-layer .ace_selected-word {	position: absolute;	z-index: 4;	-moz-box-sizing: border-box;	-webkit-box-sizing: border-box;	box-sizing: border-box;	}	.ace_line .ace_fold {	-moz-box-sizing: border-box;	-webkit-box-sizing: border-box;	box-sizing: border-box;	display: inline-block;	height: 11px;	margin-top: -2px;	vertical-align: middle;	background-image:	url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),	url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");	background-repeat: no-repeat, repeat-x;	background-position: center center, top left;	color: transparent;	border: 1px solid black;	border-radius: 2px;	cursor: pointer;	pointer-events: auto;	}	.ace_dark .ace_fold {	}	.ace_fold:hover{	background-image:	url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),	url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");	}	.ace_tooltip {	background-color: #FFF;	background-image: -webkit-linear-gradient(top, transparent, rgba(0, 0, 0, 0.1));	background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));	border: 1px solid gray;	border-radius: 1px;	box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);	color: black;	max-width: 100%;	padding: 3px 4px;	position: fixed;	z-index: 999999;	-moz-box-sizing: border-box;	-webkit-box-sizing: border-box;	box-sizing: border-box;	cursor: default;	white-space: pre;	word-wrap: break-word;	line-height: normal;	font-style: normal;	font-weight: normal;	letter-spacing: normal;	pointer-events: none;	}	.ace_folding-enabled > .ace_gutter-cell {	padding-right: 13px;	}	.ace_fold-widget {	-moz-box-sizing: border-box;	-webkit-box-sizing: border-box;	box-sizing: border-box;	margin: 0 -12px 0 1px;	display: none;	width: 11px;	vertical-align: top;	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");	background-repeat: no-repeat;	background-position: center;	border-radius: 3px;	border: 1px solid transparent;	cursor: pointer;	}	.ace_folding-enabled .ace_fold-widget {	display: inline-block;   	}	.ace_fold-widget.ace_end {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");	}	.ace_fold-widget.ace_closed {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");	}	.ace_fold-widget:hover {	border: 1px solid rgba(0, 0, 0, 0.3);	background-color: rgba(255, 255, 255, 0.2);	box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);	}	.ace_fold-widget:active {	border: 1px solid rgba(0, 0, 0, 0.4);	background-color: rgba(0, 0, 0, 0.05);	box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);	}	.ace_dark .ace_fold-widget {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");	}	.ace_dark .ace_fold-widget.ace_end {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");	}	.ace_dark .ace_fold-widget.ace_closed {	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");	}	.ace_dark .ace_fold-widget:hover {	box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);	background-color: rgba(255, 255, 255, 0.1);	}	.ace_dark .ace_fold-widget:active {	box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);	}	.ace_fold-widget.ace_invalid {	background-color: #FFB4B4;	border-color: #DE5555;	}	.ace_fade-fold-widgets .ace_fold-widget {	-webkit-transition: opacity 0.4s ease 0.05s;	transition: opacity 0.4s ease 0.05s;	opacity: 0;	}	.ace_fade-fold-widgets:hover .ace_fold-widget {	-webkit-transition: opacity 0.05s ease 0.05s;	transition: opacity 0.05s ease 0.05s;	opacity:1;	}	.ace_underline {	text-decoration: underline;	}	.ace_bold {	font-weight: bold;	}	.ace_nobold .ace_bold {	font-weight: normal;	}	.ace_italic {	font-style: italic;	}	.ace_error-marker {	background-color: rgba(255, 0, 0,0.2);	position: absolute;	z-index: 9;	}	.ace_highlight-marker {	background-color: rgba(255, 255, 0,0.2);	position: absolute;	z-index: 8;	}	';n.importCssString(p,"ace_editor");var m=function(e,t){var i=this;this.container=e||n.createElement("div"),this.$keepTextAreaAtCursor=!r.isOldIE,n.addCssClass(this.container,"ace_editor"),this.setTheme(t),this.$gutter=n.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.scroller=n.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=n.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new s(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new a(this.content);var f=this.$textLayer=new l(this.content);this.canvas=f.element,this.$markerFront=new a(this.content),this.$cursorLayer=new c(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new u(this.container,this),this.scrollBarH=new h(this.container,this),this.scrollBarV.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollTop(e.data-i.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollLeft(e.data-i.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new g(this.container,500),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.addEventListener("changeCharacterSize",function(e){i.updateCharacterSize(),i.onResize(!0,i.gutterWidth,i.$size.width,i.$size.height),i._signal("changeCharacterSize",e)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$loop=new d(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),o.resetOptions(this),o._emit("renderer",this)};(function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,i.implement(this,f),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin()},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),this.session=e,e&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,i){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!i)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar()},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,i,n){if(!(this.resizing>2)){this.resizing>0?this.resizing++:this.resizing=e?1:0;var o=this.container;n||(n=o.clientHeight||o.scrollHeight),i||(i=o.clientWidth||o.scrollWidth);var r=this.$updateCachedSize(e,t,i,n);if(!this.$size.scrollerHeight||!i&&!n)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(r|this.$changes,!0):this.$loop.schedule(r|this.$changes),this.resizing&&(this.resizing=0)}},this.$updateCachedSize=function(e,t,i,n){n-=this.$extraHeight||0;var o=0,r=this.$size,s={width:r.width,height:r.height,scrollerHeight:r.scrollerHeight,scrollerWidth:r.scrollerWidth};return n&&(e||r.height!=n)&&(r.height=n,o|=this.CHANGE_SIZE,r.scrollerHeight=r.height,this.$horizScroll&&(r.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",o|=this.CHANGE_SCROLL),i&&(e||r.width!=i)&&(o|=this.CHANGE_SIZE,r.width=i,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,this.scrollBarH.element.style.left=this.scroller.style.left=t+"px",r.scrollerWidth=Math.max(0,i-t-this.scrollBarV.getWidth()),this.scrollBarH.element.style.right=this.scroller.style.right=this.scrollBarV.getWidth()+"px",this.scroller.style.bottom=this.scrollBarH.getHeight()+"px",(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(o|=this.CHANGE_FULL)),r.$dirty=!i||!n,o&&this._signal("resize",s),o},this.onGutterResize=function(){var e=this.$showGutter?this.$gutter.offsetWidth:0;e!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,e,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()?this.$loop.schedule(this.CHANGE_FULL):this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):(this.$computeLayerConfig(),this.$loop.schedule(this.CHANGE_MARKER))},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,t=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(t,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updateGutterLineHighlight=function(){var e=this.$cursorLayer.$pixelPos,t=this.layerConfig.lineHeight;if(this.session.getUseWrapMode()){var i=this.session.selection.getCursor();i.column=0,e=this.$cursorLayer.getPixelPosition(i,!0),t*=this.session.getRowLength(i.row)}this.$gutterLineHighlight.style.top=e.top-this.layerConfig.offset+"px",this.$gutterLineHighlight.style.height=t+"px"},this.$updatePrintMargin=function(){if(this.$showPrintMargin||this.$printMarginEl){if(!this.$printMarginEl){var e=n.createElement("div");e.className="ace_layer ace_print-margin-layer",this.$printMarginEl=n.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)}var t=this.$printMarginEl.style;t.left=this.characterWidth*this.$printMarginColumn+this.$padding+"px",t.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit()}},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.content},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){if(this.$keepTextAreaAtCursor){var e=this.layerConfig,t=this.$cursorLayer.$pixelPos.top,i=this.$cursorLayer.$pixelPos.left;t-=e.offset;var n=this.lineHeight;if(!(0>t||t>e.height-n)){var o=this.characterWidth;if(this.$composition){var r=this.textarea.value.replace(/^\x01+/,"");o*=this.session.$getStringScreenWidth(r)[0]+2,n+=2}i-=this.scrollLeft,i>this.$size.scrollerWidth-o&&(i=this.$size.scrollerWidth-o),i+=this.gutterWidth,this.textarea.style.height=n+"px",this.textarea.style.width=o+"px",this.textarea.style.left=Math.min(i,this.$size.scrollerWidth-o)+"px",this.textarea.style.top=Math.min(t,this.$size.height-n)+"px"}}},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=Math.floor((this.layerConfig.height+this.layerConfig.offset)/this.layerConfig.lineHeight);return this.layerConfig.firstRow-1+e},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,i,n){var o=this.scrollMargin;o.top=0|e,o.bottom=0|t,o.right=0|n,o.left=0|i,o.v=o.top+o.bottom,o.h=o.left+o.right,o.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-o.top),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){
this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),!this.session||!this.container.offsetWidth||this.$frozen||!e&&!t)return void(this.$changes|=e);if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender");var i=this.layerConfig;if(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL){if(e|=this.$computeLayerConfig(),i.firstRow!=this.layerConfig.firstRow&&i.firstRowScreen==this.layerConfig.firstRowScreen){var n=this.scrollTop+(i.firstRow-this.layerConfig.firstRow)*this.lineHeight;n>0&&(this.scrollTop=n,e|=this.CHANGE_SCROLL,e|=this.$computeLayerConfig())}i=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),this.$gutterLayer.element.style.marginTop=-i.offset+"px",this.content.style.marginTop=-i.offset+"px",this.content.style.width=i.width+2*this.$padding+"px",this.content.style.height=i.minHeight+"px"}return e&this.CHANGE_H_SCROLL&&(this.content.style.marginLeft=-this.scrollLeft+"px",this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL?(this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),void this._signal("afterRender")):e&this.CHANGE_SCROLL?(e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(i):this.$textLayer.scrollLines(i),this.$showGutter&&this.$gutterLayer.update(i),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),this.$moveTextAreaToCursor(),void this._signal("afterRender")):(e&this.CHANGE_TEXT?(this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(i):(e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER)&&this.$showGutter&&this.$gutterLayer.update(i),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(i),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(i),void this._signal("afterRender"))},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,i=Math.max((this.$minLines||1)*this.lineHeight,Math.min(t,e))+this.scrollMargin.v+(this.$extraHeight||0),n=e>t;if(i!=this.desiredHeight||this.$size.height!=this.desiredHeight||n!=this.$vScroll){n!=this.$vScroll&&(this.$vScroll=n,this.scrollBarV.setVisible(n));var o=this.container.clientWidth;this.container.style.height=i+"px",this.$updateCachedSize(!0,this.$gutterWidth,o,i),this.desiredHeight=i,this._signal("autosize")}},this.$computeLayerConfig=function(){this.$maxLines&&this.lineHeight>1&&this.$autosize();var e=this.session,t=this.$size,i=t.height<=2*this.lineHeight,n=this.session.getScreenLength(),o=n*this.lineHeight,r=this.scrollTop%this.lineHeight,s=t.scrollerHeight+this.lineHeight,a=this.$getLongestLine(),l=!i&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-a-2*this.$padding<0),c=this.$horizScroll!==l;c&&(this.$horizScroll=l,this.scrollBarH.setVisible(l));var h=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;o+=h,this.session.setScrollTop(Math.max(-this.scrollMargin.top,Math.min(this.scrollTop,o-t.scrollerHeight+this.scrollMargin.bottom))),this.session.setScrollLeft(Math.max(-this.scrollMargin.left,Math.min(this.scrollLeft,a+2*this.$padding-t.scrollerWidth+this.scrollMargin.right)));var u=!i&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-o+h<0||this.scrollTop),d=this.$vScroll!==u;d&&(this.$vScroll=u,this.scrollBarV.setVisible(u));var g,f,p=Math.ceil(s/this.lineHeight)-1,m=Math.max(0,Math.round((this.scrollTop-r)/this.lineHeight)),v=m+p,A=this.lineHeight;m=e.screenToDocumentRow(m,0);var w=e.getFoldLine(m);w&&(m=w.start.row),g=e.documentToScreenRow(m,0),f=e.getRowLength(m)*A,v=Math.min(e.screenToDocumentRow(v,0),e.getLength()-1),s=t.scrollerHeight+e.getRowLength(v)*A+f,r=this.scrollTop-g*A;var C=0;return this.layerConfig.width!=a&&(C=this.CHANGE_H_SCROLL),(c||d)&&(C=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),d&&(a=this.$getLongestLine())),this.layerConfig={width:a,padding:this.$padding,firstRow:m,firstRowScreen:g,lastRow:v,lineHeight:A,characterWidth:this.characterWidth,minHeight:s,maxHeight:o,offset:r,gutterOffset:Math.max(0,Math.ceil((r+t.height-t.scrollerHeight)/A)),height:this.$size.scrollerHeight},C},this.$updateLines=function(){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow;this.$changedLines=null;var i=this.layerConfig;return e>i.lastRow+1||t<i.firstRow?void 0:t===1/0?(this.$showGutter&&this.$gutterLayer.update(i),void this.$textLayer.update(i)):(this.$textLayer.updateLines(i,e,t),!0)},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,i){this.scrollCursorIntoView(e,i),this.scrollCursorIntoView(t,i)},this.scrollCursorIntoView=function(e,t,i){if(0!==this.$size.scrollerHeight){var n=this.$cursorLayer.getPixelPosition(e),o=n.left,r=n.top,s=i&&i.top||0,a=i&&i.bottom||0,l=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;l+s>r?(t&&(r-=t*this.$size.scrollerHeight),0===r&&(r=-this.scrollMargin.top),this.session.setScrollTop(r)):l+this.$size.scrollerHeight-a<r+this.lineHeight&&(t&&(r+=t*this.$size.scrollerHeight),this.session.setScrollTop(r+this.lineHeight-this.$size.scrollerHeight));var c=this.scrollLeft;c>o?(o<this.$padding+2*this.layerConfig.characterWidth&&(o=-this.scrollMargin.left),this.session.setScrollLeft(o)):c+this.$size.scrollerWidth<o+this.characterWidth?this.session.setScrollLeft(Math.round(o+this.characterWidth-this.$size.scrollerWidth)):c<=this.$padding&&o-c<this.characterWidth&&this.session.setScrollLeft(0)}},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){"number"==typeof e&&(e={row:e,column:0});var i=this.$cursorLayer.getPixelPosition(e),n=this.$size.scrollerHeight-this.lineHeight,o=i.top-n*(t||0);return this.session.setScrollTop(o),o},this.STEPS=8,this.$calcSteps=function(e,t){var i=0,n=this.STEPS,o=[],r=function(e,t,i){return i*(Math.pow(e-1,3)+1)+t};for(i=0;n>i;++i)o.push(r(i/this.STEPS,e,t-e));return o},this.scrollToLine=function(e,t,i,n){var o=this.$cursorLayer.getPixelPosition({row:e,column:0}),r=o.top;t&&(r-=this.$size.scrollerHeight/2);var s=this.scrollTop;this.session.setScrollTop(r),i!==!1&&this.animateScrolling(s,n)},this.animateScrolling=function(e,t){var i=this.scrollTop;if(this.$animatedScroll){var n=this;if(e!=i){if(this.$scrollAnimation){var o=this.$scrollAnimation.steps;if(o.length&&(e=o[0],e==i))return}var r=n.$calcSteps(e,i);this.$scrollAnimation={from:e,to:i,steps:r},clearInterval(this.$timer),n.session.setScrollTop(r.shift()),n.session.$scrollTop=i,this.$timer=setInterval(function(){r.length?(n.session.setScrollTop(r.shift()),n.session.$scrollTop=i):null!=i?(n.session.$scrollTop=-1,n.session.setScrollTop(i),i=null):(n.$timer=clearInterval(n.$timer),n.$scrollAnimation=null,t&&t())},10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(t)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return 0>t&&this.session.getScrollTop()>=1-this.scrollMargin.top?!0:t>0&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom?!0:0>e&&this.session.getScrollLeft()>=1-this.scrollMargin.left?!0:e>0&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right?!0:void 0},this.pixelToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=(e+this.scrollLeft-i.left-this.$padding)/this.characterWidth,o=Math.floor((t+this.scrollTop-i.top)/this.lineHeight),r=Math.round(n);return{row:o,column:r,side:n-r>0?1:-1}},this.screenToTextCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=Math.round((e+this.scrollLeft-i.left-this.$padding)/this.characterWidth),o=(t+this.scrollTop-i.top)/this.lineHeight;return this.session.screenToDocumentPosition(o,Math.max(n,0))},this.textToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=this.session.documentToScreenPosition(e,t),o=this.$padding+Math.round(n.column*this.characterWidth),r=n.row*this.lineHeight;return{pageX:i.left+o-this.scrollLeft,pageY:i.top+r-this.scrollTop}},this.visualizeFocus=function(){n.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){n.removeCssClass(this.container,"ace_focus")},this.showComposition=function(){this.$composition||(this.$composition={keepTextAreaAtCursor:this.$keepTextAreaAtCursor,cssText:this.textarea.style.cssText}),this.$keepTextAreaAtCursor=!0,n.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor()},this.setCompositionText=function(){this.$moveTextAreaToCursor()},this.hideComposition=function(){this.$composition&&(n.removeCssClass(this.textarea,"ace_composition"),this.$keepTextAreaAtCursor=this.$composition.keepTextAreaAtCursor,this.textarea.style.cssText=this.$composition.cssText,this.$composition=null)},this.setTheme=function(e,t){function i(i){if(r.$themeId!=e)return t&&t();if(i.cssClass){n.importCssString(i.cssText,i.cssClass,r.container.ownerDocument),r.theme&&n.removeCssClass(r.container,r.theme.cssClass);var o="padding"in i?i.padding:"padding"in(r.theme||{})?4:r.$padding;r.$padding&&o!=r.$padding&&r.setPadding(o),r.$theme=i.cssClass,r.theme=i,n.addCssClass(r.container,i.cssClass),n.setCssClass(r.container,"ace_dark",i.isDark),r.$size&&(r.$size.width=0,r.$updateSizeAsync()),r._dispatchEvent("themeLoaded",{theme:i}),t&&t()}}var r=this;if(this.$themeId=e,r._dispatchEvent("themeChange",{theme:e}),e&&"string"!=typeof e)i(e);else{var s=e||this.$options.theme.initialValue;o.loadModule(["theme",s],i)}},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){n.setCssClass(this.container,e,t!==!1)},this.unsetStyle=function(e){n.removeCssClass(this.container,e)},this.setCursorStyle=function(e){this.scroller.style.cursor!=e&&(this.scroller.style.cursor=e)},this.setMouseCursor=function(e){this.scroller.style.cursor=e},this.destroy=function(){this.$textLayer.destroy(),this.$cursorLayer.destroy()}}).call(m.prototype),o.defineOptions(m.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){n.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e)},initialValue:!0},showLineNumbers:{set:function(e){this.$gutterLayer.setShowLineNumbers(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){return this.$gutterLineHighlight?(this.$gutterLineHighlight.style.display=e?"":"none",void(this.$cursorLayer.$pixelPos&&this.$updateGutterLineHighlight())):(this.$gutterLineHighlight=n.createElement("div"),this.$gutterLineHighlight.className="ace_gutter-active-line",void this.$gutter.appendChild(this.$gutterLineHighlight))},initialValue:!1,value:!0},hScrollBarAlwaysVisible:{set:function(){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(){this.updateFull()}},minLines:{set:function(){this.updateFull()}},scrollPastEnd:{set:function(e){e=+e||0,this.$scrollPastEnd!=e&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0}}),t.VirtualRenderer=m}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(e,t){"use strict";var n=e("../lib/oop"),o=e("../lib/net"),r=e("../lib/event_emitter").EventEmitter,s=e("../config"),a=function(t,n,o,r){if(this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),e.nameToUrl&&!e.toUrl&&(e.toUrl=e.nameToUrl),s.get("packaged")||!e.toUrl)r=r||s.moduleUrl(n.id,"worker");else{var a=this.$normalizePath;r=r||a(e.toUrl("ace/worker/worker.js",null,"_"));var l={};t.forEach(function(t){l[t]=a(e.toUrl(t,null,"_").replace(/(\.js)?(\?.*)?$/,""))})}try{var c=n.src,h=i(19),u=new h([c],{type:"application/javascript"}),d=(window.URL||window.webkitURL).createObjectURL(u);this.$worker=new Worker(d)}catch(g){if(!(g instanceof window.DOMException))throw g;var u=this.$workerBlob(r),f=window.URL||window.webkitURL,p=f.createObjectURL(u);this.$worker=new Worker(p),f.revokeObjectURL(p)}this.$worker.postMessage({init:!0,tlns:l,module:n.id,classname:o}),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage};(function(){n.implement(this,r),this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var i=this.callbacks[t.id];i&&(i(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return o.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,i){if(i){var n=this.callbackId++;this.callbacks[n]=i,t.push(n)}this.send(e,t)},this.emit=function(e,t){try{this.$worker.postMessage({event:e,data:{data:t.data}})}catch(i){console.error(i.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue?this.deltaQueue.push(e.data):(this.deltaQueue=[e.data],setTimeout(this.$sendDeltaQueue,0))},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,e.length>20&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))},this.$workerBlob=function(e){var t="importScripts('"+o.qualifyURL(e)+"');";try{return new Blob([t],{type:"application/javascript"})}catch(i){var n=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder,r=new n;return r.append(t),r.getBlob("application/javascript")}}}).call(a.prototype);var l=function(e,t,i){this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.callbackId=1,this.callbacks={},this.messageBuffer=[];var n=null,o=!1,a=Object.create(r),l=this;this.$worker={},this.$worker.terminate=function(){},this.$worker.postMessage=function(e){l.messageBuffer.push(e),n&&(o?setTimeout(c):c())},this.setEmitSync=function(e){o=e};var c=function(){var e=l.messageBuffer.shift();e.command?n[e.command].apply(n,e.args):e.event&&a._signal(e.event,e.data)};a.postMessage=function(e){l.onMessage({data:e})},a.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},a.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},s.loadModule(["worker",t],function(e){for(n=new e[i](a);l.messageBuffer.length;)c()})};l.prototype=a.prototype,t.UIWorkerClient=l,t.WorkerClient=a}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(e,t){"use strict";var i=e("./range").Range,n=e("./lib/event_emitter").EventEmitter,o=e("./lib/oop"),r=function(e,t,i,n,o,r){var s=this;this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=o,this.othersClass=r,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=n,this.$onCursorChange=function(){setTimeout(function(){s.onCursorChange()})},this.$pos=i;var a=e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=a.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)};(function(){o.implement(this,n),this.setup=function(){var e=this,t=this.doc,n=this.session,o=this.$pos;this.selectionBefore=n.selection.toJSON(),n.selection.inMultiSelectMode&&n.selection.toSingleRange(),this.pos=t.createAnchor(o.row,o.column),this.markerId=n.addMarker(new i(o.row,o.column,o.row,o.column+this.length),this.mainClass,null,!1),this.pos.on("change",function(t){n.removeMarker(e.markerId),e.markerId=n.addMarker(new i(t.value.row,t.value.column,t.value.row,t.value.column+e.length),e.mainClass,null,!1)}),this.others=[],this.$others.forEach(function(i){var n=t.createAnchor(i.row,i.column);e.others.push(n)}),n.setUndoSelect(!1)},this.showOtherMarkers=function(){if(!this.othersActive){var e=this.session,t=this;this.othersActive=!0,this.others.forEach(function(n){n.markerId=e.addMarker(new i(n.row,n.column,n.row,n.column+t.length),t.othersClass,null,!1),n.on("change",function(o){e.removeMarker(n.markerId),n.markerId=e.addMarker(new i(o.value.row,o.value.column,o.value.row,o.value.column+t.length),t.othersClass,null,!1)})})}},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){var t=e.data,n=t.range;if(n.start.row===n.end.row&&n.start.row===this.pos.row&&!this.$updating){this.$updating=!0;var o="insertText"===t.action?n.end.column-n.start.column:n.start.column-n.end.column;if(n.start.column>=this.pos.column&&n.start.column<=this.pos.column+this.length+1){var r=n.start.column-this.pos.column;if(this.length+=o,!this.session.$fromUndo){if("insertText"===t.action)for(var s=this.others.length-1;s>=0;s--){var a=this.others[s],l={row:a.row,column:a.column+r};a.row===n.start.row&&n.start.column<a.column&&(l.column+=o),this.doc.insert(l,t.text)}else if("removeText"===t.action)for(var s=this.others.length-1;s>=0;s--){var a=this.others[s],l={row:a.row,column:a.column+r};a.row===n.start.row&&n.start.column<a.column&&(l.column+=o),this.doc.remove(new i(l.row,l.column,l.row,l.column-o))}n.start.column===this.pos.column&&"insertText"===t.action?setTimeout(function(){this.pos.setPosition(this.pos.row,this.pos.column-o);for(var e=0;e<this.others.length;e++){var t=this.others[e],i={row:t.row,column:t.column-o};t.row===n.start.row&&n.start.column<t.column&&(i.column+=o),t.setPosition(i.row,i.column)}}.bind(this),0):n.start.column===this.pos.column&&"removeText"===t.action&&setTimeout(function(){for(var e=0;e<this.others.length;e++){var t=this.others[e];t.row===n.start.row&&n.start.column<t.column&&t.setPosition(t.row,t.column-o)}}.bind(this),0)}this.pos._emit("change",{value:this.pos});for(var s=0;s<this.others.length;s++)this.others[s]._emit("change",{value:this.others[s]})}this.$updating=!1}},this.onCursorChange=function(e){if(!this.$updating&&this.session){var t=this.session.selection.getCursor();t.row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e))}},this.detach=function(){this.session.removeMarker(this.markerId),this.hideOtherMarkers(),this.doc.removeEventListener("change",this.$onUpdate),this.session.selection.removeEventListener("changeCursor",this.$onCursorChange),this.pos.detach();for(var e=0;e<this.others.length;e++)this.others[e].detach();this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1===this.$undoStackDepth)throw Error("Canceling placeholders only supported with undo manager attached to session.");for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,i=0;t>i;i++)e.undo(!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}).call(r.prototype),t.PlaceHolder=r}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t){function i(e,t){return e.row==t.row&&e.column==t.column}function n(e){var t=e.domEvent,n=t.altKey,s=t.shiftKey,a=t.ctrlKey,l=e.getAccelKey(),c=e.getButton();if(a&&r.isMac&&(c=t.button),e.editor.inMultiSelectMode&&2==c)return void e.editor.textInput.onContextMenu(e.domEvent);if(!a&&!n&&!l)return void(0===c&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode());if(0===c){var h,u=e.editor,d=u.selection,g=u.inMultiSelectMode,f=e.getDocumentPosition(),p=d.getCursor(),m=e.inSelection()||d.isEmpty()&&i(f,p),v=e.x,A=e.y,w=function(e){v=e.clientX,A=e.clientY},C=u.session,E=u.renderer.pixelToScreenCoordinates(v,A),F=E;if(u.$mouseHandler.$enableJumpToDef)a&&n||l&&n?h="add":n&&(h="block");else if(l&&!n){if(h="add",!g&&s)return}else n&&(h="block");if(h&&r.isMac&&t.ctrlKey&&u.$mouseHandler.cancelContextMenu(),"add"==h){if(!g&&m)return;if(!g){var y=d.toOrientedRange();u.addSelectionMarker(y)}var b=d.rangeList.rangeAtPoint(f);u.$blockScrolling++,u.inVirtualSelectionMode=!0,s&&(b=null,y=d.ranges[0],u.removeSelectionMarker(y)),u.once("mouseup",function(){var e=d.toOrientedRange();b&&e.isEmpty()&&i(b.cursor,e.cursor)?d.substractPoint(e.cursor):(s?d.substractPoint(y.cursor):y&&(u.removeSelectionMarker(y),d.addRange(y)),d.addRange(e)),u.$blockScrolling--,u.inVirtualSelectionMode=!1})}else if("block"==h){e.stop(),u.inVirtualSelectionMode=!0;var x,S=[],$=function(){var e=u.renderer.pixelToScreenCoordinates(v,A),t=C.screenToDocumentPosition(e.row,e.column);i(F,e)&&i(t,d.lead)||(F=e,u.selection.moveToPosition(t),u.renderer.scrollCursorIntoView(),u.removeSelectionMarkers(S),S=d.rectangularRangeBlock(F,E),u.$mouseHandler.$clickSelection&&1==S.length&&S[0].isEmpty()&&(S[0]=u.$mouseHandler.$clickSelection.clone()),S.forEach(u.addSelectionMarker,u),u.updateSelectionMarkers())};g&&!l?d.toSingleRange():!g&&l&&(x=d.toOrientedRange(),u.addSelectionMarker(x)),s?E=C.documentToScreenPosition(d.lead):d.moveToPosition(f),F={row:-1,column:-1};var B=function(){clearInterval(k),u.removeSelectionMarkers(S),S.length||(S=[d.toOrientedRange()]),u.$blockScrolling++,x&&(u.removeSelectionMarker(x),d.toSingleRange(x));for(var e=0;e<S.length;e++)d.addRange(S[e]);u.inVirtualSelectionMode=!1,u.$mouseHandler.$clickSelection=null,u.$blockScrolling--},D=$;o.capture(u.container,w,B);var k=setInterval(function(){D()},20);return e.preventDefault()}}}var o=e("../lib/event"),r=e("../lib/useragent");t.onMouseDown=n}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(e,t){t.defaultCommands=[{name:"addCursorAbove",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},readonly:!0},{name:"addCursorBelow",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},readonly:!0},{name:"addCursorAboveSkipCurrent",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},readonly:!0},{name:"addCursorBelowSkipCurrent",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},readonly:!0},{name:"selectMoreBefore",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},readonly:!0},{name:"selectMoreAfter",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},readonly:!0},{name:"selectNextBefore",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},readonly:!0},{name:"selectNextAfter",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},readonly:!0},{name:"splitIntoLines",exec:function(e){e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readonly:!0},{name:"alignCursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"}},{name:"findAll",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},readonly:!0}],t.multiSelectCommands=[{name:"singleSelection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},readonly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];var i=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new i(t.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(e,t){function i(e,t,i){return f.$options.wrap=!0,f.$options.needle=t,f.$options.backwards=-1==i,f.find(e)}function n(e,t){return e.row==t.row&&e.column==t.column}function o(e){e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=t.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",c),e.commands.addCommands(d.defaultCommands),r(e))}function r(e){function t(){n&&(e.renderer.setMouseCursor(""),n=!1)}var i=e.textInput.getElement(),n=!1;h.addListener(i,"keydown",function(i){18!=i.keyCode||i.ctrlKey||i.shiftKey||i.metaKey?n&&t():n||(e.renderer.setMouseCursor("crosshair"),n=!0)}),h.addListener(i,"keyup",t),h.addListener(i,"blur",t)}var s=e("./range_list").RangeList,a=e("./range").Range,l=e("./selection").Selection,c=e("./mouse/multi_select_handler").onMouseDown,h=e("./lib/event"),u=e("./lib/lang"),d=e("./commands/multi_select_commands");t.commands=d.defaultCommands.concat(d.multiSelectCommands);var g=e("./search").Search,f=new g,p=e("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(p.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var i=this.toOrientedRange();if(this.rangeList.add(i),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(i),this.$onAddRange(i)}e.cursor||(e.cursor=e.end);var n=this.rangeList.add(e);return this.$onAddRange(e),n.length&&this.$onRemoveRange(n),this.rangeCount>1&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){var t=this.rangeList.substractPoint(e);return t?(this.$onRemoveRange(t),t[0]):void 0},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length?this.$onRemoveRange(e):this.ranges[0]&&this.fromOrientedRange(this.ranges[0])},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){if(this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode){var t=this.rangeList.ranges.pop();e.push(t),this.rangeCount=0}for(var i=e.length;i--;){var n=this.ranges.indexOf(e[i]);this.ranges.splice(n,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),t=t||this.ranges[0],t&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new s,this.ranges=[],this.rangeCount=0);

},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],i=a.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{var i=this.getRange(),n=this.isBackwards(),o=i.start.row,r=i.end.row;if(o==r){if(n)var s=i.end,l=i.start;else var s=i.start,l=i.end;return this.addRange(a.fromPoints(l,l)),void this.addRange(a.fromPoints(s,s))}var c=[],h=this.getLineRange(o,!0);h.start.column=i.start.column,c.push(h);for(var u=o+1;r>u;u++)c.push(this.getLineRange(u,!0));h=this.getLineRange(r,!0),h.end.column=i.end.column,c.push(h),c.forEach(this.addRange,this)}},this.toggleBlockSelection=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],i=a.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{var n=this.session.documentToScreenPosition(this.selectionLead),o=this.session.documentToScreenPosition(this.selectionAnchor),r=this.rectangularRangeBlock(n,o);r.forEach(this.addRange,this)}},this.rectangularRangeBlock=function(e,t,i){var o=[],r=e.column<t.column;if(r)var s=e.column,l=t.column;else var s=t.column,l=e.column;var c=e.row<t.row;if(c)var h=e.row,u=t.row;else var h=t.row,u=e.row;0>s&&(s=0),0>h&&(h=0),h==u&&(i=!0);for(var d=h;u>=d;d++){var g=a.fromPoints(this.session.screenToDocumentPosition(d,s),this.session.screenToDocumentPosition(d,l));if(g.isEmpty()){if(f&&n(g.end,f))break;var f=g.end}g.cursor=r?g.start:g.end,o.push(g)}if(c&&o.reverse(),!i){for(var p=o.length-1;o[p].isEmpty()&&p>0;)p--;if(p>0)for(var m=0;o[m].isEmpty();)m++;for(var v=p;v>=m;v--)o[v].isEmpty()&&o.splice(v,1)}return o}}.call(l.prototype);var m=e("./editor").Editor;(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){if(e.marker){this.session.removeMarker(e.marker);var t=this.session.$selectionMarkers.indexOf(e);-1!=t&&this.session.$selectionMarkers.splice(t,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length}},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,i=e.length;i--;){var n=e[i];if(n.marker){this.session.removeMarker(n.marker);var o=t.indexOf(n);-1!=o&&t.splice(o,1)}}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(d.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(d.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t=e.command,i=e.editor;if(i.multiSelect){if(t.multiSelectAction)"forEach"==t.multiSelectAction?n=i.forEachSelection(t,e.args):"forEachLine"==t.multiSelectAction?n=i.forEachSelection(t,e.args,!0):"single"==t.multiSelectAction?(i.exitMultiSelectMode(),n=t.exec(i,e.args||{})):n=t.multiSelectAction(i,e.args||{});else{var n=t.exec(i,e.args||{});i.multiSelect.addRange(i.multiSelect.toOrientedRange()),i.multiSelect.mergeOverlappingRanges()}return n}},this.forEachSelection=function(e,t,i){if(!this.inVirtualSelectionMode){var n,o=i&&i.keepOrder,r=1==i||i&&i.$byLines,s=this.session,a=this.selection,c=a.rangeList,h=(o?a:c).ranges;if(!h.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var u=a._eventRegistry;a._eventRegistry={};var d=new l(s);this.inVirtualSelectionMode=!0;for(var g=h.length;g--;){if(r)for(;g>0&&h[g].start.row==h[g-1].end.row;)g--;d.fromOrientedRange(h[g]),d.index=g,this.selection=s.selection=d;var f=e.exec?e.exec(this,t||{}):e(this,t||{});n||void 0===f||(n=f),d.toOrientedRange(h[g])}d.detach(),this.selection=s.selection=a,this.inVirtualSelectionMode=!1,a._eventRegistry=u,a.mergeOverlappingRanges();var p=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),p&&p.from==p.to&&this.renderer.animateScrolling(p.from),n}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,i=[],n=0;n<t.length;n++)i.push(this.session.getTextRange(t[n]));var o=this.session.getDocument().getNewLineCharacter();e=i.join(o),e.length==(i.length-1)*o.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var i=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&t==this.multiSelect.anchor)return;var o=t==this.multiSelect.anchor?i.cursor==i.start?i.end:i.start:i.cursor;n(o,t)||this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange())}},this.onPaste=function(e){if(!this.$readOnly){var t={text:e};if(this._signal("paste",t),e=t.text,!this.inMultiSelectMode||this.inVirtualSelectionMode)return this.insert(e);var i=e.split(/\r\n|\r|\n/),n=this.selection.rangeList.ranges;if(i.length>n.length||i.length<2||!i[1])return this.commands.exec("insertstring",this,e);for(var o=n.length;o--;){var r=n[o];r.isEmpty()||this.session.remove(r),this.session.insert(r.start,i[o])}}},this.findAll=function(e,t,i){if(t=t||{},t.needle=e||t.needle,void 0==t.needle){var n=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();t.needle=this.session.getTextRange(n)}this.$search.set(t);var o=this.$search.findAll(this.session);if(!o.length)return 0;this.$blockScrolling+=1;var r=this.multiSelect;i||r.toSingleRange(o[0]);for(var s=o.length;s--;)r.addRange(o[s],!0);return n&&r.rangeList.rangeAtPoint(n.start)&&r.addRange(n,!0),this.$blockScrolling-=1,o.length},this.selectMoreLines=function(e,t){var i=this.selection.toOrientedRange(),n=i.cursor==i.end,o=this.session.documentToScreenPosition(i.cursor);this.selection.$desiredColumn&&(o.column=this.selection.$desiredColumn);var r=this.session.screenToDocumentPosition(o.row+e,o.column);if(i.isEmpty())var s=r;else var l=this.session.documentToScreenPosition(n?i.end:i.start),s=this.session.screenToDocumentPosition(l.row+e,l.column);if(n){var c=a.fromPoints(r,s);c.cursor=c.start}else{var c=a.fromPoints(s,r);c.cursor=c.end}if(c.desiredColumn=o.column,this.selection.inMultiSelectMode){if(t)var h=i.cursor}else this.selection.addRange(i);this.selection.addRange(c),h&&this.selection.substractPoint(h)},this.transposeSelections=function(e){for(var t=this.session,i=t.multiSelect,n=i.ranges,o=n.length;o--;){var r=n[o];if(r.isEmpty()){var s=t.getWordRange(r.start.row,r.start.column);r.start.row=s.start.row,r.start.column=s.start.column,r.end.row=s.end.row,r.end.column=s.end.column}}i.mergeOverlappingRanges();for(var a=[],o=n.length;o--;){var r=n[o];a.unshift(t.getTextRange(r))}0>e?a.unshift(a.pop()):a.push(a.shift());for(var o=n.length;o--;){var r=n[o],s=r.clone();t.replace(r,a[o]),r.start.row=s.start.row,r.start.column=s.start.column}},this.selectMore=function(e,t,n){var o=this.session,r=o.multiSelect,s=r.toOrientedRange();if(!s.isEmpty()||(s=o.getWordRange(s.start.row,s.start.column),s.cursor=-1==e?s.start:s.end,this.multiSelect.addRange(s),!n)){var a=o.getTextRange(s),l=i(o,a,e);l&&(l.cursor=-1==e?l.start:l.end,this.$blockScrolling+=1,this.session.unfold(l),this.multiSelect.addRange(l),this.$blockScrolling-=1,this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(s.cursor)}},this.alignCursors=function(){var e=this.session,t=e.multiSelect,i=t.ranges,n=-1,o=i.filter(function(e){return e.cursor.row==n?!0:void(n=e.cursor.row)});if(i.length&&o.length!=i.length-1){o.forEach(function(e){t.substractPoint(e.cursor)});var r=0,s=1/0,l=i.map(function(t){var i=t.cursor,n=e.getLine(i.row),o=n.substr(i.column).search(/\S/g);return-1==o&&(o=0),i.column>r&&(r=i.column),s>o&&(s=o),o});i.forEach(function(t,i){var n=t.cursor,o=r-n.column,c=l[i]-s;o>c?e.insert(n,u.stringRepeat(" ",o-c)):e.remove(new a(n.row,n.column,n.row,n.column-o+c)),t.start.column=t.end.column=r,t.start.row=t.end.row=n.row,t.cursor=t.end}),t.fromOrientedRange(i[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var c=this.selection.getRange(),h=c.start.row,d=c.end.row,g=h==d;if(g){var f,p=this.session.getLength();do f=this.session.getLine(d);while(/[=:]/.test(f)&&++d<p);do f=this.session.getLine(h);while(/[=:]/.test(f)&&--h>0);0>h&&(h=0),d>=p&&(d=p-1)}var m=this.session.doc.removeLines(h,d);m=this.$reAlignText(m,g),this.session.doc.insert({row:h,column:0},m.join("\n")+"\n"),g||(c.start.column=0,c.end.column=m[m.length-1].length),this.selection.setRange(c)}},this.$reAlignText=function(e,t){function i(e){return u.stringRepeat(" ",e)}function n(e){return e[2]?i(s)+e[2]+i(a-e[2].length+l)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}function o(e){return e[2]?i(s+a-e[2].length)+e[2]+i(l," ")+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}function r(e){return e[2]?i(s)+e[2]+i(l)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}var s,a,l,c=!0,h=!0;return e.map(function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?null==s?(s=t[1].length,a=t[2].length,l=t[3].length,t):(s+a+l!=t[1].length+t[2].length+t[3].length&&(h=!1),s!=t[1].length&&(c=!1),s>t[1].length&&(s=t[1].length),a<t[2].length&&(a=t[2].length),l>t[3].length&&(l=t[3].length),t):[e]}).map(t?n:c?h?o:n:r)}}).call(m.prototype),t.onSessionChange=function(e){var t=e.session;t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect;var i=e.oldSession;i&&(i.multiSelect.off("addRange",this.$onAddRange),i.multiSelect.off("removeRange",this.$onRemoveRange),i.multiSelect.off("multiSelect",this.$onMultiSelect),i.multiSelect.off("singleSelect",this.$onSingleSelect),i.multiSelect.lead.off("change",this.$checkMultiselectChange),i.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},t.MultiSelect=o,e("./config").defineOptions(m.prototype,"editor",{enableMultiselect:{set:function(e){o(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",c)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",c))},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(e,t){"use strict";var i=e("../../range").Range,n=t.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);return this.foldingStartMarker.test(n)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(n)?"end":""},this.getFoldWidgetRange=function(){return null},this.indentationBlock=function(e,t,n){var o=/\S/,r=e.getLine(t),s=r.search(o);if(-1!=s){for(var a=n||r.length,l=e.getLength(),c=t,h=t;++t<l;){var u=e.getLine(t).search(o);if(-1!=u){if(s>=u)break;h=t}}if(h>c){var d=e.getLine(h).length;return new i(c,a,h,d)}}},this.openingBracketBlock=function(e,t,n,o,r){var s={row:n,column:o+1},a=e.$findClosingBracket(t,s,r);if(a){var l=e.foldWidgets[a.row];return null==l&&(l=e.getFoldWidget(a.row)),"start"==l&&a.row>s.row&&(a.row--,a.column=e.getLine(a.row).length),i.fromPoints(s,a)}},this.closingBracketBlock=function(e,t,n,o){var r={row:n,column:o},s=e.$findOpeningBracket(t,r);return s?(s.column++,r.column--,i.fromPoints(s,r)):void 0}}).call(n.prototype)}),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],function(e,t){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {	background: #f0f0f0;	color: #333;	}	.ace-tm .ace_print-margin {	width: 1px;	background: #e8e8e8;	}	.ace-tm .ace_fold {	background-color: #6B72E6;	}	.ace-tm {	background-color: #FFFFFF;	color: black;	}	.ace-tm .ace_cursor {	color: black;	}	.ace-tm .ace_invisible {	color: rgb(191, 191, 191);	}	.ace-tm .ace_storage,	.ace-tm .ace_keyword {	color: blue;	}	.ace-tm .ace_constant {	color: rgb(197, 6, 11);	}	.ace-tm .ace_constant.ace_buildin {	color: rgb(88, 72, 246);	}	.ace-tm .ace_constant.ace_language {	color: rgb(88, 92, 246);	}	.ace-tm .ace_constant.ace_library {	color: rgb(6, 150, 14);	}	.ace-tm .ace_invalid {	background-color: rgba(255, 0, 0, 0.1);	color: red;	}	.ace-tm .ace_support.ace_function {	color: rgb(60, 76, 114);	}	.ace-tm .ace_support.ace_constant {	color: rgb(6, 150, 14);	}	.ace-tm .ace_support.ace_type,	.ace-tm .ace_support.ace_class {	color: rgb(109, 121, 222);	}	.ace-tm .ace_keyword.ace_operator {	color: rgb(104, 118, 135);	}	.ace-tm .ace_string {	color: rgb(3, 106, 7);	}	.ace-tm .ace_comment {	color: rgb(76, 136, 107);	}	.ace-tm .ace_comment.ace_doc {	color: rgb(0, 102, 255);	}	.ace-tm .ace_comment.ace_doc.ace_tag {	color: rgb(128, 159, 191);	}	.ace-tm .ace_constant.ace_numeric {	color: rgb(0, 0, 205);	}	.ace-tm .ace_variable {	color: rgb(49, 132, 149);	}	.ace-tm .ace_xml-pe {	color: rgb(104, 104, 91);	}	.ace-tm .ace_entity.ace_name.ace_function {	color: #0000A2;	}	.ace-tm .ace_heading {	color: rgb(12, 7, 255);	}	.ace-tm .ace_list {	color:rgb(185, 6, 144);	}	.ace-tm .ace_meta.ace_tag {	color:rgb(0, 22, 142);	}	.ace-tm .ace_string.ace_regex {	color: rgb(255, 0, 0)	}	.ace-tm .ace_marker-layer .ace_selection {	background: rgb(181, 213, 255);	}	.ace-tm.ace_multiselect .ace_selection.ace_start {	box-shadow: 0 0 3px 0px white;	border-radius: 2px;	}	.ace-tm .ace_marker-layer .ace_step {	background: rgb(252, 255, 0);	}	.ace-tm .ace_marker-layer .ace_stack {	background: rgb(164, 229, 101);	}	.ace-tm .ace_marker-layer .ace_bracket {	margin: -1px 0 0 -1px;	border: 1px solid rgb(192, 192, 192);	}	.ace-tm .ace_marker-layer .ace_active-line {	background: rgba(0, 0, 0, 0.07);	}	.ace-tm .ace_gutter-active-line {	background-color : #dcdcdc;	}	.ace-tm .ace_marker-layer .ace_selected-word {	background: rgb(250, 250, 255);	border: 1px solid rgb(200, 200, 250);	}	.ace-tm .ace_indent-guide {	background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;	}	';var i=e("../lib/dom");i.importCssString(t.cssText,t.cssClass)}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/range"],function(e,t){"use strict";function i(e){this.session=e,this.session.widgetManager=this,this.session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeEditor",this.$onChangeEditor)}{var n=(e("./lib/oop"),e("./lib/dom"));e("./range").Range}(function(){this.getRowLength=function(e){var t;return t=this.lineWidgets?this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0:0,this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var e=0;return this.lineWidgets.forEach(function(t){t&&t.rowCount&&(e+=t.rowCount)}),e},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),this.editor=e,e&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(){var e=this.editor;if(e){this.editor=null,e.widgetManager=null,e.renderer.off("beforeRender",this.measureWidgets),e.renderer.off("afterRender",this.renderWidgets);var t=this.session.lineWidgets;t&&t.forEach(function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))})}},this.updateOnChange=function(e){var t=this.session.lineWidgets;if(t){var i=e.data,n=i.range,o=n.start.row,r=n.end.row-o;if(0===r);else if("removeText"==i.action||"removeLines"==i.action){var s=t.splice(o+1,r);s.forEach(function(e){e&&this.removeLineWidget(e)},this),this.$updateRows()}else{var a=new Array(r);a.unshift(o,0),t.splice.apply(t,a),this.$updateRows()}}},this.$updateRows=function(){var e=this.session.lineWidgets;if(e){var t=!0;e.forEach(function(e,i){e&&(t=!1,e.row=i)}),t&&(this.session.lineWidgets=null)}},this.addLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength())),this.session.lineWidgets[e.row]=e;var t=this.editor.renderer;return e.html&&!e.el&&(e.el=n.createElement("div"),e.el.innerHTML=e.html),e.el&&(n.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,t.container.appendChild(e.el),e._inDocument=!0),e.coverGutter||(e.el.style.zIndex=3),e.pixelHeight||(e.pixelHeight=e.el.offsetHeight),null==e.rowCount&&(e.rowCount=e.pixelHeight/t.layerConfig.lineHeight),this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,t),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(t){}this.session.lineWidgets&&(this.session.lineWidgets[e.row]=void 0),this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var i=this.session._changedWidgets,n=t.layerConfig;if(i&&i.length){for(var o=1/0,r=0;r<i.length;r++){var s=i[r];s._inDocument||(s._inDocument=!0,t.container.appendChild(s.el)),s.h=s.el.offsetHeight,s.fixedWidth||(s.w=s.el.offsetWidth,s.screenWidth=Math.ceil(s.w/n.characterWidth));var a=s.h/n.lineHeight;s.coverLine&&(a-=this.session.getRowLineCount(s.row),0>a&&(a=0)),s.rowCount!=a&&(s.rowCount=a,s.row<o&&(o=s.row))}o!=1/0&&(this.session._emit("changeFold",{data:{start:{row:o}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var i=t.layerConfig,n=this.session.lineWidgets;if(n){for(var o=Math.min(this.firstRow,i.firstRow),r=Math.max(this.lastRow,i.lastRow,n.length);o>0&&!n[o];)o--;this.firstRow=i.firstRow,this.lastRow=i.lastRow,t.$cursorLayer.config=i;for(var s=o;r>=s;s++){var a=n[s];if(a&&a.el){a._inDocument||(a._inDocument=!0,t.container.appendChild(a.el));var l=t.$cursorLayer.getPixelPosition({row:s,column:0},!0).top;a.coverLine||(l+=i.lineHeight*this.session.getRowLineCount(a.row)),a.el.style.top=l-i.offset+"px";var c=a.coverGutter?0:t.gutterWidth;a.fixedWidth||(c-=t.scrollLeft),a.el.style.left=c+"px",a.el.style.right=a.fixedWidth?t.scrollBar.getWidth()+"px":""}}}}}).call(i.prototype),t.LineWidgets=i}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],function(e,t){"use strict";function i(e,t,i){for(var n=0,o=e.length-1;o>=n;){var r=n+o>>1,s=i(t,e[r]);if(s>0)n=r+1;else{if(!(0>s))return r;o=r-1}}return-(n+1)}function n(e,t,n){var o=e.getAnnotations().sort(s.comparePoints);if(o.length){var r=i(o,{row:t,column:-1},s.comparePoints);0>r&&(r=-r-1),r>=o.length-1?r=n>0?0:o.length-1:0===r&&0>n&&(r=o.length-1);var a=o[r];if(a&&n){if(a.row===t){do a=o[r+=n];while(a&&a.row===t);if(!a)return o.slice()}var l=[];t=a.row;do l[0>n?"unshift":"push"](a),a=o[r+=n];while(a&&a.row==t);return l.length&&l}}}var o=e("../line_widgets").LineWidgets,r=e("../lib/dom"),s=e("../range").Range;t.showErrorMarker=function(e,t){var i=e.session;i.widgetManager||(i.widgetManager=new o(i),i.widgetManager.attach(e));var s=e.getCursorPosition(),a=s.row,l=i.lineWidgets&&i.lineWidgets[a];l?l.destroy():a-=t;var c,h=n(i,a,t);if(h){var u=h[0];s.column=(u.pos&&"number"!=typeof u.column?u.pos.sc:u.column)||0,s.row=u.row,c=e.renderer.$gutterLayer.$annotations[s.row]}else{if(l)return;c={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(s.row),e.selection.moveToPosition(s);var d={row:s.row,fixedWidth:!0,coverGutter:!0,el:r.createElement("div")},g=d.el.appendChild(r.createElement("div")),f=d.el.appendChild(r.createElement("div"));f.className="error_widget_arrow "+c.className;var p=e.renderer.$cursorLayer.getPixelPosition(s).left;f.style.left=p+e.renderer.gutterWidth-5+"px",d.el.className="error_widget_wrapper",g.className="error_widget "+c.className,g.innerHTML=c.text.join("<br>"),g.appendChild(r.createElement("div"));var m=function(e,t,i){return 0!==t||"esc"!==i&&"return"!==i?void 0:(d.destroy(),{command:"null"})};d.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(m),i.widgetManager.removeLineWidget(d),e.off("changeSelection",d.destroy),e.off("changeSession",d.destroy),e.off("mouseup",d.destroy),e.off("change",d.destroy))},e.keyBinding.addKeyboardHandler(m),e.on("changeSelection",d.destroy),e.on("changeSession",d.destroy),e.on("mouseup",d.destroy),e.on("change",d.destroy),e.session.widgetManager.addLineWidget(d),d.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:d.el.offsetHeight})},r.importCssString("	    .error_widget_wrapper {	        background: inherit;	        color: inherit;	        border:none	    }	    .error_widget {	        border-top: solid 2px;	        border-bottom: solid 2px;	        margin: 5px 0;	        padding: 10px 40px;	        white-space: pre-wrap;	    }	    .error_widget.ace_error, .error_widget_arrow.ace_error{	        border-color: #ff5a5a	    }	    .error_widget.ace_warning, .error_widget_arrow.ace_warning{	        border-color: #F1D817	    }	    .error_widget.ace_info, .error_widget_arrow.ace_info{	        border-color: #5a5a5a	    }	    .error_widget.ace_ok, .error_widget_arrow.ace_ok{	        border-color: #5aaa5a	    }	    .error_widget_arrow {	        position: absolute;	        border: solid 5px;	        border-top-color: transparent!important;	        border-right-color: transparent!important;	        border-left-color: transparent!important;	        top: -5px;	    }	","")}),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],function(e,t){"use strict";e("./lib/fixoldbrowsers");var i=e("./lib/dom"),n=e("./lib/event"),o=e("./editor").Editor,r=e("./edit_session").EditSession,s=e("./undomanager").UndoManager,a=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),t.config=e("./config"),t.acequire=e,t.edit=function(e){if("string"==typeof e){var r=e;if(e=document.getElementById(r),!e)throw new Error("ace.edit can't find div #"+r)}if(e&&e.env&&e.env.editor instanceof o)return e.env.editor;var s="";if(e&&/input|textarea/i.test(e.tagName)){var l=e;s=l.value,e=i.createElement("pre"),l.parentNode.replaceChild(e,l)}else s=i.getInnerText(e),e.innerHTML="";var c=t.createEditSession(s),h=new o(new a(e));h.setSession(c);var u={document:c,editor:h,onResize:h.resize.bind(h,null)};return l&&(u.textarea=l),n.addListener(window,"resize",u.onResize),h.on("destroy",function(){n.removeListener(window,"resize",u.onResize),u.editor.container.env=null}),h.container.env=h.env=u,h},t.createEditSession=function(e,t){var i=new r(e,t);return i.setUndoManager(new s),i},t.EditSession=r,t.UndoManager=s}),function(){ace.acequire(["ace/ace"],function(e){e&&e.config.init(!0),window.ace||(window.ace=e);for(var t in e)e.hasOwnProperty(t)&&(window.ace[t]=e[t])})}(),e.exports=window.ace.acequire("ace/ace")},function(e,t,i){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t){"use strict";var i=e("../lib/oop"),n=e("./text_highlight_rules").TextHighlightRules,o=function(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"invalid.illegal",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"invalid.illegal",regex:"\\/\\/.*$"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'[^"\\\\]+'},{token:"string",regex:'"',next:"start"},{token:"string",regex:"",next:"start"}]}};i.inherits(o,n),t.JsonHighlightRules=o}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t){"use strict";var i=e("../range").Range,n=function(){};(function(){this.checkOutdent=function(e,t){return/^\s+$/.test(e)?/^\s*\}/.test(t):!1},this.autoOutdent=function(e,t){var n=e.getLine(t),o=n.match(/^(\s*\})/);if(!o)return 0;var r=o[1].length,s=e.findMatchingBracket({row:t,column:r});if(!s||s.row==t)return 0;var a=this.$getIndent(e.getLine(s.row));e.replace(new i(t,0,t,r-1),a)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(n.prototype),t.MatchingBraceOutdent=n}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t){"use strict";var i,n=e("../../lib/oop"),o=e("../behaviour").Behaviour,r=e("../../token_iterator").TokenIterator,s=e("../../lib/lang"),a=["text","paren.rparen","punctuation.operator"],l=["text","paren.rparen","punctuation.operator","comment"],c={},h=function(e){var t=-1;return e.multiSelect&&(t=e.selection.index,c.rangeCount!=e.multiSelect.rangeCount&&(c={rangeCount:e.multiSelect.rangeCount})),c[t]?i=c[t]:void(i=c[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""})},u=function(){this.add("braces","insertion",function(e,t,n,o,r){var a=n.getCursorPosition(),l=o.doc.getLine(a.row);if("{"==r){h(n);var c=n.getSelectionRange(),d=o.doc.getTextRange(c);if(""!==d&&"{"!==d&&n.getWrapBehavioursEnabled())return{text:"{"+d+"}",selection:!1};if(u.isSaneInsertion(n,o))return/[\]\}\)]/.test(l[a.column])||n.inMultiSelectMode?(u.recordAutoInsert(n,o,"}"),{text:"{}",selection:[1,1]}):(u.recordMaybeInsert(n,o,"{"),{text:"{",selection:[1,1]})}else if("}"==r){h(n);var g=l.substring(a.column,a.column+1);if("}"==g){var f=o.$findOpeningBracket("}",{column:a.column+1,row:a.row});if(null!==f&&u.isAutoInsertedClosing(a,l,r))return u.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}else{if("\n"==r||"\r\n"==r){h(n);var p="";u.isMaybeInsertedClosing(a,l)&&(p=s.stringRepeat("}",i.maybeInsertedBrackets),u.clearMaybeInsertedClosing());var g=l.substring(a.column,a.column+1);if("}"===g){var m=o.findMatchingBracket({row:a.row,column:a.column+1},"}");if(!m)return null;var v=this.$getIndent(o.getLine(m.row))}else{if(!p)return void u.clearMaybeInsertedClosing();var v=this.$getIndent(l)}var A=v+o.getTabString();return{text:"\n"+A+"\n"+v+p,selection:[1,A.length,1,A.length]}}u.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,n,o,r){var s=o.doc.getTextRange(r);if(!r.isMultiLine()&&"{"==s){h(n);var a=o.doc.getLine(r.start.row),l=a.substring(r.end.column,r.end.column+1);if("}"==l)return r.end.column++,r;i.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,i,n,o){if("("==o){h(i);var r=i.getSelectionRange(),s=n.doc.getTextRange(r);if(""!==s&&i.getWrapBehavioursEnabled())return{text:"("+s+")",selection:!1};if(u.isSaneInsertion(i,n))return u.recordAutoInsert(i,n,")"),{text:"()",selection:[1,1]}}else if(")"==o){h(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row),c=l.substring(a.column,a.column+1);if(")"==c){var d=n.$findOpeningBracket(")",{column:a.column+1,row:a.row});if(null!==d&&u.isAutoInsertedClosing(a,l,o))return u.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}}),this.add("parens","deletion",function(e,t,i,n,o){var r=n.doc.getTextRange(o);if(!o.isMultiLine()&&"("==r){h(i);var s=n.doc.getLine(o.start.row),a=s.substring(o.start.column+1,o.start.column+2);if(")"==a)return o.end.column++,o}}),this.add("brackets","insertion",function(e,t,i,n,o){if("["==o){h(i);var r=i.getSelectionRange(),s=n.doc.getTextRange(r);if(""!==s&&i.getWrapBehavioursEnabled())return{text:"["+s+"]",selection:!1};if(u.isSaneInsertion(i,n))return u.recordAutoInsert(i,n,"]"),{text:"[]",selection:[1,1]}}else if("]"==o){h(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row),c=l.substring(a.column,a.column+1);if("]"==c){var d=n.$findOpeningBracket("]",{column:a.column+1,row:a.row});if(null!==d&&u.isAutoInsertedClosing(a,l,o))return u.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}}),this.add("brackets","deletion",function(e,t,i,n,o){var r=n.doc.getTextRange(o);if(!o.isMultiLine()&&"["==r){h(i);var s=n.doc.getLine(o.start.row),a=s.substring(o.start.column+1,o.start.column+2);if("]"==a)return o.end.column++,o}}),this.add("string_dquotes","insertion",function(e,t,i,n,o){if('"'==o||"'"==o){h(i);var r=o,s=i.getSelectionRange(),a=n.doc.getTextRange(s);if(""!==a&&"'"!==a&&'"'!=a&&i.getWrapBehavioursEnabled())return{text:r+a+r,selection:!1};var l=i.getCursorPosition(),c=n.doc.getLine(l.row),d=c.substring(l.column-1,l.column);if("\\"==d)return null;for(var g,f=n.getTokens(s.start.row),p=0,m=-1,v=0;v<f.length&&(g=f[v],"string"==g.type?m=-1:0>m&&(m=g.value.indexOf(r)),!(g.value.length+p>s.start.column));v++)p+=f[v].value.length;if(!g||0>m&&"comment"!==g.type&&("string"!==g.type||s.start.column!==g.value.length+p-1&&g.value.lastIndexOf(r)===g.value.length-1)){if(!u.isSaneInsertion(i,n))return;return{text:r+r,selection:[1,1]}}if(g&&"string"===g.type){var A=c.substring(l.column,l.column+1);if(A==r)return{text:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,i,n,o){var r=n.doc.getTextRange(o);if(!o.isMultiLine()&&('"'==r||"'"==r)){h(i);var s=n.doc.getLine(o.start.row),a=s.substring(o.start.column+1,o.start.column+2);if(a==r)return o.end.column++,o}})};u.isSaneInsertion=function(e,t){var i=e.getCursorPosition(),n=new r(t,i.row,i.column);if(!this.$matchTokenType(n.getCurrentToken()||"text",a)){var o=new r(t,i.row,i.column+1);if(!this.$matchTokenType(o.getCurrentToken()||"text",a))return!1}return n.stepForward(),n.getCurrentTokenRow()!==i.row||this.$matchTokenType(n.getCurrentToken()||"text",l);

},u.$matchTokenType=function(e,t){return t.indexOf(e.type||e)>-1},u.recordAutoInsert=function(e,t,n){var o=e.getCursorPosition(),r=t.doc.getLine(o.row);this.isAutoInsertedClosing(o,r,i.autoInsertedLineEnd[0])||(i.autoInsertedBrackets=0),i.autoInsertedRow=o.row,i.autoInsertedLineEnd=n+r.substr(o.column),i.autoInsertedBrackets++},u.recordMaybeInsert=function(e,t,n){var o=e.getCursorPosition(),r=t.doc.getLine(o.row);this.isMaybeInsertedClosing(o,r)||(i.maybeInsertedBrackets=0),i.maybeInsertedRow=o.row,i.maybeInsertedLineStart=r.substr(0,o.column)+n,i.maybeInsertedLineEnd=r.substr(o.column),i.maybeInsertedBrackets++},u.isAutoInsertedClosing=function(e,t,n){return i.autoInsertedBrackets>0&&e.row===i.autoInsertedRow&&n===i.autoInsertedLineEnd[0]&&t.substr(e.column)===i.autoInsertedLineEnd},u.isMaybeInsertedClosing=function(e,t){return i.maybeInsertedBrackets>0&&e.row===i.maybeInsertedRow&&t.substr(e.column)===i.maybeInsertedLineEnd&&t.substr(0,e.column)==i.maybeInsertedLineStart},u.popAutoInsertedClosing=function(){i.autoInsertedLineEnd=i.autoInsertedLineEnd.substr(1),i.autoInsertedBrackets--},u.clearMaybeInsertedClosing=function(){i&&(i.maybeInsertedBrackets=0,i.maybeInsertedRow=-1)},n.inherits(u,o),t.CstyleBehaviour=u}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t){"use strict";var i=e("../../lib/oop"),n=e("../../range").Range,o=e("./fold_mode").FoldMode,r=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};i.inherits(r,o),function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/,this.getFoldWidgetRange=function(e,t,i,n){var o=e.getLine(i),r=o.match(this.foldingStartMarker);if(r){var s=r.index;if(r[1])return this.openingBracketBlock(e,r[1],i,s);var a=e.getCommentFoldRange(i,s+r[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t){var r=o.match(this.foldingStopMarker);if(r){var s=r.index+r[0].length;return r[1]?this.closingBracketBlock(e,r[1],i,s):e.getCommentFoldRange(i,s,-1)}}},this.getSectionRange=function(e,t){var i=e.getLine(t),o=i.search(/\S/),r=t,s=i.length;t+=1;for(var a=t,l=e.getLength();++t<l;){i=e.getLine(t);var c=i.search(/\S/);if(-1!==c){if(o>c)break;var h=this.getFoldWidgetRange(e,"all",t);if(h){if(h.start.row<=r)break;if(h.isMultiLine())t=h.end.row;else if(o==c)break}a=t}}return new n(r,s,a,e.getLine(a).length)}}.call(r.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t){"use strict";var n=e("../lib/oop"),o=e("./text").Mode,r=e("./json_highlight_rules").JsonHighlightRules,s=e("./matching_brace_outdent").MatchingBraceOutdent,a=e("./behaviour/cstyle").CstyleBehaviour,l=e("./folding/cstyle").FoldMode,c=e("../worker/worker_client").WorkerClient,h=function(){this.HighlightRules=r,this.$outdent=new s,this.$behaviour=new a,this.foldingRules=new l};n.inherits(h,o),function(){this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);if("start"==e){var o=t.match(/^.*[\{\(\[]\s*$/);o&&(n+=i)}return n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(e){var t=new c(["ace"],i(17),"JsonWorker");return t.attachToDocument(e.getDocument()),t.on("error",function(t){e.setAnnotations([t.data])}),t.on("ok",function(){e.clearAnnotations()}),t},this.$id="ace/mode/json"}.call(h.prototype),t.Mode=h})},function(){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t){"use strict";var i=e("../lib/dom"),n=e("../lib/lang"),o=e("../lib/event"),r="	.ace_search {	background-color: #ddd;	border: 1px solid #cbcbcb;	border-top: 0 none;	max-width: 325px;	overflow: hidden;	margin: 0;	padding: 4px;	padding-right: 6px;	padding-bottom: 0;	position: absolute;	top: 0px;	z-index: 99;	white-space: normal;	}	.ace_search.left {	border-left: 0 none;	border-radius: 0px 0px 5px 0px;	left: 0;	}	.ace_search.right {	border-radius: 0px 0px 0px 5px;	border-right: 0 none;	right: 0;	}	.ace_search_form, .ace_replace_form {	border-radius: 3px;	border: 1px solid #cbcbcb;	float: left;	margin-bottom: 4px;	overflow: hidden;	}	.ace_search_form.ace_nomatch {	outline: 1px solid red;	}	.ace_search_field {	background-color: white;	border-right: 1px solid #cbcbcb;	border: 0 none;	-webkit-box-sizing: border-box;	-moz-box-sizing: border-box;	box-sizing: border-box;	float: left;	height: 22px;	outline: 0;	padding: 0 7px;	width: 214px;	margin: 0;	}	.ace_searchbtn,	.ace_replacebtn {	background: #fff;	border: 0 none;	border-left: 1px solid #dcdcdc;	cursor: pointer;	float: left;	height: 22px;	margin: 0;	padding: 0;	position: relative;	}	.ace_searchbtn:last-child,	.ace_replacebtn:last-child {	border-top-right-radius: 3px;	border-bottom-right-radius: 3px;	}	.ace_searchbtn:disabled {	background: none;	cursor: default;	}	.ace_searchbtn {	background-position: 50% 50%;	background-repeat: no-repeat;	width: 27px;	}	.ace_searchbtn.prev {	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAFCAYAAAB4ka1VAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADFJREFUeNpiSU1NZUAC/6E0I0yACYskCpsJiySKIiY0SUZk40FyTEgCjGgKwTRAgAEAQJUIPCE+qfkAAAAASUVORK5CYII=);    	}	.ace_searchbtn.next {	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAFCAYAAAB4ka1VAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADRJREFUeNpiTE1NZQCC/0DMyIAKwGJMUAYDEo3M/s+EpvM/mkKwCQxYjIeLMaELoLMBAgwAU7UJObTKsvAAAAAASUVORK5CYII=);    	}	.ace_searchbtn_close {	background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;	border-radius: 50%;	border: 0 none;	color: #656565;	cursor: pointer;	float: right;	font: 16px/16px Arial;	height: 14px;	margin: 5px 1px 9px 5px;	padding: 0;	text-align: center;	width: 14px;	}	.ace_searchbtn_close:hover {	background-color: #656565;	background-position: 50% 100%;	color: white;	}	.ace_replacebtn.prev {	width: 54px	}	.ace_replacebtn.next {	width: 27px	}	.ace_button {	margin-left: 2px;	cursor: pointer;	-webkit-user-select: none;	-moz-user-select: none;	-o-user-select: none;	-ms-user-select: none;	user-select: none;	overflow: hidden;	opacity: 0.7;	border: 1px solid rgba(100,100,100,0.23);	padding: 1px;	-moz-box-sizing: border-box;	box-sizing:    border-box;	color: black;	}	.ace_button:hover {	background-color: #eee;	opacity:1;	}	.ace_button:active {	background-color: #ddd;	}	.ace_button.checked {	border-color: #3399ff;	opacity:1;	}	.ace_search_options{	margin-bottom: 3px;	text-align: right;	-webkit-user-select: none;	-moz-user-select: none;	-o-user-select: none;	-ms-user-select: none;	user-select: none;	}",s=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys");i.importCssString(r,"ace_searchbox");var l='<div class="ace_search right">	    <button type="button" action="hide" class="ace_searchbtn_close"></button>	    <div class="ace_search_form">	        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>	        <button type="button" action="findNext" class="ace_searchbtn next"></button>	        <button type="button" action="findPrev" class="ace_searchbtn prev"></button>	        <button type="button" action="findAll" class="ace_searchbtn" title="Alt-Enter">All</button>	    </div>	    <div class="ace_replace_form">	        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>	        <button type="button" action="replaceAndFindNext" class="ace_replacebtn">Replace</button>	        <button type="button" action="replaceAll" class="ace_replacebtn">All</button>	    </div>	    <div class="ace_search_options">	        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>	        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>	        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>	    </div>	</div>'.replace(/>\s+/g,">"),c=function(e){var t=i.createElement("div");t.innerHTML=l,this.element=t.firstChild,this.$init(),this.setEditor(e)};(function(){this.setEditor=function(e){e.searchBox=this,e.container.appendChild(this.element),this.editor=e},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOptions=e.querySelector(".ace_search_options"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field")},this.$init=function(){var e=this.element;this.$initElements(e);var t=this;o.addListener(e,"mousedown",function(e){setTimeout(function(){t.activeInput.focus()},0),o.stopPropagation(e)}),o.addListener(e,"click",function(e){var i=e.target||e.srcElement,n=i.getAttribute("action");n&&t[n]?t[n]():t.$searchBarKb.commands[n]&&t.$searchBarKb.commands[n].exec(t),o.stopPropagation(e)}),o.addCommandKeyListener(e,function(e,i,n){var r=a.keyCodeToString(n),s=t.$searchBarKb.findKeyCommand(i,r);s&&s.exec&&(s.exec(t),o.stopEvent(e))}),this.$onChange=n.delayedCall(function(){t.find(!1,!1)}),o.addListener(this.searchInput,"input",function(){t.$onChange.schedule(20)}),o.addListener(this.searchInput,"focus",function(){t.activeInput=t.searchInput,t.searchInput.value&&t.highlight()}),o.addListener(this.replaceInput,"focus",function(){t.activeInput=t.replaceInput,t.searchInput.value&&t.highlight()})},this.$closeSearchBarKb=new s([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new s,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f|Ctrl-H|Command-Option-F":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e[t?"replaceInput":"searchInput"].focus()},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}}]),this.$syncOptions=function(){i.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),i.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),i.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked),this.find(!1,!1)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t){var n=this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked}),o=!n&&this.searchInput.value;i.setCssClass(this.searchBox,"ace_nomatch",o),this.editor._emit("findSearchBox",{match:!o}),this.highlight()},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked}),t=!e&&this.searchInput.value;i.setCssClass(this.searchBox,"ace_nomatch",t),this.editor._emit("findSearchBox",{match:!t}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.element.style.display="",this.replaceBox.style.display=t?"":"none",this.isReplace=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){var i=e.searchBox||new c(e);i.show(e.session.getTextRange(),t)}}),function(){ace.acequire(["ace/ext/searchbox"],function(){})}()},function(e){e.exports.id="ace/mode/json_worker",e.exports.src='"no use strict";(function(window){if(void 0===window.window||!window.document){window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console,window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;var chunks=id.split("/");if(!window.acequire.tlns)return console.log("unable to load "+id);chunks[0]=window.acequire.tlns[chunks[0]]||chunks[0];var path=chunks.join("/")+".js";return window.acequire.id=id,importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},window.initBaseUrls=function initBaseUrls(topLevelNamespaces){acequire.tlns=topLevelNamespaces},window.initSender=function initSender(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.command){if(!main[msg.command])throw Error("Unknown command:"+msg.command);main[msg.command].apply(main,msg.args)}else if(msg.init){initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}else msg.event&&sender&&sender._signal(msg.event,msg.data)}}})(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(e){var delta=e.data,range=delta.range;if(!(range.start.row==range.end.row&&range.start.row!=this.row||range.start.row>this.row||range.start.row==this.row&&range.start.column>this.column)){var row=this.row,column=this.column,start=range.start,end=range.end;"insertText"===delta.action?start.row===row&&column>=start.column?start.column===column&&this.$insertRight||(start.row===end.row?column+=end.column-start.column:(column-=start.column,row+=end.row-start.row)):start.row!==end.row&&row>start.row&&(row+=end.row-start.row):"insertLines"===delta.action?start.row===row&&0===column&&this.$insertRight||row>=start.row&&(row+=end.row-start.row):"removeText"===delta.action?start.row===row&&column>start.column?column=end.column>=column?start.column:Math.max(0,column-(end.column-start.column)):start.row!==end.row&&row>start.row?(end.row===row&&(column=Math.max(0,column-end.column)+start.column),row-=end.row-start.row):end.row===row&&(row-=end.row-start.row,column=Math.max(0,column-end.column)+start.column):"removeLines"==delta.action&&row>=start.row&&(row>=end.row?row-=end.row-start.row:(row=start.row,column=0)),this.setPosition(row,column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(text){this.$lines=[],0===text.length?this.$lines=[""]:Array.isArray(text)?this._insertLines(0,text):this.insert({row:0,column:0},text)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength();this.remove(new Range(0,0,len,this.getLine(len-1).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){if(range.start.row==range.end.row)return this.getLine(range.start.row).substring(range.start.column,range.end.column);var lines=this.getLines(range.start.row,range.end.row);lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;return range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column)),lines.join(this.getNewLineCharacter())},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):0>position.row&&(position.row=0),position},this.insert=function(position,text){if(!text||0===text.length)return position;position=this.$clipPosition(position),1>=this.getLength()&&this.$detectNewLine(text);var lines=this.$split(text),firstLine=lines.splice(0,1)[0],lastLine=0==lines.length?null:lines.splice(lines.length-1,1)[0];return position=this.insertInLine(position,firstLine),null!==lastLine&&(position=this.insertNewLine(position),position=this._insertLines(position.row,lines),position=this.insertInLine(position,lastLine||"")),position},this.insertLines=function(row,lines){return row>=this.getLength()?this.insert({row:row,column:0},"\\n"+lines.join("\\n")):this._insertLines(Math.max(row,0),lines)},this._insertLines=function(row,lines){if(0==lines.length)return{row:row,column:0};for(;lines.length>61440;){var end=this._insertLines(row,lines.slice(0,61440));lines=lines.slice(61440),row=end.row}var args=[row,0];args.push.apply(args,lines),this.$lines.splice.apply(this.$lines,args);var range=new Range(row,0,row+lines.length,0),delta={action:"insertLines",range:range,lines:lines};return this._signal("change",{data:delta}),range.end},this.insertNewLine=function(position){position=this.$clipPosition(position);var line=this.$lines[position.row]||"";this.$lines[position.row]=line.substring(0,position.column),this.$lines.splice(position.row+1,0,line.substring(position.column,line.length));var end={row:position.row+1,column:0},delta={action:"insertText",range:Range.fromPoints(position,end),text:this.getNewLineCharacter()};return this._signal("change",{data:delta}),end},this.insertInLine=function(position,text){if(0==text.length)return position;var line=this.$lines[position.row]||"";this.$lines[position.row]=line.substring(0,position.column)+text+line.substring(position.column);var end={row:position.row,column:position.column+text.length},delta={action:"insertText",range:Range.fromPoints(position,end),text:text};return this._signal("change",{data:delta}),end},this.remove=function(range){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),range.start=this.$clipPosition(range.start),range.end=this.$clipPosition(range.end),range.isEmpty())return range.start;var firstRow=range.start.row,lastRow=range.end.row;if(range.isMultiLine()){var firstFullRow=0==range.start.column?firstRow:firstRow+1,lastFullRow=lastRow-1;range.end.column>0&&this.removeInLine(lastRow,0,range.end.column),lastFullRow>=firstFullRow&&this._removeLines(firstFullRow,lastFullRow),firstFullRow!=firstRow&&(this.removeInLine(firstRow,range.start.column,this.getLine(firstRow).length),this.removeNewLine(range.start.row))}else this.removeInLine(firstRow,range.start.column,range.end.column);return range.start},this.removeInLine=function(row,startColumn,endColumn){if(startColumn!=endColumn){var range=new Range(row,startColumn,row,endColumn),line=this.getLine(row),removed=line.substring(startColumn,endColumn),newLine=line.substring(0,startColumn)+line.substring(endColumn,line.length);this.$lines.splice(row,1,newLine);var delta={action:"removeText",range:range,text:removed};return this._signal("change",{data:delta}),range.start}},this.removeLines=function(firstRow,lastRow){return 0>firstRow||lastRow>=this.getLength()?this.remove(new Range(firstRow,0,lastRow+1,0)):this._removeLines(firstRow,lastRow)},this._removeLines=function(firstRow,lastRow){var range=new Range(firstRow,0,lastRow+1,0),removed=this.$lines.splice(firstRow,lastRow-firstRow+1),delta={action:"removeLines",range:range,nl:this.getNewLineCharacter(),lines:removed};return this._signal("change",{data:delta}),removed},this.removeNewLine=function(row){var firstLine=this.getLine(row),secondLine=this.getLine(row+1),range=new Range(row,firstLine.length,row+1,0),line=firstLine+secondLine;this.$lines.splice(row,2,line);var delta={action:"removeText",range:range,text:this.getNewLineCharacter()};this._signal("change",{data:delta})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0==text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;if(this.remove(range),text)var end=this.insert(range.start,text);else end=range.start;return end},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++){var delta=deltas[i],range=Range.fromPoints(delta.range.start,delta.range.end);"insertLines"==delta.action?this.insertLines(range.start.row,delta.lines):"insertText"==delta.action?this.insert(range.start,delta.text):"removeLines"==delta.action?this._removeLines(range.start.row,range.end.row-1):"removeText"==delta.action&&this.remove(range)}},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--){var delta=deltas[i],range=Range.fromPoints(delta.range.start,delta.range.end);"insertLines"==delta.action?this._removeLines(range.start.row,range.end.row-1):"insertText"==delta.action?this.remove(range):"removeLines"==delta.action?this._insertLines(range.start.row,delta.lines):"removeText"==delta.action&&this.insert(range.start,delta.text)}},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function(obj){if("object"!=typeof obj||!obj)return obj;var cons=obj.constructor;if(cons===RegExp)return obj;var copy=cons();for(var key in obj)copy[key]="object"==typeof obj[key]?exports.deepCopy(obj[key]):obj[key];return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){return doc.applyDeltas(e.data),_self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"	"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue();try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);return this.sender.emit("error",{row:pos.row,column:pos.column,text:e.message,type:"error"}),void 0}this.sender.emit("ok")}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;\nfor(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="	\\n\\f\\r   ᠎             　\\u2028\\u2029";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});';

},function(e){e.exports=function(){throw new Error("define cannot be used indirect")}},function(e,t){(function(t){function i(){if(t.Blob)try{return new Blob(["asdf"],{type:"text/plain"}),Blob}catch(e){}var i=t.WebKitBlobBuilder||t.MozBlobBuilder||t.MSBlobBuilder;return function(e,t){var n=new i,o=t.endings,r=t.type;if(o)for(var s=0,a=e.length;a>s;++s)n.append(e[s],o);else for(var s=0,a=e.length;a>s;++s)n.append(e[s]);return r?n.getBlob(r):n.getBlob()}}e.exports=i()}).call(t,function(){return this}())}])});
//# sourceMappingURL=jsoneditor.map