/*! crypto-1.0.4.js (c) 2013 Kenji Urushima | kjur.github.com/jsrsasign/license
 */
if(typeof KJUR=="undefined"||!KJUR){KJUR={}}if(typeof KJUR.crypto=="undefined"||!KJUR.crypto){KJUR.crypto={}}KJUR.crypto.Util=new function(){this.DIGESTINFOHEAD={sha1:"3021300906052b0e03021a05000414",sha224:"302d300d06096086480165030402040500041c",sha256:"3031300d060960864801650304020105000420",sha384:"3041300d060960864801650304020205000430",sha512:"3051300d060960864801650304020305000440",md2:"3020300c06082a864886f70d020205000410",md5:"3020300c06082a864886f70d020505000410",ripemd160:"3021300906052b2403020105000414"};this.getDigestInfoHex=function(a,b){if(typeof this.DIGESTINFOHEAD[b]=="undefined"){throw"alg not supported in Util.DIGESTINFOHEAD: "+b}return this.DIGESTINFOHEAD[b]+a};this.getPaddedDigestInfoHex=function(h,a,j){var c=this.getDigestInfoHex(h,a);var d=j/4;if(c.length+22>d){throw"key is too short for SigAlg: keylen="+j+","+a}var b="0001";var k="00"+c;var g="";var l=d-b.length-k.length;for(var f=0;f<l;f+=2){g+="ff"}var e=b+g+k;return e};this.sha1=function(a){var b=new KJUR.crypto.MessageDigest({alg:"sha1",prov:"cryptojs"});return b.digestString(a)};this.sha256=function(a){var b=new KJUR.crypto.MessageDigest({alg:"sha256",prov:"cryptojs"});return b.digestString(a)};this.sha512=function(a){var b=new KJUR.crypto.MessageDigest({alg:"sha512",prov:"cryptojs"});return b.digestString(a)};this.md5=function(a){var b=new KJUR.crypto.MessageDigest({alg:"md5",prov:"cryptojs"});return b.digestString(a)};this.ripemd160=function(a){var b=new KJUR.crypto.MessageDigest({alg:"ripemd160",prov:"cryptojs"});return b.digestString(a)}};KJUR.crypto.MessageDigest=function(params){var md=null;var algName=null;var provName=null;var _CryptoJSMdName={md5:"CryptoJS.algo.MD5",sha1:"CryptoJS.algo.SHA1",sha224:"CryptoJS.algo.SHA224",sha256:"CryptoJS.algo.SHA256",sha384:"CryptoJS.algo.SHA384",sha512:"CryptoJS.algo.SHA512",ripemd160:"CryptoJS.algo.RIPEMD160"};this.setAlgAndProvider=function(alg,prov){if(":md5:sha1:sha224:sha256:sha384:sha512:ripemd160:".indexOf(alg)!=-1&&prov=="cryptojs"){try{this.md=eval(_CryptoJSMdName[alg]).create()}catch(ex){throw"setAlgAndProvider hash alg set fail alg="+alg+"/"+ex}this.updateString=function(str){this.md.update(str)};this.updateHex=function(hex){var wHex=CryptoJS.enc.Hex.parse(hex);this.md.update(wHex)};this.digest=function(){var hash=this.md.finalize();return hash.toString(CryptoJS.enc.Hex)};this.digestString=function(str){this.updateString(str);return this.digest()};this.digestHex=function(hex){this.updateHex(hex);return this.digest()}}if(":sha256:".indexOf(alg)!=-1&&prov=="sjcl"){try{this.md=new sjcl.hash.sha256()}catch(ex){throw"setAlgAndProvider hash alg set fail alg="+alg+"/"+ex}this.updateString=function(str){this.md.update(str)};this.updateHex=function(hex){var baHex=sjcl.codec.hex.toBits(hex);this.md.update(baHex)};this.digest=function(){var hash=this.md.finalize();return sjcl.codec.hex.fromBits(hash)};this.digestString=function(str){this.updateString(str);return this.digest()};this.digestHex=function(hex){this.updateHex(hex);return this.digest()}}};this.updateString=function(str){throw"updateString(str) not supported for this alg/prov: "+this.algName+"/"+this.provName};this.updateHex=function(hex){throw"updateHex(hex) not supported for this alg/prov: "+this.algName+"/"+this.provName};this.digest=function(){throw"digest() not supported for this alg/prov: "+this.algName+"/"+this.provName};this.digestString=function(str){throw"digestString(str) not supported for this alg/prov: "+this.algName+"/"+this.provName};this.digestHex=function(hex){throw"digestHex(hex) not supported for this alg/prov: "+this.algName+"/"+this.provName};if(typeof params!="undefined"){if(typeof params.alg!="undefined"){this.algName=params.alg;this.provName=params.prov;this.setAlgAndProvider(params.alg,params.prov)}}};KJUR.crypto.Signature=function(g){var j=null;var i=null;var l=null;var p=null;var c=null;var n=null;var b=null;var o=null;var e=null;var a=null;var f=null;var d=null;var m=null;var h=null;this._setAlgNames=function(){if(this.algName.match(/^(.+)with(.+)$/)){this.mdAlgName=RegExp.$1.toLowerCase();this.pubkeyAlgName=RegExp.$2.toLowerCase()}};this._zeroPaddingOfSignature=function(v,u){var t="";var q=u/4-v.length;for(var r=0;r<q;r++){t=t+"0"}return t+v};this.setAlgAndProvider=function(s,r){this._setAlgNames();if(r!="cryptojs/jsrsa"){throw"provider not supported: "+r}if(":md5:sha1:sha224:sha256:sha384:sha512:ripemd160:".indexOf(this.mdAlgName)!=-1){try{this.md=new KJUR.crypto.MessageDigest({alg:this.mdAlgName,prov:"cryptojs"})}catch(q){throw"setAlgAndProvider hash alg set fail alg="+this.mdAlgName+"/"+q}this.initSign=function(t){this.prvKey=t;this.state="SIGN"};this.initVerifyByPublicKey=function(t){this.pubKey=t;this.state="VERIFY"};this.initVerifyByCertificatePEM=function(t){var u=new X509();u.readCertPEM(t);this.pubKey=u.subjectPublicKeyRSA;this.state="VERIFY"};this.updateString=function(t){this.md.updateString(t)};this.updateHex=function(t){this.md.updateHex(t)};this.sign=function(){var t=KJUR.crypto.Util;var u=this.prvKey.n.bitLength();this.sHashHex=this.md.digest();this.hDigestInfo=t.getDigestInfoHex(this.sHashHex,this.mdAlgName);this.hPaddedDigestInfo=t.getPaddedDigestInfoHex(this.sHashHex,this.mdAlgName,u);var w=parseBigInt(this.hPaddedDigestInfo,16);this.hoge=w.toString(16);var v=this.prvKey.doPrivate(w);this.hSign=this._zeroPaddingOfSignature(v.toString(16),u);return this.hSign};this.signString=function(t){this.updateString(t);this.sign()};this.signHex=function(t){this.updateHex(t);this.sign()};this.verify=function(t){var u=KJUR.crypto.Util;var w=this.pubKey.n.bitLength();this.sHashHex=this.md.digest();var A=parseBigInt(t,16);var z=this.pubKey.doPublic(A);this.hPaddedDigestInfo=z.toString(16);var y=this.hPaddedDigestInfo;y=y.replace(/^1ff+00/,"");var v=KJUR.crypto.Util.DIGESTINFOHEAD[this.mdAlgName];if(y.indexOf(v)!=0){return false}var x=y.substr(v.length);return(x==this.sHashHex)}}};this.initVerifyByPublicKey=function(q){throw"initVerifyByPublicKey(rsaPubKeyy) not supported for this alg:prov="+this.algProvName};this.initVerifyByCertificatePEM=function(q){throw"initVerifyByCertificatePEM(certPEM) not supported for this alg:prov="+this.algProvName};this.initSign=function(q){throw"initSign(prvKey) not supported for this alg:prov="+this.algProvName};this.updateString=function(q){throw"updateString(str) not supported for this alg:prov="+this.algProvName};this.updateHex=function(q){throw"updateHex(hex) not supported for this alg:prov="+this.algProvName};this.sign=function(){throw"sign() not supported for this alg:prov="+this.algProvName};this.signString=function(q){throw"digestString(str) not supported for this alg:prov="+this.algProvName};this.signHex=function(q){throw"digestHex(hex) not supported for this alg:prov="+this.algProvName};this.verify=function(q){throw"verify(hSigVal) not supported for this alg:prov="+this.algProvName};if(typeof g!="undefined"){if(typeof g.alg!="undefined"){this.algName=g.alg;this.provName=g.prov;this.algProvName=g.alg+":"+g.prov;this.setAlgAndProvider(g.alg,g.prov);this._setAlgNames()}if(typeof g.prvkeypem!="undefined"){if(typeof g.prvkeypas!="undefined"){throw"both prvkeypem and prvkeypas parameters not supported"}else{try{var j=new RSAKey();j.readPrivateKeyFromPEMString(g.prvkeypem);this.initSign(j)}catch(k){throw"fatal error to load pem private key: "+k}}}}};