## Distributions


### jStat.beta( alpha, beta )

#### jStat.beta.pdf( x, alpha, beta )

Returns the value of x in the Beta distribution with parameters alpha and beta.

#### jStat.beta.cdf( x, alpha, beta )

Returns the value of x in the cdf for the Beta distribution with parameters alpha and beta.

#### jStat.beta.inv( p, alpha, beta )

Returns the value of p in the inverse of the cdf for the Beta distribution with parameters alpha and beta.

#### jStat.beta.mean( alpha, beta )

Returns the mean of the Beta distribution with parameters alpha and beta.

#### jStat.beta.median( alpha, beta )

Returns the median of the Beta distribution with parameters alpha and beta.

#### jStat.beta.mode( alpha, beta )

Returns the mode of the Beta distribution with parameters alpha and beta.

#### jStat.beta.sample( alpha, beta )

Returns a random number whose distribution is the Beta distribution with parameters alpha and beta.

#### jStat.beta.variance( alpha, beta )

Returns the variance of the Beta distribution with parameters alpha and beta.

### jStat.centralF( df1, df2 )

#### jStat.centralF.pdf( x, df1, df2 )

Returns the value of x in the pdf of the (Central) F distribution with numerator degrees of freedom df1 and denominator degrees of freedom df2.

#### jStat.centralF.cdf( x, df1, df2 )

Returns the value of x in the cdf of the (Central) F distribution with numerator degrees of freedom df1 and denominator degrees of freedom df2.

#### jStat.centralF.inv( x, df1, df2 )

Returns the value of x in the inverse of the cdf for the (Central) F distribution with numerator degrees of freedom df1 and denominator degrees of freedom df2.

#### jStat.centralF.mean( df1, df2 )

Returns the mean of the (Central) F distribution with numerator degrees of freedom df1 and denominator degrees of freedom df2.

#### jStat.centralF.mode( df1, df2 )

Returns the mode of the (Central) F distribution with numerator degrees of freedom df1 and denominator degrees of freedom df2.

#### jStat.centralF.sample( df1, df2 )

Returns a random number whose distribution is the (Central) F distribution with numerator degrees of freedom df1 and denominator degrees of freedom df2.

#### jStat.centralF.variance( df1, df2 )

Returns the variance of the (Central) F distribution with numerator degrees of freedom df1 and denominator degrees of freedom df2.

### jStat.cauchy( local, scale )

#### jStat.cauchy.pdf( x, local, scale )

Returns the value of x in the pdf of the Cauchy distribution with a location (median) of local and scale factor of scale.

#### jStat.cauchy.cdf( x, local, scale )

Returns the value of x in the cdf of the Cauchy distribution with a location (median) of local and scale factor of scale.

#### jStat.cauchy.inv( p, local, scale )

Returns the value of p in the inverse of the cdf for the Cauchy distribution with a location (median) of local and scale factor of scale.

#### jStat.cauchy.median( local, scale )

Returns the value of the median for the Cauchy distribution with a location (median) of local and scale factor of scale.

#### jStat.cauchy.mode( local, scale )

Returns the value of the mode for the Cauchy distribution with a location (median) of local and scale factor of scale.

#### jStat.cauchy.sample( local, scale )

Returns a random number whose distribution is the Cauchy distribution with a location (median) of local and scale factor of scale.

#### jStat.cauchy.variance( local, scale )

Returns the value of the variance for the Cauchy distribution with a location (median) of local and scale factor of scale.

### jStat.chisquare( dof )

#### jStat.chisquare.pdf( x, dof )

Returns the value of x in the pdf of the Chi Square distribution with degrees of freedom dof.

#### jStat.chisquare.cdf( x, dof )

Returns the value of x in the cdf of the Chi Square distribution with degrees of freedom dof.

#### jStat.chisquare.inv( p, dof )

Returns the value of x in the inverse of the cdf for the Chi Square distribution with degrees of freedom dof.

#### jStat.chisquare.mean( dof )

Returns the value of the mean for the Chi Square distribution with degrees of freedom dof.

#### jStat.chisquare.median( dof )

Returns the value of the median for the Chi Square distribution with degrees of freedom dof.

#### jStat.chisquare.mode( dof )

Returns the value of the mode for the Chi Square distribution with degrees of freedom dof.

#### jStat.chisquare.sample( dof )

Returns a random number whose distribution is the Chi Square distribution with degrees of freedom dof.

#### jStat.chisquare.variance( dof )

Returns the value of the variance for the Chi Square distribution with degrees of freedom dof.


### jStat.exponential( rate )

#### jStat.exponential.pdf( x, rate )

Returns the value of x in the pdf of the Exponential distribution with the parameter rate (lambda).

#### jStat.exponential.cdf( x, rate )

Returns the value of x in the cdf of the Exponential distribution with the parameter rate (lambda).

#### jStat.exponential.inv( p, rate )

Returns the value of x in the inverse of the cdf for the Exponential distribution with the parameter rate (lambda).

#### jStat.exponential.mean( rate )

Returns the value of the mean for the Exponential distribution with the parameter rate (lambda).

#### jStat.exponential.median( rate )

Returns the value of the median for the Exponential distribution with the parameter rate (lambda)

#### jStat.exponential.mode( rate )

Returns the value of the mode for the Exponential distribution with the parameter rate (lambda).

#### jStat.exponential.sample( rate )

Returns a random number whose distribution is the Exponential distribution with the parameter rate (lambda).

#### jStat.exponential.variance( rate )

Returns the value of the variance for the Exponential distribution with the parameter rate (lambda).

### jStat.gamma( shape, scale )

#### jStat.gamma.pdf( x, shape, scale )

Returns the value of x in the pdf of the Gamma distribution with the parameters shape (k) and scale (theta). Notice that if using the alpha beta convention, scale = 1/beta.

#### jStat.gamma.cdf( x, shape, scale )

Returns the value of x in the cdf of the Gamma distribution with the parameters shape (k) and scale (theta). Notice that if using the alpha beta convention, scale = 1/beta.

This function is checked against R's pgamma function.

#### jStat.gamma.inv( p, shape, scale )

Returns the value of p in the inverse of the cdf for the Gamma distribution with the parameters shape (k) and scale (theta). Notice that if using the alpha beta convention, scale = 1/beta.

This function is checked against R's qgamma function.

#### jStat.gamma.mean( shape, scale )

Returns the value of the mean for the Gamma distribution with the parameters shape (k) and scale (theta). Notice that if using the alpha beta convention, scale = 1/beta.

#### jStat.gamma.mode( shape, scale )

Returns the value of the mode for the Gamma distribution with the parameters shape (k) and scale (theta). Notice that if using the alpha beta convention, scale = 1/beta.

#### jStat.gamma.sample( shape, scale )

Returns a random number whose distribution is the Gamma distribution with the parameters shape (k) and scale (theta). Notice that if using the alpha beta convention, scale = 1/beta.

#### jStat.gamma.variance( shape, scale )

Returns the value of the variance for the Gamma distribution with the parameters shape (k) and scale (theta). Notice that if using the alpha beta convention, scale = 1/beta.

### jStat.invgamma( shape, scale )

#### jStat.invgamma.pdf( x, shape, scale )

Returns the value of x in the pdf of the Inverse-Gamma distribution with parametres shape (alpha) and scale (beta).

#### jStat.invgamma.cdf( x, shape, scale )

Returns the value of x in the cdf of the Inverse-Gamma distribution with parametres shape (alpha) and scale (beta).

#### jStat.invgamma.inv( p, shape, scale )

Returns the value of p in the inverse of the cdf for the Inverse-Gamma distribution with parametres shape (alpha) and scale (beta).

#### jStat.invgamma.mean( shape, scale )

Returns the value of the mean for the Inverse-Gamma distribution with parametres shape (alpha) and scale (beta).

#### jStat.invgamma.mode( shape, scale )

Returns the value of the mode for the Inverse-Gamma distribution with parametres shape (alpha) and scale (beta).

#### jStat.invgamma.sample( shape, scale )

Returns a random number whose distribution is the Inverse-Gamma distribution with parametres shape (alpha) and scale (beta).

#### jStat.invgamma.variance( shape, scale )

Returns the value of the variance for the Inverse-Gamma distribution with parametres shape (alpha) and scale (beta).

### jStat.kumaraswamy( alpha, beta )

#### jStat.kumaraswamy.pdf( x, a, b )

Returns the value of x in the pdf of the Kumaraswamy distribution with parameters a and b.

#### jStat.kumaraswamy.cdf( x, alpha, beta )

Returns the value of x in the cdf of the Kumaraswamy distribution with parameters a and b.

#### jStat.kumaraswamy.mean( alpha, beta )

Returns the value of the mean of the Kumaraswamy distribution with parameters a and b.

#### jStat.kumaraswamy.median( alpha, beta )

Returns the value of the median of the Kumaraswamy distribution with parameters a and b.

#### jStat.kumaraswamy.mode( alpha, beta )

Returns the value of the mode of the Kumaraswamy distribution with parameters a and b.

#### jStat.kumaraswamy.variance( alpha, beta )

Returns the value of the variance of the Kumaraswamy distribution with parameters a and b.

### jStat.lognormal( mu, sigma )

#### jStat.lognormal.pdf( x, mu, sigma )

Returns the value of x in the pdf of the Log-normal distribution with paramters mu (mean) and sigma (standard deviation).

#### jStat.lognormal.cdf( x, mu, sigma )

Returns the value of x in the cdf of the Log-normal distribution with paramters mu (mean) and sigma (standard deviation).

#### jStat.lognormal.inv( p, mu, sigma )

Returns the value of x in the inverse of the cdf for the Log-normal distribution with paramters mu (mean of the Normal distribution) and sigma (standard deviation of the Normal distribution).

#### jStat.lognormal.mean( mu, sigma )

Returns the value of the mean for the Log-normal distribution with paramters mu (mean of the Normal distribution) and sigma (standard deviation of the Normal distribution).

#### jStat.lognormal.median( mu, sigma )

Returns the value of the median for the Log-normal distribution with paramters mu (mean of the Normal distribution) and sigma (standard deviation of the Normal distribution).

#### jStat.lognormal.mode( mu, sigma )

Returns the value of the mode for the Log-normal distribution with paramters mu (mean of the Normal distribution) and sigma (standard deviation of the Normal distribution).

#### jStat.lognormal.sample( mu, sigma )

Returns a random number whose distribution is the Log-normal distribution with paramters mu (mean of the Normal distribution) and sigma (standard deviation of the Normal distribution).

#### jStat.lognormal.variance( mu, sigma )

Returns the value of the variance for the Log-normal distribution with paramters mu (mean of the Normal distribution) and sigma (standard deviation of the Normal distribution).

### jStat.normal( mean, std )

#### jStat.normal.pdf( x, mean, std )

Returns the value of x in the pdf of the Normal distribution with parameters mean and std (standard deviation).

#### jStat.normal.cdf( x, mean, std )

Returns the value of x in the cdf of the Normal distribution with parameters mean and std (standard deviation).

#### jStat.normal.inv( p, mean, std )

Returns the value of p in the inverse cdf for the Normal distribution with parameters mean and std (standard deviation).

#### jStat.normal.mean( mean, std )

Returns the value of the mean for the Normal distribution with parameters mean and std (standard deviation).

#### jStat.normal.median( mean, std )

Returns the value of the median for the Normal distribution with parameters mean and std (standard deviation).

#### jStat.normal.mode( mean, std )

Returns the value of the mode for the Normal distribution with parameters mean and std (standard deviation).

#### jStat.normal.sample( mean, std )

Returns a random number whose distribution is the Normal distribution with parameters mean and std (standard deviation).

#### jStat.normal.variance( mean, std )

Returns the value of the variance for the Normal distribution with parameters mean and std (standard deviation).

### jStat.pareto( scale, shape )

#### jStat.pareto.pdf( x, scale, shape )

Returns the value of x in the pdf of the Pareto distribution with parameters scale (x_m) and shape (alpha).

#### jStat.pareto.cdf( x, scale, shape )

Returns the value of x in the cdf of the Pareto distribution with parameters scale (x_m) and shape (alpha).

#### jStat.pareto.mean( scale, shape )

Returns the value of the mean of the Pareto distribution with parameters scale (x_m) and shape (alpha).

#### jStat.pareto.median( scale, shape )

Returns the value of the median of the Pareto distribution with parameters scale (x_m) and shape (alpha).


#### jStat.pareto.mode( scale, shape )

Returns the value of the mode of the Pareto distribution with parameters scale (x_m) and shape (alpha).

#### jStat.pareto.variance( scale, shape )

Returns the value of the variance of the Pareto distribution with parameters scale (x_m) and shape (alpha).

### jStat.studentt( dof )

#### jStat.studentt.pdf( x, dof )

Returns the value of x in the pdf of the Student's T distribution with degrees of freedom dof.

#### jStat.studentt.cdf( x, dof )

Returns the value of x in the cdf of the Student's T distribution with degrees of freedom dof.

#### jStat.studentt.inv( p, dof )

Returns the value of p in the inverse of the cdf for the Student's T distribution with degrees of freedom dof.

#### jStat.studentt.mean( dof )

Returns the value of the mean of the Student's T distribution with degrees of freedom dof.

#### jStat.studentt.median( dof )

Returns the value of the median of the Student's T distribution with degrees of freedom dof.

#### jStat.studentt.mode( dof )

Returns the value of the mode of the Student's T distribution with degrees of freedom dof.

#### jStat.studentt.sample( dof )

Returns a random number whose distribution is the Student's T distribution with degrees of freedom dof.

#### jStat.studentt.variance( dof )

Returns the value of the variance for the Student's T distribution with degrees of freedom dof.

### jStat.weibull( scale, shape )

#### jStat.weibull.pdf( x, scale, shape )

Returns the value x in the pdf for the Weibull distribution with parameters scale (lambda) and shape (k).

#### jStat.weibull.cdf( x, scale, shape )

Returns the value x in the cdf for the Weibull distribution with parameters scale (lambda) and shape (k).

#### jStat.weibull.inv( p, scale, shape )

Returns the value of x in the inverse of the cdf for the Weibull distribution with parameters scale (lambda) and shape (k).

#### jStat.weibull.mean( scale, shape )

Returns the value of the mean of the Weibull distribution with parameters scale (lambda) and shape (k).

#### jStat.weibull.median( scale, shape )

Returns the value of the median of the Weibull distribution with parameters scale (lambda) and shape (k).

#### jStat.weibull.mode( scale, shape )

Returns the mode of the Weibull distribution with parameters scale (lambda) and shape (k).

#### jStat.weibull.sample( scale, shape )

Returns a random number whose distribution is the Weibull distribution with parameters scale (lambda) and shape (k).

#### jStat.weibull.variance( scale, shape )

Returns the variance of the Weibull distribution with parameters scale (lambda) and shape (k).

### jStat.uniform( a, b )

#### jStat.uniform.pdf( x, a, b )

Returns the value of x in the pdf of the Uniform distribution from a to b.

#### jStat.uniform.cdf( x, a, b )

Returns the value of x in the cdf of the Uniform distribution from a to b.

#### jStat.uniform.inv(p, a, b)

Returns the inverse of the uniform.cdf function; i.e. the value of x for which uniform.cdf(x, a, b) == p.

#### jStat.uniform.mean( a, b )

Returns the value of the mean of the Uniform distribution from a to b.

#### jStat.uniform.median( a, b )

Returns the value of the median of the Uniform distribution from a to b.

#### jStat.uniform.mode( a, b )

Returns the value of the mode of the Uniform distribution from a to b.

#### jStat.uniform.sample( a, b )

Returns a random number whose distribution is the Uniform distribution from a to b.

#### jStat.uniform.variance( a, b )

Returns the variance of the Uniform distribution from a to b.

### jStat.binomial

#### jStat.binomial.pdf( k, n, p )

Returns the value of k in the pdf of the Binomial distribution with parameters n and p.

#### jStat.binomial.cdf( k, n, p )

Returns the value of k in the cdf of the Binomial distribution with parameters n and p.

### jStat.negbin

#### jStat.negbin.pdf( k, r, p )

Returns the value of k in the pdf of the Negative Binomial distribution with parameters n and p.

#### jStat.negbin.cdf( x, r, p )

Returns the value of x in the cdf of the Negative Binomial distribution with parameters n and p.

### jStat.hypgeom

#### jStat.hypgeom.pdf( k, N, m, n )

Returns the value of k in the pdf of the Hypergeometric distribution with parameters N (the population size), m (the success rate), and n (the number of draws).

#### jStat.hypgeom.cdf( x, N, m, n )

Returns the value of k in the pdf of the Hypergeometric distribution with parameters N (the population size), m (the success rate), and n (the number of draws).

### jStat.poisson

#### jStat.poisson.pdf( k, l )

Returns the value of k in the pdf of the Poisson distribution with parameter l (lambda).

#### jStat.poisson.cdf( x, l )

Returns the value of x in the cdf of the Poisson distribution with parameter l (lambda).

### jStat.triangular

#### jStat.triangular.pdf( x, a, b, c )

Returns the value of x in the pdf of the Triangular distribution with the parameters a, b, and c.

#### jStat.triangular.cdf( x, a, b, c )

Returns the value of x in the cdf of the Triangular distribution with the parameters a, b, and c.

#### jStat.triangular.mean( a, b, c )

Returns the value of the mean of the Triangular distribution with the parameters a, b, and c.

#### jStat.triangular.median( a, b, c )

Returns the value of the median of the Triangular distribution with the parameters a, b, and c.

#### jStat.triangular.mode( a, b, c )

Returns the value of the mode of the Triangular distribution with the parameters a, b, and c.

#### jStat.triangular.variance( a, b, c )

Returns the value of the variance of the Triangular distribution with the parameters a, b, and c.

